/* Ergo, version 3.8.2, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2023 Elias Rudberg, Emanuel H. Rubensson, Pawel Salek,
 * and Anastasia Kruchinina.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Ergo: An open-source program for linear-scaling electronic structure
 * calculations,
 * Elias Rudberg, Emanuel H. Rubensson, Pawel Salek, and Anastasia
 * Kruchinina,
 * SoftwareX 7, 107 (2018),
 * <http://dx.doi.org/10.1016/j.softx.2018.03.005>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */

/** @file tdhf_dynamics.h

    @brief Implementation of TDHF electron dynamics, explicitly
    propagating the electron density in time in the precence of a
    time-dependent electric field.

    @author: Elias Rudberg <em>responsible</em>
*/

#ifndef TDHF_DYNAMICS_HEADER
#define TDHF_DYNAMICS_HEADER

#include "basisinfo.h"
#include "matrix_typedefs.h"
#include "scf.h"
#include "electron_dynamics.h"

void do_tdhf_dynamics(const BasisInfoStruct & basisInfo,
		      const IntegralInfo & integralInfo,
		      const Molecule & molecule,
		      const Molecule & extraCharges,
		      const SCF::MatOptions& matOpts,
		      const JK::ExchWeights & CAM_params,
		      const JK::Params & J_K_params,
		      const symmMatrix & FockMatrix,
		      const symmMatrix & densityMatrix,
		      const symmMatrix & S_symm,
		      const triangMatrix & invCholFactor,
		      const ED::Params & params);


#endif
