/*
 * Decompiled with CFR 0.152.
 */
package burp;

import burp.IBurpExtender;
import burp.IBurpExtenderCallbacks;
import burp.IContextMenuFactory;
import burp.IContextMenuInvocation;
import burp.IExtensionHelpers;
import burp.IExtensionStateListener;
import burp.IHttpRequestResponse;
import burp.IScanIssue;
import burp.IScannerListener;
import burp.faraday.FaradayConnector;
import burp.faraday.FaradayExtensionUI;
import burp.faraday.VulnerabilityMapper;
import burp.faraday.Workspace;
import burp.faraday.exceptions.InvalidCredentialsException;
import burp.faraday.exceptions.InvalidFaradayServerException;
import burp.faraday.exceptions.SecondFactorRequiredException;
import burp.faraday.exceptions.ServerTooOldException;
import burp.faraday.models.ExtensionSettings;
import burp.faraday.models.vulnerability.Vulnerability;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JMenuItem;

public class BurpExtender
implements IBurpExtender,
IExtensionStateListener,
IScannerListener,
IContextMenuFactory {
    private static final String EXTENSION_VERSION = "2.0";
    private static final String EXTENSION_NAME = "Faraday for Burp v2.0";
    private IBurpExtenderCallbacks callbacks;
    private PrintWriter stdout;
    private IExtensionHelpers helpers;
    private FaradayConnector faradayConnector;
    private FaradayExtensionUI faradayExtensionUI;
    private ExtensionSettings extensionSettings;

    @Override
    public void registerExtenderCallbacks(IBurpExtenderCallbacks callbacks) {
        callbacks.setExtensionName(EXTENSION_NAME);
        this.callbacks = callbacks;
        this.helpers = callbacks.getHelpers();
        VulnerabilityMapper.setHelpers(this.helpers);
        this.stdout = new PrintWriter(callbacks.getStdout(), true);
        this.faradayConnector = new FaradayConnector(this.stdout);
        this.extensionSettings = new ExtensionSettings(callbacks);
        this.faradayExtensionUI = new FaradayExtensionUI(this.stdout, callbacks, this.faradayConnector, this.extensionSettings);
        if (!this.extensionSettings.getUsername().isEmpty() && !this.extensionSettings.getPassword().isEmpty()) {
            this.log("Settings found");
            this.log("Faraday Server URL: " + this.extensionSettings.getFaradayURL());
            this.log("Username: " + this.extensionSettings.getUsername());
            this.log("Import new Vulns: " + this.extensionSettings.importNewVulns());
            this.faradayConnector.setBaseUrl(this.extensionSettings.getFaradayURL());
            try {
                this.faradayConnector.validateFaradayURL();
            }
            catch (InvalidFaradayServerException e) {
                this.faradayExtensionUI.showErrorAlert("Faraday Server is down.");
                return;
            }
            catch (ServerTooOldException e) {
                this.faradayExtensionUI.showErrorAlert("Faraday server is too old to be used with this extension. Please upgrade to the latest version.");
                return;
            }
            try {
                this.faradayConnector.login(this.extensionSettings.getUsername(), this.extensionSettings.getPassword());
                this.faradayExtensionUI.notifyLoggedIn(false);
            }
            catch (SecondFactorRequiredException e) {
                this.faradayExtensionUI.showInfoAlert("The 2FA token for Faraday is required");
                this.faradayExtensionUI.notify2FATokenNeeded();
            }
            catch (InvalidCredentialsException e) {
                this.faradayExtensionUI.showErrorAlert("Invalid credentials.");
            }
            catch (InvalidFaradayServerException e) {
                this.faradayExtensionUI.showErrorAlert("Faraday Server is down.");
            }
        }
        callbacks.addSuiteTab(this.faradayExtensionUI);
        this.log("Faraday for Burp v2.0 Loaded");
        callbacks.registerScannerListener(this);
        callbacks.registerContextMenuFactory(this);
        callbacks.registerExtensionStateListener(this);
    }

    @Override
    public void extensionUnloaded() {
        this.log("Unloading extension");
        this.faradayConnector.logout();
    }

    @Override
    public List<JMenuItem> createMenuItems(IContextMenuInvocation invocation) {
        ArrayList<JMenuItem> menu = new ArrayList<JMenuItem>();
        byte ctx = invocation.getInvocationContext();
        switch (ctx) {
            case 7: {
                JMenuItem menuItem = new JMenuItem("Send issue to Faraday", null);
                menuItem.addActionListener(actionEvent -> this.onSendVulnsToFaraday(invocation.getSelectedIssues()));
                menu.add(menuItem);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                JMenuItem menuItem = new JMenuItem("Send request to Faraday", null);
                menuItem.addActionListener(actionEvent -> this.onSendRequestsToFaraday(invocation.getSelectedMessages()));
                menu.add(menuItem);
            }
        }
        return menu;
    }

    private void onSendVulnsToFaraday(IScanIssue[] issues) {
        if (issues == null) {
            return;
        }
        FaradayExtensionUI.runInThread(() -> {
            Vulnerability vulnerability;
            List vulnerabilities = Arrays.stream(issues).map(VulnerabilityMapper::fromIssue).collect(Collectors.toList());
            Workspace workspace = this.faradayConnector.getCurrentWorkspace();
            Iterator iterator = vulnerabilities.iterator();
            while (iterator.hasNext() && this.faradayExtensionUI.addVulnerability(vulnerability = (Vulnerability)iterator.next(), workspace)) {
            }
        });
    }

    private void onSendRequestsToFaraday(IHttpRequestResponse[] messages) {
        if (messages == null) {
            return;
        }
        FaradayExtensionUI.runInThread(() -> {
            Vulnerability vulnerability;
            List vulnerabilities = Arrays.stream(messages).map(VulnerabilityMapper::fromRequest).collect(Collectors.toList());
            Workspace workspace = this.faradayConnector.getCurrentWorkspace();
            Iterator iterator = vulnerabilities.iterator();
            while (iterator.hasNext() && this.faradayExtensionUI.addVulnerability(vulnerability = (Vulnerability)iterator.next(), workspace)) {
            }
        });
    }

    private void log(String msg) {
        this.stdout.println("[EXTENDER] " + msg);
    }

    @Override
    public void newScanIssue(IScanIssue issue) {
        if (!this.extensionSettings.importNewVulns()) {
            return;
        }
        FaradayExtensionUI.runInThread(() -> {
            Workspace workspace = this.faradayConnector.getCurrentWorkspace();
            Vulnerability vulnerability = VulnerabilityMapper.fromIssue(issue);
            this.faradayExtensionUI.addVulnerability(vulnerability, workspace);
        });
    }
}

