// unicodemap.h

#ifndef FUNICODEMAP_H
#define FUNICODEMAP_H

#if !defined (USE_FINAL_H) && !defined (COMPILE_FINAL_CUT)
  #error "Only <final/final.h> can be included directly."
#endif

#if defined(__linux__)
  #include <sys/kd.h>
#endif

#include <array>

namespace finalcut
{

namespace fc
{

constexpr std::array<struct unipair, 282> unicode_cp437_pairs =
{{
  //  .----------- unicode
  //  |      .---- fontpos
  //  |      |
  {0x0020, 0x20},
  {0x0021, 0x21},
  {0x0022, 0x22},
  {0x0023, 0x23},
  {0x0024, 0x24},
  {0x0025, 0x25},
  {0x0026, 0x26},
  {0x0027, 0x27},
  {0x0028, 0x28},
  {0x0029, 0x29},
  {0x002a, 0x2a},
  {0x002b, 0x2b},
  {0x002c, 0x2c},
  {0x002d, 0x2d},
  {0x002e, 0x2e},
  {0x002f, 0x2f},
  {0x0030, 0x30},
  {0x0031, 0x31},
  {0x0032, 0x32},
  {0x0033, 0x33},
  {0x0034, 0x34},
  {0x0035, 0x35},
  {0x0036, 0x36},
  {0x0037, 0x37},
  {0x0038, 0x38},
  {0x0039, 0x39},
  {0x003a, 0x3a},
  {0x003b, 0x3b},
  {0x003c, 0x3c},
  {0x003d, 0x3d},
  {0x003e, 0x3e},
  {0x003f, 0x3f},
  {0x0040, 0x40},
  {0x0041, 0x41},
  {0x0042, 0x42},
  {0x0043, 0x43},
  {0x0044, 0x44},
  {0x0045, 0x45},
  {0x0046, 0x46},
  {0x0047, 0x47},
  {0x0048, 0x48},
  {0x0049, 0x49},
  {0x004a, 0x4a},
  {0x004b, 0x4b},
  {0x004c, 0x4c},
  {0x004d, 0x4d},
  {0x004e, 0x4e},
  {0x004f, 0x4f},
  {0x0050, 0x50},
  {0x0051, 0x51},
  {0x0052, 0x52},
  {0x0053, 0x53},
  {0x0054, 0x54},
  {0x0055, 0x55},
  {0x0056, 0x56},
  {0x0057, 0x57},
  {0x0058, 0x58},
  {0x0059, 0x59},
  {0x005a, 0x5a},
  {0x005b, 0x5b},
  {0x005c, 0x5c},
  {0x005d, 0x5d},
  {0x005e, 0x5e},
  {0x005f, 0x5f},
  {0x0060, 0x60},
  {0x0061, 0x61},
  {0x0062, 0x62},
  {0x0063, 0x63},
  {0x0064, 0x64},
  {0x0065, 0x65},
  {0x0066, 0x66},
  {0x0067, 0x67},
  {0x0068, 0x68},
  {0x0069, 0x69},
  {0x006a, 0x6a},
  {0x006b, 0x6b},
  {0x006c, 0x6c},
  {0x006d, 0x6d},
  {0x006e, 0x6e},
  {0x006f, 0x6f},
  {0x0070, 0x70},
  {0x0071, 0x71},
  {0x0072, 0x72},
  {0x0073, 0x73},
  {0x0074, 0x74},
  {0x0075, 0x75},
  {0x0076, 0x76},
  {0x0077, 0x77},
  {0x0078, 0x78},
  {0x0079, 0x79},
  {0x007a, 0x7a},
  {0x007b, 0x7b},
  {0x007c, 0x7c},
  {0x007d, 0x7d},
  {0x007e, 0x7e},
  {0x00a0, 0xff},
  {0x00a1, 0xad},
  {0x00a2, 0x9b},
  {0x00a3, 0x9c},
  {0x00a5, 0x9d},
  {0x00a7, 0x15},
  {0x00aa, 0xa6},
  {0x00ab, 0xae},
  {0x00ac, 0xaa},
  {0x00b0, 0xf8},
  {0x00b1, 0xf1},
  {0x00b2, 0xfd},
  {0x00b5, 0xe6},
  {0x00b6, 0x14},
  {0x00b7, 0xfa},
  {0x00ba, 0xa7},
  {0x00bb, 0xaf},
  {0x00bc, 0xac},
  {0x00bd, 0xab},
  {0x00bf, 0xa8},
  {0x00c4, 0x8e},
  {0x00c5, 0x8f},
  {0x00c6, 0x92},
  {0x00c7, 0x80},
  {0x00c9, 0x90},
  {0x00d1, 0xa5},
  {0x00d6, 0x99},
  {0x00d7, 0x78},
  {0x00dc, 0x9a},
  {0x00df, 0xe1},
  {0x00e0, 0x85},
  {0x00e1, 0xa0},
  {0x00e2, 0x83},
  {0x00e4, 0x84},
  {0x00e5, 0x86},
  {0x00e6, 0x91},
  {0x00e7, 0x87},
  {0x00e8, 0x8a},
  {0x00e9, 0x82},
  {0x00ea, 0x88},
  {0x00eb, 0x89},
  {0x00ec, 0x8d},
  {0x00ed, 0xa1},
  {0x00ee, 0x8c},
  {0x00ef, 0x8b},
  {0x00f1, 0xa4},
  {0x00f2, 0x95},
  {0x00f3, 0xa2},
  {0x00f4, 0x93},
  {0x00f6, 0x94},
  {0x00f7, 0xf6},
  {0x00f9, 0x97},
  {0x00fa, 0xa3},
  {0x00fb, 0x96},
  {0x00fc, 0x81},
  {0x00ff, 0x98},
  {0x0192, 0x9f},
  {0x0393, 0xe2},
  {0x0398, 0xe9},
  {0x03a3, 0xe4},
  {0x03a6, 0xe8},
  {0x03a9, 0xea},
  {0x03b1, 0xe0},
  {0x03b2, 0xe1},
  {0x03b4, 0xeb},
  {0x03b5, 0xee},
  {0x03bc, 0xe6},
  {0x03c0, 0xe3},
  {0x03c3, 0xe5},
  {0x03c4, 0xe7},
  {0x03c6, 0xed},
  {0x2000, 0x20},
  {0x2001, 0x20},
  {0x2002, 0x20},
  {0x2003, 0x20},
  {0x2004, 0x20},
  {0x2005, 0x20},
  {0x2006, 0x20},
  {0x2007, 0x20},
  {0x2008, 0x20},
  {0x2009, 0x20},
  {0x200a, 0x20},
  {0x2022, 0x07},
  {0x202f, 0x20},
  {0x203c, 0x13},
  {0x207f, 0xfc},
  {0x20a7, 0x9e},
  {0x2126, 0xea},
  {0x212b, 0x8f},
  {0x2190, 0x1b},
  {0x2191, 0x18},
  {0x2192, 0x1a},
  {0x2193, 0x19},
  {0x2194, 0x1d},
  {0x2195, 0x12},
  {0x21a8, 0x17},
  {0x2205, 0xed},
  {0x2208, 0xee},
  {0x220e, 0xfe},
  {0x2219, 0xf9},
  {0x221a, 0xfb},
  {0x221e, 0xec},
  {0x221f, 0x1c},
  {0x2229, 0xef},
  {0x2248, 0xf7},
  {0x2261, 0xf0},
  {0x2264, 0xf3},
  {0x2265, 0xf2},
  {0x22c5, 0xf9},
  {0x2300, 0xed},
  {0x2302, 0x7f},
  {0x2310, 0xa9},
  {0x2319, 0x1c},
  {0x2320, 0xf4},
  {0x2321, 0xf5},
  {0x2500, 0xc4},
  {0x2502, 0xb3},
  {0x250c, 0xda},
  {0x2510, 0xbf},
  {0x2514, 0xc0},
  {0x2518, 0xd9},
  {0x251c, 0xc3},
  {0x2524, 0xb4},
  {0x252c, 0xc2},
  {0x2534, 0xc1},
  {0x253c, 0xc5},
  {0x2550, 0xcd},
  {0x2551, 0xba},
  {0x2552, 0xd5},
  {0x2553, 0xd6},
  {0x2554, 0xc9},
  {0x2555, 0xb8},
  {0x2556, 0xb7},
  {0x2557, 0xbb},
  {0x2558, 0xd4},
  {0x2559, 0xd3},
  {0x255a, 0xc8},
  {0x255b, 0xbe},
  {0x255c, 0xbd},
  {0x255d, 0xbc},
  {0x255e, 0xc6},
  {0x255f, 0xc7},
  {0x2560, 0xcc},
  {0x2561, 0xb5},
  {0x2562, 0xb6},
  {0x2563, 0xb9},
  {0x2564, 0xd1},
  {0x2565, 0xd2},
  {0x2566, 0xcb},
  {0x2567, 0xcf},
  {0x2568, 0xd0},
  {0x2569, 0xca},
  {0x256a, 0xd8},
  {0x256b, 0xd7},
  {0x256c, 0xce},
  {0x2580, 0xdf},
  {0x2584, 0xdc},
  {0x2588, 0xdb},
  {0x258c, 0xdd},
  {0x2590, 0xde},
  {0x2591, 0xb0},
  {0x2592, 0xb1},
  {0x2593, 0xb2},
  {0x25a0, 0xfe},
  {0x25ac, 0x16},
  {0x25b2, 0x1e},
  {0x25b6, 0x10},
  {0x25ba, 0x10},
  {0x25bc, 0x1f},
  {0x25c0, 0x11},
  {0x25c4, 0x11},
  {0x25cb, 0x09},
  {0x25cf, 0xf9},
  {0x25d8, 0x08},
  {0x25d9, 0x0a},
  {0x263a, 0x01},
  {0x263b, 0x02},
  {0x263c, 0x0f},
  {0x2640, 0x0c},
  {0x2642, 0x0b},
  {0x2660, 0x06},
  {0x2663, 0x05},
  {0x2665, 0x03},
  {0x2666, 0x04},
  {0x266a, 0x0d},
  {0x266b, 0x0e},
  {0x266c, 0x0e}
}};

constexpr std::array<struct unipair, 299> unicode_newfont_pairs =
{{
  //  .----------- unicode
  //  |      .---- fontpos
  //  |      |
  {0x0020, 0x20},
  {0x0021, 0x21},
  {0x0022, 0x22},
  {0x0023, 0x23},
  {0x0024, 0x24},
  {0x0025, 0x25},
  {0x0026, 0x26},
  {0x0027, 0x27},
  {0x0028, 0x28},
  {0x0029, 0x29},
  {0x002a, 0x2a},
  {0x002b, 0x2b},
  {0x002c, 0x2c},
  {0x002d, 0x2d},
  {0x002e, 0x2e},
  {0x002f, 0x2f},
  {0x0030, 0x30},
  {0x0031, 0x31},
  {0x0032, 0x32},
  {0x0033, 0x33},
  {0x0034, 0x34},
  {0x0035, 0x35},
  {0x0036, 0x36},
  {0x0037, 0x37},
  {0x0038, 0x38},
  {0x0039, 0x39},
  {0x003a, 0x3a},
  {0x003b, 0x3b},
  {0x003c, 0x3c},
  {0x003d, 0x3d},
  {0x003e, 0x3e},
  {0x003f, 0x3f},
  {0x0040, 0x40},
  {0x0041, 0x41},
  {0x0042, 0x42},
  {0x0043, 0x43},
  {0x0044, 0x44},
  {0x0045, 0x45},
  {0x0046, 0x46},
  {0x0047, 0x47},
  {0x0048, 0x48},
  {0x0049, 0x49},
  {0x004a, 0x4a},
  {0x004b, 0x4b},
  {0x004c, 0x4c},
  {0x004d, 0x4d},
  {0x004e, 0x4e},
  {0x004f, 0x4f},
  {0x0050, 0x50},
  {0x0051, 0x51},
  {0x0052, 0x52},
  {0x0053, 0x53},
  {0x0054, 0x54},
  {0x0055, 0x55},
  {0x0056, 0x56},
  {0x0057, 0x57},
  {0x0058, 0x58},
  {0x0059, 0x59},
  {0x005a, 0x5a},
  {0x005b, 0x5b},
  {0x005c, 0x5c},
  {0x005d, 0x5d},
  {0x005e, 0x5e},
  {0x005f, 0x5f},
  {0x0060, 0x60},
  {0x0061, 0x61},
  {0x0062, 0x62},
  {0x0063, 0x63},
  {0x0064, 0x64},
  {0x0065, 0x65},
  {0x0066, 0x66},
  {0x0067, 0x67},
  {0x0068, 0x68},
  {0x0069, 0x69},
  {0x006a, 0x6a},
  {0x006b, 0x6b},
  {0x006c, 0x6c},
  {0x006d, 0x6d},
  {0x006e, 0x6e},
  {0x006f, 0x6f},
  {0x0070, 0x70},
  {0x0071, 0x71},
  {0x0072, 0x72},
  {0x0073, 0x73},
  {0x0074, 0x74},
  {0x0075, 0x75},
  {0x0076, 0x76},
  {0x0077, 0x77},
  {0x0078, 0x78},
  {0x0079, 0x79},
  {0x007a, 0x7a},
  {0x007b, 0x7b},
  {0x007c, 0x7c},
  {0x007d, 0x7d},
  {0x007e, 0x7e},
  {0x00a0, 0xff},
  {0x00a1, 0xad},
  {0x00a2, 0x9b},
  {0x00a3, 0x9c},
  {0x00a5, 0x9d},
  {0x00a7, 0x15},
  {0x00aa, 0xa6},
  {0x00ab, 0xae},
  {0x00ac, 0xaa},
  {0x00b0, 0xf8},
  {0x00b1, 0xf1},
  {0x00b2, 0xfd},
  {0x00b5, 0xe6},
  {0x00b6, 0x14},
  {0x00b7, 0xfa},
  {0x00ba, 0xa7},
  {0x00bb, 0xaf},
  {0x00bc, 0xac},
  {0x00bd, 0xab},
  {0x00bf, 0xa8},
  {0x00c4, 0x8e},
  {0x00c5, 0x8f},
  {0x00c6, 0x92},
  {0x00c7, 0x80},
  {0x00c9, 0x90},
  {0x00d1, 0xa5},
  {0x00d6, 0x99},
  {0x00d7, 0x78},
  {0x00dc, 0x9a},
  {0x00df, 0xe1},
  {0x00e0, 0x85},
  {0x00e1, 0xa0},
  {0x00e2, 0x83},
  {0x00e4, 0x84},
  {0x00e5, 0x86},
  {0x00e6, 0x91},
  {0x00e7, 0x87},
  {0x00e8, 0x8a},
  {0x00e9, 0x82},
  {0x00ea, 0x88},
  {0x00eb, 0x89},
  {0x00ec, 0x8d},
  {0x00ed, 0xa1},
  {0x00ee, 0x8c},
  {0x00ef, 0x8b},
  {0x00f1, 0xa4},
  {0x00f2, 0x95},
  {0x00f3, 0xa2},
  {0x00f4, 0x93},
  {0x00f6, 0x94},
  {0x00f7, 0xf6},
  {0x00f9, 0x97},
  {0x00fa, 0xa3},
  {0x00fb, 0x96},
  {0x00fc, 0x81},
  {0x00ff, 0x98},
  {0x0192, 0x9f},
  {0x02e3, 0xfc},
  {0x0393, 0xe2},
  {0x03a3, 0xe4},
  {0x03a9, 0xea},
  {0x03b1, 0xe0},
  {0x03b2, 0xe1},
  {0x03b4, 0xeb},
  {0x03b5, 0xee},
  {0x03bc, 0xe6},
  {0x03c0, 0xe3},
  {0x03c3, 0xe5},
  {0x03c6, 0xed},
  {0x2000, 0x20},
  {0x2001, 0x20},
  {0x2002, 0x20},
  {0x2003, 0x20},
  {0x2004, 0x20},
  {0x2005, 0x20},
  {0x2006, 0x20},
  {0x2007, 0x20},
  {0x2008, 0x20},
  {0x2009, 0x20},
  {0x200a, 0x20},
  {0x2022, 0x07},
  {0x202f, 0x20},
  {0x203c, 0x13},
  {0x2050, 0xd5},
  {0x20a7, 0x9e},
  {0x2126, 0xea},
  {0x212b, 0x8f},
  {0x2190, 0x1b},
  {0x2191, 0x18},
  {0x2192, 0x1a},
  {0x2193, 0x19},
  {0x2194, 0x1d},
  {0x2195, 0x12},
  {0x21a8, 0x17},
  {0x2205, 0xed},
  {0x2208, 0xee},
  {0x220e, 0xfe},
  {0x2219, 0xf9},
  {0x221a, 0xfb},
  {0x221e, 0xec},
  {0x221f, 0x1c},
  {0x2229, 0xef},
  {0x2248, 0xf7},
  {0x2261, 0xf0},
  {0x2264, 0xf3},
  {0x2265, 0xf2},
  {0x22c5, 0xf9},
  {0x2300, 0xed},
  {0x2302, 0x7f},
  {0x2310, 0xa9},
  {0x2319, 0x1c},
  {0x2500, 0xc4},
  {0x2502, 0xb3},
  {0x2510, 0xbf},
  {0x2514, 0xc0},
  {0x2562, 0xb6},
  {0x2580, 0xdf},
  {0x2581, 0xd4},
  {0x2588, 0xdb},
  {0x258c, 0xdd},
  {0x258f, 0xbc},
  {0x2590, 0xde},
  {0x2591, 0xb0},
  {0x2592, 0xb1},
  {0x2593, 0xb2},
  {0x2594, 0xd8},
  {0x25a0, 0xfe},
  {0x25ac, 0x16},
  {0x25b2, 0x1e},
  {0x25b4, 0x1e},
  {0x25b6, 0x10},
  {0x25ba, 0x10},
  {0x25bc, 0x1f},
  {0x25be, 0x1f},
  {0x25c0, 0x11},
  {0x25c4, 0x11},
  {0x25cb, 0x09},
  {0x25cf, 0xf9},
  {0x25d8, 0x08},
  {0x25d9, 0x0a},
  {0x263a, 0x01},
  {0x263b, 0x02},
  {0x263c, 0x0f},
  {0x2640, 0x0c},
  {0x2642, 0x0b},
  {0x2660, 0x06},
  {0x2663, 0x05},
  {0x2665, 0x03},
  {0x2666, 0x04},
  {0x266a, 0x0d},
  {0x266b, 0x0e},
  {0x266c, 0x0e},
  {0x2713, 0xfb},
  {0xe1b3, 0xb3},
  {0xe1b4, 0xb4},
  {0xe1b5, 0xb5},
  {0xe1b6, 0xb6},
  {0xe1b7, 0xb7},
  {0xe1b8, 0xb8},
  {0xe1b9, 0xb9},
  {0xe1ba, 0xba},
  {0xe1bb, 0xbb},
  {0xe1bc, 0xbc},
  {0xe1bd, 0xbd},
  {0xe1be, 0xbe},
  {0xe1bf, 0xbf},
  {0xe1c0, 0xc0},
  {0xe1c1, 0xc1},
  {0xe1c2, 0xc2},
  {0xe1c3, 0xc3},
  {0xe1c4, 0xc4},
  {0xe1c5, 0xc5},
  {0xe1c6, 0xc6},
  {0xe1c7, 0xc7},
  {0xe1c8, 0xc8},
  {0xe1c9, 0xc9},
  {0xe1ca, 0xca},
  {0xe1cb, 0xcb},
  {0xe1cc, 0xcc},
  {0xe1cd, 0xcd},
  {0xe1ce, 0xce},
  {0xe1cf, 0xcf},
  {0xe1d0, 0xd0},
  {0xe1d1, 0xd1},
  {0xe1d2, 0xd2},
  {0xe1d3, 0xd3},
  {0xe1d4, 0xd4},
  {0xe1d5, 0xd5},
  {0xe1d6, 0xd6},
  {0xe1d7, 0xd7},
  {0xe1d8, 0xd8},
  {0xe1d9, 0xd9},
  {0xe1da, 0xda},
  {0xe1dc, 0xdc},
  {0xe1e7, 0xe7},
  {0xe1e8, 0xe8},
  {0xe1e9, 0xe9},
  {0xe1ea, 0xea},
  {0xe1eb, 0xeb},
  {0xe1f4, 0xf4},
  {0xe1f5, 0xf5},
  {0xe1f9, 0xf9},
  {0xe1fb, 0xfb},
  {0xe1fc, 0xfc}
}};

}  // namespace fc

}  // namespace finalcut

#endif  // FUNICODEMAP_H
