/*
 * fstrcmp - fuzzy string compare library
 * Copyright (C) 2009 Peter Miller
 * Written by Peter Miller <pmiller@opensource.org.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lib/ac/ctype.h>
#include <lib/ac/stdlib.h>
#include <lib/ac/string.h>

#include <lib/downcase.h>


char *
fstrcmp_downcase(const char *in)
{
    size_t          len;
    char            *result;
    char            *out;

    len = strlen(in) + 1;
    result = malloc(len);
    out = result;
    for (;;)
    {
        unsigned char   c;

        c = *in++;
        if (isupper(c))
            c = tolower(c);
        *out++ = c;
        if (!c)
            return result;
    }
}
