// Package hdinsight implements the Azure ARM Hdinsight service API version 2018-11-01-preview.
//
// The HDInsight Job Client.
package hdinsight

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// BaseClient is the base client for Hdinsight.
type BaseClient struct {
	autorest.Client
	Endpoint string
	UserName string
}

// New creates an instance of the BaseClient client.
func New(endpoint string, userName string) BaseClient {
	return NewWithoutDefaults(endpoint, userName)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(endpoint string, userName string) BaseClient {
	return BaseClient{
		Client:   autorest.NewClientWithUserAgent(UserAgent()),
		Endpoint: endpoint,
		UserName: userName,
	}
}
