/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.html;

import java.util.HashMap;

import org.dbdoclet.xiphias.dom.ElementImpl;
import org.dbdoclet.xiphias.dom.NodeImpl;

public class Optgroup extends StrictElement {

    private static final String tag = "optgroup";
    private static HashMap<String, HashMap<String, String>> validParentMap;
    private static HashMap<String, String> attributeMap;

    static {

        validParentMap = new HashMap<String, HashMap<String, String>>();
        validParentMap.put(Select.getTag(), HtmlElement.getAttributeMap());

        attributeMap = new HashMap<String, String>();
    }

    public static HashMap<String, String> getAttributeMap() {

        return attributeMap;
    }

    public static String getTag() {

        return tag;
    }

    public Optgroup() {

        setNodeName(tag);
        setFormatType(FORMAT_BLOCK);
        setAttribute("label", "Optgroup");
    }

    @Override
    public void closed() {

        boolean hasOptions = false;

        if (hasChildNodes() == true && getNumberOfChildNodes() > 0) {

            for (NodeImpl node : getTrafoChildNodes()) {

                if (node instanceof HtmlElement) {
                
                    ElementImpl elem = (ElementImpl) node;
                    if (elem instanceof Option) {
                        hasOptions = true;
                    }
                }
            }
        }

        if (hasOptions == false) {
            appendChild(new Option());
        }
    }

    @Override
    public void init() {

    }
}
