/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import org.dbdoclet.tag.docbook.BaseTagFactory;
import org.dbdoclet.tag.docbook.DocBookElement;
import org.dbdoclet.tag.docbook.Term;
import org.dbdoclet.tag.docbook.Varlistentry;
import org.dbdoclet.tag.docbook.Variablelist;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.xiphias.dom.ElementImpl;

public class DtEditor extends DocBookEditor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		DocBookElement entry = null;

		setValues(super.edit(values));
		BaseTagFactory dbfactory = getTagFactory();

		if (getParent() instanceof Variablelist) {

			entry = dbfactory.createVarlistentry();
			entry.setParentNode(getParent());
			getParent().appendChild(entry);

		} else if (getParent() instanceof Varlistentry) {

			setParent((DocBookElement) getParent().getParentNode());

			if ((getParent() != null) && getParent() instanceof Variablelist) {

				getCurrent().appendChild(
						dbfactory.createListitem().appendChild(
								dbfactory.createPara().setFormatType(
										ElementImpl.FORMAT_INLINE)));

				entry = dbfactory.createVarlistentry();
				entry.setParentNode(getParent());
				getParent().appendChild(entry);
				
			} else {

				return finalizeValues();
			}
			
		} else {

			return finalizeValues();
		}

		Term term = dbfactory.createTerm();
		copyCommonAttributes(getHtmlElement(), term);
		
		setCurrent(term);
		getCurrent().setParentNode(entry);

		entry.appendChild(getCurrent());

		setParent(entry);
		traverse(true);

		return finalizeValues();
	}
}
