// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Hubble

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.31.1
// source: recorder/recorder.proto

package recorder

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	Recorder_Record_FullMethodName = "/recorder.Recorder/Record"
)

// RecorderClient is the client API for Recorder service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Recorder implements the Hubble module for capturing network packets
type RecorderClient interface {
	// Record can start and stop a single recording. The recording is
	// automatically stopped if the client aborts this rpc call.
	Record(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[RecordRequest, RecordResponse], error)
}

type recorderClient struct {
	cc grpc.ClientConnInterface
}

func NewRecorderClient(cc grpc.ClientConnInterface) RecorderClient {
	return &recorderClient{cc}
}

func (c *recorderClient) Record(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[RecordRequest, RecordResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &Recorder_ServiceDesc.Streams[0], Recorder_Record_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[RecordRequest, RecordResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Recorder_RecordClient = grpc.BidiStreamingClient[RecordRequest, RecordResponse]

// RecorderServer is the server API for Recorder service.
// All implementations should embed UnimplementedRecorderServer
// for forward compatibility.
//
// Recorder implements the Hubble module for capturing network packets
type RecorderServer interface {
	// Record can start and stop a single recording. The recording is
	// automatically stopped if the client aborts this rpc call.
	Record(grpc.BidiStreamingServer[RecordRequest, RecordResponse]) error
}

// UnimplementedRecorderServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRecorderServer struct{}

func (UnimplementedRecorderServer) Record(grpc.BidiStreamingServer[RecordRequest, RecordResponse]) error {
	return status.Errorf(codes.Unimplemented, "method Record not implemented")
}
func (UnimplementedRecorderServer) testEmbeddedByValue() {}

// UnsafeRecorderServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RecorderServer will
// result in compilation errors.
type UnsafeRecorderServer interface {
	mustEmbedUnimplementedRecorderServer()
}

func RegisterRecorderServer(s grpc.ServiceRegistrar, srv RecorderServer) {
	// If the following call pancis, it indicates UnimplementedRecorderServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&Recorder_ServiceDesc, srv)
}

func _Recorder_Record_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RecorderServer).Record(&grpc.GenericServerStream[RecordRequest, RecordResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type Recorder_RecordServer = grpc.BidiStreamingServer[RecordRequest, RecordResponse]

// Recorder_ServiceDesc is the grpc.ServiceDesc for Recorder service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Recorder_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "recorder.Recorder",
	HandlerType: (*RecorderServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Record",
			Handler:       _Recorder_Record_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "recorder/recorder.proto",
}
