/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper.bytearray;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.ui.tamper.bytearray.AsciiArrayTableModel;
import com.aspect.snoop.ui.tamper.bytearray.ByteArrayTableModel;
import com.aspect.snoop.ui.tamper.bytearray.CenteredCellRenderer;
import com.aspect.snoop.ui.tamper.bytearray.HexTableCellEditor;
import com.aspect.snoop.ui.tamper.bytearray.TableSelectionHandler;
import com.aspect.snoop.ui.tamper.common.EditStringView;
import com.aspect.snoop.util.IOUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class EditByteArrayView
extends JDialog {
    private byte[] bytes;
    HexTableCellEditor editor;
    private JScrollPane asciiPane;
    private JButton btnAcceptChanges;
    private JButton btnChangeByteArraySize;
    private JButton btnEditAsString;
    private JButton btnReplaceWithDouble;
    private JButton btnReplaceWithFile;
    private JButton btnReplaceWithFloat;
    private JButton btnReplaceWithInt;
    private JButton btnReplaceWithLong;
    private JButton btnReplaceWithShort;
    private JButton btnReplaceWithString;
    private ButtonGroup btnViewGroup;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel lblByteCount;
    private JScrollPane originalPane;
    private JRadioButton rdoAscii;
    private JRadioButton rdoHex;
    private JTable tblAsciiBytes;
    private JTable tblOriginalBytes;
    static File lastFile = null;

    public byte[] getBytes() {
        return this.bytes;
    }

    public EditByteArrayView(Frame parent, boolean modal, byte[] bytes) {
        super(parent, modal);
        this.initComponents();
        this.bytes = bytes;
        this.lblByteCount.setText("" + bytes.length);
        this.tblOriginalBytes.setCellSelectionEnabled(true);
        this.tblOriginalBytes.setModel(new ByteArrayTableModel(this.tblAsciiBytes, bytes));
        this.tblOriginalBytes.setDefaultRenderer(Byte.class, new CenteredCellRenderer(this.tblAsciiBytes));
        this.tblOriginalBytes.setDragEnabled(false);
        TableSelectionHandler originalHandler = new TableSelectionHandler(this.tblOriginalBytes, this.tblAsciiBytes);
        this.tblOriginalBytes.getColumnModel().addColumnModelListener(originalHandler);
        this.tblOriginalBytes.getSelectionModel().addListSelectionListener(originalHandler);
        this.editor = new HexTableCellEditor();
        this.tblOriginalBytes.setDefaultEditor(Byte.class, this.editor);
        this.tblAsciiBytes.setDragEnabled(false);
        this.tblAsciiBytes.setCellSelectionEnabled(true);
        this.tblAsciiBytes.setModel(new AsciiArrayTableModel(this.tblOriginalBytes, bytes));
        this.tblAsciiBytes.setDefaultRenderer(Character.class, new CenteredCellRenderer(this.tblOriginalBytes));
        TableSelectionHandler asciiHandler = new TableSelectionHandler(this.tblAsciiBytes, this.tblOriginalBytes);
        this.tblAsciiBytes.getColumnModel().addColumnModelListener(asciiHandler);
        this.tblAsciiBytes.getSelectionModel().addListSelectionListener(asciiHandler);
        for (int i = 0; i < 16; ++i) {
            this.tblOriginalBytes.getColumnModel().getColumn(i).setResizable(false);
            this.tblAsciiBytes.getColumnModel().getColumn(i).setResizable(false);
        }
    }

    private void initComponents() {
        this.btnViewGroup = new ButtonGroup();
        this.originalPane = new JScrollPane();
        this.tblOriginalBytes = new JTable();
        this.jLabel1 = new JLabel();
        this.lblByteCount = new JLabel();
        this.btnReplaceWithString = new JButton();
        this.btnChangeByteArraySize = new JButton();
        this.jLabel3 = new JLabel();
        this.btnReplaceWithInt = new JButton();
        this.btnReplaceWithShort = new JButton();
        this.btnReplaceWithLong = new JButton();
        this.btnReplaceWithFloat = new JButton();
        this.btnReplaceWithDouble = new JButton();
        this.btnReplaceWithFile = new JButton();
        this.btnEditAsString = new JButton();
        this.asciiPane = new JScrollPane();
        this.tblAsciiBytes = new JTable();
        this.btnAcceptChanges = new JButton();
        this.rdoHex = new JRadioButton();
        this.rdoAscii = new JRadioButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(EditByteArrayView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.setResizable(false);
        this.originalPane.setName("originalPane");
        this.tblOriginalBytes.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblOriginalBytes.setName("tblOriginalBytes");
        this.originalPane.setViewportView(this.tblOriginalBytes);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.lblByteCount.setText(resourceMap.getString("lblByteCount.text", new Object[0]));
        this.lblByteCount.setName("lblByteCount");
        ApplicationActionMap actionMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getActionMap(EditByteArrayView.class, (Object)this);
        this.btnReplaceWithString.setAction(actionMap.get("replaceBytesAsString"));
        this.btnReplaceWithString.setText(resourceMap.getString("btnReplaceWithString.text", new Object[0]));
        this.btnReplaceWithString.setFocusable(false);
        this.btnReplaceWithString.setName("btnReplaceWithString");
        this.btnChangeByteArraySize.setAction(actionMap.get("changeArrayByteSize"));
        this.btnChangeByteArraySize.setText(resourceMap.getString("btnChangeByteArraySize.text", new Object[0]));
        this.btnChangeByteArraySize.setFocusable(false);
        this.btnChangeByteArraySize.setName("btnChangeByteArraySize");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.btnReplaceWithInt.setAction(actionMap.get("replaceBytesAsNumber"));
        this.btnReplaceWithInt.setText(resourceMap.getString("btnReplaceWithInt.text", new Object[0]));
        this.btnReplaceWithInt.setFocusable(false);
        this.btnReplaceWithInt.setName("btnReplaceWithInt");
        this.btnReplaceWithShort.setAction(actionMap.get("replaceBytesAsNumber"));
        this.btnReplaceWithShort.setText(resourceMap.getString("btnReplaceWithShort.text", new Object[0]));
        this.btnReplaceWithShort.setFocusable(false);
        this.btnReplaceWithShort.setName("btnReplaceWithShort");
        this.btnReplaceWithLong.setAction(actionMap.get("replaceBytesAsNumber"));
        this.btnReplaceWithLong.setText(resourceMap.getString("btnReplaceWithLong.text", new Object[0]));
        this.btnReplaceWithLong.setFocusable(false);
        this.btnReplaceWithLong.setName("btnReplaceWithLong");
        this.btnReplaceWithFloat.setAction(actionMap.get("replaceBytesAsNumber"));
        this.btnReplaceWithFloat.setText(resourceMap.getString("btnReplaceWithFloat.text", new Object[0]));
        this.btnReplaceWithFloat.setFocusable(false);
        this.btnReplaceWithFloat.setName("btnReplaceWithFloat");
        this.btnReplaceWithDouble.setAction(actionMap.get("replaceBytesAsNumber"));
        this.btnReplaceWithDouble.setText(resourceMap.getString("btnReplaceWithDouble.text", new Object[0]));
        this.btnReplaceWithDouble.setFocusable(false);
        this.btnReplaceWithDouble.setName("btnReplaceWithDouble");
        this.btnReplaceWithFile.setAction(actionMap.get("replaceBytesFromFile"));
        this.btnReplaceWithFile.setText(resourceMap.getString("btnReplaceWithFile.text", new Object[0]));
        this.btnReplaceWithFile.setFocusable(false);
        this.btnReplaceWithFile.setName("btnReplaceWithFile");
        this.btnEditAsString.setAction(actionMap.get("editBytesAsString"));
        this.btnEditAsString.setText(resourceMap.getString("btnEditAsString.text", new Object[0]));
        this.btnEditAsString.setFocusable(false);
        this.btnEditAsString.setName("btnEditAsString");
        this.asciiPane.setName("asciiPane");
        this.tblAsciiBytes.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblAsciiBytes.setName("tblAsciiBytes");
        this.asciiPane.setViewportView(this.tblAsciiBytes);
        this.btnAcceptChanges.setText(resourceMap.getString("btnAcceptChanges.text", new Object[0]));
        this.btnAcceptChanges.setName("btnAcceptChanges");
        this.btnAcceptChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditByteArrayView.this.btnAcceptChangesActionPerformed(evt);
            }
        });
        this.rdoHex.setAction(actionMap.get("changeView"));
        this.btnViewGroup.add(this.rdoHex);
        this.rdoHex.setSelected(true);
        this.rdoHex.setText(resourceMap.getString("rdoHex.text", new Object[0]));
        this.rdoHex.setName("rdoHex");
        this.rdoAscii.setAction(actionMap.get("changeView"));
        this.btnViewGroup.add(this.rdoAscii);
        this.rdoAscii.setText(resourceMap.getString("rdoAscii.text", new Object[0]));
        this.rdoAscii.setName("rdoAscii");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.btnEditAsString, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblByteCount, -2, 65, -2)).addComponent(this.btnChangeByteArraySize, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnReplaceWithString, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReplaceWithShort)).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -2, 136, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReplaceWithInt).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReplaceWithLong).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReplaceWithFloat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReplaceWithDouble).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReplaceWithFile)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rdoHex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rdoAscii)))).addGroup(layout.createSequentialGroup().addComponent(this.originalPane, -2, 428, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.asciiPane, -2, 430, -2))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(767, Short.MAX_VALUE).addComponent(this.btnAcceptChanges).addContainerGap()));
        layout.linkSize(0, this.asciiPane, this.originalPane);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lblByteCount)).addGap(35, 35, 35)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnReplaceWithString).addComponent(this.btnReplaceWithInt).addComponent(this.btnReplaceWithLong).addComponent(this.btnChangeByteArraySize).addComponent(this.btnReplaceWithShort).addComponent(this.btnReplaceWithFloat).addComponent(this.btnReplaceWithDouble).addComponent(this.btnReplaceWithFile)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnEditAsString).addComponent(this.rdoHex).addComponent(this.rdoAscii)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.asciiPane, 0, 0, Short.MAX_VALUE).addComponent(this.originalPane, -1, 210, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAcceptChanges).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void btnAcceptChangesActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditByteArrayView dialog = new EditByteArrayView((Frame)new JFrame(), true, "foobar".getBytes());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    @Action
    public void changeArrayByteSize() {
        String num = JOptionPane.showInputDialog("Enter new array size: ");
        if (num != null) {
            int oldSize = this.bytes.length;
            int newSize = Integer.parseInt(num);
            byte[] newArray = new byte[newSize];
            if (newSize >= oldSize) {
                int i;
                for (i = 0; i < oldSize; ++i) {
                    newArray[i] = this.bytes[i];
                }
                for (i = oldSize; i < newSize; ++i) {
                    newArray[i] = 0;
                }
            } else {
                for (int i = 0; i < newSize; ++i) {
                    newArray[i] = this.bytes[i];
                }
            }
            this.bytes = newArray;
            this.updateTable();
        }
    }

    @Action
    public void editBytesAsString() {
        EditStringView view = new EditStringView(this, true, "");
        view.setVisible(true);
        UIUtil.waitForInput(view);
        this.bytes = view.getText().getBytes();
        this.updateTable();
    }

    @Action
    public void replaceBytesAsString() {
        String s = new String(this.bytes);
        EditStringView view = new EditStringView(this, true, s);
        view.setVisible(true);
        UIUtil.waitForInput(view);
        this.bytes = view.getText().getBytes();
        this.updateTable();
    }

    @Action
    public void replaceBytesAsNumber(ActionEvent evt) {
        String num = JOptionPane.showInputDialog("Enter new value: ");
        if (num == null) {
            return;
        }
        if (evt.getActionCommand().equals("short")) {
            Short s = Short.parseShort(num);
            this.bytes = EditByteArrayView.shortToByteArray(s);
        } else if (evt.getActionCommand().equals("int")) {
            Integer s = Integer.parseInt(num);
            this.bytes = EditByteArrayView.intToByteArray(s);
        } else if (evt.getActionCommand().equals("long")) {
            Long s = Long.parseLong(num);
            this.bytes = EditByteArrayView.longToByteArray(s);
        } else if (evt.getActionCommand().equals("double")) {
            Double s = Double.parseDouble(num);
            this.bytes = EditByteArrayView.doubleToByteArray(s);
        } else if (evt.getActionCommand().equals("float")) {
            Float s = Float.valueOf(Float.parseFloat(num));
            this.bytes = EditByteArrayView.floatToByteArray(s.floatValue());
        }
        this.updateTable();
    }

    public static byte[] shortToByteArray(short value) {
        return new byte[]{(byte)(value >>> 8), (byte)value};
    }

    public static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
    }

    public static byte[] longToByteArray(long value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeLong(value);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public static byte[] floatToByteArray(float value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeFloat(value);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public static byte[] doubleToByteArray(double value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeDouble(value);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    @Action
    public void replaceBytesFromFile() {
        JFileChooser fc = lastFile != null ? new JFileChooser(lastFile.getParentFile()) : new JFileChooser();
        int rc = fc.showOpenDialog(this);
        if (rc == 0) {
            lastFile = fc.getSelectedFile();
            try {
                this.bytes = IOUtil.getBytesFromFile(lastFile);
                this.updateTable();
            }
            catch (IOException ex) {
                UIUtil.showErrorMessage(this, "Error reading file: " + ex.getMessage());
            }
        }
    }

    private void updateTable() {
        AsciiArrayTableModel modelA = (AsciiArrayTableModel)this.tblAsciiBytes.getModel();
        ByteArrayTableModel modelB = (ByteArrayTableModel)this.tblOriginalBytes.getModel();
        modelA.setBytes(this.bytes);
        modelB.setBytes(this.bytes);
        this.tblAsciiBytes.updateUI();
        this.tblOriginalBytes.updateUI();
        this.tblAsciiBytes.repaint();
        this.tblOriginalBytes.repaint();
    }

    @Action
    public void changeView(ActionEvent evt) {
        ByteArrayTableModel model = (ByteArrayTableModel)this.tblOriginalBytes.getModel();
        if (evt.getActionCommand().startsWith("Hex")) {
            model.showInHex(true);
            this.editor.shouldEditInHex(true);
        } else {
            model.showInHex(false);
            this.editor.shouldEditInHex(false);
        }
        this.tblOriginalBytes.repaint();
    }
}

