/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.HeaderUtil;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.subscriber.Seal;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConnectionUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String urlByUser;
    private String urlBase;
    private AbstractMethodInjection methodInjection;
    private String typeRequest = "GET";
    private final Random randomForUserAgent = new SecureRandom();
    private final InjectionModel injectionModel;
    private final CookieManager cookieManager = new CookieManager();

    public ConnectionUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public HttpClient.Builder getHttpClient() {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(this.getTimeout().intValue())).sslContext(this.injectionModel.getMediatorUtils().certificateUtil().getSslContext()).followRedirects(this.injectionModel.getMediatorUtils().preferencesUtil().isFollowingRedirection() ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
        if (this.injectionModel.getMediatorUtils().preferencesUtil().isHttp2Disabled()) {
            httpClientBuilder.version(HttpClient.Version.HTTP_1_1);
        }
        if (!this.injectionModel.getMediatorUtils().preferencesUtil().isNotProcessingCookies()) {
            httpClientBuilder.cookieHandler(this.cookieManager);
        }
        if (this.injectionModel.getMediatorUtils().authenticationUtil().isAuthentEnabled()) {
            httpClientBuilder.authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(ConnectionUtil.this.injectionModel.getMediatorUtils().authenticationUtil().getUsernameAuthentication(), ConnectionUtil.this.injectionModel.getMediatorUtils().authenticationUtil().getPasswordAuthentication().toCharArray());
                }
            });
        }
        return httpClientBuilder;
    }

    public static <T> Map<String, String> getHeadersMap(HttpResponse<T> httpResponse) {
        Map<String, String> sortedMap = ConnectionUtil.getHeadersMap(httpResponse.headers());
        String responseCodeHttp = String.valueOf(httpResponse.statusCode());
        sortedMap.put(":status", responseCodeHttp);
        return sortedMap;
    }

    public static Map<String, String> getHeadersMap(HttpHeaders httpHeaders) {
        Map<String, String> unsortedMap = httpHeaders.map().entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entrySet -> new AbstractMap.SimpleEntry<String, String>((String)entrySet.getKey(), String.join((CharSequence)", ", (Iterable)entrySet.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        return new TreeMap<String, String>(unsortedMap);
    }

    public HttpResponse<String> checkConnectionResponse() throws IOException, InterruptedException, JSqlException {
        String queryString = this.injectionModel.getMediatorUtils().parameterUtil().getQueryStringFromEntries();
        Object testUrl = this.getUrlBase().replaceAll("\\?$", "");
        if (StringUtils.isNotEmpty(queryString)) {
            testUrl = (String)testUrl + "?" + queryString;
        }
        String contentTypeRequest = "text/plain";
        String body = this.injectionModel.getMediatorUtils().parameterUtil().getRawRequest();
        if (this.injectionModel.getMediatorUtils().parameterUtil().isMultipartRequest()) {
            body = body.replaceAll("(?s)\\\\n", "\r\n");
        } else if (this.injectionModel.getMediatorUtils().parameterUtil().isRequestSoap()) {
            contentTypeRequest = "text/xml";
        } else if (!this.injectionModel.getMediatorUtils().parameterUtil().getListRequest().isEmpty()) {
            contentTypeRequest = "application/x-www-form-urlencoded";
        }
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder();
        try {
            httpRequest.uri(URI.create(((String)testUrl).replace("*", "")));
        }
        catch (IllegalArgumentException e) {
            throw new JSqlException(e);
        }
        httpRequest.setHeader("Content-Type", contentTypeRequest).timeout(Duration.ofSeconds(this.getTimeout().intValue()));
        this.injectionModel.getMediatorUtils().csrfUtil().addHeaderToken(httpRequest);
        this.injectionModel.getMediatorUtils().digestUtil().addHeaderToken(httpRequest);
        httpRequest.method(this.typeRequest, HttpRequest.BodyPublishers.ofString(body));
        for (AbstractMap.SimpleEntry<String, String> header : this.injectionModel.getMediatorUtils().parameterUtil().getListHeader()) {
            HeaderUtil.sanitizeHeaders(httpRequest, header);
        }
        return this.injectionModel.getMediatorUtils().headerUtil().checkResponseHeader(httpRequest, body);
    }

    public void testConnection() throws IOException, InterruptedException, JSqlException {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("LOG_CONNECTION_TEST"));
        this.getCookieManager().getCookieStore().removeAll();
        HttpResponse<String> httpResponse = this.checkConnectionResponse();
        if (!(httpResponse.statusCode() != 401 && httpResponse.statusCode() != 403 || this.injectionModel.getMediatorUtils().preferencesUtil().isNotProcessingCookies() || !this.injectionModel.getMediatorUtils().csrfUtil().isCsrf() && !this.injectionModel.getMediatorUtils().digestUtil().isDigest())) {
            if (this.injectionModel.getMediatorUtils().preferencesUtil().isProcessingCsrf()) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> "Testing CSRF handshake from previous connection...");
            } else if (StringUtils.isNotEmpty(this.injectionModel.getMediatorUtils().digestUtil().getTokenDigest())) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, () -> "Testing Digest handshake from previous connection...");
            }
            httpResponse = this.checkConnectionResponse();
        }
        if (httpResponse.statusCode() >= 400 && !this.injectionModel.getMediatorUtils().preferencesUtil().isNotTestingConnection()) {
            throw new InjectionFailureException(String.format("Connection failed: problem when calling %s", httpResponse.uri().toURL()));
        }
    }

    public String getSourceLineFeed(String url) {
        return this.getSource(url, true, false);
    }

    public String getSource(String url) {
        return this.getSource(url, false, false);
    }

    public String getSource(String url, boolean isConnectIssueIgnored) {
        return this.getSource(url, false, isConnectIssueIgnored);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSource(String url, boolean lineFeed, boolean isConnectIssueIgnored) {
        String pageSource = "";
        Map<String, String> requestHeaders = Map.of();
        Map<String, String> responseHeaders = Map.of();
        try (HttpClient httpClient = this.getHttpClient().build();){
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(this.getTimeout().intValue())).build();
            if (lineFeed) {
                HttpResponse<Stream<String>> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofLines());
                pageSource = response.body().collect(Collectors.joining("\n"));
                responseHeaders = ConnectionUtil.getHeadersMap(response.headers());
            } else {
                HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
                pageSource = response.body();
                responseHeaders = ConnectionUtil.getHeadersMap(response.headers());
            }
            requestHeaders = ConnectionUtil.getHeadersMap(httpRequest.headers());
        }
        catch (IOException e) {
            if (!isConnectIssueIgnored) {
                LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.injectionModel.sendToViews(new Seal.MessageHeader(url, null, requestHeaders, responseHeaders, pageSource, null, null, null, null));
        }
        return pageSource.trim();
    }

    public void setCustomUserAgent(HttpRequest.Builder httpRequest) {
        if (this.injectionModel.getMediatorUtils().preferencesUtil().isUserAgentRandom()) {
            String agents = this.injectionModel.getMediatorUtils().userAgentUtil().getCustomUserAgent();
            List<String> listAgents = Stream.of(agents.split("[\\r\\n]+")).filter(q -> !q.matches("^#.*")).toList();
            String randomElement = listAgents.get(this.randomForUserAgent.nextInt(listAgents.size()));
            httpRequest.setHeader("User-Agent", randomElement);
        }
    }

    public ConnectionUtil withMethodInjection(AbstractMethodInjection methodInjection) {
        this.methodInjection = methodInjection;
        return this;
    }

    public ConnectionUtil withTypeRequest(String typeRequest) {
        this.typeRequest = typeRequest;
        return this;
    }

    public String getUrlByUser() {
        return this.urlByUser;
    }

    public void setUrlByUser(String urlByUser) {
        this.urlByUser = urlByUser;
    }

    public String getUrlBase() {
        return this.urlBase;
    }

    public void setUrlBase(String urlBase) {
        this.urlBase = urlBase;
    }

    public AbstractMethodInjection getMethodInjection() {
        return this.methodInjection;
    }

    public String getTypeRequest() {
        return this.typeRequest;
    }

    public Integer getTimeout() {
        return this.injectionModel.getMediatorUtils().preferencesUtil().countConnectionTimeout();
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }
}

