/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.bruter.Coder;
import com.jsql.util.bruter.HashUtil;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExceptionUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;
    private final Set<String> exceptionsMd5Cached = new CopyOnWriteArraySet<String>();

    public ExceptionUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void setUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        try {
            SwingUtilities.invokeAndWait(() -> Thread.currentThread().setUncaughtExceptionHandler(new ExceptionHandler()));
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, () -> String.format("Unhandled Exception on %s", thread.getName()), throwable);
            LOGGER.log(Level.ERROR, () -> String.format("Unhandled Exception on %s", thread.getName()), throwable);
            String stackTrace = ExceptionUtils.getStackTrace(throwable);
            if (ExceptionUtil.this.injectionModel.getMediatorUtils().preferencesUtil().isReportingBugs() && stackTrace.contains("com.jsql") && !(throwable instanceof OutOfMemoryError) && !stackTrace.contains("OutOfMemoryError")) {
                if (stackTrace.contains("Could not initialize class java.awt.Toolkit")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, "System libraries are missing, use a proper Java runtime instead of headless runtime", throwable);
                    return;
                }
                if (stackTrace.contains("Could not initialize class sun.awt.X11.XToolkit")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, "System libraries are missing or wrong DISPLAY variable, verify your settings", throwable);
                    return;
                }
                if (stackTrace.contains("ClassFormatError: Unknown constant tag")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_JAVA, "Damaged class or JVM, verify your settings", throwable);
                    return;
                }
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance(Coder.MD5.label);
                    String stackTraceTrim = stackTrace.trim();
                    String passwordString = String.valueOf(stackTraceTrim.toCharArray());
                    byte[] passwordByte = passwordString.getBytes(StandardCharsets.UTF_8);
                    messageDigest.update(passwordByte, 0, passwordByte.length);
                    byte[] encodedPassword = messageDigest.digest();
                    String md5Exception = HashUtil.digestToHexString(encodedPassword);
                    if (!ExceptionUtil.this.exceptionsMd5Cached.contains(md5Exception)) {
                        ExceptionUtil.this.exceptionsMd5Cached.add(md5Exception);
                        ExceptionUtil.this.injectionModel.getMediatorUtils().gitUtil().sendUnhandledException(thread.getName(), throwable);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    LOGGER.log(LogLevelUtil.IGNORE, e);
                }
            }
        }
    }
}

