/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.injection.method.AbstractMethodInjection;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final InjectionModel injectionModel;

    public JsonUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public static Object getJson(String param) {
        Object jsonEntity;
        try {
            jsonEntity = new JSONObject(param);
        }
        catch (JSONException exceptionJSONObject) {
            try {
                jsonEntity = new JSONArray(param);
            }
            catch (JSONException exceptionJSONArray) {
                jsonEntity = new Object();
            }
        }
        return jsonEntity;
    }

    public static List<AbstractMap.SimpleEntry<String, String>> createEntries(Object jsonEntity, String parentName, AbstractMap.SimpleEntry<String, String> parentXPath) {
        ArrayList<AbstractMap.SimpleEntry<String, String>> attributesXPath = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        if (jsonEntity instanceof JSONObject) {
            JsonUtil.scanJsonObject(jsonEntity, parentName, parentXPath, attributesXPath);
        } else if (jsonEntity instanceof JSONArray) {
            JsonUtil.scanJsonArray(jsonEntity, parentName, parentXPath, attributesXPath);
        }
        return attributesXPath;
    }

    private static void scanJsonArray(Object jsonEntity, String parentName, AbstractMap.SimpleEntry<String, String> parentXPath, List<AbstractMap.SimpleEntry<String, String>> attributesXPath) {
        JSONArray jsonArrayEntity = (JSONArray)jsonEntity;
        for (int i = 0; i < jsonArrayEntity.length(); ++i) {
            Object value = jsonArrayEntity.get(i);
            String xpath = parentName + "[" + i + "]";
            if (value instanceof JSONArray || value instanceof JSONObject) {
                attributesXPath.addAll(JsonUtil.createEntries(value, xpath, parentXPath));
                continue;
            }
            if (!(value instanceof String)) continue;
            String string = (String)value;
            AbstractMap.SimpleEntry<CallSite, String> stringValue = new AbstractMap.SimpleEntry<CallSite, String>((CallSite)((Object)xpath), string);
            attributesXPath.add(stringValue);
            if (parentXPath == null) {
                jsonArrayEntity.put(i, value.toString().replaceAll(Pattern.quote("*") + "$", ""));
                continue;
            }
            if (!stringValue.equals(parentXPath)) continue;
            jsonArrayEntity.put(i, String.valueOf(value) + "*");
        }
    }

    private static void scanJsonObject(Object jsonEntity, String parentName, AbstractMap.SimpleEntry<String, String> parentXPath, List<AbstractMap.SimpleEntry<String, String>> attributesXPath) {
        JSONObject jsonObjectEntity = (JSONObject)jsonEntity;
        Iterator<String> keys = jsonObjectEntity.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            Object value = jsonObjectEntity.get(key);
            String xpath = parentName + "." + key;
            if (value instanceof JSONArray || value instanceof JSONObject) {
                attributesXPath.addAll(JsonUtil.createEntries(value, xpath, parentXPath));
                continue;
            }
            if (!(value instanceof String)) continue;
            String string = (String)value;
            AbstractMap.SimpleEntry<CallSite, String> stringValue = new AbstractMap.SimpleEntry<CallSite, String>((CallSite)((Object)xpath), string);
            attributesXPath.add(stringValue);
            if (parentXPath == null) {
                jsonObjectEntity.put(key, value.toString().replaceAll(Pattern.quote("*") + "$", ""));
                continue;
            }
            if (!stringValue.equals(parentXPath)) continue;
            jsonObjectEntity.put(key, String.valueOf(value) + "*");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testJsonParam(AbstractMethodInjection methodInjection, AbstractMap.SimpleEntry<String, String> paramStar) {
        boolean hasFoundInjection = false;
        paramStar.setValue(paramStar.getValue().replace("*", ""));
        Object jsonEntity = JsonUtil.getJson(paramStar.getValue());
        List<AbstractMap.SimpleEntry<String, String>> attributesJson = JsonUtil.createEntries(jsonEntity, "root", null);
        for (AbstractMap.SimpleEntry<String, String> parentXPath : attributesJson) {
            JsonUtil.createEntries(jsonEntity, "root", null);
            JsonUtil.createEntries(jsonEntity, "root", parentXPath);
            paramStar.setValue(jsonEntity.toString());
            try {
                Supplier[] supplierArray = new Supplier[4];
                supplierArray[0] = () -> I18nUtil.valueByKey("LOG_CHECKING");
                supplierArray[1] = methodInjection::name;
                supplierArray[2] = parentXPath::getKey;
                supplierArray[3] = () -> ((String)parentXPath.getValue()).replace("*", "");
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "{} {} JSON [key:{}, value:{}]", supplierArray);
                hasFoundInjection = this.injectionModel.getMediatorStrategy().testStrategies(paramStar);
                break;
            }
            catch (JSqlException e2) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, String.format("No injection found for JSON %s parameter %s=%s", methodInjection.name(), parentXPath.getKey(), parentXPath.getValue().replace("*", "")));
            }
            finally {
                methodInjection.getParams().forEach(e -> e.setValue(((String)e.getValue()).replaceAll(Pattern.quote("*") + "$", "")));
                if (hasFoundInjection) continue;
                paramStar.setValue(paramStar.getValue().replace("*", ""));
            }
        }
        return hasFoundInjection;
    }
}

