# Contributing [![GitHub contributors](https://img.shields.io/github/contributors/juice-shop/juice-shop.svg)](https://github.com/juice-shop/juice-shop/graphs/contributors) [![JavaScript Style Guide](https://img.shields.io/badge/code%20style-standard-brightgreen.svg)](http://standardjs.com/)

![CI/CD Pipeline](https://github.com/juice-shop/juice-shop/workflows/CI/CD%20Pipeline/badge.svg?branch=develop)
[![Test Coverage](https://api.codeclimate.com/v1/badges/6206c8f3972bcc97a033/test_coverage)](https://codeclimate.com/github/juice-shop/juice-shop/test_coverage)
[![Maintainability](https://api.codeclimate.com/v1/badges/6206c8f3972bcc97a033/maintainability)](https://codeclimate.com/github/juice-shop/juice-shop/maintainability)
[![Cypress tests](https://img.shields.io/endpoint?url=https://dashboard.cypress.io/badge/detailed/3hrkhu/develop&style=flat&logo=cypress)](https://dashboard.cypress.io/projects/3hrkhu/runs)
![Gitlab pipeline status](https://img.shields.io/gitlab/pipeline/bkimminich/juice-shop.svg)
[![Crowdin](https://d322cqt584bo4o.cloudfront.net/owasp-juice-shop/localized.svg)](https://crowdin.com/project/owasp-juice-shop)
![GitHub issues by-label "help wanted"](https://img.shields.io/github/issues/juice-shop/juice-shop/help%20wanted.svg?color=darkslateblue)
![GitHub issues by-label "good first issue"](https://img.shields.io/github/issues/juice-shop/juice-shop/good%20first%20issue.svg?color=darkgreen)

## Code Contributions

The minimum requirements for code contributions are:

1. The code _must_ be compliant with the configured ESLint rules based on the [JS Standard Code Style](http://standardjs.com).
2. All new and changed code _should_ have a corresponding unit and/or integration test.
3. New and changed challenges _must_ have a corresponding e2e test.
4. [Status checks](https://docs.github.com/en/github/collaborating-with-pull-requests/collaborating-on-repositories-with-code-quality-features/about-status-checks) _must_ pass for the last commit within your PR.
5. All Git commits within a PR _must_ be [signed off](https://git-scm.com/docs/git-commit#Documentation/git-commit.txt--s) to indicate the contributor's agreement with the [Developer Certificate of Origin](https://developercertificate.org/).

### Contribution Guidelines

You can find our detailed contribution guidelines over here:

<https://pwning.owasp-juice.shop/companion-guide/latest/part3/contribution.html>

## I18N Contributions

Learn all about our crowd-sourced [translation project on Crowdin](https://crowdin.com/project/owasp-juice-shop)
here: <https://pwning.owasp-juice.shop/companion-guide/latest/part3/translation.html>
