---
title: "GPS"
permalink: /docs/devel/webui_rest/gps/
toc: true
docgroup: "devel-rest"
excerpt: "Supported GPS devices, defined GPS devices, and current location information."
---
Kismet now supports multiple simultaneous GPS devices, and can select the 'best' quality device based on priority and GPS signal.

## List all available GPS drivers
Kismet supports multiple types of GPS device, and can be extended by plugins. 

* URL \\
        /gps/drivers.json

* Methods \\
        `GET`

* Return \\
        Array of all supported GPS drivers

## List all GPS devices

* URL \\
        /gps/all_gps.json

* Methods \\
        `GET`

* Return \\
        All configured GPS devices

## GPS location
The current "best" GPS location can be retrieved, with timestamp, for presentation in the UI or use in logging.

* URL \\
        /gps/location.json

* Methods \\
        `GET`

* Return \\
        Current GPS location and information

## Web GPS
Kismet supports a Web-based GPS, where the data is provided by the browser (or submitted over the HTTP channel from another GPS source).

* URL \\
        /gps/web/update.cmd

* Methods \\
        `POST`

* POST parameters \\
A [command dictionary](/docs/devel/webui_rest/commands/) containing:

| Key  | Description                                |
| ---- | ---------------------------------------    |
| lat  | GPS latitude                               |
| lon  | GPS longitude                              |
| alt  | Optional, GPS altitude in meters           |
| spd  | Optional, GPS speed in kilometers per hour |

* Returns \\
        `HTTP 200` on successful update of the webgps location
        HTTP error on failure

