/* Copyright 2022 - 2024 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_AARCH64_REGISTER_H
#define LIEF_ASM_AARCH64_REGISTER_H
namespace LIEF {
namespace assembly {
namespace aarch64 {
enum class REG;
enum class SYSREG;
const char* get_register_name(REG r);
const char* get_register_name(SYSREG r);

enum class REG {
  NoRegister = 0,
  FFR = 1,
  FP = 2,
  FPCR = 3,
  FPSR = 4,
  LR = 5,
  NZCV = 6,
  SP = 7,
  VG = 8,
  WSP = 9,
  WZR = 10,
  XZR = 11,
  ZA = 12,
  B0 = 13,
  B1 = 14,
  B2 = 15,
  B3 = 16,
  B4 = 17,
  B5 = 18,
  B6 = 19,
  B7 = 20,
  B8 = 21,
  B9 = 22,
  B10 = 23,
  B11 = 24,
  B12 = 25,
  B13 = 26,
  B14 = 27,
  B15 = 28,
  B16 = 29,
  B17 = 30,
  B18 = 31,
  B19 = 32,
  B20 = 33,
  B21 = 34,
  B22 = 35,
  B23 = 36,
  B24 = 37,
  B25 = 38,
  B26 = 39,
  B27 = 40,
  B28 = 41,
  B29 = 42,
  B30 = 43,
  B31 = 44,
  D0 = 45,
  D1 = 46,
  D2 = 47,
  D3 = 48,
  D4 = 49,
  D5 = 50,
  D6 = 51,
  D7 = 52,
  D8 = 53,
  D9 = 54,
  D10 = 55,
  D11 = 56,
  D12 = 57,
  D13 = 58,
  D14 = 59,
  D15 = 60,
  D16 = 61,
  D17 = 62,
  D18 = 63,
  D19 = 64,
  D20 = 65,
  D21 = 66,
  D22 = 67,
  D23 = 68,
  D24 = 69,
  D25 = 70,
  D26 = 71,
  D27 = 72,
  D28 = 73,
  D29 = 74,
  D30 = 75,
  D31 = 76,
  H0 = 77,
  H1 = 78,
  H2 = 79,
  H3 = 80,
  H4 = 81,
  H5 = 82,
  H6 = 83,
  H7 = 84,
  H8 = 85,
  H9 = 86,
  H10 = 87,
  H11 = 88,
  H12 = 89,
  H13 = 90,
  H14 = 91,
  H15 = 92,
  H16 = 93,
  H17 = 94,
  H18 = 95,
  H19 = 96,
  H20 = 97,
  H21 = 98,
  H22 = 99,
  H23 = 100,
  H24 = 101,
  H25 = 102,
  H26 = 103,
  H27 = 104,
  H28 = 105,
  H29 = 106,
  H30 = 107,
  H31 = 108,
  P0 = 109,
  P1 = 110,
  P2 = 111,
  P3 = 112,
  P4 = 113,
  P5 = 114,
  P6 = 115,
  P7 = 116,
  P8 = 117,
  P9 = 118,
  P10 = 119,
  P11 = 120,
  P12 = 121,
  P13 = 122,
  P14 = 123,
  P15 = 124,
  PN0 = 125,
  PN1 = 126,
  PN2 = 127,
  PN3 = 128,
  PN4 = 129,
  PN5 = 130,
  PN6 = 131,
  PN7 = 132,
  PN8 = 133,
  PN9 = 134,
  PN10 = 135,
  PN11 = 136,
  PN12 = 137,
  PN13 = 138,
  PN14 = 139,
  PN15 = 140,
  Q0 = 141,
  Q1 = 142,
  Q2 = 143,
  Q3 = 144,
  Q4 = 145,
  Q5 = 146,
  Q6 = 147,
  Q7 = 148,
  Q8 = 149,
  Q9 = 150,
  Q10 = 151,
  Q11 = 152,
  Q12 = 153,
  Q13 = 154,
  Q14 = 155,
  Q15 = 156,
  Q16 = 157,
  Q17 = 158,
  Q18 = 159,
  Q19 = 160,
  Q20 = 161,
  Q21 = 162,
  Q22 = 163,
  Q23 = 164,
  Q24 = 165,
  Q25 = 166,
  Q26 = 167,
  Q27 = 168,
  Q28 = 169,
  Q29 = 170,
  Q30 = 171,
  Q31 = 172,
  S0 = 173,
  S1 = 174,
  S2 = 175,
  S3 = 176,
  S4 = 177,
  S5 = 178,
  S6 = 179,
  S7 = 180,
  S8 = 181,
  S9 = 182,
  S10 = 183,
  S11 = 184,
  S12 = 185,
  S13 = 186,
  S14 = 187,
  S15 = 188,
  S16 = 189,
  S17 = 190,
  S18 = 191,
  S19 = 192,
  S20 = 193,
  S21 = 194,
  S22 = 195,
  S23 = 196,
  S24 = 197,
  S25 = 198,
  S26 = 199,
  S27 = 200,
  S28 = 201,
  S29 = 202,
  S30 = 203,
  S31 = 204,
  W0 = 205,
  W1 = 206,
  W2 = 207,
  W3 = 208,
  W4 = 209,
  W5 = 210,
  W6 = 211,
  W7 = 212,
  W8 = 213,
  W9 = 214,
  W10 = 215,
  W11 = 216,
  W12 = 217,
  W13 = 218,
  W14 = 219,
  W15 = 220,
  W16 = 221,
  W17 = 222,
  W18 = 223,
  W19 = 224,
  W20 = 225,
  W21 = 226,
  W22 = 227,
  W23 = 228,
  W24 = 229,
  W25 = 230,
  W26 = 231,
  W27 = 232,
  W28 = 233,
  W29 = 234,
  W30 = 235,
  X0 = 236,
  X1 = 237,
  X2 = 238,
  X3 = 239,
  X4 = 240,
  X5 = 241,
  X6 = 242,
  X7 = 243,
  X8 = 244,
  X9 = 245,
  X10 = 246,
  X11 = 247,
  X12 = 248,
  X13 = 249,
  X14 = 250,
  X15 = 251,
  X16 = 252,
  X17 = 253,
  X18 = 254,
  X19 = 255,
  X20 = 256,
  X21 = 257,
  X22 = 258,
  X23 = 259,
  X24 = 260,
  X25 = 261,
  X26 = 262,
  X27 = 263,
  X28 = 264,
  Z0 = 265,
  Z1 = 266,
  Z2 = 267,
  Z3 = 268,
  Z4 = 269,
  Z5 = 270,
  Z6 = 271,
  Z7 = 272,
  Z8 = 273,
  Z9 = 274,
  Z10 = 275,
  Z11 = 276,
  Z12 = 277,
  Z13 = 278,
  Z14 = 279,
  Z15 = 280,
  Z16 = 281,
  Z17 = 282,
  Z18 = 283,
  Z19 = 284,
  Z20 = 285,
  Z21 = 286,
  Z22 = 287,
  Z23 = 288,
  Z24 = 289,
  Z25 = 290,
  Z26 = 291,
  Z27 = 292,
  Z28 = 293,
  Z29 = 294,
  Z30 = 295,
  Z31 = 296,
  ZAB0 = 297,
  ZAD0 = 298,
  ZAD1 = 299,
  ZAD2 = 300,
  ZAD3 = 301,
  ZAD4 = 302,
  ZAD5 = 303,
  ZAD6 = 304,
  ZAD7 = 305,
  ZAH0 = 306,
  ZAH1 = 307,
  ZAQ0 = 308,
  ZAQ1 = 309,
  ZAQ2 = 310,
  ZAQ3 = 311,
  ZAQ4 = 312,
  ZAQ5 = 313,
  ZAQ6 = 314,
  ZAQ7 = 315,
  ZAQ8 = 316,
  ZAQ9 = 317,
  ZAQ10 = 318,
  ZAQ11 = 319,
  ZAQ12 = 320,
  ZAQ13 = 321,
  ZAQ14 = 322,
  ZAQ15 = 323,
  ZAS0 = 324,
  ZAS1 = 325,
  ZAS2 = 326,
  ZAS3 = 327,
  ZT0 = 328,
  D0_D1 = 329,
  D1_D2 = 330,
  D2_D3 = 331,
  D3_D4 = 332,
  D4_D5 = 333,
  D5_D6 = 334,
  D6_D7 = 335,
  D7_D8 = 336,
  D8_D9 = 337,
  D9_D10 = 338,
  D10_D11 = 339,
  D11_D12 = 340,
  D12_D13 = 341,
  D13_D14 = 342,
  D14_D15 = 343,
  D15_D16 = 344,
  D16_D17 = 345,
  D17_D18 = 346,
  D18_D19 = 347,
  D19_D20 = 348,
  D20_D21 = 349,
  D21_D22 = 350,
  D22_D23 = 351,
  D23_D24 = 352,
  D24_D25 = 353,
  D25_D26 = 354,
  D26_D27 = 355,
  D27_D28 = 356,
  D28_D29 = 357,
  D29_D30 = 358,
  D30_D31 = 359,
  D31_D0 = 360,
  D0_D1_D2_D3 = 361,
  D1_D2_D3_D4 = 362,
  D2_D3_D4_D5 = 363,
  D3_D4_D5_D6 = 364,
  D4_D5_D6_D7 = 365,
  D5_D6_D7_D8 = 366,
  D6_D7_D8_D9 = 367,
  D7_D8_D9_D10 = 368,
  D8_D9_D10_D11 = 369,
  D9_D10_D11_D12 = 370,
  D10_D11_D12_D13 = 371,
  D11_D12_D13_D14 = 372,
  D12_D13_D14_D15 = 373,
  D13_D14_D15_D16 = 374,
  D14_D15_D16_D17 = 375,
  D15_D16_D17_D18 = 376,
  D16_D17_D18_D19 = 377,
  D17_D18_D19_D20 = 378,
  D18_D19_D20_D21 = 379,
  D19_D20_D21_D22 = 380,
  D20_D21_D22_D23 = 381,
  D21_D22_D23_D24 = 382,
  D22_D23_D24_D25 = 383,
  D23_D24_D25_D26 = 384,
  D24_D25_D26_D27 = 385,
  D25_D26_D27_D28 = 386,
  D26_D27_D28_D29 = 387,
  D27_D28_D29_D30 = 388,
  D28_D29_D30_D31 = 389,
  D29_D30_D31_D0 = 390,
  D30_D31_D0_D1 = 391,
  D31_D0_D1_D2 = 392,
  D0_D1_D2 = 393,
  D1_D2_D3 = 394,
  D2_D3_D4 = 395,
  D3_D4_D5 = 396,
  D4_D5_D6 = 397,
  D5_D6_D7 = 398,
  D6_D7_D8 = 399,
  D7_D8_D9 = 400,
  D8_D9_D10 = 401,
  D9_D10_D11 = 402,
  D10_D11_D12 = 403,
  D11_D12_D13 = 404,
  D12_D13_D14 = 405,
  D13_D14_D15 = 406,
  D14_D15_D16 = 407,
  D15_D16_D17 = 408,
  D16_D17_D18 = 409,
  D17_D18_D19 = 410,
  D18_D19_D20 = 411,
  D19_D20_D21 = 412,
  D20_D21_D22 = 413,
  D21_D22_D23 = 414,
  D22_D23_D24 = 415,
  D23_D24_D25 = 416,
  D24_D25_D26 = 417,
  D25_D26_D27 = 418,
  D26_D27_D28 = 419,
  D27_D28_D29 = 420,
  D28_D29_D30 = 421,
  D29_D30_D31 = 422,
  D30_D31_D0 = 423,
  D31_D0_D1 = 424,
  P0_P1 = 425,
  P1_P2 = 426,
  P2_P3 = 427,
  P3_P4 = 428,
  P4_P5 = 429,
  P5_P6 = 430,
  P6_P7 = 431,
  P7_P8 = 432,
  P8_P9 = 433,
  P9_P10 = 434,
  P10_P11 = 435,
  P11_P12 = 436,
  P12_P13 = 437,
  P13_P14 = 438,
  P14_P15 = 439,
  P15_P0 = 440,
  Q0_Q1 = 441,
  Q1_Q2 = 442,
  Q2_Q3 = 443,
  Q3_Q4 = 444,
  Q4_Q5 = 445,
  Q5_Q6 = 446,
  Q6_Q7 = 447,
  Q7_Q8 = 448,
  Q8_Q9 = 449,
  Q9_Q10 = 450,
  Q10_Q11 = 451,
  Q11_Q12 = 452,
  Q12_Q13 = 453,
  Q13_Q14 = 454,
  Q14_Q15 = 455,
  Q15_Q16 = 456,
  Q16_Q17 = 457,
  Q17_Q18 = 458,
  Q18_Q19 = 459,
  Q19_Q20 = 460,
  Q20_Q21 = 461,
  Q21_Q22 = 462,
  Q22_Q23 = 463,
  Q23_Q24 = 464,
  Q24_Q25 = 465,
  Q25_Q26 = 466,
  Q26_Q27 = 467,
  Q27_Q28 = 468,
  Q28_Q29 = 469,
  Q29_Q30 = 470,
  Q30_Q31 = 471,
  Q31_Q0 = 472,
  Q0_Q1_Q2_Q3 = 473,
  Q1_Q2_Q3_Q4 = 474,
  Q2_Q3_Q4_Q5 = 475,
  Q3_Q4_Q5_Q6 = 476,
  Q4_Q5_Q6_Q7 = 477,
  Q5_Q6_Q7_Q8 = 478,
  Q6_Q7_Q8_Q9 = 479,
  Q7_Q8_Q9_Q10 = 480,
  Q8_Q9_Q10_Q11 = 481,
  Q9_Q10_Q11_Q12 = 482,
  Q10_Q11_Q12_Q13 = 483,
  Q11_Q12_Q13_Q14 = 484,
  Q12_Q13_Q14_Q15 = 485,
  Q13_Q14_Q15_Q16 = 486,
  Q14_Q15_Q16_Q17 = 487,
  Q15_Q16_Q17_Q18 = 488,
  Q16_Q17_Q18_Q19 = 489,
  Q17_Q18_Q19_Q20 = 490,
  Q18_Q19_Q20_Q21 = 491,
  Q19_Q20_Q21_Q22 = 492,
  Q20_Q21_Q22_Q23 = 493,
  Q21_Q22_Q23_Q24 = 494,
  Q22_Q23_Q24_Q25 = 495,
  Q23_Q24_Q25_Q26 = 496,
  Q24_Q25_Q26_Q27 = 497,
  Q25_Q26_Q27_Q28 = 498,
  Q26_Q27_Q28_Q29 = 499,
  Q27_Q28_Q29_Q30 = 500,
  Q28_Q29_Q30_Q31 = 501,
  Q29_Q30_Q31_Q0 = 502,
  Q30_Q31_Q0_Q1 = 503,
  Q31_Q0_Q1_Q2 = 504,
  Q0_Q1_Q2 = 505,
  Q1_Q2_Q3 = 506,
  Q2_Q3_Q4 = 507,
  Q3_Q4_Q5 = 508,
  Q4_Q5_Q6 = 509,
  Q5_Q6_Q7 = 510,
  Q6_Q7_Q8 = 511,
  Q7_Q8_Q9 = 512,
  Q8_Q9_Q10 = 513,
  Q9_Q10_Q11 = 514,
  Q10_Q11_Q12 = 515,
  Q11_Q12_Q13 = 516,
  Q12_Q13_Q14 = 517,
  Q13_Q14_Q15 = 518,
  Q14_Q15_Q16 = 519,
  Q15_Q16_Q17 = 520,
  Q16_Q17_Q18 = 521,
  Q17_Q18_Q19 = 522,
  Q18_Q19_Q20 = 523,
  Q19_Q20_Q21 = 524,
  Q20_Q21_Q22 = 525,
  Q21_Q22_Q23 = 526,
  Q22_Q23_Q24 = 527,
  Q23_Q24_Q25 = 528,
  Q24_Q25_Q26 = 529,
  Q25_Q26_Q27 = 530,
  Q26_Q27_Q28 = 531,
  Q27_Q28_Q29 = 532,
  Q28_Q29_Q30 = 533,
  Q29_Q30_Q31 = 534,
  Q30_Q31_Q0 = 535,
  Q31_Q0_Q1 = 536,
  X22_X23_X24_X25_X26_X27_X28_FP = 537,
  X0_X1_X2_X3_X4_X5_X6_X7 = 538,
  X2_X3_X4_X5_X6_X7_X8_X9 = 539,
  X4_X5_X6_X7_X8_X9_X10_X11 = 540,
  X6_X7_X8_X9_X10_X11_X12_X13 = 541,
  X8_X9_X10_X11_X12_X13_X14_X15 = 542,
  X10_X11_X12_X13_X14_X15_X16_X17 = 543,
  X12_X13_X14_X15_X16_X17_X18_X19 = 544,
  X14_X15_X16_X17_X18_X19_X20_X21 = 545,
  X16_X17_X18_X19_X20_X21_X22_X23 = 546,
  X18_X19_X20_X21_X22_X23_X24_X25 = 547,
  X20_X21_X22_X23_X24_X25_X26_X27 = 548,
  W30_WZR = 549,
  W0_W1 = 550,
  W2_W3 = 551,
  W4_W5 = 552,
  W6_W7 = 553,
  W8_W9 = 554,
  W10_W11 = 555,
  W12_W13 = 556,
  W14_W15 = 557,
  W16_W17 = 558,
  W18_W19 = 559,
  W20_W21 = 560,
  W22_W23 = 561,
  W24_W25 = 562,
  W26_W27 = 563,
  W28_W29 = 564,
  LR_XZR = 565,
  X28_FP = 566,
  X0_X1 = 567,
  X2_X3 = 568,
  X4_X5 = 569,
  X6_X7 = 570,
  X8_X9 = 571,
  X10_X11 = 572,
  X12_X13 = 573,
  X14_X15 = 574,
  X16_X17 = 575,
  X18_X19 = 576,
  X20_X21 = 577,
  X22_X23 = 578,
  X24_X25 = 579,
  X26_X27 = 580,
  Z0_Z1 = 581,
  Z1_Z2 = 582,
  Z2_Z3 = 583,
  Z3_Z4 = 584,
  Z4_Z5 = 585,
  Z5_Z6 = 586,
  Z6_Z7 = 587,
  Z7_Z8 = 588,
  Z8_Z9 = 589,
  Z9_Z10 = 590,
  Z10_Z11 = 591,
  Z11_Z12 = 592,
  Z12_Z13 = 593,
  Z13_Z14 = 594,
  Z14_Z15 = 595,
  Z15_Z16 = 596,
  Z16_Z17 = 597,
  Z17_Z18 = 598,
  Z18_Z19 = 599,
  Z19_Z20 = 600,
  Z20_Z21 = 601,
  Z21_Z22 = 602,
  Z22_Z23 = 603,
  Z23_Z24 = 604,
  Z24_Z25 = 605,
  Z25_Z26 = 606,
  Z26_Z27 = 607,
  Z27_Z28 = 608,
  Z28_Z29 = 609,
  Z29_Z30 = 610,
  Z30_Z31 = 611,
  Z31_Z0 = 612,
  Z0_Z1_Z2_Z3 = 613,
  Z1_Z2_Z3_Z4 = 614,
  Z2_Z3_Z4_Z5 = 615,
  Z3_Z4_Z5_Z6 = 616,
  Z4_Z5_Z6_Z7 = 617,
  Z5_Z6_Z7_Z8 = 618,
  Z6_Z7_Z8_Z9 = 619,
  Z7_Z8_Z9_Z10 = 620,
  Z8_Z9_Z10_Z11 = 621,
  Z9_Z10_Z11_Z12 = 622,
  Z10_Z11_Z12_Z13 = 623,
  Z11_Z12_Z13_Z14 = 624,
  Z12_Z13_Z14_Z15 = 625,
  Z13_Z14_Z15_Z16 = 626,
  Z14_Z15_Z16_Z17 = 627,
  Z15_Z16_Z17_Z18 = 628,
  Z16_Z17_Z18_Z19 = 629,
  Z17_Z18_Z19_Z20 = 630,
  Z18_Z19_Z20_Z21 = 631,
  Z19_Z20_Z21_Z22 = 632,
  Z20_Z21_Z22_Z23 = 633,
  Z21_Z22_Z23_Z24 = 634,
  Z22_Z23_Z24_Z25 = 635,
  Z23_Z24_Z25_Z26 = 636,
  Z24_Z25_Z26_Z27 = 637,
  Z25_Z26_Z27_Z28 = 638,
  Z26_Z27_Z28_Z29 = 639,
  Z27_Z28_Z29_Z30 = 640,
  Z28_Z29_Z30_Z31 = 641,
  Z29_Z30_Z31_Z0 = 642,
  Z30_Z31_Z0_Z1 = 643,
  Z31_Z0_Z1_Z2 = 644,
  Z0_Z1_Z2 = 645,
  Z1_Z2_Z3 = 646,
  Z2_Z3_Z4 = 647,
  Z3_Z4_Z5 = 648,
  Z4_Z5_Z6 = 649,
  Z5_Z6_Z7 = 650,
  Z6_Z7_Z8 = 651,
  Z7_Z8_Z9 = 652,
  Z8_Z9_Z10 = 653,
  Z9_Z10_Z11 = 654,
  Z10_Z11_Z12 = 655,
  Z11_Z12_Z13 = 656,
  Z12_Z13_Z14 = 657,
  Z13_Z14_Z15 = 658,
  Z14_Z15_Z16 = 659,
  Z15_Z16_Z17 = 660,
  Z16_Z17_Z18 = 661,
  Z17_Z18_Z19 = 662,
  Z18_Z19_Z20 = 663,
  Z19_Z20_Z21 = 664,
  Z20_Z21_Z22 = 665,
  Z21_Z22_Z23 = 666,
  Z22_Z23_Z24 = 667,
  Z23_Z24_Z25 = 668,
  Z24_Z25_Z26 = 669,
  Z25_Z26_Z27 = 670,
  Z26_Z27_Z28 = 671,
  Z27_Z28_Z29 = 672,
  Z28_Z29_Z30 = 673,
  Z29_Z30_Z31 = 674,
  Z30_Z31_Z0 = 675,
  Z31_Z0_Z1 = 676,
  Z16_Z24 = 677,
  Z17_Z25 = 678,
  Z18_Z26 = 679,
  Z19_Z27 = 680,
  Z20_Z28 = 681,
  Z21_Z29 = 682,
  Z22_Z30 = 683,
  Z23_Z31 = 684,
  Z0_Z8 = 685,
  Z1_Z9 = 686,
  Z2_Z10 = 687,
  Z3_Z11 = 688,
  Z4_Z12 = 689,
  Z5_Z13 = 690,
  Z6_Z14 = 691,
  Z7_Z15 = 692,
  Z16_Z20_Z24_Z28 = 693,
  Z17_Z21_Z25_Z29 = 694,
  Z18_Z22_Z26_Z30 = 695,
  Z19_Z23_Z27_Z31 = 696,
  Z0_Z4_Z8_Z12 = 697,
  Z1_Z5_Z9_Z13 = 698,
  Z2_Z6_Z10_Z14 = 699,
  Z3_Z7_Z11_Z15 = 700,
  NUM_TARGET_REGS = 701,
};

enum class SYSREG {
  OSDTRRX_EL1 = 32770,
  DBGBVR0_EL1 = 32772,
  DBGBCR0_EL1 = 32773,
  DBGWVR0_EL1 = 32774,
  DBGWCR0_EL1 = 32775,
  DBGBVR1_EL1 = 32780,
  DBGBCR1_EL1 = 32781,
  DBGWVR1_EL1 = 32782,
  DBGWCR1_EL1 = 32783,
  MDCCINT_EL1 = 32784,
  MDSCR_EL1 = 32786,
  DBGBVR2_EL1 = 32788,
  DBGBCR2_EL1 = 32789,
  DBGWVR2_EL1 = 32790,
  DBGWCR2_EL1 = 32791,
  OSDTRTX_EL1 = 32794,
  DBGBVR3_EL1 = 32796,
  DBGBCR3_EL1 = 32797,
  DBGWVR3_EL1 = 32798,
  DBGWCR3_EL1 = 32799,
  MDSELR_EL1 = 32802,
  DBGBVR4_EL1 = 32804,
  DBGBCR4_EL1 = 32805,
  DBGWVR4_EL1 = 32806,
  DBGWCR4_EL1 = 32807,
  MDSTEPOP_EL1 = 32810,
  DBGBVR5_EL1 = 32812,
  DBGBCR5_EL1 = 32813,
  DBGWVR5_EL1 = 32814,
  DBGWCR5_EL1 = 32815,
  OSECCR_EL1 = 32818,
  DBGBVR6_EL1 = 32820,
  DBGBCR6_EL1 = 32821,
  DBGWVR6_EL1 = 32822,
  DBGWCR6_EL1 = 32823,
  DBGBVR7_EL1 = 32828,
  DBGBCR7_EL1 = 32829,
  DBGWVR7_EL1 = 32830,
  DBGWCR7_EL1 = 32831,
  DBGBVR8_EL1 = 32836,
  DBGBCR8_EL1 = 32837,
  DBGWVR8_EL1 = 32838,
  DBGWCR8_EL1 = 32839,
  DBGBVR9_EL1 = 32844,
  DBGBCR9_EL1 = 32845,
  DBGWVR9_EL1 = 32846,
  DBGWCR9_EL1 = 32847,
  DBGBVR10_EL1 = 32852,
  DBGBCR10_EL1 = 32853,
  DBGWVR10_EL1 = 32854,
  DBGWCR10_EL1 = 32855,
  DBGBVR11_EL1 = 32860,
  DBGBCR11_EL1 = 32861,
  DBGWVR11_EL1 = 32862,
  DBGWCR11_EL1 = 32863,
  DBGBVR12_EL1 = 32868,
  DBGBCR12_EL1 = 32869,
  DBGWVR12_EL1 = 32870,
  DBGWCR12_EL1 = 32871,
  DBGBVR13_EL1 = 32876,
  DBGBCR13_EL1 = 32877,
  DBGWVR13_EL1 = 32878,
  DBGWCR13_EL1 = 32879,
  DBGBVR14_EL1 = 32884,
  DBGBCR14_EL1 = 32885,
  DBGWVR14_EL1 = 32886,
  DBGWCR14_EL1 = 32887,
  DBGBVR15_EL1 = 32892,
  DBGBCR15_EL1 = 32893,
  DBGWVR15_EL1 = 32894,
  DBGWCR15_EL1 = 32895,
  MDRAR_EL1 = 32896,
  OSLAR_EL1 = 32900,
  OSLSR_EL1 = 32908,
  OSDLR_EL1 = 32924,
  DBGPRCR_EL1 = 32932,
  DBGCLAIMSET_EL1 = 33734,
  DBGCLAIMCLR_EL1 = 33742,
  DBGAUTHSTATUS_EL1 = 33782,
  SPMCGCR0_EL1 = 34024,
  SPMCGCR1_EL1 = 34025,
  SPMACCESSR_EL1 = 34027,
  SPMIIDR_EL1 = 34028,
  SPMDEVARCH_EL1 = 34029,
  SPMDEVAFF_EL1 = 34030,
  SPMCFGR_EL1 = 34031,
  SPMINTENSET_EL1 = 34033,
  SPMINTENCLR_EL1 = 34034,
  PMEVCNTSVR0_EL1 = 34624,
  PMEVCNTSVR1_EL1 = 34625,
  PMEVCNTSVR2_EL1 = 34626,
  PMEVCNTSVR3_EL1 = 34627,
  PMEVCNTSVR4_EL1 = 34628,
  PMEVCNTSVR5_EL1 = 34629,
  PMEVCNTSVR6_EL1 = 34630,
  PMEVCNTSVR7_EL1 = 34631,
  PMEVCNTSVR8_EL1 = 34632,
  PMEVCNTSVR9_EL1 = 34633,
  PMEVCNTSVR10_EL1 = 34634,
  PMEVCNTSVR11_EL1 = 34635,
  PMEVCNTSVR12_EL1 = 34636,
  PMEVCNTSVR13_EL1 = 34637,
  PMEVCNTSVR14_EL1 = 34638,
  PMEVCNTSVR15_EL1 = 34639,
  PMEVCNTSVR16_EL1 = 34640,
  PMEVCNTSVR17_EL1 = 34641,
  PMEVCNTSVR18_EL1 = 34642,
  PMEVCNTSVR19_EL1 = 34643,
  PMEVCNTSVR20_EL1 = 34644,
  PMEVCNTSVR21_EL1 = 34645,
  PMEVCNTSVR22_EL1 = 34646,
  PMEVCNTSVR23_EL1 = 34647,
  PMEVCNTSVR24_EL1 = 34648,
  PMEVCNTSVR25_EL1 = 34649,
  PMEVCNTSVR26_EL1 = 34650,
  PMEVCNTSVR27_EL1 = 34651,
  PMEVCNTSVR28_EL1 = 34652,
  PMEVCNTSVR29_EL1 = 34653,
  PMEVCNTSVR30_EL1 = 34654,
  PMCCNTSVR_EL1 = 34655,
  PMICNTSVR_EL1 = 34656,
  TRCTRACEIDR = 34817,
  TRCVICTLR = 34818,
  TRCSEQEVR0 = 34820,
  TRCCNTRLDVR0 = 34821,
  TRCIDR8 = 34822,
  TRCIMSPEC0 = 34823,
  TRCPRGCTLR = 34824,
  TRCQCTLR = 34825,
  TRCVIIECTLR = 34826,
  TRCSEQEVR1 = 34828,
  TRCCNTRLDVR1 = 34829,
  TRCIDR9 = 34830,
  TRCIMSPEC1 = 34831,
  TRCPROCSELR = 34832,
  TRCITEEDCR = 34833,
  TRCVISSCTLR = 34834,
  TRCSEQEVR2 = 34836,
  TRCCNTRLDVR2 = 34837,
  TRCIDR10 = 34838,
  TRCIMSPEC2 = 34839,
  TRCSTATR = 34840,
  TRCVIPCSSCTLR = 34842,
  TRCCNTRLDVR3 = 34845,
  TRCIDR11 = 34846,
  TRCIMSPEC3 = 34847,
  TRCCONFIGR = 34848,
  TRCCNTCTLR0 = 34853,
  TRCIDR12 = 34854,
  TRCIMSPEC4 = 34855,
  TRCCNTCTLR1 = 34861,
  TRCIDR13 = 34862,
  TRCIMSPEC5 = 34863,
  TRCAUXCTLR = 34864,
  TRCSEQRSTEVR = 34868,
  TRCCNTCTLR2 = 34869,
  TRCIMSPEC6 = 34871,
  TRCSEQSTR = 34876,
  TRCCNTCTLR3 = 34877,
  TRCIMSPEC7 = 34879,
  TRCEVENTCTL0R = 34880,
  TRCVDCTLR = 34882,
  TRCEXTINSELR = 34884,
  TRCEXTINSELR0 = 34884,
  TRCCNTVR0 = 34885,
  TRCIDR0 = 34887,
  TRCEVENTCTL1R = 34888,
  TRCVDSACCTLR = 34890,
  TRCEXTINSELR1 = 34892,
  TRCCNTVR1 = 34893,
  TRCIDR1 = 34895,
  TRCRSR = 34896,
  TRCVDARCCTLR = 34898,
  TRCEXTINSELR2 = 34900,
  TRCCNTVR2 = 34901,
  TRCIDR2 = 34903,
  TRCSTALLCTLR = 34904,
  TRCEXTINSELR3 = 34908,
  TRCCNTVR3 = 34909,
  TRCIDR3 = 34911,
  TRCTSCTLR = 34912,
  TRCIDR4 = 34919,
  TRCSYNCPR = 34920,
  TRCIDR5 = 34927,
  TRCCCCTLR = 34928,
  TRCIDR6 = 34935,
  TRCBBCTLR = 34936,
  TRCIDR7 = 34943,
  TRCRSCTLR16 = 34945,
  TRCSSCCR0 = 34946,
  TRCSSPCICR0 = 34947,
  TRCOSLAR = 34948,
  TRCRSCTLR17 = 34953,
  TRCSSCCR1 = 34954,
  TRCSSPCICR1 = 34955,
  TRCOSLSR = 34956,
  TRCRSCTLR2 = 34960,
  TRCRSCTLR18 = 34961,
  TRCSSCCR2 = 34962,
  TRCSSPCICR2 = 34963,
  TRCRSCTLR3 = 34968,
  TRCRSCTLR19 = 34969,
  TRCSSCCR3 = 34970,
  TRCSSPCICR3 = 34971,
  TRCRSCTLR4 = 34976,
  TRCRSCTLR20 = 34977,
  TRCSSCCR4 = 34978,
  TRCSSPCICR4 = 34979,
  TRCPDCR = 34980,
  TRCRSCTLR5 = 34984,
  TRCRSCTLR21 = 34985,
  TRCSSCCR5 = 34986,
  TRCSSPCICR5 = 34987,
  TRCPDSR = 34988,
  TRCRSCTLR6 = 34992,
  TRCRSCTLR22 = 34993,
  TRCSSCCR6 = 34994,
  TRCSSPCICR6 = 34995,
  TRCRSCTLR7 = 35000,
  TRCRSCTLR23 = 35001,
  TRCSSCCR7 = 35002,
  TRCSSPCICR7 = 35003,
  TRCRSCTLR8 = 35008,
  TRCRSCTLR24 = 35009,
  TRCSSCSR0 = 35010,
  TRCRSCTLR9 = 35016,
  TRCRSCTLR25 = 35017,
  TRCSSCSR1 = 35018,
  TRCRSCTLR10 = 35024,
  TRCRSCTLR26 = 35025,
  TRCSSCSR2 = 35026,
  TRCRSCTLR11 = 35032,
  TRCRSCTLR27 = 35033,
  TRCSSCSR3 = 35034,
  TRCRSCTLR12 = 35040,
  TRCRSCTLR28 = 35041,
  TRCSSCSR4 = 35042,
  TRCRSCTLR13 = 35048,
  TRCRSCTLR29 = 35049,
  TRCSSCSR5 = 35050,
  TRCRSCTLR14 = 35056,
  TRCRSCTLR30 = 35057,
  TRCSSCSR6 = 35058,
  TRCRSCTLR15 = 35064,
  TRCRSCTLR31 = 35065,
  TRCSSCSR7 = 35066,
  TRCACVR0 = 35072,
  TRCACVR8 = 35073,
  TRCACATR0 = 35074,
  TRCACATR8 = 35075,
  TRCDVCVR0 = 35076,
  TRCDVCVR4 = 35077,
  TRCDVCMR0 = 35078,
  TRCDVCMR4 = 35079,
  TRCACVR1 = 35088,
  TRCACVR9 = 35089,
  TRCACATR1 = 35090,
  TRCACATR9 = 35091,
  TRCACVR2 = 35104,
  TRCACVR10 = 35105,
  TRCACATR2 = 35106,
  TRCACATR10 = 35107,
  TRCDVCVR1 = 35108,
  TRCDVCVR5 = 35109,
  TRCDVCMR1 = 35110,
  TRCDVCMR5 = 35111,
  TRCACVR3 = 35120,
  TRCACVR11 = 35121,
  TRCACATR3 = 35122,
  TRCACATR11 = 35123,
  TRCACVR4 = 35136,
  TRCACVR12 = 35137,
  TRCACATR4 = 35138,
  TRCACATR12 = 35139,
  TRCDVCVR2 = 35140,
  TRCDVCVR6 = 35141,
  TRCDVCMR2 = 35142,
  TRCDVCMR6 = 35143,
  TRCACVR5 = 35152,
  TRCACVR13 = 35153,
  TRCACATR5 = 35154,
  TRCACATR13 = 35155,
  TRCACVR6 = 35168,
  TRCACVR14 = 35169,
  TRCACATR6 = 35170,
  TRCACATR14 = 35171,
  TRCDVCVR3 = 35172,
  TRCDVCVR7 = 35173,
  TRCDVCMR3 = 35174,
  TRCDVCMR7 = 35175,
  TRCACVR7 = 35184,
  TRCACVR15 = 35185,
  TRCACATR7 = 35186,
  TRCACATR15 = 35187,
  TRCCIDCVR0 = 35200,
  TRCVMIDCVR0 = 35201,
  TRCCIDCCTLR0 = 35202,
  TRCCIDCCTLR1 = 35210,
  TRCCIDCVR1 = 35216,
  TRCVMIDCVR1 = 35217,
  TRCVMIDCCTLR0 = 35218,
  TRCVMIDCCTLR1 = 35226,
  TRCCIDCVR2 = 35232,
  TRCVMIDCVR2 = 35233,
  TRCCIDCVR3 = 35248,
  TRCVMIDCVR3 = 35249,
  TRCCIDCVR4 = 35264,
  TRCVMIDCVR4 = 35265,
  TRCCIDCVR5 = 35280,
  TRCVMIDCVR5 = 35281,
  TRCCIDCVR6 = 35296,
  TRCVMIDCVR6 = 35297,
  TRCCIDCVR7 = 35312,
  TRCVMIDCVR7 = 35313,
  TRCITCTRL = 35716,
  TRCDEVID = 35735,
  TRCDEVTYPE = 35743,
  TRCPIDR4 = 35751,
  TRCPIDR5 = 35759,
  TRCPIDR6 = 35767,
  TRCPIDR7 = 35775,
  TRCCLAIMSET = 35782,
  TRCPIDR0 = 35783,
  TRCCLAIMCLR = 35790,
  TRCPIDR1 = 35791,
  TRCDEVAFF0 = 35798,
  TRCPIDR2 = 35799,
  TRCDEVAFF1 = 35806,
  TRCPIDR3 = 35807,
  TRCLAR = 35814,
  TRCCIDR0 = 35815,
  TRCLSR = 35822,
  TRCCIDR1 = 35823,
  TRCAUTHSTATUS = 35830,
  TRCCIDR2 = 35831,
  TRCDEVARCH = 35838,
  TRCCIDR3 = 35839,
  BRBINF0_EL1 = 35840,
  BRBSRC0_EL1 = 35841,
  BRBTGT0_EL1 = 35842,
  BRBINF16_EL1 = 35844,
  BRBSRC16_EL1 = 35845,
  BRBTGT16_EL1 = 35846,
  BRBINF1_EL1 = 35848,
  BRBSRC1_EL1 = 35849,
  BRBTGT1_EL1 = 35850,
  BRBINF17_EL1 = 35852,
  BRBSRC17_EL1 = 35853,
  BRBTGT17_EL1 = 35854,
  BRBINF2_EL1 = 35856,
  BRBSRC2_EL1 = 35857,
  BRBTGT2_EL1 = 35858,
  BRBINF18_EL1 = 35860,
  BRBSRC18_EL1 = 35861,
  BRBTGT18_EL1 = 35862,
  BRBINF3_EL1 = 35864,
  BRBSRC3_EL1 = 35865,
  BRBTGT3_EL1 = 35866,
  BRBINF19_EL1 = 35868,
  BRBSRC19_EL1 = 35869,
  BRBTGT19_EL1 = 35870,
  BRBINF4_EL1 = 35872,
  BRBSRC4_EL1 = 35873,
  BRBTGT4_EL1 = 35874,
  BRBINF20_EL1 = 35876,
  BRBSRC20_EL1 = 35877,
  BRBTGT20_EL1 = 35878,
  BRBINF5_EL1 = 35880,
  BRBSRC5_EL1 = 35881,
  BRBTGT5_EL1 = 35882,
  BRBINF21_EL1 = 35884,
  BRBSRC21_EL1 = 35885,
  BRBTGT21_EL1 = 35886,
  BRBINF6_EL1 = 35888,
  BRBSRC6_EL1 = 35889,
  BRBTGT6_EL1 = 35890,
  BRBINF22_EL1 = 35892,
  BRBSRC22_EL1 = 35893,
  BRBTGT22_EL1 = 35894,
  BRBINF7_EL1 = 35896,
  BRBSRC7_EL1 = 35897,
  BRBTGT7_EL1 = 35898,
  BRBINF23_EL1 = 35900,
  BRBSRC23_EL1 = 35901,
  BRBTGT23_EL1 = 35902,
  BRBINF8_EL1 = 35904,
  BRBSRC8_EL1 = 35905,
  BRBTGT8_EL1 = 35906,
  BRBINF24_EL1 = 35908,
  BRBSRC24_EL1 = 35909,
  BRBTGT24_EL1 = 35910,
  BRBINF9_EL1 = 35912,
  BRBSRC9_EL1 = 35913,
  BRBTGT9_EL1 = 35914,
  BRBINF25_EL1 = 35916,
  BRBSRC25_EL1 = 35917,
  BRBTGT25_EL1 = 35918,
  BRBINF10_EL1 = 35920,
  BRBSRC10_EL1 = 35921,
  BRBTGT10_EL1 = 35922,
  BRBINF26_EL1 = 35924,
  BRBSRC26_EL1 = 35925,
  BRBTGT26_EL1 = 35926,
  BRBINF11_EL1 = 35928,
  BRBSRC11_EL1 = 35929,
  BRBTGT11_EL1 = 35930,
  BRBINF27_EL1 = 35932,
  BRBSRC27_EL1 = 35933,
  BRBTGT27_EL1 = 35934,
  BRBINF12_EL1 = 35936,
  BRBSRC12_EL1 = 35937,
  BRBTGT12_EL1 = 35938,
  BRBINF28_EL1 = 35940,
  BRBSRC28_EL1 = 35941,
  BRBTGT28_EL1 = 35942,
  BRBINF13_EL1 = 35944,
  BRBSRC13_EL1 = 35945,
  BRBTGT13_EL1 = 35946,
  BRBINF29_EL1 = 35948,
  BRBSRC29_EL1 = 35949,
  BRBTGT29_EL1 = 35950,
  BRBINF14_EL1 = 35952,
  BRBSRC14_EL1 = 35953,
  BRBTGT14_EL1 = 35954,
  BRBINF30_EL1 = 35956,
  BRBSRC30_EL1 = 35957,
  BRBTGT30_EL1 = 35958,
  BRBINF15_EL1 = 35960,
  BRBSRC15_EL1 = 35961,
  BRBTGT15_EL1 = 35962,
  BRBINF31_EL1 = 35964,
  BRBSRC31_EL1 = 35965,
  BRBTGT31_EL1 = 35966,
  BRBCR_EL1 = 35968,
  BRBFCR_EL1 = 35969,
  BRBTS_EL1 = 35970,
  BRBINFINJ_EL1 = 35976,
  BRBSRCINJ_EL1 = 35977,
  BRBTGTINJ_EL1 = 35978,
  BRBIDR0_EL1 = 35984,
  TEECR32_EL1 = 36864,
  TEEHBR32_EL1 = 36992,
  MDCCSR_EL0 = 38920,
  DBGDTR_EL0 = 38944,
  DBGDTRRX_EL0 = 38952,
  DBGDTRTX_EL0 = 38952,
  SPMCR_EL0 = 40160,
  SPMCNTENSET_EL0 = 40161,
  SPMCNTENCLR_EL0 = 40162,
  SPMOVSCLR_EL0 = 40163,
  SPMZR_EL0 = 40164,
  SPMSELR_EL0 = 40165,
  SPMOVSSET_EL0 = 40179,
  SPMEVCNTR0_EL0 = 40704,
  SPMEVCNTR1_EL0 = 40705,
  SPMEVCNTR2_EL0 = 40706,
  SPMEVCNTR3_EL0 = 40707,
  SPMEVCNTR4_EL0 = 40708,
  SPMEVCNTR5_EL0 = 40709,
  SPMEVCNTR6_EL0 = 40710,
  SPMEVCNTR7_EL0 = 40711,
  SPMEVCNTR8_EL0 = 40712,
  SPMEVCNTR9_EL0 = 40713,
  SPMEVCNTR10_EL0 = 40714,
  SPMEVCNTR11_EL0 = 40715,
  SPMEVCNTR12_EL0 = 40716,
  SPMEVCNTR13_EL0 = 40717,
  SPMEVCNTR14_EL0 = 40718,
  SPMEVCNTR15_EL0 = 40719,
  SPMEVTYPER0_EL0 = 40720,
  SPMEVTYPER1_EL0 = 40721,
  SPMEVTYPER2_EL0 = 40722,
  SPMEVTYPER3_EL0 = 40723,
  SPMEVTYPER4_EL0 = 40724,
  SPMEVTYPER5_EL0 = 40725,
  SPMEVTYPER6_EL0 = 40726,
  SPMEVTYPER7_EL0 = 40727,
  SPMEVTYPER8_EL0 = 40728,
  SPMEVTYPER9_EL0 = 40729,
  SPMEVTYPER10_EL0 = 40730,
  SPMEVTYPER11_EL0 = 40731,
  SPMEVTYPER12_EL0 = 40732,
  SPMEVTYPER13_EL0 = 40733,
  SPMEVTYPER14_EL0 = 40734,
  SPMEVTYPER15_EL0 = 40735,
  SPMEVFILTR0_EL0 = 40736,
  SPMEVFILTR1_EL0 = 40737,
  SPMEVFILTR2_EL0 = 40738,
  SPMEVFILTR3_EL0 = 40739,
  SPMEVFILTR4_EL0 = 40740,
  SPMEVFILTR5_EL0 = 40741,
  SPMEVFILTR6_EL0 = 40742,
  SPMEVFILTR7_EL0 = 40743,
  SPMEVFILTR8_EL0 = 40744,
  SPMEVFILTR9_EL0 = 40745,
  SPMEVFILTR10_EL0 = 40746,
  SPMEVFILTR11_EL0 = 40747,
  SPMEVFILTR12_EL0 = 40748,
  SPMEVFILTR13_EL0 = 40749,
  SPMEVFILTR14_EL0 = 40750,
  SPMEVFILTR15_EL0 = 40751,
  SPMEVFILT2R0_EL0 = 40752,
  SPMEVFILT2R1_EL0 = 40753,
  SPMEVFILT2R2_EL0 = 40754,
  SPMEVFILT2R3_EL0 = 40755,
  SPMEVFILT2R4_EL0 = 40756,
  SPMEVFILT2R5_EL0 = 40757,
  SPMEVFILT2R6_EL0 = 40758,
  SPMEVFILT2R7_EL0 = 40759,
  SPMEVFILT2R8_EL0 = 40760,
  SPMEVFILT2R9_EL0 = 40761,
  SPMEVFILT2R10_EL0 = 40762,
  SPMEVFILT2R11_EL0 = 40763,
  SPMEVFILT2R12_EL0 = 40764,
  SPMEVFILT2R13_EL0 = 40765,
  SPMEVFILT2R14_EL0 = 40766,
  SPMEVFILT2R15_EL0 = 40767,
  DBGVCR32_EL2 = 41016,
  BRBCR_EL2 = 42112,
  SPMACCESSR_EL2 = 42219,
  BRBCR_EL12 = 44160,
  SPMACCESSR_EL12 = 44267,
  SPMACCESSR_EL3 = 46315,
  SPMROOTCR_EL3 = 46327,
  SPMSCR_EL1 = 48375,
  MIDR_EL1 = 49152,
  MPUIR_EL1 = 49156,
  MPIDR_EL1 = 49157,
  REVIDR_EL1 = 49158,
  ID_PFR0_EL1 = 49160,
  ID_PFR1_EL1 = 49161,
  ID_DFR0_EL1 = 49162,
  ID_AFR0_EL1 = 49163,
  ID_MMFR0_EL1 = 49164,
  ID_MMFR1_EL1 = 49165,
  ID_MMFR2_EL1 = 49166,
  ID_MMFR3_EL1 = 49167,
  ID_ISAR0_EL1 = 49168,
  ID_ISAR1_EL1 = 49169,
  ID_ISAR2_EL1 = 49170,
  ID_ISAR3_EL1 = 49171,
  ID_ISAR4_EL1 = 49172,
  ID_ISAR5_EL1 = 49173,
  ID_MMFR4_EL1 = 49174,
  ID_ISAR6_EL1 = 49175,
  MVFR0_EL1 = 49176,
  MVFR1_EL1 = 49177,
  MVFR2_EL1 = 49178,
  ID_PFR2_EL1 = 49180,
  ID_DFR1_EL1 = 49181,
  ID_MMFR5_EL1 = 49182,
  ID_AA64PFR0_EL1 = 49184,
  ID_AA64PFR1_EL1 = 49185,
  ID_AA64PFR2_EL1 = 49186,
  ID_AA64ZFR0_EL1 = 49188,
  ID_AA64SMFR0_EL1 = 49189,
  ID_AA64FPFR0_EL1 = 49191,
  ID_AA64DFR0_EL1 = 49192,
  ID_AA64DFR1_EL1 = 49193,
  ID_AA64DFR2_EL1 = 49194,
  ID_AA64AFR0_EL1 = 49196,
  ID_AA64AFR1_EL1 = 49197,
  ID_AA64ISAR0_EL1 = 49200,
  ID_AA64ISAR1_EL1 = 49201,
  ID_AA64ISAR2_EL1 = 49202,
  ID_AA64ISAR3_EL1 = 49203,
  ID_AA64MMFR0_EL1 = 49208,
  ID_AA64MMFR1_EL1 = 49209,
  ID_AA64MMFR2_EL1 = 49210,
  ID_AA64MMFR3_EL1 = 49211,
  ID_AA64MMFR4_EL1 = 49212,
  SCTLR_EL1 = 49280,
  ACTLR_EL1 = 49281,
  CPACR_EL1 = 49282,
  SCTLR2_EL1 = 49283,
  RGSR_EL1 = 49285,
  GCR_EL1 = 49286,
  ZCR_EL1 = 49296,
  TRFCR_EL1 = 49297,
  TRCITECR_EL1 = 49299,
  SMPRI_EL1 = 49300,
  SMCR_EL1 = 49302,
  TTBR0_EL1 = 49408,
  TTBR1_EL1 = 49409,
  TCR_EL1 = 49410,
  TCR2_EL1 = 49411,
  APIAKeyLo_EL1 = 49416,
  APIAKeyHi_EL1 = 49417,
  APIBKeyLo_EL1 = 49418,
  APIBKeyHi_EL1 = 49419,
  APDAKeyLo_EL1 = 49424,
  APDAKeyHi_EL1 = 49425,
  APDBKeyLo_EL1 = 49426,
  APDBKeyHi_EL1 = 49427,
  APGAKeyLo_EL1 = 49432,
  APGAKeyHi_EL1 = 49433,
  GCSCR_EL1 = 49448,
  GCSPR_EL1 = 49449,
  GCSCRE0_EL1 = 49450,
  SPSR_EL1 = 49664,
  ELR_EL1 = 49665,
  SP_EL0 = 49672,
  SPSel = 49680,
  CurrentEL = 49682,
  PAN = 49683,
  UAO = 49684,
  ALLINT = 49688,
  PM = 49689,
  ICC_PMR_EL1 = 49712,
  AFSR0_EL1 = 49800,
  AFSR1_EL1 = 49801,
  ESR_EL1 = 49808,
  ERRIDR_EL1 = 49816,
  ERRSELR_EL1 = 49817,
  ERXGSR_EL1 = 49818,
  ERXFR_EL1 = 49824,
  ERXCTLR_EL1 = 49825,
  ERXSTATUS_EL1 = 49826,
  ERXADDR_EL1 = 49827,
  ERXPFGF_EL1 = 49828,
  ERXPFGCTL_EL1 = 49829,
  ERXPFGCDN_EL1 = 49830,
  ERXMISC0_EL1 = 49832,
  ERXMISC1_EL1 = 49833,
  ERXMISC2_EL1 = 49834,
  ERXMISC3_EL1 = 49835,
  TFSR_EL1 = 49840,
  TFSRE0_EL1 = 49841,
  FAR_EL1 = 49920,
  PFAR_EL1 = 49925,
  PRENR_EL1 = 49929,
  PRSELR_EL1 = 49937,
  PRBAR_EL1 = 49984,
  PRLAR_EL1 = 49985,
  PRBAR1_EL1 = 49988,
  PRLAR1_EL1 = 49989,
  PRBAR2_EL1 = 49992,
  PRLAR2_EL1 = 49993,
  PRBAR3_EL1 = 49996,
  PRLAR3_EL1 = 49997,
  PRBAR4_EL1 = 50000,
  PRLAR4_EL1 = 50001,
  PRBAR5_EL1 = 50004,
  PRLAR5_EL1 = 50005,
  PRBAR6_EL1 = 50008,
  PRLAR6_EL1 = 50009,
  PRBAR7_EL1 = 50012,
  PRLAR7_EL1 = 50013,
  PRBAR8_EL1 = 50016,
  PRLAR8_EL1 = 50017,
  PRBAR9_EL1 = 50020,
  PRLAR9_EL1 = 50021,
  PRBAR10_EL1 = 50024,
  PRLAR10_EL1 = 50025,
  PRBAR11_EL1 = 50028,
  PRLAR11_EL1 = 50029,
  PRBAR12_EL1 = 50032,
  PRLAR12_EL1 = 50033,
  PRBAR13_EL1 = 50036,
  PRLAR13_EL1 = 50037,
  PRBAR14_EL1 = 50040,
  PRLAR14_EL1 = 50041,
  PRBAR15_EL1 = 50044,
  PRLAR15_EL1 = 50045,
  PAR_EL1 = 50080,
  PMSCR_EL1 = 50376,
  PMSNEVFR_EL1 = 50377,
  PMSICR_EL1 = 50378,
  PMSIRR_EL1 = 50379,
  PMSFCR_EL1 = 50380,
  PMSEVFR_EL1 = 50381,
  PMSLATFR_EL1 = 50382,
  PMSIDR_EL1 = 50383,
  PMBLIMITR_EL1 = 50384,
  PMBPTR_EL1 = 50385,
  PMBSR_EL1 = 50387,
  PMSDSFR_EL1 = 50388,
  PMBIDR_EL1 = 50391,
  TRBLIMITR_EL1 = 50392,
  TRBPTR_EL1 = 50393,
  TRBBASER_EL1 = 50394,
  TRBSR_EL1 = 50395,
  TRBMAR_EL1 = 50396,
  TRBTRG_EL1 = 50398,
  TRBIDR_EL1 = 50399,
  PMSSCR_EL1 = 50411,
  PMINTENSET_EL1 = 50417,
  PMINTENCLR_EL1 = 50418,
  PMUACR_EL1 = 50420,
  PMECR_EL1 = 50421,
  PMMIR_EL1 = 50422,
  PMIAR_EL1 = 50423,
  MAIR_EL1 = 50448,
  MAIR2_EL1 = 50449,
  PIRE0_EL1 = 50450,
  PIR_EL1 = 50451,
  POR_EL1 = 50452,
  S2POR_EL1 = 50453,
  AMAIR_EL1 = 50456,
  AMAIR2_EL1 = 50457,
  LORSA_EL1 = 50464,
  LOREA_EL1 = 50465,
  LORN_EL1 = 50466,
  LORC_EL1 = 50467,
  MPAMIDR_EL1 = 50468,
  LORID_EL1 = 50471,
  MPAM1_EL1 = 50472,
  MPAM0_EL1 = 50473,
  MPAMSM_EL1 = 50475,
  VBAR_EL1 = 50688,
  RVBAR_EL1 = 50689,
  RMR_EL1 = 50690,
  ISR_EL1 = 50696,
  DISR_EL1 = 50697,
  ICC_IAR0_EL1 = 50752,
  ICC_EOIR0_EL1 = 50753,
  ICC_HPPIR0_EL1 = 50754,
  ICC_BPR0_EL1 = 50755,
  ICC_AP0R0_EL1 = 50756,
  ICC_AP0R1_EL1 = 50757,
  ICC_AP0R2_EL1 = 50758,
  ICC_AP0R3_EL1 = 50759,
  ICC_AP1R0_EL1 = 50760,
  ICC_AP1R1_EL1 = 50761,
  ICC_AP1R2_EL1 = 50762,
  ICC_AP1R3_EL1 = 50763,
  ICC_NMIAR1_EL1 = 50765,
  ICC_DIR_EL1 = 50777,
  ICC_RPR_EL1 = 50779,
  ICC_SGI1R_EL1 = 50781,
  ICC_ASGI1R_EL1 = 50782,
  ICC_SGI0R_EL1 = 50783,
  ICC_IAR1_EL1 = 50784,
  ICC_EOIR1_EL1 = 50785,
  ICC_HPPIR1_EL1 = 50786,
  ICC_BPR1_EL1 = 50787,
  ICC_CTLR_EL1 = 50788,
  ICC_SRE_EL1 = 50789,
  ICC_IGRPEN0_EL1 = 50790,
  ICC_IGRPEN1_EL1 = 50791,
  CONTEXTIDR_EL1 = 50817,
  RCWSMASK_EL1 = 50819,
  TPIDR_EL1 = 50820,
  ACCDATA_EL1 = 50821,
  RCWMASK_EL1 = 50822,
  SCXTNUM_EL1 = 50823,
  CNTKCTL_EL1 = 50952,
  CCSIDR_EL1 = 51200,
  CLIDR_EL1 = 51201,
  CCSIDR2_EL1 = 51202,
  GMID_EL1 = 51204,
  SMIDR_EL1 = 51206,
  AIDR_EL1 = 51207,
  CSSELR_EL1 = 53248,
  CTR_EL0 = 55297,
  DCZID_EL0 = 55303,
  RNDR = 55584,
  RNDRRS = 55585,
  GCSPR_EL0 = 55593,
  NZCV = 55824,
  DAIF = 55825,
  SVCR = 55826,
  DIT = 55829,
  SSBS = 55830,
  TCO = 55831,
  FPCR = 55840,
  FPSR = 55841,
  FPMR = 55842,
  DSPSR_EL0 = 55848,
  DLR_EL0 = 55849,
  PMICNTR_EL0 = 56480,
  PMICFILTR_EL0 = 56496,
  PMCR_EL0 = 56544,
  PMCNTENSET_EL0 = 56545,
  PMCNTENCLR_EL0 = 56546,
  PMOVSCLR_EL0 = 56547,
  PMSWINC_EL0 = 56548,
  PMSELR_EL0 = 56549,
  PMCEID0_EL0 = 56550,
  PMCEID1_EL0 = 56551,
  PMCCNTR_EL0 = 56552,
  PMXEVTYPER_EL0 = 56553,
  PMXEVCNTR_EL0 = 56554,
  PMZR_EL0 = 56556,
  PMUSERENR_EL0 = 56560,
  PMOVSSET_EL0 = 56563,
  POR_EL0 = 56596,
  TPIDR_EL0 = 56962,
  TPIDRRO_EL0 = 56963,
  TPIDR2_EL0 = 56965,
  SCXTNUM_EL0 = 56967,
  AMCR_EL0 = 56976,
  AMCFGR_EL0 = 56977,
  AMCGCR_EL0 = 56978,
  AMUSERENR_EL0 = 56979,
  AMCNTENCLR0_EL0 = 56980,
  AMCNTENSET0_EL0 = 56981,
  AMCG1IDR_EL0 = 56982,
  AMCNTENCLR1_EL0 = 56984,
  AMCNTENSET1_EL0 = 56985,
  AMEVCNTR00_EL0 = 56992,
  AMEVCNTR01_EL0 = 56993,
  AMEVCNTR02_EL0 = 56994,
  AMEVCNTR03_EL0 = 56995,
  AMEVTYPER00_EL0 = 57008,
  AMEVTYPER01_EL0 = 57009,
  AMEVTYPER02_EL0 = 57010,
  AMEVTYPER03_EL0 = 57011,
  AMEVCNTR10_EL0 = 57056,
  AMEVCNTR11_EL0 = 57057,
  AMEVCNTR12_EL0 = 57058,
  AMEVCNTR13_EL0 = 57059,
  AMEVCNTR14_EL0 = 57060,
  AMEVCNTR15_EL0 = 57061,
  AMEVCNTR16_EL0 = 57062,
  AMEVCNTR17_EL0 = 57063,
  AMEVCNTR18_EL0 = 57064,
  AMEVCNTR19_EL0 = 57065,
  AMEVCNTR110_EL0 = 57066,
  AMEVCNTR111_EL0 = 57067,
  AMEVCNTR112_EL0 = 57068,
  AMEVCNTR113_EL0 = 57069,
  AMEVCNTR114_EL0 = 57070,
  AMEVCNTR115_EL0 = 57071,
  AMEVTYPER10_EL0 = 57072,
  AMEVTYPER11_EL0 = 57073,
  AMEVTYPER12_EL0 = 57074,
  AMEVTYPER13_EL0 = 57075,
  AMEVTYPER14_EL0 = 57076,
  AMEVTYPER15_EL0 = 57077,
  AMEVTYPER16_EL0 = 57078,
  AMEVTYPER17_EL0 = 57079,
  AMEVTYPER18_EL0 = 57080,
  AMEVTYPER19_EL0 = 57081,
  AMEVTYPER110_EL0 = 57082,
  AMEVTYPER111_EL0 = 57083,
  AMEVTYPER112_EL0 = 57084,
  AMEVTYPER113_EL0 = 57085,
  AMEVTYPER114_EL0 = 57086,
  AMEVTYPER115_EL0 = 57087,
  CNTFRQ_EL0 = 57088,
  CNTPCT_EL0 = 57089,
  CNTVCT_EL0 = 57090,
  CNTPCTSS_EL0 = 57093,
  CNTVCTSS_EL0 = 57094,
  CNTP_TVAL_EL0 = 57104,
  CNTP_CTL_EL0 = 57105,
  CNTP_CVAL_EL0 = 57106,
  CNTV_TVAL_EL0 = 57112,
  CNTV_CTL_EL0 = 57113,
  CNTV_CVAL_EL0 = 57114,
  PMEVCNTR0_EL0 = 57152,
  PMEVCNTR1_EL0 = 57153,
  PMEVCNTR2_EL0 = 57154,
  PMEVCNTR3_EL0 = 57155,
  PMEVCNTR4_EL0 = 57156,
  PMEVCNTR5_EL0 = 57157,
  PMEVCNTR6_EL0 = 57158,
  PMEVCNTR7_EL0 = 57159,
  PMEVCNTR8_EL0 = 57160,
  PMEVCNTR9_EL0 = 57161,
  PMEVCNTR10_EL0 = 57162,
  PMEVCNTR11_EL0 = 57163,
  PMEVCNTR12_EL0 = 57164,
  PMEVCNTR13_EL0 = 57165,
  PMEVCNTR14_EL0 = 57166,
  PMEVCNTR15_EL0 = 57167,
  PMEVCNTR16_EL0 = 57168,
  PMEVCNTR17_EL0 = 57169,
  PMEVCNTR18_EL0 = 57170,
  PMEVCNTR19_EL0 = 57171,
  PMEVCNTR20_EL0 = 57172,
  PMEVCNTR21_EL0 = 57173,
  PMEVCNTR22_EL0 = 57174,
  PMEVCNTR23_EL0 = 57175,
  PMEVCNTR24_EL0 = 57176,
  PMEVCNTR25_EL0 = 57177,
  PMEVCNTR26_EL0 = 57178,
  PMEVCNTR27_EL0 = 57179,
  PMEVCNTR28_EL0 = 57180,
  PMEVCNTR29_EL0 = 57181,
  PMEVCNTR30_EL0 = 57182,
  PMEVTYPER0_EL0 = 57184,
  PMEVTYPER1_EL0 = 57185,
  PMEVTYPER2_EL0 = 57186,
  PMEVTYPER3_EL0 = 57187,
  PMEVTYPER4_EL0 = 57188,
  PMEVTYPER5_EL0 = 57189,
  PMEVTYPER6_EL0 = 57190,
  PMEVTYPER7_EL0 = 57191,
  PMEVTYPER8_EL0 = 57192,
  PMEVTYPER9_EL0 = 57193,
  PMEVTYPER10_EL0 = 57194,
  PMEVTYPER11_EL0 = 57195,
  PMEVTYPER12_EL0 = 57196,
  PMEVTYPER13_EL0 = 57197,
  PMEVTYPER14_EL0 = 57198,
  PMEVTYPER15_EL0 = 57199,
  PMEVTYPER16_EL0 = 57200,
  PMEVTYPER17_EL0 = 57201,
  PMEVTYPER18_EL0 = 57202,
  PMEVTYPER19_EL0 = 57203,
  PMEVTYPER20_EL0 = 57204,
  PMEVTYPER21_EL0 = 57205,
  PMEVTYPER22_EL0 = 57206,
  PMEVTYPER23_EL0 = 57207,
  PMEVTYPER24_EL0 = 57208,
  PMEVTYPER25_EL0 = 57209,
  PMEVTYPER26_EL0 = 57210,
  PMEVTYPER27_EL0 = 57211,
  PMEVTYPER28_EL0 = 57212,
  PMEVTYPER29_EL0 = 57213,
  PMEVTYPER30_EL0 = 57214,
  PMCCFILTR_EL0 = 57215,
  VPIDR_EL2 = 57344,
  MPUIR_EL2 = 57348,
  VMPIDR_EL2 = 57349,
  SCTLR_EL2 = 57472,
  ACTLR_EL2 = 57473,
  SCTLR2_EL2 = 57475,
  HCR_EL2 = 57480,
  MDCR_EL2 = 57481,
  CPTR_EL2 = 57482,
  HSTR_EL2 = 57483,
  HFGRTR_EL2 = 57484,
  HFGWTR_EL2 = 57485,
  HFGITR_EL2 = 57486,
  HACR_EL2 = 57487,
  ZCR_EL2 = 57488,
  TRFCR_EL2 = 57489,
  HCRX_EL2 = 57490,
  TRCITECR_EL2 = 57491,
  SMPRIMAP_EL2 = 57493,
  SMCR_EL2 = 57494,
  SDER32_EL2 = 57497,
  TTBR0_EL2 = 57600,
  VSCTLR_EL2 = 57600,
  TTBR1_EL2 = 57601,
  TCR_EL2 = 57602,
  TCR2_EL2 = 57603,
  VTTBR_EL2 = 57608,
  VTCR_EL2 = 57610,
  VNCR_EL2 = 57616,
  HDBSSBR_EL2 = 57626,
  HDBSSPROD_EL2 = 57627,
  HACDBSBR_EL2 = 57628,
  HACDBSCONS_EL2 = 57629,
  GCSCR_EL2 = 57640,
  GCSPR_EL2 = 57641,
  VSTTBR_EL2 = 57648,
  VSTCR_EL2 = 57650,
  DACR32_EL2 = 57728,
  HDFGRTR2_EL2 = 57736,
  HDFGWTR2_EL2 = 57737,
  HFGRTR2_EL2 = 57738,
  HFGWTR2_EL2 = 57739,
  HDFGRTR_EL2 = 57740,
  HDFGWTR_EL2 = 57741,
  HAFGRTR_EL2 = 57742,
  HFGITR2_EL2 = 57743,
  SPSR_EL2 = 57856,
  ELR_EL2 = 57857,
  SP_EL1 = 57864,
  SPSR_irq = 57880,
  SPSR_abt = 57881,
  SPSR_und = 57882,
  SPSR_fiq = 57883,
  IFSR32_EL2 = 57985,
  AFSR0_EL2 = 57992,
  AFSR1_EL2 = 57993,
  ESR_EL2 = 58000,
  VSESR_EL2 = 58003,
  FPEXC32_EL2 = 58008,
  TFSR_EL2 = 58032,
  FAR_EL2 = 58112,
  HPFAR_EL2 = 58116,
  PFAR_EL2 = 58117,
  PRENR_EL2 = 58121,
  PRSELR_EL2 = 58129,
  PRBAR_EL2 = 58176,
  PRLAR_EL2 = 58177,
  PRBAR1_EL2 = 58180,
  PRLAR1_EL2 = 58181,
  PRBAR2_EL2 = 58184,
  PRLAR2_EL2 = 58185,
  PRBAR3_EL2 = 58188,
  PRLAR3_EL2 = 58189,
  PRBAR4_EL2 = 58192,
  PRLAR4_EL2 = 58193,
  PRBAR5_EL2 = 58196,
  PRLAR5_EL2 = 58197,
  PRBAR6_EL2 = 58200,
  PRLAR6_EL2 = 58201,
  PRBAR7_EL2 = 58204,
  PRLAR7_EL2 = 58205,
  PRBAR8_EL2 = 58208,
  PRLAR8_EL2 = 58209,
  PRBAR9_EL2 = 58212,
  PRLAR9_EL2 = 58213,
  PRBAR10_EL2 = 58216,
  PRLAR10_EL2 = 58217,
  PRBAR11_EL2 = 58220,
  PRLAR11_EL2 = 58221,
  PRBAR12_EL2 = 58224,
  PRLAR12_EL2 = 58225,
  PRBAR13_EL2 = 58228,
  PRLAR13_EL2 = 58229,
  PRBAR14_EL2 = 58232,
  PRLAR14_EL2 = 58233,
  PRBAR15_EL2 = 58236,
  PRLAR15_EL2 = 58237,
  PMSCR_EL2 = 58568,
  MAIR2_EL2 = 58633,
  MAIR_EL2 = 58640,
  PIRE0_EL2 = 58642,
  PIR_EL2 = 58643,
  POR_EL2 = 58644,
  S2PIR_EL2 = 58645,
  AMAIR_EL2 = 58648,
  AMAIR2_EL2 = 58649,
  MPAMHCR_EL2 = 58656,
  MPAMVPMV_EL2 = 58657,
  MPAM2_EL2 = 58664,
  MPAMVPM0_EL2 = 58672,
  MPAMVPM1_EL2 = 58673,
  MPAMVPM2_EL2 = 58674,
  MPAMVPM3_EL2 = 58675,
  MPAMVPM4_EL2 = 58676,
  MPAMVPM5_EL2 = 58677,
  MPAMVPM6_EL2 = 58678,
  MPAMVPM7_EL2 = 58679,
  MECID_P0_EL2 = 58688,
  MECID_A0_EL2 = 58689,
  MECID_P1_EL2 = 58690,
  MECID_A1_EL2 = 58691,
  MECIDR_EL2 = 58695,
  VMECID_P_EL2 = 58696,
  VMECID_A_EL2 = 58697,
  VBAR_EL2 = 58880,
  RVBAR_EL2 = 58881,
  RMR_EL2 = 58882,
  VDISR_EL2 = 58889,
  ICH_AP0R0_EL2 = 58944,
  ICH_AP0R1_EL2 = 58945,
  ICH_AP0R2_EL2 = 58946,
  ICH_AP0R3_EL2 = 58947,
  ICH_AP1R0_EL2 = 58952,
  ICH_AP1R1_EL2 = 58953,
  ICH_AP1R2_EL2 = 58954,
  ICH_AP1R3_EL2 = 58955,
  ICC_SRE_EL2 = 58957,
  ICH_HCR_EL2 = 58968,
  ICH_VTR_EL2 = 58969,
  ICH_MISR_EL2 = 58970,
  ICH_EISR_EL2 = 58971,
  ICH_ELRSR_EL2 = 58973,
  ICH_VMCR_EL2 = 58975,
  ICH_LR0_EL2 = 58976,
  ICH_LR1_EL2 = 58977,
  ICH_LR2_EL2 = 58978,
  ICH_LR3_EL2 = 58979,
  ICH_LR4_EL2 = 58980,
  ICH_LR5_EL2 = 58981,
  ICH_LR6_EL2 = 58982,
  ICH_LR7_EL2 = 58983,
  ICH_LR8_EL2 = 58984,
  ICH_LR9_EL2 = 58985,
  ICH_LR10_EL2 = 58986,
  ICH_LR11_EL2 = 58987,
  ICH_LR12_EL2 = 58988,
  ICH_LR13_EL2 = 58989,
  ICH_LR14_EL2 = 58990,
  ICH_LR15_EL2 = 58991,
  CONTEXTIDR_EL2 = 59009,
  TPIDR_EL2 = 59010,
  SCXTNUM_EL2 = 59015,
  AMEVCNTVOFF00_EL2 = 59072,
  AMEVCNTVOFF01_EL2 = 59073,
  AMEVCNTVOFF02_EL2 = 59074,
  AMEVCNTVOFF03_EL2 = 59075,
  AMEVCNTVOFF04_EL2 = 59076,
  AMEVCNTVOFF05_EL2 = 59077,
  AMEVCNTVOFF06_EL2 = 59078,
  AMEVCNTVOFF07_EL2 = 59079,
  AMEVCNTVOFF08_EL2 = 59080,
  AMEVCNTVOFF09_EL2 = 59081,
  AMEVCNTVOFF010_EL2 = 59082,
  AMEVCNTVOFF011_EL2 = 59083,
  AMEVCNTVOFF012_EL2 = 59084,
  AMEVCNTVOFF013_EL2 = 59085,
  AMEVCNTVOFF014_EL2 = 59086,
  AMEVCNTVOFF015_EL2 = 59087,
  AMEVCNTVOFF10_EL2 = 59088,
  AMEVCNTVOFF11_EL2 = 59089,
  AMEVCNTVOFF12_EL2 = 59090,
  AMEVCNTVOFF13_EL2 = 59091,
  AMEVCNTVOFF14_EL2 = 59092,
  AMEVCNTVOFF15_EL2 = 59093,
  AMEVCNTVOFF16_EL2 = 59094,
  AMEVCNTVOFF17_EL2 = 59095,
  AMEVCNTVOFF18_EL2 = 59096,
  AMEVCNTVOFF19_EL2 = 59097,
  AMEVCNTVOFF110_EL2 = 59098,
  AMEVCNTVOFF111_EL2 = 59099,
  AMEVCNTVOFF112_EL2 = 59100,
  AMEVCNTVOFF113_EL2 = 59101,
  AMEVCNTVOFF114_EL2 = 59102,
  AMEVCNTVOFF115_EL2 = 59103,
  CNTVOFF_EL2 = 59139,
  CNTSCALE_EL2 = 59140,
  CNTISCALE_EL2 = 59141,
  CNTPOFF_EL2 = 59142,
  CNTVFRQ_EL2 = 59143,
  CNTHCTL_EL2 = 59144,
  CNTHP_TVAL_EL2 = 59152,
  CNTHP_CTL_EL2 = 59153,
  CNTHP_CVAL_EL2 = 59154,
  CNTHV_TVAL_EL2 = 59160,
  CNTHV_CTL_EL2 = 59161,
  CNTHV_CVAL_EL2 = 59162,
  CNTHVS_TVAL_EL2 = 59168,
  CNTHVS_CTL_EL2 = 59169,
  CNTHVS_CVAL_EL2 = 59170,
  CNTHPS_TVAL_EL2 = 59176,
  CNTHPS_CTL_EL2 = 59177,
  CNTHPS_CVAL_EL2 = 59178,
  SCTLR_EL12 = 59520,
  CPACR_EL12 = 59522,
  SCTLR2_EL12 = 59523,
  ZCR_EL12 = 59536,
  TRFCR_EL12 = 59537,
  TRCITECR_EL12 = 59539,
  SMCR_EL12 = 59542,
  TTBR0_EL12 = 59648,
  TTBR1_EL12 = 59649,
  TCR_EL12 = 59650,
  TCR2_EL12 = 59651,
  GCSCR_EL12 = 59688,
  GCSPR_EL12 = 59689,
  SPSR_EL12 = 59904,
  ELR_EL12 = 59905,
  AFSR0_EL12 = 60040,
  AFSR1_EL12 = 60041,
  ESR_EL12 = 60048,
  TFSR_EL12 = 60080,
  FAR_EL12 = 60160,
  PFAR_EL12 = 60165,
  PMSCR_EL12 = 60616,
  MAIR_EL12 = 60688,
  MAIR2_EL12 = 60689,
  PIRE0_EL12 = 60690,
  PIR_EL12 = 60691,
  POR_EL12 = 60692,
  AMAIR_EL12 = 60696,
  AMAIR2_EL12 = 60697,
  MPAM1_EL12 = 60712,
  VBAR_EL12 = 60928,
  CONTEXTIDR_EL12 = 61057,
  SCXTNUM_EL12 = 61063,
  CNTKCTL_EL12 = 61192,
  CNTP_TVAL_EL02 = 61200,
  CNTP_CTL_EL02 = 61201,
  CNTP_CVAL_EL02 = 61202,
  CNTV_TVAL_EL02 = 61208,
  CNTV_CTL_EL02 = 61209,
  CNTV_CVAL_EL02 = 61210,
  SCTLR_EL3 = 61568,
  ACTLR_EL3 = 61569,
  SCTLR2_EL3 = 61571,
  SCR_EL3 = 61576,
  SDER32_EL3 = 61577,
  CPTR_EL3 = 61578,
  FGWTE3_EL3 = 61581,
  ZCR_EL3 = 61584,
  SMCR_EL3 = 61590,
  MDCR_EL3 = 61593,
  TTBR0_EL3 = 61696,
  TCR_EL3 = 61698,
  GPTBR_EL3 = 61708,
  GPCCR_EL3 = 61710,
  GCSCR_EL3 = 61736,
  GCSPR_EL3 = 61737,
  SPSR_EL3 = 61952,
  ELR_EL3 = 61953,
  SP_EL2 = 61960,
  AFSR0_EL3 = 62088,
  AFSR1_EL3 = 62089,
  ESR_EL3 = 62096,
  VSESR_EL3 = 62099,
  TFSR_EL3 = 62128,
  FAR_EL3 = 62208,
  MFAR_EL3 = 62213,
  MAIR2_EL3 = 62729,
  MAIR_EL3 = 62736,
  PIR_EL3 = 62739,
  POR_EL3 = 62740,
  AMAIR_EL3 = 62744,
  AMAIR2_EL3 = 62745,
  MPAM3_EL3 = 62760,
  MECID_RL_A_EL3 = 62801,
  VBAR_EL3 = 62976,
  RVBAR_EL3 = 62977,
  RMR_EL3 = 62978,
  VDISR_EL3 = 62985,
  ICC_CTLR_EL3 = 63076,
  ICC_SRE_EL3 = 63077,
  ICC_IGRPEN1_EL3 = 63079,
  TPIDR_EL3 = 63106,
  SCXTNUM_EL3 = 63111,
  CNTPS_TVAL_EL1 = 65296,
  CNTPS_CTL_EL1 = 65297,
  CNTPS_CVAL_EL1 = 65298,
  CPM_IOACC_CTL_EL3 = 65424,
  NUM_TARGET_SYSREGS = 1213,
};
}
}
}
#endif
