/* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

/*! \file message.h 
	\brief Plik zawiera deklarację klasy komunikatów
*/

#ifndef __LW_MESSAGE_H
#define __LW_MESSAGE_H

#include "piece.h"

enum LWMsg {
	LW_INFO_ProgramInterrupted=0,
	LW_ERROR_WrongNumberOfArguments,
	LW_ERROR_LValueIsNotVariable,
	LW_ERROR_UnmatchedBrace,
	LW_ERROR_EmptyBrace,
	LW_ERROR_BadString,
	LW_ERROR_DivisionByZero,
	LW_ERROR_BadIndexOfArray,
	LW_ERROR_ForButWhereIsToOrDownto,
	LW_ERROR_ToButWhereIsFor,
	LW_ERROR_DowntoButWhereIsFor,
	LW_ERROR_RepeatButWhereIsUntil,
	LW_ERROR_UntilButWhereIsRepeat,
	LW_ERROR_NeedVariableAsArgument,
	LW_ERROR_IsNotArray,
	LW_ERROR_IndexOutOfRange,
	LW_ERROR_BreakNotInALoop,
	LW_ERROR_ContinueNotInALoop,
	LW_ERROR_ElseButWhereIsIf,
	LW_ERROR_StepButWhereIsFor,
	LW_ERROR_PleaseSpecifyStep,
	LW_ERROR_NumberOutOfRange,
	LW_ERROR_DontUseSpecial,
	LW_ERROR_BeginProgramWithCommand
};

class LWProgram;

/*! \class LWMessage
	\brief Klasa komunikatu

	Obiekty tej klasy są rzucane jako wyjątki podczas analizy i interpretacji kodu
*/

class LWMessage {
private:
LWMsg message;
LWPiece *piece;
LWProgram *program;
public:
LWMessage (LWMsg a_message);
void setPiece (LWPiece *a_piece);
void show ();
guint getId (); 	
};

#endif
