/* ----- encode/953xint16, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_953xint16_checksums[] = {
  "b85dffbe410d5d88bd60d7ea927e051ce0795e26b2524a9e8abefda128a92e7e",
  "7b1c952f6e7c01227dbbe8e0418cc4d5ea1860eba1f27166cdd9ba5af60586f9",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_953xint16_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_953xint16_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_953xint16_ITEMBYTES

static void *storage_encode_953xint16_s;
static unsigned char *test_encode_953xint16_s;
static void *storage_encode_953xint16_x;
static unsigned char *test_encode_953xint16_x;
static void *storage_encode_953xint16_s2;
static unsigned char *test_encode_953xint16_s2;
static void *storage_encode_953xint16_x2;
static unsigned char *test_encode_953xint16_x2;

#define precomputed_encode_953xint16_NUM 4

static const unsigned char precomputed_encode_953xint16_s[precomputed_encode_953xint16_NUM][crypto_encode_STRBYTES] = {
  {142,66,99,203,191,57,39,173,13,9,248,209,40,43,242,50,201,126,61,105,54,114,146,173,59,165,226,217,223,238,35,15,145,184,25,164,78,150,123,199,82,1,80,235,255,61,6,233,47,56,171,2,15,99,166,26,98,99,241,167,102,139,30,107,183,48,216,115,237,239,120,195,71,67,221,131,105,152,86,93,41,39,121,140,36,242,149,36,64,54,228,68,245,206,21,49,81,223,95,221,230,179,142,176,110,209,7,30,29,133,223,77,155,112,30,253,50,68,245,167,217,166,67,24,186,170,158,158,218,226,113,109,31,148,154,83,157,219,209,194,129,140,75,191,56,174,132,251,212,226,160,135,181,153,181,51,91,211,35,45,243,103,171,58,223,29,29,109,189,13,117,231,218,156,188,134,152,16,249,237,32,63,185,112,117,49,208,48,20,217,211,56,134,212,92,98,63,19,143,172,174,191,87,197,14,85,220,166,19,251,212,204,122,73,164,84,20,162,90,22,99,48,220,163,228,132,249,225,232,86,1,169,126,94,169,103,148,158,180,223,199,227,177,78,125,153,252,220,11,252,12,98,49,77,94,214,45,2,223,120,197,106,101,19,157,227,162,158,166,15,222,233,7,56,131,40,157,110,226,113,144,153,194,241,26,37,141,149,89,198,90,83,115,94,44,39,218,103,81,175,72,230,156,137,84,27,92,159,196,17,20,185,174,216,209,197,157,54,124,184,2,185,53,240,213,156,8,201,30,119,163,236,210,241,30,212,147,207,139,43,235,186,98,44,167,103,182,89,207,158,94,105,1,81,135,204,106,111,148,30,25,231,192,41,139,99,241,124,178,180,19,54,24,135,230,81,97,24,47,14,44,125,178,182,67,224,193,215,78,106,23,92,42,130,60,46,23,119,240,121,236,138,79,128,65,80,209,14,16,106,158,251,64,9,223,253,182,208,167,232,32,11,99,198,195,194,26,87,243,252,240,10,136,177,59,223,192,97,248,57,95,118,15,161,170,244,35,39,104,184,206,250,28,190,107,82,72,23,86,136,177,50,5,249,128,103,229,245,112,9,184,55,99,143,252,161,75,240,230,69,44,151,13,235,204,74,245,92,170,81,227,159,142,2,202,25,101,51,232,113,18,131,63,3,214,190,210,166,13,41,211,54,101,228,167,92,150,229,138,147,219,254,168,87,72,111,189,147,17,82,205,88,164,224,5,139,200,103,41,130,156,142,51,134,161,135,196,207,196,51,78,2,220,68,36,173,145,213,218,101,167,218,188,94,190,58,198,235,181,198,144,47,105,109,192,48,162,144,154,108,169,193,92,245,12,55,112,13,41,255,238,205,243,13,147,183,75,213,7,57,39,45,102,111,58,191,57,183,188,202,40,23,203,103,129,229,247,230,245,25,55,156,54,1,190,98,247,124,28,11,154,184,195,203,239,32,68,83,42,222,152,72,158,184,203,60,149,204,218,178,11,128,203,138,85,246,143,84,122,246,171,125,222,235,147,53,150,136,191,51,67,187,26,220,219,115,77,33,79,20,167,235,10,34,253,216,157,118,38,91,118,129,240,46,142,106,240,83,90,57,93,85,21,1,22,138,33,232,55,227,32,56,153,12,182,65,196,86,101,215,158,145,253,16,5,33,128,145,162,220,154,205,156,161,203,240,135,214,246,89,206,174,57,181,124,107,111,200,243,221,79,209,123,223,161,50,77,108,65,119,1,83,176,241,165,124,74,80,59,94,52,107,65,193,191,136,202,151,244,128,55,194,17,230,19,120,223,121,107,253,121,90,5,139,207,205,247,77,143,159,20,199,129,30,124,184,175,228,67,115,7,192,96,28,232,12,106,92,27,99,204,247,40,237,59,46,246,134,197,82,28,233,78,66,203,182,32,27,193,71,64,20,182,125,72,53,175,216,205,85,172,77,196,58,117,14,78,172,53,82,156,156,177,136,228,174,197,84,162,38,80,247,134,196,131,229,135,214,6,41,115,234,10,213,77,183,13,10,95,254,242,111,96,223,91,40,62,127,184,145,88,102,198,200,149,195,96,110,106,184,235,117,51,40,69,7,94,186,105,109,26,51,182,195,223,238,191,60,189,118,46,246,129,151,14,201,202,213,234,81,165,114,219,238,116,250,52,77,17,119,177,222,71,82,199,93,0,199,247,98,236,176,238,32,221,226,29,172,45,186,14,202,152,242,83,169,167,163,98,58,134,143,162,176,29,24,24,131,167,1,18,32,240,125,75,154,96,16,64,144,102,49,166,132,38,239,51,24,74,114,13,230,20,71,89,76,209,200,23,48,158,29,5,157,56,154,255,113,121,3,141,229,150,81,93,101,181,208,81,217,215,250,236,152,120,216,108,203,140,202,84,190,11,3,116,164,28,167,180,220,167,33,255,80,72,199,23,247,115,82,253,90,244,209,51,120,243,167,11,71,135,206,207,61,227,24,53,43,201,176,69,48,97,133,105,121,237,189,38,173,38,47,192,219,159,138,73,47,38,241,206,147,149,174,129,55,53,188,103,86,223,219,146,185,113,172,248,195,10,172,97,61,135,22,53,148,81,94,128,129,252,216,67,20,182,239,229,254,22,114,0,4,234,255,0,3,219,134,228,160,130,90,49,171,54,86,88,90,144,44,111,145,117,113,64,137,72,82,76,127,182,182,41,131,46,36,100,65,237,233,80,72,155,94,204,142,234,253,126,59,133,7,149,87,193,251,141,200,19,147,68,27,17,68,94,98,229,64,3,218,122,70,54,9,196,142,12,226,94,37,251,35,50,126,83,132,198,24,36,214,140,235,238,145,12,103,107,22,18,1,106,105,156,89,234,47,186,27,208,151,253,199,180,84,25,125,151,204,134,157,94,89,238,88,28,81,197,244,17,74,107,25,204,204,40,115,87,23,42,122,9,137,21,212,246,189,79,129,125,163,162,160,14,206,36,79,61,141,151,106,210,233,76,163,41,177,106,253,23,175,6,225,89,81,40,158,157,60,206,75,118,182,184,205,110,183,180,76,120,201,225,125,223,55,28,19,104,182,171,51,202,195,39,229,132,195,73,185,92,177,21,255,25,42,137,47,62,29,8,21,54,210,73,99,80,133,1,133,84,120,65,15,220,115,239,126,239,55,18,107,78,249,85,63,205,73,24,45,202,73,254,81,94,96,184,177,131,28,212,98,64,180,138,158,117,219,240,134,248,163,140,18,29,214,188,28,98,144,228,164,239,10,141,159,191,118,123,161,46,150,54,28,37,67,109,177,45,88,199,44,209,230,108,51,230,108,171,130,155,150,217,166,159,210,156,186,71,137,37,192,26,169,32,114,123,169,204,7,75,2,246,248,55,31,130,231,207,151,46,199,215,24,115,207,60,52,127,215,245,204,96,167,152,244,186,121,12,85,141,8,95,129,239,66,9,98,82,255,197,111,7,131,214,44,78,158,208,137,10,158,167,56,165,153,162,22,179,98,241,144,186,248,68,66,102,228,184,78,118,214,94,216,236,37,219,242,92,138,96,58,180,24,171,180,245,13,50,252,39,121,11,204,85,119,68,142,212,247,39,70,126,190,238,116,163,216,80,201,141,45,39,21,219,120,236,87,113,240,26,247,161,32,68,3,112,151,38,114,126,219,134,63,108,219,35,188,98,182,235,244,175,254,182,55,250,91,156,219,196,34,142,164,41,35,57,251,234,228,222,137,173,57,57,121,111,217,4,69,50,117,239,132,125,92,243,96,230,213,225,133,230,106,162,47,158,68,226,228,98,217,141,190,80,87,250,254,100,226,29,33,223,181,132,99,116,33,141,57,59,46,71,245,158,150,59,62,19,180,124,193,249,48,97,234,23,20,168,202,242,241,91,212,199,156,131,117,153,19,74,107,110,60,113,233,83,96,90,31,12,101,9,235,110,76,90,180,68,240,79,67,66,254,142,132,50,101,204,226,216,146,107,198,251,19,8,158,216,161,35,177,43,111,209,130,4,99,151,6,142,16,51,110,148,226,198,225,144,218,82,26,148,179,166,124,9,224,161,159,253,219,134,243,74,159,11,103,82,200,45,155,147,170,58,85,11,75,249,82,6,138,124,149,147,159,147,75,26,220,122,209,78,198,66,227,161,194,162,6,242,81,143,37,226,24,64,122,8,198,62,163,74,234,124,86,235,253,91,72,123,90,184,218,71,69,159,193,101,224,63,144,240,21,44,135,89,134,163,177,247,251,63,6,221,114,192,54,63,199,54,212,215,52,204,47,5,135,35,45,171,166,45,96,188,170,66,105,101,109,163,156,161,50,254,83,73,164},
  {89,2,151,167,27,28,67,100,35,187,55,117,75,75,177,104,103,47,15,11,177,71,116,236,18,217,32,157,58,159,118,106,8,13,192,101,72,222,24,104,162,54,34,125,107,164,134,57,97,182,164,25,96,147,197,119,51,41,101,55,154,197,244,60,90,18,64,52,144,76,66,121,69,30,213,206,3,33,20,95,148,20,246,35,44,103,111,84,104,44,181,169,18,71,254,161,34,151,175,3,68,91,254,128,92,162,26,190,33,117,54,16,99,107,252,210,121,201,97,115,126,180,240,39,243,108,65,10,110,166,99,15,194,92,182,173,69,31,28,80,96,157,209,133,225,11,183,91,24,107,141,109,46,224,110,206,74,72,45,176,216,69,178,185,164,229,245,13,236,152,22,0,168,89,231,129,78,243,52,186,175,222,111,114,109,227,185,239,179,197,232,103,175,13,229,29,40,247,244,209,96,106,147,13,95,56,255,44,109,193,112,22,253,244,48,191,59,206,114,217,167,90,150,172,191,203,18,38,216,133,15,238,205,68,187,27,62,83,148,121,57,183,104,161,70,210,44,40,172,154,102,118,195,198,98,191,188,6,22,247,72,55,15,179,218,217,241,56,44,84,153,203,164,176,244,232,243,237,53,88,100,79,127,167,221,234,181,14,111,232,195,215,205,91,252,68,34,36,23,138,253,48,111,182,109,35,92,247,189,132,8,72,233,159,51,204,142,220,45,3,19,216,39,154,185,79,246,49,151,181,108,141,120,235,220,235,195,155,2,216,76,210,252,233,51,146,142,155,41,58,100,79,174,64,169,62,44,100,3,6,194,196,6,200,91,164,159,159,0,159,251,66,9,15,84,76,247,33,111,170,97,40,156,134,133,199,250,114,83,116,185,255,21,182,142,208,55,116,131,81,57,10,84,60,130,89,219,225,232,48,77,160,160,89,51,203,166,150,39,178,203,75,162,20,155,216,132,120,232,151,4,40,142,24,63,198,185,16,222,153,194,7,118,169,83,252,160,81,150,63,106,117,7,77,43,15,209,4,28,247,211,118,71,104,216,131,203,39,160,25,4,78,49,10,69,63,246,193,240,104,71,102,59,145,184,170,102,81,103,83,93,40,142,78,56,203,217,135,235,67,216,229,201,140,168,226,28,61,215,111,146,220,172,74,66,12,37,45,153,189,195,90,251,193,87,60,75,193,239,107,5,174,209,210,255,22,74,154,231,45,185,138,245,234,189,70,131,30,219,114,11,186,178,177,194,167,166,144,90,51,155,40,170,147,9,60,15,130,159,7,79,127,16,75,134,119,38,165,81,161,102,250,0,148,190,36,213,50,42,223,59,70,83,74,231,92,122,51,160,143,62,241,157,227,80,35,232,224,96,100,152,18,132,15,141,2,252,252,157,91,155,22,90,56,187,211,130,164,49,3,110,91,93,207,56,94,211,255,14,8,122,129,1,12,168,206,250,65,134,203,197,243,201,136,62,56,186,97,121,133,236,254,47,50,171,39,240,118,141,55,44,71,249,250,66,130,119,212,137,123,48,86,216,9,221,238,25,153,67,89,28,205,102,237,59,18,111,88,12,230,214,172,126,143,55,197,11,6,205,49,151,156,93,146,47,103,7,76,55,52,189,242,189,158,188,24,236,244,199,28,246,19,106,141,170,193,32,179,83,143,125,233,195,12,5,247,41,232,74,126,94,155,188,245,244,50,19,211,50,162,67,189,18,105,186,60,43,25,189,181,121,51,230,162,214,72,112,126,121,57,141,80,126,103,24,67,137,161,171,82,131,10,160,51,46,24,112,56,96,60,160,167,38,73,241,18,2,155,205,217,250,55,21,46,231,143,218,230,129,103,42,221,165,231,226,45,246,28,107,172,54,67,32,68,138,208,121,211,37,232,182,7,135,202,76,81,233,14,117,151,18,128,123,49,224,163,121,229,43,161,126,125,194,64,102,199,202,200,205,133,221,129,62,173,148,225,14,130,228,200,217,24,225,11,243,187,126,244,9,186,201,180,28,137,6,240,3,101,163,80,2,153,19,10,130,123,199,213,73,21,11,81,163,215,128,103,63,85,90,145,81,34,65,25,119,13,42,43,158,97,4,79,93,215,22,130,207,118,139,172,137,11,136,134,234,38,235,188,247,214,51,198,126,248,153,139,104,163,69,6,40,234,207,158,211,34,11,59,102,232,55,100,110,249,156,171,252,186,105,221,133,237,17,36,239,194,198,91,213,54,128,81,247,84,174,143,103,36,191,12,48,176,157,232,18,113,131,61,36,189,24,67,208,36,211,174,46,172,167,18,132,254,63,101,197,254,233,4,156,113,71,140,201,122,171,70,237,132,118,188,179,66,112,157,150,25,109,188,130,206,176,66,219,60,10,240,202,20,182,62,176,55,232,16,95,139,221,236,123,228,199,161,12,96,109,63,224,199,186,182,56,193,116,97,71,1,158,73,182,137,181,82,88,14,113,232,244,140,203,115,201,9,177,92,206,69,184,156,41,54,147,165,187,213,237,84,213,213,85,24,173,148,50,185,222,35,253,236,190,162,9,16,161,45,39,202,187,202,24,104,254,176,240,172,66,88,120,32,116,192,124,126,232,139,189,5,53,138,211,65,37,195,100,102,108,155,82,112,183,235,6,0,241,225,194,167,189,176,82,220,149,250,180,239,250,205,46,86,246,243,169,108,44,231,177,140,145,35,209,33,189,134,81,242,157,27,232,84,194,162,40,160,61,214,241,206,141,83,96,239,24,120,66,155,161,164,165,154,215,245,235,222,78,72,41,119,60,33,210,8,95,158,165,100,18,97,156,94,100,149,79,228,49,239,196,188,40,41,34,178,62,171,12,253,57,66,126,29,231,131,249,228,150,63,161,50,51,154,43,46,25,51,130,52,73,200,19,242,19,54,51,45,174,186,15,59,49,104,196,123,6,187,238,81,151,148,48,145,159,123,41,81,250,227,107,127,240,248,105,74,207,159,217,175,191,216,109,231,231,181,204,149,156,184,180,241,231,153,210,184,133,111,69,69,236,37,179,207,238,169,77,236,79,149,193,173,187,25,250,175,106,134,150,92,134,108,151,62,146,210,128,9,219,152,228,218,53,67,64,69,207,73,212,53,182,240,179,229,195,31,15,224,102,183,153,214,29,222,69,43,119,138,231,133,49,236,231,86,79,34,44,226,239,175,141,69,121,211,235,255,241,11,34,169,181,67,79,55,201,119,107,245,56,228,13,152,91,185,107,134,78,115,175,88,195,82,219,199,174,106,172,33,25,245,200,96,207,38,10,64,85,5,2,12,240,241,19,219,89,222,89,59,129,182,199,135,252,22,205,70,159,167,140,117,1,186,13,197,233,233,26,245,208,152,147,228,32,245,82,160,99,56,79,148,204,217,76,204,199,132,44,199,222,234,170,97,158,86,16,31,0,218,58,195,246,30,224,77,80,12,202,11,152,169,195,218,142,161,171,34,84,126,9,127,177,94,86,61,183,18,222,232,123,166,38,176,117,159,87,179,230,240,249,181,79,132,53,71,209,71,77,83,39,211,195,232,243,230,143,143,191,68,104,129,148,253,76,172,116,33,65,93,86,192,251,52,242,220,35,38,36,123,203,127,50,74,148,224,172,253,249,190,89,73,65,202,74,43,167,45,40,120,169,24,58,140,19,166,182,26,81,138,172,97,197,177,77,34,11,149,14,63,3,109,236,130,169,191,95,108,32,246,183,75,78,116,48,70,24,90,96,236,186,137,11,194,221,70,196,23,139,123,168,220,102,235,6,230,31,86,137,83,188,255,19,68,10,37,78,11,186,229,245,65,107,70,146,32,225,173,40,17,58,142,92,217,94,206,105,55,214,13,78,1,48,86,253,20,156,53,245,45,223,176,218,60,99,81,231,231,80,2,106,182,234,175,185,110,234,15,21,224,33,80,95,119,231,201,221,199,79,161,25,198,230,121,104,85,221,137,185,102,1,99,45,233,141,174,11,22,57,186,228,119,24,225,154,120,198,251,41,16,255,238,112,113,65,142,233,117,127,69,212,84,11,103,53,161,204,23,133,137,197,53,18,14,115,33,134,62,11,243,118,77,17,171,243,183,241,117,70,161,38,147,129,54,212,4,102,175,213,236,102,204,188,86,99,209,200,105,17,166,148,56,163,122,249,151,147,2,219,11,74,25,63,75,255,233,137,226,180,184,85,176,164,163,71,38,52,43,200,34,9,52,61,93,184,77,173,139,122,26,22,107,173,212,155,198,29,107,181,241,1,11,14,155,68,140,146,64,7,149,101,100,126,202},
  {10,233,25,94,153,250,69,92,240,57,200,35,170,59,124,178,142,4,126,113,87,168,248,73,18,245,223,115,74,141,130,25,90,154,246,145,105,198,169,211,255,139,143,250,151,6,236,179,121,99,232,31,108,10,47,247,179,6,204,60,107,2,198,162,223,173,170,174,45,212,73,83,159,101,211,147,166,95,238,95,223,54,94,177,88,163,18,201,222,87,96,53,134,217,108,178,165,227,241,249,1,189,69,90,166,216,67,112,228,174,123,169,53,14,138,132,27,195,35,32,141,47,67,8,100,188,45,241,226,158,205,51,78,238,123,160,139,234,100,112,148,16,63,34,222,19,139,68,229,169,48,165,207,117,76,31,219,164,144,28,242,185,8,2,81,121,192,142,38,66,139,126,76,125,2,7,171,234,164,180,4,126,100,150,28,127,91,176,34,98,133,214,28,197,148,54,198,220,168,100,7,166,232,228,93,199,119,109,86,13,102,84,227,107,71,242,23,242,19,129,53,194,211,108,3,193,228,170,114,237,204,139,200,84,255,87,223,182,148,101,211,200,113,194,201,112,33,63,95,8,190,26,162,198,1,55,143,225,53,65,245,28,200,247,68,236,171,151,5,21,208,149,202,131,155,22,124,77,149,201,168,214,45,210,127,154,167,138,41,31,16,10,181,5,9,23,224,23,23,126,215,136,225,148,171,1,36,31,227,179,23,215,64,104,10,68,245,206,233,250,193,171,129,68,231,224,197,148,21,218,238,75,4,250,232,99,43,185,161,56,171,228,243,204,210,134,110,124,124,72,130,170,137,250,228,234,101,129,90,160,225,218,0,185,195,68,60,181,204,25,56,179,56,113,154,58,43,31,255,201,150,38,209,56,183,111,200,246,49,196,51,170,49,177,243,189,29,142,132,149,243,49,226,6,103,172,173,58,215,250,213,48,186,142,222,135,205,53,67,135,197,1,94,119,214,53,147,170,181,106,194,54,215,223,197,243,101,178,193,204,167,16,134,221,205,115,70,178,116,47,209,92,20,69,59,94,7,215,49,209,49,30,178,53,92,251,35,122,112,216,121,167,79,18,232,250,254,84,128,167,207,79,242,9,128,132,179,16,216,198,118,246,164,41,1,222,249,36,249,29,24,118,55,181,70,6,118,112,198,148,98,135,135,176,99,33,169,55,144,54,243,57,151,179,192,50,85,30,84,56,70,158,64,252,123,65,230,77,33,187,81,63,54,31,26,128,166,134,121,54,109,96,195,155,30,245,95,151,167,230,228,216,140,42,137,119,95,91,254,57,44,92,240,116,119,227,189,231,53,55,195,119,17,117,223,14,91,239,80,172,146,34,204,12,154,140,205,157,159,244,38,150,88,37,219,78,70,11,232,223,85,218,1,161,89,136,183,195,117,188,175,243,223,40,184,68,85,26,93,197,235,125,208,195,80,135,124,5,152,171,200,118,5,213,68,131,140,43,159,59,159,149,62,105,105,92,212,130,126,100,82,249,35,48,24,43,211,5,67,138,139,43,59,45,91,32,173,81,65,99,109,181,47,10,71,55,72,47,187,80,134,152,162,139,183,95,187,199,245,66,232,128,122,201,58,156,60,254,94,137,141,126,125,136,151,66,139,74,25,6,63,12,180,73,40,114,11,68,48,240,72,40,225,14,239,228,94,245,23,159,221,62,208,157,235,166,187,160,204,219,203,171,53,180,50,238,225,72,164,248,200,62,26,22,91,235,61,32,227,93,26,48,237,186,3,235,238,3,51,187,130,30,208,23,186,187,128,92,137,106,60,237,25,21,217,10,106,84,219,42,244,60,145,10,226,121,92,21,39,240,177,229,114,117,201,242,0,142,29,66,91,211,234,235,72,222,238,181,12,11,220,3,165,119,123,21,18,234,210,78,209,169,74,24,78,178,176,205,170,254,103,63,209,46,101,154,119,6,223,45,83,31,77,212,247,85,130,206,43,112,149,2,68,156,197,180,103,243,211,51,158,67,116,148,18,94,153,89,170,136,113,115,78,251,162,231,109,229,133,19,66,11,94,239,190,49,36,235,140,124,166,124,178,93,14,62,211,26,170,23,20,156,105,120,115,177,71,86,118,163,251,248,156,134,78,196,144,88,130,160,14,48,75,85,17,241,86,65,199,28,92,94,183,1,44,169,221,10,201,136,148,43,112,227,94,52,198,85,68,190,7,35,22,4,197,195,48,151,37,186,218,18,50,158,88,212,193,149,151,64,155,135,77,99,209,187,70,223,116,13,180,79,228,225,67,226,241,182,102,232,186,242,89,170,20,96,114,48,213,172,9,29,80,191,143,139,112,131,238,198,12,193,107,16,223,253,126,192,197,17,66,145,105,50,74,116,41,114,38,40,98,248,98,168,141,200,190,236,47,174,255,105,158,226,103,31,33,225,25,151,58,123,230,12,74,210,99,154,112,221,25,61,240,213,118,139,203,154,60,242,34,191,193,240,173,33,43,131,235,212,62,32,198,113,95,78,38,83,7,188,113,134,255,143,17,16,54,218,138,47,125,22,81,108,94,49,68,8,69,72,27,246,198,200,230,89,180,162,1,61,145,150,150,56,151,167,33,203,160,239,17,51,79,0,7,218,187,134,209,152,214,178,97,255,112,235,28,71,35,78,236,128,12,60,182,68,103,16,59,221,179,50,200,130,81,50,181,57,241,20,208,26,250,167,234,228,28,252,149,196,34,81,4,134,58,222,167,43,57,192,16,109,121,43,214,29,40,34,248,71,152,168,148,168,95,125,250,115,134,105,100,159,167,221,145,29,229,190,106,48,52,184,213,102,200,84,26,99,186,131,101,138,17,19,67,191,178,181,125,87,133,242,208,4,7,122,130,244,22,103,85,153,221,110,116,166,45,188,226,179,6,173,4,40,121,60,250,158,151,152,184,155,212,52,119,214,228,62,82,81,186,173,151,133,220,44,23,40,117,206,78,62,125,212,209,180,3,241,109,252,67,81,173,91,159,142,66,113,116,78,100,233,11,253,89,19,201,170,147,10,251,117,147,226,242,144,78,246,63,22,138,177,45,205,10,209,125,249,149,253,15,209,228,186,250,16,72,183,119,153,211,234,141,166,32,60,23,56,37,92,144,135,215,170,138,28,11,118,225,95,22,23,64,200,31,107,155,16,101,112,161,249,12,38,65,125,147,205,113,193,144,157,192,228,134,226,212,22,142,88,211,128,127,18,55,5,250,101,140,198,59,235,233,114,16,29,160,158,141,38,106,36,131,121,113,62,216,13,160,178,76,210,152,170,152,182,164,241,91,224,94,252,34,61,144,89,222,171,153,110,218,159,63,59,80,111,79,165,210,124,192,1,87,140,114,79,214,249,110,15,210,220,115,194,70,195,193,76,199,153,112,140,74,121,176,116,102,201,77,64,188,241,116,246,144,211,132,110,201,213,88,140,198,124,79,87,227,219,181,193,58,57,223,167,179,177,149,5,255,106,198,143,15,27,139,189,187,163,151,36,161,213,56,123,155,2,50,23,252,14,206,24,215,34,161,31,0,118,37,101,185,63,232,74,183,183,155,175,211,120,10,94,47,39,250,78,240,166,81,83,14,229,233,74,36,24,246,68,14,232,23,52,58,25,86,23,213,169,190,138,173,96,72,22,242,59,188,238,25,40,212,103,202,244,210,37,60,184,60,249,176,1,205,6,67,231,250,128,183,185,55,199,187,7,49,30,156,242,43,164,159,141,132,10,46,198,223,246,70,130,65,72,91,92,40,9,116,161,152,180,252,236,91,209,66,115,116,243,208,224,22,194,113,76,192,142,198,53,16,227,108,56,21,191,47,139,104,163,232,141,184,170,199,189,220,159,238,255,251,44,5,168,184,46,124,95,89,194,252,88,174,3,36,254,179,195,139,84,233,179,77,113,20,211,146,79,0,133,138,123,38,113,116,207,194,181,181,162,19,33,176,70,239,39,134,174,174,5,96,67,182,94,239,94,96,51,19,155,235,19,201,226,2,194,57,93,193,171,163,113,214,88,160,167,17,176,243,50,161,4,185,2,182,111,122,46,227,226,232,114,224,56,59,185,200,90,149,56,101,99,102,180,9,150,57,228,74,218,160,190,121,197,0,186,9,21,142,117,179,19,213,87,3,74,123,79,75,195,25,105,46,72,182,230,216,195,247,12,187,199,0,27,66,57,32,151,41,64,57,87,84,218,233,224,206,191,179,7,101,203,55,226,50,135,184,67,191,211,205,173,191,87,58,35,159,92,169,40,141,88,233,98,190,71,4,48,177,240,230,227,124,144,75,11,49,253},
  {178,231,220,79,153,97,241,100,186,226,232,64,216,239,166,114,237,99,34,14,85,61,252,36,172,183,109,201,127,170,4,38,49,84,102,240,101,83,65,122,218,70,62,49,171,206,147,4,74,160,132,36,245,93,219,211,101,187,186,187,27,31,162,3,160,148,120,116,133,129,154,174,173,132,13,154,130,52,191,143,133,18,209,25,86,170,141,65,50,65,48,220,22,45,82,138,1,190,226,215,118,160,114,8,193,244,132,37,228,99,155,192,138,81,227,84,188,170,55,147,211,114,206,136,65,82,147,186,220,18,190,95,91,31,164,207,163,130,59,60,98,153,29,1,33,59,126,236,165,243,34,196,21,152,237,55,112,14,236,173,231,160,225,222,211,153,30,66,19,51,50,122,233,135,141,78,194,23,69,39,165,245,73,91,213,38,0,249,113,54,197,35,60,10,76,52,218,167,86,18,129,118,73,130,222,175,37,44,210,207,212,62,115,14,155,100,233,155,179,215,38,58,71,185,36,116,159,224,155,178,158,64,10,192,153,210,73,151,208,6,252,46,197,196,207,214,219,179,107,30,105,164,140,242,23,0,72,95,213,97,40,146,219,11,199,37,186,176,73,127,194,83,31,73,19,103,59,97,225,82,34,233,244,219,173,1,230,81,196,76,104,209,16,137,25,189,40,122,176,218,49,186,241,189,227,180,69,165,58,56,102,129,43,161,36,132,69,208,94,240,93,250,85,244,196,227,215,14,181,93,234,82,102,15,104,87,111,229,163,64,152,136,171,203,129,113,98,114,248,122,68,156,177,116,5,90,27,68,171,186,253,88,216,102,101,210,93,58,120,135,14,24,105,21,23,132,242,76,159,85,100,255,89,134,40,48,168,75,183,224,198,223,110,70,151,59,92,95,142,215,151,161,126,154,105,58,26,199,134,190,47,101,121,142,176,60,167,37,141,116,221,54,91,233,251,68,110,116,134,124,247,32,101,33,113,19,99,94,232,214,199,220,84,153,220,196,185,19,169,62,151,213,75,214,3,236,145,247,143,4,49,141,247,190,13,207,96,147,68,9,242,125,65,130,147,27,13,119,242,98,17,220,25,171,189,19,168,47,114,109,156,124,198,64,254,161,142,161,201,6,53,73,249,241,125,86,107,154,252,148,33,192,149,144,108,176,19,133,26,164,172,51,125,194,28,67,83,246,61,107,238,195,130,36,206,34,227,212,68,167,105,4,164,15,10,135,194,53,195,174,54,172,233,255,175,235,32,234,230,32,23,51,239,130,204,143,6,202,58,44,116,107,22,89,86,237,223,43,97,245,141,225,82,155,0,66,255,134,34,59,108,221,161,162,14,172,38,207,227,138,77,84,102,171,72,50,245,13,25,128,148,8,35,44,115,157,110,138,0,43,146,48,234,152,181,214,166,187,95,184,164,234,68,152,165,70,134,60,219,112,250,178,244,174,22,128,115,148,17,4,9,42,97,209,51,57,124,200,154,44,248,238,181,174,160,197,177,87,152,68,141,145,147,229,213,141,186,234,127,215,1,40,77,91,188,57,233,168,154,47,0,161,253,67,131,237,81,171,101,230,116,83,150,18,16,186,160,58,75,75,80,11,154,33,175,84,92,203,36,234,223,212,250,174,238,30,125,227,189,242,126,161,121,71,242,122,184,146,25,94,165,2,130,143,121,35,227,57,132,85,179,168,117,201,11,105,135,178,33,117,47,186,28,72,187,208,167,139,20,151,38,4,100,163,177,8,64,26,78,58,194,15,127,69,7,16,175,149,20,154,222,91,69,225,52,238,18,95,52,3,213,51,196,113,219,117,194,156,81,249,100,132,0,115,70,2,219,166,159,72,203,93,225,66,197,254,11,175,150,237,109,177,240,252,158,25,164,12,222,155,109,246,0,10,249,129,109,248,200,193,53,80,78,241,3,181,100,126,187,18,114,221,56,201,115,126,186,2,0,59,37,218,108,197,214,229,148,148,215,251,171,3,10,178,27,243,156,236,152,156,111,178,118,17,119,157,252,130,7,166,116,210,149,89,129,101,153,194,75,18,111,253,77,182,23,56,245,117,13,165,131,41,138,232,41,6,78,159,51,1,128,211,100,255,95,227,8,109,85,183,140,64,81,139,88,66,213,17,18,165,43,190,26,184,209,161,71,144,152,245,70,75,200,14,177,156,202,228,244,205,208,186,135,96,29,75,40,25,22,15,219,242,78,128,166,251,80,3,216,94,188,230,182,12,154,129,116,195,62,146,109,236,77,140,188,152,126,216,26,255,165,151,79,130,37,220,3,130,238,51,46,236,42,53,209,234,53,140,120,142,106,64,168,237,139,114,193,144,132,164,52,93,255,78,239,135,178,84,223,161,139,214,147,240,194,47,223,196,92,129,7,205,141,74,60,20,180,116,101,177,69,120,157,2,202,254,64,115,60,81,14,89,36,179,122,67,153,234,180,42,217,198,207,16,22,145,151,178,57,210,163,227,45,179,196,34,204,148,245,200,209,240,139,54,45,93,0,191,135,184,55,62,44,160,234,50,110,120,151,47,224,204,224,99,118,169,239,238,93,85,171,233,57,245,212,246,205,111,193,184,54,221,205,78,209,21,90,135,186,119,22,59,120,196,25,223,60,47,176,229,88,51,191,134,1,141,147,180,246,50,37,211,35,121,160,211,163,174,17,183,89,180,76,14,198,248,47,81,112,227,245,226,206,50,166,116,248,32,71,120,9,102,160,111,32,234,91,32,247,119,251,154,46,123,182,10,103,72,201,143,19,121,58,76,113,149,179,82,129,239,217,186,202,136,207,203,246,135,134,159,234,75,4,220,79,165,72,48,84,97,245,51,121,157,47,204,21,250,158,193,137,134,140,103,185,10,178,224,218,204,48,72,45,127,251,1,223,235,230,38,162,251,1,117,225,9,46,96,215,62,255,95,108,4,202,91,16,110,63,224,42,191,122,178,245,123,112,19,109,249,30,79,170,195,54,138,73,30,165,45,0,172,126,44,165,83,128,72,159,234,204,219,45,18,182,135,69,193,137,217,207,43,71,15,213,234,135,247,115,244,37,45,232,250,201,79,118,126,150,111,247,11,103,255,121,43,66,28,136,32,59,107,104,112,24,69,200,193,225,137,188,223,70,64,210,57,49,205,139,223,93,243,15,241,150,170,14,7,177,237,113,47,135,54,198,231,23,243,167,135,219,222,140,168,81,63,173,166,114,19,14,250,192,45,130,129,149,134,15,29,176,221,69,136,50,129,197,172,153,129,255,172,202,201,109,185,149,111,39,46,224,157,182,120,114,168,239,147,143,212,28,254,10,73,111,165,27,192,213,209,236,78,70,37,178,53,146,245,224,8,11,169,148,123,48,14,248,154,225,71,6,154,166,183,215,242,241,102,140,154,254,80,84,81,217,251,92,135,204,137,242,98,54,34,41,16,157,89,197,247,74,163,215,22,49,211,51,213,59,110,19,214,88,78,246,97,76,214,203,143,236,141,106,49,151,181,24,133,232,43,10,207,151,241,234,55,246,151,255,37,131,182,227,235,52,31,169,167,50,128,95,151,184,101,248,90,157,44,172,63,196,163,101,178,186,152,161,231,147,77,31,117,157,111,225,45,219,212,162,180,10,59,44,65,224,13,98,218,158,64,191,143,11,197,139,11,46,89,58,116,216,241,171,105,158,151,26,195,102,213,4,4,29,151,238,163,98,189,180,29,185,5,242,133,153,119,146,41,86,128,223,79,248,60,23,165,0,18,233,180,125,109,86,62,50,63,42,24,130,57,169,235,211,132,124,125,0,76,212,130,35,237,204,106,64,219,92,198,243,233,133,93,187,33,210,78,2,82,35,21,85,63,2,250,159,218,66,34,71,26,22,253,134,140,62,137,81,250,101,47,125,58,64,192,185,103,190,33,126,86,154,223,244,226,109,50,123,187,114,123,172,59,106,83,182,60,92,128,204,221,13,96,162,176,144,29,193,11,55,29,246,70,180,52,54,1,7,73,172,179,175,221,130,215,101,116,21,72,28,160,30,189,226,204,136,57,242,225,74,127,199,2,9,183,92,247,178,156,72,66,185,5,55,158,143,10,168,181,178,2,57,30,248,55,107,198,105,57,3,108,184,227,226,65,2,82,27,159,233,13,72,20,240,97,163,0,110,204,253,123,212,173,139,140,245,159,254,206,2,225,121,103,155,141,91,45,230,42,39,88,252,89,238,55,111,109,246,141,211,142,99,149,203,85,83,150,184,30,92,61,36,161,104,168,27,68,170,134,153,209,24,1,124,227,64,161},
} ;

static const uint16_t precomputed_encode_953xint16_x[precomputed_encode_953xint16_NUM][crypto_encode_ITEMS] = {
  {17038,52067,14783,44327,2317,53752,11048,13042,32457,26941,29238,44434,42299,55778,61151,3875,47249,42009,38478,51067,338,60240,15871,59654,14383,683,25359,6822,25442,42993,35686,27422,12471,29656,61421,50040,17223,33757,39017,23894,10025,35961,61988,9365,13888,17636,52981,12565,57169,56671,46054,45198,53614,7687,34077,19935,28827,64798,17458,42997,42713,6211,43706,40606,58074,28017,37919,21402,56221,49873,35969,48971,44600,64388,58068,34720,39349,13237,54107,11555,26611,15019,7647,27933,3517,59253,40154,34492,4248,60921,16160,28857,12661,12496,55572,14547,54406,25180,4927,44175,49070,50519,21774,42716,64275,52436,18810,21668,41492,5722,12387,41948,34020,57849,22248,43265,24190,26537,40596,57268,58311,20145,39293,56572,64523,25100,19761,54878,557,30943,27333,4965,58269,40610,4006,59870,14343,10371,28317,29154,39312,61890,9498,38285,50777,21338,24179,10028,26586,44881,58952,35228,6996,40796,4548,47380,55470,50641,13981,47228,47362,61493,40149,51464,30494,60579,61906,54302,53139,11147,47851,11362,26535,22966,40655,26974,20737,52359,28522,7828,59161,10688,25483,31985,46258,13843,34584,20966,6241,3631,32044,46770,57411,55233,27214,23575,33322,11836,30487,31216,35564,32847,20545,3793,27152,64414,2368,64991,53430,59559,2848,50787,49859,22298,64755,2800,45448,57147,25024,14840,30303,41231,62634,10019,47208,64206,48668,21099,5960,34902,12977,63749,26496,62949,2416,14264,36707,41468,61515,17894,38700,60173,19148,23797,20906,40931,654,6602,13157,29160,33554,831,48854,42706,10509,14035,58469,23719,58774,37770,65243,22440,28488,37821,21009,22733,57508,35589,26568,33321,36508,34355,34721,53188,13252,590,17628,44324,54673,26074,55975,24252,15038,60358,50869,12176,28009,12480,37026,27802,49577,62812,14092,3440,65321,52718,3571,46995,54603,14599,11559,28518,48954,46905,51900,5928,26571,58753,59127,6645,39991,310,25278,31991,2844,47258,52163,8431,21316,56874,18584,47262,15563,52373,45786,32779,35531,63061,21647,63098,32171,60382,13715,34966,13247,47939,56346,29659,8525,5199,60327,8714,55549,30365,23334,33142,12016,27278,21488,14682,21853,277,35350,59425,58167,14368,3225,16822,22212,55141,37278,4349,8453,37248,56482,52634,41372,61643,54919,23030,44750,46393,27516,51311,56819,53583,57211,12961,27725,30529,21249,61872,31909,20554,24123,27444,49473,35007,38858,33012,49719,58897,30739,31199,64875,23161,35589,52687,19959,40847,50964,7809,47228,58543,29507,49159,7264,3304,23658,25371,63436,60712,11835,34550,21189,59676,16974,46795,6944,18369,5184,32182,13640,55471,21965,19884,15044,3701,44110,21045,40092,34993,44772,21701,9890,63312,50310,58755,54919,10502,60019,54538,46925,2573,65119,28658,57184,10331,32574,37304,26200,51398,50069,28256,47210,30187,10291,1861,47710,28009,13082,50102,61151,15551,30397,63022,38785,51470,54730,20970,29349,61147,64116,19764,30481,57009,21063,24007,50944,25335,45292,8430,58077,44061,47661,51726,62104,43347,41895,14946,36742,45218,6173,33560,423,8210,32240,39499,4192,36928,12646,33958,61222,6195,29258,58893,18196,19545,51409,12311,7582,40197,39480,29183,889,58765,20886,25949,53429,55633,64215,39148,55416,52076,51852,48724,779,42100,42780,56500,8615,20735,51016,63255,21107,23293,53748,30771,42995,18187,52871,15823,6371,11061,45257,12357,34145,31081,48621,44326,12070,56256,35487,12105,61734,37838,44693,14209,48181,22119,56287,47506,44145,50168,44042,15713,5767,37941,24145,33152,55548,5187,61366,65253,29206,1024,65514,768,34523,41188,23170,43825,22070,23128,11408,37231,29045,35136,21064,32588,46774,33577,9262,16740,59885,18512,24219,36556,65002,15230,1925,22421,64449,51341,37651,6980,17425,25182,16613,55811,18042,2358,36548,57868,9566,9211,32306,33875,6342,54820,60300,37358,26380,5739,274,26986,22940,12266,7098,38864,51197,21684,32025,52375,40326,22878,22766,20764,62661,18961,6507,52428,29480,5975,31274,35081,54293,48630,33103,41853,41122,52750,20260,36157,27287,59858,41804,45353,64874,44823,57606,20825,40488,15517,19406,46710,52664,46958,19636,51576,32225,14303,4892,46696,13227,50122,58663,50052,47433,45404,65301,10777,12169,7486,5384,53814,25417,34128,34049,30804,3905,29660,32495,14319,27410,63822,16213,18893,11544,18890,20990,24670,45496,7299,25300,46144,40586,56181,34544,41976,4748,54813,7356,36962,42212,2799,40845,30399,41339,38446,7222,17189,45421,22573,11463,59089,13164,27878,33451,38555,42713,53919,47772,35143,49189,43290,29216,43387,1996,587,63734,7991,59266,38863,50990,6359,53107,13372,55167,52469,42848,62616,31162,21772,2189,33119,17135,25097,65362,28613,33543,11478,40526,35280,40458,14503,39333,5794,25267,37105,63674,16964,58470,20152,54902,55390,9708,62171,35420,14944,6324,46251,3573,64562,31015,52235,30549,36420,63444,17959,48766,29934,55459,51536,11661,5415,30939,22508,61553,63258,8353,836,38768,29222,56190,16262,56172,48163,46690,62699,65199,14262,23546,56220,8900,42126,9001,64313,58602,35294,14765,31033,55663,17668,30002,34031,23677,24819,54758,34273,27366,12194,17566,58594,55650,48781,22352,65274,57956,8477,46559,25476,8564,14733,11835,62791,38558,15931,46099,49532,12537,60001,5143,51880,61938,54363,40135,30083,5017,27466,15470,59761,24659,8026,25868,60169,19566,46170,61508,17231,65090,33934,25906,58060,37592,50795,5115,40456,41432,45347,28459,33489,25348,1687,4238,28211,58004,57798,55952,6738,45972,31910,57353,40865,56317,62342,40778,26379,51282,39725,43667,21818,19211,21241,35334,38268,40851,19347,56346,53626,50766,58178,49825,1698,20978,9615,6370,31296,50696,41790,59978,22140,65003,18523,23163,55992,17735,49567,57445,36927,5616,34604,34393,45475,64503,1599,29405,14016,51007,54326,13527,12236,34565,11555,42667,24621,43708,26946,28005,40099,12961,21502,42057},
  {601,42903,7195,25667,47907,30007,19275,26801,12135,2831,18353,60532,55570,40224,40762,27254,3336,26048,56904,26648,13986,32034,42091,14726,46689,6564,37728,30661,10547,14181,50586,15604,4698,13376,19600,31042,7749,52949,8451,24340,5268,9206,26412,21615,11368,43445,18194,41470,38690,943,23364,33022,41564,48666,29985,4150,27491,54012,51577,29537,46206,10224,27891,2625,42606,3939,23746,44470,8005,20508,40288,34257,3041,23479,27416,28045,57390,52846,18506,45101,17880,47538,58788,3573,39148,22,22952,33255,62286,47668,57007,29295,58221,61369,50611,26600,3503,7653,63272,53748,27232,3475,14431,11519,49517,5744,62717,48944,52795,55666,23207,44182,52159,9746,34264,60943,17613,7099,21310,31124,46905,41320,53830,10284,39596,30310,50883,48994,1724,63254,14152,45839,55770,14577,21548,52121,45220,59636,60915,22581,20324,42879,60125,3765,59503,55235,23501,17660,9250,35351,12541,46703,9069,63324,33981,18440,40937,52275,56462,813,55315,39463,20409,12790,46487,36204,60280,60380,39875,55298,53836,59900,37427,39822,14889,20324,16558,16041,25644,1539,50370,51206,42075,40863,40704,17147,3849,19540,8695,43631,10337,34460,51077,29434,29779,65465,46613,53390,29751,20867,2617,15444,22914,57819,12520,41037,22944,52019,38566,45607,19403,5282,55451,30852,38888,10244,6286,50751,4281,39390,1986,43382,64595,20896,16278,30058,19719,3883,1233,63260,30419,26695,33752,10187,6560,19972,2609,16197,49654,26864,26183,37179,43704,20838,21351,10333,20110,52024,34777,17387,58840,36041,58024,15644,28631,56466,19116,3138,11557,48537,23235,49659,15447,49483,27631,44549,53969,5887,39498,11751,35513,60149,18109,7811,29403,47627,45490,42946,37030,13146,10395,37802,15369,33295,1951,32591,19216,30598,42278,41297,64102,37888,9406,13013,57130,17979,19027,23783,13178,36768,61758,58269,9040,57576,25696,4760,3972,653,64764,23453,5787,14426,54203,42114,817,23406,53085,24120,65491,2062,33146,3073,52904,16890,52102,62405,35017,14398,25018,34169,65260,12847,10155,30448,14221,18220,64249,33346,54391,31625,22064,2520,61149,39193,22851,52508,60774,4667,22639,58892,44246,36734,50487,1547,12749,40087,37469,26415,19463,13367,62141,40637,6332,62700,7367,5110,36202,49578,45856,36691,59773,3267,63237,59433,32330,39774,62908,13044,54035,41522,48451,26898,15546,6443,46525,13177,41702,18646,32368,14713,20621,26494,17176,41353,21163,2691,13216,6190,14448,15456,42912,18726,4849,39682,55757,14330,11797,36839,59098,26497,56618,59301,11746,7414,44139,17206,17440,53386,54137,59429,1974,51847,20812,3817,38773,32786,12667,41952,58745,41259,32126,16578,51046,51402,34253,33245,44350,57748,33294,51428,6361,3041,48115,62590,47625,46281,35100,61446,25859,20643,39170,2579,31618,54727,5449,20747,55203,26496,21823,37210,8785,6465,3447,11050,24990,20228,55133,33302,30415,44171,2953,34440,9962,48363,55031,50739,63614,35737,41832,1605,59944,40655,8915,15115,59494,25655,63854,43932,47868,56681,60805,9233,49903,23494,14037,20864,21751,36782,9319,3263,45104,59549,28946,15747,48420,17176,9424,44755,44078,4775,65156,25919,65221,1257,29084,35911,31433,18091,34029,48246,17075,40304,6550,48237,52866,17072,15579,61450,5322,16054,14256,4328,35679,60637,58491,41415,24588,16237,51168,46778,49464,24948,327,18846,35254,21173,3672,59505,36084,29643,2505,23729,17870,40120,13865,42387,54715,21741,54741,6229,38061,47410,9182,60669,41662,4105,11681,51751,51899,26648,45310,44272,22594,8312,49268,32380,35816,1469,35381,16851,49957,26212,39788,28754,60343,6,57841,42946,45245,56402,64149,61364,52730,22062,62454,27817,59180,36017,9105,8657,34493,62033,7069,21736,41666,41000,54845,52977,21389,61280,30744,39746,42145,39589,62935,57067,18510,30505,8508,2258,40543,25765,24850,24220,38244,58447,61233,48324,10536,45602,43838,64780,16953,7550,33767,58617,16278,12961,39475,11819,13081,13442,51273,61971,13843,11571,47790,15119,26673,31684,47878,20974,38039,37168,31647,20777,58362,32619,63728,19049,40911,45017,55487,59245,46567,38348,47260,61876,39399,47314,28549,17733,9708,53171,43502,60493,38223,44481,6587,45050,34410,23702,27782,16023,53906,2432,39131,56036,17205,17728,18895,13780,61622,58803,8131,57359,46950,54937,56861,11077,35447,34279,60465,22247,8783,57900,45039,17805,54137,65515,3057,43298,17333,14159,30665,62827,58424,38925,47451,34411,29518,22703,21187,51163,27310,8620,62745,24776,9935,16394,1365,3074,61936,56083,56921,15193,46721,34759,5884,18125,42911,30092,47617,50445,59881,62746,39120,58515,62752,41042,14435,37967,55756,52300,33991,50988,60126,25002,22174,7952,55808,49978,7926,19936,3152,3018,43416,56003,41358,8875,32340,32521,24241,15702,4791,59614,42619,45094,40821,45911,61670,46585,33871,18229,18385,21325,54055,59587,59123,36751,17599,33128,64916,44108,8564,23873,49238,13563,56562,9763,31524,32715,18994,57492,64940,48889,18777,51777,11082,11687,30760,6313,35898,42515,6838,35409,25004,45509,8781,38155,16142,27907,33516,49065,27743,63008,19383,29774,17968,23064,60512,35258,49675,18141,6084,31627,56488,60262,58886,22047,21385,65468,17427,9482,2894,58810,16885,18027,8338,44513,4392,36410,55644,52830,14185,3542,334,22064,5373,13724,11765,45279,15578,20835,59367,592,46698,45034,28345,4074,57365,20513,30559,51687,51165,41295,50713,31206,21864,35293,26297,25345,59693,44685,5643,47673,30692,57624,30874,64454,4137,61183,29040,36417,30185,17791,21716,26379,41269,6092,35205,13765,3602,8563,16006,62219,19830,43793,47091,30193,41286,37670,13953,1236,44902,60629,52326,22204,53603,27080,42513,14484,31395,38905,659,3035,6474,19263,59903,57993,47284,45141,41892,9799,11060,8904,13321,23869,19896,35757,6778,27414,54445,50843,27421,61877,2817,39694,35908,16530,38151,25701,51838},
  {59658,24089,64153,23621,14832,9160,15274,45692,1166,29054,43095,18936,62738,29663,36170,6530,39514,37366,50793,54185,35839,64143,1687,46060,25465,8168,2668,63279,1715,15564,619,41670,44511,44714,54317,21321,26015,37843,24486,24558,14047,45406,41816,51474,22494,13664,55686,45676,58277,63985,48385,23109,55462,28739,44772,43387,3637,33930,49947,8227,12173,2115,48228,61741,40674,13261,61006,41083,60043,28772,4244,8767,5086,17547,43493,42288,30159,8012,42203,7312,47602,520,31057,36544,16934,32395,32076,1794,60075,46244,32260,38500,32540,45147,25122,54917,50460,13972,56518,25768,42503,58600,51037,28023,3414,21606,27619,62023,61975,33043,49717,27859,49411,43748,60786,35788,21704,22527,46815,26004,51411,49777,28873,16161,2143,6846,50850,14081,57743,16693,7413,63432,60484,38827,5381,38352,33738,5787,19836,51605,54952,53805,39551,35495,7977,2576,1461,5897,6112,32279,35031,38113,427,7972,46051,55063,26688,17418,52981,64233,43969,17537,57575,38085,55829,19438,64004,25576,47403,14497,58539,52467,34514,31854,18556,43650,64137,60132,33125,41050,56033,47360,17603,46396,6604,45880,28984,15002,7979,51711,9878,14545,28599,63176,50225,43571,45361,48627,36381,38276,12787,1762,44135,15021,64215,12501,36538,34782,13773,34627,453,30558,13782,43667,27317,14018,57303,62405,45669,52417,4263,56710,29645,45638,12148,23761,17684,24123,55047,53553,7729,13746,64348,31267,55408,42873,4687,64232,21758,42880,20431,2546,33920,4275,50904,63094,10660,56833,9465,7673,30232,46391,1606,28790,38086,34658,45191,8547,14249,13968,14835,45975,12992,7765,14420,40518,64576,16763,19942,47905,16209,7990,32794,34470,13945,24685,39875,62750,38751,59047,55524,10892,30601,23391,14846,23596,29936,58231,59325,14133,30659,29969,3807,61275,44112,8850,3276,35994,40397,62623,38438,9560,20187,2886,57320,55893,41217,34905,50103,48245,62383,10463,17592,6741,50525,32235,50128,34640,1404,43928,30408,54533,33604,11148,15263,38303,26942,23657,33492,25726,63826,12323,11032,1491,35395,11147,11579,8283,20909,25409,46445,2607,14151,12104,20667,39046,35746,24503,51131,17141,33000,51578,39994,65084,35166,32397,34941,17047,19083,1561,3135,18868,29224,17419,61488,10312,3809,58607,62814,40727,16093,40400,42731,41147,56268,43979,46133,60978,18657,63652,16072,5658,60251,8253,24035,12314,47853,60163,1006,47923,7810,6096,48058,23680,27273,60732,5401,2777,21610,10971,15604,2705,31202,5468,61479,58801,30066,62153,36352,16925,54107,60394,56904,46574,2828,988,30629,5499,59922,20178,43473,6218,45646,52656,65194,16231,11985,39525,1655,11743,8019,54349,22007,52866,28715,661,40004,46277,62311,13267,17310,38004,24082,22937,34986,29553,64334,59298,58733,4997,2882,61278,12734,60196,31884,31910,23986,15886,6867,6058,39956,30825,45427,22087,41846,63739,34460,50254,22672,41090,12302,21835,61713,16726,7367,24156,439,43308,2781,35017,11156,58224,13406,21958,48708,8967,1046,50117,38704,47653,4826,40498,54360,38337,16535,34715,25421,48081,57158,3444,20404,57828,57923,46833,59494,62138,43609,24596,12402,44245,7433,48976,35727,33648,50926,49420,4203,64991,49278,4549,37186,12905,29770,29225,10278,63586,43106,51341,60606,44591,27135,58014,8039,57633,38681,31546,3302,53834,39523,56688,15641,54768,35702,39627,62012,48930,61633,8621,33579,54507,8254,29126,20063,21286,48135,34417,36863,4113,55862,12170,5757,27729,12638,2116,18501,63003,51398,23014,41652,15617,38545,14486,42903,52001,61344,13073,79,55815,34491,39121,45782,65377,60272,18204,20003,33004,15372,17590,4199,56635,12979,33480,12881,14773,5361,6864,43002,58602,64540,50325,20770,34308,56890,11175,49209,27920,11129,7638,8744,18424,43160,43156,32095,29690,27014,40804,56743,7569,48869,12394,47156,26325,21704,25370,33722,35429,4881,48963,46514,22397,62085,1232,31239,62594,26390,39253,28381,42612,48173,46050,44294,10244,15481,40698,39063,39864,13524,54903,16100,20818,44474,34199,11484,10263,52853,15950,54397,46289,61699,64621,20803,23469,36511,28994,20084,59748,64779,4953,43721,2707,30203,58003,37106,63054,5695,45450,52525,53514,63869,64917,53519,47844,4346,46920,39287,60115,42637,15392,14359,23589,34704,43735,7306,30219,24545,5910,51264,27423,4251,28773,63905,9740,32065,52627,49521,40336,58560,57990,5844,22670,32979,4735,1335,26106,50828,60219,29417,7440,40608,9869,9322,31107,15985,3544,45728,53836,43672,46744,61860,57435,64606,15650,22928,43998,28313,40922,15167,28496,42319,31954,448,35927,20338,63958,3950,56530,49779,49990,19649,39367,35952,31050,29872,51558,16461,61884,63092,54160,28292,54729,35928,31942,22351,56291,49589,14650,42975,45491,1429,27391,36806,6927,48523,41915,9367,54689,31544,667,5938,3836,6350,8919,8097,30208,25893,16313,19176,47031,44955,30931,24074,10031,20218,42736,21329,58638,19177,6180,17654,59406,13335,6458,5974,43477,35518,24749,5704,15346,61116,10265,26580,62666,9682,47164,63804,432,1741,59203,33018,47543,50999,1979,7729,62108,42027,36255,2692,50734,63199,33350,18497,23643,2344,41332,46232,60668,53595,29506,62324,57552,49686,19569,36544,13766,58128,14444,48917,35631,41832,36328,43704,48583,40924,65518,11515,43013,11960,24444,49753,22780,942,65060,50099,21643,46057,29005,54036,20370,34048,31626,28966,53108,46530,41653,8467,18096,10223,44678,1454,17248,24246,24303,13152,39699,5099,58057,49666,23865,43969,29091,22742,42912,45073,13043,1185,697,28598,11898,58083,29416,14560,47419,23240,14485,25445,46182,38409,58425,55882,48800,50553,47616,5385,30094,5043,22485,18947,20347,49995,26905,18478,59062,50136,3319,51131,6912,14658,38688,16425,22329,55892,57577,49102,1971,52069,57911,34610,17336,54207,44493,22463,9018,23711,10409,22669,25321,18366,12292,61617,58342,36988,2891,64817},
  {59314,20444,24985,25841,58042,16616,61400,29350,25581,3618,15701,9468,47020,51565,43647,9732,21553,61542,21349,31297,18138,12606,52907,1171,41034,9348,24053,54235,47973,48058,7963,930,38048,29816,33157,44698,33965,39437,13442,36799,4741,6609,43606,16781,16690,56368,11542,35410,48641,55266,41078,2162,62657,9604,25572,49307,20874,21731,43708,37687,29395,35022,21057,47763,4828,24510,8027,53156,33443,15419,39266,285,15137,60542,62373,50210,38933,14317,3696,44524,41191,57057,39379,16926,13075,31282,34793,20109,6082,10053,62885,23369,9941,63744,13937,9157,2620,13388,42970,4694,30337,33353,45022,11301,53202,16084,3699,25755,39913,55219,14886,47431,29732,57503,45723,16542,49162,53913,38729,1744,12028,50373,54991,46043,7787,42089,62092,23,24392,25045,37416,3035,9671,45242,32585,21442,18719,26387,24891,21217,59682,56308,429,20966,19652,53608,35088,48409,31272,55984,47665,48625,46307,42309,14394,33126,41259,33828,53317,61534,64093,62549,58308,3799,23989,21226,3942,22376,58735,16547,34968,52139,29057,29282,31480,40004,29873,23045,17435,47787,22781,26328,53861,14941,34680,6158,5481,33815,19698,21919,65380,34393,12328,19368,57527,57286,18030,15255,24412,55182,41367,39550,14953,50970,48774,25903,36473,15536,9639,29837,14045,59739,17659,29806,31878,8439,8549,4977,24163,55016,56519,39252,50396,5049,16041,54679,54859,60419,63377,1167,36145,48887,53005,37728,2372,32242,33345,7059,30477,25330,56337,43801,5053,12200,28018,31900,16582,41470,41358,1737,18741,61945,22141,39531,38140,49185,37013,45164,34067,42010,13228,49789,17180,63059,27453,50158,9346,8910,54499,42820,1129,4004,34570,13762,44739,44086,65513,60335,59936,8422,13079,33519,36812,51718,11322,27508,22806,60758,11231,62817,57741,39762,16896,34559,15138,56684,41633,44046,53030,35555,21581,43878,12872,3573,32793,2196,11299,40307,35438,11008,12434,39146,54965,48038,47199,60068,38980,18085,15494,28891,45818,44788,32790,38003,1041,10761,53601,14643,51324,11418,61176,44725,50592,22449,17560,37261,58771,36309,60090,55167,10241,23373,14780,43241,12186,41216,17405,60803,43857,58981,21364,4758,47632,15008,19275,2896,8602,21679,52060,59940,54495,44794,7918,58237,62141,41342,18297,31474,37560,24089,677,36738,9081,14819,21892,43187,51573,26891,45703,29985,47663,18460,53435,35751,38676,1062,41828,2225,6720,14926,4034,17791,4103,38319,39444,23518,57669,60980,24338,820,13269,29124,30171,40130,63825,33892,29440,582,42715,18591,24011,17121,65221,44811,60822,45421,64752,6558,3236,39902,63085,2560,33273,63597,49608,20533,61774,46339,32356,4795,56690,51512,32371,698,15104,55845,50540,58838,38036,64471,939,45578,62235,60572,40088,45679,4470,40311,33532,42503,53876,22933,25985,49817,4683,64879,46669,14359,30197,42253,10627,59530,1577,40782,307,54144,65380,58207,27912,46933,16524,35665,16984,4565,42258,48683,47130,41425,36935,62872,19270,3784,40113,58570,52724,47824,24711,19229,6440,3862,62171,32846,64422,848,24280,59068,3254,33178,50036,37438,60525,35917,39100,55422,65306,38821,33359,56357,33283,13294,60462,13610,60113,35893,36472,16490,60840,29323,37057,42116,23860,20223,34799,21682,41439,54923,61587,12226,50399,33116,52487,19085,5180,29876,45413,30789,669,65226,29504,20796,22798,45860,17274,60057,10932,50905,4303,37142,45719,53817,58275,45869,8900,38092,51445,61649,13963,23853,48896,47239,15927,41004,13034,30830,12183,52448,25568,43382,61167,21853,59819,62777,63188,28621,47297,56630,20173,5585,34650,30650,15126,50296,57113,12092,58800,13144,34495,36097,46227,13046,54053,31011,54176,44707,46865,46169,3660,63686,20783,58224,58101,13006,29862,8440,30791,26121,28576,59936,8283,30711,39675,31534,2742,18535,36809,30995,19514,38257,21171,61313,47833,35018,52175,34806,40838,19434,56324,42319,12360,24916,13301,40313,52271,64021,49566,34441,26508,2745,57522,52442,18480,32557,507,60383,9958,64418,29953,2529,24622,16087,24575,1132,23498,28176,57407,48938,45690,31733,4976,63853,20254,50090,35382,7753,11685,44032,11390,21413,18560,60063,56268,4653,34742,49477,55689,11215,3911,60117,63367,62579,11557,64232,20425,32374,28566,3063,65383,11129,7234,8328,27451,28776,17688,49608,35297,57276,16454,14802,52529,57227,62301,61711,43670,1806,60849,12145,13959,59334,62231,34727,57051,43148,16209,42669,4978,64014,11712,33154,34453,7439,56752,34885,33074,44229,33177,44287,51658,47469,28565,11815,40416,30902,43122,37871,54415,65052,18698,42351,49179,53717,20204,9542,13746,62866,2272,43275,31636,3632,39672,18401,39430,47014,62167,26353,39564,20734,20820,64473,34652,35276,25330,8758,4137,22941,63429,41802,5847,54065,54579,28219,54803,20056,25078,54860,36811,36332,12650,46487,34072,11240,53002,61847,14314,38902,9727,46723,60387,7988,42921,32818,38751,26040,23288,11421,16300,41924,45669,39098,59297,19859,29983,28573,11745,54491,46242,15114,16684,3552,55906,16542,36799,50443,2955,22830,29754,61912,27051,38814,49946,54630,1028,38685,41966,48482,7604,1465,34290,30617,10642,32854,20447,15608,42263,4608,46313,28029,15958,16178,6186,14722,60329,34003,32124,19456,33492,60707,27340,56128,50780,59891,23941,8635,20178,20994,5411,16213,64002,55967,8770,6727,64790,35974,35134,64081,12133,14973,49216,26553,8638,22142,57242,58100,12909,47995,31602,15276,21354,15542,32860,56780,24589,45218,7568,3009,7479,18166,13492,310,18695,45996,56751,55170,29797,18453,40988,48414,52450,14728,57842,32586,711,46857,63324,40114,16968,1465,40503,2703,46504,690,7737,14328,50795,14697,27651,58296,16866,20994,40731,3561,5192,25072,163,52334,31741,44500,35979,40949,52990,57602,26489,36251,11611,10982,22567,23036,14318,28015,36342,36563,38243,21963,38483,7864,15708,41252,43112,17435,34474,53657,280,58236,41280},
} ;

static void test_encode_953xint16_impl(long long impl)
{
  unsigned char *s = test_encode_953xint16_s;
  unsigned char *x = test_encode_953xint16_x;
  unsigned char *s2 = test_encode_953xint16_s2;
  unsigned char *x2 = test_encode_953xint16_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_953xint16_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_953xint16(impl);
    printf("encode_953xint16 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_953xint16_implementation(impl),ntruprime_dispatch_encode_953xint16_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_953xint16;
    printf("encode_953xint16 selected implementation %s compiler %s\n",ntruprime_encode_953xint16_implementation(),ntruprime_encode_953xint16_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_953xint16_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_953xint16_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_953xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_953xint16_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_953xint16_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_953xint16_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_953xint16(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"953xint16")) return;
  storage_encode_953xint16_s = callocplus(crypto_encode_STRBYTES);
  test_encode_953xint16_s = aligned(storage_encode_953xint16_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_953xint16_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_953xint16_x = aligned(storage_encode_953xint16_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_953xint16_s2 = callocplus(maxalloc);
  test_encode_953xint16_s2 = aligned(storage_encode_953xint16_s2,crypto_encode_STRBYTES);
  storage_encode_953xint16_x2 = callocplus(maxalloc);
  test_encode_953xint16_x2 = aligned(storage_encode_953xint16_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_953xint16 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_953xint16();++impl)
      forked(test_encode_953xint16_impl,impl);
    ++test_encode_953xint16_s;
    ++test_encode_953xint16_x;
    ++test_encode_953xint16_s2;
    ++test_encode_953xint16_x2;
  }
  free(storage_encode_953xint16_x2);
  free(storage_encode_953xint16_s2);
  free(storage_encode_953xint16_x);
  free(storage_encode_953xint16_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

