// Geometric Tools, LLC
// Copyright (c) 1998-2014
// Distributed under the Boost Software License, Version 1.0.
// http://www.boost.org/LICENSE_1_0.txt
// http://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
//
// File Version: 5.0.1 (2010/10/01)

#ifndef WM5DISTPOINT3TRIANGLE3_H
#define WM5DISTPOINT3TRIANGLE3_H

#include "Wm5MathematicsLIB.h"
#include "Wm5Distance.h"
#include "Wm5Triangle3.h"

namespace Wm5
{

template <typename Real>
class WM5_MATHEMATICS_ITEM DistPoint3Triangle3
    : public Distance<Real,Vector3<Real> >
{
public:
    DistPoint3Triangle3 (const Vector3<Real>& point,
        const Triangle3<Real>& triangle);

    // Object access.
    const Vector3<Real>& GetPoint () const;
    const Triangle3<Real>& GetTriangle () const;

    // Static distance queries.
    virtual Real Get ();
    virtual Real GetSquared ();

    // Function calculations for dynamic distance queries.
    virtual Real Get (Real t, const Vector3<Real>& velocity0,
        const Vector3<Real>& velocity1);
    virtual Real GetSquared (Real t, const Vector3<Real>& velocity0,
        const Vector3<Real>& velocity1);

    // Information about the closest triangle point.
    Real GetTriangleBary (int i) const;

private:
    using Distance<Real,Vector3<Real> >::mClosestPoint0;
    using Distance<Real,Vector3<Real> >::mClosestPoint1;

    const Vector3<Real>* mPoint;
    const Triangle3<Real>* mTriangle;

    // Information about the closest triangle point.
    Real mTriangleBary[3];  // closest1 = sum_{i=0}^2 bary[i]*tri.vertex[i]
};

typedef DistPoint3Triangle3<float> DistPoint3Triangle3f;
typedef DistPoint3Triangle3<double> DistPoint3Triangle3d;

}

#endif
