/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Qt includes


/////////////////////// Local includes
#include "MsXpS/libXpertMassCore/globals.hpp"
#include "MsXpS/libXpertMassCore/Oligomer.hpp"


namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC OligomerCollection : public QObject
{
  Q_OBJECT

  public:
  OligomerCollection(const QString &name        = QString(),
                     PolymerCstQSPtr polymer_cqsp = nullptr,
                     Enums::MassType mass_type         = Enums::MassType::BOTH);
  OligomerCollection(const OligomerCollection &other);

  virtual ~OligomerCollection();

  void setPolymer(PolymerCstQSPtr polymer_cqsp);
  const PolymerCstQSPtr getPolymer() const;

  void setName(const QString &name);
  const QString &getName() const;

  void setComment(const QString &comment);
  const QString &getComment() const;

  const std::vector<OligomerSPtr> &getOligomersCstRef() const;
  std::vector<OligomerSPtr> &getOligomersRef();

  void setMassType(Enums::MassType mass_type);
  Enums::MassType getMassType() const;

  OligomerSPtr findOligomerEncompassing(std::size_t monomer_index,
                                        std::size_t &oligomer_index);
  OligomerSPtr findOligomerEncompassing(MonomerCstSPtr monomer_csp,
                                        std::size_t &oligomer_index);
  OligomerSPtr findOligomerEncompassing(MonomerSPtr monomer_sp,
                                        std::size_t &oligomer_index);

  // In the methods below, Enums::MassType is by default MASS_NONE,
  // which means that the value of the variable is to be read in the
  // member m_massType.

  QString allOligomerMassesToString(Enums::MassType mass_type);

  static bool monoMassCompare(const OligomerSPtr o1_sp,
                              const OligomerSPtr o2_sp);
  static bool avgMassCompare(const OligomerSPtr o1_sp,
                             const OligomerSPtr o2_sp);

  void sortAscending();
  void sortDescending();

  std::size_t size() const;

  QString toString() const;

  void clear();

  OligomerCollection &operator=(const OligomerCollection &other);
  bool operator==(const OligomerCollection &other) const;
  bool operator!=(const OligomerCollection &other) const;


  protected:
  QString m_name;
  QString m_comment;
  PolymerCstQSPtr mcsp_polymer;
  Enums::MassType m_massType;

  std::vector<OligomerSPtr> m_oligomers;
};

typedef std::shared_ptr<OligomerCollection> OligomerCollectionSPtr;
typedef std::shared_ptr<const OligomerCollection> OligomerCollectionCstSPtr;


} // namespace libXpertMassCore
} // namespace MsXpS
