"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _TelemetrySensorType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _TelemetrySensorTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TelemetrySensorType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SENSOR_UNSET: _TelemetrySensorType.ValueType  # 0
    """
    No external telemetry sensor explicitly set
    """
    BME280: _TelemetrySensorType.ValueType  # 1
    """
    High accuracy temperature, pressure, humidity
    """
    BME680: _TelemetrySensorType.ValueType  # 2
    """
    High accuracy temperature, pressure, humidity, and air resistance
    """
    MCP9808: _TelemetrySensorType.ValueType  # 3
    """
    Very high accuracy temperature
    """
    INA260: _TelemetrySensorType.ValueType  # 4
    """
    Moderate accuracy current and voltage
    """
    INA219: _TelemetrySensorType.ValueType  # 5
    """
    Moderate accuracy current and voltage
    """
    BMP280: _TelemetrySensorType.ValueType  # 6
    """
    High accuracy temperature and pressure
    """
    SHTC3: _TelemetrySensorType.ValueType  # 7
    """
    High accuracy temperature and humidity
    """
    LPS22: _TelemetrySensorType.ValueType  # 8
    """
    High accuracy pressure
    """
    QMC6310: _TelemetrySensorType.ValueType  # 9
    """
    3-Axis magnetic sensor
    """
    QMI8658: _TelemetrySensorType.ValueType  # 10
    """
    6-Axis inertial measurement sensor
    """
    QMC5883L: _TelemetrySensorType.ValueType  # 11
    """
    3-Axis magnetic sensor
    """
    SHT31: _TelemetrySensorType.ValueType  # 12
    """
    High accuracy temperature and humidity
    """
    PMSA003I: _TelemetrySensorType.ValueType  # 13
    """
    PM2.5 air quality sensor
    """
    INA3221: _TelemetrySensorType.ValueType  # 14
    """
    INA3221 3 Channel Voltage / Current Sensor
    """
    BMP085: _TelemetrySensorType.ValueType  # 15
    """
    BMP085/BMP180 High accuracy temperature and pressure (older Version of BMP280)
    """
    RCWL9620: _TelemetrySensorType.ValueType  # 16
    """
    RCWL-9620 Doppler Radar Distance Sensor, used for water level detection
    """
    SHT4X: _TelemetrySensorType.ValueType  # 17
    """
    Sensirion High accuracy temperature and humidity
    """
    VEML7700: _TelemetrySensorType.ValueType  # 18
    """
    VEML7700 high accuracy ambient light(Lux) digital 16-bit resolution sensor.
    """
    MLX90632: _TelemetrySensorType.ValueType  # 19
    """
    MLX90632 non-contact IR temperature sensor.
    """
    OPT3001: _TelemetrySensorType.ValueType  # 20
    """
    TI OPT3001 Ambient Light Sensor
    """
    LTR390UV: _TelemetrySensorType.ValueType  # 21
    """
    Lite On LTR-390UV-01 UV Light Sensor
    """
    TSL25911FN: _TelemetrySensorType.ValueType  # 22
    """
    AMS TSL25911FN RGB Light Sensor
    """
    AHT10: _TelemetrySensorType.ValueType  # 23
    """
    AHT10 Integrated temperature and humidity sensor
    """
    DFROBOT_LARK: _TelemetrySensorType.ValueType  # 24
    """
    DFRobot Lark Weather station (temperature, humidity, pressure, wind speed and direction)
    """
    NAU7802: _TelemetrySensorType.ValueType  # 25
    """
    NAU7802 Scale Chip or compatible
    """
    BMP3XX: _TelemetrySensorType.ValueType  # 26
    """
    BMP3XX High accuracy temperature and pressure
    """
    ICM20948: _TelemetrySensorType.ValueType  # 27
    """
    ICM-20948 9-Axis digital motion processor
    """
    MAX17048: _TelemetrySensorType.ValueType  # 28
    """
    MAX17048 1S lipo battery sensor (voltage, state of charge, time to go)
    """
    CUSTOM_SENSOR: _TelemetrySensorType.ValueType  # 29
    """
    Custom I2C sensor implementation based on https://github.com/meshtastic/i2c-sensor
    """
    MAX30102: _TelemetrySensorType.ValueType  # 30
    """
    MAX30102 Pulse Oximeter and Heart-Rate Sensor
    """
    MLX90614: _TelemetrySensorType.ValueType  # 31
    """
    MLX90614 non-contact IR temperature sensor
    """
    SCD4X: _TelemetrySensorType.ValueType  # 32
    """
    SCD40/SCD41 CO2, humidity, temperature sensor
    """
    RADSENS: _TelemetrySensorType.ValueType  # 33
    """
    ClimateGuard RadSens, radiation, Geiger-Muller Tube
    """
    INA226: _TelemetrySensorType.ValueType  # 34
    """
    High accuracy current and voltage
    """
    DFROBOT_RAIN: _TelemetrySensorType.ValueType  # 35
    """
    DFRobot Gravity tipping bucket rain gauge
    """
    DPS310: _TelemetrySensorType.ValueType  # 36
    """
    Infineon DPS310 High accuracy pressure and temperature
    """
    RAK12035: _TelemetrySensorType.ValueType  # 37
    """
    RAKWireless RAK12035 Soil Moisture Sensor Module
    """
    MAX17261: _TelemetrySensorType.ValueType  # 38
    """
    MAX17261 lipo battery gauge
    """
    PCT2075: _TelemetrySensorType.ValueType  # 39
    """
    PCT2075 Temperature Sensor
    """
    ADS1X15: _TelemetrySensorType.ValueType  # 40
    """
    ADS1X15 ADC
    """
    ADS1X15_ALT: _TelemetrySensorType.ValueType  # 41
    """
    ADS1X15 ADC_ALT
    """
    SFA30: _TelemetrySensorType.ValueType  # 42
    """
    Sensirion SFA30 Formaldehyde sensor
    """
    SEN5X: _TelemetrySensorType.ValueType  # 43
    """
    SEN5X PM SENSORS
    """
    TSL2561: _TelemetrySensorType.ValueType  # 44
    """
    TSL2561 light sensor
    """
    BH1750: _TelemetrySensorType.ValueType  # 45
    """
    BH1750 light sensor
    """

class TelemetrySensorType(_TelemetrySensorType, metaclass=_TelemetrySensorTypeEnumTypeWrapper):
    """
    Supported I2C Sensors for telemetry in Meshtastic
    """

SENSOR_UNSET: TelemetrySensorType.ValueType  # 0
"""
No external telemetry sensor explicitly set
"""
BME280: TelemetrySensorType.ValueType  # 1
"""
High accuracy temperature, pressure, humidity
"""
BME680: TelemetrySensorType.ValueType  # 2
"""
High accuracy temperature, pressure, humidity, and air resistance
"""
MCP9808: TelemetrySensorType.ValueType  # 3
"""
Very high accuracy temperature
"""
INA260: TelemetrySensorType.ValueType  # 4
"""
Moderate accuracy current and voltage
"""
INA219: TelemetrySensorType.ValueType  # 5
"""
Moderate accuracy current and voltage
"""
BMP280: TelemetrySensorType.ValueType  # 6
"""
High accuracy temperature and pressure
"""
SHTC3: TelemetrySensorType.ValueType  # 7
"""
High accuracy temperature and humidity
"""
LPS22: TelemetrySensorType.ValueType  # 8
"""
High accuracy pressure
"""
QMC6310: TelemetrySensorType.ValueType  # 9
"""
3-Axis magnetic sensor
"""
QMI8658: TelemetrySensorType.ValueType  # 10
"""
6-Axis inertial measurement sensor
"""
QMC5883L: TelemetrySensorType.ValueType  # 11
"""
3-Axis magnetic sensor
"""
SHT31: TelemetrySensorType.ValueType  # 12
"""
High accuracy temperature and humidity
"""
PMSA003I: TelemetrySensorType.ValueType  # 13
"""
PM2.5 air quality sensor
"""
INA3221: TelemetrySensorType.ValueType  # 14
"""
INA3221 3 Channel Voltage / Current Sensor
"""
BMP085: TelemetrySensorType.ValueType  # 15
"""
BMP085/BMP180 High accuracy temperature and pressure (older Version of BMP280)
"""
RCWL9620: TelemetrySensorType.ValueType  # 16
"""
RCWL-9620 Doppler Radar Distance Sensor, used for water level detection
"""
SHT4X: TelemetrySensorType.ValueType  # 17
"""
Sensirion High accuracy temperature and humidity
"""
VEML7700: TelemetrySensorType.ValueType  # 18
"""
VEML7700 high accuracy ambient light(Lux) digital 16-bit resolution sensor.
"""
MLX90632: TelemetrySensorType.ValueType  # 19
"""
MLX90632 non-contact IR temperature sensor.
"""
OPT3001: TelemetrySensorType.ValueType  # 20
"""
TI OPT3001 Ambient Light Sensor
"""
LTR390UV: TelemetrySensorType.ValueType  # 21
"""
Lite On LTR-390UV-01 UV Light Sensor
"""
TSL25911FN: TelemetrySensorType.ValueType  # 22
"""
AMS TSL25911FN RGB Light Sensor
"""
AHT10: TelemetrySensorType.ValueType  # 23
"""
AHT10 Integrated temperature and humidity sensor
"""
DFROBOT_LARK: TelemetrySensorType.ValueType  # 24
"""
DFRobot Lark Weather station (temperature, humidity, pressure, wind speed and direction)
"""
NAU7802: TelemetrySensorType.ValueType  # 25
"""
NAU7802 Scale Chip or compatible
"""
BMP3XX: TelemetrySensorType.ValueType  # 26
"""
BMP3XX High accuracy temperature and pressure
"""
ICM20948: TelemetrySensorType.ValueType  # 27
"""
ICM-20948 9-Axis digital motion processor
"""
MAX17048: TelemetrySensorType.ValueType  # 28
"""
MAX17048 1S lipo battery sensor (voltage, state of charge, time to go)
"""
CUSTOM_SENSOR: TelemetrySensorType.ValueType  # 29
"""
Custom I2C sensor implementation based on https://github.com/meshtastic/i2c-sensor
"""
MAX30102: TelemetrySensorType.ValueType  # 30
"""
MAX30102 Pulse Oximeter and Heart-Rate Sensor
"""
MLX90614: TelemetrySensorType.ValueType  # 31
"""
MLX90614 non-contact IR temperature sensor
"""
SCD4X: TelemetrySensorType.ValueType  # 32
"""
SCD40/SCD41 CO2, humidity, temperature sensor
"""
RADSENS: TelemetrySensorType.ValueType  # 33
"""
ClimateGuard RadSens, radiation, Geiger-Muller Tube
"""
INA226: TelemetrySensorType.ValueType  # 34
"""
High accuracy current and voltage
"""
DFROBOT_RAIN: TelemetrySensorType.ValueType  # 35
"""
DFRobot Gravity tipping bucket rain gauge
"""
DPS310: TelemetrySensorType.ValueType  # 36
"""
Infineon DPS310 High accuracy pressure and temperature
"""
RAK12035: TelemetrySensorType.ValueType  # 37
"""
RAKWireless RAK12035 Soil Moisture Sensor Module
"""
MAX17261: TelemetrySensorType.ValueType  # 38
"""
MAX17261 lipo battery gauge
"""
PCT2075: TelemetrySensorType.ValueType  # 39
"""
PCT2075 Temperature Sensor
"""
ADS1X15: TelemetrySensorType.ValueType  # 40
"""
ADS1X15 ADC
"""
ADS1X15_ALT: TelemetrySensorType.ValueType  # 41
"""
ADS1X15 ADC_ALT
"""
SFA30: TelemetrySensorType.ValueType  # 42
"""
Sensirion SFA30 Formaldehyde sensor
"""
SEN5X: TelemetrySensorType.ValueType  # 43
"""
SEN5X PM SENSORS
"""
TSL2561: TelemetrySensorType.ValueType  # 44
"""
TSL2561 light sensor
"""
BH1750: TelemetrySensorType.ValueType  # 45
"""
BH1750 light sensor
"""
global___TelemetrySensorType = TelemetrySensorType

@typing.final
class DeviceMetrics(google.protobuf.message.Message):
    """
    Key native device metrics such as battery level
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BATTERY_LEVEL_FIELD_NUMBER: builtins.int
    VOLTAGE_FIELD_NUMBER: builtins.int
    CHANNEL_UTILIZATION_FIELD_NUMBER: builtins.int
    AIR_UTIL_TX_FIELD_NUMBER: builtins.int
    UPTIME_SECONDS_FIELD_NUMBER: builtins.int
    battery_level: builtins.int
    """
    0-100 (>100 means powered)
    """
    voltage: builtins.float
    """
    Voltage measured
    """
    channel_utilization: builtins.float
    """
    Utilization for the current channel, including well formed TX, RX and malformed RX (aka noise).
    """
    air_util_tx: builtins.float
    """
    Percent of airtime for transmission used within the last hour.
    """
    uptime_seconds: builtins.int
    """
    How long the device has been running since the last reboot (in seconds)
    """
    def __init__(
        self,
        *,
        battery_level: builtins.int | None = ...,
        voltage: builtins.float | None = ...,
        channel_utilization: builtins.float | None = ...,
        air_util_tx: builtins.float | None = ...,
        uptime_seconds: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_air_util_tx", b"_air_util_tx", "_battery_level", b"_battery_level", "_channel_utilization", b"_channel_utilization", "_uptime_seconds", b"_uptime_seconds", "_voltage", b"_voltage", "air_util_tx", b"air_util_tx", "battery_level", b"battery_level", "channel_utilization", b"channel_utilization", "uptime_seconds", b"uptime_seconds", "voltage", b"voltage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_air_util_tx", b"_air_util_tx", "_battery_level", b"_battery_level", "_channel_utilization", b"_channel_utilization", "_uptime_seconds", b"_uptime_seconds", "_voltage", b"_voltage", "air_util_tx", b"air_util_tx", "battery_level", b"battery_level", "channel_utilization", b"channel_utilization", "uptime_seconds", b"uptime_seconds", "voltage", b"voltage"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_air_util_tx", b"_air_util_tx"]) -> typing.Literal["air_util_tx"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_battery_level", b"_battery_level"]) -> typing.Literal["battery_level"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_channel_utilization", b"_channel_utilization"]) -> typing.Literal["channel_utilization"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_uptime_seconds", b"_uptime_seconds"]) -> typing.Literal["uptime_seconds"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_voltage", b"_voltage"]) -> typing.Literal["voltage"] | None: ...

global___DeviceMetrics = DeviceMetrics

@typing.final
class EnvironmentMetrics(google.protobuf.message.Message):
    """
    Weather station or other environmental metrics
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEMPERATURE_FIELD_NUMBER: builtins.int
    RELATIVE_HUMIDITY_FIELD_NUMBER: builtins.int
    BAROMETRIC_PRESSURE_FIELD_NUMBER: builtins.int
    GAS_RESISTANCE_FIELD_NUMBER: builtins.int
    VOLTAGE_FIELD_NUMBER: builtins.int
    CURRENT_FIELD_NUMBER: builtins.int
    IAQ_FIELD_NUMBER: builtins.int
    DISTANCE_FIELD_NUMBER: builtins.int
    LUX_FIELD_NUMBER: builtins.int
    WHITE_LUX_FIELD_NUMBER: builtins.int
    IR_LUX_FIELD_NUMBER: builtins.int
    UV_LUX_FIELD_NUMBER: builtins.int
    WIND_DIRECTION_FIELD_NUMBER: builtins.int
    WIND_SPEED_FIELD_NUMBER: builtins.int
    WEIGHT_FIELD_NUMBER: builtins.int
    WIND_GUST_FIELD_NUMBER: builtins.int
    WIND_LULL_FIELD_NUMBER: builtins.int
    RADIATION_FIELD_NUMBER: builtins.int
    RAINFALL_1H_FIELD_NUMBER: builtins.int
    RAINFALL_24H_FIELD_NUMBER: builtins.int
    SOIL_MOISTURE_FIELD_NUMBER: builtins.int
    SOIL_TEMPERATURE_FIELD_NUMBER: builtins.int
    temperature: builtins.float
    """
    Temperature measured
    """
    relative_humidity: builtins.float
    """
    Relative humidity percent measured
    """
    barometric_pressure: builtins.float
    """
    Barometric pressure in hPA measured
    """
    gas_resistance: builtins.float
    """
    Gas resistance in MOhm measured
    """
    voltage: builtins.float
    """
    Voltage measured (To be depreciated in favor of PowerMetrics in Meshtastic 3.x)
    """
    current: builtins.float
    """
    Current measured (To be depreciated in favor of PowerMetrics in Meshtastic 3.x)
    """
    iaq: builtins.int
    """
    relative scale IAQ value as measured by Bosch BME680 . value 0-500.
    Belongs to Air Quality but is not particle but VOC measurement. Other VOC values can also be put in here.
    """
    distance: builtins.float
    """
    RCWL9620 Doppler Radar Distance Sensor, used for water level detection. Float value in mm.
    """
    lux: builtins.float
    """
    VEML7700 high accuracy ambient light(Lux) digital 16-bit resolution sensor.
    """
    white_lux: builtins.float
    """
    VEML7700 high accuracy white light(irradiance) not calibrated digital 16-bit resolution sensor.
    """
    ir_lux: builtins.float
    """
    Infrared lux
    """
    uv_lux: builtins.float
    """
    Ultraviolet lux
    """
    wind_direction: builtins.int
    """
    Wind direction in degrees
    0 degrees = North, 90 = East, etc...
    """
    wind_speed: builtins.float
    """
    Wind speed in m/s
    """
    weight: builtins.float
    """
    Weight in KG
    """
    wind_gust: builtins.float
    """
    Wind gust in m/s
    """
    wind_lull: builtins.float
    """
    Wind lull in m/s
    """
    radiation: builtins.float
    """
    Radiation in µR/h
    """
    rainfall_1h: builtins.float
    """
    Rainfall in the last hour in mm
    """
    rainfall_24h: builtins.float
    """
    Rainfall in the last 24 hours in mm
    """
    soil_moisture: builtins.int
    """
    Soil moisture measured (% 1-100)
    """
    soil_temperature: builtins.float
    """
    Soil temperature measured (*C)
    """
    def __init__(
        self,
        *,
        temperature: builtins.float | None = ...,
        relative_humidity: builtins.float | None = ...,
        barometric_pressure: builtins.float | None = ...,
        gas_resistance: builtins.float | None = ...,
        voltage: builtins.float | None = ...,
        current: builtins.float | None = ...,
        iaq: builtins.int | None = ...,
        distance: builtins.float | None = ...,
        lux: builtins.float | None = ...,
        white_lux: builtins.float | None = ...,
        ir_lux: builtins.float | None = ...,
        uv_lux: builtins.float | None = ...,
        wind_direction: builtins.int | None = ...,
        wind_speed: builtins.float | None = ...,
        weight: builtins.float | None = ...,
        wind_gust: builtins.float | None = ...,
        wind_lull: builtins.float | None = ...,
        radiation: builtins.float | None = ...,
        rainfall_1h: builtins.float | None = ...,
        rainfall_24h: builtins.float | None = ...,
        soil_moisture: builtins.int | None = ...,
        soil_temperature: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_barometric_pressure", b"_barometric_pressure", "_current", b"_current", "_distance", b"_distance", "_gas_resistance", b"_gas_resistance", "_iaq", b"_iaq", "_ir_lux", b"_ir_lux", "_lux", b"_lux", "_radiation", b"_radiation", "_rainfall_1h", b"_rainfall_1h", "_rainfall_24h", b"_rainfall_24h", "_relative_humidity", b"_relative_humidity", "_soil_moisture", b"_soil_moisture", "_soil_temperature", b"_soil_temperature", "_temperature", b"_temperature", "_uv_lux", b"_uv_lux", "_voltage", b"_voltage", "_weight", b"_weight", "_white_lux", b"_white_lux", "_wind_direction", b"_wind_direction", "_wind_gust", b"_wind_gust", "_wind_lull", b"_wind_lull", "_wind_speed", b"_wind_speed", "barometric_pressure", b"barometric_pressure", "current", b"current", "distance", b"distance", "gas_resistance", b"gas_resistance", "iaq", b"iaq", "ir_lux", b"ir_lux", "lux", b"lux", "radiation", b"radiation", "rainfall_1h", b"rainfall_1h", "rainfall_24h", b"rainfall_24h", "relative_humidity", b"relative_humidity", "soil_moisture", b"soil_moisture", "soil_temperature", b"soil_temperature", "temperature", b"temperature", "uv_lux", b"uv_lux", "voltage", b"voltage", "weight", b"weight", "white_lux", b"white_lux", "wind_direction", b"wind_direction", "wind_gust", b"wind_gust", "wind_lull", b"wind_lull", "wind_speed", b"wind_speed"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_barometric_pressure", b"_barometric_pressure", "_current", b"_current", "_distance", b"_distance", "_gas_resistance", b"_gas_resistance", "_iaq", b"_iaq", "_ir_lux", b"_ir_lux", "_lux", b"_lux", "_radiation", b"_radiation", "_rainfall_1h", b"_rainfall_1h", "_rainfall_24h", b"_rainfall_24h", "_relative_humidity", b"_relative_humidity", "_soil_moisture", b"_soil_moisture", "_soil_temperature", b"_soil_temperature", "_temperature", b"_temperature", "_uv_lux", b"_uv_lux", "_voltage", b"_voltage", "_weight", b"_weight", "_white_lux", b"_white_lux", "_wind_direction", b"_wind_direction", "_wind_gust", b"_wind_gust", "_wind_lull", b"_wind_lull", "_wind_speed", b"_wind_speed", "barometric_pressure", b"barometric_pressure", "current", b"current", "distance", b"distance", "gas_resistance", b"gas_resistance", "iaq", b"iaq", "ir_lux", b"ir_lux", "lux", b"lux", "radiation", b"radiation", "rainfall_1h", b"rainfall_1h", "rainfall_24h", b"rainfall_24h", "relative_humidity", b"relative_humidity", "soil_moisture", b"soil_moisture", "soil_temperature", b"soil_temperature", "temperature", b"temperature", "uv_lux", b"uv_lux", "voltage", b"voltage", "weight", b"weight", "white_lux", b"white_lux", "wind_direction", b"wind_direction", "wind_gust", b"wind_gust", "wind_lull", b"wind_lull", "wind_speed", b"wind_speed"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_barometric_pressure", b"_barometric_pressure"]) -> typing.Literal["barometric_pressure"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_current", b"_current"]) -> typing.Literal["current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_distance", b"_distance"]) -> typing.Literal["distance"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_gas_resistance", b"_gas_resistance"]) -> typing.Literal["gas_resistance"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_iaq", b"_iaq"]) -> typing.Literal["iaq"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ir_lux", b"_ir_lux"]) -> typing.Literal["ir_lux"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_lux", b"_lux"]) -> typing.Literal["lux"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_radiation", b"_radiation"]) -> typing.Literal["radiation"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_rainfall_1h", b"_rainfall_1h"]) -> typing.Literal["rainfall_1h"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_rainfall_24h", b"_rainfall_24h"]) -> typing.Literal["rainfall_24h"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_relative_humidity", b"_relative_humidity"]) -> typing.Literal["relative_humidity"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_soil_moisture", b"_soil_moisture"]) -> typing.Literal["soil_moisture"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_soil_temperature", b"_soil_temperature"]) -> typing.Literal["soil_temperature"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_temperature", b"_temperature"]) -> typing.Literal["temperature"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_uv_lux", b"_uv_lux"]) -> typing.Literal["uv_lux"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_voltage", b"_voltage"]) -> typing.Literal["voltage"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_weight", b"_weight"]) -> typing.Literal["weight"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_white_lux", b"_white_lux"]) -> typing.Literal["white_lux"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_wind_direction", b"_wind_direction"]) -> typing.Literal["wind_direction"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_wind_gust", b"_wind_gust"]) -> typing.Literal["wind_gust"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_wind_lull", b"_wind_lull"]) -> typing.Literal["wind_lull"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_wind_speed", b"_wind_speed"]) -> typing.Literal["wind_speed"] | None: ...

global___EnvironmentMetrics = EnvironmentMetrics

@typing.final
class PowerMetrics(google.protobuf.message.Message):
    """
    Power Metrics (voltage / current / etc)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CH1_VOLTAGE_FIELD_NUMBER: builtins.int
    CH1_CURRENT_FIELD_NUMBER: builtins.int
    CH2_VOLTAGE_FIELD_NUMBER: builtins.int
    CH2_CURRENT_FIELD_NUMBER: builtins.int
    CH3_VOLTAGE_FIELD_NUMBER: builtins.int
    CH3_CURRENT_FIELD_NUMBER: builtins.int
    CH4_VOLTAGE_FIELD_NUMBER: builtins.int
    CH4_CURRENT_FIELD_NUMBER: builtins.int
    CH5_VOLTAGE_FIELD_NUMBER: builtins.int
    CH5_CURRENT_FIELD_NUMBER: builtins.int
    CH6_VOLTAGE_FIELD_NUMBER: builtins.int
    CH6_CURRENT_FIELD_NUMBER: builtins.int
    CH7_VOLTAGE_FIELD_NUMBER: builtins.int
    CH7_CURRENT_FIELD_NUMBER: builtins.int
    CH8_VOLTAGE_FIELD_NUMBER: builtins.int
    CH8_CURRENT_FIELD_NUMBER: builtins.int
    ch1_voltage: builtins.float
    """
    Voltage (Ch1)
    """
    ch1_current: builtins.float
    """
    Current (Ch1)
    """
    ch2_voltage: builtins.float
    """
    Voltage (Ch2)
    """
    ch2_current: builtins.float
    """
    Current (Ch2)
    """
    ch3_voltage: builtins.float
    """
    Voltage (Ch3)
    """
    ch3_current: builtins.float
    """
    Current (Ch3)
    """
    ch4_voltage: builtins.float
    """
    Voltage (Ch4)
    """
    ch4_current: builtins.float
    """
    Current (Ch4)
    """
    ch5_voltage: builtins.float
    """
    Voltage (Ch5)
    """
    ch5_current: builtins.float
    """
    Current (Ch5)
    """
    ch6_voltage: builtins.float
    """
    Voltage (Ch6)
    """
    ch6_current: builtins.float
    """
    Current (Ch6)
    """
    ch7_voltage: builtins.float
    """
    Voltage (Ch7)
    """
    ch7_current: builtins.float
    """
    Current (Ch7)
    """
    ch8_voltage: builtins.float
    """
    Voltage (Ch8)
    """
    ch8_current: builtins.float
    """
    Current (Ch8)
    """
    def __init__(
        self,
        *,
        ch1_voltage: builtins.float | None = ...,
        ch1_current: builtins.float | None = ...,
        ch2_voltage: builtins.float | None = ...,
        ch2_current: builtins.float | None = ...,
        ch3_voltage: builtins.float | None = ...,
        ch3_current: builtins.float | None = ...,
        ch4_voltage: builtins.float | None = ...,
        ch4_current: builtins.float | None = ...,
        ch5_voltage: builtins.float | None = ...,
        ch5_current: builtins.float | None = ...,
        ch6_voltage: builtins.float | None = ...,
        ch6_current: builtins.float | None = ...,
        ch7_voltage: builtins.float | None = ...,
        ch7_current: builtins.float | None = ...,
        ch8_voltage: builtins.float | None = ...,
        ch8_current: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_ch1_current", b"_ch1_current", "_ch1_voltage", b"_ch1_voltage", "_ch2_current", b"_ch2_current", "_ch2_voltage", b"_ch2_voltage", "_ch3_current", b"_ch3_current", "_ch3_voltage", b"_ch3_voltage", "_ch4_current", b"_ch4_current", "_ch4_voltage", b"_ch4_voltage", "_ch5_current", b"_ch5_current", "_ch5_voltage", b"_ch5_voltage", "_ch6_current", b"_ch6_current", "_ch6_voltage", b"_ch6_voltage", "_ch7_current", b"_ch7_current", "_ch7_voltage", b"_ch7_voltage", "_ch8_current", b"_ch8_current", "_ch8_voltage", b"_ch8_voltage", "ch1_current", b"ch1_current", "ch1_voltage", b"ch1_voltage", "ch2_current", b"ch2_current", "ch2_voltage", b"ch2_voltage", "ch3_current", b"ch3_current", "ch3_voltage", b"ch3_voltage", "ch4_current", b"ch4_current", "ch4_voltage", b"ch4_voltage", "ch5_current", b"ch5_current", "ch5_voltage", b"ch5_voltage", "ch6_current", b"ch6_current", "ch6_voltage", b"ch6_voltage", "ch7_current", b"ch7_current", "ch7_voltage", b"ch7_voltage", "ch8_current", b"ch8_current", "ch8_voltage", b"ch8_voltage"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_ch1_current", b"_ch1_current", "_ch1_voltage", b"_ch1_voltage", "_ch2_current", b"_ch2_current", "_ch2_voltage", b"_ch2_voltage", "_ch3_current", b"_ch3_current", "_ch3_voltage", b"_ch3_voltage", "_ch4_current", b"_ch4_current", "_ch4_voltage", b"_ch4_voltage", "_ch5_current", b"_ch5_current", "_ch5_voltage", b"_ch5_voltage", "_ch6_current", b"_ch6_current", "_ch6_voltage", b"_ch6_voltage", "_ch7_current", b"_ch7_current", "_ch7_voltage", b"_ch7_voltage", "_ch8_current", b"_ch8_current", "_ch8_voltage", b"_ch8_voltage", "ch1_current", b"ch1_current", "ch1_voltage", b"ch1_voltage", "ch2_current", b"ch2_current", "ch2_voltage", b"ch2_voltage", "ch3_current", b"ch3_current", "ch3_voltage", b"ch3_voltage", "ch4_current", b"ch4_current", "ch4_voltage", b"ch4_voltage", "ch5_current", b"ch5_current", "ch5_voltage", b"ch5_voltage", "ch6_current", b"ch6_current", "ch6_voltage", b"ch6_voltage", "ch7_current", b"ch7_current", "ch7_voltage", b"ch7_voltage", "ch8_current", b"ch8_current", "ch8_voltage", b"ch8_voltage"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch1_current", b"_ch1_current"]) -> typing.Literal["ch1_current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch1_voltage", b"_ch1_voltage"]) -> typing.Literal["ch1_voltage"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch2_current", b"_ch2_current"]) -> typing.Literal["ch2_current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch2_voltage", b"_ch2_voltage"]) -> typing.Literal["ch2_voltage"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch3_current", b"_ch3_current"]) -> typing.Literal["ch3_current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch3_voltage", b"_ch3_voltage"]) -> typing.Literal["ch3_voltage"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch4_current", b"_ch4_current"]) -> typing.Literal["ch4_current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch4_voltage", b"_ch4_voltage"]) -> typing.Literal["ch4_voltage"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch5_current", b"_ch5_current"]) -> typing.Literal["ch5_current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch5_voltage", b"_ch5_voltage"]) -> typing.Literal["ch5_voltage"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch6_current", b"_ch6_current"]) -> typing.Literal["ch6_current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch6_voltage", b"_ch6_voltage"]) -> typing.Literal["ch6_voltage"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch7_current", b"_ch7_current"]) -> typing.Literal["ch7_current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch7_voltage", b"_ch7_voltage"]) -> typing.Literal["ch7_voltage"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch8_current", b"_ch8_current"]) -> typing.Literal["ch8_current"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_ch8_voltage", b"_ch8_voltage"]) -> typing.Literal["ch8_voltage"] | None: ...

global___PowerMetrics = PowerMetrics

@typing.final
class AirQualityMetrics(google.protobuf.message.Message):
    """
    Air quality metrics
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PM10_STANDARD_FIELD_NUMBER: builtins.int
    PM25_STANDARD_FIELD_NUMBER: builtins.int
    PM100_STANDARD_FIELD_NUMBER: builtins.int
    PM10_ENVIRONMENTAL_FIELD_NUMBER: builtins.int
    PM25_ENVIRONMENTAL_FIELD_NUMBER: builtins.int
    PM100_ENVIRONMENTAL_FIELD_NUMBER: builtins.int
    PARTICLES_03UM_FIELD_NUMBER: builtins.int
    PARTICLES_05UM_FIELD_NUMBER: builtins.int
    PARTICLES_10UM_FIELD_NUMBER: builtins.int
    PARTICLES_25UM_FIELD_NUMBER: builtins.int
    PARTICLES_50UM_FIELD_NUMBER: builtins.int
    PARTICLES_100UM_FIELD_NUMBER: builtins.int
    CO2_FIELD_NUMBER: builtins.int
    CO2_TEMPERATURE_FIELD_NUMBER: builtins.int
    CO2_HUMIDITY_FIELD_NUMBER: builtins.int
    FORM_FORMALDEHYDE_FIELD_NUMBER: builtins.int
    FORM_HUMIDITY_FIELD_NUMBER: builtins.int
    FORM_TEMPERATURE_FIELD_NUMBER: builtins.int
    PM40_STANDARD_FIELD_NUMBER: builtins.int
    PARTICLES_40UM_FIELD_NUMBER: builtins.int
    PM_TEMPERATURE_FIELD_NUMBER: builtins.int
    PM_HUMIDITY_FIELD_NUMBER: builtins.int
    PM_VOC_IDX_FIELD_NUMBER: builtins.int
    PM_NOX_IDX_FIELD_NUMBER: builtins.int
    PARTICLES_TPS_FIELD_NUMBER: builtins.int
    pm10_standard: builtins.int
    """
    Concentration Units Standard PM1.0 in ug/m3
    """
    pm25_standard: builtins.int
    """
    Concentration Units Standard PM2.5 in ug/m3
    """
    pm100_standard: builtins.int
    """
    Concentration Units Standard PM10.0 in ug/m3
    """
    pm10_environmental: builtins.int
    """
    Concentration Units Environmental PM1.0 in ug/m3
    """
    pm25_environmental: builtins.int
    """
    Concentration Units Environmental PM2.5 in ug/m3
    """
    pm100_environmental: builtins.int
    """
    Concentration Units Environmental PM10.0 in ug/m3
    """
    particles_03um: builtins.int
    """
    0.3um Particle Count in #/0.1l
    """
    particles_05um: builtins.int
    """
    0.5um Particle Count in #/0.1l
    """
    particles_10um: builtins.int
    """
    1.0um Particle Count in #/0.1l
    """
    particles_25um: builtins.int
    """
    2.5um Particle Count in #/0.1l
    """
    particles_50um: builtins.int
    """
    5.0um Particle Count in #/0.1l
    """
    particles_100um: builtins.int
    """
    10.0um Particle Count in #/0.1l
    """
    co2: builtins.int
    """
    CO2 concentration in ppm
    """
    co2_temperature: builtins.float
    """
    CO2 sensor temperature in degC
    """
    co2_humidity: builtins.float
    """
    CO2 sensor relative humidity in %
    """
    form_formaldehyde: builtins.float
    """
    Formaldehyde sensor formaldehyde concentration in ppb
    """
    form_humidity: builtins.float
    """
    Formaldehyde sensor relative humidity in %RH
    """
    form_temperature: builtins.float
    """
    Formaldehyde sensor temperature in degrees Celsius
    """
    pm40_standard: builtins.int
    """
    Concentration Units Standard PM4.0 in ug/m3
    """
    particles_40um: builtins.int
    """
    4.0um Particle Count in #/0.1l
    """
    pm_temperature: builtins.float
    """
    PM Sensor Temperature
    """
    pm_humidity: builtins.float
    """
    PM Sensor humidity
    """
    pm_voc_idx: builtins.float
    """
    PM Sensor VOC Index
    """
    pm_nox_idx: builtins.float
    """
    PM Sensor NOx Index
    """
    particles_tps: builtins.float
    """
    Typical Particle Size in um
    """
    def __init__(
        self,
        *,
        pm10_standard: builtins.int | None = ...,
        pm25_standard: builtins.int | None = ...,
        pm100_standard: builtins.int | None = ...,
        pm10_environmental: builtins.int | None = ...,
        pm25_environmental: builtins.int | None = ...,
        pm100_environmental: builtins.int | None = ...,
        particles_03um: builtins.int | None = ...,
        particles_05um: builtins.int | None = ...,
        particles_10um: builtins.int | None = ...,
        particles_25um: builtins.int | None = ...,
        particles_50um: builtins.int | None = ...,
        particles_100um: builtins.int | None = ...,
        co2: builtins.int | None = ...,
        co2_temperature: builtins.float | None = ...,
        co2_humidity: builtins.float | None = ...,
        form_formaldehyde: builtins.float | None = ...,
        form_humidity: builtins.float | None = ...,
        form_temperature: builtins.float | None = ...,
        pm40_standard: builtins.int | None = ...,
        particles_40um: builtins.int | None = ...,
        pm_temperature: builtins.float | None = ...,
        pm_humidity: builtins.float | None = ...,
        pm_voc_idx: builtins.float | None = ...,
        pm_nox_idx: builtins.float | None = ...,
        particles_tps: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_co2", b"_co2", "_co2_humidity", b"_co2_humidity", "_co2_temperature", b"_co2_temperature", "_form_formaldehyde", b"_form_formaldehyde", "_form_humidity", b"_form_humidity", "_form_temperature", b"_form_temperature", "_particles_03um", b"_particles_03um", "_particles_05um", b"_particles_05um", "_particles_100um", b"_particles_100um", "_particles_10um", b"_particles_10um", "_particles_25um", b"_particles_25um", "_particles_40um", b"_particles_40um", "_particles_50um", b"_particles_50um", "_particles_tps", b"_particles_tps", "_pm100_environmental", b"_pm100_environmental", "_pm100_standard", b"_pm100_standard", "_pm10_environmental", b"_pm10_environmental", "_pm10_standard", b"_pm10_standard", "_pm25_environmental", b"_pm25_environmental", "_pm25_standard", b"_pm25_standard", "_pm40_standard", b"_pm40_standard", "_pm_humidity", b"_pm_humidity", "_pm_nox_idx", b"_pm_nox_idx", "_pm_temperature", b"_pm_temperature", "_pm_voc_idx", b"_pm_voc_idx", "co2", b"co2", "co2_humidity", b"co2_humidity", "co2_temperature", b"co2_temperature", "form_formaldehyde", b"form_formaldehyde", "form_humidity", b"form_humidity", "form_temperature", b"form_temperature", "particles_03um", b"particles_03um", "particles_05um", b"particles_05um", "particles_100um", b"particles_100um", "particles_10um", b"particles_10um", "particles_25um", b"particles_25um", "particles_40um", b"particles_40um", "particles_50um", b"particles_50um", "particles_tps", b"particles_tps", "pm100_environmental", b"pm100_environmental", "pm100_standard", b"pm100_standard", "pm10_environmental", b"pm10_environmental", "pm10_standard", b"pm10_standard", "pm25_environmental", b"pm25_environmental", "pm25_standard", b"pm25_standard", "pm40_standard", b"pm40_standard", "pm_humidity", b"pm_humidity", "pm_nox_idx", b"pm_nox_idx", "pm_temperature", b"pm_temperature", "pm_voc_idx", b"pm_voc_idx"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_co2", b"_co2", "_co2_humidity", b"_co2_humidity", "_co2_temperature", b"_co2_temperature", "_form_formaldehyde", b"_form_formaldehyde", "_form_humidity", b"_form_humidity", "_form_temperature", b"_form_temperature", "_particles_03um", b"_particles_03um", "_particles_05um", b"_particles_05um", "_particles_100um", b"_particles_100um", "_particles_10um", b"_particles_10um", "_particles_25um", b"_particles_25um", "_particles_40um", b"_particles_40um", "_particles_50um", b"_particles_50um", "_particles_tps", b"_particles_tps", "_pm100_environmental", b"_pm100_environmental", "_pm100_standard", b"_pm100_standard", "_pm10_environmental", b"_pm10_environmental", "_pm10_standard", b"_pm10_standard", "_pm25_environmental", b"_pm25_environmental", "_pm25_standard", b"_pm25_standard", "_pm40_standard", b"_pm40_standard", "_pm_humidity", b"_pm_humidity", "_pm_nox_idx", b"_pm_nox_idx", "_pm_temperature", b"_pm_temperature", "_pm_voc_idx", b"_pm_voc_idx", "co2", b"co2", "co2_humidity", b"co2_humidity", "co2_temperature", b"co2_temperature", "form_formaldehyde", b"form_formaldehyde", "form_humidity", b"form_humidity", "form_temperature", b"form_temperature", "particles_03um", b"particles_03um", "particles_05um", b"particles_05um", "particles_100um", b"particles_100um", "particles_10um", b"particles_10um", "particles_25um", b"particles_25um", "particles_40um", b"particles_40um", "particles_50um", b"particles_50um", "particles_tps", b"particles_tps", "pm100_environmental", b"pm100_environmental", "pm100_standard", b"pm100_standard", "pm10_environmental", b"pm10_environmental", "pm10_standard", b"pm10_standard", "pm25_environmental", b"pm25_environmental", "pm25_standard", b"pm25_standard", "pm40_standard", b"pm40_standard", "pm_humidity", b"pm_humidity", "pm_nox_idx", b"pm_nox_idx", "pm_temperature", b"pm_temperature", "pm_voc_idx", b"pm_voc_idx"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_co2", b"_co2"]) -> typing.Literal["co2"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_co2_humidity", b"_co2_humidity"]) -> typing.Literal["co2_humidity"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_co2_temperature", b"_co2_temperature"]) -> typing.Literal["co2_temperature"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_form_formaldehyde", b"_form_formaldehyde"]) -> typing.Literal["form_formaldehyde"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_form_humidity", b"_form_humidity"]) -> typing.Literal["form_humidity"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_form_temperature", b"_form_temperature"]) -> typing.Literal["form_temperature"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_particles_03um", b"_particles_03um"]) -> typing.Literal["particles_03um"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_particles_05um", b"_particles_05um"]) -> typing.Literal["particles_05um"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_particles_100um", b"_particles_100um"]) -> typing.Literal["particles_100um"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_particles_10um", b"_particles_10um"]) -> typing.Literal["particles_10um"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_particles_25um", b"_particles_25um"]) -> typing.Literal["particles_25um"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_particles_40um", b"_particles_40um"]) -> typing.Literal["particles_40um"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_particles_50um", b"_particles_50um"]) -> typing.Literal["particles_50um"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_particles_tps", b"_particles_tps"]) -> typing.Literal["particles_tps"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm100_environmental", b"_pm100_environmental"]) -> typing.Literal["pm100_environmental"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm100_standard", b"_pm100_standard"]) -> typing.Literal["pm100_standard"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm10_environmental", b"_pm10_environmental"]) -> typing.Literal["pm10_environmental"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm10_standard", b"_pm10_standard"]) -> typing.Literal["pm10_standard"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm25_environmental", b"_pm25_environmental"]) -> typing.Literal["pm25_environmental"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm25_standard", b"_pm25_standard"]) -> typing.Literal["pm25_standard"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm40_standard", b"_pm40_standard"]) -> typing.Literal["pm40_standard"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm_humidity", b"_pm_humidity"]) -> typing.Literal["pm_humidity"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm_nox_idx", b"_pm_nox_idx"]) -> typing.Literal["pm_nox_idx"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm_temperature", b"_pm_temperature"]) -> typing.Literal["pm_temperature"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_pm_voc_idx", b"_pm_voc_idx"]) -> typing.Literal["pm_voc_idx"] | None: ...

global___AirQualityMetrics = AirQualityMetrics

@typing.final
class LocalStats(google.protobuf.message.Message):
    """
    Local device mesh statistics
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPTIME_SECONDS_FIELD_NUMBER: builtins.int
    CHANNEL_UTILIZATION_FIELD_NUMBER: builtins.int
    AIR_UTIL_TX_FIELD_NUMBER: builtins.int
    NUM_PACKETS_TX_FIELD_NUMBER: builtins.int
    NUM_PACKETS_RX_FIELD_NUMBER: builtins.int
    NUM_PACKETS_RX_BAD_FIELD_NUMBER: builtins.int
    NUM_ONLINE_NODES_FIELD_NUMBER: builtins.int
    NUM_TOTAL_NODES_FIELD_NUMBER: builtins.int
    NUM_RX_DUPE_FIELD_NUMBER: builtins.int
    NUM_TX_RELAY_FIELD_NUMBER: builtins.int
    NUM_TX_RELAY_CANCELED_FIELD_NUMBER: builtins.int
    HEAP_TOTAL_BYTES_FIELD_NUMBER: builtins.int
    HEAP_FREE_BYTES_FIELD_NUMBER: builtins.int
    NUM_TX_DROPPED_FIELD_NUMBER: builtins.int
    uptime_seconds: builtins.int
    """
    How long the device has been running since the last reboot (in seconds)
    """
    channel_utilization: builtins.float
    """
    Utilization for the current channel, including well formed TX, RX and malformed RX (aka noise).
    """
    air_util_tx: builtins.float
    """
    Percent of airtime for transmission used within the last hour.
    """
    num_packets_tx: builtins.int
    """
    Number of packets sent
    """
    num_packets_rx: builtins.int
    """
    Number of packets received (both good and bad)
    """
    num_packets_rx_bad: builtins.int
    """
    Number of packets received that are malformed or violate the protocol
    """
    num_online_nodes: builtins.int
    """
    Number of nodes online (in the past 2 hours)
    """
    num_total_nodes: builtins.int
    """
    Number of nodes total
    """
    num_rx_dupe: builtins.int
    """
    Number of received packets that were duplicates (due to multiple nodes relaying).
    If this number is high, there are nodes in the mesh relaying packets when it's unnecessary, for example due to the ROUTER/REPEATER role.
    """
    num_tx_relay: builtins.int
    """
    Number of packets we transmitted that were a relay for others (not originating from ourselves).
    """
    num_tx_relay_canceled: builtins.int
    """
    Number of times we canceled a packet to be relayed, because someone else did it before us.
    This will always be zero for ROUTERs/REPEATERs. If this number is high, some other node(s) is/are relaying faster than you.
    """
    heap_total_bytes: builtins.int
    """
    Number of bytes used in the heap
    """
    heap_free_bytes: builtins.int
    """
    Number of bytes free in the heap
    """
    num_tx_dropped: builtins.int
    """
    Number of packets that were dropped because the transmit queue was full.
    """
    def __init__(
        self,
        *,
        uptime_seconds: builtins.int = ...,
        channel_utilization: builtins.float = ...,
        air_util_tx: builtins.float = ...,
        num_packets_tx: builtins.int = ...,
        num_packets_rx: builtins.int = ...,
        num_packets_rx_bad: builtins.int = ...,
        num_online_nodes: builtins.int = ...,
        num_total_nodes: builtins.int = ...,
        num_rx_dupe: builtins.int = ...,
        num_tx_relay: builtins.int = ...,
        num_tx_relay_canceled: builtins.int = ...,
        heap_total_bytes: builtins.int = ...,
        heap_free_bytes: builtins.int = ...,
        num_tx_dropped: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["air_util_tx", b"air_util_tx", "channel_utilization", b"channel_utilization", "heap_free_bytes", b"heap_free_bytes", "heap_total_bytes", b"heap_total_bytes", "num_online_nodes", b"num_online_nodes", "num_packets_rx", b"num_packets_rx", "num_packets_rx_bad", b"num_packets_rx_bad", "num_packets_tx", b"num_packets_tx", "num_rx_dupe", b"num_rx_dupe", "num_total_nodes", b"num_total_nodes", "num_tx_dropped", b"num_tx_dropped", "num_tx_relay", b"num_tx_relay", "num_tx_relay_canceled", b"num_tx_relay_canceled", "uptime_seconds", b"uptime_seconds"]) -> None: ...

global___LocalStats = LocalStats

@typing.final
class HealthMetrics(google.protobuf.message.Message):
    """
    Health telemetry metrics
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEART_BPM_FIELD_NUMBER: builtins.int
    SPO2_FIELD_NUMBER: builtins.int
    TEMPERATURE_FIELD_NUMBER: builtins.int
    heart_bpm: builtins.int
    """
    Heart rate (beats per minute)
    """
    spO2: builtins.int
    """
    SpO2 (blood oxygen saturation) level
    """
    temperature: builtins.float
    """
    Body temperature in degrees Celsius
    """
    def __init__(
        self,
        *,
        heart_bpm: builtins.int | None = ...,
        spO2: builtins.int | None = ...,
        temperature: builtins.float | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_heart_bpm", b"_heart_bpm", "_spO2", b"_spO2", "_temperature", b"_temperature", "heart_bpm", b"heart_bpm", "spO2", b"spO2", "temperature", b"temperature"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_heart_bpm", b"_heart_bpm", "_spO2", b"_spO2", "_temperature", b"_temperature", "heart_bpm", b"heart_bpm", "spO2", b"spO2", "temperature", b"temperature"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_heart_bpm", b"_heart_bpm"]) -> typing.Literal["heart_bpm"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_spO2", b"_spO2"]) -> typing.Literal["spO2"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_temperature", b"_temperature"]) -> typing.Literal["temperature"] | None: ...

global___HealthMetrics = HealthMetrics

@typing.final
class HostMetrics(google.protobuf.message.Message):
    """
    Linux host metrics
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPTIME_SECONDS_FIELD_NUMBER: builtins.int
    FREEMEM_BYTES_FIELD_NUMBER: builtins.int
    DISKFREE1_BYTES_FIELD_NUMBER: builtins.int
    DISKFREE2_BYTES_FIELD_NUMBER: builtins.int
    DISKFREE3_BYTES_FIELD_NUMBER: builtins.int
    LOAD1_FIELD_NUMBER: builtins.int
    LOAD5_FIELD_NUMBER: builtins.int
    LOAD15_FIELD_NUMBER: builtins.int
    USER_STRING_FIELD_NUMBER: builtins.int
    uptime_seconds: builtins.int
    """
    Host system uptime
    """
    freemem_bytes: builtins.int
    """
    Host system free memory
    """
    diskfree1_bytes: builtins.int
    """
    Host system disk space free for /
    """
    diskfree2_bytes: builtins.int
    """
    Secondary system disk space free
    """
    diskfree3_bytes: builtins.int
    """
    Tertiary disk space free
    """
    load1: builtins.int
    """
    Host system one minute load in 1/100ths
    """
    load5: builtins.int
    """
    Host system five minute load  in 1/100ths
    """
    load15: builtins.int
    """
    Host system fifteen minute load  in 1/100ths
    """
    user_string: builtins.str
    """
    Optional User-provided string for arbitrary host system information
    that doesn't make sense as a dedicated entry.
    """
    def __init__(
        self,
        *,
        uptime_seconds: builtins.int = ...,
        freemem_bytes: builtins.int = ...,
        diskfree1_bytes: builtins.int = ...,
        diskfree2_bytes: builtins.int | None = ...,
        diskfree3_bytes: builtins.int | None = ...,
        load1: builtins.int = ...,
        load5: builtins.int = ...,
        load15: builtins.int = ...,
        user_string: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_diskfree2_bytes", b"_diskfree2_bytes", "_diskfree3_bytes", b"_diskfree3_bytes", "_user_string", b"_user_string", "diskfree2_bytes", b"diskfree2_bytes", "diskfree3_bytes", b"diskfree3_bytes", "user_string", b"user_string"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_diskfree2_bytes", b"_diskfree2_bytes", "_diskfree3_bytes", b"_diskfree3_bytes", "_user_string", b"_user_string", "diskfree1_bytes", b"diskfree1_bytes", "diskfree2_bytes", b"diskfree2_bytes", "diskfree3_bytes", b"diskfree3_bytes", "freemem_bytes", b"freemem_bytes", "load1", b"load1", "load15", b"load15", "load5", b"load5", "uptime_seconds", b"uptime_seconds", "user_string", b"user_string"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_diskfree2_bytes", b"_diskfree2_bytes"]) -> typing.Literal["diskfree2_bytes"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_diskfree3_bytes", b"_diskfree3_bytes"]) -> typing.Literal["diskfree3_bytes"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_user_string", b"_user_string"]) -> typing.Literal["user_string"] | None: ...

global___HostMetrics = HostMetrics

@typing.final
class Telemetry(google.protobuf.message.Message):
    """
    Types of Measurements the telemetry module is equipped to handle
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TIME_FIELD_NUMBER: builtins.int
    DEVICE_METRICS_FIELD_NUMBER: builtins.int
    ENVIRONMENT_METRICS_FIELD_NUMBER: builtins.int
    AIR_QUALITY_METRICS_FIELD_NUMBER: builtins.int
    POWER_METRICS_FIELD_NUMBER: builtins.int
    LOCAL_STATS_FIELD_NUMBER: builtins.int
    HEALTH_METRICS_FIELD_NUMBER: builtins.int
    HOST_METRICS_FIELD_NUMBER: builtins.int
    time: builtins.int
    """
    Seconds since 1970 - or 0 for unknown/unset
    """
    @property
    def device_metrics(self) -> global___DeviceMetrics:
        """
        Key native device metrics such as battery level
        """

    @property
    def environment_metrics(self) -> global___EnvironmentMetrics:
        """
        Weather station or other environmental metrics
        """

    @property
    def air_quality_metrics(self) -> global___AirQualityMetrics:
        """
        Air quality metrics
        """

    @property
    def power_metrics(self) -> global___PowerMetrics:
        """
        Power Metrics
        """

    @property
    def local_stats(self) -> global___LocalStats:
        """
        Local device mesh statistics
        """

    @property
    def health_metrics(self) -> global___HealthMetrics:
        """
        Health telemetry metrics
        """

    @property
    def host_metrics(self) -> global___HostMetrics:
        """
        Linux host metrics
        """

    def __init__(
        self,
        *,
        time: builtins.int = ...,
        device_metrics: global___DeviceMetrics | None = ...,
        environment_metrics: global___EnvironmentMetrics | None = ...,
        air_quality_metrics: global___AirQualityMetrics | None = ...,
        power_metrics: global___PowerMetrics | None = ...,
        local_stats: global___LocalStats | None = ...,
        health_metrics: global___HealthMetrics | None = ...,
        host_metrics: global___HostMetrics | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["air_quality_metrics", b"air_quality_metrics", "device_metrics", b"device_metrics", "environment_metrics", b"environment_metrics", "health_metrics", b"health_metrics", "host_metrics", b"host_metrics", "local_stats", b"local_stats", "power_metrics", b"power_metrics", "variant", b"variant"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["air_quality_metrics", b"air_quality_metrics", "device_metrics", b"device_metrics", "environment_metrics", b"environment_metrics", "health_metrics", b"health_metrics", "host_metrics", b"host_metrics", "local_stats", b"local_stats", "power_metrics", b"power_metrics", "time", b"time", "variant", b"variant"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["variant", b"variant"]) -> typing.Literal["device_metrics", "environment_metrics", "air_quality_metrics", "power_metrics", "local_stats", "health_metrics", "host_metrics"] | None: ...

global___Telemetry = Telemetry

@typing.final
class Nau7802Config(google.protobuf.message.Message):
    """
    NAU7802 Telemetry configuration, for saving to flash
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ZEROOFFSET_FIELD_NUMBER: builtins.int
    CALIBRATIONFACTOR_FIELD_NUMBER: builtins.int
    zeroOffset: builtins.int
    """
    The offset setting for the NAU7802
    """
    calibrationFactor: builtins.float
    """
    The calibration factor for the NAU7802
    """
    def __init__(
        self,
        *,
        zeroOffset: builtins.int = ...,
        calibrationFactor: builtins.float = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["calibrationFactor", b"calibrationFactor", "zeroOffset", b"zeroOffset"]) -> None: ...

global___Nau7802Config = Nau7802Config
