#!/usr/bin/env python3

import asyncio
import typing
from pathlib import Path

from mitmproxy.contentviews import SyntaxHighlight
from mitmproxy.proxy.mode_specs import ReverseMode

here = Path(__file__).parent.absolute()

filename = here / "../src/js/backends/consts.ts"


async def make() -> str:
    protocols = typing.get_args(typing.get_type_hints(ReverseMode)["scheme"])
    protocol_enum = ",\n    ".join(
        f'{protocol.upper()} = "{protocol.lower()}"' for protocol in protocols
    )

    langs = typing.get_args(SyntaxHighlight.__value__)
    syntax_highlight_enum = ",\n    ".join(
        f'{lang.upper()} = "{lang.lower()}"' for lang in langs
    )

    # language=TypeScript
    content = (
        "/** Auto-generated by web/gen/backend_consts.py */\n"
        "export enum ReverseProxyProtocols {\n"
        f"    {protocol_enum},\n"
        "}\n"
        "\n"
        "export enum SyntaxHighlight {\n"
        f"    {syntax_highlight_enum},\n"
        "}\n"
    )

    return content


if __name__ == "__main__":
    filename.write_bytes(asyncio.run(make()).encode())
