package uk.me.parabola.mkgmap.osmstyle.housenumber;

import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.FakeIdGenerator;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.Locatable;

class HousenumberElem implements Locatable{
	protected final Element element;
	private int housenumber;
	private String sign;
	private String place;
	private CityInfo cityInfo;
	private ZipCodeInfo zipCode;
	private String street;
	//cache for Way elements to prevent calling Way.getCofG() repeatedly
	private Coord location;
	
	public HousenumberElem(Element el, CityInfo ci) {
		this.element = el;
		this.cityInfo = ci;
	}

	public HousenumberElem(HousenumberElem he) {
		this.element = he.element;
		this.housenumber = he.housenumber;
		this.sign = he.sign;
		this.street = he.street;
		this.place = he.place;
		this.cityInfo = he.cityInfo;
		this.zipCode = he.zipCode;
		this.location = he.location;
	}

	public Element getElement() {
		return element;
	}

	public int getHousenumber() {
		return housenumber;
	}

	public void setHousenumber(int housenumber) {
		this.housenumber = housenumber;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getPlace() {
		return place;
	}

	public void setPlace(String place) {
		this.place = place;
	}

	public String getStreet() {
		return street;
	}

	public void setStreet(String street) {
		this.street = street;
	}

	public MapRoad getRoad(){
		return null;
	}
	
	public CityInfo getCityInfo(){
		return cityInfo;
	}
	
	public void setZipCode(ZipCodeInfo zip){
		zipCode = zip;
	}
	
	public ZipCodeInfo getZipCode(){
		return zipCode;
	}
	
	@Override
	public Coord getLocation() {
		if (location == null){
			if (element instanceof Node)
				location = ((Node) element).getLocation();
			else 
				location = ((Way) element).getCofG();
		}
		return location;
	}
	
	@Override
	public String toString() {
		if (street != null)
			return street + " " + sign;
		if (place != null)
			return place + " " + sign;
		return "?" + " " + sign;
	}
	
	public String toBrowseURL(){
		if (FakeIdGenerator.isFakeId(element.getId())){
			return getLocation().toOSMURL();
		}
		return element.toBrowseURL();
	}

}