/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4CMAREngine;

class T4CPlsqlIndexTableAccessor
extends PlsqlIndexTableAccessor {
    T4CMAREngine mare;
    final int[] meta = new int[1];
    final int[] tmp = new int[1];
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    T4CPlsqlIndexTableAccessor(OracleStatement oracleStatement, int n, int n2, int n3, int n4, short s, boolean bl, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n, n2, n3, n4, s, bl);
        this.calculateSizeTmpByteArray();
        this.mare = t4CMAREngine;
    }

    void processIndicator(int n) throws IOException, SQLException {
        if (this.mare.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (this.stmt.sql_kind != 1) {
                this.mare.unmarshalSB2();
            }
        } else if (this.stmt.sql_kind == 1) {
            this.mare.processIndicator(n <= 0, n);
        }
    }

    boolean unmarshalOneRow() throws SQLException, IOException {
        if (this.isUseLess) {
            ++this.lastRowProcessed;
            return false;
        }
        if (this.rowSpaceIndicator == null) {
            byte[] byArray = new byte[16000];
            this.mare.unmarshalCLR(byArray, 0, this.meta);
            this.processIndicator(this.meta[0]);
            ++this.lastRowProcessed;
            return false;
        }
        int n = this.indicatorIndex + this.lastRowProcessed;
        int n2 = this.lengthIndex + this.lastRowProcessed;
        byte[] byArray = this.stmt.ibtBindBytes;
        char[] cArray = this.stmt.ibtBindChars;
        short[] sArray = this.stmt.ibtBindIndicators;
        int n3 = this.stmt.ibtBindByteOffset;
        int n4 = this.stmt.ibtBindCharOffset;
        int n5 = this.stmt.ibtBindIndicatorOffset;
        if (this.isNullByDescribe) {
            this.rowSpaceIndicator[n] = -1;
            this.rowSpaceIndicator[n2] = 0;
            ++this.lastRowProcessed;
            if (this.mare.versionNumber < 9200) {
                this.processIndicator(0);
            }
            return false;
        }
        int n6 = (int)this.mare.unmarshalUB4();
        sArray[this.ibtMetaIndex + 4] = (short)(n6 & 0xFFFFFFFF & 0xFFFF);
        sArray[this.ibtMetaIndex + 5] = (short)(n6 & 0xFFFF);
        if (this.element_internal_type == 9 || this.element_internal_type == 96 || this.element_internal_type == 1) {
            byte[] byArray2 = this.stmt.tmpByteArray;
            for (int i = 0; i < n6; ++i) {
                int n7 = this.ibtValueIndex + this.element_max_len * i;
                this.mare.unmarshalCLR(byArray2, 0, this.meta);
                this.tmp[0] = this.meta[0];
                int n8 = this.stmt.connection.conversion.CHARBytesToJavaChars(byArray2, 0, cArray, n7 + 1, this.tmp, cArray.length - n7 - 1);
                cArray[n7] = (char)(n8 * 2);
                this.processIndicator(this.meta[0]);
                if (this.meta[0] == 0) {
                    sArray[this.ibtIndicatorIndex + i] = -1;
                    sArray[this.ibtLengthIndex + i] = 0;
                    continue;
                }
                sArray[this.ibtLengthIndex + i] = (short)(this.meta[0] * 2);
                sArray[this.ibtIndicatorIndex + i] = 0;
            }
        } else {
            for (int i = 0; i < n6; ++i) {
                int n9 = this.ibtValueIndex + this.element_max_len * i;
                this.mare.unmarshalCLR(byArray, n9 + 1, this.meta);
                byArray[n9] = (byte)this.meta[0];
                this.processIndicator(this.meta[0]);
                if (this.meta[0] == 0) {
                    sArray[this.ibtIndicatorIndex + i] = -1;
                    sArray[this.ibtLengthIndex + i] = 0;
                    continue;
                }
                sArray[this.ibtLengthIndex + i] = (short)this.meta[0];
                sArray[this.ibtIndicatorIndex + i] = 0;
            }
        }
        ++this.lastRowProcessed;
        return false;
    }

    void calculateSizeTmpByteArray() {
        int n;
        if ((this.element_internal_type == 9 || this.element_internal_type == 96 || this.element_internal_type == 1) && this.stmt.sizeTmpByteArray < (n = this.ibtCharLength * this.stmt.connection.conversion.m_cMaxCharSize / this.max_num_of_elements)) {
            this.stmt.sizeTmpByteArray = n;
        }
    }

    String getString(int n) throws SQLException {
        String string = super.getString(n);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize) {
            string = string.substring(0, this.definedColumnSize);
        }
        return string;
    }
}

