/*
 * Decompiled with CFR 0.152.
 */
package ork;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class OracleDBConnection {
    private String m_sSid = null;
    private String m_sUser = null;
    private String m_sPass = null;
    private String m_sHost = null;
    private Connection m_oConn = null;
    private int m_nPort = 1521;
    public static final int ERROR_NO_HOST = -1000;
    public static final int ERROR_CONNECTION_FAILED = -1001;
    public static final int ERROR_LOGIN_FAILED = 1017;
    public static final int ERROR_ACCOUNT_LOCKED = 28000;
    public static final int ERROR_IO_EXCEPTION = 17002;
    public static final int ERROR_CONNECT_AS_SYSDBA = 28009;
    public static final int OK = 0;

    public Connection getConnection() {
        return this.m_oConn;
    }

    public OracleDBConnection() {
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
        }
        catch (ClassNotFoundException e) {
            System.err.println("[x] Failed to load Oracle JDBC driver");
            try {
                throw e.getException();
            }
            catch (Throwable ex) {
                System.err.println("[x] Uncaught exception in OracleDBConnection constructor");
            }
        }
    }

    public OracleDBConnection(String sServer, int nPort, String sSID) {
        this();
        this.setHost(sServer);
        this.setSID(sSID);
        this.setPort(nPort);
    }

    public OracleDBConnection(OracleDBConnection oConn) {
        this();
        this.setSID(oConn.getSid());
        this.setUser(oConn.getUser());
        this.setPassword(oConn.getPassword());
        this.setHost(oConn.getHost());
        this.setPort(oConn.getPort());
    }

    public void setSID(String sSid) {
        this.m_sSid = sSid;
    }

    public void setUser(String sUser) {
        this.m_sUser = sUser;
    }

    public void setPassword(String sPass) {
        this.m_sPass = sPass;
    }

    public void setHost(String sHost) {
        this.m_sHost = sHost;
    }

    public void setPort(int nPort) {
        this.m_nPort = nPort;
    }

    public String getSid() {
        return this.m_sSid;
    }

    public String getUser() {
        return this.m_sUser;
    }

    public String getPassword() {
        return this.m_sPass;
    }

    public String getHost() {
        return this.m_sHost;
    }

    public int getPort() {
        return this.m_nPort;
    }

    public int login() {
        String sUrl = null;
        int nErr = 0;
        if (this.m_sSid == null) {
            System.err.println("[x] Warning SID not set!!");
        }
        if (this.m_sUser == null) {
            System.err.println("[x] Warning User not set!!");
        }
        if (this.m_sPass == null) {
            System.err.println("[x] Warning Password not set!!");
        }
        if (this.m_sHost == null) {
            System.err.println("[x] Host has not been set!!");
            return -1000;
        }
        sUrl = "jdbc:oracle:thin:@" + this.m_sHost + ":" + this.m_nPort + ":" + this.m_sSid;
        try {
            this.m_oConn = DriverManager.getConnection(sUrl, this.m_sUser, this.m_sPass);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 0) {
                return 17002;
            }
            if (e.getErrorCode() == 28000) {
                nErr = 28000;
            }
            if (e.getErrorCode() == 28009) {
                this.m_sUser = String.valueOf(this.m_sUser) + " AS SYSDBA";
                return this.login();
            }
            nErr = e.getErrorCode();
        }
        return nErr;
    }

    public void close() {
        try {
            if (this.m_oConn != null && !this.m_oConn.isClosed()) {
                this.m_oConn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

