# WARNING: this file is auto-generated by 'build_sync_library.py'
# from the original file 'test_raise.py'
# DO NOT CHANGE! Change the original file instead.
import pytest
from key_value.shared.errors import MissingKeyError

from key_value.sync.code_gen.adapters.raise_on_missing import RaiseOnMissingAdapter
from key_value.sync.code_gen.stores.memory.store import MemoryStore


@pytest.fixture
def store() -> MemoryStore:
    return MemoryStore()


@pytest.fixture
def adapter(store: MemoryStore) -> RaiseOnMissingAdapter:
    return RaiseOnMissingAdapter(key_value=store)


def test_get(adapter: RaiseOnMissingAdapter):
    adapter.put(collection="test", key="test", value={"test": "test"})
    assert adapter.get(collection="test", key="test") == {"test": "test"}


def test_get_missing(adapter: RaiseOnMissingAdapter):
    with pytest.raises(MissingKeyError):
        _ = adapter.get(collection="test", key="test", raise_on_missing=True)


def test_get_many(adapter: RaiseOnMissingAdapter):
    adapter.put(collection="test", key="test", value={"test": "test"})
    adapter.put(collection="test", key="test_2", value={"test": "test_2"})
    assert adapter.get_many(collection="test", keys=["test", "test_2"]) == [{"test": "test"}, {"test": "test_2"}]


def test_get_many_missing(adapter: RaiseOnMissingAdapter):
    adapter.put(collection="test", key="test", value={"test": "test"})
    with pytest.raises(MissingKeyError):
        _ = adapter.get_many(collection="test", keys=["test", "test_2"], raise_on_missing=True)


def test_ttl(adapter: RaiseOnMissingAdapter):
    adapter.put(collection="test", key="test", value={"test": "test"}, ttl=60)
    (value, ttl) = adapter.ttl(collection="test", key="test")
    assert value == {"test": "test"}
    assert ttl is not None


def test_ttl_missing(adapter: RaiseOnMissingAdapter):
    with pytest.raises(MissingKeyError):
        _ = adapter.ttl(collection="test", key="test", raise_on_missing=True)


def test_ttl_many(adapter: RaiseOnMissingAdapter):
    adapter.put(collection="test", key="test", value={"test": "test"}, ttl=60)
    adapter.put(collection="test", key="test_2", value={"test": "test_2"}, ttl=120)
    results = adapter.ttl_many(collection="test", keys=["test", "test_2"])
    assert results[0][0] == {"test": "test"}
    assert results[0][1] is not None
    assert results[1][0] == {"test": "test_2"}
    assert results[1][1] is not None


def test_ttl_many_missing(adapter: RaiseOnMissingAdapter):
    adapter.put(collection="test", key="test", value={"test": "test"}, ttl=60)
    with pytest.raises(MissingKeyError):
        _ = adapter.ttl_many(collection="test", keys=["test", "test_2"], raise_on_missing=True)
