"""cascade in vuls relation

Revision ID: 7dea3a6caf51
Revises: 38bb251889e6
Create Date: 2021-11-10 21:23:24.837776+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '7dea3a6caf51'
down_revision = '38bb251889e6'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('command_workspace_id_fkey', 'command', type_='foreignkey')
    op.create_foreign_key(None, 'command', 'workspace', ['workspace_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('knowledge_base_vulnerability_template_id_fkey', 'knowledge_base', type_='foreignkey')
    op.create_foreign_key(None, 'knowledge_base', 'vulnerability_template', ['vulnerability_template_id'], ['id'])
    op.drop_constraint('reference_vulnerability_association_vulnerability_id_fkey', 'reference_vulnerability_association', type_='foreignkey')
    op.create_foreign_key(None, 'reference_vulnerability_association', 'vulnerability', ['vulnerability_id'], ['id'], ondelete='CASCADE')
    op.alter_column('vulnerability', 'risk',
               existing_type=sa.REAL(),
               type_=sa.Float(precision=3, asdecimal=1),
               existing_nullable=True)
    op.drop_constraint('vulnerability_service_id_fkey', 'vulnerability', type_='foreignkey')
    op.create_foreign_key(None, 'vulnerability', 'service', ['service_id'], ['id'], ondelete='CASCADE')
    op.alter_column('vulnerability_template', 'risk',
               existing_type=sa.REAL(),
               type_=sa.Float(precision=3, asdecimal=1),
               existing_nullable=True)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('vulnerability_template', 'risk',
               existing_type=sa.Float(precision=3, asdecimal=1),
               type_=sa.REAL(),
               existing_nullable=True)
    op.drop_constraint('vulnerability_service_id_fkey', 'vulnerability', type_='foreignkey')
    op.create_foreign_key(None, 'vulnerability', 'service', ['service_id'], ['id'])
    op.alter_column('vulnerability', 'risk',
               existing_type=sa.Float(precision=3, asdecimal=1),
               type_=sa.REAL(),
               existing_nullable=True)
    op.drop_constraint('reference_vulnerability_association_vulnerability_id_fkey', 'reference_vulnerability_association', type_='foreignkey')
    op.create_foreign_key(None, 'reference_vulnerability_association', 'vulnerability', ['vulnerability_id'], ['id'])
    op.drop_constraint('knowledge_base_vulnerability_template_id_fkey', 'knowledge_base', type_='foreignkey')
    op.create_foreign_key(None, 'knowledge_base', 'vulnerability_template', ['vulnerability_template_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('command_workspace_id_fkey', 'command', type_='foreignkey')
    op.create_foreign_key(None, 'command', 'workspace', ['workspace_id'], ['id'])
    # ### end Alembic commands ###
