# Installation and Getting Started

`testbook` is a unit testing framework for testing code in Jupyter Notebooks.

## Installing `testbook`

Using a virtual environment or system Python:

```{code-block} bash
pip install testbook
```

Using Anaconda:

```{code-block} bash
conda install testbook
```

## What is a Jupyter Notebook?

[An introduction to Jupyter](https://jupyter-notebook-beginner-guide.readthedocs.io/en/latest/what_is_jupyter.html)

## Installing and Launching Jupyter Notebook

[How to install Jupyter](https://jupyterlab.readthedocs.io/en/stable/getting_started/installation.html)

```{code-block} bash
jupyter lab
```

## Create your first test

Create a new notebook:

To do add image

Write the following code into the first cell of a Jupyter Notebook:

```{code-block} python
def foo(x):
    return x + 1
```

Save this Notebook as `notebook.ipynb`.

Create a new `.py` file. In this new file, write the following unit test:

```{code-block} python
from testbook import testbook

@testbook('notebook.ipynb', execute=True)
def test_foo(tb):
    foo = tb.get("foo")

    assert foo(2) == 3
```

That's it! You can now execute the test.

## General workflow when using testbook to write a unit test

1. Use `testbook.testbook` as a decorator or context manager to specify the path to the Jupyter Notebook. Passing `execute=True` will execute all the cells, and passing `execute=['cell-tag-1', 'cell-tag-2']` will only execute specific cells identified by cell tags.

2. Obtain references to objects under test using the `.get` method. 

3. Write the test!
