% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maFitMod.R
\name{maFitMod}
\alias{maFitMod}
\alias{predict.maFit}
\alias{plot.maFit}
\alias{print.maFit}
\title{Fit dose-response models via bootstrap model
  averaging (bagging)}
\usage{
maFitMod(dose, resp, S, models, nSim = 1000, control, bnds, addArgs = NULL)

\method{predict}{maFit}(
  object,
  summaryFct = function(x) quantile(x, probs = c(0.025, 0.25, 0.5, 0.75, 0.975)),
  doseSeq = NULL,
  ...
)

\method{plot}{maFit}(
  x,
  plotData = c("means", "meansCI", "none"),
  xlab = "Dose",
  ylab = "Response",
  title = NULL,
  level = 0.95,
  trafo = function(x) x,
  lenDose = 201,
  ...
)
}
\arguments{
\item{dose}{Numeric specifying the dose variable.}

\item{resp}{Numeric specifying the response estimate corresponding
to the doses in \code{dose}}

\item{S}{Covariance matrix associated with the dose-response
estimate specified via \code{resp}}

\item{models}{dose-response models to fit}

\item{nSim}{Number of bootstrap simulations}

\item{control}{Same as the control argument in
\code{\link{fitMod}}.}

\item{bnds}{Bounds for non-linear parameters. This needs to be a
list with list entries corresponding to the selected bounds. The
names of the list entries need to correspond to the model
names. The \code{\link{defBnds}} function provides the default
selection.}

\item{addArgs}{List containing two entries named "scal" and "off"
for the "betaMod" and "linlog" model. When addArgs is NULL the
following defaults are used \samp{list(scal = 1.2*max(doses), off
= 0.01*max(doses))}}

\item{object}{Object of class maFit}

\item{summaryFct}{If equal to NULL predictions are calculated for
each sampled parameter value. Otherwise a summary function is
applied to the dose-response predictions for each parameter
value.  The default is to calculate 0.025, 0.25, 0.5, 0.75, 0.975
quantiles of the predictions for each dose.}

\item{doseSeq}{Where to calculate predictions.}

\item{...}{Additional parametes (unused)}

\item{x}{object of class maFit}

\item{plotData}{Determines how the original data are plotted:
Either as means or as means with CI or not at all. The level of the CI
is determined by the argument \samp{level}.}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{title}{plot title}

\item{level}{Level for CI, when plotData is equal to
\samp{meansCI}.}

\item{trafo}{Plot the fitted models on a transformed scale
(e.g. probability scale if models have been fitted on log-odds
scale). The default for \samp{trafo} is the identity function.}

\item{lenDose}{Number of grid values to use for display.}
}
\value{
An object of class \samp{maFit}, which contains the fitted
  dose-response models \samp{DRMod} objects, information on which model
  was selected in each bootstrap and basic input parameters.
}
\description{
This function fits dose-response models in a bootstrap model
averaging approach motivated by the bagging procedure (Breiman
1996). Given summary estimates for the outcome at each dose, the
function samples summary data from the multivariate normal
distribution. For each sample dose-response models are fit to these
summary estimates and the best model
according to the gAIC is selected.
}
\examples{
data(biom)
## produce first stage fit (using dose as factor)
anMod <- lm(resp~factor(dose)-1, data=biom)
drFit <- coef(anMod)
S <- vcov(anMod)
dose <- sort(unique(biom$dose))
## fit an emax and sigEmax model (increase nSim for real use)
mFit <- maFitMod(dose, drFit, S, model = c("emax", "sigEmax"), nSim = 10)
mFit
plot(mFit, plotData = "meansCI")
ED(mFit, direction = "increasing", p = 0.9)
}
\references{
Breiman, L. (1996). Bagging predictors. Machine learning, 24, 123-140.
}
\seealso{
\code{\link{fitMod}}, \code{\link{bFitMod}}, \code{\link{drmodels}}
}
\author{
Bjoern Bornkamp
}
