% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haven-sas.R
\name{read_xpt}
\alias{read_xpt}
\alias{write_xpt}
\title{Read and write SAS transport files}
\usage{
read_xpt(
  file,
  col_select = NULL,
  skip = 0,
  n_max = Inf,
  .name_repair = "unique"
)

write_xpt(
  data,
  path,
  version = 8,
  name = NULL,
  label = attr(data, "label"),
  adjust_tz = TRUE
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, the input must be either wrapped with \code{I()}, be a string
containing at least one new line, or be a vector containing at least one
string with a new line.

Using a value of \code{\link[readr:clipboard]{clipboard()}} will read from the system clipboard.}

\item{col_select}{One or more selection expressions, like in
\code{\link[dplyr:select]{dplyr::select()}}. Use \code{c()} or \code{list()} to use more than one expression.
See \code{?dplyr::select} for details on available selection options. Only the
specified columns will be read from \code{data_file}.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of lines to read.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}

\item{data}{Data frame to write.}

\item{path}{Path to a file where the data will be written.}

\item{version}{Version of transport file specification to use: either 5 or 8.}

\item{name}{Member name to record in file. Defaults to file name sans
extension. Must be <= 8 characters for version 5, and <= 32 characters
for version 8.}

\item{label}{Dataset label to use, or \code{NULL}. Defaults to the value stored in
the "label" attribute of \code{data}.

Note that although SAS itself supports dataset labels up to 256 characters
long, dataset labels in SAS transport files must be <= 40 characters.}

\item{adjust_tz}{Stata, SPSS and SAS do not have a concept of time zone,
and all \link{date-time} variables are treated as UTC. \code{adjust_tz} controls
how the timezone of date-time values is treated when writing.
\itemize{
\item If \code{TRUE} (the default) the timezone of date-time values is ignored, and
they will display the same in R and Stata/SPSS/SAS, e.g.
\code{"2010-01-01 09:00:00 NZDT"} will be written as \code{"2010-01-01 09:00:00"}.
Note that this changes the underlying numeric data, so use caution if
preserving between-time-point differences is critical.
\item If \code{FALSE}, date-time values are written as the corresponding UTC value,
e.g. \code{"2010-01-01 09:00:00 NZDT"} will be written as
\code{"2009-12-31 20:00:00"}.
}}
}
\value{
A tibble, data frame variant with nice defaults.

Variable labels are stored in the "label" attribute of each variable.
It is not printed on the console, but the RStudio viewer will show it.

If a dataset label is defined, it will be stored in the "label" attribute
of the tibble.

\code{write_xpt()} returns the input \code{data} invisibly.
}
\description{
The SAS transport format is a open format, as is required for submission
of the data to the FDA.
}
\examples{
tmp <- tempfile(fileext = ".xpt")
write_xpt(mtcars, tmp)
read_xpt(tmp)
}
