% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPareto.R
\name{fitPareto}
\alias{fitPareto}
\title{Fit income distribution models with the Pareto distribution}
\usage{
fitPareto(
  x,
  k = NULL,
  x0 = NULL,
  method = "thetaPDC",
  groups = NULL,
  w = NULL,
  ...
)
}
\arguments{
\item{x}{a numeric vector.}

\item{k}{the number of observations in the upper tail to which the Pareto
distribution is fitted.}

\item{x0}{the threshold (scale parameter) above which the Pareto distribution
is fitted.}

\item{method}{either a function or a character string specifying the function
to be used to estimate the shape parameter of the Pareto distibution, such as
\code{\link{thetaPDC}} (the default).  See \dQuote{Details} for requirements
for such a function and \dQuote{See also} for available functions.}

\item{groups}{an optional vector or factor specifying groups of elements of
\code{x} (e.g., households).  If supplied, each group of observations is
expected to have the same value in \code{x} (e.g., household income).  Only
the values of every first group member to appear are used for fitting the
Pareto distribution. For each group above the threshold, every group member
is assigned the same value.}

\item{w}{an optional numeric vector giving sample weights.}

\item{\dots}{addtional arguments to be passed to the specified method.}
}
\value{
A numeric vector with a Pareto distribution fit to the upper tail.
}
\description{
Fit a Pareto distribution to the upper tail of income data.  Since a
theoretical distribution is used for the upper tail, this is a semiparametric
approach.
}
\details{
The arguments \code{k} and \code{x0} of course correspond with each other.
If \code{k} is supplied, the threshold \code{x0} is estimated with the \eqn{n
- k} largest value in \code{x}, where \eqn{n} is the number of observations.
On the other hand, if the threshold \code{x0} is supplied, \code{k} is given
by the number of observations in \code{x} larger than \code{x0}.  Therefore,
either \code{k} or \code{x0} needs to be supplied.  If both are supplied,
only \code{k} is used (mainly for back compatibility).

The function supplied to \code{method} should take a numeric vector (the
observations) as its first argument.  If \code{k} is supplied, it will be
passed on (in this case, the function is required to have an argument called
\code{k}).  Similarly, if the threshold \code{x0} is supplied, it will be
passed on (in this case, the function is required to have an argument called
\code{x0}).  As above, only \code{k} is passed on if both are supplied.  If
the function specified by \code{method} can handle sample weights, the
corresponding argument should be called \code{w}.  Additional arguments are
passed via the \dots{} argument.
}
\note{
The arguments \code{x0} for the threshold (scale parameter) of the
Pareto distribution and \code{w} for sample weights were introduced in
version 0.2.  This results in slightly different behavior regarding the
function calls to \code{method} compared to prior versions.
}
\examples{
data(eusilc)


## gini coefficient without Pareto tail modeling
gini("eqIncome", weights = "rb050", data = eusilc)


## gini coefficient with Pareto tail modeling

# using number of observations in tail
eqIncome <- fitPareto(eusilc$eqIncome, k = 175,
    w = eusilc$db090, groups = eusilc$db030)
gini(eqIncome, weights = eusilc$rb050)

# using threshold
eqIncome <- fitPareto(eusilc$eqIncome, x0 = 44150,
    w = eusilc$db090, groups = eusilc$db030)
gini(eqIncome, weights = eusilc$rb050)

}
\seealso{
\code{\link{paretoTail}}, \code{\link{replaceTail}}

\code{\link{thetaPDC}}, \code{\link{thetaWML}}, \code{\link{thetaHill}},
\code{\link{thetaISE}}, \code{\link{thetaLS}}, \code{\link{thetaMoment}},
\code{\link{thetaQQ}}, \code{\link{thetaTM}}
}
\author{
Andreas Alfons and Josef Holzer
}
\keyword{manip}
