% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consecutive_assertion_linter.R
\name{consecutive_assertion_linter}
\alias{consecutive_assertion_linter}
\title{Force consecutive calls to assertions into just one when possible}
\usage{
consecutive_assertion_linter()
}
\description{
\code{\link[base:stopifnot]{base::stopifnot()}} accepts any number of tests, so sequences like
\verb{stopifnot(x); stopifnot(y)} are redundant. Ditto for tests using
\code{assertthat::assert_that()} without specifying \verb{msg=}.
}
\examples{
# will produce lints
lint(
  text = "stopifnot(x); stopifnot(y)",
  linters = consecutive_assertion_linter()
)

lint(
  text = "assert_that(x); assert_that(y)",
  linters = consecutive_assertion_linter()
)

# okay
lint(
  text = "stopifnot(x, y)",
  linters = consecutive_assertion_linter()
)

lint(
  text = 'assert_that(x, msg = "Bad x!"); assert_that(y)',
  linters = consecutive_assertion_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
