% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_omega.R
\name{item_omega}
\alias{item_omega}
\alias{item_omega.data.frame}
\alias{item_omega.matrix}
\title{McDonald's Omega for Items or Scales}
\usage{
item_omega(x, ...)

\method{item_omega}{data.frame}(
  x,
  n = "auto",
  rotation = "oblimin",
  factor_method = "minres",
  poly_cor = FALSE,
  verbose = TRUE,
  ...
)

\method{item_omega}{matrix}(
  x,
  n = "auto",
  rotation = "oblimin",
  factor_method = "minres",
  n_obs = NULL,
  poly_cor = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{...}{Additional arguments passed to \code{\link[psych:omega]{psych::omega()}}.}

\item{n}{Number of factors to extract.}

\item{rotation}{Rotation to be applied. Defaults to \code{"oblimin"}. Further
options are \code{"simplimax"}, \code{"Promax"}, \code{"cluster"} and \code{"target"}. See
\code{?psych::omega} for details.}

\item{factor_method}{The factoring method to be used. Passed to the \code{fm}
argument in \code{psych::omega()}. Defaults to \code{"minres"} (minimum residual).
Other options include \code{"ml"} (maximum likelihood), \code{"pa"} (principal axis),
etc.}

\item{poly_cor}{Logical, if \code{TRUE}, polychoric correlations will be computed
(by passing \code{poly = TRUE} to \code{psych::omega()}). Defaults to \code{FALSE}.}

\item{verbose}{Logical, if \code{TRUE} (default), messages are printed.}

\item{n_obs}{Number of observations in the original data set if \code{x} is a
correlation matrix. Required to compute correct fit indices.}
}
\value{
A data frames containing the reliability coefficients. Use \code{summary()}
or \code{parameters::model_parameters()} on the returned object to extract more
information.
}
\description{
This function computes McDonald's omega reliability coefficients
alongside Cronbach's alpha for a set of items or a scale. It acts as a
wrapper for the \code{\link[psych:omega]{psych::omega()}} function. The aim is to make McDonald's
omega readily available and present it with the widely-known Cronbach's
alpha, allowing for a more complete understanding of scale reliability. The
output includes various forms of omega (e.g., total, hierarchical) depending
on the factor structure specified.
}
\details{
\code{item_omega()} is a simple wrapper around \code{psych::omega()}, which returns
the reliability coefficients. The original object returned by \code{psych::omega()}
is saved as \verb{$model} attribute. Further information are accessible via the
\code{summary()} and \code{parameters::model_parameters()} methods. Use \code{as.numeric()}
to return the reliability coefficients as (named) numeric vector. Detailed
information can be found in the docs of \code{?psych::omega}.
}
\examples{
\dontshow{if (insight::check_if_installed("parameters", quietly = TRUE)) withAutoprint(\{ # examplesIf}
data(mtcars)
x <- mtcars[1:7]
result <- item_omega(x, n = 2)

result

as.numeric(result)

summary(result)

parameters::model_parameters(result)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Bland, J. M., & Altman, D. G. (1997). Statistics notes: Cronbach's alpha.
BMJ, 314(7080), 572. \doi{10.1136/bmj.314.7080.572}
\item Revelle, W., & Zinbarg, R. E. (2009). Coefficients alpha, beta, omega, and
the glb: Comments on Sijtsma. Psychometrika, 74(1), 145–154.
\doi{10.1007/s11336-008-9102-z}
\item Zinbarg, R.E., Revelle, W., Yovel, I., & Li. W. (2005). Cronbach's Alpha,
Revelle's Beta, McDonald's Omega: Their relations with each and two
alternative conceptualizations of reliability. Psychometrika. 70, 123-133
}
}
