% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wave.filter.R
\name{wave.filter}
\alias{wave.filter}
\title{Select a Wavelet Filter}
\usage{
wave.filter(name)
}
\arguments{
\item{name}{Character string of wavelet filter.}
}
\value{
List containing the following items: \item{L}{Length of the wavelet
filter.} \item{hpf}{High-pass filter coefficients.} \item{lpf}{Low-pass
filter coefficients.}
}
\description{
Converts name of wavelet filter to filter coefficients.
}
\details{
Simple \code{switch} statement selects the appropriate filter.
}
\references{
Daubechies, I. (1992) \emph{Ten Lectures on Wavelets}, CBMS-NSF
Regional Conference Series in Applied Mathematics, SIAM: Philadelphia.

Doroslovacki (1998) On the least asymmetric wavelets, \emph{IEEE
Transactions for Signal Processing}, \bold{46}, No. 4, 1125-1130.

Morris and Peravali (1999) Minimum-bandwidth discrete-time wavelets,
\emph{Signal Processing}, \bold{76}, No. 2, 181-193.

Nielsen, M. (2000) On the Construction and Frequency Localization of
Orthogonal Quadrature Filters, \emph{Journal of Approximation Theory},
\bold{108}, No. 1, 36-52.
}
\seealso{
\code{\link{wavelet.filter}}, \code{\link{squared.gain}}.
}
\author{
B. Whitcher
}
\keyword{ts}
