// Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Auto-generated file. Do not edit!
// Generated by tools/sobol32_direction_vector_generator

#include "rocrand/rocrandapi.h"

// clang-format off
#define SOBOL32_N 640000
extern ROCRANDAPI const unsigned int rocrand_h_sobol32_direction_vectors[SOBOL32_N] =
{
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x04000000, 0x02000000, 0x01000000, 0x00800000, 0x00400000, 0x00200000, 0x00100000, 0x00080000, 0x00040000, 0x00020000, 0x00010000, 0x00008000, 0x00004000, 0x00002000, 0x00001000, 0x00000800, 0x00000400, 0x00000200, 0x00000100, 0x00000080, 0x00000040, 0x00000020, 0x00000010, 0x00000008, 0x00000004, 0x00000002, 0x00000001, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x88000000, 0xcc000000, 0xaa000000, 0xff000000, 0x80800000, 0xc0c00000, 0xa0a00000, 0xf0f00000, 0x88880000, 0xcccc0000, 0xaaaa0000, 0xffff0000, 0x80008000, 0xc000c000, 0xa000a000, 0xf000f000, 0x88008800, 0xcc00cc00, 0xaa00aa00, 0xff00ff00, 0x80808080, 0xc0c0c0c0, 0xa0a0a0a0, 0xf0f0f0f0, 0x88888888, 0xcccccccc, 0xaaaaaaaa, 0xffffffff, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xe8000000, 0x5c000000, 0x8e000000, 0xc5000000, 0x68800000, 0x9cc00000, 0xee600000, 0x55900000, 0x80680000, 0xc09c0000, 0x60ee0000, 0x90550000, 0xe8808000, 0x5cc0c000, 0x8e606000, 0xc5909000, 0x6868e800, 0x9c9c5c00, 0xeeee8e00, 0x5555c500, 0x8000e880, 0xc0005cc0, 0x60008e60, 0x9000c590, 0xe8006868, 0x5c009c9c, 0x8e00eeee, 0xc5005555, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xf8000000, 0x74000000, 0xa2000000, 0x93000000, 0xd8800000, 0x25400000, 0x59e00000, 0xe6d00000, 0x78080000, 0xb40c0000, 0x82020000, 0xc3050000, 0x208f8000, 0x51474000, 0xfbea2000, 0x75d93000, 0xa0858800, 0x914e5400, 0xdbe79e00, 0x25db6d00, 0x58800080, 0xe54000c0, 0x79e00020, 0xb6d00050, 0x800800f8, 0xc00c0074, 0x200200a2, 0x50050093, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xf8000000, 0xdc000000, 0x7a000000, 0x9d000000, 0x5a800000, 0x2fc00000, 0xa1600000, 0xf0b00000, 0xda880000, 0x6fc40000, 0x81620000, 0x40bb0000, 0x22878000, 0xb3c9c000, 0xfb65a000, 0xddb2d000, 0x78022800, 0x9c0b3c00, 0x5a0fb600, 0x2d0ddb00, 0xa2878080, 0xf3c9c040, 0xdb65a020, 0x6db2d0b0, 0x800228f8, 0x400b3cdc, 0x200fb67a, 0xb00ddb9d, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xc8000000, 0x24000000, 0x56000000, 0xfb000000, 0xe0800000, 0x70400000, 0xa8600000, 0x14300000, 0x9ec80000, 0xdf240000, 0xb6d60000, 0x8bbb0000, 0x48008000, 0x64004000, 0x36006000, 0xcb003000, 0x2880c800, 0x54402400, 0xfe605600, 0xef30fb00, 0x7e48e080, 0xaf647040, 0x1eb6a860, 0x9f8b1430, 0xd6c81ec8, 0xbb249f24, 0x80d6d6d6, 0x40bbbbbb, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x58000000, 0x94000000, 0x3e000000, 0xe3000000, 0xbe800000, 0x23c00000, 0x1e200000, 0xf3100000, 0x46780000, 0x67840000, 0x78460000, 0x84670000, 0xc6788000, 0xa784c000, 0xd846a000, 0x5467d000, 0x9e78d800, 0x33845400, 0xe6469e00, 0xb7673300, 0x20f86680, 0x104477c0, 0xf8668020, 0x4477c010, 0x668020f8, 0x77c01044, 0x8020f866, 0xc0104477, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x88000000, 0x24000000, 0x12000000, 0x2d000000, 0x76800000, 0x9e400000, 0x08200000, 0x64100000, 0xb2280000, 0x7d140000, 0xfea20000, 0xba490000, 0x1a248000, 0x491b4000, 0xc4b5a000, 0xe3739000, 0xf6800800, 0xde400400, 0xa8200a00, 0x34100500, 0x3a280880, 0x59140240, 0xeca20120, 0x974902d0, 0x6ca48768, 0xd75b49e4, 0xcc95a082, 0x87639641, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x28000000, 0xd4000000, 0x6a000000, 0x71000000, 0x38800000, 0x58400000, 0xea200000, 0x31100000, 0x98a80000, 0x08540000, 0xc22a0000, 0xe5250000, 0xf2b28000, 0x79484000, 0xfaa42000, 0xbd731000, 0x18a80800, 0x48540400, 0x622a0a00, 0xb5250500, 0xdab28280, 0xad484d40, 0x90a426a0, 0xcc731710, 0x20280b88, 0x10140184, 0x880a04a2, 0x84350611, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x98000000, 0x94000000, 0x8a000000, 0x5b000000, 0x33800000, 0xd9c00000, 0x72200000, 0x3f100000, 0xc1b80000, 0xa6ec0000, 0x53860000, 0x29f50000, 0x0a3a8000, 0x1b2ac000, 0xd392e000, 0x69ff7000, 0xea380800, 0xab2c0400, 0x4ba60e00, 0xfde50b00, 0x60028980, 0xf006c940, 0x7834e8a0, 0x241a75b0, 0x123a8b38, 0xcf2ac99c, 0xb992e922, 0x82ff78f1, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x08000000, 0x6c000000, 0x9e000000, 0x23000000, 0x57800000, 0xadc00000, 0x7fa00000, 0x91d00000, 0x49880000, 0xced40000, 0x880a0000, 0x2c0f0000, 0x3e0d8000, 0x3317c000, 0x5fb06000, 0xc1f8b000, 0xe18d8800, 0xb2d7c400, 0x1e106a00, 0x6328b100, 0xf7858880, 0xbdc3c2c0, 0x77ba63e0, 0xfdf7b330, 0xd7800df8, 0xedc0081c, 0xdfa0041a, 0x81d00a2d, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x58000000, 0xac000000, 0x96000000, 0x2b000000, 0xd4800000, 0x09400000, 0xe2a00000, 0x52500000, 0x4e280000, 0xc71c0000, 0x629e0000, 0x12670000, 0x6e138000, 0xf731c000, 0x3a98a000, 0xbe449000, 0xf83b8800, 0xdc2dc400, 0xee06a200, 0xb7239300, 0x1aa80d80, 0x8e5c0ec0, 0xa03e0b60, 0x703701b0, 0x783b88c8, 0x9c2dca54, 0xce06a74a, 0x87239795, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xf8000000, 0x8c000000, 0xe2000000, 0x33000000, 0x0f800000, 0x21400000, 0x95a00000, 0x5e700000, 0xd8080000, 0x1c240000, 0xba160000, 0xef370000, 0x15868000, 0x9e6fc000, 0x781b6000, 0x4c349000, 0x420e8800, 0x630bcc00, 0xf7ad6a00, 0xad739500, 0x77800780, 0x6d4004c0, 0xd7a00420, 0x3d700630, 0x2f880f78, 0xb1640ad4, 0xcdb6077a, 0x824706d7, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x38000000, 0xc4000000, 0x42000000, 0xa3000000, 0xf1800000, 0xaa400000, 0xfce00000, 0x85100000, 0xe0080000, 0x500c0000, 0x58060000, 0x54090000, 0x7a038000, 0x670c4000, 0xb3842000, 0x094a3000, 0x0d6f1800, 0x2f5aa400, 0x1ce7ce00, 0xd5145100, 0xb8000080, 0x040000c0, 0x22000060, 0x33000090, 0xc9800038, 0x6e4000c4, 0xbee00042, 0x261000a3, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xa8000000, 0x54000000, 0x9a000000, 0x9d000000, 0x1e800000, 0x5cc00000, 0x7d200000, 0x8d100000, 0x24880000, 0x71c40000, 0xeba20000, 0x75df0000, 0x6ba28000, 0x35d14000, 0x4ba3a000, 0xc5d2d000, 0xe3a16800, 0x91db8c00, 0x79aef200, 0x0cdf4100, 0x672a8080, 0x50154040, 0x1a01a020, 0xdd0dd0f0, 0x3e83e8a8, 0xaccacc54, 0xd52d529a, 0xd91d919d, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xd8000000, 0xc4000000, 0x46000000, 0x85000000, 0xa5800000, 0x76c00000, 0xada00000, 0x6ab00000, 0x2da80000, 0xaabc0000, 0x0daa0000, 0x7ab10000, 0xd5a78000, 0xbebd4000, 0x93a3e000, 0x3bb51000, 0x3629b800, 0x4d727c00, 0x9b836200, 0x27c4d700, 0xb629b880, 0x8d727cc0, 0xbb836220, 0xf7c4d7d0, 0x6e29b858, 0x49727c04, 0xfd836266, 0x72c4d755, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x38000000, 0x14000000, 0xf6000000, 0x67000000, 0x8f800000, 0x50400000, 0x8aa00000, 0x0ff00000, 0x12a80000, 0xabf40000, 0xfcaa0000, 0x28fb0000, 0xbd298000, 0x0bba4000, 0x4e06e000, 0x330c3000, 0x59861800, 0xc74d3400, 0x3d2cb200, 0x4bb2cb00, 0x6e061880, 0xc30d3440, 0x618cb220, 0xd342cbf0, 0xcb2e18b8, 0x2cb93454, 0xe186b2d6, 0x9349cb97, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x68000000, 0x64000000, 0x36000000, 0x6d000000, 0x41800000, 0xe0400000, 0xd2e00000, 0x9bf00000, 0x0ce80000, 0x52fc0000, 0x5b6a0000, 0x2fb30000, 0xa00c8000, 0x30054000, 0x4807e000, 0x940f9000, 0x5e01f800, 0x090e9400, 0x778a5600, 0x8d416b00, 0x9369f880, 0x7bb294c0, 0xde005620, 0xc9026bf0, 0x578d78e8, 0x7d4bd4a4, 0xfb6db616, 0x1fbefb9d, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x98000000, 0xf4000000, 0xae000000, 0xbb000000, 0xe7800000, 0x95c00000, 0x1c200000, 0xd0300000, 0xdba80000, 0x55f40000, 0xff820000, 0x21c10000, 0x12238000, 0x3b3a4000, 0xa42b6000, 0x3430f000, 0x4da69800, 0x4af3ec00, 0x2e043a00, 0xfb0a1f00, 0x47851880, 0xc5c9ac40, 0x842f5aa0, 0x243aef50, 0x75a38018, 0xeefa40b4, 0x180b600e, 0xb400f0eb, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xb8000000, 0x3c000000, 0xce000000, 0x41000000, 0x21800000, 0x51c00000, 0x09600000, 0x85700000, 0xf2780000, 0x8e9c0000, 0x60020000, 0x70030000, 0x58038000, 0x8c02c000, 0x7602e000, 0x7d00f000, 0xef833800, 0x10c10400, 0x28e08600, 0xd4b14700, 0xfb182580, 0x0bee15c0, 0x9279c9e0, 0xfe9d3a70, 0x38000008, 0xfc00000c, 0x2e00000e, 0xf100000b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x68000000, 0x3c000000, 0x8a000000, 0x51000000, 0xa9800000, 0xddc00000, 0x5ba00000, 0x39d00000, 0x95f80000, 0x56d40000, 0x0a020000, 0x91030000, 0x49838000, 0x0dc34000, 0x33a1a000, 0x05d0f000, 0x1ffa2800, 0x07d54400, 0xa380a600, 0x4cc07700, 0x1222ee80, 0x3413a740, 0xa65bf7e0, 0x5305ab50, 0x15f80008, 0x96d4000c, 0xea02000e, 0x4103000d, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x38000000, 0x8c000000, 0x7e000000, 0x71000000, 0xc8800000, 0x04c00000, 0x1ba00000, 0xbb700000, 0x4a980000, 0xc3bc0000, 0xa6020000, 0x6d010000, 0xee818000, 0x29c34000, 0x9520e000, 0x42b23000, 0xe7b9f800, 0x0d0dc400, 0x3fb92200, 0x110d1300, 0x19bbee80, 0x3c0cadc0, 0x973a4a60, 0xc5cf7ef0, 0x3a180008, 0x0b7c0004, 0xa3a20006, 0x7771000d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x08000000, 0x64000000, 0x6a000000, 0x89000000, 0xa5800000, 0xcb400000, 0x18200000, 0xad900000, 0xaf880000, 0x72f40000, 0x25820000, 0x0b430000, 0xb8228000, 0x3d924000, 0xa7882000, 0x16f59000, 0x4f83a800, 0x82412400, 0x1da01600, 0xf6d16d00, 0xbfa84080, 0xbb672640, 0xe0091620, 0xf0b4efd0, 0x38228008, 0xfd92400c, 0x0788200a, 0x86f59009, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x48000000, 0x8c000000, 0xd6000000, 0x39000000, 0xd5800000, 0x32400000, 0xb2a00000, 0x72100000, 0x53d80000, 0x82cc0000, 0xcb820000, 0x47430000, 0x91208000, 0xa9534000, 0x7cf92000, 0x4e9e3000, 0xfcf95800, 0x8e9fe400, 0xdcf9d600, 0x5e9c8900, 0x94f96a80, 0xd29fb840, 0x42f9b760, 0xeb9c9f30, 0x97788008, 0xd9df400c, 0x25db2002, 0xabcd300d, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xd8000000, 0xf4000000, 0x3e000000, 0x95000000, 0x8f800000, 0x3d400000, 0xf3200000, 0x2ef00000, 0xadc80000, 0x0a0c0000, 0x8b220000, 0x4af30000, 0x6bc88000, 0x3b0d4000, 0xe2a16000, 0x16b0d000, 0x29687800, 0xbdbf1400, 0x33cb5e00, 0x0f0c2500, 0xfca1b480, 0xd3b0afc0, 0x7eeb6920, 0x74fe4d30, 0xfee87808, 0xb4ff140c, 0xdeeb5e02, 0xe4fc2505, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x98000000, 0xa4000000, 0x7a000000, 0xd5000000, 0x02800000, 0x60400000, 0x51e00000, 0x88700000, 0x8c280000, 0x47c40000, 0x0be20000, 0xad710000, 0xb6aa8000, 0x3386c000, 0xb8006000, 0x54039000, 0x42036800, 0xc1019400, 0xe0826a00, 0x11431100, 0x2960af80, 0x3d3175c0, 0xdf4a3aa0, 0xaff49e10, 0xd62b6808, 0x62c59404, 0x31606a0a, 0xd932110b, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x18000000, 0x34000000, 0x8a000000, 0x9d000000, 0x67800000, 0x82400000, 0x40e00000, 0x60f00000, 0x91480000, 0x29440000, 0x2d620000, 0xbfb30000, 0x162a8000, 0xfbf4c000, 0xe4ca6000, 0xc207d000, 0x2002a800, 0xf001b400, 0xb8037e00, 0x04021900, 0x92034b80, 0xa90327c0, 0xed81f320, 0x1f40d810, 0x27602808, 0xe2b1740c, 0xd1ab1e0a, 0x49b6c903, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x08000000, 0x4c000000, 0x02000000, 0xb5000000, 0x36800000, 0xc2c00000, 0x14200000, 0x07500000, 0x1bf80000, 0x50340000, 0x48a20000, 0xac910000, 0xd35b8000, 0xbca74000, 0x7bfa2000, 0xc0343000, 0xa0a18800, 0x30909400, 0xd95b7a00, 0x45a57b00, 0x4f7a7880, 0xb7f6f940, 0x82013de0, 0xf502dfd0, 0xd6820808, 0x12c3d404, 0x1c235a0e, 0x4b504b0d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x68000000, 0x4c000000, 0x76000000, 0xf7000000, 0x36800000, 0xd7400000, 0x87e00000, 0xef300000, 0xa3a80000, 0xd5440000, 0x23aa0000, 0x15470000, 0xc3a98000, 0x45464000, 0xaba82000, 0x09477000, 0xdda9f800, 0xfe44ac00, 0xeb292200, 0x2907f100, 0x6ccb3d80, 0xc6344dc0, 0xcf61b320, 0x137318d0, 0xeccb3d88, 0x06344dcc, 0x2f61b32e, 0x437318d5, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xc8000000, 0x74000000, 0x52000000, 0x03000000, 0xeb800000, 0x6f400000, 0x64600000, 0xdaf00000, 0x17980000, 0x297c0000, 0xa59a0000, 0xfa7d0000, 0xe61b8000, 0x713f4000, 0x1878a000, 0xdcce9000, 0xb661e800, 0x99f29c00, 0x9c184600, 0xd63e2100, 0x09fa5780, 0x548e0ac0, 0xa380a9e0, 0x5b413f30, 0x56625788, 0x49f20ac4, 0x341aa9e6, 0x323c3f39, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xb8000000, 0x04000000, 0x6e000000, 0x97000000, 0xf2800000, 0xedc00000, 0x13600000, 0x5c900000, 0xdb580000, 0x31e40000, 0x09da0000, 0xcc270000, 0x02b88000, 0x44b44000, 0x0fe26000, 0xe6505000, 0x9ab9d800, 0x50b50c00, 0x79e29200, 0xa552fb00, 0xbe38bf80, 0x2e77d940, 0xf6000ae0, 0x830112d0, 0x84803f88, 0xaec3994c, 0x37e26aea, 0x225142dd, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x68000000, 0xec000000, 0x22000000, 0x2b000000, 0x36800000, 0x9d400000, 0x6a200000, 0x16700000, 0x4de80000, 0x330c0000, 0x936a0000, 0x824f0000, 0x3b498000, 0x8f3fc000, 0x28202000, 0xcd707000, 0xf36aa800, 0x724fdc00, 0xb34bf200, 0x533e6900, 0x62207a80, 0x0a7140c0, 0xe7ea6520, 0xc40d90f0, 0xefe9fa88, 0xd80e80cc, 0x45ea452e, 0x2f0de0f3, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x28000000, 0xd4000000, 0x8a000000, 0xff000000, 0x84800000, 0x73c00000, 0x13200000, 0xc2b00000, 0xfb380000, 0x361c0000, 0x401a0000, 0xe0af0000, 0x11228000, 0x19b3c000, 0xfdb82000, 0x5edf9000, 0x75b88800, 0x7adfac00, 0xf7baba00, 0x61ddf300, 0xd1387e80, 0x391e55c0, 0xcc9ba860, 0x776cbeb0, 0xa000f688, 0xf001f9cc, 0x08011262, 0xe4014db3, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xb8000000, 0x84000000, 0x1a000000, 0xaf000000, 0xbd800000, 0xdfc00000, 0x14e00000, 0x43500000, 0xda380000, 0x4e1c0000, 0x4cda0000, 0x364d0000, 0x29608000, 0xdc904000, 0x6ed86000, 0x5d4f5000, 0x2ee08800, 0xfc51ac00, 0x7fb81e00, 0x45dc8300, 0xfa3a4580, 0x5e1d6240, 0x54dbd360, 0xe24ec930, 0x8b62cd88, 0xf790ce44, 0xc959cd6a, 0x2d8f4a35, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x08000000, 0xf4000000, 0xf6000000, 0x8b000000, 0xc9800000, 0x55400000, 0x67200000, 0xf3f00000, 0x34780000, 0x57440000, 0x1ada0000, 0xb1f50000, 0xa9818000, 0x6540c000, 0x8f23a000, 0x77f21000, 0xca7bf800, 0x2845fc00, 0x255afe00, 0x6fb67900, 0x07233a80, 0xc3f25ac0, 0xdc7aed60, 0xd34482d0, 0xe4d94288, 0xcef766c4, 0x9603b36e, 0xbb00ebd7, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x68000000, 0xf4000000, 0x62000000, 0xdf000000, 0x79800000, 0xdd400000, 0x76e00000, 0x2cf00000, 0xcfb80000, 0x51ec0000, 0xc8da0000, 0x845d0000, 0x9b818000, 0x42434000, 0xef622000, 0x61b19000, 0xd1582800, 0x891cac00, 0x65626e00, 0x0ab10900, 0x2adbbd80, 0x1b5d86c0, 0x02014560, 0x0f032470, 0xf1821588, 0xb9426ac4, 0x7ce10b6e, 0x07f3bd79, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x18000000, 0xdc000000, 0x42000000, 0x37000000, 0x20800000, 0xf1400000, 0x28600000, 0x94900000, 0x87880000, 0xa83c0000, 0x556a0000, 0xe6ef0000, 0xf8038000, 0x4c024000, 0x3a01e000, 0xbb023000, 0x7a816800, 0x1a43ac00, 0x4ae18a00, 0x52d31900, 0x8f682380, 0xcded9740, 0xfa80bfa0, 0xda43f2b0, 0x2ae2cb88, 0x02d07b4c, 0x976ad5a6, 0x11eddbb5, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xf8000000, 0x34000000, 0x62000000, 0xf5000000, 0xa8800000, 0xfcc00000, 0x8e200000, 0x53f00000, 0xc7780000, 0x95740000, 0xb8020000, 0xd4e50000, 0xb2808000, 0xfdc0c000, 0x64a02000, 0xaa30f000, 0x19d8f800, 0x0e443400, 0x935a6200, 0xe761f500, 0x657a2880, 0x40913cc0, 0xe0022e20, 0xd0e563f0, 0x08809f78, 0xccc09174, 0x56200202, 0x97f0e5e5, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xf8000000, 0xec000000, 0x7e000000, 0x61000000, 0x5c800000, 0xe6c00000, 0xdda00000, 0x2a700000, 0x93380000, 0x13cc0000, 0xd3ce0000, 0x73790000, 0x83a08000, 0x7b70c000, 0x97b8a000, 0xe90cf000, 0x886ef800, 0xd409ec00, 0x3218fe00, 0xef7ca100, 0xc556fc80, 0x56c516c0, 0x4556a5a0, 0x96c50670, 0xe556cd38, 0x66c542cc, 0x1d56574e, 0x8ac549b9, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x58000000, 0x2c000000, 0x9a000000, 0xf9000000, 0x3c800000, 0xb2c00000, 0xad200000, 0x3a300000, 0x89980000, 0x448c0000, 0x2eea0000, 0x6f810000, 0xef208000, 0x2f30c000, 0x0f182000, 0xbf4cb000, 0xe74a5800, 0xcb712c00, 0x51981a00, 0xa88c3900, 0x94ea1c80, 0x268102c0, 0x8ba07520, 0xb1f0d630, 0x38383398, 0x7c7c0d8c, 0x52524a6a, 0x3d3df141, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xd8000000, 0xac000000, 0x8e000000, 0x09000000, 0x9e800000, 0xa1c00000, 0xcaa00000, 0x33700000, 0x95780000, 0x085c0000, 0x24b60000, 0x6a350000, 0x43788000, 0x6d5cc000, 0x14362000, 0x72f5b000, 0xcf585800, 0x53ec6c00, 0xc5eeae00, 0x40d9b900, 0xe016c680, 0x9045cdc0, 0x6880e4a0, 0x74c04a70, 0x2220f3f8, 0x87b0b59c, 0x9758b816, 0x3fecfc45, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xa8000000, 0x2c000000, 0xa2000000, 0x2d000000, 0xda800000, 0xf9400000, 0xec600000, 0x02b00000, 0x3d480000, 0x825c0000, 0x7d4a0000, 0x62610000, 0x8dc88000, 0xca1c4000, 0xa1aae000, 0x6891f000, 0x8c602800, 0xb2b06c00, 0x75484200, 0x5e5cdd00, 0x774a7280, 0x6361d540, 0xf548ce60, 0x1e5c6fb0, 0x974a07c8, 0x93618b1c, 0x5d48b92a, 0x325c0cd1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xc8000000, 0x7c000000, 0x82000000, 0x4f000000, 0xbe800000, 0xedc00000, 0x21600000, 0xab700000, 0x78680000, 0x746c0000, 0x1e9a0000, 0xfdcb0000, 0x39088000, 0x2f1cc000, 0x4ef2e000, 0xc5a73000, 0x6d924800, 0xe1d7bc00, 0x4b7ae200, 0x487bbf00, 0xbc801680, 0x62c061c0, 0x7fe08b60, 0x76b0a870, 0x91088ce8, 0xa31caaac, 0xe4f2037a, 0xc6a7f47b, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x98000000, 0x2c000000, 0x06000000, 0xcd000000, 0x8a800000, 0x1bc00000, 0xffa00000, 0xad500000, 0x7af80000, 0xb3dc0000, 0x5b2e0000, 0x1f290000, 0x9d588000, 0xf28cc000, 0x07d62000, 0x71f51000, 0xd4f61800, 0xda65ec00, 0x632ea600, 0xe3291d00, 0x2358b280, 0x038ce7c0, 0x135641a0, 0x8b355c50, 0xa7d6ee78, 0xa1f5891c, 0x6cf6880e, 0xe665b4b9, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x98000000, 0x54000000, 0x3a000000, 0x9d000000, 0x7e800000, 0x7f400000, 0x17200000, 0xab500000, 0x6df80000, 0x96a40000, 0x83d20000, 0x71e10000, 0xc0d88000, 0xe0f44000, 0x30aaa000, 0x08059000, 0xcc2a1800, 0x6e451400, 0xa78a1a00, 0xe3554d00, 0x01d2c680, 0x68e1fb40, 0xbc589520, 0xc6b4b250, 0xfb0a1178, 0x1515b0e4, 0xf272c872, 0xb1f12cf1, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x08000000, 0x84000000, 0xb2000000, 0xb9000000, 0xbe800000, 0x4fc00000, 0x55600000, 0xf8f00000, 0xac280000, 0x66d40000, 0xb30a0000, 0x8bb50000, 0xc7c88000, 0x11e4c000, 0xaa42e000, 0xa591b000, 0xd0ea8800, 0x78854400, 0x6c80d200, 0x86c0c900, 0x03e05680, 0x83307bc0, 0x4348ef60, 0xa324c5f0, 0x13a2a0a8, 0x1ba19014, 0x9f22d8ea, 0x2d61fc85, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x78000000, 0x24000000, 0x9e000000, 0x47000000, 0x67800000, 0xf7400000, 0xdf200000, 0xb3100000, 0x71680000, 0x8c4c0000, 0x32520000, 0xe5d50000, 0xaa528000, 0x31d5c000, 0x2c52e000, 0x62d5f000, 0xadd29800, 0xf695d400, 0x8b720600, 0xf5c59300, 0x42ba6180, 0x3dd96440, 0xdea0bea0, 0xe750d750, 0x37c84fc8, 0xbf1c9b1c, 0x839a1d9a, 0x09c94ec9, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x78000000, 0x9c000000, 0xee000000, 0x1b000000, 0xcb800000, 0xc3400000, 0xc7a00000, 0x05100000, 0x88680000, 0xc4740000, 0x225a0000, 0x3da10000, 0x345a8000, 0x7aa1c000, 0xf1da6000, 0x12e17000, 0x85fa1800, 0x48b1ec00, 0x2432f600, 0x92d5f700, 0x45803d80, 0xa8403440, 0x94207a20, 0xea50f150, 0xd9c81248, 0x46648524, 0x8fb24812, 0x21952485, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x58000000, 0x7c000000, 0xc2000000, 0xe1000000, 0x0d800000, 0xd7c00000, 0x2aa00000, 0xf5300000, 0x9ba80000, 0xc0f40000, 0x20c60000, 0x702f0000, 0x48668000, 0x241f4000, 0xbe4ee000, 0x232b5000, 0xec28b800, 0xda342c00, 0xfde6fa00, 0xdfdf8d00, 0x6eee1780, 0x5b1b0ac0, 0xe0000520, 0x500093f0, 0x38008488, 0x6c008e04, 0x9a000bce, 0x9d00d8eb, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xb8000000, 0xac000000, 0x72000000, 0xb1000000, 0x03800000, 0xd2c00000, 0xc1600000, 0x9b900000, 0x4e480000, 0x0b740000, 0x864e0000, 0x3f0b0000, 0x68068000, 0x447f4000, 0x7648a000, 0xe7747000, 0xd44e9800, 0xbe0b9c00, 0xd3864a00, 0x3abf5d00, 0xc528d180, 0xcde413c0, 0x99865ae0, 0x67bfd550, 0x94a8c528, 0x9e24cde4, 0xe3669986, 0x82ef67bf, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x88000000, 0x44000000, 0x4a000000, 0x47000000, 0xdd800000, 0x42400000, 0xc3200000, 0x77100000, 0x75b80000, 0x966c0000, 0x715e0000, 0xfc950000, 0xa6e68000, 0xd9f9c000, 0x28386000, 0x142cb000, 0x527e6800, 0xfb853400, 0x5b5e4200, 0x0b95c300, 0x1366f780, 0xafb9b540, 0x2918f6a0, 0x603cc150, 0xb0469498, 0x68a9927c, 0x34a09b66, 0xc250ebb9, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xd8000000, 0xfc000000, 0xf6000000, 0xd5000000, 0xbf800000, 0x2c400000, 0xeee00000, 0x09700000, 0x19080000, 0x21640000, 0xad6a0000, 0xd3130000, 0x22828000, 0x9707c000, 0x98e0a000, 0x1c709000, 0x8688f800, 0x5d24ac00, 0x9b8a2e00, 0x26632900, 0xcd8ac980, 0x63633940, 0x8a0af160, 0xe323b530, 0x4aea8fe8, 0xc3534414, 0x1a623a62, 0x1b774b77, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0xac000000, 0x6a000000, 0x85000000, 0xfb800000, 0xa8c00000, 0x84200000, 0xae300000, 0x4b080000, 0xe0740000, 0x10860000, 0x388f0000, 0xfc2e8000, 0x320b4000, 0x2980e000, 0x91c01000, 0x2da03800, 0x7ff0fc00, 0x06a83200, 0xcf842900, 0x4e2e9180, 0x5b0b2dc0, 0xd800ffa0, 0xec0046f0, 0x0a00af28, 0xd5001e44, 0xa380038e, 0x04c074fb, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xe8000000, 0x44000000, 0x5e000000, 0xad000000, 0xef800000, 0x68400000, 0x84600000, 0xfe500000, 0xfd280000, 0x07f40000, 0x2c620000, 0xda4f0000, 0x53068000, 0x12dfc000, 0x6f802000, 0xa8403000, 0x24602800, 0xae501400, 0x15283a00, 0x43f41100, 0x72621780, 0x774f2b40, 0xbc86bbe0, 0x7a9fda10, 0xebe00118, 0x56100f94, 0xd948174a, 0xa9a415fd, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x18000000, 0x04000000, 0xda000000, 0x09000000, 0x22800000, 0xe8400000, 0xbc600000, 0x0e300000, 0x7b580000, 0x378c0000, 0x14c20000, 0x874d0000, 0x99d48000, 0xbfb94000, 0x18802000, 0x91403000, 0xe6e01800, 0x52702c00, 0x05380600, 0x34bc0100, 0x971a3680, 0x51810240, 0x13f688a0, 0xde847a10, 0x466c8f18, 0x1745738c, 0x91fa26d6, 0x73f111e3, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x88000000, 0x9c000000, 0x2e000000, 0x05000000, 0xab800000, 0x1c400000, 0x6e200000, 0x25100000, 0xfba80000, 0x94040000, 0xf26e0000, 0x0b070000, 0xfeaa8000, 0x3fd1c000, 0xee202000, 0x65101000, 0xdba80800, 0xc4041400, 0x7a6e2200, 0x97072700, 0xd0aa8b80, 0x3ad1c140, 0x45a00ae0, 0x79501710, 0xb5881388, 0xe1141d44, 0x81c61cea, 0x03030201, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xc8000000, 0x3c000000, 0x3e000000, 0x67000000, 0xf9800000, 0xcc400000, 0x66600000, 0xb3100000, 0xaba80000, 0x5d240000, 0xc4fe0000, 0xb8cf0000, 0x66bb8000, 0x71a8c000, 0x10602000, 0x28103000, 0x4c280800, 0xa6641400, 0x931e3200, 0xfb9f0f00, 0x95738f80, 0xf89cd9c0, 0x86b61e60, 0x01bb0310, 0x880d9198, 0xdc13f8c4, 0x4e6db8ea, 0xff03e849, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x58000000, 0x44000000, 0x7e000000, 0x69000000, 0x5b800000, 0xdc400000, 0x5a200000, 0x87100000, 0xdad80000, 0x9bec0000, 0xbc420000, 0xca0f0000, 0x6f7c8000, 0xc6d9c000, 0xa1a02000, 0xab501000, 0xf8f80800, 0xe8fc2c00, 0x409a1600, 0x7ce31100, 0xf6be9f80, 0xb996da40, 0xcf7cb6e0, 0x36d9e710, 0xd9a03e88, 0x5f501dc4, 0xdef828b6, 0xc5fc1bfb, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x48000000, 0x74000000, 0xc2000000, 0xe7000000, 0xb5800000, 0xba400000, 0x9b200000, 0xa3d00000, 0x2f180000, 0x81840000, 0xd82a0000, 0xcc190000, 0x5e078000, 0xe138c000, 0xd8982000, 0x9cc41000, 0x568a2800, 0x65892c00, 0xa23f9200, 0xb76cdd00, 0xedaa1080, 0x365929c0, 0x65278560, 0xf2e8c290, 0xbf8014c8, 0x694025f4, 0x4ca01346, 0x4e9035a1, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x98000000, 0xb4000000, 0x52000000, 0x07000000, 0xbf800000, 0x5a400000, 0x3b200000, 0x91d00000, 0xd3380000, 0xfdec0000, 0x954a0000, 0x58f10000, 0xb5df8000, 0x091dc000, 0x86b82000, 0xa4ac1000, 0x7bea2800, 0xd0613c00, 0x2847a600, 0x8c61ed00, 0x166a3480, 0xcd2111c0, 0x0ce787e0, 0xb7f1ea90, 0x667208c8, 0x151d1974, 0x1895884e, 0x15ecc2bb, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xf8000000, 0x4c000000, 0xa6000000, 0x89000000, 0x6e800000, 0x1a400000, 0x17600000, 0x4bf00000, 0xa2f80000, 0x7c5c0000, 0x7e360000, 0x551b0000, 0x40808000, 0x272d4000, 0x93982000, 0x7eac3000, 0x524e3800, 0x43071c00, 0xd1d6be00, 0x75c65300, 0xd7e08980, 0xacdd5240, 0xd16003a0, 0x72f02a90, 0xd47803d8, 0x5a1c1dfc, 0x37563f3e, 0xdbeb2e57, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xb8000000, 0x3c000000, 0xde000000, 0xdf000000, 0x29800000, 0x32400000, 0xe9200000, 0x62900000, 0x71d80000, 0x5e3c0000, 0x9f2e0000, 0x09e70000, 0x026b8000, 0x5176c000, 0x5ef82000, 0xafac1000, 0x81760800, 0xb69b0c00, 0x3be5ae00, 0xeb41cf00, 0x33eb9780, 0x2f36e7c0, 0xf1d82260, 0x1e3c1090, 0xbf2e1c48, 0x39e71ba4, 0xba6b85f6, 0x6d76ef4f, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xf8000000, 0x3c000000, 0x6e000000, 0x19000000, 0x50800000, 0xca400000, 0x7b200000, 0xafd00000, 0x97a80000, 0x4b9c0000, 0x55ae0000, 0x64ef0000, 0xf0288000, 0x68524000, 0x64082000, 0x820c1000, 0x8f262800, 0x75a33400, 0xf4aebe00, 0xa8614f00, 0x842ebb80, 0xf2215640, 0xa70e9c20, 0xb1f15690, 0xa6a6a8c8, 0xdf6d40f4, 0xcd88886a, 0x68c27fa7, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xc8000000, 0xbc000000, 0x4e000000, 0x57000000, 0x80800000, 0x0a400000, 0xfd200000, 0x8db00000, 0xffa80000, 0xa6840000, 0x110e0000, 0x4bdf0000, 0x74d78000, 0xb8724000, 0x84082000, 0x8a741000, 0xbd061800, 0xedab3400, 0x2fd1b200, 0x6ed96f00, 0xad59b380, 0x05ed45c0, 0x23ff9820, 0x38b66690, 0x8e263548, 0x771b286c, 0x30f9866a, 0x121d6761, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xa8000000, 0xd4000000, 0xfa000000, 0xf9000000, 0x92800000, 0x19400000, 0x42a00000, 0x21500000, 0x8ef80000, 0xa7040000, 0x59920000, 0x36f90000, 0x2b2e8000, 0xffd04000, 0x51922000, 0x12f91000, 0x592e8800, 0x62d06c00, 0x91120a00, 0x26b92500, 0x730eb680, 0xa3c05240, 0xcfca2ea0, 0xb9ad2350, 0xe6c4a628, 0x136d5a14, 0x338e8d1e, 0xd7804a91, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x58000000, 0x1c000000, 0x72000000, 0x4f000000, 0xa1800000, 0x77400000, 0x4da00000, 0xbd300000, 0xaef80000, 0x369c0000, 0x8ab60000, 0xa8850000, 0x0fe18000, 0xea0dc000, 0xf3362000, 0x83c51000, 0xd041b800, 0xa83dec00, 0xa44e3600, 0xde191700, 0x6557a480, 0xf288ffc0, 0xa4d79e60, 0x75c8cad0, 0x517797e8, 0x64f8c08c, 0xd58f8dde, 0x0164eb77, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x88000000, 0x34000000, 0xa2000000, 0x03000000, 0x41800000, 0xf7400000, 0x03a00000, 0x04100000, 0x9a080000, 0x4f140000, 0x0fb20000, 0xea550000, 0xd73b8000, 0x13a1c000, 0x2c122000, 0xfe451000, 0x6533a800, 0x38b5d400, 0x09a00200, 0x23101d00, 0x51880080, 0xdf5414c0, 0x67923260, 0x2e0530d0, 0xad13a868, 0xace5c1c4, 0xfb8816e2, 0xa8543e15, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xb8000000, 0x1c000000, 0x82000000, 0xfb000000, 0xed800000, 0x87400000, 0xffa00000, 0x24300000, 0xde480000, 0x992c0000, 0xc6e60000, 0xd2dd0000, 0x64938000, 0x59a7c000, 0x01462000, 0xaaed1000, 0xd8dbb800, 0xeb8bf400, 0x92200e00, 0xe3701700, 0xc1e81880, 0x6d1c0ac0, 0xa0ae1560, 0x57f126d0, 0x20759f68, 0x707af7cc, 0x8855acf2, 0x740ad79b, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x48000000, 0xac000000, 0x06000000, 0x95000000, 0x05800000, 0xc9400000, 0x3be00000, 0x08100000, 0xcc680000, 0xb6740000, 0xcd5e0000, 0xe1a70000, 0x635c8000, 0xa8e1c000, 0x98be2000, 0x00b73000, 0x44b4a800, 0xfed5c400, 0x25803200, 0x19401b00, 0xd3e02980, 0xb4102140, 0x82681360, 0x8f741950, 0xcede0f78, 0xbde72744, 0x5d3cb27a, 0x69b1dfcd, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xf8000000, 0x34000000, 0x1a000000, 0xff000000, 0xf3800000, 0x93400000, 0x2da00000, 0x3e700000, 0x3d480000, 0x88cc0000, 0x52b20000, 0x8d910000, 0xce358000, 0x750cc000, 0x94922000, 0x84a11000, 0x5cdd9800, 0xd8b0f400, 0xeae81e00, 0xd9bc1d00, 0x047a1e80, 0x721d0bc0, 0x532782e0, 0x0dede9d0, 0x8e6fade8, 0x1521e05c, 0x44dd8bb2, 0x7cb0e2e3, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x28000000, 0xfc000000, 0xb2000000, 0x5b000000, 0x3f800000, 0x7f400000, 0x89e00000, 0x22700000, 0xb3680000, 0xa3a40000, 0xdd360000, 0xfaad0000, 0xe1a38000, 0x7e6ec000, 0x71562000, 0xc09d3000, 0x36ab9800, 0xcbfac400, 0x81682a00, 0x38a40f00, 0x82b63480, 0x95ed12c0, 0x404385e0, 0xa01ee0d0, 0x703e2ef8, 0x38392e5c, 0xd41dbb3a, 0x4e17f339, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x08000000, 0x4c000000, 0xf6000000, 0x7f000000, 0x76800000, 0x19400000, 0x11a00000, 0x7bf00000, 0x8af80000, 0xa7540000, 0x42ae0000, 0xcb170000, 0xe4a58000, 0x8c124000, 0xd6562000, 0x2f431000, 0x4e8b9800, 0x5d454c00, 0xabd3a200, 0xf2e14300, 0x83058580, 0xc8e243c0, 0x4a2e27a0, 0xa1570950, 0x1585a3e8, 0xa1a25e3c, 0x338e209e, 0xa6a73345, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xb8000000, 0x7c000000, 0x4a000000, 0xf3000000, 0x90800000, 0x81400000, 0x5fa00000, 0xfb900000, 0x5dd80000, 0x8cec0000, 0x5b360000, 0xc4b10000, 0xdf338000, 0x52974000, 0x166e2000, 0x891d1000, 0x7ba5a800, 0x1db65c00, 0x2c858e00, 0x2b664f00, 0x7cfd9a80, 0xa31a70c0, 0x18938220, 0xe5077350, 0x19b62368, 0xfaf11124, 0x4213a7d6, 0xd7477cab, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x88000000, 0xd4000000, 0xea000000, 0xb7000000, 0xf5800000, 0xa5400000, 0xfea00000, 0x7e900000, 0x3eb80000, 0x9ef40000, 0x2e820000, 0xa6d90000, 0x729d8000, 0x98c9c000, 0x2fba2000, 0xda6d1000, 0x7f3fa800, 0x81c0ec00, 0xff3f8200, 0xc1c0e500, 0x5f3fb280, 0x71c0d1c0, 0xd73f9760, 0xa5c0e050, 0x3d3faf28, 0x12c0fb64, 0xc8bfa24e, 0xb780ea2d, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x08000000, 0x34000000, 0x1a000000, 0xd1000000, 0xac800000, 0x57400000, 0x43a00000, 0x18d00000, 0x0d480000, 0xb2b40000, 0xe4620000, 0x52010000, 0xc5668000, 0xe6e94000, 0x8e0a2000, 0xdb251000, 0x55ec8800, 0x9f8c5400, 0x06c6a200, 0xbe395d00, 0xa3422e80, 0x39913040, 0xb98ea120, 0xf98d4cd0, 0xd9a03468, 0x89d02f74, 0x81c826f2, 0xb5f4193d, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x08000000, 0xe4000000, 0xe6000000, 0x07000000, 0x10800000, 0x7d400000, 0x5da00000, 0x08f00000, 0x21180000, 0x37940000, 0xfdfa0000, 0xd8ef0000, 0xb9258000, 0x2be14000, 0xf7c22000, 0xddcb1000, 0x48e79800, 0x412a7c00, 0xc7a5a200, 0xf5a16900, 0x3ce20180, 0x5f7b2dc0, 0x2cdf9e20, 0xe70e5a50, 0xa0e78ce8, 0x152a6afc, 0x49a58de6, 0xe6a17f75, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x38000000, 0xac000000, 0xa2000000, 0xcf000000, 0x57800000, 0x2fc00000, 0x63a00000, 0x51b00000, 0x16e80000, 0xd5740000, 0xf4e20000, 0xfa130000, 0x33448000, 0x5dc74000, 0xc4c4a000, 0x02077000, 0xbf64a800, 0x4fb75c00, 0x338ca600, 0xf9c37700, 0x32ee8e80, 0xe31044c0, 0x358a1b60, 0xc0a70f30, 0x8406a388, 0x46646b5c, 0xd9680e32, 0x26b40201, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x78000000, 0x6c000000, 0x7e000000, 0xff000000, 0x18800000, 0xc0c00000, 0x7ca00000, 0x5ab00000, 0xd9b80000, 0xc7040000, 0x94f20000, 0x8eed0000, 0xebe28000, 0x5676c000, 0x0b62a000, 0x3ab6f000, 0x29c2a800, 0x8f06f400, 0x90fab600, 0xe4c2ef00, 0x06a8a980, 0xcf9fd0c0, 0x2c722fa0, 0x9e2d20f0, 0xcf429088, 0x70c6c65c, 0xd4da8ee6, 0x6eb2c39d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xd8000000, 0xf4000000, 0xd2000000, 0xab000000, 0x98800000, 0x90c00000, 0xeca00000, 0x82f00000, 0xe7e80000, 0x2a040000, 0xaf3e0000, 0x32b70000, 0xfff28000, 0x7e46c000, 0x4d72a000, 0x4186f000, 0x93528800, 0x3cb6fc00, 0x0a9abe00, 0x5b82c100, 0xe46c8a80, 0xfa01ebc0, 0x27682ca0, 0x8ec40ff0, 0x319e3788, 0x2b471f4c, 0x589aa672, 0x3082d9cd, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x08000000, 0x0c000000, 0x72000000, 0xf9000000, 0x4a800000, 0x86c00000, 0x14e00000, 0x7db00000, 0x0f280000, 0x8dec0000, 0xe70a0000, 0x11830000, 0xad578000, 0xecdec000, 0x99b7a000, 0xe16ed000, 0x3e9f8800, 0x5082dc00, 0xa3958a00, 0xb401df00, 0x36421680, 0x271f2140, 0xf195a420, 0x3d01d0f0, 0xd4c22918, 0x9ddf139c, 0x9f75a0d2, 0xb5b1efe7, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0xe4000000, 0x1e000000, 0x0d000000, 0x4f800000, 0x03c00000, 0xb9e00000, 0xcad00000, 0xd8780000, 0xbc2c0000, 0xe27e0000, 0x8f410000, 0x90ef8000, 0xbb1c4000, 0xe68fa000, 0x320c5000, 0xe717b800, 0x14f04400, 0xf511b200, 0xc39d7d00, 0x99803580, 0xfac03e40, 0xa0600660, 0x70102eb0, 0x18183018, 0x9c3c0804, 0xd2660c06, 0xf77d1e0f, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x38000000, 0x2c000000, 0xd2000000, 0x8d000000, 0x70800000, 0x14c00000, 0xb2e00000, 0x51f00000, 0xf6280000, 0x0b740000, 0x23c20000, 0x8b7b0000, 0x63858000, 0xab51c000, 0xd3e5a000, 0x9361d000, 0xffada800, 0x4125fc00, 0x72a7a600, 0x31daf700, 0x66481280, 0x83441440, 0x378a2ea0, 0x753f0170, 0x3c8f8a18, 0x56aef90c, 0xb78a1992, 0x353f20d1, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xd8000000, 0xec000000, 0xf2000000, 0x65000000, 0x87800000, 0x05c00000, 0x48a00000, 0xcb100000, 0x58f80000, 0xb3340000, 0x84d20000, 0xc9130000, 0xd5f58000, 0x50944000, 0x470da000, 0xfaa07000, 0x0e5fb800, 0xef736400, 0x3e8a0e00, 0xf8371f00, 0x1c5f9280, 0x1a737640, 0x010a0b60, 0x41f71330, 0x7eff9748, 0x58637ef4, 0x2c7233f6, 0x92031479, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x58000000, 0xc4000000, 0x66000000, 0x3b000000, 0x39800000, 0xd7c00000, 0x10a00000, 0xbb700000, 0xf9f80000, 0x77f40000, 0x80a60000, 0xe30d0000, 0x3db48000, 0x11c64000, 0xbbcca000, 0xdaf27000, 0xea4a8800, 0x014f5400, 0x00a61e00, 0x230d2500, 0x9db4a780, 0x81c65bc0, 0xe3cca1e0, 0x1ef27a30, 0x8c4a9bc8, 0x3a4f41ec, 0x39262a36, 0xf4cd23d1, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xb8000000, 0xb4000000, 0xfa000000, 0x47000000, 0xd1800000, 0x1fc00000, 0xe2e00000, 0x94100000, 0x4a580000, 0x0f240000, 0xcd8e0000, 0xe9bb0000, 0xebe48000, 0xf8a64000, 0xc35ca000, 0x23925000, 0xa48a9800, 0xd50d5400, 0x3ae03600, 0x70103900, 0xe8582880, 0xec2438c0, 0x5e0e24e0, 0x057b3b30, 0x2284b258, 0x34767334, 0xba64be4e, 0xa766713d, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xb8000000, 0x14000000, 0xd2000000, 0x6d000000, 0x25800000, 0x73c00000, 0x54e00000, 0x38500000, 0x54380000, 0xb2440000, 0x3d7e0000, 0x9dbf0000, 0x67958000, 0x86ad4000, 0x554da000, 0x71b95000, 0xc18bb800, 0x69824400, 0xa5801600, 0x33c00100, 0x34e00280, 0x68500a40, 0xec3813e0, 0xa64402b0, 0xef7e28d8, 0xf0bf09a4, 0x42158956, 0xf56d7e75, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x38000000, 0x2c000000, 0x86000000, 0x79000000, 0xe2800000, 0xd8c00000, 0xafe00000, 0xc0100000, 0xa0280000, 0x10140000, 0xc8720000, 0x14490000, 0xaa698000, 0xff0ec000, 0x9ba1a000, 0x3a0ad000, 0x777b9800, 0x6f97ec00, 0x60001600, 0xb0002700, 0xd8001780, 0xdc002940, 0xbe001720, 0x55002370, 0x648032d8, 0xa1c01874, 0x4d603b52, 0x18d00231, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0x34000000, 0x3e000000, 0x1b000000, 0xe0800000, 0xe2c00000, 0xd3a00000, 0xc6500000, 0xa7080000, 0x0acc0000, 0xf7e60000, 0x60010000, 0xf0188000, 0xa80ac000, 0x0430a000, 0x7656f000, 0x2f7e9800, 0xdecbfc00, 0xf9880a00, 0x330c3100, 0x24c62580, 0x749107c0, 0xccb0a5a0, 0x5096f370, 0x6adea348, 0x079bffe4, 0xc8003d0a, 0xf4003797, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x98000000, 0x9c000000, 0x4e000000, 0x59000000, 0x07800000, 0xddc00000, 0xdea00000, 0x1a300000, 0x23080000, 0x34a40000, 0xa13a0000, 0x8bc50000, 0xdb958000, 0x73d04000, 0x57bda000, 0x75847000, 0xfaafa800, 0x38154c00, 0xac280e00, 0xf6542b00, 0x35123d80, 0xd1910d40, 0x1887b460, 0x97414630, 0x9eba05c8, 0xfa0517bc, 0xf335b68a, 0x5ce040d5, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x84000000, 0x92000000, 0x91000000, 0xbd800000, 0x8cc00000, 0x61600000, 0xc5b00000, 0x30d80000, 0x6f6c0000, 0x4af60000, 0x0a530000, 0x5d2d8000, 0x8bc04000, 0x9fdba000, 0x45935000, 0x70f62800, 0x4f531400, 0x5aad8a00, 0x02006500, 0xd93b8680, 0x19e35540, 0x0ece23e0, 0xf84f1370, 0xfc63bd38, 0x2e4f775c, 0x9f5812ee, 0x32ac3ff7, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x78000000, 0xac000000, 0x3a000000, 0x0d000000, 0xf1800000, 0x6cc00000, 0xf5200000, 0x9df00000, 0x76a80000, 0x08640000, 0x141a0000, 0xb6230000, 0xc75f8000, 0x84944000, 0x3145a000, 0xa3b77000, 0x659a2800, 0x1ae30c00, 0x127f9600, 0xe9645700, 0x3fedb080, 0x07d35840, 0x4b801ae0, 0xa1c01470, 0x24a01728, 0x01302b4c, 0xfb883062, 0x39940d25, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x98000000, 0x6c000000, 0xaa000000, 0x83000000, 0xd7800000, 0xc0c00000, 0xa1600000, 0x30d00000, 0x99280000, 0x8cf40000, 0x9b4a0000, 0xfbdb0000, 0x8ae88000, 0x12644000, 0x7f42a000, 0x35af5000, 0x87e21800, 0x28ef1c00, 0xb5429e00, 0xc6af5700, 0x28622c80, 0xb42f2bc0, 0x2622a760, 0x197f5cf0, 0xccca1bb8, 0x7b1b3704, 0xcb889c92, 0x12b443c9, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x28000000, 0x8c000000, 0x2e000000, 0xc3000000, 0xae800000, 0x79c00000, 0x9d200000, 0xe5d00000, 0x0b680000, 0xd2ec0000, 0x1fa20000, 0xe2690000, 0x4d328000, 0x3dd8c000, 0xcf30a000, 0x40a1f000, 0xdaca3800, 0x03853c00, 0xb4109200, 0x1a71ef00, 0x19222180, 0xd7a923c0, 0x9e12b820, 0x2b08e2b0, 0x42d8a6e8, 0x678df404, 0x76481612, 0xc73c010f, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x48000000, 0x6c000000, 0x4e000000, 0x3b000000, 0x94800000, 0xc1c00000, 0xbe200000, 0xb3500000, 0x98880000, 0xffdc0000, 0xcd320000, 0x4bc10000, 0x17728000, 0x7aabc000, 0xeac8a000, 0x12b6f000, 0x56883800, 0x04dc2c00, 0x39b20a00, 0xfa010700, 0xe1528180, 0xa5fbd5c0, 0x3c4096a0, 0xd66aceb0, 0x0f3a32a8, 0x8edd30a4, 0x90e083aa, 0x33fad423, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0x44000000, 0x1a000000, 0xf1000000, 0x4e800000, 0xf5c00000, 0x32600000, 0x3d100000, 0x28f80000, 0xcaa40000, 0xcfee0000, 0x337f0000, 0xbbad8000, 0xc14bc000, 0xa6bba000, 0x1990d000, 0xa4783800, 0xca643400, 0xc90e0e00, 0x9aaf3500, 0xb7b59080, 0x873fed40, 0x69cdb520, 0x2c5bd130, 0xb643a738, 0x0734c634, 0x299628a6, 0x4c1b18ed, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xc8000000, 0xe4000000, 0x42000000, 0xbd000000, 0x6a800000, 0x05c00000, 0x2a200000, 0x89100000, 0xf0880000, 0x64dc0000, 0x2eb60000, 0x97830000, 0x4f578000, 0x3fe7c000, 0x9b69a000, 0x55b8f000, 0x32081800, 0xb51c0c00, 0x6e960a00, 0xb7930500, 0x5f5fa280, 0x07fbd640, 0xb77faa20, 0xf3ebde30, 0xcd778828, 0x62f7ef34, 0x01e19caa, 0x9864ce73, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x48000000, 0xdc000000, 0x92000000, 0x53000000, 0x6c800000, 0x85c00000, 0x36600000, 0xe5500000, 0xc9f80000, 0xac6c0000, 0x8a6a0000, 0x27570000, 0x32e88000, 0x0cfbc000, 0xd5faa000, 0x9e00d000, 0x29181800, 0x13fc1400, 0x23722a00, 0x74ab3300, 0xf19ab680, 0x6850e3c0, 0x6c601fa0, 0x2a5025b0, 0xd7782eb8, 0x6aac1c24, 0x988a2de6, 0x9bc7254f, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x98000000, 0x6c000000, 0x2e000000, 0x71000000, 0x7c800000, 0xebc00000, 0xd2200000, 0x67500000, 0xd1d80000, 0xf1640000, 0xbc9a0000, 0x8bd10000, 0x02678000, 0xff1ac000, 0xbda5a000, 0xdf6ff000, 0xcdf83800, 0xf7340400, 0xe9c23e00, 0x2d752f00, 0xdaddad80, 0x0e9bc740, 0x3c9a34a0, 0x4bd116b0, 0x6267b3a8, 0x2f1ad724, 0x25a586fe, 0xb36fce8d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xb8000000, 0xac000000, 0x06000000, 0xfd000000, 0xef800000, 0xf8c00000, 0x8c200000, 0xf6300000, 0xe5480000, 0x73c40000, 0x46ca0000, 0xdd750000, 0x1fcd8000, 0xe0814000, 0x106fa000, 0x48007000, 0xb4200800, 0x9a303c00, 0x43480600, 0xbec42700, 0x114a2f80, 0x89b51440, 0x95edba60, 0xebb14170, 0x1aa7b8e8, 0xc30473bc, 0x7eca125a, 0xb1751d7d, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x58000000, 0x14000000, 0x5a000000, 0x75000000, 0x6c800000, 0x87c00000, 0xdc600000, 0xf6700000, 0xcb780000, 0x4b840000, 0xd2660000, 0x79070000, 0x82c78000, 0xf8e4c000, 0x9db9a000, 0x0917d000, 0xcae00800, 0x14b00400, 0x83983e00, 0x7e341100, 0xc77e0080, 0xa5f31840, 0xad598da0, 0x38a7fcb0, 0x7df80c38, 0xf9440c6c, 0xc2862dc6, 0x58b73b7d, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xe8000000, 0x94000000, 0x42000000, 0x7b000000, 0x49800000, 0x3cc00000, 0x90200000, 0x58500000, 0x1c080000, 0xa64c0000, 0xd13e0000, 0xa6eb0000, 0x375c8000, 0xd7f94000, 0x81caa000, 0x78ce7000, 0x2a003800, 0x2f002c00, 0x6b802200, 0x37c03900, 0x31a02a80, 0xf0903bc0, 0xce2802e0, 0x851c11f0, 0x84b63668, 0x3c671924, 0x7642a30a, 0x29427f87, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x28000000, 0x14000000, 0x4a000000, 0xe3000000, 0x6f800000, 0x72c00000, 0x70200000, 0xe8300000, 0x34080000, 0xba3c0000, 0xcb0a0000, 0x7b850000, 0x38d28000, 0x9318c000, 0x87abe000, 0x46d4b000, 0xca000800, 0x23000c00, 0x4f800200, 0x82c00f00, 0x58200280, 0xfc300140, 0x7e0804a0, 0x593c0e30, 0xa48a06f8, 0x0945072c, 0x48f28702, 0x7b28ce83, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x28000000, 0x9c000000, 0x7e000000, 0xff000000, 0x43800000, 0x79c00000, 0xb8200000, 0x14100000, 0x52380000, 0xf9140000, 0x088a0000, 0xd8670000, 0x40ff8000, 0x108fc000, 0x7c78e000, 0x6ad27000, 0x5d800800, 0x96c00400, 0x33a00e00, 0xa1d00500, 0xbc180280, 0x8e0409c0, 0x673207e0, 0xa7b30ff0, 0xb3d58438, 0xa538c79c, 0xd69f6b82, 0x9759b141, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x48000000, 0x1c000000, 0xae000000, 0xf9000000, 0x6c800000, 0x95c00000, 0x7c200000, 0x3e300000, 0xe1080000, 0x489c0000, 0x6fd20000, 0x37270000, 0x059b8000, 0xe1764000, 0xcde72000, 0xb8277000, 0x94200800, 0x92300c00, 0x27080200, 0xdd9c0700, 0xe5520480, 0x47e701c0, 0xbb3b8ae0, 0xb3864f90, 0x3c4f26c8, 0x5b4b795c, 0x66da0fc2, 0xd3bb0fe3, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x48000000, 0xbc000000, 0x0e000000, 0xe1000000, 0xb5800000, 0x3dc00000, 0x8c200000, 0xd6100000, 0x75180000, 0xd7b40000, 0x9ad20000, 0x648f0000, 0x50538000, 0x25c04000, 0x38296000, 0x04157000, 0x4a200800, 0xcb100400, 0xae980600, 0xdb740d00, 0xeb720480, 0x335f0bc0, 0xa76b80e0, 0xc5644e10, 0x62636b58, 0x8aee73dc, 0x0c8180c2, 0x5c4f4961, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x98000000, 0x34000000, 0x12000000, 0x43000000, 0x04800000, 0xb8400000, 0x46200000, 0x41300000, 0x3fb80000, 0x58f40000, 0x74460000, 0x701d0000, 0x680c8000, 0x9c1cc000, 0x6e132000, 0xfd051000, 0x61980800, 0xedc40c00, 0xb9fe0e00, 0xbbe90d00, 0x80ca8980, 0x6041c340, 0x523fa120, 0x6329d430, 0x34b32848, 0xf0751784, 0xea000262, 0x67000513, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x98000000, 0xec000000, 0x0e000000, 0x29000000, 0x9f800000, 0xa9400000, 0x52200000, 0x8f300000, 0x32a80000, 0x1cd40000, 0xa8460000, 0x89ab0000, 0xac5b8000, 0x63964000, 0x5f65e000, 0x673f5000, 0xd6880800, 0xc6e40c00, 0x336e0a00, 0xa93f0500, 0x5fbd8980, 0x094d4ec0, 0x023660e0, 0x170d1290, 0xdea3e1f8, 0x12d45694, 0x81738722, 0x160241f3, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xf8000000, 0xfc000000, 0x1e000000, 0x2b000000, 0x67800000, 0xc5400000, 0xab200000, 0x27900000, 0x65680000, 0x9b2c0000, 0xdfae0000, 0x99570000, 0x852b8000, 0xf4a4c000, 0xfecee000, 0x405ad000, 0x5fae0800, 0xd9570400, 0x252b8a00, 0xc4a4c300, 0x06ceef80, 0xbc5adfc0, 0x41ae09e0, 0xf25706b0, 0x42ab8c78, 0x01e4cf54, 0xadeee532, 0x9bcaddb9, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x68000000, 0x9c000000, 0x06000000, 0x2f000000, 0xf8800000, 0x2a400000, 0x7f200000, 0x30900000, 0xc6780000, 0x81040000, 0xeb8a0000, 0xa4df0000, 0x82458000, 0x4321c000, 0x46b12000, 0x11571000, 0x8d8a0800, 0x5bdf0400, 0xf2c58e00, 0x6561c900, 0x57912680, 0x92c719c0, 0xb5720860, 0xdf9b06f0, 0x9eef8188, 0xdb6ecba4, 0x6c8ca172, 0x6072dac9, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xa8000000, 0x44000000, 0xc2000000, 0x13000000, 0xcf800000, 0xe2400000, 0x71200000, 0x6cb00000, 0xa5c80000, 0xa77c0000, 0x77ba0000, 0x9e690000, 0x0f048000, 0x2182c000, 0x5740e000, 0x1fa51000, 0xfa720800, 0xbd150c00, 0x9abe8200, 0xdcebc700, 0x3fc46a80, 0x9867d440, 0x1e12e420, 0xdd001d30, 0x0a8486f8, 0x24c2c524, 0xa3e0ef92, 0xb655158b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x18000000, 0x7c000000, 0x8e000000, 0x6f000000, 0x52800000, 0x1fc00000, 0x59200000, 0x71b00000, 0x2b780000, 0x5de40000, 0x90160000, 0xd8170000, 0x9c1f8000, 0x9e19c000, 0x770da000, 0x2ebb7000, 0x91ee0800, 0x36330c00, 0x23298e00, 0x34bec100, 0x04ea2180, 0xe186b7c0, 0xf355a0e0, 0xc1ef7af0, 0x0e000328, 0xaf000cfc, 0xb2800a12, 0x0fc001db, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x08000000, 0xf4000000, 0xa6000000, 0x77000000, 0x65800000, 0xd3c00000, 0x45200000, 0xe4900000, 0xd9680000, 0xbf4c0000, 0x28720000, 0x5de50000, 0x361d8000, 0x8f0bc000, 0x39a26000, 0x31ce7000, 0x9c3a0800, 0x02390400, 0xc9078a00, 0x5ea2cb00, 0xec4de080, 0xb3e0bf40, 0x1525e260, 0xfcacb370, 0x9557e458, 0xe549b23c, 0x0d4a66d2, 0xe9427e09, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x48000000, 0xf4000000, 0x26000000, 0x61000000, 0x17800000, 0x08c00000, 0xbb200000, 0x04b00000, 0xe8580000, 0x5d540000, 0x1cc20000, 0x8d350000, 0x4d958000, 0xdbe64000, 0x3bbee000, 0x32d4b000, 0xb83a0800, 0xcc110c00, 0x2a2f8600, 0x2b374d00, 0xecb16480, 0xac53ff40, 0xe3536a60, 0xc1d6fa10, 0x489eef78, 0x0264b18c, 0x16620132, 0x20450e0b, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x78000000, 0x74000000, 0x7e000000, 0x5f000000, 0xd0800000, 0x75400000, 0x7d200000, 0x2d900000, 0x18f80000, 0x85fc0000, 0xd86e0000, 0xb8950000, 0x496b8000, 0xef0dc000, 0x08bb2000, 0x9179d000, 0x0b360800, 0x7eb90400, 0xc25d8e00, 0xd1b4c700, 0x2ae6a780, 0x30cd1740, 0x59d0afe0, 0x3a7411f0, 0xe58d2b08, 0xb4c0d454, 0x1feb8652, 0xf14dc699, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xc8000000, 0x24000000, 0x8e000000, 0x39000000, 0x6a800000, 0x60400000, 0x5aa00000, 0xf8700000, 0x96a80000, 0xc2540000, 0xe99a0000, 0xb5dd0000, 0x6d798000, 0xb6334000, 0xa5332000, 0xb8b35000, 0xab798800, 0x6b334c00, 0x61b32200, 0x71f35900, 0x53598480, 0xd7034e40, 0x23bb2ae0, 0x72d75a90, 0x46eb8228, 0xc0ca4844, 0xfdf8af4a, 0x89491517, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xf8000000, 0xbc000000, 0xca000000, 0x39000000, 0x13800000, 0x55400000, 0xbba00000, 0xd1700000, 0x6d880000, 0xf2440000, 0xbf360000, 0x08ab0000, 0x9be48000, 0x5b754000, 0x34986000, 0x91ec1000, 0xc2648800, 0xf7354c00, 0x3cb86a00, 0xc5dc1d00, 0xec4c8780, 0x680147c0, 0x240666a0, 0x06331e90, 0xdb1e06b8, 0x6e9f0294, 0x30da8d1a, 0x1dda4387, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xf8000000, 0xe4000000, 0xfa000000, 0xad000000, 0xb6800000, 0x89c00000, 0x92a00000, 0x53d00000, 0x6fb80000, 0x2d5c0000, 0xfa460000, 0xa1c50000, 0xfea88000, 0xd5d64000, 0xec992000, 0x34d23000, 0x8c088800, 0xf6064400, 0x1b212600, 0xcd8e3300, 0x744e8780, 0x1ec34a40, 0xa909a9a0, 0x3c9879d0, 0xbcf7ace8, 0xf00172dc, 0xd819288a, 0xb41238ed, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x68000000, 0xe4000000, 0x86000000, 0x9d000000, 0xe1800000, 0xb0c00000, 0xeda00000, 0x12f00000, 0x16980000, 0x7e740000, 0x2fc20000, 0xc72d0000, 0x56b38000, 0x5e624000, 0xdfe7e000, 0xbf387000, 0xda938800, 0x3c524c00, 0xc4dfee00, 0xc3bc7100, 0x8bc98e80, 0x610b4240, 0x3bae6660, 0xc7f338d0, 0xe31de098, 0x3091794c, 0xd37a00ba, 0x566905ff, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xa8000000, 0x34000000, 0xd2000000, 0x59000000, 0xd6800000, 0xf1400000, 0x9aa00000, 0x8f500000, 0xada80000, 0x96cc0000, 0xa9420000, 0x46a10000, 0x49468000, 0x56af4000, 0xb1672000, 0xbaa51000, 0xff668800, 0x05bf4400, 0xa2ef2200, 0x7b791700, 0x1fac8280, 0x9fc24740, 0xa7e3af20, 0x2beb5290, 0x35e72fe8, 0x52e51854, 0x93468e8a, 0x0baf4e65, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x88000000, 0xcc000000, 0x5a000000, 0x77000000, 0x4e800000, 0x23400000, 0xd4a00000, 0xb4500000, 0xaa080000, 0x8f340000, 0x3a8a0000, 0xad570000, 0xbd948000, 0x1bfec000, 0xeacd2000, 0x41411000, 0x379c8800, 0x44cac400, 0xf8472a00, 0xb0161900, 0x58080080, 0xe43408c0, 0x060a0fa0, 0xa5170e70, 0xf5b48c68, 0x37eecef4, 0x80e528ea, 0x2e651c35, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x68000000, 0xb4000000, 0xb6000000, 0x09000000, 0x40800000, 0xb9400000, 0x3ea00000, 0x54700000, 0x30180000, 0x482c0000, 0x24220000, 0xae310000, 0xd5378000, 0x42af4000, 0x067da000, 0x770c1000, 0xadaf8800, 0xb7c34c00, 0x22ffae00, 0x404d1700, 0xd6000e80, 0xb9000740, 0xc8800560, 0x7d400790, 0xe0a00288, 0xe97000d4, 0xc698088a, 0xf86c05d7, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xb8000000, 0xe4000000, 0x86000000, 0x8d000000, 0x4b800000, 0x8ec00000, 0x79a00000, 0x1df00000, 0xab180000, 0xf6b40000, 0x8d560000, 0xbb5d0000, 0xbe5f8000, 0x59f24000, 0x1d1f6000, 0x33a2f000, 0x8ae78800, 0xefb64c00, 0x28d16e00, 0x048bf100, 0xfe4e0380, 0x79e90240, 0xed098660, 0x9baf49d0, 0xd6c0ef38, 0x8d90b6ac, 0x23d8e7fa, 0xc224b50f, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x88000000, 0xbc000000, 0xba000000, 0x6b000000, 0xbb800000, 0x27400000, 0x30a00000, 0x6cd00000, 0xfff80000, 0x505c0000, 0xa10a0000, 0x788b0000, 0xf0f88000, 0x95dbc000, 0x037d6000, 0x2eba9000, 0x59f28800, 0x1150c400, 0x2985e600, 0x60615b00, 0x690fe080, 0xa4aa5fc0, 0xfad765a0, 0x76e199b0, 0x04f20d38, 0xb3d706b4, 0x0272862a, 0xc610c0bd, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x58000000, 0x54000000, 0x56000000, 0x33000000, 0x54800000, 0xe4c00000, 0x17a00000, 0x18700000, 0xcf780000, 0x05c40000, 0xbe1e0000, 0xaf290000, 0x6e8f8000, 0x85dbc000, 0x7e23a000, 0xcf057000, 0x3e918800, 0xddf2cc00, 0x2a2c2600, 0x991eb500, 0x0d922d80, 0x8947b940, 0xcee5ab60, 0x8e987a30, 0x15f80ec8, 0x4604020c, 0xcb3e079a, 0x309902f7, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x78000000, 0xdc000000, 0xca000000, 0x43000000, 0xe3800000, 0x9c400000, 0xb8a00000, 0x73d00000, 0x06c80000, 0x1c7c0000, 0xf8860000, 0xd3c30000, 0x36e88000, 0x6445c000, 0x24bb6000, 0x19c65000, 0x75ee8800, 0x87c6c400, 0xb8f3ea00, 0xa1539300, 0x061def80, 0x813c99c0, 0xa4bb6ea0, 0x59c65330, 0xd5ee8bb8, 0xb7c6c304, 0xc0f3eaaa, 0x7d539dcd, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x08000000, 0x5c000000, 0x3a000000, 0x2f000000, 0xac800000, 0x94c00000, 0x5fa00000, 0xc2700000, 0x44480000, 0xa1740000, 0x1afa0000, 0xe68b0000, 0x43f08000, 0x9732c000, 0xa8a4a000, 0x5add7000, 0x86aa8800, 0x73c9cc00, 0x0f1c2a00, 0xfc9bb900, 0x3cf42880, 0x939fb9c0, 0xf04621a0, 0x3760b7f0, 0x37cca848, 0xa119798c, 0x15b884da, 0x1546ce17, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x28000000, 0xc4000000, 0x3a000000, 0x9b000000, 0xa1800000, 0x93400000, 0xa0a00000, 0xf9f00000, 0x2a580000, 0x560c0000, 0xa5020000, 0xe0950000, 0xd9d88000, 0xba7dc000, 0x0e07e000, 0x49049000, 0x1e828800, 0x78e4cc00, 0x80dd6e00, 0x3cec5700, 0x7addea80, 0x47dd9040, 0xab7805a0, 0xfcbc02b0, 0xcffa0698, 0x3f690274, 0x7e828b2a, 0xc8e4ca6f, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x28000000, 0xa4000000, 0xfe000000, 0x3d000000, 0x82800000, 0xb3400000, 0x05a00000, 0x42f00000, 0x41780000, 0xa28c0000, 0x63620000, 0x3d8d0000, 0xbed98000, 0x33544000, 0xc5ba2000, 0x22fe1000, 0x31638800, 0x8aa54c00, 0xc779a600, 0xc3ab5700, 0x83e22a80, 0xb1c21640, 0x76d981e0, 0x275448d0, 0x73ba2ca8, 0xcbfe1674, 0x65e3853a, 0xa0e541bf, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x88000000, 0x5c000000, 0xea000000, 0x43000000, 0x40800000, 0xfc400000, 0x9da00000, 0x19f00000, 0x90580000, 0xdf8c0000, 0x96ea0000, 0xc2d30000, 0xb4d48000, 0xfdcdc000, 0x8e49a000, 0xba835000, 0x87468800, 0xe922cc00, 0x238f2e00, 0x2ce19700, 0x99e9a080, 0x507359c0, 0x3f9e88a0, 0xe6eecf30, 0x4ac52288, 0xe8c29d04, 0x17e527fa, 0xcd729c6f, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x58000000, 0x9c000000, 0x2a000000, 0xcf000000, 0x3d800000, 0x4c400000, 0x0ca00000, 0x70d00000, 0xb4780000, 0x60840000, 0xb2de0000, 0x6f6b0000, 0xb3188000, 0x878ac000, 0xbb4ee000, 0x7d285000, 0x4e9e8800, 0xebf5c400, 0x07d06600, 0x85dd9d00, 0x3eceed80, 0x3d685dc0, 0x503e8ca0, 0x1825c5f0, 0xfc286058, 0xfa199004, 0x9730efea, 0xa193563d, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xe8000000, 0x0c000000, 0xbe000000, 0x2f000000, 0x73800000, 0x12400000, 0x3a600000, 0x16700000, 0x58680000, 0x0f4c0000, 0x98f60000, 0x38b50000, 0x93fa8000, 0xd9014000, 0xe0b5a000, 0xc7dd3000, 0x7335a800, 0x059d3400, 0xc155ae00, 0x8fed3d00, 0xcf3da080, 0xa3a13dc0, 0x9a4bab60, 0xa6543f30, 0x40512c58, 0x7b657e14, 0xc2ec8ffe, 0xa5844f73, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x08000000, 0x74000000, 0xea000000, 0x15000000, 0xdc800000, 0x40c00000, 0xe8e00000, 0xccd00000, 0x0ed80000, 0xfffc0000, 0xc17e0000, 0xe0a30000, 0x3ef98000, 0xa7ecc000, 0x9d63e000, 0xee9fd000, 0xc9e3e800, 0x1a5fdc00, 0xeb03ea00, 0x538fd500, 0x315bea80, 0x98b3d240, 0xf2c5e420, 0xa1c0d310, 0x1e6469e8, 0xb910171c, 0xaa998766, 0x7bfccbd1, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xa8000000, 0x9c000000, 0xfa000000, 0xd3000000, 0xdb800000, 0xb4c00000, 0x88e00000, 0x62d00000, 0x39d80000, 0xae6c0000, 0x48860000, 0x8f410000, 0xcc2f8000, 0x92034000, 0x6f39a000, 0xf1829000, 0xcfd9a800, 0xcf529c00, 0x2c01aa00, 0x623e9100, 0x1707a080, 0xc5bf98c0, 0xa9c82f20, 0xe66cd5f0, 0x24a98298, 0x0d424ebc, 0x2b162216, 0x2f81d491, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x88000000, 0xfc000000, 0xe6000000, 0x59000000, 0x18800000, 0xc1400000, 0x95600000, 0x1f700000, 0xf8480000, 0xfdc40000, 0xb6260000, 0xa1390000, 0x8c908000, 0xeb7ec000, 0xa254e000, 0xa2d6b000, 0xc7b4e800, 0xf0e6b400, 0x249ce600, 0x8752b700, 0x1c72ee80, 0xbfefb8c0, 0x4d2460e0, 0x72987d50, 0x16480168, 0x18c40144, 0xa8a6003e, 0x097904b3, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x58000000, 0x84000000, 0xca000000, 0x6b000000, 0x1f800000, 0x12400000, 0x98600000, 0xd3500000, 0xfce80000, 0x669c0000, 0x22ea0000, 0xbf9b0000, 0xe2418000, 0xf0474000, 0xdf6aa000, 0xead53000, 0x4382a800, 0x9c493c00, 0xd968a600, 0x77d23100, 0xa9292380, 0x68957940, 0xa3c38f20, 0xfb004ff0, 0x67a126d8, 0xa65972d4, 0xda41895e, 0x64474ee1, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x68000000, 0xe4000000, 0x7e000000, 0x87000000, 0xda800000, 0x2c400000, 0x62600000, 0x3d700000, 0x9bd80000, 0x158c0000, 0x02f60000, 0xf83f0000, 0x6c388000, 0x6a354000, 0xc125e000, 0xd199f000, 0x6cfde800, 0xb715f400, 0x028be200, 0x506af100, 0xc0536480, 0x486fbf40, 0x5c4e8360, 0x1a4a4730, 0x117d66c8, 0x51dcb1f4, 0x848002ee, 0xbb400323, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xd8000000, 0xfc000000, 0xba000000, 0x2f000000, 0xd0800000, 0x78c00000, 0xaae00000, 0x81f00000, 0x07680000, 0x42b40000, 0x33e20000, 0x5c6d0000, 0x1c0b8000, 0x8a244000, 0x972a6000, 0x5ca55000, 0x1ac26800, 0x79d15400, 0xeb406e00, 0x508c5300, 0x38c3e380, 0xcaec1cc0, 0xf1e38820, 0xdf504e30, 0xbea86d28, 0x89f85dbc, 0x7341e986, 0xccb116a3, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xb8000000, 0x74000000, 0x02000000, 0xbf000000, 0x18800000, 0x05c00000, 0x5be00000, 0x6af00000, 0xdb680000, 0x6b2c0000, 0x2aa20000, 0x72ef0000, 0x9f578000, 0xa12c4000, 0x49bc6000, 0xa4741000, 0x53b46800, 0x5f681400, 0x811e6e00, 0x399b1500, 0x0c63e580, 0x9f845240, 0x294205a0, 0x3c1f09b0, 0x9e3f8c28, 0x11004dec, 0xc19e6f96, 0x185b1a43, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xc8000000, 0xdc000000, 0x12000000, 0x65000000, 0x6d800000, 0x97c00000, 0xc1e00000, 0x72f00000, 0xec680000, 0x85140000, 0xdd860000, 0x3fe10000, 0xeddd8000, 0xa8e8c000, 0x5559a000, 0xfab75000, 0x2f51a800, 0x93935400, 0x08dfae00, 0x85565b00, 0xa28c2280, 0xcb7b96c0, 0x958603a0, 0xa3e10090, 0x9fdd8d78, 0x3de8cdec, 0xf0d9a766, 0xb17755c3, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x38000000, 0x4c000000, 0x66000000, 0xfb000000, 0xc4800000, 0x4cc00000, 0x47e00000, 0x7b500000, 0x5b980000, 0x0a640000, 0xb23a0000, 0x61310000, 0x418c8000, 0x4f684000, 0x91b86000, 0xc77fd000, 0xc5826800, 0x9d4edc00, 0x608eea00, 0xeee69b00, 0x8ed68980, 0x1ec94fc0, 0x76cce7e0, 0x72e39c70, 0x60f801a8, 0xb1f403bc, 0xe8420c56, 0x9b050bc9, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xc8000000, 0xdc000000, 0x22000000, 0x4b000000, 0xa8800000, 0x00c00000, 0xbfe00000, 0x19500000, 0xd8880000, 0x68e40000, 0x33c60000, 0xc3590000, 0x87858000, 0x3e494000, 0x5a366000, 0x9f01d000, 0x36906800, 0x59c8dc00, 0x947dee00, 0x6d359f00, 0x45858280, 0x854942c0, 0x5ab668a0, 0x73c1da70, 0x63706c28, 0xd798d57c, 0xc675ed56, 0x4e119a29, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xc8000000, 0x44000000, 0x82000000, 0x2d000000, 0xef800000, 0x67400000, 0x48600000, 0xcaf00000, 0x62380000, 0x9d2c0000, 0xd78e0000, 0x3b570000, 0x46638000, 0x21cac000, 0x22a82000, 0x38c57000, 0x171e2800, 0xdebe7400, 0xa6f3aa00, 0x1423b900, 0x0a380680, 0x492c0d40, 0xbd8e06a0, 0x82570b90, 0xe3e38a58, 0x2f8ac0e4, 0x0748225e, 0xb875780b, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xd8000000, 0xc4000000, 0xc6000000, 0xa1000000, 0x6a800000, 0xb5c00000, 0xcae00000, 0x65700000, 0xec080000, 0x9a340000, 0x43120000, 0x7d9b0000, 0xa6768000, 0xd188c000, 0xdc536000, 0xe2879000, 0x79c96800, 0x80e89400, 0x6e4de600, 0xfd8b5300, 0xe6600b80, 0x31b00f40, 0xac680fe0, 0x3a840150, 0xbdfa0748, 0x46df0d0c, 0xcf6c8666, 0x9727c71b, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xb8000000, 0x14000000, 0x56000000, 0x29000000, 0x7d800000, 0xd6400000, 0xe1600000, 0x69d00000, 0x88380000, 0x7c1c0000, 0x5a020000, 0x7b2f0000, 0xbabe8000, 0x96dac000, 0x1ca0a000, 0x77d0b000, 0x7d1aa800, 0x4ba3bc00, 0x4f462200, 0x34c67d00, 0x13800980, 0x2b400c40, 0x6ae004e0, 0x869002d0, 0xacd80938, 0xd78c0eb4, 0x655a0cae, 0x47e30969, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x58000000, 0xf4000000, 0x4e000000, 0x57000000, 0xbf800000, 0xd0c00000, 0xf5e00000, 0x4f500000, 0xf5080000, 0xf2b40000, 0x66520000, 0xe5970000, 0x79c88000, 0x25434000, 0xa425a000, 0xc6301000, 0xeb1fa800, 0x2d831c00, 0x65ed2e00, 0xa7735b00, 0x393a0b80, 0x38b30440, 0x27728760, 0xf9304d30, 0x58b72a98, 0x5750573c, 0xa1208846, 0xaca74089, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x68000000, 0x1c000000, 0x3a000000, 0x07000000, 0xfc800000, 0xe6c00000, 0xd2600000, 0xf8b00000, 0xe8c80000, 0x93440000, 0xc9160000, 0x9d950000, 0x476d8000, 0x3f094000, 0x58b3e000, 0x38d71000, 0x6b5e6800, 0x4d1e5400, 0xd38d8e00, 0x66794b00, 0xfe9be080, 0x45e31ec0, 0xf0e06d20, 0xa77f55b0, 0x8f3e0268, 0x50a1051c, 0xd4d3826e, 0x39684f27, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x28000000, 0x7c000000, 0x5e000000, 0x9d000000, 0xde800000, 0x7d400000, 0xfbe00000, 0x02900000, 0x13480000, 0xbedc0000, 0x981e0000, 0x641d0000, 0xfa348000, 0x873ec000, 0x4985e000, 0x1ce07000, 0x9b316800, 0xc79ebc00, 0x49d48600, 0x29aecd00, 0xcccdec80, 0x533c76c0, 0xabaf6f60, 0x3fc3b210, 0xc8800e08, 0x4c400304, 0xb3600ed6, 0x8ed0013d, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0xac000000, 0x12000000, 0x93000000, 0x39800000, 0x97400000, 0x82e00000, 0x47b00000, 0x36480000, 0x38640000, 0x916e0000, 0x87c10000, 0x431b8000, 0x61b64000, 0x2347a000, 0x44fa3000, 0x62bc2800, 0x22fc7400, 0x17b38e00, 0x2e624300, 0xec61a680, 0x275f3dc0, 0xaac9a9a0, 0xfb8b37f0, 0x5c6facb8, 0x0f6e3344, 0x16fa2536, 0x91a974cf, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x28000000, 0x04000000, 0xee000000, 0xd3000000, 0xe3800000, 0xfa400000, 0x65e00000, 0x9d900000, 0xa1680000, 0x324c0000, 0x71ee0000, 0x3b830000, 0xa6668000, 0x17c94000, 0x5ca32000, 0x53def000, 0x12a5a800, 0x30c7bc00, 0x090e8e00, 0xe6854100, 0x86cd2480, 0x461dfd40, 0x17232460, 0x6d9ef170, 0xf945aed8, 0xae57b394, 0x63e684e6, 0x2a89473d, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x4c000000, 0x06000000, 0xf3000000, 0x25800000, 0xd2c00000, 0x51600000, 0x00b00000, 0x2c480000, 0x8a2c0000, 0xd51e0000, 0xe6910000, 0xcf468000, 0xa7874000, 0x1bf6a000, 0xd9c45000, 0x70f82800, 0xa86f1400, 0xb0108e00, 0x783a4100, 0x442e2080, 0x1a1211c0, 0x9d280ee0, 0x9a9c0ff0, 0xf1560438, 0x70bd071c, 0x745881ce, 0xfe1649e7, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x08000000, 0x4c000000, 0xb6000000, 0xf9000000, 0xb2800000, 0x93400000, 0x87e00000, 0x55900000, 0xc4c80000, 0x88040000, 0x8c2e0000, 0x56290000, 0x89228000, 0xba91c000, 0xdf41e000, 0x31c5f000, 0xacab6800, 0x76503c00, 0x1b448600, 0x0bfccb00, 0x03ad6e80, 0x4ded33c0, 0x328003e0, 0x53400750, 0x67e00e48, 0x259001a4, 0xccc803d6, 0xc40408ad, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x08000000, 0x64000000, 0xda000000, 0xc5000000, 0x8b800000, 0x66c00000, 0x9f600000, 0x88b00000, 0x6e580000, 0xb10c0000, 0x19b60000, 0xe7d30000, 0x5eeb8000, 0x2375c000, 0x1eb2a000, 0x8571d000, 0x2d812800, 0x55c81400, 0x4fe58a00, 0xeadacd00, 0xd1572280, 0x2fab1f40, 0xdcd60520, 0xea630e10, 0x9b338718, 0x64b9c33c, 0x9064a1ce, 0x8e12d8a7, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xb8000000, 0xe4000000, 0x76000000, 0x87000000, 0x5f800000, 0x12c00000, 0xf3600000, 0xfa900000, 0xe4780000, 0x0d140000, 0x7aa20000, 0x245f0000, 0x2d388000, 0x8aa24000, 0x9c472000, 0xc912d000, 0xfc87a800, 0x1b649c00, 0x96828a00, 0xee794300, 0xe825a980, 0x6c3b9140, 0x0a3a04e0, 0xe51b0a30, 0x16828098, 0x2e79465c, 0xc825a14e, 0x9c3b90c5, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xe8000000, 0x54000000, 0x4e000000, 0xfd000000, 0xbf800000, 0x57400000, 0x32e00000, 0x36b00000, 0x16f80000, 0xd0b40000, 0x1fd60000, 0xd1270000, 0x5daa8000, 0x087ec000, 0x7259a000, 0xd163b000, 0x2beb2800, 0x8f197400, 0x189c8200, 0xfbe9cb00, 0xd70b2480, 0x04a97a40, 0x11e48260, 0x8c1dce90, 0x123d2518, 0xb73e75a4, 0x14b60e56, 0xa9d7075f, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x98000000, 0xb4000000, 0x7a000000, 0x97000000, 0x63800000, 0xf5400000, 0x70e00000, 0xd4900000, 0x66e80000, 0x2dac0000, 0xd8420000, 0xe4730000, 0x12778000, 0x7b554000, 0x3dcc2000, 0x10013000, 0x3833a800, 0x84287c00, 0xb2358e00, 0xbb264900, 0xadbbaf80, 0x18547e40, 0x847f8620, 0x42694e30, 0xe3662798, 0x89de3324, 0x6a0620b6, 0xaf0e355d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x48000000, 0xf4000000, 0xd6000000, 0x8d000000, 0x46800000, 0x00400000, 0x3be00000, 0x25100000, 0x02980000, 0xee5c0000, 0xdac60000, 0x09bf0000, 0xadd08000, 0xc82ac000, 0x3424e000, 0x7616b000, 0x5d326800, 0x0e837c00, 0xf4460200, 0xedff0100, 0xa8308e80, 0x443ac240, 0xee3ce9e0, 0xe10ab790, 0x2c946108, 0xaf6c74d4, 0x266e85d6, 0xeed9c355, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xd8000000, 0x64000000, 0xaa000000, 0x69000000, 0x9a800000, 0xf4c00000, 0x9f600000, 0x75100000, 0x24b80000, 0xcfe40000, 0xb8fa0000, 0x697f0000, 0x422b8000, 0x1524c000, 0x74aee000, 0x87d89000, 0xb4ff6800, 0x7f435c00, 0xe51a0a00, 0x4caf0700, 0x73f38f80, 0x76d0cd40, 0xaa6ce720, 0xb18390d0, 0x7b4eeb08, 0x1f0895dc, 0x6da76a5e, 0xe5775f1d, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x98000000, 0x1c000000, 0xe6000000, 0xdf000000, 0xae800000, 0x0ac00000, 0x7f600000, 0xe1100000, 0xcda80000, 0x92740000, 0x82aa0000, 0xb4d10000, 0xdc468000, 0x19b24000, 0x80526000, 0x5fba1000, 0x8f5ee800, 0xd9095c00, 0x01820e00, 0x5c650700, 0xd98c8f80, 0xe0734ac0, 0xefbce7e0, 0x177c5c30, 0xc5268c88, 0xe7a2415c, 0x837a6b1e, 0x770e15bd, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xa8000000, 0x9c000000, 0xf6000000, 0x15000000, 0x89800000, 0xe7c00000, 0x75600000, 0x9a300000, 0x9b280000, 0x489c0000, 0x944e0000, 0xd9ad0000, 0xefca8000, 0x9960c000, 0x54332000, 0xba199000, 0xab1fa800, 0x90885400, 0x30480600, 0x1bac0d00, 0x90e60480, 0xf3f100c0, 0x2f6485e0, 0xa13dc890, 0xa3b1a7f8, 0xe4d55f2c, 0x79ca87ce, 0x5c60c3df, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x78000000, 0xa4000000, 0x5e000000, 0xf3000000, 0x97800000, 0x6d400000, 0x4be00000, 0x18300000, 0x34280000, 0xc60c0000, 0x872a0000, 0xb1b70000, 0x3a7e8000, 0x824b4000, 0x86692000, 0xe876b000, 0xb375a800, 0xf8f6f400, 0x6f800600, 0x89400900, 0xf5e00980, 0x3b300740, 0xdba80260, 0x0f4c0570, 0x92ca0c98, 0x5a8709e4, 0x99d68dc6, 0x29074757, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x38000000, 0x0c000000, 0x1e000000, 0x63000000, 0xcc800000, 0xb3c00000, 0xc6600000, 0xb0300000, 0x58180000, 0x5c140000, 0x56120000, 0x570d0000, 0xde848000, 0xcedf4000, 0x69cbe000, 0xcf6fd000, 0x2da56800, 0x2a599400, 0xbe000a00, 0x53000300, 0xd4800180, 0xcfc007c0, 0xe0600260, 0xdf3006f0, 0x8a980d28, 0x8cd40d0c, 0x5cf200ae, 0x54fd003f, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xd8000000, 0xc4000000, 0xe2000000, 0x7b000000, 0x38800000, 0x10c00000, 0x3aa00000, 0xe0100000, 0x30180000, 0xb80c0000, 0x341e0000, 0x3a1b0000, 0xbf188000, 0xda9c4000, 0x6bcf6000, 0x02271000, 0xf0d21800, 0x0abf5400, 0x58000200, 0x04000300, 0x82000180, 0x8b0003c0, 0xe0800360, 0xd4c00310, 0xd8a00388, 0x9b1001ec, 0x089800e2, 0xa8cc0043, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x18000000, 0x5c000000, 0xae000000, 0xa9000000, 0x3b800000, 0x78c00000, 0x18e00000, 0xb8100000, 0xcc180000, 0xe61c0000, 0x5d160000, 0xd1830000, 0x23cb8000, 0x2475c000, 0x52452000, 0x97bf7000, 0x3e231800, 0x31fd1c00, 0x43800200, 0x54c00300, 0x4ee00380, 0xfd1002c0, 0x41980060, 0x6bdc0170, 0xd07602b8, 0xb85302a4, 0xccb380ee, 0x02b9c1e3, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x38000000, 0x44000000, 0xda000000, 0xe5000000, 0x59800000, 0x35400000, 0x5ca00000, 0x74100000, 0x02080000, 0xf1140000, 0x4b9e0000, 0xac470000, 0x9b288000, 0x7e4b4000, 0xe234a000, 0xe9cf3000, 0x2070a800, 0x75e89400, 0xa6a00200, 0x21100100, 0xc3880280, 0x705403c0, 0xf53e00e0, 0x79570110, 0x1aa08368, 0x5f1f4394, 0xac8aa166, 0x04d830d5, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x58000000, 0x44000000, 0x32000000, 0x87000000, 0xc9800000, 0x8b400000, 0xb3200000, 0xb4100000, 0xfa080000, 0x3b140000, 0x6f9a0000, 0x664b0000, 0xb9a88000, 0xc4d64000, 0x4578e000, 0xf5bd3000, 0xaad36800, 0x14616400, 0x59200200, 0x37100100, 0xa1880280, 0xe7540340, 0x4d3a0160, 0x1d1b0110, 0xc28080c8, 0xccd2421c, 0x196ae326, 0x23a2322d, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x08000000, 0xf4000000, 0x86000000, 0xd7000000, 0x5e800000, 0xec400000, 0x9b600000, 0xe6100000, 0x27180000, 0x66840000, 0x00420000, 0xe1610000, 0x430e8000, 0x2888c000, 0x035ee000, 0x29e9d000, 0x704c8800, 0x1975ec00, 0x8f180200, 0x42840300, 0xae420080, 0xd2610040, 0x938e8020, 0xe7c8c3d0, 0x40bee218, 0xf4b9d35c, 0x92b4897a, 0x75a1efb1, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x88000000, 0x84000000, 0x12000000, 0xdd000000, 0xd6800000, 0x36400000, 0xd1e00000, 0x56100000, 0x6f080000, 0x3b9c0000, 0xb8da0000, 0xebb10000, 0x11e08000, 0xf61a4000, 0x5f0fa000, 0x639cd000, 0xb4cdc800, 0x7dbbbc00, 0xdee80200, 0xfd8c0100, 0xbfd20380, 0x842d0340, 0x333a8220, 0x44ab4210, 0x8a6f2048, 0x7ec69374, 0xeca26b5a, 0x7e776cd9, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xd8000000, 0x0c000000, 0x1e000000, 0x5d000000, 0x2e800000, 0xd8400000, 0x83200000, 0xf2100000, 0xb3080000, 0xcb8c0000, 0x4ad60000, 0x9d7b0000, 0x20318000, 0x719bc000, 0xfdcfa000, 0x2cffd000, 0xfde60800, 0x8d72e400, 0x68280200, 0x759c0100, 0x87de0180, 0xbbf702c0, 0x9c678360, 0x38a0c030, 0x40de2078, 0xf2741174, 0x9da1a8ba, 0xb2413761, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xc8000000, 0xa4000000, 0xf2000000, 0x23000000, 0xba800000, 0x5ec00000, 0xc1600000, 0x1e100000, 0xb5180000, 0x8b9c0000, 0xb74e0000, 0xed390000, 0x25a48000, 0x98764000, 0x03906000, 0x335d5000, 0x8f20d800, 0xbeabac00, 0x4ef80200, 0x0b4c0300, 0x23360380, 0x08b501c0, 0xeff28320, 0x5ad34290, 0x637ae3c8, 0x6512108c, 0x13943aea, 0x4b40bd7b, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x58000000, 0x8c000000, 0x5a000000, 0xcd000000, 0x78800000, 0x02400000, 0x07600000, 0x5e100000, 0xe3180000, 0x938c0000, 0x25d20000, 0x64ab0000, 0xf5a18000, 0x2f234000, 0x9c7da000, 0x71991000, 0x34cd4800, 0x7e246c00, 0x26f80200, 0x52dc0300, 0x812a0180, 0xb7770240, 0x360b8160, 0xc7144230, 0x8d962168, 0x66dd5334, 0x072369e2, 0x18653c09, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x18000000, 0xcc000000, 0x0e000000, 0xb1000000, 0x1a800000, 0xf3c00000, 0x0b200000, 0x61100000, 0xb2980000, 0x07c40000, 0xb92e0000, 0xc6130000, 0xd5018000, 0xe085c000, 0xf0d82000, 0xb6a05000, 0xf557f800, 0x5ef8a400, 0x2f2e0200, 0x7b130300, 0xe1818080, 0xd245c1c0, 0xf9782060, 0xe8705330, 0x42eff838, 0x892ca6c4, 0x3e18026a, 0x490400cf, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xd8000000, 0x04000000, 0xe2000000, 0xe7000000, 0x95800000, 0xbdc00000, 0x6ba00000, 0xdf100000, 0x81880000, 0xe7cc0000, 0xd8aa0000, 0x708b0000, 0xdf488000, 0xfbf04000, 0x5d66e000, 0x0f31b000, 0x5a433800, 0xc97f3400, 0x152a0200, 0x894b0100, 0x36e88180, 0x93e04140, 0x916ee360, 0x513db010, 0x0b493b88, 0x81e4379c, 0xde6a8056, 0x28b743f7, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xc8000000, 0x74000000, 0x0a000000, 0xff000000, 0x45800000, 0xdec00000, 0xfde00000, 0xe7100000, 0xa9980000, 0xf8cc0000, 0x44fe0000, 0xeb890000, 0xb3d68000, 0x6b6d4000, 0x3a51e000, 0xc3a9b000, 0x26a95800, 0x6428fc00, 0x237e0200, 0x8e490300, 0xa9b68180, 0x29bd43c0, 0xe9a9e320, 0x89b5b1d0, 0x79af5828, 0xb1bdfffc, 0xc5ae8316, 0xcfb1407b, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x68000000, 0x24000000, 0xda000000, 0xc1000000, 0xd1800000, 0x17c00000, 0x02200000, 0x75100000, 0xa3980000, 0xd2c40000, 0x19a20000, 0xcbdd0000, 0x543c8000, 0x6a0f4000, 0x79022000, 0xbd933000, 0xf9c47800, 0x71360400, 0x41820200, 0xbfcd0300, 0x06248080, 0xbf0b4040, 0x0a8021a0, 0x275e3090, 0xd460fb68, 0x08fd4704, 0xf0a22146, 0xde43335f, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x18000000, 0x1c000000, 0x3a000000, 0x29000000, 0x43800000, 0xd1c00000, 0x6c600000, 0xad100000, 0x25880000, 0x22dc0000, 0x96f20000, 0x27530000, 0x842b8000, 0xd9ab4000, 0x376f2000, 0x638f7000, 0xe1dfb800, 0x0467cc00, 0x39120200, 0x1b830100, 0x2dc38380, 0xc6674240, 0x9c152060, 0x7a007070, 0xc90638e8, 0xd39f8ca4, 0xc9d6a30e, 0x70673247, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xc8000000, 0xc4000000, 0xf6000000, 0xd9000000, 0x38800000, 0xe3400000, 0x1ae00000, 0x9f100000, 0x19880000, 0xa7dc0000, 0x93b20000, 0xa6e90000, 0x55008000, 0x4a8ac000, 0x2c552000, 0x6b6c1000, 0x8ccde800, 0x242d1c00, 0xd43a0200, 0xcc350100, 0x20328380, 0x8223c240, 0x6535a320, 0x40b6d310, 0x6d70cbd8, 0x4dcd0f64, 0xf0adeae2, 0x957d1e8d, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xb8000000, 0x3c000000, 0x56000000, 0x85000000, 0x6c800000, 0x51c00000, 0x70a00000, 0xeb100000, 0x95880000, 0x8b5c0000, 0x94660000, 0x4f270000, 0x135f8000, 0x387ec000, 0x713aa000, 0x22449000, 0x86eeb800, 0xcfe95400, 0xed6e0200, 0xd5bb0100, 0x17998380, 0xac49c0c0, 0x4fed22e0, 0xad6650f0, 0x35b21958, 0x278ac614, 0x145f3bb2, 0x73ec9447, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0xd4000000, 0x7e000000, 0x7b000000, 0xee800000, 0xb1c00000, 0xad600000, 0x51100000, 0xab880000, 0x444c0000, 0xc2260000, 0x25bd0000, 0x83e28000, 0xc0dbc000, 0x56ed6000, 0x4d4ad000, 0xd5afb800, 0xcbf1ec00, 0x44ce0200, 0x70e10100, 0x8a4c8180, 0x912ac0c0, 0x7f29e1a0, 0x7c2c1350, 0x7ea059f8, 0x3d60fdec, 0x290cd9ba, 0x479a3fc7, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x38000000, 0x74000000, 0x96000000, 0x77000000, 0x5a800000, 0xef400000, 0x1ee00000, 0x35100000, 0x6b880000, 0x6acc0000, 0x173e0000, 0x1eb70000, 0xd5768000, 0x8fc6c000, 0xd4b4e000, 0xc86e5000, 0x18526800, 0x047c9c00, 0xba560200, 0x856b0100, 0x67c08180, 0x08bdc3c0, 0xe27c60e0, 0xb55f91d0, 0xcbf00a58, 0xee840ddc, 0x59588b6a, 0xf9e5cebd, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xd8000000, 0x64000000, 0xda000000, 0x97000000, 0x85800000, 0x18c00000, 0xb6a00000, 0x59100000, 0x70880000, 0xfe440000, 0x99f60000, 0xdc6b0000, 0xa4b48000, 0x82074000, 0xb308e000, 0x7f99b000, 0x3fc29800, 0xeb3a1400, 0x25de0200, 0x1c3f0100, 0x304a8080, 0x6ce842c0, 0x3aea6360, 0x8be5f190, 0x0776fb68, 0x6720e65c, 0x03c27816, 0x1527a563, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x28000000, 0x14000000, 0x6a000000, 0x91000000, 0x05800000, 0xb5400000, 0xbba00000, 0xa7100000, 0xda980000, 0x83dc0000, 0x7e7e0000, 0xee750000, 0xf66a8000, 0x2a794000, 0xa4782000, 0x776fb000, 0xf7fb2800, 0x2d37b400, 0xb2c60200, 0xabf90300, 0x632c8380, 0x81c043c0, 0xdb74a0a0, 0x91fff050, 0x0a3789a8, 0xa8444644, 0xc8378a16, 0xed4445d5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x48000000, 0xac000000, 0x8e000000, 0xe5000000, 0x4e800000, 0x97c00000, 0xe5600000, 0x3e900000, 0x0fd80000, 0xe17c0000, 0x0c920000, 0x2cd10000, 0xe6e98000, 0x5bc3c000, 0xbb6da000, 0x73905000, 0xfd593800, 0xb0b50c00, 0xa0e98200, 0xd2c3c300, 0x9beda380, 0x11505040, 0x1eb93920, 0xb5e50eb0, 0xc4518038, 0xe82fc094, 0xd627a2ba, 0x4b3d521f, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xc8000000, 0x04000000, 0x0a000000, 0x1b000000, 0xeb800000, 0x57400000, 0x0fe00000, 0x63900000, 0xf3580000, 0xb5ec0000, 0x608a0000, 0xd4c10000, 0xecac8000, 0x7e6b4000, 0x47d26000, 0xa329f000, 0x932da800, 0x4b299c00, 0xe72c8200, 0x392b4300, 0xe0326180, 0x14b9f340, 0xa275ab20, 0xe1c59c10, 0x66268228, 0xa1aa436c, 0xe8fee22e, 0x5e02b21d, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xb8000000, 0x94000000, 0x12000000, 0xdd000000, 0x86800000, 0xe0400000, 0xd2a00000, 0xb2900000, 0xa2480000, 0x97a40000, 0xb0120000, 0xe81f0000, 0x0c168000, 0x96004000, 0x770ca000, 0xcf825000, 0x74de4800, 0xefe1f400, 0xe6b68200, 0xf0904100, 0xe744a080, 0x95265040, 0xfa4c4ae0, 0x73bef650, 0x2a000248, 0x09000274, 0xb480029a, 0x2d4003c1, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xf8000000, 0x74000000, 0x66000000, 0x13000000, 0x9b800000, 0x8a400000, 0xf6200000, 0x5f900000, 0x54480000, 0xf12c0000, 0x92160000, 0x35170000, 0xe8828000, 0x21cac000, 0x847d6000, 0xddadf000, 0x6dc58800, 0xb678a400, 0xf8a28200, 0x2d5ac100, 0x2bb56180, 0x96c1f0c0, 0xf1f38be0, 0xa8ffa5d0, 0x22680398, 0xeebc014c, 0xa65e03ee, 0xf43b02e9, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x28000000, 0xdc000000, 0x22000000, 0x27000000, 0xed800000, 0xa7c00000, 0xbf200000, 0x09900000, 0x51d80000, 0xd63c0000, 0x991a0000, 0xc89d0000, 0xdd478000, 0x8d6e4000, 0xe571e000, 0x196e3000, 0x8b64b800, 0xd46d0400, 0xcde78200, 0x943e4300, 0x2e09e380, 0xed023140, 0xf686b8a0, 0x385c0770, 0x17e20288, 0x8731039c, 0xdd858036, 0x1fcf43df, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x08000000, 0x8c000000, 0x5e000000, 0x1b000000, 0xda800000, 0x62c00000, 0xcc600000, 0x2e900000, 0xe8c80000, 0xed7c0000, 0x2d120000, 0x1d890000, 0x0e4d8000, 0x29a9c000, 0x6e726000, 0x3392d000, 0x4d539800, 0x9724ec00, 0xcead8200, 0xb2f9c100, 0x2e5a6380, 0x99bed040, 0x96699820, 0xa781ee30, 0x975a0378, 0x5e35016c, 0x513f80ea, 0x11b0c1cb, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x68000000, 0x5c000000, 0x56000000, 0x87000000, 0xa3800000, 0x22c00000, 0x30a00000, 0x95900000, 0xd5c80000, 0x1b3c0000, 0xdb560000, 0xdb650000, 0x55a78000, 0xfb14c000, 0x6589e000, 0x1dc5f000, 0x97259800, 0xd5407400, 0x686f8200, 0xfc28c100, 0x08dfe380, 0x71a0f0c0, 0x090219a0, 0x5094b570, 0x6b466358, 0xf37d331c, 0xe9b2790e, 0x9d1c844b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0x64000000, 0xb6000000, 0x19000000, 0xd6800000, 0x36c00000, 0x40200000, 0xd0900000, 0xa7d80000, 0x12bc0000, 0x60560000, 0xb6f10000, 0x70a08000, 0x4758c000, 0xfd6e2000, 0x16fc5000, 0x60b71800, 0xdf5aa400, 0xe1788200, 0x8ce4c300, 0xabb82380, 0xa6cd50c0, 0x18379920, 0x2c926590, 0x0dcea0d8, 0x91a49364, 0x7dd938da, 0xf9a6f41b, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x74000000, 0xee000000, 0xc9000000, 0x8a800000, 0x27400000, 0xff600000, 0x8c900000, 0xda480000, 0xfbec0000, 0x32da0000, 0xc7a50000, 0x24328000, 0xf9efc000, 0x79c02000, 0x4631d000, 0xe2e22800, 0x90574c00, 0xf4fa8200, 0x6543c100, 0xd47a2180, 0x5d04d140, 0x7498a9a0, 0xe6548dd0, 0x51e0a1b8, 0x2dd71224, 0x982a8baa, 0x13fc5ddd, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xe8000000, 0xe4000000, 0x1a000000, 0x11000000, 0x53800000, 0xb8c00000, 0x80e00000, 0xd1900000, 0xc5d80000, 0xbd740000, 0xba560000, 0x0ba50000, 0x79b88000, 0x4cad4000, 0xa5232000, 0x3cecf000, 0x07935800, 0x8ad9bc00, 0xd5e08200, 0xa8194300, 0x84152280, 0x8a19f0c0, 0xc913dba0, 0x5f90ff90, 0x46cda268, 0x8be4b344, 0x9308fbce, 0x2e980e23, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xe8000000, 0x54000000, 0xbe000000, 0x1b000000, 0x7f800000, 0xa9c00000, 0xbf600000, 0x3d900000, 0xf8d80000, 0x55ec0000, 0x48da0000, 0x2de50000, 0x94d68000, 0x97e5c000, 0xd9c26000, 0xa7777000, 0xb183f800, 0xaacc0c00, 0x4cee8200, 0xc659c300, 0x5ea06180, 0xe6ee7140, 0xc3577ba0, 0x0a20cd50, 0x88a060f8, 0x69ee736c, 0x62d7787e, 0xe8e0cfe7, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x48000000, 0x14000000, 0x2a000000, 0x47000000, 0x1e800000, 0xf0400000, 0x96200000, 0x08900000, 0xb9580000, 0x4dbc0000, 0x454e0000, 0xa3b10000, 0x704e8000, 0x56234000, 0xe88de000, 0x49475000, 0x05ae4800, 0x5156a400, 0x89b68200, 0x374f4300, 0x48bbe380, 0x18da53c0, 0xdf76c920, 0x0d38e450, 0xe81be2a8, 0xc40a521c, 0x720ecbfa, 0xeb14e401, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x78000000, 0xe4000000, 0x42000000, 0x5d000000, 0xe5800000, 0xd8c00000, 0x1be00000, 0x0b900000, 0xebd80000, 0x0d740000, 0x65ca0000, 0x4e770000, 0xdb588000, 0xbc2a4000, 0xd8e0a000, 0x75123000, 0xb9905800, 0xdeda5c00, 0xd4e08200, 0xcb0e4300, 0x3292a280, 0x8c413340, 0x28bad9e0, 0x4ba31f90, 0xe52aa308, 0xcf653274, 0xf8c8d916, 0x0bf01c23, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x88000000, 0xac000000, 0xfe000000, 0xbf000000, 0x21800000, 0x2c400000, 0x86200000, 0x5e900000, 0x6dc80000, 0x7a640000, 0xa0ae0000, 0x17490000, 0x45b98000, 0x9bd5c000, 0x2970e000, 0x5f34b000, 0x7409c800, 0x6a05e400, 0x45178200, 0x3c9cc100, 0xc4c96080, 0x98e173c0, 0x2b792a20, 0x263156b0, 0xee9e49f8, 0xc5d927fc, 0x267ee206, 0xd6adb271, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xb8000000, 0x1c000000, 0x2a000000, 0xc7000000, 0x25800000, 0x49400000, 0xc9600000, 0xf2900000, 0x44c80000, 0xf4240000, 0x45ee0000, 0xff4f0000, 0x646f8000, 0x300f4000, 0xd819e000, 0xcc143000, 0x6211e800, 0x63138c00, 0x13818200, 0xa4404100, 0x2bf66080, 0x9e5b73c0, 0xc4e80ae0, 0xcfd7bc70, 0xf3b86aa8, 0x4fa7ce1c, 0xd5b1e216, 0x8aa033e5, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x78000000, 0x9c000000, 0x2a000000, 0x95000000, 0x20800000, 0xb9400000, 0x27e00000, 0xb9900000, 0xebd80000, 0xa7bc0000, 0x3cea0000, 0x9a070000, 0xfd178000, 0x24834000, 0xdf47a000, 0xe0f89000, 0x9011e800, 0x580b1c00, 0xac1d8200, 0x82144300, 0x71082380, 0x9687d340, 0x065c49e0, 0x92648e70, 0x2043eaa8, 0x75601d54, 0x39d80102, 0x6ebc02a5, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xb8000000, 0x34000000, 0xca000000, 0x59000000, 0x8a800000, 0x81c00000, 0x58e00000, 0x37900000, 0x09580000, 0xec3c0000, 0xabe60000, 0x941f0000, 0x5a028000, 0xb1134000, 0xb68a2000, 0xc7c0d000, 0xffeff800, 0x2e097c00, 0x5b048200, 0xbf9c4300, 0x4550a380, 0xf22f92c0, 0x88e3dae0, 0xff86acd0, 0x6551f928, 0xa22a7e64, 0x80e003aa, 0x739003c7, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x98000000, 0x6c000000, 0xaa000000, 0xcb000000, 0xdc800000, 0x18400000, 0xece00000, 0x93900000, 0x5ad80000, 0x19bc0000, 0x32ee0000, 0x5e9b0000, 0x07498000, 0xe6774000, 0x82c46000, 0x55bd1000, 0x88f7c800, 0xfd87bc00, 0x2fc78200, 0x383c4300, 0x0f35e380, 0xd1a653c0, 0x16e5aa60, 0x108dadb0, 0x624fc8a8, 0xafebbc2c, 0x4b1182f2, 0x1c8b40a1, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xe8000000, 0x64000000, 0x2a000000, 0x9b000000, 0x05800000, 0x2fc00000, 0x18a00000, 0xd4900000, 0x61580000, 0xcae40000, 0x5ff60000, 0x0b750000, 0xaa208000, 0x40cf4000, 0x2f346000, 0xcc433000, 0x026f3800, 0x68b0b400, 0xdc8e8200, 0x155e4300, 0x38e2e080, 0x48f970c0, 0x40fbdba0, 0x34fcc590, 0xc6f5daa8, 0xd1fdc56c, 0x9a7b5a96, 0x04a3877f, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xd8000000, 0x2c000000, 0xa2000000, 0x65000000, 0xe4800000, 0xa8c00000, 0xd2e00000, 0x2b900000, 0x9d480000, 0xf0bc0000, 0xc6ba0000, 0x3da30000, 0x26218000, 0x737a4000, 0x97d9a000, 0x8f7c1000, 0xadd9d800, 0x267e3c00, 0xbb538200, 0x33a54100, 0xa1222380, 0x12f55140, 0x8b89fb60, 0x2d546cb0, 0x78a1f888, 0x32b86c94, 0xb3b3fa12, 0xe1376ee3, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xc8000000, 0x14000000, 0x82000000, 0xc1000000, 0x14800000, 0x8dc00000, 0x61a00000, 0xe3900000, 0x4a580000, 0xd1e40000, 0x5f7a0000, 0x0fb10000, 0xcc8e8000, 0xb1c64000, 0x87af2000, 0x38831000, 0x43c27800, 0xdea2d400, 0xf00c8200, 0x58034300, 0xfc03a080, 0xc6105140, 0x8b19db20, 0xc1968450, 0x1b4f5808, 0x2d74c404, 0x96ba7ad2, 0x2416d477, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0x3c000000, 0xe2000000, 0x4d000000, 0xcd800000, 0xadc00000, 0x8ae00000, 0x66900000, 0x43580000, 0x6da40000, 0xf53a0000, 0x49630000, 0xfc4b8000, 0x552a4000, 0xd97ca000, 0x84573000, 0x39397800, 0x637d3c00, 0xf5498200, 0x16bd4300, 0x83b52080, 0xb22a7140, 0xddec5960, 0x4a074cf0, 0xb91dd988, 0x6b8e0e34, 0x6ecaf9b6, 0xb0637cf7, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0xd4000000, 0xee000000, 0xab000000, 0x1b800000, 0x4a400000, 0x3fa00000, 0xca500000, 0x7fa80000, 0xaa5c0000, 0xefba0000, 0xf2570000, 0x3ba08000, 0x1c4ac000, 0x90b5e000, 0x07c9b000, 0xdafca800, 0x386e4400, 0x10b5e200, 0x47c9b100, 0xbafca980, 0xa86e4640, 0x48b5e360, 0x93c9b250, 0x54fcaa38, 0x036e44ec, 0x5335e30e, 0xd989b379, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x9c000000, 0xe2000000, 0x8b000000, 0x52800000, 0x56c00000, 0x4a600000, 0xb6d00000, 0x3a680000, 0xded40000, 0xee6a0000, 0xf8df0000, 0x1b798000, 0xc3434000, 0x9428e000, 0x8d691000, 0x3e523800, 0x4bb85c00, 0x6c28e200, 0x41691100, 0xa4523880, 0x4cb85c40, 0x84a8e360, 0x00a91370, 0x5eb23b08, 0x27a85e6c, 0xa620e22a, 0x3e6d122b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x48000000, 0x44000000, 0xca000000, 0x0d000000, 0x28800000, 0x51400000, 0xd8a00000, 0x59500000, 0xbcb80000, 0xc34c0000, 0x49ae0000, 0xe7c50000, 0x96e68000, 0xf87c4000, 0xea372000, 0x3d015000, 0xa0910800, 0xf5444400, 0xa2b72200, 0x1c415300, 0xd0310b80, 0x581446c0, 0x9c0f2320, 0x960d5210, 0x7b1f08a8, 0xe39146f4, 0xfac9a382, 0x66611355, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xa8000000, 0xac000000, 0xe6000000, 0x09000000, 0x38800000, 0xe2c00000, 0x50a00000, 0xead00000, 0x2cb80000, 0x84d40000, 0x99ba0000, 0xf2410000, 0xde6f8000, 0x7c7dc000, 0xdf7ea000, 0x38e2d000, 0x53a6f800, 0xdd4ac400, 0xcffea200, 0xb622d300, 0xc506f880, 0x2e9ac440, 0x73c6a0a0, 0x7c36d1b0, 0xea1cfb18, 0x3f0bc464, 0xb9912042, 0x665f123b, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x48000000, 0x64000000, 0xea000000, 0xc5000000, 0x4f800000, 0x75c00000, 0x3b600000, 0xa1d00000, 0xd9680000, 0xe0cc0000, 0x4cee0000, 0x18050000, 0x5c028000, 0x26084000, 0x7b122000, 0x289db000, 0x9b5a9800, 0xeb33dc00, 0x2a722200, 0x0c4db100, 0xedb29b80, 0x4e3fdcc0, 0x15fc2320, 0xd198b090, 0x82d81828, 0x4dfb9fd4, 0x6d80021e, 0x94c00147, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x58000000, 0x54000000, 0x72000000, 0xcf000000, 0xf2800000, 0x99400000, 0xcfa00000, 0xfb500000, 0x98b80000, 0x7dd40000, 0xe3ea0000, 0x257f0000, 0xbe308000, 0x56894000, 0xc35d6000, 0xbcad1000, 0xe7c94800, 0xb0f06400, 0xa9e56200, 0xce791300, 0xd6a34880, 0x9ccf6640, 0x8075e360, 0x37a05250, 0xff462948, 0x92b6757c, 0x76d6a8aa, 0x3b6f3435, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xd8000000, 0xdc000000, 0x62000000, 0xdf000000, 0x2c800000, 0x15400000, 0xbe600000, 0x2b500000, 0x43680000, 0x38cc0000, 0x0aa60000, 0x4bf70000, 0x438d8000, 0x41c34000, 0xe7326000, 0x5f2cd000, 0xb321c800, 0xe9219c00, 0x9a3a6200, 0x0cb0d100, 0x1aefcb80, 0xea1a9dc0, 0x0b11e160, 0xda849270, 0xdc502a08, 0x2bf50ebc, 0x738249d2, 0x79c9de25, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0xa4000000, 0x5a000000, 0x33000000, 0xdf800000, 0x4ac00000, 0xa9600000, 0xa4d00000, 0x28680000, 0xd4440000, 0x732e0000, 0xc6f70000, 0x360a8000, 0x85044000, 0x1a80e000, 0xf045b000, 0x6928b800, 0x55e11c00, 0xd988e200, 0x57d1b100, 0x17eeba80, 0x0e921cc0, 0x724c6060, 0x5e32f390, 0xe06cdbe8, 0x3847ec0c, 0x85223b1e, 0xa3e55ebb, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x08000000, 0x84000000, 0xea000000, 0x8f000000, 0x9c800000, 0x2ec00000, 0x86200000, 0x18d00000, 0xaf380000, 0x45540000, 0xa8620000, 0xf6350000, 0x00c28000, 0x03204000, 0xfb4f6000, 0xc56dd000, 0x61b1b800, 0x589c9400, 0x24d76200, 0xf929d300, 0x5c4bb880, 0x0ded9740, 0xad6fe220, 0xd5b89110, 0x4a9c5b28, 0xf7c1057c, 0x03b1b852, 0x939c95ab, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x28000000, 0x2c000000, 0x82000000, 0x61000000, 0xbc800000, 0x5e400000, 0xbba00000, 0x88500000, 0x8ca80000, 0x43cc0000, 0xf9660000, 0xfda90000, 0xe7538000, 0x43214000, 0x980ba000, 0xa404d000, 0x3e1b6800, 0xbb1b2400, 0xd983a200, 0x4cd8d100, 0x06f56b80, 0xee6e25c0, 0xe63e22a0, 0x2a8c91b0, 0x89434988, 0x003eb444, 0xd5936852, 0x1ec724c9, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xa8000000, 0x8c000000, 0xbe000000, 0x41000000, 0x31800000, 0x05c00000, 0x9ae00000, 0xe4d00000, 0x7b780000, 0x69140000, 0x7d9a0000, 0x9bd10000, 0xcbf38000, 0x7d52c000, 0xf2a1a000, 0x4de5f000, 0xd8429800, 0xd13c6c00, 0xa73ba200, 0x9a34f300, 0x8db11880, 0xfd6eac40, 0xcc1a00a0, 0x5e110130, 0x71138278, 0x8982c144, 0x21d9a266, 0xa8f1f227, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x18000000, 0x94000000, 0xbe000000, 0xa7000000, 0x39800000, 0x6a400000, 0x6c600000, 0x55500000, 0x81e80000, 0x21040000, 0xda9a0000, 0x55d70000, 0xa5208000, 0xa6a4c000, 0x8dfe6000, 0x4b1cf000, 0x6397a800, 0x5b4fbc00, 0xeee46200, 0x348bf100, 0x0ad72a80, 0x38bb7e40, 0xfaf20260, 0xca930350, 0x0dda8078, 0x9123c0dc, 0x88b6e086, 0x32fc33f9, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x08000000, 0x94000000, 0x36000000, 0xbd000000, 0x28800000, 0xa9c00000, 0x60a00000, 0x2cd00000, 0xc4380000, 0x4f1c0000, 0x6b820000, 0xc84d0000, 0x07e88000, 0x50b7c000, 0x34cd2000, 0x3837d000, 0x3d049800, 0xe88a0400, 0xc9cf2200, 0xb0bad300, 0x24cc1980, 0x502dc740, 0x791a0220, 0xd6810150, 0xe0d28158, 0xae26c1b4, 0x3007a082, 0x181d10f7, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x08000000, 0xf4000000, 0xc6000000, 0xe9000000, 0xd6800000, 0xf2400000, 0x06200000, 0x4f500000, 0x86a80000, 0x8c1c0000, 0x1a1e0000, 0x0b0d0000, 0x41888000, 0x31d9c000, 0x10e3a000, 0x94321000, 0xf05b6800, 0x613e1400, 0xe4dda200, 0xd46f1100, 0x997be980, 0x71fbd6c0, 0xf6a00220, 0xa41002d0, 0x3e080298, 0x750c0164, 0x5496037a, 0xd5410019, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xc8000000, 0xfc000000, 0xc6000000, 0xa5000000, 0x7a800000, 0xc6400000, 0x8ee00000, 0x2f500000, 0x9a680000, 0xe0140000, 0x10060000, 0x981d0000, 0x44118000, 0xf201c000, 0x9f0b2000, 0x19979000, 0x19cc6800, 0x323e8c00, 0x67ed2200, 0x3bda9100, 0x5535e880, 0x6a6b4dc0, 0x68000120, 0xcc0002f0, 0x2e000398, 0x29000354, 0x748002ca, 0x9f4000e9, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x58000000, 0xac000000, 0x6e000000, 0x41000000, 0x23800000, 0x46c00000, 0x22200000, 0x33d00000, 0x23a80000, 0x4a040000, 0x8b1e0000, 0xe89f0000, 0x0e438000, 0x9c66c000, 0xf7ada000, 0x7811b000, 0x5c1cf800, 0x96023400, 0x5d13a200, 0x159eb100, 0xabd77a80, 0x6fb0f6c0, 0x34080360, 0x221403b0, 0x3f160338, 0x8a8b03c4, 0x915581ee, 0xa6edc3ab, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x48000000, 0x0c000000, 0xca000000, 0xfb000000, 0xb1800000, 0x5ec00000, 0xc9600000, 0xc1d00000, 0xaee80000, 0x46040000, 0x71020000, 0xea9d0000, 0xbf4b8000, 0xdfb04000, 0x04aee000, 0xa5377000, 0x13f8b800, 0x86891c00, 0xc54ce200, 0x9cba7100, 0xa13b3a80, 0x75ed5d40, 0xe7880320, 0xc7d40130, 0x7fea01a8, 0xfc9902ac, 0x864983e6, 0x392d414b, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xa8000000, 0xfc000000, 0xaa000000, 0x63000000, 0x18800000, 0xbb400000, 0xa6e00000, 0x7a500000, 0x91680000, 0xfb940000, 0xe3d60000, 0x3db10000, 0x2cb18000, 0x43384000, 0x96efe000, 0xb2545000, 0xbd7c0800, 0x09974c00, 0xd4d1e200, 0x73315100, 0x5efb8880, 0x9e4e0fc0, 0x4f6780a0, 0x3e8942f0, 0x9a5e6228, 0x016c124c, 0x8393eac2, 0x47c31d1d, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xd8000000, 0x24000000, 0xf2000000, 0x2b000000, 0x7f800000, 0xb2c00000, 0x24200000, 0x03d00000, 0xbca80000, 0xb0840000, 0xdf520000, 0xcdef0000, 0x506e8000, 0xf1bd4000, 0xfe0de000, 0xb517b000, 0xfa863800, 0xe04ef400, 0xe877e200, 0xe5bcb100, 0xa41aba80, 0xb20cb740, 0x8b1c8160, 0xaf824190, 0x6acb6148, 0x002ef3ec, 0xf1d9da9e, 0x97b6465b, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xd8000000, 0x4c000000, 0x22000000, 0xdf000000, 0x26800000, 0x8ec00000, 0xb0e00000, 0xefd00000, 0x73780000, 0xf4940000, 0x19d20000, 0x227f0000, 0x5f138000, 0xe6874000, 0xaed66000, 0xe0ea9000, 0x37c13800, 0x3f634c00, 0xd69c6200, 0xc6d19300, 0x04f8b880, 0xd1cf0d40, 0x566b8160, 0x41134230, 0x93846008, 0xc355923c, 0x26b2bbfa, 0xf4f40f0b, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x68000000, 0xec000000, 0xfa000000, 0xfb000000, 0x61800000, 0x89c00000, 0xd9200000, 0x34d00000, 0x01a80000, 0x33840000, 0x7ece0000, 0xd2b90000, 0x1e0b8000, 0x3d1a4000, 0x9896e000, 0xa7557000, 0x4f635800, 0x893a9400, 0x8cd0e200, 0x15b87100, 0x7d8eda80, 0xfbddd4c0, 0x5e2383a0, 0xf75e42b0, 0xf778e168, 0x9d3c732c, 0xc2c0d826, 0x90a4d597, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x68000000, 0x6c000000, 0x62000000, 0x69000000, 0xc2800000, 0xf2c00000, 0x5e600000, 0x7dd00000, 0x3bf80000, 0x269c0000, 0xccc60000, 0x5d610000, 0x4a438000, 0x01b94000, 0x8f3ca000, 0x4fe21000, 0x809a7800, 0xcbd41c00, 0x64e2a200, 0x7b0f1300, 0x0387f980, 0x3c405fc0, 0x3ea383a0, 0x22a942b0, 0xe8a4a008, 0x8dae1264, 0xdd247aaa, 0x2ee91e7b, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xb8000000, 0xac000000, 0x46000000, 0x6b000000, 0xdf800000, 0xbec00000, 0x1fa00000, 0x37d00000, 0x99380000, 0x87840000, 0x82c60000, 0xb1a30000, 0xb8db8000, 0x14a7c000, 0xb85ce000, 0x6ff53000, 0x8c29b800, 0x5f1b8400, 0x0582e200, 0x8bc23300, 0xf72c3a80, 0xa88b47c0, 0xff5b80e0, 0x3667c1b0, 0xf9fce398, 0x6f25326c, 0x3491b99e, 0xa15f844b, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xa8000000, 0x0c000000, 0x22000000, 0x27000000, 0xf8800000, 0x65c00000, 0x4c600000, 0xdd500000, 0x49b80000, 0x81240000, 0x8cfe0000, 0x6c890000, 0x23db8000, 0xe5734000, 0x90d66000, 0x5bf7d000, 0x5c099800, 0x5a183c00, 0x930de200, 0xce849300, 0xc4dffa80, 0xbdefeec0, 0x450478a0, 0xbf9caf30, 0x8d521808, 0x31ab7d5c, 0x353b81c2, 0xbae34067, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x78000000, 0x7c000000, 0xe2000000, 0x11000000, 0x0b800000, 0x7ec00000, 0xf9600000, 0x25500000, 0xbfa80000, 0x402c0000, 0xa8e20000, 0x968b0000, 0x9f418000, 0xa2b54000, 0xe1a8a000, 0x1325b000, 0x827a3800, 0x4bde3c00, 0x1ce92200, 0xe090f100, 0x88529b80, 0xf63b8f40, 0x1ff31be0, 0xf21eccf0, 0xc913ba08, 0x47877e04, 0x34c3804e, 0xec6e424b, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x18000000, 0x3c000000, 0x3e000000, 0x99000000, 0xd3800000, 0x13c00000, 0x3ee00000, 0x58500000, 0x51280000, 0xb8ac0000, 0x60660000, 0x22070000, 0xf70d8000, 0x4286c000, 0x1449a000, 0x37393000, 0xfda11800, 0x7df14c00, 0xb0c42200, 0x267ff100, 0x3708bb80, 0xe2987fc0, 0x044d3a60, 0xdf22bdf0, 0xd9aa9978, 0x7fe08ca4, 0x17c802ae, 0x6cfc027f, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x98000000, 0x64000000, 0x2e000000, 0xab000000, 0xfc800000, 0xe6c00000, 0xf8a00000, 0x26500000, 0xf4680000, 0x2bec0000, 0x8daa0000, 0x39d70000, 0xf22a8000, 0xef88c000, 0x4e50e000, 0xd879d000, 0x19e2f800, 0xfcbb2400, 0xd85a6200, 0x27611100, 0x237a1b80, 0xdd7ef640, 0x0e7a9860, 0x06e13490, 0x5620f938, 0x618025ec, 0x955ae012, 0x2cfed14b, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xa8000000, 0x6c000000, 0xf2000000, 0xdf000000, 0x42800000, 0x15c00000, 0x57200000, 0x63500000, 0x04e80000, 0xed640000, 0x5c2a0000, 0x57d90000, 0xf0238000, 0x45dd4000, 0x1f396000, 0x3f4a9000, 0xcef09800, 0xf6761400, 0x80bae200, 0x6f07d100, 0x3a81fa80, 0x71c88640, 0x592878a0, 0xe65cc4b0, 0xf57a9b48, 0x483f143c, 0xc1d1632a, 0x212e92a7, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x48000000, 0x4c000000, 0xd6000000, 0x63000000, 0x9f800000, 0xbf400000, 0xb6a00000, 0x76d00000, 0x2ae80000, 0xffe40000, 0xb3720000, 0x2ba50000, 0x764f8000, 0x6425c000, 0xc102e000, 0x3e8bb000, 0x31d5c800, 0x3f700400, 0x1da56200, 0xe54a7100, 0xe3a52a80, 0x7a5eb540, 0x123f2b20, 0xf21fb430, 0xe902abd8, 0xc29f75cc, 0x5fcfcbde, 0x0871078d, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0x64000000, 0x06000000, 0x65000000, 0x55800000, 0xb6400000, 0x17600000, 0x15d00000, 0x7c280000, 0x633c0000, 0x71be0000, 0x91670000, 0x30de8000, 0x49b1c000, 0xe5692000, 0xfecbf000, 0xe0a12800, 0x4af2bc00, 0x4f9fa200, 0xc1463100, 0xd9f60980, 0xc71e4cc0, 0x16800860, 0xd6d54c90, 0x5ca88b98, 0x48ef8c54, 0x1c8928b6, 0x69cebe89, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x5c000000, 0xaa000000, 0x5d000000, 0x91800000, 0x34400000, 0x04a00000, 0xf7d00000, 0x19e80000, 0xf4fc0000, 0x3d7a0000, 0x4d390000, 0xc79d8000, 0xf35e4000, 0xd0232000, 0x7613f000, 0xb716e800, 0xac8bc400, 0xb5d6a200, 0x58f1b100, 0xaf6fc980, 0x44313440, 0xb015cba0, 0x58083470, 0x44084928, 0x8e167434, 0xc30b6866, 0x3a9584e1, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xc8000000, 0x64000000, 0x9a000000, 0xfd000000, 0xa6800000, 0xecc00000, 0x86200000, 0x08500000, 0xabe80000, 0xcef40000, 0x74660000, 0x8ea50000, 0xfb8e8000, 0xfa584000, 0x82f02000, 0x1a7c1000, 0xf1bcf800, 0xfc187400, 0x8616a200, 0xeb105100, 0x558ad880, 0xe55167c0, 0x556cd920, 0x5e346490, 0x344258e8, 0x4dfc2534, 0xf5fa7b3a, 0x19e434e3, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0x74000000, 0x6e000000, 0x2f000000, 0x7f800000, 0x4c400000, 0xfea00000, 0xc9d00000, 0x23e80000, 0x8ffc0000, 0x3dea0000, 0xf8e50000, 0xde688000, 0x3ebac000, 0xe9dc6000, 0xd3ebb000, 0x97f02800, 0xc1ed8400, 0xe2fce200, 0x9f7d7100, 0x6e2e4980, 0xda1f3640, 0x610e4820, 0xa08f34d0, 0x2bc64a38, 0x4ee337fc, 0x2d64485e, 0xab2a37a1, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xe8000000, 0xfc000000, 0x12000000, 0x67000000, 0xf4800000, 0xeac00000, 0xbe600000, 0x40500000, 0xf9b80000, 0x89bc0000, 0x31ba0000, 0x45b90000, 0x3ba98000, 0xa6a94000, 0xc9386000, 0xc5685000, 0xf6c77800, 0xfc637c00, 0xaf49e200, 0x612d1300, 0x997d1980, 0x14ce2e40, 0xe37d19a0, 0x4fce2cf0, 0x65fd1bc8, 0x520e2cdc, 0xc71d1bf2, 0x049e2d1b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x38000000, 0x7c000000, 0xb2000000, 0xaf000000, 0xb8800000, 0x54c00000, 0x4a600000, 0x8a500000, 0x77b80000, 0xc1ac0000, 0x80b60000, 0x35330000, 0xbe658000, 0x5c5b4000, 0x06a76000, 0xac3bd000, 0x87f7b800, 0x5d017c00, 0x379ae200, 0xfc5c9300, 0xd6bedb80, 0x8435afc0, 0x33e6dae0, 0xab09aef0, 0x5688db48, 0x59c6ae7c, 0x95e35b82, 0x2202ec63, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xc8000000, 0x14000000, 0x8e000000, 0xcf000000, 0x7d800000, 0x5bc00000, 0x53200000, 0x49500000, 0x85780000, 0xb9ac0000, 0x93120000, 0x279d0000, 0xfac48000, 0x31b2c000, 0xa7126000, 0x9984f000, 0x2ddf5800, 0x90263400, 0x66c4e200, 0x8bab3300, 0xd609bb80, 0x33100740, 0xd789d920, 0x02c9f750, 0x3db203b8, 0xf50d037c, 0xcc9c8156, 0x114ec27f, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xa8000000, 0x64000000, 0x96000000, 0x23000000, 0x0f800000, 0x50400000, 0xc8600000, 0x0cd00000, 0x9fb80000, 0xa0fc0000, 0x550e0000, 0xdc810000, 0x97c68000, 0xcc21c000, 0xfaade000, 0xd477b000, 0xa6d8a800, 0x86ae9c00, 0x4e656200, 0x17d77300, 0x0c33c980, 0x9ab8ecc0, 0xe47028a0, 0x0ede5e90, 0xe2b601d8, 0xd87d034c, 0x34c8831e, 0x03a0c011, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x58000000, 0x04000000, 0x82000000, 0x05000000, 0x05800000, 0x52400000, 0x42e00000, 0xcad00000, 0x71280000, 0xe8740000, 0x340a0000, 0x0a070000, 0x79168000, 0x13894000, 0x8d4b2000, 0x46707000, 0x1f0aa800, 0x64804c00, 0x65d7a200, 0xddbe3100, 0xd1b70880, 0x6fa97e40, 0x5cbe2b60, 0x163a0d10, 0x18e00088, 0x8bd00354, 0xd6a801f6, 0x2f340319, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0x34000000, 0x22000000, 0x2b000000, 0xbd800000, 0x79400000, 0x2fe00000, 0x57d00000, 0xaf280000, 0x1b640000, 0xf81e0000, 0xe40f0000, 0x2a148000, 0xb7114000, 0x3390e000, 0x44557000, 0x9b6e0800, 0xb8072c00, 0x441a6200, 0x1a0b3100, 0x2f0a6a80, 0x07931cc0, 0x664c8860, 0xb07d6dd0, 0x05800008, 0x3d40016c, 0x35e00216, 0x78d001f5, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x68000000, 0x24000000, 0xaa000000, 0x93000000, 0xf4800000, 0xc4c00000, 0x8da00000, 0xb7500000, 0xcff80000, 0x51240000, 0x37920000, 0x98410000, 0xcd6a8000, 0x40f24000, 0x83b3e000, 0x4e535000, 0x0869b800, 0xb16e4400, 0x16eb6200, 0x86b01300, 0x1fc8da80, 0x4d2b5740, 0x11833ba0, 0x255c0790, 0xd0f88228, 0x8bb3420c, 0x1a5960f2, 0x1a6110c3, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x28000000, 0xcc000000, 0x4a000000, 0x81000000, 0x61800000, 0x4a400000, 0xdee00000, 0x2ed00000, 0x83380000, 0x69740000, 0x678a0000, 0x41590000, 0x1e7f8000, 0x151e4000, 0x3f94a000, 0x5558f000, 0x80722800, 0x2a12cc00, 0x71012200, 0x798fb300, 0xbe410880, 0x70f07c40, 0x29d5aaa0, 0x29a88c30, 0xc3a783a8, 0x92ba4144, 0xfb26a1a6, 0x6d75f259, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x98000000, 0xe4000000, 0x76000000, 0xb5000000, 0xe3800000, 0xae400000, 0xfe200000, 0x94d00000, 0x09e80000, 0x1bbc0000, 0x57860000, 0x90570000, 0xa72e8000, 0x8d53c000, 0x18b12000, 0x21123000, 0x4d9ba800, 0x9f4a1400, 0x9bb9a200, 0x1786f100, 0xf04c0980, 0x5727e7c0, 0x155d2860, 0xfca5d690, 0x570e8258, 0xf883c014, 0x7cd9206e, 0x35ee32e9, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xd8000000, 0x24000000, 0x82000000, 0x91000000, 0xa2800000, 0x2f400000, 0x19200000, 0x0ed00000, 0x1df80000, 0x5e2c0000, 0xb74a0000, 0x1d3f0000, 0x7cca8000, 0x44f14000, 0x00a1a000, 0x3e0a9000, 0x17188800, 0x419fd400, 0xd4d92200, 0x68e8d300, 0x9eb9ab80, 0x191b0440, 0x7e8a8960, 0x795cd790, 0xc221a388, 0xc14a9104, 0x36388a6a, 0x7b4fd46d, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xf8000000, 0x5c000000, 0x26000000, 0x05000000, 0xf2800000, 0x91400000, 0x43600000, 0x08d00000, 0x61b80000, 0x82740000, 0x90560000, 0xfbe30000, 0x62818000, 0x795dc000, 0x37702000, 0x7adf1000, 0xe6b14800, 0x0fe91c00, 0xd09fa200, 0xde55d300, 0x4af6e880, 0xc218cfc0, 0x9f0749e0, 0x019a1e70, 0x6ec62218, 0x84ac10d4, 0xa0e8c8aa, 0x0910dcf5, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x58000000, 0x3c000000, 0x82000000, 0x53000000, 0x5c800000, 0xd3c00000, 0x67e00000, 0xb6500000, 0x4fa80000, 0x58ec0000, 0x70c20000, 0x137f0000, 0x31918000, 0x1e494000, 0x5bbae000, 0x8ef65000, 0x15d35800, 0xfafe8c00, 0x53c16200, 0x27ec1100, 0x565a3b80, 0x9fae9f40, 0x00f15b60, 0x4cd18df0, 0x9178e388, 0x6289530c, 0x42c2db92, 0x8877ccff, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x38000000, 0xdc000000, 0x92000000, 0x0f000000, 0x97800000, 0x7fc00000, 0xee200000, 0x49500000, 0x8b780000, 0xa8240000, 0x50460000, 0x8deb0000, 0x95718000, 0xbd334000, 0x8cc16000, 0x5bb93000, 0xa1915800, 0x5ec45400, 0x34aee200, 0xe6157300, 0x691fba80, 0x3e8125c0, 0xe1495ae0, 0x7f705470, 0x0e30e2c8, 0x594a72fc, 0x6370383e, 0x3c2d674f, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x38000000, 0x54000000, 0x5a000000, 0x0f000000, 0xc6800000, 0x60400000, 0x4aa00000, 0x17d00000, 0xd1780000, 0x38a40000, 0xb4da0000, 0xb9eb0000, 0x9dfc8000, 0x0ff64000, 0x5cf06000, 0x3c771000, 0x652fa800, 0xe813e400, 0x0c0ee200, 0x3e1e5300, 0xfd014a80, 0xa59db640, 0xa8d7aae0, 0x7ff7e650, 0x94f4e1e8, 0x6065517c, 0xc325c97a, 0xd11ff691, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xb8000000, 0x34000000, 0x92000000, 0xdd000000, 0xff800000, 0xdcc00000, 0x9e200000, 0xee300000, 0x76280000, 0x92340000, 0x88320000, 0xd9250000, 0x80a38000, 0x1371c000, 0xafca6000, 0x62a59000, 0x56760800, 0xb441cc00, 0xa4760a00, 0x9941cf00, 0x03f60980, 0x4181cfc0, 0xb7d60b60, 0x46b1cf10, 0xac7e0928, 0xd545cc64, 0x45ec0ad6, 0x3e90cf17, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x08000000, 0xcc000000, 0x92000000, 0xb9000000, 0x10800000, 0xf3c00000, 0xb4200000, 0xe4300000, 0x1c380000, 0xb8340000, 0x56220000, 0x75230000, 0x10ba8000, 0x61e8c000, 0x9f1fe000, 0xdf8df000, 0xd45b8800, 0xc4610c00, 0xce5b8a00, 0xf1610d00, 0x2cdb8b80, 0x0ba10fc0, 0x807b8ba0, 0xd0510cf0, 0xba6389e8, 0x35550e14, 0xe0f989aa, 0x0b820ddb, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x98000000, 0xec000000, 0x2a000000, 0x27000000, 0xa9800000, 0x09400000, 0x11e00000, 0x99f00000, 0x2de80000, 0x8be40000, 0x16f60000, 0x00650000, 0x4cb88000, 0x7e1dc000, 0xd1092000, 0xcc841000, 0x63c93800, 0xef390400, 0x60493a00, 0x01790700, 0xb8293b80, 0x01c90540, 0x1c2139e0, 0xffdd06f0, 0x0d3f3948, 0x535c066c, 0xfef1bbee, 0x2464c649, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xf8000000, 0x84000000, 0x26000000, 0xa7000000, 0x3a800000, 0x9ec00000, 0x4fe00000, 0x87f00000, 0x4bf80000, 0xe1e40000, 0x0ce60000, 0xcb790000, 0x6a298000, 0x008d4000, 0xcbc9a000, 0xec66f000, 0x10b92800, 0x7e5ad400, 0x94392a00, 0x939ad500, 0xdf592980, 0xb9aad540, 0x3fc12a60, 0x627ed750, 0x2bbf2af8, 0xf6d3d5cc, 0x73e8aa12, 0xc5f397b7, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0x34000000, 0x76000000, 0x53000000, 0xb1800000, 0x57400000, 0xf5e00000, 0x4bf00000, 0x7cf80000, 0x837c0000, 0xab3a0000, 0x855f0000, 0x88e98000, 0x957f4000, 0xe8392000, 0x2ccd1000, 0xc3b4f800, 0x2291c400, 0x86ccfa00, 0xb2adc500, 0xa616fa80, 0x2b02c5c0, 0xbd877a20, 0x0d418510, 0xcce45bf8, 0xeb63945c, 0xbf21213e, 0xc3411101, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x98000000, 0x0c000000, 0x6a000000, 0x85000000, 0x30800000, 0xd7c00000, 0x7ae00000, 0x9cf00000, 0x33f80000, 0xa67c0000, 0x11360000, 0x24050000, 0xce148000, 0x0b11c000, 0x1b856000, 0x9c497000, 0x7ea08800, 0xee5e5400, 0xb7b88a00, 0x94d25500, 0xb5768a80, 0x46ab5440, 0xf25408e0, 0x65bf9470, 0x4dc5e948, 0x77e72664, 0x1860018a, 0xd230013b, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x48000000, 0xa4000000, 0xb6000000, 0x69000000, 0x56800000, 0x18400000, 0x4e200000, 0xcc300000, 0xbb280000, 0xd0ac0000, 0xb0760000, 0x631f0000, 0xa59b8000, 0x15d54000, 0x0ffc6000, 0xeddcb000, 0xd3feb800, 0x47cffc00, 0x30f6ba00, 0x2253ff00, 0x0528ba80, 0xfda0fc40, 0xa0e53ba0, 0x8a5abed0, 0x512ad978, 0xd3bf4f74, 0x25fe0022, 0xcec30315, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x38000000, 0xc4000000, 0xe6000000, 0x85000000, 0x23800000, 0x39c00000, 0x84e00000, 0x5ef00000, 0x19f80000, 0xc96c0000, 0x5e2a0000, 0x3c8d0000, 0xfd458000, 0x5db14000, 0x7545e000, 0xe1bf9000, 0xf753a800, 0xb2b1b400, 0x69cbaa00, 0x6cedb500, 0x32f9a880, 0x33fcb5c0, 0x566e2860, 0xdaacf6d0, 0x45c44bf8, 0xe6ef24c4, 0x9df78376, 0x8f604023, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x88000000, 0xac000000, 0x5e000000, 0x2d000000, 0xf8800000, 0x88c00000, 0x5ea00000, 0x13b00000, 0xfb380000, 0x1be40000, 0xb94e0000, 0x7cef0000, 0x06c28000, 0xbbad4000, 0xa726e000, 0x7df6f000, 0xe0556800, 0xfe6bfc00, 0x511b6a00, 0x6e84fd00, 0xe9d9e980, 0xa829bc40, 0x3e7f0ba0, 0xf11f4ef0, 0xde8a62d8, 0x31c4b244, 0x8c290b3a, 0xcc644d67, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xa8000000, 0xf4000000, 0xf6000000, 0xbf000000, 0x7c800000, 0x07c00000, 0x4ee00000, 0x81f00000, 0x95680000, 0xc6bc0000, 0x8e420000, 0x18a70000, 0x05518000, 0x32334000, 0x4d86a000, 0xa85e3000, 0x3fa74800, 0x85c1d400, 0xc7e54a00, 0xe266d700, 0x1e34c880, 0x279594c0, 0xb5526a20, 0xfa3ba710, 0xe99d21f8, 0x064671ec, 0xdcba6a0a, 0xfb47a6f3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x88000000, 0x1c000000, 0x16000000, 0xb9000000, 0x3f800000, 0x2a400000, 0xf3e00000, 0x62f00000, 0xf1680000, 0x35340000, 0x7bc60000, 0xa4a70000, 0xcc8c8000, 0x9ada4000, 0x2f3b6000, 0x9cd39000, 0xde3e5800, 0x5f446400, 0x72785a00, 0x9da36700, 0x3314d980, 0x50892540, 0x4cc7bba0, 0x762eb530, 0x335fe3f8, 0x7c7dd3d4, 0xb0a33906, 0x0680f47d, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x58000000, 0x2c000000, 0x12000000, 0x31000000, 0x0e800000, 0x1f400000, 0x62e00000, 0x1bf00000, 0x81780000, 0xd02c0000, 0x19d60000, 0x49ad0000, 0xe7108000, 0x699ec000, 0x36dee000, 0xf43a3000, 0x3fdd5800, 0xe6a5c400, 0x1a8b5a00, 0x1148c500, 0x69fbd880, 0x80660640, 0xf6bd39e0, 0xa28036f0, 0x4d4e61a8, 0xf3e4f234, 0xc563bb92, 0xc62ff749, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xf8000000, 0xa4000000, 0x1a000000, 0xa7000000, 0x88800000, 0x6b400000, 0x07200000, 0x08300000, 0x6cb80000, 0x61fc0000, 0x8fc20000, 0x4a6d0000, 0xc6018000, 0x591ec000, 0x15982000, 0xb4cc3000, 0x1cf4d800, 0xc04cfc00, 0x79b6da00, 0xa261fd00, 0x0a175a80, 0xcf0f3ec0, 0x04977960, 0xdd4f0c50, 0xe639a108, 0x99a2f2cc, 0x3274f92a, 0x220cce61, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xd8000000, 0x1c000000, 0x46000000, 0xd1000000, 0x20800000, 0x42400000, 0xae200000, 0xfb300000, 0xe1a80000, 0xa4fc0000, 0x135a0000, 0x4eb10000, 0x197a8000, 0x7f9e4000, 0x87c66000, 0xeee77000, 0xac53b800, 0xdb233c00, 0x11a9ba00, 0xdce23f00, 0x3f5b3880, 0xd0b07fc0, 0xd46f5be0, 0x191a0fb0, 0x149c62f8, 0x605670f4, 0x1529387a, 0x94bd7efd, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xf8000000, 0x4c000000, 0x6a000000, 0x8f000000, 0x43800000, 0x02400000, 0x7fa00000, 0xf4b00000, 0x59280000, 0xfa6c0000, 0x47560000, 0xa3390000, 0x6d788000, 0xb8c9c000, 0xe3762000, 0x29d35000, 0x29e99800, 0x5d14ac00, 0x609f9a00, 0xdbddaf00, 0xdaef1a80, 0x7c886c40, 0x89c73960, 0x39fe3d70, 0x850820c8, 0xfc86534c, 0x49c71bc6, 0x19e46c45, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xf8000000, 0x14000000, 0xe6000000, 0x99000000, 0x47800000, 0xef400000, 0x4de00000, 0x12f00000, 0xbc780000, 0xdca40000, 0x421e0000, 0x17110000, 0xd29b8000, 0x8adb4000, 0x25b26000, 0x95959000, 0xe052f800, 0x5b738400, 0x8634fa00, 0x14c68500, 0xe8b17980, 0xd40cc640, 0x46189a60, 0xa9021610, 0x6f9801f8, 0x03540074, 0xbfe602e6, 0x6df502c9, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xc8000000, 0x4c000000, 0x3a000000, 0x1f000000, 0x94800000, 0xebc00000, 0x37600000, 0x82700000, 0x31f80000, 0x6aac0000, 0x701a0000, 0x28130000, 0x5c128000, 0x4201c000, 0x9b142000, 0xe29fb000, 0xcecb4800, 0xbceae400, 0xfd294a00, 0xed55e500, 0xdfa1c880, 0xc38727c0, 0x73476ba0, 0x46a956f0, 0x1a000348, 0xef00028c, 0xfc80031a, 0x17c00023, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xa8000000, 0x2c000000, 0xfe000000, 0x51000000, 0xef800000, 0x06400000, 0x57600000, 0x10700000, 0x22e80000, 0x05240000, 0xfd0e0000, 0xd18b0000, 0x37568000, 0xe8e54000, 0xbe356000, 0x59859000, 0xeb5cd800, 0x8efbf400, 0x3b3ada00, 0xcc14f700, 0x6e025b80, 0x990ab640, 0x9389b920, 0x504e66f0, 0x2a6e02d8, 0x01fb03b4, 0x75be8366, 0xbdc140ad, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xc8000000, 0x7c000000, 0xc2000000, 0x13000000, 0x61800000, 0xc3400000, 0x58200000, 0xa1300000, 0x5fb80000, 0x97740000, 0xd3020000, 0x418b0000, 0x134c8000, 0x2038c000, 0x153ca000, 0xe1a19000, 0x467a7800, 0xa19f3c00, 0xe3407a00, 0x88203d00, 0xd92efb80, 0xeba3ffc0, 0x2966d8a0, 0x020eae30, 0x330203a8, 0xb18b027c, 0xbb4c802e, 0xec38c071, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xf8000000, 0x2c000000, 0x96000000, 0xcf000000, 0x62800000, 0xdd400000, 0xfea00000, 0x4bb00000, 0x90380000, 0x10ec0000, 0xf9860000, 0x45c90000, 0xdae48000, 0x48924000, 0x9c59a000, 0x8f36f000, 0xca66d800, 0xa8d6cc00, 0x7d78da00, 0xa643cd00, 0x96225880, 0xc7f48c40, 0x47197b60, 0xa6993cf0, 0x3f428138, 0xdbab43cc, 0x882522b2, 0xccf8b1b9, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x48000000, 0x5c000000, 0x3a000000, 0xe7000000, 0x99800000, 0x04400000, 0xbb200000, 0x0a300000, 0x46b80000, 0x407c0000, 0xec8a0000, 0xf6d30000, 0xc4f08000, 0xf643c000, 0x40312000, 0x89b71000, 0x15e61800, 0x2acd3c00, 0xbef41a00, 0x31523d00, 0x69b69a80, 0xc5feffc0, 0xf2dd3ba0, 0x1ae92eb0, 0x1f428348, 0xe8acc12c, 0x816ba32e, 0x8817d03d, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x58000000, 0xac000000, 0xde000000, 0xe9000000, 0x99800000, 0x82c00000, 0x9d600000, 0x3e700000, 0x6cf80000, 0x08ac0000, 0x239a0000, 0xb1c10000, 0x67fc8000, 0x0e234000, 0x85c06000, 0xf5fc5000, 0x29378800, 0x1d48e400, 0x1ab58a00, 0x4495e500, 0x894b0880, 0x38aba7c0, 0x3b95e9e0, 0xbdd9b570, 0x09e48298, 0xbf3f42d4, 0xb04262fe, 0xa92151df, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x08000000, 0x54000000, 0xd6000000, 0xe5000000, 0xab800000, 0xe9400000, 0x1b200000, 0x70b00000, 0x39f80000, 0x92c40000, 0xba7e0000, 0xdf870000, 0xcf498000, 0x462d4000, 0xd736e000, 0x5aaa1000, 0xeefa7800, 0x525ffc00, 0x41b3fa00, 0x0472bd00, 0x7e851980, 0x5ad8ac40, 0x4e7f61a0, 0xb9875110, 0x724c98f8, 0xb1b5ef84, 0xbc6983d6, 0x729d4061, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x18000000, 0x54000000, 0xfa000000, 0x83000000, 0xca800000, 0x95c00000, 0xb7a00000, 0x2d300000, 0x70f80000, 0x1b5c0000, 0x307a0000, 0x75810000, 0x89578000, 0x9f72c000, 0x8103a000, 0xcd9d7000, 0x2d550800, 0x5d745c00, 0xe6028a00, 0xe5069d00, 0x6f812a80, 0xda5befc0, 0xddf422e0, 0xe8dfb290, 0xcc2eab08, 0x2d752d9c, 0x9e0d82a2, 0x2103c00b, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x48000000, 0x9c000000, 0x42000000, 0x51000000, 0xc2800000, 0x25c00000, 0x65600000, 0x9ff00000, 0xfe280000, 0xad5c0000, 0xeda60000, 0x8a070000, 0x0d088000, 0x2086c000, 0x24dbe000, 0xeff33000, 0x26354800, 0xd9500400, 0x63bdca00, 0xd116c700, 0x02862880, 0x85d5f640, 0x357b61a0, 0xd7e9f030, 0x6228aaa8, 0xef543674, 0xbca80122, 0x489c00a3, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x38000000, 0x04000000, 0x76000000, 0xdf000000, 0x84800000, 0x84400000, 0xfca00000, 0x5c300000, 0x7e780000, 0xf5c40000, 0x617a0000, 0xd1450000, 0x75218000, 0x65e54000, 0x1503a000, 0x6996b000, 0x49c97800, 0x53784c00, 0x9848fa00, 0x5ead0d00, 0x5d335980, 0x69ffbcc0, 0xbf002160, 0xb482f0d0, 0x5c495ab8, 0x88babeac, 0x1221a12a, 0xa567b07d, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x48000000, 0x5c000000, 0xaa000000, 0xb5000000, 0x17800000, 0x42400000, 0x06200000, 0xddb00000, 0x8de80000, 0x0acc0000, 0x06fa0000, 0x9e5b0000, 0x6c3c8000, 0x48a3c000, 0xaa666000, 0x00841000, 0x5ccd9800, 0xe9f43c00, 0x54d11a00, 0x55e7ff00, 0xeedf7a80, 0x98efefc0, 0xed48e3a0, 0x2cb0d2b0, 0xf46d7b08, 0x5388ef64, 0x2c4661d6, 0x1d3411ad, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x98000000, 0x5c000000, 0x12000000, 0x07000000, 0x4e800000, 0x4ac00000, 0xf7e00000, 0x2b700000, 0xa6a80000, 0xbfdc0000, 0x6e7a0000, 0xa7210000, 0x6f868000, 0xb556c000, 0xaaab2000, 0xe5de7000, 0xbd60e800, 0x8fb3b400, 0xf44e6a00, 0x45397700, 0x909f4880, 0xb7c605c0, 0xda7922e0, 0xd12370b0, 0x969c68a8, 0x76c477ac, 0xf5e3c912, 0x0471c747, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x78000000, 0x14000000, 0x2a000000, 0x69000000, 0x0e800000, 0x54c00000, 0x82200000, 0xc6b00000, 0x4b680000, 0xcfcc0000, 0x61b60000, 0xeef10000, 0xb08f8000, 0xd7d4c000, 0xc5a4e000, 0xccfcb000, 0xe583e800, 0x9f40cc00, 0xc6646a00, 0x03580f00, 0x10768a80, 0x0c55be40, 0x19fae360, 0x6d01b210, 0xbc9a69c8, 0x59d50cb4, 0x8ea70b72, 0x977c7fa7, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0x84000000, 0x82000000, 0x55000000, 0x37800000, 0xb0400000, 0x3be00000, 0x06700000, 0x37380000, 0xb15c0000, 0xc66e0000, 0x57330000, 0x814f8000, 0xfe69c000, 0xfb3c6000, 0x87431000, 0x2963d800, 0x99a14400, 0x00945a00, 0xa2d48500, 0xa4263a80, 0x31d49540, 0x24b26220, 0xd3001350, 0xa0945a28, 0xf2d48704, 0xac263876, 0xa5d49485, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x48000000, 0x8c000000, 0x9a000000, 0x57000000, 0x4b800000, 0x50400000, 0x0ca00000, 0x65300000, 0xe6780000, 0x975c0000, 0x1f220000, 0xa1730000, 0xc4ce8000, 0xfb67c000, 0xf3d22000, 0xe0ffd000, 0x9b851800, 0x28462c00, 0xe8b39a00, 0x033ded00, 0x6363ba80, 0x07c13cc0, 0x9ef023a0, 0xaa8cd2f0, 0xe6cb9bc8, 0x2861eeac, 0x8e41b866, 0x0db23f2d, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x88000000, 0x04000000, 0x66000000, 0xc5000000, 0x57800000, 0xcac00000, 0x99a00000, 0x6c300000, 0xe5f80000, 0x3ecc0000, 0x37b20000, 0x0d3b0000, 0xa4678000, 0xb9114000, 0xfd86e000, 0xcdd59000, 0x1d348800, 0xbc6ddc00, 0xe50b0a00, 0x67809d00, 0xe2c7e880, 0xeda20cc0, 0x8226e2a0, 0x24e590d0, 0x0f4c8938, 0x3861dec4, 0xc31908e6, 0x028b9d2f, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xb8000000, 0x94000000, 0xaa000000, 0xb9000000, 0x77800000, 0x87c00000, 0x5b600000, 0xc2f00000, 0xbe280000, 0x97c40000, 0xd36a0000, 0x8ef50000, 0x70338000, 0x3cd4c000, 0x89fae000, 0xd4b99000, 0x159aa800, 0xd2d1a400, 0x72e12a00, 0xa6316700, 0x93d9cb80, 0x3179f4c0, 0x1bfae160, 0x39b99290, 0xa81aa9c8, 0x1c11a774, 0xe6012b96, 0x770165ab, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x38000000, 0xdc000000, 0xde000000, 0x6d000000, 0x90800000, 0x6dc00000, 0x1e600000, 0x34f00000, 0xf6280000, 0xebcc0000, 0x3f720000, 0x127d0000, 0x62fa8000, 0x5f2b4000, 0x094fe000, 0xd9b17000, 0x2d948800, 0x754d2400, 0xb7a60a00, 0x589a6700, 0x49d3ea80, 0x3c6a16c0, 0xf7e7e260, 0x33bd71b0, 0xca868b18, 0x92c02704, 0x55f48bda, 0x30bd2473, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x88000000, 0xd4000000, 0x46000000, 0xd9000000, 0x81800000, 0xd5400000, 0xd0600000, 0xc0f00000, 0xe0380000, 0xf3040000, 0x02820000, 0xffdb0000, 0xabbd8000, 0x15534000, 0x70616000, 0x90efd000, 0xd83fb800, 0xaf059400, 0x90803a00, 0x60cdd500, 0xf33cd980, 0x418147c0, 0x755a03a0, 0x806f0090, 0xf8e780b8, 0xbc3c42f4, 0x6106e13e, 0x9d939361, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x08000000, 0xfc000000, 0xae000000, 0x11000000, 0x24800000, 0x8d400000, 0x88600000, 0x45f00000, 0x68280000, 0x870c0000, 0x918e0000, 0xd3d70000, 0xd62c8000, 0x5e1b4000, 0x69106000, 0x60977000, 0x47451800, 0xc3653400, 0x22679a00, 0x7ee97700, 0xb7bb7a80, 0xf5d54540, 0xfb2602a0, 0xf49b02b0, 0x65428218, 0xc47c41f4, 0x73f4e20a, 0x8d303181, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x58000000, 0xa4000000, 0x02000000, 0x39000000, 0x93800000, 0x41c00000, 0x80a00000, 0x3e300000, 0xf6780000, 0xca140000, 0xd5020000, 0x3d810000, 0xb6d98000, 0xd43fc000, 0x7363e000, 0x9f8d1000, 0x9fd96800, 0x4fa05c00, 0xfea2ea00, 0xe12e9d00, 0x3ee08b80, 0x11484dc0, 0xdff802e0, 0x66d40350, 0xfc2200e8, 0xef7102b4, 0x09818326, 0xfcdbc373, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xd8000000, 0xb4000000, 0xda000000, 0xa1000000, 0xcd800000, 0x69400000, 0xae600000, 0x7ef00000, 0x8c380000, 0x340c0000, 0x9a1e0000, 0x010d0000, 0xdd8f8000, 0xb156c000, 0x1a79e000, 0xa4e6d000, 0x2d38b800, 0xf98d5400, 0xf3493a00, 0xaf669500, 0xa3675880, 0x3d6a8540, 0x2e6003e0, 0x3ef00390, 0x2c380288, 0x240c0014, 0x421e033e, 0xb50d01f1, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xc8000000, 0x8c000000, 0x5e000000, 0xbf000000, 0xa9800000, 0x68400000, 0xd7e00000, 0x15700000, 0xbea80000, 0x041c0000, 0xb21a0000, 0xf11b0000, 0x6e9e8000, 0x85c34000, 0x6dada000, 0x23991000, 0xbd57d800, 0x7b76c400, 0x09b35a00, 0x819e8700, 0x34487880, 0x51e8d5c0, 0x5e6003a0, 0x0d3003f0, 0x014800d8, 0x2d6c020c, 0x9ab200fe, 0xc607016d, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xa8000000, 0x04000000, 0xba000000, 0xfb000000, 0xaf800000, 0x36400000, 0xdce00000, 0x42700000, 0xc8b80000, 0x298c0000, 0xcb420000, 0xce7f0000, 0xc6bb8000, 0x609ac000, 0x6bd4a000, 0x45b7d000, 0xd3175800, 0xeb952400, 0x2c56da00, 0xd7fce500, 0x45fbf880, 0xfaeef6c0, 0x4f638220, 0x7226c2d0, 0xa94ea2c8, 0xd974d03c, 0x7736daf6, 0xe7cce725, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x18000000, 0x1c000000, 0x96000000, 0x9b000000, 0x9c800000, 0x34c00000, 0x3d600000, 0x94f00000, 0xaba80000, 0x60840000, 0xd2c20000, 0xde790000, 0xa4668000, 0x117a4000, 0xdae62000, 0x4ca03000, 0xda176800, 0x65102400, 0x639bea00, 0x92576700, 0x1cb94b80, 0xb20415c0, 0x010683e0, 0x598a41b0, 0x874e23b8, 0x072430dc, 0x8c55684a, 0x93a926cf, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x58000000, 0x24000000, 0xca000000, 0xa1000000, 0xe2800000, 0xe4400000, 0x85600000, 0x44f00000, 0x3f280000, 0x62840000, 0x245e0000, 0xe56d0000, 0x14f58000, 0x673ec000, 0x468de000, 0xee4f3000, 0x4479f800, 0xf665f400, 0x837a7a00, 0xc3f23700, 0xaabc1b80, 0x7b5ec640, 0x94f582e0, 0xa73ec2d0, 0x268de3c8, 0xbe4f3354, 0x1c79f9c2, 0xd265f585, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x78000000, 0xb4000000, 0xfe000000, 0x8d000000, 0x51800000, 0xb5c00000, 0xc7a00000, 0xd1300000, 0x06780000, 0xc8940000, 0x2a460000, 0xf7610000, 0x9b0b8000, 0x508e4000, 0xce54e000, 0x11665000, 0xb2122800, 0x871afc00, 0x4287aa00, 0x7951bd00, 0x5be6cb80, 0x174cad40, 0xeeed8260, 0x92df4390, 0xb5276398, 0xa07c10a4, 0x8180cb5e, 0xedddae33, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x08000000, 0x84000000, 0x7e000000, 0x49000000, 0x24800000, 0x55400000, 0xd3600000, 0x64f00000, 0xf2280000, 0x01840000, 0x3bda0000, 0xd9230000, 0x2e0f8000, 0x91064000, 0xb89a6000, 0xd74c7000, 0x68661800, 0xf374d400, 0xb4fb9a00, 0xea259700, 0xfd9c7b80, 0xc9c8a6c0, 0x6a3583a0, 0x3d9540d0, 0xa9dde058, 0x1a3e32f4, 0x358e794a, 0x2ddfa661, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x78000000, 0x9c000000, 0x6a000000, 0xeb000000, 0x26800000, 0x18c00000, 0x76a00000, 0x15300000, 0x26680000, 0x379c0000, 0xcd560000, 0xa4e10000, 0xb9568000, 0x4ae9c000, 0xd447a000, 0x4576f000, 0xe511a800, 0xfb989c00, 0x1f592a00, 0x73fc5f00, 0x25d60880, 0xc12e6c40, 0x18688160, 0x2294c230, 0x5ec722c8, 0xffbe329c, 0xeca088d2, 0x9637adbf, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xf8000000, 0x44000000, 0xc2000000, 0x0d000000, 0x6b800000, 0x4b400000, 0xf0e00000, 0x9bb00000, 0xfb580000, 0x38fc0000, 0x57be0000, 0x555d0000, 0x4beb8000, 0xb72ec000, 0xba84e000, 0x96c75000, 0xfcbad800, 0x61db9400, 0x3e3e3a00, 0xf31cc500, 0xa084e080, 0x4fc75240, 0x0d3ad960, 0xb39b9650, 0x9f5e3ae8, 0x6aecc424, 0x02bce226, 0xaacb5359, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x08000000, 0x94000000, 0xb6000000, 0x5d000000, 0xdc800000, 0x3ec00000, 0x8d600000, 0xcbb00000, 0x8ad80000, 0x8b740000, 0x6eae0000, 0xda5b0000, 0x9fa78000, 0x9cca4000, 0x26766000, 0xaa2fb000, 0x78820800, 0x30de1400, 0xbc746a00, 0x2d31a500, 0xc3166180, 0xa59fb140, 0xac5a0ba0, 0x62aa1610, 0xb05a68f8, 0x00aaa624, 0xbb51e02a, 0x9125f0cf, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xc8000000, 0x14000000, 0xd2000000, 0x45000000, 0x28800000, 0xebc00000, 0xb6600000, 0xc9b00000, 0x6dc80000, 0x01640000, 0xd43e0000, 0xf6830000, 0x80df8000, 0x6df6c000, 0xc5e9e000, 0x81fe3000, 0x7bf4a800, 0xbaff5400, 0x887d4a00, 0x32b16700, 0x7e41e180, 0x192a3140, 0xea02a8a0, 0xc9185610, 0xc69cca68, 0xf8c4a644, 0xc1f7826a, 0x5be2c3fb, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xf8000000, 0xac000000, 0x1a000000, 0xd1000000, 0x0d800000, 0xfe400000, 0x3ea00000, 0xccf00000, 0x78480000, 0xcda40000, 0x5c7a0000, 0x21810000, 0x244e8000, 0x0fbcc000, 0x71606000, 0x7e191000, 0x5f0cb800, 0x8a8b7c00, 0x88ccda00, 0xe4626f00, 0xad886180, 0x6e4d11c0, 0x96beb860, 0x28ee7c70, 0x36585988, 0xaaafaef4, 0x9aee81de, 0x034cc17d, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x08000000, 0x84000000, 0x3e000000, 0xe9000000, 0x50800000, 0x7ec00000, 0x30600000, 0xfab00000, 0x5cd80000, 0xdb740000, 0x11320000, 0xd1870000, 0x1a458000, 0x98b54000, 0x57d5e000, 0xc0eeb000, 0x947e8800, 0x94b53400, 0xadcb6a00, 0xf7eb8500, 0xddede180, 0xb2eab2c0, 0x67748ba0, 0x033635d0, 0x9284ead8, 0x65ddc4b4, 0xd3f7803a, 0xf3f2409f, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x28000000, 0xd4000000, 0x42000000, 0xb1000000, 0xfb800000, 0x9cc00000, 0xf0e00000, 0xd0300000, 0x16c80000, 0x05f40000, 0x21b60000, 0xbf070000, 0x648b8000, 0x0854c000, 0xe0b16000, 0x9c86d000, 0x34462800, 0x16bfe400, 0x3f974a00, 0x56c93700, 0xa5f96380, 0x11b2d240, 0xc7102920, 0x9888e610, 0x9e54cba8, 0x13a9f694, 0xd61e0166, 0x530302f7, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x38000000, 0xf4000000, 0xee000000, 0x1f000000, 0xe4800000, 0x39400000, 0xea600000, 0x2f300000, 0xa7580000, 0x6d740000, 0x6fba0000, 0xf8090000, 0x540d8000, 0xbe094000, 0x970f2000, 0x2886f000, 0x2358f800, 0x1b644400, 0xd4b7da00, 0x7a92b500, 0xbe572180, 0xaaf2f3c0, 0x7062fb60, 0x9e2d4510, 0xbcda5958, 0x00abf6ac, 0x848001aa, 0xc9400359, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x98000000, 0x14000000, 0x6a000000, 0xc9000000, 0x4e800000, 0xdd400000, 0x84200000, 0x53700000, 0x0e580000, 0xdbbc0000, 0x74ba0000, 0xcd350000, 0x5dfd8000, 0x731dc000, 0xaf856000, 0xbfcb7000, 0xd770b800, 0xec5ecc00, 0xceadda00, 0x2c29bd00, 0x3f676080, 0x204272c0, 0x10b738e0, 0x7f360f90, 0x20f539c8, 0xa78f0e74, 0x23cab812, 0x616bce91, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x08000000, 0x8c000000, 0x66000000, 0x71000000, 0x7c800000, 0x6a400000, 0x7e200000, 0xa2700000, 0x85480000, 0xa7a40000, 0xb6be0000, 0x9a3b0000, 0x18648000, 0x7a5b4000, 0xb635e000, 0xce6f3000, 0x73449800, 0xdeb4ec00, 0x46397a00, 0x967fdf00, 0x1743e180, 0xa4b03140, 0x593e1ba0, 0x17e4ac70, 0x67801bb8, 0xc1dfacf4, 0xf9e499ea, 0x5a84ed2d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xa8000000, 0xd4000000, 0x4a000000, 0x9b000000, 0x3b800000, 0x56400000, 0x4ee00000, 0xdab00000, 0x6b480000, 0xc86c0000, 0xca6a0000, 0x95730000, 0x9cf38000, 0x5da1c000, 0x1edd2000, 0x97399000, 0x58017800, 0xbc00b400, 0x3e145a00, 0xa1152700, 0x089f2080, 0xb9d692c0, 0x52b0f820, 0x0f4e7690, 0x8a78f988, 0xf562763c, 0x4cf2f946, 0x85a175f5, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x78000000, 0x7c000000, 0xda000000, 0x45000000, 0xfb800000, 0x94c00000, 0xeae00000, 0x4c300000, 0xf7c80000, 0x4e6c0000, 0xc66a0000, 0x02690000, 0x047c8000, 0xeb66c000, 0x2deee000, 0x3ea55000, 0x9a842800, 0x795ea400, 0x3922ca00, 0x1457f700, 0x76ace080, 0xfe9052c0, 0x0f5aab60, 0xae3d6430, 0xaedaa888, 0xbffd67e4, 0x1fbaa806, 0x170d6587, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xc8000000, 0x8c000000, 0x82000000, 0x83000000, 0xc9800000, 0xb0400000, 0x3ee00000, 0xc8b00000, 0xbb480000, 0xdb740000, 0x8afe0000, 0xdeb30000, 0x9e4c8000, 0x8ff7c000, 0x3a272000, 0x968bd000, 0x93c3f800, 0xf1ae7400, 0x65ccda00, 0x04a1a700, 0x99592380, 0x2878d340, 0x9b6f7aa0, 0x2ae9b670, 0xaea3fb28, 0x465e773c, 0xcbe4daae, 0x3425a78d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x98000000, 0x84000000, 0x16000000, 0x99000000, 0x16800000, 0x9e400000, 0x3e600000, 0x9a300000, 0x17480000, 0x00e40000, 0xf8620000, 0xcb350000, 0x8dd78000, 0xe4b84000, 0x5500e000, 0x4c847000, 0x9d4c5800, 0xcbfb6400, 0x81e4ba00, 0xaaeb1700, 0xa362e180, 0x5ab172c0, 0xf01bd9e0, 0x580327d0, 0x64045838, 0x661f6774, 0x0106b982, 0x929e16dd, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x58000000, 0x0c000000, 0x3a000000, 0x5d000000, 0xf3800000, 0x08400000, 0x57e00000, 0x81b00000, 0x75480000, 0x54740000, 0xe1f60000, 0x26a90000, 0xbbce8000, 0xffb8c000, 0xe651e000, 0xfced5000, 0x752eb800, 0x83849400, 0xa0575a00, 0x33edc700, 0xbfa7e380, 0x46445240, 0xcce038e0, 0x7d3c5570, 0xd786bb88, 0x96409644, 0x54e958a6, 0x1130c715, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xa8000000, 0xd4000000, 0xd6000000, 0xb3000000, 0xc1800000, 0xe7c00000, 0xdba00000, 0x0f700000, 0x55580000, 0xdde40000, 0xa3020000, 0xd9830000, 0xfbc38000, 0x29be4000, 0xc269a000, 0xf3ccd000, 0x2dba0800, 0x2c73ec00, 0xccd1aa00, 0x463c3d00, 0x7aa82380, 0xb3f192c0, 0xdc102b20, 0xd2017c90, 0x5d0203f8, 0xfe83009c, 0x8c4381de, 0x8d7e4293, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xa8000000, 0xb4000000, 0x66000000, 0x93000000, 0x57800000, 0x4f400000, 0x2d200000, 0x99700000, 0x77d80000, 0xd7e40000, 0xc6120000, 0xc3130000, 0xef8f8000, 0x23544000, 0x572ba000, 0xd87e1000, 0xd557d800, 0x5c3a2c00, 0xf3ee7a00, 0x38173d00, 0x2c162380, 0x1a0950c0, 0x310bfb20, 0x0a847f10, 0x3fd80138, 0x53e4019c, 0x68120146, 0x941302b1, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x38000000, 0x34000000, 0x1e000000, 0xf3000000, 0x86800000, 0xc6c00000, 0xf5a00000, 0x68700000, 0x07580000, 0xebec0000, 0x881a0000, 0x6c010000, 0x7a058000, 0xa50b4000, 0x799aa000, 0x6a483000, 0xde6bc800, 0xe8480c00, 0x2f6b6a00, 0xdfc13d00, 0xfe252280, 0x8b3270c0, 0xfaace860, 0xbce77d10, 0x38800298, 0x05c0021c, 0x6b2002e2, 0xeab00117, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x98000000, 0x84000000, 0x72000000, 0x73000000, 0xdd800000, 0x86400000, 0x4e600000, 0xff300000, 0x3ed80000, 0x04a40000, 0x61960000, 0x00510000, 0xe76f8000, 0x1da4c000, 0x0b0b2000, 0x49815000, 0x0c433800, 0xe96e6400, 0xc8be1a00, 0x4f8e3500, 0xe54aa380, 0x6be09040, 0xad699be0, 0x9abef750, 0x0c8f81a8, 0xf0d4c2dc, 0xf1b3233e, 0x15155295, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x18000000, 0x9c000000, 0x32000000, 0x3d000000, 0x5c800000, 0xb3400000, 0x83200000, 0x59700000, 0x90c80000, 0x19f40000, 0xd18e0000, 0xc7c90000, 0x447c8000, 0xfc57c000, 0x42bae000, 0x46a3b000, 0x28a1b800, 0x47a6ac00, 0xb6355a00, 0x41fc1f00, 0xed806380, 0x05c97140, 0xf169d9e0, 0x24dbdc30, 0x5ff282a8, 0xca9ec184, 0x1046603a, 0x38b47079, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x38000000, 0x94000000, 0xd6000000, 0x99000000, 0x03800000, 0x43400000, 0xc5a00000, 0x59f00000, 0x2ec80000, 0x4be40000, 0xa9ca0000, 0x9d790000, 0x9b198000, 0x6c964000, 0x09d2e000, 0x8d67d000, 0x7305d800, 0xf0897c00, 0x73d53a00, 0x5673af00, 0x3f836180, 0x295593c0, 0xf6bd3b60, 0x8967ae90, 0x8d0161b8, 0x15889334, 0x3a4eb8d6, 0xf638efa9, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x38000000, 0xa4000000, 0xb6000000, 0x29000000, 0x48800000, 0x7a400000, 0x9ba00000, 0x16f00000, 0x00d80000, 0xeef40000, 0x04ca0000, 0x88e90000, 0x25df8000, 0x5c6c4000, 0x4d98e000, 0x58d6b000, 0x3aeb9800, 0x6adb9c00, 0x35e17a00, 0xe3502d00, 0xab3f6180, 0x28bef1c0, 0x1d617b60, 0xe9102e50, 0xe89f6038, 0xaa4ef334, 0x93b9787a, 0x8ae42d8d, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x38000000, 0x1c000000, 0xd2000000, 0x51000000, 0xc9800000, 0x65c00000, 0x23600000, 0x21b00000, 0xb4580000, 0x8abc0000, 0x48d60000, 0x48fd0000, 0x1d608000, 0xeab3c000, 0x38db6000, 0x40fe9000, 0xa97ec800, 0x1cac7400, 0xa7cbaa00, 0x0a63e500, 0x543be080, 0x938d5340, 0xc0c5aa60, 0xbce2e630, 0x4b6d61a8, 0xe5b39034, 0x4a464aee, 0xa1a3b693, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xd8000000, 0xdc000000, 0x3a000000, 0x4d000000, 0x60800000, 0xf0c00000, 0x76a00000, 0xe5700000, 0xc0580000, 0xfe740000, 0x3fde0000, 0x57210000, 0x772c8000, 0x4736c000, 0xef31e000, 0x7b283000, 0x45384800, 0xee2fec00, 0xf9afaa00, 0x24e2dd00, 0xc21d6180, 0xa11ef340, 0xf289a8e0, 0x29c7dd30, 0x2837e188, 0xbebd3344, 0xa16acaea, 0xc6482cb7, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xc8000000, 0xcc000000, 0xd6000000, 0x3f000000, 0xc9800000, 0xe5400000, 0x65e00000, 0xb9300000, 0x11980000, 0x915c0000, 0x17f20000, 0xac2f0000, 0xf9188000, 0x4e9f4000, 0x88cf2000, 0xaaa1d000, 0xfdd51800, 0x923b5400, 0x7a02ba00, 0x3905c500, 0xae988080, 0x18df41c0, 0x52af21a0, 0xf9d1d3f0, 0x882d1878, 0x931757cc, 0xcf88ba7e, 0x8246c669, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x38000000, 0xf4000000, 0x26000000, 0x33000000, 0xe4800000, 0x95c00000, 0x42e00000, 0xbbb00000, 0xe0980000, 0x2bd40000, 0x55fa0000, 0x71310000, 0x8a418000, 0x5fae4000, 0x6e88a000, 0x04d3f000, 0x6b6ba800, 0x3df6a400, 0xcd228a00, 0x804b1500, 0x8ea18180, 0xa71e41c0, 0xb290a360, 0x7ec7f310, 0x6271a878, 0x3077a71c, 0x657b090a, 0x52f1579b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xb8000000, 0xcc000000, 0xd2000000, 0x99000000, 0x77800000, 0x35c00000, 0xe6e00000, 0x50b00000, 0x5d880000, 0x40c40000, 0xb37e0000, 0x54650000, 0xb8e68000, 0x3bb7c000, 0x431f6000, 0xaa8cd000, 0x1458c800, 0xfc2ca400, 0xfec12a00, 0xc867b700, 0xf2ee8180, 0x9eb3c340, 0x4e816160, 0x7259d370, 0x9b3649a8, 0xd25f6554, 0xab204896, 0x9a4e65b3, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xd8000000, 0x5c000000, 0x9e000000, 0x31000000, 0xf7800000, 0x0b400000, 0xf1e00000, 0x29300000, 0x61980000, 0xfe440000, 0xa4660000, 0xdd610000, 0x8ee88000, 0x77ac4000, 0xa14be000, 0xcaedd000, 0x95b91800, 0x3e4e1400, 0x847a7a00, 0xed7f8500, 0x06f08380, 0xf3a84040, 0x634de2e0, 0x65fcd030, 0x53299918, 0xc29655b4, 0x7ecf9ba6, 0x35b755e9, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x58000000, 0xbc000000, 0x6e000000, 0x85000000, 0xf7800000, 0xf9c00000, 0xb6a00000, 0x9ef00000, 0x40980000, 0x354c0000, 0xf5f20000, 0x720d0000, 0x1b148000, 0x0a9e4000, 0x024b6000, 0x79655000, 0x11464800, 0x47ec2c00, 0x0901aa00, 0x819b3d00, 0xe0de8280, 0x9f2f43c0, 0xba35e1e0, 0xbdba1030, 0x3c6ba8d8, 0x86da3ce4, 0x2e380066, 0x57bc00f3, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xd8000000, 0xcc000000, 0xba000000, 0x11000000, 0xb1800000, 0xbec00000, 0xd1600000, 0x98300000, 0xa4980000, 0x11440000, 0xb0b20000, 0x6fd50000, 0x40ea8000, 0xb6f2c000, 0x5df36000, 0x9d7b1000, 0x62326800, 0xd58bb400, 0x50d38a00, 0xd6766500, 0x72b88380, 0x62d7c2c0, 0x0361e2e0, 0xfd3dd0f0, 0x930b0988, 0xdc91a774, 0x0d41622e, 0x42ae13bf, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x08000000, 0x0c000000, 0x9e000000, 0x77000000, 0xf9800000, 0x04400000, 0x7c600000, 0x83b00000, 0xea880000, 0xbfdc0000, 0x89220000, 0x45570000, 0x0ef88000, 0xc8664000, 0xd9b32000, 0x2f9cd000, 0x9f443800, 0x0bffc400, 0xc8e79a00, 0x6b695700, 0xaa3a8280, 0xf6c143c0, 0xf7a3a0a0, 0x909690f0, 0x4add1a58, 0xa1a815ec, 0xcb99239e, 0x1d57d2cd, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x78000000, 0xac000000, 0x5a000000, 0x11000000, 0x53800000, 0xf3400000, 0x63e00000, 0xed300000, 0xca980000, 0x04cc0000, 0x2ea60000, 0x01dd0000, 0xeb328000, 0x898ac000, 0xa2436000, 0x10635000, 0x0e739800, 0xd16e5400, 0x45fa7a00, 0xbe3bc500, 0x14148280, 0x9617c140, 0x7b11e160, 0x2a9992f0, 0x74c8f888, 0x66b106f4, 0xc5d7e226, 0x65349289, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xd8000000, 0xc4000000, 0xb2000000, 0x1d000000, 0xf1800000, 0xe4400000, 0xfce00000, 0x34300000, 0xbd180000, 0x818c0000, 0x1c420000, 0x08fd0000, 0x5e338000, 0x6416c000, 0xc219e000, 0xe51f9000, 0x059fb800, 0x8e409400, 0x25f7da00, 0x77b4c500, 0x44420280, 0x8cfd01c0, 0xcc3383e0, 0x4916c3d0, 0xeb99e1a8, 0xc55f9364, 0x4b7fb90e, 0xa77097e5, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0x2c000000, 0x96000000, 0x07000000, 0x14800000, 0xd4c00000, 0x4c600000, 0x23300000, 0xc3180000, 0x8e840000, 0x15ca0000, 0x47e30000, 0xe7708000, 0xe1af4000, 0x70c62000, 0xe6607000, 0xca270800, 0xe48d9400, 0xdcdbaa00, 0x3061a500, 0xad2a0380, 0xc01301c0, 0x20088120, 0x501b4070, 0x181422f8, 0x040770ac, 0xba1d8a0a, 0x9101d74f, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x38000000, 0xe4000000, 0x4e000000, 0x7b000000, 0x80800000, 0x46c00000, 0x3f600000, 0xda300000, 0x17080000, 0xd29c0000, 0xb7c20000, 0xbae10000, 0x5f6b8000, 0x0a3d4000, 0x3f0aa000, 0x3e857000, 0x25ddc800, 0x6bf2b400, 0xeafeea00, 0xb76b8700, 0xc6220280, 0x9d1103c0, 0xd7838060, 0x74514350, 0x98a0a1d8, 0x68c8727c, 0x947c4b3a, 0x72b2f4f7, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xd8000000, 0x5c000000, 0xe2000000, 0xe5000000, 0x5d800000, 0x4ac00000, 0x10a00000, 0xcaf00000, 0xe9080000, 0x17940000, 0x4bda0000, 0x432d0000, 0x5f208000, 0x1d3fc000, 0x2824e000, 0x1da51000, 0xd36be800, 0x7dc9cc00, 0xb0358a00, 0xe1be1f00, 0xe17a0380, 0xf0dd01c0, 0x69a882e0, 0x156bc3b0, 0xf6dee0e8, 0x82b812e4, 0x97e36afe, 0x58920ebf, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x48000000, 0xfc000000, 0xca000000, 0x4d000000, 0xe1800000, 0x2a400000, 0x2a200000, 0xf0f00000, 0x2b180000, 0x6e840000, 0x1ad60000, 0xfbf30000, 0xf5868000, 0xec4ec000, 0x553ce000, 0x387f9000, 0x9ec87800, 0x15fb8c00, 0xa6841a00, 0xa6c9dd00, 0x51ee0380, 0x68870240, 0x45c880a0, 0x8379c0b0, 0xd84c6208, 0x233252c4, 0xdf6a18ae, 0xe24edd9d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x18000000, 0xec000000, 0x5a000000, 0xc3000000, 0x72800000, 0x67c00000, 0x33200000, 0x59700000, 0xcd080000, 0x17840000, 0x445a0000, 0x21650000, 0xd10e8000, 0xb58ec000, 0x5b4f2000, 0x11f03000, 0x99d1a800, 0xae2f1c00, 0xa6ea0a00, 0x9d44ef00, 0xb0f20180, 0x145103c0, 0xc97c83e0, 0xc51fc370, 0x3393a108, 0xda5ff0bc, 0x4c6a08a2, 0xd684ee93, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x58000000, 0x4c000000, 0x8e000000, 0x5d000000, 0x15800000, 0xd6400000, 0x2e200000, 0x84f00000, 0x5b080000, 0x0c8c0000, 0xc9d20000, 0x0f6d0000, 0x78528000, 0x83204000, 0x697e6000, 0xf1471000, 0xf4bf7800, 0x5c348c00, 0xcfe19a00, 0xff8edf00, 0x715a0080, 0x34a103c0, 0xfc2083e0, 0xfffd41f0, 0xa784e358, 0x3d5b5044, 0xbabb1a6e, 0xa1229e2d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x98000000, 0x84000000, 0xe6000000, 0x13000000, 0x78800000, 0xafc00000, 0x1ee00000, 0xccb00000, 0xde080000, 0x27040000, 0x768e0000, 0x30c10000, 0x9c638000, 0x127c4000, 0x4d76a000, 0x2ff97000, 0x613ce800, 0x6a432400, 0xe6afca00, 0x17031700, 0x5e880180, 0x5cc40140, 0xf66e01e0, 0xfb710050, 0x44eb81f8, 0x0db8425c, 0xbb98a27a, 0x6f4872f3, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x28000000, 0x8c000000, 0x2a000000, 0x9b000000, 0xe7800000, 0xfb400000, 0x86200000, 0x43f00000, 0xae080000, 0x4d0c0000, 0xde820000, 0xbbd30000, 0x98f48000, 0x2984c000, 0xa64e2000, 0xc0bb9000, 0x5c259800, 0x90e2ac00, 0xd5953a00, 0x0442ff00, 0x67a80080, 0xb9bc01c0, 0x7caa0220, 0x9e2f00f0, 0x27fe8008, 0xa81bc05c, 0x4c18a336, 0x8a1c5181, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xc8000000, 0x3c000000, 0xda000000, 0x53000000, 0x2e800000, 0x11400000, 0x94a00000, 0x7e700000, 0xac080000, 0x02040000, 0x771a0000, 0x309f0000, 0x6c5e8000, 0x0f3cc000, 0xc8a12000, 0x5467b000, 0xd713f800, 0x2092bc00, 0x745e5a00, 0xcb22cf00, 0xe6a00180, 0xe17003c0, 0x708800a0, 0x4c440030, 0xdf3a0048, 0x30af01bc, 0xa07683d2, 0x3108c109, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x28000000, 0x54000000, 0xba000000, 0x85000000, 0x43800000, 0x29c00000, 0x70e00000, 0x81b00000, 0x4c080000, 0xa60c0000, 0xbb1a0000, 0x248b0000, 0x934f8000, 0xf4bdc000, 0xe797e000, 0x7bc0d000, 0x01f94800, 0x08352400, 0xc8d32a00, 0xc17f3700, 0xa9600080, 0x9d7002c0, 0xf7680220, 0x2a7c0090, 0x15f20248, 0xd2370344, 0x9ddd83e6, 0xdafac2b3, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x18000000, 0xec000000, 0xf2000000, 0xa1000000, 0x8e800000, 0xcbc00000, 0xdd200000, 0xe7900000, 0x2a080000, 0xed040000, 0xec8e0000, 0x02c70000, 0xa7a18000, 0x325ec000, 0xa4272000, 0x251e1000, 0x83cee800, 0xf92fbc00, 0x71925200, 0xfd0fb900, 0xc4880080, 0x16c40040, 0xc9ae00e0, 0x79570070, 0x67a98018, 0x925ac0ec, 0x342920f2, 0x4d1910a1, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x18000000, 0xbc000000, 0xce000000, 0xab000000, 0xbe800000, 0x98400000, 0x17200000, 0x17500000, 0xe2080000, 0xbd0c0000, 0x89820000, 0xf8c10000, 0x3c618000, 0x02fbc000, 0xa314e000, 0xe32eb000, 0x9d55e800, 0x0b028400, 0x6e8df200, 0xa0493500, 0xbb280080, 0xc15c00c0, 0xf50a0020, 0xcd8d0010, 0xbac38018, 0x516ac0bc, 0xb37d60ce, 0xf7d970ab, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xb8000000, 0x84000000, 0xd6000000, 0x83000000, 0xdc800000, 0x6f400000, 0x56200000, 0x80b00000, 0x5a080000, 0xc90c0000, 0x9d860000, 0xaecf0000, 0x5aeb8000, 0x37584000, 0xb6d56000, 0x1a1c3000, 0x3dffc800, 0x992bf400, 0x763be200, 0x844acb00, 0xe6a80080, 0x95fc00c0, 0x952e0060, 0xfc3300f0, 0xa54580b8, 0xd72b4084, 0x2130e0d6, 0xa6c77083, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x38000000, 0xd4000000, 0xca000000, 0xa7000000, 0xd9800000, 0xc8c00000, 0x9ce00000, 0xec500000, 0x76080000, 0xf10c0000, 0x38860000, 0x184b0000, 0xd8a38000, 0x12fd4000, 0xddf4a000, 0x987e7000, 0x16bf9800, 0x83558c00, 0xe3834e00, 0xf7c10500, 0x41680080, 0x669c00c0, 0xa1ee0060, 0xdad700b0, 0xeb4d8038, 0x0b2a40d4, 0x1d3920ca, 0x289430a7, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x78000000, 0xec000000, 0x52000000, 0x13000000, 0x43800000, 0xd0c00000, 0x9de00000, 0x1f900000, 0x5b080000, 0x97840000, 0xceca0000, 0x6ceb0000, 0x37178000, 0x2446c000, 0x88a12000, 0x5fbb3000, 0x6bf73800, 0x2b568c00, 0xe0e11e00, 0x3511d900, 0x5f4a0080, 0xef2b0040, 0x497780a0, 0x5b16c0b0, 0x36492078, 0x3baf30ec, 0xac353852, 0xc3398c13, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xa8000000, 0xc4000000, 0x2e000000, 0xdb000000, 0x3f800000, 0xf0400000, 0x85200000, 0x18100000, 0xdd080000, 0x60840000, 0x01ce0000, 0x1e6b0000, 0x0aba8000, 0xf1544000, 0x16aee000, 0xa257b000, 0xfd2ef800, 0x841a8400, 0x7f089200, 0xe1802100, 0x63460080, 0xceaf0040, 0x6e5480e0, 0x472f40b0, 0x691c60a8, 0xf787f0c4, 0xc44e182e, 0xe32634db, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x38000000, 0xbc000000, 0xea000000, 0xd9000000, 0x16800000, 0xb6c00000, 0xcce00000, 0x2dd00000, 0x3f080000, 0x7d8c0000, 0x954a0000, 0x4eaf0000, 0x0af38000, 0x9eb3c000, 0xea9aa000, 0xd4a39000, 0x2bf86800, 0x9435ec00, 0x465f8e00, 0xf94a3d00, 0xaca20080, 0xf7f300c0, 0x2e3180a0, 0x5750c0f0, 0x6bc32038, 0x4c6f50bc, 0x081948ea, 0xcc69bcd9, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xd8000000, 0xe4000000, 0xb6000000, 0x57000000, 0x28800000, 0x08c00000, 0x9ea00000, 0x3ef00000, 0x08880000, 0x18c40000, 0x16ae0000, 0xb2fb0000, 0x82858000, 0x1dca4000, 0xdf256000, 0xc5be7000, 0x3c670800, 0xb55acc00, 0x77f48a00, 0xeb019f00, 0x3a858080, 0x09ca4040, 0x512560e0, 0xc6be70b0, 0x7ae708d8, 0x0e9acce4, 0x77d48ab6, 0x8a319f57, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x78000000, 0x94000000, 0x6a000000, 0xdb000000, 0x60800000, 0xea400000, 0xed600000, 0xe9500000, 0x08880000, 0x96440000, 0xbb660000, 0x045b0000, 0x350f8000, 0x398d4000, 0x6dc0a000, 0x51a6b000, 0xb3718800, 0x493fe400, 0x4c547600, 0x99092500, 0xa78f8080, 0x6ccd4040, 0x9220a060, 0xadb6b0b0, 0x24198878, 0x936be494, 0x185a766a, 0xd30625db, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x68000000, 0x2c000000, 0x36000000, 0x13000000, 0x63800000, 0x62400000, 0x78a00000, 0x89300000, 0x0f880000, 0x344c0000, 0xfbaa0000, 0xb2b30000, 0x29ce8000, 0x56eec000, 0x57996000, 0xcdba3000, 0x1c44b800, 0xb7a2e400, 0x14bdea00, 0x62c42300, 0x716e8080, 0x2fdec0c0, 0x901160a0, 0xe5f63030, 0xb9eeb868, 0x3a11e42c, 0x68f36a36, 0x456ae313, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x28000000, 0x04000000, 0x4a000000, 0xad000000, 0xce800000, 0xffc00000, 0x45200000, 0x19900000, 0x92880000, 0x79cc0000, 0xb6220000, 0x28130000, 0x22ca8000, 0x43ac4000, 0xf256a000, 0x85a1d000, 0xe1526800, 0xa425bc00, 0x491ff200, 0xb243c900, 0x436a8080, 0xf8fc40c0, 0xe37ea020, 0x2e3dd030, 0xe2d86828, 0x456abc04, 0xcbff724a, 0xf2f089ad, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x78000000, 0x74000000, 0xf6000000, 0x5f000000, 0x7f800000, 0x5d400000, 0xe0e00000, 0xf0100000, 0x99880000, 0xea4c0000, 0xc3620000, 0x27570000, 0xdc6f8000, 0xb8db4000, 0xd1256000, 0x503ef000, 0x2d3a7800, 0x4bb19400, 0x6e70ee00, 0xa85cb100, 0x6be78080, 0xc99740c0, 0xc3c76020, 0x7129f070, 0xe035f878, 0x753ad474, 0x4fbd8ef6, 0xe07e415f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xa8000000, 0xe4000000, 0x66000000, 0x11000000, 0xff800000, 0x30c00000, 0x90a00000, 0x72700000, 0xd1880000, 0x75cc0000, 0xd12a0000, 0xcfbd0000, 0x94a28000, 0xa4724000, 0x18846000, 0x16401000, 0xcbef7800, 0xcc104c00, 0x6e5dea00, 0xabbc7700, 0x32aa8080, 0x157e40c0, 0x370e60a0, 0x8e8d10d0, 0xbf45f8a8, 0xd86e0ce4, 0xaed38a66, 0x21f16711, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xe8000000, 0x4c000000, 0x0e000000, 0x49000000, 0x93800000, 0x81c00000, 0x49600000, 0xdc300000, 0x51880000, 0x86c40000, 0xb3e20000, 0x3e7f0000, 0x71268000, 0x5f90c000, 0x305ae000, 0xa0379000, 0xd789b800, 0x53c5dc00, 0x3667f600, 0x52bc1300, 0xe9ce8080, 0x4564c040, 0xf230e020, 0xe88c90f0, 0xfd4d38e8, 0x7e2a1c4c, 0x791b960e, 0xe41b4349, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x68000000, 0x8c000000, 0xe6000000, 0xbf000000, 0x3d800000, 0x85c00000, 0x59a00000, 0x67d00000, 0x47880000, 0x54c40000, 0x272a0000, 0x819d0000, 0xc0ee8000, 0x3d3cc000, 0xdbbc6000, 0x49faf000, 0x6c935800, 0x006b9c00, 0xf07e7a00, 0xb35ccd00, 0x18c68080, 0x2128c040, 0x4e9e60a0, 0x4563f0d0, 0x5cf7d868, 0xe81a5c8c, 0x77249ae6, 0xa99efdbf, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xb8000000, 0x54000000, 0x5e000000, 0xfb000000, 0xbd800000, 0xe6400000, 0x8be00000, 0x12900000, 0xa6880000, 0xcbcc0000, 0xb5a60000, 0x9d750000, 0x52138000, 0xc2414000, 0x9defe000, 0x359cb000, 0xf90d5800, 0x648ca400, 0x72ce1e00, 0x712e7900, 0xdfb58080, 0xcb3440c0, 0xf1fc6060, 0x5cddf050, 0x6162b8b8, 0xe3501454, 0x5e23465e, 0xfc32ddfb, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xe8000000, 0xd4000000, 0xf2000000, 0xc9000000, 0x43800000, 0x30400000, 0x41600000, 0xb7f00000, 0xf6880000, 0xf5cc0000, 0xba260000, 0x04190000, 0x0eb68000, 0x54694000, 0x82752000, 0x75cb9000, 0x7a2fb800, 0x6416c400, 0x9eb77600, 0xbc624f00, 0x56708080, 0x87c040c0, 0xb32ba060, 0x279ed090, 0xaef498e8, 0xfd0854d4, 0xe1884ef2, 0x7144cbc9, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xe8000000, 0xb4000000, 0xfa000000, 0x09000000, 0x31800000, 0xd8c00000, 0x35200000, 0x25900000, 0xda880000, 0xfc440000, 0xb2620000, 0x4b770000, 0x1ab68000, 0x5e174000, 0x8341a000, 0x1ce19000, 0x2d389800, 0xf1d74c00, 0xbce53200, 0x1d302900, 0x39dc8080, 0x78e44040, 0x0f352020, 0x84d1d070, 0xb367b8e8, 0xdef59cb4, 0x80760afa, 0x4e35f509, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x68000000, 0x3c000000, 0x86000000, 0xb5000000, 0x36800000, 0x49400000, 0xa3200000, 0xc0700000, 0x9d880000, 0xeecc0000, 0xbee20000, 0xdd190000, 0xaf5e8000, 0xc3f7c000, 0x224e6000, 0x24ac5000, 0x4dbee800, 0xe8e0d400, 0xe01b1200, 0x15d6f700, 0xf4b48080, 0x6062c0c0, 0x6852e020, 0xaa729090, 0x26860868, 0xe147443c, 0xbf219a86, 0xd67f73b5, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x28000000, 0x8c000000, 0x1e000000, 0xd1000000, 0x98800000, 0x15c00000, 0x5fe00000, 0xaeb00000, 0x65c80000, 0x27ec0000, 0x6ab60000, 0x67c10000, 0xc0ee8000, 0xaf3ec000, 0xf480e000, 0x5bc39000, 0xc6e74800, 0x2a39bc00, 0x46026e00, 0x2507a300, 0x4280e080, 0xc6c390c0, 0x20674860, 0x7ef9bc90, 0xa9626e28, 0x1277a38c, 0x66a8e09e, 0x9e9f9011, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xd8000000, 0xe4000000, 0xe2000000, 0x7b000000, 0x59800000, 0xa0c00000, 0x12a00000, 0x20b00000, 0xbcc80000, 0x04ac0000, 0xb1b60000, 0x12430000, 0x23e18000, 0x7ed84000, 0xe0dd2000, 0x3dde3000, 0x2d59d800, 0xc71d2c00, 0x10f21a00, 0x842d5300, 0x93fd2080, 0x29ae30c0, 0xd931d860, 0xcc012cb0, 0x7e0c1ad8, 0xad0253e4, 0xa88aa062, 0xbe4570bb, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x58000000, 0x44000000, 0x86000000, 0xdf000000, 0x1f800000, 0xa4400000, 0x29e00000, 0xced00000, 0xa8480000, 0x03e40000, 0xebd60000, 0x5ac70000, 0xb9218000, 0xe2f24000, 0x803f6000, 0x8d147000, 0xb1efb800, 0xaadf2400, 0xbe4bee00, 0x74e7d500, 0xe85f6080, 0x3c847040, 0xc9c7b860, 0xecab24f0, 0x93b5ee58, 0x0354d544, 0xbd00e006, 0x9685309f, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xc8000000, 0x74000000, 0xda000000, 0x9f000000, 0x13800000, 0x80400000, 0x47600000, 0x6e100000, 0xce480000, 0xf2640000, 0x9a920000, 0x71810000, 0x53488000, 0x82e54000, 0x8754a000, 0x63ad7000, 0x3eb27800, 0xc57fa400, 0xa6588600, 0xbd255900, 0x667ca080, 0x5bd97040, 0x58687820, 0x3d9aa490, 0x6e0206c8, 0x25011974, 0x3c80805a, 0xcbc140df, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0xfc000000, 0x96000000, 0x13000000, 0xe3800000, 0x96400000, 0x0f600000, 0x2b300000, 0x14480000, 0x56640000, 0x3db60000, 0x4a890000, 0xf8c68000, 0xe5a9c000, 0xff986000, 0x615bb000, 0xeffdf800, 0x47ea0400, 0xcaf2c600, 0x87610b00, 0xe7306080, 0xda4fb040, 0x8163f860, 0x9c370410, 0xa5ca4628, 0x9125cbfc, 0xa8588016, 0x9174c053, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xa8000000, 0x14000000, 0x5a000000, 0xa9000000, 0xbc800000, 0x80400000, 0xf3e00000, 0xa0500000, 0xb6480000, 0xece40000, 0x43d20000, 0xf58b0000, 0x6cce8000, 0xcba34000, 0xdfb6a000, 0xf0181000, 0xbda68800, 0xe0bba400, 0x239cae00, 0x56644d00, 0x749ea080, 0xf1ec1040, 0xd55c8820, 0x54c4a430, 0x07a82ea8, 0x19b80d14, 0x271c80da, 0x5a2840e9, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x18000000, 0x84000000, 0xee000000, 0x45000000, 0x7e800000, 0xe2c00000, 0x64a00000, 0x5a900000, 0x0bc80000, 0x28240000, 0xf7560000, 0x0ae30000, 0xb3f58000, 0x80764000, 0x1039e000, 0x345fd000, 0x8d6ea800, 0x95b84c00, 0x051eda00, 0x89826100, 0x934fe080, 0x83ecd040, 0x4f732860, 0x35ba0cb0, 0x95193a18, 0x418ab184, 0xbf4ac86e, 0xf1e5dc05, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xf8000000, 0x3c000000, 0x22000000, 0x07000000, 0xf9800000, 0x0f400000, 0x55e00000, 0x74b00000, 0xaa480000, 0xeb640000, 0x227a0000, 0x20e50000, 0x323b8000, 0xc081c000, 0x43cb2000, 0xfc25f000, 0x3b915800, 0x5e555400, 0x5b7aee00, 0xcc6cf300, 0x4bf92080, 0x77a4f040, 0x8bd0d8a0, 0x6e3194d0, 0xd28a4ef8, 0xccc8c33c, 0x11a358a2, 0xd2d45447, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x88000000, 0x84000000, 0x92000000, 0x4d000000, 0x95800000, 0x3cc00000, 0x50200000, 0x92900000, 0x13c80000, 0x20ac0000, 0xefde0000, 0xd5230000, 0xa3148000, 0xed0e4000, 0x058e2000, 0xe4c25000, 0xec2a1800, 0x0c926c00, 0x48c19200, 0x6a255100, 0x0b982080, 0x2c4d50c0, 0x5d6098e0, 0x3c7f2cb0, 0xa47b3288, 0x38794184, 0xf6741812, 0x95716c8d, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x48000000, 0x8c000000, 0x3e000000, 0xeb000000, 0xb3800000, 0xa1c00000, 0x2f600000, 0x48900000, 0x82480000, 0xd6a40000, 0xf3fe0000, 0x80d30000, 0x45e88000, 0xcfd2c000, 0xb46ee000, 0x13153000, 0xff817800, 0x3fce3c00, 0x94652600, 0x0312c100, 0xe7866080, 0x4bc7f040, 0x6e6f98e0, 0x5a1b0cb0, 0x81045e48, 0xb28cfd8c, 0x534b46be, 0x9c2131ab, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xf8000000, 0x64000000, 0x0a000000, 0x43000000, 0x10800000, 0x0b400000, 0x36a00000, 0xfe300000, 0xf3c80000, 0x91ec0000, 0x3e960000, 0xd0f70000, 0xc3ab8000, 0x93bc4000, 0xc901a000, 0x9388b000, 0x7bcec800, 0xcde95400, 0x30987a00, 0x69f49b00, 0x682a2080, 0xec74f0c0, 0xfeef6860, 0x1811e4f0, 0x66beb2f8, 0xa481cf64, 0xa94c5a8a, 0x79ab6b83, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x38000000, 0x44000000, 0x4a000000, 0x57000000, 0xa6800000, 0x3f400000, 0xbda00000, 0xb6900000, 0x5dc80000, 0x88e40000, 0x3c360000, 0xfdd30000, 0xd26f8000, 0x4d764000, 0x3d71a000, 0x2571f000, 0xb177a800, 0x73721400, 0x58788a00, 0xf0f2b100, 0xd2be2080, 0x9e97b040, 0xb1ce0860, 0x6ee7e4b0, 0xed392238, 0x3a53a544, 0x12a92aca, 0x74134117, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x38000000, 0x3c000000, 0xd6000000, 0xbd000000, 0x4c800000, 0xc0400000, 0xbe200000, 0xd6300000, 0xf8c80000, 0xec640000, 0xdf1e0000, 0xf9770000, 0x1d6f8000, 0x3d99c000, 0x58346000, 0xc9cb5000, 0xaeee8800, 0x6e53a400, 0xe5d9d200, 0x8a1e3b00, 0xe1fbe080, 0x1f229040, 0x1cb2e8e0, 0xad8cf4f0, 0xeac15a38, 0x1b6e9f3c, 0xe89bb256, 0x00b66bfd, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0xf4000000, 0xe2000000, 0x25000000, 0x92800000, 0x62400000, 0x0e200000, 0x02b00000, 0x1cc80000, 0xe26c0000, 0x679a0000, 0x47f50000, 0x15668000, 0x48194000, 0x1b312000, 0x9709d000, 0x5f82e800, 0xa4c04400, 0x5e631200, 0x01969300, 0x78f7a080, 0x7ee090c0, 0xaedbc8a0, 0xb05594d0, 0x2c13fa28, 0xb13fd7f4, 0x36003262, 0xd70643e5, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xe8000000, 0xac000000, 0xd6000000, 0x1f000000, 0x53800000, 0x24c00000, 0x25a00000, 0x3fd00000, 0xf1480000, 0x46640000, 0x2df20000, 0x60570000, 0xb3828000, 0xb4ccc000, 0x1da06000, 0x8bd07000, 0x63497800, 0x2361ec00, 0xb77cca00, 0x08103500, 0xe16ae080, 0x8a78b040, 0xf69b1820, 0x03269cf0, 0xf99732e8, 0x28ad19ac, 0x495e4a56, 0x6f0cf55f, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x18000000, 0x04000000, 0x46000000, 0x5d000000, 0x61800000, 0x2d400000, 0xfd600000, 0x5d300000, 0x96c80000, 0x8f240000, 0xfad20000, 0x0a350000, 0xb04d8000, 0xfce64000, 0x807b6000, 0xa3a15000, 0xce13d800, 0x2e1cf400, 0x9e1f6600, 0x76199b00, 0xba1ee080, 0xe0131040, 0xff12b820, 0x859ca4d0, 0x945b3e18, 0x25f22f04, 0xa8e566c6, 0x9e789b1d, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x68000000, 0x84000000, 0x9a000000, 0xc7000000, 0x4c800000, 0x37400000, 0xd4600000, 0xe5700000, 0x64c80000, 0x83ac0000, 0x78560000, 0x38db0000, 0xe1928000, 0x60fa4000, 0xba08a000, 0x5703f000, 0x748f0800, 0xeb471400, 0xa2665600, 0x3c770f00, 0x754c2080, 0x3f62b0c0, 0xd7f52860, 0x3e8ea430, 0xb449fe68, 0x62efeb84, 0x253b7e1a, 0x9425ab07, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x38000000, 0xc4000000, 0xf6000000, 0x9b000000, 0xf7800000, 0xaa400000, 0x66600000, 0x32900000, 0x42c80000, 0xadac0000, 0x15ba0000, 0x09b50000, 0x8bb78000, 0xaeb24000, 0xee3c6000, 0xb9f93000, 0xdcd3b800, 0x12a90400, 0xa4347600, 0x70fa4100, 0x3651e080, 0x3c6e70c0, 0x639058a0, 0xbc4e74d0, 0x4d61ae38, 0x8d1f75c4, 0xc481ae76, 0xc1cf755b, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xd8000000, 0xf4000000, 0xea000000, 0xbd000000, 0x5b800000, 0xddc00000, 0x4d200000, 0xfd500000, 0xbf480000, 0x396c0000, 0x84ba0000, 0x4eb70000, 0xc3b98000, 0xe0314000, 0x39ffa000, 0x46d75000, 0xf2867800, 0xfc48bc00, 0xa5e66200, 0x37f2dd00, 0x59dc2080, 0x680110c0, 0x4c0858a0, 0x4e02acf0, 0x7f05bad8, 0xca8a31f4, 0x984dba6a, 0xc7e6317d, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xf8000000, 0xec000000, 0xfa000000, 0xeb000000, 0xc2800000, 0x5c400000, 0x37e00000, 0x40f00000, 0xd7e80000, 0x50f40000, 0x7fea0000, 0x34f30000, 0x91e58000, 0xc9fdc000, 0x426a2000, 0xbc337000, 0xeb460800, 0x9766b400, 0x4bbd7600, 0x508ebb00, 0xb3460880, 0x4b66b440, 0x69bd7620, 0x278ebb70, 0x73c60878, 0x1026b4ac, 0x66dd76da, 0xd03ebb9b, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x28000000, 0x9c000000, 0xe6000000, 0x59000000, 0x7c800000, 0x5e400000, 0x35e00000, 0xea300000, 0x01e80000, 0x503c0000, 0x1ee20000, 0x65bd0000, 0x14208000, 0x9214c000, 0x2dfee000, 0x20c95000, 0x00ad2800, 0x3052b400, 0x4e117600, 0xabf19700, 0xc9cd2880, 0x4422b4c0, 0xda1976a0, 0x01fd9710, 0xfec728a8, 0xeda3b45c, 0x36dbf646, 0xaf545749, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0xbc000000, 0x76000000, 0x9d000000, 0x26800000, 0x6f400000, 0x57600000, 0xd6f00000, 0x33680000, 0x2cf40000, 0x906a0000, 0x43710000, 0x2ba98000, 0x2c5ac000, 0x67bee000, 0x1d0b1000, 0x66808800, 0x4f43e400, 0x0766fe00, 0xeefa0b00, 0x8f608880, 0x5af3e440, 0x0d6efe20, 0x65fe0b50, 0x44e288b8, 0x7b36e4fc, 0xb14d7e56, 0x2e65cbcd, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x54000000, 0x26000000, 0x4b000000, 0x05800000, 0x95c00000, 0xc4e00000, 0x2df00000, 0x12e80000, 0x4ef40000, 0x2b6e0000, 0xa1310000, 0x8e8b8000, 0xb0444000, 0x6121e000, 0xe114f000, 0x331fb800, 0x2e14ac00, 0x08947600, 0xc4d03300, 0xbff7b880, 0x6fe0ac40, 0x387a7660, 0xbf213350, 0x8e1c38d8, 0x7894ec14, 0xacd39646, 0xe3f1c31b, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x98000000, 0x34000000, 0x52000000, 0x45000000, 0x63800000, 0x23c00000, 0xdc200000, 0xc8f00000, 0x06280000, 0xd1fc0000, 0x3ba20000, 0xe13f0000, 0x0b0b8000, 0x188c4000, 0xc346a000, 0xbb641000, 0x899a9800, 0x66bd2c00, 0xb2cada00, 0xbdace300, 0xa6329880, 0x25812cc0, 0xc4c8daa0, 0xc2a3e330, 0x8cb11818, 0x33c16cf4, 0xb4247af2, 0xc4f4f375, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x98000000, 0xac000000, 0x32000000, 0x29000000, 0x14800000, 0x02c00000, 0xcde00000, 0xadf00000, 0xb3e80000, 0xa6fc0000, 0xc6620000, 0xf4bb0000, 0x0f4b8000, 0x23a1c000, 0x1ed0a000, 0x09f75000, 0xa5efe800, 0x59fe7c00, 0x8debb600, 0xcdfae300, 0x63e7e880, 0x4ef27cc0, 0xf261b6a0, 0x6abde370, 0x144e6818, 0x1e28bc6c, 0x089a9692, 0xc6db7359, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x98000000, 0xb4000000, 0xde000000, 0x61000000, 0xca800000, 0x63c00000, 0x39200000, 0xc9300000, 0x6b280000, 0x923c0000, 0xa6aa0000, 0x7e750000, 0x70c38000, 0x38ae4000, 0xff766000, 0x0a4c5000, 0x5364c800, 0xea596c00, 0xa973da00, 0x87413f00, 0xd3ecc880, 0xa6956cc0, 0xa3d1da20, 0x53383f90, 0x3c2d4818, 0xa5b22c74, 0x6dee3afe, 0xb79f2ff1, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xb8000000, 0x3c000000, 0x82000000, 0x79000000, 0x1d800000, 0xf6400000, 0x67a00000, 0x8d300000, 0x82a80000, 0x22b40000, 0xc5ee0000, 0xcc950000, 0xb8958000, 0xee9ec000, 0xf199a000, 0x3b1f5000, 0x93d97800, 0x5abbb400, 0xd9ecc200, 0x3e934700, 0x69977880, 0x771eb440, 0xb9d14260, 0xa7b98710, 0x7a60d838, 0x33d4e47c, 0x6abdbae2, 0x11ecf369, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x88000000, 0x34000000, 0xd6000000, 0xe5000000, 0x25800000, 0x89c00000, 0xa2600000, 0x93b00000, 0xe3680000, 0xd8340000, 0x53ae0000, 0xcdd30000, 0xf2d68000, 0x78584000, 0xc31fe000, 0x06301000, 0xc2aab800, 0x5e580c00, 0xee17de00, 0x77b25700, 0xed64b880, 0x913b0c40, 0x6c295e60, 0xcb1e1770, 0x72355808, 0x74a81c74, 0xcb5d66b6, 0x439a5b95, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xa8000000, 0xe4000000, 0x2e000000, 0xc7000000, 0xfe800000, 0x22c00000, 0xfae00000, 0xf2300000, 0x7be80000, 0xcfb40000, 0x79a20000, 0x28910000, 0xc3f88000, 0x49874000, 0x64466000, 0x342d3000, 0x92d28800, 0xc8d29c00, 0x69d0e600, 0x44559f00, 0x4e188880, 0x1d379c40, 0x216a66a0, 0x6373df50, 0x144e6828, 0x8c29eca4, 0x7edc8e8e, 0x52dd7397, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x98000000, 0xd4000000, 0x1e000000, 0xe5000000, 0x6b800000, 0xb9400000, 0x56e00000, 0x33700000, 0xed680000, 0x423c0000, 0x678a0000, 0x93470000, 0x3deb8000, 0x95f64000, 0x73a06000, 0x679f1000, 0xf91d5800, 0xc3dac400, 0x407c5600, 0x5fe8e300, 0xe2f6d880, 0x172c84c0, 0xfe5c3620, 0x0037f3b0, 0xa08b8018, 0x6fc64014, 0x7028603e, 0x72d31055, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xe8000000, 0x0c000000, 0x22000000, 0xa3000000, 0xd0800000, 0x8bc00000, 0x44a00000, 0x13f00000, 0x0c280000, 0xac3c0000, 0x6e860000, 0x22cd0000, 0xdb208000, 0x7ab1c000, 0x8844a000, 0x27e6f000, 0xd8912800, 0x657b8c00, 0xdae3c200, 0xb11b4300, 0x9931a880, 0xfb0a4cc0, 0x048762e0, 0xbdcdb310, 0x31a88068, 0xa67dc0cc, 0xda6aa0c2, 0x32d7f0b3, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x88000000, 0x24000000, 0x5e000000, 0x85000000, 0xb6800000, 0x01c00000, 0xf2200000, 0x42f00000, 0x6aa80000, 0x5e3c0000, 0xa20a0000, 0xb7010000, 0x698a8000, 0xbc4f4000, 0x486d6000, 0x239a1000, 0x85b68800, 0x014c4c00, 0x62ea4a00, 0x205b3300, 0xd0940880, 0x823f0cc0, 0x400d2a20, 0xe00023d0, 0xf0080008, 0x580c00e4, 0xac02007e, 0x7a0d0055, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x98000000, 0x94000000, 0x6e000000, 0xa3000000, 0x96800000, 0x3e400000, 0x56200000, 0x91700000, 0xbba80000, 0xcdbc0000, 0x6dc20000, 0x41eb0000, 0xdd938000, 0xf3b64000, 0xe6cb6000, 0x7b657000, 0x69d28800, 0xf09f5400, 0xd638ca00, 0x060b5300, 0x6f030880, 0xcc8214c0, 0x83402aa0, 0xfba86370, 0xadb2e018, 0xbdc43054, 0xa9e868ce, 0xd19764d3, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x58000000, 0x5c000000, 0x7a000000, 0xcd000000, 0x80800000, 0x5e400000, 0x4ce00000, 0x5b100000, 0x5b680000, 0x58dc0000, 0x31420000, 0x9d610000, 0x5fdf8000, 0x54c0c000, 0x97ae2000, 0x33731000, 0xa83aa800, 0xa058b400, 0x23070600, 0x538cf500, 0x45cf2880, 0xad2574c0, 0x0034a6a0, 0xb45e25d0, 0xfd0420d8, 0x688e109c, 0x2a4728da, 0xe2e9741d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xb8000000, 0x94000000, 0x1a000000, 0x4b000000, 0xa5800000, 0x7bc00000, 0x48600000, 0xd2700000, 0xe4e80000, 0xa33c0000, 0x60c20000, 0x35ed0000, 0x8db18000, 0x1e804000, 0x16462000, 0xafa7f000, 0xbc1af800, 0x4b908c00, 0x27539e00, 0x4cb53b00, 0x88017880, 0xfc01ccc0, 0x96063ea0, 0xd50f8b10, 0x4c842038, 0x014af054, 0x8c2b78ba, 0xaad0cc5b, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x08000000, 0x5c000000, 0x62000000, 0x81000000, 0xed800000, 0x87c00000, 0x6e600000, 0x9e300000, 0x58e80000, 0xf1740000, 0x4aca0000, 0xa9ed0000, 0xe4f28000, 0x2904c000, 0x6182a000, 0xcdcfd000, 0x2361f800, 0x19b0ec00, 0x0225fe00, 0x1093bf00, 0xd2317880, 0x72ed2c40, 0x0c7fde20, 0x5545af90, 0xa728a088, 0x3b12d01c, 0x52fb7842, 0xd6002c11, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xb8000000, 0xec000000, 0x66000000, 0x23000000, 0xab800000, 0xadc00000, 0x1b600000, 0x17100000, 0x09e80000, 0x0c5c0000, 0xabca0000, 0x88690000, 0x74998000, 0xa023c000, 0x2531e000, 0x15d6f000, 0x6f0dd800, 0x5d8d6c00, 0x16c2ce00, 0x0ce34d00, 0x64d65880, 0xdd8bacc0, 0xd6c8ae20, 0x2ce37d50, 0x34d9e038, 0x658af02c, 0x3ac7d846, 0x4ae46c73, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xd8000000, 0x44000000, 0x7e000000, 0x61000000, 0x23800000, 0x7ec00000, 0xf1200000, 0x26500000, 0x1fe80000, 0xcf7c0000, 0x1dbe0000, 0xbe950000, 0x6bcf8000, 0xc4af4000, 0xd59d6000, 0x3f46d000, 0x14e01800, 0x8bf45c00, 0x15f5da00, 0xa4f82100, 0x3f7d7880, 0x15b28cc0, 0x4295c260, 0x41cc7d10, 0x03a8a258, 0xd31aad84, 0x1c00ba9e, 0xfa02f1b1, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xa8000000, 0x7c000000, 0x16000000, 0x6d000000, 0x7b800000, 0x66400000, 0xe3200000, 0x87d00000, 0xf3680000, 0xf9f40000, 0x17320000, 0xa8dd0000, 0xcfec8000, 0x3f38c000, 0x94d8e000, 0x79e69000, 0x42359800, 0x47551400, 0x63a9ba00, 0xb71c3100, 0xad857880, 0xeb478440, 0x28ae22a0, 0x59942510, 0xc4404228, 0x1423753c, 0x9f53ba36, 0x47a5313d, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xb8000000, 0x24000000, 0x0e000000, 0xd1000000, 0x96800000, 0x05c00000, 0x12600000, 0x69b00000, 0x41a80000, 0x3ed40000, 0x689e0000, 0x7fb30000, 0x64a18000, 0x8e5f4000, 0xd05a6000, 0x6957d000, 0xf3da4800, 0x941aec00, 0xc57b3e00, 0xc14e7f00, 0xcca82880, 0xa2593c40, 0x225f7660, 0x625793f0, 0x025a9638, 0xf25c0364, 0x4a533eee, 0x6e5a7f61, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x28000000, 0x4c000000, 0x4a000000, 0xe5000000, 0x7c800000, 0x45400000, 0x8b600000, 0x90500000, 0x7c280000, 0xda340000, 0x76f60000, 0x1c590000, 0x96208000, 0x8f3bc000, 0x72752000, 0x3d111000, 0x1b472800, 0xb0656400, 0x97dc0e00, 0xdeef8900, 0xa39a0880, 0xb7007440, 0xed8d26e0, 0xf7c3ed50, 0x7d2e86a8, 0xe0b03d0c, 0x7cbc0e2a, 0x5ebf89f5, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x28000000, 0xfc000000, 0x0a000000, 0xf9000000, 0x8e800000, 0x6bc00000, 0x2ae00000, 0x9a300000, 0xe4280000, 0x24540000, 0xe4da0000, 0xc8190000, 0x137c8000, 0xe704c000, 0xe1812000, 0x6645d000, 0x4ea00800, 0x8194cc00, 0xc932b600, 0x83a4c700, 0xc91b2880, 0x09f81c40, 0x5ac63e20, 0x6860cb50, 0xa3f2bea8, 0xb3c00bbc, 0xeee19eaa, 0x6438dbe9, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x38000000, 0xb4000000, 0x46000000, 0x4b000000, 0xfc800000, 0x86400000, 0x03a00000, 0xb6700000, 0x52e80000, 0x73540000, 0xc3da0000, 0xd7970000, 0x493d8000, 0xc0ce4000, 0x64eae000, 0x60557000, 0x1b506800, 0x9fdc7400, 0x8d9a6200, 0x78391b00, 0xbd408880, 0xa72e0440, 0x143f8a20, 0x9f4f2fb0, 0x02220ab8, 0x9fb16ff4, 0x2f80eae6, 0x3ec01fbb, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x58000000, 0x9c000000, 0x1e000000, 0x3f000000, 0x83800000, 0x02400000, 0x18e00000, 0x1bd00000, 0xe1280000, 0xad7c0000, 0x04120000, 0x048b0000, 0x8dc38000, 0x0cacc000, 0x083b6000, 0xa377b000, 0xf3141800, 0x130c3400, 0xa5834600, 0xf1492100, 0x2d6cf880, 0xe29744c0, 0xf84c3ea0, 0x95e2a5f0, 0x4153a6d8, 0x33ee515c, 0x7251803e, 0xa667c00f, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xd8000000, 0xfc000000, 0x6a000000, 0xab000000, 0x71800000, 0x0fc00000, 0x83200000, 0x33b00000, 0x95680000, 0x5b5c0000, 0xd3fe0000, 0x0c870000, 0x1f478000, 0x066ac000, 0x26d82000, 0x0e30f000, 0xe8aa7800, 0xef76ec00, 0xcbc89a00, 0xe5265f00, 0x4ab5d880, 0x83ecdcc0, 0x971ac260, 0x08104330, 0xa79f3a58, 0x1d506f3c, 0x3af1808a, 0x9201c05b, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x38000000, 0x2c000000, 0xe6000000, 0xb7000000, 0x59800000, 0xea400000, 0xdf200000, 0x17d00000, 0x4ae80000, 0xb5b40000, 0x6b9e0000, 0xeac10000, 0x5fe18000, 0xe939c000, 0xc558e000, 0x07263000, 0xabdb3800, 0xf4e8b400, 0xfeb99a00, 0xec150100, 0x9b8a5880, 0x3f434440, 0xa3a44260, 0x091a85d0, 0x4f097ab8, 0x5587316c, 0xbc4f6006, 0x802af027, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x68000000, 0x3c000000, 0xd6000000, 0x51000000, 0x1a800000, 0x49c00000, 0xdf200000, 0xead00000, 0xfa680000, 0x5d3c0000, 0x9d1a0000, 0x884f0000, 0x5b688000, 0xcfbac000, 0x78d8e000, 0x59645000, 0xb4b10800, 0xc55dec00, 0xeb20ca00, 0x50d0d900, 0x85696880, 0xf2bf7cc0, 0x4c532220, 0xa5a665b0, 0xf3102ae8, 0xdd4889fc, 0x53e26076, 0xe57d9021, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x58000000, 0x14000000, 0xda000000, 0xf3000000, 0x01800000, 0x7e400000, 0x28600000, 0x55d00000, 0x21a80000, 0x2efc0000, 0x4c9e0000, 0x12490000, 0x966f8000, 0x94da4000, 0x4f2d2000, 0xc737f000, 0x27b2f800, 0x477c7400, 0x6eda2e00, 0xcc2ce100, 0x2eb85880, 0xc5fdc4c0, 0xf913f660, 0x060265d0, 0xc5090ed8, 0x8c8211d4, 0xdecd203a, 0xe8a7f0e3, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xa8000000, 0xcc000000, 0x22000000, 0xb1000000, 0xbe800000, 0xea400000, 0x9de00000, 0xf3100000, 0x48280000, 0x523c0000, 0x609e0000, 0xe6ef0000, 0x90908000, 0xeee9c000, 0x8c9fa000, 0xd4e35000, 0x59920800, 0x84631400, 0x20d2e600, 0x160cdd00, 0x87032880, 0x298684c0, 0xbbcfce60, 0xf22559b0, 0x473c6628, 0x501a1d0c, 0x2fa408c2, 0xaaf014c1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xd8000000, 0x64000000, 0xaa000000, 0xc1000000, 0x47800000, 0x8f400000, 0x94a00000, 0xbb300000, 0x49680000, 0xc55c0000, 0x34b20000, 0xba2d0000, 0x3ffb8000, 0x748d4000, 0xadc22000, 0x566dd000, 0xf1d19800, 0xf97bc400, 0xdc436200, 0x862b9f00, 0x31fa3880, 0xbf8654c0, 0xbb435aa0, 0x46accb90, 0x8e38e258, 0x7ce6dfa4, 0xef18188a, 0x4d9b8491, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x68000000, 0x24000000, 0xa2000000, 0x15000000, 0x4f800000, 0xee400000, 0x0b600000, 0x6d700000, 0xb3a80000, 0x21dc0000, 0x9cf20000, 0x76ef0000, 0x8e308000, 0x1b4b4000, 0x94eba000, 0xfb3f9000, 0x44cf9800, 0xa2af1400, 0xbc5d5e00, 0xafb5eb00, 0xa606b880, 0xc704c4c0, 0x9281e6a0, 0x35c22fb0, 0x2f25dee8, 0x5712abe4, 0x33571882, 0x69385465, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xd8000000, 0xf4000000, 0x16000000, 0xfd000000, 0xc3800000, 0x53400000, 0x8a200000, 0x27b00000, 0x5be80000, 0x17540000, 0x323e0000, 0xd5af0000, 0x0eff8000, 0xaec24000, 0x286be000, 0xdc1b1000, 0x2c191800, 0xd41a0400, 0x701e0a00, 0x8e131700, 0x5f137880, 0x7e9c5440, 0xc6db7260, 0x72744330, 0xc5098a58, 0x478557b4, 0xfd4698f6, 0xb328448d, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x48000000, 0xe4000000, 0xbe000000, 0x51000000, 0xd1800000, 0xb7c00000, 0x1f600000, 0x47500000, 0x16280000, 0xaf7c0000, 0x485e0000, 0xa6ab0000, 0xe13e8000, 0xf4ff4000, 0x08946000, 0x054dd000, 0x222db800, 0x09780c00, 0x25543e00, 0x95273100, 0x15f15880, 0x311d9cc0, 0xc68d6660, 0x3b46adf0, 0xb3223ec8, 0xb8f03124, 0x6291d85e, 0xc249dc61, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xf8000000, 0x9c000000, 0x76000000, 0x0d000000, 0x9f800000, 0xc9c00000, 0x9b200000, 0x98100000, 0x76180000, 0x971c0000, 0xb6960000, 0x865f0000, 0x90f08000, 0x26294000, 0x2f962000, 0x7bdaf000, 0x763d0800, 0xad829400, 0xfec5a600, 0x27ae6700, 0xcf5da680, 0x35726740, 0xcceba620, 0x2a3d67d0, 0x3b8326d8, 0xc3c8274c, 0xd02306ae, 0x629dd741, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xd8000000, 0x34000000, 0xd6000000, 0x8d000000, 0xd3800000, 0xea400000, 0xfd600000, 0xca100000, 0x74180000, 0x85140000, 0x0c920000, 0xd9d70000, 0x743a8000, 0x3ee9c000, 0x585ca000, 0x8d707000, 0x11074800, 0x1982ec00, 0x6d49ba00, 0xc9eddb00, 0x44d1ba80, 0xdfb9dbc0, 0xd0a3bae0, 0xfb3edb90, 0x26613a38, 0x54931ba4, 0x2dd79aee, 0xc2306b29, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x48000000, 0x64000000, 0xfa000000, 0x17000000, 0xdd800000, 0xd0c00000, 0x9ba00000, 0x34f00000, 0xebf80000, 0x92740000, 0xd8b20000, 0xc41b0000, 0x656f8000, 0x3a51c000, 0xc98a6000, 0x32c91000, 0xc0a7c800, 0xe7714400, 0x9e3b3e00, 0xa7591100, 0x1b093e80, 0x738211c0, 0x85c6bee0, 0xed23d150, 0xefb4dea8, 0x299ec134, 0x0da11652, 0x1df48523, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x88000000, 0x44000000, 0xa6000000, 0x6b000000, 0xcd800000, 0x47400000, 0x69e00000, 0x62300000, 0xa1380000, 0x78bc0000, 0x01f20000, 0x3f1d0000, 0xfaa58000, 0x95d9c000, 0x840fa000, 0x060b1000, 0x7b02c800, 0xb58f3c00, 0x8b4a6200, 0x8beae100, 0xaf386280, 0x07b7e140, 0xf27de260, 0x2f5e21b0, 0x34ca42e8, 0x39a931f4, 0x4c5a8a4e, 0xfd4b0d9f, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xe8000000, 0xf4000000, 0x4a000000, 0x51000000, 0xae800000, 0xb5c00000, 0xb5a00000, 0x7a500000, 0x67580000, 0xdfdc0000, 0xe51a0000, 0x35370000, 0xed298000, 0xd09ec000, 0x3f766000, 0x23c17000, 0x7aa89800, 0x7fd44400, 0x1510de00, 0x6d359b00, 0x212ade80, 0x86929b40, 0xd07b5ee0, 0x96405b90, 0x30ef3e08, 0xd13a2b64, 0x6f2c2642, 0xc59baf35, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xf8000000, 0x34000000, 0x76000000, 0x4d000000, 0x88800000, 0x93c00000, 0x9e200000, 0x5fd00000, 0x40d80000, 0x9b540000, 0x511a0000, 0xde710000, 0x7b4e8000, 0x7de5c000, 0xd9fea000, 0x9b0c7000, 0x558bf800, 0xb34f4400, 0x71e0e600, 0x7bf6fb00, 0x1002e680, 0x6803fbc0, 0x9c0e6660, 0x0a033b70, 0xf7044698, 0x878b8b44, 0x20479eee, 0xc8697f09, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x68000000, 0x44000000, 0x32000000, 0x19000000, 0x5d800000, 0x52400000, 0x2b600000, 0x5c100000, 0xd9980000, 0x07dc0000, 0xcab20000, 0xa5a50000, 0x14bb8000, 0x6aa3c000, 0xf232e000, 0x64667000, 0xfa902800, 0x3752cc00, 0x7f7c9a00, 0xf1802b00, 0x64471a80, 0xe063eb40, 0x6895fa60, 0xbe559b30, 0x3afdd208, 0x8fcb5774, 0x392b483a, 0x97727c6d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x28000000, 0xcc000000, 0x4a000000, 0x63000000, 0x6e800000, 0x26400000, 0x3ee00000, 0xa1700000, 0x4bf80000, 0x5bb40000, 0x845a0000, 0x94ad0000, 0xf5978000, 0x198f4000, 0x26c1e000, 0x1da2d000, 0xa81fb800, 0xe94c9c00, 0xaa619200, 0x2c37d500, 0xa7961280, 0xbe8895c0, 0x5e4ff260, 0x4aee45b0, 0x7f724a48, 0x86fbd97c, 0xd03e5802, 0xe59e4c1f, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x98000000, 0x6c000000, 0x16000000, 0x45000000, 0x5a800000, 0x77c00000, 0x93e00000, 0xc9d00000, 0x05580000, 0xf7940000, 0x1ef60000, 0x70eb0000, 0x7e5a8000, 0x2c184000, 0x21b72000, 0xe3cc7000, 0xd9e55800, 0xf2d16400, 0x3ed5fa00, 0x38dd5700, 0xc5d77a80, 0x235117c0, 0xda965aa0, 0x60766710, 0xe5298238, 0xd2bf437c, 0xec4b582e, 0x4cae6439, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xb8000000, 0x54000000, 0xce000000, 0x93000000, 0xa1800000, 0xe3400000, 0x76600000, 0x13b00000, 0xc8380000, 0x66740000, 0xfa920000, 0x2fef0000, 0x04fc8000, 0xc05dc000, 0x8ecb2000, 0x7f211000, 0x30d18800, 0xd50f7c00, 0xce88ba00, 0x00cdd100, 0x4c2c3a80, 0x215411c0, 0x5e4d1ae0, 0x54ee0110, 0x89721258, 0xd913bd44, 0x75ad0896, 0xe612bcd7, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xb8000000, 0x04000000, 0x3e000000, 0x3b000000, 0x2e800000, 0x80400000, 0x05a00000, 0x8df00000, 0x51780000, 0x88340000, 0xb2160000, 0x1c250000, 0x61368000, 0xf592c000, 0x1bef2000, 0x43559000, 0x6a0bf800, 0x6d0e3c00, 0xb980c600, 0x1cc2c900, 0x3cee4680, 0xa7d409c0, 0x774f66a0, 0x492099f0, 0x1cbc1e18, 0xf75d65f4, 0x2c0b7826, 0x7209fccf, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x38000000, 0xac000000, 0xda000000, 0x3b000000, 0x73800000, 0x0a400000, 0xbd600000, 0x95100000, 0x8d980000, 0xac540000, 0x077e0000, 0xdd0f0000, 0x6a848000, 0x4ec24000, 0x0ea5e000, 0x21375000, 0x7a6be800, 0x64958c00, 0xa0ddfa00, 0x90b01b00, 0x37277a80, 0xe87d5bc0, 0xb8861a20, 0x31c84bd0, 0x93281218, 0x767a977c, 0x6d8600c2, 0x1f4b0047, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xf8000000, 0xe4000000, 0x62000000, 0xdf000000, 0x8d800000, 0xfd400000, 0x01600000, 0x2bd00000, 0xe5580000, 0xd3940000, 0xb2b60000, 0x9a830000, 0xdcc48000, 0xf226c000, 0xdbb2e000, 0xe2021000, 0x1f014800, 0xad8edc00, 0xad4fea00, 0xf96a2700, 0xcfdd6a80, 0x875fe7c0, 0x0c930aa0, 0x3f3f3790, 0x67cea258, 0xdda4fb74, 0xd9f2803a, 0x3ee5c0ab, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x98000000, 0xd4000000, 0x6e000000, 0x1f000000, 0x0f800000, 0x4ac00000, 0x3de00000, 0x2b500000, 0x47d80000, 0x709c0000, 0x9ab60000, 0x36870000, 0xf6468000, 0x72afc000, 0xa5732000, 0x0debd000, 0xe35ea800, 0xabd14400, 0xda9b7a00, 0x73babf00, 0xf20bfa80, 0xdd027f40, 0x1a865a20, 0xbc4a6f50, 0x2ba5d2b8, 0xe9fbfb84, 0x6aa880d6, 0x3174c09b, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x28000000, 0x84000000, 0x9a000000, 0xfd000000, 0xd5800000, 0xc5c00000, 0x5b600000, 0x3fb00000, 0x9d380000, 0x98740000, 0x37520000, 0x9c4b0000, 0xb0a18000, 0xdbd5c000, 0xb6026000, 0x2300b000, 0xd2856800, 0x7d4e7400, 0x6329e200, 0x251f0900, 0x63e26280, 0xc7f5c9c0, 0xe79382e0, 0xf6abb950, 0x40d50ac8, 0xc880bdd4, 0x4043e052, 0xd6a57029, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x08000000, 0x24000000, 0xee000000, 0xcb000000, 0x1a800000, 0xdb400000, 0xd5600000, 0xdab00000, 0xf5380000, 0x67f40000, 0x0f5a0000, 0xa9c10000, 0x5a298000, 0x09d7c000, 0x708f2000, 0x6e4c9000, 0x5cefb800, 0x87754c00, 0x39157a00, 0x692aa100, 0x1f5efa80, 0x31c861c0, 0x26225a60, 0x7bd23170, 0x798b4268, 0x75cc2d54, 0xb826a086, 0x58db509f, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x68000000, 0x9c000000, 0x6e000000, 0x9f000000, 0xd3800000, 0x1c400000, 0xcea00000, 0xd7f00000, 0xc9780000, 0xa7bc0000, 0x41da0000, 0x134d0000, 0x45238000, 0x5fbe4000, 0x85d6a000, 0xe94c5000, 0x5829e800, 0x1532ec00, 0x49106600, 0x862e2900, 0xc231e680, 0x16916940, 0xec66c6e0, 0x67927930, 0xe0e00e88, 0xc85f85ac, 0x420ca0e6, 0xb9015033, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xa8000000, 0xbc000000, 0x66000000, 0x3b000000, 0x1b800000, 0x66c00000, 0x74600000, 0x0fb00000, 0x51780000, 0x111c0000, 0xf4aa0000, 0x00d70000, 0x25418000, 0x76a04000, 0x39d12000, 0x47c31000, 0x12eae800, 0x79f9a400, 0xa05bf200, 0x1804e100, 0x040ad280, 0x1207f140, 0xb1003ae0, 0xee8e5510, 0xfa43c848, 0x6f26b4ac, 0x261b1aae, 0x312a45d7, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xf8000000, 0x64000000, 0xa2000000, 0x73000000, 0xca800000, 0x3bc00000, 0x5ca00000, 0x1c700000, 0x33b80000, 0x15140000, 0xce6a0000, 0x5d510000, 0x9c8a8000, 0x02c6c000, 0xa92de000, 0xe3385000, 0x19d63800, 0x2a4a6400, 0xc1e2fe00, 0xa51d8100, 0xf66f1e80, 0xd955d1c0, 0x0e812660, 0x89cbb5f0, 0x07a9d898, 0x7af73494, 0x367446ba, 0xfcb02527, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xf8000000, 0x0c000000, 0xca000000, 0x53000000, 0xef800000, 0x7ac00000, 0xde600000, 0x8b100000, 0xc5d80000, 0x3dbc0000, 0x9fa60000, 0x0eff0000, 0x520c8000, 0xaf0a4000, 0x6d89e000, 0xcdc85000, 0x0fe8e800, 0x64dca400, 0x6d301200, 0x70ebcb00, 0x1159f280, 0x1cf39b40, 0x5d091a20, 0xd2833f50, 0x584708d8, 0xce2bf45c, 0xa1347a92, 0x5aed2f4f, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x48000000, 0x94000000, 0xd6000000, 0xa1000000, 0x65800000, 0x7dc00000, 0x5fe00000, 0xd6b00000, 0x59780000, 0xf9940000, 0x1fa20000, 0xb8990000, 0x8a298000, 0xed52c000, 0x71cea000, 0xa5e13000, 0x1db3a800, 0xeff9d400, 0xded99a00, 0x6d0e1900, 0xff8f3a80, 0x86cb29c0, 0xa16692e0, 0x65fffdf0, 0xfdd488a8, 0x1f8a2464, 0x76c492fe, 0x8966fd05, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x08000000, 0x6c000000, 0x7a000000, 0x77000000, 0x74800000, 0x09c00000, 0xabe00000, 0xff900000, 0x51580000, 0xa6340000, 0x4c6a0000, 0x54db0000, 0x1e7f8000, 0x61cb4000, 0x97e3e000, 0x6d911000, 0xda561800, 0xa0b2e400, 0x5ea60a00, 0xf1be0b00, 0x9f2fea80, 0xeff41bc0, 0xc7867260, 0xdb4dbf50, 0xd7239868, 0xa3f2a43c, 0xcd826a92, 0x34405b8b, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x08000000, 0x7c000000, 0x5a000000, 0x33000000, 0xb8800000, 0x92c00000, 0x2fe00000, 0xafd00000, 0xdc180000, 0x447c0000, 0x3be60000, 0xf9d70000, 0x8d1b8000, 0x2bf24000, 0x3fa4e000, 0x51f65000, 0xdca69800, 0x417bd400, 0xa260ba00, 0x3c9d7f00, 0x42ba5a80, 0x02002f40, 0xa7014220, 0xae8ebbd0, 0x63c69828, 0xd06bd4ac, 0xa398baf2, 0x08317fdf, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xf8000000, 0x1c000000, 0x62000000, 0x77000000, 0xf3800000, 0x93c00000, 0xcb600000, 0x03500000, 0x19980000, 0xf4740000, 0x006a0000, 0xe2d70000, 0xb55c8000, 0x789f4000, 0x16f26000, 0x392f9000, 0xa4f6e800, 0x762c3400, 0xab7bd200, 0xd7ecaf00, 0xef1bb280, 0x3b303fc0, 0x0743da60, 0x73204b90, 0xf7fce898, 0x1bab348c, 0x7dbf527a, 0x6007ef3b, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x48000000, 0xbc000000, 0x02000000, 0xdf000000, 0xb8800000, 0xb1c00000, 0xc8600000, 0x77d00000, 0x8f180000, 0xcefc0000, 0xc5620000, 0xf85b0000, 0xca538000, 0xed524000, 0x51dd6000, 0x06151000, 0xe771d800, 0x49212400, 0x12787200, 0xc2a57700, 0xb13f1280, 0xc8076740, 0xfc074a60, 0xe2030350, 0xcf0bd828, 0xf08624ec, 0x0dc9f2aa, 0xca6c3773, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xa8000000, 0x94000000, 0xde000000, 0x11000000, 0xf1800000, 0xb8c00000, 0x95200000, 0xad700000, 0x94380000, 0x71d40000, 0x4d8e0000, 0x32c50000, 0xfa238000, 0x7df0c000, 0x75762000, 0xc831b000, 0xabdde800, 0x1a888400, 0xee424600, 0xf962c900, 0x9f17e680, 0xada3b9c0, 0xb83c2e20, 0x63da8df0, 0x1e838088, 0xa840c064, 0xd46e20d6, 0x2495b0b5, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x88000000, 0x2c000000, 0x66000000, 0x75000000, 0xe3800000, 0x2fc00000, 0xbaa00000, 0xeed00000, 0xea980000, 0xf3f40000, 0xd1820000, 0x58cd0000, 0x06298000, 0x419d4000, 0x61742000, 0x47c7f000, 0x26a50800, 0x60da9400, 0xc390ee00, 0xfe79fb00, 0xa74d4e80, 0x67e34bc0, 0xb23c66e0, 0xf22e2fb0, 0x53918068, 0xc679409c, 0x634e208e, 0x5deef029, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xb8000000, 0x9c000000, 0xc6000000, 0xb5000000, 0xab800000, 0x79400000, 0x0c600000, 0x78b00000, 0xe2780000, 0xc35c0000, 0x65860000, 0x38470000, 0xe5e88000, 0x7efb4000, 0x8e962000, 0x4022f000, 0x9f538800, 0x438d7c00, 0xbd4b6a00, 0x66689900, 0x23b5ca80, 0xd8f12940, 0x4b906220, 0x63aea5d0, 0x52108098, 0xade7404c, 0x2af020de, 0x5c95f0b9, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xe8000000, 0xc4000000, 0x3e000000, 0x47000000, 0xf4800000, 0x83c00000, 0xdc600000, 0xb5d00000, 0x74980000, 0x38340000, 0x23060000, 0x7a890000, 0x0ccb8000, 0x9ce5c000, 0xe0112000, 0x2bf3d000, 0x476cd800, 0x935d0400, 0x6a57b200, 0x19d32700, 0x4e951280, 0x613137c0, 0xe08eeaa0, 0xe5c6e3b0, 0x97660048, 0xcb590074, 0x665380f6, 0x93d1c0f3, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x28000000, 0x14000000, 0x92000000, 0xbd000000, 0xa0800000, 0x0e400000, 0x94e00000, 0xe6500000, 0x5d980000, 0x33bc0000, 0x7d460000, 0x5f650000, 0x5f938000, 0x56b0c000, 0x41c6e000, 0x672db000, 0xcc79f800, 0xb960bc00, 0x20946200, 0x733daf00, 0x63070280, 0x5385df40, 0x85cb9a20, 0x8d2813f0, 0x5d78e008, 0x07e4b0e4, 0x3dd4781a, 0x7c597c19, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x68000000, 0xb4000000, 0xfa000000, 0xcf000000, 0xb9800000, 0x67c00000, 0x27600000, 0x3d700000, 0xf8380000, 0xeb1c0000, 0x61c60000, 0x16610000, 0x79f38000, 0xad7ac000, 0x803e6000, 0x671e1000, 0xb7c1c800, 0xff669400, 0x41775200, 0x4632bd00, 0xb61cb280, 0xa3476d40, 0x32289a20, 0xf65929b0, 0x0ee66048, 0x22b21004, 0x535fc832, 0x006b948b, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xc8000000, 0xec000000, 0x42000000, 0x1f000000, 0x77800000, 0xe5c00000, 0xe8600000, 0xa9500000, 0x70180000, 0x9c340000, 0x71c20000, 0x1e6f0000, 0xb05f8000, 0xe69f4000, 0x9b726000, 0xf8e91000, 0x8f1da800, 0x7bbf5400, 0x3c04e200, 0x4a062f00, 0x930b0280, 0x658f7fc0, 0x32c34ae0, 0x73e27b90, 0x0e926028, 0x8779107c, 0x42e5a8ea, 0xe41b54a3, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xd8000000, 0xf4000000, 0x2e000000, 0x73000000, 0x1e800000, 0x67400000, 0x9f600000, 0xde700000, 0x7ab80000, 0x2f140000, 0xb7ce0000, 0x3b2b0000, 0xf79a8000, 0x3f87c000, 0xc8cc2000, 0xefa09000, 0xb5d93800, 0xe9652c00, 0x997d2a00, 0xea328500, 0xeb5d8a80, 0xee2ad5c0, 0x761c1220, 0x3c43a910, 0xbdeea0f8, 0x1b3350e4, 0x9cdb1856, 0x6aeebc57, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x28000000, 0xec000000, 0xca000000, 0x51000000, 0x17800000, 0xf1c00000, 0x65200000, 0xc7500000, 0xd2180000, 0xcc740000, 0x524a0000, 0x5aed0000, 0x35738000, 0x69cb4000, 0x812ce000, 0xf1597000, 0x911fc800, 0x4efdf400, 0x920cf600, 0x55049b00, 0xd1819680, 0x9acfabc0, 0x0bab3e60, 0xcd1d6f30, 0x8cff6048, 0x3f0230dc, 0x508b2802, 0xb540844d, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xf8000000, 0x3c000000, 0x4e000000, 0x19000000, 0x56800000, 0x7e400000, 0x65200000, 0xa7500000, 0xe2780000, 0xb52c0000, 0x0f5e0000, 0x36790000, 0x8f288000, 0x9c524000, 0x0bfe2000, 0xf0edf000, 0xc8b6b800, 0xe14cac00, 0xaea44600, 0x5d9e9f00, 0x1e12fe80, 0xc0d23340, 0x5eb6b820, 0x344cacf0, 0xee244658, 0xb6de9f8c, 0x9bb2fe36, 0x3cc23365, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x98000000, 0x34000000, 0xbe000000, 0x59000000, 0xff800000, 0x1fc00000, 0xae600000, 0xb7700000, 0x01180000, 0xc26c0000, 0xdd7e0000, 0xd61b0000, 0x6cec8000, 0x9134c000, 0xedb3a000, 0x92f2f000, 0x81d6a800, 0xce89a400, 0x3c4bea00, 0x93a23900, 0xc21d4280, 0x02eb9d40, 0xf036a820, 0xb639a4d0, 0xab33ea38, 0x42be39a4, 0x387b42a6, 0x7b9c9d2d, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xf8000000, 0xb4000000, 0x12000000, 0x39000000, 0x2d800000, 0x4bc00000, 0xa1e00000, 0xc8f00000, 0xf1180000, 0x3dec0000, 0xd6fe0000, 0xce170000, 0x6b668000, 0x71bac000, 0xbdbd6000, 0x5bb43000, 0xd0b38800, 0x943f0400, 0x0a709200, 0x54501900, 0x2f431a80, 0x2faf1d40, 0xced38820, 0x6e0f0410, 0xd7089258, 0xba8c19e4, 0x51451a6a, 0xa0a41dcd, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x98000000, 0x3c000000, 0xe2000000, 0xbb000000, 0x6c800000, 0x7a400000, 0xa0a00000, 0x70b00000, 0xcc180000, 0xcea40000, 0x71ba0000, 0x479d0000, 0x0a6e8000, 0x88504000, 0xc700e000, 0x2e831000, 0x91413800, 0x642f8c00, 0xaef1be00, 0xb2bbb900, 0xe7108680, 0x6a2435c0, 0x9ff938e0, 0xa13b8cf0, 0x1fd3bef8, 0x71c2b90c, 0xa46406fa, 0xe9597547, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x74000000, 0x72000000, 0x8b000000, 0x7f800000, 0x31400000, 0x43200000, 0x88700000, 0x49580000, 0x722c0000, 0x38f20000, 0x6d9f0000, 0x874b8000, 0xe223c000, 0x10f76000, 0x79901000, 0xe5428800, 0x01268c00, 0x1b7fb600, 0x3adc7d00, 0x2d653e80, 0xf6d6f140, 0x636888e0, 0x0bd58c50, 0x9de63608, 0xd210bd64, 0x9601de9a, 0xd10921bf, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x58000000, 0x1c000000, 0x6a000000, 0xff000000, 0xe9800000, 0x02400000, 0x5ea00000, 0xc5f00000, 0x04580000, 0x38240000, 0xb63e0000, 0x64b50000, 0x397e8000, 0xd0924000, 0xad4e6000, 0xdf2dd000, 0xa3b82800, 0xdcfb5c00, 0x30dcde00, 0xb8e9bd00, 0xdd5af680, 0x2ca7e1c0, 0xc6f8a8a0, 0x57dc1c30, 0x6d6c3e78, 0x45162dec, 0xd50cbeb2, 0xf6816d23, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xa8000000, 0x34000000, 0x12000000, 0xbd000000, 0xb3800000, 0x50c00000, 0x06200000, 0x14d00000, 0xd7f80000, 0xbca40000, 0x259a0000, 0x5c110000, 0xedd18000, 0x1e7bc000, 0x056f6000, 0x72357000, 0x0d082800, 0xbb85d400, 0xf4c05e00, 0x4c2ca700, 0x35d27680, 0x427873c0, 0x4363a8e0, 0x2d3f1430, 0xab86bec8, 0x6cc617c4, 0xb02f3e3a, 0xe3d9d749, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x38000000, 0x94000000, 0x2a000000, 0x77000000, 0xc8800000, 0x27400000, 0xcf600000, 0x42d00000, 0x0eb80000, 0xdee40000, 0x58120000, 0xa51d0000, 0x8a9c8000, 0x0d50c000, 0xf97ae000, 0xf2c75000, 0x77a83800, 0x32739c00, 0x2c429200, 0xf1e74300, 0x7498aa80, 0x7059dfc0, 0x16feb860, 0x950a5c70, 0x338ef2d8, 0x01c9d324, 0x3d24f292, 0x9e30d323, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x88000000, 0x84000000, 0xe6000000, 0xe5000000, 0x4a800000, 0x25c00000, 0xfd600000, 0x11700000, 0xb5180000, 0xe4ec0000, 0x233e0000, 0x8b350000, 0x3f338000, 0xf136c000, 0xe0372000, 0xc4b9b000, 0x807b3800, 0xd1995400, 0x002c7a00, 0x02d39900, 0xd2894280, 0xb9cfcd40, 0xc76eb820, 0x6e769430, 0xf096da28, 0x0ca9e9f4, 0xb216daee, 0xed69e921, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x28000000, 0xc4000000, 0x9a000000, 0x9b000000, 0xbf800000, 0x60400000, 0xf8200000, 0x3b100000, 0xe2380000, 0x4dac0000, 0xf85e0000, 0x199d0000, 0x90f18000, 0x0f48c000, 0x15a4e000, 0x54579000, 0xe79b8800, 0x61f69c00, 0x03c3d600, 0x0e66db00, 0x563e5e80, 0xbfa14740, 0x07520820, 0xcc125cb0, 0x43b93688, 0x8cec4b34, 0xd4f45632, 0xd54f1b1f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x38000000, 0xdc000000, 0xaa000000, 0x29000000, 0xb2800000, 0x83c00000, 0xd6600000, 0x65300000, 0x80580000, 0x86e40000, 0x0bf20000, 0x42b50000, 0xeb148000, 0x22444000, 0xe6266000, 0xb616b000, 0xceccf800, 0xd2ebf400, 0x85feaa00, 0xfdb32d00, 0xea985280, 0x0209d9c0, 0xdd007860, 0x2c8bb4f0, 0xd4cacad8, 0x03e09dec, 0x0b782a12, 0xe4726d35, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xa8000000, 0xb4000000, 0xe6000000, 0x15000000, 0x63800000, 0xf1c00000, 0xc5a00000, 0xedf00000, 0x6b580000, 0x682c0000, 0xfd320000, 0x4b7f0000, 0x71178000, 0x984bc000, 0x8b662000, 0xc4d2b000, 0x43efa800, 0x0f928400, 0x8e093600, 0x810e8d00, 0xf58c9e80, 0x5ccf0940, 0xba2028e0, 0x4e354450, 0x5dfd16c8, 0xf3533da4, 0x042cb6ce, 0x173a4de1, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xa8000000, 0x9c000000, 0xea000000, 0xbf000000, 0x54800000, 0x12400000, 0x33a00000, 0xd5900000, 0x47380000, 0x2f2c0000, 0x6bd20000, 0x56990000, 0xa9b18000, 0x3a694000, 0x48f26000, 0x4f46d000, 0x142ef800, 0xc15f8c00, 0x9dd18e00, 0x4398fb00, 0x22357680, 0x0ca27740, 0xc11f78e0, 0x3576cc30, 0x6c83eec8, 0x164e2bec, 0x8da38ec2, 0x6c91fb63, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x08000000, 0x7c000000, 0x72000000, 0xc3000000, 0x73800000, 0x50400000, 0x2de00000, 0x40300000, 0xfe580000, 0x5e2c0000, 0x75960000, 0xcf870000, 0x42498000, 0x1ee54000, 0xebbde000, 0xda139000, 0x7dc0c800, 0x84a31c00, 0x8154ea00, 0x3fa46500, 0x16dda280, 0x49e23940, 0x2634a8a0, 0xc355cc90, 0x44a9c228, 0xe154e9ac, 0xcfa980fa, 0xced540ff, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x58000000, 0x74000000, 0x5e000000, 0xa1000000, 0x23800000, 0x68c00000, 0xd7200000, 0x1b500000, 0xdbf80000, 0xd6640000, 0xabb20000, 0x2d050000, 0x198a8000, 0x1fccc000, 0x49a1a000, 0x221a7000, 0xef176800, 0xc6955400, 0x815bee00, 0xbcf7ff00, 0xc0e60680, 0x8efe6bc0, 0x6be44860, 0x8277e4f0, 0xe9a726b8, 0x3219db44, 0x67120086, 0xda950015, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x58000000, 0x24000000, 0x56000000, 0x41000000, 0x4e800000, 0x00400000, 0xe7600000, 0x33700000, 0x0c980000, 0xdeac0000, 0xabda0000, 0x2e450000, 0x12628000, 0xa3f9c000, 0x01dc2000, 0x5d48f000, 0xabe8b800, 0x9c3c8c00, 0xf074e200, 0xad126900, 0x2566da80, 0x3c7b2540, 0xc7141860, 0xf664bc70, 0x55f8fab8, 0x90dad514, 0x7bc4208e, 0xd7a4f025, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xa8000000, 0x3c000000, 0x3e000000, 0x65000000, 0x92800000, 0x4ac00000, 0x0fe00000, 0x52900000, 0xd9f80000, 0xd8ac0000, 0x82360000, 0x77cf0000, 0x196b8000, 0x925b4000, 0xe11d2000, 0xebb33000, 0xda82b800, 0x46cd6400, 0xe9ef8200, 0xf390bf00, 0xe17eba80, 0xf56a9b40, 0x445a18a0, 0x98161410, 0x17359a88, 0x5d46ab6c, 0xe7ab2016, 0xcfbc3019, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xd8000000, 0x04000000, 0x16000000, 0xe5000000, 0x78800000, 0xb0400000, 0x05600000, 0x5c300000, 0x3fd80000, 0x4aac0000, 0xea9a0000, 0x77470000, 0xe6e88000, 0x5df3c000, 0x28782000, 0x8cbeb000, 0x039b9800, 0x65ceec00, 0x51a38200, 0x1b10dd00, 0x85889a80, 0x6cc1f140, 0x53293860, 0x74589c50, 0xc76aba38, 0xd7384114, 0x565a204e, 0x5c65b0a1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x28000000, 0x3c000000, 0x92000000, 0xb7000000, 0x60800000, 0x0dc00000, 0xa8200000, 0x03100000, 0x2db80000, 0xea640000, 0xe2720000, 0xfd470000, 0x4def8000, 0x773f4000, 0xaca3e000, 0x58dcd000, 0x5498b800, 0x80faf400, 0xaf89ae00, 0x594c7b00, 0xfbe69680, 0xb63dcfc0, 0xed26d860, 0x049e64d0, 0x88fd76c8, 0x63851f2c, 0xf34c603a, 0x58e3904b, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x98000000, 0x0c000000, 0x6e000000, 0x15000000, 0x54800000, 0xa5c00000, 0xd1600000, 0x08900000, 0x78780000, 0x71a40000, 0x857a0000, 0x112d0000, 0x12b68000, 0x13474000, 0xcfa92000, 0xf8783000, 0xb1afd800, 0xe57c7400, 0x2128da00, 0x8ab13700, 0x1f4b8280, 0xa1a703c0, 0xed7cf8e0, 0xe52944f0, 0x40b182f8, 0xf04a033c, 0x822a7876, 0x673e04d9, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x38000000, 0x54000000, 0x8a000000, 0x43000000, 0xba800000, 0xf1400000, 0x9f200000, 0x8e700000, 0xb8d80000, 0x056c0000, 0xa7d60000, 0xe9e70000, 0x039a8000, 0xb94cc000, 0x6324e000, 0x487d1000, 0xf5dfd800, 0x4ee39c00, 0xfb119600, 0xb7051d00, 0xa082ce80, 0xaa4d4140, 0xa1ad38a0, 0xcd398c90, 0x30f4ce18, 0xbb9a4184, 0xad4fb832, 0xc9294c57, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xa8000000, 0x5c000000, 0x22000000, 0x2b000000, 0xaa800000, 0xd3400000, 0x3a200000, 0xd1b00000, 0xf0d80000, 0x774c0000, 0x3c2a0000, 0xbcb90000, 0xd7558000, 0xf3834000, 0x2acde000, 0x27e99000, 0x9ed59800, 0xe640dc00, 0xa9ad7600, 0xcb702900, 0x9f350e80, 0xc5996540, 0x506de060, 0x62199030, 0x94ad9848, 0x94fcdc2c, 0x7fff768a, 0x75752977, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xc8000000, 0x14000000, 0xa2000000, 0x65000000, 0x74800000, 0x22c00000, 0x2ce00000, 0x80900000, 0x96b80000, 0x26c40000, 0x26e60000, 0x019f0000, 0xd8318000, 0xbd09c000, 0xc88d6000, 0x64c37000, 0x73e89800, 0x4d18a400, 0x76f38200, 0xefe2b700, 0x9b167a80, 0x41f963c0, 0x666d6020, 0x11537090, 0xf9d09868, 0x0d1ca444, 0x16f5826a, 0x1fedb771, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x78000000, 0x9c000000, 0x6e000000, 0x03000000, 0xeb800000, 0xbf400000, 0x8ee00000, 0xf6500000, 0x4bf80000, 0xb54c0000, 0x3fe20000, 0x10dd0000, 0xac348000, 0x17624000, 0x641d2000, 0x4d93d000, 0xa7de0800, 0x3db10c00, 0x412d3a00, 0x407fdb00, 0xfa0e1280, 0xa90d0740, 0xca8520e0, 0xf1cfd0f0, 0x3d240818, 0xde700c2c, 0xe103ba16, 0x6e8c9b9f, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x48000000, 0xe4000000, 0xa2000000, 0x4f000000, 0x6b800000, 0x6c400000, 0x29a00000, 0xf0f00000, 0x77180000, 0x514c0000, 0x152a0000, 0x4b310000, 0xccf38000, 0xc916c000, 0xf0466000, 0x87abd000, 0xe9f7c800, 0x499dbc00, 0xb588be00, 0x7d470500, 0x13211680, 0x463d6940, 0x18746060, 0x86d6d0b0, 0x51ae48a8, 0xfcfa7c14, 0x211d5eea, 0x044a15ab, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x98000000, 0xb4000000, 0xa6000000, 0x1f000000, 0x68800000, 0x5ac00000, 0x57a00000, 0x51700000, 0xe2180000, 0x0fcc0000, 0xd22e0000, 0x2a3f0000, 0x50f48000, 0x175ec000, 0x7e272000, 0x78309000, 0x49f9f800, 0x30d8e400, 0xd46e7600, 0xc15bbd00, 0xe928ae80, 0x9cbfc940, 0x51312020, 0x46739010, 0x469b7838, 0xb70524e4, 0xf48bd63e, 0x20c6edab, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x08000000, 0x34000000, 0x6e000000, 0xa3000000, 0xd9800000, 0xc9c00000, 0x23e00000, 0x7ef00000, 0x6ed80000, 0x8ec40000, 0x5c620000, 0xc03b0000, 0xaabd8000, 0x92f7c000, 0xfcdfa000, 0x97c3d000, 0x18e02800, 0x7b79c400, 0xad168200, 0x682ec100, 0x6c110a80, 0xd0a0d5c0, 0x6d5da060, 0x4a08d090, 0xe505a8e8, 0xfe8a0464, 0x264b2266, 0x75261197, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x18000000, 0x0c000000, 0x22000000, 0xc5000000, 0x13800000, 0x2a400000, 0x3d200000, 0x6e900000, 0x0ff80000, 0x17440000, 0x92aa0000, 0x1ed10000, 0x8bde8000, 0x50554000, 0x7e10e000, 0x053b7000, 0x98a9e800, 0x6fdfdc00, 0xa65b1600, 0xf5190b00, 0x81ba1e80, 0x7c69a7c0, 0x673ae0e0, 0xfdaa70b0, 0x6c576878, 0xe41a9c7c, 0xdc33f63a, 0xc1267bc9, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xe8000000, 0xac000000, 0xae000000, 0xa1000000, 0x90800000, 0x54c00000, 0x9a200000, 0x93100000, 0x0cf80000, 0x0d4c0000, 0xb2620000, 0x93f30000, 0xf4c38000, 0xea204000, 0x4b162000, 0x18fdf000, 0xe7419800, 0x11648400, 0x0c750e00, 0x91890300, 0xb440b680, 0x16e37740, 0x1d37a0e0, 0x75eeb010, 0xa2b43888, 0x20a934fc, 0x44dab646, 0x395c770d, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xa8000000, 0x24000000, 0x9a000000, 0x01000000, 0xe2800000, 0x29c00000, 0xcd600000, 0x8b300000, 0x90980000, 0x0f440000, 0x2eaa0000, 0x8f5f0000, 0x4d2b8000, 0x8414c000, 0xc985e000, 0x524cb000, 0x7a22b800, 0xe997f400, 0xc1c56a00, 0x496a3500, 0xe1303280, 0xa99a71c0, 0x61ce60e0, 0xb9687050, 0xd93f58c8, 0x259f44b4, 0xdfcdd232, 0x2262c125, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x78000000, 0x1c000000, 0x86000000, 0x21000000, 0x60800000, 0x3c400000, 0x80e00000, 0x92300000, 0xb6180000, 0xc48c0000, 0x064a0000, 0xd7ef0000, 0xbbb68000, 0x8ede4000, 0xe225a000, 0xb3907000, 0xb2431800, 0x95e74c00, 0xf0b38a00, 0x21518d00, 0xfbe3b280, 0xf5b8f140, 0x3bd68060, 0x70ae4050, 0x4cdda098, 0xe92c700c, 0xfc1118fe, 0xbb844c3d, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x08000000, 0xfc000000, 0x5a000000, 0x41000000, 0x84800000, 0xa5400000, 0x6a200000, 0x7bb00000, 0xc8580000, 0x68840000, 0x874e0000, 0xff290000, 0xe93b8000, 0x7e174000, 0x3b2e6000, 0x873fb000, 0xb91d5800, 0x14ad9c00, 0xeffdb600, 0x0efa7900, 0xfa750e80, 0x773f15c0, 0x511b80a0, 0x78a74070, 0x0df66028, 0xbbfbb04c, 0xd8f35852, 0xc9749cbd, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x98000000, 0xc4000000, 0x06000000, 0x0b000000, 0x4f800000, 0x35400000, 0x52600000, 0xb1700000, 0x3dd80000, 0xdd840000, 0x604e0000, 0xf2ef0000, 0x1db48000, 0xc9fdc000, 0xb5182000, 0xdfa6d000, 0x4bd74800, 0x5e892c00, 0x53c2b200, 0xd5a99100, 0xdad95a80, 0xf80badc0, 0xf40c80a0, 0x6e09c010, 0x870e20b8, 0x158dd014, 0xfc4dc89e, 0x10ebeccf, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x48000000, 0x74000000, 0x36000000, 0xe3000000, 0x7e800000, 0x70400000, 0xaf600000, 0xd6300000, 0xfd980000, 0x95840000, 0x1ac60000, 0xf9210000, 0x625f8000, 0x692bc000, 0x5a582000, 0xf52f5000, 0xa85ed800, 0x68266c00, 0x41ddb200, 0x50e27500, 0x7dfcca80, 0x573489c0, 0x26198020, 0x904ac070, 0x7f67a0e8, 0x8e3490c4, 0x719ef87e, 0x9f8d3c97, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0x0c000000, 0x9a000000, 0x8f000000, 0x8a800000, 0xc2c00000, 0xbb600000, 0x1db00000, 0xc9980000, 0x530c0000, 0x08820000, 0x31c70000, 0x83e28000, 0x64734000, 0x6e716000, 0x997d5000, 0x7ffa5800, 0x373f8400, 0x3b5f1a00, 0xa0622d00, 0x3134a280, 0x5654b940, 0xc9e200e0, 0xf3770050, 0x98fa8058, 0xe9bf401c, 0x7f9360a2, 0x360a5083, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x58000000, 0x5c000000, 0xae000000, 0x83000000, 0xc4800000, 0xd4400000, 0x18200000, 0xc7500000, 0xd8b80000, 0xdd0c0000, 0x0f860000, 0x34c70000, 0x6e608000, 0xaa704000, 0x04672000, 0xbb76d000, 0x9dee7800, 0x20b00c00, 0x91034600, 0xd9893700, 0xbbcc9e80, 0x5ce8ab40, 0xa13e00a0, 0x76cb0010, 0x2b668078, 0x99f7400c, 0xeea7a0f6, 0x5e1690df, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x18000000, 0x0c000000, 0xb2000000, 0x09000000, 0xe0800000, 0x3cc00000, 0xbba00000, 0x6cb00000, 0x86580000, 0x5b040000, 0x39860000, 0xd4410000, 0x236a8000, 0x71114000, 0x5de3e000, 0x86d7b000, 0xb7cc9800, 0x8a2ac400, 0x1cf3f600, 0x033eb100, 0x9d100e80, 0x3fe385c0, 0x87de0020, 0xf3450070, 0x10ec80b8, 0x105040bc, 0x340960aa, 0xce06f005, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xe8000000, 0x74000000, 0xe2000000, 0x0f000000, 0x20800000, 0x98c00000, 0x10e00000, 0xe6700000, 0xb3d80000, 0xda040000, 0x730e0000, 0x068b0000, 0x0dc78000, 0xa369c000, 0xc8396000, 0xd6f6d000, 0x0316f800, 0x9eed8400, 0xe77f8200, 0x5252e900, 0x83419a80, 0xaaaf7dc0, 0xd15800a0, 0x1dc40050, 0x8b6e00c8, 0x9c3b00e4, 0xa4ff800a, 0xe41dc07b, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xa8000000, 0x4c000000, 0x4e000000, 0x97000000, 0xc5800000, 0x7d400000, 0xa7600000, 0x3bf00000, 0x55280000, 0xf8040000, 0x84020000, 0xb2010000, 0xe1048000, 0xb6854000, 0xbac26000, 0x03227000, 0xce14b800, 0xd61e2c00, 0x770fea00, 0xe0933b00, 0x58dadf80, 0xfe2b2940, 0x2b800020, 0x3a400010, 0xeae00008, 0x9ab00024, 0x1448002a, 0x18f40013, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x38000000, 0x8c000000, 0x5a000000, 0x21000000, 0x3b800000, 0x38400000, 0xcbe00000, 0x69f00000, 0x2d980000, 0x2c040000, 0x6a060000, 0xe9070000, 0x9f808000, 0xd641c000, 0x3ce46000, 0x2972d000, 0x0f590800, 0xe425dc00, 0xf057c200, 0x66895f00, 0xf7efcf80, 0xbddaacc0, 0x93e00020, 0x35f00030, 0xaf980038, 0x91040004, 0x3386000e, 0x7c470023, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xc8000000, 0xdc000000, 0x4a000000, 0x4f000000, 0x53800000, 0xe2c00000, 0x86600000, 0x10f00000, 0x7ed80000, 0xb4040000, 0xe6020000, 0xed010000, 0xf0818000, 0x33464000, 0xf7a6e000, 0x8f125000, 0xc3ea7800, 0x1f3e9c00, 0xa0311600, 0xf3bf3300, 0xb9740780, 0x5b1e36c0, 0x9de00020, 0x6e300010, 0x92b80008, 0xdbf4000c, 0x035a0032, 0x67c50037, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0x34000000, 0x6a000000, 0xa5000000, 0xda800000, 0x10c00000, 0xd5200000, 0xc6900000, 0xfcf80000, 0x02040000, 0xf1060000, 0xc0850000, 0x4dc68000, 0x13a14000, 0x8851a000, 0xe6db5000, 0xbb112800, 0xc7b8d400, 0x07618600, 0xaf762900, 0xe94a7480, 0x3b6cc7c0, 0x06780020, 0x02c40030, 0xac260028, 0xe2150034, 0xf33e800a, 0x80a5400d, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xd8000000, 0xe4000000, 0xbe000000, 0x37000000, 0xdd800000, 0x3d400000, 0xf3200000, 0x6bd00000, 0x3c480000, 0xba040000, 0x99060000, 0x52830000, 0xd4c68000, 0xa866c000, 0x4bf72000, 0x341df000, 0x8c0db800, 0x0da4ec00, 0x9d14ea00, 0x492a1900, 0xad771e80, 0x46de0240, 0x97680020, 0xf5d40030, 0x7b4e0018, 0x0f870034, 0x48408036, 0x23a5c039, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x28000000, 0x84000000, 0xda000000, 0x23000000, 0x31800000, 0xcec00000, 0x2aa00000, 0x96100000, 0x4b580000, 0xae040000, 0xa1060000, 0x0e810000, 0x19448000, 0xb1614000, 0xf0342000, 0xdb0ed000, 0x13bd1800, 0x4cf38c00, 0x96a97600, 0x4e28d500, 0x7a6b7080, 0x0b8c3ac0, 0x33f80020, 0xcf140030, 0x09de0008, 0x59450024, 0x5162800a, 0x40304021, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x38000000, 0x84000000, 0x56000000, 0x27000000, 0x2b800000, 0xc7c00000, 0x4f600000, 0xd9900000, 0xdfb80000, 0x77040000, 0xf3820000, 0x73c50000, 0xb1648000, 0x4291c000, 0x263c2000, 0xc1c6b000, 0xb0633800, 0x46145c00, 0xe67abe00, 0xa367bb00, 0xd390ec80, 0x1ab94dc0, 0x85820020, 0x84c50010, 0x02e48028, 0x9151c024, 0x075c200e, 0xbb56b021, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xf8000000, 0x3c000000, 0x5a000000, 0x1b000000, 0xa8800000, 0x1c400000, 0x7b600000, 0x81100000, 0x4f080000, 0xab040000, 0x80860000, 0xf8410000, 0x0d608000, 0x3817c000, 0xc089e000, 0x45c6d000, 0xfca6d800, 0xaab44400, 0xdf386200, 0xa7781b00, 0x6a1fe880, 0x720ba840, 0xa2860020, 0x1f410030, 0xdfe08008, 0x2f57c004, 0xeb69e03e, 0xe496d00f, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x28000000, 0x3c000000, 0xd2000000, 0x7b000000, 0xef800000, 0x48400000, 0xc9200000, 0x88100000, 0x90a80000, 0xa3040000, 0x8b820000, 0xbe450000, 0xe4248000, 0xda914000, 0xa269e000, 0x64e29000, 0x1671d800, 0xc81a7c00, 0xdefac200, 0x23890900, 0x2c16a080, 0x86a99540, 0xbe020020, 0x61050010, 0x98848028, 0xcdc14024, 0xee61e00a, 0x40b6900f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xf8000000, 0xbc000000, 0xc2000000, 0x57000000, 0xc0800000, 0x30c00000, 0x82200000, 0x28b00000, 0x66380000, 0xcb040000, 0x72860000, 0x3fc50000, 0x4ea58000, 0x2277c000, 0x0f1de000, 0xe1321000, 0x737cb800, 0xb6670400, 0x24520600, 0xf9aed100, 0xa20d2580, 0xd7f8e1c0, 0x88a60020, 0x6b750030, 0x4a9d8028, 0x0e73c02c, 0x451be03e, 0x5237102f, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x88000000, 0x0c000000, 0xca000000, 0x37000000, 0x2b800000, 0x9d400000, 0xd2e00000, 0x56b00000, 0x55c80000, 0xeb040000, 0x39820000, 0x3e430000, 0xc7638000, 0xb2f44000, 0x5da86000, 0xf6725000, 0x3f6bb800, 0xe7d65c00, 0xb23d6a00, 0xb62dd700, 0x4b375580, 0xfd89be40, 0x49620020, 0x63f30010, 0x9b2b8018, 0x8fb0401c, 0xdf4a6022, 0x38c15003, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x38000000, 0x54000000, 0x12000000, 0xed000000, 0x9c800000, 0x89400000, 0x8a600000, 0x07500000, 0xc1380000, 0x91040000, 0x82860000, 0xd2450000, 0x81e28000, 0x9391c000, 0x189aa000, 0x6a749000, 0xbf096800, 0x90ede400, 0x507cca00, 0xdf629300, 0x0fd31a80, 0xfa78d9c0, 0xa6660020, 0x21550030, 0xce3a8028, 0x8885c014, 0xfb44a00e, 0x97659015, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x48000000, 0x14000000, 0x6e000000, 0xc9000000, 0xf3800000, 0xd4c00000, 0x89e00000, 0xbb100000, 0x7eb80000, 0xe5040000, 0x11820000, 0x4fc30000, 0x59648000, 0x73524000, 0x0d18a000, 0x9eb77000, 0x400c4800, 0x15089c00, 0xbc8c2600, 0x3f4b0f00, 0x542cf880, 0x947b45c0, 0xcde20020, 0xbd130010, 0x53bc8018, 0xa0864024, 0x5042a012, 0x4fa07005, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xf8000000, 0x4c000000, 0x76000000, 0x07000000, 0xb5800000, 0x5f400000, 0x91e00000, 0x80900000, 0xb2980000, 0xb1040000, 0x52820000, 0xdac50000, 0xa6a48000, 0xa577c000, 0x080a6000, 0x729fb000, 0x51063800, 0x6282ac00, 0xb2c37a00, 0x12a7cf00, 0x9f71a480, 0x790c44c0, 0xc01a0020, 0xbbc10010, 0xac268028, 0xa3b2c024, 0x20aee03e, 0x9ce87013, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xb8000000, 0xfc000000, 0x26000000, 0xe3000000, 0xc1800000, 0xcec00000, 0x3ce00000, 0x41900000, 0xe9780000, 0xb5040000, 0x5a860000, 0x93430000, 0x24278000, 0x2675c000, 0x956fe000, 0xb4bd3000, 0x30651800, 0x49d30c00, 0x90daf600, 0x8bb7a700, 0xa80e2c80, 0x5bee9bc0, 0x15fe0020, 0x05470030, 0xdf218018, 0x8bf6c03c, 0x35a8602e, 0x2f58f03f, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xb8000000, 0x64000000, 0x7a000000, 0xf5000000, 0xb5800000, 0xd7c00000, 0x78600000, 0xdff00000, 0xca580000, 0x6b040000, 0xfa860000, 0xb7410000, 0x4a228000, 0xc855c000, 0x09cb2000, 0x04afd000, 0xaedda800, 0x9346ac00, 0xd0233e00, 0x4d558300, 0x544a9f80, 0x0f6f62c0, 0xc8be0020, 0xc3b50030, 0x5afc8008, 0x4410c014, 0x016fa02e, 0x1fbb1019, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x28000000, 0x6c000000, 0xa2000000, 0x55000000, 0x89800000, 0x0c400000, 0x1d600000, 0xcdb00000, 0x25580000, 0x73040000, 0xf2820000, 0xc2c50000, 0xf5a08000, 0x11114000, 0x37cb6000, 0x71891000, 0xb5eca800, 0xe3df4c00, 0xa7c3e200, 0x04262b00, 0xf951cd80, 0xf4ae9ac0, 0x633a0020, 0x20310010, 0xb71a8028, 0x11604004, 0x9fb1e00a, 0xe859501b, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xb8000000, 0xd4000000, 0xaa000000, 0x6b000000, 0xff800000, 0xc2c00000, 0x9e200000, 0x44500000, 0xf5980000, 0xaf840000, 0x4ac20000, 0x52250000, 0x4a538000, 0x8c9dc000, 0xef02a000, 0xdd875000, 0x65c65800, 0x6fa47c00, 0xff93d600, 0x2b3a5100, 0x7c937280, 0x88bef4c0, 0xd8538020, 0x739dc010, 0x1a82a028, 0x0447501c, 0xbc66582e, 0x3d347c35, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x48000000, 0x54000000, 0x96000000, 0xdb000000, 0x1d800000, 0x79400000, 0xd9600000, 0xf0500000, 0x22a80000, 0xb5840000, 0xfd460000, 0x67630000, 0x6f508000, 0xe12a4000, 0x43c6a000, 0xafa2b000, 0x3575d800, 0x89186c00, 0xddbd8a00, 0x454e6b00, 0x8d123280, 0x85ca4d40, 0xbad08020, 0x0c6a4030, 0x6ca6a018, 0x94f2b004, 0x425dd812, 0x11dc6c15, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x68000000, 0xa4000000, 0x26000000, 0x8f000000, 0x92800000, 0x61c00000, 0xfce00000, 0x6ff00000, 0x89780000, 0xa6840000, 0xefc60000, 0x77e50000, 0xcb708000, 0x0fbb4000, 0x6ce12000, 0xc7f73000, 0x8d797800, 0x90801400, 0x08c64e00, 0x4167c700, 0x8cb2cf80, 0x7c5b73c0, 0x91908020, 0x2f4b4030, 0xd7192028, 0x10b33004, 0xf65f781a, 0x2c951429, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xa8000000, 0x34000000, 0x2a000000, 0xc3000000, 0x6b800000, 0x67400000, 0x41600000, 0x83300000, 0x49280000, 0x0f840000, 0x35460000, 0x0e670000, 0xaeb78000, 0x5b6d4000, 0xf865a000, 0x53b75000, 0xc9e91800, 0x6fa0dc00, 0x82107a00, 0x72fcab00, 0x0ddec980, 0xef0b1140, 0x0dd78020, 0x1f5d4030, 0xb8cda038, 0x3c73503c, 0x544f182a, 0x72b7dc0d, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xe8000000, 0xcc000000, 0x5e000000, 0x39000000, 0x43800000, 0x8fc00000, 0x75e00000, 0x68900000, 0x10e80000, 0x97840000, 0x95c20000, 0xcee10000, 0x94118000, 0xc1af4000, 0xbc226000, 0x6070f000, 0xb9f8c800, 0xb7af9c00, 0x29253e00, 0x6df6cf00, 0xd7393480, 0xa5cb8f40, 0x5c718020, 0x6fff4010, 0x52aa6008, 0xeca4f00c, 0xff32c83a, 0x735a9c33, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x48000000, 0x34000000, 0xe2000000, 0xaf000000, 0xdf800000, 0x1cc00000, 0x52200000, 0xfed00000, 0xbaa80000, 0x7d840000, 0xd3c60000, 0x3da50000, 0xba108000, 0x948a4000, 0x5555a000, 0x24691000, 0x30a47800, 0xaa907c00, 0xe7cfa600, 0x43b7b100, 0xf49ca680, 0xa2d80d40, 0x20b88020, 0x390e4030, 0x6e93a028, 0x3dcc1004, 0x20b4f812, 0xa51a3c0d, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x88000000, 0xa4000000, 0x4a000000, 0x5f000000, 0x94800000, 0x90c00000, 0x71e00000, 0x89f00000, 0x4a980000, 0x9a840000, 0x55c20000, 0xa2610000, 0x11b58000, 0xcdbc4000, 0xd3912000, 0x17285000, 0x293ff800, 0xab572400, 0x52cbc600, 0xd2ce2f00, 0x92c9df80, 0xb2ceccc0, 0x02cd8020, 0x8ac84010, 0x2ecb2008, 0x64cd502c, 0x3bc87822, 0xaf4a6429, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xb8000000, 0x2c000000, 0x2e000000, 0xe7000000, 0x2e800000, 0xa6c00000, 0x58e00000, 0x61b00000, 0xf8c80000, 0x5c840000, 0xb7c60000, 0x2d650000, 0x4ff18000, 0x75edc000, 0x49556000, 0x417f7000, 0x184e3800, 0x4d42f400, 0xe9a3f600, 0x4e172700, 0x55de3d80, 0xadd85e40, 0xe1d98020, 0x5fd9c030, 0x30db6028, 0x8a5e700c, 0x2e99b82e, 0xbf7a340b, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x88000000, 0xec000000, 0x1a000000, 0xb5000000, 0x46800000, 0xf7c00000, 0xe3200000, 0x1c900000, 0x35780000, 0x88840000, 0x7cc20000, 0x06a70000, 0x32d18000, 0x5a1c4000, 0x2a736000, 0x5bcad000, 0xf1eea800, 0xa9fdb400, 0x6a42fe00, 0x0964f900, 0x55f2f480, 0x808ea3c0, 0x38098020, 0xccc84010, 0x26696038, 0x0eb9d00c, 0xe1a52822, 0x8d52f43b, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xf8000000, 0xec000000, 0xa2000000, 0xcd000000, 0x7a800000, 0x86400000, 0x83200000, 0x3e500000, 0x38b80000, 0x67840000, 0xc4c60000, 0x89630000, 0x4f728000, 0x33efc000, 0xc9bb6000, 0x87071000, 0x03836800, 0x82c25400, 0xc2617200, 0x1ef4b900, 0xb42b8280, 0x355ebdc0, 0xa9b48020, 0xb78cc030, 0x9c49e018, 0x62a8d014, 0xb118083e, 0xd795443b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x88000000, 0x34000000, 0x12000000, 0x4f000000, 0x08800000, 0x2e400000, 0x00a00000, 0x8a300000, 0xc3b80000, 0x6f840000, 0x62c60000, 0x04e70000, 0x29928000, 0xef0c4000, 0xeb7da000, 0x58629000, 0x85d37800, 0xc8adc400, 0x0dcbb200, 0x2f9fe500, 0x91f06180, 0x3adf75c0, 0xabd48020, 0x61ab4030, 0xb84f2038, 0x165ed014, 0x3f96d822, 0xaa0b540d, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x38000000, 0xd4000000, 0x7a000000, 0x91000000, 0x06800000, 0x47400000, 0x96600000, 0x3b300000, 0x5ba80000, 0x1f840000, 0xbdc60000, 0xa7270000, 0x42568000, 0xb519c000, 0x40eaa000, 0x0fe1d000, 0x61f58800, 0x1509b400, 0xcf117a00, 0x9a7dd300, 0x715fa980, 0x6d090540, 0x3b108020, 0xd07ec030, 0x085c2038, 0x87881034, 0xd257280e, 0xad1c6435, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xf8000000, 0x4c000000, 0x8a000000, 0xd9000000, 0x17800000, 0x6e400000, 0xeca00000, 0x2a100000, 0x8b180000, 0x6a840000, 0xd7c20000, 0xb5e70000, 0x06318000, 0x3fcfc000, 0x6bfe6000, 0x51325000, 0x8f4bc800, 0xed3a3c00, 0xa7533200, 0x113fc500, 0x9555e080, 0x643a80c0, 0x38d38020, 0x2b78c010, 0x8ff7e038, 0xe529900c, 0x314fa83e, 0xb23b6c13, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xc8000000, 0x24000000, 0x2e000000, 0xe1000000, 0xc0800000, 0x9d400000, 0x4b600000, 0xea300000, 0x84880000, 0x8f840000, 0xfcc20000, 0x36a10000, 0x2c108000, 0xedde4000, 0xc53d2000, 0xd9cf7000, 0xa4e00800, 0x26f58400, 0x6a2b2a00, 0x4f91bb00, 0x1b1b4180, 0x3c9e7c40, 0xd45a8020, 0x14fb4010, 0x35efa008, 0x12b03004, 0x85cda832, 0x36e4b409, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x28000000, 0x94000000, 0x3e000000, 0xed000000, 0xd7800000, 0x13c00000, 0xbe200000, 0x1cb00000, 0x4ed80000, 0x64840000, 0x59460000, 0xe2610000, 0x9d548000, 0x6e494000, 0x71e8a000, 0x779bf000, 0xf6e46800, 0x5c153c00, 0xa02c5e00, 0x6eb89100, 0x5ed6f580, 0x838f4ec0, 0x02ca8020, 0x2cac4030, 0x83fa2008, 0x12b3b024, 0xdbd8480a, 0x2f078c25, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0xac000000, 0xd2000000, 0xb3000000, 0x02800000, 0x38400000, 0x63e00000, 0x6f100000, 0x98e80000, 0x33840000, 0x31c60000, 0x5d270000, 0x7ab18000, 0xbd1a4000, 0xd9f96000, 0x726c9000, 0xb7c09800, 0x18209400, 0x55350200, 0xd6ddbf00, 0x7bdec880, 0xe858af40, 0xc99f8020, 0x0cb94030, 0xa20ee038, 0x2911d00c, 0x3de87812, 0x2c06442b, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xe8000000, 0xb4000000, 0x3a000000, 0x9f000000, 0x85800000, 0x3dc00000, 0x38e00000, 0x34f00000, 0x7a280000, 0x78840000, 0x4b420000, 0x96a30000, 0xd8d08000, 0x0abf4000, 0x9f19a000, 0x6c4fd000, 0x8e31f800, 0xcb4dac00, 0x77b12e00, 0x0889a700, 0x12559780, 0x7af9d940, 0x5e3a8020, 0xa2584010, 0x03eb2018, 0xc2639004, 0xdcb0d83a, 0xf7093c2d, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xc8000000, 0x54000000, 0xf2000000, 0x39000000, 0xe9800000, 0x44c00000, 0x59e00000, 0x5f100000, 0xe4b80000, 0xb6840000, 0x46420000, 0xdda30000, 0x13b38000, 0x3a8e4000, 0xf2cea000, 0x80699000, 0x195cc800, 0x9391cc00, 0xaffee600, 0x00a2af00, 0xe0300880, 0x034e9dc0, 0x08a98020, 0x3eb94010, 0xeb872018, 0xf5c0d01c, 0x8463e832, 0x99d51c15, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x58000000, 0x8c000000, 0xee000000, 0x7b000000, 0x28800000, 0xf4c00000, 0x94600000, 0xe2700000, 0x86280000, 0xe9840000, 0x05460000, 0xfd210000, 0xe1518000, 0x747ac000, 0x61786000, 0xf2fd7000, 0x0eb8d800, 0x5e1bc400, 0x700fe600, 0x98508300, 0x19f84380, 0x8e3ab940, 0x5edf8020, 0xb66fc030, 0xb727e008, 0x4052b00c, 0x55ff3816, 0x40397423, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0x64000000, 0xf2000000, 0xeb000000, 0x0c800000, 0x79c00000, 0x6d200000, 0x6fb00000, 0x3dc80000, 0xb9840000, 0x10420000, 0x35610000, 0x66d38000, 0xbd1bc000, 0x659f2000, 0xf6599000, 0x44785800, 0xdd4ce400, 0x6e448e00, 0x20630900, 0x3f568d80, 0xbd5a4640, 0x78f98020, 0xfc8ec010, 0x1766a008, 0xc5d7501c, 0x8d9ef81e, 0xfa5bb419, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x18000000, 0x1c000000, 0x22000000, 0x87000000, 0xac800000, 0x58400000, 0x2fe00000, 0xfab00000, 0x50680000, 0x70440000, 0x6be20000, 0xe4b10000, 0x456d8000, 0x43c4c000, 0x8322e000, 0xb1101000, 0x1739b800, 0x4599a400, 0xfb4c2200, 0x85576f00, 0x62dd6d80, 0xb42fa740, 0x8da2e020, 0x2e501010, 0xb459b808, 0x5769a42c, 0x9cc42206, 0x13a36f07, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xd8000000, 0x34000000, 0xc2000000, 0x7b000000, 0x20800000, 0xa8c00000, 0x76e00000, 0x50500000, 0xccf80000, 0xfcc40000, 0x84e60000, 0x13570000, 0x287f8000, 0x4e02c000, 0xbd07a000, 0xa1811000, 0x37445800, 0xe4a7c400, 0xc174e600, 0x08cda700, 0xb3ad5a80, 0xe2bd63c0, 0x93e7a020, 0x05d11030, 0xd9bc5838, 0x9363c43c, 0xbd12e636, 0x875aa70d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x38000000, 0x04000000, 0x8e000000, 0x13000000, 0xa2800000, 0xbf400000, 0x2a200000, 0x4ad00000, 0x54480000, 0x23440000, 0xb0260000, 0x3fd70000, 0xe9c98000, 0x8c85c000, 0xbc462000, 0x60a37000, 0xf9911800, 0xcc6cd400, 0xf091da00, 0xdbeb2100, 0x1251ce80, 0x6e083640, 0x6ce62020, 0x61337030, 0xd1f91838, 0x82f8d40c, 0x007fda0e, 0x6f382101, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xf8000000, 0x94000000, 0x16000000, 0x47000000, 0x54800000, 0x46c00000, 0x0a600000, 0xed900000, 0xdd580000, 0x1ac40000, 0xa0660000, 0x70950000, 0x5cd88000, 0xa183c000, 0x6b42a000, 0x9325b000, 0x67b2b800, 0xd56d6400, 0xa7ea9600, 0x8e2ae300, 0x1cca5480, 0x259bcec0, 0x5ba2a020, 0x2b75b030, 0x520ab828, 0x33f96404, 0x7c34963e, 0xdb2be325, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x88000000, 0x74000000, 0xa6000000, 0x41000000, 0x89800000, 0xa9c00000, 0xdaa00000, 0xfa700000, 0xf2280000, 0xcfc40000, 0xbba20000, 0xe3f30000, 0x23ef8000, 0xe9604000, 0x93d1a000, 0xf6de3000, 0x24a98800, 0x72860c00, 0x0347ee00, 0xf5e76500, 0xc5961b80, 0xdcbc3d40, 0x81f9a020, 0x891a3010, 0x770b8818, 0x15750c3c, 0x0ea86e22, 0x2987251d, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xa8000000, 0x2c000000, 0x52000000, 0x5f000000, 0x76800000, 0x5a400000, 0xe3600000, 0xadf00000, 0x4a780000, 0x70440000, 0x18620000, 0xd5730000, 0xa5388000, 0x3ea14000, 0xe7536000, 0x2b299000, 0xb26e7800, 0xed88f400, 0xb13eb200, 0xa8a00b00, 0xa6535780, 0x40ae47c0, 0x69ab6020, 0x0e2d9010, 0xf7ec7818, 0xf34bf404, 0x471e322a, 0x38b54b0b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xe8000000, 0xe4000000, 0xde000000, 0xbb000000, 0xe8800000, 0x24400000, 0x4ba00000, 0x7c300000, 0xfd680000, 0xc2440000, 0x8ca60000, 0xa6b70000, 0xe82d8000, 0xec634000, 0x63512000, 0x02b9f000, 0x82bc5800, 0x42ba0400, 0xa2bb0200, 0x12bc2d00, 0xfab9f980, 0x1eb84f40, 0xc0b92020, 0x7bbdf030, 0x933a5838, 0xb77d042c, 0xfcde823a, 0x80eb6d39, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0x3c000000, 0x6e000000, 0x53000000, 0xb2800000, 0xfa400000, 0x50600000, 0x5ed00000, 0xcc080000, 0x80440000, 0x89620000, 0x8d530000, 0x89c98000, 0x53e0c000, 0xf313e000, 0xdba87000, 0x98371800, 0x7a9b5400, 0x41293200, 0x86767300, 0x18fdae80, 0x12fc9440, 0x33fbe020, 0xec7c7010, 0x5fbd1818, 0xe31c540c, 0x45eab226, 0xba51b30f, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xe8000000, 0x8c000000, 0x92000000, 0x17000000, 0x26800000, 0x9ac00000, 0xbe600000, 0x6bd00000, 0xfe880000, 0x5cc40000, 0xef660000, 0xdc510000, 0xf3ca8000, 0xbfe34000, 0x8f926000, 0xce2d9000, 0x2f763800, 0x9b387400, 0x519db600, 0x7929e300, 0x99f7a680, 0xc9ff2040, 0x33fa6020, 0x68f99030, 0xfc783808, 0x21bd7414, 0x5159363a, 0x2c4fa323, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x98000000, 0x5c000000, 0x0e000000, 0xc5000000, 0xe0800000, 0x54400000, 0x59a00000, 0xb6900000, 0x09d80000, 0x41440000, 0x61220000, 0x1ed50000, 0x0e7a8000, 0xaad0c000, 0xd478e000, 0x05d17000, 0xf3fea800, 0xe212c400, 0x8798c200, 0xb7e77d00, 0xf031fc80, 0xf0cefac0, 0x3b5ae020, 0x9e047010, 0xbd042828, 0x4c820414, 0x92402226, 0x58a60d17, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x38000000, 0xfc000000, 0xea000000, 0x61000000, 0x30800000, 0xcb400000, 0xf0a00000, 0xb0100000, 0x31580000, 0x72440000, 0xcc260000, 0x99550000, 0xf4fc8000, 0xdcd5c000, 0x4139e000, 0xa0365000, 0x12098800, 0x7fb94400, 0x4c773a00, 0xc12a1500, 0x396ce880, 0xa4481ec0, 0xa59fe020, 0x5e235030, 0x64550828, 0x1e7c8424, 0xde96da0e, 0x4518453f, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xf8000000, 0x1c000000, 0x32000000, 0xeb000000, 0x73800000, 0x21400000, 0x7de00000, 0x55b00000, 0x30880000, 0x42440000, 0x8a620000, 0xcaf10000, 0xdc6d8000, 0x6b73c000, 0xc62ae000, 0x0d149000, 0xe6d8d800, 0x96795c00, 0x342a6a00, 0x8612bf00, 0x055b9580, 0xff3cc840, 0xadc8e020, 0xfda59010, 0xecd55808, 0x25fa9c2c, 0x75688a3e, 0x6bf22f07, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x98000000, 0x1c000000, 0x5e000000, 0xab000000, 0x85800000, 0x3cc00000, 0xa6600000, 0x23700000, 0xbc880000, 0xd3c40000, 0xc1e20000, 0x5ab70000, 0xfc6a8000, 0xcdf0c000, 0xa5cae000, 0xf961f000, 0x8cf5d800, 0x414fec00, 0xd1278600, 0x2ad10300, 0x101ba380, 0xe6fdb840, 0x27c8e020, 0xac66f010, 0x12775838, 0x300b2c14, 0xcf876626, 0xedc3f307, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x38000000, 0xc4000000, 0x6e000000, 0x59000000, 0x36800000, 0xb7c00000, 0xb5e00000, 0xc7900000, 0xc2f80000, 0x62c40000, 0xe1620000, 0x0b550000, 0x9a988000, 0xef15c000, 0xe43c2000, 0xada27000, 0x13304800, 0xb74d7400, 0xfa4f1e00, 0x7ac91f00, 0xe009d480, 0x256f53c0, 0xf03e2020, 0x1ba77010, 0x3e30c828, 0xc7ccb404, 0xe8893e0e, 0x53aa6f31, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0xf4000000, 0x12000000, 0x67000000, 0x01800000, 0xe8400000, 0xb9200000, 0xb6f00000, 0x5c680000, 0x4d440000, 0xe7a20000, 0x83310000, 0x9b0b8000, 0x3f944000, 0x9fbda000, 0x69dd9000, 0x078eb800, 0x55574c00, 0x85586200, 0x654b9900, 0xbbb4ef80, 0x9bce9f40, 0xbe77a020, 0x74a89010, 0x48a73808, 0x16b20c1c, 0x314e4202, 0x99b2493d, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x88000000, 0x54000000, 0x96000000, 0x31000000, 0x7f800000, 0xfec00000, 0x91200000, 0x85500000, 0x24c80000, 0xbdc40000, 0xf1a20000, 0x99150000, 0xaeae8000, 0x2c704000, 0x4d98a000, 0xa30db000, 0xe7610800, 0x6c30bc00, 0x45fed600, 0x35bef900, 0xc5dd4280, 0x5f6fca40, 0x37d2a020, 0xf78cb010, 0x5d258828, 0x2f51fc34, 0xa7caf622, 0x3d460915, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x68000000, 0x3c000000, 0x52000000, 0xf7000000, 0x69800000, 0x66400000, 0x91600000, 0x20b00000, 0x52580000, 0xf7440000, 0xb1e60000, 0xf2710000, 0x5ff98000, 0x4f574000, 0xad2fe000, 0x2a3f9000, 0x93743800, 0x377f0c00, 0x91965200, 0x9a8adb00, 0x59291d80, 0xb4392ec0, 0x7e71e020, 0xa5fa9030, 0xa453b808, 0xa6ad4c0c, 0xd37e321a, 0x57970b0f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xa8000000, 0xec000000, 0xb6000000, 0x95000000, 0xef800000, 0x61c00000, 0x55200000, 0x90700000, 0xc3480000, 0x36c40000, 0xfda60000, 0x41370000, 0xe32b8000, 0xacd14000, 0x2ff96000, 0x332eb000, 0x54d52800, 0xfbfb3c00, 0xb12cee00, 0x33d3d900, 0xdb7b0b80, 0x1c6b3640, 0x7db76020, 0x906db030, 0x7bb0a838, 0x4d697c1c, 0x08300e2a, 0x32af293b, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xd8000000, 0xd4000000, 0x2a000000, 0xd3000000, 0x62800000, 0xcbc00000, 0x59e00000, 0x64500000, 0x07f80000, 0x89440000, 0x62220000, 0x45b50000, 0x07ad8000, 0x7cbac000, 0xec60a000, 0x6f165000, 0x5ade1800, 0x40745400, 0x3f4c3e00, 0xdd6c3f00, 0xd8df6a80, 0x7f7073c0, 0xb3cd2020, 0x87ac9010, 0x3cbeb828, 0x4c62042c, 0xdf122636, 0x82d86b35, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x48000000, 0x84000000, 0x76000000, 0x03000000, 0xa1800000, 0x00400000, 0x0ca00000, 0x46f00000, 0xfd480000, 0x85c40000, 0x6ae20000, 0x51530000, 0xe6398000, 0xc2ce4000, 0x12822000, 0xa9c2b000, 0xe8e29800, 0x0c56cc00, 0xf0be6200, 0x5d0bf500, 0x99679f80, 0x3413fe40, 0x501ba020, 0xd9fcf010, 0x5928b818, 0x97507c0c, 0xed3efa12, 0x874e3921, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xe8000000, 0x14000000, 0x22000000, 0x8d000000, 0x19800000, 0xf7c00000, 0x69200000, 0x14700000, 0x78980000, 0xaa440000, 0xf4e60000, 0x94530000, 0xaf688000, 0x541b4000, 0x1802a000, 0x2c041000, 0xbe07e800, 0xab070c00, 0x5e805e00, 0x7742f900, 0xa565db80, 0x079760c0, 0x1c4a2020, 0x316f5030, 0x4f1d4818, 0xde871c04, 0xb741b63a, 0xc566f505, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0x4c000000, 0x2e000000, 0x59000000, 0x57800000, 0x2b400000, 0x14a00000, 0xb4100000, 0x3ac80000, 0x32c40000, 0xd6e60000, 0xdf310000, 0xe19a8000, 0x26aec000, 0x6b306000, 0x139e7000, 0x29ad4800, 0x79b0fc00, 0x195efa00, 0x034c3500, 0xa0845880, 0xe5c60240, 0x4862e020, 0xdbf4b030, 0xc27b2808, 0xf01f8c14, 0xf0e93216, 0x62120913, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x68000000, 0xcc000000, 0xae000000, 0x27000000, 0xf7800000, 0x98c00000, 0xa7a00000, 0x5fb00000, 0xdba80000, 0x09440000, 0x64620000, 0xe9910000, 0x07df8000, 0x44cf4000, 0x41506000, 0xa87e7000, 0x077bb800, 0xacfd7c00, 0x223ee600, 0xf69ead00, 0x54ad7580, 0x52c5f940, 0x82a7e020, 0xf1353010, 0x0be9d808, 0x65a20c3c, 0x66b2de1a, 0x43289133, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x68000000, 0xdc000000, 0x96000000, 0xb9000000, 0x1c800000, 0x0f400000, 0xefa00000, 0x80300000, 0xba680000, 0xddc40000, 0xade20000, 0x59130000, 0xaa1d8000, 0x458f4000, 0x3fd0e000, 0x387db000, 0xf85f4800, 0x64a82400, 0x4ba0da00, 0x3231ad00, 0xf168b980, 0xea44df40, 0x25256020, 0x5676f010, 0xf94da818, 0x3ab6942c, 0x242a121a, 0x92e2c937, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x38000000, 0xd4000000, 0x16000000, 0xd9000000, 0x6a800000, 0xe9400000, 0x73200000, 0xe1700000, 0xa1b80000, 0x71c40000, 0xdd620000, 0x3dd50000, 0x690a8000, 0x691dc000, 0x4f70a000, 0xecbfb000, 0xad454800, 0xbd221400, 0x1c752a00, 0xb53f0900, 0xad84b380, 0x06c431c0, 0xfae22020, 0x08167010, 0x7a6fe828, 0xa9cca414, 0x32f8e20e, 0x59e5dd35, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x88000000, 0xd4000000, 0xce000000, 0xfb000000, 0xb8800000, 0xc3400000, 0xa4e00000, 0xe8500000, 0x8ab80000, 0x69c40000, 0x46a60000, 0xa1330000, 0xb22a8000, 0xb4584000, 0x7494a000, 0xef9b7000, 0xe3325800, 0x1b2d0400, 0x8ddbfa00, 0x6a557700, 0x43bfaa80, 0x004569c0, 0xd0662020, 0xd9173030, 0x9f58f818, 0x84117414, 0x98dd2222, 0xd9d73335, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x08000000, 0x9c000000, 0x32000000, 0xeb000000, 0xa0800000, 0xc1400000, 0x1f600000, 0xc2700000, 0xc7e80000, 0x37c40000, 0x83260000, 0x90950000, 0xf15e8000, 0x5f8c4000, 0x7f36e000, 0x5a8a9000, 0x66b0d800, 0xa04dc400, 0xc013aa00, 0x281d0b00, 0x74e99b80, 0xc3440340, 0x4c606020, 0x86f2d030, 0x70a83828, 0x65a65434, 0xa4d3f202, 0xefbd8f27, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xf8000000, 0x14000000, 0x32000000, 0x1d000000, 0xa2800000, 0x60400000, 0xa4200000, 0x07f00000, 0x93080000, 0xffc40000, 0xf6e20000, 0xeb970000, 0xecd98000, 0xb53bc000, 0xa12ea000, 0x6f309000, 0x2e6c6800, 0xd4905400, 0x3b5fe200, 0x4bf8d100, 0x8b4e6780, 0x0fe63440, 0x23152020, 0x559c5010, 0x499b4838, 0x379b040c, 0xdc9d2a3e, 0x99181505, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x78000000, 0x6c000000, 0x1e000000, 0x55000000, 0x77800000, 0x3cc00000, 0xcc200000, 0xd9100000, 0x51e80000, 0xce440000, 0x4f620000, 0x9df50000, 0xc6df8000, 0x75bfc000, 0x9e4d6000, 0x4993f000, 0xb1aa2800, 0x4c26fc00, 0x9914c600, 0xf1eb3100, 0x3e447080, 0x3762ab40, 0xf1f0e020, 0xd8d93010, 0x20b8c828, 0xe9cacc3c, 0x75538e1e, 0x7d8e3d1b, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x48000000, 0x4c000000, 0xe2000000, 0x0d000000, 0x44800000, 0x29400000, 0x03200000, 0xb8d00000, 0xebe80000, 0xc8c40000, 0xd2e60000, 0x58b30000, 0x21198000, 0x757e4000, 0x99886000, 0xe7361000, 0x37dce800, 0xa09ee400, 0x94baea00, 0x31ee2900, 0x61c05e80, 0x6864c340, 0xe6f7e020, 0x6fbb5030, 0x0e6d0818, 0xb706b40c, 0xdd866212, 0xdbc2dd13, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x58000000, 0x54000000, 0x06000000, 0x61000000, 0xd0800000, 0x2dc00000, 0x96a00000, 0x59d00000, 0x07b80000, 0x88440000, 0x8de60000, 0x93b10000, 0x70498000, 0xf7eec000, 0xc6b8a000, 0xa8c33000, 0xd8258800, 0x6114c400, 0x77988e00, 0xc550e500, 0x987d5680, 0x69e081c0, 0x0db72020, 0x654cf030, 0x116ca808, 0xd27d340c, 0xbae3a616, 0xaa361115, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x88000000, 0x54000000, 0xfa000000, 0x37000000, 0x21800000, 0x60c00000, 0x30200000, 0x91300000, 0x1bb80000, 0x92440000, 0x43620000, 0x42d70000, 0x51298000, 0xc7084000, 0x8f3ca000, 0x9806d000, 0x4c053800, 0xf603cc00, 0x21046600, 0x3080b100, 0xd8404180, 0xbc67b9c0, 0xd7572020, 0xfbe99010, 0x48281838, 0x6b895c0c, 0x197ffe22, 0xd962ad15, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xe8000000, 0x2c000000, 0xce000000, 0xdf000000, 0x74800000, 0xa0400000, 0x10a00000, 0x19f00000, 0x28880000, 0x4fc40000, 0xe6660000, 0x18150000, 0xda5a8000, 0x427b4000, 0x1dcb6000, 0x76e17000, 0xca577800, 0x93fb6400, 0x8c0da200, 0xc782d500, 0x7ac22780, 0x9fe5e840, 0xc5d7e020, 0x553f3030, 0x95ee9828, 0xa1555414, 0x7d7fba3a, 0x5949c10b, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x08000000, 0x24000000, 0x0a000000, 0xbd000000, 0x75800000, 0xfbc00000, 0xaa600000, 0xf9100000, 0x1bc80000, 0x3f440000, 0x1a260000, 0xc7b30000, 0x1c3d8000, 0x75dc4000, 0xfc0b2000, 0x73215000, 0x10356800, 0xaefd6c00, 0x183f3e00, 0x6fde6300, 0x990a5080, 0x9aa24a40, 0xcdf0a020, 0x979e1030, 0x23abc818, 0x47547c2c, 0x826f7602, 0x28355f09, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xb8000000, 0x4c000000, 0x26000000, 0xb7000000, 0x86800000, 0x64c00000, 0xcd600000, 0xde700000, 0xa2280000, 0x71440000, 0xdd260000, 0xdad70000, 0x8ebc8000, 0xac59c000, 0x4b686000, 0x90643000, 0x09f03800, 0x176a7400, 0xce640600, 0x12f6fb00, 0x27ef1b80, 0xa5a52d40, 0x1512e020, 0xbb5af030, 0x7decd838, 0x3ca38424, 0xa0925e2e, 0x1b1bbf13, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xe8000000, 0xb4000000, 0x22000000, 0x45000000, 0xed800000, 0x25400000, 0xa1600000, 0xa8100000, 0xee480000, 0x9bc40000, 0xcea60000, 0x64b70000, 0x1ff98000, 0xb1bb4000, 0x065fa000, 0x558c1000, 0x8566a800, 0x7210ac00, 0x274d4a00, 0x38437b00, 0xd0e29880, 0xfb518640, 0x18282020, 0x73545030, 0x5c2e8838, 0x5954fc0c, 0x9d2bc23a, 0x7ed3872d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xd8000000, 0x94000000, 0x52000000, 0x49000000, 0x7e800000, 0xfa400000, 0x35e00000, 0x45700000, 0xf6780000, 0x5bc40000, 0x82260000, 0x11570000, 0xf4298000, 0xe46ac000, 0xfc8ea000, 0xad7f9000, 0x4c46c800, 0xd6e5b400, 0x36f33200, 0xc8b8df00, 0x91649380, 0x4a363fc0, 0x43192020, 0x5bf65030, 0xfc3fe838, 0x5623e40c, 0x6354da36, 0x6d2f3b25, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x18000000, 0x1c000000, 0xae000000, 0x8f000000, 0x90800000, 0x7bc00000, 0x4ee00000, 0xbc300000, 0xc0380000, 0x1e440000, 0xc0a20000, 0xc4970000, 0xa8aa8000, 0x50ecc000, 0x1b4ee000, 0xfd5c7000, 0x0f37f800, 0x0ebbc400, 0x42827e00, 0x4ac7a700, 0xa963c980, 0x1b71edc0, 0x431e6020, 0x7f93b010, 0x82299838, 0xee287414, 0xa82be606, 0x932fd307, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x28000000, 0xb4000000, 0x22000000, 0xa7000000, 0x0b800000, 0xf3c00000, 0x64200000, 0x7b700000, 0xd5880000, 0x74240000, 0x33720000, 0x91890000, 0xae228000, 0x08734000, 0x0c0ca000, 0xd8e39000, 0xc0d67800, 0x8f3cfc00, 0x9a8c0e00, 0xaba15900, 0x12b52780, 0xaaafa240, 0x42d67820, 0xb83cfc10, 0x990c0e08, 0x3c615934, 0x7c95278a, 0xc2dfa26d, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x38000000, 0x54000000, 0x4e000000, 0x17000000, 0x6a800000, 0x6b400000, 0xa2a00000, 0x80b00000, 0x06280000, 0xdaa40000, 0x34b60000, 0xd8290000, 0x45a18000, 0x3237c000, 0xa96ba000, 0xbe03f000, 0xcf077800, 0xae80f400, 0xad44aa00, 0xd9a46d00, 0xf035f180, 0x34691b40, 0x05877820, 0xb5c0f430, 0x17e4aa08, 0xbd146d2c, 0x801df18e, 0xadcd1b55, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x18000000, 0xe4000000, 0xf2000000, 0x85000000, 0x0e800000, 0xb1c00000, 0xf5200000, 0x9c100000, 0x05e80000, 0x3d240000, 0x30160000, 0x9beb0000, 0x46238000, 0xb596c000, 0xb7ac2000, 0x7b441000, 0xe6e2e800, 0x64345400, 0x9b7d9e00, 0x870f4100, 0x6b11b480, 0x4e6f3140, 0xe262e820, 0x84f45430, 0xeadd9e18, 0x3bdf413c, 0x7f59b486, 0x3f9b3179, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0xdc000000, 0xe6000000, 0x89000000, 0x74800000, 0xa8400000, 0x7b200000, 0xb2100000, 0xb8b80000, 0x47240000, 0x44120000, 0x09bb0000, 0xbfa68000, 0x5250c000, 0x279de000, 0x9f31b000, 0xcbac8800, 0x6f1a4400, 0xc176f200, 0x018c5100, 0x258d5480, 0x6f89f7c0, 0x688c8820, 0x410a4410, 0xffcef218, 0x9fa85114, 0x4d1f5496, 0x1272f7f7, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xe8000000, 0xb4000000, 0x02000000, 0xf1000000, 0xa4800000, 0x50c00000, 0x73a00000, 0xb0500000, 0x68180000, 0xb7a40000, 0x1a520000, 0xcd1f0000, 0xe1238000, 0x53954000, 0xae3aa000, 0x03b39000, 0xb92ac800, 0x0d4b8400, 0x213b1600, 0xb0325500, 0x466f8680, 0xd7aa16c0, 0x488ac820, 0x0c1b8410, 0x0da31638, 0xa756553c, 0xc79d86ba, 0x1ee516ed, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x68000000, 0x7c000000, 0xa2000000, 0x69000000, 0x63800000, 0x24400000, 0x18600000, 0x55500000, 0x9ff80000, 0x5c640000, 0xd3520000, 0xe0fd0000, 0xf8e78000, 0x37914000, 0xaa5ee000, 0x50129000, 0xa81a0800, 0x4771fc00, 0x31cdb200, 0x4049cb00, 0x850fd680, 0x52e88dc0, 0x99fa0820, 0x6361fc10, 0xd7d5b228, 0x743dcb1c, 0xda45d69a, 0xe3618ddf, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x18000000, 0xdc000000, 0x16000000, 0x1f000000, 0x3a800000, 0x55c00000, 0x9e200000, 0x72d00000, 0x4c980000, 0x10240000, 0x71d60000, 0x801f0000, 0xeae18000, 0xcd76c000, 0x7b09e000, 0x2e593000, 0xb0823800, 0x7cc63400, 0xeba09e00, 0xb5914900, 0x437c6280, 0x36d29ac0, 0x469a3820, 0xf9223430, 0xe4569e38, 0xf75e492c, 0xfd05e286, 0x37805af7, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xe8000000, 0xe4000000, 0x7a000000, 0xb3000000, 0xd6800000, 0x93c00000, 0x16200000, 0x79900000, 0x43780000, 0x24240000, 0x7e920000, 0x17fb0000, 0x78e78000, 0xc8354000, 0xd0ac2000, 0x323c5000, 0x63c4d800, 0xbe209400, 0xfd97ce00, 0x4979e900, 0x7f211880, 0x4c1075c0, 0xfe3cd820, 0xddc49410, 0x6725ce18, 0x0012e91c, 0x003e98ba, 0x64c135f9, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xb8000000, 0xc4000000, 0xca000000, 0x89000000, 0xa9800000, 0x50c00000, 0x81600000, 0x6d500000, 0xf1c80000, 0x0f640000, 0xee560000, 0x714d0000, 0x46218000, 0x87f3c000, 0x597b2000, 0x10bfd000, 0xf05b8800, 0x11cc6c00, 0xdf665600, 0x46530300, 0xbd4d4680, 0xf0213840, 0x00f38820, 0xb3f86c30, 0x60f85628, 0x887a032c, 0xad3ac6ae, 0xc29ff871, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xa8000000, 0x8c000000, 0x6e000000, 0x4f000000, 0x09800000, 0x43400000, 0x83e00000, 0xa5b00000, 0xdd580000, 0x11e40000, 0x3cb60000, 0x9fd90000, 0x69228000, 0x75134000, 0x730d6000, 0x3509f000, 0x360d3800, 0x718f2c00, 0xadccea00, 0x8faea700, 0xe559c180, 0xd5e320c0, 0x2eb53820, 0xc6db2c30, 0x0ba2ea08, 0xddd3a734, 0x92ad41aa, 0x55d960e3, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x48000000, 0x24000000, 0xbe000000, 0xa7000000, 0xda800000, 0x5a400000, 0x94200000, 0xff300000, 0x12d80000, 0xd6240000, 0x9a360000, 0x6d5b0000, 0x93e18000, 0xfbd44000, 0xbb8a2000, 0x73ec7000, 0x73fd7800, 0x0e96f400, 0x712fa200, 0xb8995900, 0xaa05cd80, 0x9101d4c0, 0x39857820, 0x8ec2f430, 0x2161a218, 0x9596592c, 0x09aa4d92, 0xf7da94c9, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xf8000000, 0xf4000000, 0x9a000000, 0x41000000, 0xf4800000, 0xa4400000, 0x56600000, 0x97700000, 0x81980000, 0xd7640000, 0x03f20000, 0x75d90000, 0x09078000, 0x9885c000, 0x9a46a000, 0x05675000, 0x2ef5c800, 0xbf580400, 0xfe45f200, 0x7762bb00, 0x33f21f80, 0xaddaaec0, 0x8d07c820, 0xfa810410, 0x2f427208, 0x6be77b1c, 0xcbb4bfbe, 0x1dbdfefd, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xa8000000, 0x94000000, 0xae000000, 0xbf000000, 0x9b800000, 0x71400000, 0xfba00000, 0x33d00000, 0x51d80000, 0xdca40000, 0xf4560000, 0xca9d0000, 0xee078000, 0xdf034000, 0x4b81a000, 0xa946f000, 0xc7a0b800, 0x09d07c00, 0x40defa00, 0xf8262500, 0x1e934280, 0x407c04c0, 0x2676b820, 0xbd0d7c30, 0xc6f97a28, 0x81b5651c, 0xf96ae2aa, 0x2d4ef4e5, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x88000000, 0xbc000000, 0x46000000, 0x65000000, 0x02800000, 0xcb400000, 0x90a00000, 0x4ff00000, 0xe6280000, 0xcda40000, 0xa9720000, 0xff6d0000, 0x52008000, 0x4f064000, 0x0980e000, 0x80c6b000, 0x97676800, 0xcd15f400, 0x7dfc6a00, 0xca3bad00, 0x10dc6b80, 0x1f0a6b40, 0x72956820, 0x6038f410, 0x5bdcea28, 0xf48ded24, 0xe5548ba2, 0x6ad8db6f, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x58000000, 0x8c000000, 0xe2000000, 0xc7000000, 0xb8800000, 0xb4400000, 0x70a00000, 0x5bf00000, 0xf3c80000, 0x43a40000, 0xfd720000, 0x9a8d0000, 0xf0858000, 0x1040c000, 0xe6a16000, 0xc2f69000, 0x364cf800, 0x0465a400, 0x6310b200, 0xc298bd00, 0x909a9b80, 0x4f9efc40, 0xdb1ef820, 0xbd58a410, 0x52fd3228, 0x3d8c7d0c, 0x9801fb96, 0x6c016c63, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x48000000, 0xf4000000, 0xa6000000, 0x9d000000, 0xc3800000, 0xb8c00000, 0xf4a00000, 0x84b00000, 0x87a80000, 0xe5a40000, 0xed360000, 0xc8690000, 0x05868000, 0x95c44000, 0x0f26a000, 0xd077b000, 0x690ea800, 0xae15bc00, 0x921ef600, 0xcb8e4d00, 0x6752b980, 0x957cbb40, 0xfd18a820, 0xa30cbc30, 0xe9107608, 0xbe9e0d14, 0xdbca1992, 0x3db60b7d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x98000000, 0x4c000000, 0xde000000, 0xe1000000, 0xbf800000, 0x36c00000, 0x7ca00000, 0x2cd00000, 0xea880000, 0xc3a40000, 0xb2560000, 0xc3cd0000, 0x39c18000, 0x7a22c000, 0x49976000, 0xceeb7000, 0xead7c800, 0x87899c00, 0x02264600, 0xd5976d00, 0x98ed5a80, 0x6fd50240, 0x3209c820, 0x47e09c30, 0x29b1c628, 0xdc78ad2c, 0x70bbbaa6, 0x971cb253, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x68000000, 0xfc000000, 0x46000000, 0x7f000000, 0x68800000, 0xcfc00000, 0x3ea00000, 0xbc900000, 0x6d980000, 0x67a40000, 0xfb160000, 0x32d90000, 0xb2c18000, 0xab254000, 0x26d6e000, 0xe97fb000, 0xefd4b800, 0x76faa400, 0x24914e00, 0x19998d00, 0x4da0e080, 0x1a1172c0, 0xb15ab820, 0xaf87a430, 0x6346ce08, 0xb365cd2c, 0x9f37809a, 0x148b82ff, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xe8000000, 0x1c000000, 0x16000000, 0xa3000000, 0x28800000, 0x8cc00000, 0xb4a00000, 0xc8f00000, 0xc7480000, 0xd1a40000, 0x8b760000, 0x0f0f0000, 0x87c08000, 0xa0214000, 0x2237e000, 0xa8ec3000, 0xc5d65800, 0xcaffa400, 0xdf0fd600, 0x4fc63d00, 0xcc214380, 0x4c313c40, 0xffe85820, 0xe754a430, 0xf3395638, 0xe0287d24, 0x237623ba, 0x330c4c47, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xc8000000, 0x0c000000, 0x4e000000, 0xc3000000, 0xf5800000, 0x0b400000, 0x68e00000, 0xfb500000, 0x99180000, 0xa9e40000, 0xa3d60000, 0xf4df0000, 0x47c18000, 0xff204000, 0xbc776000, 0x016ff000, 0x5a8c5800, 0xbc5dcc00, 0x72072a00, 0x8501df00, 0xda84b680, 0x00c732c0, 0x68a25820, 0x6a36cc30, 0x2708aa38, 0x9b1a9f2c, 0x04e456b2, 0xc55782c3, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x68000000, 0x14000000, 0x86000000, 0x8f000000, 0x3a800000, 0x7e400000, 0xa0200000, 0xe5f00000, 0xb1f80000, 0xeaa40000, 0x33b60000, 0xe5df0000, 0x79538000, 0x654d4000, 0x21fba000, 0xb2a1b000, 0xafb63800, 0x87d9f400, 0x18570200, 0xc4cc9900, 0xe3396b80, 0xe3c3b5c0, 0xd0e5b820, 0xad94b430, 0xe32ca238, 0xf82d293c, 0x84af539a, 0x95ea41c5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x48000000, 0x4c000000, 0x2a000000, 0xdd000000, 0x49800000, 0xbec00000, 0x55600000, 0x8a300000, 0x12680000, 0xf4e40000, 0xc8f60000, 0x550f0000, 0x37d08000, 0xbd1c4000, 0xa4296000, 0x14c7d000, 0x4865a800, 0x23b3ac00, 0x3caa6600, 0xe9806300, 0x0ec32d80, 0x6d65dd40, 0x1e352820, 0x3c6fec30, 0x4fe30638, 0x7677b324, 0x7f4e8592, 0x95f27153, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xa8000000, 0xbc000000, 0x6a000000, 0x6d000000, 0x95800000, 0xc9c00000, 0x90200000, 0x4b900000, 0xf8c80000, 0x1da40000, 0x86520000, 0x76eb0000, 0xbd368000, 0x441f4000, 0xe60ae000, 0x9d07d000, 0x4d872800, 0xedc0cc00, 0xbe22de00, 0x58974900, 0xd6484080, 0x46e5b040, 0x2731a820, 0xf11f8c10, 0x57883e18, 0x7ac09914, 0xcea768aa, 0x88d17c6f, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x48000000, 0x7c000000, 0x5a000000, 0x2b000000, 0xfc800000, 0xa1c00000, 0x8ce00000, 0xa7900000, 0x99a80000, 0x8c640000, 0x9c560000, 0xde4f0000, 0x67718000, 0xec3c4000, 0xa2c8e000, 0x06b55000, 0x80da1800, 0xb55a8400, 0xd71a1e00, 0x70b99f00, 0x730b6880, 0x22508b40, 0xeb4b9820, 0x3ef6c430, 0x0c7afe38, 0x4a68cf2c, 0x27877092, 0x35450f5f, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xf8000000, 0xa4000000, 0x7e000000, 0x71000000, 0xc7800000, 0xb5c00000, 0x54200000, 0xa1b00000, 0xa4580000, 0xe7a40000, 0x22720000, 0x7d7d0000, 0xab938000, 0xc4edc000, 0xdc7c2000, 0x24127000, 0x8d2b4800, 0xa25d9c00, 0x72a01e00, 0x3bf4c900, 0x49bf6180, 0xc034b4c0, 0x7498c820, 0x52005c10, 0x13043e28, 0xcc82b93c, 0x8d4629be, 0xaf6428e9, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x88000000, 0xd4000000, 0x46000000, 0x63000000, 0x1c800000, 0x3cc00000, 0xb4e00000, 0x77f00000, 0x58780000, 0xa4640000, 0x11320000, 0x3d990000, 0x3a128000, 0x820e4000, 0xd95ba000, 0x92f2b000, 0x47fc5800, 0x7425c400, 0xc1131600, 0xa28d5f00, 0x879d4b80, 0x5b104dc0, 0x138ed820, 0x9e1b8410, 0xc850b608, 0x0f2bef34, 0xb5cb13a2, 0x153889f5, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xb8000000, 0xcc000000, 0x1a000000, 0x09000000, 0x18800000, 0x70400000, 0x7ca00000, 0xc0100000, 0x89b80000, 0x86240000, 0x55560000, 0xa79f0000, 0x37718000, 0xcccbc000, 0x47ed6000, 0x843f5000, 0x3ce08800, 0xc4b22400, 0x65ac1200, 0xa5998d00, 0x6277b480, 0x264837c0, 0xfaa90820, 0x8e1de430, 0x53b77238, 0x3a29dd2c, 0x425ebcae, 0x6d15d3f3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xb8000000, 0x84000000, 0xb2000000, 0x29000000, 0xcf800000, 0x0d400000, 0x57200000, 0x45900000, 0x2e880000, 0xb2a40000, 0x55d60000, 0x1c2d0000, 0x27778000, 0xe9fbc000, 0x4b5d2000, 0x768c1000, 0x26a38800, 0x8fd2dc00, 0x792eba00, 0x66f59100, 0xfbbe2080, 0x48f8e640, 0xd8dc0820, 0x9dcd1c30, 0x22859a28, 0x10c4811c, 0xa36228ae, 0x1535fa61, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0x34000000, 0x3a000000, 0x0d000000, 0x7f800000, 0xbb400000, 0x09a00000, 0xd8700000, 0x37080000, 0xb8240000, 0x74320000, 0x5c2b0000, 0xdc978000, 0xcdda4000, 0x3bdea000, 0x70dc5000, 0x6c5d2800, 0xef9cdc00, 0x27faca00, 0x06ef4500, 0x61738f80, 0x328eba40, 0x6e62a820, 0x72129c10, 0x371e6a18, 0xd63c151c, 0x978b2782, 0x75e3264d, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x68000000, 0x3c000000, 0xba000000, 0xbf000000, 0x9a800000, 0xd9400000, 0x5c600000, 0x41100000, 0x5f680000, 0xa8e40000, 0x61560000, 0xfc8b0000, 0x65378000, 0x499d4000, 0xac5ee000, 0xfc7c5000, 0xbc8fb800, 0xc537b400, 0x599eda00, 0xb4593b00, 0xa8782c80, 0x3a8fb940, 0xc0303820, 0x7c1ef430, 0xf79e3a18, 0x2d5a6b1c, 0x27fe149a, 0xde4a4d4f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0x4c000000, 0xda000000, 0xd3000000, 0xad800000, 0xd1c00000, 0x6fa00000, 0xb8300000, 0xf1b80000, 0x9c240000, 0x9cf60000, 0x629d0000, 0x3f528000, 0xc0af4000, 0xbdeb6000, 0x210a5000, 0xd8d8d800, 0x60368c00, 0x85bc9e00, 0x82214500, 0x09f5dd80, 0xee1f6bc0, 0xdc125820, 0x094dcc30, 0x68b9fe28, 0xaaa21534, 0xdcb1858a, 0xfeffa7d3, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xd8000000, 0x0c000000, 0xee000000, 0x9d000000, 0xf2800000, 0x18c00000, 0xd4e00000, 0xf3700000, 0x11e80000, 0xdb640000, 0x29360000, 0xf5c90000, 0xf8f28000, 0xf1a8c000, 0x40456000, 0x8b27f000, 0x5a132800, 0x73d97400, 0xbd2d7600, 0xdd802f00, 0x81407f80, 0x8fa32140, 0xf3d7a820, 0x6bb8b430, 0x139a9608, 0xe60f1f34, 0x5f9637b6, 0xfe9da543, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x08000000, 0x5c000000, 0xf6000000, 0x69000000, 0x0f800000, 0x59c00000, 0x22600000, 0x6ef00000, 0x73280000, 0xb4e40000, 0x10b60000, 0x048f0000, 0xb6718000, 0x306e4000, 0x66c1e000, 0xd4e43000, 0x60b40800, 0xec8f1c00, 0x5a713e00, 0xce6ebb00, 0x53c7bb80, 0x2d619f40, 0x50738820, 0xc16e5c30, 0x6d415e38, 0x9f24cb2c, 0x89d25382, 0x4efab357, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xd8000000, 0x2c000000, 0xfa000000, 0x03000000, 0xce800000, 0x31c00000, 0xff600000, 0xb4f00000, 0x5c080000, 0x0ae40000, 0xf7b60000, 0xd0ab0000, 0x3e768000, 0xf3c8c000, 0x98866000, 0x08c35000, 0x52e5d800, 0x1bb59400, 0x4aa89e00, 0x6d728300, 0xe54a0380, 0x85447640, 0x0da55820, 0xe5165430, 0x89387e18, 0x71891314, 0x65a1bbb6, 0x8116b24b, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x78000000, 0xc4000000, 0xf2000000, 0x9f000000, 0x74800000, 0x87c00000, 0x18200000, 0xfa700000, 0x0a080000, 0x3ba40000, 0x75360000, 0xc3eb0000, 0x84f58000, 0x16cdc000, 0xc5012000, 0xa7801000, 0xdd443800, 0x06e40400, 0x83d06e00, 0x583a1900, 0x28cfe780, 0xb4029640, 0x2a07b820, 0x0b02c430, 0xce84ce18, 0xa4c7c90c, 0x5aa2ff9e, 0x10b28271, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x48000000, 0xbc000000, 0xae000000, 0x01000000, 0x19800000, 0xfcc00000, 0xc7600000, 0x8bf00000, 0xca180000, 0x67e40000, 0xeab20000, 0x9bbb0000, 0x20768000, 0xe9d84000, 0xc002e000, 0x2005f000, 0x30014800, 0x1807ac00, 0xf400d600, 0x1203d300, 0xaf01e380, 0x1881bec0, 0xe545c820, 0x3ba4ec10, 0x4c94b618, 0x41ee6314, 0xadfa4b92, 0x8d57e2ef, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x08000000, 0x84000000, 0xae000000, 0x89000000, 0xea800000, 0xbb400000, 0xb0a00000, 0x32500000, 0xd5080000, 0x67240000, 0x75960000, 0xabef0000, 0xbd508000, 0x828e4000, 0xe0e72000, 0xeb77f000, 0xe19b0800, 0x424bf400, 0x4d82ea00, 0x18c4ed00, 0x01603680, 0xa9b3fa40, 0x5ffd8820, 0x047ab430, 0x69bd4a38, 0x30595d24, 0x89aa1e82, 0x2f70fe61, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x98000000, 0xb4000000, 0xbe000000, 0xe3000000, 0x0e800000, 0xa9400000, 0x9f600000, 0xd4300000, 0x8b180000, 0x2ee40000, 0xf1f60000, 0xec390000, 0x52328000, 0xcc1ac000, 0x2660a000, 0xdfb57000, 0x5bdad800, 0x78475400, 0x68e27a00, 0x96f74300, 0x34bda580, 0xe476cac0, 0xcffe5820, 0xb2149430, 0x98485a08, 0xe5ccf334, 0x3a09dda6, 0x4829eeed, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x38000000, 0xfc000000, 0x42000000, 0x47000000, 0xdd800000, 0x8c400000, 0xa3e00000, 0xbfd00000, 0xd8f80000, 0x1b640000, 0xb9120000, 0xf2df0000, 0x27168000, 0x07dbc000, 0x3594e000, 0xc21a9000, 0x9c30f800, 0x27298c00, 0x239cb200, 0xf2744700, 0x73cdc280, 0x29cefdc0, 0x62cc7820, 0x75494c10, 0x2a0cd238, 0xd26a1714, 0x18ff5a8e, 0xbb6621ff, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x48000000, 0x94000000, 0x2e000000, 0x45000000, 0x06800000, 0x67c00000, 0xb8e00000, 0x4ad00000, 0x1ae80000, 0xe5640000, 0x96920000, 0xef490000, 0x52928000, 0xc9484000, 0xa391a000, 0x31cdf000, 0xc9556800, 0x1ba81400, 0xca450e00, 0xfca7cf00, 0x63705280, 0x171be140, 0xd1bde820, 0x99cd5410, 0xed542e08, 0x8dab7f34, 0x83461a92, 0x08264565, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xd8000000, 0x54000000, 0x1a000000, 0xe9000000, 0x34800000, 0xc2400000, 0x2b200000, 0x98b00000, 0x22880000, 0x14a40000, 0xa3760000, 0x8d6b0000, 0xd0728000, 0x90e8c000, 0x46b5a000, 0xa9885000, 0x2d268800, 0x47b38400, 0x010b0200, 0x19663100, 0x1b957180, 0x8639ee40, 0x702a0820, 0xc8d44430, 0xbd9a2218, 0x58dda134, 0x747cd9b6, 0x930efa55, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xb8000000, 0x34000000, 0x2a000000, 0x93000000, 0x6e800000, 0x89400000, 0x09200000, 0xaa900000, 0xc4380000, 0x9aa40000, 0xec520000, 0xdddf0000, 0xfcd18000, 0x1d9fc000, 0x5072a000, 0xd4ced000, 0x862a5800, 0x4ad95400, 0x4051da00, 0xd3ddf100, 0xadd43080, 0xdc1d13c0, 0x11b1d820, 0xd9ad9410, 0xf218fa38, 0x50b7e12c, 0xf02f48ae, 0x8fda57cd, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xc8000000, 0x6c000000, 0x1e000000, 0x2d000000, 0x71800000, 0x09c00000, 0x09600000, 0x4a700000, 0x6f580000, 0xc0a40000, 0xe3120000, 0xb52f0000, 0x17ff8000, 0x87b04000, 0x243e6000, 0x91d07000, 0xcccea800, 0xdbcdac00, 0xb54e5e00, 0x1e0e9300, 0x32295780, 0xc17c88c0, 0x88f0c820, 0x7a1ddc10, 0x5180f638, 0xd9c33f1c, 0x516709b2, 0x9e721bdb, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x68000000, 0xc4000000, 0xc6000000, 0xa7000000, 0x71800000, 0x03400000, 0x2c200000, 0x41700000, 0xfc580000, 0x0f640000, 0x5d520000, 0x752d0000, 0x473f8000, 0xfc354000, 0x4b792000, 0x8594b000, 0x1f4ff800, 0xeaefec00, 0x8cdd8a00, 0x4aa22900, 0xbbb61f80, 0xc73f84c0, 0xbc36d820, 0xeb7b5c10, 0xf5927228, 0x774dc51c, 0x2eeb959a, 0x4addadf1, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xf8000000, 0x24000000, 0x36000000, 0x07000000, 0xe6800000, 0xb8400000, 0xc2e00000, 0xcab00000, 0x01a80000, 0x02a40000, 0x6c520000, 0x9d1b0000, 0xd40a8000, 0x7071c000, 0x6d082000, 0xbdf03000, 0x69cb7800, 0xfa56d400, 0x6a19d200, 0x7a8f5f00, 0xc430f980, 0x45ed8b40, 0x62435820, 0xbfe6e410, 0xa132aa18, 0x9a698b34, 0x57812bbe, 0x19c6d449, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xa8000000, 0xa4000000, 0xc2000000, 0xa5000000, 0x55800000, 0xcd400000, 0x49600000, 0x85900000, 0x47a80000, 0x90240000, 0x76f60000, 0x4b390000, 0xf40c8000, 0xe4974000, 0x202a2000, 0x60639000, 0x7616e800, 0xcdebcc00, 0x39c1da00, 0xc3a23300, 0x2cb78880, 0x6ad86b40, 0xf55cc820, 0xe9185c30, 0xbfff3208, 0xe62dff04, 0xd76052aa, 0x0e935869, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x88000000, 0xa4000000, 0x3a000000, 0xbb000000, 0x2b800000, 0x95c00000, 0xb7600000, 0x57300000, 0xb9580000, 0xdea40000, 0xa6560000, 0xd3690000, 0x51798000, 0x6bb64000, 0x591a2000, 0x5d015000, 0x66821800, 0x0b413c00, 0xb025de00, 0xc915f300, 0x794b1d80, 0x936de8c0, 0xb1783820, 0xfbb06c30, 0x611fc608, 0x7100cf2c, 0xf880c3a2, 0x8a451be9, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0xc4000000, 0xb2000000, 0xcd000000, 0xcc800000, 0x71400000, 0x07a00000, 0x78300000, 0x27480000, 0x94e40000, 0x9a920000, 0xe7f90000, 0xa8e88000, 0x48d44000, 0xbfdd2000, 0x661c1000, 0x72fea800, 0xa86d0400, 0x6f93ba00, 0x577e0500, 0x57ae2d80, 0x2c77a440, 0xf86b8820, 0x47951410, 0x237f1208, 0x3daa0124, 0x6d751792, 0x42ede171, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0xac000000, 0xb2000000, 0x8f000000, 0xd7800000, 0x14c00000, 0x9b600000, 0x70300000, 0x70780000, 0x35a40000, 0xe8560000, 0xb5cf0000, 0xa61d8000, 0x75104000, 0x276c6000, 0xc5cf1000, 0xce1db800, 0x09149c00, 0xed68d600, 0xaecdf300, 0x079de580, 0x20d229c0, 0x2e89d820, 0x1dbf8c30, 0xf8436e38, 0xfe266f0c, 0xc690b392, 0xedab9aeb, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x18000000, 0x64000000, 0x76000000, 0xdb000000, 0x15800000, 0x37c00000, 0x63a00000, 0xa5b00000, 0xbbf80000, 0x6a640000, 0xa1160000, 0xb9cd0000, 0x9b5a8000, 0x7e52c000, 0xfb282000, 0xbb0c3000, 0x927a9800, 0x2fa44c00, 0x1fb4ae00, 0x1afd3500, 0x7ee23980, 0x52529dc0, 0x312ab820, 0xd20c7c30, 0xfaf83628, 0xcee47934, 0x3a541786, 0x9d2968d9, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x38000000, 0xdc000000, 0x82000000, 0xcf000000, 0x6a800000, 0x4dc00000, 0xa0e00000, 0x4f500000, 0xca180000, 0xc3240000, 0xdab20000, 0x5ccd0000, 0x5c7b8000, 0x03b7c000, 0xdf49e000, 0x4a3a9000, 0x39163800, 0xe0bb7400, 0x94d61e00, 0x105b2f00, 0x13817680, 0x3e401ac0, 0x8ea7d820, 0xa9f5e410, 0x77ea2628, 0xd2c95b3c, 0x997ee88e, 0xe231f5f7, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xa8000000, 0xe4000000, 0x3e000000, 0xb7000000, 0xaf800000, 0xd6400000, 0x71e00000, 0x69300000, 0xdf980000, 0x75a40000, 0xe5d60000, 0x682f0000, 0x98f98000, 0xea574000, 0x2e6e2000, 0x111f7000, 0x7f677800, 0x83f61c00, 0x09bae200, 0xbc330700, 0x251fed80, 0x9960e2c0, 0x98f15820, 0xcc3d6c30, 0x4b739a38, 0xa87e1b2c, 0xb7928faa, 0x57cfa5f9, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xd8000000, 0x04000000, 0x2a000000, 0x2f000000, 0xc1800000, 0x5fc00000, 0xc7200000, 0x07300000, 0x76e80000, 0x9ee40000, 0x79160000, 0xa15d0000, 0x1b498000, 0x4d94c000, 0xa81b2000, 0x562dd000, 0x90403800, 0xede3ec00, 0x56930e00, 0x5b9d5100, 0x82edad80, 0x0ce43540, 0x42131820, 0x22da3c30, 0xb78d3628, 0x6537bd2c, 0xf5e923b6, 0x0964a441, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x68000000, 0x5c000000, 0xae000000, 0xad000000, 0x5a800000, 0x9ac00000, 0xcea00000, 0xf5b00000, 0xbdc80000, 0x99640000, 0x91960000, 0x8ab90000, 0xce0c8000, 0x67414000, 0xf9e5e000, 0x8454f000, 0x559ea800, 0x1aff7400, 0x12694600, 0x30556d00, 0x679f9180, 0x39fd2c40, 0xf5ed4820, 0x98128430, 0x6ffb6e08, 0xaceb5904, 0x1093379a, 0xe63cb157, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x88000000, 0xac000000, 0x4a000000, 0x3d000000, 0x99800000, 0x9b400000, 0xdf200000, 0x03700000, 0x03980000, 0x31640000, 0x49d20000, 0x61af0000, 0x08de8000, 0xc6424000, 0x56a06000, 0xf037d000, 0x20bf2800, 0xf011ec00, 0xdb49ea00, 0x834e4100, 0xe749bf80, 0xe14d4ac0, 0xc64d4820, 0xeac93c10, 0x44084238, 0x4a6ded14, 0xab3835a2, 0x3250dbeb, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xc8000000, 0xf4000000, 0xf6000000, 0x0f000000, 0x76800000, 0xa7c00000, 0xb8200000, 0x1d300000, 0x3b980000, 0xa8e40000, 0x2f960000, 0x636f0000, 0x225b8000, 0x2bc44000, 0x5226a000, 0x00373000, 0x8c19b800, 0x4aa65400, 0x44f32e00, 0x98bd0900, 0xc550a580, 0x74cf16c0, 0xf1291820, 0x413e6430, 0xc4111638, 0xb32f1d3c, 0x983d2bb2, 0xad912ffd, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xe8000000, 0xe4000000, 0x96000000, 0xed000000, 0x2a800000, 0xaec00000, 0x13e00000, 0xdf900000, 0x95180000, 0xdc240000, 0xd4f20000, 0x7f4f0000, 0xcd5e8000, 0xbb014000, 0x67822000, 0x34413000, 0x0522a800, 0xc0713400, 0x388ee600, 0x323f4700, 0xcf56c080, 0x2ffd8ac0, 0x0f328820, 0xba2f0410, 0x960ace38, 0x1afb3314, 0x39b006ba, 0x6ee8fdf9, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xc8000000, 0x4c000000, 0x66000000, 0x01000000, 0x49800000, 0x07c00000, 0x6fe00000, 0xa3900000, 0x13880000, 0x0d240000, 0x7ff20000, 0x88d90000, 0x0dc98000, 0x7d004000, 0xa7816000, 0x6ac7b000, 0xf063c800, 0x6d566c00, 0x79e96e00, 0xcf744700, 0x029d5880, 0x6fefee40, 0x6670a820, 0x9718dc10, 0x762b2608, 0x8c966b2c, 0x570f56b2, 0x05611953, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xe8000000, 0x3c000000, 0xe6000000, 0xaf000000, 0xc5800000, 0x61c00000, 0x8ea00000, 0x72300000, 0x24e80000, 0xa4640000, 0x9b160000, 0x4a1f0000, 0xeeae8000, 0x48054000, 0x4c00e000, 0xbe02b000, 0x2b00b800, 0xf7808c00, 0x14c5de00, 0x02263d00, 0x7970c580, 0x0e0c0540, 0x39365820, 0x436d3c30, 0xb8a3e638, 0xf537f114, 0x3d6bfbba, 0x73a3884f, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x88000000, 0x1c000000, 0x16000000, 0xc1000000, 0x2c800000, 0x3cc00000, 0x46200000, 0xecb00000, 0x8e380000, 0xede40000, 0x27160000, 0xa2cd0000, 0xe13f8000, 0xf4664000, 0xed53e000, 0xf72e3000, 0x322dc800, 0x8cafc400, 0x236eb600, 0x7ac80900, 0xc538c980, 0xd664d3c0, 0x56502820, 0x84a8f430, 0xff6afe28, 0xcccc8d1c, 0x743a1fa2, 0x72e4aac7, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x38000000, 0xe4000000, 0x0e000000, 0x7d000000, 0xc9800000, 0xecc00000, 0x9da00000, 0x19900000, 0xfc980000, 0x16640000, 0xe6b60000, 0xc9490000, 0xd4198000, 0x3923c000, 0x74d02000, 0x71fcf000, 0xc853a800, 0x48beac00, 0x73353600, 0x0f8cf500, 0x1ab9a880, 0x24366ec0, 0x950d8820, 0xf2ff5c30, 0xa4d11e08, 0x19fc992c, 0x84533e8e, 0x2abcabf9, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xa8000000, 0xfc000000, 0xe6000000, 0xe9000000, 0x73800000, 0xe6400000, 0xda600000, 0xe3300000, 0x4eb80000, 0x47240000, 0x29d20000, 0x3f4d0000, 0x833a8000, 0x8c634000, 0x9230e000, 0x193cb000, 0xc3608800, 0xa8b33c00, 0x5cfae200, 0x57442b00, 0x6de48d80, 0x17743bc0, 0xb7da6820, 0x70968c10, 0xe7aaea28, 0xd1cd5734, 0x9cfe0faa, 0xb746e0ff, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x18000000, 0x6c000000, 0x1e000000, 0x5b000000, 0xfc800000, 0x93c00000, 0xb5600000, 0xf2900000, 0x5da80000, 0x02240000, 0x58320000, 0x145d0000, 0x5e198000, 0x8f3ec000, 0xaf886000, 0xe2167000, 0x90689800, 0x4c40c400, 0xe6204e00, 0xc2312300, 0x855cb880, 0x3b9f7f40, 0xbd797820, 0x42a87410, 0xd4a0b628, 0x42f7972c, 0xa8bc6e86, 0x80ca985b, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xa8000000, 0x24000000, 0xda000000, 0x99000000, 0x9e800000, 0x85400000, 0x4a200000, 0xf7f00000, 0x57680000, 0x45e40000, 0x0a920000, 0x37bb0000, 0x11f98000, 0xac5b4000, 0x886c2000, 0x84665000, 0x0e550800, 0x195e1400, 0x78ef1a00, 0x3a222900, 0x7ff17380, 0xa36efd40, 0x87e0a820, 0x1f930410, 0x573e3218, 0xd7be6d2c, 0xe1f961aa, 0x6459c049, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x48000000, 0xe4000000, 0xf2000000, 0xf5000000, 0x6d800000, 0xd8c00000, 0x78e00000, 0x31700000, 0xddb80000, 0xf1a40000, 0x6f560000, 0xc72b0000, 0xefea8000, 0xaf084000, 0x827e2000, 0xd1c01000, 0x8b666800, 0x6ab38c00, 0x1fdab600, 0xc8929f00, 0x9b4bff80, 0x55dc7fc0, 0xe192c820, 0x18cbdc30, 0xf61afe18, 0x5ff50334, 0x7ff92192, 0xe1026cf9, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xe8000000, 0x54000000, 0xc6000000, 0x23000000, 0xbb800000, 0xefc00000, 0x29200000, 0xff700000, 0xe0180000, 0xcb640000, 0x02920000, 0x81c90000, 0xd1c88000, 0x59c94000, 0xbdcda000, 0x03cdb000, 0x9ccdd800, 0xb54bbc00, 0xbf8f2e00, 0x0e280100, 0xa51b6f80, 0x83e4eac0, 0x9ed0f820, 0x832b4c10, 0x299d5608, 0x31a70d24, 0xeb3119ba, 0x06fe17d5, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x58000000, 0x44000000, 0x22000000, 0x61000000, 0x2c800000, 0x21c00000, 0x4ee00000, 0xee100000, 0x65a80000, 0xd9a40000, 0x54320000, 0x23d90000, 0x9ed88000, 0xb45cc000, 0x669d2000, 0xadfa9000, 0x52aa4800, 0x3e220400, 0x04777e00, 0x967d0f00, 0x04ec6c80, 0x7887bf40, 0x1bc7e820, 0x4be05410, 0x70921608, 0x7d6c9b24, 0xffc1da96, 0xb9e07451, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xa8000000, 0xcc000000, 0xb6000000, 0xf9000000, 0xe5800000, 0xc8400000, 0x5ea00000, 0x93100000, 0x3f880000, 0x3d640000, 0x28f20000, 0xe5b90000, 0x2abb8000, 0x763b4000, 0x7bf96000, 0x1d1d3000, 0x78aa0800, 0x18348c00, 0xacdc5200, 0x40492d00, 0x68836c80, 0x6fc2ca40, 0x6de0e820, 0xf336fc10, 0xaa5d3a08, 0xf289913c, 0xbae6b6aa, 0xebb02b73, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xb8000000, 0x74000000, 0x9a000000, 0x35000000, 0xc7800000, 0xbfc00000, 0xe3200000, 0x87b00000, 0x32e80000, 0xa5640000, 0xac560000, 0xe0fd0000, 0xda788000, 0x9e3fc000, 0xa4dca000, 0x334f5000, 0x2297e800, 0x165fdc00, 0x2b0ace00, 0x4e728100, 0x5aca1980, 0x52510d40, 0x37fbc820, 0xfcfb4c30, 0xec7f8628, 0x753b0d24, 0xe459bfae, 0xb20e905d, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xe8000000, 0x14000000, 0x56000000, 0x79000000, 0x08800000, 0xd6c00000, 0xb8e00000, 0xec900000, 0xcf880000, 0x0ca40000, 0x99b20000, 0x8c7b0000, 0x30fe8000, 0xc0394000, 0xd9dda000, 0x91cd3000, 0x22830800, 0xadc42400, 0xff626600, 0x1bd1df00, 0x4129b880, 0x9a155640, 0x54482820, 0xdac45410, 0x62e6ce18, 0x0f97cb14, 0x440c56ba, 0x01e6ed45, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x38000000, 0xf4000000, 0x5a000000, 0x6d000000, 0xb9800000, 0xd0400000, 0x0b600000, 0x09900000, 0x8e480000, 0x04a40000, 0x69b20000, 0x963b0000, 0xadbf8000, 0xd4ffc000, 0x641aa000, 0x54cc5000, 0x0a642800, 0x4e112c00, 0x410ab200, 0x67400300, 0x9fe05880, 0x00522440, 0x25690820, 0x3e56bc10, 0x1a6e3a18, 0x46d27f1c, 0xadab428e, 0x92f3cb7d, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x38000000, 0xdc000000, 0xa2000000, 0x7b000000, 0xc2800000, 0x22c00000, 0xf1a00000, 0x37b00000, 0x37e80000, 0xaae40000, 0x06520000, 0x033b0000, 0xd3198000, 0x48efc000, 0xe663e000, 0xa5919000, 0x271c9800, 0x9ee8b400, 0x0b652600, 0xea16a500, 0xfa5fe180, 0x8a0d2540, 0xf434f820, 0x80ade410, 0x4103de18, 0xf580412c, 0xaa45bf8e, 0xfc62a477, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xc8000000, 0x44000000, 0xba000000, 0xa5000000, 0xfb800000, 0xb3400000, 0xc2200000, 0x5c300000, 0x32d80000, 0x67e40000, 0x52d60000, 0x458f0000, 0x9e2b8000, 0x685c4000, 0xb5272000, 0x96b35000, 0x181be800, 0xcf803c00, 0x01422a00, 0xc323c900, 0xedb24580, 0xec98b8c0, 0x1a414820, 0x07a02c30, 0x10756238, 0x5e7ce53c, 0xbb14a7b2, 0x556c1dd1, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x68000000, 0xfc000000, 0x1a000000, 0xe1000000, 0xb2800000, 0x8ec00000, 0x04200000, 0xfe900000, 0x76980000, 0xa5640000, 0x9cf20000, 0xc3e90000, 0x4bca8000, 0x575d4000, 0x74c0e000, 0x55255000, 0xd413c800, 0xbc5fb400, 0x2f440600, 0x65621900, 0xfcf4b880, 0x33ebdec0, 0xf3cba820, 0xc35ea410, 0x92c5ae08, 0xae21bd34, 0x8791969a, 0x801a23ff, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x08000000, 0x7c000000, 0xd6000000, 0x91000000, 0xcb800000, 0xf0400000, 0x3ea00000, 0xbab00000, 0x03380000, 0xd0640000, 0x5dd20000, 0x2c6b0000, 0x6bc98000, 0x96fe4000, 0xdb86e000, 0x68423000, 0x9aa24800, 0xa8b07c00, 0x303a9200, 0x20e42d00, 0x2113b180, 0xb80e4fc0, 0xd41f2820, 0xe1970c10, 0x8ccfba18, 0x5c7c212c, 0x38478b82, 0x62a72edf, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xb8000000, 0xfc000000, 0x62000000, 0xc1000000, 0x56800000, 0x46400000, 0x03200000, 0x9a100000, 0xb9380000, 0x90e40000, 0xf8f20000, 0x78cf0000, 0xa2ac8000, 0x6e1bc000, 0x6cf6e000, 0xfece9000, 0x0da84800, 0x339e1400, 0xf9320200, 0x732f6100, 0x71dd3c80, 0x8417e7c0, 0x5a382820, 0xe7604410, 0xf8322a38, 0x85ab2504, 0xc79d16ae, 0x2f33c2ff, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x08000000, 0x04000000, 0xaa000000, 0x4d000000, 0x88800000, 0xad400000, 0x2ba00000, 0x4d700000, 0x8cb80000, 0x39640000, 0xa6120000, 0x3baf0000, 0xcc4c8000, 0x341e4000, 0x43912000, 0xae68d000, 0xb2a9a800, 0x4ecaa400, 0x24595a00, 0xf8b7c500, 0x425cd780, 0xbbb4c3c0, 0xddde0820, 0xcb773410, 0xdfbf5238, 0xaee4f104, 0xd2d18582, 0x93cf32c1, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x38000000, 0xf4000000, 0x12000000, 0x79000000, 0x0c800000, 0x59400000, 0xb4600000, 0x19500000, 0xf4980000, 0x62a40000, 0x1df20000, 0xc26d0000, 0x75498000, 0x8d7fc000, 0x9a34a000, 0xb64a1000, 0xc4fe8800, 0xb1f58400, 0x746b3a00, 0x364ddb00, 0x84f9b680, 0x11f3a2c0, 0xc469a820, 0x0e495410, 0x70fa9228, 0x03f08f2c, 0xbd69248e, 0x02ca2dfd, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x58000000, 0xd4000000, 0x16000000, 0xcf000000, 0x48800000, 0x34c00000, 0xd4e00000, 0x43900000, 0x42280000, 0x55a40000, 0x1a320000, 0xda1f0000, 0xb6ba8000, 0xfb0cc000, 0x0557a000, 0x87cb3000, 0xfdb13800, 0x365aa400, 0xee9e7600, 0x687e4f00, 0x4aed5080, 0x8b46ab40, 0xeca61820, 0x0db65410, 0x1e586e38, 0x52981b34, 0x227d3e96, 0x1feab075, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xd8000000, 0x5c000000, 0x26000000, 0x09000000, 0x94800000, 0x45c00000, 0xb9200000, 0x8e100000, 0xc7980000, 0x43640000, 0xd5720000, 0x6eeb0000, 0xdb898000, 0x6ff8c000, 0x1197e000, 0xf5ddb000, 0x0c040800, 0x0e070400, 0xed043e00, 0x5e83d100, 0xb2c76c80, 0x78a21ec0, 0x79506820, 0x327d7410, 0xe0d45618, 0xd93ea52c, 0x53333ab6, 0xc38cbbd7, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x78000000, 0xb4000000, 0x06000000, 0x29000000, 0x98800000, 0x15c00000, 0xe2e00000, 0xd8500000, 0xa7280000, 0xf8540000, 0x572e0000, 0xb0570000, 0xcb2c8000, 0x7a54c000, 0x50292000, 0xcdd4f000, 0xf4686800, 0xa2703400, 0xdb18c600, 0x3fef2300, 0x5c320480, 0x37b81a40, 0x4318c620, 0x1bef2330, 0x42320498, 0xfab81a54, 0xa598c63e, 0x932f231d, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x48000000, 0x94000000, 0x9e000000, 0x7d000000, 0x81800000, 0x8c400000, 0x87e00000, 0xffb00000, 0x18c80000, 0xe7b40000, 0x04ce0000, 0x8db70000, 0x37c88000, 0x39354000, 0xae0c2000, 0xac91b000, 0xab5fc800, 0xca6dbc00, 0xd867aa00, 0xaef38300, 0xaea95780, 0x0c44c540, 0x47e7aa20, 0x9fb38330, 0xc8c95798, 0xafb4c574, 0x90cfaa32, 0x13b78315, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xf8000000, 0xdc000000, 0x0e000000, 0x91000000, 0xad800000, 0xe8400000, 0x49a00000, 0xadf00000, 0xb8880000, 0xc5f40000, 0x8c8e0000, 0x3ff10000, 0x478d8000, 0x2976c000, 0x414b6000, 0xba16b000, 0x71dfe800, 0xa30bdc00, 0x00b4aa00, 0xb6ab9100, 0x6342c580, 0x3f20d540, 0x7b34aa20, 0xa3eb9130, 0xd162c5a8, 0x4790d55c, 0xd19caa1e, 0x6eaf9107, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x18000000, 0x64000000, 0x02000000, 0xb5000000, 0x06800000, 0x3cc00000, 0x51a00000, 0x8bb00000, 0xe8a80000, 0x2fb40000, 0x4aaa0000, 0x8ab30000, 0xa42d8000, 0xca73c000, 0x938ea000, 0xf6c3d000, 0xc8a30800, 0xe337e400, 0xef68ee00, 0xb3966900, 0x28593380, 0xbefeec40, 0xdec8ee20, 0x88266910, 0x38f133b8, 0x054aec7c, 0x8e62ee26, 0xd3956909, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x88000000, 0xd4000000, 0x82000000, 0x07000000, 0x10800000, 0x91c00000, 0xaa600000, 0x52100000, 0x48780000, 0x8e140000, 0xde7e0000, 0xab110000, 0x99fc8000, 0xa2554000, 0x765a2000, 0xd8215000, 0x6b321800, 0x0ecdd400, 0xaa9c9600, 0xd1c78700, 0xca638680, 0xa21404c0, 0x907c9620, 0xd2178730, 0x887b86a8, 0x2e1004d4, 0x8e7a9602, 0x23128705, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xd8000000, 0xbc000000, 0xc2000000, 0xc9000000, 0x5d800000, 0x50400000, 0x07e00000, 0x5eb00000, 0xf7680000, 0x0ab40000, 0xf16e0000, 0xadb70000, 0x0fed8000, 0x0d71c000, 0x7bc86000, 0x0f67d000, 0x41762800, 0xa1c93c00, 0x1a66aa00, 0xaef40300, 0xe088df80, 0xfc04f840, 0x6206aa20, 0xd9040330, 0xf580df98, 0x3440f85c, 0x79e0aa16, 0x55b7031f, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xb8000000, 0x24000000, 0x06000000, 0xa5000000, 0x1e800000, 0x04c00000, 0xdfa00000, 0xec700000, 0x5ee80000, 0xc0740000, 0xd4ea0000, 0x9f770000, 0x1d688000, 0x9e32c000, 0x5989a000, 0xb1a2f000, 0x95748800, 0x026e0400, 0x37b2ae00, 0x08c9f900, 0x4d444d80, 0x9ee44e40, 0xc892ae20, 0x2179f910, 0xb48c4d98, 0x43204e54, 0x3bb0ae0e, 0xb2caf919, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x78000000, 0xac000000, 0xfa000000, 0xbf000000, 0x21800000, 0x44400000, 0xc1e00000, 0x8b300000, 0xa4280000, 0xd1340000, 0x0b2e0000, 0xa8b50000, 0x33688000, 0xeb56c000, 0xab5de000, 0x94f91000, 0x812c1800, 0x7fb61c00, 0xe6eb3a00, 0x29109300, 0x57bda380, 0x2d4e5240, 0xbac33a20, 0x94249330, 0x8693a388, 0xeafb5274, 0xd02bba3e, 0x9732531b, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xc8000000, 0xd4000000, 0xd6000000, 0x21000000, 0x95800000, 0x3e400000, 0xb8600000, 0x8b900000, 0x1c580000, 0x69940000, 0x5b5a0000, 0xe5150000, 0x3c9c8000, 0xa9334000, 0x2c6a2000, 0x5c7df000, 0xd3672800, 0x7d175c00, 0x6099da00, 0x8b331f00, 0x0b6e4680, 0x20fc9dc0, 0xaca1da20, 0x2d371f10, 0x726c4688, 0x897d9df4, 0x40e75a12, 0xaa515f25, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xb8000000, 0x94000000, 0xaa000000, 0x11000000, 0x67800000, 0xa0c00000, 0x53200000, 0xb7500000, 0xa2780000, 0x11540000, 0x5d7e0000, 0xd5d10000, 0x0f3e8000, 0x53b4c000, 0xce8a2000, 0xd8399000, 0x7b36a800, 0x02c8ac00, 0xf558ae00, 0x7403b500, 0xda025480, 0x1900c6c0, 0x5b80ae20, 0x26c7b530, 0x7c2454a8, 0x6bd5c6c4, 0x74382e0e, 0x85367515, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xc8000000, 0xe4000000, 0x76000000, 0x29000000, 0x07800000, 0xbbc00000, 0x5de00000, 0x6d500000, 0xdc680000, 0x24540000, 0xebea0000, 0xb7930000, 0x22098000, 0x64c54000, 0x3366a000, 0x3112f000, 0x4a4de800, 0xdce1cc00, 0xbed1b600, 0x39ae6300, 0xc4b07c80, 0x3f387040, 0x1d3bb620, 0x2a3d6310, 0x70b9fcb8, 0x02fd305c, 0xe1dd1612, 0x44ef9329, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x68000000, 0x64000000, 0xfe000000, 0x5d000000, 0x8c800000, 0x99400000, 0x6d600000, 0x8af00000, 0xc6480000, 0xe3f40000, 0x7cce0000, 0x33b70000, 0x1b2e8000, 0x71044000, 0xa685a000, 0x2247b000, 0xa0e14800, 0x6d30d400, 0xf56d0200, 0x2be4ff00, 0x78b47580, 0x6eaa3d40, 0xfac30220, 0x1fa3ff30, 0x2152f598, 0x111a7d44, 0xdbe8a23a, 0xbda34f29, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xe8000000, 0xdc000000, 0x9e000000, 0xf9000000, 0x15800000, 0x4f400000, 0x42a00000, 0x3e300000, 0x3e380000, 0x0b340000, 0x2dba0000, 0x29710000, 0x089b8000, 0xd7064000, 0x44856000, 0x26c6b000, 0xa3e0a800, 0x6d931c00, 0xc98b5200, 0xe44a4900, 0x9d2a4380, 0x2f7848c0, 0x50915220, 0x960b4910, 0x8009c3a8, 0x750a08cc, 0x868e321a, 0x34ccf927, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x88000000, 0xc4000000, 0x9e000000, 0x1f000000, 0x60800000, 0x3a400000, 0xb3a00000, 0xa3700000, 0x19980000, 0x20740000, 0xfb1e0000, 0x47370000, 0x15398000, 0x73834000, 0xa0c7a000, 0x98e3b000, 0x17515800, 0xac2bb400, 0xea0b0a00, 0x4ab86900, 0x79453180, 0x3124d5c0, 0x34350a20, 0x7fbf6930, 0xd0c4b198, 0xd0e395fc, 0xb354aa02, 0xc22fd901, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xc8000000, 0x0c000000, 0xf6000000, 0x91000000, 0xbc800000, 0x02400000, 0x38e00000, 0x4a700000, 0x7b880000, 0xfd740000, 0x2e0a0000, 0x27b10000, 0x1ead8000, 0xfa274000, 0x0ed5e000, 0x341cf000, 0x760f6800, 0xf3b21400, 0x7cabfa00, 0xa9251300, 0x11550980, 0xe1dcdf40, 0x9729fa20, 0xaee01310, 0xcb7289a8, 0x5f0a9f7c, 0xcb319a12, 0x24eba313, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x78000000, 0x4c000000, 0x52000000, 0xe7000000, 0x28800000, 0x62400000, 0x00600000, 0x01300000, 0x4b480000, 0xec340000, 0x38ce0000, 0x2cf10000, 0xc1ef8000, 0x2f22c000, 0x42d5e000, 0xf2bc5000, 0x1258d800, 0x852a1400, 0x70014a00, 0x18015700, 0xdc036380, 0x1a033d40, 0xd3074a20, 0x36845730, 0xd742e3a8, 0xcfe0fd4c, 0x4bf52a3e, 0x296ec723, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xd8000000, 0xac000000, 0xe2000000, 0xb3000000, 0x03800000, 0xd5400000, 0x76600000, 0xaab00000, 0x09480000, 0x93b40000, 0xfdca0000, 0xa3770000, 0x6bea8000, 0x5921c000, 0xe3d7e000, 0x327ad000, 0x34bc7800, 0x6f9fcc00, 0x6f4b5200, 0xe6b13f00, 0xbb492780, 0x98b7c540, 0x42495220, 0x4c323f10, 0x0289a798, 0x12110544, 0x8cdc3216, 0xd42d2f3b, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xe8000000, 0x9c000000, 0x6a000000, 0xbf000000, 0xdd800000, 0xac400000, 0x42200000, 0xd0100000, 0xe8380000, 0x59140000, 0x80ba0000, 0x07d50000, 0xeb5f8000, 0x4da24000, 0x67536000, 0xf99d1000, 0x34409800, 0x5620fc00, 0xb6157a00, 0x653a2d00, 0x4f955a80, 0x077d5cc0, 0x3cb77a20, 0x1beb2d10, 0x0448da88, 0x381e1cec, 0xb2019a1a, 0x8b017d37, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x18000000, 0x74000000, 0x26000000, 0x43000000, 0xdc800000, 0x1c400000, 0x76a00000, 0xad100000, 0x82480000, 0x6c140000, 0xe3ce0000, 0x7bd30000, 0x23ac8000, 0xe723c000, 0xd2d72000, 0x9e2ef000, 0xeae73800, 0x1bb11400, 0xcf5e5a00, 0xbe5ae100, 0x97dd5280, 0xec1fe340, 0x7e785a20, 0x878de130, 0xe977d2b8, 0x50bb2354, 0x026dfa26, 0x5c43d12d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x58000000, 0xdc000000, 0xaa000000, 0xa9000000, 0x6b800000, 0xcbc00000, 0x64600000, 0x92900000, 0x7bf80000, 0xe5940000, 0xf77e0000, 0x8ad10000, 0xd85b8000, 0xf163c000, 0x83156000, 0x513a9000, 0xde722800, 0x802acc00, 0x4a4cf600, 0xc7daaf00, 0x74a24280, 0x2873c0c0, 0x432af620, 0x28cfaf30, 0xd79fc2a8, 0x830500ec, 0x02821636, 0x0043ff07, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x28000000, 0xb4000000, 0xde000000, 0x05000000, 0xd1800000, 0x5dc00000, 0x25e00000, 0x6bd00000, 0x8c480000, 0xaa540000, 0xb98a0000, 0xdbb30000, 0x9c5e8000, 0x7afa4000, 0x538f2000, 0x40b6b000, 0xa8dc0800, 0x66bebc00, 0x03aca600, 0xba84b300, 0x91434880, 0x45a7d940, 0xc1f22620, 0x857ef310, 0xf34c68b8, 0xc8d16964, 0x64ce2e2a, 0x3c104f3d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xe8000000, 0xac000000, 0x9e000000, 0x13000000, 0x0b800000, 0x68400000, 0x2fa00000, 0x21d00000, 0x99d80000, 0x3a540000, 0x899e0000, 0x01f10000, 0x82498000, 0x512e4000, 0x9298e000, 0x3674b000, 0xcc097800, 0xd98d6c00, 0x62cc7a00, 0xe6e8f100, 0x5f7bc480, 0x010647c0, 0xb685fa20, 0x38c6b130, 0x106324a8, 0x1032f7fc, 0x28ac821a, 0x17dbdd1b, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x18000000, 0x7c000000, 0xea000000, 0x27000000, 0x3a800000, 0x4c400000, 0x99600000, 0x4c700000, 0x04780000, 0xeef40000, 0x743a0000, 0xfd970000, 0xef4d8000, 0xdb6fc000, 0x31fa6000, 0xdc329000, 0xa71c5800, 0x0d86c400, 0xdec5fa00, 0xd1226f00, 0xb3120980, 0x9d0b94c0, 0x8b087a20, 0x060daf10, 0x7b886998, 0xfd4904fc, 0x306c2226, 0x997f6b0f, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x28000000, 0xbc000000, 0xae000000, 0xef000000, 0x5a800000, 0x58400000, 0xc3200000, 0xcf100000, 0x3c080000, 0xed940000, 0x104a0000, 0x0cb10000, 0x265e8000, 0x11384000, 0xdb0f6000, 0xdb173000, 0x6e091800, 0x0c936400, 0x35cf9a00, 0x26741d00, 0x013dd280, 0xb30f6540, 0xc7111a20, 0x500c5d10, 0xcb92b2a8, 0xd3485564, 0xd030022a, 0x2d1b393f, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x18000000, 0x3c000000, 0x6a000000, 0xdd000000, 0xdc800000, 0xf6c00000, 0xf9a00000, 0x9e100000, 0xfbd80000, 0x2e940000, 0xdf1e0000, 0x46370000, 0xff8e8000, 0xb22fc000, 0xa23b6000, 0xb2e29000, 0xe7f28800, 0xd7aef400, 0x7e7cfe00, 0x7a815900, 0x89c21e80, 0xbc20cfc0, 0xf2527e20, 0x5bbe9930, 0x74a17e98, 0xfa965fc4, 0x411ef626, 0xb5376d3f, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x78000000, 0xe4000000, 0xde000000, 0x8b000000, 0x44800000, 0xdcc00000, 0xeb200000, 0xb0700000, 0xb0e80000, 0x08f40000, 0xa62a0000, 0x2ed30000, 0x8ddf8000, 0xa078c000, 0xddcca000, 0xc7843000, 0xa443f800, 0x5de59400, 0xc653de00, 0x531f6d00, 0x1a5aed80, 0xcc3c5240, 0x1c2c5e20, 0x3bd7ad10, 0xa25e4db8, 0x883c626c, 0x922da63e, 0x78d53929, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xa8000000, 0x2c000000, 0x0a000000, 0x0d000000, 0x0d800000, 0xf3400000, 0x49600000, 0x53300000, 0x2ae80000, 0x6ab40000, 0x67ae0000, 0x50d10000, 0xea1c8000, 0x07fc4000, 0x1c09e000, 0x83c21000, 0x8fa08800, 0xcd12fc00, 0x46b95200, 0xbc6a5700, 0x0b765b80, 0xa9084840, 0x6a45d220, 0xaae61730, 0x7b77bba8, 0x910e5854, 0x4e435a0a, 0xdce1eb3b, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xe8000000, 0xcc000000, 0xba000000, 0x1d000000, 0x6c800000, 0x37400000, 0x06e00000, 0x9ad00000, 0x3dd80000, 0xcc540000, 0x579a0000, 0x46330000, 0x4a0f8000, 0x950c4000, 0xd08de000, 0x454b9000, 0x47ea0800, 0x345d7400, 0xa394f200, 0xa83f2300, 0xe907f480, 0x028125c0, 0x54437220, 0xb1676310, 0x8e1014b8, 0xb1f9b5ec, 0xb1a6fa1a, 0xdc365723, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x18000000, 0x2c000000, 0x62000000, 0x4b000000, 0xbd800000, 0x5cc00000, 0xb4200000, 0x31900000, 0xee880000, 0x7e140000, 0x414e0000, 0xebb70000, 0x86188000, 0xce1fc000, 0x3a1de000, 0x141ad000, 0xed1cb800, 0x0399bc00, 0xcede9e00, 0x443d7d00, 0x8a8c0280, 0xe8105140, 0x244e1e20, 0xaf36bd30, 0x345fe298, 0xb77d8174, 0x816a2626, 0x3420c13b, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x98000000, 0xb4000000, 0xb2000000, 0xf9000000, 0x2d800000, 0xa2400000, 0xd3e00000, 0x39300000, 0xaf980000, 0x9eb40000, 0xd0da0000, 0x6ad50000, 0xd6ac8000, 0x1129c000, 0x9e6d2000, 0x220e5000, 0x087be800, 0x7581bc00, 0x76463a00, 0x91e48300, 0x88316380, 0xae19b7c0, 0x3af2ba20, 0x48394310, 0x87664388, 0xf6f2e7f4, 0xfe3dd206, 0xa4653f3d, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x38000000, 0x74000000, 0x02000000, 0x4d000000, 0x9c800000, 0xdfc00000, 0x40e00000, 0x30300000, 0x09380000, 0x82b40000, 0x7dfe0000, 0x79d50000, 0x7f8d8000, 0x3d4cc000, 0x692a2000, 0xeadad000, 0xa5014800, 0x6081b400, 0xb1c47600, 0x0be71300, 0xdbb76780, 0x737f72c0, 0x8311f620, 0x9fefd330, 0x9cbb4788, 0x1bf4a2dc, 0x8bdb3e2e, 0xdf83a72d, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x28000000, 0x0c000000, 0x02000000, 0x39000000, 0xa5800000, 0x1b400000, 0x3ca00000, 0xb2500000, 0xd5780000, 0x61d40000, 0xe13e0000, 0xc7f50000, 0x2aa98000, 0x83ec4000, 0x4e4de000, 0x859a5000, 0x91a52800, 0xd1d4fc00, 0x293eb200, 0x1bf67900, 0xf0abb080, 0x9eeedac0, 0xe5cf3220, 0xa5de3930, 0x31805088, 0xdd458afc, 0xdba59a2a, 0xf4d78533, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x88000000, 0x0c000000, 0x46000000, 0x63000000, 0x7a800000, 0xf2c00000, 0x68e00000, 0x9cd00000, 0x57980000, 0x05540000, 0x9fda0000, 0xbf750000, 0x9bed8000, 0xfc394000, 0xc521e000, 0x20b57000, 0x868df800, 0x7eae2400, 0x139eae00, 0x2f55c300, 0x6aded880, 0xdef7f7c0, 0x97a92e20, 0x2c198310, 0x1412b888, 0xf27bc7fc, 0x5c053602, 0x7e02d713, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x48000000, 0x94000000, 0x72000000, 0xfb000000, 0xa2800000, 0x4f400000, 0x42200000, 0x52100000, 0xc7580000, 0x03940000, 0x1e9e0000, 0x2cf70000, 0x8daf8000, 0xc73d4000, 0xe0272000, 0x1114d000, 0xd9d9f800, 0x9ad14400, 0x9dbd4200, 0xb3673500, 0xd5332280, 0x32cfa7c0, 0x4c0cc220, 0xe7ed7530, 0xd29b8298, 0x12f637cc, 0x88aa1a32, 0x00bce115, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xc8000000, 0xec000000, 0x02000000, 0x77000000, 0x2f800000, 0x03c00000, 0x63600000, 0x94700000, 0xc9f80000, 0x14f40000, 0x51ba0000, 0x82550000, 0x07ad8000, 0xa15b4000, 0x6fe6e000, 0xde355000, 0x105a5800, 0x4964ac00, 0x9f708600, 0xfc7c1700, 0xb4349580, 0x3b5bd0c0, 0x8ce70620, 0xf7b25710, 0x7a9ff588, 0xb885c0fc, 0xbc43be12, 0x78a7ab2b, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x08000000, 0xc4000000, 0xea000000, 0x15000000, 0x17800000, 0x2cc00000, 0x6be00000, 0x05500000, 0x34280000, 0xf3d40000, 0x5d6e0000, 0x1df50000, 0x525c8000, 0x334d4000, 0xd2c6a000, 0x5ce01000, 0xe3d50800, 0xb56d2c00, 0xa9f3ae00, 0xe05c9300, 0xea4bb480, 0xeb426a40, 0x8f212e20, 0x8ab4d330, 0x8b799488, 0xdafb3a54, 0x7d3c8622, 0x865cef01, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0x94000000, 0x26000000, 0xdd000000, 0xe3800000, 0xf3400000, 0x47600000, 0x59300000, 0x19880000, 0x1bb40000, 0xab4e0000, 0xcc930000, 0x679f8000, 0x66e94000, 0xbe872000, 0xd0c27000, 0x5424c800, 0x2e55ec00, 0x08bf9200, 0x963cb700, 0x96f88b80, 0xbade0340, 0x488e1220, 0xf236f730, 0x9f082bb8, 0x3771334c, 0x9d6bfa32, 0x61c66b15, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x88000000, 0x24000000, 0x86000000, 0xd5000000, 0x3f800000, 0xddc00000, 0xa2600000, 0xb6100000, 0xe8d80000, 0xa0940000, 0x909a0000, 0x00350000, 0x3c6d8000, 0x67b94000, 0xc500a000, 0x27837000, 0xa1c10800, 0x78660c00, 0x49152600, 0xa059ff00, 0x11d5c680, 0x05bf01c0, 0xf602a620, 0x1d05bf10, 0x3b80e688, 0xabc131fc, 0xff610e02, 0xad91c319, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xd8000000, 0x6c000000, 0x52000000, 0x2b000000, 0x55800000, 0x9bc00000, 0x56600000, 0x18700000, 0x98a80000, 0x74f40000, 0x9dee0000, 0x1cd50000, 0x40388000, 0x7e6bc000, 0x8a17e000, 0x76db5000, 0x0159b800, 0x799a7c00, 0xee7b2600, 0x83cc6f00, 0xec049580, 0x9201a240, 0x0b05a620, 0x8586af30, 0x43c5f588, 0x3a643274, 0x4a737e16, 0xb3ac432b, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x88000000, 0x44000000, 0xf6000000, 0xef000000, 0x47800000, 0x38c00000, 0x8fe00000, 0x20700000, 0xcc780000, 0x96f40000, 0x283e0000, 0xe8550000, 0x4c688000, 0xf6394000, 0x5356a000, 0x55ecf000, 0xb5fed800, 0xe5354c00, 0xe65fde00, 0x47e05300, 0x8474cd80, 0xca7838c0, 0x21f15e20, 0xa3b81330, 0x6294ed88, 0xda8888f4, 0x7ec9a602, 0xe06cef21, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x38000000, 0xfc000000, 0xc2000000, 0x27000000, 0x32800000, 0x8ac00000, 0x84200000, 0x17d00000, 0xf6980000, 0x44540000, 0x77de0000, 0x2d330000, 0x136c8000, 0x341ac000, 0x86976000, 0x87fed000, 0x6ce75800, 0xc4f2c400, 0x5bcc4e00, 0xac0ac500, 0xb1a80080, 0x5439d9c0, 0x1f46ce20, 0xfc670530, 0xf935e0b8, 0x356ac9d4, 0x9d1c762e, 0x3916d10f, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x18000000, 0x6c000000, 0xaa000000, 0x81000000, 0x50800000, 0xdac00000, 0xf3200000, 0xdd500000, 0x15b80000, 0xf2d40000, 0x08fe0000, 0x18b10000, 0x51ce8000, 0x1b39c000, 0xaf11e000, 0x205e9000, 0xdea6e800, 0x25119400, 0x715c7e00, 0x3627ad00, 0x83d7a480, 0x307fd8c0, 0x0674fe20, 0x6ceb6d30, 0x996ec4a8, 0xad2d88c4, 0x73cb7626, 0x2e38a92b, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xa8000000, 0xec000000, 0x32000000, 0xb7000000, 0x11800000, 0x06400000, 0x7b600000, 0x5b300000, 0x05a80000, 0x1d740000, 0xdece0000, 0x76470000, 0x23648000, 0x2f364000, 0x23ade000, 0xdc70d000, 0xa64cd800, 0xe4861c00, 0xf8c10a00, 0x18a51700, 0x00170b80, 0xe4ff2640, 0x3b6cea20, 0x54d5c730, 0x6e5bd398, 0xbc793a54, 0x59ade00a, 0x1770d00b, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x08000000, 0x3c000000, 0xfe000000, 0xed000000, 0xae800000, 0x54400000, 0xba600000, 0x94f00000, 0xf4180000, 0xf0b40000, 0xf67e0000, 0x20410000, 0x18608000, 0xf7f54000, 0x6f9f6000, 0x3e73b000, 0xda588800, 0x1dd38400, 0x3b0d4a00, 0x0999e700, 0x87736580, 0xc6dec3c0, 0x82922a20, 0xf6ea5730, 0xa5abeda8, 0x8e4d47f4, 0x5b7f6022, 0xeec3b03f, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xf8000000, 0x14000000, 0xda000000, 0x33000000, 0xcc800000, 0xb7400000, 0xae600000, 0xc8700000, 0xbd080000, 0xf7340000, 0x6f6e0000, 0xa9410000, 0x7f648000, 0x83f2c000, 0x4cca2000, 0x25151000, 0xd1ff3800, 0xb179b400, 0xa83ca200, 0x1f5bd700, 0x80aed980, 0xaa640b40, 0x8a768220, 0x6a0ec730, 0x49b1e1a8, 0x072dbf54, 0x05a2201e, 0xe9511035, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x68000000, 0x8c000000, 0xe2000000, 0x19000000, 0x83800000, 0x61400000, 0x25600000, 0x9d900000, 0x37b80000, 0xf0d40000, 0xb0da0000, 0xd4410000, 0x74e18000, 0x2dd64000, 0x6d5fe000, 0x86005000, 0x3706a800, 0xd8860c00, 0x8bc04200, 0xafa67700, 0x55b38680, 0x6d4f86c0, 0x43ffa220, 0xf4362710, 0xf50d2ea8, 0x351d8adc, 0x10e5e03a, 0x03d15033, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x78000000, 0xbc000000, 0xc2000000, 0x49000000, 0x1b800000, 0x12c00000, 0x0e200000, 0xa8700000, 0x1ff80000, 0x3eb40000, 0x4fde0000, 0x4dc30000, 0xcaa38000, 0xbe34c000, 0xe7986000, 0xdea1d000, 0xc831a800, 0x4899cc00, 0x42235e00, 0x32756d00, 0xbaff3580, 0x2f371ec0, 0xd01b3e20, 0x2664bd30, 0xfb169db8, 0xfd6ad2ec, 0x781e603e, 0x9266d01f, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x18000000, 0x34000000, 0x8a000000, 0xd3000000, 0x90800000, 0x78c00000, 0xa6e00000, 0x31300000, 0x15280000, 0xc5f40000, 0xddce0000, 0x95c50000, 0xaf668000, 0x2a71c000, 0x4b892000, 0x32e09000, 0x6b313800, 0xfe29d400, 0x7171de00, 0x370f7300, 0xd426ef80, 0x84d74e40, 0x9498fe20, 0xb81fe330, 0xa6dfd788, 0x4d3a9a44, 0xa58f2026, 0x93e1903d, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x88000000, 0x1c000000, 0x4a000000, 0x4d000000, 0xfc800000, 0x22400000, 0x8b200000, 0x15900000, 0x5cf80000, 0xadd40000, 0x62da0000, 0xb0c70000, 0x7a638000, 0x19374000, 0xa0a96000, 0x61ca1000, 0x937c8800, 0x7810b400, 0xe83bfa00, 0x19b17d00, 0xb8ee9e80, 0x4fef4ec0, 0x566a9a20, 0xc4af6d10, 0x9fc81698, 0xd878facc, 0x3b92e002, 0xeff95017, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x18000000, 0x2c000000, 0xbe000000, 0xc7000000, 0xe2800000, 0x1b400000, 0x3be00000, 0xe8d00000, 0x07780000, 0x31940000, 0x1d9a0000, 0xf0c50000, 0x8d248000, 0x3ef1c000, 0x8d0fe000, 0x84d93000, 0xca215800, 0x9c71e400, 0xb6496200, 0x6f3c8b00, 0x3af03c80, 0xb70e74c0, 0x39de8220, 0xb5a1bb10, 0x28b36488, 0x216e90f4, 0x3cc96026, 0xd079f01b, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x98000000, 0xd4000000, 0x06000000, 0x91000000, 0xb3800000, 0xd7c00000, 0x2b600000, 0xef900000, 0x5f180000, 0x3a540000, 0x2b7a0000, 0xab430000, 0xaa258000, 0xb6b3c000, 0xb5292000, 0x5e38f000, 0xa4642800, 0x5910ac00, 0xdd5ab600, 0xa7f38700, 0xc409a280, 0x180e33c0, 0xe20b9620, 0xd90f7710, 0xd98f8ab8, 0xb2c99ffc, 0xb8eea006, 0x1e5c3025, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xc8000000, 0xfc000000, 0xfe000000, 0x81000000, 0x3e800000, 0x30c00000, 0x13600000, 0x8a300000, 0xfec80000, 0xf0f40000, 0x2eaa0000, 0xdb430000, 0xaf258000, 0xfe914000, 0xd4186000, 0xbc4db000, 0x7e35e800, 0x5ccb0400, 0x9ff10e00, 0xa92aaf00, 0xe1077780, 0x8e82fd40, 0x18c16e20, 0x1f631f10, 0xbc309fb8, 0x83cef97c, 0x3077e012, 0x9f6ff02f, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x48000000, 0xc4000000, 0xf2000000, 0x73000000, 0x24800000, 0x1dc00000, 0xe7600000, 0x2d700000, 0x01780000, 0x5eb40000, 0x4b1a0000, 0x22430000, 0x6a248000, 0x5dd54000, 0xe468a000, 0x2839d000, 0x4c13b800, 0x750bb400, 0x644ef600, 0xcaecdf00, 0x5afce580, 0x11f100c0, 0xd0be5620, 0x6fd10f10, 0x376d5db8, 0x3cbdb4f4, 0xc9d62032, 0x1e6f9021, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x68000000, 0x2c000000, 0x8e000000, 0x07000000, 0x16800000, 0x93c00000, 0x10a00000, 0x96700000, 0xadd80000, 0xffb40000, 0x607e0000, 0xd2470000, 0x3de08000, 0x59104000, 0x750fe000, 0xab1b3000, 0x08935800, 0x5049c400, 0x987d2600, 0x3647f100, 0x2fe70d80, 0x68157bc0, 0x208ac620, 0x8c58c130, 0x02f25598, 0xc71fbff4, 0x2691603a, 0xe74c703b, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xb8000000, 0x74000000, 0xae000000, 0x59000000, 0xfa800000, 0x11c00000, 0xdbe00000, 0x45f00000, 0x15780000, 0xd9340000, 0x0a1a0000, 0x4c050000, 0x9a048000, 0xd704c000, 0x73852000, 0x5340b000, 0xbe216800, 0x3012a400, 0x098a4600, 0x36cd0b00, 0xc2eca180, 0x9df974c0, 0x93f56620, 0x5878bb10, 0x7db14988, 0x2adb10f4, 0xa160000e, 0x1430000d, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x68000000, 0x1c000000, 0x1a000000, 0xb7000000, 0x1a800000, 0xedc00000, 0xeaa00000, 0xf9700000, 0xd3980000, 0x4fb40000, 0x11ba0000, 0x10030000, 0x58018000, 0x94044000, 0x76036000, 0xc5039000, 0xb1855800, 0xed400400, 0xb062d600, 0x09578100, 0xc728a580, 0x768dc9c0, 0xa77bb620, 0xd2271110, 0x07b47db8, 0xddbd8ddc, 0xf200003a, 0xeb000017, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x38000000, 0x04000000, 0x36000000, 0x2f000000, 0x1e800000, 0x05400000, 0x72e00000, 0x3c100000, 0x22180000, 0xaa540000, 0xbc7e0000, 0x6a030000, 0x6d038000, 0xdf86c000, 0x80c5a000, 0x67207000, 0x60b15800, 0x44694400, 0x9e1d5200, 0x58516300, 0x4578ca80, 0xeb8407c0, 0x4ec6f220, 0xac221330, 0xf83212b8, 0x562f83ec, 0xf678002e, 0x57040031, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x08000000, 0x6c000000, 0x02000000, 0x05000000, 0x1f800000, 0x27400000, 0xa2200000, 0x41900000, 0xb8280000, 0x41d40000, 0x908e0000, 0x90810000, 0x91c48000, 0x38e54000, 0x91f1e000, 0x4c185000, 0xf32f4800, 0xc952ec00, 0x054a1200, 0x36666d00, 0x5f37f680, 0x0a7ef040, 0x341df220, 0x072b3d30, 0x0f523ea8, 0x3e485c54, 0x26e28022, 0x0ef0402b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x98000000, 0x84000000, 0x22000000, 0x85000000, 0xd4800000, 0xc7400000, 0xd7200000, 0x09900000, 0x03b80000, 0x51d40000, 0xb11e0000, 0x81830000, 0xabc28000, 0xe463c000, 0xf4b0a000, 0x932dd000, 0x20ec0800, 0x808db400, 0xb63f1200, 0x30119d00, 0x5c7f3680, 0x9fb1c4c0, 0xdca9b220, 0x602b4d30, 0xeb6fbeb8, 0xe24cb0e4, 0x58dc8006, 0xb0e0c011, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x68000000, 0x94000000, 0x02000000, 0xd7000000, 0xfe800000, 0xfac00000, 0x07a00000, 0x93100000, 0xeab80000, 0xe4d40000, 0x989e0000, 0xf5870000, 0x42458000, 0x50604000, 0x31372000, 0x83eb5000, 0xb20e1800, 0xc37de400, 0xc7f06e00, 0xba494900, 0x001c8e80, 0x724108c0, 0x98614e20, 0xb5311930, 0x99e91698, 0x990bacdc, 0xabfb803a, 0xe8374015, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xe8000000, 0x4c000000, 0x3e000000, 0x4f000000, 0x63800000, 0x8ac00000, 0x97200000, 0x64300000, 0xbe480000, 0x03f40000, 0x73ea0000, 0x7d830000, 0x75c28000, 0xeca04000, 0x5af2e000, 0xb36eb000, 0x5ac41800, 0xdf20ec00, 0xd8312e00, 0x784f2500, 0xe8f43780, 0x62692b40, 0x8641ce20, 0xce669510, 0x61d0afb8, 0xf95e8744, 0x438a801a, 0xf3544003, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x28000000, 0x7c000000, 0xde000000, 0x7f000000, 0xa6800000, 0x6b400000, 0xe8e00000, 0xf5500000, 0xa9180000, 0x2b140000, 0xda7e0000, 0x82850000, 0x11468000, 0x2de04000, 0xb6d36000, 0x91dfb000, 0xd3341800, 0xab0dc400, 0x84eda200, 0x4338f300, 0x0366b080, 0x71966fc0, 0xaf38c220, 0x35664330, 0x52922888, 0xc7baebc4, 0x0926802a, 0x60f0402f, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x28000000, 0x14000000, 0xf6000000, 0xbf000000, 0x17800000, 0xf8400000, 0x21a00000, 0xfd300000, 0x41f80000, 0x92f40000, 0xd81a0000, 0xae630000, 0x34d08000, 0x556e4000, 0x6a3e2000, 0xd510f000, 0x4f885800, 0xa32e8c00, 0x889ffa00, 0x3da15100, 0xef30bb80, 0x90fd8ac0, 0x56715a20, 0xfddfe110, 0x2a86c3b8, 0xb6c3f6d4, 0xb966f82a, 0x77503c15, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x08000000, 0x24000000, 0xae000000, 0x05000000, 0x17800000, 0x73c00000, 0x6c200000, 0x71500000, 0xe5e80000, 0x3d140000, 0x6e0a0000, 0x26610000, 0x2bb58000, 0x4f1d4000, 0x2a6aa000, 0xd2d33000, 0x202e0800, 0x28334c00, 0x7ade7600, 0x374bbd00, 0xe205c480, 0x9f065640, 0xe4815620, 0xbd45cd10, 0x8a616ca8, 0xe1b62a7c, 0x44192822, 0xc8e93c19, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xb8000000, 0xfc000000, 0xf6000000, 0x53000000, 0xff800000, 0xc2400000, 0x07e00000, 0x50500000, 0x8dc80000, 0xd1940000, 0x5e6e0000, 0xc5250000, 0xf4778000, 0x1f3cc000, 0x766a6000, 0x71207000, 0x66727800, 0x7638cc00, 0x94ecca00, 0xe3e7e300, 0xaa53c080, 0xb0c9f940, 0xb1112a20, 0x2dab5330, 0xaf83d888, 0xaa45454c, 0x53e1980e, 0xd2517c0f, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xd8000000, 0x64000000, 0x3e000000, 0x41000000, 0xdc800000, 0x84400000, 0xe2e00000, 0x76500000, 0x0a180000, 0xaa940000, 0xe2be0000, 0xc7270000, 0x56758000, 0x05edc000, 0xd9bca000, 0xb4a53000, 0x87b42800, 0x73cf9400, 0x4b4f6a00, 0x310e1300, 0xf2ec4080, 0x283e3fc0, 0x7e664a20, 0x5216e330, 0xf8fcc898, 0x74c09bdc, 0x54a30816, 0x37b06429, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x58000000, 0x4c000000, 0x0e000000, 0x05000000, 0xc6800000, 0xcac00000, 0x5e600000, 0xb4300000, 0x83c80000, 0x04740000, 0x316e0000, 0x4f230000, 0x8a148000, 0x1d5dc000, 0x60ece000, 0xd060b000, 0x71334800, 0xa54bc400, 0x9eb23e00, 0x370a6700, 0xb712e780, 0x07da3540, 0x1c2a5e20, 0x97071730, 0x55854fb8, 0xa5454154, 0x0c252836, 0x7d95b423, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x48000000, 0x54000000, 0x1a000000, 0x07000000, 0x87800000, 0x86c00000, 0xdd200000, 0xcab00000, 0xa6680000, 0xb7f40000, 0x838e0000, 0x05650000, 0xa3d08000, 0x13bb4000, 0x85482000, 0x18409000, 0x49659800, 0x65d36c00, 0x7ab8ce00, 0xcfce3500, 0x56021380, 0xc1043240, 0xee806e20, 0xcc45e530, 0x9367ab88, 0x42d3ce74, 0x2d3b3832, 0x0109bc25, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xf8000000, 0x34000000, 0x5e000000, 0x83000000, 0x5a800000, 0x72400000, 0xc2e00000, 0xa6700000, 0xcfe80000, 0x10b40000, 0x5c4a0000, 0xdea30000, 0xaf928000, 0x0f18c000, 0x2f1d2000, 0x9f1b3000, 0x971cb800, 0x4b19a400, 0xd919ca00, 0x301b2300, 0xb79bb180, 0x1c596040, 0xf67e6a20, 0xe0acd310, 0x4bd029b8, 0x32f8f444, 0xb1e9981e, 0x23b6941d, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xe8000000, 0xdc000000, 0x32000000, 0xcb000000, 0xd1800000, 0x16c00000, 0x36a00000, 0x48700000, 0xb1d80000, 0x4d340000, 0x72be0000, 0x5e670000, 0xdfd58000, 0xb72c4000, 0xa5a96000, 0x0eecd000, 0x9489b800, 0x8d5d9c00, 0x7f732e00, 0x82581900, 0x68f64580, 0xd19fd3c0, 0x06d7ce20, 0x7dac8930, 0x9ae89d98, 0x6a899fdc, 0xec58d81a, 0x51f54c07, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xe8000000, 0x4c000000, 0x8e000000, 0xd9000000, 0xa8800000, 0x52400000, 0x3ea00000, 0x3ab00000, 0x44e80000, 0x32740000, 0x070a0000, 0x83e70000, 0x91948000, 0x269c4000, 0x9d78e000, 0xa8ed3000, 0x4c71a800, 0x860eb400, 0x5f629a00, 0xe9d51100, 0x03391780, 0x58498a40, 0xcfc6fa20, 0xba606110, 0xd7525f98, 0x9c790e74, 0x346b481a, 0x54308403, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x08000000, 0x6c000000, 0x22000000, 0xc9000000, 0x30800000, 0x47400000, 0x9ea00000, 0xfcb00000, 0x44f80000, 0x7d740000, 0x221a0000, 0xd0e70000, 0x72928000, 0x8f0b4000, 0xbf2fe000, 0xc7df5000, 0xf8002800, 0x34011400, 0x2607b200, 0x9706d100, 0xd387ef80, 0xd2c2eac0, 0xcb62d220, 0xec56c110, 0x166a2798, 0x827faec4, 0x8535c822, 0x7339440b, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x18000000, 0xa4000000, 0x1a000000, 0xc7000000, 0x46800000, 0x20400000, 0xbd600000, 0xc3900000, 0xba880000, 0xc2540000, 0x312a0000, 0xa4e50000, 0x41528000, 0x1da9c000, 0x6ba1a000, 0x16b21000, 0x587a1800, 0x154e6400, 0x8cf1fa00, 0x7219ff00, 0xa85a4e80, 0xa2384740, 0x0f28da20, 0x39e72f10, 0xe0d37688, 0x6b6df344, 0xee829826, 0xcc42a439, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x18000000, 0x44000000, 0xee000000, 0x29000000, 0x87800000, 0xe9400000, 0x6da00000, 0x2bd00000, 0x44a80000, 0x54140000, 0x33ce0000, 0xfd270000, 0xd4128000, 0xf3cbc000, 0x9d22a000, 0x4411b000, 0xebc86800, 0xd923cc00, 0xaa10c200, 0xc2ce7100, 0x5ea1e480, 0x4356c040, 0xaf6ee220, 0x75730130, 0x07f9ac98, 0xfb7f7c64, 0x46bce826, 0xfadb0c21, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0xbc000000, 0x06000000, 0xc3000000, 0x39800000, 0xcd400000, 0x5aa00000, 0x34b00000, 0xbdb80000, 0xcb740000, 0xb7da0000, 0x82250000, 0xa9718000, 0xfedac000, 0x26a26000, 0x52b1f000, 0x2ebaf800, 0xfaf67c00, 0xbe99b200, 0x6283f900, 0x58c67f80, 0xb9e3e0c0, 0x19105220, 0x728dc910, 0xc28f6788, 0xda8eacdc, 0x3689783e, 0x388dbc3f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x88000000, 0x84000000, 0xaa000000, 0x41000000, 0x94800000, 0x8ec00000, 0x8c600000, 0xab700000, 0xb2f80000, 0xa4340000, 0x36de0000, 0xe0e10000, 0xe9b18000, 0xb0994000, 0x1447a000, 0xd9a71000, 0xda932800, 0x77ce7400, 0x366e3e00, 0x70fee700, 0xf1337d80, 0xd05f7cc0, 0xd3261e20, 0x5751b730, 0xfa2e75a8, 0x555b58fc, 0x8da2a802, 0xc8973411, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xd8000000, 0x3c000000, 0x4a000000, 0xeb000000, 0xcf800000, 0x49400000, 0xb3e00000, 0xab300000, 0x82580000, 0xe2f40000, 0x217a0000, 0x02610000, 0xf7778000, 0xab3bc000, 0x3a006000, 0xd3069000, 0xe383b800, 0x6b41ac00, 0xbce3d200, 0x12b20300, 0x6a1d4380, 0x7592d5c0, 0x0c8e3220, 0x7a9e5310, 0x0d511ba8, 0xa32a29ec, 0x58cc3816, 0xe7fe6c1f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x08000000, 0xdc000000, 0x8e000000, 0x23000000, 0x99800000, 0x02c00000, 0x32200000, 0x75900000, 0x1d280000, 0xbbd40000, 0x834e0000, 0xd5230000, 0x06158000, 0x86ef4000, 0x11716000, 0xc89a3000, 0x9e6cf800, 0xef313c00, 0x7ef84e00, 0xbc9b3d00, 0x9c6e0a80, 0xda33c040, 0x607aae20, 0x7dd94d30, 0xdd8812b8, 0xa9048c5c, 0xb082f822, 0x72423c07, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xa8000000, 0x94000000, 0x06000000, 0xb1000000, 0x3b800000, 0x54c00000, 0x45e00000, 0xf9700000, 0x6b680000, 0x15340000, 0x86ce0000, 0xffe50000, 0x1a738000, 0xc7ec4000, 0x7b752000, 0x046b7000, 0x83b42800, 0xcb8a6c00, 0xf1c76e00, 0xb864d300, 0x3cb11d80, 0xa50ddc40, 0x1087ce20, 0x3c42e330, 0x15a59588, 0x46d1806c, 0x16bc280a, 0xb30e6c15, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x88000000, 0x44000000, 0xc2000000, 0x77000000, 0x96800000, 0x2a400000, 0x13a00000, 0xcc300000, 0x46a80000, 0x79f40000, 0xc0ce0000, 0x03a70000, 0x84328000, 0x62af4000, 0x2bf2a000, 0x3fcc5000, 0xd1269800, 0x6c702400, 0x060daa00, 0x71468900, 0x53236380, 0xbb703040, 0x608b8a20, 0x43069930, 0x8c83db98, 0xf1400464, 0x93269802, 0xdb702421, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xe8000000, 0x0c000000, 0xde000000, 0x65000000, 0xb1800000, 0xd9400000, 0x2ee00000, 0xa3100000, 0xe6880000, 0x3df40000, 0x9d9e0000, 0xcf7f0000, 0x0a6e8000, 0x0de64000, 0xc391e000, 0xd44e3000, 0xed548800, 0xf2ea5c00, 0x8b247200, 0x4933a300, 0x9c393680, 0x4b8de540, 0xb070fa20, 0x82d9ff30, 0xf09d4498, 0x22fe4664, 0x8529cc9a, 0xda041a73, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x38000000, 0x54000000, 0xf6000000, 0x63000000, 0xab800000, 0xad400000, 0xf0e00000, 0x64500000, 0x99d80000, 0x40b40000, 0xcb8e0000, 0x1a690000, 0xb0be8000, 0x44a6c000, 0x0e352000, 0x664ff000, 0xb048f800, 0x834b8c00, 0xb0cc6200, 0xd98df300, 0xe76a4c80, 0xb43b9fc0, 0x70649a20, 0xfe967f30, 0x6e7e2ea8, 0xbd026ce4, 0x6480d6ae, 0x04c4e0e5, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x7c000000, 0xc6000000, 0x11000000, 0x25800000, 0x60400000, 0xc0600000, 0x61100000, 0xdd280000, 0x4d740000, 0x323a0000, 0xcd5f0000, 0xa4cc8000, 0x9a264000, 0x36706000, 0xe8bcf000, 0x859ea800, 0xb769bc00, 0x22135a00, 0x13aa1700, 0xbfb76e80, 0xf69ae440, 0x41edf220, 0xc4d3ab10, 0x6d0c3498, 0xe404f354, 0xa2009cba, 0xf3064f4f, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xf8000000, 0x8c000000, 0xd6000000, 0x0b000000, 0xcb800000, 0xfec00000, 0xa4a00000, 0xe0900000, 0xe1180000, 0x78340000, 0xbf8e0000, 0x862f0000, 0x06388000, 0xe266c000, 0x6833e000, 0xe788f000, 0x3a2d7800, 0x78394c00, 0x9d647e00, 0xf9b21100, 0xc448b680, 0x5e0ea7c0, 0xade90620, 0x261b5d30, 0xc5b4c898, 0x7a48b6d4, 0x410fb09e, 0x6c6afad3, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x88000000, 0x84000000, 0xc6000000, 0xf5000000, 0xc8800000, 0xef400000, 0x13a00000, 0x79d00000, 0x31180000, 0x96740000, 0xf2ce0000, 0x286f0000, 0x433c8000, 0xc2654000, 0xe837a000, 0xffeff000, 0xa3fd4800, 0xfd021400, 0x8c87c200, 0x4942c100, 0x36a79880, 0x39504bc0, 0x5a5a8a20, 0x43d0d530, 0x7e185a98, 0xd1f68af4, 0x3a0b1282, 0x230b9ed1, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xd8000000, 0x3c000000, 0x16000000, 0x6d000000, 0xd6800000, 0x4cc00000, 0xeee00000, 0xa8d00000, 0x1ae80000, 0xd0340000, 0x1f3e0000, 0x3c5d0000, 0x33cf8000, 0x1585c000, 0x9b436000, 0x2aa2f000, 0x33f1c800, 0x78592400, 0x69cc5e00, 0x96801b00, 0xacc5fc80, 0x7ee7f240, 0xc0d59620, 0xfeed3f30, 0xfa37a288, 0x643ae96c, 0x87dfea96, 0xa98f0d7f, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x68000000, 0x8c000000, 0x6e000000, 0xff000000, 0x9b800000, 0xef400000, 0xe1600000, 0xa7100000, 0xa2580000, 0xd8740000, 0x024a0000, 0xa5a90000, 0x07788000, 0xbf804000, 0xed45e000, 0x0063b000, 0x7b965800, 0x32988c00, 0x34539200, 0xd53d5f00, 0xc4606680, 0x09953fc0, 0x6b9dca20, 0x0cd1d310, 0xa7f9f4a8, 0xb94160f4, 0xba652cba, 0x7e94acf3, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x98000000, 0x0c000000, 0xb2000000, 0x25000000, 0x69800000, 0xc3c00000, 0xa9600000, 0xdef00000, 0xdef80000, 0xd1940000, 0xdb0a0000, 0xd1ed0000, 0x35db8000, 0x91c3c000, 0x5c66e000, 0xbf75d000, 0x39380800, 0x5ef67c00, 0x9ef8c600, 0xf197bf00, 0x6b0d0d80, 0x49ef2ec0, 0x39d8ce20, 0x23c5c310, 0x7967cb88, 0xd6f191ec, 0xfafc4386, 0xf7902dd3, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xa8000000, 0xc4000000, 0x9e000000, 0x11000000, 0xfe800000, 0x52c00000, 0x16e00000, 0xef700000, 0x1ab80000, 0x78940000, 0x434a0000, 0x04e90000, 0x4b3c8000, 0xd5d64000, 0xf1eba000, 0x3bba3000, 0x9e176800, 0x8d8f6400, 0xb00b4e00, 0x474afb00, 0x7aeaf180, 0xaa3e50c0, 0xd3562620, 0xcf2c9f10, 0x775d3fa8, 0xfe62ebd4, 0x78b7778a, 0x64d8ffe1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xe8000000, 0x4c000000, 0xaa000000, 0x6d000000, 0x34800000, 0x82c00000, 0x69a00000, 0xd3900000, 0xe9a80000, 0xe7340000, 0x76be0000, 0xc85b0000, 0x4e288000, 0x42724000, 0x7a59e000, 0xf72b9000, 0xc8f6c800, 0xcb98d400, 0xc909ce00, 0x26231100, 0x3ad46680, 0x4f4b0240, 0xb5410620, 0xc4e0c530, 0xc37528b8, 0x94da5354, 0x40ec809a, 0x61d05763, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xc8000000, 0x44000000, 0xfa000000, 0x83000000, 0x1a800000, 0xbd400000, 0x1fa00000, 0xbad00000, 0x5bd80000, 0x4e740000, 0x8f8a0000, 0xbaed0000, 0x695d8000, 0xa7314000, 0xf22aa000, 0x7f3f1000, 0x5e05f800, 0x69006400, 0x01868200, 0x5bc62100, 0xd4e09080, 0x9872edc0, 0x82897a20, 0x316b4510, 0x799b9288, 0x2d558cdc, 0x2d1b4a92, 0x6112b8c1, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x98000000, 0x5c000000, 0xd2000000, 0x27000000, 0xaf800000, 0xa9400000, 0x1a600000, 0x19100000, 0xfd380000, 0x38740000, 0x39ae0000, 0xbb0f0000, 0xbc3e8000, 0xf6f5c000, 0x6e6b6000, 0x9ea9d000, 0xd4899800, 0x757ccc00, 0x7c958200, 0xef7f4700, 0x3f946680, 0x3efd3cc0, 0x6bd21a20, 0x681c8b30, 0xfa076498, 0xd303bbe4, 0x49831c86, 0x084767e7, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x28000000, 0x2c000000, 0x22000000, 0x03000000, 0xca800000, 0x75400000, 0xc4200000, 0xb3100000, 0x61e80000, 0xa8340000, 0x627e0000, 0x0b990000, 0xf2ea8000, 0x8ab64000, 0x9b3ae000, 0xfdb9d000, 0x6afab800, 0x0dd86400, 0x644c4200, 0x58e7bd00, 0x18f3de80, 0xeb9c6040, 0x82e8fa20, 0x12b6d930, 0x8f3d1ca8, 0xdbb99d44, 0x67ffc4aa, 0xe65a697b, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x78000000, 0x14000000, 0xea000000, 0xb3000000, 0x45800000, 0x24400000, 0x3ba00000, 0x47100000, 0x4f480000, 0x93b40000, 0x5bda0000, 0xadbf0000, 0x2b488000, 0xf1b6c000, 0x34df2000, 0xbe3d1000, 0x3a0e7800, 0xc2931c00, 0x4b0cca00, 0x18137900, 0xb4cb4e80, 0x8ef39940, 0x46f8b220, 0xf36f6510, 0x6fe70498, 0xf4b22074, 0xd45edcbe, 0x8afaec55, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x28000000, 0x54000000, 0x12000000, 0x5d000000, 0x69800000, 0xf0c00000, 0x96e00000, 0xd0f00000, 0x99780000, 0x69140000, 0xad0a0000, 0xa12b0000, 0x663a8000, 0x70304000, 0x879b2000, 0x9de65000, 0x9e778800, 0xe93f3c00, 0xe4b7de00, 0x6edec300, 0x43c10580, 0xa462a6c0, 0xe6b25620, 0x5bdeff10, 0x9e465bb8, 0xd6a725e4, 0x0552f3aa, 0xb6aa49c5, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x68000000, 0xac000000, 0x22000000, 0x35000000, 0x28800000, 0xc6400000, 0xc4600000, 0x9db00000, 0x73180000, 0xa6d40000, 0x1f2a0000, 0x390d0000, 0x1eda8000, 0x3f744000, 0xa33ae000, 0x1203d000, 0x8d010800, 0xcc877400, 0xd8476a00, 0xbb649f00, 0x2c375380, 0xbfdbddc0, 0x91f46220, 0x6e7aeb10, 0x11e0b988, 0x0f7602e4, 0x1b3b51ba, 0xf602a6fb, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xc8000000, 0x54000000, 0x0a000000, 0x3b000000, 0xf4800000, 0xf6c00000, 0xf2a00000, 0x0ab00000, 0xbbc80000, 0x21140000, 0x5afe0000, 0xea9f0000, 0x088c8000, 0x2af74000, 0xc0a92000, 0x8f879000, 0xa245b800, 0xb4601400, 0xe0121e00, 0x2d7ff900, 0xc4df3f80, 0x4ae80940, 0x7fe1a620, 0xe054ed30, 0x261fa198, 0x124fb074, 0xfe533992, 0xb7183465, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x08000000, 0x9c000000, 0xb2000000, 0xab000000, 0xc9800000, 0x74c00000, 0xdce00000, 0xd5f00000, 0x57380000, 0x0c140000, 0x924e0000, 0x2d6f0000, 0x8ff98000, 0xcaf14000, 0x60ba6000, 0x79d15000, 0xc82c7800, 0x63d87c00, 0xf5e60e00, 0x1f752300, 0x667a7d80, 0x6e33e4c0, 0xa45c7620, 0x48265f30, 0xb913f398, 0xeacc87dc, 0xb72beba2, 0x245aabd7, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x98000000, 0xc4000000, 0xb6000000, 0x7d000000, 0x51800000, 0xfd400000, 0x0b200000, 0xb2100000, 0xd4080000, 0x16340000, 0x4c9a0000, 0x7bff0000, 0x314a8000, 0x9911c000, 0x288ba000, 0x42f2f000, 0xeeff8800, 0xeccadc00, 0xee551200, 0xbca94d00, 0xf266be80, 0x2f346f40, 0xeb189a20, 0x9bb89110, 0xfbeb2c98, 0x4e47e264, 0x33a50486, 0x50d0ce61, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x48000000, 0x2c000000, 0x1e000000, 0xf1000000, 0x15800000, 0x4a400000, 0xd6e00000, 0x60500000, 0x38e80000, 0x25b40000, 0x0a3a0000, 0xaf990000, 0x60aa8000, 0xcc514000, 0x66eae000, 0x74b73000, 0x8fba2800, 0xadda7c00, 0x9a4eca00, 0xb2002300, 0xaf049480, 0x4486be40, 0xcfc6e220, 0xd4a75f10, 0x9ab2dea8, 0x46badd64, 0xec5816b2, 0x3a0e915b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xe8000000, 0x5c000000, 0xce000000, 0xef000000, 0x5f800000, 0x08400000, 0x82600000, 0xe4100000, 0xcd980000, 0xa9f40000, 0xf9ce0000, 0xb20b0000, 0xd62d8000, 0x4f5a4000, 0x21506000, 0xf97fb000, 0xb9265800, 0x37f0ac00, 0x2ecbea00, 0x498e8700, 0x5469d680, 0x583859c0, 0xe7c03220, 0x42246b30, 0x2a725cb8, 0xff896efc, 0x3f6fbc9a, 0x9dbc9ee7, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xa8000000, 0xcc000000, 0xf6000000, 0x37000000, 0x6f800000, 0xa1400000, 0xb6e00000, 0xfb500000, 0xb8180000, 0x9a340000, 0x460e0000, 0xcecf0000, 0x766e8000, 0xc05c4000, 0x2053e000, 0x119b7000, 0x54711800, 0x6b6d6c00, 0x06df2200, 0x75902300, 0x0fbfe480, 0x278259c0, 0x3d40ba20, 0x88e10f30, 0x90532698, 0x89990ae4, 0xc076468a, 0x696a3ac3, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x18000000, 0xa4000000, 0x36000000, 0xeb000000, 0xc3800000, 0x4bc00000, 0xfca00000, 0xc7300000, 0xedb80000, 0xac140000, 0x0f4a0000, 0x52090000, 0xe1ed8000, 0x083bc000, 0x84d5a000, 0x5c6df000, 0x24f83800, 0x91f7cc00, 0xd99e5600, 0x3360b100, 0x3d95d380, 0x798b72c0, 0x562bee20, 0xc69cbd10, 0xeee625a8, 0x815233dc, 0xa4ac05a6, 0x1fd903f9, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0xc4000000, 0x62000000, 0x1d000000, 0xbc800000, 0x3ec00000, 0xebe00000, 0x3f900000, 0x28a80000, 0xdcf40000, 0x93fa0000, 0x5ebd0000, 0xd21a8000, 0x482e4000, 0xbc35a000, 0xcb1dd000, 0xf6ae0800, 0x2ff31400, 0x247e6e00, 0x1bfee300, 0x4abdd680, 0xb81a8040, 0x012ae620, 0x4ab3b710, 0x2cde1888, 0xc3cdb364, 0x33a338aa, 0x5bb72361, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0xa4000000, 0x36000000, 0x2f000000, 0x6f800000, 0x05c00000, 0x40a00000, 0xc9b00000, 0xd2580000, 0x8a940000, 0x9c2a0000, 0x396f0000, 0x638f8000, 0xe75e4000, 0x2811a000, 0xe76a7000, 0xa8899800, 0xdedb2c00, 0x32d38600, 0xa04c1100, 0xc0f81780, 0x7a275dc0, 0x5ef59e20, 0x81b97d10, 0x76c23198, 0xc5253ccc, 0x497611ba, 0x187e0cf9, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xf8000000, 0x64000000, 0x5e000000, 0x09000000, 0xff800000, 0x9bc00000, 0xffe00000, 0x4ef00000, 0x2f380000, 0x02940000, 0x980a0000, 0x114b0000, 0x94ee8000, 0x573ec000, 0x2692a000, 0x2608b000, 0x084f2800, 0x936f6c00, 0xa8fb8600, 0x87701b00, 0x61f9ad80, 0xd8f28cc0, 0x0a3a2e20, 0xcf11b710, 0xd8c88bb8, 0xda2e27c4, 0x8d5eab9e, 0xb4a357c9, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x78000000, 0x5c000000, 0x6a000000, 0x01000000, 0x82800000, 0x94c00000, 0x0aa00000, 0x0f100000, 0xdc380000, 0x0d340000, 0xf6ea0000, 0x412f0000, 0xcc098000, 0x735ec000, 0xd2006000, 0x7d061000, 0x7885a800, 0x1dc1e400, 0xac26de00, 0xadd5f900, 0xbd9b9280, 0x81a20ec0, 0x3c92f620, 0xd27edd10, 0x3f572c98, 0xe15ee7fc, 0xcf054cbe, 0xf583f7c7, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x88000000, 0x14000000, 0xa2000000, 0x49000000, 0x4a800000, 0xc3400000, 0xfe600000, 0xc5b00000, 0x84b80000, 0xab540000, 0xf74e0000, 0xfd0f0000, 0x89ef8000, 0xef1d4000, 0x25c42000, 0xc321d000, 0xa4d02800, 0x508e2400, 0x6729a200, 0x3fb85f00, 0x50d43b80, 0x828d50c0, 0xc62e0a20, 0xd13f3b30, 0xb997b998, 0x21ebdfec, 0xeb1d9982, 0xdfc50ff5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xe8000000, 0xec000000, 0x62000000, 0x4f000000, 0xc6800000, 0xe1400000, 0x8a200000, 0x88f00000, 0xc4280000, 0xea540000, 0xd09e0000, 0x55db0000, 0xe1f98000, 0x4c0a4000, 0x9da1e000, 0xda36d000, 0xc2ced800, 0x31428400, 0x32204200, 0x1cf36d00, 0xd22f9180, 0xc3527640, 0xd71f1a20, 0x5f1fa930, 0x031833b8, 0x6918cb5c, 0xba19d39a, 0xf69e1b4b, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x68000000, 0x6c000000, 0x32000000, 0xad000000, 0x35800000, 0x12400000, 0x9e200000, 0x24900000, 0xa4180000, 0x59340000, 0x11ce0000, 0xc18f0000, 0x3aaf8000, 0x97ba4000, 0xcbe7e000, 0xa5f25000, 0xfb2bc800, 0x13f99c00, 0x76c64a00, 0xf3e7c500, 0xd1f26280, 0xad2b47c0, 0x50fa0220, 0xb4401930, 0x1525c898, 0x5a15d2ec, 0xa8da28ba, 0x7bd382eb, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xe8000000, 0x5c000000, 0x92000000, 0xe5000000, 0x75800000, 0xddc00000, 0xb7a00000, 0xfe900000, 0x50f80000, 0xa9b40000, 0xae2a0000, 0x2f2b0000, 0x2ca98000, 0x226e4000, 0xd34c6000, 0x469d5000, 0x22840800, 0x1d401c00, 0xe7e07600, 0xd0f78900, 0x3fccae80, 0x2cdf20c0, 0x55e7fe20, 0x65f2d510, 0xb24938b8, 0xb51bb9fc, 0xc443389a, 0xb060b9c7, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0x3c000000, 0xa6000000, 0xad000000, 0x67800000, 0xdbc00000, 0xd4a00000, 0x5e500000, 0x00580000, 0x70740000, 0xda4a0000, 0x3b4f0000, 0xa2ca8000, 0x00094000, 0xb9286000, 0xbfb8f000, 0x9dc14800, 0xa9a62c00, 0xd1d4a600, 0x779ce100, 0x8ad6e880, 0x1518fdc0, 0xfa956e20, 0xa47c8d10, 0x6960ae98, 0x07f5ace4, 0xc98aae82, 0xb3eaacdf, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0x94000000, 0x82000000, 0xa1000000, 0x13800000, 0x69400000, 0x90200000, 0x7d700000, 0xa7580000, 0x6bd40000, 0x52ea0000, 0x8cef0000, 0x2bec8000, 0x536c4000, 0x4cab2000, 0x0c4ad000, 0xbd5f6800, 0x66d6ec00, 0x1f6c3200, 0x02ad6500, 0xa3484580, 0x61db95c0, 0x8315da20, 0x4288c910, 0xb63bd798, 0x328460d4, 0x3ac3d7aa, 0x996060f5, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xb8000000, 0x94000000, 0x0a000000, 0x0b000000, 0x04800000, 0x7cc00000, 0x02200000, 0x09d00000, 0xb3980000, 0xe0740000, 0xd00a0000, 0xe20b0000, 0x3d0b8000, 0xd38cc000, 0x14482000, 0xaae91000, 0x4bfdb800, 0xf0459400, 0x12e20e00, 0x75f3dd00, 0x0b4f6480, 0xe46b27c0, 0xdc3e3620, 0x46e18910, 0xdff6cab8, 0x50492aec, 0xe8eeca8e, 0x8cfd2af5, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xc8000000, 0x24000000, 0x62000000, 0x07000000, 0x13800000, 0xec400000, 0xa8a00000, 0x6df00000, 0x2d080000, 0x5dd40000, 0xe93e0000, 0x793b0000, 0x913c8000, 0x853b4000, 0xff3aa000, 0x143ed000, 0x41bcd800, 0xc8ff6c00, 0x74d8aa00, 0xe6ea1100, 0x8f035980, 0x17801b40, 0xbe46f220, 0xb7a53d30, 0x9275d3b8, 0x874b9a74, 0x9075d392, 0x904b9a79, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xa8000000, 0x3c000000, 0xe2000000, 0x51000000, 0x84800000, 0xd1400000, 0x29a00000, 0xe2900000, 0xbfa80000, 0x00b40000, 0x5bfa0000, 0x02790000, 0x5dbf8000, 0x685e4000, 0xf5eb6000, 0x8090d000, 0xaea8a800, 0x24371400, 0xbabc3200, 0x83dd5100, 0x832e4280, 0x35f5c640, 0xa4591a20, 0x5fe90510, 0x7d9490a8, 0x502b074c, 0x3071108a, 0xc99c475f, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x68000000, 0x6c000000, 0x92000000, 0x6d000000, 0x94800000, 0x51c00000, 0x25600000, 0xcb500000, 0xd9680000, 0x01b40000, 0x847e0000, 0xe7fd0000, 0x73bf8000, 0xf9984000, 0x9f6de000, 0xaab15000, 0x7bf9c800, 0x69b89400, 0x689ad600, 0x41e95700, 0x92726880, 0x341ff240, 0x0c2a9e20, 0x6d108330, 0x4e4cde88, 0xbbc6b56c, 0x3c655eba, 0xe9d7f56b, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x98000000, 0x9c000000, 0xf6000000, 0x49000000, 0x20800000, 0x01400000, 0x84a00000, 0x88b00000, 0x9df80000, 0xa7940000, 0x1f8a0000, 0x440f0000, 0x66c88000, 0xcca9c000, 0xe07f6000, 0x5450f000, 0x096de800, 0x9f9f1400, 0x1f455200, 0x39a1f900, 0xea31d380, 0xf7be7cc0, 0xb8b23a20, 0x95fc2d10, 0xc3916198, 0xa58db5f4, 0x630be186, 0x934f75f7, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x58000000, 0x7c000000, 0x2a000000, 0x73000000, 0xe2800000, 0xd6400000, 0x58e00000, 0x1ef00000, 0x11280000, 0x30540000, 0x673a0000, 0x178f0000, 0x72468000, 0x4ee3c000, 0x27f06000, 0x90ab1000, 0x5c96b800, 0x959fa400, 0x7b9b7a00, 0x0e98cb00, 0x8d1e9180, 0xa6da9c40, 0xb8fda220, 0x27ac7f10, 0xb8135398, 0x22ddf344, 0xdef849b6, 0x56ae284f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x78000000, 0x74000000, 0x9e000000, 0x67000000, 0x17800000, 0xb2400000, 0xd8e00000, 0xc3100000, 0xc5880000, 0x91b40000, 0x8a7e0000, 0x992b0000, 0xb1418000, 0x9962c000, 0xfa572000, 0x90ecb000, 0x61e75800, 0x9391ec00, 0xf04d5a00, 0xf312c300, 0x9d8ef680, 0x75b5d940, 0x1c7d2220, 0xf22f9f30, 0x4cc4f4b8, 0xd226f65c, 0x52368ebe, 0xf63c856d, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xe8000000, 0x24000000, 0xc2000000, 0x21000000, 0xeb800000, 0xb0400000, 0x29200000, 0x5dd00000, 0x2a280000, 0x0cb40000, 0x6ada0000, 0xf1490000, 0x19448000, 0x56a04000, 0x3796a000, 0xbe0bd000, 0xb4e36800, 0x37b26c00, 0xdc5f9a00, 0x54899d00, 0xff217080, 0xe6d3ba40, 0xdcaa5220, 0x09702110, 0xdcbd82a8, 0xa9384b54, 0xd67cb89a, 0x23de0659, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xa8000000, 0x24000000, 0xde000000, 0xd1000000, 0x23800000, 0x0bc00000, 0x3d600000, 0x85f00000, 0x38280000, 0x07540000, 0x36be0000, 0x2f8f0000, 0xe4428000, 0x6ca04000, 0xc792a000, 0xf75b3000, 0x9b3ee800, 0xfd4ccc00, 0xaea12600, 0x8493ff00, 0x9fdbad80, 0xac789440, 0x916d6e20, 0x1a740330, 0xd1ec6398, 0xc933a744, 0x03c9e58a, 0xbce06879, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x58000000, 0x9c000000, 0x2a000000, 0x87000000, 0xde800000, 0x40c00000, 0x4be00000, 0xee300000, 0xaa480000, 0x7f140000, 0x109e0000, 0x19ef0000, 0x9f038000, 0xe287c000, 0x3ac66000, 0xa4e21000, 0xf4b21800, 0x5c8b4400, 0x99f36e00, 0xa72e9300, 0x2de48380, 0xeb328b40, 0x57cf1620, 0x6753c730, 0xeebbf598, 0x79b85c4c, 0x6f3b7bb6, 0xbbf81f57, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x58000000, 0x64000000, 0xe2000000, 0xfb000000, 0xc5800000, 0x4f400000, 0x27a00000, 0x05b00000, 0x3dd80000, 0x3f540000, 0x8cca0000, 0x8ebb0000, 0x8f028000, 0x3f87c000, 0x3040a000, 0x90215000, 0xe9f63800, 0xbbfa1c00, 0x97a6b200, 0x6db2c900, 0x71db7b80, 0x715229c0, 0xa9c82a20, 0x363d8510, 0x1cc1f1b8, 0x69e1fce4, 0x989763b6, 0xc0aaa5c9, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x18000000, 0x54000000, 0xce000000, 0x85000000, 0xc2800000, 0xebc00000, 0x9a600000, 0x6d500000, 0xdcb80000, 0x1af40000, 0x028e0000, 0x439d0000, 0xec068000, 0xca07c000, 0x73072000, 0x83823000, 0xff464800, 0xa0a2c400, 0xfbb50600, 0xdf2eef00, 0x9eae2080, 0x9eef68c0, 0x07cc6e20, 0xd83a1b30, 0xf8336e88, 0xe06e43e4, 0x1e09c8a6, 0xf5585ce5, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0x2c000000, 0x0a000000, 0x0f000000, 0xf8800000, 0x77400000, 0x3be00000, 0xc0700000, 0xd9c80000, 0x1ed40000, 0x395a0000, 0xb1ef0000, 0xd0058000, 0x58014000, 0x3401e000, 0x5e039000, 0x21015800, 0xd186f400, 0x8ac39200, 0xbb266300, 0x74527d80, 0x551cab40, 0x3c8b2a20, 0x3e370710, 0x4faab798, 0x46633c5c, 0x00b745a2, 0x0de88f5b, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x9c000000, 0xd2000000, 0x83000000, 0xed800000, 0x74400000, 0x16a00000, 0x36100000, 0x77280000, 0x9af40000, 0x469a0000, 0xd54f0000, 0x02878000, 0x13c2c000, 0x2de66000, 0x5734d000, 0x527b3800, 0x58f91c00, 0xcf3f2a00, 0x9cdec100, 0xe2e9fe80, 0x4217ee40, 0x512a7220, 0x7ff70d10, 0x2e1fec98, 0xf98b334c, 0x40e126be, 0xfbb3e277, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x98000000, 0xfc000000, 0xf6000000, 0x83000000, 0xcf800000, 0x83400000, 0x39200000, 0x9a700000, 0x61f80000, 0x7a140000, 0x8faa0000, 0x411b0000, 0x26828000, 0xe9c1c000, 0x8ee46000, 0x8397f000, 0x2fef3800, 0xc7ba2c00, 0x37b1b200, 0xd51ead00, 0x64813580, 0x18c49cc0, 0x5862ea20, 0x22577110, 0x250dbfb8, 0xde2f1de4, 0xf55aed86, 0xa22780ef, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xc8000000, 0x8c000000, 0xf6000000, 0x2d000000, 0xaa800000, 0xc9400000, 0x3ca00000, 0xfd100000, 0xdcc80000, 0x75f40000, 0xaffe0000, 0xc96b0000, 0x78658000, 0x71774000, 0x3fbce000, 0x0d4a7000, 0xeb314800, 0x289f8400, 0x759c1200, 0xd71e1900, 0x725bd680, 0x48f81940, 0x50efba20, 0xaaa0ed30, 0xe0130cb8, 0x5e4ec47c, 0xc0b49e92, 0xad5c9d53, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xe8000000, 0x24000000, 0x5e000000, 0xe3000000, 0x19800000, 0xd8c00000, 0xea200000, 0x63900000, 0x46f80000, 0xda740000, 0xb2ca0000, 0x59dd0000, 0x77648000, 0xa3744000, 0x264aa000, 0xe39b3000, 0xc0077800, 0x60001c00, 0x7000ae00, 0xb8054500, 0xcc037680, 0x7a0070c0, 0xbd077620, 0xfa836910, 0xc1402088, 0x32e169d4, 0x89b60e9a, 0x25696cd9, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xf8000000, 0x24000000, 0x8e000000, 0x75000000, 0x8e800000, 0xb1c00000, 0x68a00000, 0x59b00000, 0xc4180000, 0x2dd40000, 0x0f8a0000, 0x67bb0000, 0xd7e18000, 0xc0d2c000, 0x1509a000, 0x40783000, 0x1e434800, 0x61e42400, 0x31d2d600, 0x058cd900, 0x8cb9d780, 0x2463bbc0, 0x23923e20, 0x666bcd10, 0x8a69c9b8, 0x786986fc, 0xb7689f9e, 0xcae89fd9, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x28000000, 0x4c000000, 0x9e000000, 0x19000000, 0x96800000, 0x67c00000, 0xe9e00000, 0x28500000, 0x65980000, 0x27740000, 0x86ae0000, 0xd77d0000, 0xf6a28000, 0x67764000, 0x66abe000, 0xe7793000, 0xcea1e800, 0x03752400, 0xb4ae8600, 0x607ef300, 0x4127e880, 0xf236cdc0, 0x3a8a8e20, 0xa1cfe730, 0x0cea0688, 0xb0db5ac4, 0x9b5000aa, 0xf01ae9e3, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x88000000, 0xcc000000, 0xc6000000, 0xb9000000, 0xdf800000, 0x0ac00000, 0x41600000, 0x0db00000, 0x0d680000, 0x43140000, 0x303e0000, 0x2c0d0000, 0x9ea38000, 0xa5534000, 0x1b1ee000, 0x2c9ff000, 0x3a5de800, 0x253dac00, 0xe5892e00, 0xb567ff00, 0x4fb26780, 0x9e6ea640, 0xd3942620, 0xd478a330, 0x742d2188, 0x1eb3b54c, 0x5def8f82, 0x87530a43, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xe8000000, 0x34000000, 0x66000000, 0x5d000000, 0x03800000, 0xf8c00000, 0x5ea00000, 0xbc900000, 0xd6880000, 0xdbf40000, 0x853e0000, 0x822d0000, 0xb0648000, 0x47304000, 0x959e2000, 0x77bef000, 0xd36e0800, 0xd1018c00, 0x79879e00, 0xd7c0c100, 0xb6225e80, 0xf2d65740, 0x4769b620, 0xa702bd30, 0xec874888, 0x30435a74, 0xc0e4569a, 0xc573db7d, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x38000000, 0x64000000, 0x96000000, 0x11000000, 0x4d800000, 0xf5400000, 0x99e00000, 0x4cd00000, 0x3e580000, 0x1d740000, 0x2cea0000, 0x19bf0000, 0xaca18000, 0xf530c000, 0xe28fa000, 0xeb2ef000, 0x6d9c6800, 0xc750fc00, 0x321d1200, 0x05176b00, 0xaf78c080, 0x6503c7c0, 0x5384da20, 0xd8466710, 0xd6603a98, 0x069090fc, 0x9f3ca8ae, 0x7f673bc9, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xd8000000, 0xb4000000, 0x8e000000, 0x49000000, 0x70800000, 0xbec00000, 0x2f200000, 0x47300000, 0x59780000, 0x19d40000, 0x34ee0000, 0xbbd90000, 0x7ea38000, 0x2575c000, 0x52992000, 0x86c73000, 0xcb272800, 0x81375400, 0x4c7a4e00, 0x8b527500, 0xf92feb80, 0x237b34c0, 0xbed24620, 0x9d6f1130, 0x9d9f0da8, 0x8342d5cc, 0x77654396, 0x8bd0a0dd, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x08000000, 0x9c000000, 0x8a000000, 0x71000000, 0x0e800000, 0x5cc00000, 0x83600000, 0x31900000, 0x75280000, 0x51340000, 0x865a0000, 0x50cf0000, 0x90668000, 0x82114000, 0xc56f6000, 0x73909000, 0xb82d2800, 0xa5b7c400, 0xb39fbe00, 0x4928a700, 0xeb317e80, 0x8f584440, 0xda4ff620, 0xd2a4f310, 0x66776898, 0x017d6744, 0x25fad6a2, 0x383ec077, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xb8000000, 0xf4000000, 0x36000000, 0xb7000000, 0x99800000, 0x6bc00000, 0xa8200000, 0xac500000, 0x7df80000, 0x92b40000, 0xbd0a0000, 0x1c5f0000, 0xad208000, 0xfcd4c000, 0xc4ba2000, 0x62d6f000, 0x1fbdd800, 0x8955dc00, 0x9d7bd600, 0x43f6f500, 0x0169d080, 0x7cee80c0, 0xb92e2e20, 0xe20ed910, 0x89dd5e98, 0x64e269f4, 0x05f4888e, 0xfe6f9ced, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x28000000, 0xec000000, 0xea000000, 0xc5000000, 0x97800000, 0xb4400000, 0x6da00000, 0x2d300000, 0x32080000, 0x03540000, 0x56de0000, 0xb9cb0000, 0xf6b08000, 0x1c484000, 0x33f6e000, 0x786a9000, 0x11830800, 0x5b400c00, 0xdf229a00, 0x5ef41900, 0xc3ee6780, 0xafc21740, 0xa3e7f220, 0x4d96c530, 0x34b915b8, 0x471c9254, 0x112807aa, 0xbfa0c74b, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xd8000000, 0x84000000, 0xc6000000, 0xed000000, 0xf2800000, 0xb1c00000, 0x53200000, 0xc0500000, 0x9f880000, 0x40340000, 0xa53e0000, 0x68c90000, 0x6cd28000, 0x274dc000, 0x9795a000, 0xf1ae7000, 0x0ae48800, 0x1f730400, 0x65df1600, 0x60bac500, 0xe48ee880, 0xe7b7a340, 0xd27cbe20, 0x842a7130, 0x4ea0d6a8, 0xc8101244, 0xd2e9c896, 0x58041351, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x24000000, 0xce000000, 0xc9000000, 0x0b800000, 0xedc00000, 0xfda00000, 0x0a500000, 0x41680000, 0xf9b40000, 0x3f5a0000, 0xe12f0000, 0x54d68000, 0x052a4000, 0xbad6a000, 0xbc2fb000, 0xc9532800, 0x1ded8c00, 0xdef31600, 0x10ba5900, 0x5d1d5080, 0x0f4b6040, 0x72201e20, 0x19922510, 0x6dcbce98, 0xa4630544, 0x11f570ba, 0xc63a9059, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0x74000000, 0x6e000000, 0x55000000, 0x6e800000, 0xa9400000, 0x4c600000, 0xe1d00000, 0x8eb80000, 0xa2740000, 0x4e4e0000, 0xb7790000, 0x5a548000, 0x897a4000, 0xe7542000, 0x33fab000, 0xf0114800, 0x029b2400, 0x0b44d200, 0x4b609f00, 0xb0560080, 0x8a7cd4c0, 0x20d53a20, 0x3e3b4b30, 0x0637baa8, 0xe0addff4, 0xcdeea0aa, 0xd78824ed, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x38000000, 0xf4000000, 0x12000000, 0xe9000000, 0x82800000, 0x8c400000, 0x77200000, 0xfb700000, 0x4c580000, 0xbe940000, 0xe24a0000, 0x799d0000, 0x4e768000, 0x50dac000, 0x1dd22000, 0xfcebd000, 0x5d2c2800, 0x8fcda400, 0xfc5d7a00, 0xd690c500, 0x0e4d7d80, 0x8f9911c0, 0x8d75f220, 0xcf5c7110, 0x01160f88, 0xee8ba0c4, 0x53fbddae, 0xb4a101ed, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x08000000, 0x44000000, 0xce000000, 0x47000000, 0x6f800000, 0x35400000, 0x68200000, 0x6d300000, 0xdab80000, 0x11d40000, 0x6dee0000, 0xc1ff0000, 0x2ef48000, 0x075d4000, 0xba03a000, 0x9106b000, 0x04835800, 0x00c1ac00, 0xdc65a200, 0x69902500, 0x234fcf80, 0xd10a06c0, 0x16a9da20, 0x2ede7930, 0x4c449598, 0x38a23ff4, 0xcbf46fa2, 0xd5d8b6e1, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xc8000000, 0xd4000000, 0x72000000, 0xbb000000, 0x0c800000, 0xadc00000, 0x96e00000, 0xff900000, 0x59e80000, 0x0a340000, 0x8e5e0000, 0xb2290000, 0xc5d58000, 0x5e4d4000, 0xa6802000, 0x9ac45000, 0xa4603800, 0x7752d400, 0x168d6600, 0x49e3ab00, 0x29176680, 0xcb2bce40, 0xda50fe20, 0x7b0c6f30, 0xd7a418a8, 0x54b7e17c, 0xa89f4692, 0x404b9e45, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x38000000, 0x7c000000, 0xae000000, 0x81000000, 0xf6800000, 0x81c00000, 0xc2600000, 0x48300000, 0x90e80000, 0x23140000, 0x727a0000, 0x6b2b0000, 0xca768000, 0x7fccc000, 0xb3806000, 0xe5463000, 0x8ca12800, 0xedd1a400, 0x979cb600, 0x8c5a4f00, 0x753a8b80, 0x408b9240, 0xe4237e20, 0x65151b10, 0x177d75b8, 0xbfad4944, 0x4cb2ebae, 0x8e29a24f, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xa8000000, 0x44000000, 0x2e000000, 0x1d000000, 0x09800000, 0x3fc00000, 0x73e00000, 0x6ff00000, 0x60a80000, 0xdc540000, 0xf27a0000, 0xe36d0000, 0xddb18000, 0x628e4000, 0x0d40a000, 0xaca1b000, 0x8c568800, 0xea7c9c00, 0x2f692600, 0x47b71b00, 0xf988bd80, 0x5dc30c40, 0xb4e68e20, 0xdd707710, 0xffedb388, 0x1ff43b7c, 0x88a81d8a, 0xb852bc41, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0x84000000, 0xbe000000, 0x81000000, 0x57800000, 0x73400000, 0x23e00000, 0xa4900000, 0x48a80000, 0xa5b40000, 0x819a0000, 0x7fef0000, 0x18528000, 0x540d4000, 0x78c7a000, 0xc2a73000, 0xcc776800, 0x9cbfec00, 0x44da2200, 0x190d8b00, 0x3544f280, 0x7ee14840, 0x21106a20, 0x10ec1710, 0x66d41898, 0x04cb1f64, 0x8e635282, 0xc8d67871, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xb8000000, 0x4c000000, 0x7e000000, 0xd1000000, 0x7c800000, 0x91c00000, 0xaba00000, 0x7f700000, 0x45880000, 0x2b940000, 0x1f9e0000, 0x0f490000, 0xdfb18000, 0x82aec000, 0xad20e000, 0x75b3b000, 0xd1ac2800, 0x66a5f400, 0x75f23600, 0x514f5100, 0xbeb0e180, 0xe62eb740, 0x00e77e20, 0x1813d530, 0x33d81fa8, 0x21aaa25c, 0x1ea6018e, 0x99f00763, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x28000000, 0x4c000000, 0x9e000000, 0xf1000000, 0xe5800000, 0x58c00000, 0xb5e00000, 0xcf100000, 0x71b80000, 0xc5b40000, 0xd48e0000, 0xf67f0000, 0xdcd08000, 0xa2dc4000, 0xe8e7e000, 0x24913000, 0x907fa800, 0x89d73c00, 0xf55efe00, 0x8f206b00, 0xadf3e280, 0xae292cc0, 0x8b4e3620, 0xbb1e2730, 0x00835498, 0xb7444bd4, 0xd62202aa, 0xc4731ce3, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xa8000000, 0xa4000000, 0xc2000000, 0x77000000, 0x40800000, 0xc0400000, 0xc0a00000, 0xda700000, 0xf1e80000, 0x25140000, 0x1ffa0000, 0x846b0000, 0x92d28000, 0xbf984000, 0xcefaa000, 0xd1e9d000, 0x1512d800, 0xc7f8b400, 0x18696a00, 0x5cd55900, 0xae99a580, 0x3b788040, 0x26299220, 0x55777d10, 0x1d6a37b8, 0xf354fd64, 0x5259258a, 0x659fc079, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x48000000, 0x74000000, 0x46000000, 0xff000000, 0x46800000, 0xea400000, 0xdc600000, 0x02900000, 0x2b880000, 0x99340000, 0xefba0000, 0xd10b0000, 0x01738000, 0x6adf4000, 0xda1d2000, 0xce3bf000, 0xb1cf1800, 0xad572400, 0xc9285a00, 0x44844f00, 0x5b412280, 0xf1e3c540, 0x5853e220, 0xaaacdb10, 0x7540c0b8, 0x6ae01e6c, 0x40d2a2b2, 0x33ec854d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x68000000, 0xcc000000, 0x7a000000, 0x9d000000, 0x58800000, 0xd3c00000, 0xe4a00000, 0xdd300000, 0x08e80000, 0x53d40000, 0x983e0000, 0x786b0000, 0x6c128000, 0xf69a4000, 0x405de000, 0x987a1000, 0xc08cc800, 0xdbc2f400, 0xf8a36600, 0x2f33a900, 0x49ecc380, 0x1957e440, 0x1afece20, 0xbe4a0d30, 0xffe40db8, 0x4252e944, 0x1d7e43ba, 0xec0da443, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xa8000000, 0x34000000, 0x12000000, 0x37000000, 0xc6800000, 0x04c00000, 0xbae00000, 0x4e700000, 0xe2180000, 0x1dd40000, 0xb2ca0000, 0x0a9d0000, 0xb8118000, 0x63ae4000, 0x75ab2000, 0x98ac5000, 0x8d2a5800, 0x056f8400, 0x104cce00, 0x045e3b00, 0x89f09180, 0x3d5ba9c0, 0x1e763620, 0xfa1eaf10, 0xa1d4a788, 0x64cc06fc, 0x8799118a, 0x7d91e9dd, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xc8000000, 0x94000000, 0x6a000000, 0xed000000, 0x9f800000, 0x31400000, 0x21a00000, 0x4b500000, 0x2e680000, 0x13340000, 0x1f5a0000, 0x356b0000, 0x3fb58000, 0xa69b4000, 0xef0c2000, 0xa7809000, 0x2d408800, 0x3fa78c00, 0xbc507200, 0x94e87900, 0x29f4dc80, 0x65bfcc40, 0xb29b5a20, 0xc50b2510, 0xaa8786b8, 0xc2c0e95c, 0xc6e6dc92, 0x09f0cc75, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xb8000000, 0x44000000, 0x46000000, 0xf7000000, 0xa1800000, 0xc9c00000, 0x1d200000, 0xe6100000, 0x89b80000, 0x4a740000, 0xa1ca0000, 0x4ab90000, 0x55f18000, 0x7b0ac000, 0x401ca000, 0x35267000, 0x0a175800, 0x63bf9c00, 0xf7758600, 0x4d4fbd00, 0xd7fd6280, 0x9196e2c0, 0x1f7dfe20, 0x5ad19110, 0xc4189ca8, 0x932373fc, 0xad17628e, 0x8a3fe2c1, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x48000000, 0xec000000, 0xaa000000, 0x69000000, 0xf6800000, 0xbec00000, 0xcce00000, 0x18700000, 0x2d580000, 0x13d40000, 0x228a0000, 0x935f0000, 0x54d58000, 0xeb0b4000, 0x201be000, 0x1d729000, 0x31df6800, 0xa4110400, 0x68e82e00, 0x7de8bb00, 0x596d3180, 0x4aaba3c0, 0x46cb2620, 0x6b7b6f10, 0xf9461798, 0x10a0ccdc, 0x045531b2, 0xa6cfa3eb, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x78000000, 0x84000000, 0x0a000000, 0xfd000000, 0x40800000, 0x9c400000, 0xbee00000, 0xae900000, 0xbd480000, 0xcfb40000, 0xaefe0000, 0xdf4f0000, 0x0eb68000, 0x007ec000, 0x240fa000, 0x75d51000, 0xf62d0800, 0xb1e5f400, 0x57121a00, 0x0b8cfb00, 0x80176280, 0x860e8740, 0xd4d03220, 0xc8a9df30, 0x32a75098, 0xa8775864, 0xf7df62be, 0xe8fa8751, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x38000000, 0xbc000000, 0x2a000000, 0xa1000000, 0x75800000, 0x14c00000, 0x31a00000, 0xdeb00000, 0xba080000, 0x21540000, 0xd35e0000, 0x860d0000, 0xcb528000, 0x525ec000, 0xe3886000, 0xe7921000, 0xdffe2800, 0x173a9c00, 0xfc9fbe00, 0x8b280900, 0xd0a2cf80, 0x4b36e340, 0x9ecd7620, 0x38f74530, 0x89efb988, 0xaa01a644, 0x6102cfae, 0x5586e35f, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x18000000, 0xa4000000, 0x32000000, 0x75000000, 0xbb800000, 0xc2c00000, 0xa2200000, 0xe8300000, 0xfda80000, 0xd8540000, 0xa5fe0000, 0xbdab0000, 0xf8578000, 0xf5f9c000, 0x15aba000, 0x4456d000, 0x63ff4800, 0x52afec00, 0x8ad36e00, 0x1abf8500, 0x324ebb80, 0xc0c19240, 0x0f260620, 0x17b07930, 0xbd68bdb8, 0x1771eb6c, 0x524ebba6, 0xb0c19259, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xf8000000, 0x4c000000, 0xce000000, 0xad000000, 0xed800000, 0x2f400000, 0xfe600000, 0xb6900000, 0x22980000, 0x829c0000, 0xd29e0000, 0x3a9d0000, 0xfe9e8000, 0x84994000, 0xab9b2000, 0x251d5000, 0x4ad83800, 0x767f5400, 0x11ce2e00, 0x7ba1dd00, 0x6d306980, 0x1fab7d40, 0x753069a0, 0x63ab7d50, 0x233069b8, 0xf2ab7d4c, 0xf8b06986, 0x3ceb7d5f, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xc8000000, 0x1c000000, 0xba000000, 0xff000000, 0x99800000, 0x1c400000, 0xeca00000, 0x8b900000, 0xd8380000, 0x703c0000, 0x1c3e0000, 0x8e390000, 0x5d388000, 0xb6bec000, 0x49fe2000, 0x86dbf000, 0xee0c0800, 0x4310c400, 0xa4fc2600, 0x8c5d4300, 0xf9cc1f80, 0x60f45e40, 0x284c1fa0, 0x20b45e50, 0x9eec1f98, 0x64245e5c, 0x17541faa, 0x14585e5b, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x48000000, 0xe4000000, 0x9e000000, 0x8f000000, 0x52800000, 0x01400000, 0xada00000, 0x0c100000, 0x15a80000, 0x2dac0000, 0x41aa0000, 0x9baf0000, 0x7aa88000, 0xef2ac000, 0x58ede000, 0x6a091000, 0x44bd6800, 0x0f87fc00, 0x36c3f600, 0xf7609b00, 0x2175fb80, 0xd5dad6c0, 0x6df5fba0, 0x9b9ad6f0, 0x32d5fb88, 0x66cad6cc, 0xc2ddfb9a, 0xa376d6f5, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xe8000000, 0xb4000000, 0xb6000000, 0x31000000, 0x5e800000, 0x73400000, 0x36e00000, 0x50300000, 0xf4d80000, 0xb0dc0000, 0x9eda0000, 0x43df0000, 0xe75f8000, 0x4f18c000, 0x147d6000, 0xee88d000, 0x30715800, 0xcbbfac00, 0xb42e3600, 0xd5248100, 0xb8978080, 0x6e89e640, 0xf07780a0, 0x6bb9e670, 0xa42f8088, 0x3d25e674, 0x0c9580b2, 0xd88ae659, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x58000000, 0xf4000000, 0x52000000, 0xe7000000, 0xba800000, 0xadc00000, 0x31600000, 0x39300000, 0xa8880000, 0xaa8c0000, 0x558e0000, 0x7b0d0000, 0x54cb8000, 0xdaa94000, 0xad1ee000, 0xfa547000, 0x86bf4800, 0x50849c00, 0x2ec4f200, 0xe1e2f900, 0x57f47080, 0x296ad4c0, 0x2d7c70a0, 0x24e6d4d0, 0xa27270b8, 0x222bd4e4, 0x9fd9f0ae, 0x35b294d9, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x28000000, 0xcc000000, 0x86000000, 0x35000000, 0xf1800000, 0x17c00000, 0xf2e00000, 0x0f700000, 0xb0a80000, 0x26ac0000, 0xabaa0000, 0xee2d0000, 0x2be88000, 0x8e09c000, 0x0fffa000, 0xea139000, 0xed1e3800, 0x5d63b400, 0xe9b60a00, 0xa9cd1d00, 0x151aa680, 0xc96383c0, 0x6bb2a6a0, 0x66cf83f0, 0x7f98a698, 0xd62283dc, 0xf9102692, 0xb99b43ef, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x28000000, 0xe4000000, 0x5a000000, 0xeb000000, 0x44800000, 0xc6400000, 0x85a00000, 0x67d00000, 0x30a80000, 0x2eac0000, 0xefaa0000, 0xd82d0000, 0xc6ef8000, 0x130ec000, 0xa479e000, 0x06833000, 0x71406800, 0xb7244c00, 0xa4957e00, 0x688bd300, 0xc4bdad80, 0x826508c0, 0x39b5ada0, 0xbf1908f0, 0x74b7ad98, 0x169808e4, 0x6b722d92, 0x14fbc8dd, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xc8000000, 0xdc000000, 0xce000000, 0xb1000000, 0x28800000, 0xd7400000, 0x8fe00000, 0x08f00000, 0xef380000, 0x853c0000, 0x2e3a0000, 0x05bf0000, 0xb57e8000, 0xbc58c000, 0x188e2000, 0x69e05000, 0x35f1d800, 0x51be9c00, 0xc7792600, 0x535ad900, 0x7909de80, 0x8221c740, 0x7f51dea0, 0xa9adc770, 0xb933de88, 0xc69ec77c, 0x8aaf5eba, 0x2eb5074b, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xa8000000, 0xa4000000, 0x86000000, 0x83000000, 0x7e800000, 0x6bc00000, 0x9ea00000, 0xc6d00000, 0x6b280000, 0x512c0000, 0x682e0000, 0x6fad0000, 0x63ed8000, 0xe108c000, 0x0d3de000, 0x2e21d000, 0xda11c800, 0xc5083c00, 0xcb3c6200, 0xcd221700, 0xb4966180, 0x06ca98c0, 0xf19e61a0, 0x8df698d0, 0x5cb861b8, 0x296798d4, 0xf273e192, 0x7cfe58fd, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xa8000000, 0x1c000000, 0x9a000000, 0xdd000000, 0x80800000, 0xa5c00000, 0x08e00000, 0xb8500000, 0x4d880000, 0xb88c0000, 0xe40a0000, 0xfbcb0000, 0x3e2b8000, 0xaefec000, 0x5ab62000, 0x70def000, 0xf1821800, 0xc7451c00, 0xe427b200, 0xa6333500, 0xbf1bd780, 0xbc64cbc0, 0x5b91d7a0, 0x226fcbf0, 0x4d5a57a8, 0x24c10bf4, 0xf2647782, 0xf093fbf3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x18000000, 0x5c000000, 0x5a000000, 0x6b000000, 0x95800000, 0xb8c00000, 0x7ea00000, 0x00300000, 0x62e80000, 0xd5ec0000, 0xda6a0000, 0xa9af0000, 0x728e8000, 0xd27e4000, 0x9234a000, 0x1dea7000, 0xce6b2800, 0x27ac8400, 0x378dc200, 0x32ff7700, 0xd2755680, 0x7f0a71c0, 0xf6bf56a0, 0x169571f0, 0x46d9d688, 0x210731fc, 0x1687768e, 0xc94241eb, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x18000000, 0x94000000, 0xda000000, 0x25000000, 0x79800000, 0xf5c00000, 0x98a00000, 0x69b00000, 0x78e80000, 0xf1ec0000, 0x966e0000, 0x24ab0000, 0x648b8000, 0x437b4000, 0xe7f7e000, 0x448d3000, 0x137a1800, 0x5ff6d400, 0xc088fa00, 0xd17a7f00, 0xeef25280, 0x630a65c0, 0x01bc52a0, 0x0fd165d0, 0xff7fd288, 0xe1f625d4, 0x978e328e, 0x11fc15f1, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xf8000000, 0x1c000000, 0x0a000000, 0xc1000000, 0xc6800000, 0xd8c00000, 0xbae00000, 0xd6b00000, 0xe8880000, 0xfd8c0000, 0x650e0000, 0x62cb0000, 0x61a98000, 0x865e4000, 0x1d76a000, 0x59eaf000, 0x677af800, 0x62a3cc00, 0xc7968a00, 0x3f5c1d00, 0x87f48880, 0x2b2ffcc0, 0x4c9a88a0, 0x8a94fcd0, 0xebdb0888, 0x7236bcc4, 0xf54ba8b6, 0x67eb4cc3, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x88000000, 0xec000000, 0xc2000000, 0xe9000000, 0xc2800000, 0x95400000, 0x7ea00000, 0x65f00000, 0x0f180000, 0xa41c0000, 0xcf9e0000, 0xb85f0000, 0x43bf8000, 0xd0ebc000, 0x5604a000, 0x3f06b000, 0xbd83f800, 0x08c4ec00, 0x6660c600, 0x8b977300, 0x688b3c80, 0x0e915440, 0x280d3ca0, 0x52d25450, 0x842cbca8, 0x2a669454, 0x19979c8a, 0x298be46f, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x38000000, 0xa4000000, 0xd6000000, 0x35000000, 0x37800000, 0x1f400000, 0xbd200000, 0x78100000, 0xeef80000, 0xf5fc0000, 0x337e0000, 0x5dbf0000, 0x42da8000, 0x2c6b4000, 0xd7c66000, 0x92e4d000, 0x2ef77800, 0x860fc400, 0xcef6be00, 0x560c9700, 0x66f57780, 0x7a0e3040, 0x2cf377a0, 0x3d0d3050, 0xf877f7a8, 0x20c9707c, 0x6d9317a6, 0xfabae055, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xf8000000, 0x74000000, 0xea000000, 0x03000000, 0xb6800000, 0xf2c00000, 0x8e600000, 0x84b00000, 0xb8c80000, 0x19cc0000, 0xe04a0000, 0x5a090000, 0xffa88000, 0xb8ff4000, 0xb4c4e000, 0x8367b000, 0x7331a800, 0x438f1c00, 0xb5ed0a00, 0x8558b900, 0xb7943c80, 0x9d5b2ac0, 0x33963ca0, 0xef5e2af0, 0x7494bcb8, 0x4bd86afc, 0xf150dc86, 0x993c9ae1, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xb8000000, 0x0c000000, 0x02000000, 0xa7000000, 0xed800000, 0x9fc00000, 0xe2600000, 0xf0100000, 0x60480000, 0x694c0000, 0xb1ce0000, 0xfc8f0000, 0xb0a98000, 0x871c4000, 0x5e242000, 0x48b03000, 0xc8bf0800, 0xe3556400, 0x71691a00, 0x387cc900, 0xc8b6a980, 0x88bbfbc0, 0xc350a9a0, 0xa168fbd0, 0x807f29a8, 0xc4b7bbe4, 0x8abc8986, 0x6454cbe7, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x28000000, 0xbc000000, 0x82000000, 0x7b000000, 0x89800000, 0xc3c00000, 0x0be00000, 0x07700000, 0xed380000, 0xf83c0000, 0x70be0000, 0x45fb0000, 0x225a8000, 0x800bc000, 0xad262000, 0x0c163000, 0x530fe800, 0xd8a2a400, 0xedd33a00, 0x13ed2500, 0x7e507e80, 0x7f2dc740, 0x62367ea0, 0x729ac750, 0x5e6afe88, 0x7b96075c, 0x89c85e82, 0xb1c0f773, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x68000000, 0x84000000, 0xba000000, 0xed000000, 0xe9800000, 0x6bc00000, 0x58200000, 0xfad00000, 0x7e180000, 0x379c0000, 0x6c5a0000, 0x7c7b0000, 0xf2ac8000, 0x5eb7c000, 0x002fe000, 0x3ff03000, 0xc54c5800, 0x86479400, 0x49e30a00, 0x6ff62b00, 0x9d4dcd80, 0x4a406540, 0x87e14da0, 0x50f7a570, 0x1dceada8, 0x7207954c, 0x5902f5b2, 0x1b80016d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x98000000, 0x1c000000, 0xca000000, 0xe7000000, 0x4d800000, 0xb8400000, 0xaca00000, 0xd0f00000, 0x40180000, 0xfd9c0000, 0xadda0000, 0x357f0000, 0xbb8f8000, 0x52934000, 0xd38fa000, 0xa693f000, 0x2d8bc800, 0x1f962400, 0xc908a600, 0xdb566300, 0xbd6d1480, 0xb5c5dc40, 0x74e294a0, 0xcc569c70, 0x18ed3488, 0x39856c74, 0x8646fcae, 0xb5a34873, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x78000000, 0xc4000000, 0x5a000000, 0xa3000000, 0xd8800000, 0xbf400000, 0xfde00000, 0x0c900000, 0x50e80000, 0x146c0000, 0xe52e0000, 0x39cb0000, 0x1adf8000, 0x0ff44000, 0x3e3e6000, 0xa8e2b000, 0xd114a800, 0xaa29ec00, 0xe74a5600, 0xa89ed900, 0x3b948d80, 0x4a6f62c0, 0xfc2b0da0, 0x724b22d0, 0x951d6d88, 0xf15592f4, 0x514fc596, 0x0d9b7ec5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x98000000, 0xa4000000, 0x3e000000, 0x59000000, 0x2e800000, 0x9bc00000, 0x0d200000, 0x2e900000, 0x89c80000, 0x394c0000, 0x4b8a0000, 0x802d0000, 0x99798000, 0x1f954000, 0xcb4c6000, 0x408f9000, 0x15ac5800, 0x7f3eac00, 0x58f23200, 0xa0bfbb00, 0x61b01f80, 0x445a69c0, 0x89019fa0, 0x968329f0, 0x4fc7ff98, 0x3b21b9d4, 0x4b9227be, 0x3d4a55fd, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x58000000, 0xb4000000, 0xfe000000, 0x55000000, 0xc2800000, 0x6dc00000, 0x67a00000, 0x1dd00000, 0xf8e80000, 0xf46c0000, 0xc4ae0000, 0x2d8b0000, 0x079b8000, 0x6bd14000, 0xa1e8e000, 0xcce91000, 0x4a6cb800, 0x31af2c00, 0xff0e0200, 0x325a5f00, 0xb870e180, 0x423e7ec0, 0x610361a0, 0x7c833ed0, 0x98c58188, 0xb5212ed4, 0x2812b99e, 0x2b4f42f9, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x68000000, 0xa4000000, 0x02000000, 0xcf000000, 0xd9800000, 0x92400000, 0x26e00000, 0x6bd00000, 0x55880000, 0x360c0000, 0xf74a0000, 0x56290000, 0x5ebe8000, 0xf555c000, 0x8a4ce000, 0x88aef000, 0x217d8800, 0xdbf7c400, 0xc47b9600, 0xc976c100, 0x1db9af80, 0x2ad3ebc0, 0x450f2fa0, 0x20ca2bf0, 0xcd69cfb8, 0x9cdddbcc, 0x7242c7a2, 0x16e3dfe5, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x68000000, 0xc4000000, 0x2a000000, 0x1f000000, 0x62800000, 0xc7c00000, 0xb0600000, 0xb8f00000, 0xdee80000, 0x126c0000, 0x40aa0000, 0xdd490000, 0x98f88000, 0x9db3c000, 0x6949e000, 0x7afab000, 0x16b74800, 0x79cadc00, 0x0e3c2200, 0x2a51c100, 0x33fdf680, 0x1d3269c0, 0x258d76a0, 0xda1da9f0, 0xda8696b8, 0x9bc219fc, 0x56635ea2, 0x79f205cd, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x38000000, 0xac000000, 0x12000000, 0x8d000000, 0x42800000, 0x90c00000, 0x84600000, 0x05d00000, 0x1de80000, 0x596c0000, 0x3aaa0000, 0x434b0000, 0x29da8000, 0x5a134000, 0xbe0a2000, 0x0af8b000, 0x85e3d800, 0x90954c00, 0x7acf8a00, 0x109a0900, 0x2f305780, 0x7af880c0, 0x5de2d7a0, 0x2c97c0f0, 0x60caf7a8, 0x099870fc, 0xd3b1afa6, 0x75397cd7, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x78000000, 0xcc000000, 0x2e000000, 0xd5000000, 0xbe800000, 0xd4c00000, 0x57600000, 0x8d500000, 0x6ad80000, 0x1e5c0000, 0xa59a0000, 0x8b7d0000, 0xff6d8000, 0xc9964000, 0x85bc2000, 0xbf0f5000, 0xf140f800, 0x38268c00, 0x28756a00, 0xb82d7100, 0xf8b28b80, 0x454fc540, 0xcae70ba0, 0xce158570, 0xf1f92b98, 0x61abd574, 0x31f65386, 0x916a1947, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xc8000000, 0x8c000000, 0x86000000, 0x8d000000, 0x11800000, 0x66400000, 0xb1e00000, 0x16d00000, 0x33680000, 0x63ec0000, 0xf22a0000, 0x988f0000, 0x763b8000, 0x71c5c000, 0x9aa5a000, 0x16b79000, 0xd3fef800, 0x2966f400, 0x0b118600, 0xdfcb6900, 0x005a6f80, 0xe4535cc0, 0x15abefa0, 0x4bc99cf0, 0xa25dcf88, 0x5357ccd4, 0x572c97ba, 0xf509a8f7, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x78000000, 0x84000000, 0x36000000, 0xb5000000, 0x2e800000, 0x15c00000, 0xdc200000, 0xdb700000, 0x2a480000, 0x05cc0000, 0xb08a0000, 0x28690000, 0x87bc8000, 0xae474000, 0xf7676000, 0xba90d000, 0x611e7800, 0x3ef68c00, 0x980fe200, 0x30ac2300, 0x911bc880, 0xe6f272c0, 0xcc0d48a0, 0xceac32f0, 0xd81ea8b8, 0x7a77a2dc, 0x5acdb0a6, 0x8908fefd, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xc8000000, 0xfc000000, 0xde000000, 0x89000000, 0xa0800000, 0xccc00000, 0x58200000, 0x60b00000, 0xe3380000, 0x1ebc0000, 0x00fa0000, 0x9b1f0000, 0x8e0e8000, 0x8bc0c000, 0x49a32000, 0x98f3d000, 0x65da9800, 0xb92a1c00, 0x56f43a00, 0xd4d81b00, 0x8dae6e80, 0x88307f40, 0x13faeea0, 0x389fbf70, 0xd94f4e88, 0x10a0af7c, 0xa074f6ba, 0x0d1a6343, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x28000000, 0xe4000000, 0xc6000000, 0x3b000000, 0xcd800000, 0xbd400000, 0xab600000, 0xf7100000, 0x73780000, 0xe3fc0000, 0x783a0000, 0xab9b0000, 0xbeab8000, 0x7fa2c000, 0xc731e000, 0x2409d000, 0x92150800, 0x99f9e400, 0xb93e4e00, 0x671bb500, 0xef6afd80, 0x95065e40, 0xf2837da0, 0x86c39e70, 0x15231da8, 0x5df38e74, 0x1b2c75a2, 0xc6e17a4d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x58000000, 0x54000000, 0x32000000, 0x93000000, 0x77800000, 0x71c00000, 0x58a00000, 0x3b900000, 0xe0380000, 0x06bc0000, 0x0bfa0000, 0xa11f0000, 0x31ea8000, 0x79e04000, 0x8776e000, 0x29c97000, 0x4e34e800, 0x9928d400, 0xe1c69a00, 0x70a47f00, 0x97907380, 0x363b0a40, 0xffb8f3a0, 0xbb784a70, 0x955e9388, 0x8b8e7a5c, 0x6d561b9e, 0x2d1f9e49, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x28000000, 0xd4000000, 0xb6000000, 0xcd000000, 0xaa800000, 0x0fc00000, 0x5a600000, 0x61d00000, 0xdef80000, 0x977c0000, 0xa33a0000, 0xae190000, 0x396e8000, 0x47a7c000, 0xa8b56000, 0x6caed000, 0xaac7b800, 0x84e76c00, 0x48135200, 0x919ba100, 0xa02fdf80, 0x1006a040, 0x18035fa0, 0x9c046070, 0x9202bfb8, 0x5304704c, 0xb386e7b2, 0x13460c79, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x58000000, 0x54000000, 0xc6000000, 0x4f000000, 0x1f800000, 0x94400000, 0xfae00000, 0xe2d00000, 0xa4b80000, 0xe63c0000, 0xa4fe0000, 0x7ad90000, 0x192e8000, 0x69e44000, 0x6752e000, 0xa5fed000, 0x765fa800, 0x48ead400, 0x7243b600, 0xe5e54100, 0xb554a780, 0xccfe5a40, 0xd6dc27a0, 0x9b2f1a50, 0x48e64798, 0x3bd08a6c, 0xbc3b8f8e, 0x91f9ce79, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x48000000, 0x54000000, 0x5a000000, 0xaf000000, 0xe2800000, 0x6cc00000, 0xe7e00000, 0xa5900000, 0xd9780000, 0xcafc0000, 0x59ba0000, 0xbb190000, 0x75298000, 0x31e3c000, 0x8c956000, 0xfaf9b000, 0xa1bbc800, 0xd71a5c00, 0x23287a00, 0xd8e56500, 0xcf14d980, 0x81bbca40, 0x671f59a0, 0x1b2d0a70, 0xd4e1b9b8, 0x89127a74, 0x20bc91aa, 0x709b5661, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x78000000, 0x84000000, 0xf2000000, 0x79000000, 0x7d800000, 0x6bc00000, 0x8ce00000, 0xce900000, 0x83380000, 0xe1bc0000, 0xb4fe0000, 0xcb5d0000, 0x196a8000, 0x40e14000, 0xe0916000, 0x1c3cf000, 0x9f383800, 0x27be5400, 0x27fdca00, 0xbbda0d00, 0x85282980, 0x5ac3d840, 0x2d64a9a0, 0x43539850, 0x0cd949b8, 0xd7af286c, 0x578491a6, 0x46c1cc4d, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xf8000000, 0x3c000000, 0x8e000000, 0x1d000000, 0xac800000, 0x61c00000, 0x90e00000, 0xaf900000, 0x0ac80000, 0x314c0000, 0x330e0000, 0x4daf0000, 0xca9b8000, 0xf6644000, 0x2151a000, 0x85afd000, 0xde9a3800, 0x9c61dc00, 0x1e501200, 0x422bf500, 0x32d83980, 0x4fc7e7c0, 0x5de5b9a0, 0xdb10a7d0, 0xc70999a8, 0xd7a837f4, 0xbd9f8196, 0x65e17bfb, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xb8000000, 0x74000000, 0xbe000000, 0x97000000, 0xa3800000, 0xb5c00000, 0x50e00000, 0x65700000, 0x5cd80000, 0xaa5c0000, 0x691a0000, 0x3abd0000, 0xec6d8000, 0x76604000, 0xfe37e000, 0x6b7c1000, 0x7a8ba800, 0x10103400, 0xaf6b5a00, 0x5be0fd00, 0x94f6e680, 0x441a9840, 0xd83966a0, 0x412bd870, 0xeac10698, 0xef668874, 0x42b2ceb6, 0x413bec69, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x48000000, 0x74000000, 0x9e000000, 0x5b000000, 0x3f800000, 0xe3400000, 0xa1a00000, 0x52300000, 0xa6180000, 0xb55c0000, 0x1cfe0000, 0xdac90000, 0x92d28000, 0x348cc000, 0x63f16000, 0xc47c9000, 0xac0cc800, 0xf531f400, 0xd39f8e00, 0x031a1300, 0xe1da4a80, 0x683f8e40, 0x9c2b2aa0, 0xb7431e50, 0xefa7e298, 0xd132ea4c, 0xd5986c8a, 0xf418f951, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x68000000, 0x94000000, 0xb2000000, 0x49000000, 0x4a800000, 0x77400000, 0xeea00000, 0xd0f00000, 0x10680000, 0xb72c0000, 0x618e0000, 0x5d7b0000, 0xb3168000, 0x0339c000, 0x47336000, 0xdc8df000, 0xf5f93800, 0xf552ac00, 0xeb1a7600, 0xae84f300, 0x4d414c80, 0x23a263c0, 0xf0722ca0, 0xd22f93d0, 0x350b1488, 0x3d3d3ffc, 0xa0316292, 0xe909ccd9, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x28000000, 0xec000000, 0x6e000000, 0xff000000, 0x6f800000, 0x72c00000, 0xfd600000, 0x0ed00000, 0x83680000, 0x89ac0000, 0x00ca0000, 0x041f0000, 0x8a748000, 0xd559c000, 0xdbd4a000, 0x51e8d000, 0xa5eba800, 0x6fe91400, 0xc2ea2200, 0x646b1900, 0x4229c780, 0x200d48c0, 0x307d67a0, 0xd02598f0, 0xc976cf88, 0x4cdc8cec, 0x3214ed82, 0x310b95d7, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xd8000000, 0x2c000000, 0xbe000000, 0x41000000, 0xa2800000, 0xd0c00000, 0x71600000, 0xed900000, 0x76580000, 0x6a9c0000, 0xb5fe0000, 0x916f0000, 0xc1b48000, 0x31ee4000, 0x26712000, 0x070bd000, 0x83a55800, 0xdbf20c00, 0x044baa00, 0x7884f100, 0xcbc64580, 0x88e3bb40, 0xe4d765a0, 0x7e786b50, 0x572a3da8, 0xd216674c, 0x221f979e, 0x863d9647, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xd8000000, 0x84000000, 0xc6000000, 0xaf000000, 0x19800000, 0xe4400000, 0x29600000, 0x73b00000, 0x81280000, 0x096c0000, 0xfa0e0000, 0x44bf0000, 0x05128000, 0x86b84000, 0x2c126000, 0x103b5000, 0x61d4a800, 0x05182400, 0xbf076600, 0x31807d00, 0x9844c880, 0xdb6525c0, 0xc2b6a8a0, 0xb3ae75d0, 0x32aa00a8, 0x982a51fc, 0x07eb669e, 0x13c92cdd, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x68000000, 0x94000000, 0x3e000000, 0x63000000, 0x88800000, 0x66400000, 0xe4600000, 0xf0500000, 0xab980000, 0xe3dc0000, 0x6cba0000, 0x706f0000, 0xbbb58000, 0x230ac000, 0x9d646000, 0x7dd29000, 0x2a580800, 0x7b7c8c00, 0xbfccde00, 0x8e40ed00, 0xb067a780, 0x6e511740, 0x989bc7a0, 0x035f8770, 0x9ef9cf88, 0xaa0c0b64, 0x28e09192, 0x00162641, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xb8000000, 0x4c000000, 0xd6000000, 0x55000000, 0x8d800000, 0x82c00000, 0x3fa00000, 0x1c300000, 0x0d280000, 0x21ec0000, 0x274e0000, 0x70fd0000, 0x62168000, 0x05df4000, 0x26632000, 0xe7109000, 0x6058b800, 0x40a59400, 0x8ab3a200, 0x0b6a4f00, 0x0f085680, 0x271c0bc0, 0x49c376a0, 0x53209bd0, 0xe975ceb8, 0x43480fcc, 0x62f8ec96, 0x751100df, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x68000000, 0x24000000, 0x66000000, 0x51000000, 0x2b800000, 0x9ac00000, 0x07a00000, 0xaf300000, 0xa4b80000, 0xc07c0000, 0x1ada0000, 0x7c6f0000, 0x05148000, 0xd04bc000, 0xf0e0e000, 0xd354d000, 0xefaed800, 0x05364400, 0x77b97200, 0x7cff1f00, 0x8a9a7e80, 0xa28a7f40, 0x13429ea0, 0xba62af70, 0x6a164688, 0x86cbeb6c, 0xd3a3b492, 0x61333465, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x48000000, 0xb4000000, 0x46000000, 0xdb000000, 0xc8800000, 0x43c00000, 0x77200000, 0x28900000, 0xd5f80000, 0xc43c0000, 0x9e1e0000, 0xcd0f0000, 0xd7b08000, 0x296ec000, 0x87c56000, 0x39205000, 0x67920800, 0xab788c00, 0x14fef200, 0x95ba9b00, 0xe05b9780, 0xae681440, 0x0d46f7a0, 0x8fe44450, 0x4732ffa8, 0x06afc86c, 0x9ae28dba, 0x80b49341, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x48000000, 0xb4000000, 0x22000000, 0xdb000000, 0x54800000, 0xd1400000, 0xb9600000, 0x64500000, 0x5aa80000, 0xd0ec0000, 0x7d0e0000, 0x28190000, 0x7bd48000, 0x876ac000, 0x14c96000, 0xce3d7000, 0x13e12800, 0xe8104c00, 0x564b2600, 0xa6795d00, 0xc5023780, 0xb985dec0, 0x2cc557a0, 0x1fa1aed0, 0xa4f0ff98, 0xc0db22fc, 0xae72b98a, 0x1c9f0fd1, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xa8000000, 0xac000000, 0x4a000000, 0x21000000, 0x91800000, 0x59c00000, 0x08e00000, 0xb5300000, 0xdbe80000, 0xcb2c0000, 0x5e4e0000, 0x68b90000, 0x42b28000, 0xa92bc000, 0x9348a000, 0x533ff000, 0x4a727800, 0x984c3400, 0xd3b8da00, 0xca32ad00, 0x156cdc80, 0x8c6f47c0, 0x29ea7ca0, 0xde29b7d0, 0x61ca8498, 0x867e43cc, 0x18d2feb2, 0x595f1ee7, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xf8000000, 0xd4000000, 0x4a000000, 0x0f000000, 0x4a800000, 0xed400000, 0x44e00000, 0xd7500000, 0xaa780000, 0xe03c0000, 0x025a0000, 0xc6490000, 0xbdd78000, 0x373c4000, 0xecd8e000, 0x290fb000, 0x0a324800, 0xcced5c00, 0x3ae15600, 0x82568100, 0x77f99380, 0x43f8ac40, 0x19fb73a0, 0x8efe1c70, 0xc07ebbb8, 0x9f3f0044, 0x00df0d86, 0xd70a3171, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x98000000, 0xb4000000, 0xa2000000, 0xdf000000, 0x60800000, 0x6dc00000, 0xffe00000, 0xf2700000, 0x18a80000, 0x026c0000, 0x010a0000, 0x60bb0000, 0x86f18000, 0x47694000, 0x9a8ee000, 0x77fcf000, 0x2fd18800, 0x1078cc00, 0x7690c200, 0x505c8d00, 0x6c017680, 0xf6010fc0, 0x0d0596a0, 0x7786fff0, 0x21459ea8, 0x842773e4, 0x7093bc8e, 0x555b0ec9, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x58000000, 0xfc000000, 0x46000000, 0x3d000000, 0x7f800000, 0x8cc00000, 0x39600000, 0xbaf00000, 0x68f80000, 0x953c0000, 0x8dde0000, 0x9ae90000, 0xc2f08000, 0x04fe4000, 0x5b3fa000, 0x24d89000, 0x076ff800, 0xc9374400, 0x391a0200, 0x2f881900, 0x86031680, 0x9d00c540, 0xaf82b6a0, 0xe4c15550, 0x9d65ce98, 0x00f4515c, 0x13fe6c8e, 0xd7bdd863, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x68000000, 0xc4000000, 0x5e000000, 0xb9000000, 0x77800000, 0x37400000, 0xbfa00000, 0xe3300000, 0x3fe80000, 0x7dac0000, 0x5f8e0000, 0x34fb0000, 0x46378000, 0x6a68c000, 0xa1e8e000, 0x24ad1000, 0x18095800, 0xfbbd2400, 0x5591fe00, 0x135cd300, 0x7902f280, 0x978679c0, 0x074412a0, 0x47a069d0, 0x4f32ca88, 0xa5e98df4, 0x9aadd492, 0x910f4ec5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xc8000000, 0x94000000, 0xfe000000, 0xdf000000, 0x19800000, 0x59400000, 0x3c600000, 0xefd00000, 0xd6c80000, 0x7c8c0000, 0xdb6a0000, 0x08fd0000, 0x22d48000, 0x724ec000, 0x69486000, 0xb6ce9000, 0x8c8ee800, 0xf369e400, 0xacf9ce00, 0x14d37d00, 0x39490b80, 0x8ecb89c0, 0x308b6ba0, 0xa96819f0, 0x45f90398, 0x46533dfc, 0x878aadaa, 0x34efd0d9, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xf8000000, 0x94000000, 0xe2000000, 0x1f000000, 0xc1800000, 0xd0400000, 0x9b600000, 0x60700000, 0xacf80000, 0x41bc0000, 0xa45e0000, 0xa5e90000, 0x2a358000, 0xfc9e4000, 0xe24ce000, 0x57e6f000, 0x46b18800, 0xaa5ec400, 0x8ce82600, 0xf6b1cd00, 0x6259e680, 0x90ec5540, 0xe8b306a0, 0xf35fa550, 0x38690e98, 0x04762174, 0x66f848a6, 0xd2bf5c51, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xb8000000, 0xec000000, 0xee000000, 0xdd000000, 0x24800000, 0x2e400000, 0xfae00000, 0xb4500000, 0x50180000, 0x955c0000, 0x0a3a0000, 0x52ab0000, 0xcf178000, 0x8a7e4000, 0x954b2000, 0xefc35000, 0xdc243800, 0xaef25c00, 0x53a88e00, 0xed97c900, 0x0d3c3380, 0xd92d1f40, 0xfed513a0, 0x63594f70, 0x6b3caba8, 0x002e5354, 0x40508586, 0x02188a6f, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x38000000, 0x84000000, 0x6a000000, 0xb3000000, 0x21800000, 0x2e400000, 0xc0a00000, 0x70f00000, 0x91980000, 0x4edc0000, 0xc0fe0000, 0xa1cf0000, 0xefb18000, 0x3fbc4000, 0xffee6000, 0xb6863000, 0xf5c02800, 0x45e46400, 0xc5d1f600, 0x9d2e0300, 0x28e68c80, 0xb554b440, 0x6deeeca0, 0xe1818450, 0x4e4144a8, 0x30a6a064, 0x98f752a6, 0x2d9ed345, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xf8000000, 0x94000000, 0x2e000000, 0xd7000000, 0x86800000, 0x59400000, 0x19e00000, 0x28500000, 0x83d80000, 0xd79c0000, 0xe1fa0000, 0xa96b0000, 0x30968000, 0xcdfd4000, 0xf36be000, 0x59959000, 0xd47ba800, 0x40afdc00, 0xa3317600, 0x1ccce900, 0xbaa22380, 0x28b4d140, 0x6a0bc3a0, 0xc3864170, 0x1ac4eba8, 0xc323dd5c, 0xcb72fd96, 0xf8ace479, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x98000000, 0x6c000000, 0xd6000000, 0x37000000, 0x2d800000, 0x11c00000, 0xd3e00000, 0x71700000, 0x02c80000, 0x1e8c0000, 0xacaa0000, 0x26390000, 0x71878000, 0x4fc74000, 0x70e22000, 0x36f79000, 0x6a08a800, 0xbbe90400, 0x379cea00, 0xd1d7c500, 0xe01f7680, 0x8110ccc0, 0x997ad6a0, 0x84201cf0, 0xad905eb8, 0x823e88c4, 0x93841c9e, 0xa2c049df, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x18000000, 0x4c000000, 0x46000000, 0xf7000000, 0x18800000, 0x84400000, 0xbe600000, 0xcf500000, 0xc0380000, 0xa4fc0000, 0x62de0000, 0x2ded0000, 0x69828000, 0x4bc64000, 0xb2a62000, 0x1d771000, 0xe50f2800, 0xa1932c00, 0xb71b6e00, 0x0449ad00, 0xba76ef80, 0x35886a40, 0xe1d24fa0, 0xeb793a50, 0x2e1b47b8, 0x9fcd066c, 0xbcb701be, 0x56ab877f, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xb8000000, 0x64000000, 0xd6000000, 0x8b000000, 0xf1800000, 0x7dc00000, 0x9fa00000, 0x0f300000, 0xf6380000, 0x4e7c0000, 0x121e0000, 0x45890000, 0x37028000, 0x73834000, 0x78c26000, 0xf123d000, 0xed740800, 0xfb5e4400, 0xf96a8a00, 0x1dd2c700, 0x93ede680, 0x19905b40, 0x4d8d06a0, 0x4b00cb50, 0x51836e98, 0xedc15f4c, 0x57a3ecb6, 0xd334dc55, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x18000000, 0x3c000000, 0x16000000, 0xc5000000, 0x43800000, 0xd1c00000, 0x7b200000, 0x11300000, 0xacb80000, 0xb0fc0000, 0x231a0000, 0x7c890000, 0x05c78000, 0x39234000, 0x5634a000, 0xc83f1000, 0xd5bbb800, 0x257f6400, 0x57db0a00, 0x942ee300, 0xdd308280, 0xd2ba1b40, 0xe1fba2a0, 0x829a4b70, 0x5a4ebab8, 0xd2633f44, 0x695188be, 0xd6edf84b, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xc8000000, 0xbc000000, 0xbe000000, 0x15000000, 0x38800000, 0x4cc00000, 0x7d200000, 0xbf900000, 0x09380000, 0x1b7c0000, 0xbb9a0000, 0x2baf0000, 0xf6c68000, 0xc224c000, 0x00172000, 0x2e7fd000, 0x731af800, 0x0f6b7c00, 0x07e1fa00, 0x0bb26300, 0xa02f7780, 0xb3821a40, 0x9146d7a0, 0x61650a70, 0x02710f88, 0xbd8ea67c, 0x04d48dba, 0x2f5f7953, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x98000000, 0x4c000000, 0xc6000000, 0xd5000000, 0xb5800000, 0x70400000, 0x5be00000, 0xb2300000, 0x4ec80000, 0x790c0000, 0xddae0000, 0x6afd0000, 0x5ac18000, 0xad214000, 0x09112000, 0x6adc1000, 0x7a523800, 0x89bd5400, 0x21a1b600, 0xbad4d900, 0xfc7ea080, 0x62045ac0, 0x170600a0, 0x12850ad0, 0x0ac318b8, 0x15254ef4, 0xb517169e, 0xa4dc83e7, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x28000000, 0xc4000000, 0x7e000000, 0x3d000000, 0x4e800000, 0xd6400000, 0x3e200000, 0xaf100000, 0xda580000, 0xf79c0000, 0x257e0000, 0xc40d0000, 0xce618000, 0x9034c000, 0xc9c8e000, 0xec841000, 0xc9477800, 0x2fa54c00, 0x08d25e00, 0xd3bd9f00, 0x796a6f80, 0xb5d11940, 0xdd3d0fa0, 0xcf2cc950, 0x1bf317b8, 0x5a295574, 0xd176d1b2, 0x92699645, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x08000000, 0xa4000000, 0xda000000, 0x77000000, 0xf9800000, 0xeac00000, 0x6c600000, 0xe5b00000, 0xfab80000, 0xc6fc0000, 0x75de0000, 0xd8cf0000, 0x9ea38000, 0x65d7c000, 0x4108e000, 0x01433000, 0x35a20800, 0x1a568400, 0x1ac97200, 0x05a40100, 0xc253f480, 0x96cb1d40, 0xeba694a0, 0x6750ed50, 0xbc4ffca8, 0x22e29974, 0x96f466aa, 0xcc1f2c5d, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x68000000, 0x84000000, 0xda000000, 0x7b000000, 0x90800000, 0x00c00000, 0x9ee00000, 0xad500000, 0x85480000, 0xba0c0000, 0xe6aa0000, 0x1adb0000, 0x9ea38000, 0x9b74c000, 0x12fee000, 0x58153000, 0xcaec6800, 0x52f8ac00, 0xb8130a00, 0xfaefed00, 0x2afcbf80, 0x5412a1c0, 0xa4ebdfa0, 0x8bf851f0, 0xbf92d7a8, 0x34ad0df4, 0x15d955b2, 0x8c247cd5, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x48000000, 0xe4000000, 0xa6000000, 0xdd000000, 0x2f800000, 0x0ac00000, 0x94a00000, 0x1c900000, 0xdee80000, 0xbaac0000, 0xc14a0000, 0xfcbb0000, 0x4ee68000, 0x8670c000, 0x7699e000, 0xd531d000, 0x2df8b800, 0x4e808400, 0x5f417200, 0x69602700, 0x88b7cb80, 0xd43d90c0, 0xeca2aba0, 0x709780f0, 0xbced73a8, 0x71aa14dc, 0x7bcf59ba, 0x3dfc67e5, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x58000000, 0xc4000000, 0x42000000, 0xdb000000, 0x72800000, 0x48400000, 0x55a00000, 0xd1f00000, 0x8c780000, 0xafbc0000, 0x5bde0000, 0x05490000, 0x75208000, 0x8ab64000, 0xe75a6000, 0xd80b7000, 0x87062800, 0x54847c00, 0x01439e00, 0x9426e300, 0x77311480, 0x179e3340, 0xb2edf4a0, 0xafd60350, 0x1c4f3c98, 0x9ca64f5c, 0x50706a8e, 0xcab9e06d, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x98000000, 0xac000000, 0x86000000, 0xc1000000, 0x14800000, 0xc0c00000, 0x32e00000, 0x05100000, 0x79980000, 0x8adc0000, 0x7d7a0000, 0x16cb0000, 0x9c628000, 0xead24000, 0x8af92000, 0x41881000, 0x29c19800, 0xd260fc00, 0xcfd41a00, 0x3c7c7d00, 0xc24abd80, 0x7ca72540, 0xe8331da0, 0x17ea7570, 0x941325a8, 0x251bd97c, 0x6e1d078e, 0xcd9d0857, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x28000000, 0x74000000, 0x66000000, 0xaf000000, 0x94800000, 0x86c00000, 0x00200000, 0x8c500000, 0xc9380000, 0x5a7c0000, 0x631e0000, 0x53290000, 0xfba48000, 0x3e11c000, 0x1fd86000, 0x4e085000, 0x7a72a800, 0xd26c4c00, 0x0bc05a00, 0x35a32b00, 0xa5111180, 0x0d5b0c40, 0xd7cbf1a0, 0xc6d79c50, 0xacfbb998, 0xa4db407c, 0x4c8dab92, 0x9bb1b761, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xa8000000, 0x84000000, 0xea000000, 0xb7000000, 0xff800000, 0x7a400000, 0xa0600000, 0xcd100000, 0xbad80000, 0xa61c0000, 0xfeba0000, 0xb10d0000, 0xbb628000, 0x9c93c000, 0x7d99e000, 0xbefdb000, 0x1e698800, 0x55f43400, 0x9a084600, 0xa2e55500, 0x2fd7a580, 0x277c5f40, 0x6d2ec5a0, 0xef132f70, 0xb9de2d98, 0xfb986b4c, 0x47fe83b2, 0xacea7a6d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x48000000, 0x0c000000, 0xfa000000, 0x93000000, 0xb3800000, 0x89400000, 0x2e200000, 0xbe900000, 0x4b280000, 0x74ec0000, 0x990a0000, 0x087d0000, 0xb5278000, 0x2111c000, 0x886fa000, 0xd1cb7000, 0xd01b6800, 0x3c13b400, 0x86e91e00, 0x260fff00, 0xf1fff380, 0xb76266c0, 0xf8b5d3a0, 0x49b9d6f0, 0xddc49b98, 0x3ae1d2e4, 0xd4f4cd8a, 0x5d1a29e7, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x98000000, 0x14000000, 0x82000000, 0x61000000, 0xf1800000, 0x5e400000, 0xbe600000, 0x5b100000, 0x5d980000, 0x7d5c0000, 0x8bfa0000, 0x6a4f0000, 0xe0648000, 0x84144000, 0x631ae000, 0x559ff000, 0xe1597800, 0x55ff3400, 0x754ee600, 0x7ee3c500, 0xdcd6b580, 0x91b9c540, 0x7e2ad5a0, 0xf6717570, 0xce0fcd88, 0x3b06f16c, 0xe48433ae, 0xfdc2b069, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x58000000, 0x54000000, 0x52000000, 0x71000000, 0x8a800000, 0x20c00000, 0xb8600000, 0x41300000, 0x49f80000, 0x1cbc0000, 0xc19e0000, 0x558b0000, 0x24638000, 0x5f354000, 0x9efde000, 0xa53e7000, 0x42df7800, 0x13acec00, 0xaff7ca00, 0x9e9e5900, 0x000b7880, 0x1120f340, 0x721318a0, 0xe2ecc350, 0xc8d40088, 0x678c1f54, 0xa564d29e, 0x3db29a41, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x78000000, 0x44000000, 0xca000000, 0x45000000, 0xdd800000, 0xd8400000, 0x66200000, 0x58d00000, 0xa3780000, 0x555c0000, 0xb58a0000, 0x32f10000, 0xbdad8000, 0x35244000, 0x9e576000, 0x31bcb000, 0x27bad800, 0x3cbb5400, 0x76392600, 0x62fccf00, 0xb31f5d80, 0x54aa6040, 0xdea585a0, 0xed113470, 0x151ca3b8, 0x47adfb74, 0xb823fe26, 0x0fd79b25, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x18000000, 0xdc000000, 0xbe000000, 0x63000000, 0x25800000, 0x30c00000, 0xf1200000, 0xf5b00000, 0xb6f80000, 0xafdc0000, 0xbe6e0000, 0x3a950000, 0x60488000, 0x5ca64000, 0x1175a000, 0x6dd8d000, 0x736d8800, 0x34110400, 0x810c5200, 0xe7445300, 0x14e1fa80, 0xd6119f40, 0x1c0c72a0, 0xc1c09b50, 0x31a020b8, 0x0ff4c85c, 0xc499da3e, 0x3c89572b, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x98000000, 0x5c000000, 0xba000000, 0xd5000000, 0x78800000, 0x89c00000, 0xa3600000, 0x24900000, 0xf1880000, 0x6eec0000, 0x207a0000, 0x8cf30000, 0x6e9e8000, 0xb9204000, 0xa5b1a000, 0xf83af000, 0x94d41800, 0x0daa7c00, 0xdbdec200, 0xb584c100, 0x6d451980, 0xb0a217c0, 0x62f101a0, 0x35986bf0, 0x4aa7c3a8, 0x57f0aafc, 0x5d18da0e, 0x6b61bd2b, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xb8000000, 0x3c000000, 0x6a000000, 0xf9000000, 0xe9800000, 0x81c00000, 0x0be00000, 0x2e500000, 0x0cc80000, 0xed2c0000, 0xfa7a0000, 0x3f330000, 0xe3da8000, 0xaa454000, 0x8727a000, 0x02367000, 0xbc58f800, 0x28821400, 0x94436a00, 0xc0214d00, 0x6cb76b80, 0x731bc7c0, 0x5c2793a0, 0x76b5d3f0, 0x121ef9a8, 0x39a79edc, 0x25731206, 0xdcf91913, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xe8000000, 0x94000000, 0x56000000, 0xcb000000, 0x74800000, 0xdb400000, 0x09a00000, 0x78d00000, 0x55480000, 0x5aec0000, 0xb13e0000, 0xccf70000, 0x7f5c8000, 0xb2c5c000, 0x2d666000, 0xfeb05000, 0x0f7fc800, 0x96d40c00, 0x524d8600, 0x246a8300, 0x937a8980, 0xc4d2c5c0, 0xf74d41a0, 0x17eac9d0, 0x16bec7a8, 0x1f374aec, 0x6fb8ce12, 0x5eb04f09, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xd8000000, 0x9c000000, 0x56000000, 0xa1000000, 0x7f800000, 0x03c00000, 0xb6e00000, 0x34100000, 0x0f780000, 0x279c0000, 0x668a0000, 0x54750000, 0x732c8000, 0x6fc04000, 0x18e1a000, 0x59179000, 0x4efed800, 0xc15e8400, 0x65e80a00, 0x94a1e500, 0x14358180, 0x000bd040, 0xc43359a0, 0xa8095470, 0x60315398, 0xd20db15c, 0x4f30522e, 0x908a213b, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x18000000, 0xd4000000, 0xa2000000, 0x43000000, 0xbb800000, 0xcdc00000, 0xede00000, 0xbf500000, 0x0c580000, 0xa7bc0000, 0xa1ee0000, 0x61310000, 0xa2c88000, 0x78064000, 0x2401e000, 0x5a047000, 0x27042800, 0x01821400, 0x5ac70a00, 0xf461cd00, 0x3196e380, 0x5a3f2b40, 0xd52acba0, 0x40513f50, 0x79dbc198, 0x0f7df27c, 0xbe8ba21e, 0x27259909, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x78000000, 0x94000000, 0xba000000, 0xe9000000, 0x7b800000, 0x7d400000, 0xa5200000, 0xccb00000, 0xa9080000, 0xba2c0000, 0xc19e0000, 0x08170000, 0xa1fb8000, 0x95864000, 0x4e45e000, 0x07a3b000, 0xa276b800, 0x9d6a8400, 0xfdbfde00, 0xf726cf00, 0x89b4ee80, 0xdc8c58c0, 0x846a56a0, 0x8e3adcd0, 0x566388a8, 0x6a9713d4, 0xaf3ae636, 0x91e60b31, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x38000000, 0x2c000000, 0x0a000000, 0x69000000, 0x45800000, 0xf5c00000, 0x9ae00000, 0x21300000, 0x79480000, 0xcdac0000, 0x3b9a0000, 0x58510000, 0x0ebe8000, 0x62854000, 0x17452000, 0x4da3f000, 0x0c91f800, 0x05d8f400, 0xf073aa00, 0xe7ef0500, 0xb5be3880, 0xd205b8c0, 0xf507c0a0, 0x17814cf0, 0xc0c66ab8, 0xed6349ec, 0x91f4d236, 0xac2eb127, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0xc4000000, 0xd6000000, 0xe3000000, 0xb4800000, 0x19400000, 0x2c600000, 0xa5900000, 0xe6b80000, 0x49dc0000, 0x88ce0000, 0x7f330000, 0x768e8000, 0xd1d44000, 0xb9596000, 0x078d5000, 0x10500800, 0x579fcc00, 0xb62cd600, 0x18e1fd00, 0xfcd67d80, 0x6adace40, 0xdc4875a0, 0xf6760250, 0xf2ea2388, 0x2843bf5c, 0x4de53e2e, 0x7b54212d, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xc8000000, 0xa4000000, 0xca000000, 0x79000000, 0x68800000, 0x49400000, 0xf2200000, 0x8d300000, 0xada80000, 0x2e8c0000, 0xcf3e0000, 0x51d10000, 0x6c7f8000, 0x2af7c000, 0xf1cbe000, 0xf21e3000, 0x8b643800, 0xa7159c00, 0xac9a6600, 0xbd200f00, 0x9ab31a80, 0x2b69a1c0, 0xd66922a0, 0x84ed3dd0, 0xccacc498, 0x6a0af2c4, 0x087c3e2a, 0x40f1632d, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x38000000, 0x04000000, 0x12000000, 0x0d000000, 0xe7800000, 0xfec00000, 0x7c600000, 0xc5700000, 0x03580000, 0xba3c0000, 0xe4ce0000, 0x6f550000, 0xc60a8000, 0x35354000, 0x44786000, 0xa8ee7000, 0xcd055800, 0xc7870400, 0xeec00200, 0x3461f900, 0xf973b680, 0x155a5e40, 0xa538eea0, 0x0e485a50, 0x76126cb8, 0x44ace34c, 0x8c21ba36, 0x8254cd0d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x28000000, 0x8c000000, 0xfe000000, 0x61000000, 0x82800000, 0xc5400000, 0x64e00000, 0x32700000, 0xc3880000, 0x6a6c0000, 0x549a0000, 0xbb570000, 0x0b5e8000, 0x7ef5c000, 0x8fcea000, 0xa00bd000, 0xedaf1800, 0x553eac00, 0x5dc7d600, 0xd2a12900, 0x5b123680, 0x4f3fecc0, 0x2ec72ea0, 0xdf2640f0, 0xe5d67888, 0xc81ea9dc, 0xcf10ee02, 0xd53d953f, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x58000000, 0x34000000, 0x5a000000, 0x5b000000, 0xd0800000, 0x19400000, 0xf6a00000, 0xe3d00000, 0x41d80000, 0xb07c0000, 0xa52e0000, 0x70b10000, 0x83ef8000, 0x55d34000, 0x34dbe000, 0x81fab000, 0x67ed2800, 0x17d54c00, 0xbbdab600, 0x5b786b00, 0x7dad5980, 0x05f49140, 0x1b4e71a0, 0xb700dd50, 0xfe834798, 0xf847f644, 0x2d23fe0e, 0x7214d709, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0xfc000000, 0x72000000, 0x31000000, 0x65800000, 0x27400000, 0x0e600000, 0x57100000, 0xfda80000, 0x40cc0000, 0x2b5e0000, 0x08350000, 0x63da8000, 0x08f5c000, 0x33ff2000, 0xb8023000, 0xe4047800, 0xc6037400, 0xcf07fe00, 0x0e80b500, 0x8fc59980, 0x3ea59ac0, 0x4f37e1a0, 0xc15feed0, 0xcd349fb8, 0x985f9bcc, 0x34b4a632, 0xbd1df133, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x18000000, 0xac000000, 0x1e000000, 0x9b000000, 0x3f800000, 0x7a400000, 0x91a00000, 0xe7500000, 0x98180000, 0x84bc0000, 0x136a0000, 0x8cb70000, 0x2ee98000, 0x5bf34000, 0x5fc92000, 0x03645000, 0x1d35c800, 0xe7a81400, 0xb1d51600, 0x38d89300, 0x3bd8dd80, 0x685efb40, 0xac1f15a0, 0xf6bdef70, 0x36698388, 0x78313c64, 0x7329fe0e, 0x1c14d70f, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xe8000000, 0x74000000, 0x8a000000, 0xd7000000, 0xcf800000, 0x5bc00000, 0x2e600000, 0x76d00000, 0xbdd80000, 0x9abc0000, 0xaeee0000, 0x28710000, 0xe4ee8000, 0x5f77c000, 0xbb6d6000, 0x9cb3b000, 0x0908c800, 0x1460d400, 0xe9d03a00, 0x9659c100, 0xd37a8380, 0xcb8c4740, 0x6f244ba0, 0x5ff19350, 0xf32cf198, 0xf712924c, 0x7cbb9222, 0x2feba511, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x58000000, 0x84000000, 0xb2000000, 0x95000000, 0xd8800000, 0xb0400000, 0xb3a00000, 0x63d00000, 0x0fc80000, 0xf76c0000, 0xf73e0000, 0x13370000, 0x283a8000, 0xaab64000, 0x8afd6000, 0x88567000, 0x680e9800, 0x45083c00, 0x498c4e00, 0x03ce8b00, 0xc96d0980, 0x1c39e9c0, 0x00b591a0, 0xbbfad5d0, 0xd2d55fa8, 0x15491edc, 0xaa29b63e, 0x281bc73d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x68000000, 0x94000000, 0x26000000, 0x77000000, 0x02800000, 0x91400000, 0xfea00000, 0x66100000, 0x41980000, 0x8dbc0000, 0xc2ea0000, 0x21d70000, 0x687b8000, 0xd20ac000, 0x9fe56000, 0x80b5d000, 0x6b8ba800, 0x06255c00, 0xe256c600, 0x24bbfb00, 0x8b6e4780, 0xa0142540, 0x469e6fa0, 0x573bb970, 0xbfadc988, 0x05759274, 0xcb682612, 0xc014eb11, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x28000000, 0xc4000000, 0xce000000, 0xf5000000, 0x6b800000, 0x80c00000, 0x10a00000, 0x7d700000, 0x3c680000, 0x1f4c0000, 0xfefa0000, 0xc0350000, 0xa50f8000, 0xdb1cc000, 0x1023e000, 0x8b301000, 0xe38e7800, 0xec594400, 0x72459200, 0x31e68f00, 0x36173080, 0x1f39b9c0, 0x9d16c8a0, 0x89bc3df0, 0x8250ba98, 0x2fdaa2c4, 0xf681f212, 0x0f465f35, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x08000000, 0x0c000000, 0x32000000, 0xc5000000, 0x7e800000, 0x60c00000, 0xd2600000, 0x8db00000, 0x06e80000, 0x060c0000, 0x897a0000, 0xb0f30000, 0xd9cb8000, 0x0c99c000, 0xa106a000, 0x3086b000, 0x2fc25800, 0xfde08c00, 0xa5f6fa00, 0x4f4f9100, 0xd05a4080, 0xd96515c0, 0x7c3398a0, 0x69ac59f0, 0x6c2bc2a8, 0x456978d4, 0x6c49da2a, 0xbddfe117, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xa8000000, 0x24000000, 0x92000000, 0xc9000000, 0xca800000, 0xf9c00000, 0x36a00000, 0xf2500000, 0xbce80000, 0x4ccc0000, 0x315a0000, 0x40170000, 0x0d0c8000, 0x1bfbc000, 0xfc41e000, 0x96e3f000, 0x4ab17800, 0x815e4c00, 0x8817b200, 0x790b9f00, 0xd1fa3180, 0xb9465cc0, 0xea67c9a0, 0xe873d0f0, 0xb4799b88, 0x4907bfcc, 0x0a80d222, 0x59c4af05, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xf8000000, 0xdc000000, 0x32000000, 0x53000000, 0xd2800000, 0x62c00000, 0xe1e00000, 0x85100000, 0xf3a80000, 0x44cc0000, 0x7d1e0000, 0x86550000, 0xf2098000, 0xdaf84000, 0x2647a000, 0x7e21b000, 0xb7766800, 0x85fadc00, 0x1ec23a00, 0xe3e7fd00, 0x5e103980, 0x152836c0, 0x300fd1a0, 0x21faaad0, 0xb0c24bb8, 0xe2e0e7d4, 0xcf921a06, 0x5d6b0d23, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xb8000000, 0x54000000, 0xf2000000, 0xb7000000, 0x3e800000, 0x56c00000, 0x11e00000, 0xe6500000, 0x86e80000, 0xbb8c0000, 0xec1e0000, 0x9d950000, 0xd2898000, 0xe39a4000, 0xc0d1e000, 0xb429f000, 0x906f0800, 0x41489c00, 0x3bfc9a00, 0x2ec37d00, 0x65e36380, 0x645326c0, 0x99edeba0, 0x690dfad0, 0x1cde91b8, 0xc97277d4, 0xbd5b7a16, 0x0d338d01, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x88000000, 0xb4000000, 0x22000000, 0xdf000000, 0x85800000, 0xc6c00000, 0xe2e00000, 0x51d00000, 0x04d80000, 0x51bc0000, 0x01aa0000, 0x0e110000, 0xe6bc8000, 0xc02ac000, 0x02d26000, 0x5f5df000, 0xbe7cc800, 0xabcc0400, 0x4b840200, 0xf7c53d00, 0xc6628780, 0x6b970b40, 0xd07acfa0, 0xcacdcf70, 0xd706adb8, 0xf184027c, 0x84c4621a, 0x0de5cd11, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x88000000, 0xec000000, 0x0a000000, 0x85000000, 0x07800000, 0xb2c00000, 0xbbe00000, 0x09900000, 0x5a380000, 0x345c0000, 0xde0e0000, 0x76570000, 0x6a5c8000, 0x550ec000, 0xc2d2a000, 0x28187000, 0xbaa99800, 0x23e18400, 0xfd91a200, 0xe439c500, 0x2f5bbd80, 0x328e7640, 0xa016a5a0, 0xebfd3250, 0xd73ba7a8, 0x9fdb876c, 0x46cd020a, 0xb8b6b517, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xd8000000, 0x34000000, 0xee000000, 0x4d000000, 0x79800000, 0xf8c00000, 0xe7600000, 0xe8700000, 0x92b80000, 0x665c0000, 0x5dee0000, 0xd0b70000, 0x15db8000, 0xbe2b4000, 0x0751e000, 0x5aeb1000, 0x92313800, 0xcd9a9400, 0x260c0200, 0x65836100, 0x8ac76680, 0x98656940, 0xcef5dea0, 0x5cf8bd50, 0x977e3ca8, 0x70bbcc54, 0x815de21e, 0x6f687119, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xf8000000, 0xc4000000, 0x56000000, 0xa5000000, 0x18800000, 0x98400000, 0x9e200000, 0x47500000, 0x0fc80000, 0xa36c0000, 0xab7a0000, 0xa1130000, 0xc8ed8000, 0x4eb84000, 0x9ff16000, 0xd9dc5000, 0x60063800, 0xb0041c00, 0x8801ce00, 0x6c06e700, 0x6a025180, 0x370579c0, 0xeb81e9a0, 0x25c525f0, 0x1ee347a8, 0x413092e4, 0xd6b8ae16, 0xebf6b715, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x58000000, 0xfc000000, 0x2a000000, 0xfd000000, 0x72800000, 0x92400000, 0xc0e00000, 0xe8700000, 0x81680000, 0x4d0c0000, 0x343e0000, 0x44310000, 0xa28b8000, 0x44ff4000, 0xae95a000, 0xa6197000, 0x5fe4d800, 0x63f36c00, 0x87aace00, 0x40ad3100, 0x372fae80, 0x1befd3c0, 0xeb48f6a0, 0x9adfffd0, 0x57419898, 0xde66bee4, 0xe8376e0e, 0x9088411b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xb8000000, 0x6c000000, 0x22000000, 0x83000000, 0x93800000, 0xdfc00000, 0xbaa00000, 0x58300000, 0x65780000, 0xa75c0000, 0x172a0000, 0x01350000, 0x39fc8000, 0x991b4000, 0xf9492000, 0xa422b000, 0x9572e800, 0x409ed400, 0x01895a00, 0x9b020700, 0x6f868280, 0x15c72b40, 0x5da2eaa0, 0x3db7bf70, 0x77be1098, 0x2f7c485c, 0x805b5a36, 0x92ab0707, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xe8000000, 0x1c000000, 0xc2000000, 0x0f000000, 0x38800000, 0x6f400000, 0x6b600000, 0x5cb00000, 0x23080000, 0xe3ec0000, 0x6a9e0000, 0xe2b30000, 0x9e0b8000, 0x0c6ac000, 0x595d2000, 0xd092b000, 0x78dd0800, 0x86556c00, 0xc17be600, 0x65415500, 0xa862cc80, 0xee354ac0, 0xcf4a44a0, 0x9a09e6d0, 0x4a6f0288, 0x505cc3f4, 0x4113e632, 0x161d5533, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x68000000, 0xc4000000, 0xc6000000, 0x6b000000, 0xa1800000, 0x32400000, 0x55200000, 0xbff00000, 0xa5080000, 0x86ac0000, 0x009a0000, 0x8bf30000, 0x7b0b8000, 0xf1aac000, 0x5b1be000, 0xb8b05000, 0xe6a8c800, 0x709aa400, 0x53f42600, 0x470a6700, 0x9bac0c80, 0x321fdac0, 0xb43544a0, 0x1e6cbef0, 0xb67902a8, 0x8b6049d4, 0x08d42632, 0x07fa6725, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x48000000, 0x4c000000, 0x7a000000, 0xa1000000, 0x03800000, 0x15c00000, 0x49600000, 0x89700000, 0x57d80000, 0x963c0000, 0x500e0000, 0x7cf70000, 0xf91c8000, 0xadd8c000, 0x7739a000, 0x738cf000, 0x99343800, 0xf8780400, 0x68af1a00, 0x5ae08900, 0x44b35680, 0xcabe9a40, 0x914deea0, 0xd8d55e50, 0x7e49d4a8, 0x6456e76c, 0x2f0b9a3a, 0x5874493f, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x78000000, 0x4c000000, 0xbe000000, 0x2d000000, 0x95800000, 0xcf400000, 0x7aa00000, 0xd9700000, 0x0f380000, 0xeb1c0000, 0x39aa0000, 0xb0f10000, 0xa67a8000, 0x60bb4000, 0x435c2000, 0x698d5000, 0x50407800, 0xdc217400, 0x3eb69e00, 0xa75ad300, 0xb38a5c80, 0x67453340, 0x1ea2a4a0, 0xc3720770, 0x58389ab8, 0xd99fc44c, 0xbc6c1e26, 0x0391931f, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x18000000, 0x94000000, 0x0e000000, 0x13000000, 0x71800000, 0x03400000, 0x31a00000, 0x20100000, 0x27480000, 0x726c0000, 0xffbe0000, 0x21970000, 0xcc0f8000, 0x7fc94000, 0xcdaee000, 0x97db1000, 0x46e7c800, 0xefb42400, 0xbc5aee00, 0x38a68b00, 0x0c961f80, 0x668f73c0, 0xa10857a0, 0xf54917d0, 0x836dd9a8, 0xb73accf4, 0xc6556e2e, 0x106fcb11, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x78000000, 0x34000000, 0x22000000, 0x6f000000, 0x43800000, 0xe8400000, 0x8f200000, 0x32b00000, 0x38480000, 0x4dec0000, 0x799e0000, 0x5a330000, 0x89888000, 0xd18d4000, 0x558be000, 0xaf887000, 0x048f4800, 0x1d0f3400, 0xae48c600, 0x40eed700, 0xf51e2680, 0x01f2bac0, 0x96efeea0, 0x581fced0, 0x7d724888, 0xb52b29ec, 0x737e4616, 0xd6e09721, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xd8000000, 0xe4000000, 0x3e000000, 0x13000000, 0x8b800000, 0x19c00000, 0x56a00000, 0x27700000, 0x6a880000, 0xceac0000, 0x4e9a0000, 0x37f30000, 0x14ce8000, 0x93ca4000, 0x1e4a6000, 0xe08b1000, 0xebacc800, 0xfa197400, 0x97b76a00, 0x4aa8b700, 0xa09f4880, 0xecf78ec0, 0x934f00a0, 0x880bbaf0, 0x81ee8aa8, 0x617d5dfc, 0x0063ea1e, 0xf051f705, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x78000000, 0x34000000, 0x86000000, 0x53000000, 0x0b800000, 0xc7c00000, 0xd8e00000, 0x80f00000, 0x69180000, 0xab7c0000, 0x3ace0000, 0x68770000, 0x8d5b8000, 0xd85e4000, 0xc0dce000, 0x2c995000, 0x23b88800, 0x03aab400, 0xde411a00, 0x9a257500, 0x5891b680, 0x01ad9c40, 0x2344bea0, 0xaea26850, 0x36d4c4a8, 0xb38b0d54, 0x17d49a36, 0x0d0c3519, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x18000000, 0x04000000, 0x7a000000, 0x1f000000, 0x14800000, 0x85400000, 0xfd200000, 0xfe300000, 0xd9980000, 0x21fc0000, 0xe2ea0000, 0xa5410000, 0x2d268000, 0xf6304000, 0xb59b6000, 0x47ff3000, 0x83e90800, 0xd4c28c00, 0xa3e2f600, 0x9ad32700, 0x33cf5280, 0x9d71e440, 0x85bd3aa0, 0xce4c5870, 0xc5b6c4b8, 0xf05df36c, 0x4d9b603e, 0xf3ff302d, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x88000000, 0x6c000000, 0xa2000000, 0x4f000000, 0x35800000, 0x33400000, 0x03a00000, 0x06100000, 0x98980000, 0x187c0000, 0x75ce0000, 0x57430000, 0x8da48000, 0x4b12c000, 0x921ca000, 0x96be3000, 0x292a0800, 0xf0f5c400, 0x5c2ece00, 0xfe76eb00, 0xccef1780, 0xb797d940, 0xf5d9bfa0, 0xaedc2d50, 0x9d5d7988, 0x8f1f024c, 0x243ca02a, 0xe3ee3017, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x98000000, 0xc4000000, 0xb6000000, 0xc9000000, 0x8d800000, 0xed400000, 0x51600000, 0xeeb00000, 0x9e880000, 0x0aac0000, 0xd97e0000, 0x33470000, 0xd4618000, 0xa9374000, 0x98c86000, 0x314b5000, 0x5a0bd800, 0x2a689400, 0x4558ce00, 0xdc90cd00, 0x3c59f480, 0xf911dac0, 0xfd1a4ca0, 0x12721ed0, 0x30a95aa8, 0xba7a47c4, 0x25c0600e, 0x9ba75035, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x58000000, 0x34000000, 0x92000000, 0xc5000000, 0x12800000, 0x36c00000, 0xf1600000, 0xd2900000, 0xbc080000, 0x2fac0000, 0x4e5e0000, 0x5dc10000, 0x78e18000, 0xe5d14000, 0xf62fe000, 0x811bf000, 0x53e51800, 0x8c572c00, 0x516c8a00, 0x933ce900, 0xc955c980, 0x03eccfc0, 0x45ff31a0, 0xa83013d0, 0x897ea398, 0xcdf7d6f4, 0x1599e00e, 0x0226f039, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x58000000, 0x1c000000, 0x96000000, 0xcd000000, 0x03800000, 0xccc00000, 0x31e00000, 0x29500000, 0xcab80000, 0xfb9c0000, 0x7d2e0000, 0x07c10000, 0x17628000, 0x42124000, 0x4d9da000, 0xe02a9000, 0x4c443800, 0x6fa7c400, 0xa1f09200, 0x23cab500, 0x72108380, 0xb598c040, 0xec291ba0, 0x72459450, 0xe6a5b198, 0x2874e56c, 0xb40ba00e, 0x8d77902b, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xd8000000, 0x94000000, 0xbe000000, 0x29000000, 0x99800000, 0x29400000, 0x86a00000, 0xd9d00000, 0x11980000, 0x827c0000, 0x8f0a0000, 0x14410000, 0x61248000, 0xb9944000, 0x3ebbe000, 0xaaeb9000, 0x8c321800, 0xf1ed7400, 0xd6b24e00, 0xb628f300, 0xf9d6d180, 0x819ca740, 0x0a7f29a0, 0xf30a4370, 0xe6477fb8, 0x6223c47c, 0xb711e00e, 0xa77a9019, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xa8000000, 0xc4000000, 0x72000000, 0xb3000000, 0x36800000, 0x9cc00000, 0xdfa00000, 0x1af00000, 0x5be80000, 0xda8c0000, 0xc4da0000, 0xd7470000, 0x88e28000, 0x5211c000, 0xa9fae000, 0x4374f000, 0x2fae2800, 0x3ceebc00, 0xc60b4a00, 0x2719ef00, 0xb8626c80, 0x67d0a5c0, 0x97dea4a0, 0xb1c6e9f0, 0x2c21c688, 0xd1b6bafc, 0xad0a6022, 0x1d9e300d, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x58000000, 0x4c000000, 0x56000000, 0x89000000, 0x4a800000, 0xa9c00000, 0xc0e00000, 0x0f500000, 0x2b280000, 0xcc0c0000, 0x86be0000, 0x5e410000, 0xc9a78000, 0x51774000, 0x631a2000, 0x49361000, 0x9bbe9800, 0x4ec7ac00, 0x5f63d200, 0x0214dd00, 0xd70bd380, 0x473b54c0, 0xce076ba0, 0x6506e8d0, 0xac842198, 0x28c499c4, 0x9e63a00e, 0xbc905017, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x78000000, 0x0c000000, 0x8a000000, 0x51000000, 0x43800000, 0x27c00000, 0xaa600000, 0xd4900000, 0xc6980000, 0xa93c0000, 0x92ca0000, 0xb5470000, 0x0e218000, 0xf9344000, 0xe8692000, 0xc333f000, 0xf168b800, 0x04b5c400, 0x78ad2a00, 0x01d4b100, 0x38be2980, 0x780b5340, 0x0ea7b1a0, 0xf0716770, 0x24482388, 0xef071264, 0xf482a016, 0x4f40b027, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x48000000, 0xf4000000, 0x62000000, 0x35000000, 0x9f800000, 0x06400000, 0xcde00000, 0x51100000, 0x13380000, 0x469c0000, 0x196a0000, 0x23c70000, 0x82a38000, 0x3577c000, 0x036d6000, 0x7ac2f000, 0x63231800, 0x80334400, 0x4e0de600, 0x7314e100, 0x463d7580, 0x691e6e40, 0x472b0da0, 0x5223da70, 0x45b7f388, 0x714f7f74, 0xef76e01a, 0xfa693009, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xf8000000, 0xac000000, 0x12000000, 0x65000000, 0x23800000, 0xe5c00000, 0x29e00000, 0xc4b00000, 0xb5f80000, 0x1fdc0000, 0x598a0000, 0x24470000, 0x31268000, 0x72d74000, 0xce8f2000, 0xb2c63000, 0x1f60d800, 0x5af7a400, 0x65d89a00, 0x188cbd00, 0xe1c72480, 0xbfe15540, 0xf7b0dca0, 0x057cc170, 0xfa9a9e88, 0x6d2cd85c, 0x7851a036, 0xcacd7037, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x78000000, 0x14000000, 0x3a000000, 0x6d000000, 0xff800000, 0xec400000, 0x6c600000, 0xe5d00000, 0xd8180000, 0xcd3c0000, 0x6f0a0000, 0xa4830000, 0xa0c78000, 0x60a24000, 0x8b73e000, 0x146ab000, 0x33d61800, 0x5b1b4400, 0x45bef600, 0x01c97d00, 0xa323ef80, 0xd135ad40, 0x0b0c17a0, 0x16875970, 0x91c379a8, 0xd9272074, 0x5c358036, 0xc48d4031, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x88000000, 0xc4000000, 0xb6000000, 0x6f000000, 0x6b800000, 0x07400000, 0xeae00000, 0x06100000, 0x4e480000, 0xf4ec0000, 0x9f9a0000, 0x32810000, 0xc3c28000, 0xe620c000, 0x1bb5e000, 0x2abfd000, 0x78b4e800, 0x933b9400, 0x36f71e00, 0x055db100, 0x10241d80, 0xd4b2b5c0, 0xd13f15a0, 0x07f7f1f0, 0x35de63b8, 0x42e114cc, 0x9210801a, 0xe04dc03d, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x98000000, 0xf4000000, 0x16000000, 0x6f000000, 0x51800000, 0xc2400000, 0x42a00000, 0x45900000, 0xa6d80000, 0xa13c0000, 0x8b8a0000, 0xf0830000, 0xe8c18000, 0x37634000, 0xe275e000, 0x9c6bd000, 0x62306800, 0xb7cf4400, 0xa122e600, 0xa6d60b00, 0x0efbeb80, 0xb1682f40, 0x5ab463a0, 0xf30fbb70, 0x54476da8, 0xeda5b444, 0x3413800e, 0xb49c4039, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x88000000, 0xdc000000, 0xea000000, 0x5b000000, 0xe3800000, 0x48400000, 0x45a00000, 0x39100000, 0x8b380000, 0xf1dc0000, 0xdcee0000, 0xc9810000, 0xb3418000, 0xd627c000, 0x69562000, 0x9a9df000, 0xfecf6800, 0xe6d49400, 0x80da8600, 0xc468f300, 0x12476780, 0xa6a01c40, 0xfe902fa0, 0xed787850, 0x517c4198, 0x6b7fdf74, 0x5879803a, 0xf7fbc003, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xc8000000, 0x4c000000, 0xf6000000, 0x25000000, 0x00800000, 0x45400000, 0x59a00000, 0xb9500000, 0x8ba80000, 0x744c0000, 0x993a0000, 0xf2030000, 0x5f048000, 0xf384c000, 0x10c7a000, 0xd4639000, 0xe9b4f800, 0x9d5e9c00, 0x63b70600, 0x665ee300, 0x5a302d80, 0x6d9edac0, 0xe7d175a0, 0x37ecd6f0, 0x436c0ba8, 0xb42b69ec, 0x5288001a, 0x485c003f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x98000000, 0x5c000000, 0xae000000, 0xeb000000, 0x68800000, 0x72400000, 0xff200000, 0xb4d00000, 0x38680000, 0x280c0000, 0x9c7a0000, 0x74050000, 0xaa008000, 0xf9024000, 0x1d87a000, 0x69c35000, 0xb9e0c800, 0x97b16c00, 0x989f8e00, 0xcc332f00, 0xfe5fcd80, 0x3f509cc0, 0xf6aaa5a0, 0x1f6ba0f0, 0x668f6398, 0x113ea3fc, 0xb9a0003e, 0xed90002b, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x28000000, 0xac000000, 0x2e000000, 0x3d000000, 0xaf800000, 0xc5c00000, 0x07600000, 0x7d900000, 0x5ae80000, 0x434c0000, 0x973a0000, 0xbc010000, 0xa6078000, 0xa100c000, 0xf986a000, 0x7cc55000, 0x2ae5f800, 0xab55e400, 0xcf0aba00, 0x549f6900, 0x0f77f980, 0x85bc00c0, 0x1646a1a0, 0x04a1b4f0, 0x8bf463b8, 0xf6faf9e4, 0xc9600032, 0xd090000f, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x04000000, 0x36000000, 0xe7000000, 0xc0800000, 0x40400000, 0x9da00000, 0xa8d00000, 0x38780000, 0xf09c0000, 0xf46e0000, 0x13050000, 0x9e828000, 0xc341c000, 0x1b22e000, 0x2790d000, 0x615ea800, 0x2e0c8c00, 0xb6b53e00, 0x8bc9eb00, 0x12d72980, 0xbd78a840, 0xd91d61a0, 0xcfadf450, 0x146277b8, 0x3eb0534c, 0xdfce0032, 0x1cd5000d, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xd8000000, 0x4c000000, 0xae000000, 0xfd000000, 0x41800000, 0xab400000, 0xd9e00000, 0xf8f00000, 0x52d80000, 0x4f7c0000, 0x54ea0000, 0x4d030000, 0x49878000, 0x1f474000, 0x2be42000, 0x73f1d000, 0xa258f800, 0x0bbc9400, 0xdb4abe00, 0x2d929900, 0x48ebd280, 0xdb00de40, 0xc8850aa0, 0x38c29a70, 0xe9a2cca8, 0x0994d774, 0xa2ea001e, 0x3c030027, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xa8000000, 0x44000000, 0x16000000, 0x51000000, 0x5f800000, 0xa0400000, 0xe3a00000, 0xbbd00000, 0xe2980000, 0x9efc0000, 0x16ca0000, 0xe4250000, 0xd7948000, 0x033fc000, 0x7a2ee000, 0x16d5d000, 0xd7191800, 0xc5be4400, 0xb1efb600, 0x0b328300, 0x2a69d180, 0x7d742f40, 0x78caa9a0, 0x29207b70, 0x9212e798, 0x10796c5c, 0x290d9832, 0x47c1840d, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x78000000, 0x7c000000, 0x52000000, 0xd5000000, 0x1b800000, 0xe8c00000, 0xf4200000, 0x03100000, 0xbca80000, 0xcbcc0000, 0x5c3a0000, 0x23a10000, 0x51d78000, 0xf98a4000, 0xad5ea000, 0xf750b000, 0xaecad800, 0xafb96400, 0xaf627200, 0xdbf51b00, 0x05980f80, 0xa37324c0, 0x9ddbf7a0, 0x3b10b0f0, 0x60adfdb8, 0xa9cc7fe4, 0xa13d5826, 0x3c23243b, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x38000000, 0x6c000000, 0x82000000, 0xdf000000, 0x38800000, 0x13c00000, 0xea600000, 0x38f00000, 0xaa280000, 0x630c0000, 0x565e0000, 0xd0e10000, 0xb4328000, 0x98c94000, 0xb8392000, 0x2e10b000, 0xe71c8800, 0xca47ac00, 0xf423e200, 0x62d3a900, 0x75fefa80, 0x0174edc0, 0x4469d2a0, 0x012ab1d0, 0xe58f9898, 0x309e04ec, 0x79060816, 0x7182ec37, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xb8000000, 0xdc000000, 0x66000000, 0xa7000000, 0xf7800000, 0x06400000, 0xc6200000, 0xd7700000, 0x18f80000, 0x731c0000, 0xc20a0000, 0x8ca50000, 0xb7b28000, 0xa0194000, 0x878ca000, 0xcfe21000, 0xeb11e800, 0xffad3400, 0xd390f600, 0x3a6c9f00, 0x81f66880, 0xfe3bc540, 0x1cf9a0a0, 0x791da170, 0x5b0c1e98, 0x70221a6c, 0x98716836, 0x1b7d741b, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xd8000000, 0x3c000000, 0xbe000000, 0xc1000000, 0xa8800000, 0x67c00000, 0x79e00000, 0xc0d00000, 0x1e380000, 0x049c0000, 0x8c6e0000, 0x6e650000, 0xee928000, 0xb89e4000, 0x7268a000, 0xcf64d000, 0x36131800, 0x075e3c00, 0x37893200, 0xb1b49500, 0xe92be780, 0xab424040, 0xdc22dfa0, 0xa636ec50, 0xc76855b8, 0x0de4954c, 0xaad7980e, 0xe5397c03, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x98000000, 0x1c000000, 0xba000000, 0x29000000, 0xd8800000, 0x89c00000, 0x32200000, 0xc6100000, 0x7c180000, 0xeb7c0000, 0xe88e0000, 0x0fa10000, 0xe5528000, 0x7afc4000, 0x09cfa000, 0xcc47f000, 0xfd617800, 0xe2f2dc00, 0xaba88200, 0xad333b00, 0xba8cdf80, 0xe2a3d940, 0x7bd087a0, 0x903ab550, 0x526edd98, 0x4710a26c, 0x809df83e, 0xd4bf9c2b, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x68000000, 0x3c000000, 0x6a000000, 0x45000000, 0xd8800000, 0x0ec00000, 0x8ba00000, 0xd1f00000, 0xc2b80000, 0x755c0000, 0x24ce0000, 0x84a10000, 0x5c708000, 0x2cf9c000, 0x143b2000, 0x409ff000, 0x84e99800, 0x1c133c00, 0xee2f5a00, 0xe9b6cf00, 0xccdcd480, 0x6c8c1f40, 0x42c6eca0, 0x29a51350, 0xf8f50e98, 0xa83e107c, 0x6a9f9802, 0x21ee3c33, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xb8000000, 0x14000000, 0xe6000000, 0xc9000000, 0x70800000, 0x1b400000, 0xede00000, 0xf3900000, 0xc3c80000, 0x83ec0000, 0xdfde0000, 0x1ae10000, 0x2e148000, 0x160b4000, 0x9848e000, 0xef2c5000, 0xecf8d800, 0x15527c00, 0x6bec5600, 0x03dbd100, 0xb0e5f980, 0x2517f5c0, 0xf18941a0, 0x2e8e99d0, 0x8f0b2f98, 0x20ca64dc, 0xb86ed836, 0xc31f7c19, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x88000000, 0x04000000, 0x4e000000, 0x8f000000, 0xb4800000, 0xa4c00000, 0x8a200000, 0x01700000, 0x99d80000, 0x05bc0000, 0xc12e0000, 0xb9270000, 0x37f68000, 0xd818c000, 0x4a1de000, 0xd7181000, 0xbe992800, 0x53d92c00, 0x84ba3a00, 0xdaaa3300, 0x1965ec80, 0x91147c40, 0x574fa4a0, 0x9cb18050, 0xc47f56a8, 0xce8d8f7c, 0x8f17280a, 0x804e2c3d, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xd8000000, 0xe4000000, 0xaa000000, 0xe3000000, 0x82800000, 0x1dc00000, 0xeb200000, 0xf7d00000, 0xdab80000, 0xb8dc0000, 0x54ee0000, 0x79270000, 0x00d78000, 0x9a3b4000, 0xea196000, 0xab4ab000, 0x3e326800, 0xfac9dc00, 0xa974a200, 0x102cc300, 0x6b81b980, 0xac45da40, 0x8c6531a0, 0x7531f650, 0xb44c9ba8, 0x92b55974, 0x1e0a681e, 0x6bd5dc0d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x78000000, 0x1c000000, 0xd6000000, 0x11000000, 0x9d800000, 0x0c400000, 0xc6e00000, 0x38900000, 0xf3680000, 0xb64c0000, 0xcf7a0000, 0x70e50000, 0x99928000, 0xf6ef4000, 0xd60ca000, 0xa79f9000, 0x4573d800, 0x21785400, 0x5de74600, 0x42141900, 0xe3ad0180, 0xe96930c0, 0x5948f9a0, 0xb7fdb4f0, 0x2322c798, 0xf03769ec, 0x4e1bd806, 0x4b34542b, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xe8000000, 0x0c000000, 0x5e000000, 0xed000000, 0x4e800000, 0xc0400000, 0x68e00000, 0xc7f00000, 0x63d80000, 0x58fc0000, 0x712a0000, 0x21a30000, 0x73948000, 0xf76dc000, 0x8040a000, 0x88e3d000, 0x97f4f800, 0xfbdc6c00, 0xbcf85e00, 0x232d5100, 0x92a28a80, 0xd0158e40, 0x79a852a0, 0x28e4f270, 0x27f0d4a8, 0x33dbdf6c, 0xc0fe5812, 0x952cbc2f, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xc8000000, 0x9c000000, 0x7e000000, 0x0f000000, 0x37800000, 0xd6400000, 0x6e200000, 0x5e100000, 0xefb80000, 0x475c0000, 0xbaae0000, 0x65650000, 0x9eb68000, 0x536ac000, 0x61012000, 0x40835000, 0xd5c46800, 0xaa65b400, 0x89313600, 0x15289f00, 0x3720c380, 0x4a948440, 0xd87d0ba0, 0x9c3da050, 0x0b1ff5b8, 0x91891b6c, 0x11f3480a, 0x29cfe40b, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x18000000, 0x8c000000, 0x52000000, 0xd7000000, 0x31800000, 0xdfc00000, 0x80200000, 0x5cb00000, 0x93180000, 0xa27c0000, 0x44ae0000, 0xeae10000, 0x92158000, 0x45ef4000, 0xb8802000, 0x2b443000, 0x59674800, 0x22d52400, 0x88490a00, 0x61f31300, 0x7b788a80, 0x482fc440, 0xafa462a0, 0xa6709050, 0x05bf8098, 0x188dd754, 0x1c51681e, 0x4a0c1437, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x08000000, 0x7c000000, 0x32000000, 0xf7000000, 0x38800000, 0xd2400000, 0x31a00000, 0x72100000, 0xd9c80000, 0xc9ac0000, 0x32da0000, 0x3de70000, 0x4eb38000, 0xb85dc000, 0xd8a72000, 0xe7943000, 0x0808c800, 0x38cb6c00, 0x202aae00, 0xd11a3b00, 0x3b829f80, 0x64c0abc0, 0x86e4f7a0, 0x9c3537f0, 0x491a3188, 0x8f8190f4, 0x8ac7e80a, 0x53e35c2b, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x98000000, 0xa4000000, 0x62000000, 0xf3000000, 0x70800000, 0xf3400000, 0x1e200000, 0x0af00000, 0x20880000, 0xcc6c0000, 0xb87e0000, 0xf7e50000, 0x08938000, 0xb2dd4000, 0x4c576000, 0xf538f000, 0xccc6a800, 0x1be78c00, 0x16944600, 0xe7db4f00, 0xfdd4ec80, 0x1df91ac0, 0xf520a4a0, 0x9e7226d0, 0xd1c8aab8, 0x714e55c4, 0x5a0a481e, 0x802e3c2d, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0x3c000000, 0xd2000000, 0x8d000000, 0x29800000, 0x12c00000, 0xd1600000, 0xdc300000, 0xa3180000, 0x863c0000, 0x552e0000, 0xd4270000, 0x08908000, 0x6ec94000, 0x5c55a000, 0x94aeb000, 0x92e61800, 0x1ff23400, 0xd9ff7200, 0xcdc93100, 0x4ad3ac80, 0x72ebfa40, 0x70c694a0, 0x44653e50, 0x99b4dea8, 0x6bdecb4c, 0x9e5b3836, 0x4e99c403, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x68000000, 0x6c000000, 0x5e000000, 0xc7000000, 0xde800000, 0xd2400000, 0x77e00000, 0x48500000, 0x45080000, 0x4f2c0000, 0x975e0000, 0x5f210000, 0x2ff78000, 0x3bbec000, 0x0ff6a000, 0xcbb8d000, 0xd7f4a800, 0x9fbabc00, 0x8df61e00, 0x6ab83900, 0xca75df80, 0xa17e0dc0, 0xb15657a0, 0x4c8fa1d0, 0xcbebc198, 0x0efa34c4, 0x56958802, 0x89acac1f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xb8000000, 0x7c000000, 0x3e000000, 0x51000000, 0x2a800000, 0x08400000, 0x62200000, 0xa4f00000, 0xf3b80000, 0x845c0000, 0xdd4a0000, 0x1ce70000, 0xc0948000, 0x7c6f4000, 0x7595a000, 0x24e9d000, 0x0ad19800, 0xb14bac00, 0x0ae75e00, 0x05906700, 0x5cef4480, 0xd6d34340, 0x7f4dfca0, 0xe3e57f70, 0x53101a88, 0x6aaf244c, 0xe5f0b826, 0xf13d3c13, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xa8000000, 0x0c000000, 0x5e000000, 0x63000000, 0x75800000, 0xebc00000, 0xd8600000, 0x9a300000, 0xf6980000, 0xd5bc0000, 0x5eae0000, 0x2e230000, 0x45918000, 0x9acec000, 0xa217a000, 0xac0dd000, 0x1cf08800, 0xd07ec400, 0x7dcbaa00, 0x1592d100, 0x72cdfc80, 0x0e115e40, 0x220d54a0, 0xd7f38a50, 0xa9fe5688, 0xc80f8f64, 0xaef6a822, 0x9d7dd427, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x88000000, 0xd4000000, 0xaa000000, 0xdb000000, 0x24800000, 0x20c00000, 0xa7600000, 0x36b00000, 0x25380000, 0xa31c0000, 0x078e0000, 0x4c270000, 0x6f928000, 0xd72cc000, 0x5f776000, 0x61ddb000, 0xcfe82800, 0xe4152c00, 0x0969ba00, 0xabd73900, 0x308f1880, 0xdea49f40, 0xca54d0a0, 0x15cbc350, 0x3e86a2a8, 0x33c3a65c, 0x77e3c80a, 0x8c735c29, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x88000000, 0xfc000000, 0xe2000000, 0x07000000, 0x5c800000, 0x8b400000, 0x5da00000, 0xdeb00000, 0x9b680000, 0x400c0000, 0xedde0000, 0x17630000, 0x67d48000, 0x71bac000, 0x46342000, 0x662eb000, 0xd4a9c800, 0x72e84c00, 0x28c9c600, 0xb3bb3300, 0x71339280, 0x12afdbc0, 0xd3ecfaa0, 0x454ce7d0, 0x0d7a5488, 0x9654e8cc, 0xbd7f682a, 0xfe533c33, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x78000000, 0x54000000, 0x56000000, 0x6f000000, 0x4d800000, 0xac400000, 0x2b200000, 0x1a700000, 0x70680000, 0x2a1c0000, 0xfa720000, 0x406d0000, 0x32188000, 0x5e764000, 0x6e6c6000, 0x09189000, 0x45f78800, 0xad2d7400, 0x6fbf9e00, 0xf3c3b300, 0xf664fe80, 0x5fd0cec0, 0x79db60a0, 0x9c137df0, 0x97bf9e38, 0x67c3b30c, 0xc064fe86, 0xc0d0cee9, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x78000000, 0x74000000, 0xba000000, 0x05000000, 0xb4800000, 0xb2400000, 0x56e00000, 0xf6100000, 0x0d480000, 0xdb5c0000, 0x86160000, 0x854f0000, 0x67598000, 0x20154000, 0x364f6000, 0x18dff000, 0x99d0b800, 0x636aec00, 0xbeefc600, 0x862f9d00, 0x158beb80, 0x18fa1cc0, 0x53642da0, 0xaad581d0, 0x5cefc608, 0xa72f9d14, 0xc30bebb6, 0xcbba1cd9, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x68000000, 0xa4000000, 0xe6000000, 0xaf000000, 0x9d800000, 0xea400000, 0x0f600000, 0xb1900000, 0x8b480000, 0xf2dc0000, 0x8d920000, 0x61490000, 0xffd88000, 0x2912c000, 0xd18f6000, 0x237a9000, 0x9ba08800, 0x4b36f400, 0x76fd2e00, 0x85e1a100, 0x5a540380, 0xd46f78c0, 0xb9292da0, 0xafced9f0, 0x821d2e18, 0xb131a12c, 0xa3fc03a2, 0x0d6378f5, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xc8000000, 0x14000000, 0xce000000, 0x35000000, 0xd3800000, 0xcac00000, 0x52200000, 0x18f00000, 0xe2c80000, 0x623c0000, 0xacf60000, 0xbcc90000, 0x4f3a8000, 0x1375c000, 0x640fe000, 0xf21c5000, 0x23021800, 0xaa80d400, 0xdb409a00, 0x0fe0df00, 0xbe538280, 0x0c79cbc0, 0x309318a0, 0xa85914d0, 0xa1609a38, 0xf310df3c, 0x3a9b82aa, 0xff45cbe9, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x34000000, 0xca000000, 0xd3000000, 0xbf800000, 0x51400000, 0x0c200000, 0x6a700000, 0x8a680000, 0x341c0000, 0x04760000, 0xdb6b0000, 0x4c9d8000, 0x30b6c000, 0x5d0ae000, 0xa14a7000, 0x4bee0800, 0x3c5d8400, 0x44d70600, 0x4fd9e300, 0x93943680, 0x56fd46c0, 0x736330a0, 0x1754a5d0, 0x889f0628, 0x82b5e314, 0x820a368a, 0xf8ca46c9, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xf8000000, 0xb4000000, 0xa6000000, 0x9d000000, 0xfe800000, 0xaf400000, 0x69200000, 0x45100000, 0x71d80000, 0x38cc0000, 0x7b120000, 0x08d90000, 0x784f8000, 0x6d514000, 0xc17b6000, 0xbb1f1000, 0x2d289800, 0x8ee47c00, 0x26779e00, 0xf76bab00, 0x95409d80, 0x3e227840, 0x449703a0, 0x7319d370, 0xd12f9e18, 0x14e7ab14, 0xc1729d86, 0x7eeb7849, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0x24000000, 0x8a000000, 0x11000000, 0x40800000, 0x46400000, 0x91200000, 0xb8100000, 0xf0680000, 0x727c0000, 0xfb160000, 0xbdeb0000, 0xf2be8000, 0xe375c000, 0x475a6000, 0x8903f000, 0x7c851800, 0xb042ec00, 0x5626c600, 0x4f922300, 0x49aae580, 0x7e9a25c0, 0xc5e423a0, 0x627406d0, 0x1fd8c628, 0xb345230c, 0x3ba2658a, 0xbf54e5d5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x58000000, 0x74000000, 0x66000000, 0x8f000000, 0x26800000, 0x6c400000, 0xd7600000, 0x90d00000, 0xb0480000, 0x8e9c0000, 0x5dd20000, 0x07c90000, 0xcf5b8000, 0xee704000, 0x8f386000, 0x0c231000, 0xc5330800, 0x92db2c00, 0x02b64600, 0x5b1e5100, 0x7d17d180, 0xd1eee2c0, 0x0f6997a0, 0x272cb3f0, 0x3e4c4618, 0x1d9b5134, 0xc15651ae, 0xbe8ba2d9, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xa8000000, 0xac000000, 0x1a000000, 0x43000000, 0x58800000, 0x7e400000, 0xcba00000, 0x4f300000, 0x98a80000, 0xf19c0000, 0xd8360000, 0xbe2b0000, 0x4add8000, 0xaa13c000, 0x90db2000, 0x89103000, 0xf85d0800, 0x4f55fc00, 0x37fe0600, 0xb6672700, 0xf6531880, 0x5c7b1ac0, 0x08a51ea0, 0x57b03dd0, 0xc6e80628, 0x2a3c2714, 0x3f0698a2, 0x8a84daef, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xd8000000, 0xfc000000, 0xde000000, 0x2f000000, 0x74800000, 0xc3400000, 0x38a00000, 0x68f00000, 0x64480000, 0x76bc0000, 0x5ff60000, 0xccc90000, 0xbbfa8000, 0x20554000, 0xf4b82000, 0x3ef39000, 0x9f4ec800, 0x983cfc00, 0x21b72e00, 0xa9ef9700, 0xb7cd3e80, 0x157e6bc0, 0x3e1210a0, 0x219dfcd0, 0xeac12e38, 0x5666973c, 0x8c97beae, 0x11db2bd3, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xe8000000, 0x6c000000, 0xee000000, 0x8d000000, 0xf6800000, 0xf2c00000, 0x39a00000, 0x48700000, 0x13c80000, 0x7abc0000, 0x51f60000, 0xe4890000, 0x42598000, 0x9867c000, 0x72552000, 0xbbf99000, 0xf016d800, 0xd19dfc00, 0xf9433200, 0x25e1c300, 0xb7141280, 0xd81f1fc0, 0xc60120a0, 0xc107dcd0, 0xa884b238, 0x47c30324, 0x4b26b2a2, 0x38b44fef, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xb8000000, 0x14000000, 0x9e000000, 0xd7000000, 0x51800000, 0x25400000, 0xe1a00000, 0x95f00000, 0x01e80000, 0x6f1c0000, 0xf5760000, 0x96290000, 0xf4788000, 0x3b644000, 0x1e146000, 0xa038d000, 0x08440800, 0x01235400, 0x4234f600, 0xfa8bef00, 0x510e5680, 0xc549a6c0, 0xd66ca0a0, 0x595b49d0, 0xf3527638, 0xad9aaf2c, 0x77b4b6b6, 0xb9cc36f9, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x98000000, 0x14000000, 0x02000000, 0x27000000, 0xcc800000, 0x8c400000, 0x58a00000, 0x33d00000, 0x2a680000, 0x22bc0000, 0x2a520000, 0xc5ab0000, 0x16df8000, 0x0b604000, 0x39b76000, 0xd25b3000, 0x6b276800, 0x07153c00, 0x8c8fb600, 0x26cd0f00, 0x736ac780, 0x573d6bc0, 0x639771a0, 0x3ccb64f0, 0x806a3608, 0x39ba4f04, 0x18d0278e, 0x30ed1bf1, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x98000000, 0xac000000, 0x12000000, 0xb1000000, 0xe0800000, 0x6fc00000, 0x09200000, 0x83b00000, 0xb1280000, 0xc19c0000, 0x79320000, 0xfbed0000, 0x26398000, 0x7e404000, 0x2664a000, 0x55507000, 0x73bf5800, 0xc7072c00, 0xb7878a00, 0xe0452f00, 0xf5605880, 0x2cd12ec0, 0x18fdd2a0, 0x87e501f0, 0x32160a38, 0x91596f04, 0xbb96f8be, 0x121c5edf, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xb8000000, 0x34000000, 0x7e000000, 0x6d000000, 0x65800000, 0x94400000, 0x67a00000, 0xfb100000, 0xd7080000, 0xcf1c0000, 0xd8920000, 0xda4b0000, 0x13398000, 0xcac74000, 0xb7676000, 0x8777d000, 0xdcfdd800, 0x34202400, 0xfe53de00, 0x972a0700, 0x2f482180, 0x92b92ec0, 0x3881ffa0, 0x99c429f0, 0xdfe25e08, 0xc6b14734, 0x871d4186, 0x2495fec9, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x18000000, 0x24000000, 0x6a000000, 0xaf000000, 0xc3800000, 0x2a400000, 0xa0600000, 0xed100000, 0x8b180000, 0x070c0000, 0xca960000, 0x2b5f0000, 0xd86a8000, 0x8c054000, 0xb606e000, 0x3104f000, 0x6e856800, 0x7ac28400, 0x07a53e00, 0xa2327900, 0xaae90f80, 0x88c07e40, 0xcca231a0, 0xabb10750, 0x5fafbe08, 0xf327390c, 0x2ff7efae, 0xeac88e55, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xe8000000, 0xac000000, 0x12000000, 0x05000000, 0x68800000, 0x13400000, 0x73e00000, 0xb7d00000, 0xfe880000, 0xda5c0000, 0x17560000, 0x71cf0000, 0xf3ba8000, 0x7982c000, 0x1dc52000, 0x93a37000, 0x67b47800, 0xcd994c00, 0x85f22e00, 0x60f9bd00, 0x4a644d80, 0x0a1014c0, 0x1d2863a0, 0x55eaa9d0, 0x76c8ae08, 0xe63b7d0c, 0x96416d92, 0x5b6364f7, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x88000000, 0xc4000000, 0x0a000000, 0x8f000000, 0x41800000, 0xc0c00000, 0xd2a00000, 0x39d00000, 0x43f80000, 0xc32c0000, 0xc8520000, 0x6b3b0000, 0x858e8000, 0x8381c000, 0xebc16000, 0xc924f000, 0x0e17e800, 0x9cdc1400, 0xf43e7a00, 0xdc0ebb00, 0x5f462f80, 0x8f635b40, 0x39f255a0, 0x4d6ae070, 0x5bb0fa08, 0xe08f7b0c, 0xdd074f8a, 0xb287ab4d, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xd8000000, 0x6c000000, 0x36000000, 0x9f000000, 0x50800000, 0xfdc00000, 0xc6600000, 0xfd100000, 0x3df80000, 0x106c0000, 0x90560000, 0x26590000, 0xfb1a8000, 0x38bd4000, 0xbfc8a000, 0x21225000, 0x27b70800, 0xad0d5c00, 0x4fc0fa00, 0x9b633500, 0x08967780, 0x89bba540, 0x3c4c0da0, 0x6a65d050, 0xeb12da38, 0x72fc253c, 0x28e9dfae, 0xd994a977, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xb8000000, 0xe4000000, 0xee000000, 0x43000000, 0xf0800000, 0x90400000, 0x30a00000, 0xcf700000, 0xa6680000, 0xf99c0000, 0x1fb20000, 0x7e8f0000, 0xc24c8000, 0xa8ae4000, 0xda79e000, 0x30e2d000, 0xb7d62800, 0x151ffc00, 0x65f31600, 0xf32c8f00, 0x36bf3280, 0x3206a6c0, 0x8900a4a0, 0x7d8469f0, 0x13c67628, 0xe8601f3c, 0x8b90faa6, 0xb7bb8af5, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x98000000, 0x9c000000, 0xae000000, 0x3d000000, 0xa4800000, 0xa4400000, 0xdda00000, 0x01f00000, 0x35580000, 0xc02c0000, 0xa9320000, 0x98bb0000, 0x16798000, 0x829e4000, 0xc24f2000, 0xdea61000, 0xc073d800, 0x09996c00, 0x07c9d600, 0xd0657700, 0x9490be80, 0xe948bb40, 0x0b20e8a0, 0x56b38c70, 0xc17f7608, 0x491d2734, 0xe18c468e, 0xb6c7c763, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0x64000000, 0x1e000000, 0xf1000000, 0x41800000, 0xcbc00000, 0xdae00000, 0xbd500000, 0xfb380000, 0xefec0000, 0x9b160000, 0xc0190000, 0x2f5f8000, 0x19ffc000, 0x688f6000, 0xdf865000, 0x7ac7b800, 0xfb646400, 0x66964200, 0x09dd9100, 0x36b96980, 0x7e2f1940, 0xdef0aba0, 0xf5cd4850, 0x1226a238, 0x9d340114, 0x7b29b192, 0xe9712d5d, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xd8000000, 0x34000000, 0x9a000000, 0x57000000, 0xda800000, 0x0e400000, 0x4da00000, 0x40700000, 0xf6980000, 0x006c0000, 0x96b20000, 0x767d0000, 0xfd398000, 0x711a4000, 0xfbae6000, 0x8bd2f000, 0xe7eb2800, 0xbd728c00, 0xb31d9600, 0x58ac1700, 0xab55f280, 0x6eaeb940, 0xf251e4a0, 0xc928ee70, 0x79927638, 0xbc48a704, 0xd402baae, 0x8a03c579, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xb8000000, 0xcc000000, 0xea000000, 0x25000000, 0xa5800000, 0xba400000, 0x4ba00000, 0xc6b00000, 0x93480000, 0xaa7c0000, 0x2e720000, 0xee2f0000, 0xf2ab8000, 0x7f694000, 0x4788a000, 0x551cb000, 0x27a63800, 0x3cb62400, 0x2e4b8e00, 0x13f8d700, 0xc6369c80, 0x4c8d49c0, 0x7b9e92a0, 0x7360def0, 0x03d2ae28, 0x079e2704, 0x116184a6, 0xa2d19dc7, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x98000000, 0x44000000, 0xc6000000, 0xa7000000, 0x2b800000, 0xb4400000, 0x5c200000, 0x31500000, 0x43a80000, 0xbb7c0000, 0x9d960000, 0x9e4f0000, 0x214b8000, 0x0ec84000, 0xdc8de000, 0x77ad9000, 0xf57e4800, 0x46930400, 0x67c9ae00, 0x6c092b00, 0x9a6b5f80, 0xb41981c0, 0x7b6171a0, 0x08f4ead0, 0x1db9ce08, 0x5d73fb04, 0x5afb778e, 0xd4d355c5, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x08000000, 0xcc000000, 0xee000000, 0xd3000000, 0x52800000, 0x4ac00000, 0xa5e00000, 0xbed00000, 0x68780000, 0x562c0000, 0x51920000, 0x47db0000, 0x42df8000, 0xb75cc000, 0xf5192000, 0x33389000, 0x83882800, 0xbc63ac00, 0x02941200, 0xd55b3100, 0xa81f0580, 0xc2bbbf40, 0x43cc97a0, 0x97404e70, 0x3ba0b208, 0x3ef46104, 0x17c98daa, 0xdd404347, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xe8000000, 0xb4000000, 0x22000000, 0x81000000, 0x21800000, 0x56400000, 0xc2200000, 0xa9100000, 0xe6480000, 0x2fdc0000, 0x5e560000, 0xb5ef0000, 0x988e8000, 0x3e3ec000, 0xf921e000, 0x15943000, 0xa788d800, 0xe8bc6400, 0x7de64e00, 0x39731b00, 0xe77dcd80, 0xa5810cc0, 0x7c4303a0, 0xa723d7d0, 0xb291ae08, 0x6d082b2c, 0x5a7b9592, 0x0203a8d1, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xb8000000, 0x1c000000, 0x1a000000, 0xd1000000, 0x03800000, 0x65c00000, 0x27a00000, 0xc0500000, 0xe3b80000, 0x516c0000, 0x04960000, 0x8f9b0000, 0xe0f98000, 0xee8f4000, 0x71a22000, 0xd357b000, 0x9d3e1800, 0x052b3400, 0x33f0c200, 0x6defab00, 0x6dd0fb80, 0xa97fe540, 0x824fb9a0, 0xf9840e50, 0x44c4e228, 0x2c231b34, 0x919763a6, 0x7a1b9163, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x48000000, 0xec000000, 0xb2000000, 0x03000000, 0xf3800000, 0x70c00000, 0x3f200000, 0x9c300000, 0xec580000, 0x28ec0000, 0x9bf60000, 0x76fb0000, 0xb91f8000, 0x5a0ec000, 0x0a622000, 0x9ed37000, 0x65cc4800, 0x64c42400, 0x1926aa00, 0xf9319700, 0x5add8c80, 0xbea9c140, 0x7a92a6a0, 0xe7ad9650, 0x76128a28, 0xbee9e704, 0x86f6449a, 0x147f256f, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xa8000000, 0x04000000, 0x2a000000, 0xcb000000, 0x32800000, 0x68400000, 0xada00000, 0xabf00000, 0x2ba80000, 0xfddc0000, 0x66b20000, 0xb58f0000, 0x97ee8000, 0x627cc000, 0x8a466000, 0xf2a5f000, 0x4b70c800, 0x54e92c00, 0xe4fae600, 0x40030700, 0xe001ae80, 0x50020cc0, 0xd807c8a0, 0xac02cbf0, 0x2e068628, 0xe105f72c, 0xf985e6a2, 0x5ac4e0dd, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x38000000, 0x7c000000, 0x06000000, 0xf7000000, 0xae800000, 0x79400000, 0x9d600000, 0x22500000, 0xc5880000, 0x625c0000, 0x86120000, 0xff690000, 0xfccd8000, 0xdf3d4000, 0x94472000, 0xd2e45000, 0xda97c800, 0x232e6c00, 0x9a28ae00, 0x77a94900, 0xd26a0580, 0x534db8c0, 0xf7fd2ba0, 0x4ae0b1f0, 0x56958e18, 0x2d281904, 0xf92a4db6, 0x9b2b94eb, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xd8000000, 0x84000000, 0xd6000000, 0xc5000000, 0x92800000, 0xb6400000, 0xdb200000, 0xa0b00000, 0x03380000, 0x600c0000, 0x79f60000, 0x0d9d0000, 0xbf788000, 0x6c2b4000, 0xb8c3e000, 0x9f641000, 0xf892d800, 0x5c0bdc00, 0x1bf17600, 0x269dd300, 0x1cfcd080, 0x46ef9240, 0x94a326a0, 0xa0740150, 0x285c9618, 0x7698c30c, 0x14f8888e, 0x8aee0e7d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xc8000000, 0x8c000000, 0x0a000000, 0xfd000000, 0x44800000, 0x35400000, 0xff200000, 0xd3b00000, 0x38880000, 0x88bc0000, 0x94f20000, 0x2eab0000, 0xf18d8000, 0x7238c000, 0x22b52000, 0xb60bb000, 0xe0fc7800, 0xbf516c00, 0x005afe00, 0xba200b00, 0x23303880, 0x73cc1fc0, 0x549d46a0, 0xb0c3d4f0, 0x1ce7de08, 0x00d7bb14, 0x469e409a, 0x69c673c7, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x78000000, 0x8c000000, 0x86000000, 0x53000000, 0x93800000, 0x2bc00000, 0x68e00000, 0xb0f00000, 0x1a380000, 0x5c4c0000, 0x45360000, 0xdddd0000, 0xb13d8000, 0x03cb4000, 0x08f6a000, 0x363bd000, 0xea48e800, 0xbe312400, 0xba5b5200, 0x90fd5100, 0xbe2fb480, 0x7884ac40, 0x944766a0, 0xf523bd50, 0x2315f218, 0xcd4a8124, 0x67b15ca6, 0xa4988857, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x18000000, 0x44000000, 0x6e000000, 0x8d000000, 0x7b800000, 0xf7c00000, 0x0ea00000, 0xed700000, 0x26280000, 0x0bdc0000, 0xc8b20000, 0xff8d0000, 0x062a8000, 0x1bdf4000, 0x00b3e000, 0x1389d000, 0x342d5800, 0xbcdad400, 0x9834f200, 0x12ca7300, 0xb6c99a80, 0xa8cb30c0, 0x5dcde8a0, 0xd24f03f0, 0x538f1238, 0x942fa31c, 0x6cdec29e, 0x3030e4fd, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x58000000, 0x94000000, 0xae000000, 0xe9000000, 0xe4800000, 0xa3400000, 0x70600000, 0xb7500000, 0x61080000, 0x91dc0000, 0x58160000, 0x6b6f0000, 0xc1898000, 0x249c4000, 0xe5756000, 0xdebe5000, 0x26c17800, 0x1ba48c00, 0xee742e00, 0xa9388100, 0x8605e580, 0xd50564c0, 0x36864ba0, 0x3842a5d0, 0x1fe14e08, 0x2396d114, 0x11ac9dbe, 0xf82de8e1, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x18000000, 0x7c000000, 0x86000000, 0xa7000000, 0xda800000, 0x02400000, 0x51600000, 0x45500000, 0x23980000, 0x594c0000, 0x2f160000, 0x56f90000, 0x86188000, 0xdd894000, 0x6a362000, 0x0dc95000, 0x5e514800, 0x5f1d4c00, 0x6c0ed600, 0x4cf1f100, 0x75eebd80, 0x0ee3a840, 0xe096eba0, 0x1b3e1950, 0xdab8f638, 0xa478a12c, 0xc05ff59e, 0xe6eee463, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0xfc000000, 0x86000000, 0x11000000, 0x05800000, 0xdcc00000, 0xe7e00000, 0x79500000, 0x94780000, 0x4bac0000, 0x05960000, 0x43990000, 0x7aff8000, 0x45ef4000, 0x4a332000, 0x146a5000, 0x94f2f800, 0xf88c0400, 0x6f23da00, 0x9cb00100, 0xe62aa180, 0x5d524b40, 0xbe78fba0, 0x84a80a50, 0xfd10fa38, 0x24da5114, 0xacd85996, 0x58de4f7b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x98000000, 0x84000000, 0xe2000000, 0x75000000, 0xf7800000, 0x09c00000, 0xe0600000, 0xa0100000, 0xac780000, 0xa5ac0000, 0x59b20000, 0xb4090000, 0xcdc78000, 0x22664000, 0xa517e000, 0x53ffb000, 0xb06c7800, 0xdfd23400, 0x8319e200, 0xe33b6500, 0x798fff80, 0x1505cd40, 0xa781fda0, 0x71c11870, 0xf4627a18, 0xda16e114, 0x5d7a659e, 0xb02c9c45, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x08000000, 0x0c000000, 0xce000000, 0x25000000, 0x64800000, 0x37c00000, 0x89a00000, 0x36d00000, 0xca980000, 0x178c0000, 0xd2b60000, 0x3aed0000, 0xd8418000, 0xefe0c000, 0x04372000, 0x1e2c9000, 0xa4631800, 0x10706c00, 0x9fcbea00, 0x35525b00, 0x32dc9f80, 0x086d3c40, 0x6e8055a0, 0x70c3f750, 0xb627d218, 0x1892a704, 0x147a6dba, 0x5d3e0b57, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xe8000000, 0xc4000000, 0x66000000, 0x21000000, 0xdb800000, 0xe5400000, 0x6ba00000, 0x52900000, 0x42b80000, 0xc16c0000, 0x16760000, 0xb88f0000, 0xedc58000, 0x1a61c000, 0xd2f46000, 0x5b499000, 0x52a17800, 0xd513f400, 0xddffc600, 0x51cdff00, 0xf4665580, 0x47f68b40, 0x3ecdf3a0, 0x2ae2e450, 0x2f32de08, 0xe92b9b34, 0xe456eb92, 0x785b8055, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x08000000, 0x14000000, 0x22000000, 0x5d000000, 0x6c800000, 0x9ac00000, 0x4ca00000, 0x54d00000, 0xbe780000, 0xbc6c0000, 0x00b60000, 0xeb090000, 0x62468000, 0xb463c000, 0x2573e000, 0xb6283000, 0x90d7b800, 0xe47b2c00, 0x9d69a200, 0x6a33db00, 0x06cae780, 0x0b65a340, 0x34f0a5a0, 0x106e4850, 0x7eb5fa38, 0xe00cc71c, 0x41c2fd9a, 0x17245449, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x18000000, 0x54000000, 0x0a000000, 0x29000000, 0x07800000, 0x2bc00000, 0x69600000, 0xb7900000, 0xd6080000, 0xd85c0000, 0xda320000, 0x987f0000, 0x26808000, 0x10434000, 0x24a36000, 0x19f77000, 0x5d19d800, 0x5f17d400, 0x4d4f3200, 0x9e7e5d00, 0xb1814b80, 0xa4c592c0, 0x89e519a0, 0x10d0bff0, 0xf62f8a28, 0x74edf91c, 0xda0d218e, 0x665c5bf9, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x48000000, 0xe4000000, 0x6e000000, 0x7f000000, 0x27800000, 0x47c00000, 0x37a00000, 0x89d00000, 0xf9a80000, 0x81bc0000, 0x2cb20000, 0xa15d0000, 0xb6848000, 0xdf47c000, 0x37e66000, 0x89b7d000, 0x0fdac800, 0x15c1e400, 0x3aa67200, 0x73537b00, 0x1cef4f80, 0x8f5ffdc0, 0x69875da0, 0xe8c756f0, 0x4820da38, 0x12144f2c, 0x0c0d758a, 0xfd6ba2e5, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xb8000000, 0x44000000, 0xba000000, 0x81000000, 0x4e800000, 0x21c00000, 0xda600000, 0x71500000, 0x82b80000, 0xac2c0000, 0x8ff60000, 0x7d0d0000, 0xcf058000, 0x5d814000, 0xf240e000, 0x9b217000, 0x09f41800, 0xa20c5c00, 0x8a82aa00, 0xdbc1d500, 0xbb602d80, 0xefd01140, 0x1b7a67a0, 0x324cb450, 0x44a05218, 0x7eb1f924, 0x2dab1f96, 0xf3b0d865, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xf8000000, 0xec000000, 0xc6000000, 0x21000000, 0xd4800000, 0x52400000, 0x6ee00000, 0x16f00000, 0x37080000, 0xb9bc0000, 0x37560000, 0xe59b0000, 0x27078000, 0x95874000, 0xf6c1a000, 0x94a3d000, 0x6c10f800, 0x0bf8cc00, 0x69b60600, 0x7b6aed00, 0x54086480, 0xfe3f1dc0, 0xca97c2a0, 0x42ba20d0, 0xecd15e28, 0x765af104, 0xb5211ab6, 0xa0d67cef, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x88000000, 0xd4000000, 0x9a000000, 0x8b000000, 0xd9800000, 0x60c00000, 0x06200000, 0xe4100000, 0x37680000, 0xb5bc0000, 0xe1f60000, 0x08dd0000, 0xf4078000, 0xaa02c000, 0x7305e000, 0x1586f000, 0xa6c4c800, 0xc3243400, 0x2c911a00, 0x052f6f00, 0x0adddd80, 0x63039dc0, 0xdd8127a0, 0x92c602d0, 0xc9263218, 0x2f90ab34, 0x08af8f9a, 0xf01a06d1, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xa8000000, 0xe4000000, 0x5a000000, 0xa1000000, 0xa5800000, 0xb3c00000, 0x22200000, 0xd9700000, 0x82680000, 0x1edc0000, 0x91920000, 0xc0bd0000, 0x70008000, 0x6804c000, 0x84016000, 0xaa027000, 0x09029800, 0x41870400, 0xe9c26200, 0x83218700, 0x7cf2f680, 0x31af46c0, 0x3cf9f4a0, 0x48e0b1f0, 0x42d39a38, 0x6ed9f30c, 0xf9928cb2, 0x44bd05c5, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x18000000, 0x0c000000, 0xd2000000, 0xc9000000, 0xba800000, 0xdb400000, 0x72e00000, 0x4ef00000, 0xcfc80000, 0x837c0000, 0xdcd60000, 0xa6190000, 0x85e38000, 0x3f764000, 0x1f0ba000, 0x0c5e7000, 0xf1861800, 0x90c2fc00, 0xef221e00, 0xbd574500, 0x2edc9480, 0x66c023c0, 0x50232aa0, 0xf8d016d0, 0xd01a2638, 0x7ae48934, 0x1af0b29e, 0x71cdaae7, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x68000000, 0xac000000, 0x1a000000, 0x63000000, 0x24800000, 0x28c00000, 0x2c200000, 0xdf100000, 0xaf080000, 0x8fdc0000, 0x36720000, 0xbb7f0000, 0xa3a28000, 0x4f52c000, 0xf9ef2000, 0x43ee3000, 0x10ea8800, 0x7c6c5c00, 0x08ac3200, 0x568cff00, 0x469c1d80, 0xd710b6c0, 0x130d0fa0, 0x2ddd79f0, 0x61711a28, 0x41ff530c, 0x5e650792, 0x3ef3e5d7, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x28000000, 0x24000000, 0x8a000000, 0xb1000000, 0xe0800000, 0x0bc00000, 0x61a00000, 0x46500000, 0x84a80000, 0xe43c0000, 0x77b20000, 0x39190000, 0x4c228000, 0x0b16c000, 0x21cf6000, 0x0048f000, 0xe30a9800, 0x7d6eac00, 0xc89f8a00, 0xb7631b00, 0x9976db80, 0x3a3cf9c0, 0x44b431a0, 0x9c9e12f0, 0x3562f218, 0xdc76873c, 0x48bc29b2, 0xf2767ec5, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x18000000, 0xb4000000, 0x02000000, 0x7b000000, 0xcc800000, 0xe1c00000, 0x19a00000, 0x80900000, 0xeea80000, 0x06fc0000, 0x4e760000, 0x695b0000, 0xd7e78000, 0x40704000, 0xb45c6000, 0x5a633000, 0xf2310800, 0x9ab91c00, 0xed97fa00, 0x4b2edb00, 0x68ba0d80, 0x9e90efc0, 0x0baf97a0, 0x6f7a04d0, 0xe6351228, 0x88b8b704, 0xae969f8e, 0x63af18f9, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x98000000, 0xbc000000, 0xae000000, 0x87000000, 0xf0800000, 0xc7c00000, 0x0ca00000, 0xd5100000, 0x46080000, 0xa5dc0000, 0x44f20000, 0x9d7b0000, 0xdbe58000, 0xee764000, 0x37bc2000, 0x82c01000, 0x2d238800, 0xe9535c00, 0xdbe84a00, 0x18aaa300, 0x39cea980, 0x4578d6c0, 0x07e0c3a0, 0x707565f0, 0xb8ba6208, 0x5643af14, 0xf8e34b8e, 0xccf639cb, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x18000000, 0x64000000, 0x1e000000, 0x1b000000, 0x5a800000, 0xf1c00000, 0x53a00000, 0xa1100000, 0xe2880000, 0x0f5c0000, 0x8bf20000, 0xa8ff0000, 0xcce38000, 0xc5704000, 0x4f3ae000, 0xd8415000, 0x94e6e800, 0x41702c00, 0xa13b2a00, 0x0b410b00, 0xb2606180, 0xcab462c0, 0xf79baba0, 0xebd739f0, 0xfbaca228, 0x678c3704, 0x8edd438e, 0x00b715ed, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xf8000000, 0x14000000, 0xce000000, 0x35000000, 0x00800000, 0xe3c00000, 0x97200000, 0xe7100000, 0xd0e80000, 0xc73c0000, 0xc9760000, 0xf81d0000, 0xb2628000, 0xeaf44000, 0xaa586000, 0x20035000, 0x90021800, 0x28060c00, 0xdc00ea00, 0x2205cf00, 0xef032580, 0xfb80d1c0, 0xd645afa0, 0x74674ed0, 0x93f01218, 0xa0d8d31c, 0xf0c7b786, 0xdea142c9, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0x14000000, 0x62000000, 0x87000000, 0x8c800000, 0xbac00000, 0x5f200000, 0xb9d00000, 0xf8d80000, 0xeacc0000, 0x74b60000, 0xdee90000, 0x3fe78000, 0x1df3c000, 0xdb8ae000, 0x5dd73000, 0xe2dc6800, 0x31cffc00, 0x9e342200, 0xa92b5700, 0x7f447380, 0xf0670e40, 0x41b4b1a0, 0xdd6e6950, 0x6da52a38, 0xa2105b14, 0x867ed992, 0xe6589541, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x98000000, 0xf4000000, 0xfa000000, 0xc7000000, 0x95800000, 0x80c00000, 0xaaa00000, 0x17100000, 0xdb980000, 0x554c0000, 0xd4f20000, 0xd0ed0000, 0xca658000, 0x2db04000, 0x34886000, 0x2ad6f000, 0xe3bb2800, 0x371a3400, 0x750ffa00, 0xa012ab00, 0x26196180, 0x898cf240, 0xb854fba0, 0x96f9a970, 0x4d793238, 0x50be2f24, 0x989dd3be, 0x52ce9d69, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x28000000, 0xa4000000, 0x7e000000, 0xe5000000, 0x8d800000, 0x8ec00000, 0x12600000, 0x1bf00000, 0x14880000, 0xa6bc0000, 0xdad20000, 0x0bdf0000, 0x17a68000, 0xd914c000, 0xd03d6000, 0xac915000, 0x62fb9800, 0x6cf36400, 0x360e6a00, 0x46ff8d00, 0xd2f08080, 0xf309bdc0, 0xbb798aa0, 0x743460f0, 0x456e1228, 0xde89792c, 0x85b81282, 0x6e5404f5, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x28000000, 0x3c000000, 0x6e000000, 0x07000000, 0x81800000, 0x0f400000, 0x03600000, 0x59500000, 0xaff80000, 0xd06c0000, 0x8fb20000, 0x4bef0000, 0x85f08000, 0x180ac000, 0xf165a000, 0x40511000, 0x217b0800, 0xd2ac5400, 0xc5944600, 0x2adeb900, 0x9cdd2d80, 0x6fd93740, 0x2c5c4ba0, 0xd21c5e70, 0x43ffce28, 0xc6682d1c, 0x0cb4cb82, 0x006a9e63, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x18000000, 0xd4000000, 0x66000000, 0xfd000000, 0x4d800000, 0x8a400000, 0xa1a00000, 0xe9700000, 0xcd380000, 0xe78c0000, 0x9f560000, 0xa90f0000, 0x31918000, 0x096a4000, 0x1e076000, 0xd9071000, 0x83811800, 0xab43a400, 0x4625ce00, 0x2c301700, 0xba1b1a80, 0x343e9840, 0x340834a0, 0x8c13df50, 0x2b2d5608, 0x63a5f314, 0x9a77b4ae, 0x01ba9f71, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x28000000, 0xa4000000, 0x2a000000, 0x9f000000, 0x32800000, 0xc4400000, 0xf7a00000, 0xed700000, 0xf0680000, 0xffdc0000, 0x6e520000, 0x385b0000, 0x67958000, 0x093bc000, 0x01056000, 0x6f86f000, 0x6dc1e800, 0xbb64cc00, 0x6997a600, 0x7c384700, 0x0c841280, 0x094432c0, 0x762354a0, 0x05b145f0, 0x5e8bce08, 0xec8b4b14, 0xaf8cd4a2, 0x9b0d85cd, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x48000000, 0x0c000000, 0xbe000000, 0x69000000, 0x40800000, 0x35400000, 0x97e00000, 0x40300000, 0xb2180000, 0xa3ec0000, 0xb1520000, 0xba690000, 0xac908000, 0x84cfc000, 0xfd412000, 0x5be01000, 0x1e33f800, 0xab1aac00, 0xab681e00, 0x88143d00, 0x93884a80, 0x85a5f340, 0x7651f4a0, 0x6bee1e70, 0x7d536618, 0xe46d512c, 0xb59374aa, 0x8c48de5f, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xe8000000, 0x34000000, 0x12000000, 0xfd000000, 0xe0800000, 0x50400000, 0x2aa00000, 0xb3f00000, 0x05580000, 0x4a6c0000, 0xebd60000, 0x5be90000, 0xe5168000, 0x720cc000, 0x77c1e000, 0x7362b000, 0x6b933800, 0xe948cc00, 0xeae65600, 0x61579f00, 0x3aa85e80, 0xb1355f40, 0x92b968a0, 0x8bbcb050, 0xe13bee38, 0xf07f931c, 0x2c59e8a2, 0xc8e97041, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xa8000000, 0x2c000000, 0x96000000, 0x23000000, 0x15800000, 0xf1400000, 0x54600000, 0x8a900000, 0xe0380000, 0xf06c0000, 0x9a720000, 0x67690000, 0x5df68000, 0xef2ec000, 0x19172000, 0x0a7e5000, 0x658be800, 0x43a75400, 0xe237d600, 0xab8fd100, 0xc4a62b80, 0x1db7e740, 0xf7c85da0, 0x2244a670, 0xc9e0be18, 0x07d3451c, 0x3a5a5d92, 0xddfda667, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xf8000000, 0x14000000, 0x3a000000, 0x89000000, 0x9b800000, 0xbbc00000, 0x05e00000, 0x55700000, 0xb9080000, 0x7e3c0000, 0x5c160000, 0x673f0000, 0x2f968000, 0x60fa4000, 0x0c766000, 0x6a8cf000, 0x89fb5800, 0x87f1b400, 0x79481200, 0x901f9900, 0x0481c880, 0x674695c0, 0xc6a13aa0, 0xf1d3bcd0, 0x25dbca08, 0x02676d2c, 0x78b73a96, 0xbbecbcf9, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x88000000, 0x04000000, 0x5a000000, 0x45000000, 0x1b800000, 0xa2400000, 0x68600000, 0x23900000, 0xedf80000, 0xe9ac0000, 0xf1760000, 0x9da90000, 0x63708000, 0xbca9c000, 0xd2f36000, 0xd3ef7000, 0xa513b800, 0x083f5400, 0x658c5e00, 0xd985d900, 0xdb451380, 0xc5e5e940, 0x6ad2ada0, 0x091a8050, 0x32f96638, 0x972a4d2c, 0xd8b2adba, 0x2f8a807d, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xf8000000, 0x1c000000, 0x2e000000, 0x0f000000, 0xc3800000, 0x24400000, 0xe6a00000, 0x72100000, 0x2bd80000, 0x2c0c0000, 0xf4320000, 0x580f0000, 0xde338000, 0x950f4000, 0x14b22000, 0x99c91000, 0x27d3c800, 0x083e0400, 0x543c8e00, 0x9a3a0f00, 0x653f0980, 0x8ebef440, 0x4efa27a0, 0x9a5eab70, 0xc94ec628, 0x2e144b04, 0xe5da27b6, 0xd30eab73, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x28000000, 0x24000000, 0x9e000000, 0x4d000000, 0x34800000, 0x63c00000, 0xf1a00000, 0x9c700000, 0x95680000, 0xb45c0000, 0x98560000, 0xa4590000, 0x00508000, 0xc85cc000, 0x4a576000, 0x33585000, 0x17d0d800, 0xfa1f6c00, 0xc8b00a00, 0xa34a5b00, 0xa2687a80, 0x73d99ec0, 0x121790a0, 0xdabb55d0, 0x02465238, 0x8ae0f72c, 0x24179092, 0xf3bb55f5, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x88000000, 0xbc000000, 0x26000000, 0x0d000000, 0x35800000, 0x76c00000, 0x5ee00000, 0xb7500000, 0x75880000, 0x139c0000, 0x19320000, 0xdd9f0000, 0x78348000, 0x561bc000, 0x07f4a000, 0x2f7b5000, 0x51601800, 0x1a93a400, 0xbbee6a00, 0x6b894900, 0xea999180, 0x96b328c0, 0xb05fdba0, 0x9656f1f0, 0x1e08f228, 0x7c5e2d3c, 0xd857dbaa, 0xbf0af1e3, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x18000000, 0x1c000000, 0xf2000000, 0xd1000000, 0xc6800000, 0xdb400000, 0x24a00000, 0x34f00000, 0xdbf80000, 0x24cc0000, 0x2fd60000, 0xb6cd0000, 0x0ed68000, 0x884f4000, 0x79932000, 0x46e8f000, 0x8062d800, 0xa997dc00, 0xaee8be00, 0x64601700, 0xf793e680, 0x95e8ca40, 0x6fe6f8a0, 0x18536d50, 0xbb0ae618, 0xb9358b3c, 0x2c1ef8be, 0x609f6d6b, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xe8000000, 0xb4000000, 0x0a000000, 0x6d000000, 0xa7800000, 0x73400000, 0x11e00000, 0x3a300000, 0x7e680000, 0xcd9c0000, 0xfed60000, 0x0fdb0000, 0xb6b28000, 0x01aac000, 0xe3bfe000, 0xcac47000, 0xb5a77800, 0x29557400, 0xd49e3600, 0x33569d00, 0xc19b9280, 0x18d780c0, 0x14dec4a0, 0x3234add0, 0x5a6f4e28, 0xff98e92c, 0x3fd724b2, 0xfe5bddd1, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x58000000, 0xe4000000, 0x92000000, 0x59000000, 0x64800000, 0x2b400000, 0x64600000, 0xf7100000, 0xa2a80000, 0xeb7c0000, 0x1e720000, 0x1b3f0000, 0x8f968000, 0x4fef4000, 0x3c18e000, 0x40e23000, 0x3c539800, 0x96cc4c00, 0x346bae00, 0x00df5100, 0x86470f80, 0x5ae12fc0, 0x6950c1a0, 0xfc4c0ef0, 0x402a3628, 0x933c1d2c, 0x8392219e, 0x41ed3ee5, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x58000000, 0x84000000, 0x4a000000, 0x1d000000, 0x83800000, 0xfec00000, 0x52200000, 0x5ad00000, 0xf3f80000, 0x6d6c0000, 0x0bf60000, 0x75af0000, 0x32d48000, 0x6ffd4000, 0x036fe000, 0xecf5f000, 0xb32f7800, 0xcb945400, 0x891cfa00, 0x169a6f00, 0xc659ab80, 0xd379c740, 0xff2831a0, 0xad941850, 0xa21d8208, 0xf61d3b3c, 0xb41fd1be, 0x651de84d, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xf8000000, 0x64000000, 0x4a000000, 0x2f000000, 0x82800000, 0x97c00000, 0xd4e00000, 0xa2b00000, 0x0d080000, 0xa1fc0000, 0x1f520000, 0x743d0000, 0x08b18000, 0x320f4000, 0xbb7be000, 0x3c95f000, 0x12d9e800, 0xe107cc00, 0xf785ba00, 0xa2448100, 0x75a05680, 0x53952bc0, 0x305d8ca0, 0xc6c61af0, 0x0b665238, 0x9cf24d04, 0x56ae6ca6, 0x976feaed, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xf8000000, 0xf4000000, 0x5a000000, 0x73000000, 0x89800000, 0x3bc00000, 0xf8a00000, 0x76900000, 0x87480000, 0xdc9c0000, 0xcf360000, 0x475b0000, 0x67958000, 0xe9cd4000, 0x04dd6000, 0x9753f000, 0x4ced8800, 0x038df400, 0x63be0200, 0x9b62e300, 0x2a36cd80, 0x73d958c0, 0xccd62fa0, 0x382e0bd0, 0x34ad8a28, 0x0be81714, 0xb00b4fb6, 0x1b7dfbf9, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xf8000000, 0x0c000000, 0x16000000, 0xad000000, 0xa7800000, 0x90c00000, 0x95200000, 0x8ab00000, 0xf6180000, 0x62ec0000, 0xb4920000, 0x7e2b0000, 0xf7b08000, 0xf9984000, 0x962ea000, 0xf3b35000, 0xbb991800, 0x1128b400, 0x17354a00, 0x2dd9e700, 0xa54d9080, 0x3566fb40, 0x63d4faa0, 0x2bcf0c70, 0x80265208, 0x4136533c, 0xe0da5a96, 0x92cc5c4f, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xe8000000, 0xb4000000, 0x1a000000, 0x43000000, 0xc7800000, 0x2c400000, 0xa1a00000, 0xf1900000, 0x45880000, 0x6edc0000, 0xd6360000, 0xf91d0000, 0xc5d78000, 0x6829c000, 0x3949e000, 0xeebff000, 0xe1448800, 0x0f200400, 0xc1534e00, 0xc3e81700, 0x54aa8d80, 0x2e8daac0, 0xbd59a3a0, 0x90728dd0, 0x63bfc618, 0xafc41334, 0xafe7c382, 0xaf34bdc9, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x58000000, 0xcc000000, 0xf2000000, 0xe3000000, 0xea800000, 0xe2400000, 0x74200000, 0xa4b00000, 0x82280000, 0xd35c0000, 0x2c960000, 0xcc9d0000, 0x9e768000, 0x574d4000, 0xb94fa000, 0x004a7000, 0x7dcb4800, 0xfb0aac00, 0x24699600, 0x317b8b00, 0xed266080, 0xc9328ec0, 0x0ce8d6a0, 0x283f35d0, 0x5f82de18, 0xcdc1273c, 0x41e7f6ae, 0x795505df, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x68000000, 0x9c000000, 0x6e000000, 0xa7000000, 0x0b800000, 0x24c00000, 0xc8600000, 0x82300000, 0x91280000, 0x415c0000, 0x42520000, 0xdf190000, 0x36778000, 0xa809c000, 0x90cca000, 0xf6a91000, 0x33980800, 0x39300400, 0x34acca00, 0x229a7d00, 0x11b05e80, 0x11e956c0, 0xf33db4a0, 0x0566fbf0, 0xe4b4c218, 0x636a7914, 0x637c94a2, 0x86432bc3, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xd8000000, 0xd4000000, 0x16000000, 0x9b000000, 0x4e800000, 0x9d400000, 0x20600000, 0xbc100000, 0x8fe80000, 0x313c0000, 0x1c760000, 0x73f90000, 0xded08000, 0xdd4b4000, 0xb78f6000, 0x792f9000, 0x159fa800, 0xf1c28c00, 0x80266e00, 0xf1f5d100, 0xc439c780, 0xcdf57dc0, 0xfe3e49a0, 0x04f17cd0, 0x15b9c638, 0x40375d2c, 0x241fa9ae, 0xcc00acc9, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x78000000, 0xbc000000, 0x66000000, 0x01000000, 0x81800000, 0x96c00000, 0x6ee00000, 0xb1100000, 0xcda80000, 0xc25c0000, 0x76e20000, 0x9d170000, 0x83aa8000, 0x775c4000, 0x55642000, 0xd0d1d000, 0x0bc9b800, 0xd0084400, 0xe16c9a00, 0x5bba1100, 0x6f754780, 0xf3f8a1c0, 0x1bd065a0, 0x054af4f0, 0x5249b828, 0x4ac8442c, 0xb18c9a16, 0x27aa1133, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x08000000, 0xbc000000, 0xb6000000, 0x2b000000, 0xb4800000, 0x8ec00000, 0x03a00000, 0x5ad00000, 0x85680000, 0x941c0000, 0x97a20000, 0xa0d30000, 0xb06c8000, 0x879dc000, 0x13e7a000, 0xbab35000, 0xeb986800, 0xfde13c00, 0xb5b27200, 0x6d193b00, 0x5a23a380, 0x239441c0, 0x9089b9a0, 0xcdac46f0, 0xd4b86808, 0x55f13c3c, 0x257a722a, 0xb8d53b23, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0xcc000000, 0x6e000000, 0x17000000, 0xcf800000, 0x45400000, 0xb1e00000, 0xd9300000, 0x2fb80000, 0xff6c0000, 0x15e60000, 0x93310000, 0x32bf8000, 0x4dea4000, 0x7222a000, 0x1d141000, 0xa9ac4800, 0x97448400, 0x40e2f600, 0xf5b1b500, 0x977c0e80, 0x2acfb040, 0x69b2b0a0, 0x817a8150, 0x01cc4838, 0x00348434, 0x473af60e, 0xddadb517, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xe8000000, 0xc4000000, 0xca000000, 0x4b000000, 0x95800000, 0xb1400000, 0x64a00000, 0xfc500000, 0x89280000, 0xe9dc0000, 0x20a60000, 0x76510000, 0xa22e8000, 0xcc5ec000, 0x79e76000, 0xd6f17000, 0x947a8800, 0x0e703400, 0x05ba4600, 0x4711df00, 0x868f4f80, 0x500d1fc0, 0x40cf81a0, 0xd72cf4d0, 0x70da8838, 0xb220343c, 0xec924622, 0x1ecddf1d, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xb8000000, 0x04000000, 0x4a000000, 0x33000000, 0xbd800000, 0xc0c00000, 0xa2a00000, 0xe8500000, 0xd0880000, 0x5e7c0000, 0x8ca60000, 0xe1550000, 0x060e8000, 0x17384000, 0x1cc3e000, 0x9ca77000, 0xc9554800, 0x6a083400, 0xd13a0a00, 0xd9c76300, 0x5c249f80, 0xcd1332c0, 0x86ebdda0, 0xe68c65d0, 0x837d4818, 0x9824341c, 0x27140a16, 0x65ee630d, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xb8000000, 0x2c000000, 0xfa000000, 0xb1000000, 0xbb800000, 0xa6400000, 0x76e00000, 0x62900000, 0x51580000, 0x492c0000, 0xf0e60000, 0x41970000, 0x5fdc8000, 0x0ae84000, 0xff42a000, 0x8961b000, 0x3ad6d800, 0xc8bc1400, 0x4f384e00, 0xdb7e3500, 0x2899fb80, 0x178b4a40, 0x13976da0, 0x0ad96b50, 0x7f6ed808, 0x0e00141c, 0xb7064e06, 0xd8853507, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x14000000, 0x8e000000, 0xff000000, 0x0a800000, 0x72c00000, 0x3a600000, 0x82300000, 0xa9380000, 0xdd6c0000, 0x04660000, 0x25330000, 0x9fb98000, 0x25acc000, 0x4706e000, 0x4687d000, 0xc0c20800, 0x4f676c00, 0xf1b32200, 0x3a7e9500, 0x114a4a80, 0x31f0f440, 0x3edb60a0, 0x1b190d50, 0x6ffa0828, 0x390b6c14, 0x5155220a, 0x828d9501, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xb8000000, 0x74000000, 0xda000000, 0x9d000000, 0xb5800000, 0xf2c00000, 0x44a00000, 0x28700000, 0x24c80000, 0x221c0000, 0x3ba60000, 0x34f70000, 0x198b8000, 0xd97f4000, 0x5af06000, 0xbe8a7000, 0x81fdb800, 0x75b40400, 0xc4eb5a00, 0x432f4300, 0x3e0c1e80, 0xeabc41c0, 0x1dd2fca0, 0x873b06d0, 0xab13b808, 0xd19f0424, 0x0266da06, 0x56d70329, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x38000000, 0x3c000000, 0xca000000, 0x03000000, 0xb6800000, 0x35400000, 0x5d200000, 0x48300000, 0xbe980000, 0x298c0000, 0x08260000, 0x87b10000, 0xf65f8000, 0x63694000, 0xe6762000, 0xd93eb000, 0x56fdc800, 0x7c9eec00, 0x9e893e00, 0x80a57300, 0xeff2a080, 0xd0fdb940, 0x5d9e56a0, 0x4f0a2650, 0x6563c838, 0x7693ec34, 0x4c68be16, 0xe2f1332b, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x78000000, 0x4c000000, 0x5e000000, 0xb3000000, 0x97800000, 0x82400000, 0x9fe00000, 0x0db00000, 0x4b780000, 0x1b2c0000, 0xf8e20000, 0x18330000, 0x0c3a8000, 0x64484000, 0x8a93a000, 0xefeb9000, 0xffc1e800, 0x7ca36400, 0x48d40e00, 0x100ffd00, 0xa2743a80, 0xbfdf7240, 0x67f9dca0, 0xfaefeb70, 0x5743e808, 0x9760640c, 0x16768e36, 0x6ddbbd2f, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xd8000000, 0x2c000000, 0xa6000000, 0xa5000000, 0xb8800000, 0xf7400000, 0x20a00000, 0xf5d00000, 0x96480000, 0xa63c0000, 0xdd220000, 0xaa150000, 0xf9ad8000, 0x8f4c4000, 0xc0bda000, 0x13655000, 0x9c339800, 0xaa3bac00, 0x0b275e00, 0x67122f00, 0x652cd380, 0x2a0c40c0, 0xcf1a15a0, 0x5d30c3f0, 0xe0bc1838, 0x6362ec04, 0xf4377e2e, 0x8e3b3f3f, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xf8000000, 0xec000000, 0x02000000, 0xb9000000, 0x1a800000, 0xafc00000, 0xb7e00000, 0xb7700000, 0x22980000, 0x8b0c0000, 0x6c660000, 0xae310000, 0x58be8000, 0x829e4000, 0x1b0ea000, 0x44627000, 0x0a315800, 0x4ebc5c00, 0xd59c8a00, 0xba8e7100, 0x4827bc80, 0x08952340, 0xe1ec6ea0, 0xf7960e50, 0xa469d838, 0x8dd31c3c, 0x41ccaa26, 0x7b024117, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xc8000000, 0x0c000000, 0xa2000000, 0x1b000000, 0x2e800000, 0x82400000, 0x36200000, 0xb2b00000, 0xb7280000, 0x70bc0000, 0x2fa20000, 0x6c750000, 0xc0488000, 0x6ea9c000, 0xce7c2000, 0x28c47000, 0xba634800, 0x2d976c00, 0x8818c600, 0xaf529300, 0x457f8c80, 0x7e4390c0, 0x9c2602a0, 0xc5b36ff0, 0x4ba9c838, 0x21fbac2c, 0x3b04662a, 0xfe83231f, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xe8000000, 0x3c000000, 0x62000000, 0xa7000000, 0x9d800000, 0xe7c00000, 0x43e00000, 0xd9100000, 0x86980000, 0xa76c0000, 0x17620000, 0x4e550000, 0x443e8000, 0x95dec000, 0xa3cca000, 0x54d3f000, 0x2e7ea800, 0x09fc1400, 0x5d3af200, 0xbd599100, 0xf68f9f80, 0xe173f840, 0xd949c5a0, 0x8e937d70, 0x5a5a2838, 0xcb0bd41c, 0xd6b2d222, 0xc2ada123, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xe8000000, 0x84000000, 0x6a000000, 0x0f000000, 0x5b800000, 0xacc00000, 0x57e00000, 0x51f00000, 0x6a080000, 0x971c0000, 0x95620000, 0x5fb70000, 0xe3a88000, 0xb74ac000, 0x83396000, 0xd8f47000, 0x108da800, 0x25596400, 0x0ac75a00, 0x46e0e900, 0xa777b880, 0x264eebc0, 0xb5bf4aa0, 0xb4b066f0, 0x022f2828, 0xec88a43c, 0xd35cba32, 0x23c5592d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xb8000000, 0xc4000000, 0x06000000, 0x0b000000, 0x00800000, 0x59400000, 0xafe00000, 0x19f00000, 0xe1580000, 0x704c0000, 0x32620000, 0x93330000, 0xa37b8000, 0xf11f4000, 0x1229e000, 0xd9511000, 0x544de800, 0x84621c00, 0x5031ae00, 0x0ff96500, 0xd2597880, 0x74c86940, 0xcd273ea0, 0xe7d01070, 0x020c6808, 0x8d025c04, 0xcb81ce06, 0xf9c43505, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x08000000, 0x64000000, 0xb6000000, 0x71000000, 0xa1800000, 0x5cc00000, 0x17a00000, 0x39d00000, 0x24e80000, 0x6d9c0000, 0x70220000, 0xdc110000, 0x16c88000, 0x4e8bc000, 0x3a696000, 0x4ddb9000, 0xa8c4b800, 0x99a04400, 0xc4d40a00, 0xa76b0b00, 0xfe582b80, 0xd302fdc0, 0xae8299a0, 0x0844b2f0, 0xace43818, 0x0bb7840c, 0xcf1f6a3a, 0x9a619b25, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x88000000, 0xec000000, 0xee000000, 0xc7000000, 0x39800000, 0x37c00000, 0x6da00000, 0x89100000, 0x06080000, 0x97bc0000, 0x40220000, 0x94d50000, 0xfeaa8000, 0xb629c000, 0xeb692000, 0x62891000, 0x44f9c800, 0x3ec33400, 0x0327d200, 0x5f540300, 0x086ccd80, 0xf90bdcc0, 0x0a38d7a0, 0x15e5ebf0, 0xe0734838, 0x013af43c, 0x5266f23a, 0xc8b11337, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x28000000, 0x8c000000, 0x3e000000, 0x3b000000, 0xda800000, 0x66c00000, 0x04a00000, 0x96500000, 0x76a80000, 0xd55c0000, 0x2e260000, 0xc8930000, 0xf60b8000, 0xa10fc000, 0x758b2000, 0x704a9000, 0x5a6da800, 0x30fbcc00, 0xcbf54200, 0x577e4300, 0x88b61f80, 0x2d9c5bc0, 0x0180f5a0, 0x8c46d4d0, 0x3a662828, 0x66f40c04, 0x7afe6202, 0x2af4d337, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x48000000, 0x94000000, 0x02000000, 0xf1000000, 0x1d800000, 0x27400000, 0xdf200000, 0x4c700000, 0x11980000, 0xddcc0000, 0xa2a20000, 0x5b370000, 0x76bf8000, 0x9db8c000, 0x6d3ce000, 0xe1ffb000, 0x3a9a1800, 0x0d48a400, 0xfe62b600, 0xc850b300, 0xd56a6280, 0x6c91fb40, 0xaa08cca0, 0xe142ec70, 0xa4259828, 0x14f06404, 0xf95e561a, 0x9caf0311, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x18000000, 0x54000000, 0x32000000, 0x5f000000, 0x07800000, 0xba400000, 0x0aa00000, 0x2bd00000, 0xa7880000, 0xc17c0000, 0x97620000, 0x8b330000, 0x3efb8000, 0xc9224000, 0xdb946000, 0xd62e3000, 0x1729e800, 0x99a80400, 0x21684e00, 0x550d9700, 0xb7bab380, 0xb207bec0, 0x9f0095a0, 0xa7806df0, 0x6a460808, 0x12a47404, 0x7fd5c62e, 0x958ba321, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xf8000000, 0x84000000, 0xde000000, 0xc3000000, 0x11800000, 0xe4400000, 0xfba00000, 0xb8700000, 0xce980000, 0xc4cc0000, 0xe2620000, 0xc5910000, 0xf44f8000, 0xaea34000, 0x26f5e000, 0x695dd000, 0xaa2c6800, 0xd1335400, 0xdfba8e00, 0xed7d8f00, 0xfd194680, 0x798ddb40, 0xf54020a0, 0x5b204070, 0xccb60818, 0x49fdc434, 0x97db0606, 0xddef0b25, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x98000000, 0x0c000000, 0x96000000, 0x77000000, 0x37800000, 0x66400000, 0x76e00000, 0x5b100000, 0x9ae80000, 0x489c0000, 0x1b220000, 0x95b30000, 0xf41d8000, 0x34e04000, 0xd612a000, 0xfc69d000, 0xe65b8800, 0xa804c400, 0x4401ee00, 0xa201b500, 0xfd069780, 0x4e8313c0, 0x2ac171a0, 0xb12622f0, 0x3cb4a808, 0x809d5434, 0xef20c60e, 0xbfb0a107, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x98000000, 0xec000000, 0x06000000, 0x9b000000, 0x76800000, 0xa4400000, 0xf5e00000, 0xcfb00000, 0xc2d80000, 0xe20c0000, 0x8d220000, 0xe3170000, 0xc50e8000, 0x55a74000, 0x8855a000, 0x5c6e5000, 0x3b576800, 0xbeedac00, 0xa514f600, 0xbe0b3d00, 0xf324ca80, 0x44153f40, 0xdd89d4a0, 0x1ee4ee70, 0xe1344828, 0xaa98bc0c, 0xe1ec3e2e, 0x4193c107, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x18000000, 0x4c000000, 0x5a000000, 0x69000000, 0xbc800000, 0xdc400000, 0x14e00000, 0x8cf00000, 0x8c180000, 0xd48c0000, 0x1a260000, 0xcb570000, 0x338d8000, 0x99a44000, 0x3890a000, 0x3eadb000, 0x79751800, 0xbcdc6c00, 0xa4286600, 0xde321500, 0x89b84880, 0x4e1e0340, 0xb188b6a0, 0x5ca43a50, 0x6e103808, 0x83e99c14, 0x8513de2e, 0xfa68c917, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x68000000, 0x34000000, 0xc6000000, 0x59000000, 0x64800000, 0x45c00000, 0x14200000, 0x9b300000, 0xbb880000, 0xcc1c0000, 0xfb660000, 0x97d50000, 0x1e1c8000, 0xb464c000, 0x5250e000, 0x13589000, 0x7f837800, 0x7640ac00, 0xc867aa00, 0x70573f00, 0x745df080, 0x6e0781c0, 0xcd05a2a0, 0x3284d2d0, 0x04c71818, 0x2ca0fc0c, 0x2cf23222, 0x30aa0311, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x68000000, 0x44000000, 0xc2000000, 0x81000000, 0x44800000, 0x5e400000, 0xbde00000, 0x0b700000, 0x74680000, 0xca7c0000, 0x1d260000, 0xd5d50000, 0xb87e8000, 0xb426c000, 0x35536000, 0x143b3000, 0xe0c79800, 0x3ea76c00, 0xfc15f600, 0x16588d00, 0x6c76fc80, 0x03e9fcc0, 0xd9ba12a0, 0xce00ddd0, 0x97027818, 0xbf869c1c, 0x87c70e22, 0x4921d11d, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x48000000, 0x14000000, 0x5a000000, 0x87000000, 0x39800000, 0x2d400000, 0xd2a00000, 0xdb100000, 0x89180000, 0x632c0000, 0xdb660000, 0x3a750000, 0xe46b8000, 0x16c2c000, 0x64e0e000, 0x9e357000, 0x324a6800, 0xce13b400, 0x639a0600, 0xcdee2f00, 0x3386f580, 0x42441c40, 0x8f251ba0, 0x74574750, 0x80bf0818, 0xcfbd0434, 0xa23d0e2a, 0x357f2b21, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x98000000, 0x8c000000, 0x8a000000, 0x71000000, 0x98800000, 0x68c00000, 0x76a00000, 0xb9900000, 0x07b80000, 0x6a0c0000, 0x05e60000, 0xb2730000, 0x1ac98000, 0xbf404000, 0xa1e2a000, 0x7c713000, 0xd5cf5800, 0x40c78c00, 0x32a1e200, 0x0795a300, 0x60bd7180, 0x9189f540, 0x08a24ba0, 0xbe979a50, 0xcc3a7828, 0xef49fc14, 0x1d039a2e, 0x62805f27, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xb8000000, 0xf4000000, 0x1a000000, 0x8b000000, 0xfa800000, 0xcac00000, 0x08600000, 0x5dd00000, 0xcae80000, 0xabdc0000, 0xf7260000, 0xf7f70000, 0xe29b8000, 0x48074000, 0xdc006000, 0xf6027000, 0xb5020800, 0xd3864c00, 0x4f462200, 0x2226c500, 0x1476f580, 0x65db6dc0, 0xf6215fa0, 0x9e70a4d0, 0xf6dfe808, 0x28a47c24, 0xf6b7ca06, 0x81b9b909, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x78000000, 0xa4000000, 0x36000000, 0xd9000000, 0x92800000, 0x03400000, 0x12200000, 0xa4700000, 0xda780000, 0x3cac0000, 0x96e60000, 0xed910000, 0x946d8000, 0x85014000, 0x4084e000, 0x8c479000, 0x89a1f800, 0x4db19c00, 0x6f19ae00, 0xbcfd3b00, 0x31ed7a80, 0x99c26440, 0x3d60aca0, 0xec538350, 0x9d0e9838, 0x47564c24, 0x70893606, 0x1796771d, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x78000000, 0x94000000, 0x8e000000, 0x7b000000, 0x8e800000, 0x0c400000, 0x4e600000, 0x50300000, 0xbb480000, 0x799c0000, 0x97a20000, 0xec950000, 0x615d8000, 0xe0814000, 0x67416000, 0xd8e3d000, 0x18712800, 0x032c6c00, 0xc6acb600, 0x2c6c6100, 0xe24a2a80, 0x361cafc0, 0x506234a0, 0xf331e2f0, 0x11cfc838, 0x53dbfc04, 0x4ec17e06, 0x28229d11, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x48000000, 0x64000000, 0x16000000, 0x01000000, 0x65800000, 0x58400000, 0xa8600000, 0x7cf00000, 0x57780000, 0x676c0000, 0xb1220000, 0x11150000, 0xa3ce8000, 0x6073c000, 0x86bf6000, 0x854c9000, 0xc2b73800, 0x161c6400, 0xca184e00, 0x501af100, 0xf31ecc80, 0x799d6040, 0x695d3aa0, 0x8efd3570, 0x152a5838, 0xf245f41c, 0x8361f60a, 0xf2755535, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x38000000, 0xc4000000, 0xca000000, 0xe7000000, 0xf9800000, 0x0fc00000, 0xf7200000, 0x89f00000, 0xf4a80000, 0x8cfc0000, 0x13e20000, 0xc1530000, 0x139d8000, 0xb7f54000, 0x31a9e000, 0xce797000, 0xfba3e800, 0x2cb23400, 0xb7cc1200, 0xf6ecd700, 0x56192e80, 0xd63356c0, 0x5b8954a0, 0x710bf5f0, 0x05480808, 0x56a84434, 0xf7fa7a26, 0x5467a335, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x88000000, 0x3c000000, 0xe6000000, 0x8b000000, 0xbe800000, 0xebc00000, 0x4de00000, 0xfc500000, 0x5cd80000, 0xecec0000, 0x83260000, 0x18350000, 0xe3cf8000, 0x0510c000, 0xd4ffa000, 0x0a5dd000, 0x6b2de800, 0x40c4ec00, 0x4366ca00, 0x6f91c100, 0xb53cf580, 0x42be6040, 0x8efe57a0, 0x275e8d50, 0xbeac4818, 0x05803c14, 0x6d42a21a, 0xe220ed0b, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0xdc000000, 0x2e000000, 0x57000000, 0x45800000, 0xc6c00000, 0xd0a00000, 0x55f00000, 0x25080000, 0xa6dc0000, 0xd7660000, 0x63d10000, 0x61b98000, 0xbcb5c000, 0x8e6fa000, 0x9b089000, 0xb9df4800, 0x7ee6d400, 0xb3117a00, 0x521b0300, 0x5ec5b280, 0x14a77bc0, 0xfff400a0, 0xb80e6cd0, 0x2e5ee838, 0xf1234404, 0x4931b202, 0x30a91723, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x28000000, 0xb4000000, 0xc2000000, 0xfd000000, 0x78800000, 0x53400000, 0x50a00000, 0x22b00000, 0xf5d80000, 0x804c0000, 0x21e20000, 0x1f150000, 0xe7e98000, 0xc2d7c000, 0x1b0ae000, 0x5544b000, 0xb7a57800, 0x0b366c00, 0xd01e7e00, 0x20ab4f00, 0xa073d880, 0xdcbe6f40, 0x141b5ea0, 0x3aad8c70, 0xf1779838, 0xaa3edc24, 0xe4590612, 0x99882339, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x08000000, 0x04000000, 0xb2000000, 0x1b000000, 0xcb800000, 0x7f400000, 0xb3200000, 0x26100000, 0x49980000, 0x362c0000, 0x32620000, 0x58330000, 0xbd0d8000, 0xc874c000, 0x0fae6000, 0x3624b000, 0x9093c800, 0xfc5bc400, 0x3ec90600, 0xa991b300, 0xe4df5180, 0x2e093040, 0xc7f21fa0, 0x62e88770, 0x8e05a808, 0x75037434, 0xce80ce2a, 0x09c57705, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xd8000000, 0x74000000, 0x0a000000, 0x9d000000, 0xf7800000, 0xcac00000, 0xa1a00000, 0x47700000, 0x19d80000, 0x178c0000, 0x65620000, 0x79d10000, 0x782f8000, 0x5d124000, 0x568b6000, 0xe4e0f000, 0x68123800, 0xdd0a9400, 0x6826ca00, 0x3ab3cb00, 0x22ff7e80, 0xa5b99940, 0xbbde0ca0, 0xf68f8670, 0xd4e15818, 0x40166434, 0x610ef20e, 0xce245f19, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xc8000000, 0xc4000000, 0xfe000000, 0x6f000000, 0x5f800000, 0x00c00000, 0x69a00000, 0x56700000, 0x4ec80000, 0xdb9c0000, 0x1d660000, 0x49d10000, 0xd3ba8000, 0x04d3c000, 0x613a6000, 0xa696d000, 0x32df0800, 0x9f00c400, 0xb7875a00, 0x94c1fb00, 0x6fa52680, 0x357389c0, 0x2b49f4a0, 0x4a5c76d0, 0x44456838, 0x40e6141c, 0xf410522a, 0xe09d3f3d, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x28000000, 0xcc000000, 0xca000000, 0x9b000000, 0x76800000, 0x73400000, 0x67e00000, 0xc1300000, 0x78580000, 0x850c0000, 0xa0a60000, 0xb8d70000, 0xac6e8000, 0x66d6c000, 0x596d2000, 0x2d513000, 0x7dab0800, 0xfc772c00, 0x12bfce00, 0x9bbeb500, 0xd23a0e80, 0x71fa6f40, 0x445e48a0, 0x270e3650, 0x57a62808, 0x74561c0c, 0x6c2cc622, 0xbbb5992f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xe8000000, 0x8c000000, 0xd2000000, 0x5b000000, 0x8e800000, 0xb0400000, 0x10600000, 0x18b00000, 0xbbd80000, 0x408c0000, 0xf0220000, 0xc0d10000, 0xdf6f8000, 0xd153c000, 0x8fad2000, 0xe071f000, 0x26fac800, 0xcbdaec00, 0x788f1600, 0x7421d100, 0x8ed77e80, 0xbe6f3f40, 0x88d720a0, 0x636ac270, 0x1b57e818, 0xa0ab1c34, 0xd8f5de02, 0x93bb3d27, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x68000000, 0x54000000, 0xa6000000, 0xad000000, 0x6e800000, 0xcec00000, 0xdde00000, 0x78b00000, 0xd2380000, 0x99ac0000, 0x1ec20000, 0xe5e30000, 0xd4b48000, 0x783ac000, 0xaeade000, 0x2f459000, 0x4ea35800, 0x04129c00, 0x7d2fc200, 0x17057900, 0xc184ba80, 0x63400c40, 0xb4a5c0a0, 0xcb127970, 0x40ade008, 0x2645903c, 0x4e235832, 0x03d29c19, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x18000000, 0x64000000, 0xbe000000, 0x73000000, 0x66800000, 0x8e400000, 0xb4e00000, 0x3a500000, 0xc8c80000, 0x183c0000, 0x06460000, 0xe8e10000, 0xd0518000, 0x4dca4000, 0x71bfe000, 0x3480d000, 0x1f476800, 0x4b612c00, 0x57950600, 0x9bea3500, 0xa44ea580, 0x037ffcc0, 0xa3232ba0, 0xd47435d0, 0x493fe038, 0xd9c0d004, 0xb527681e, 0xcb712c0d, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xf8000000, 0x0c000000, 0x22000000, 0xaf000000, 0x48800000, 0x6fc00000, 0xa5200000, 0x42d00000, 0xcbf80000, 0xf3cc0000, 0x17c60000, 0xe9250000, 0x80d38000, 0xf4fb4000, 0x434ba000, 0x74077000, 0x6e016800, 0x6d04bc00, 0x77827a00, 0xdf41f700, 0xc6e64f80, 0xc5f02140, 0x262efda0, 0x70b21a50, 0x8bcba018, 0x5bc77034, 0x2b216806, 0xbfd4bc27, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xb8000000, 0x04000000, 0x9e000000, 0x33000000, 0xd2800000, 0x68c00000, 0x6d200000, 0xf6300000, 0x38480000, 0x839c0000, 0xbcc60000, 0x3b210000, 0x19328000, 0x40cc4000, 0xfe59e000, 0x3462d000, 0xe9546800, 0x179d8c00, 0x8ac59200, 0xe427cf00, 0xd9b30880, 0x390a9bc0, 0xe8fb12a0, 0xd51208d0, 0x3579e038, 0xb552d01c, 0xfd9c6836, 0xffc18c0d, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x18000000, 0x9c000000, 0x1e000000, 0x55000000, 0x54800000, 0xa7400000, 0x72e00000, 0x18d00000, 0xae580000, 0x2f2c0000, 0x0d460000, 0xede70000, 0x23558000, 0x9a984000, 0xfd082000, 0x5db21000, 0xc44d5800, 0x3a518c00, 0x281dde00, 0x234b8d00, 0x6dd1c180, 0xaad82c40, 0x306967a0, 0xf3a03d50, 0xf3302008, 0x440e1014, 0xff33582e, 0x020a8c23, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xa8000000, 0xf4000000, 0xae000000, 0xd9000000, 0x7d800000, 0x9ac00000, 0x88600000, 0xfa900000, 0x07280000, 0x431c0000, 0xb4c20000, 0x91630000, 0x27158000, 0x8dedc000, 0x637ee000, 0xba50d000, 0x3848b800, 0xbd0ca400, 0x44a8fa00, 0x68dd7500, 0x1526c780, 0x4f3295c0, 0xd95865a0, 0xbde394f0, 0xe456e008, 0x394cd034, 0x2c8ab802, 0x3c6fa439, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xb8000000, 0xdc000000, 0xaa000000, 0x79000000, 0xb5800000, 0xd8c00000, 0x27600000, 0x1bf00000, 0x69680000, 0xa73c0000, 0xcbc60000, 0x8be30000, 0xe6b48000, 0x9ec84000, 0xffaf2000, 0xcf5db000, 0x96b19800, 0x46c8e400, 0xb3ae2a00, 0x6d5f5d00, 0x8bb09480, 0x854d6cc0, 0xb86806a0, 0x86bb65d0, 0xfd012028, 0x1382b03c, 0x23c31826, 0x3fe3a41b, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xe8000000, 0x4c000000, 0xb2000000, 0x55000000, 0x44800000, 0x75400000, 0xea200000, 0xacd00000, 0x7c380000, 0x558c0000, 0xd6420000, 0x15a50000, 0xf2158000, 0x6ed9c000, 0x78b92000, 0x80cdf000, 0x8c663800, 0x81730c00, 0x2a2b4e00, 0xc5535b00, 0x49fc8780, 0x84ecdf40, 0x4fb0d1a0, 0x70cd7870, 0x14632038, 0x9574f004, 0xec29b822, 0x8653cc27, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x98000000, 0xfc000000, 0x7a000000, 0x4d000000, 0x21800000, 0x5a400000, 0x01600000, 0x6fb00000, 0x92f80000, 0x406c0000, 0x9b420000, 0x32e10000, 0x2cf18000, 0x7c1a4000, 0x269f2000, 0xe25e3000, 0x51fcb800, 0x12e8e400, 0x1b849e00, 0x37467900, 0x10e20680, 0x7df3f240, 0xf79d00a0, 0xa9df5f70, 0x3ebd2018, 0x1e0f3004, 0xcc75381e, 0x15dea40b, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x38000000, 0x3c000000, 0xfe000000, 0x69000000, 0x59800000, 0xd6400000, 0xd0e00000, 0xe3f00000, 0x69e80000, 0x7ebc0000, 0xcb460000, 0x53610000, 0x4eb68000, 0xff8c4000, 0x7f8c2000, 0x3f881000, 0x5f89b800, 0xef890400, 0xd78d3e00, 0xeb889500, 0x158ec880, 0x7c8848c0, 0x250e6ea0, 0xf34dc9d0, 0x23aa2038, 0xc059103c, 0xa9b73816, 0xd7094423, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x98000000, 0x54000000, 0xc6000000, 0xa1000000, 0xf9800000, 0x81c00000, 0xa0e00000, 0xb9d00000, 0x0ef80000, 0x870c0000, 0x91460000, 0x24a30000, 0xb2f28000, 0x54cf4000, 0x36a26000, 0x95f69000, 0x2c4a3800, 0x3ee54400, 0x2cd50200, 0x617aa900, 0x4fc97980, 0x04227140, 0x8eb223a0, 0x7be80c50, 0x3296e028, 0xd15ad00c, 0x177ad82e, 0x16cc9409, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xe8000000, 0xcc000000, 0xbe000000, 0xfb000000, 0x1b800000, 0x81c00000, 0xf4600000, 0xb4100000, 0xb9f80000, 0x8f4c0000, 0xf3460000, 0xbb210000, 0xa9358000, 0x7fc9c000, 0xa1052000, 0xb2819000, 0x6f412800, 0xad218400, 0xfe339200, 0x0a4dcd00, 0x33c3f380, 0x9165b740, 0xe49269a0, 0x1bb96e50, 0xdeeea038, 0xc1355024, 0xf3cf8822, 0x7f04d407, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xb8000000, 0xfc000000, 0xf2000000, 0xed000000, 0x57800000, 0x4dc00000, 0x57a00000, 0x60300000, 0x4a780000, 0xc92c0000, 0xa5460000, 0x30e10000, 0x45d68000, 0xc4284000, 0x02c62000, 0xa5227000, 0x5e73f800, 0xee185400, 0x59b91200, 0xc9893300, 0x5bf32c80, 0xdedaba40, 0x3199e6a0, 0x1078ad50, 0xf02ea038, 0x94c7303c, 0x96255836, 0x1ef36413, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x28000000, 0xb4000000, 0x92000000, 0x61000000, 0x02800000, 0x26400000, 0x59600000, 0x7f500000, 0x68c80000, 0xfbbc0000, 0xc6c60000, 0xc6250000, 0x08b58000, 0x6fdbc000, 0xa510e000, 0x07ab3000, 0xbfec9800, 0x298f9c00, 0xa3596600, 0x6455d900, 0x1f4b6180, 0xfd7ed4c0, 0xa0e07fa0, 0x7e96a1d0, 0x1f6d6018, 0x56ccf004, 0x84ba7832, 0x4b41ac39, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x68000000, 0x1c000000, 0x86000000, 0xad000000, 0xd4800000, 0xd2c00000, 0xbb200000, 0xaa900000, 0xa2480000, 0xc23c0000, 0x44460000, 0x76e30000, 0xd2308000, 0x159ac000, 0x1817a000, 0x8d8ed000, 0xd59c5800, 0x78144c00, 0x9d887200, 0x8d9f2f00, 0x0c107d80, 0x078d8ec0, 0xa69df7a0, 0x75973dd0, 0x01cf2028, 0xcf78101c, 0x6425f812, 0x09159c0b, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xb8000000, 0x0c000000, 0xee000000, 0x0b000000, 0x26800000, 0x23400000, 0xee200000, 0x8dd00000, 0x85680000, 0xe8dc0000, 0xc7c60000, 0x98650000, 0x06778000, 0xa97d4000, 0xfad1a000, 0xa5ed1000, 0x949c2800, 0xfd67ec00, 0x6bf0ee00, 0x4cb98b00, 0x27b52f80, 0x7e1fbdc0, 0x902649a0, 0x7ed5cad0, 0x4fee2018, 0x359c5014, 0x9ae38816, 0x3f33fc07, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x08000000, 0x5c000000, 0x9e000000, 0xfb000000, 0xdb800000, 0x96c00000, 0x32a00000, 0x99100000, 0xc7780000, 0x430c0000, 0xd1460000, 0x9a650000, 0x40b08000, 0x7defc000, 0x46b6a000, 0x62ec1000, 0xb7302800, 0x3d2c8400, 0x33112a00, 0x4e7a4300, 0x158aed80, 0xcb064b40, 0x73834fa0, 0xdac59c50, 0x54a62018, 0x3613d02c, 0xdefe883a, 0xb0cc942b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xe8000000, 0x6c000000, 0x5e000000, 0xff000000, 0x17800000, 0xa5400000, 0xf5e00000, 0x3ef00000, 0x73480000, 0x081c0000, 0x42c20000, 0x98a10000, 0xf7128000, 0x4bbac000, 0x00502000, 0x6f5f9000, 0xde260800, 0x72d4c400, 0x309dd600, 0x68006500, 0xac05e880, 0xbe01f5c0, 0x4f0416a0, 0xff87c4f0, 0xc942a018, 0xabe5501c, 0xc1f62802, 0x64cb5437, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x98000000, 0x9c000000, 0x46000000, 0x73000000, 0xd0800000, 0x5d400000, 0x24600000, 0x14900000, 0x12d80000, 0x9fec0000, 0xe8820000, 0xb1410000, 0x4a658000, 0x33964000, 0x80582000, 0x6baad000, 0x2963a800, 0x5b141c00, 0xf119ee00, 0xc1c98900, 0x4af3a780, 0x434fe240, 0x06b441a0, 0xaeaee770, 0x62e58018, 0x62d64024, 0x9a38201e, 0xc03ad033, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x58000000, 0x84000000, 0x36000000, 0xc1000000, 0x67800000, 0x69c00000, 0xa3e00000, 0x55900000, 0xe4580000, 0x546c0000, 0x33820000, 0xe7c70000, 0x56e58000, 0xcc164000, 0x909ee000, 0x22099000, 0xf8d5b800, 0x06fa3400, 0x5959f200, 0xd1ea1100, 0xd5425380, 0xf6a39e40, 0x633579a0, 0xa76c6b70, 0x63058028, 0x08864014, 0x6b46e01e, 0x0ba59005, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x48000000, 0x74000000, 0xa6000000, 0x11000000, 0xf8800000, 0x7b400000, 0x29200000, 0xc4500000, 0xb9780000, 0x8fcc0000, 0x0c860000, 0x9d410000, 0x58268000, 0x8cd7c000, 0x8a39e000, 0xd2ea9000, 0x6ed3b800, 0x353e4c00, 0x2f6e9e00, 0xfb135300, 0x3e5f8b80, 0x4e9ff940, 0x5b7dcda0, 0x30cfb650, 0xf1068038, 0x0887c03c, 0x5341e00a, 0xed269031, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xf8000000, 0xcc000000, 0x3a000000, 0xab000000, 0x19800000, 0x7b400000, 0xcaa00000, 0xdad00000, 0x7fd80000, 0x616c0000, 0xdf820000, 0xa2470000, 0x3c238000, 0xe6154000, 0x6b39a000, 0x359bb000, 0x894e8800, 0xbf969400, 0xf07e9600, 0x8f3dcf00, 0xfb99a380, 0xf44e5840, 0x67139da0, 0xc1bbf370, 0xeb5b8028, 0xaaa94024, 0x30e3a036, 0xbaf0b027, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xa8000000, 0xac000000, 0xd2000000, 0xcf000000, 0x7a800000, 0x5ac00000, 0x94e00000, 0x2bb00000, 0x23980000, 0xd88c0000, 0x10860000, 0xd1c70000, 0x30618000, 0xfc71c000, 0xaaf82000, 0x7f7ff000, 0x2f3ee800, 0x791eac00, 0x524e8200, 0x8c64b100, 0xc6765a80, 0x69ff7140, 0x47ff90a0, 0x12fb5c50, 0x3b798008, 0xf13dc034, 0xf41e2002, 0x4fc8f00f, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x98000000, 0x14000000, 0xa2000000, 0x77000000, 0x7b800000, 0x2a400000, 0xa7200000, 0x02d00000, 0xcd280000, 0xe51c0000, 0x79860000, 0xcd410000, 0x94a68000, 0x14914000, 0x440c6000, 0x26c9b000, 0x1a28a800, 0x0e9d6400, 0x1bc20e00, 0x56642b00, 0xb877cf80, 0x18ba8fc0, 0x0f9789a0, 0x798b30d0, 0x218e8038, 0x158d403c, 0x678a603e, 0x3888b029, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x18000000, 0xcc000000, 0x06000000, 0x65000000, 0x4f800000, 0x02c00000, 0x1fa00000, 0x12b00000, 0x9d980000, 0x9bcc0000, 0x8c820000, 0x58470000, 0x6ae48000, 0x73d54000, 0x8e8ea000, 0xbde25000, 0xc3551800, 0x28c85400, 0xee03ea00, 0x51062b00, 0x15870880, 0xc9c1c940, 0xe123daa0, 0x95f4a670, 0xe3fe8028, 0xbc5e401c, 0x4ee8200e, 0x4370101f, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0xd4000000, 0xaa000000, 0x27000000, 0x1c800000, 0xa1400000, 0xfae00000, 0x40f00000, 0x71580000, 0x7c8c0000, 0xa1820000, 0x72c70000, 0xbb238000, 0x6d504000, 0xca4c6000, 0x08a7f000, 0x9c926800, 0xcfe8dc00, 0x6fb36e00, 0xcebe1d00, 0xabfe7080, 0x431c5d40, 0x80e896a0, 0x4f312c70, 0x39f98028, 0x001b4024, 0x1e6de01e, 0x1570b021, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x88000000, 0xf4000000, 0xc2000000, 0xa5000000, 0xcf800000, 0x59400000, 0x23600000, 0x25900000, 0xac080000, 0x4e3c0000, 0x50820000, 0x2fc30000, 0x13a48000, 0x80b5c000, 0xbc7be000, 0x6765b000, 0xaf953800, 0x5d0e5400, 0x73b93600, 0x24c59100, 0x37249780, 0xad76dcc0, 0xaadff9a0, 0x185169f0, 0xc2ae8008, 0xed0ac03c, 0x3bbd600a, 0x70c37031, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0xcc000000, 0x62000000, 0x55000000, 0x01800000, 0x38c00000, 0x11200000, 0x13500000, 0x07980000, 0x96ac0000, 0xf2820000, 0xe2410000, 0xcf668000, 0x1633c000, 0xb8ac2000, 0x05817000, 0x56c7b800, 0xc625a400, 0x77d04a00, 0x76db0f00, 0x734a7380, 0x92f1b640, 0xa38f21a0, 0x5fd1ad70, 0x4adc8018, 0xb94ec03c, 0x3bf0a02a, 0x880fb03f, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x58000000, 0xec000000, 0x16000000, 0x83000000, 0xcc800000, 0xafc00000, 0x38e00000, 0x07b00000, 0xd2380000, 0xa02c0000, 0x5d860000, 0x02470000, 0x82a48000, 0xf9134000, 0x552da000, 0xc203d000, 0xa906a800, 0x91877c00, 0x64429a00, 0xf9a67900, 0xe9969a80, 0xb4ee1c40, 0x95e388a0, 0x74338950, 0x6f7a8008, 0x3008401c, 0x0c57203e, 0x010b9037, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xc8000000, 0xc4000000, 0x2a000000, 0xab000000, 0x8f800000, 0x5ec00000, 0x53600000, 0x13900000, 0x16480000, 0xe9fc0000, 0xa0820000, 0xdb410000, 0xd6a38000, 0x9772c000, 0x57186000, 0x42d37000, 0xdbea0800, 0x490a2400, 0x35580a00, 0xecf32d00, 0x5bd9a780, 0xc6b0bec0, 0xf1f845a0, 0x8c8407f0, 0x45418018, 0x0fa3c014, 0xbff3e00a, 0x685db015, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x38000000, 0x8c000000, 0x5e000000, 0x03000000, 0xb7800000, 0x91400000, 0xcb600000, 0x68100000, 0x7a080000, 0x3cbc0000, 0xe3060000, 0x67810000, 0xc9478000, 0xd7654000, 0x0e15a000, 0xf50e9000, 0xd53ee800, 0x7143a400, 0x1b603600, 0x30155100, 0x66085b80, 0x5ab930c0, 0x6c02a5a0, 0x8e0515d0, 0x5b060038, 0xab810034, 0xf7478016, 0x44654007, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xe8000000, 0xe4000000, 0x46000000, 0x37000000, 0x7f800000, 0xa3400000, 0x66e00000, 0x89500000, 0xc1180000, 0x556c0000, 0x8f020000, 0x93870000, 0x31418000, 0xefe7c000, 0xcdd06000, 0xbfdd1000, 0xe1cf8800, 0x28304400, 0x0709e600, 0x6093ad00, 0xda3ebd80, 0x991f2240, 0x896b33a0, 0xe5011b70, 0x16820028, 0xd7c70034, 0xe0218032, 0x31f7c03d, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x88000000, 0x3c000000, 0xea000000, 0x53000000, 0xb3800000, 0x28c00000, 0x0e600000, 0xbb700000, 0xa7e80000, 0xd2bc0000, 0xa7020000, 0x45810000, 0x81c08000, 0x96e3c000, 0x9435a000, 0x574eb000, 0xdea9c800, 0x5b1d0400, 0xab91da00, 0xd2dfb500, 0xc1756880, 0x4cecc4c0, 0x353a5aa0, 0xa9c205f0, 0x7ae20018, 0xe631000c, 0x4048801a, 0x332fc033, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xa8000000, 0xf4000000, 0x46000000, 0x61000000, 0x23800000, 0xabc00000, 0x19e00000, 0xb6500000, 0x20c80000, 0x623c0000, 0x6b060000, 0x28870000, 0x53448000, 0x72a4c000, 0xa8f2e000, 0x923d9000, 0x23053800, 0x4c801400, 0x8d414200, 0x4fa41100, 0x39703d80, 0x1efb14c0, 0x786427a0, 0x729141d0, 0x1fae0008, 0x822b001c, 0xc4ea8002, 0x748fc031, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x68000000, 0x3c000000, 0xfa000000, 0x51000000, 0x83800000, 0xa5400000, 0x34200000, 0xcab00000, 0x34280000, 0x497c0000, 0xd3060000, 0x16830000, 0x58c68000, 0x9e64c000, 0x8212a000, 0x4f5e3000, 0xc4b15800, 0x132c9400, 0x29fc3600, 0x68c50b00, 0x9667b480, 0x6e1094c0, 0x2d58faa0, 0xc1b0fbd0, 0x56ae0028, 0x27bf002c, 0x8e608012, 0x7a17c033, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x18000000, 0x4c000000, 0xde000000, 0xc1000000, 0xdd800000, 0x54c00000, 0x52600000, 0x4bb00000, 0x30a80000, 0x333c0000, 0x2c060000, 0xae050000, 0x39068000, 0xa1814000, 0x92c2a000, 0xdf649000, 0x4830f800, 0xa568e400, 0xbcd84a00, 0x33763500, 0xcccdce80, 0x418958c0, 0xbd2f5ca0, 0x0ffb59d0, 0xca600018, 0x47b0001c, 0x0ea8003e, 0xc23c001f, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xd8000000, 0x0c000000, 0x06000000, 0xad000000, 0xc3800000, 0x35400000, 0x64600000, 0xcd100000, 0x64380000, 0x248c0000, 0x68020000, 0x14070000, 0x2a008000, 0x9b074000, 0xb686a000, 0xfac05000, 0x57255800, 0x04737400, 0x6aafb600, 0x75f68900, 0x28eb4b80, 0xb1104940, 0x5a3d85a0, 0x9589a470, 0x45800028, 0x5840003c, 0x87e0003e, 0xc850000f, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x98000000, 0x04000000, 0x0e000000, 0xd3000000, 0x4e800000, 0x96c00000, 0x32600000, 0x56b00000, 0x31780000, 0x1cec0000, 0x60060000, 0x10070000, 0xc8028000, 0x6c034000, 0x9204e000, 0xd9005000, 0x9386e800, 0x0b44ec00, 0xea26c200, 0xf2152500, 0x55ab2680, 0x7b273e40, 0x4d936ca0, 0x6ceee750, 0xb8000008, 0xb400002c, 0x3600000e, 0x2700003d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x88000000, 0xd4000000, 0xfa000000, 0x0d000000, 0xa9800000, 0xb4c00000, 0x41200000, 0x19d00000, 0xb5480000, 0xa34c0000, 0x44020000, 0x12030000, 0xa9028000, 0x0b834000, 0xe5c22000, 0xc6a35000, 0x5a13e800, 0x50e83400, 0xa7dea600, 0x04a8d300, 0xe9be0480, 0x4198e740, 0x0f869520, 0xab8c2d30, 0x9b200008, 0x04d0000c, 0x34c8000a, 0x138c000d, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xe8000000, 0x24000000, 0xc6000000, 0x4d000000, 0x46800000, 0x98400000, 0xbfa00000, 0x3d700000, 0x3fb80000, 0x00cc0000, 0x9c020000, 0x4a010000, 0xcf018000, 0x1d834000, 0x7bc3a000, 0x45609000, 0xdc931800, 0xf0693400, 0x44851a00, 0x3b346100, 0x696dfe80, 0x247275c0, 0xa73b3ee0, 0xa98d6330, 0xbf200008, 0xa8300004, 0xa6980006, 0x75fc000d, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xa8000000, 0xdc000000, 0x0a000000, 0x33000000, 0xd3800000, 0x4d400000, 0x41a00000, 0xe8300000, 0x5e880000, 0xeb3c0000, 0x62020000, 0xcf010000, 0x09818000, 0x6642c000, 0xe622a000, 0x73737000, 0x26282800, 0xe38ccc00, 0xa2494e00, 0x28dc3500, 0xc2128680, 0x1ff860c0, 0x5a165a20, 0x9c0c1cf0, 0x6d080008, 0x567c0004, 0xeba20006, 0x4b31000b, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x48000000, 0x54000000, 0x9a000000, 0xab000000, 0x77800000, 0x55400000, 0xcea00000, 0x44500000, 0x47080000, 0xa78c0000, 0x02020000, 0xe7010000, 0xe1818000, 0x0841c000, 0x94212000, 0x03915000, 0x9a6a6800, 0xa4beac00, 0xed3bde00, 0xd8345500, 0x89f4ba80, 0x4997d140, 0x7026bc20, 0xa8dc8e30, 0x02880008, 0x3dcc0004, 0x09220006, 0x79110007, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xf8000000, 0x3c000000, 0x2e000000, 0x23000000, 0x9e800000, 0xd9400000, 0xefa00000, 0x58700000, 0x86c80000, 0x399c0000, 0xda020000, 0xa9010000, 0x7f808000, 0x42c3c000, 0x4f63e000, 0xe210f000, 0xe558b800, 0xb5048c00, 0x7ae47a00, 0xfab46500, 0x82cc3e80, 0x90f921c0, 0x6477bb20, 0x73aeb670, 0x79e80008, 0x2bac0004, 0xf5ea0002, 0xddad000f, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xa8000000, 0x64000000, 0xc6000000, 0xa7000000, 0xdb800000, 0x71400000, 0x3b200000, 0x1af00000, 0xd0480000, 0x4df40000, 0x13020000, 0xf5810000, 0x92408000, 0x76a14000, 0x64b2a000, 0x54e99000, 0xe0471800, 0x5f689c00, 0x79066e00, 0x204b4500, 0xf5f4ac80, 0xff004bc0, 0x07829120, 0x5b400fd0, 0x6e220008, 0x08710004, 0xb9888002, 0x1a154005, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xf8000000, 0xbc000000, 0xa2000000, 0x53000000, 0xac800000, 0x0ac00000, 0xaa600000, 0x75d00000, 0x62980000, 0x31c40000, 0x5f020000, 0xc6810000, 0x6dc38000, 0x70e24000, 0xca13e000, 0x297af000, 0x13568800, 0x62bb4c00, 0x8eb7b200, 0x8529ab00, 0x3a8de980, 0xde5fb740, 0x93463a60, 0x1cc12f10, 0xcf620008, 0x8c510004, 0x19db800e, 0x34e64009, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xf8000000, 0x44000000, 0x7a000000, 0xb9000000, 0xaa800000, 0x20400000, 0x44600000, 0x2cd00000, 0x40b80000, 0x9c1c0000, 0x55020000, 0x4c830000, 0x57438000, 0xc5e04000, 0xa313e000, 0xb0191000, 0x17ede800, 0x6e88e400, 0x3635aa00, 0xbac50100, 0x28cc5180, 0x81b9d340, 0xb29cd2e0, 0xef41b870, 0xa1e20008, 0x2913000c, 0xe11b800e, 0x016c4001, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xb8000000, 0xf4000000, 0x9a000000, 0xd9000000, 0xe3800000, 0x13400000, 0x9de00000, 0x64100000, 0x6d680000, 0xe9a40000, 0xe5020000, 0x25830000, 0x3c408000, 0x19634000, 0x6fd2e000, 0x2d4bd000, 0x7a966800, 0xbbd96400, 0xbb3c8e00, 0x2adecd00, 0xc0cc3780, 0x1ea6f040, 0xa580a5a0, 0xfc43ee90, 0x39620008, 0xbfd3000c, 0x95488002, 0x8e97400d, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x98000000, 0x4c000000, 0x02000000, 0xe5000000, 0xd7800000, 0xebc00000, 0x85a00000, 0x79d00000, 0x28480000, 0xf5c40000, 0xb7020000, 0x7a810000, 0x78438000, 0xc861c000, 0xcf726000, 0x2d193000, 0x06cc0800, 0x1e259400, 0x0db05e00, 0x3d392f00, 0x91dc5680, 0x144c4740, 0xf264f120, 0x6bd26f10, 0x654a0008, 0x16450004, 0x62c1800e, 0x8020c007, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x08000000, 0x8c000000, 0xc2000000, 0xfb000000, 0xf3800000, 0x72c00000, 0x9e200000, 0x6cb00000, 0x05280000, 0xa1f40000, 0x25020000, 0xe2810000, 0xc6418000, 0x85614000, 0xff502000, 0x4a3a3000, 0x83af0800, 0x177dec00, 0x8b84ce00, 0xe80b4b00, 0xf2c7b880, 0xf0eb52c0, 0x765644a0, 0x74701fd0, 0x9c0a0008, 0xc4c50004, 0x7deb8006, 0x68d44005, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x58000000, 0x64000000, 0x9e000000, 0xaf000000, 0xbf800000, 0x88400000, 0x17600000, 0x0c500000, 0x87480000, 0x348c0000, 0x4d020000, 0x8a830000, 0x96c28000, 0xe7a0c000, 0x10f16000, 0xee399000, 0x99f67800, 0xe214bc00, 0x4387fe00, 0xfaeda100, 0xadd31d80, 0x60081140, 0x3c6cad20, 0xf9109a30, 0x42aa0008, 0xca1f000c, 0xb3e8800a, 0x01ffc003, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xe8000000, 0x24000000, 0x7e000000, 0x37000000, 0x57800000, 0x45400000, 0x35e00000, 0x9f500000, 0x52280000, 0x64240000, 0x87820000, 0xdd410000, 0x99e18000, 0xf550c000, 0xf32ba000, 0x20a49000, 0xeb43f800, 0x9ae1dc00, 0x64d0de00, 0x7d69d500, 0xf0c77780, 0x5c50ed40, 0xe3a9b0a0, 0xba64cc90, 0x8fe18008, 0xa650c004, 0xbaaba006, 0x62e49003, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x88000000, 0x54000000, 0x9e000000, 0x8b000000, 0x31800000, 0x21c00000, 0xdc600000, 0x70d00000, 0x6c780000, 0x54fc0000, 0x79820000, 0x55c10000, 0xd2618000, 0x83d3c000, 0x81fa2000, 0xbf3d5000, 0xb0e07800, 0x9f932c00, 0xae594600, 0x2a8f4700, 0x54cb5180, 0xf6559340, 0x5a0449e0, 0x313fbff0, 0x03e18008, 0x1213c004, 0xb59a2006, 0x6bed500f, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x48000000, 0x3c000000, 0x46000000, 0x77000000, 0x90800000, 0xd0c00000, 0x60200000, 0xf0300000, 0x80b80000, 0x45140000, 0xb4820000, 0xc2c10000, 0x9d218000, 0x89b24000, 0xc3f92000, 0x1f74f000, 0xc5531800, 0x35e8dc00, 0xe8ffc200, 0x487f0300, 0x60bfa080, 0x849db0c0, 0xd6afdae0, 0x13152850, 0xcb818008, 0x0e424004, 0x9be12006, 0xd690f009, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x98000000, 0x4c000000, 0x86000000, 0xc7000000, 0x99800000, 0xcbc00000, 0xaae00000, 0x4cf00000, 0x7ab80000, 0x67040000, 0xdf820000, 0x6cc10000, 0x43608000, 0x4f314000, 0x045a6000, 0xe1f53000, 0xe4381800, 0x55461c00, 0xcea0e600, 0x42d36f00, 0xa1284b80, 0x988d43c0, 0xfddf92e0, 0x0c34b010, 0x99d88008, 0x38354004, 0x63d86002, 0x91343005, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xe8000000, 0xcc000000, 0xf2000000, 0xd1000000, 0xd7800000, 0x0bc00000, 0x8b600000, 0x38b00000, 0x4f380000, 0x986c0000, 0x3e820000, 0xd8410000, 0xcea18000, 0x68d04000, 0x550ba000, 0x35173000, 0x054dc800, 0x53904400, 0xbd2bde00, 0xf185ef00, 0x28e7cd80, 0xf15772c0, 0xf1ef44e0, 0x56402db0, 0x35a38008, 0x3a514004, 0x4f4a2006, 0xb2b77001, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x88000000, 0x04000000, 0x0a000000, 0x77000000, 0x3c800000, 0x37c00000, 0xd6e00000, 0x50b00000, 0x7b580000, 0xf84c0000, 0x73820000, 0x97410000, 0x07218000, 0xaf514000, 0xe26a2000, 0xfb541000, 0x5c6e2800, 0x2252dc00, 0x51e87200, 0x4c141f00, 0x6b4e3b80, 0x550072c0, 0x3f815560, 0xb942d530, 0x4a238008, 0x3cd04004, 0x652ba006, 0x14755005, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xe8000000, 0x64000000, 0x06000000, 0x83000000, 0xba800000, 0x4cc00000, 0x50a00000, 0xdb900000, 0x28480000, 0x1f0c0000, 0x3d820000, 0xe0430000, 0xa7608000, 0x4db3c000, 0x351ba000, 0x86e59000, 0xc69e1800, 0x80cb0c00, 0xfecd6a00, 0x10a07300, 0x3b922280, 0xf849de40, 0x070ee920, 0xb183c830, 0x82428008, 0x2260c00c, 0x74332002, 0xc35a500f, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xe8000000, 0xb4000000, 0xd2000000, 0xb3000000, 0xa5800000, 0x74400000, 0x6f600000, 0x52300000, 0x0c980000, 0x2fc40000, 0xf2820000, 0x9bc30000, 0x94218000, 0x4ed2c000, 0xa3eba000, 0xeebed000, 0x8cb54800, 0xcdfbcc00, 0xb8f41600, 0x02989100, 0x3ac7dd80, 0x5603b8c0, 0x49006a60, 0xc2831b10, 0xb3c38008, 0x4021c00c, 0x2cd22006, 0xf8e8100b, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x88000000, 0xec000000, 0x9a000000, 0x7f000000, 0xf2800000, 0xd5c00000, 0x8f600000, 0xc1500000, 0x1bd80000, 0x9a340000, 0xc9820000, 0xc1410000, 0x97a28000, 0xffb34000, 0xefca2000, 0x484fb000, 0x75046800, 0x788afc00, 0xaaec4a00, 0x2f349700, 0x8c005d80, 0xaa011540, 0x87007760, 0x46809cd0, 0x2bc08008, 0x86624004, 0xd6d0a00a, 0x4398f00d, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xb8000000, 0x6c000000, 0x3e000000, 0xcb000000, 0x8e800000, 0x73c00000, 0x67600000, 0x2ad00000, 0x2a280000, 0xeb2c0000, 0x63820000, 0x6a410000, 0x3c208000, 0xe971c000, 0x6f1ae000, 0x3f15b000, 0x7566f800, 0x70fc2c00, 0xf629ba00, 0x0d2d8f00, 0x94803d80, 0x12c33b40, 0x50e380a0, 0x529008b0, 0xc30a8008, 0x37dcc004, 0x49d86002, 0x2df57007, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xe8000000, 0x14000000, 0xd6000000, 0xc3000000, 0x0f800000, 0x6a400000, 0x02600000, 0xb3100000, 0x78e80000, 0xae440000, 0x22820000, 0x1ac10000, 0x85a08000, 0x9e314000, 0xed1ba000, 0x147c5000, 0x4a0d5800, 0xe4740c00, 0x799bbe00, 0xbdbd6900, 0x782c6980, 0xec077c40, 0x54e2cba0, 0x0fd27d10, 0x864a8008, 0xc3f44004, 0x67d92002, 0x19dc1005, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x38000000, 0xbc000000, 0x02000000, 0x49000000, 0x99800000, 0x56c00000, 0x31200000, 0x89d00000, 0xf0e80000, 0xec440000, 0xd6820000, 0x78410000, 0x55638000, 0x6eb14000, 0xbf58e000, 0x4e9ef000, 0x70de0800, 0x72be2400, 0x7e8ee600, 0x2f949b00, 0x1b69e480, 0x3b87f740, 0x4a211ba0, 0x7150cd10, 0x5ba98008, 0x65a44004, 0x1d71600e, 0x6dfab005, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x78000000, 0xf4000000, 0x32000000, 0x83000000, 0x38800000, 0x5c400000, 0xf9600000, 0x9df00000, 0x8bd80000, 0x1b440000, 0x2c420000, 0x11610000, 0x31f08000, 0x9ddb4000, 0xd245e000, 0x63c1d000, 0x47a1c800, 0x17d28c00, 0xc1cba200, 0x982c9100, 0x0a3e3580, 0xed55bfc0, 0xa12ba360, 0xfa1e4f10, 0x1845e008, 0x54c1d004, 0x6d21c802, 0x18928c0d, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xf8000000, 0xfc000000, 0x2a000000, 0xfd000000, 0x99800000, 0x46400000, 0x6b600000, 0xcf700000, 0xd2080000, 0x2d2c0000, 0x74420000, 0x1a610000, 0xb4f08000, 0x7d484000, 0xf1cfe000, 0xd671f000, 0xed89a800, 0x746f7400, 0x6fa02600, 0x24d3f900, 0x60dadd80, 0xbaf7d5c0, 0xba355c20, 0x879622b0, 0xe247e008, 0x111df004, 0x00aba802, 0xb07e7401, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x08000000, 0x44000000, 0x0a000000, 0xb7000000, 0x96800000, 0xf4c00000, 0x51600000, 0x69500000, 0xc6380000, 0x9d4c0000, 0x3ac20000, 0xac610000, 0x28d18000, 0x147ac000, 0x30ec2000, 0x46f31000, 0x09092800, 0xc4a75c00, 0x25769a00, 0x528cf300, 0x9322d580, 0x5cf3cd40, 0x260aa4e0, 0xce27df30, 0x27b42008, 0xf2ef1004, 0x95f32806, 0x458a5c0b, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xb8000000, 0xb4000000, 0xc6000000, 0x91000000, 0x83800000, 0x7ec00000, 0xaca00000, 0xd6100000, 0x45380000, 0x1c5c0000, 0x24c20000, 0xe7a10000, 0x5e928000, 0x137bc000, 0x16bee000, 0x4030d000, 0x726a1800, 0x1104c400, 0xe92fce00, 0x88c81b00, 0xfe17e280, 0x73970040, 0xd05570e0, 0x2d77cf70, 0x22a6e008, 0x61bcd004, 0xe2b0180a, 0x9729c40f, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0xfc000000, 0xaa000000, 0xcb000000, 0xcd800000, 0xdc400000, 0xab200000, 0x4d500000, 0x91880000, 0x66340000, 0xb7420000, 0xf6a30000, 0xe9108000, 0x96a94000, 0xd9656000, 0x11c9f000, 0xf715a800, 0x4911ac00, 0x06a97600, 0xa1669100, 0xbdca1c80, 0x0515fd40, 0x7e101a20, 0x612a46d0, 0xb6276008, 0xdb6af00c, 0x94052802, 0x44b8ec05, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x88000000, 0xd4000000, 0xf2000000, 0xc9000000, 0x86800000, 0xf5c00000, 0x1ae00000, 0xc7300000, 0xde880000, 0x5f7c0000, 0x84c20000, 0xd0630000, 0xfcf18000, 0xfb6b4000, 0xadce2000, 0x34095000, 0x14bcc800, 0x9920a400, 0xaed25a00, 0xe2387700, 0xd0b47b80, 0x759cf4c0, 0xdbf20e20, 0x32ea2ff0, 0x558c2008, 0xccaa500c, 0xe62d4806, 0x49bbe40d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x78000000, 0x14000000, 0x1a000000, 0x8f000000, 0x01800000, 0x4e400000, 0xd1a00000, 0x44500000, 0x66f80000, 0x34ec0000, 0x3b420000, 0xcf230000, 0x23928000, 0x651bc000, 0xd71de000, 0x98ea5000, 0x09b76800, 0xecfebc00, 0x0f1ac600, 0xe01d5900, 0x2d685680, 0xadf45940, 0xca5e97e0, 0x5eca2db0, 0xd2a7e008, 0x4725500c, 0xd367e80a, 0x2dc67c0f, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x18000000, 0x5c000000, 0x92000000, 0x11000000, 0x80800000, 0xf1400000, 0x1de00000, 0x4f700000, 0x57980000, 0x727c0000, 0x62420000, 0xb4610000, 0xd2b18000, 0xe13b4000, 0x75ec6000, 0x342b7000, 0xe3c74800, 0x4eefc400, 0x09aa4200, 0xa8072500, 0x274dc780, 0x0dbb55c0, 0x9eac8a60, 0x1cc833f0, 0x32366008, 0x73367004, 0xabb4c806, 0x66f5840d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x48000000, 0xe4000000, 0xe6000000, 0x25000000, 0x14800000, 0x74c00000, 0x10e00000, 0x57b00000, 0x77180000, 0x4a140000, 0x47c20000, 0x79630000, 0x3bf28000, 0xc13b4000, 0x86452000, 0xb2e99000, 0xc22c9800, 0x77041400, 0xac4a1200, 0x90bd7300, 0x65cc1380, 0xdf35a6c0, 0x0a107860, 0xd40bb250, 0x989f2008, 0x809e900c, 0xec9c180a, 0x4e9c540d, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x48000000, 0x84000000, 0x4e000000, 0xcb000000, 0xaf800000, 0x5bc00000, 0xa9600000, 0x57b00000, 0x73280000, 0x4a540000, 0x1ac20000, 0xa3e30000, 0x78f38000, 0x960bc000, 0x23452000, 0x5d381000, 0x482e3800, 0x3fceac00, 0x913c7e00, 0x1036cf00, 0xeef1f580, 0xa10a06c0, 0xeec590a0, 0xf7f85f50, 0x83cf2008, 0xd33f100c, 0xf137b80e, 0x34726c0f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xf8000000, 0x0c000000, 0xe2000000, 0x7b000000, 0x65800000, 0x69400000, 0xe3a00000, 0xc4f00000, 0x4a380000, 0x450c0000, 0xcc420000, 0x27230000, 0x1f328000, 0xf75ac000, 0x881fe000, 0xc8aa3000, 0x67a48800, 0x44e56c00, 0xf8465600, 0x5f35c500, 0xa14efe80, 0x0f623bc0, 0x9e1054e0, 0x85689a30, 0x8fc5e008, 0xd575300c, 0x3b6c080a, 0x08d0ac0b, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xa8000000, 0xfc000000, 0xc6000000, 0x17000000, 0x42800000, 0x13c00000, 0x7be00000, 0x6db00000, 0x9be80000, 0x49940000, 0xaec20000, 0x50610000, 0x2ff08000, 0x5349c000, 0xc906a000, 0x4cf9f000, 0x6fee1800, 0x6eeedc00, 0xa36fca00, 0x862d6f00, 0xa40c5f80, 0xcb5e4ec0, 0x948523a0, 0xd1b82450, 0x49cca008, 0xe3bcf004, 0x79b49802, 0xac921c07, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xc8000000, 0xfc000000, 0xe2000000, 0xef000000, 0x18800000, 0x6ec00000, 0x15a00000, 0x4ed00000, 0x64080000, 0xa59c0000, 0xe6420000, 0x73630000, 0x07728000, 0xd8d84000, 0xe6972000, 0xa75df000, 0x19e28800, 0x8eb23c00, 0x89faa200, 0x3486db00, 0xf1f68680, 0x162c4340, 0x803a2420, 0xa5a48870, 0x83e5a008, 0x5085b00c, 0x47f5a80a, 0x572fcc01, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x18000000, 0x64000000, 0xca000000, 0xa9000000, 0x0b800000, 0x92400000, 0x28e00000, 0x52f00000, 0x03780000, 0x9d2c0000, 0x7dc20000, 0xb0a30000, 0xb3118000, 0x8a0b4000, 0x14146000, 0xac0f9000, 0x55922800, 0xa9c82400, 0xafb6ee00, 0x719f6900, 0x20585380, 0x187d73c0, 0x752941e0, 0x8f44deb0, 0x0fe5e008, 0xb4f4d00c, 0x22fe4806, 0x48ebb40d, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x98000000, 0x04000000, 0x42000000, 0x59000000, 0xda800000, 0x35400000, 0xf1a00000, 0x6cd00000, 0x51580000, 0x57e40000, 0x03c20000, 0xeae30000, 0x2a718000, 0x30094000, 0x6e7e6000, 0x55461000, 0x80900800, 0xba7be400, 0x6e77aa00, 0xf339f500, 0x49d6b680, 0x7ceb2b40, 0xcf0f6960, 0x1eceb190, 0x552fe008, 0xf1df500c, 0x2e966806, 0xec49f405, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x78000000, 0x3c000000, 0x32000000, 0x8b000000, 0x24800000, 0x53c00000, 0x1da00000, 0x99d00000, 0x60e80000, 0xe99c0000, 0x91420000, 0x43630000, 0x7df08000, 0x3b78c000, 0x2295e000, 0x3ceef000, 0x73f9c800, 0xeb55ac00, 0xfe4ed200, 0x88a96f00, 0x257ee680, 0xabf01f40, 0x4e7947a0, 0xe7148870, 0xccad6008, 0x531a300c, 0x8be62802, 0x0c545c03, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xf8000000, 0x3c000000, 0x3e000000, 0xbb000000, 0x58800000, 0xa4c00000, 0xa7600000, 0xeb700000, 0x9b780000, 0x6f4c0000, 0xa7420000, 0x2b230000, 0xa0d28000, 0x03684000, 0xe547e000, 0xea76f000, 0x3eadf800, 0x6bf16c00, 0xd3b8a200, 0xae2fb300, 0xdb33cd80, 0x2edb45c0, 0xec5e09e0, 0x65c88b30, 0x3ad76008, 0x2e3db00c, 0x1d38980a, 0x15efdc01, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xc8000000, 0x4c000000, 0x5e000000, 0x59000000, 0x35800000, 0x1ac00000, 0x51200000, 0x2ab00000, 0x61980000, 0xad340000, 0x1e420000, 0xc2630000, 0xd7508000, 0x3f08c000, 0x459f2000, 0xdd2f3000, 0x4bb47800, 0x6200e400, 0x2f039600, 0x30830b00, 0x89439480, 0x96e3c2c0, 0x5c10aa60, 0x56ea7ed0, 0xf10da008, 0xb684f00c, 0xf65bd802, 0xc3971403, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x78000000, 0x54000000, 0xca000000, 0x19000000, 0x05800000, 0x9c400000, 0xc2600000, 0x2a300000, 0x79a80000, 0x5ab40000, 0xe4c20000, 0x59a30000, 0x31138000, 0xe27a4000, 0x6a6de000, 0x873f5000, 0x87262800, 0xb77ae400, 0xa1eed600, 0x507c5100, 0x9dc4f980, 0xb689b0c0, 0xcb653aa0, 0x2d1810d0, 0xafdc6008, 0x0bd6100c, 0xf270480e, 0xc9cbf409, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0xc4000000, 0xf6000000, 0x15000000, 0xdb800000, 0x5c400000, 0x19e00000, 0x21700000, 0x90580000, 0xe5240000, 0xb4c20000, 0xf3210000, 0x5b508000, 0x52894000, 0x60ece000, 0xff4d1000, 0x98dcd800, 0xf577d400, 0xb4c9ae00, 0x560d5100, 0x6abc5780, 0xc046edc0, 0x9171bd60, 0x9858a690, 0x69266008, 0xeec15004, 0xec22b802, 0xa7d28405, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x08000000, 0x64000000, 0xce000000, 0xb9000000, 0x31800000, 0x3bc00000, 0x88a00000, 0x61900000, 0xc1080000, 0x3f1c0000, 0xa9420000, 0x1de10000, 0xee728000, 0x9479c000, 0xf9e42000, 0x25e79000, 0x67e43800, 0xa4e76400, 0x9a648600, 0x45248f00, 0x6dc7d280, 0xc8374e40, 0x688f2820, 0xfd481670, 0x197ca008, 0x7bf35004, 0x81b8980a, 0x18443407, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xe8000000, 0x54000000, 0x56000000, 0x67000000, 0xab800000, 0xf3400000, 0xc3200000, 0xb9f00000, 0xe9580000, 0x7c2c0000, 0x0dc20000, 0xd2e30000, 0x19138000, 0x99494000, 0xc5e7a000, 0x7ae75000, 0xfd645800, 0x04271c00, 0xf2056e00, 0x3977ad00, 0xbbee3c80, 0x0a228fc0, 0xe9705160, 0x039baab0, 0xc54e2008, 0x0791100c, 0xd88a780e, 0x8d060c05, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x98000000, 0x0c000000, 0x1a000000, 0x17000000, 0xe6800000, 0xcb400000, 0x94e00000, 0x3d900000, 0x11780000, 0x33d40000, 0xc4e20000, 0x05910000, 0x6d7b8000, 0x21d64000, 0x47e06000, 0xf5113000, 0xab3be800, 0x44b61c00, 0x57b3fa00, 0xbbca1d00, 0x319dbb80, 0xacbcea40, 0x708ebfe0, 0x21875250, 0xd13be808, 0x83b61c04, 0xc933fa0e, 0xec8a1d09, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xd8000000, 0x7c000000, 0x9e000000, 0x0f000000, 0xb6800000, 0xe1400000, 0xf3a00000, 0x07500000, 0x71180000, 0xcffc0000, 0x2da20000, 0x68530000, 0x379a8000, 0xa6bd4000, 0x7a016000, 0x8d02f000, 0xd780f800, 0xd0c17c00, 0x0061ba00, 0xf7b27500, 0x14e9b680, 0x00342140, 0xc4851e60, 0x98edbaf0, 0x8698f808, 0x8f3d7c0c, 0x55c3ba0a, 0xb3e17505, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x28000000, 0x84000000, 0x86000000, 0xc7000000, 0xd4800000, 0x2f400000, 0xd3600000, 0xc1b00000, 0x19780000, 0x1a340000, 0xb9620000, 0x64b30000, 0x5cfa8000, 0x7ef5c000, 0x3dc2a000, 0x5b211000, 0x16509800, 0xaf8adc00, 0x7c2ff200, 0x60e4ad00, 0x85a85580, 0x31fd9ac0, 0x60ae77e0, 0xdba4b5d0, 0x28c89808, 0xeb4edc0c, 0x8755f20a, 0x2bd3ad07, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x68000000, 0x74000000, 0x92000000, 0x89000000, 0x84800000, 0x96400000, 0x37a00000, 0xf3500000, 0x4e780000, 0x7dbc0000, 0x84a20000, 0x2ad10000, 0x9ebb8000, 0x8d5ec000, 0xd8d3a000, 0xe7b8d000, 0x81ddc800, 0x8a92e400, 0x2a1ab200, 0x8f8c0900, 0xd26a5680, 0x48e54940, 0xb80f7be0, 0x9da827f0, 0xaf87c808, 0xbbbfe404, 0x8fa3320e, 0x1f53c90b, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x14000000, 0x72000000, 0x65000000, 0xb2800000, 0x61c00000, 0x29e00000, 0x25900000, 0x2a780000, 0x10a40000, 0xb6e20000, 0xb6110000, 0x83398000, 0x39844000, 0x1213a000, 0xa9395000, 0x50844800, 0xbe93d400, 0xa3fa6a00, 0xc8e45700, 0x5f432f80, 0x1621a240, 0x0773b3e0, 0xae684d90, 0x969e4808, 0x2de6d404, 0xadc1ea06, 0x17e11701, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xc8000000, 0xe4000000, 0x36000000, 0x73000000, 0x0f800000, 0xda400000, 0x4c600000, 0x84d00000, 0x0df80000, 0xd4440000, 0x31620000, 0xa4510000, 0xf2388000, 0x3b644000, 0x9f512000, 0x59ba9000, 0xf7245800, 0xb0338c00, 0x1aea1e00, 0xc49c7900, 0x1e17a980, 0xdc5bff40, 0x62b619e0, 0xe22a2010, 0x9a3e5808, 0xdd668c04, 0x44509e02, 0x82393901, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xd8000000, 0x44000000, 0x92000000, 0x0b000000, 0xb3800000, 0x08400000, 0x90200000, 0x10f00000, 0x8dc80000, 0xec940000, 0x0d220000, 0x9a730000, 0x8d098000, 0xcf774000, 0x19b16000, 0x416a1000, 0x65a7c800, 0x1b896c00, 0xd9b6ae00, 0xc352b100, 0x3d784880, 0xdd7e8fc0, 0x2f44a920, 0x1f9bbb50, 0x956dc808, 0x6d9e6c0c, 0x6c552e06, 0xeec2f10d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x58000000, 0xfc000000, 0xce000000, 0x3d000000, 0x1d800000, 0x9d400000, 0xcba00000, 0xccf00000, 0x7a780000, 0x31a40000, 0xeca20000, 0xa6730000, 0x25bb8000, 0xe1c4c000, 0xf2336000, 0x6998f000, 0x0774b800, 0x616a3400, 0xbf0e1600, 0x1bcc0500, 0xbf2dd680, 0xab7c27c0, 0x0d742fe0, 0x9e6aab90, 0xe98eb808, 0x6a0d340c, 0x624f960e, 0xf06fc503, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x18000000, 0xfc000000, 0xaa000000, 0xc1000000, 0xbe800000, 0x29400000, 0x15e00000, 0xcaf00000, 0x4e280000, 0x41c40000, 0x67620000, 0xb1b10000, 0x36ca8000, 0x77b7c000, 0x250a6000, 0x0d16f000, 0xd91a2800, 0xe24dc400, 0x0f361a00, 0x6f4b9500, 0xd3751f80, 0x3a289fc0, 0x1fc7caa0, 0xb861b610, 0x7030a808, 0x2e0a0404, 0x62947a0a, 0x06d9650f, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x08000000, 0x84000000, 0x76000000, 0xdb000000, 0xf3800000, 0x30400000, 0xc2a00000, 0x2bf00000, 0x5ad80000, 0x7c440000, 0xcd220000, 0xa1b10000, 0x117a8000, 0xf937c000, 0x873a2000, 0x58971000, 0x73495800, 0x300dac00, 0x68af6e00, 0x7a5e1100, 0x26077280, 0x3e8393c0, 0x08c31d60, 0x59612c10, 0xa513d808, 0x498a6c04, 0x246d4e0a, 0xb53d010f, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x48000000, 0x0c000000, 0xd2000000, 0x5f000000, 0xc2800000, 0xf7c00000, 0x02a00000, 0xf0100000, 0xda380000, 0x04740000, 0xea220000, 0x5cd10000, 0x241b8000, 0xbea4c000, 0xe73b2000, 0x91f53000, 0x3362c800, 0x4bb0bc00, 0xc1a9aa00, 0x5a0f2f00, 0x1cb46280, 0x22018c40, 0xb701aae0, 0x1e81f2d0, 0x5dc14808, 0x19a07c04, 0xec908a0e, 0xa0fb1f03, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x7c000000, 0x32000000, 0x89000000, 0x3a800000, 0x10c00000, 0xa0600000, 0x7ab00000, 0xcdf80000, 0xf2d40000, 0x24e20000, 0xa9710000, 0x9a188000, 0xf4244000, 0x96ba2000, 0x7cf4f000, 0x98f24800, 0x615b6400, 0x2a044a00, 0x02abf300, 0xd8df6980, 0x12ecbec0, 0x62d455e0, 0x6ce20c50, 0xf572c808, 0xb81b2404, 0x75246a02, 0xd03a0301, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x38000000, 0x3c000000, 0xfe000000, 0x59000000, 0xe2800000, 0xc2400000, 0xe4600000, 0x90700000, 0xef680000, 0xb8e40000, 0x57e20000, 0x74b30000, 0xab4a8000, 0xdbf6c000, 0xab7ae000, 0x3ffff000, 0x9c6f7800, 0xd5b6a400, 0xe918ea00, 0xda8cb900, 0xe786c980, 0xf210f5c0, 0x7a1a5fa0, 0x5b0fc690, 0xfc47f808, 0x21b3640c, 0x4fc88a0a, 0xdcb5890b, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x98000000, 0x74000000, 0x9e000000, 0xa5000000, 0x6f800000, 0x71400000, 0xfee00000, 0xf7900000, 0xca180000, 0x55a40000, 0x5c620000, 0x75510000, 0x07bb8000, 0x5bd74000, 0xd9686000, 0xbb2cd000, 0xd55ff800, 0xc056d400, 0x762b5e00, 0x00cdd500, 0x9d4d2380, 0xe30eba40, 0xa96fde60, 0x353e6f90, 0x87067808, 0xde909404, 0xdf98be0e, 0x67e6450d, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x88000000, 0xa4000000, 0x56000000, 0x9d000000, 0xa1800000, 0x00c00000, 0x7d200000, 0x83d00000, 0x8d080000, 0xbd7c0000, 0x05a20000, 0xc4930000, 0x85e98000, 0x360dc000, 0xd5b82000, 0xb0c59000, 0x4966d800, 0xe7f6b400, 0xf51c2600, 0x8593d300, 0x9e69cc80, 0x39cc8b40, 0xb21a9a20, 0x87566af0, 0xbc0d5808, 0xf2b8740c, 0x1e458606, 0x53278307, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xf8000000, 0xe4000000, 0x06000000, 0xd9000000, 0x38800000, 0x43c00000, 0xcfe00000, 0x55700000, 0xd9280000, 0x7f940000, 0x52620000, 0xbc310000, 0x420a8000, 0x88864000, 0xbf79e000, 0xadae9000, 0x12ec9800, 0x48ce2400, 0x535e8200, 0x93855f00, 0x88fb0780, 0x57ef81c0, 0xd24d2ea0, 0x6f9ebd50, 0x2de41808, 0x5ec96404, 0xe6e5e20a, 0x31498f09, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xd8000000, 0x8c000000, 0xa2000000, 0xeb000000, 0x1e800000, 0x33400000, 0x41a00000, 0x13700000, 0xc6a80000, 0x277c0000, 0x76220000, 0x65b10000, 0x92cb8000, 0x3aefc000, 0x98596000, 0xf0173000, 0xb9bf0800, 0xd6436c00, 0x46219a00, 0x1db2bd00, 0x0ecb2e80, 0xb0eeb1c0, 0x2759d8a0, 0xc09474f0, 0xc3fe8808, 0x6261ac04, 0x78917a0e, 0xa9fb4d0f, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x98000000, 0x74000000, 0x8e000000, 0xcf000000, 0xa0800000, 0xfcc00000, 0xc9e00000, 0x53500000, 0x6c180000, 0x68640000, 0xd0620000, 0xc4130000, 0x5fb88000, 0xbd164000, 0xe4486000, 0x5afed000, 0xa3c4b800, 0x01107c00, 0x563b6200, 0x7254e300, 0x83eb3f80, 0x918ec140, 0xc0ee5a60, 0x4b7c1690, 0xd8863808, 0xc8b13c0c, 0xc2498202, 0x29ff7309, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x18000000, 0xe4000000, 0x52000000, 0x13000000, 0x0c800000, 0x63400000, 0x46a00000, 0x72d00000, 0xee480000, 0xb8940000, 0x4f220000, 0x0c130000, 0x5c2b8000, 0x6f25c000, 0x585a6000, 0xcbbc9000, 0x7a84c800, 0x06088c00, 0xd6b4d200, 0xecb25d00, 0xc7faf280, 0x82edf740, 0x490e9320, 0xf87f0b50, 0xb9654808, 0xfb7a4c0c, 0xd9af320e, 0x7bac0d07, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xd8000000, 0xbc000000, 0x3e000000, 0x4f000000, 0xdc800000, 0xf0400000, 0x9ce00000, 0x1a700000, 0x4b280000, 0x0e440000, 0x15620000, 0x5bb30000, 0xfa098000, 0x23144000, 0x90196000, 0xea0df000, 0x5d977800, 0xa1587c00, 0x4d6e9200, 0x1f26f100, 0xdcd0ab80, 0x08ba45c0, 0xf69d96a0, 0xa1cf1c10, 0x59b4f808, 0xed8b3c0c, 0x5dd47206, 0x35b84101, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x18000000, 0x74000000, 0x8a000000, 0xe3000000, 0x2a800000, 0x32400000, 0x31600000, 0xc7f00000, 0x78e80000, 0xccac0000, 0xeee20000, 0xaa330000, 0xe4498000, 0xf7ff4000, 0x7d5a6000, 0xed26d000, 0x39bda800, 0x0a39cc00, 0x87d64a00, 0xcad5d900, 0x5154cd80, 0xbe95a3c0, 0xcd3571a0, 0xf2e5ffb0, 0x221e2808, 0xe9e98c0c, 0x612faa06, 0x0423490d, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xe8000000, 0xf4000000, 0xc6000000, 0x07000000, 0x0d800000, 0x38c00000, 0x76200000, 0x36900000, 0x0ed80000, 0x442c0000, 0x1ee20000, 0x78b30000, 0x34498000, 0xe0f5c000, 0x87cda000, 0x5ed2d000, 0xb8b99800, 0x90dc5c00, 0x12c85600, 0xafb79300, 0xec2e9080, 0x4ae31e40, 0xaeb13160, 0xab4a55b0, 0xf1743808, 0x8d0e8c0c, 0xe9f1ce06, 0x84abcf07, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x98000000, 0x54000000, 0x72000000, 0x95000000, 0x6c800000, 0x6ec00000, 0x46a00000, 0x1c500000, 0xab780000, 0xab940000, 0x40620000, 0x86f30000, 0xa92a8000, 0x63ef4000, 0xf8746000, 0x05d05000, 0x19384800, 0x6bf79400, 0x06929200, 0x8fd98b00, 0x1ac70280, 0x039aad40, 0xa9a42be0, 0x6eeb7750, 0xe7cc2808, 0x01e7c40c, 0xe78ada0a, 0xd3be1f0d, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x48000000, 0x6c000000, 0x5e000000, 0xbf000000, 0x11800000, 0x62c00000, 0xb2a00000, 0xfef00000, 0xd6b80000, 0x7d340000, 0x9c620000, 0xa2530000, 0xaf498000, 0x8e0c4000, 0xf9972000, 0x0190b000, 0x036bf800, 0x3bbf3c00, 0xcb4f2600, 0x4af41b00, 0x3a428280, 0xc2e2bfc0, 0x491100e0, 0x3b28e9d0, 0xe05cd808, 0x78df8c0c, 0x689cde06, 0xcf7f2701, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x28000000, 0xac000000, 0x12000000, 0x4f000000, 0x8b800000, 0x8cc00000, 0x8ca00000, 0x3d900000, 0xfda80000, 0x400c0000, 0xa4620000, 0x3f330000, 0x153a8000, 0x2527c000, 0xd92ea000, 0x7833b000, 0x02b9c800, 0x33e47c00, 0x468f4e00, 0xf4212300, 0x90d14a80, 0x66c8c240, 0x1cbf84a0, 0x31990d30, 0x74b76808, 0x9687cc0c, 0x873e860a, 0x05595f0f, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x68000000, 0xa4000000, 0x2a000000, 0x75000000, 0x8f800000, 0xa6c00000, 0x57a00000, 0x5cb00000, 0xff380000, 0xcf8c0000, 0x3b620000, 0x0e130000, 0xf40a8000, 0x4a744000, 0x454fa000, 0x92c39000, 0xd5a12800, 0x2db31400, 0x4abbde00, 0x744dab00, 0x47416680, 0xde630ec0, 0x299296e0, 0x56cbdb30, 0x27d68808, 0x04fc840c, 0x4678f60a, 0x96edbf01, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x78000000, 0x3c000000, 0x76000000, 0x05000000, 0xbf800000, 0x7f400000, 0xcf200000, 0xf8900000, 0xf0880000, 0xaaf40000, 0x0e620000, 0xb6b30000, 0xdd988000, 0x663cc000, 0xa937e000, 0xbc81f000, 0x5dc25800, 0x23e05400, 0x76f3de00, 0x8638ed00, 0x576e1480, 0x585c2e40, 0x67842820, 0x5d1828d0, 0x4dfdb808, 0x8fd5a40c, 0x75f38602, 0xa4bbb903, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x88000000, 0x74000000, 0x26000000, 0x17000000, 0xbc800000, 0x0b400000, 0x7aa00000, 0x65f00000, 0x6f280000, 0x69740000, 0x63e20000, 0xce530000, 0x91588000, 0x299c4000, 0x87742000, 0xe0e0d000, 0x64d31800, 0x15189c00, 0x13bc9200, 0xbbc5dd00, 0xc469a280, 0xc3d6d3c0, 0xae11d2a0, 0xc57a1ad0, 0x562f3808, 0x297c4c0c, 0xd3a58a02, 0x6dfa4101, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x48000000, 0xcc000000, 0x12000000, 0xc1000000, 0xac800000, 0x5a400000, 0xd1e00000, 0xd0500000, 0x16480000, 0x542c0000, 0x9da20000, 0xdeb30000, 0xd9998000, 0xe5a64000, 0xa6af2000, 0xd4e23000, 0x02d2c800, 0x6f08c400, 0x304dd200, 0x3f317900, 0x9d5b3f80, 0x5f058d40, 0xd39daf20, 0xccbaabb0, 0x4f55e808, 0xa5d6f40c, 0x08951a06, 0x9af6bd09, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x88000000, 0xb4000000, 0xc2000000, 0x11000000, 0xc0800000, 0x57400000, 0x0d200000, 0x8c500000, 0xe3f80000, 0xe0e40000, 0xb4620000, 0x0e730000, 0x382a8000, 0x9fdd4000, 0xe3642000, 0xdaa3d000, 0xd0928800, 0xf41b8400, 0xd0546200, 0xdaabad00, 0xe99eec80, 0x56c5fd40, 0x6db089e0, 0xc04a7c90, 0xffaea808, 0x944c540c, 0xb2fcea0a, 0xff372905, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x98000000, 0xcc000000, 0x46000000, 0x63000000, 0x27800000, 0x4b400000, 0xc3600000, 0x18f00000, 0xb7b80000, 0xe54c0000, 0x47220000, 0x4a130000, 0xff0b8000, 0x4a14c000, 0x2fdc6000, 0xd6ea3000, 0x29259800, 0x6dc4cc00, 0x2e773e00, 0x12aefd00, 0x8b136580, 0x698ad7c0, 0x2fd5dce0, 0x957cae30, 0x9abbf808, 0xe5cdfc0c, 0xe9e1260e, 0x8332f103, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x68000000, 0xd4000000, 0x6e000000, 0xcb000000, 0xd0800000, 0x28400000, 0xfe200000, 0x73500000, 0xd3580000, 0x38040000, 0x13620000, 0x26f10000, 0xd0cb8000, 0x193fc000, 0xa017a000, 0x8a985000, 0xa3e73800, 0x01d16c00, 0xa2182200, 0x87a5d100, 0xcdf0d080, 0x504bf940, 0x497ff360, 0x12377b10, 0x2bca9808, 0x01bc3c04, 0x4c569a0e, 0x82ba7d0f, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x38000000, 0x5c000000, 0x16000000, 0x2b000000, 0x78800000, 0x4d400000, 0xb5a00000, 0xc4b00000, 0x51d80000, 0x316c0000, 0x55e20000, 0x0a910000, 0x94a98000, 0xda54c000, 0x4c9ee000, 0xd39a7000, 0xf64cd800, 0x8113ec00, 0x8d68c200, 0x6cb52500, 0x7a8d3e80, 0x107006c0, 0xacb9f960, 0x3ebd0ab0, 0x70e83808, 0x6e749c04, 0x8cef9a06, 0x37230903, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x88000000, 0x04000000, 0x22000000, 0x89000000, 0xdd800000, 0x74400000, 0x7c200000, 0xc9100000, 0xf6380000, 0xe43c0000, 0x5b620000, 0x0db10000, 0x20e88000, 0x8966c000, 0xd2ec2000, 0xe63b1000, 0x9c3d0800, 0xf7626400, 0x9bb29600, 0x03eb6100, 0xd9e7a880, 0x592da840, 0x67599ae0, 0xf48c3ff0, 0xbc0b2808, 0xf5947404, 0x75a51e02, 0x790ec50b, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xe8000000, 0xc4000000, 0x8e000000, 0xd9000000, 0x91800000, 0xc6400000, 0x10e00000, 0x01500000, 0x4e380000, 0xad4c0000, 0xeb220000, 0xddf10000, 0xe88b8000, 0x7aa74000, 0xb795a000, 0x893c1000, 0x41eab800, 0xd9b6a400, 0x574f2600, 0xc423e900, 0x59704b80, 0x254a8940, 0x1306c2e0, 0x2aa63e30, 0x1f949808, 0xad3df404, 0x1fe83e0e, 0xe8b55d0d, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xf8000000, 0xcc000000, 0xf2000000, 0xe3000000, 0xbc800000, 0x27400000, 0xb6200000, 0x52500000, 0xafc80000, 0x61240000, 0x0fe20000, 0x88330000, 0x53388000, 0xcdfec000, 0x522de000, 0xd5263000, 0xf1e24800, 0xb932cc00, 0xbcbb5200, 0xae3e8d00, 0x0f4fc080, 0xc3573d40, 0xef798920, 0xcb5d2790, 0xf53f2808, 0x9fce3c0c, 0x8616fa02, 0xf259710b, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xb8000000, 0xf4000000, 0x5e000000, 0x5d000000, 0x27800000, 0x9a400000, 0xe1a00000, 0x96300000, 0xac480000, 0xff3c0000, 0x9e620000, 0xf2d10000, 0xa3598000, 0x4785c000, 0xde74e000, 0xaedcd000, 0xaaf3f800, 0xd2283400, 0x3dee3e00, 0xe5389900, 0x3156ce80, 0x9b2e04c0, 0x4058e320, 0x0d061ff0, 0xbbb69808, 0x513d2404, 0x3b632606, 0x41517d07, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xb8000000, 0x64000000, 0x52000000, 0x0b000000, 0xf7800000, 0x92c00000, 0x98e00000, 0xc2300000, 0x2de80000, 0xeddc0000, 0x72a20000, 0xbd930000, 0x46fa8000, 0x0166c000, 0x6c64e000, 0xaae49000, 0x08a6c800, 0xcb056c00, 0x86147e00, 0x3bac7b00, 0x05e91b80, 0x41de5cc0, 0x5ca33da0, 0x3091f670, 0x507aa808, 0x0b243c0c, 0xc3c4d60a, 0x69f7470b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x48000000, 0x04000000, 0x02000000, 0x31000000, 0x0b800000, 0xb4c00000, 0xdc200000, 0xe8500000, 0xe6780000, 0xa9ec0000, 0xd0620000, 0x7a330000, 0x8d4b8000, 0xbf25c000, 0xe3872000, 0x09951000, 0x6a8e8800, 0x00d38400, 0x70384e00, 0x168da300, 0x6ed18880, 0xd7395d40, 0x160cebe0, 0xac9356b0, 0xb2582808, 0xa5bc540c, 0x4418660e, 0xaaddf707, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xc8000000, 0x94000000, 0x72000000, 0x3f000000, 0x9a800000, 0x96c00000, 0x16e00000, 0x11d00000, 0x33f80000, 0x57ec0000, 0x23a20000, 0x36730000, 0xaf898000, 0x4b66c000, 0x6c452000, 0xddf75000, 0x271d4800, 0x3ceabc00, 0x46f50a00, 0xc79e6b00, 0x612b2380, 0x08968340, 0xb78c81e0, 0x4ab0bab0, 0xaa6be808, 0x8e342c0c, 0xa07ee206, 0x837a470b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x98000000, 0x64000000, 0x32000000, 0xc9000000, 0xc3800000, 0x40400000, 0x42200000, 0x66d00000, 0x00080000, 0xec1c0000, 0x6ee20000, 0x04330000, 0xea3b8000, 0xc926c000, 0xb7446000, 0x05b49000, 0x786e4800, 0x2efb6400, 0xb7c72e00, 0xbb75b100, 0x438df080, 0xcf4b0740, 0x9ebf3220, 0xeef37370, 0xbbdba808, 0x6596340c, 0xdfbc860e, 0x4173850b, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x58000000, 0xac000000, 0xb6000000, 0x41000000, 0x02800000, 0xefc00000, 0x25a00000, 0x3f700000, 0xc6380000, 0x35f40000, 0x23e20000, 0x68930000, 0x74a98000, 0xd65e4000, 0x263f6000, 0xfbefb000, 0xe9265800, 0x93abc400, 0x0dddaa00, 0x077daf00, 0x178ede80, 0xeaf471c0, 0xc460bee0, 0xa7d11ed0, 0x75cab808, 0x610d340c, 0xdf371206, 0x76c09b09, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x88000000, 0x44000000, 0xce000000, 0x25000000, 0x26800000, 0xf3400000, 0x47e00000, 0x1b700000, 0x01880000, 0x38dc0000, 0xd3720000, 0xe58b0000, 0x26dd8000, 0xce70c000, 0x0f092000, 0x5f9c9000, 0x6293f800, 0x17f9b400, 0x8bd40a00, 0xeeec3500, 0x981aab80, 0x74a767c0, 0xf165b320, 0xbdc488f0, 0x4d540a08, 0x6dac350c, 0x37faab86, 0x9bd767cb, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x08000000, 0x3c000000, 0xd6000000, 0xed000000, 0x73800000, 0xf1c00000, 0x73600000, 0x44d00000, 0xd1d80000, 0x1ac40000, 0xbcd20000, 0xa5d90000, 0x50c68000, 0xf7d3c000, 0x33592000, 0xee867000, 0xa3709800, 0xe9ea9400, 0x080fbe00, 0x99af5f00, 0x3c9d5980, 0x55d5ad40, 0xbd6b9860, 0x814c7290, 0x2d8fbe08, 0xc56f5f04, 0x9c7d598a, 0x90c5ad47, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x48000000, 0x84000000, 0x3a000000, 0xd3000000, 0x7a800000, 0x96400000, 0xdee00000, 0x37700000, 0x25c80000, 0xb8240000, 0x4b720000, 0x33cb0000, 0x05248000, 0x60f1c000, 0xc00a2000, 0x89069000, 0xf6212800, 0xa5d16c00, 0xcf5b7a00, 0x681d7100, 0x8cdf1780, 0xa07e27c0, 0xa3efa620, 0xda549710, 0xf13b7a08, 0x2a2d710c, 0x65771782, 0xcd6a27cf, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xa8000000, 0xac000000, 0x36000000, 0x59000000, 0x0d800000, 0x23400000, 0x6c200000, 0x16f00000, 0x2b180000, 0x3f7c0000, 0x60f20000, 0xd21b0000, 0x22fd8000, 0x9bb3c000, 0xba39a000, 0xae0f3000, 0xdfab1800, 0xd1c4c400, 0xe03d0600, 0x42d09500, 0x89e8f480, 0x46669dc0, 0xec8d9960, 0x78693970, 0x2b250608, 0xcdac950c, 0x211af486, 0x487d9dc7, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x78000000, 0x44000000, 0x1e000000, 0x0f000000, 0x41800000, 0xa2400000, 0xf4600000, 0xcd900000, 0x7c780000, 0xa7040000, 0x9b920000, 0x6f7b0000, 0x2c878000, 0x20d3c000, 0xe99ae000, 0x58d69000, 0x1b8bb800, 0x39eedc00, 0x916d9600, 0xf9ae3100, 0x100c8d80, 0xf4bc6040, 0x88b5a0e0, 0x781ac190, 0xd2959608, 0x43ea310c, 0xa67e8d8e, 0xc0176047, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x88000000, 0x1c000000, 0xfa000000, 0x45000000, 0xb3800000, 0xf5400000, 0xa8200000, 0x3a500000, 0xa5080000, 0x6f240000, 0x5c520000, 0xda0b0000, 0xb9a48000, 0x4a934000, 0x0f692000, 0x37d4f000, 0x2fc8a800, 0x80443400, 0xb7203e00, 0x5cd27d00, 0x4bc91480, 0x7e471740, 0xbc228920, 0x1c517810, 0x3a083e08, 0xc9a67d0c, 0x92931482, 0x9b681745, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x88000000, 0x1c000000, 0x52000000, 0xcf000000, 0xf8800000, 0xfdc00000, 0x3da00000, 0x37b00000, 0x6f580000, 0x37540000, 0x19b20000, 0x82590000, 0xb8d68000, 0x18f04000, 0x843b2000, 0x33c6f000, 0x25990800, 0x16741c00, 0x25c31200, 0x49a1ff00, 0x49b36a80, 0xea590cc0, 0x94d52260, 0x52f167d0, 0xdf3b1208, 0x8545ff04, 0x45596a8a, 0x1c540cc9, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xd8000000, 0x0c000000, 0x5e000000, 0x1f000000, 0x97800000, 0xfbc00000, 0xffe00000, 0x89b00000, 0xc3880000, 0x82c40000, 0x53b20000, 0x868b0000, 0x90468000, 0x1af0c000, 0x80286000, 0xc756b000, 0x8269b800, 0xc4741c00, 0xcfbaee00, 0x9b8f5700, 0xb6146380, 0x58cb88c0, 0x05677920, 0x2c23f890, 0xc252ee08, 0x083b570c, 0x684e638a, 0x8df488cb, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xc8000000, 0x3c000000, 0xb2000000, 0x33000000, 0x6c800000, 0x59400000, 0x8da00000, 0x77d00000, 0x06a80000, 0x34940000, 0x84d20000, 0x0a290000, 0xbdd48000, 0x3171c000, 0x89fa2000, 0x357c7000, 0x84e70800, 0x52a8ec00, 0x0a94c200, 0xedd2ed00, 0x99ab1a80, 0xf2173d40, 0xea9287a0, 0xad0ac0d0, 0x2e46c208, 0x57fbed04, 0xcc7f9a82, 0x0f66fd4f, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xe8000000, 0x5c000000, 0xf6000000, 0xcf000000, 0xd6800000, 0xc9400000, 0x66600000, 0x93500000, 0xc5480000, 0xac2c0000, 0x36520000, 0xcac90000, 0x0cee8000, 0x77f14000, 0x42baa000, 0x9697f000, 0xb4c69800, 0x040f9c00, 0xd9e3aa00, 0xeb903d00, 0x40e8c580, 0xb65c8740, 0x212b3820, 0xba7fbd30, 0x6c99aa08, 0x8e253d04, 0xf71c458a, 0x2b48c74d, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x98000000, 0x3c000000, 0x52000000, 0x49000000, 0x8b800000, 0x02c00000, 0x88200000, 0xc2300000, 0xf1c80000, 0xf9440000, 0x41b20000, 0x67090000, 0xe7658000, 0xd483c000, 0x9e436000, 0xe2617000, 0xc6508800, 0xf89b4400, 0x355ede00, 0xdaaf4300, 0xa7c40480, 0xcaf3a6c0, 0x2cea8c20, 0xf2f7e590, 0x13bb5e08, 0x39ec8304, 0x08276486, 0xd162d6c7, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x38000000, 0x3c000000, 0x52000000, 0x49000000, 0xf6800000, 0x72400000, 0xd8600000, 0x47300000, 0x4e880000, 0xc1540000, 0xddb20000, 0xe6cb0000, 0xf4368000, 0x7203c000, 0xf903e000, 0x6e827000, 0x3e408800, 0xb261c400, 0x32332a00, 0xea088100, 0xfa164580, 0xf350c6c0, 0xd3bbf320, 0x62dee4d0, 0xf465aa08, 0x6a3b410c, 0x491da58a, 0x17c6b6c7, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x88000000, 0x14000000, 0x6e000000, 0x9b000000, 0x56800000, 0xfb400000, 0x42200000, 0xc6700000, 0xef980000, 0x4a2c0000, 0x1cf20000, 0x26db0000, 0x490e8000, 0xe9004000, 0x77812000, 0xf8c2d000, 0xe4e3f800, 0xa1904c00, 0x84890a00, 0x4fe65500, 0xe4356480, 0xc91f43c0, 0xc24bd360, 0xd807e030, 0x37278a08, 0xc0d6150c, 0xc88c448a, 0xd6c193c9, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x28000000, 0x54000000, 0xd2000000, 0x1f000000, 0x66800000, 0xd3c00000, 0x81200000, 0xc5f00000, 0x49580000, 0x84cc0000, 0xd5720000, 0x3f990000, 0xc86f8000, 0x07c3c000, 0x1321a000, 0x3af2d000, 0x5fda8800, 0x7f0cdc00, 0x0052ca00, 0x28690700, 0x9e35f880, 0xe58d4dc0, 0x1591ca60, 0x844bc7b0, 0x52454a08, 0x3196c704, 0x97be588e, 0xc7ea9dc7, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x58000000, 0x44000000, 0x76000000, 0xbd000000, 0x59800000, 0xfbc00000, 0x04200000, 0xcd700000, 0x96680000, 0x7fc40000, 0x1ef20000, 0xb2ab0000, 0x21668000, 0xe0c2c000, 0xe8a26000, 0xe3339000, 0x33891800, 0x61979400, 0x936a7600, 0x32453700, 0x5b326480, 0x278993c0, 0xdf9656a0, 0x026a3f90, 0x01c4f608, 0x2ff3f70c, 0xb12a048a, 0x0da503c3, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xd8000000, 0xbc000000, 0x5e000000, 0xab000000, 0xce800000, 0xdac00000, 0x87200000, 0x4eb00000, 0xdf180000, 0x87140000, 0x0b320000, 0xbb5b0000, 0xb2f58000, 0x76a14000, 0x10f06000, 0xa3fb7000, 0xc1063800, 0x1fdbcc00, 0x3936ca00, 0x16019300, 0x6f00f080, 0x9c80e0c0, 0x27c1a760, 0x86a218d0, 0xb8f14a08, 0x77fbd30c, 0x2b051086, 0x8edad0cd, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xc8000000, 0x54000000, 0x66000000, 0x1d000000, 0xb4800000, 0x49400000, 0x06600000, 0x45f00000, 0x2d680000, 0x528c0000, 0x48720000, 0xbeab0000, 0xf4ae8000, 0xa963c000, 0x4a702000, 0x6dabd000, 0xd92c5800, 0x8aa15400, 0x84508200, 0xa8ba3d00, 0x83f5ad80, 0x5aa6e5c0, 0x269dc0a0, 0x3c2b4bb0, 0xd8ec0208, 0x2782fd0c, 0x04c30d8a, 0xf5a2f5c7, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xe8000000, 0xdc000000, 0xce000000, 0xc7000000, 0xff800000, 0x55400000, 0xf4a00000, 0xf9300000, 0x59380000, 0x13fc0000, 0xdfb20000, 0x8cfb0000, 0xe99f8000, 0x0d63c000, 0xe550a000, 0x70e8f000, 0x3bd6f800, 0x3c86bc00, 0x6d6d8e00, 0x5238ed00, 0x7a7d8e80, 0x99f3fac0, 0xe5da21e0, 0xa4eff570, 0x44780e08, 0x6b5c2d0c, 0x9080ae8e, 0x56c3cac7, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xb8000000, 0xcc000000, 0x7a000000, 0x3f000000, 0xc3800000, 0x09400000, 0x06e00000, 0xebb00000, 0xcba80000, 0xf8a40000, 0x21320000, 0x04690000, 0x2b848000, 0x96a04000, 0x93d3e000, 0x39dbb000, 0x152fa800, 0xba841c00, 0x0c233e00, 0x84104d00, 0x96fa2780, 0xf0bc00c0, 0x663cdba0, 0x6bfe2110, 0x4bddbe08, 0x45cd0d04, 0xe4374782, 0x330af0c9, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x18000000, 0x4c000000, 0x1a000000, 0x93000000, 0xe2800000, 0xd5c00000, 0xa5200000, 0x0bd00000, 0x9d980000, 0xaf3c0000, 0x2a120000, 0xbeb90000, 0x15ec8000, 0x1a084000, 0x24c56000, 0x901fb000, 0xf2c12800, 0xe1a3ac00, 0xff107a00, 0x8d391f00, 0xddad8880, 0x0268fd40, 0xd4f60560, 0x0df76e70, 0x04751a08, 0xcf36af04, 0x2dd4a082, 0x44275149, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xb8000000, 0x0c000000, 0xae000000, 0x9b000000, 0xc8800000, 0xf5400000, 0x4be00000, 0xd5500000, 0x1f180000, 0x65240000, 0x62120000, 0x71fb0000, 0x3bf58000, 0x9cc94000, 0xbc7de000, 0x5057b000, 0x41f8f800, 0x93f60c00, 0x48cbd200, 0xce7fcd00, 0xdd561380, 0x1e78bf40, 0x00371d60, 0x6d690510, 0x984e3208, 0xe25c7d0c, 0x2fa4eb86, 0xd251b34d, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xe8000000, 0xbc000000, 0xbe000000, 0x7b000000, 0xd2800000, 0x58400000, 0xe9600000, 0xa3100000, 0x50480000, 0xdc0c0000, 0xc1520000, 0xc82b0000, 0x649c8000, 0xa6d84000, 0x5884a000, 0x677c7000, 0xe989b800, 0x53adcc00, 0xa5617a00, 0x85117900, 0xcf4b9980, 0x748f8e40, 0x08129420, 0x8acb83b0, 0x884dda08, 0xee31090c, 0x44382182, 0xe4554249, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xc8000000, 0x9c000000, 0x3a000000, 0x6f000000, 0x3e800000, 0x88400000, 0xbaa00000, 0x94300000, 0xc6c80000, 0x628c0000, 0xf3720000, 0x02e90000, 0xdefe8000, 0x5f194000, 0x3c562000, 0x7746f000, 0x057ca800, 0x7edb1c00, 0x14364a00, 0x6f962900, 0xec264680, 0xb92e92c0, 0xa0c0de20, 0x9fe12eb0, 0x5b126a08, 0x5a39d904, 0x97a46e8a, 0x48eccecd, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x68000000, 0x7c000000, 0xae000000, 0x4b000000, 0x0d800000, 0x62400000, 0x73200000, 0xe4700000, 0x68780000, 0xff740000, 0xed320000, 0x06db0000, 0xc1458000, 0x5268c000, 0xa7dea000, 0xdd0e7000, 0x43457800, 0xaf680c00, 0x955d8600, 0xd0cfd100, 0xdf277080, 0x02b9cfc0, 0xd8960ce0, 0x1da17350, 0x57b12608, 0x071aa10c, 0xfb278886, 0x78b903cb, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x98000000, 0x4c000000, 0x0e000000, 0x81000000, 0x6f800000, 0xb2c00000, 0x36200000, 0x65b00000, 0x8b780000, 0x2e1c0000, 0x06720000, 0xaad90000, 0x856e8000, 0xbd284000, 0xb4776000, 0x25e5b000, 0x042d7800, 0xefc9e400, 0x8ae54e00, 0x3aae5300, 0x0a88cc80, 0xd204c0c0, 0xff3d2ae0, 0x2940c2f0, 0x16e02e08, 0xe492e304, 0xdc4b348a, 0xee2564c9, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xf8000000, 0x34000000, 0x62000000, 0x21000000, 0x2c800000, 0x0ac00000, 0xbf200000, 0x2d500000, 0x77080000, 0x358c0000, 0xf2920000, 0x26a90000, 0xc31f8000, 0xfe3a4000, 0xf8b6e000, 0xafa55000, 0x834ec800, 0xb3b3e400, 0x64faa200, 0xff958300, 0x56f70880, 0x8645bf40, 0x5f3cab20, 0x8eeb54b0, 0xb1fe4208, 0x0bc9d304, 0x79ae408e, 0xda401b41, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x08000000, 0x6c000000, 0x5a000000, 0x09000000, 0x9a800000, 0xdac00000, 0x52600000, 0xa6500000, 0x11480000, 0x6e740000, 0x9f920000, 0x98a90000, 0x04678000, 0x6c7ac000, 0x03ed2000, 0xda6c3000, 0x0b2ea800, 0xad0c8400, 0x8dff9a00, 0x5f866300, 0x2368bd80, 0xd0864b40, 0xa2eab220, 0x15c78650, 0xdac8ba08, 0x3a375304, 0xc933958e, 0x63990f43, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x68000000, 0x94000000, 0x7a000000, 0x13000000, 0x3e800000, 0xaac00000, 0x99600000, 0x8cf00000, 0x2d780000, 0x91ec0000, 0xb7320000, 0xd5990000, 0xef5f8000, 0xa4e9c000, 0x6e64a000, 0xeaa7d000, 0xbac52800, 0x0bb56c00, 0x2a8dea00, 0x74c1a300, 0x38609980, 0x257091c0, 0x5b3b8ae0, 0x4d4e8c30, 0x72234a08, 0xb7d37304, 0xe728318e, 0x9a853dcf, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x98000000, 0x1c000000, 0x8e000000, 0x15000000, 0xe8800000, 0xa1400000, 0xeba00000, 0x36900000, 0xe7680000, 0x1de40000, 0x78d20000, 0x3b4b0000, 0x45b68000, 0xd6dbc000, 0x3f5d6000, 0x52fcf000, 0xe56ef800, 0x3085b400, 0xe3219200, 0x87d29d00, 0x44caaa80, 0xdf769040, 0x95bb64a0, 0xa1ad6710, 0x4ee6f208, 0xb1516d0c, 0xd888d28a, 0xf857e447, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x58000000, 0x8c000000, 0x9e000000, 0x3d000000, 0x27800000, 0x0e400000, 0xc8600000, 0xe8700000, 0xc5980000, 0xffcc0000, 0x75b20000, 0x41bb0000, 0xb4dc8000, 0x26d8c000, 0x182e6000, 0xd780b000, 0xb643b800, 0xd4611400, 0x9e706e00, 0x2c9b2100, 0xca4de580, 0xd8f347c0, 0x9358db60, 0x756cc0b0, 0x25628e08, 0xc7f3510c, 0x8fd83d82, 0xcdaee3cb, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xe8000000, 0xe4000000, 0xaa000000, 0x15000000, 0x66800000, 0x09400000, 0xffa00000, 0x2ab00000, 0x99280000, 0x807c0000, 0x7f720000, 0xd2c90000, 0x37ef8000, 0x7faa4000, 0xc93ea000, 0x60d21000, 0xe87be800, 0x46c47400, 0x1bd44a00, 0x1c4e2d00, 0xa718ba80, 0xb91558c0, 0x302c75a0, 0x2d4b1570, 0x562d6a08, 0xd64a7d04, 0x7faff28e, 0x548a3cc1, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xf8000000, 0x7c000000, 0x82000000, 0x83000000, 0x81800000, 0x85c00000, 0x78e00000, 0xf6700000, 0x51680000, 0x20a40000, 0x98320000, 0x4b490000, 0xa1b68000, 0x93e94000, 0xc4e6e000, 0x15117000, 0xedd84800, 0x82af6c00, 0x1c26b600, 0x7d70ff00, 0xc4e99f80, 0x036617c0, 0x4dd3fea0, 0xc5b87710, 0x0b9ed608, 0x4deccf04, 0xd485378a, 0x00210bcd, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xd8000000, 0xf4000000, 0x4e000000, 0xf3000000, 0x67800000, 0x0a400000, 0xeea00000, 0xccf00000, 0x29980000, 0x486c0000, 0x4b320000, 0x08790000, 0x7abf8000, 0xc5984000, 0x526e6000, 0x86325000, 0xd4fa7800, 0x3b7f2c00, 0x9b7a0e00, 0xcd3f7100, 0xf7da2680, 0xd8ccd5c0, 0xdcc1a360, 0xfa639530, 0x5a93ee08, 0x29096104, 0x4c643e8e, 0x4bd4a9c9, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x58000000, 0xfc000000, 0xd2000000, 0x13000000, 0x54800000, 0x17c00000, 0x60a00000, 0xc6700000, 0x3a680000, 0x1c140000, 0x1b320000, 0x440b0000, 0x39458000, 0xda6b4000, 0x8c166000, 0x23307000, 0xe8090800, 0xb344ac00, 0x3569e200, 0x0a957700, 0x27f1be80, 0xdc2b43c0, 0x62f41aa0, 0x6fa010d0, 0xd0f20208, 0x06aa470c, 0x8434d686, 0x40809fc5, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x68000000, 0x84000000, 0xd6000000, 0xc5000000, 0x4c800000, 0xc6c00000, 0xb8a00000, 0x06900000, 0x9b280000, 0x0f7c0000, 0xf6d20000, 0xd24b0000, 0x7ecd8000, 0xbc29c000, 0x98fea000, 0xad919000, 0xaeab9800, 0x2f3f3400, 0x87b2e200, 0xdffae300, 0xfe366680, 0x099fb040, 0x9022c3a0, 0x26537d70, 0xee89c208, 0x316eb30c, 0x15395e86, 0x2496144f, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x58000000, 0x94000000, 0x2e000000, 0x95000000, 0x62800000, 0x00c00000, 0x81600000, 0xf1100000, 0x11480000, 0x108c0000, 0x41520000, 0x27eb0000, 0xcd7f8000, 0xc848c000, 0x080e6000, 0x1a93d000, 0xe1097800, 0x062cb400, 0xcca31a00, 0x46f2db00, 0x2e998180, 0xa5a43640, 0x9a4d7220, 0xe3309db0, 0x557afa08, 0x2075cb0c, 0x9464998e, 0xcfac524b, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x88000000, 0x74000000, 0xb2000000, 0xbd000000, 0x60800000, 0x0ec00000, 0xb8a00000, 0xdbd00000, 0x50280000, 0x78ec0000, 0xa8920000, 0x76cb0000, 0xbd5c8000, 0xdfcac000, 0xbfdd2000, 0xf40b5000, 0xabfd0800, 0x6f1a5400, 0x38779200, 0xa3a65300, 0x138c0680, 0x7b638540, 0x6bf11fa0, 0xe13a2b30, 0x9a643208, 0x4aacc30c, 0x28f0ae82, 0xb2b84143, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xb8000000, 0x0c000000, 0x32000000, 0xa3000000, 0xea800000, 0x4c400000, 0xdfe00000, 0xd4100000, 0xbfe80000, 0x7edc0000, 0x89d20000, 0x3ac90000, 0x036c8000, 0xbac84000, 0x436fe000, 0x9acab000, 0xd36f8800, 0x22caec00, 0xdf6cda00, 0x10c99900, 0x7c6e8380, 0xfa485240, 0x302e32a0, 0x25a986f0, 0xe43dba08, 0x9a426904, 0x9ae26b82, 0x13904e49, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x38000000, 0xa4000000, 0x26000000, 0x65000000, 0x59800000, 0x79c00000, 0x85e00000, 0xac900000, 0xfb580000, 0x4fbc0000, 0xcdd20000, 0xb8fb0000, 0xda0e8000, 0x367bc000, 0xe14fe000, 0x82da1000, 0x867e5800, 0xd031f400, 0xc0693600, 0x3f571f00, 0xb8c6d380, 0x531eac40, 0x26e28e60, 0x80129770, 0x331a5608, 0x5f9dcf0c, 0x5ea1eb8a, 0x08328847, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x08000000, 0x54000000, 0xca000000, 0x67000000, 0xae800000, 0x15400000, 0xe6200000, 0x40900000, 0x8bc80000, 0x37ac0000, 0x98520000, 0xb4290000, 0xc75f8000, 0x49a84000, 0x669d2000, 0x35c8d000, 0xaaac6800, 0x29d03c00, 0xc3e8aa00, 0xa23cdd00, 0x161b1480, 0xae45b040, 0x556f3620, 0x58b39430, 0xb6580a08, 0x9de54d04, 0xd03ddc8e, 0x1d191c49, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xb8000000, 0xf4000000, 0x4e000000, 0x1b000000, 0xef800000, 0x03400000, 0x05a00000, 0x55b00000, 0xf6c80000, 0xa6340000, 0xbe720000, 0x5da90000, 0x34658000, 0x72294000, 0x1727e000, 0xc7885000, 0x2a977800, 0x7d410c00, 0x36a22e00, 0x96325500, 0x9f88ea80, 0x4e9530c0, 0xeb426a20, 0x09a10850, 0x8fb24e08, 0x73ca4504, 0xeab5f286, 0xa6b12ccd, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x88000000, 0xf4000000, 0x8e000000, 0x37000000, 0xb1800000, 0x18c00000, 0xd3e00000, 0xbed00000, 0x1a380000, 0x0efc0000, 0xfe920000, 0x3f990000, 0x0e8e8000, 0x07584000, 0x0d6f2000, 0x918b5000, 0x73557800, 0x99767c00, 0x4ec45600, 0x996dfb00, 0x6f8b8380, 0xfc55e540, 0xc4f7e7e0, 0xa4073a70, 0x078ff608, 0xd9dbeb04, 0x782d5b8a, 0xb0a98949, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0x6c000000, 0xae000000, 0xdd000000, 0xa3800000, 0x3c400000, 0x39a00000, 0xc6900000, 0xb9680000, 0x81ac0000, 0xda520000, 0xaa090000, 0xd55d8000, 0x724a4000, 0x26fde000, 0xe3da3000, 0x0b17f800, 0xdab41400, 0x68247e00, 0x634c2900, 0xb9e0e280, 0x49330c40, 0xbef9f0a0, 0x1d47c630, 0xeebe1e08, 0x28795904, 0xf6857a86, 0x595e6841, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x28000000, 0xa4000000, 0xde000000, 0xf5000000, 0xdf800000, 0x41c00000, 0xaa600000, 0x6e700000, 0xc5d80000, 0x346c0000, 0x93320000, 0xf0fb0000, 0x783f8000, 0x12384000, 0xecdfa000, 0x640b1000, 0x2ba63800, 0x19f6f400, 0xddfeae00, 0x46585f00, 0x07ad2d80, 0xc652dfc0, 0xd20ab460, 0x5aa7ce30, 0x68748e08, 0xd13c0f0c, 0xbfb9358e, 0x521c7bc9, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x78000000, 0x2c000000, 0x1e000000, 0xa9000000, 0xd6800000, 0x25400000, 0xf5a00000, 0x9ad00000, 0xf1a80000, 0x270c0000, 0x56120000, 0x7acb0000, 0x41bd8000, 0xde894000, 0xf69ee000, 0x331b3000, 0x95943800, 0x8944c400, 0xededaa00, 0x1a618d00, 0x3c300280, 0x03da6940, 0x78f7e7a0, 0x6af738b0, 0xadf4ca08, 0x1a74fd0c, 0x6db55a86, 0xf757dd4d, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x78000000, 0xbc000000, 0x32000000, 0x21000000, 0xea800000, 0xaf400000, 0x60a00000, 0xabb00000, 0x2fe80000, 0xe4a40000, 0xb9720000, 0xe5890000, 0xd9768000, 0xc949c000, 0xd814e000, 0x731a7000, 0xa7ee0800, 0x1c65e400, 0x1e119a00, 0x78d81500, 0x9b0eb680, 0x4cf5ecc0, 0x578a96a0, 0xb8740210, 0x83c9fa08, 0x8756a504, 0x6bb8de8a, 0xb05eb8cf, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x98000000, 0xe4000000, 0x4a000000, 0x4b000000, 0xd3800000, 0x02c00000, 0x55a00000, 0x9b700000, 0x37980000, 0x89740000, 0x27320000, 0x2e7b0000, 0x03e48000, 0xc63b4000, 0xb8056000, 0x2ba91000, 0xbc8f6800, 0x5a15cc00, 0x13e09e00, 0x2190c300, 0x428a2a80, 0x5cbf2bc0, 0x01ee0960, 0x4fc78550, 0xd48b7e08, 0x29bd930c, 0x6b6ea282, 0x6187b7c5, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x98000000, 0xa4000000, 0x86000000, 0x63000000, 0xa6800000, 0xf7c00000, 0x77200000, 0xc9500000, 0x1d580000, 0x41940000, 0x6e720000, 0x8c0b0000, 0xd8cc8000, 0xf9e74000, 0x197b6000, 0x56451000, 0x50e9d800, 0xf4bdac00, 0x20ecea00, 0xec371700, 0x92e1a880, 0x73706340, 0x5d888860, 0xe78f39d0, 0x76053208, 0xbb8abb0c, 0x348d4282, 0x38877445, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x58000000, 0x9c000000, 0x32000000, 0x01000000, 0x4f800000, 0xa9c00000, 0x3a200000, 0x64b00000, 0xb5380000, 0x27a40000, 0x56920000, 0x258b0000, 0x449c8000, 0x2e35c000, 0x57986000, 0x1a55f000, 0x84c98800, 0x8ffda400, 0xe9e4ae00, 0xc172df00, 0xf51ac480, 0x561598c0, 0xaa2925e0, 0x5ceec510, 0xc8ad2608, 0xba4f7b0c, 0x7b5e6a82, 0xab1747cf, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x28000000, 0x94000000, 0x4a000000, 0x07000000, 0x32800000, 0xafc00000, 0x1d600000, 0x01700000, 0x45080000, 0xc7fc0000, 0x70120000, 0xe2790000, 0x63f68000, 0xc46cc000, 0xfe2ba000, 0xd8add000, 0x6bcb6800, 0xf91f7c00, 0x2522ba00, 0xf2520700, 0x9e5b6180, 0xae2443c0, 0x6074e920, 0x602c9970, 0x2309d208, 0xc6fd7b04, 0x1391db8a, 0x163a44cb, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x58000000, 0x5c000000, 0x8e000000, 0xd7000000, 0x16800000, 0x43400000, 0xc0600000, 0xe2900000, 0xb4680000, 0x6ba40000, 0x8cf20000, 0x11f90000, 0x414f8000, 0x9016c000, 0xd76a6000, 0xb727f000, 0x2ab37800, 0xae1bfc00, 0x791fca00, 0xeddc8500, 0x537c0580, 0x7a4d7c40, 0x1095fea0, 0xff29de10, 0xdfc4b208, 0x04637904, 0x9091cf8e, 0x3d68f943, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xd8000000, 0x84000000, 0xd2000000, 0x6d000000, 0x66800000, 0xa3400000, 0x66a00000, 0x1b300000, 0x21f80000, 0x26fc0000, 0x1f920000, 0xefcb0000, 0xb5868000, 0x602dc000, 0xa7fa6000, 0x71ff9000, 0xe8100800, 0x8c0a1400, 0x17666a00, 0x923e1500, 0x8af10680, 0xde1bd2c0, 0xca6d98e0, 0xe5d89870, 0x2c8e6208, 0x65c8010c, 0x9c856c8a, 0x74aec7cf, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x9c000000, 0x6a000000, 0xd5000000, 0x14800000, 0x60400000, 0xb2200000, 0x01900000, 0xad880000, 0xc3ac0000, 0x61b20000, 0xf5190000, 0x28a58000, 0xdb5f4000, 0x000a6000, 0xf56ef000, 0x92d36800, 0xac2a7400, 0x9ffec200, 0x30d91900, 0x68445480, 0xdfaef040, 0x4bb08d20, 0x401af330, 0x6c25aa08, 0xe31f6d04, 0x2e289686, 0x9efee945, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xe8000000, 0xc4000000, 0x1a000000, 0xfd000000, 0xfc800000, 0x65c00000, 0x7b200000, 0xa0900000, 0xd2380000, 0x4a640000, 0x3db20000, 0x89ab0000, 0x0fde8000, 0x3d95c000, 0x597aa000, 0xfd869000, 0xb8832800, 0xbfc09400, 0x2621c200, 0xac112f00, 0x5ff9d080, 0xf5459440, 0x872345e0, 0xa691a610, 0xb93aea08, 0x65e5bb0c, 0xabf2128a, 0x52cbbb4f, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xe8000000, 0x44000000, 0x8a000000, 0x2f000000, 0x0c800000, 0xccc00000, 0x8f200000, 0x9af00000, 0x24f80000, 0x343c0000, 0xaad20000, 0x2a890000, 0x50048000, 0xefcec000, 0x57a8a000, 0x39f49000, 0xc1b46800, 0x7e54dc00, 0x5d850200, 0xda8f4b00, 0xcfc84880, 0x706515c0, 0x1a5d4ae0, 0x9a423b70, 0xd4e36a08, 0xa5529704, 0x64c9ca82, 0x96e49ec3, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xc8000000, 0xf4000000, 0x56000000, 0x37000000, 0x8b800000, 0x90c00000, 0x2d200000, 0x16300000, 0xbea80000, 0x311c0000, 0x58120000, 0x451b0000, 0xc0748000, 0xcbadc000, 0x05fa2000, 0xd5e45000, 0xf1741800, 0x8f2d3c00, 0x02bb5e00, 0x3a048b00, 0x63675080, 0x6f349ac0, 0xc04ebfa0, 0xd9ea27f0, 0xcefd4608, 0xd202b70c, 0x69008e82, 0x6881d1cf, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x18000000, 0xec000000, 0xfa000000, 0x65000000, 0xe1800000, 0x7bc00000, 0xd5e00000, 0xd7300000, 0x71480000, 0xf36c0000, 0x03d20000, 0x39fb0000, 0x32e68000, 0x07dcc000, 0xf0596000, 0xbcf63000, 0xa4c5a800, 0x990e3400, 0x1423d600, 0x07d2f700, 0x57f90b80, 0x51e45ec0, 0xd15d9420, 0xfb19b930, 0xe5547e08, 0x42d7c30c, 0x6e145d8a, 0xdb7669cb, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xc8000000, 0xf4000000, 0x62000000, 0xdb000000, 0x0b800000, 0xc6c00000, 0x3c200000, 0xe1900000, 0x73580000, 0xf0ec0000, 0xc4b20000, 0x324b0000, 0xa6f48000, 0x8abcc000, 0x814a2000, 0x29745000, 0xc67dc800, 0x226b8c00, 0x69675e00, 0x5ce50300, 0x8726f480, 0x5185b440, 0x2a57e060, 0xf66eac30, 0x50f09608, 0x88298f0c, 0xce072a82, 0xde97774b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x48000000, 0xec000000, 0x62000000, 0xe9000000, 0xac800000, 0x23c00000, 0x16a00000, 0xe0300000, 0x5f080000, 0x130c0000, 0xb5920000, 0xd6bb0000, 0x41478000, 0x2aff4000, 0x71382000, 0xe7073000, 0x531d4800, 0xf46ac400, 0x069ca200, 0x132a7700, 0x6ffd1680, 0x9fb986c0, 0x9dc73920, 0xf13e15b0, 0x939bea08, 0xc137b30c, 0x6b14348e, 0xc0e7b1c5, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x48000000, 0x7c000000, 0x4e000000, 0x89000000, 0x82800000, 0xe5c00000, 0xaae00000, 0xc4900000, 0x91980000, 0x5bcc0000, 0x41720000, 0xd28b0000, 0x9b178000, 0x389d4000, 0x05082000, 0x42557000, 0x86bff800, 0x0df94400, 0x889e5a00, 0x5d099f00, 0x9654d780, 0x64be6c40, 0x82f95360, 0xff1eefb0, 0x744ba208, 0x5077db0c, 0x884f0d8e, 0x3231b34d, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xd8000000, 0xac000000, 0xbe000000, 0x41000000, 0x96800000, 0xe4c00000, 0x03e00000, 0x1c300000, 0xf1f80000, 0x71b40000, 0x9cd20000, 0x2c490000, 0xa70d8000, 0xbec6c000, 0x6c886000, 0x1eee3000, 0x49f5b800, 0x68f1a400, 0x3a1b0a00, 0x49869b00, 0x972a5380, 0xd6fffec0, 0xfe5dc6e0, 0x1fce6650, 0xfb24b208, 0xcdba3f04, 0x2f96d986, 0xe982a5c3, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xb8000000, 0x94000000, 0x6a000000, 0x1f000000, 0x65800000, 0x71400000, 0x08e00000, 0x63100000, 0xbbd80000, 0xffc40000, 0x86720000, 0x358b0000, 0x7afc8000, 0x13a74000, 0x34a3e000, 0x4571d000, 0x86086800, 0x72bfdc00, 0xcfc72600, 0x8e733d00, 0x698a7780, 0x6cfda640, 0x4aa71c60, 0xb023a990, 0x24b3ce08, 0x852ba10c, 0x0d8eb182, 0x6eaf4b45, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x78000000, 0xbc000000, 0xb6000000, 0xe3000000, 0x94800000, 0x0b400000, 0xb0e00000, 0xe3f00000, 0xf4180000, 0xdafc0000, 0x83920000, 0x56a90000, 0x6b068000, 0xdd1e4000, 0xc6e2e000, 0xe0f17000, 0xd0981800, 0xb9be2c00, 0xf7734200, 0xbf590500, 0xca1d1780, 0x706011c0, 0xdab14f60, 0x0df9f570, 0xe88dda08, 0x73496904, 0x1f74b58a, 0x06c464c1, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xe8000000, 0x6c000000, 0xba000000, 0x79000000, 0x54800000, 0x11400000, 0xaa200000, 0xb5b00000, 0x3a580000, 0x6da40000, 0x51120000, 0xb7a90000, 0x615c8000, 0xe4464000, 0x24c0a000, 0x1be03000, 0x00d22800, 0x72ca0400, 0xf1cf4200, 0xec2d1d00, 0xa7fea480, 0xa4b5e0c0, 0x52ba3e60, 0xf8f53b10, 0xc219ea08, 0x3b055904, 0xb9e34682, 0x8dd1cdc1, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xb8000000, 0xd4000000, 0x9a000000, 0x29000000, 0x0c800000, 0xda400000, 0xa6a00000, 0xf3100000, 0x65380000, 0x1bac0000, 0xd3320000, 0x4d6b0000, 0xe8b48000, 0x67cfc000, 0x82c3e000, 0x26e0d000, 0x5cb32800, 0xeaab8400, 0x1cd58200, 0xba3c5100, 0xf7495680, 0xe9e4da40, 0x98558fe0, 0xec7fbd30, 0x4fea2a08, 0x61f4150c, 0xb4ed3482, 0x6f135b47, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xf8000000, 0x6c000000, 0xae000000, 0x51000000, 0x53800000, 0x55c00000, 0xf7a00000, 0x9c300000, 0xf2280000, 0xf60c0000, 0xee120000, 0x46d90000, 0x2e048000, 0xf0efc000, 0x06c0e000, 0x3b203000, 0x9b73f800, 0x8bcb6400, 0x5c5f1e00, 0xb5a85f00, 0x21cd2280, 0xc6b0fac0, 0xa86b11a0, 0x226e31b0, 0xc8806608, 0x2d40fb04, 0x42e0dc82, 0xe2d195c7, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x08000000, 0x44000000, 0xc2000000, 0x25000000, 0x28800000, 0xa1400000, 0x91e00000, 0xddb00000, 0xf2c80000, 0xa7ac0000, 0xcad20000, 0x3d3b0000, 0xa3068000, 0x880d4000, 0xd7012000, 0xb5809000, 0xb5c2c800, 0x6ea3f400, 0xe7519200, 0xa4f89d00, 0x3ba5db80, 0x505d40c0, 0x3278ec20, 0x81e7dc30, 0x323dda08, 0x1d0a290c, 0xc00f698a, 0xf3024dcd, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x48000000, 0x44000000, 0x3e000000, 0x37000000, 0x4b800000, 0x73c00000, 0x82200000, 0x8ff00000, 0x7d780000, 0x3a640000, 0x01520000, 0x72c90000, 0x0aff8000, 0x54e74000, 0x84122000, 0x39ab9000, 0x546e3800, 0x2e0ebc00, 0xf01e1e00, 0x30b4a700, 0xe05bec80, 0xaa152dc0, 0x99e9e4e0, 0xe98fa610, 0xb9dda608, 0x5b945b04, 0x4328528e, 0xa72d5ac5, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xf8000000, 0x24000000, 0xa2000000, 0xd5000000, 0x2f800000, 0x35c00000, 0xfde00000, 0x85100000, 0x86580000, 0x2f340000, 0xf6720000, 0xb3090000, 0x084d8000, 0xb834c000, 0xfcf0e000, 0x31481000, 0x546dc800, 0x9ac47400, 0x0eb8ce00, 0x15a64f00, 0x6deb6b80, 0x0dddde40, 0x052e8060, 0xde644450, 0x830a8608, 0xb04ffb04, 0xfc36c586, 0xeef3414b, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xc8000000, 0x64000000, 0xe6000000, 0xe5000000, 0x32800000, 0x6e400000, 0x61e00000, 0x6c100000, 0xf7080000, 0x251c0000, 0xb6720000, 0x25d90000, 0xceb48000, 0xb11ec000, 0xf8702000, 0xb4d81000, 0xe237d800, 0x965e7400, 0x29117a00, 0xb58a3100, 0xa35dcb80, 0x83930e40, 0x67c91f20, 0xb8be22f0, 0x40802208, 0xc5438504, 0xc2601182, 0x2ed3ef43, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x18000000, 0x4c000000, 0x92000000, 0x23000000, 0xbd800000, 0x7b400000, 0xa6a00000, 0x66f00000, 0x00680000, 0x03140000, 0x4cd20000, 0xc3590000, 0xc31e8000, 0x64d44000, 0x57b36000, 0x29cab000, 0x7a668800, 0x9cf8ac00, 0x8f6ea600, 0x4c7e1500, 0xb0451e80, 0x6fca01c0, 0xc767eaa0, 0x307b93d0, 0xfaacae08, 0x341ff904, 0x4754588a, 0x3df3e4c9, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x18000000, 0xdc000000, 0xc6000000, 0x2b000000, 0x8c800000, 0x02400000, 0x09200000, 0x9ad00000, 0xffb80000, 0xacbc0000, 0x66720000, 0x62a90000, 0x95e78000, 0xb2fc4000, 0x09536000, 0xa379f000, 0x6eded800, 0xd8008c00, 0x7c002200, 0xb603e100, 0xa301d080, 0x48809540, 0x1842b5e0, 0xe4218770, 0x3d537a08, 0x717a2d04, 0xa7df128e, 0xf583c449, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xc8000000, 0x4c000000, 0x36000000, 0xc3000000, 0xea800000, 0x2bc00000, 0x2c600000, 0x74500000, 0xe2b80000, 0xf0440000, 0xf3f20000, 0x7a8b0000, 0x86af8000, 0x310d4000, 0xb13e2000, 0x43d7b000, 0xfb291800, 0xc59fec00, 0x29677a00, 0x22002700, 0x5101f580, 0x63805f40, 0x2c433be0, 0xaa216990, 0xe3704208, 0x64487b0c, 0x634f978e, 0x541f944d, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x78000000, 0x4c000000, 0xe6000000, 0x1f000000, 0xce800000, 0xd0c00000, 0x57200000, 0x36f00000, 0xcb980000, 0xd2640000, 0x29120000, 0x16490000, 0xd10d8000, 0xd3ecc000, 0xbdbee000, 0x6d97b000, 0x6b0bd800, 0x466fdc00, 0x51feaa00, 0x8f75cb00, 0xf558e880, 0x8e4775c0, 0xab601360, 0x3c110010, 0xb1cb9208, 0x784da704, 0x1e8d9a86, 0xdead62cb, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x18000000, 0xf4000000, 0xd2000000, 0xc9000000, 0x4b800000, 0xb8c00000, 0x06200000, 0xf7b00000, 0x50680000, 0x339c0000, 0x85520000, 0xd7fb0000, 0x07458000, 0x7825c000, 0xac756000, 0x040f5000, 0x09880800, 0x4e8e0400, 0x46cade00, 0x5e6edb00, 0xb0584480, 0x45358cc0, 0xcfed00a0, 0x1d992ff0, 0x5697b608, 0x9f9f8f0c, 0x03529286, 0x5cf953cf, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xb8000000, 0x14000000, 0x16000000, 0xd7000000, 0x09800000, 0x93c00000, 0x3fa00000, 0xb4700000, 0x32f80000, 0x449c0000, 0x4e120000, 0x0e2b0000, 0x1b968000, 0x63b7c000, 0x9707e000, 0xeddfd000, 0x85f21800, 0x7539fc00, 0xcd3dd600, 0x5d636700, 0x8d524a80, 0xd8cb23c0, 0x040466e0, 0xfa5c39f0, 0xcd302e08, 0x31194b0c, 0x938f848a, 0x9abab8c7, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xc8000000, 0x04000000, 0xda000000, 0x05000000, 0xb5800000, 0x88400000, 0xda200000, 0x1f700000, 0x19d80000, 0x49140000, 0x27120000, 0xd18b0000, 0x9e3d8000, 0x159ec000, 0xa8ae2000, 0xc6549000, 0x11b32800, 0xb5397400, 0xf684a600, 0x3f58b900, 0x6fd42480, 0x7ff247c0, 0x1c182c60, 0xb7740fd0, 0x0c41ae08, 0xc0215d0c, 0x7a71aa86, 0x9c588ac3, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x08000000, 0xb4000000, 0xf2000000, 0x8d000000, 0xf8800000, 0xba400000, 0xe4200000, 0x7f900000, 0x50080000, 0x7f640000, 0x5bf20000, 0xb2b90000, 0x3a7d8000, 0xb3ddc000, 0x828f2000, 0xa2e45000, 0x7d328800, 0x86d95400, 0x60cf5200, 0x2ac61100, 0xdca39c80, 0xe5d1b040, 0x242bf720, 0xf8f6b210, 0xb7fafa08, 0x8bdf1504, 0x1e8c4686, 0x74e7f54f, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xe8000000, 0x1c000000, 0x8e000000, 0xf1000000, 0x03800000, 0x09c00000, 0xac600000, 0x9af00000, 0xe9d80000, 0x706c0000, 0x5d520000, 0xa84b0000, 0x7dc48000, 0x18a4c000, 0x25d6a000, 0x2fcdf000, 0xc8c17800, 0x87e12400, 0xaf319e00, 0x7bbb0f00, 0xf39c9d80, 0xab09e9c0, 0x5fe57260, 0x7df61d30, 0x299e4608, 0xb80bdb0c, 0xeb667b82, 0x2ab4c2cb, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x18000000, 0x6c000000, 0x4e000000, 0x61000000, 0xa9800000, 0x36400000, 0xb0200000, 0x62100000, 0x94c80000, 0x187c0000, 0x16720000, 0x81f90000, 0xb2278000, 0x9704c000, 0x3e976000, 0x531d3000, 0x83c37800, 0x7061a400, 0x8f323600, 0xb95af100, 0xaff7ac80, 0x35ac2240, 0xecdb9020, 0xdfb7da70, 0xc08e2e08, 0xad4a6504, 0x263ce28e, 0x8252774b, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x58000000, 0xd4000000, 0xae000000, 0xd5000000, 0x94800000, 0xe6c00000, 0x31200000, 0x2cd00000, 0x67080000, 0xfbec0000, 0xee320000, 0x0e790000, 0x06f68000, 0xebf5c000, 0xbb766000, 0xfbb6d000, 0x6394f800, 0xf9c47400, 0xd70e2200, 0xf2415300, 0x97e35880, 0xbdf07d40, 0xbbd84920, 0xc4e53e30, 0xc1deba08, 0x4e4af704, 0xdd8f028a, 0x79809a4f, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xd8000000, 0xa4000000, 0xf2000000, 0x31000000, 0x70800000, 0x5ec00000, 0xa3200000, 0x13f00000, 0x4ce80000, 0x55140000, 0x77120000, 0x90b90000, 0x92cc8000, 0x66ccc000, 0x9ccc6000, 0x41cd1000, 0x0f4e8800, 0xee8ee400, 0x5a2d7200, 0xa49e0300, 0x54153080, 0x9f9231c0, 0x4a7836a0, 0x73efddd0, 0x9c3d9a08, 0x04a4f704, 0xb81a4a82, 0xea7e16cb, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xc8000000, 0x0c000000, 0xf2000000, 0x17000000, 0x17800000, 0xd2c00000, 0xd1e00000, 0x59300000, 0xc7c80000, 0x419c0000, 0xb7120000, 0xa3990000, 0x18268000, 0xbd674000, 0x0e442000, 0xbe95b000, 0xb46f0800, 0x043bbc00, 0x1bb58e00, 0xfdbe5300, 0x94418380, 0x25a23ec0, 0xcc906e20, 0x3358a0f0, 0xe6c4a608, 0x67d55f04, 0x2d4f858a, 0xc7e991c5, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x88000000, 0x0c000000, 0x22000000, 0x19000000, 0x50800000, 0x79c00000, 0x0f200000, 0x16900000, 0x2af80000, 0xa7e40000, 0x77720000, 0xc8c90000, 0x83ce8000, 0x000d4000, 0xd22d2000, 0x1a3db000, 0xa2064800, 0xcb408400, 0x8fe39200, 0x3932bf00, 0x1da98080, 0x063fe440, 0xe806d2e0, 0xae41ea10, 0xa562fa08, 0xddf28b04, 0x6c08da8a, 0x526d9f4d, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x18000000, 0x94000000, 0x0e000000, 0xf5000000, 0x35800000, 0x1ac00000, 0x5d200000, 0x96f00000, 0x42980000, 0xb26c0000, 0x0e120000, 0x1fc90000, 0xc8478000, 0xb286c000, 0x9fa76000, 0xf156d000, 0x17cc7800, 0xb3a3f400, 0xdcb0a600, 0xf8f92300, 0xdf7c6880, 0x055951c0, 0x16cd0b60, 0xf8216c30, 0xcb71be08, 0x34590704, 0x454d368e, 0x7be046c3, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x18000000, 0x5c000000, 0x86000000, 0x5b000000, 0x8c800000, 0x60c00000, 0x3a200000, 0x38900000, 0x1b980000, 0x98bc0000, 0xb3720000, 0x80a90000, 0xd8f68000, 0x1436c000, 0x50176000, 0xff84f000, 0xc69f5800, 0x21e04c00, 0xfe306200, 0xfbc8cb00, 0xd5064c80, 0x8d5eb440, 0x2f42db60, 0xca61cf70, 0x44725a08, 0x72297704, 0x2f35f68a, 0x0c95f343, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xc8000000, 0xdc000000, 0xf6000000, 0x31000000, 0x0b800000, 0xf5c00000, 0xede00000, 0xa1d00000, 0x40c80000, 0x7a3c0000, 0xea720000, 0xdd3b0000, 0x74c78000, 0x9a55c000, 0x093e2000, 0x2af1f000, 0x3c789800, 0xb267a400, 0xca25be00, 0xeb055f00, 0x90b55b80, 0x826cf540, 0xac785e20, 0x4a66b670, 0x3e248608, 0x3106cb0c, 0x9fb65d8e, 0x64effe4f, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xc8000000, 0x44000000, 0x7e000000, 0xe5000000, 0x85800000, 0x2bc00000, 0xdbe00000, 0x79b00000, 0x0ef80000, 0xad440000, 0x9a120000, 0xd6690000, 0x926e8000, 0x7adcc000, 0x07a42000, 0x80209000, 0x8a50b800, 0x2348f400, 0xa5bee600, 0x5e556700, 0xf3fb1380, 0xf4c61cc0, 0x53d356e0, 0xaa8b8390, 0x795cfe08, 0x0565c304, 0x44436d8a, 0xf3221fcb, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x58000000, 0x94000000, 0xa6000000, 0x5f000000, 0xcf800000, 0xfac00000, 0x92e00000, 0x93900000, 0x42280000, 0x99440000, 0x5a320000, 0x3a9b0000, 0xaf9f8000, 0xed0ec000, 0xd3a46000, 0x9da0d000, 0x3eb2d800, 0x59db5c00, 0x20bcce00, 0x87fc4300, 0x06deff80, 0x1f2c1440, 0x07d6e1a0, 0xde9bdb90, 0x719df608, 0xf60d0f0c, 0xd226898e, 0xf460db43, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x28000000, 0x9c000000, 0x66000000, 0x81000000, 0x7c800000, 0x28400000, 0xf7a00000, 0xac300000, 0xfbc80000, 0xd5240000, 0xe5520000, 0x871b0000, 0x34fc8000, 0xc54c4000, 0x3a45a000, 0x3883f000, 0x8a405800, 0x14a06400, 0x13b16200, 0xfc0be900, 0x0d463280, 0x0d02dec0, 0xf283b820, 0x15415910, 0x7d201a08, 0x2d703d0c, 0xece8a882, 0x3755a3c9, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x78000000, 0xbc000000, 0x12000000, 0xc5000000, 0x63800000, 0x89400000, 0x88600000, 0xb2500000, 0x48d80000, 0x46dc0000, 0x4ef20000, 0xe4a90000, 0xa6b78000, 0xde664000, 0xb67ee000, 0x78827000, 0x15c28800, 0x83a13400, 0x6ef2de00, 0x54a97d00, 0x2eb78d80, 0x0a661b40, 0x607e9c60, 0x138011f0, 0xa1413608, 0xac607904, 0x0c533b8e, 0xe7d92241, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x78000000, 0x54000000, 0x2e000000, 0x6f000000, 0xe7800000, 0xb3c00000, 0xd0600000, 0x17900000, 0x9d780000, 0xa78c0000, 0x74b20000, 0x52cb0000, 0xfcc58000, 0x34b54000, 0x819ce000, 0xa109d000, 0x8ca57800, 0x93249c00, 0xb4e56e00, 0x2a864700, 0x8214d580, 0x80ece440, 0xc0a1e8e0, 0x4a7146b0, 0x602b7608, 0xe6154b0c, 0xc6eda386, 0xe3a2af4d, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xb8000000, 0xbc000000, 0x4e000000, 0x2f000000, 0x99800000, 0xed400000, 0xce600000, 0x9dd00000, 0xb6580000, 0x16440000, 0x44720000, 0x27290000, 0xeded8000, 0x105fc000, 0x24d5e000, 0xc5487000, 0xb63c7800, 0xed041c00, 0x2910b600, 0xb57a1d00, 0x55f40d80, 0xa7f8b540, 0x8336a660, 0x4ddafb90, 0x1206ae08, 0x5890b104, 0x4c38a386, 0xa1950447, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xb8000000, 0xbc000000, 0xde000000, 0x27000000, 0x7d800000, 0xfa400000, 0x16600000, 0xf9100000, 0x10b80000, 0xf12c0000, 0x6bb20000, 0x2a0b0000, 0x45a58000, 0xabd44000, 0x04ffe000, 0x4caa7000, 0x3517b800, 0xe25fbc00, 0xfc1aa600, 0x1c9e0100, 0x8ab88d80, 0x142e5640, 0x1f3151e0, 0xa2c94a30, 0xd0057e08, 0xdce48d0c, 0x0237f386, 0x0eaddb49, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x28000000, 0xb4000000, 0x66000000, 0x7b000000, 0x66800000, 0xa2c00000, 0xc5e00000, 0x69b00000, 0x32f80000, 0xbb1c0000, 0x9f120000, 0x80e90000, 0x9e758000, 0x39254000, 0xdcefa000, 0xdbc85000, 0x10265800, 0xe76d8c00, 0x048baa00, 0xc185e300, 0xc1fd7380, 0x2e20a8c0, 0x47d0c6e0, 0xac0b62f0, 0xec45d208, 0x649c7f04, 0x4e52a186, 0xfe49d7cd, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x08000000, 0x74000000, 0x76000000, 0x1b000000, 0xc2800000, 0x7c400000, 0xb6600000, 0x66100000, 0x10480000, 0xdb540000, 0x27b20000, 0xbbf90000, 0xbaaf8000, 0x6c1c4000, 0x9c672000, 0xfd095000, 0xf6b51800, 0x72638c00, 0x2811ba00, 0x074a5900, 0x83d4fd80, 0x4af10640, 0xd61a0620, 0x0f7d17d0, 0x6ff60208, 0x2981c504, 0x66c2ff8e, 0x5620c349, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x18000000, 0x5c000000, 0x46000000, 0xf7000000, 0xb9800000, 0xb6400000, 0x74600000, 0x2a900000, 0x37880000, 0x82840000, 0x978a0000, 0x92850000, 0xdf8b8000, 0xe685c000, 0xdd8be000, 0x0b84b000, 0xd50af800, 0xf3476c00, 0xaea81e00, 0x1bf5b500, 0xc7d1cf80, 0x84691f40, 0xe55711a0, 0x03e01550, 0x3fd1cf88, 0xa8691f44, 0xdb5711a6, 0x98e01553, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x98000000, 0x3c000000, 0x22000000, 0xbf000000, 0xf7800000, 0xa0c00000, 0x27e00000, 0x02500000, 0xb1d80000, 0x6e240000, 0x19da0000, 0x7a270000, 0xefdb8000, 0x53274000, 0x2159e000, 0xa567b000, 0xccf96800, 0x68954c00, 0x0fd2b600, 0x321bcf00, 0xec442980, 0x8c4ac640, 0xbf9c6ee0, 0x3d6ebed0, 0x41c42988, 0x7f8ac64c, 0xb5fc6ee6, 0x0cfebed1, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x28000000, 0x7c000000, 0xf6000000, 0xf3000000, 0xa7800000, 0x8f400000, 0x0e200000, 0x0d100000, 0x96c80000, 0x799c0000, 0xcaca0000, 0xff9f0000, 0xb1c88000, 0x941dc000, 0xe0882000, 0x153c3000, 0xbc1bf800, 0xffb7fc00, 0x6c256600, 0xb72fc100, 0x0b525e80, 0x726b7540, 0xc34fc5a0, 0x14e1b330, 0xad725e88, 0xc37b754c, 0x0387c5aa, 0x2e7db33b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xe8000000, 0x4c000000, 0x32000000, 0xbf000000, 0x2c800000, 0x80c00000, 0x06e00000, 0xbc500000, 0x8d580000, 0xc9c40000, 0x475a0000, 0x62c70000, 0x1dd98000, 0x5306c000, 0x52ba2000, 0xb017f000, 0x4742e800, 0xfca10c00, 0x1b705a00, 0xe6680f00, 0x038fc180, 0xe5653e40, 0xe42b54e0, 0xb0ada950, 0xf857c188, 0x9f613e4c, 0x5b1154ee, 0x21faa957, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x0c000000, 0x46000000, 0x25000000, 0xa9800000, 0x01c00000, 0x57200000, 0x16700000, 0x8e480000, 0x165c0000, 0x274a0000, 0xb9dd0000, 0x638b8000, 0x777dc000, 0x0c3a6000, 0xa215f000, 0x4a177800, 0x2e176400, 0x4c14de00, 0x6b16e300, 0xd5954280, 0x12d75ac0, 0x8eb74ba0, 0x42a61bb0, 0x25ff4288, 0xfd7a5ac4, 0x0374cba6, 0x1387dbb3, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x48000000, 0x3c000000, 0x42000000, 0x4d000000, 0x50800000, 0x03400000, 0x1fe00000, 0x4a300000, 0xcdd80000, 0xb70c0000, 0x2ada0000, 0x468f0000, 0x531a8000, 0x3b2f4000, 0x5c4ba000, 0xce87b000, 0x2bfea800, 0x57208400, 0xc512ea00, 0xbcc90900, 0x55c55580, 0x601fc1c0, 0x7312f2e0, 0x4fc845f0, 0x2a475588, 0x6edcc1cc, 0x773272e2, 0x255805f1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xc8000000, 0xe4000000, 0x7a000000, 0xab000000, 0x73800000, 0x0ac00000, 0x98600000, 0x38700000, 0xafb80000, 0x4ab40000, 0x6aba0000, 0xe0370000, 0xbcf98000, 0x0b16c000, 0x752aa000, 0x933d5000, 0xd8974800, 0x2fe9fc00, 0x535f8600, 0xbce55700, 0xd651a780, 0x2cea56c0, 0x74dd2960, 0xe4264410, 0x7133a788, 0xd51956cc, 0x9ea6a96e, 0x3f738417, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xe8000000, 0xbc000000, 0xea000000, 0x17000000, 0x6a800000, 0xe2c00000, 0xb1e00000, 0x17100000, 0x8d880000, 0x96cc0000, 0x8b0a0000, 0xc60d0000, 0xd9e88000, 0x1d9ec000, 0xa3a32000, 0xfb303000, 0x5dfa8800, 0xf4956c00, 0xdeafa200, 0x1a5a2700, 0x11a74580, 0x3254cb40, 0x914e3ba0, 0xec495c70, 0xfbafc588, 0xd3da0b44, 0x9fe51baa, 0x84756c7f, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x78000000, 0xdc000000, 0xd2000000, 0xf9000000, 0xc8800000, 0x09400000, 0xeba00000, 0xec300000, 0x6b880000, 0x8d840000, 0xc90a0000, 0x41c50000, 0xe8288000, 0x55b4c000, 0x04816000, 0x3343b000, 0x66a02800, 0x22b15400, 0xedc98a00, 0x59a4b100, 0xcff9c480, 0xf92d71c0, 0xa3fda2a0, 0xf9e763d0, 0xa4d94488, 0x185db1c4, 0x5dd6c2aa, 0xcb51d3d7, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x18000000, 0x6c000000, 0x62000000, 0x59000000, 0xa7800000, 0x8c400000, 0x9a600000, 0xcb300000, 0x55580000, 0xc69c0000, 0x38da0000, 0x27dd0000, 0xab388000, 0x6badc000, 0x8280e000, 0x21c07000, 0x9b236800, 0xc8d01400, 0x312b7600, 0x9b26e500, 0x7cb77f80, 0x057f79c0, 0xbca822e0, 0xea6547b0, 0xc757ff88, 0x3d0eb9c4, 0x9b12c2ea, 0x9b0837b3, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xe8000000, 0xc4000000, 0x4a000000, 0xad000000, 0x0c800000, 0xb9c00000, 0xa5200000, 0x33500000, 0xb8580000, 0x8ff40000, 0x06da0000, 0x27350000, 0x197a8000, 0x96a6c000, 0xc3812000, 0xbc41d000, 0x8a620800, 0x9ab26400, 0x0eaaba00, 0x333f4300, 0x73558e80, 0x3ccb9e40, 0x358dc7e0, 0x3bfd5590, 0xdcf70e88, 0x45595e44, 0xdb76e7e2, 0xb319859f, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x08000000, 0xa4000000, 0x7a000000, 0xd1000000, 0x89800000, 0xe7400000, 0x41200000, 0xbd500000, 0x31080000, 0x90f40000, 0x3e8a0000, 0x00b50000, 0x11298000, 0xec25c000, 0xacc1a000, 0x9b635000, 0x4bf24800, 0xf0191400, 0xb05fee00, 0xd9ec4900, 0xd355ca80, 0xac1aac40, 0xc65da6a0, 0x06ee4b90, 0xc9d44a88, 0xbfdb6c44, 0x37be06ae, 0xb6dc1b93, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x88000000, 0x04000000, 0x16000000, 0xab000000, 0xdc800000, 0x1dc00000, 0xc6a00000, 0x12b00000, 0x04e80000, 0xb2bc0000, 0xe36a0000, 0x9bff0000, 0x4c088000, 0x01ec4000, 0x7d52a000, 0x79385000, 0x8c44f800, 0xb08ffc00, 0x88400a00, 0x22e34b00, 0x9251f080, 0xd3bbf1c0, 0x4a864b20, 0xf2acbf30, 0x0b337088, 0xf2a8b1cc, 0x8f5c6b2a, 0x43b8af3d, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x68000000, 0x84000000, 0x36000000, 0x4d000000, 0xb5800000, 0xeac00000, 0x89e00000, 0x85700000, 0x36f80000, 0x54d40000, 0xb67a0000, 0xa7950000, 0xc7588000, 0x40074000, 0xe4512000, 0xf9695000, 0x53dff800, 0xa9176400, 0x3518ae00, 0xa6a70f00, 0xfa02e980, 0x2f026ac0, 0x06811a60, 0x06406590, 0x88a06988, 0x2f502ac4, 0xb9e8ba6a, 0x409e7599, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x88000000, 0x9c000000, 0x62000000, 0xc9000000, 0x18800000, 0xc8c00000, 0xfa600000, 0x4a900000, 0xe7b80000, 0xd85c0000, 0xca3a0000, 0xba1f0000, 0x59998000, 0x9e6f4000, 0xd673a000, 0x0ee93000, 0xf4042800, 0x98b71400, 0x2d3eca00, 0x1728f700, 0xc2e6c380, 0x04e6cd40, 0x8be50560, 0xdc663030, 0xa3254388, 0x36068d4c, 0x61b7256e, 0x4dbc4031, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x88000000, 0xc4000000, 0x4e000000, 0x13000000, 0x9b800000, 0xc8400000, 0xb4200000, 0xcbf00000, 0xf9280000, 0xdd940000, 0xbdaa0000, 0x44550000, 0x3cc88000, 0xe3044000, 0xd5d2a000, 0x7fdb5000, 0x843d9800, 0xa7fc1c00, 0x439e7600, 0xd04dfd00, 0x38954680, 0xc92aa2c0, 0xe594aa20, 0x01aab090, 0x1657c688, 0x2dcbe2c4, 0xe1868a2a, 0xdb11a095, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x48000000, 0x6c000000, 0x76000000, 0x59000000, 0x28800000, 0x76400000, 0xab200000, 0xc3100000, 0xf7c80000, 0xaa640000, 0x384a0000, 0x81a50000, 0xdbab8000, 0x56d74000, 0x24d2a000, 0xd22af000, 0x9c157800, 0x5bb09400, 0x21195a00, 0x8b4c8d00, 0x1bdf9680, 0x69d59140, 0x5d52e1a0, 0x80eb64d0, 0xa7761688, 0x2283d144, 0x5141c1a6, 0xd6a3d4d9, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x88000000, 0x8c000000, 0x46000000, 0xef000000, 0xbd800000, 0x6bc00000, 0x3ea00000, 0xde900000, 0x40580000, 0x973c0000, 0xccda0000, 0x0a7f0000, 0xde3b8000, 0xf08e4000, 0x28d1a000, 0xe5387000, 0xcf0eb800, 0x0612cc00, 0x9f1ace00, 0xa0dda300, 0x22a85480, 0xc5d44940, 0x236ebde0, 0x9ca1d1b0, 0x6b91d488, 0xbcd9094c, 0x727e9de6, 0xea38e1b5, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xc8000000, 0x74000000, 0xe2000000, 0xb3000000, 0x86800000, 0xdec00000, 0x25a00000, 0x7e100000, 0xeac80000, 0x928c0000, 0xf94a0000, 0x33cf0000, 0x13a88000, 0xea3cc000, 0x7313a000, 0xd9491000, 0x03ce2800, 0x7baadc00, 0x6e3db200, 0x5910e700, 0x1e49c480, 0x674def40, 0x166937a0, 0xcd1f6170, 0xf9c34488, 0xd1222f4c, 0x8bd017aa, 0x05e9b17f, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x88000000, 0x8c000000, 0x62000000, 0x95000000, 0x43800000, 0xa5400000, 0xd3600000, 0xc6100000, 0x75a80000, 0x8cac0000, 0x5d2a0000, 0x656f0000, 0xd98a8000, 0xc8ddc000, 0x6310a000, 0x7e2bf000, 0x85ef2800, 0x5c48a400, 0xbe7da600, 0x63a07100, 0x83320b80, 0x78597940, 0x9ed76520, 0x8c8e17f0, 0xcb5a8b88, 0x4657b94c, 0x0d4f4522, 0x53fb27fb, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x28000000, 0x54000000, 0x6a000000, 0xf1000000, 0xed800000, 0x43c00000, 0x55600000, 0x92f00000, 0x44280000, 0x62f40000, 0x2eaa0000, 0x33b70000, 0x86898000, 0x0f64c000, 0xe9712000, 0x08e99000, 0xa1168800, 0x131b5400, 0xa4bdbe00, 0x342e1b00, 0xc8758b80, 0x9feaa0c0, 0x6b95e320, 0x92598710, 0x349e0b88, 0x84fd60cc, 0xb18f432e, 0x5767d71f, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xc8000000, 0x84000000, 0x8e000000, 0x99000000, 0x6e800000, 0x7ec00000, 0xfc200000, 0x96100000, 0xebc80000, 0x84a40000, 0x2e4a0000, 0xbfe50000, 0xa9298000, 0x4e964000, 0x6392a000, 0xc8885000, 0x4fc69800, 0xd5393400, 0x625da200, 0xd8b40f00, 0x72803280, 0xfcc06740, 0x8f2335a0, 0x3f93e9d0, 0xaa8bb288, 0xecc72744, 0xb4ba15ae, 0xa71cf9dd, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x08000000, 0xc4000000, 0xae000000, 0x01000000, 0x59800000, 0x52c00000, 0xc7a00000, 0xe8100000, 0x19480000, 0xad940000, 0x2b8a0000, 0x7a350000, 0x2b998000, 0xf77c4000, 0x200da000, 0x19f55000, 0xadba1800, 0x61acd400, 0xc4e73e00, 0xfb703f00, 0x03f97080, 0x134d8740, 0x5097c1a0, 0x00090f10, 0xabf4d088, 0x8eb8d744, 0xb32dd9ae, 0x30a5db15, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x28000000, 0xf4000000, 0xba000000, 0x27000000, 0xef800000, 0xf4400000, 0x89600000, 0x50b00000, 0xdc480000, 0x2bb40000, 0x180a0000, 0x3ad70000, 0xe4ba8000, 0xd09e4000, 0x8e0e2000, 0x4e179000, 0x321bc800, 0x1f0d8c00, 0x20963600, 0x60d87d00, 0x40af8380, 0xed84f7c0, 0x8a807ea0, 0x20c1ef10, 0xfca1a388, 0xe09367cc, 0xe51bb6a2, 0x488c6315, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x98000000, 0xa4000000, 0x72000000, 0x4d000000, 0x02800000, 0x1d400000, 0x0fa00000, 0x07300000, 0x7c080000, 0x15040000, 0xb54a0000, 0xe0a70000, 0xe37a8000, 0x982c4000, 0x4c3ce000, 0xc944d000, 0xc66a2800, 0x09d76400, 0x41526200, 0x96d9f100, 0x0e1d8c80, 0x14b745c0, 0xb60258a0, 0x0f0013d0, 0x27816c88, 0xf3c395cc, 0x5ce070a2, 0x939377dd, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x78000000, 0x24000000, 0x72000000, 0x07000000, 0x6d800000, 0x0a400000, 0x5fe00000, 0x01700000, 0xb4580000, 0xdd7c0000, 0x481a0000, 0x279d0000, 0x7bea8000, 0x40074000, 0xf9376000, 0x758dd000, 0x7403a800, 0x6a034c00, 0x93035e00, 0xf7830500, 0x51407180, 0x646168c0, 0x7e33cce0, 0x813af330, 0xbbcf1188, 0xa9e0b8c4, 0xa47264e2, 0x86d8bf39, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x88000000, 0xf4000000, 0x02000000, 0x3b000000, 0x71800000, 0x57400000, 0x07e00000, 0x0bd00000, 0x78f80000, 0x7bbc0000, 0xc4ba0000, 0xa5df0000, 0x1c298000, 0xc0c54000, 0x2b47a000, 0xfb049000, 0x9b64a800, 0x6ef7fc00, 0xd36f2e00, 0x71c08100, 0x9f22e180, 0x7671a640, 0xac4b6e60, 0x9d544eb0, 0x12df4188, 0x43aa364c, 0x3286466e, 0x0026f2b9, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x48000000, 0x74000000, 0x42000000, 0xcb000000, 0xce800000, 0xaf400000, 0x8d200000, 0x83700000, 0x3b080000, 0x82e40000, 0xc74a0000, 0x3d470000, 0x7d788000, 0x526e4000, 0x316da000, 0xbbed9000, 0xeeafa800, 0xc48c3c00, 0xf77dd200, 0x9e37a100, 0xd6723680, 0x388aa4c0, 0xd224f6a0, 0x8ca81550, 0x2cd59688, 0x1a6034cc, 0xa253deaa, 0x667a6955, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x48000000, 0x44000000, 0x8a000000, 0x73000000, 0x3d800000, 0xfa400000, 0x00200000, 0xb4d00000, 0x7ba80000, 0x86440000, 0x76ea0000, 0x11e50000, 0x3b7b8000, 0x0fed4000, 0xffaea000, 0xcc8e5000, 0x25dd8800, 0xb4361c00, 0x7a513e00, 0xfc6ad500, 0x1c272e80, 0xd218ae40, 0x969fcc20, 0x8296a150, 0x75438e88, 0xeba3fe44, 0xdb91c426, 0xeb09fd51, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xf8000000, 0xa4000000, 0xa6000000, 0x5b000000, 0x38800000, 0x30c00000, 0x8c200000, 0xa6900000, 0xd4f80000, 0x12940000, 0x633a0000, 0xe4350000, 0x686b8000, 0xcf6d4000, 0x2c2c6000, 0x604dd000, 0x563ff800, 0x42753c00, 0x838b5a00, 0x475c1f00, 0x2786fa80, 0x17839d40, 0x76438560, 0x33e25510, 0x5c309a88, 0x45ab4d44, 0x70cffd66, 0x1afe2911, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x18000000, 0xec000000, 0x1a000000, 0x7b000000, 0x2f800000, 0x19c00000, 0xd3200000, 0xaf900000, 0x9dc80000, 0x3f5c0000, 0x250a0000, 0xd8fd0000, 0x4cda8000, 0x47d64000, 0xfb36e000, 0xa687f000, 0xe05f8800, 0xa48a9c00, 0x6c3e7600, 0x017b9b00, 0xbd060a80, 0x6f9e0d40, 0xe6abf1a0, 0x5f2efe30, 0x5ef2ea88, 0xbeb8fd44, 0x5724f9a2, 0x588f223d, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xa8000000, 0xa4000000, 0x16000000, 0xa7000000, 0xbb800000, 0x93400000, 0x19e00000, 0x65f00000, 0x31e80000, 0x7e6c0000, 0xb3aa0000, 0xcb0d0000, 0x769a8000, 0x2446c000, 0xcae42000, 0xc0f65000, 0xe3ed7800, 0x4fe84c00, 0x1d6e5600, 0xce29a100, 0xa74c2180, 0xd8fbaec0, 0x60f4da20, 0x53ee2970, 0xc7ea0188, 0x496cfec4, 0x70292222, 0xa44da57f, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x08000000, 0x84000000, 0x72000000, 0x59000000, 0x4e800000, 0xe6400000, 0xa9200000, 0xad900000, 0x0e680000, 0xe39c0000, 0x4b2a0000, 0x193f0000, 0x9c788000, 0x51364000, 0x3dd4a000, 0xdba65000, 0x123e6800, 0x1bf9b400, 0x51f41200, 0xa6b50d00, 0xa5142680, 0x6cc43340, 0xca8fdb20, 0x4601d730, 0x13028688, 0x6b81634c, 0x06c3332a, 0xe8612335, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xc8000000, 0x14000000, 0x66000000, 0xf7000000, 0x00800000, 0x90400000, 0x39e00000, 0xe9d00000, 0x09780000, 0xfaec0000, 0x7c3a0000, 0xa28d0000, 0x8a288000, 0xced54000, 0x8ab7a000, 0xeea71000, 0xa3ff3800, 0x8ce24c00, 0xe0517a00, 0x12b82d00, 0x31ce4d80, 0x654ad240, 0x9847d460, 0x66accbf0, 0x1fdbed88, 0x7e5cc244, 0xcad26c6a, 0x8ffac7f1, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x68000000, 0x1c000000, 0x22000000, 0x57000000, 0x19800000, 0xf6c00000, 0x68600000, 0x05d00000, 0xa2980000, 0x3e140000, 0x31da0000, 0x92b50000, 0x83698000, 0x607c4000, 0xa3242000, 0x4cd23000, 0x3e1ba800, 0x5e57ec00, 0x92fa0e00, 0x5fc65700, 0x2540bf80, 0x95a25840, 0xb63031e0, 0x568a6210, 0x856d1f88, 0xe0dc2844, 0x4b97b9ee, 0x7d1bbe15, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x18000000, 0x6c000000, 0x0e000000, 0x01000000, 0x43800000, 0x2ac00000, 0x1ce00000, 0xd1500000, 0x8b580000, 0x2db40000, 0x7e1a0000, 0x4d950000, 0x3ea98000, 0x2a1cc000, 0xab85e000, 0x4ad37000, 0x6d9ad800, 0xaf57f400, 0xc64a9600, 0xf14c7f00, 0x5bdd7580, 0x47e51240, 0x75c3b4e0, 0x9660a690, 0x5c111588, 0xb77aa244, 0x9b048cee, 0x04902297, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x48000000, 0xcc000000, 0x8e000000, 0x99000000, 0x39800000, 0x4ec00000, 0x21200000, 0x89f00000, 0x80f80000, 0xc55c0000, 0xa1ba0000, 0x57bd0000, 0x82e88000, 0x1f744000, 0xc2eda000, 0xc7217000, 0xccf09800, 0xdf7a9400, 0x8e9ebe00, 0x7f1b4f00, 0xc58c6a80, 0x94b3c0c0, 0x84184560, 0xfb0f4fb0, 0x92f14a88, 0x4e7af0c4, 0xdb1f7d6a, 0xefd9abb5, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xb8000000, 0xec000000, 0x46000000, 0x79000000, 0xd4800000, 0xe6400000, 0x9ce00000, 0x84b00000, 0xb5980000, 0xf9040000, 0x765a0000, 0x23250000, 0xb24b8000, 0xf9eec000, 0x83e56000, 0x5beb7000, 0x6a3f7800, 0x090e1400, 0x01546a00, 0xf771ad00, 0xb7b8c980, 0x2115d7c0, 0x529283e0, 0x878875d0, 0x82cc2988, 0x8f7567c4, 0x99631be6, 0x5273d1df, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x58000000, 0x54000000, 0x5a000000, 0x39000000, 0x86800000, 0x62c00000, 0x45600000, 0x30f00000, 0xd0a80000, 0x2d240000, 0x45ea0000, 0x30070000, 0xe4b98000, 0xd23ec000, 0x9444e000, 0xe3199000, 0x37ac8800, 0x5c1df400, 0x1296d200, 0x5163df00, 0x4af27780, 0x79abe4c0, 0x83a55920, 0x2b28be50, 0x7b651788, 0xb74bb4cc, 0xbd14b12e, 0x5d221a57, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xf8000000, 0x4c000000, 0x92000000, 0x23000000, 0xe8800000, 0x57400000, 0xb2a00000, 0x35f00000, 0x93180000, 0x5fa40000, 0xa3da0000, 0xd0c70000, 0x78c88000, 0xe80ec000, 0xf0c76000, 0xc8c9f000, 0xb00c2800, 0xccc4fc00, 0xa2caca00, 0xdf0e8100, 0xb6475080, 0xd6886ec0, 0x852cf8e0, 0xd4f56e50, 0xf732b088, 0xef785ecc, 0xe43730ea, 0x7852a257, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xc8000000, 0x6c000000, 0xee000000, 0x9f000000, 0x61800000, 0xed400000, 0x02600000, 0x04900000, 0x8cf80000, 0xf57c0000, 0x2b3a0000, 0xf1df0000, 0xbd8b8000, 0xfb554000, 0x1b5ca000, 0x4b4af000, 0x31761800, 0x392e0c00, 0x9ae25e00, 0xdb51d900, 0x1c584780, 0xd9cf0340, 0x64b15060, 0xe388fcb0, 0x9c556788, 0x2edfb34c, 0x7c086866, 0xe61540b9, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x48000000, 0xec000000, 0x5e000000, 0x39000000, 0x2d800000, 0xbb400000, 0xc5600000, 0x51100000, 0x4c680000, 0x50bc0000, 0x17aa0000, 0x291f0000, 0xeb9b8000, 0x6f86c000, 0xf39ea000, 0xbc5b7000, 0xf826d800, 0x1ead1400, 0x4b402e00, 0x4d621900, 0xdd112b80, 0x626ad540, 0x21bce620, 0xd62a95b0, 0xcc5e0b88, 0x17f8654c, 0x13171e26, 0x04b631b7, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xf8000000, 0xe4000000, 0x26000000, 0xcb000000, 0x1e800000, 0xe7c00000, 0xb8a00000, 0xb2f00000, 0x28c80000, 0xb6640000, 0x1c8a0000, 0xac870000, 0x479b8000, 0x45dfc000, 0xe9646000, 0x7c0a5000, 0x3445f800, 0x0fbbfc00, 0xc7ecc200, 0xa58f4300, 0x725c5080, 0x6d2580c0, 0x5eeac7a0, 0xeb56cf50, 0xf0e1b088, 0x5a1310cc, 0x66dadfa6, 0x6ebfa353, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xe8000000, 0x34000000, 0x06000000, 0x6f000000, 0xaf800000, 0x13c00000, 0xe8e00000, 0x8a500000, 0x66480000, 0x6e240000, 0xef0a0000, 0xa7870000, 0xb8f98000, 0xc03dc000, 0x86662000, 0x622b1000, 0xa2373800, 0x7f622c00, 0x3590c600, 0xb4a90300, 0x09771580, 0xa7c26240, 0x2ee2e8a0, 0x0552f8d0, 0x79cab588, 0x95e7b24c, 0x33e870ae, 0x2bd504db, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x38000000, 0x5c000000, 0x5e000000, 0xed000000, 0x3c800000, 0xdb400000, 0x37200000, 0x07700000, 0x55180000, 0x3e540000, 0x223a0000, 0x99270000, 0x87238000, 0x0f714000, 0xc1196000, 0x94573000, 0xf53b9800, 0x4aa5c400, 0xd3e20a00, 0x32919900, 0x16894e80, 0x2a5c40c0, 0xae2610e0, 0x04a32090, 0x03b2d688, 0x30f984cc, 0x25c41ae6, 0xfa32b999, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x88000000, 0x5c000000, 0x7e000000, 0xb1000000, 0x73800000, 0x5ac00000, 0xb5600000, 0x02100000, 0x43c80000, 0x714c0000, 0x66aa0000, 0xeb5f0000, 0x21638000, 0x8011c000, 0x5ccba000, 0x8bcfb000, 0x9be9d800, 0x26fcb400, 0x5913b600, 0x034a6f00, 0x470cbb80, 0x7388d340, 0xa16f02a0, 0xad19f970, 0xcae56388, 0xc874674c, 0x1dfcb4a6, 0xa993967b, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xf8000000, 0xa4000000, 0xba000000, 0xe5000000, 0x13800000, 0xfc400000, 0x84a00000, 0x1b100000, 0x4ac80000, 0xf0a40000, 0x566a0000, 0x1fb50000, 0x4ea08000, 0xe613c000, 0xed496000, 0xfee45000, 0x6bcb0800, 0x09240400, 0xa72a2600, 0x6497a500, 0x4ff13c80, 0xd37acd40, 0x4a7cb1a0, 0xe8866ad0, 0xefba3488, 0x721ec944, 0x8bf697aa, 0x6601cfdb, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xf8000000, 0x94000000, 0x32000000, 0x87000000, 0x43800000, 0xe0400000, 0x04200000, 0xe8100000, 0xef780000, 0x7e3c0000, 0xa75a0000, 0x802d0000, 0xa5208000, 0x5e92c000, 0x6bb96000, 0x29dd9000, 0x53292800, 0x17654c00, 0xee754600, 0xef8d5d00, 0x71737e80, 0x4bca3140, 0x2c95c560, 0x6f7c34b0, 0x1dfa5688, 0x80ff7d44, 0xbbb8836a, 0x61dd69bf, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x88000000, 0xc4000000, 0x56000000, 0x59000000, 0xcd800000, 0xb6c00000, 0xb2e00000, 0xf3500000, 0x33180000, 0x6e5c0000, 0x3dfa0000, 0xc70d0000, 0x65e08000, 0x1bd0c000, 0xf258a000, 0xd17ed000, 0x36c97800, 0xe1077400, 0xa706ee00, 0xe6057f00, 0xb7865d80, 0x6b464640, 0x9aa53fe0, 0x6f766030, 0x282f2588, 0xd6d13244, 0xd1dbd1ea, 0xd2bf1f37, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xe8000000, 0x6c000000, 0x0a000000, 0x4d000000, 0x8d800000, 0xe4400000, 0x62a00000, 0x33100000, 0x67680000, 0x076c0000, 0xefca0000, 0xc97d0000, 0x1d228000, 0x7e524000, 0x1e4b2000, 0xaf3ef000, 0xae818800, 0xf2c18400, 0x54629e00, 0x2171e500, 0xd1181c80, 0xfef6ed40, 0x14fe3f20, 0x5162e5f0, 0x50f19488, 0xf75b6944, 0x6d56a122, 0x486e00fd, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x98000000, 0x54000000, 0x86000000, 0x4d000000, 0xd3800000, 0x89c00000, 0x00a00000, 0x42100000, 0xaae80000, 0x7acc0000, 0x044a0000, 0x89dd0000, 0x47238000, 0x6dd14000, 0x974be000, 0x635d1000, 0xeb627800, 0x21b16400, 0xca78d600, 0xd0675300, 0xf0e72c80, 0x83a57f40, 0xb7463120, 0xed371770, 0x9ced5488, 0x18181b44, 0xd454e726, 0x765d4471, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x08000000, 0x54000000, 0xc6000000, 0xed000000, 0x6b800000, 0xbdc00000, 0xbc200000, 0x7bf00000, 0x2f680000, 0x8b6c0000, 0xd94a0000, 0x679d0000, 0x52a08000, 0x09b14000, 0x508aa000, 0xedbd1000, 0x7c513800, 0x015be400, 0xfc243600, 0xf7d70300, 0x20bc7e80, 0x47d3c8c0, 0x149a9520, 0x04069670, 0x42254688, 0xb6d42cc4, 0x613ca32a, 0x9d109571, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x98000000, 0xf4000000, 0x92000000, 0xd7000000, 0x52800000, 0x1fc00000, 0x19a00000, 0x10300000, 0xf2580000, 0xf08c0000, 0x6cfa0000, 0x9a3f0000, 0x4d608000, 0x6512c000, 0xeca8e000, 0x7cf61000, 0x8e062800, 0xa47d8c00, 0xa3808200, 0x68436300, 0x53e00c80, 0xacd04fc0, 0x880857e0, 0x6d4546f0, 0x3b1c2488, 0x7192c3cc, 0x066855ea, 0xd8d4e5f7, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x78000000, 0x5c000000, 0x22000000, 0x6f000000, 0xeb800000, 0xbbc00000, 0xf0600000, 0x30700000, 0xd7a80000, 0xcc9c0000, 0xc0ca0000, 0x436d0000, 0x9aa08000, 0x86934000, 0xe89b6000, 0x53173000, 0x53876800, 0xea1fcc00, 0xbf8aa600, 0x434e9300, 0x71734f80, 0xe929fec0, 0x9fde0720, 0xaaebf7b0, 0x73be2788, 0x189b32c4, 0x5b14212a, 0x478624b9, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xc8000000, 0x14000000, 0x7e000000, 0x8d000000, 0xe6800000, 0xabc00000, 0xc6a00000, 0x61700000, 0xf1380000, 0xb1540000, 0xb69a0000, 0x34a50000, 0xfb618000, 0x8ed14000, 0x30c8a000, 0xaaac1000, 0x85ecd800, 0xaf8d6400, 0xeddee200, 0x65d45b00, 0x725b6080, 0x13869ac0, 0x34539660, 0xb10abc90, 0x7f0db888, 0x9f1efec4, 0xdbf4f46e, 0x25eba791, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x58000000, 0xfc000000, 0x16000000, 0x1b000000, 0x7e800000, 0x6dc00000, 0x25200000, 0x52300000, 0x19e80000, 0x3ad40000, 0xf9ca0000, 0xd9650000, 0x61628000, 0x6a51c000, 0xc439e000, 0x0caf3000, 0xa6073800, 0xa4309c00, 0x52e82200, 0x0c559b00, 0x000ace80, 0x4e476fc0, 0xc251db20, 0x00385790, 0xf6aff688, 0xc306f3c4, 0x65b17922, 0xaba90c93, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x48000000, 0xbc000000, 0xfe000000, 0xb3000000, 0x56800000, 0xca400000, 0x1e200000, 0x02300000, 0xe5d80000, 0x4ee40000, 0x8afa0000, 0x97570000, 0x60e28000, 0x4b534000, 0x7449a000, 0x99ceb000, 0x43a4d800, 0x40593c00, 0x32252200, 0x6e9b2500, 0xd3474280, 0x730a71c0, 0xa26da7e0, 0xfd57a750, 0x61e19a88, 0x28d04dcc, 0xbf8805e2, 0x112cc251, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x98000000, 0xfc000000, 0xba000000, 0x01000000, 0x66800000, 0xf4400000, 0x25e00000, 0xd5100000, 0xcc080000, 0xaabc0000, 0x276a0000, 0x2fef0000, 0xa8828000, 0x5b41c000, 0xbc62e000, 0xb0d13000, 0x58288800, 0x358ff400, 0x33517200, 0x4ce8d500, 0x7f2d8d80, 0x14204540, 0x5f32c7a0, 0x343a8eb0, 0xd3078588, 0x4fae714c, 0xb36155a2, 0x59536bbb, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xf8000000, 0xfc000000, 0x52000000, 0x4f000000, 0xee800000, 0x16c00000, 0xe1200000, 0xd9f00000, 0xd7280000, 0xd0740000, 0x148a0000, 0x05470000, 0x19818000, 0x24414000, 0xd5e06000, 0x1fd1b000, 0xe45aa800, 0xbf9ecc00, 0x38dcf200, 0x69bc6700, 0x33aebe80, 0x1a57fcc0, 0xddfbf820, 0xc1aef610, 0xe5559688, 0xbb7870cc, 0x436f6a2e, 0x52772119, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x78000000, 0xec000000, 0x12000000, 0x65000000, 0xe5800000, 0x3dc00000, 0x44a00000, 0xb2700000, 0xb4280000, 0x79a40000, 0x210a0000, 0x58150000, 0xce838000, 0xf740c000, 0x05e06000, 0x34927000, 0x8e39a800, 0x20de2400, 0x1435de00, 0x70b26300, 0xa40a0480, 0x8d967ec0, 0xeb41e220, 0x2fe07f50, 0xdd902c88, 0x09b89ac4, 0x001c5c26, 0x59146c57, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x68000000, 0xec000000, 0x8e000000, 0x7b000000, 0x2e800000, 0x81400000, 0xb5a00000, 0x95500000, 0x8a680000, 0x4ef40000, 0xab4a0000, 0x6be50000, 0x43018000, 0xda81c000, 0x6b422000, 0x9ca37000, 0x26d39800, 0xb2aa5c00, 0xda968200, 0x71f9e900, 0xefff6c80, 0x938dd040, 0x00f73f20, 0x704a4e90, 0x95657488, 0x9a424c44, 0xeb219d2e, 0x9c11d793, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0x54000000, 0x9a000000, 0x35000000, 0x28800000, 0xdbc00000, 0xcea00000, 0x66500000, 0x72980000, 0x28fc0000, 0x92ba0000, 0x266d0000, 0xf5008000, 0xc881c000, 0x4bc0e000, 0x66a19000, 0xaa500800, 0xbc998400, 0x87feca00, 0x8f39bb00, 0xd52e9880, 0xe0627640, 0x607330e0, 0x5f09dab0, 0x3cc61088, 0x10163244, 0x084f1aea, 0x5490f1b3, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x88000000, 0xe4000000, 0x82000000, 0x35000000, 0xcb800000, 0xbf400000, 0x34200000, 0x1f100000, 0x9c880000, 0x21fc0000, 0x962a0000, 0x2a2d0000, 0x51c28000, 0x58e2c000, 0x2872a000, 0xa9b85000, 0x79642800, 0xb3dd4400, 0x5e3a2600, 0x9827a900, 0x7cfebe80, 0x29a86140, 0x4f6e92a0, 0xcce023b0, 0x62721688, 0x58bae544, 0xc0e494a2, 0xb19d1abf, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xf8000000, 0x34000000, 0x0a000000, 0xcb000000, 0x83800000, 0x04400000, 0x0ee00000, 0x64700000, 0xd3a80000, 0xaeec0000, 0x75ca0000, 0xfd5f0000, 0x34c38000, 0x7d22c000, 0x04d26000, 0x02391000, 0x62b7c800, 0x38cdfc00, 0x229b2600, 0x1325bd00, 0xe4947580, 0xe79ea0c0, 0x00e0c520, 0xfd709270, 0xbf2a3d88, 0xab2e9ccc, 0x786a0326, 0x2a4eff77, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x98000000, 0x34000000, 0x1a000000, 0x93000000, 0x2e800000, 0xb7c00000, 0x56200000, 0x30d00000, 0x14780000, 0x6b140000, 0xe7da0000, 0x36870000, 0x68438000, 0x78604000, 0x1db3e000, 0xb24b9000, 0xb51e0800, 0xb8a49c00, 0xcc91d200, 0xc61a1300, 0xada72280, 0xd7113c40, 0x1a58b960, 0x0fc45710, 0x39a0aa88, 0x5692e04c, 0x95190b66, 0xe325941d, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x64000000, 0x7e000000, 0x9f000000, 0xf6800000, 0xf6c00000, 0x08e00000, 0x4e100000, 0xb7180000, 0xb7140000, 0x027a0000, 0xdf450000, 0x98428000, 0xd2214000, 0x7cf0a000, 0x0809d000, 0x618dd800, 0xd12dec00, 0x5d1d2200, 0x9ef62700, 0x45e83980, 0x581f0340, 0xc9758fe0, 0xfaa8ec10, 0x40bd6188, 0x7146af44, 0x6f428de2, 0x70a25b11, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x68000000, 0x5c000000, 0x7a000000, 0x3d000000, 0x02800000, 0xecc00000, 0xe7a00000, 0xd0300000, 0x0e980000, 0x7e440000, 0x2cba0000, 0x3d350000, 0x0bc28000, 0x6822c000, 0x76712000, 0xa9fab000, 0x5bd44800, 0x93138400, 0x3568e200, 0x88ffc700, 0x9c8e5480, 0x7c7653c0, 0x232154e0, 0xebf111d0, 0x6eba9c88, 0x843617c4, 0x674016e2, 0x6fe3a6df, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x98000000, 0xf4000000, 0x82000000, 0xbd000000, 0x2f800000, 0x4d400000, 0x23600000, 0x6bd00000, 0xb1980000, 0xf19c0000, 0xda7a0000, 0x918d0000, 0x58438000, 0xd0e34000, 0x3893e000, 0x51f99000, 0xe6cc6800, 0xc2232400, 0x1eb3b600, 0x154a4100, 0xda867380, 0x2524fa40, 0x53d69be0, 0xbe7ee130, 0xc06b9b88, 0xcab59e44, 0x2caf4de6, 0xb4737039, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x48000000, 0x84000000, 0x46000000, 0x4b000000, 0xed800000, 0xcfc00000, 0xb4a00000, 0x5cd00000, 0x9db80000, 0x967c0000, 0x9d9a0000, 0xeded0000, 0xb9c18000, 0xa7a04000, 0x9d52a000, 0xc07b5000, 0x67dc3800, 0xe3c93c00, 0x1417ae00, 0x1fdf9300, 0x3fcb2480, 0x7e15ec40, 0xc6de7460, 0x974952b0, 0x93549c88, 0x163d9044, 0xfbf8fa6e, 0x0b1cd1b5, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x58000000, 0x5c000000, 0x76000000, 0x57000000, 0xd8800000, 0x37400000, 0x55a00000, 0xc2900000, 0x7ff80000, 0xd7ec0000, 0x77da0000, 0x57bd0000, 0x5b438000, 0x5ba2c000, 0x5990e000, 0x797ab000, 0xb3acb800, 0xd0fa2c00, 0x836fba00, 0xfe9a0100, 0xa11cf480, 0x33513740, 0x6e1b1960, 0x225d6df0, 0x74f1cc88, 0x2188db44, 0xfc25c366, 0x47de1cff, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xc8000000, 0x74000000, 0x86000000, 0x11000000, 0xae800000, 0x58400000, 0xa5200000, 0x23300000, 0x01c80000, 0x08540000, 0x6caa0000, 0xf6450000, 0x12518000, 0xfddac000, 0x29aca000, 0xacb41000, 0xbd7a3800, 0xaf5f1400, 0x419ee200, 0x50fec500, 0xfcee5e80, 0x051565c0, 0x8908afa0, 0xf835e390, 0xa638c688, 0x23fe61c4, 0xbd6c75ae, 0xbed4329f, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x28000000, 0xac000000, 0xda000000, 0xd9000000, 0x07800000, 0x2e400000, 0xece00000, 0x3f700000, 0x39380000, 0xa5fc0000, 0x339a0000, 0x2a6f0000, 0xa7d38000, 0xf3abc000, 0xc4352000, 0xb11c7000, 0x78eac800, 0x2d575400, 0x9d2c3600, 0xecb2bd00, 0xb29b3d80, 0x09ecdcc0, 0xaf913b60, 0x04480030, 0xa1c4d588, 0xd7e7f8cc, 0x1cb7c566, 0x13dde933, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x08000000, 0xbc000000, 0xa2000000, 0xb9000000, 0x1d800000, 0xacc00000, 0x17e00000, 0xe7d00000, 0x2ff80000, 0xd08c0000, 0xb8da0000, 0xcabd0000, 0x95f18000, 0x9a494000, 0xe067a000, 0x5e4cb000, 0x5639a800, 0xd0ee9400, 0x06cb3e00, 0x55253700, 0x036f7980, 0x190a1440, 0xaa462c60, 0xeffd7f70, 0x80d17188, 0x89783044, 0x28ccba6e, 0x067adc71, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xb8000000, 0xe4000000, 0xa6000000, 0xd9000000, 0xe4800000, 0xc0c00000, 0xeaa00000, 0xae500000, 0xfe780000, 0x4af40000, 0x401a0000, 0xe0050000, 0x25308000, 0x5a094000, 0xcc1c6000, 0x6f35d000, 0xfc3b7800, 0xf9977400, 0x4069ca00, 0x60efc700, 0xc31dc880, 0x1ab7f240, 0x347acf60, 0x39f73490, 0x279ad088, 0x4f455644, 0x2cd07d6a, 0x07bb8791, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xb8000000, 0x8c000000, 0x9e000000, 0x31000000, 0x71800000, 0x33400000, 0xbe600000, 0xf2100000, 0x97580000, 0xa4240000, 0xae7a0000, 0xba550000, 0x04338000, 0xb9a8c000, 0xf4af6000, 0xaca5f000, 0x98bb9800, 0x45767400, 0x9741fe00, 0x24622900, 0x09126f80, 0xb5da8d40, 0xf1e4f8e0, 0xefd86ad0, 0x2ae69788, 0xdd590944, 0xb7269ee6, 0xa8f837d7, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x88000000, 0xac000000, 0xf2000000, 0x5f000000, 0x66800000, 0x08c00000, 0x17a00000, 0x80d00000, 0x34e80000, 0xcf640000, 0x2c8a0000, 0x7a950000, 0xfe728000, 0xa3b94000, 0x80cea000, 0xf10cf000, 0x792ee800, 0x2ebc4c00, 0xfab59200, 0x45e0bf00, 0xa5b09480, 0x7099b840, 0xffdee920, 0x08c480d0, 0x445adc88, 0xd27c0444, 0x5b171322, 0xf43133d1, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xf8000000, 0xc4000000, 0xa6000000, 0xf9000000, 0xd8800000, 0x7c400000, 0xf3a00000, 0x73500000, 0xa2f80000, 0x5d4c0000, 0x201a0000, 0x3b3d0000, 0x60f28000, 0x41aac000, 0xd7b76000, 0xb156d000, 0x81267800, 0xc0cf7400, 0xa6d9ba00, 0xcbdfb500, 0x31811c80, 0xccc09440, 0x63e04960, 0xeaf27670, 0xb2aa0488, 0xbc343044, 0x86950b62, 0xb544777f, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xa8000000, 0xd4000000, 0x92000000, 0xd3000000, 0x84800000, 0xe8400000, 0x73600000, 0x11700000, 0x71280000, 0x93f40000, 0x5d0a0000, 0x9f670000, 0x5a128000, 0xdc5b4000, 0x84de2000, 0x9ffd1000, 0x3dede800, 0x7db59c00, 0x8f699a00, 0xe9958d00, 0xfff8ef80, 0xa88f1cc0, 0xfdc67d20, 0x21c30c10, 0xd2a12788, 0x03d090cc, 0x52f88f22, 0xd10c5d11, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x08000000, 0xe4000000, 0x1a000000, 0x2d000000, 0xe9800000, 0xb0400000, 0x2e600000, 0x54100000, 0x33780000, 0x354c0000, 0x2c5a0000, 0x78bf0000, 0x5c718000, 0xec6ac000, 0xa4b7a000, 0xebd45000, 0xf8454800, 0xd47da400, 0x97d08e00, 0x405b1500, 0x46beef80, 0x8b738940, 0x58e81860, 0xf576ef70, 0x91f60788, 0x98357d4c, 0x9e145e6e, 0x78669e77, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xd8000000, 0x74000000, 0xea000000, 0xa3000000, 0x47800000, 0xa7400000, 0x3d200000, 0xf4900000, 0xf6980000, 0x8d1c0000, 0xa5fa0000, 0x602f0000, 0x67328000, 0x31c9c000, 0x5e67e000, 0x82151000, 0xc8fdc800, 0x5f0adc00, 0x2507f600, 0x23273100, 0x04349a80, 0x2fedd740, 0x54d09ae0, 0xee3bfc30, 0x41ccb288, 0xdfc11b4c, 0x5be224e2, 0x73f0d13b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xd8000000, 0x3c000000, 0x9a000000, 0xd9000000, 0x35800000, 0xd1c00000, 0xbda00000, 0x60700000, 0x0b280000, 0xa1f40000, 0x844a0000, 0x40a70000, 0xc3518000, 0x9218c000, 0x453ce000, 0x42ad3000, 0x1a940800, 0x0b191400, 0x50bdfe00, 0x836d0300, 0x8f377080, 0x8f69bec0, 0xfd946620, 0x619bfc10, 0xe7fd9888, 0x2b8e9acc, 0x52a6102e, 0x2e502b1f, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xf8000000, 0x44000000, 0xd6000000, 0xf5000000, 0xac800000, 0xeac00000, 0xb5a00000, 0xe3d00000, 0xd6880000, 0xfcb40000, 0x5aea0000, 0x1b450000, 0xb5f28000, 0xac184000, 0x9edf6000, 0xc56e5000, 0x8a17b800, 0xd0b94400, 0x038d2a00, 0xfa245f00, 0xca80d480, 0xd7c00c40, 0xd521d0a0, 0x3310e390, 0xfc2a0c88, 0xd4e61844, 0xe923c2a2, 0xe110b895, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x48000000, 0xf4000000, 0x56000000, 0x61000000, 0xe2800000, 0xe5400000, 0x76200000, 0x85f00000, 0xab080000, 0x57ac0000, 0x536a0000, 0xb5ff0000, 0xf5508000, 0xb5ba4000, 0xef87a000, 0x2db49000, 0x75dd7800, 0x21a1d400, 0x44321200, 0xb168f100, 0xe2fde280, 0x86d02ac0, 0xaa7b78a0, 0xc0e69f70, 0x7c653a88, 0x6c266ecc, 0x5e8692aa, 0x4736fa75, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x18000000, 0x84000000, 0x8e000000, 0x61000000, 0x44800000, 0x89400000, 0xc8a00000, 0xeff00000, 0x98980000, 0x29d40000, 0x69fa0000, 0xf1c50000, 0x23308000, 0xcdfbc000, 0x8fc6e000, 0xfa32d000, 0xbd7b5800, 0x90851400, 0xd793ea00, 0x980ac100, 0xe05ea080, 0x726762c0, 0x9743a4e0, 0x41a39a90, 0x97739888, 0xabdb66c4, 0x1675f6ea, 0x278a9f9b, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xe8000000, 0x5c000000, 0xaa000000, 0x2f000000, 0x70800000, 0x9e400000, 0xc9a00000, 0x51100000, 0x2c380000, 0xf7140000, 0x475a0000, 0xc3e70000, 0x48d28000, 0x7f59c000, 0x27e72000, 0xc6d1b000, 0xfe5a0800, 0x66654c00, 0xf113aa00, 0x5c3a6500, 0x3f171480, 0xab595540, 0x81e78a60, 0x3bd0aa10, 0xa5d8bc88, 0x96a4694c, 0x7ff10862, 0x310a331b, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x48000000, 0x4c000000, 0x72000000, 0x6b000000, 0x27800000, 0x70400000, 0xf3e00000, 0x2f100000, 0xc5680000, 0xa2240000, 0xf54a0000, 0x68950000, 0xa1d38000, 0x2a49c000, 0x7914a000, 0xe493f000, 0xd729e800, 0x22c51c00, 0xc9db9600, 0xabbc4d00, 0xa515e180, 0xce937540, 0xe828d620, 0x4346dad0, 0xa49b2988, 0x2adc5944, 0xc4c60826, 0xc4d87bd3, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xa8000000, 0x0c000000, 0x4e000000, 0xbb000000, 0x95800000, 0x81400000, 0xa4200000, 0x2e500000, 0xe2d80000, 0x41940000, 0x643a0000, 0x15a50000, 0xfb128000, 0xbcf84000, 0x1ec62000, 0xba637000, 0x1df29800, 0x98ca5c00, 0x79ee2e00, 0xb73c4900, 0xba27f680, 0x6b500440, 0x545b37e0, 0x81548910, 0xfb59ce88, 0xced56844, 0x5b1ba1e2, 0xfe74ec15, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x08000000, 0x9c000000, 0x4e000000, 0x29000000, 0xbe800000, 0x1ec00000, 0x9d200000, 0xc7100000, 0x0f680000, 0x3a2c0000, 0x200a0000, 0xf9dd0000, 0x92d08000, 0x73ca4000, 0x907ea000, 0x18033000, 0x74001800, 0xa2005400, 0xbf008200, 0x0380ff00, 0x7242fe80, 0xe4e25f40, 0xcdb2ed20, 0x68390ef0, 0xb6a4c688, 0x40177b44, 0x11aed72a, 0x5e4b95fd, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x18000000, 0x94000000, 0x1e000000, 0xa1000000, 0x40800000, 0x2a400000, 0x45600000, 0xe1500000, 0x85f80000, 0xf75c0000, 0x285a0000, 0xfa2f0000, 0x9a118000, 0x581ac000, 0x484fe000, 0x86c19000, 0x55231800, 0xe3335400, 0x6128ba00, 0x1e664d00, 0x85244780, 0x28c65440, 0x8fd70660, 0xb54e1a30, 0x04413f88, 0xdc62504c, 0xa5d1446e, 0xd9b99337, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x78000000, 0x5c000000, 0xa2000000, 0xa3000000, 0x80800000, 0xc5c00000, 0x3f200000, 0x76f00000, 0x54780000, 0xba3c0000, 0xb51a0000, 0xcaaf0000, 0xdf718000, 0x4638c000, 0x565e6000, 0xec08b000, 0x72846800, 0x5f867c00, 0x66064a00, 0x3c46fb00, 0x1426ce80, 0x4334e4c0, 0x821ef160, 0x7d6a6930, 0xba174688, 0x89ede8cc, 0xb893336e, 0x6e6a9e3f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xd8000000, 0xfc000000, 0x22000000, 0x93000000, 0x37800000, 0xd4c00000, 0xbfa00000, 0x55500000, 0xa7780000, 0x33cc0000, 0x449a0000, 0x907f0000, 0xfad18000, 0xafbac000, 0x3e6ce000, 0x2ac83000, 0x2484e800, 0xc3dc3c00, 0xe5809600, 0x5fc2ff00, 0x94239080, 0xd3902e40, 0x53dabf60, 0xad1e3c70, 0x15201888, 0x8f11e24c, 0xdc9ba16e, 0x4c7e0f77, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x78000000, 0x14000000, 0x7a000000, 0x8f000000, 0xc0800000, 0x41400000, 0x7f600000, 0x6a900000, 0x36480000, 0xe2540000, 0x5bea0000, 0xb0670000, 0x40118000, 0x400b4000, 0xa9b66000, 0x1a3a1000, 0x0e4f0800, 0x1c57ec00, 0x16ebaa00, 0x0be65900, 0xabd36f80, 0x892be740, 0x68c528a0, 0x7da2d910, 0x2a318788, 0x0ffa5b4c, 0x8a6e6aae, 0x66a63c11, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xc8000000, 0x44000000, 0x62000000, 0xe5000000, 0xd7800000, 0x8dc00000, 0xc9a00000, 0xd6700000, 0x42d80000, 0x2e940000, 0x163a0000, 0xee070000, 0xe1708000, 0x885a4000, 0x08d5a000, 0xec5a5000, 0xfad5a800, 0x615a0400, 0x39549600, 0x469a0300, 0x51f72880, 0x256b46c0, 0x7beee9e0, 0x15de9590, 0x3665a088, 0x70a252cc, 0x2ff0f7ea, 0xac198295, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x88000000, 0xe4000000, 0x8e000000, 0xf1000000, 0x0f800000, 0xfbc00000, 0xd3e00000, 0xb9500000, 0x04a80000, 0xdcb40000, 0x7c0a0000, 0xc3470000, 0xce508000, 0xde29c000, 0x06f4a000, 0x152b5000, 0x2e771800, 0x6c68d400, 0x5bd7c600, 0xee1a8b00, 0xa14d2180, 0x04159240, 0xd3f8c920, 0xf91c3190, 0x373c1988, 0x988cd64c, 0x3cf6372a, 0x322bfe9b, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x38000000, 0xc4000000, 0x4e000000, 0x65000000, 0x02800000, 0x7d400000, 0xba600000, 0xbf500000, 0x07080000, 0xbf7c0000, 0x71aa0000, 0xf48d0000, 0xaa538000, 0x1d8bc000, 0xd63d6000, 0x0dcbd000, 0xd2dcd800, 0x25d90400, 0xf4b6f200, 0x7a770100, 0x39d43380, 0xb8a45040, 0x821c31a0, 0xeb7992b0, 0x3b440b88, 0x8f8c4444, 0x05d2fba6, 0xfe4a87bb, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x88000000, 0x8c000000, 0x4a000000, 0x61000000, 0xcf800000, 0x03c00000, 0xa8a00000, 0x3e500000, 0x5c280000, 0x467c0000, 0x227a0000, 0x7a570000, 0xb4048000, 0xa02cc000, 0xca51a000, 0xd22a7000, 0x417c4800, 0xb6fa5400, 0x5f150600, 0x5ce61300, 0x7f1df080, 0x618bec40, 0x39ae9320, 0x7a910530, 0x0008f688, 0x8d6dff4c, 0x6eb363aa, 0xe71ae977, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xc8000000, 0x8c000000, 0xc6000000, 0xb7000000, 0x50800000, 0x0ec00000, 0xaa600000, 0x20300000, 0x75b80000, 0x38e40000, 0x598a0000, 0x4b5f0000, 0xf66e8000, 0x12544000, 0x7bf2a000, 0xc258f000, 0x8f95f800, 0x7b108c00, 0x25a84a00, 0xa3cf4f00, 0xbf856f80, 0x503905c0, 0x7ba7b660, 0xacaa29d0, 0xb04d2588, 0x13c64acc, 0x919ad9e2, 0x94772c15, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x38000000, 0x3c000000, 0xfe000000, 0x89000000, 0x8c800000, 0x10c00000, 0x11600000, 0x90b00000, 0x6de80000, 0xd0ec0000, 0x395a0000, 0xdf050000, 0x8eb58000, 0x2bdcc000, 0xc9f06000, 0x66c9b000, 0x14ff5800, 0x57e3f400, 0x5370da00, 0xab0aef00, 0x631c6b80, 0x5490f7c0, 0xd07a7320, 0x3c157ff0, 0xcd8cb188, 0xcfea18c4, 0x17ee18ae, 0xe4d9883f, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xb8000000, 0xc4000000, 0x26000000, 0x4f000000, 0xd4800000, 0xc9400000, 0x81600000, 0x1ad00000, 0xf0d80000, 0xddcc0000, 0xb60a0000, 0x7f150000, 0x1ac48000, 0x669cc000, 0xe6136000, 0xbf7b5000, 0xe9bf3800, 0x35210c00, 0x2e333a00, 0x64cb1100, 0xa3b73380, 0xe835c040, 0xfdf5a1e0, 0x69d724f0, 0xe0640988, 0xdb6ed144, 0xa9fa926a, 0xf9fee4bf, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xa8000000, 0x64000000, 0xf6000000, 0x0b000000, 0xd4800000, 0x76c00000, 0x78200000, 0xbb300000, 0xe7680000, 0x55240000, 0x405a0000, 0xd84f0000, 0xb47c8000, 0x4d95c000, 0xff712000, 0xba88d000, 0x2eb73800, 0xc8c1dc00, 0x4720ba00, 0xa1b13f00, 0x66a98680, 0xc386e9c0, 0x14ab6420, 0x6e875bd0, 0xf3293c88, 0x30c7d6cc, 0xc7cae2aa, 0x6ad5b213, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xa8000000, 0x04000000, 0x96000000, 0xe7000000, 0xe1800000, 0x94c00000, 0x59e00000, 0x94100000, 0xb8980000, 0x132c0000, 0x3a8a0000, 0x0cb50000, 0x28258000, 0xb2ff4000, 0xd5722000, 0x0acad000, 0x49173800, 0x2b976c00, 0x98d46e00, 0xfaf70700, 0xc287e580, 0x44ce7940, 0x559820e0, 0x9faf0070, 0x62cb8b88, 0xed157e44, 0x4d95c56e, 0xc7d47931, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xa8000000, 0xe4000000, 0x5a000000, 0xff000000, 0x09800000, 0x13c00000, 0x3c200000, 0xd2300000, 0x6bd80000, 0x833c0000, 0x4eea0000, 0xd5650000, 0x0c168000, 0x2cad4000, 0xf0c12000, 0x43a05000, 0x30f10800, 0xc3788c00, 0xf84c7e00, 0xbd534b00, 0x0e8b4280, 0x31b45dc0, 0xd95d76e0, 0x75385bb0, 0x99ad3c88, 0xee4216c4, 0x9de0b462, 0xd5114679, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xf8000000, 0xc4000000, 0xbe000000, 0x45000000, 0xf1800000, 0x6ac00000, 0x04a00000, 0xfcf00000, 0xdc880000, 0x8e5c0000, 0xcd7a0000, 0xdf550000, 0xb3e58000, 0x3d8c4000, 0xdcc36000, 0x0da2d000, 0xbf71d800, 0xa14aa400, 0xbc7dce00, 0x95cb5700, 0x673d3880, 0x1ba90ac0, 0x4f6f4da0, 0xc3d21330, 0xd9baf688, 0x3ef75dc4, 0x8e97f52e, 0xa3c759fd, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x18000000, 0xf4000000, 0xae000000, 0x4f000000, 0xf9800000, 0x16c00000, 0x60600000, 0x7c300000, 0x3f080000, 0x34d40000, 0xb83a0000, 0xfc5f0000, 0x052f8000, 0x7587c000, 0x7f80e000, 0x75c39000, 0xa3e19800, 0x3bf04c00, 0xf1eaee00, 0x53a40f00, 0x5f93e380, 0x9bd871c0, 0x07af40a0, 0x94c43910, 0x96230d88, 0x38137ecc, 0x1a1b2326, 0x0a4f88db, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x28000000, 0xe4000000, 0x02000000, 0x79000000, 0x4d800000, 0x38400000, 0x3ea00000, 0x1dd00000, 0xccd80000, 0x9a1c0000, 0x5c0a0000, 0xa1470000, 0x1b568000, 0x306cc000, 0x28812000, 0x0bc1d000, 0x91e1e800, 0x81f31400, 0xf7ca0e00, 0x80a69d00, 0x92a62080, 0x53a54440, 0x82279ee0, 0x046644b0, 0x8dc62e88, 0x4294d94c, 0x808f3e62, 0x28f3c0f7, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xd8000000, 0xc4000000, 0xa6000000, 0xd5000000, 0x1e800000, 0x46c00000, 0xc7e00000, 0xc8500000, 0x4ee80000, 0x85a40000, 0xfdba0000, 0x6ccf0000, 0x7a5d8000, 0x1757c000, 0xaca1e000, 0xa2f15000, 0x4918b800, 0xea3de400, 0x25449200, 0xf06ac700, 0x53662980, 0xb25a5440, 0x089de520, 0x8eb6c350, 0x25f0bb88, 0x3c9b934c, 0x437c4cae, 0xace4571b, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0xc4000000, 0x06000000, 0x33000000, 0x46800000, 0x08400000, 0x25a00000, 0x87700000, 0x12580000, 0xeb6c0000, 0x842a0000, 0x7ab50000, 0xea868000, 0x89fd4000, 0xb0a2a000, 0x22f0d000, 0x349bf800, 0x928cbc00, 0x68f93200, 0x189ee500, 0x5333d880, 0xddf8aac0, 0x2d1c44e0, 0x3df257f0, 0x6018ea88, 0xc7cf4fc4, 0x6cdb1c62, 0x9f2ebd39, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x38000000, 0xdc000000, 0xc6000000, 0x51000000, 0x5f800000, 0x8a400000, 0x77200000, 0xea900000, 0xd2580000, 0x11140000, 0x03ca0000, 0x53cd0000, 0xda1e8000, 0xbce5c000, 0x2b236000, 0x6c903000, 0xa359b800, 0xfe941400, 0xb18bf600, 0xf8ee0500, 0xf68c7e80, 0x3fbc7940, 0x65b6a2e0, 0xe51a2b90, 0x87b58888, 0xce1b7c44, 0xdf365c62, 0xc2da92db, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x58000000, 0xec000000, 0x72000000, 0xeb000000, 0x94800000, 0x31400000, 0x6aa00000, 0x58300000, 0x76b80000, 0x759c0000, 0x938a0000, 0xaaa50000, 0x3ed78000, 0xeb4fc000, 0x2e23e000, 0x4173f000, 0xc819e800, 0x83adbc00, 0x24334a00, 0x4cb81100, 0x7a9c1c80, 0xf10a9bc0, 0xb6e68760, 0xb5f5e930, 0x8fbd5688, 0x7cfb8ac4, 0xa3bf1be6, 0x2ef9b2f3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x38000000, 0x1c000000, 0x0a000000, 0xc9000000, 0xc4800000, 0x17c00000, 0x0b600000, 0xcc900000, 0xc4680000, 0xa6940000, 0x167a0000, 0xd43f0000, 0xcb0c8000, 0x0715c000, 0x373b6000, 0xbd9d3000, 0xf27c8800, 0xe92e7400, 0x86242a00, 0xdc206300, 0x36319380, 0x58998b40, 0x8fec0920, 0x95c44690, 0xad713988, 0x0038284c, 0xce1cfaaa, 0x563ffdd3, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x88000000, 0xe4000000, 0xae000000, 0x03000000, 0xce800000, 0xe4c00000, 0x52600000, 0x17100000, 0x70480000, 0xe1740000, 0x7bda0000, 0x24fd0000, 0x174c8000, 0xd376c000, 0xfadba000, 0x037dd000, 0xe00dd800, 0x20577c00, 0x71e9b200, 0x7c84f700, 0x3743a780, 0x13218940, 0x5b31a9a0, 0x87f9e710, 0xbb4e9588, 0x7977be44, 0x87dbae2a, 0x36fcbe57, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xf8000000, 0x7c000000, 0x5a000000, 0x73000000, 0xd0800000, 0x6ac00000, 0x5d200000, 0xff700000, 0x1dc80000, 0x117c0000, 0xf13a0000, 0x7ef70000, 0xa3a58000, 0xe39d4000, 0x92e96000, 0xc90d3000, 0x02734800, 0x40489c00, 0x0e3fba00, 0xd75abf00, 0x91e67280, 0x807ca8c0, 0x0ebbc2a0, 0x6eb5cbb0, 0x0f464888, 0x154c57cc, 0x3c91502e, 0xb1991371, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xe8000000, 0xac000000, 0x5a000000, 0xdd000000, 0x14800000, 0xa0400000, 0x38600000, 0x0ad00000, 0x5db80000, 0xbd1c0000, 0xd6ea0000, 0xe8670000, 0x91d58000, 0xa53dc000, 0x24592000, 0x5f0ef000, 0x41738800, 0x26c9a400, 0xb6d7aa00, 0x7cbced00, 0xa8980f80, 0xb32fbc40, 0x6dc36c60, 0x5aa3abb0, 0xc5f02588, 0x7e89914c, 0x1ab7c3ee, 0x586f27f3, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xc8000000, 0xe4000000, 0xea000000, 0xc9000000, 0x43800000, 0xc4c00000, 0xbea00000, 0xf2700000, 0x65780000, 0x8b2c0000, 0x858a0000, 0xb5150000, 0xd2c78000, 0x0b4dc000, 0x5859a000, 0x9d9dd000, 0x8e51c800, 0xb4485400, 0x1e379600, 0x3b74cf00, 0x2c175880, 0xa947e0c0, 0x838e9a60, 0x58f848f0, 0x84ed4e88, 0x85abefc4, 0x5227e2e6, 0x28dfb83b, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x18000000, 0x8c000000, 0x8a000000, 0x9d000000, 0xa5800000, 0x99c00000, 0x47a00000, 0x87900000, 0x6fb80000, 0x04840000, 0xdcaa0000, 0x9d7d0000, 0x7b4d8000, 0x9465c000, 0x8fd8e000, 0x4fb67000, 0xce010800, 0x7303e400, 0xc6816e00, 0x1742cb00, 0x74e3b480, 0xed72ab40, 0x19ca7960, 0xafcf01d0, 0xd2255a88, 0x34b8a044, 0x1604adee, 0x2dea1a9b, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x78000000, 0xcc000000, 0x86000000, 0x7f000000, 0x84800000, 0x7bc00000, 0x0ce00000, 0xc4900000, 0x53e80000, 0xf8bc0000, 0x80fa0000, 0xa2170000, 0xb8678000, 0x0a1e4000, 0xc4c96000, 0x20cef000, 0x0f833800, 0x15436c00, 0x3e235a00, 0x9bf27b00, 0xdc382580, 0x96762340, 0x49369920, 0x4e15d030, 0x4e66ff88, 0xbd1d184c, 0x24485ca6, 0x690f437d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xf8000000, 0x6c000000, 0x82000000, 0x39000000, 0x4c800000, 0x74400000, 0x91600000, 0x1d300000, 0x80380000, 0x49a40000, 0x5c8a0000, 0x6f5f0000, 0x130c8000, 0x1607c000, 0xa3986000, 0x7cb6f000, 0xe263a800, 0x3cb37400, 0xf6fbea00, 0xa7844d00, 0x5d587b80, 0xa696c3c0, 0xbdb22e60, 0xb67be2d0, 0x41c51188, 0xbd3a4ecc, 0x6326b5ea, 0xa7c8111b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xb8000000, 0x7c000000, 0x12000000, 0x33000000, 0x77800000, 0x68400000, 0xc7a00000, 0x0e500000, 0x59880000, 0xed7c0000, 0x295a0000, 0x4c370000, 0x1a458000, 0x11ddc000, 0x54886000, 0xf3fdb000, 0x219be800, 0xca541c00, 0x22f70600, 0xb9251500, 0xe3ee2480, 0xf2b33a40, 0x17f8efa0, 0x8ae5af30, 0x160ea288, 0x2c40ef4c, 0x69a12b2e, 0xcf51e573, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x58000000, 0xb4000000, 0xf6000000, 0xd9000000, 0x0f800000, 0xbf400000, 0x7e200000, 0x7d100000, 0x71e80000, 0x92fc0000, 0x287a0000, 0xe4d70000, 0xb9648000, 0xb95dc000, 0x112ae000, 0x5b9f9000, 0x574af800, 0xc22f1400, 0x9970d600, 0x975b5100, 0x42469a80, 0x11cc4340, 0xe4814420, 0xa7c08e30, 0x33e0cc88, 0x2df1d24c, 0xf89bbeaa, 0xada59d73, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x28000000, 0x5c000000, 0xea000000, 0x53000000, 0x76800000, 0xfe400000, 0x1f600000, 0x4a300000, 0x52380000, 0x507c0000, 0x7e4a0000, 0x59270000, 0x0a078000, 0x28574000, 0xb8dc2000, 0x31dbb000, 0xe70fc800, 0x0d915c00, 0x712ae200, 0xfb154d00, 0x643e7380, 0x02284fc0, 0xbd95aa60, 0x427c5fb0, 0xf948b188, 0x69a6b2cc, 0xf54411e6, 0x66b54c79, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xb8000000, 0xdc000000, 0xc2000000, 0x8d000000, 0xfa800000, 0x4c400000, 0x3a600000, 0xfdd00000, 0x4a080000, 0xf9940000, 0x879a0000, 0x7bfd0000, 0x96de8000, 0xe0eec000, 0x22f56000, 0x9ac93000, 0x7cb5a800, 0xa5a8e400, 0x3fe5b200, 0xcde31d00, 0x0b118f80, 0x1c2a7040, 0x4e279ea0, 0x8841cb90, 0x14615d88, 0x2ad05d44, 0x918bb922, 0x35575fd7, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xf8000000, 0xcc000000, 0xfa000000, 0xbf000000, 0x6d800000, 0x7bc00000, 0x04a00000, 0xd0900000, 0x19680000, 0x03c40000, 0x163a0000, 0x700d0000, 0xfc6d8000, 0xffde4000, 0x12e76000, 0x316af000, 0x77c7c800, 0xc03aec00, 0x650ece00, 0xd6edab00, 0x259dc080, 0x97856f40, 0x5a582220, 0xd3bcced0, 0xa1546e88, 0x74523444, 0x604a2aae, 0xb0974d95, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x58000000, 0x9c000000, 0xba000000, 0x6d000000, 0x8e800000, 0x24c00000, 0xa2200000, 0x2e100000, 0x7e980000, 0x70dc0000, 0x004a0000, 0x02670000, 0x6d868000, 0xa9354000, 0x3a7ce000, 0x3d9bb000, 0x0d5c4800, 0xd1086400, 0x95048200, 0xe2f65f00, 0xd7dcde80, 0x4bc9ad40, 0x5c25dfe0, 0x856412b0, 0x3604bc88, 0xaf74424c, 0x4e9d4962, 0x18a9dbf1, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x68000000, 0x44000000, 0x72000000, 0xab000000, 0xe7800000, 0x28c00000, 0x4c200000, 0x69100000, 0xecf80000, 0x903c0000, 0x9f2a0000, 0x7be70000, 0x51868000, 0xb8f6c000, 0xda7c2000, 0x294b5000, 0x2c942800, 0x7e0f5c00, 0xed402600, 0x97e0f700, 0xceb39a80, 0x6b2b9d40, 0x81e7a260, 0x6e873130, 0xb5779c88, 0x75bc3a4c, 0xb4ea10e2, 0xb444f07f, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xb8000000, 0x14000000, 0x66000000, 0x05000000, 0x66800000, 0x67c00000, 0x34600000, 0x3dd00000, 0x84780000, 0xaafc0000, 0x186a0000, 0xcfe70000, 0x71c68000, 0x30354000, 0xfebf6000, 0x75499000, 0x8594b800, 0x320c6400, 0x8a63f200, 0xdcd12300, 0x0cf85780, 0x743fde40, 0x808a6160, 0xe2f44030, 0xc45cc588, 0xa35b6d4c, 0x578c8ee2, 0x7e20fa71, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x18000000, 0x34000000, 0x82000000, 0x91000000, 0xc1800000, 0x0ec00000, 0x31600000, 0x42b00000, 0x81780000, 0x58440000, 0x3f0a0000, 0x215d0000, 0xb07f8000, 0xe3ecc000, 0x7106e000, 0xdba99000, 0xbe0d2800, 0xe2f6b400, 0x3a717e00, 0x83184700, 0xda751f80, 0x9933dbc0, 0x6aba0960, 0x4aa4cb50, 0x127a8188, 0x48c60cc4, 0x90483ee6, 0xeefca49f, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x48000000, 0xec000000, 0xf2000000, 0x7f000000, 0x2f800000, 0x11c00000, 0xc0a00000, 0x58f00000, 0x36c80000, 0x7da40000, 0x89fa0000, 0xfacf0000, 0x662e8000, 0x38be4000, 0xa5a4a000, 0xcdf97000, 0x14ce2800, 0x732eac00, 0xcc3fa600, 0x85e56300, 0x9198f880, 0xdc1e4ec0, 0x23558ca0, 0x563076d0, 0xe9ebfe88, 0x8c965dcc, 0x0b915c22, 0x899b941d, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x38000000, 0x14000000, 0x8a000000, 0xa7000000, 0x5a800000, 0xf7c00000, 0x94a00000, 0xfb100000, 0xb9780000, 0x68340000, 0xdeaa0000, 0x316d0000, 0xcf4f8000, 0xdb9cc000, 0x72466000, 0xa3611000, 0x4fb18800, 0xd2686c00, 0x194c3200, 0x9a9ddb00, 0x71c4dc80, 0xd3236d40, 0xe953de60, 0x04980b10, 0xb2448e88, 0x8362a644, 0xdfb10ae6, 0x1a6bca5f, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xb8000000, 0xa4000000, 0x6a000000, 0x15000000, 0x17800000, 0x41400000, 0x99e00000, 0x7db00000, 0x04280000, 0x231c0000, 0xc7da0000, 0x7c570000, 0x6fb48000, 0x1704c000, 0x6cad6000, 0x62f0d000, 0x4acb0800, 0x902f6400, 0x93324600, 0xe4eb8900, 0x80bfd580, 0x3b0a91c0, 0xfe0e9820, 0x23a05630, 0x3cd2f388, 0x225ac8cc, 0x3c14c5aa, 0x93d663f7, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x88000000, 0xbc000000, 0x9a000000, 0x13000000, 0xa5800000, 0x98400000, 0xeca00000, 0xf7d00000, 0x61980000, 0x8e140000, 0xcf0a0000, 0x69ad0000, 0x610e8000, 0x78de4000, 0x0c45a000, 0xfed03000, 0x97188800, 0x93d55c00, 0xebeb6e00, 0xfadd9500, 0x4b477080, 0x0d534c40, 0x5e592fe0, 0xfdf59290, 0x07fbbe88, 0x66a7e944, 0x68a25762, 0x69d0c2d5, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x48000000, 0x9c000000, 0xce000000, 0xe7000000, 0x7c800000, 0x12c00000, 0x2ea00000, 0x06b00000, 0x38f80000, 0xa8c40000, 0xed8a0000, 0x491f0000, 0x8bbe8000, 0xeb0dc000, 0xb8f4a000, 0xdab33000, 0x16f95800, 0x5fc48c00, 0xe90b5a00, 0x8fdcbf00, 0xf71d1c80, 0xc4bcc7c0, 0x1b8edc60, 0x1c348a50, 0xc710e688, 0x3ec848cc, 0x5cfe18e2, 0xf4ee0193, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x08000000, 0xcc000000, 0x46000000, 0x6f000000, 0x44800000, 0xdbc00000, 0x98a00000, 0x0e100000, 0x85e80000, 0x23bc0000, 0x813a0000, 0x11770000, 0xd9d78000, 0x0fc4c000, 0x5e2ca000, 0x8f927000, 0xe3aa7800, 0x535eec00, 0x3cc8da00, 0x5befdb00, 0x0c336480, 0x4b382140, 0x98761420, 0xe2545930, 0xe8851e88, 0xd94e8a4c, 0x932288a6, 0x41515477, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xb8000000, 0x44000000, 0x96000000, 0xf5000000, 0xcc800000, 0x28c00000, 0x31600000, 0xe9300000, 0xde380000, 0x6af40000, 0x634a0000, 0x256d0000, 0x5ded8000, 0x8b2d4000, 0x534e6000, 0x34ffd000, 0x19067800, 0x3f12e400, 0xc72a5a00, 0xd0df1f00, 0xf315cb80, 0x04b949c0, 0xf7363060, 0x7eab1790, 0x749c7188, 0x0ab4c6c4, 0x4cebe3ee, 0x783f6a59, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xe8000000, 0xbc000000, 0x96000000, 0x99000000, 0xf8800000, 0x9b400000, 0xd3600000, 0xc7300000, 0x42680000, 0xa4940000, 0xae9a0000, 0xe2dd0000, 0xd05f8000, 0xd41c4000, 0xeefd2000, 0x260f3000, 0x52443800, 0xc782f400, 0x82c32a00, 0x84a1c100, 0x75128380, 0xb13bffc0, 0xfc4d0720, 0xbda57010, 0x39f30988, 0x70c94ec4, 0xf8869ca6, 0xdf234bdd, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x48000000, 0x1c000000, 0x6e000000, 0x9f000000, 0x7f800000, 0x68400000, 0xa6e00000, 0x28300000, 0x78180000, 0x3a540000, 0xebea0000, 0x0aed0000, 0x4c6d8000, 0x98aec000, 0xa78da000, 0xae1d3000, 0x6f55d800, 0x716a6c00, 0x102e5600, 0x7c4f7500, 0xd6bf3180, 0x5a86ebc0, 0x64c1d0e0, 0xd7232910, 0x85914788, 0x974a6ec4, 0xd53e996e, 0x6cc69ed7, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xa8000000, 0xa4000000, 0x0e000000, 0x15000000, 0x02800000, 0xa9c00000, 0xcee00000, 0x05f00000, 0xb2180000, 0x5a640000, 0x80aa0000, 0x4d5f0000, 0xcedf8000, 0x739d4000, 0x7dbe2000, 0xa62e5000, 0xaf065800, 0x3418a400, 0x5b66c200, 0x54293b00, 0xed9c2d80, 0x00bd66c0, 0x60ace2e0, 0x18c6a4d0, 0x47fb4f88, 0xf8174dcc, 0x41f0b766, 0x6c193611, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x98000000, 0x1c000000, 0xaa000000, 0x07000000, 0x61800000, 0x59400000, 0x89200000, 0xb4d00000, 0x5b080000, 0x968c0000, 0xa11a0000, 0xd0e50000, 0x9ce68000, 0xeee44000, 0xd5e5e000, 0xce64b000, 0x08240800, 0xfc86cc00, 0xbb15fe00, 0x6e3d0100, 0x2de3c680, 0x8eb05440, 0x41f8cfa0, 0xc8d5aaf0, 0xaddd5888, 0x7251a544, 0xf3c8e122, 0xfeee82bd, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xc8000000, 0x84000000, 0x52000000, 0x9b000000, 0x13800000, 0xa3c00000, 0xf9200000, 0xc2d00000, 0x71b80000, 0x7ca40000, 0xc52a0000, 0x16fd0000, 0x2efc8000, 0x12fd4000, 0x3cfea000, 0x29fdd000, 0xbf7da800, 0x423c9c00, 0xc25ff600, 0xd2ef5b00, 0x28e67e80, 0xbdc81e40, 0x4e0f3760, 0x52170850, 0xa223a888, 0x3153d544, 0xe27841ea, 0xdd875a19, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x18000000, 0xfc000000, 0xf2000000, 0xf7000000, 0x4b800000, 0xa8400000, 0x4c200000, 0x11d00000, 0x47d80000, 0x77bc0000, 0x43ca0000, 0x9d050000, 0xcf068000, 0xa8044000, 0xdb87e000, 0x5fc73000, 0xf9e76800, 0xe3348c00, 0x1d6db600, 0x3591e500, 0x71f95a80, 0x556f8c40, 0x919164e0, 0x5ff9a230, 0x806d8c88, 0x35111944, 0x403ab662, 0x960c927d, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x88000000, 0x34000000, 0x62000000, 0xfd000000, 0x7a800000, 0x05400000, 0x22200000, 0x3e100000, 0x1c780000, 0x0d7c0000, 0x18aa0000, 0x30e70000, 0xbaa58000, 0x0707c000, 0xaad4a000, 0xffcc9000, 0xcd83e800, 0x26c34400, 0xe7e3d200, 0xe8725900, 0xa4c9ee80, 0x8157ab40, 0xce0d7a60, 0x99e34e30, 0xd3711c88, 0x9949a24c, 0x0f965cee, 0x4decf17b, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xb8000000, 0x04000000, 0xf2000000, 0x5f000000, 0x70800000, 0x02400000, 0x9aa00000, 0x49f00000, 0xc9e80000, 0x08bc0000, 0x9fda0000, 0x96350000, 0xc6f48000, 0xf9164000, 0xfec76000, 0xde9cd000, 0x6269e800, 0xc87d4c00, 0xf8393a00, 0x65e40d00, 0xfcaf6c80, 0xa6e008c0, 0xd2535220, 0x419808b0, 0x4a97b688, 0x6a0795c4, 0xf37c36aa, 0xcabadc75, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x18000000, 0x1c000000, 0xf2000000, 0x97000000, 0x74800000, 0x8c400000, 0x23200000, 0xdff00000, 0x1c080000, 0x1b9c0000, 0x3e3a0000, 0x5b770000, 0xd9b58000, 0xc5d64000, 0x9386e000, 0x713db000, 0xb20a6800, 0x5e9d8c00, 0xedb8ca00, 0x6bb7f500, 0x72d55a80, 0xd70738c0, 0x357c6ba0, 0x952b9230, 0x6f6cf088, 0x94b03dcc, 0x93aa392e, 0xb42dd6fd, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x48000000, 0xbc000000, 0xd6000000, 0x29000000, 0x0c800000, 0x8e400000, 0xd4200000, 0x8fb00000, 0xc2b80000, 0xbec40000, 0x0cca0000, 0x959d0000, 0xa25d8000, 0xf2bec000, 0xd66da000, 0xc7c7b000, 0x984b3800, 0x7fdc3400, 0x247cfa00, 0x760cd500, 0x5b57ce80, 0x04c079c0, 0xeb63cd60, 0x3310aa50, 0x91491488, 0xa35cdcc4, 0x723d1bee, 0x262c9797, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xd8000000, 0xac000000, 0x76000000, 0x25000000, 0x0f800000, 0x0cc00000, 0x3ee00000, 0x09500000, 0x7e580000, 0xb91c0000, 0xbb4a0000, 0x51e70000, 0x2fa58000, 0x7e04c000, 0xd375e000, 0xcf9df000, 0xd609f800, 0x0ac40400, 0x11947600, 0xf8cc6f00, 0x8952d980, 0xbe5a9440, 0x591d63e0, 0xcb48b3b0, 0x89e4cf88, 0x83a4cb4c, 0x0804226e, 0xf67413f7, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x28000000, 0x04000000, 0xee000000, 0xb5000000, 0x17800000, 0xa0400000, 0x55a00000, 0xfb100000, 0x13e80000, 0xfdec0000, 0x9d5a0000, 0x05170000, 0x8b5f8000, 0xf9a3c000, 0xd1122000, 0x28eb5000, 0xef6dd800, 0x02986400, 0xf4f4f600, 0xcbec6d00, 0xa4581c80, 0x28971340, 0xe81ec820, 0x22819570, 0x77c13288, 0x95e31a4c, 0x1eb222a6, 0xc0faeb3b, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x58000000, 0x04000000, 0xca000000, 0x07000000, 0x77800000, 0xbac00000, 0x26600000, 0x6b900000, 0xbad80000, 0x443c0000, 0xc72a0000, 0x6d770000, 0x2dcf8000, 0x0c60c000, 0xdc93e000, 0xf5585000, 0x8aff8800, 0x734b6c00, 0x05e5e600, 0x2a965f00, 0xf59d9b80, 0x4a5b7b40, 0x497fc9e0, 0x3b882f30, 0x5087f588, 0xa486484c, 0xf687b466, 0x95850b77, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x08000000, 0xfc000000, 0x26000000, 0x97000000, 0xea800000, 0x53400000, 0xc6600000, 0x99500000, 0x1c080000, 0x499c0000, 0xbb3a0000, 0xf8c70000, 0x94ac8000, 0xcb60c000, 0xa2d1a000, 0xe2c8b000, 0x4e3d7800, 0x434b8c00, 0x61ffc200, 0xe96b0900, 0x584c2f80, 0x11702240, 0xa0bb14a0, 0xb60662b0, 0x3b0e9588, 0xbf10a74c, 0x15e8f92a, 0xf40d49f7, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0xf4000000, 0x2a000000, 0xfd000000, 0x2d800000, 0xf8400000, 0xa8600000, 0x7c900000, 0xaf380000, 0xcb9c0000, 0x57ca0000, 0x06370000, 0xc46e8000, 0x1ae04000, 0x1852e000, 0x7c9a1000, 0x382c8800, 0x50834400, 0x15c0ce00, 0x70203d00, 0x84f0a380, 0x8babc540, 0x90a42c60, 0xb656d5b0, 0xacfce588, 0xefd8bc4c, 0x26cc41e2, 0xaad12df5, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x08000000, 0x9c000000, 0x82000000, 0x47000000, 0x5e800000, 0x61400000, 0xb3a00000, 0x41f00000, 0xc9380000, 0x3e540000, 0x696a0000, 0x399f0000, 0xfc848000, 0xdde04000, 0x50d1a000, 0x9b89b000, 0x5bcf6800, 0xdc4d4c00, 0xe68c0200, 0x8ded1100, 0x107c6880, 0x425718c0, 0xdb68ff60, 0x869fa810, 0x66070288, 0xaaa345cc, 0xba7295ea, 0x41faa1d5, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0x3c000000, 0xba000000, 0x03000000, 0xa9800000, 0x29400000, 0xd1600000, 0xf7100000, 0x43080000, 0xbd440000, 0x977a0000, 0xde5d0000, 0xbeb78000, 0x6823c000, 0xae72e000, 0x4019b000, 0xd04c4800, 0x373c9c00, 0x65a7be00, 0x5928c100, 0x8435af80, 0x60e0ff40, 0xa251bca0, 0x486b94d0, 0x79565988, 0xe5f0a244, 0x7659ad26, 0x42aeaa93, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x68000000, 0xb4000000, 0x0a000000, 0xaf000000, 0x69800000, 0xf8400000, 0x58200000, 0xac900000, 0x5e780000, 0xd5040000, 0x2cca0000, 0x1eed0000, 0xbf378000, 0x03e04000, 0x83f12000, 0x73481000, 0x67aec800, 0x2397cc00, 0xf5b05e00, 0x7669f500, 0xb1bcba80, 0x822c1540, 0x4dd78860, 0xdc90fed0, 0xc67a2c88, 0xb9062c44, 0x2ac96ce6, 0x67ec1e9d, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x98000000, 0x9c000000, 0xf2000000, 0x1d000000, 0x8f800000, 0x15c00000, 0x23200000, 0xda300000, 0xde180000, 0xcb3c0000, 0xfa0a0000, 0x60950000, 0x8aef8000, 0xfa834000, 0xce42e000, 0xa0e3b000, 0x9a11e800, 0xfca86400, 0x0e678600, 0x7a55eb00, 0x6b4dc680, 0x42f381c0, 0xaabb63e0, 0xf8cf68b0, 0xe531a888, 0xf49b0ec4, 0xbd7ea366, 0xb6ea4271, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xe8000000, 0xc4000000, 0xce000000, 0xbb000000, 0x13800000, 0xe6c00000, 0x06600000, 0x5fd00000, 0x65880000, 0x44bc0000, 0xc33a0000, 0xe3650000, 0x5fcd8000, 0x61034000, 0x2e812000, 0x7a40d000, 0xc520d800, 0x28725c00, 0x25b86600, 0xed264f00, 0x4cecbb80, 0xce71aa40, 0xfab894a0, 0xc0a7b430, 0xe92e0588, 0xf790b944, 0x49a9c92e, 0xd64f1171, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x28000000, 0xac000000, 0x32000000, 0x6b000000, 0xe2800000, 0xeec00000, 0x0e600000, 0x03900000, 0x8f680000, 0xe3b40000, 0x5d9a0000, 0x8bcd0000, 0xf2848000, 0x54024000, 0xf6032000, 0x55017000, 0xeb812800, 0x4f43bc00, 0xae21f200, 0xd132df00, 0xe99a1f80, 0x8dcc3f40, 0xdf87bf20, 0x3b80b910, 0x2740c588, 0xa2205c44, 0xb330d2aa, 0xaa981955, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xa8000000, 0xb4000000, 0xce000000, 0x63000000, 0x5b800000, 0xf6c00000, 0x96e00000, 0x6a100000, 0xfb080000, 0xd61c0000, 0x2afa0000, 0x3f850000, 0xcaaf8000, 0xf3424000, 0x8b222000, 0x23721000, 0x51d8d800, 0xc4f5fc00, 0xb7768600, 0xb5b66f00, 0x8d543980, 0xd444dd40, 0xdccf0ca0, 0x48131bb0, 0x3a086788, 0x0c9e4e44, 0x66b83326, 0xb526e9f5, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x58000000, 0x5c000000, 0x12000000, 0x11000000, 0x82800000, 0xbb400000, 0xf4a00000, 0x3a700000, 0xc4580000, 0x86c40000, 0xb98a0000, 0x536d0000, 0x4ed48000, 0x19c2c000, 0x7fe2e000, 0x36d23000, 0xd228e800, 0x089c5400, 0x724d3200, 0x7a65e100, 0xb7f81c80, 0x21364ec0, 0xe7120ee0, 0x79c9f050, 0x584fc688, 0xa766fbc4, 0xaf79a06a, 0xff759f97, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0xcc000000, 0x8a000000, 0xe1000000, 0x84800000, 0x50c00000, 0x91200000, 0xbb100000, 0xe4480000, 0x23240000, 0x957a0000, 0x81fd0000, 0x22568000, 0x20414000, 0x3fe0a000, 0x7531f000, 0xa4d94800, 0xfc2d9400, 0x543d0a00, 0x81f7ef00, 0x58905280, 0x3b0a7d40, 0x374776a0, 0xb30a7450, 0x9b461088, 0x89090644, 0xa246ae22, 0x898ba619, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xb8000000, 0x4c000000, 0x72000000, 0xcd000000, 0xfb800000, 0x7a400000, 0xbb600000, 0xccd00000, 0x19880000, 0xba6c0000, 0x3d3a0000, 0x7bb70000, 0x4a1e8000, 0x1a434000, 0xcb616000, 0xc4d3f000, 0x7d896800, 0x3c6ce400, 0xce391600, 0x3f341500, 0x06dcb780, 0x20e27440, 0xc69202a0, 0xaae8c770, 0x12bec988, 0xa2b1854c, 0x32db2322, 0x33a6e639, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x08000000, 0x1c000000, 0x62000000, 0x01000000, 0x9c800000, 0x1ec00000, 0x50600000, 0x7eb00000, 0x2de80000, 0x38040000, 0x7fba0000, 0xe59f0000, 0x52378000, 0x90904000, 0x8ffaa000, 0x023cb000, 0xcc66e800, 0xe7095400, 0xdf750a00, 0xd9b33700, 0x06695780, 0xa54623c0, 0x9e9b3520, 0x400ef750, 0xcf4d3588, 0xd76c00cc, 0xca7dc8a6, 0x6fc75395, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xd8000000, 0xbc000000, 0xbe000000, 0x6f000000, 0x0d800000, 0x35400000, 0x3a200000, 0xe6d00000, 0x72680000, 0x75ac0000, 0xab1a0000, 0xc0570000, 0xacfd8000, 0x2533c000, 0xb15be000, 0xd7f7b000, 0x2f6d5800, 0x05792c00, 0x4624be00, 0x0c84d100, 0x4b95c280, 0x601c6840, 0x9b81bc20, 0x1e40c170, 0x65a1a488, 0x6a92554c, 0x4ecb20ae, 0xa9bfc83b, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x18000000, 0x94000000, 0xe6000000, 0xbd000000, 0x0f800000, 0x99400000, 0xae200000, 0x4cd00000, 0x94f80000, 0xc2240000, 0x358a0000, 0x514d0000, 0xe6758000, 0xd0b14000, 0x0c8ae000, 0xe0cf9000, 0xb637b800, 0x0713c400, 0x7c1b7600, 0x4196c900, 0x47805280, 0xb5405840, 0xac20c660, 0x9fd3af50, 0xaa791c88, 0x26e41544, 0x59e902ee, 0x013eae19, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xc8000000, 0x44000000, 0xc6000000, 0x2f000000, 0x50800000, 0xe8c00000, 0x77e00000, 0x50d00000, 0xddb80000, 0x82140000, 0xb80a0000, 0xd6bd0000, 0x33c78000, 0x7e33c000, 0x7aeba000, 0xc3ec5000, 0x533ef800, 0xae858c00, 0x7c91ca00, 0x3c984700, 0x66264180, 0xd7e35240, 0x40d12260, 0x45b9a090, 0x3e16f388, 0xf2095944, 0x7bbf09e6, 0x8a47e5d3, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0xb8000000, 0x24000000, 0x16000000, 0x33000000, 0x66800000, 0x68c00000, 0x3be00000, 0x5d900000, 0x4de80000, 0xd9840000, 0xae1a0000, 0x4fbd0000, 0xd5568000, 0x1c52c000, 0xb98b6000, 0x6355d000, 0x1f517800, 0x470bbc00, 0x5f95d200, 0x8ab2f700, 0x0d9a5980, 0x62fd5f40, 0x08f7e320, 0xfee3d3d0, 0x18127388, 0xababd444, 0x66a588a2, 0x426b6b97, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x88000000, 0x74000000, 0x66000000, 0x4f000000, 0x4f800000, 0x6cc00000, 0x3ba00000, 0x19d00000, 0x77380000, 0x57540000, 0x7dca0000, 0x3eff0000, 0xc4c68000, 0x9d134000, 0x4899a000, 0x10871000, 0x29f3f800, 0xbc29cc00, 0x88cdf600, 0xfecd5700, 0xf9cfcc80, 0xe24cba40, 0x788ed960, 0x842d0890, 0xa67d4288, 0xdb84614c, 0xf873c3e2, 0xd3e8b5d9, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x38000000, 0x5c000000, 0xc6000000, 0x2b000000, 0x54800000, 0xa6400000, 0x32600000, 0x48b00000, 0x87880000, 0x14dc0000, 0x9eda0000, 0xcf270000, 0x02ad8000, 0x03704000, 0x5e286000, 0xf5cfb000, 0x7040b800, 0x01623c00, 0xf030ba00, 0x8fc86d00, 0x69bdd780, 0x18e999c0, 0x03ec56a0, 0x5b909430, 0x27da5588, 0x82a488cc, 0x996cdb2e, 0x22d290f5, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xc8000000, 0x6c000000, 0xfa000000, 0xf9000000, 0xd2800000, 0x42c00000, 0x9d600000, 0xff900000, 0x01d80000, 0x92840000, 0xf4aa0000, 0x0e8f0000, 0x0d568000, 0x72d04000, 0x7af8a000, 0xc1b47000, 0x24038800, 0x56027400, 0x23019200, 0x7b804700, 0x5841fb80, 0xb3a00f40, 0x98f091e0, 0x074825d0, 0x41df6188, 0x24ed7c4c, 0x6746d862, 0xfc485d95, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xd8000000, 0x94000000, 0xb6000000, 0x11000000, 0x3d800000, 0x95400000, 0xdaa00000, 0xd7900000, 0xcb380000, 0xac8c0000, 0xf68a0000, 0x42e70000, 0x9ddf8000, 0x47514000, 0xc0d9e000, 0xafbf9000, 0x7f23f800, 0x76d27400, 0xd799fe00, 0xa21c8900, 0x4c32b880, 0x5928ad40, 0x16f54b60, 0xfea482f0, 0x3efd3e88, 0x0b80104c, 0x44406de6, 0x872276b1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xb8000000, 0xa4000000, 0x26000000, 0xf5000000, 0x36800000, 0x8e400000, 0x44600000, 0x77d00000, 0xf8380000, 0x2a240000, 0xfe0a0000, 0x000f0000, 0x5cb58000, 0x23d0c000, 0xa63a6000, 0x9b24d000, 0x9e89b800, 0xc34ca400, 0x8a575200, 0xfc41b500, 0xef607f80, 0xf053ec40, 0x16fb7060, 0xad07c250, 0x5f391588, 0x27a53d4c, 0x3fc9bdee, 0xb6ae8b17, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x48000000, 0x04000000, 0xf6000000, 0x69000000, 0xa4800000, 0x6cc00000, 0xfba00000, 0xab900000, 0x0ad80000, 0xac940000, 0x762a0000, 0xd67f0000, 0xebf58000, 0x3e18c000, 0xab35a000, 0x87b85000, 0x37a43800, 0x34e11400, 0xed739a00, 0xb8a96f00, 0x39bd0880, 0xf7d57740, 0xfecac2e0, 0x410e3890, 0x285f0a88, 0x4c255c4c, 0xb5a0686e, 0x4e9334d7, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xe8000000, 0xd4000000, 0x66000000, 0x43000000, 0x34800000, 0x16400000, 0xebe00000, 0xdd700000, 0x1e180000, 0x7f7c0000, 0x0eca0000, 0x0ff50000, 0x7ede8000, 0xea584000, 0x199e2000, 0x503a9000, 0x852c7800, 0x57037c00, 0x32805a00, 0xa543ed00, 0xe7626180, 0xf731c6c0, 0x47f9d2e0, 0x870c6db0, 0x67506388, 0x524bc7c4, 0x8db79162, 0xd33d3a7d, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x28000000, 0x6c000000, 0x52000000, 0x43000000, 0x21800000, 0xdcc00000, 0x79a00000, 0x6f900000, 0x1c280000, 0xe9e40000, 0x0eda0000, 0x47fd0000, 0x3a848000, 0xb5ebc000, 0xbcc72000, 0x0509f000, 0xc0342800, 0x42109c00, 0x42e9be00, 0x6b451700, 0x34cb1c80, 0x9116a340, 0xd7c2d920, 0xe423f150, 0x5951aa88, 0x528ad844, 0xb1f453aa, 0xb330d913, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x88000000, 0x2c000000, 0xea000000, 0x73000000, 0x51800000, 0xeac00000, 0x09e00000, 0x28100000, 0x88680000, 0x236c0000, 0x5f5a0000, 0xf8f70000, 0x6b4f8000, 0x4b2a4000, 0x144ca000, 0x80a87000, 0xb58dc800, 0xacc8dc00, 0x395e1e00, 0x98406f00, 0xfaa05d80, 0x87324540, 0x939b9120, 0x7814c470, 0x89df2b88, 0x8402864c, 0xb6001aa6, 0xa102323d, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x48000000, 0x14000000, 0x52000000, 0x7b000000, 0x4a800000, 0x02400000, 0xbfa00000, 0xf6300000, 0xbb580000, 0xc6740000, 0x028a0000, 0x5fbd0000, 0xdb178000, 0x4e5bc000, 0xf1f5a000, 0x034b1000, 0xe3dda800, 0x92471c00, 0xaad3f200, 0x97490d00, 0xf1df2880, 0x894453c0, 0xd05386e0, 0xdd0a8d90, 0x5a7cd288, 0x2d7552c4, 0x1008f466, 0x51fdcf53, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xf8000000, 0x04000000, 0xca000000, 0xe5000000, 0x5f800000, 0xf1400000, 0x07a00000, 0xa6f00000, 0x82880000, 0xf68c0000, 0xb49a0000, 0xb6550000, 0xcaee8000, 0x0308c000, 0x40ce6000, 0x25b95000, 0x78660800, 0x6d86e400, 0x20568600, 0x51ef1900, 0xab8aa480, 0xff0ea8c0, 0xbed8f5a0, 0xc9763970, 0xdbdc4a88, 0xe6e205c4, 0xc950df22, 0x08786cbf, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x08000000, 0x64000000, 0x62000000, 0xb9000000, 0x10800000, 0xae400000, 0x82600000, 0xa4f00000, 0xf4580000, 0x318c0000, 0x458a0000, 0xb3c50000, 0x2aec8000, 0x41f8c000, 0x41dfa000, 0x0d02d000, 0xca836800, 0xdb41d400, 0x64e39a00, 0xd9b1f500, 0xbbb93f80, 0x49bde0c0, 0x24f385e0, 0xb4591e70, 0x918c6d88, 0xb58a11c4, 0xbbc6c86a, 0x4eec1fbf, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x98000000, 0x24000000, 0xde000000, 0x31000000, 0x17800000, 0xd3c00000, 0xe9200000, 0x2cd00000, 0xa5380000, 0xd1a40000, 0x4a0a0000, 0xdaef0000, 0x9b848000, 0x325a4000, 0x4897e000, 0x7c435000, 0x0ee15800, 0x23f0b400, 0x4ce8f600, 0x251e9300, 0x5d6dae80, 0xb045da40, 0x8f793b60, 0xf246cf50, 0x5479e088, 0x32c7ad4c, 0x5539bbea, 0x59a7721d, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x28000000, 0xf4000000, 0x7e000000, 0x6f000000, 0x55800000, 0xb7c00000, 0xfa600000, 0x04900000, 0xb2280000, 0x0a1c0000, 0x621a0000, 0x18470000, 0x3afd8000, 0x8ccbc000, 0x43cc2000, 0x28109000, 0xeb689800, 0x3c3d4c00, 0xdc2bbe00, 0xdd1d3b00, 0xbb995380, 0xbd87a340, 0x0d9f6220, 0x38da95b0, 0x02a45588, 0x552c444c, 0x95c297ae, 0xdf6181fb, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x08000000, 0xc4000000, 0xf2000000, 0x4f000000, 0xd7800000, 0xa7c00000, 0x9b200000, 0x48900000, 0x40480000, 0x041c0000, 0x713a0000, 0x23670000, 0xabbe8000, 0x2febc000, 0x7acfa000, 0x98935000, 0x184a2800, 0x581e8c00, 0xff3b4600, 0x52674b00, 0x053d9e80, 0xe2a8eb40, 0xdeaf6ea0, 0x3b6350b0, 0x2c715088, 0xcff97c4c, 0x82c71e22, 0x446ebcfb, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x08000000, 0x5c000000, 0x96000000, 0x0f000000, 0x3a800000, 0xa0400000, 0x27200000, 0x5f500000, 0x3fc80000, 0x16040000, 0x02fa0000, 0x423f0000, 0x99a78000, 0x90e94000, 0xd556a000, 0xcb32b000, 0x4b393800, 0xa9dcec00, 0x2e958200, 0xfdd1c500, 0x0b8bba80, 0x9b248e40, 0xd4a8bea0, 0x407703d0, 0x4963a088, 0x8370174c, 0xe01a3e26, 0x088ce491, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x78000000, 0xe4000000, 0x1a000000, 0x43000000, 0x45800000, 0x20c00000, 0xa7600000, 0x97300000, 0xf8480000, 0xb9940000, 0x0dda0000, 0xf90f0000, 0x3f748000, 0x602bc000, 0x45246000, 0xe451d000, 0xcd784800, 0x46ddfc00, 0x5bce2e00, 0xef150700, 0xc09a9780, 0xf2ace1c0, 0x392753a0, 0xca528110, 0xfc7a9188, 0x6c5ecacc, 0xb88d222a, 0xd5b65bdb, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x98000000, 0x9c000000, 0xc2000000, 0x53000000, 0x94800000, 0x94c00000, 0xc9600000, 0x00500000, 0x94880000, 0x35ac0000, 0x3dfa0000, 0x0cd70000, 0xfdee8000, 0x84594000, 0xabe5e000, 0x7034b000, 0xe6fc2800, 0xfdf0dc00, 0x8db8ea00, 0x1976b700, 0x10de6b80, 0x5e821840, 0x03c090a0, 0x23e32470, 0x1591c988, 0x0269834c, 0xa9bfd922, 0x36d3e731, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x38000000, 0xc4000000, 0xfa000000, 0x65000000, 0xbf800000, 0xb3400000, 0x07e00000, 0x8f700000, 0x79080000, 0xd2540000, 0xd55a0000, 0xac8f0000, 0xe8968000, 0x52fb4000, 0xd89f6000, 0xd92fd000, 0x55844800, 0xfac3e400, 0xa7a3c600, 0xe4129100, 0x09bac580, 0xc37e16c0, 0xd85c5aa0, 0x1b8ce910, 0x0e14ab88, 0x403bf3cc, 0x633e7122, 0xb33c5ad9, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x74000000, 0xb2000000, 0x4d000000, 0x86800000, 0xac400000, 0x1ca00000, 0x4b700000, 0xe4780000, 0x875c0000, 0x2d6a0000, 0x0ab50000, 0x049f8000, 0xc10bc000, 0xe0256000, 0xbfb69000, 0xb61ce800, 0xbf4b8400, 0x81854200, 0x0a47ed00, 0x8a24ac80, 0x96b5fec0, 0xaa9d3e60, 0x62090430, 0xa5a7e688, 0x6674c7c4, 0x0b7d58e6, 0x3d5a03f3, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0xf4000000, 0x32000000, 0xff000000, 0x65800000, 0x3a400000, 0x21e00000, 0x3db00000, 0x47280000, 0x887c0000, 0x48ba0000, 0x77450000, 0x8abe8000, 0x819b4000, 0xe0d5a000, 0xc9851000, 0xa59fa800, 0xcb0b8c00, 0x316f4e00, 0x46413d00, 0xa7e05d80, 0xd0b231c0, 0xcda9d620, 0xdfbcd2b0, 0xa71b9b88, 0x5916d0c4, 0x0f24cda2, 0x2b4d4271, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xa8000000, 0x6c000000, 0x7e000000, 0x4f000000, 0xa8800000, 0x21400000, 0xb5a00000, 0xe3100000, 0xc0680000, 0xf80c0000, 0xa11a0000, 0xe0950000, 0xb74c8000, 0x63bac000, 0xbf052000, 0x9c64f000, 0xdb159800, 0x088fac00, 0x045aaa00, 0xe734a100, 0x155f1880, 0xec518340, 0xa2c90620, 0xd79e2cf0, 0x22318a88, 0x3438be44, 0x7ec60caa, 0xb48552b7, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x38000000, 0xdc000000, 0x3e000000, 0x51000000, 0x65800000, 0xb1400000, 0xd9e00000, 0x68d00000, 0x84b80000, 0xb24c0000, 0x7f4a0000, 0xd7870000, 0x850e8000, 0xeba8c000, 0xc4d76000, 0x91f43000, 0xdd84d800, 0xbe0f5400, 0x252a5e00, 0xd315d900, 0xcbd76580, 0x35755840, 0x61441c60, 0x42af17f0, 0x4e180388, 0x8c7f254c, 0xf7a09fe2, 0x7db3f2b7, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xe8000000, 0xcc000000, 0x4a000000, 0x11000000, 0xf3800000, 0x51400000, 0xae200000, 0x59900000, 0x6c580000, 0x2c8c0000, 0x3f2a0000, 0xfd250000, 0x0acf8000, 0x498bc000, 0x9f772000, 0x96747000, 0x61f54800, 0xe6b65400, 0xcb979600, 0x5485c900, 0x1c1fe280, 0x94f01540, 0xbeebf0e0, 0xd4c41ef0, 0x61bd9c88, 0xcc203844, 0xa493ec66, 0x85dae6b3, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x18000000, 0xa4000000, 0xc6000000, 0xb1000000, 0x78800000, 0xd9400000, 0x5c600000, 0xaa900000, 0x8f480000, 0xe7440000, 0xea7a0000, 0x88bd0000, 0x69058000, 0x4f994000, 0xebeee000, 0x4f6d5000, 0x242e3800, 0xf74cb400, 0xa05eaa00, 0x50d41900, 0x27b26780, 0x85b90540, 0x409ec5a0, 0x6576c8d0, 0x54019588, 0x0e01b844, 0xed00d02e, 0x8a833099, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x48000000, 0xac000000, 0xc2000000, 0x41000000, 0x31800000, 0x49c00000, 0xd3a00000, 0x82300000, 0x65480000, 0x3fa40000, 0x8a9a0000, 0x3dbd0000, 0x1b678000, 0xeabb4000, 0xd74da000, 0x8c0d7000, 0x56ed6800, 0x473c1400, 0xce27be00, 0xe358cb00, 0x9e1ddc80, 0xc154b1c0, 0x6bf120a0, 0x86e862d0, 0x85952a88, 0x1bd25ec4, 0x24198a26, 0xbefc7c11, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0x9c000000, 0x86000000, 0x77000000, 0x75800000, 0x87c00000, 0x63600000, 0xad500000, 0x63d80000, 0x62040000, 0xe0aa0000, 0x51ad0000, 0xb6868000, 0x2de94000, 0xec8d2000, 0xc176b000, 0x4303f800, 0x2f828c00, 0x56c37e00, 0xf1e33b00, 0x77135780, 0x1b791440, 0x2a35d9e0, 0x5920bad0, 0x25f27188, 0xb3ea5344, 0xff8da862, 0xa6f7e999, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xa8000000, 0xa4000000, 0xb2000000, 0x01000000, 0x2a800000, 0x14400000, 0x07200000, 0xb8700000, 0x2fd80000, 0x9dd40000, 0x854a0000, 0x8e9d0000, 0xf8d48000, 0xfdca4000, 0x6bdd2000, 0x2d775000, 0x5dfa2800, 0x5527b400, 0xbbd13200, 0xdce87d00, 0x78ae0280, 0xd52d02c0, 0x10ef9ee0, 0x7c0f3410, 0xb79eb888, 0x3e56dbc4, 0x0f89266a, 0x27fdefd5, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x18000000, 0x8c000000, 0xfe000000, 0x45000000, 0x13800000, 0x42400000, 0xcd600000, 0xb9d00000, 0x08580000, 0xc1340000, 0x11360000, 0x39370000, 0x8d378000, 0x8f364000, 0x2c362000, 0xf6b41000, 0x5977e800, 0x9356fc00, 0xf466b200, 0x07afbb00, 0x03a08e80, 0x6a7069c0, 0x4a2948a0, 0x3f1ecc70, 0x2c2948a8, 0xb61ecc74, 0xe1a948aa, 0xc15ecc73, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xa8000000, 0xe4000000, 0xc6000000, 0xcd000000, 0x3b800000, 0x77400000, 0xdd600000, 0x7c500000, 0x56480000, 0xc4740000, 0xcc760000, 0xf8750000, 0xb6758000, 0x8f75c000, 0xdaf76000, 0x84b4f000, 0xa457e800, 0x6244dc00, 0xd2ec3200, 0x1d89ef00, 0x5ad49a80, 0x1a846bc0, 0x36ceb2e0, 0x85b96330, 0x254eb2e8, 0xd6f9633c, 0x1e2eb2ea, 0x77a9633d, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x08000000, 0xec000000, 0xba000000, 0x7d000000, 0x8b800000, 0xe9c00000, 0xeaa00000, 0x80d00000, 0x97680000, 0x7a6c0000, 0xe66e0000, 0xa46f0000, 0x8d6e8000, 0x88edc000, 0x422de000, 0x080e5000, 0x2d9cb800, 0x4f154c00, 0x3d4b6200, 0xcffec500, 0xece66f80, 0xea30ecc0, 0xcdda7160, 0x3af5f8d0, 0x757a7168, 0xbb25f8d4, 0xbb92716e, 0x6989f8d9, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x38000000, 0xb4000000, 0x8a000000, 0x63000000, 0x88800000, 0x08c00000, 0xc5600000, 0x85900000, 0xe0380000, 0x6d5c0000, 0x115e0000, 0xc75f0000, 0x425c8000, 0x07dec000, 0x569e2000, 0xc4bcf000, 0x8e0ed800, 0x45075400, 0x00117600, 0x117b5500, 0x8f7d4080, 0xf3eed6c0, 0x80561620, 0x3948c350, 0xffb61628, 0x2318c354, 0x386e1626, 0x3014c35d, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xe8000000, 0x54000000, 0xfe000000, 0x5b000000, 0x04800000, 0x5fc00000, 0x62600000, 0x6f700000, 0x12c80000, 0x4edc0000, 0xc4de0000, 0xb1df0000, 0x965c8000, 0x011d4000, 0x7ebee000, 0x82afb000, 0x5e944800, 0x02c12400, 0xb1e33600, 0x96334900, 0xae694080, 0x0a4d3d40, 0xed24d660, 0x2ae9bd10, 0x158cd668, 0x6f45bd14, 0x359ad666, 0xef46bd13, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x38000000, 0x74000000, 0x46000000, 0xdb000000, 0x15800000, 0x91400000, 0xff600000, 0x8a300000, 0xc0c80000, 0xbe340000, 0x9c360000, 0x99370000, 0x13b48000, 0x3977c000, 0xc0572000, 0x9286f000, 0xd43fe800, 0x9b208400, 0xb7d2d200, 0x1c399700, 0x5dddea80, 0xa1d28240, 0xbf3a6160, 0xdc5fc9b0, 0xa6926168, 0xa35bc9b4, 0x37ec6166, 0xb118c9b9, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xe8000000, 0x74000000, 0x4e000000, 0x3f000000, 0xcd800000, 0xa1400000, 0x33e00000, 0x94f00000, 0x3e280000, 0xb24c0000, 0xdd4e0000, 0x38cd0000, 0x4d8f8000, 0xe06cc000, 0xa39f6000, 0x2436b000, 0x793b8800, 0xa8957400, 0xc92b4200, 0x1bce4700, 0x7a0e4880, 0x902d7b40, 0xb2fe33e0, 0x3404f2d0, 0xa1b033e8, 0xf3c9f2dc, 0x81bfb3e2, 0x62e532d1, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x78000000, 0x24000000, 0xae000000, 0x5f000000, 0xa0800000, 0xb1400000, 0x43e00000, 0xef700000, 0x4ca80000, 0x411c0000, 0x961e0000, 0xba9f0000, 0x19dc8000, 0x1f3ec000, 0xd9cf2000, 0xffa7b000, 0x42990800, 0x96567400, 0x6c73f600, 0x2629b300, 0xe15c7c80, 0xba7de140, 0x3c2ee3e0, 0x83d7af90, 0x5cb0e3e8, 0xb308af94, 0xe80c63e6, 0x3d066f9d, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xf8000000, 0x64000000, 0x0a000000, 0x55000000, 0x77800000, 0x79c00000, 0xc9a00000, 0xf6100000, 0x91a80000, 0x373c0000, 0x163e0000, 0x73bd0000, 0x4b7d8000, 0x575cc000, 0x118f2000, 0x5006b000, 0xb7ea9800, 0xdb5dcc00, 0x678d1200, 0x1b077500, 0x37699380, 0x1c1eebc0, 0xce6fdd60, 0x02753990, 0xbbf1dd68, 0x42d8399c, 0xcea45d6a, 0x6f78f999, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xd8000000, 0xa4000000, 0x06000000, 0xc9000000, 0x13800000, 0x16c00000, 0xf9a00000, 0x0ed00000, 0xb0380000, 0xe5bc0000, 0x10be0000, 0xc13d0000, 0x08ff8000, 0x43dd4000, 0x344e2000, 0xc914b000, 0x14d8a800, 0x600d8c00, 0xf1f4c200, 0xe3691900, 0x8644bf80, 0xc52024c0, 0x12909420, 0x84dacad0, 0xc80e9428, 0x2df7cadc, 0xf1691422, 0x91468ad7, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xd8000000, 0xc4000000, 0xae000000, 0x47000000, 0xec800000, 0x3dc00000, 0x7de00000, 0x02f00000, 0x0ed80000, 0x54940000, 0xbf960000, 0xa1170000, 0x51d48000, 0x19b44000, 0x55072000, 0x337c3000, 0x8b3a8800, 0x02659400, 0x174d2600, 0x9e835100, 0xb0c3e680, 0xa8614d40, 0x7cb28620, 0xbe7abc70, 0x7c448628, 0x275dbc74, 0x52280626, 0x654dfc77, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x48000000, 0xe4000000, 0xa2000000, 0x95000000, 0x8f800000, 0x53400000, 0xeee00000, 0xd5900000, 0x21c80000, 0x8c8c0000, 0x938e0000, 0x5d0d0000, 0x8bce8000, 0xb76d4000, 0xe99c6000, 0x3f87f000, 0x51a17800, 0x5d712c00, 0xd3581200, 0x0fc6df00, 0x6fc0a480, 0x3523d2c0, 0xdab045e0, 0xd278bfd0, 0x2f7645e8, 0x74b9bfdc, 0x9bd6c5e6, 0x2e49ffd3, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x18000000, 0xfc000000, 0x56000000, 0x97000000, 0x30800000, 0x6bc00000, 0x78200000, 0x3fb00000, 0xa1080000, 0x259c0000, 0x851e0000, 0xb6df0000, 0x92fd8000, 0xeb4dc000, 0xc545a000, 0x2c5a5000, 0x94850800, 0xcd785400, 0x50b51600, 0x71317900, 0xe9c93980, 0x7f3d9740, 0xfc6d1b60, 0x86745910, 0xb8909b68, 0xba399914, 0xed553b62, 0xeda3c915, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xd8000000, 0x54000000, 0xfe000000, 0xa1000000, 0xfd800000, 0x4dc00000, 0x10200000, 0xda100000, 0x23680000, 0x32a40000, 0x97260000, 0xcee70000, 0x80c58000, 0xabd4c000, 0xad3fa000, 0x865af000, 0xff5f0800, 0x4aaa8c00, 0x1484fa00, 0xc0350d00, 0xea0ced80, 0x78a275c0, 0x24507060, 0xf78af6f0, 0xd915f068, 0x519e36f4, 0xc40a5062, 0x5dd4c6f1, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xa8000000, 0x84000000, 0xea000000, 0x53000000, 0xf8800000, 0xa6c00000, 0xaee00000, 0x3a300000, 0x34f80000, 0x7fac0000, 0x932e0000, 0x47ed0000, 0x760e8000, 0x2abd4000, 0xa987e000, 0x5749f000, 0x4a145800, 0x62201400, 0x07d17600, 0x1648ad00, 0x1d94f680, 0xea616e40, 0x6af3a5a0, 0xef1a2f10, 0x701d25a8, 0xe8976f1c, 0x1fe2c5a6, 0xc5b29f13, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x18000000, 0x9c000000, 0x6a000000, 0x1b000000, 0x60800000, 0xf8400000, 0x53e00000, 0x74f00000, 0xecd80000, 0xb3040000, 0x07860000, 0x51c70000, 0xcf278000, 0x7a54c000, 0x0d4ca000, 0xe96ad000, 0x5bbd7800, 0xdab21400, 0x5e381600, 0x84753700, 0x3f9dd880, 0x3b605b40, 0x68b2d020, 0xb939e830, 0x7ef55028, 0x14dd2834, 0x8c01f02a, 0x1203f839, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x38000000, 0x9c000000, 0xa2000000, 0x6b000000, 0x61800000, 0x60c00000, 0x6a200000, 0x18b00000, 0x29280000, 0x655c0000, 0x26de0000, 0x6d1f0000, 0xc6bd8000, 0x0ecf4000, 0x75c7a000, 0x9429d000, 0x39dd5800, 0x5a9ff400, 0xdb7df200, 0xd86c3100, 0x0137b980, 0x83614b40, 0xe65317e0, 0x4db8a690, 0x89c697e8, 0x662be694, 0x7adf37e2, 0x2f1d369f, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x18000000, 0x3c000000, 0x5a000000, 0x7f000000, 0x8b800000, 0x1bc00000, 0x29600000, 0x16500000, 0x90e80000, 0x49640000, 0x6ce60000, 0x86250000, 0x45c48000, 0xead44000, 0xfe1c2000, 0x5b08d000, 0x5277b800, 0x562f4400, 0x1233ea00, 0xc638c500, 0x67cfc080, 0x262089c0, 0x5f729260, 0xcc19c3f0, 0xeabe1268, 0xe13983fc, 0x704c326e, 0x37e053ff, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xa8000000, 0xc4000000, 0x5e000000, 0x61000000, 0x1e800000, 0x19400000, 0x16a00000, 0x74b00000, 0x25880000, 0xdc4c0000, 0x3bce0000, 0xe00f0000, 0x2dee8000, 0x8cfcc000, 0x90466000, 0x95417000, 0x5ca20800, 0x83b28c00, 0x0e0b7600, 0x2d8d5300, 0x912da980, 0xc29e6b40, 0x04960560, 0x7d1ab050, 0x1a368568, 0x7da97054, 0x39be656e, 0x3ce4c05d, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xc8000000, 0x4c000000, 0x66000000, 0x33000000, 0x32800000, 0x70c00000, 0x44200000, 0x06500000, 0xea480000, 0x8ed40000, 0xe3560000, 0x37170000, 0x58f58000, 0xd4074000, 0xe6dc6000, 0xb9615000, 0x8632c800, 0xfbfb0400, 0x6c6d4e00, 0x75584d00, 0xdefd7d80, 0x5131d4c0, 0xb378a5e0, 0x91ac32b0, 0x04fb25e8, 0x78ec72b4, 0x969ac5e2, 0x185e62bf, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x68000000, 0xd4000000, 0xee000000, 0x51000000, 0xbc800000, 0x3d400000, 0x5fa00000, 0x0fb00000, 0x75680000, 0xfab40000, 0x13360000, 0x44f70000, 0xdb178000, 0x55874000, 0x111ee000, 0x16e1b000, 0xce100800, 0x63d84c00, 0xd75e3e00, 0x52c00b00, 0x8d63d580, 0xc2d13b40, 0x97bb16e0, 0x5d0cd830, 0x263a96e8, 0xb6cc9834, 0x83dbf6ea, 0x875e6837, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0xf4000000, 0x82000000, 0x25000000, 0xa5800000, 0xe7400000, 0xb3e00000, 0xc9300000, 0x58d80000, 0xb2140000, 0x1e960000, 0x62570000, 0x75f78000, 0x15a74000, 0x3f8fe000, 0x52603000, 0xc4703800, 0x1a39ac00, 0x6ca7ba00, 0xac0ee700, 0x32218880, 0xc713fc40, 0xb9c95720, 0x94df2b70, 0xe6c8d728, 0x985f6b74, 0xea08b72a, 0x87fc1b77, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xb8000000, 0x7c000000, 0xbe000000, 0x9b000000, 0x29800000, 0xa0400000, 0x8d200000, 0x08700000, 0x0ee80000, 0x195c0000, 0xd9de0000, 0x9d1d0000, 0x66ff8000, 0x386dc000, 0x8e972000, 0xd2f2d000, 0x232a2800, 0xc63f4400, 0x518f6200, 0xed04a300, 0x3a8af780, 0xf08f6640, 0xfd8645e0, 0xa6483c90, 0x476fc5e8, 0x3514fc9c, 0x4fb165e2, 0xf08aec95, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x48000000, 0xf4000000, 0xba000000, 0x0b000000, 0xa5800000, 0x92400000, 0x63e00000, 0x58900000, 0x2fe80000, 0x073c0000, 0x4fbe0000, 0xed7f0000, 0x205e8000, 0x43ecc000, 0x92b5e000, 0xec523000, 0xafcad800, 0xe40ff400, 0x8826e200, 0x84bbeb00, 0x9b74c480, 0x34f336c0, 0xe63ac160, 0x7ab7e190, 0xa8524168, 0xadc82194, 0xc30f216e, 0x2ba5d19d, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xa8000000, 0xcc000000, 0x7a000000, 0x1d000000, 0xe9800000, 0xe9c00000, 0x01600000, 0xd1d00000, 0x21f80000, 0xc0c40000, 0x8d060000, 0x9a670000, 0xbcb48000, 0xb1cd4000, 0x154be000, 0xc6eed000, 0xeb383800, 0x5324cc00, 0x03962a00, 0xb3bc6d00, 0xb283b880, 0x8f4347c0, 0x3022cc20, 0xdaf34530, 0xad892c28, 0x140d9534, 0x2e291426, 0xea3d5933, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x08000000, 0x9c000000, 0xce000000, 0x99000000, 0xaf800000, 0xdf400000, 0xe3e00000, 0x34300000, 0x43280000, 0x41ac0000, 0x8cee0000, 0x980d0000, 0x4abc8000, 0xc1564000, 0x285a6000, 0x21661000, 0x99702800, 0xe7cacc00, 0x9b1c3200, 0x9b062f00, 0xbf023080, 0xda800840, 0xd6c3e8e0, 0x89a0ac50, 0xbe5188e8, 0xad5abc5c, 0x80e7a0ee, 0xbf317057, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xf8000000, 0x34000000, 0x7a000000, 0xeb000000, 0xb8800000, 0x59c00000, 0x68600000, 0x81300000, 0x54480000, 0xeee40000, 0x89260000, 0x78470000, 0xd6f78000, 0x45fdc000, 0xc7ba2000, 0xba4cf000, 0x67321800, 0x694a3400, 0x43671600, 0x91655100, 0xd6648080, 0x90e4dc40, 0x30255960, 0xc7c5a4f0, 0xe9b77968, 0x1d5d54f4, 0x496b616a, 0xf47460fd, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x78000000, 0x04000000, 0xd6000000, 0x1b000000, 0x64800000, 0x70c00000, 0xbe200000, 0x13900000, 0x63d80000, 0x3c1c0000, 0x96de0000, 0xc9ff0000, 0xefec8000, 0x4174c000, 0x62092000, 0x52273000, 0x97f36800, 0xe1ab8400, 0xa0f4d600, 0xa1493500, 0xa2457d80, 0xeb831bc0, 0xfa4170a0, 0x31e006d0, 0x0f3050a8, 0x638b36d4, 0x816538a6, 0x1f93b2d5, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x08000000, 0x6c000000, 0x7e000000, 0x89000000, 0xb1800000, 0x7a400000, 0xfee00000, 0x3f700000, 0x4eb80000, 0xd7940000, 0xd4d60000, 0x03b70000, 0x82858000, 0xf0dec000, 0xe73ae000, 0x29d55000, 0x4837a800, 0x13c60c00, 0x90bd0a00, 0xfe8b8300, 0x404fe880, 0xd3705d40, 0x70bb3ba0, 0xfe9447f0, 0xb557dba8, 0x71f617f4, 0x1065f3a2, 0xb1aedbf9, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xe8000000, 0x84000000, 0x2e000000, 0xc5000000, 0x18800000, 0x8ac00000, 0x87e00000, 0xd7700000, 0xe4180000, 0xf2640000, 0xe5a60000, 0x26c70000, 0x49748000, 0x3d8ec000, 0x87196000, 0x7be57000, 0x51e6c800, 0xfae75c00, 0xc766fe00, 0xc5253500, 0x20069a80, 0xf4976f40, 0xe9ff5320, 0x3a83ecb0, 0x35c03328, 0x7c619cb4, 0x94327b26, 0x37b800bd, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x38000000, 0x94000000, 0x6e000000, 0x3f000000, 0xdd800000, 0x8f400000, 0xd6600000, 0x27700000, 0x6a680000, 0x602c0000, 0x646e0000, 0x718d0000, 0x7ebf8000, 0x3b354000, 0xa529a000, 0xd64df000, 0x531d4800, 0x93e43400, 0xb2930200, 0xa5591f00, 0x85a7f680, 0x4a700340, 0x3aeb2ee0, 0x6fec4450, 0x95cc8ee8, 0xbb5cb45c, 0x1c0646e2, 0xfca1c057, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xf8000000, 0x8c000000, 0x66000000, 0xa7000000, 0x70800000, 0x9a400000, 0xfae00000, 0x9fb00000, 0xd5180000, 0xc6940000, 0xc7d60000, 0x13b50000, 0x5d448000, 0x543c4000, 0xc85ba000, 0xdcf79000, 0x6a270800, 0x784f1400, 0x16639600, 0x0bf0df00, 0xacf9e480, 0x0ba5b240, 0x3d8f2220, 0x12438670, 0x2ee28228, 0x25b1167c, 0xdc190a2e, 0x6516427f, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x78000000, 0x14000000, 0x92000000, 0x55000000, 0x36800000, 0x0ac00000, 0x85600000, 0xf6500000, 0x23280000, 0xa0740000, 0x73b60000, 0xf6570000, 0x45c78000, 0x3c0cc000, 0xa8692000, 0xa4577000, 0x70c63800, 0xfa8eec00, 0x0aa9f600, 0x4d357d00, 0x0095d880, 0x1ea599c0, 0xc95dc960, 0x02c066b0, 0x7962e968, 0x285016b4, 0x202b516a, 0x29f63ab9, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x88000000, 0x0c000000, 0xfe000000, 0x91000000, 0x8b800000, 0x04c00000, 0x7de00000, 0xcd700000, 0x94780000, 0xc36c0000, 0x00ae0000, 0x7bcf0000, 0x1ffc8000, 0x57a64000, 0xd5d86000, 0xebbe5000, 0x5e06a800, 0x510a6c00, 0x1b170200, 0xddc0f100, 0x5a639680, 0x67b32b40, 0x409ba6a0, 0x019c1110, 0x6215c6a8, 0xaa414114, 0xc8a1eea6, 0x37526d1f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x98000000, 0x04000000, 0xea000000, 0x6f000000, 0x60800000, 0x6cc00000, 0x05e00000, 0x70900000, 0x10880000, 0x858c0000, 0x844e0000, 0x322d0000, 0x70fe8000, 0x24564000, 0x47282000, 0x413e3000, 0x0a349800, 0x01f9a400, 0xff956600, 0x064b7500, 0x676f9280, 0xd85fa8c0, 0x0867dee0, 0xe990c6d0, 0x3109fee8, 0xeccff6dc, 0xd2ede6e6, 0xd31d12df, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x08000000, 0x4c000000, 0xca000000, 0x13000000, 0xea800000, 0x2ec00000, 0x19e00000, 0x4db00000, 0xfec80000, 0x33240000, 0xfce60000, 0x48850000, 0x2f748000, 0xa39fc000, 0xff6be000, 0x2bb4d000, 0xb97ef800, 0x30583400, 0x67bf5e00, 0x51b98500, 0xde0c7280, 0xf1709c40, 0x702be360, 0x721419f0, 0x25ee0368, 0x93c1c9fc, 0x16627b6e, 0xe8f33df1, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0xcc000000, 0x8a000000, 0xbd000000, 0xe2800000, 0xc1c00000, 0x1e200000, 0xd0300000, 0x7f180000, 0xe69c0000, 0xc45e0000, 0x23fd0000, 0x978d8000, 0x60f4c000, 0xff39a000, 0x0dac9000, 0x4ec7b800, 0x0b22cc00, 0x36b28600, 0x80daa100, 0x53bc0980, 0x99ed1140, 0x0ea65120, 0xc6730550, 0x1679f128, 0x8f4e955c, 0x1255c92a, 0x6dc99959, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xb8000000, 0xdc000000, 0xe2000000, 0x85000000, 0xf8800000, 0xb6c00000, 0x30e00000, 0xad900000, 0x6e480000, 0x0eec0000, 0x5cae0000, 0x588f0000, 0x70ff8000, 0xe3a7c000, 0x51c12000, 0x0d605000, 0xc3d2d800, 0xf8684c00, 0x2b9fee00, 0x4375d500, 0xda2b6680, 0xa7bcd8c0, 0x1f0435e0, 0xcf708c50, 0xaeda95e8, 0xdc271c54, 0xca816dea, 0xebc30055, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x28000000, 0xc4000000, 0x76000000, 0x23000000, 0x82800000, 0xed400000, 0x28a00000, 0xe0b00000, 0xe8480000, 0xad6c0000, 0xaeae0000, 0x194d0000, 0xa45d8000, 0xbd274000, 0xbfc3e000, 0xbde2f000, 0xb4102800, 0x22f82400, 0xfc24ee00, 0x1041fb00, 0x8d234980, 0xd9729340, 0xbeabfe60, 0xcffd21d0, 0x8f159e68, 0x02c891dc, 0x642e566a, 0x600e45d7, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x68000000, 0x94000000, 0xce000000, 0xdb000000, 0xa4800000, 0xd8400000, 0xdf600000, 0x9c100000, 0xe2880000, 0x9a540000, 0xfa960000, 0x57b50000, 0x59c78000, 0x34ddc000, 0x02c06000, 0xe4203000, 0xbbf00800, 0x6cd9e400, 0xdabd3600, 0x1751f700, 0xfd69da80, 0x480512c0, 0x707f34e0, 0xc7732fb0, 0x1898d4e8, 0x97dedfbc, 0x9a40bce2, 0xc6630bb5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x58000000, 0x84000000, 0x26000000, 0xff000000, 0x5f800000, 0xe9c00000, 0x8b600000, 0x76d00000, 0x31480000, 0x965c0000, 0x8e1e0000, 0xefbd0000, 0x9f8e8000, 0x20d4c000, 0x7021a000, 0x0af1b000, 0xe1ba2800, 0x5ae65400, 0x9a7b6a00, 0xe084ad00, 0xe02a1080, 0x0d8f93c0, 0x11d50ae0, 0x7ca39d90, 0xd6b22ae8, 0x861aed9c, 0xa5d7a2e6, 0xb2a00995, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xe8000000, 0x5c000000, 0x9a000000, 0x2b000000, 0x8d800000, 0x23c00000, 0x97600000, 0x04900000, 0x58980000, 0x9fec0000, 0xa7ae0000, 0x7a0f0000, 0x5b7d8000, 0x1f344000, 0x35e3e000, 0x64d09000, 0xd13bf800, 0xa89dd400, 0xcae42200, 0x425a0d00, 0x620da080, 0xaf7d1ac0, 0x7934f4a0, 0xf4e28d10, 0x2a5294a8, 0x237a5d14, 0x863c8ca2, 0x72141913, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x18000000, 0x6c000000, 0x46000000, 0xad000000, 0xe2800000, 0x6a400000, 0x99200000, 0xbcf00000, 0x43780000, 0x83c40000, 0x59060000, 0x5d670000, 0x89348000, 0x0f7c4000, 0x80202000, 0xd4739000, 0x123b8800, 0x7d66bc00, 0x1937f600, 0xc77f3f00, 0xc4236b80, 0xe6724040, 0x953899a0, 0x74e72cb0, 0x3cf439a8, 0xd69cfcb4, 0x8bb191a6, 0x80dad0b7, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xd8000000, 0x54000000, 0x46000000, 0x19000000, 0x23800000, 0x24400000, 0xc1200000, 0x20b00000, 0x8d780000, 0x779c0000, 0xb95e0000, 0xe7bf0000, 0x566f8000, 0x2c86c000, 0x37d1a000, 0x03eaf000, 0x48d6e800, 0x98780c00, 0x061ec200, 0xe21eb300, 0x4c1c2780, 0xa91f1d40, 0x109e3ca0, 0xe7dc44d0, 0x0e7e1ca8, 0x760f74d4, 0x2496d4aa, 0xb55b48d1, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x68000000, 0xc4000000, 0x7a000000, 0x9d000000, 0x38800000, 0xc1c00000, 0x5f600000, 0x6f900000, 0x07080000, 0xb92c0000, 0x356e0000, 0x174f0000, 0x3c7d8000, 0xa6854000, 0x27b0e000, 0xa939f000, 0x17551800, 0xfb9bec00, 0x49a4ce00, 0x8c03e900, 0xce00c480, 0x2f0272c0, 0x5180eae0, 0xeb417450, 0xc7a38ae8, 0x7272c454, 0x345bf2e2, 0xd9c59857, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xf8000000, 0xe4000000, 0xc2000000, 0xe5000000, 0x91800000, 0xc2400000, 0x1aa00000, 0xfe300000, 0x1cc80000, 0x802c0000, 0x52ee0000, 0x998f0000, 0x3a5e8000, 0x4386c000, 0x1b112000, 0x2bb8b000, 0x5cc6b800, 0x5432ac00, 0xa5cbaa00, 0x57afc300, 0xa7aff980, 0x0fada940, 0x73afbe60, 0x45af20d0, 0x9aae1e68, 0x0a2e50d4, 0x9bef066e, 0xa60e8cd5, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xc8000000, 0x34000000, 0xfa000000, 0x7b000000, 0x83800000, 0x33c00000, 0x0ee00000, 0xc2700000, 0x78080000, 0x0d2c0000, 0x4a6e0000, 0x02cf0000, 0x309d8000, 0x6a85c000, 0x1092e000, 0x24783000, 0x9c26d800, 0x9bc3b400, 0xcae2fa00, 0x40729500, 0xef08be80, 0x88af3f40, 0xccaec360, 0x0eaec1d0, 0x39afa368, 0xac2c31d4, 0xe2ee1b62, 0xda8e75d5, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xc8000000, 0xe4000000, 0xa2000000, 0x81000000, 0x0f800000, 0x21400000, 0xe9a00000, 0xb8500000, 0xadd80000, 0xe9d40000, 0x50160000, 0xac770000, 0xee448000, 0xc2ad4000, 0xf9126000, 0x747bf000, 0x79847800, 0x69cffc00, 0x2fa30200, 0xdb512700, 0xc359d180, 0xb71518c0, 0x50f5fba0, 0x1986caf0, 0x59cd1ba8, 0x07a37af4, 0x4f5183a6, 0xa95936f3, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x18000000, 0xcc000000, 0x42000000, 0x7f000000, 0x8c800000, 0x6a400000, 0x9ca00000, 0x19500000, 0xf8280000, 0x897c0000, 0xe5de0000, 0x248d0000, 0x70a48000, 0xcbd94000, 0x49072000, 0x2d091000, 0x75ec9800, 0x5d942400, 0x81413600, 0x3e218f00, 0x5e136580, 0xff0924c0, 0xa2eef260, 0x6515d890, 0x15026a68, 0x8781fc9c, 0x78c35c6e, 0xa3e0739b, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x18000000, 0xfc000000, 0xba000000, 0xad000000, 0x7f800000, 0x98400000, 0x06200000, 0x06f00000, 0xf3480000, 0xf7e40000, 0x49c60000, 0x03370000, 0xa27e8000, 0x8c98c000, 0xe4dea000, 0x94aa5000, 0x58763800, 0x98dc4c00, 0x6eab1200, 0x95772300, 0x775f0380, 0xeee85440, 0x6f540b60, 0xcbad37f0, 0xb0a23368, 0xe7317bf4, 0x1a29216e, 0xb5b658fd, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x88000000, 0xec000000, 0xe2000000, 0x37000000, 0x4d800000, 0xc5400000, 0xa6e00000, 0x0b100000, 0x5ff80000, 0x1cec0000, 0xd80e0000, 0xa41f0000, 0x96678000, 0x7fcb4000, 0x89276000, 0xca2bd000, 0xe1b7d800, 0xb5904400, 0xa9381200, 0x024fd700, 0xd37d1480, 0x12363cc0, 0x6dd03120, 0xb9584590, 0x539fe928, 0x50240194, 0x02a9fb2a, 0xc674d697, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x78000000, 0x5c000000, 0x46000000, 0x23000000, 0x41800000, 0x9bc00000, 0x05e00000, 0x1b500000, 0x29c80000, 0x9a8c0000, 0x796e0000, 0x913d0000, 0x91768000, 0x44394000, 0x5ab6a000, 0xe9dad000, 0x75e54800, 0x52108400, 0xae692200, 0x53fc9d00, 0x80174280, 0x3e2aebc0, 0x00dfcee0, 0xc824e9d0, 0x44f286e8, 0x6cb86ddc, 0x4df5a4e6, 0x2179f0d3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xe8000000, 0xe4000000, 0x4e000000, 0x1f000000, 0x37800000, 0x43c00000, 0x07600000, 0x5c100000, 0x1da80000, 0x3cec0000, 0x348e0000, 0x971d0000, 0x9d768000, 0x50fbc000, 0x2b666000, 0x3c50f000, 0x8f0b4800, 0xc49ef400, 0x50b54a00, 0xa89a3500, 0x10f6a080, 0x8a3944c0, 0x50858860, 0xe20086d0, 0xc500c068, 0x3e8372dc, 0x37430a66, 0x312287d9, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x88000000, 0x4c000000, 0x52000000, 0xe5000000, 0x81800000, 0xacc00000, 0xb5e00000, 0xbcf00000, 0xe8f80000, 0x97bc0000, 0x5f5e0000, 0x362f0000, 0x34168000, 0xd5484000, 0xc4646000, 0xccf25000, 0x40f99800, 0x0bbc4c00, 0x355d2a00, 0x172f4900, 0xab964680, 0xce899940, 0x1506c0a0, 0x5d418f50, 0xb12158a8, 0x9512c354, 0x3e0af2ae, 0x5e45ca5f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xe8000000, 0x34000000, 0x12000000, 0xa5000000, 0xf9800000, 0x58c00000, 0xb0e00000, 0x57300000, 0xed580000, 0xf34c0000, 0x20ae0000, 0xe91d0000, 0xf8078000, 0x76e94000, 0x2754e000, 0x47c13000, 0xb862f800, 0xf4732c00, 0xf87b2a00, 0x311ff900, 0xe4040280, 0xf0e85240, 0x20565d20, 0xf3424110, 0x2d22a528, 0x0e506d1c, 0xbaa80f22, 0x72f7d417, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x28000000, 0x14000000, 0x32000000, 0xf7000000, 0x5c800000, 0x3c400000, 0xa5a00000, 0xc3d00000, 0xe9780000, 0x29640000, 0xd5c60000, 0xcb950000, 0x8f2d8000, 0x102bc000, 0xd95d6000, 0x42803000, 0x05417800, 0x08236400, 0xf6107600, 0xf31a3700, 0x3bd49980, 0x548ed2c0, 0x9af81120, 0x05a46bb0, 0xf2276928, 0xc4e60fbc, 0x00049f2a, 0x61f6f8b5, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x88000000, 0x74000000, 0x72000000, 0x3d000000, 0x19800000, 0x32c00000, 0x7c200000, 0x72d00000, 0x76480000, 0xecec0000, 0x094e0000, 0x895d0000, 0xe3348000, 0xcd0a4000, 0x3a0e6000, 0x2bbeb000, 0xb3c5f800, 0xca924c00, 0x0a28ca00, 0xde5cf100, 0x2bb69980, 0xb84baec0, 0x77ef45e0, 0x8fce4b50, 0xa71e3de8, 0x4856475c, 0xf73897ee, 0x0db40657, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xa8000000, 0xe4000000, 0x9e000000, 0xa5000000, 0x8a800000, 0x21400000, 0x0ba00000, 0x41f00000, 0xe0080000, 0xf5140000, 0xc4360000, 0xac870000, 0x332c8000, 0xc1c94000, 0x0cf5e000, 0xa5e57000, 0x48bd8800, 0x01d15c00, 0xd43a1600, 0x7afea300, 0x81f2e580, 0x4009ce40, 0x6516d060, 0x1c347b30, 0xe087d868, 0x492c6734, 0xfac82e66, 0x2377b433, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x28000000, 0x44000000, 0x32000000, 0xb1000000, 0x2f800000, 0x50c00000, 0x2de00000, 0x54f00000, 0x99980000, 0x64240000, 0x6a460000, 0xc8770000, 0x470d8000, 0xb5594000, 0x67c7e000, 0x71b5f000, 0x896eb800, 0xf76a3c00, 0x78bce200, 0x9be31100, 0x37f3fe80, 0x971be140, 0x03651d20, 0x7b6600b0, 0xc7662528, 0x09657cb4, 0xd6652722, 0x16e79db7, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x64000000, 0xe6000000, 0x2d000000, 0xba800000, 0x37400000, 0xb9600000, 0x24f00000, 0xcd080000, 0x46bc0000, 0xa95e0000, 0x00ef0000, 0xeb878000, 0xb04bc000, 0x48dca000, 0xb82e3000, 0x9b242800, 0xec985c00, 0x6d459600, 0xc9eabb00, 0x688dd680, 0x97f5a940, 0xb1006360, 0x68817e90, 0x8443cb68, 0x5ae2e294, 0x1732fd6a, 0x0a2a6995, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x28000000, 0x5c000000, 0x8a000000, 0x4d000000, 0x9c800000, 0x76400000, 0x81a00000, 0xfcd00000, 0x7c080000, 0x55140000, 0xe2360000, 0xd5a50000, 0x3c8f8000, 0x8f0b4000, 0x3295e000, 0x5ff59000, 0xebc63800, 0xdf3d4c00, 0x2e335e00, 0xa1f95700, 0xb98f0980, 0x1f8b66c0, 0x76d410e0, 0xd755cfb0, 0x7595a8e8, 0x4e77c3bc, 0xa10516e2, 0x18de04bf, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x08000000, 0x3c000000, 0x92000000, 0x53000000, 0xdb800000, 0x73c00000, 0x19600000, 0x16900000, 0xd5980000, 0x10940000, 0x58760000, 0xba250000, 0x735d8000, 0x9f98c000, 0xb796e000, 0x0df71000, 0x58e6d800, 0xeabe5400, 0x1d485a00, 0x9aaf4500, 0x41909880, 0x181a46c0, 0xe655f2a0, 0x3f94f1f0, 0xf1f6aaa8, 0xeae665fc, 0xe9be10aa, 0xcecb30f9, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xa8000000, 0x14000000, 0xb2000000, 0xe9000000, 0xca800000, 0x3f400000, 0x60a00000, 0xf3d00000, 0xbe280000, 0x58b40000, 0x33960000, 0x61870000, 0x524e8000, 0xc0884000, 0xdc64e000, 0x703fb000, 0x9bf1f800, 0x13bb1c00, 0x88bd5600, 0x0db0db00, 0xd99a0180, 0xf42e82c0, 0x7b39e460, 0x66fef9b0, 0xcb909c68, 0xab0aa5b4, 0xcda7aa6e, 0x55dd8ebf, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x78000000, 0xd4000000, 0x8e000000, 0x1d000000, 0x32800000, 0x95c00000, 0x86200000, 0x2c100000, 0x8cd80000, 0xc7ac0000, 0xca0e0000, 0x675f0000, 0x29668000, 0xbc78c000, 0xa87f2000, 0xf9f77000, 0xd861c800, 0x4b707c00, 0xf22a1600, 0x61c77100, 0x07a84180, 0x15845dc0, 0x5bcb00a0, 0x88f47b10, 0x90e248a8, 0xbdb3c714, 0xb389feae, 0x4697061d, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x18000000, 0x24000000, 0x36000000, 0x61000000, 0x67800000, 0xd6c00000, 0x34200000, 0x2df00000, 0x44180000, 0x4f3c0000, 0xd19e0000, 0x072f0000, 0xb2d68000, 0xc4bac000, 0xb48ca000, 0x19e73000, 0xcc836800, 0xe2412c00, 0xa2619200, 0xc193b900, 0xd08b6180, 0xd636ea40, 0x94697020, 0xf6e551d0, 0xde029828, 0x0d01bdd4, 0x0d812a2e, 0xb5c3f4d5, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x68000000, 0xfc000000, 0x82000000, 0x7d000000, 0x61800000, 0x98c00000, 0x51200000, 0x8ad00000, 0x62380000, 0x023c0000, 0x0b9e0000, 0x3e0f0000, 0xeed78000, 0x0d9b4000, 0x7cace000, 0x89c41000, 0xb3039800, 0xb6802c00, 0x5841ca00, 0x1a617900, 0x56310580, 0x244972c0, 0xf0177820, 0x47b89dd0, 0xdcfd6028, 0x21bcf1d4, 0x8e5fca2a, 0x1eaed8d7, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x88000000, 0xe4000000, 0xc6000000, 0x77000000, 0x79800000, 0x65c00000, 0x99a00000, 0x32d00000, 0xa3e80000, 0x1d940000, 0x24b60000, 0xa9250000, 0xa12c8000, 0x110b4000, 0x0aa76000, 0xd9edf000, 0xc4286800, 0x6535f400, 0x00e4f200, 0x8a8e5500, 0xeadafb80, 0xcbcf14c0, 0xfa391160, 0xadfd1e30, 0x69e3f968, 0x2cb2aa3c, 0xd99aeb6e, 0x722f4f33, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xd8000000, 0x6c000000, 0x62000000, 0x0d000000, 0x9c800000, 0x47c00000, 0x3b200000, 0xa4500000, 0x6da80000, 0xb1ac0000, 0xa50e0000, 0x5d1f0000, 0x19d78000, 0x6a4ac000, 0xa15fa000, 0x20b51000, 0x50791800, 0xf346ec00, 0x4641be00, 0x5861f100, 0xc4b1e580, 0x18d868c0, 0xc1540860, 0xeb88fbd0, 0x617c9068, 0x4b67d7d4, 0x51930e6a, 0xc38af6d1, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xb8000000, 0x0c000000, 0x96000000, 0x3b000000, 0x7a800000, 0xac400000, 0x97e00000, 0x94700000, 0x67e80000, 0x18e40000, 0xcc860000, 0xff370000, 0x5cfc8000, 0x6e494000, 0x3275a000, 0xbc9e9000, 0x87fa4800, 0xdcbee400, 0xbfab2e00, 0xb507cf00, 0x65f6b880, 0x115ffd40, 0x26dbf4e0, 0x036f8470, 0x63d33ce8, 0x527b2074, 0x407f32e6, 0x01083f73, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xa8000000, 0xcc000000, 0x56000000, 0x6b000000, 0x2d800000, 0x98c00000, 0xafa00000, 0x2a500000, 0x41380000, 0x95740000, 0xc2160000, 0xf7e50000, 0x448d8000, 0xa4c0c000, 0xc1a06000, 0x05505000, 0xa6b98800, 0x98b56400, 0xe7357200, 0x3ef72100, 0x59d44780, 0x99c402c0, 0xf01f1020, 0x895816f0, 0x9f06f828, 0x48bd22fc, 0x008a022a, 0x19ff67f9, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x48000000, 0x6c000000, 0xa2000000, 0x65000000, 0xe0800000, 0x32400000, 0xbc600000, 0x8a900000, 0xd3780000, 0x7dec0000, 0x23ce0000, 0x2d3d0000, 0xb0d68000, 0x60404000, 0xb1636000, 0x5611d000, 0xbb38d800, 0x808f8c00, 0x87df2e00, 0x0b055700, 0xf4daae80, 0x1bddd0c0, 0xc1053f20, 0xadd93190, 0xa15e8728, 0xb2476d9c, 0x3f397126, 0xde8db697, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x68000000, 0xa4000000, 0x2a000000, 0xc3000000, 0xd2800000, 0x4ec00000, 0x2b600000, 0xa3d00000, 0x49b80000, 0x907c0000, 0x91de0000, 0x136f0000, 0xca068000, 0x3940c000, 0xba236000, 0x9df0f000, 0x0e49d800, 0xa5349400, 0x2a687e00, 0xf9c4d500, 0xf1a25080, 0x7ab313c0, 0x156a1f20, 0x7d4595d0, 0x6a60a728, 0x3651f1d4, 0x0ff9012e, 0xceddb0dd, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xf8000000, 0xb4000000, 0x9a000000, 0xe5000000, 0xe3800000, 0x8fc00000, 0x87e00000, 0x47b00000, 0x47080000, 0xd7340000, 0x23160000, 0xd5470000, 0xcefd8000, 0x4a404000, 0x7b21a000, 0x48d27000, 0x63fa9800, 0x669ccc00, 0xec32a200, 0x64c94d00, 0xaed6ba80, 0x93a57040, 0xd8ccc260, 0x5b8a11b0, 0x1e77fa68, 0x68b4adb4, 0xead7c062, 0xb1a52cb3, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x48000000, 0x14000000, 0xae000000, 0x13000000, 0x67800000, 0x88400000, 0xb3600000, 0x1ef00000, 0x28980000, 0x4d4c0000, 0x206e0000, 0x92ff0000, 0x11178000, 0x4583c000, 0x0940e000, 0x4de1b000, 0x14338800, 0x3b3b8400, 0xb51f3a00, 0x90274b00, 0x2e3a3e80, 0xa59c8940, 0xa9e6f520, 0x4a194110, 0x9d8d9d28, 0xbecf7514, 0x462f2f2a, 0x129cba15, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x78000000, 0x24000000, 0x7e000000, 0x43000000, 0x6d800000, 0xb7c00000, 0xeee00000, 0x93900000, 0xcb380000, 0xbb240000, 0x48060000, 0x50770000, 0x525e8000, 0xce024000, 0x7b01a000, 0x29803000, 0xf9c04800, 0xd5e18400, 0xda11d200, 0x02fb9d00, 0x16c5de80, 0xb6149cc0, 0x2c8f0620, 0x079ab5b0, 0x1596ee28, 0xe04f01b4, 0xc0f9742e, 0x7fc618b7, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xf8000000, 0x6c000000, 0xce000000, 0x99000000, 0x28800000, 0xeac00000, 0x39a00000, 0xac100000, 0x15c80000, 0x08640000, 0x02060000, 0x5f350000, 0xbc2d8000, 0xf023c000, 0xc2522000, 0x28a89000, 0x94d72800, 0x6b5d0c00, 0xc4594e00, 0x41edd500, 0x98014b80, 0x1c03ffc0, 0x86037ae0, 0x9d02e870, 0x728072e8, 0xd1c2747c, 0x462394ea, 0xf7516d75, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xa8000000, 0xd4000000, 0x62000000, 0xd3000000, 0xcf800000, 0xcc400000, 0x28200000, 0xebf00000, 0x5b480000, 0x94040000, 0x2b660000, 0xc3350000, 0x85cc8000, 0x5da2c000, 0xd8b26000, 0xc2ea3000, 0x46b63800, 0x8e8d3400, 0xb803aa00, 0xbc004b00, 0xd6002380, 0x2103e040, 0xb480a360, 0xd7c2ea70, 0x8662fb68, 0x10d0ee7c, 0x7f3be96e, 0x030f5175, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xb8000000, 0xdc000000, 0x1e000000, 0x33000000, 0xd9800000, 0xfd400000, 0x09200000, 0xf7f00000, 0x8ef80000, 0xccac0000, 0xf7ce0000, 0x5e9f0000, 0x81d48000, 0x47204000, 0x0cf0a000, 0xd37ad000, 0xc3ed2800, 0x6bef2400, 0x9fefa200, 0x35eca700, 0x4cec3b80, 0xdc6dc840, 0x09afe5a0, 0x094f5a10, 0xe05c6da8, 0xb4b5ae14, 0xf57267a6, 0xbe3a6d17, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x6c000000, 0x56000000, 0xe1000000, 0x85800000, 0x05400000, 0x9da00000, 0x25b00000, 0xd8080000, 0x45140000, 0xe0f60000, 0x83670000, 0xe69e8000, 0x6da34000, 0x4db1e000, 0xd4095000, 0x63158800, 0x29f5cc00, 0x6ae67a00, 0xb5de5f00, 0x1100b180, 0xed810340, 0x0940c560, 0xbba11c30, 0xecb2ad68, 0x318a8034, 0x1657df6e, 0x9c565333, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xc8000000, 0x7c000000, 0xca000000, 0x6d000000, 0x76800000, 0x16c00000, 0xc6600000, 0x7c300000, 0x57580000, 0x6d3c0000, 0x049e0000, 0xee4f0000, 0x5ce48000, 0x1763c000, 0x60b2e000, 0x1c9a1000, 0xc5deb800, 0xda6e4c00, 0xc975b600, 0xeaeb9d00, 0x5f26ec80, 0x83828840, 0x94437f20, 0x86a078d0, 0xcd512728, 0xf8eb24d4, 0x2626a926, 0x730135d9, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xb8000000, 0xcc000000, 0xb6000000, 0x59000000, 0x8f800000, 0x09c00000, 0xbd200000, 0x1cf00000, 0xbfb80000, 0xa3940000, 0x10760000, 0x53270000, 0x6c2e8000, 0xfbe1c000, 0x87512000, 0x2d0b1000, 0x0ccc4800, 0xd0306c00, 0xc31bb200, 0x43a42500, 0xfb6cc980, 0x04817e40, 0x3d43eea0, 0xa862eff0, 0xa09086a8, 0xb52a93f4, 0x41bffcae, 0x4b481af9, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x48000000, 0xac000000, 0xfa000000, 0x9d000000, 0xb8800000, 0x7bc00000, 0xe7200000, 0x31100000, 0xc6a80000, 0x66740000, 0xe5960000, 0x42250000, 0x18dc8000, 0xb7e0c000, 0xd9b3e000, 0x81fa5000, 0x38bc3800, 0x9c100c00, 0x862ace00, 0x89b71100, 0x0cb4a580, 0xf03475c0, 0xadf79d60, 0x75d6f3b0, 0x85464568, 0xd6adafbc, 0x4b3a336e, 0x5d1f72bd, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x28000000, 0x64000000, 0xd6000000, 0x8b000000, 0xb7800000, 0x3bc00000, 0xd0e00000, 0x4d700000, 0xdb980000, 0x52ac0000, 0xa60e0000, 0xa45d0000, 0x14558000, 0x8b12c000, 0x3ba86000, 0x3496f000, 0x24732800, 0xd91b4400, 0x11eeba00, 0xfcae0500, 0xa10efe80, 0x81dc5740, 0xa2946f20, 0x4f701e90, 0x9e9aa728, 0xd22f6a9c, 0x604f552a, 0x5e7cdb91, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x58000000, 0x34000000, 0x46000000, 0xb1000000, 0x16800000, 0xeac00000, 0x1f600000, 0x03b00000, 0x0a680000, 0xccc40000, 0xe7e60000, 0x1df50000, 0x094f8000, 0xb350c000, 0x599ba000, 0xe10c7000, 0x10f1e800, 0x0c496c00, 0x1a55d600, 0x229d6d00, 0xbd092880, 0xb376d240, 0x678d29e0, 0xc2328df0, 0x5728e1e8, 0xd7e751fc, 0xf5f77fe2, 0x154f20f1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xe8000000, 0xe4000000, 0xda000000, 0xe3000000, 0xd9800000, 0xb8c00000, 0x34e00000, 0x79500000, 0x68880000, 0xc6ec0000, 0x794e0000, 0xe73d0000, 0x2f878000, 0x02724000, 0x0ebbe000, 0xc8f77000, 0x90489800, 0x920fd400, 0xd01c9200, 0x17b5a100, 0xe56afa80, 0x453f63c0, 0xd087ffe0, 0xddf0f350, 0xf37b07e8, 0x1096175c, 0x555aede2, 0x9626125b, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xb8000000, 0xcc000000, 0x26000000, 0xcf000000, 0x22800000, 0x18c00000, 0x77600000, 0x20700000, 0xe4480000, 0x25bc0000, 0x469e0000, 0x824d0000, 0xb1948000, 0x45d2c000, 0x0a5a2000, 0xd4061000, 0xe1290800, 0x10cd7400, 0x21579e00, 0xb6b00d00, 0xe82a6880, 0xad4d4540, 0xc3149660, 0x8511b790, 0x213b3e68, 0x6a74139c, 0x0661886e, 0x31f27a95, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x88000000, 0x04000000, 0x86000000, 0xc9000000, 0x1e800000, 0x64c00000, 0x84600000, 0xb6300000, 0x4b980000, 0xc7940000, 0xebb60000, 0x3a270000, 0x306d8000, 0x2612c000, 0xe00ae000, 0xdedff000, 0x20496800, 0xcd7e0c00, 0xbf99d600, 0x59969500, 0x0eb67c80, 0x76a57040, 0x93adcc20, 0x71f30d70, 0xaa7bc428, 0xbce43174, 0xcb0f9a22, 0xbfa05879, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x88000000, 0x4c000000, 0x32000000, 0x1b000000, 0x67800000, 0x4ac00000, 0x11e00000, 0x7a300000, 0xb1280000, 0x23f40000, 0x89560000, 0x9d450000, 0x113d8000, 0xbb934000, 0x6abb6000, 0x194d5000, 0x881b1800, 0x615cb400, 0x86628a00, 0x58f1d100, 0x7cca3e80, 0x53c6ea40, 0xe77ea8e0, 0xa733b830, 0xfbab50e8, 0x4bb51c3c, 0x2cf7a2ea, 0x48d42937, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xc8000000, 0xe4000000, 0x5a000000, 0xff000000, 0xf4800000, 0xfcc00000, 0xd4600000, 0xa4d00000, 0xa4f80000, 0xbecc0000, 0x1dee0000, 0x251f0000, 0xad958000, 0xf7114000, 0x9c186000, 0x5adef000, 0x2b771800, 0xb6012400, 0xa1015600, 0xc180f500, 0x0f436c80, 0xf02153c0, 0x32725a20, 0x714b3e10, 0xb566a228, 0x0f9aaa14, 0xae9d0c22, 0xe5d4cb17, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x38000000, 0xbc000000, 0xe2000000, 0x21000000, 0xff800000, 0xe2c00000, 0xe2e00000, 0x6cd00000, 0x41580000, 0xd8840000, 0xfa260000, 0x2b550000, 0xb7fc8000, 0x97934000, 0xfe79a000, 0x0a345000, 0x1bec5800, 0x75281c00, 0x45ac8200, 0x6b8b3900, 0xb6df5a80, 0xb623ddc0, 0x99310ea0, 0x050a33b0, 0x339e76a8, 0x9a003fbc, 0x3d038cae, 0x8d800ab3, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x28000000, 0x6c000000, 0xbe000000, 0x03000000, 0xb0800000, 0x3f400000, 0x76600000, 0x18900000, 0x38b80000, 0xe35c0000, 0x0ffe0000, 0x41cd0000, 0x46448000, 0x9f11c000, 0xbd7b6000, 0x637dd000, 0x788ca800, 0x1726e400, 0xb5010600, 0x2f830b00, 0x29c38a80, 0x5e23d4c0, 0x24724c20, 0xce699050, 0xa0070428, 0x78f2645c, 0x8f2b4a2e, 0xb5669b59, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xe8000000, 0x4c000000, 0x7e000000, 0x75000000, 0x92800000, 0xd7400000, 0xfee00000, 0x00900000, 0xbb780000, 0x6bf40000, 0x03660000, 0xb41f0000, 0x01e98000, 0xc78d4000, 0x0911e000, 0x93b95000, 0xd4d5e800, 0xa855dc00, 0x1216c600, 0x7a747300, 0x2fa45480, 0x893d90c0, 0x49da8e20, 0xca063570, 0x494c4828, 0x27324674, 0x38081ca2, 0x1e9fd6bf, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x78000000, 0xfc000000, 0xd6000000, 0xad000000, 0xfe800000, 0xcc400000, 0x0c600000, 0xb0900000, 0x04180000, 0x7bb40000, 0xe3260000, 0x933d0000, 0x5a8a8000, 0x0eac4000, 0x6010a000, 0x5959d000, 0xbf56c800, 0x02f4dc00, 0x1dc6f600, 0xa1ef0f00, 0x33f1e280, 0x950ad6c0, 0x1a6c49a0, 0x953385f0, 0xd72abfa8, 0x699c8afc, 0x203b5d26, 0x1d465c3f, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xe8000000, 0xc4000000, 0x42000000, 0x99000000, 0x3b800000, 0xc2400000, 0xa4600000, 0xdfd00000, 0xb1580000, 0x3f2c0000, 0x0afe0000, 0x06a50000, 0x70098000, 0xd9b7c000, 0x6cf16000, 0x876bf000, 0x90e53800, 0xbe6a3c00, 0x7b672200, 0xb4281300, 0x0b073e80, 0xc1f9a3c0, 0xe75f95a0, 0x87566790, 0xb6e0b7a8, 0x1e12749c, 0xdb79892a, 0xd29ed75d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x68000000, 0x2c000000, 0x22000000, 0x93000000, 0xa3800000, 0x4c400000, 0x2de00000, 0xca500000, 0xa9780000, 0xd6f40000, 0x9aa60000, 0x3edd0000, 0xc2ab8000, 0x90ce4000, 0x0a32e000, 0xfe69d000, 0x32ef1800, 0xf1c3b400, 0x28a2ea00, 0xc333c300, 0x1ae84080, 0xeb2d43c0, 0x95610520, 0x99906e70, 0xd2dbef28, 0x1647ad7c, 0x3c0dafa2, 0x9013eeb3, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x08000000, 0x9c000000, 0x46000000, 0x1d000000, 0x0c800000, 0xbbc00000, 0xaaa00000, 0x8c300000, 0xffa80000, 0x6e5c0000, 0x376e0000, 0xb8470000, 0x5bd98000, 0x0314c000, 0xafe3e000, 0x6a501000, 0xf6b9c800, 0xf3845c00, 0x697b7e00, 0xbb25d900, 0x5a49ef80, 0x570c4140, 0x4c57f6e0, 0xba80a810, 0x3ec288e8, 0x92227114, 0x3df2e762, 0x060af059, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xc8000000, 0xd4000000, 0x16000000, 0x6f000000, 0x90800000, 0xbcc00000, 0x96200000, 0x2b300000, 0x72f80000, 0x3a340000, 0xa6060000, 0xc87d0000, 0x148a8000, 0xf1ae4000, 0xe7606000, 0x0051b000, 0x08aba800, 0xb79c7400, 0x9c1a8600, 0xc9255d00, 0xdccf3180, 0xaa327b40, 0x517adda0, 0x34756cf0, 0x45e65ba8, 0x42ed31fc, 0xb503ea26, 0x85810ab7, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x58000000, 0x94000000, 0x42000000, 0xd3000000, 0xc5800000, 0xacc00000, 0xe3200000, 0x35d00000, 0xcaa80000, 0xbcb40000, 0x6e660000, 0xd34f0000, 0x683b8000, 0x04ff4000, 0x54a12000, 0x5210f000, 0x580ab800, 0xd7a6d400, 0xccee3200, 0x0babb900, 0x2236a180, 0x5b26e4c0, 0xa2afc760, 0xe3cb0c30, 0x3b07f568, 0xdaffb534, 0xd9a2d4ea, 0x5a9211ff, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xa8000000, 0x0c000000, 0xde000000, 0xab000000, 0x98800000, 0x8c400000, 0xbba00000, 0x7db00000, 0xf5080000, 0xaacc0000, 0x407e0000, 0x9bf50000, 0x7a788000, 0x77244000, 0x1e23e000, 0xbe735000, 0x4c686800, 0xf79f2400, 0x9de71600, 0x92c3cf00, 0x98e34580, 0x5c90c540, 0x69face60, 0x73e428d0, 0x51c3d868, 0x6c62e7dc, 0xbed01dee, 0xd15a6297, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x48000000, 0xec000000, 0xda000000, 0x71000000, 0x0f800000, 0xe4c00000, 0x0ce00000, 0x74500000, 0x56d80000, 0xa5ec0000, 0x1abe0000, 0x62e50000, 0x844a8000, 0x0ad6c000, 0x8282e000, 0xb943d000, 0x95227800, 0x3d335c00, 0xff4bb200, 0x1c55d900, 0xf5c2f680, 0x5360b5c0, 0x389307a0, 0x263bce90, 0x43beb5a8, 0xd167179c, 0x1288c326, 0x0b346255, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x38000000, 0x64000000, 0x7a000000, 0x61000000, 0x33800000, 0xb4c00000, 0x8f200000, 0xc2100000, 0x0b980000, 0x054c0000, 0x705e0000, 0x7f470000, 0x8a4b8000, 0xa575c000, 0x57422000, 0x63e03000, 0x19301800, 0x9b89bc00, 0x33d44200, 0x58900900, 0xa0d8c980, 0x28aee3c0, 0x6a6f94a0, 0xc24e0010, 0x7cddd6a8, 0xc3050914, 0xf3289f2a, 0x57052ad5, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x88000000, 0x24000000, 0xe2000000, 0x33000000, 0x74800000, 0x34400000, 0x8ba00000, 0x0d300000, 0xd9c80000, 0x24ac0000, 0x851e0000, 0x84970000, 0x0d988000, 0x84b5c000, 0x1668e000, 0x5b9cf000, 0x07d4b800, 0x20bb9400, 0xd6c63600, 0x9c839f00, 0x8040c580, 0x01a33740, 0xca30f760, 0xc74a7450, 0x07ee4168, 0x983c2b54, 0x8ee664e6, 0x2b73ec19, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xc8000000, 0xac000000, 0x2a000000, 0xd9000000, 0xa3800000, 0xb7c00000, 0x18a00000, 0x42700000, 0x18f80000, 0x0c840000, 0xb1760000, 0x8c4f0000, 0x15698000, 0x9bedc000, 0x2f99e000, 0xd256d000, 0x5dfdb800, 0x33303c00, 0xb619e200, 0x34954500, 0xeadffb80, 0x7c824040, 0xa7421ea0, 0x75e08b30, 0xde927ca8, 0x3de80e34, 0xe2ac6722, 0xcd789e7d, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x48000000, 0x34000000, 0x92000000, 0x21000000, 0xcf800000, 0xe6c00000, 0x6be00000, 0x7cf00000, 0xa8380000, 0x7edc0000, 0x7bae0000, 0x6e570000, 0x91e88000, 0xb5f5c000, 0xa3bbe000, 0x321fb000, 0x7d4e3800, 0xe3265c00, 0x10105200, 0xe8493100, 0x3ea6a280, 0x97d3f340, 0xac2b7aa0, 0x7494af50, 0x1c0ba8a8, 0x9a045e54, 0x3500ea26, 0x2d831d19, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x38000000, 0x84000000, 0x66000000, 0xb9000000, 0x90800000, 0xf1c00000, 0x9fa00000, 0x3f300000, 0x17f80000, 0xf2440000, 0xc7f60000, 0x9acd0000, 0xc8a98000, 0x802ec000, 0x4ffb2000, 0xc644b000, 0xe9f5e800, 0xcfcd2c00, 0x82285e00, 0x2aefb100, 0x9fd94380, 0x21371140, 0x00ed77a0, 0x6cd98130, 0xf2b4a9a8, 0x6aacf03c, 0x7538ca2a, 0x0e665179, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xa8000000, 0x2c000000, 0xd2000000, 0xeb000000, 0xab800000, 0xff400000, 0xfb200000, 0x8cb00000, 0x78c80000, 0x6c2c0000, 0x501e0000, 0xa4150000, 0xf8588000, 0x59d5c000, 0xb4ba6000, 0xe6865000, 0xeea2d800, 0xeaf01400, 0x73696a00, 0xcc5d0f00, 0xa8b55780, 0x41a83f40, 0x653f5b60, 0xa9a6f050, 0x2410b168, 0x4f3b3f5c, 0x71c706ee, 0x59809011, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xe8000000, 0x2c000000, 0x42000000, 0x11000000, 0x4a800000, 0x26c00000, 0xd9600000, 0xbdf00000, 0xdb380000, 0x25840000, 0x9bf60000, 0xb88d0000, 0x44ab8000, 0x54cfc000, 0x7b096000, 0x905e5000, 0x8dc29800, 0x86e0bc00, 0x1fb14600, 0xe79b0500, 0xf2947c80, 0xbd7ffd40, 0xfb93dca0, 0x8f485230, 0x5bff1aa8, 0x5f51973c, 0xe7298622, 0x3c8ffa75, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x88000000, 0x34000000, 0xb2000000, 0xb1000000, 0x94800000, 0x42c00000, 0x44200000, 0xf1500000, 0x0a480000, 0xcf4c0000, 0xaf9e0000, 0x01950000, 0x993a8000, 0x67554000, 0x571a6000, 0x7b043000, 0x3fd1b800, 0x7d8a1c00, 0xc5effe00, 0xe90e8d00, 0xe17fa180, 0x60e74ac0, 0xa02126e0, 0x9b507e50, 0x974a58e8, 0x25ceb35c, 0x525d1966, 0xe634899b, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xd8000000, 0x84000000, 0x02000000, 0xe7000000, 0x5a800000, 0x8b400000, 0x37e00000, 0x17b00000, 0xf5280000, 0x143c0000, 0x8a0e0000, 0x14e50000, 0x8f7b8000, 0x55a64000, 0x93982000, 0x1695b000, 0xa4f1f800, 0xd6c94400, 0x898f1e00, 0x34270b00, 0x0459f080, 0xef36a040, 0xc92177e0, 0x3d91cb90, 0x503be9e8, 0x8845809c, 0x9f29b962, 0xcf3cd0d3, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x18000000, 0xfc000000, 0x76000000, 0x21000000, 0x83800000, 0xdb400000, 0xe9600000, 0x56700000, 0x14080000, 0x6f8c0000, 0x417e0000, 0x02b70000, 0xa1998000, 0xa134c000, 0xeadba000, 0xf055d000, 0x90aac800, 0x8a5cec00, 0x2227b200, 0x3ea25700, 0xdad0fe80, 0xf5db2540, 0xf6d65a60, 0xe26aced0, 0x3f7e6868, 0x27b759d4, 0xd81ab6e2, 0xe5766c99, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x68000000, 0xcc000000, 0x12000000, 0x71000000, 0x6f800000, 0x97400000, 0x94a00000, 0xfdf00000, 0xd8680000, 0x956c0000, 0x7fde0000, 0xf3150000, 0x7b8a8000, 0x8c3dc000, 0x82456000, 0x4a12d000, 0x273a5800, 0xaff47c00, 0x065ad200, 0x3467b700, 0x45234980, 0x99b03440, 0xda489ee0, 0x0c5f50d0, 0xde572ce8, 0xb22a37dc, 0x5c4e3d66, 0xd46e7f99, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x28000000, 0x8c000000, 0xa6000000, 0x6b000000, 0x93800000, 0x39c00000, 0x21200000, 0x00500000, 0x7fb80000, 0x641c0000, 0xe18e0000, 0x81170000, 0xda5b8000, 0x05eec000, 0xb0256000, 0x7852d000, 0x9bb98800, 0x6e1ec400, 0xfc8c9a00, 0x51969500, 0xfc190580, 0xbb0d96c0, 0xfa57f920, 0x943816d0, 0xb9de0328, 0xcaac53d4, 0x9c468eaa, 0x75630119, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x38000000, 0x64000000, 0xbe000000, 0x89000000, 0x30800000, 0xf6c00000, 0xdb200000, 0xadd00000, 0x2ac80000, 0x6bdc0000, 0x36ce0000, 0x6a270000, 0x82a98000, 0xf16fc000, 0x23342000, 0xa8423000, 0x7ce00800, 0x92738c00, 0xe7d8be00, 0x4f344d00, 0x1a411d80, 0xb7e3dcc0, 0xe1f116e0, 0x2e98ea10, 0xbf5588e8, 0x14f29714, 0x941a9d62, 0xe695c7d5, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x98000000, 0xf4000000, 0x9a000000, 0xe5000000, 0x60800000, 0x29400000, 0x65600000, 0x0f900000, 0x02780000, 0xa77c0000, 0x93ae0000, 0x9db70000, 0x4bd98000, 0xc44cc000, 0x7265a000, 0x8241f000, 0xeae05800, 0x9b53ec00, 0x0ad95e00, 0xe6cf0300, 0xea270a80, 0xcda3f2c0, 0xb1303420, 0x68ca4d50, 0x1174ca28, 0xf778be54, 0xbffd98a2, 0x3eefa099, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xd8000000, 0x24000000, 0xee000000, 0xc1000000, 0xe5800000, 0x0ac00000, 0xf8a00000, 0xb8f00000, 0x70580000, 0x63140000, 0xbb260000, 0x4cdd0000, 0xfbba8000, 0x53854000, 0x9c2f2000, 0x97e33000, 0x8a90c800, 0xd00a6c00, 0xdbbd8a00, 0x70694900, 0xb0ec7780, 0xe2401640, 0x25e29220, 0xd191f3f0, 0x52883828, 0x79ff8afc, 0x758a87a6, 0xf17cf0bb, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x28000000, 0xac000000, 0x46000000, 0x21000000, 0x0c800000, 0x91400000, 0x70200000, 0x15f00000, 0x83480000, 0x3e0c0000, 0x20be0000, 0x7cd70000, 0xc6a98000, 0x269d4000, 0x2026e000, 0x4563d000, 0x7fd08800, 0x79bb6c00, 0x8cc7ce00, 0xed72e300, 0x30091f80, 0x952cce40, 0xc6cfec60, 0xc75f75d0, 0xff46c268, 0x95b246d4, 0x97e955e2, 0xb6bee49f, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xa8000000, 0x74000000, 0x6a000000, 0x2d000000, 0xb3800000, 0x31400000, 0x27200000, 0xef100000, 0xd1e80000, 0x3fb40000, 0x2fe60000, 0xc62f0000, 0xb4088000, 0x66c44000, 0x663de000, 0xdf62b000, 0xa9b05800, 0xaeb98c00, 0x7cffb200, 0x5503cf00, 0x9f83ef80, 0x674179c0, 0xa420dd60, 0xb390ae30, 0x0a2a8f68, 0xf055d134, 0xfb9738e6, 0x6c7624ff, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x18000000, 0xb4000000, 0xc6000000, 0x85000000, 0xb2800000, 0x4ec00000, 0x90e00000, 0x0f100000, 0x4cf80000, 0xafd40000, 0x24060000, 0xbf1f0000, 0xd65b8000, 0x83e64000, 0x218d2000, 0x33e27000, 0xa8902800, 0x78b89c00, 0x2df46600, 0xd1f55500, 0x0bf77a80, 0xc4f5c8c0, 0x7177d220, 0xd63461f0, 0x8b969428, 0x2e2744f4, 0x36efc6aa, 0xf8b1103b, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x48000000, 0x84000000, 0xde000000, 0x55000000, 0xdd800000, 0x96400000, 0x37e00000, 0x15100000, 0xca380000, 0x6dd40000, 0x7b860000, 0xfbdf0000, 0x45588000, 0x3b044000, 0x741e6000, 0xdafaf000, 0xfcf6c800, 0x3eb77c00, 0x6f55ba00, 0x0347cb00, 0xfefed880, 0xc66b9ec0, 0x868ef120, 0xfd80ecf0, 0x86432b28, 0x2fe2d7f4, 0x6913bba6, 0xd83a753f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x68000000, 0x84000000, 0x32000000, 0x1f000000, 0x04800000, 0xb6400000, 0xdc600000, 0xfed00000, 0xecb80000, 0x7b140000, 0xe4860000, 0xe4dd0000, 0xfd5a8000, 0x4a06c000, 0xf19e6000, 0x1bb8f000, 0x3b97f800, 0x80c56400, 0xb7be4600, 0x6f0b8700, 0x94fda280, 0x64e887c0, 0x1eeda620, 0x377196f0, 0xb0cb8028, 0xc55fe1fc, 0x849b5aa6, 0x9ea4c235, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x68000000, 0x94000000, 0x3a000000, 0x67000000, 0x1a800000, 0x39400000, 0x49e00000, 0x43100000, 0x29580000, 0xe1140000, 0x40460000, 0xf47d0000, 0x423b8000, 0xa746c000, 0x2efe6000, 0xdb79b000, 0x3ea69800, 0x05ece400, 0x6622fe00, 0xe5b36300, 0x22aad080, 0x88df5ac0, 0x9ec888a0, 0xcc0f1a70, 0xe53216a8, 0x6ce8c97c, 0x13bdde22, 0xa099b7b1, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x88000000, 0x84000000, 0x1e000000, 0xb7000000, 0xec800000, 0x4a400000, 0xfa600000, 0x05d00000, 0x9ad80000, 0x1bec0000, 0xcf7e0000, 0x89470000, 0x5c398000, 0x3c7fc000, 0x9bc6e000, 0x117b7000, 0xb29fc800, 0xd8547400, 0xebc07600, 0x05a3f700, 0xd671da80, 0xdfaa13c0, 0x26c4cba0, 0x9cf8e090, 0x875c5da8, 0x8af76794, 0x6133cf22, 0x084ac055, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x28000000, 0x74000000, 0xe2000000, 0xa1000000, 0x85800000, 0x70c00000, 0x95200000, 0x09500000, 0x08880000, 0xb8840000, 0x8c160000, 0x1a3f0000, 0xb4298000, 0xef14c000, 0xaebf6000, 0xc9693000, 0xaef57800, 0xf8cf1c00, 0x1db3fa00, 0x797ba100, 0x1d9e1980, 0x9b3b5ec0, 0xaefeb1e0, 0xdb0be870, 0x6b442be8, 0x4db67974, 0x1e2eca62, 0x0542fbb9, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x88000000, 0x9c000000, 0x5e000000, 0xe9000000, 0x52800000, 0x5d400000, 0x77600000, 0xb4b00000, 0xeb180000, 0x710c0000, 0x7ffe0000, 0xb0070000, 0x567b8000, 0xaebfc000, 0x5166e000, 0xb7c91000, 0xd924a800, 0x1c286c00, 0x71d6f600, 0xded14b00, 0x3f29aa80, 0x48560640, 0x46107d20, 0x3e8add90, 0x0c466b28, 0xaf998694, 0x394ee9aa, 0xb41f2cdd, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x38000000, 0x54000000, 0xe6000000, 0xcd000000, 0x4c800000, 0x70400000, 0x2a600000, 0x81900000, 0x21a80000, 0x59d40000, 0x67060000, 0x734f0000, 0x2ecb8000, 0xa8c54000, 0xaceea000, 0x77fa7000, 0xc3dfa800, 0xb9e3bc00, 0xe650be00, 0xe20af700, 0xaae65280, 0x431d22c0, 0x39c27f60, 0x1aa10cb0, 0x79b26168, 0xa95a8bb4, 0x146e1bea, 0x91ba5577, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x48000000, 0x9c000000, 0xea000000, 0xbb000000, 0x12800000, 0xbc400000, 0x1c600000, 0xdbf00000, 0xe6f80000, 0x59dc0000, 0x036e0000, 0x82770000, 0xf1988000, 0x48adc000, 0x6dd7e000, 0x61cb1000, 0x30067800, 0x19a1f400, 0x81526e00, 0x31288700, 0x0ab45280, 0x08bb8b40, 0x5abd53a0, 0xc41d0050, 0x8dcedda8, 0x23a59754, 0xf3f27726, 0xeaf92819, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0x4c000000, 0x52000000, 0xa1000000, 0x46800000, 0x30c00000, 0xd6e00000, 0xcf900000, 0x00280000, 0xc9340000, 0xb0e60000, 0x36ef0000, 0x56ab8000, 0x91f7c000, 0x0a046000, 0x3b7cd000, 0xdf835800, 0x52413c00, 0xd820b600, 0x7a708d00, 0x003a5a80, 0xf35e5ac0, 0xcdf0b360, 0x3e7a4730, 0xe97fe568, 0x3e81da34, 0x34c287ea, 0x78e26cfd, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xa8000000, 0x34000000, 0xa6000000, 0x37000000, 0x95800000, 0x12c00000, 0xee200000, 0xeb500000, 0x92680000, 0xc0240000, 0xa4360000, 0x6ebd0000, 0xf5ea8000, 0x33e64000, 0xa095e000, 0x86adb000, 0x95626800, 0xf5b0d400, 0x4e1bf200, 0x9f9e7100, 0x7f3b4d80, 0xf54dcac0, 0x0993ce60, 0xf449e570, 0x4f775c68, 0x885c647c, 0x059b99e6, 0x565ccab7, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x18000000, 0x5c000000, 0xde000000, 0xf3000000, 0x5d800000, 0x4a400000, 0x84a00000, 0x9d300000, 0x1e880000, 0x954c0000, 0xb3be0000, 0x05d70000, 0xf6088000, 0x6d8e4000, 0x1edd2000, 0x9506d000, 0xb492e800, 0x6d3b8400, 0x7c06e200, 0xd8104300, 0xb7f92580, 0x2c670b40, 0xce431e60, 0xa6a2a8d0, 0x60305c68, 0x980a7bd4, 0xc68eb1e6, 0xff5c2497, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xe8000000, 0x2c000000, 0xce000000, 0xb1000000, 0x70800000, 0xdac00000, 0xce200000, 0x57900000, 0xc7780000, 0x81d40000, 0xf8060000, 0xe99d0000, 0x5efa8000, 0x2f944000, 0xeee6e000, 0x3f2ed000, 0xe792a800, 0xef790c00, 0x4dd4de00, 0x0605bd00, 0xb09cb980, 0x027ac1c0, 0x3b550520, 0x91c6c9f0, 0x183dbb28, 0xfa29e4fc, 0xa08d4aa6, 0xe240f93f, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x18000000, 0xa4000000, 0x8e000000, 0x03000000, 0xba800000, 0xbd400000, 0x57a00000, 0xb0900000, 0x2f880000, 0xce840000, 0x75d60000, 0x42bd0000, 0xe20b8000, 0x0f454000, 0xb0342000, 0x1d0f3000, 0xf1534800, 0x2a69e400, 0x3136fe00, 0x568c2300, 0x7f908980, 0xc7084dc0, 0xcac5bce0, 0x3df7f570, 0x4aece2e8, 0xb7e1a67c, 0x16b30362, 0xb4db3fbf, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x58000000, 0x14000000, 0xce000000, 0xe3000000, 0x68800000, 0xb4c00000, 0xc0e00000, 0xf3700000, 0xc6480000, 0x7b740000, 0xfa460000, 0x7b2f0000, 0x93498000, 0x94f74000, 0x10052000, 0xc80ef000, 0x5e5b8800, 0xe20fa400, 0xcb583600, 0xed8c0d00, 0xb11afa80, 0x36af3940, 0x300b2160, 0x9a545430, 0xc657b768, 0x3455e934, 0xf555e5e2, 0x94d48477, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x48000000, 0xcc000000, 0x9a000000, 0x43000000, 0xb3800000, 0xea400000, 0x45a00000, 0x3e100000, 0x78f80000, 0x37e40000, 0x1a360000, 0x262f0000, 0xa5f98000, 0xd167c000, 0x3af5e000, 0x694d5000, 0xcf89f800, 0xf46f9400, 0x94584a00, 0x41773b00, 0x0f0c8980, 0xb02953c0, 0x997f0720, 0x17225f30, 0x50d32d28, 0xca9bf434, 0xeb15bca2, 0xf7ff63f5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x08000000, 0x3c000000, 0xf2000000, 0xef000000, 0x0e800000, 0x1c400000, 0x8c600000, 0xf2500000, 0xd8e80000, 0xdcc40000, 0x62560000, 0xff9d0000, 0x60ea8000, 0xd8c4c000, 0x5455e000, 0xc69d9000, 0x47699800, 0xeb044400, 0xd7f5ae00, 0x456e6700, 0xf373e280, 0x8d59cdc0, 0xcfbd3560, 0x2edabef0, 0x0a7ffb68, 0x747989fc, 0xbe0e61e6, 0xfba0903d, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xd8000000, 0xf4000000, 0xa6000000, 0x71000000, 0x5c800000, 0x96400000, 0x76600000, 0xf5d00000, 0x0be80000, 0xd8b40000, 0x5da60000, 0x1d6f0000, 0x41e98000, 0x1bb7c000, 0x6627a000, 0x6eaff000, 0xd14ba800, 0x5c474c00, 0x397d8e00, 0x65a11f00, 0x95735a80, 0x241a1bc0, 0xbbef2f60, 0xdca8c530, 0x7a548168, 0xb235ea34, 0x22e5d3e2, 0x638c4df5, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x28000000, 0x94000000, 0xc2000000, 0x1f000000, 0x28800000, 0x5bc00000, 0x5d600000, 0x71300000, 0xa6080000, 0xdd1c0000, 0x406e0000, 0x88470000, 0x82c98000, 0x78ff4000, 0xd29ce000, 0xff2d3000, 0x50e47800, 0xd7986400, 0x72443600, 0x51cb0100, 0x8e7c8080, 0xf05cda40, 0x7fcc6f60, 0xd997b190, 0x9db33968, 0xc7c9c094, 0xb37ea1e2, 0x57df0ed7, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xd8000000, 0xf4000000, 0xae000000, 0x1f000000, 0x5c800000, 0x82400000, 0x68a00000, 0x3bf00000, 0x9c480000, 0x3dd40000, 0x77e60000, 0xd5cd0000, 0xb50b8000, 0xc7f7c000, 0xe155a000, 0x35a7f000, 0x1d6d8800, 0x1ef8d400, 0x83bf1600, 0x28817700, 0xec419180, 0xd7a3b040, 0xf7711a60, 0xc608b6b0, 0xa1762c68, 0xe214f1bc, 0x568415e2, 0xd45fa5f5, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x58000000, 0xf4000000, 0x4a000000, 0x13000000, 0x35800000, 0xbb400000, 0xa8200000, 0xef500000, 0xd1680000, 0x436c0000, 0x7dfe0000, 0x64750000, 0x4a2b8000, 0x1b4d4000, 0x6aad2000, 0x711f7000, 0x1b441800, 0x81b1f400, 0x71599200, 0x93768700, 0x9da9c380, 0xbf0f24c0, 0x790cba60, 0x240f6a50, 0xb08d8868, 0xe94edd5c, 0xddaef3e2, 0xc69e3d9f, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x68000000, 0xb4000000, 0xca000000, 0x71000000, 0x79800000, 0xf0c00000, 0xe8a00000, 0xcd300000, 0x2c580000, 0xbd8c0000, 0xe2fe0000, 0xee450000, 0xb7198000, 0xe8ec4000, 0x10ece000, 0xdcedb000, 0x1aedd800, 0x8dee7c00, 0x936cea00, 0x152ed100, 0xcfcf9f80, 0x121c8940, 0x92961d20, 0xd6108a90, 0x80a99728, 0xd0f6ab9c, 0xfa80b0aa, 0x1440aed3, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x58000000, 0xfc000000, 0x22000000, 0x75000000, 0x87800000, 0xccc00000, 0x54a00000, 0x29d00000, 0x3e380000, 0xc37c0000, 0x8eee0000, 0x96370000, 0xe9788000, 0x291ec000, 0x3e9ca000, 0xea5dd000, 0xa2fe9800, 0xb92e6c00, 0xaa16e200, 0x12eaa900, 0x72c4a780, 0xc550cac0, 0x82799f20, 0x599e3350, 0xf0dd5d28, 0xbdbc8a54, 0xb74d42a6, 0x24663c95, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x68000000, 0x84000000, 0x52000000, 0x49000000, 0x5d800000, 0x86400000, 0x7c200000, 0xc4b00000, 0x1fa80000, 0xfafc0000, 0xfa8e0000, 0x19c70000, 0xe96b8000, 0xbf1ec000, 0x155c6000, 0xdf7ff000, 0xf0cd7800, 0x43e6bc00, 0x8ed87a00, 0x58373b00, 0xe261a780, 0xc4916740, 0x4518b6e0, 0xaa56d490, 0x2ef12ce8, 0xf58bdf94, 0x054c136a, 0x21a634d9, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xc8000000, 0x54000000, 0xd6000000, 0x51000000, 0x3a800000, 0xe5400000, 0x0e200000, 0x15d00000, 0x8bd80000, 0x8ef40000, 0x27e60000, 0xe2dd0000, 0x45198000, 0xbf17c000, 0xe955e000, 0xaaf73000, 0xc9e4a800, 0x1fde8c00, 0x25981600, 0x41578b00, 0x0ef4af80, 0xe7e6d6c0, 0xc2df46a0, 0x5519b0f0, 0x771530a8, 0xbd57cbfc, 0x7cf7572a, 0x98e6613d, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xa8000000, 0x54000000, 0x3a000000, 0xfb000000, 0x3e800000, 0xaa400000, 0x11a00000, 0xb4d00000, 0xb6980000, 0xe05c0000, 0xcd4e0000, 0x83b70000, 0xe75b8000, 0xdc3f4000, 0x6bfee000, 0x729e3000, 0x83ac9800, 0x49471400, 0x92d01e00, 0xf3990f00, 0x27df4d80, 0xee8c08c0, 0xc0d741a0, 0x7d680f50, 0x30543fa8, 0xe62b7054, 0x6c748a2a, 0x223a1c9f, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x28000000, 0xa4000000, 0xaa000000, 0xa3000000, 0xc1800000, 0x07400000, 0xc7200000, 0x0dd00000, 0x56880000, 0xa8e40000, 0xf6160000, 0x9f4d0000, 0x3e208000, 0x9752c000, 0x7c496000, 0x76867000, 0x1de69800, 0x0297b400, 0xac8fa200, 0xaac15700, 0x1e626780, 0x8bf0c6c0, 0x8ddaa9e0, 0xbaaddaf0, 0x999393e8, 0xc82b39fc, 0x5e76566e, 0x51bea83d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x08000000, 0x44000000, 0x8a000000, 0x7f000000, 0x88800000, 0x70400000, 0xe7e00000, 0xb9b00000, 0xdbb80000, 0xa55c0000, 0x270e0000, 0xf3050000, 0x94e38000, 0x9f334000, 0x4ef86000, 0x0d3ff000, 0x2a7d1800, 0x711fc400, 0x9aee7600, 0x2db75f00, 0x3bd91c80, 0x8c2ec840, 0x3f174fa0, 0x3a0a3950, 0xe2e421a8, 0x5452a25c, 0xdd0b4b22, 0x56673517, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x08000000, 0xf4000000, 0x12000000, 0xd3000000, 0x3d800000, 0x8cc00000, 0x0de00000, 0x75b00000, 0xb5480000, 0x223c0000, 0x206e0000, 0x57970000, 0x37618000, 0xe6f24000, 0x4f6b6000, 0xe3ee3000, 0x7655b800, 0xea03d400, 0x6f007200, 0x7b82c900, 0x3dc31280, 0xeb602240, 0x30f0ac60, 0x26688f10, 0x896d6668, 0xdd159214, 0x4c2006e2, 0x38d07953, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x58000000, 0xcc000000, 0x02000000, 0x51000000, 0xca800000, 0xc8c00000, 0xfc200000, 0x0a100000, 0xa9a80000, 0x0b6c0000, 0xab5e0000, 0xb7e70000, 0x5ca28000, 0x47d24000, 0x310a2000, 0x2abc9000, 0x3d545800, 0x78d97c00, 0x68b6e600, 0x5c680d00, 0xafcd5980, 0xb08d2bc0, 0x0cef8660, 0x031c0f50, 0x26053868, 0x1e117e54, 0x27a887ee, 0x386f589f, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x78000000, 0xdc000000, 0x82000000, 0x33000000, 0xe5800000, 0x79400000, 0xc0600000, 0xc3f00000, 0x5b880000, 0x7aec0000, 0x8e7e0000, 0x7d870000, 0x0ca08000, 0xa2d0c000, 0xf4182000, 0x8894d000, 0x381a9800, 0x3294b400, 0x3718d200, 0xc515ff00, 0x05591280, 0x3cf5db40, 0x3deb0860, 0x941f7650, 0x61774268, 0x38a93d54, 0xa67e02e6, 0x7985d91d, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x18000000, 0xb4000000, 0x1e000000, 0x07000000, 0xa5800000, 0x68400000, 0xe2a00000, 0xfa900000, 0x29e80000, 0xab540000, 0x28660000, 0xac9f0000, 0x0b608000, 0x66704000, 0xcad92000, 0xdfac7000, 0x7798c800, 0xc58fb400, 0xa1cb7200, 0xc004eb00, 0xd96d5d80, 0x02fad1c0, 0x54fe5f60, 0x36906cb0, 0x73ebe568, 0x4a5433b4, 0x8ee54ae6, 0x675e497f, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x48000000, 0x74000000, 0xb2000000, 0x79000000, 0x8a800000, 0x7f400000, 0xf8a00000, 0x50d00000, 0x95980000, 0xfb840000, 0x18f60000, 0x6e3f0000, 0xd5e38000, 0xe170c000, 0x77c8e000, 0x7d5db000, 0x95d03800, 0x991bfc00, 0x6fc58600, 0x43d57300, 0x832e1580, 0xb3990cc0, 0x0086ffa0, 0xd377ff30, 0xf7fd41a8, 0xdc027034, 0xf603522a, 0xf301cff1, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0xb4000000, 0xc2000000, 0xc5000000, 0xa9800000, 0xebc00000, 0xac200000, 0xb8300000, 0xb6480000, 0x001c0000, 0xb30e0000, 0x61f70000, 0xede28000, 0xb512c000, 0x8df9e000, 0xbc96b000, 0xfcb1f800, 0xf00bcc00, 0xfdff3a00, 0xce1e5d00, 0x380e9980, 0x0377af40, 0x04a14160, 0x6073cd90, 0x68a98368, 0x5b8d5c94, 0xd9b4a0ee, 0xa3016edd, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x78000000, 0xf4000000, 0x96000000, 0xe9000000, 0xc8800000, 0xb0400000, 0x67200000, 0x9d900000, 0x76580000, 0xe0cc0000, 0xf17e0000, 0x7d370000, 0xe2608000, 0x8830c000, 0xa0882000, 0xae347000, 0x91e26800, 0x87f32c00, 0x4a695e00, 0x36440700, 0x264b9f80, 0x5c57fbc0, 0x21d1eba0, 0x3378c810, 0xe25cdda8, 0x36a4e314, 0x9d389c26, 0x307cdfdd, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xc8000000, 0xe4000000, 0x06000000, 0x2b000000, 0xb4800000, 0x72c00000, 0xc1e00000, 0x74300000, 0xd4180000, 0x23d40000, 0x52860000, 0x086f0000, 0x3a408000, 0xc9214000, 0xa4d36000, 0xe5ab7000, 0x308ca800, 0xbff12400, 0x047b6600, 0xbea43500, 0x773dde80, 0x0fab3c40, 0x598c9720, 0x367057f0, 0xd13bd928, 0x950406f4, 0x522e01a6, 0x43607fbb, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x58000000, 0x8c000000, 0xb6000000, 0x41000000, 0x15800000, 0x7f400000, 0xe4a00000, 0x47d00000, 0x96080000, 0x40340000, 0x8ec60000, 0xbc5d0000, 0xb0c08000, 0x1ce04000, 0xcff22000, 0x87199000, 0xa3dd8800, 0xa083ec00, 0x40c08a00, 0xe4e12f00, 0x93f0f980, 0xd91a10c0, 0x36dee5e0, 0x8f029fb0, 0xc88367e8, 0x54c01cbc, 0xbee1346e, 0xd4f2b377, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x78000000, 0x0c000000, 0xa2000000, 0x6d000000, 0x73800000, 0x78400000, 0x34200000, 0x9c900000, 0x09d80000, 0x68940000, 0x6fa60000, 0x38ad0000, 0x3cc38000, 0x9ee3c000, 0xa1712000, 0x242b9000, 0xc27f5800, 0xe6390c00, 0xa065f200, 0xf2cd1b00, 0x8f73bf80, 0x2b2b23c0, 0x7cfe75a0, 0x7df8df70, 0x94075fa8, 0x567f087c, 0xb8383222, 0x2766a0b5, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x18000000, 0x1c000000, 0xd6000000, 0xdd000000, 0x94800000, 0x87c00000, 0x12a00000, 0x24300000, 0x1cf80000, 0x013c0000, 0xad2e0000, 0xf3270000, 0x4ec28000, 0x1422c000, 0xd4f3a000, 0x01da5000, 0xf34f4800, 0xac365c00, 0x95497e00, 0x1487b900, 0x4a71c780, 0xad19e540, 0x586d39a0, 0x13478fd0, 0x18d18fa8, 0xe928aad4, 0xd494962e, 0x0a7ba69d, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x88000000, 0x0c000000, 0xa2000000, 0x89000000, 0x4e800000, 0x92c00000, 0x5ca00000, 0x4fd00000, 0x52380000, 0x3dc40000, 0x8e360000, 0xca1d0000, 0xaec18000, 0xb6a14000, 0xead06000, 0x0eb8d000, 0xae049800, 0x90169c00, 0xb50c9600, 0x2958d500, 0x8a374380, 0xa41c66c0, 0xa5c0d520, 0xc12398b0, 0xbe915b28, 0xccd891bc, 0x1f74eeaa, 0x04fdf277, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x68000000, 0xac000000, 0xea000000, 0x13000000, 0xf7800000, 0x2e400000, 0x8a200000, 0x25d00000, 0xa4080000, 0xad6c0000, 0xd31e0000, 0x95870000, 0x7a408000, 0x0423c000, 0xc0d36000, 0x928a5000, 0xa3acb800, 0xc6ff5400, 0xed373a00, 0x953bab00, 0xf1568f80, 0xbecb66c0, 0xd68f7fe0, 0x1ead8ad0, 0x247c7de8, 0x2df6b5d4, 0x85d8a866, 0xef672811, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xb8000000, 0xdc000000, 0xb6000000, 0xd5000000, 0x0a800000, 0xc2c00000, 0x6b200000, 0x7ff00000, 0xf4280000, 0x9d140000, 0xf9460000, 0x2b5f0000, 0xcac08000, 0x3f20c000, 0xddf32000, 0x632bd000, 0x90974800, 0x8e04fc00, 0xeb3ea600, 0xc350f500, 0x179a4d80, 0x62dc7840, 0xe78253e0, 0x54421330, 0xffe33de8, 0x51d2da34, 0x395af666, 0x77fe877d, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xd8000000, 0x1c000000, 0x4e000000, 0xb5000000, 0x1f800000, 0x81c00000, 0x86200000, 0xc4b00000, 0x80780000, 0x05ac0000, 0x31be0000, 0xc5370000, 0xc2038000, 0x6301c000, 0x9683a000, 0xc0435000, 0x6ae22800, 0x41139c00, 0x8b0b9200, 0xb6f4ad00, 0xef226180, 0xf5320d40, 0x84bb8ba0, 0x540d4590, 0xb0cfb1a8, 0x916cb494, 0xf81e622a, 0x784484d5, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x78000000, 0xf4000000, 0x0e000000, 0x8b000000, 0xf7800000, 0xc9400000, 0xc1200000, 0xecd00000, 0x4b580000, 0x3e540000, 0x63260000, 0xc06d0000, 0xd8028000, 0x4402c000, 0x06002000, 0x97007000, 0x75820800, 0xb841c400, 0xb3a1ca00, 0x5912d700, 0xb4bbff80, 0xdae792c0, 0x058f9aa0, 0x59b36770, 0xce28d8a8, 0xd91fb47c, 0x7d484d26, 0xcb6c41b5, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xc8000000, 0x2c000000, 0x2e000000, 0xf1000000, 0x53800000, 0x97c00000, 0x3be00000, 0x09900000, 0xf3580000, 0xd9a40000, 0x7d560000, 0xa9df0000, 0xac028000, 0x6e00c000, 0x9102e000, 0x4383d000, 0x5fc32800, 0x17e3cc00, 0x27923200, 0x0258d500, 0x8a27fe80, 0xea9496c0, 0x923c04a0, 0xa5920db0, 0x9d599ea8, 0x48a6d4b4, 0x3ed4322e, 0xf61d8775, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xe8000000, 0x8c000000, 0x5a000000, 0x47000000, 0xe4800000, 0x4a400000, 0x6e600000, 0xbcd00000, 0xa7880000, 0xf10c0000, 0x343e0000, 0x8fa50000, 0x24038000, 0xb6024000, 0x4d02e000, 0xbb825000, 0xcac0f800, 0xf2224400, 0xcfb3e600, 0xb8dba700, 0xf8470280, 0xe11063c0, 0x692ad4e0, 0xb0fd2950, 0xc4844ae8, 0x3e338a5c, 0x4d19ce62, 0xdae45e93, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xe8000000, 0x6c000000, 0xba000000, 0xf1000000, 0xd5800000, 0x16400000, 0x94200000, 0x02500000, 0x78b80000, 0xdc3c0000, 0x74ce0000, 0x8ce50000, 0xb7818000, 0x83424000, 0xc7a2e000, 0xc713d000, 0x4c18f800, 0xcbac9c00, 0xc5147a00, 0xe229cb00, 0x7a66df80, 0x294140c0, 0x4ea2db20, 0xc6900b50, 0x1459d928, 0x908e1c5c, 0x35c61caa, 0x1252079b, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x28000000, 0xb4000000, 0x66000000, 0x0f000000, 0x75800000, 0xde400000, 0xce200000, 0x91b00000, 0x54c80000, 0xaafc0000, 0xfb2e0000, 0x18750000, 0xe3f18000, 0xd0eac000, 0xbe4d6000, 0x7f653000, 0xec4ae800, 0xa03cf400, 0x55cfb200, 0xf2267300, 0xa5ea6780, 0xd6cf8f40, 0x9da6e960, 0xd6aa6410, 0x7c6ed368, 0x34d5d31c, 0x3581eeea, 0x3e40db59, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x58000000, 0x3c000000, 0x8e000000, 0x55000000, 0x43800000, 0x28c00000, 0x11600000, 0x47b00000, 0x20980000, 0x31ec0000, 0xd3fe0000, 0xbbb70000, 0x30728000, 0x657a4000, 0xfe1e2000, 0x50455000, 0x61c8a800, 0xd4071c00, 0x54eb2200, 0x36965900, 0x1ee3f880, 0x9970f040, 0x88fa5520, 0x53df3110, 0xeaa7ff28, 0x6abb2414, 0x57ff8dae, 0xf9b6915f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x18000000, 0xac000000, 0x8e000000, 0x83000000, 0xec800000, 0xe9400000, 0x47200000, 0x9bb00000, 0xf2380000, 0x1d240000, 0x74f60000, 0xdc5d0000, 0x3ff38000, 0xba9ac000, 0xf355a000, 0xe0af9000, 0xa9e9e800, 0x008f0400, 0x84d84600, 0xcaf63b00, 0xf75f5b80, 0x17721f40, 0xb9d96ea0, 0x0d771cb0, 0x369d60a8, 0x5311b3bc, 0xdc4b9522, 0x297e93f1, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xa8000000, 0x94000000, 0xd2000000, 0xe3000000, 0xa4800000, 0x7f400000, 0xa4e00000, 0x13300000, 0x30a80000, 0xe4840000, 0xd0160000, 0xb16f0000, 0x37708000, 0x4cc8c000, 0x2ef76000, 0xe55cb000, 0xa958b800, 0x980c1400, 0x10819600, 0x9d410300, 0x9fe28c80, 0x1bb07a40, 0xa1e879e0, 0xe5645270, 0x56a637e8, 0xb905f574, 0xacd59566, 0x544c983d, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x78000000, 0x04000000, 0x32000000, 0x5d000000, 0xa7800000, 0xee400000, 0x60200000, 0xfc700000, 0x0b880000, 0xa79c0000, 0x678e0000, 0xed570000, 0x7ab28000, 0x8f6bc000, 0xba0f2000, 0xb214b000, 0x93123800, 0x26592c00, 0x6125e200, 0xf938f300, 0xe4f45780, 0x43829040, 0x4c41a360, 0x2522cb90, 0x8ff15968, 0xafcba494, 0x9ebcd4ee, 0x0e7febd9, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x88000000, 0x54000000, 0x76000000, 0x59000000, 0xda800000, 0xa9c00000, 0x36a00000, 0x60700000, 0xef780000, 0x4e340000, 0x0f260000, 0x9b8d0000, 0x46328000, 0xc099c000, 0x2a24e000, 0x130c3000, 0xf8f3a800, 0xf9b96c00, 0x93151600, 0x1815c900, 0x15976780, 0x53d5f440, 0xec359aa0, 0xe024eaf0, 0xf80fc4a8, 0x65707ffc, 0xd7f81d26, 0x28f42eb9, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xd8000000, 0xc4000000, 0xfa000000, 0x0d000000, 0xc6800000, 0xdb400000, 0x87e00000, 0x88f00000, 0x93380000, 0x8da40000, 0x8ff60000, 0x58df0000, 0x2b308000, 0x78994000, 0xa9372000, 0x79fdb000, 0xc2e09800, 0xe2724c00, 0x4e788600, 0xc944e300, 0xee841880, 0x1f24a940, 0xc6b52ca0, 0x2e3e37b0, 0xab4212a8, 0x1fe128b4, 0xacf01426, 0x99382efb, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x78000000, 0xbc000000, 0xe6000000, 0x7d000000, 0x5d800000, 0x07c00000, 0x7d600000, 0xa0f00000, 0xa8a80000, 0x3cac0000, 0x1bfe0000, 0x73470000, 0xa0708000, 0x02ebc000, 0x8e0f2000, 0x526c5000, 0x591f8800, 0x13741c00, 0xe33ada00, 0xc1f6bd00, 0xa67b4c80, 0x21d7a140, 0xeaa928e0, 0x0bad79d0, 0x457d5ae8, 0xb80488d4, 0x1953c466, 0x19ba4891, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x78000000, 0x04000000, 0xfe000000, 0xcf000000, 0xbf800000, 0xb0c00000, 0x16e00000, 0x41d00000, 0x61980000, 0xdbdc0000, 0xd32e0000, 0x4a070000, 0x29508000, 0x9ad84000, 0x1bfca000, 0xff1d3000, 0x53cd0800, 0xe8d45400, 0xc5487a00, 0xbcc6a100, 0x54b2d680, 0xca8a57c0, 0xcda66ea0, 0xf1a10450, 0x8bf1bca8, 0xe4a9c154, 0x06969826, 0x9be9239f, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xf8000000, 0xd4000000, 0x1e000000, 0x13000000, 0xee800000, 0x3d400000, 0x61200000, 0x64d00000, 0xb5a80000, 0x744c0000, 0x47fe0000, 0x1d250000, 0x03508000, 0x336ac000, 0x71ae2000, 0x67cef000, 0xaf3dc800, 0xe3c7e400, 0xe1e34e00, 0x76322300, 0xfd1bbb80, 0x2c146ac0, 0xcec84560, 0x513d4ad0, 0x20c6e368, 0x97637ddc, 0x8f735eee, 0x7a38101d, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xb8000000, 0xec000000, 0x82000000, 0x17000000, 0xf6800000, 0x27400000, 0xada00000, 0xb1100000, 0x8db80000, 0x3d0c0000, 0x2dfe0000, 0x20750000, 0xd5918000, 0x75f94000, 0x122ca000, 0x65ad9000, 0x2d6e5800, 0x540c6400, 0x867ece00, 0x92b6bb00, 0x77f3e180, 0x630af7c0, 0x8ea70020, 0x37c81890, 0x2dc53628, 0x8eba579c, 0x458fc1aa, 0x0fbf3f57, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x98000000, 0x1c000000, 0x66000000, 0x87000000, 0xa3800000, 0x6e400000, 0xe6200000, 0xc1300000, 0x6bd80000, 0xe0b40000, 0x88e60000, 0x40af0000, 0x37308000, 0x34dac000, 0xbf35a000, 0x90a45000, 0xb98c8800, 0x49837400, 0x5743ca00, 0x3ea08b00, 0x7af2ff80, 0xfcbaad40, 0x7826c720, 0x2a4e2370, 0xaae22528, 0x3dd28c74, 0xf90918a6, 0xce3e1e35, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x18000000, 0x94000000, 0x3a000000, 0xf9000000, 0xda800000, 0x4fc00000, 0xd3a00000, 0x3b100000, 0xeeb80000, 0x5c8c0000, 0x90fe0000, 0x99770000, 0xbb108000, 0xaebb4000, 0xbc8e2000, 0xe0fdf000, 0x8175d800, 0x2f11dc00, 0x94bb2600, 0x458f9100, 0x3a7ceb80, 0xceb745c0, 0xfcb1c420, 0xafa90290, 0xab371a28, 0x66f1bf94, 0x5e4b8fa6, 0x65c4f753, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x38000000, 0xf4000000, 0xa2000000, 0x7f000000, 0xbf800000, 0x18c00000, 0x02e00000, 0xef900000, 0x7c280000, 0x778c0000, 0xf73e0000, 0x5ae50000, 0x97928000, 0xa82b4000, 0xc58ca000, 0x403ef000, 0x2964b800, 0xd9522400, 0x77caca00, 0xea9fc100, 0x9b546680, 0x44cb6ec0, 0xc31e6160, 0xbe945ad0, 0x76aab368, 0xb3ce4fdc, 0x2c9c27e6, 0x4e568413, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x38000000, 0x54000000, 0xee000000, 0xb9000000, 0x79800000, 0x9ac00000, 0xaa600000, 0x7f100000, 0x97180000, 0x4f840000, 0xcb360000, 0x0bdd0000, 0x6c118000, 0x119a4000, 0x29c5a000, 0x70167000, 0x7f6f0800, 0x54f98c00, 0x0256fa00, 0xca4ec900, 0xc9485480, 0x0b3cb6c0, 0x2f4245a0, 0x3aa00430, 0x9a7017a8, 0x0c88313c, 0xedde312a, 0x591082fb, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x18000000, 0x6c000000, 0x7e000000, 0x91000000, 0x87800000, 0xb7c00000, 0x56e00000, 0xf8d00000, 0x5f480000, 0x54e40000, 0x4a960000, 0xcc2d0000, 0x49b18000, 0xe05bc000, 0x754ca000, 0x82a39000, 0xd3f32800, 0x527a8c00, 0x8bfde200, 0xf878e500, 0xd8ff2a80, 0xa8fb1fc0, 0x05bec1e0, 0xa85b33f0, 0xe14d2be8, 0xa0a10afc, 0x34f06b6a, 0x30fbec3d, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x18000000, 0x74000000, 0x9e000000, 0xd3000000, 0x8b800000, 0xccc00000, 0x3ea00000, 0xe5100000, 0x2d780000, 0xa35c0000, 0xc7ae0000, 0x59a50000, 0xea308000, 0xf1aac000, 0xec05a000, 0x50a3f000, 0xfe10c800, 0xaaf96400, 0x959f5a00, 0xac0c3100, 0x90353780, 0x1e0aa5c0, 0x73965720, 0x7b9822d0, 0x0dace528, 0xa4a447dc, 0xdab3e0ae, 0xcae8471d, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xf8000000, 0xf4000000, 0xe2000000, 0x05000000, 0xcd800000, 0x16c00000, 0x3d200000, 0xcb900000, 0xb9980000, 0x68ec0000, 0x011e0000, 0x02f70000, 0xb4328000, 0xb0484000, 0x8916a000, 0x5282f000, 0x6a42b800, 0x6461cc00, 0xd5706a00, 0x7aa89900, 0xf8244980, 0x0f4a09c0, 0xa59428a0, 0xc3c0dd90, 0x78a2daa8, 0xb1533894, 0xa2bae12e, 0xbc7e9457, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xb8000000, 0x2c000000, 0xce000000, 0x59000000, 0xbc800000, 0x6e400000, 0x05600000, 0x3c700000, 0x69b80000, 0x88340000, 0x77e60000, 0xeb0f0000, 0x04918000, 0x5b0bc000, 0x4cac2000, 0x1bc01000, 0x2fa06800, 0xdb506c00, 0x8ea8ee00, 0x3cfccf00, 0x06e9ee80, 0xb49f6540, 0xc418a6a0, 0x3464c5f0, 0x14cd80a8, 0x8133b6f4, 0x3358c822, 0x6d8460b5, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xe8000000, 0x9c000000, 0xc2000000, 0xbd000000, 0x62800000, 0x9b400000, 0xdb600000, 0x14d00000, 0xd3f80000, 0x97bc0000, 0xc5ce0000, 0x14c70000, 0x0c318000, 0xbce8c000, 0x19666000, 0x2f409000, 0x6563d800, 0x1bd10c00, 0x347b3600, 0x1a7eb300, 0xdbecfa80, 0xa4755bc0, 0x149b0520, 0x016c0850, 0x0b340b28, 0x31fbe754, 0xbabe7fa2, 0xef4d9399, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xd8000000, 0x44000000, 0xc2000000, 0xc5000000, 0xaf800000, 0xc7c00000, 0x29e00000, 0x2fd00000, 0xa6880000, 0xc4140000, 0xd8660000, 0x921f0000, 0xb5318000, 0x69d8c000, 0xf3dea000, 0x0bd33000, 0x54887800, 0xa9178c00, 0x3be7e200, 0x0bded500, 0xdfd19680, 0xee88cfc0, 0xf81736e0, 0x8e64bb30, 0x4d1f8ce8, 0x9bb21234, 0xc3992062, 0xd8ffb4f9, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xe8000000, 0x44000000, 0x12000000, 0xd3000000, 0x3f800000, 0x9e400000, 0x94600000, 0xf7d00000, 0x81880000, 0xc5ec0000, 0x9d9e0000, 0x26e70000, 0xd4b18000, 0xabd94000, 0x4127e000, 0x07927000, 0x28ebf800, 0x70bc9400, 0x60d73a00, 0xbba96b00, 0x0e5e4680, 0x0fc5ffc0, 0xc082a4e0, 0xb7c300d0, 0x6b2006e8, 0x3f31cfd4, 0x3f9b6262, 0x0a44bf1f, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xd8000000, 0x74000000, 0x82000000, 0x73000000, 0x8f800000, 0x51400000, 0x39a00000, 0x00500000, 0x1c180000, 0x1fac0000, 0xd39e0000, 0x1cb70000, 0x15b08000, 0xdf6bc000, 0x4425a000, 0xb849f000, 0x19b5b800, 0x2b339400, 0x92a9ba00, 0xf3465700, 0x08f90d80, 0x485dcac0, 0xaad50ba0, 0x31827990, 0xac4229a8, 0x83228a94, 0xa7920626, 0x2478b351, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xd8000000, 0x44000000, 0x3e000000, 0x0d000000, 0x73800000, 0x9cc00000, 0x91600000, 0x28900000, 0x34e80000, 0x9bdc0000, 0x1e6e0000, 0x41370000, 0x10b38000, 0x48d8c000, 0xa346a000, 0x1c093000, 0xf48f8800, 0x29675c00, 0xef3b4200, 0x98956900, 0x2f432880, 0x6da34cc0, 0xc9f0f060, 0x947b7890, 0x33371a68, 0xffb3bd94, 0x6c5bd8ea, 0x2f043451, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x38000000, 0xc4000000, 0xe2000000, 0x7b000000, 0xd5800000, 0x96c00000, 0x2b600000, 0xae100000, 0xdec80000, 0x48940000, 0x5fa60000, 0x005d0000, 0x56318000, 0xe5784000, 0x3f2fa000, 0x89ea3000, 0xaca77800, 0xc9dff400, 0x36f3f200, 0x9f1b8100, 0xc3bdf080, 0x3262e6c0, 0xc09072e0, 0xbd8baf30, 0x0534d8e8, 0xe2d4aa3c, 0xb485826a, 0x226d49f3, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0x84000000, 0xe2000000, 0x69000000, 0xcd800000, 0xeac00000, 0x19a00000, 0xf7d00000, 0x88480000, 0x48a40000, 0xd2960000, 0x26ef0000, 0x51328000, 0x30f94000, 0x209c6000, 0x9aa9f000, 0x7a14b800, 0x27afbc00, 0x4953da00, 0x0a099900, 0x7046ab80, 0x2d247ac0, 0xec550ce0, 0xc54cf2f0, 0x33e28ee8, 0x1b3167f4, 0x8dfba76e, 0x171c8833, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0x54000000, 0x46000000, 0x9f000000, 0x89800000, 0xe8400000, 0x95200000, 0xc8500000, 0x95980000, 0x36ec0000, 0x175e0000, 0x0f770000, 0x7bb38000, 0xa529c000, 0x1c446000, 0x5c5bb000, 0x5f8de800, 0x2c2cb400, 0xddbe0200, 0x7944db00, 0x38d94380, 0xd74eacc0, 0x7fce6fa0, 0x9d0c2290, 0x4bec65a8, 0x1fdd3d94, 0xbdb72c2a, 0xa5528e55, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x08000000, 0x54000000, 0x3a000000, 0xbf000000, 0x89800000, 0x3a400000, 0x9ae00000, 0x20300000, 0x87e80000, 0xea340000, 0xcdde0000, 0x37eb0000, 0xd2358000, 0xe1dfc000, 0x01ea6000, 0x0b34f000, 0xb95e7800, 0x37287400, 0x9d142a00, 0xb04cb700, 0x3052f680, 0x4a1ac140, 0x307c2860, 0xa7ba41f0, 0x882edee8, 0xf9a080b4, 0xa252f68a, 0xb11ac141, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xd8000000, 0xac000000, 0xde000000, 0x53000000, 0x4c800000, 0x90400000, 0xc0200000, 0x09500000, 0x07380000, 0x0d1c0000, 0x42260000, 0xcb3b0000, 0x831f8000, 0xd9264000, 0x43baa000, 0xb95e5000, 0x38078800, 0x8b689400, 0x31a62e00, 0x29f8fb00, 0x907fd580, 0x34d60bc0, 0xa99342a0, 0x015bbd10, 0xf36c9728, 0x1acdb6d4, 0xa85fd582, 0x61860bcf, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xa8000000, 0x4c000000, 0x72000000, 0x45000000, 0x2b800000, 0x28c00000, 0x21e00000, 0xdcf00000, 0x21080000, 0x85140000, 0x001e0000, 0xdb090000, 0x9c158000, 0x519fc000, 0x2ac8e000, 0x4c761000, 0xacaf3800, 0x73a03c00, 0x7853aa00, 0x87d93500, 0xd98d1880, 0xe4b3de40, 0x54a802e0, 0x4e44e8f0, 0xa7451a68, 0x4ec736bc, 0xfb051882, 0xc567de41, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x88000000, 0xc4000000, 0x82000000, 0x2d000000, 0xe4800000, 0x3c400000, 0x30e00000, 0x7f100000, 0x4e580000, 0x796c0000, 0xc9360000, 0x43590000, 0xedee8000, 0xcd74c000, 0xefb86000, 0x5cffb000, 0xe82dd800, 0xdd56dc00, 0x600a9600, 0x4357bb00, 0x43086e80, 0xacd769c0, 0xe4cb1e20, 0xe1f50250, 0xb7fb70a8, 0x5e1e6b9c, 0xe23e6e8e, 0x3b8e69c1, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x58000000, 0x4c000000, 0x9e000000, 0x85000000, 0xaa800000, 0xbe400000, 0x03600000, 0xf4100000, 0x81480000, 0xe06c0000, 0x58260000, 0x94cb0000, 0x1baf8000, 0xc8854000, 0x447ba000, 0xe857d000, 0x98120800, 0x2f49cc00, 0x9d6e6e00, 0xcea4db00, 0xec88f880, 0xd1cdd3c0, 0x0816be60, 0xfe72c410, 0xa1d846e8, 0x8a6417d4, 0x39a97882, 0x92bf93c3, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x98000000, 0x04000000, 0x16000000, 0x8b000000, 0x7c800000, 0x3d400000, 0xae200000, 0x86700000, 0x59480000, 0x1a040000, 0xc44e0000, 0x88c90000, 0x58c68000, 0xd7acc000, 0x5fd82000, 0x2cdcf000, 0xe1108800, 0x8f185400, 0x623c2e00, 0xa1800f00, 0x6ac15980, 0x5fe2ef40, 0x5d1163e0, 0xed1b0cb0, 0xd73e3a68, 0x1a00e3fc, 0xa101d98e, 0x55832f41, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x58000000, 0x1c000000, 0xfe000000, 0x2f000000, 0xc0800000, 0xfbc00000, 0x59200000, 0x8bb00000, 0xab880000, 0x88cc0000, 0x82460000, 0xfd0b0000, 0x380c8000, 0x69e44000, 0xf479a000, 0x61259000, 0xb3dbc800, 0xae54e400, 0x29f12e00, 0x12e9a500, 0xbb1d2f80, 0x3d9d4440, 0x455df5e0, 0x1afc4a90, 0xa98eda68, 0x3da60ed4, 0xf619af8e, 0xb875044b, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x98000000, 0x54000000, 0x2a000000, 0xa7000000, 0xca800000, 0xa3c00000, 0xcea00000, 0x37900000, 0xe6380000, 0x41440000, 0x1a7e0000, 0x1eb90000, 0xd1858000, 0x945fc000, 0xfde82000, 0xab9eb000, 0x154a3800, 0xe50c1400, 0x64f20600, 0xf2081d00, 0x8d6f6180, 0x9c4242c0, 0xe4e32ba0, 0x52726470, 0x07ca4a28, 0x72cd26bc, 0xf052e182, 0x2a9982c1, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0xfc000000, 0xc6000000, 0x27000000, 0x2c800000, 0x67c00000, 0x76e00000, 0xb2f00000, 0xcd480000, 0x3b540000, 0x6b1e0000, 0xddcb0000, 0x7a978000, 0xaafc4000, 0xebb9a000, 0xb41e1000, 0xdd48a800, 0xd3542400, 0xaf1d3e00, 0xd7ca0500, 0x03962080, 0x5d7c8e40, 0x66fa6be0, 0x823d10f0, 0x35da4b68, 0xcb2e9eb4, 0x2fe1a082, 0x3570ce47, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xf8000000, 0x74000000, 0xee000000, 0x23000000, 0x9b800000, 0xd1c00000, 0xdaa00000, 0x3ad00000, 0xe9f80000, 0x25440000, 0x6f3e0000, 0x8fbb0000, 0x24258000, 0x9a4dc000, 0x4013a000, 0xb4dbb000, 0x8c55a800, 0x35659400, 0x3eafd200, 0xbfa0c100, 0x4e51d980, 0x19b943c0, 0x332715a0, 0xcfcc9770, 0x62d34c28, 0x0df814b4, 0x1347f98a, 0xe83f33c9, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x88000000, 0x0c000000, 0xc2000000, 0x8f000000, 0xe8800000, 0x56400000, 0xb6200000, 0x89900000, 0xa6880000, 0x059c0000, 0xa3960000, 0x0c490000, 0xb3fc8000, 0x85254000, 0x32d3e000, 0x672a9000, 0x6acc7800, 0x517dd400, 0x70668e00, 0x7e734300, 0x8ffaf580, 0x16e400c0, 0x45329760, 0x8e5b15d0, 0x99b4e2e8, 0x87da551c, 0x7a759586, 0x583bd0cf, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x08000000, 0x3c000000, 0x06000000, 0x73000000, 0xa7800000, 0x8dc00000, 0xdaa00000, 0x71300000, 0x6d180000, 0xf90c0000, 0x0b960000, 0x8b590000, 0x806c8000, 0xbf074000, 0x8ef3e000, 0xdeb85000, 0x0abda800, 0x87cd3400, 0xb6b68200, 0x97aac100, 0x87d6c980, 0x3f3a9c40, 0xd47dc9a0, 0xaaee45d0, 0xf2478028, 0x1413999c, 0x35e9a986, 0x2cb58c47, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x18000000, 0x54000000, 0x0e000000, 0x8d000000, 0x4a800000, 0x8ec00000, 0xeaa00000, 0x1d900000, 0x42f80000, 0x95840000, 0x51fe0000, 0x50bb0000, 0x08e48000, 0x524cc000, 0xc4102000, 0x33b9b000, 0x5f67a800, 0xee0f2c00, 0x24712e00, 0xd28af900, 0xd90d5d80, 0x7df1e2c0, 0xe3ca5ca0, 0x73ee2470, 0x12038128, 0x8f0306b4, 0xfd81fd8e, 0x974092c9, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xb8000000, 0xf4000000, 0x5e000000, 0xb3000000, 0x94800000, 0x71400000, 0x16a00000, 0xd4d00000, 0x5d280000, 0xd1840000, 0x742e0000, 0x6ee90000, 0x89668000, 0xe8dd4000, 0xcb512000, 0x8cebb000, 0x8865e800, 0xb55d9400, 0xcb90ae00, 0x808bbf00, 0x05d56b80, 0xb645b7c0, 0xa2cd80e0, 0x49198530, 0xf45e6b68, 0x361172fc, 0x504acb8e, 0x01b747c7, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x08000000, 0xac000000, 0x0a000000, 0xc9000000, 0xb9800000, 0xfac00000, 0x2de00000, 0xa9500000, 0xefd80000, 0xe9f40000, 0x6bae0000, 0xc6990000, 0xc7d78000, 0xae9dc000, 0x0ed26000, 0x42191000, 0xea955800, 0x36be6c00, 0x20e25200, 0x86d01500, 0x2e1b9080, 0xc094b0c0, 0x2fbc8720, 0x9160dc30, 0xd01097a8, 0x09f9acfc, 0xa0c6708a, 0x79e460c1, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xe8000000, 0x44000000, 0x26000000, 0xf1000000, 0xf7800000, 0x4f400000, 0x8de00000, 0x8b300000, 0xc9c80000, 0x4abc0000, 0xa6f60000, 0x3c090000, 0xc59e8000, 0xf4644000, 0x67916000, 0x4a183000, 0x51c7c800, 0x2fc13c00, 0x6421aa00, 0x2e12eb00, 0x985b9680, 0x29a7a140, 0xccb0f8e0, 0xce8a9f50, 0x135dee68, 0x13c57e1c, 0xa8c2768e, 0x1aa2d143, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xe8000000, 0x24000000, 0x72000000, 0x5f000000, 0x82800000, 0x84c00000, 0xd6a00000, 0xd3d00000, 0xf9b80000, 0x3b440000, 0xc77e0000, 0x96790000, 0x45668000, 0x636e4000, 0x1de36000, 0xec31b000, 0x72891800, 0x174ed400, 0x9af24600, 0x3b2a4100, 0x261c7d80, 0x9788a3c0, 0x3ecc10a0, 0x16b15270, 0x8a48ed28, 0x1feeb1bc, 0x30211d8e, 0x851013cb, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xf8000000, 0xac000000, 0x92000000, 0x77000000, 0xf9800000, 0x93400000, 0xbf200000, 0xd0900000, 0x80080000, 0xf4640000, 0xd6ee0000, 0x9a4b0000, 0x37c58000, 0x6bbfc000, 0x67a1a000, 0x6b50d000, 0x6ce93800, 0xbc153400, 0x70956a00, 0xd5565300, 0x8cb4a580, 0xb24544c0, 0xd2fdc960, 0x2382f030, 0x8042ece8, 0xf0a374f4, 0xa2d3058a, 0x77aa94c1, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xe8000000, 0xac000000, 0xfe000000, 0x5b000000, 0x79800000, 0xf4c00000, 0xa5a00000, 0xb1300000, 0x57180000, 0x93940000, 0xc20e0000, 0x5edb0000, 0x60b68000, 0x347fc000, 0x29a2e000, 0x7f339000, 0x94188800, 0x3e177400, 0x8ccf9a00, 0xf2787d00, 0x0d055180, 0xb5271840, 0x92d74da0, 0x5d6fc7b0, 0x894a9c28, 0x2b1c1ff4, 0xbe31b186, 0xd49b884d, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x48000000, 0x0c000000, 0xe6000000, 0xc7000000, 0x6d800000, 0xe1400000, 0x5d600000, 0x43500000, 0x63e80000, 0x262c0000, 0x31460000, 0xe8ab0000, 0x1a4e8000, 0x3894c000, 0x57836000, 0xc8439000, 0x1be16800, 0x7990e400, 0x50cbba00, 0x599d9b00, 0x16bc7480, 0x370dd2c0, 0x23f631e0, 0x63d22790, 0xde2ac568, 0x988c3554, 0xffb71486, 0xda3242c1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x18000000, 0xac000000, 0x0e000000, 0x75000000, 0x94800000, 0x4e400000, 0x82600000, 0x62b00000, 0x9f580000, 0xcfa40000, 0x337e0000, 0x8d190000, 0x2bc58000, 0x20ccc000, 0x2cc12000, 0x65235000, 0xd2504800, 0x62a9cc00, 0xfc1d5600, 0x072be300, 0x4cdddc80, 0xa4088540, 0xff8fdca0, 0xe0229370, 0x2ed18028, 0x28ebd63c, 0xd47cfc82, 0xaa9bd54d, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xe8000000, 0x84000000, 0x1e000000, 0x79000000, 0x41800000, 0x90c00000, 0x27a00000, 0x74f00000, 0x23080000, 0xb6140000, 0xff9e0000, 0x6bcb0000, 0xbdb68000, 0xf16f4000, 0x9fc26000, 0xdb233000, 0x5bb32800, 0x5d68fc00, 0x4cc55200, 0xbca72d00, 0xc7744180, 0xf9cd2f40, 0x07b05ae0, 0x6f6b69f0, 0x4fc49b68, 0x2a2606b4, 0x87362186, 0x8b2e1f4f, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xc8000000, 0x64000000, 0x56000000, 0x59000000, 0xb1800000, 0xfcc00000, 0xad200000, 0xb5500000, 0xc7980000, 0x19d40000, 0x9cce0000, 0x8b5b0000, 0xacf78000, 0x259ec000, 0xeec26000, 0x72213000, 0x35d00800, 0x7ed95c00, 0xd6351200, 0xb9bffd00, 0x1e127b80, 0xd77843c0, 0xbc243e20, 0xb0c55eb0, 0x3f37c5a8, 0x103cdd74, 0xeed01b82, 0xd85973cd, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0xbc000000, 0x7a000000, 0xa5000000, 0x2a800000, 0xbd400000, 0xaea00000, 0x49900000, 0x33c80000, 0x4c8c0000, 0x9a060000, 0x1c2b0000, 0x91bd8000, 0x655cc000, 0xd9ede000, 0xd275d000, 0xf1d2d800, 0x67e81c00, 0xb05eae00, 0x2b6da700, 0x4b366380, 0x21713ac0, 0x657b0a60, 0xca15ec90, 0x2f2089e8, 0x4d510654, 0x4da95b8a, 0x9d7cf6cd, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0xc4000000, 0x1e000000, 0x8b000000, 0x82800000, 0x99400000, 0x74600000, 0x51300000, 0x56c80000, 0x2c4c0000, 0xffc60000, 0x3deb0000, 0x661c8000, 0x94bdc000, 0x9d2c2000, 0xdf74f000, 0x44e3a800, 0x7171f400, 0x59299600, 0xffbc2700, 0xcfad9080, 0x7e34db40, 0x6480a4e0, 0x6640b890, 0x40e11468, 0x4f7093d4, 0x222a188e, 0xb53ddf4d, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x18000000, 0xdc000000, 0xa6000000, 0xe3000000, 0x3e800000, 0x91400000, 0xc8e00000, 0x49300000, 0xd0c80000, 0xe1fc0000, 0xf4760000, 0xdf6b0000, 0x8b2d8000, 0xb70fc000, 0x551e2000, 0x0b449000, 0xd4a32800, 0xd851b400, 0x6c39a600, 0x7d967700, 0x51d96280, 0xc1259940, 0x9ad34ce0, 0x4b7a9450, 0x6e740e68, 0xaa6b9d14, 0x3eac6a8a, 0x8cccbd41, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0xdc000000, 0x06000000, 0xf7000000, 0xf6800000, 0x26c00000, 0x86200000, 0xe9f00000, 0xb2b80000, 0x3ecc0000, 0x9cb60000, 0x4b590000, 0x4c9d8000, 0xb1bfc000, 0x40cee000, 0x5fb45000, 0xc7dba800, 0x4b5da400, 0x1e1c1600, 0xa57ec900, 0x4bed1780, 0x61c61140, 0x7a218820, 0xfff1a450, 0xcdba7fa8, 0xc44fe51c, 0x94765f82, 0xe67ae541, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x58000000, 0x5c000000, 0x1a000000, 0x4b000000, 0xc7800000, 0xd3c00000, 0x3e600000, 0x66b00000, 0xda080000, 0x39cc0000, 0x56060000, 0xb0ab0000, 0xa49e8000, 0xce7dc000, 0xa08e2000, 0x6d249000, 0x5739d800, 0x2206e400, 0xfeabe200, 0x119d6900, 0x14ff6280, 0xbdcd0940, 0x500607e0, 0x01abbb90, 0x381f4568, 0x823e22d4, 0x112e9a86, 0x2ff47d45, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x58000000, 0xa4000000, 0x5e000000, 0x83000000, 0x9c800000, 0x9cc00000, 0x3c200000, 0x9a500000, 0x66880000, 0x0f4c0000, 0xca060000, 0x7fe90000, 0xde7f8000, 0x2cbcc000, 0x9b9e2000, 0x414e7000, 0xd1042800, 0x6769d400, 0x8cbe4e00, 0xcb9e4900, 0x394d4780, 0xe505efc0, 0x6169d660, 0xabbe8290, 0x091cb1e8, 0x268c1d5c, 0x45a6cf8a, 0x67fb8bc5, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xe8000000, 0x0c000000, 0x82000000, 0x65000000, 0x05800000, 0x07400000, 0xe1e00000, 0x09900000, 0x2e780000, 0xfbb40000, 0xb58e0000, 0x0f590000, 0x11858000, 0x0607c000, 0xec45e000, 0x74241000, 0xc0f6f800, 0x8e6cfc00, 0xf7cad200, 0x8c7f5300, 0xf9f05680, 0x56abfbc0, 0x972e18a0, 0x792a37b0, 0x996dae28, 0x6f48dc7c, 0xcabece82, 0x4150d7c1, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x68000000, 0x7c000000, 0xa6000000, 0xc3000000, 0xaf800000, 0x58c00000, 0x3a600000, 0xf1f00000, 0x60680000, 0x45640000, 0xa8ce0000, 0x034b0000, 0x19378000, 0x52b6c000, 0xc874e000, 0xb315d000, 0x0c64a800, 0xea4ff400, 0x7b0a2200, 0x8a14d500, 0x16e68e80, 0x160d1440, 0x5a29df60, 0xd74604b0, 0x021db1e8, 0xcb71c0f4, 0x4c294682, 0xac45f04d, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x98000000, 0x54000000, 0xde000000, 0xb3000000, 0x47800000, 0x5a400000, 0xca600000, 0x60b00000, 0x6a880000, 0x6be40000, 0x7e2e0000, 0xb7290000, 0x36758000, 0xeaf44000, 0xfb37a000, 0x4114b000, 0xb6c56800, 0xd07c9400, 0x98d3a200, 0xc3397f00, 0x13ee8480, 0xdf0bf140, 0x58a5dbe0, 0x96cf3f30, 0x855aff68, 0x995d7e7c, 0x4881cc82, 0x6fc3954f, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xf8000000, 0x04000000, 0xba000000, 0xc7000000, 0xf5800000, 0x21c00000, 0xcb600000, 0x9ff00000, 0x2b680000, 0xe3840000, 0xb02e0000, 0xc04b0000, 0xa4d78000, 0xc4d6c000, 0xb4d6a000, 0x7cd67000, 0x10d53800, 0x56d5d400, 0x2fd4fa00, 0xa7558900, 0xb4166e80, 0xab374040, 0xde644760, 0xa19e9b30, 0xf68289e8, 0x8e40ab74, 0x1da27682, 0xc912244d, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xc8000000, 0xd4000000, 0x06000000, 0x69000000, 0x13800000, 0x6f400000, 0x20600000, 0x41500000, 0x23480000, 0x8f040000, 0x300e0000, 0xf7e90000, 0xf5768000, 0x8475c000, 0x2bf46000, 0x66b4f000, 0x71d58800, 0x56045c00, 0xdb8f5a00, 0x74ab5b00, 0x5f143080, 0xb625c6c0, 0xa03ef760, 0xfa728fb0, 0x7478a7e8, 0xbc1eb97c, 0x03c3588e, 0x3da0aac5, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x98000000, 0xfc000000, 0x8e000000, 0x09000000, 0x24800000, 0x6cc00000, 0xac200000, 0xfaf00000, 0x38e80000, 0x64d40000, 0xb3fe0000, 0x548b0000, 0x7ac78000, 0x0fc6c000, 0xe5472000, 0x20841000, 0x38260800, 0x3617bc00, 0x5edee600, 0x4ef94900, 0xcced4f80, 0xd8308540, 0x7dcae560, 0x8aa7ed70, 0xefd68ae8, 0xf87c7834, 0x41cbe782, 0xe4a5e94d, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x98000000, 0x34000000, 0x4a000000, 0xf7000000, 0xc3800000, 0x05c00000, 0xba600000, 0x4e900000, 0xc7d80000, 0x03b40000, 0x422e0000, 0xde390000, 0x58e48000, 0x4796c000, 0x771c2000, 0x0f103000, 0x591a3800, 0xe4545400, 0x647f2200, 0x0f018100, 0xe7805a80, 0x37c2e9c0, 0xa963c020, 0x5f105130, 0x011b3aa8, 0x305448fc, 0xfe7ee286, 0x60007dc1, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x98000000, 0xdc000000, 0xda000000, 0x17000000, 0x71800000, 0xbac00000, 0x5b200000, 0x8ad00000, 0x16b80000, 0x22840000, 0x4f7e0000, 0x541b0000, 0x76948000, 0x54e74000, 0x994da000, 0x0dd39000, 0xef385800, 0x8c441400, 0xba5e4a00, 0x57ca5500, 0x00af4380, 0x7022f5c0, 0x5152a0a0, 0x437a0170, 0xe424c328, 0x3d6c24b4, 0xd2839b8e, 0x7541a1c7, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xc8000000, 0x54000000, 0x96000000, 0x25000000, 0x6d800000, 0x58c00000, 0x7da00000, 0x76700000, 0xdbf80000, 0x51a40000, 0x8b1e0000, 0x39db0000, 0x44178000, 0x91c64000, 0x0d4ee000, 0xdc93f000, 0xcbea4800, 0xa10dac00, 0xa6739200, 0x43f9fd00, 0xdda58980, 0x311f9540, 0x16dad720, 0xce95daf0, 0x17863ea8, 0x60afffb4, 0xe2004182, 0x4300794f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x58000000, 0xac000000, 0x12000000, 0x43000000, 0x2b800000, 0xc7400000, 0x86a00000, 0x0f500000, 0x8d480000, 0xb9140000, 0xe49e0000, 0x36690000, 0xc4058000, 0xc1f7c000, 0x41ef2000, 0xceb05000, 0xc4b83800, 0x9b0de400, 0x00c33200, 0x33e32b00, 0xbaf07380, 0x21988dc0, 0x071dd760, 0x6529c8f0, 0x8ca704e8, 0x17a6d53c, 0x5025cb82, 0x2566a9c1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x78000000, 0x74000000, 0xfe000000, 0xed000000, 0x8a800000, 0x5d400000, 0xe8600000, 0xc0b00000, 0x12580000, 0x118c0000, 0x29160000, 0x8f390000, 0x7fbd8000, 0x700c4000, 0xa7d42000, 0xee9bb000, 0xd72f6800, 0xb805ec00, 0x4df06e00, 0xd2391700, 0x4d3d0880, 0xf94de540, 0x81b690a0, 0xbb2959d0, 0x3bf43828, 0x0aca4c9c, 0x61846082, 0x1731094f, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x68000000, 0x1c000000, 0xce000000, 0x35000000, 0x06800000, 0xf1400000, 0xbb200000, 0x30700000, 0x6b780000, 0x17740000, 0x16ce0000, 0xf15b0000, 0x43868000, 0xfff64000, 0x828d6000, 0x34f95000, 0x06b60800, 0x95ac0c00, 0x4289de00, 0xb4cfb700, 0x2258f580, 0x8c06bb40, 0x36363720, 0x95ef4bb0, 0xa52b22a8, 0x62fde0f4, 0x6780fd86, 0x75c1b74b, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x88000000, 0x34000000, 0xc2000000, 0xa9000000, 0x21800000, 0xee400000, 0x17a00000, 0xab300000, 0x2d980000, 0xa4bc0000, 0x3be60000, 0xb5390000, 0x9d0e8000, 0x5cbc4000, 0x47e4e000, 0x233a7000, 0x060e9800, 0x5c3fcc00, 0xbc261200, 0x18da4700, 0x139fdb80, 0xfb15b840, 0xdb43b1a0, 0x90223d10, 0x36700a28, 0xfeb8b55c, 0xbe4f438e, 0xb09f7443, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x88000000, 0x9c000000, 0x1e000000, 0x7f000000, 0xa3800000, 0xf7400000, 0xb7e00000, 0xca300000, 0x57880000, 0xef3c0000, 0xb7760000, 0xe16b0000, 0x098f8000, 0x8c3cc000, 0x4af56000, 0xc929d000, 0x0dedc800, 0x394f6400, 0x369c6200, 0xf224fb00, 0x92133680, 0x949b1d40, 0x7f2449e0, 0x28930650, 0x1b5b9f68, 0x86060b14, 0xd700fe82, 0x6f837945, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x28000000, 0x94000000, 0x6e000000, 0x9b000000, 0x17800000, 0x73c00000, 0xe7600000, 0xd8b00000, 0x56680000, 0x923c0000, 0xfd160000, 0xa30b0000, 0x4b8d8000, 0x99fd4000, 0x16746000, 0x89b97000, 0x8ce5a800, 0xc1423400, 0x80220200, 0xc7925900, 0x10781680, 0x2687d540, 0xf9719660, 0x9009a5d0, 0x880e60e8, 0xa43d4094, 0x9a15be8a, 0x6e89e14b, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x08000000, 0x34000000, 0xba000000, 0xef000000, 0x91800000, 0x1cc00000, 0x2da00000, 0x03d00000, 0x0c580000, 0xf7b40000, 0xcfae0000, 0xa1f90000, 0x34668000, 0xa3f44000, 0xa64ee000, 0xf3c87000, 0x360f7800, 0x28293400, 0xbf3dca00, 0x01c3ad00, 0xc7218180, 0xa4920bc0, 0x2a3aa720, 0x7447a430, 0x52e546a8, 0x22b49ffc, 0x712ef98e, 0x4cbb3fc3, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x98000000, 0x6c000000, 0x7a000000, 0x5f000000, 0x34800000, 0x5c400000, 0xc2a00000, 0x3c100000, 0xd8280000, 0x38940000, 0x7a1e0000, 0xf29b0000, 0x9aaf8000, 0x87a0c000, 0xa7932000, 0x98e95000, 0x42741800, 0x0aacf400, 0x5fa31e00, 0x6b93cb00, 0xf2e9c780, 0x857508c0, 0x522f31e0, 0x79e3d070, 0xf632ee68, 0xfa7a2cb4, 0x011ec182, 0xa81a37c5, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x38000000, 0x8c000000, 0xe6000000, 0x35000000, 0x37800000, 0x56400000, 0x8f200000, 0x69700000, 0x6a480000, 0xbd2c0000, 0x80460000, 0x88190000, 0xdc168000, 0xc021c000, 0x75f1a000, 0xd28b5000, 0x25cfe800, 0x3d55ac00, 0xbf833a00, 0xd2409f00, 0x2d207180, 0x9e71e740, 0x3acb85e0, 0x83ecc910, 0xbda41c68, 0x3a88825c, 0x31cca38e, 0xa754d445, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0x7c000000, 0x7e000000, 0x13000000, 0xba800000, 0x13c00000, 0xab200000, 0xbdd00000, 0x58980000, 0x455c0000, 0x78e60000, 0x9b6b0000, 0x35958000, 0x9263c000, 0x5d30a000, 0x42699000, 0xb6154800, 0x32235400, 0x1e525600, 0xa8dbdd00, 0x3e3fef80, 0xee5451c0, 0x6d412a20, 0xfae2a390, 0x5bf38da8, 0x1cc9a654, 0x8c86f18a, 0xf95bd8c1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x58000000, 0x44000000, 0x3a000000, 0x21000000, 0xa5800000, 0x6fc00000, 0xf7a00000, 0xd0500000, 0xcc380000, 0x66740000, 0xefee0000, 0x44c90000, 0xcc9c8000, 0x52e3c000, 0x1eb02000, 0x6c8bf000, 0xf1ffb800, 0x0a930c00, 0xdc180200, 0xcce44100, 0x83f6a580, 0xa02e69c0, 0xc36a5ea0, 0xd4cf5fb0, 0x82db4328, 0x06c63a7c, 0x98671f86, 0x31b424c5, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x58000000, 0xa4000000, 0x3a000000, 0x2b000000, 0xb6800000, 0x45c00000, 0xefe00000, 0x3b100000, 0x05980000, 0x1f0c0000, 0x7b760000, 0xb6690000, 0xc1068000, 0xa922c000, 0x6e732000, 0x8d4a7000, 0x48773800, 0x04eb2400, 0x8ec7e600, 0x65c0a500, 0x1fe04480, 0x531169c0, 0xa99a3d20, 0xd90e5dd0, 0xce7541a8, 0x11e8101c, 0x19469a8e, 0xb583e8c9, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x38000000, 0x1c000000, 0x32000000, 0x21000000, 0x33800000, 0x5bc00000, 0x9e600000, 0x2fb00000, 0xb1d80000, 0x870c0000, 0xf6b60000, 0x65090000, 0x34e78000, 0x40a1c000, 0x6c50a000, 0xf6a81000, 0x6a37f800, 0x0e4aac00, 0xfbc73a00, 0x5533e900, 0x3d9bd280, 0x4cae6940, 0x846626a0, 0xd1e38ad0, 0x76720c28, 0xc6bb4f9c, 0x6f3d108a, 0x0aae2c41, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0x3c000000, 0x06000000, 0xd5000000, 0xff800000, 0x34c00000, 0x85a00000, 0xfcf00000, 0x68380000, 0xc6e40000, 0xd27e0000, 0xa9e90000, 0xbe6f8000, 0xa543c000, 0xb0632000, 0x94d11000, 0x4709a800, 0x63fe2c00, 0xcc2a5a00, 0x8e4c3500, 0xb6731180, 0x13785b40, 0x5f876020, 0x9f2f1df0, 0x5f23d9a8, 0xffb06abc, 0x9d59638a, 0xd5b48249, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x28000000, 0x2c000000, 0x36000000, 0xc9000000, 0xb4800000, 0x86400000, 0x54e00000, 0xe7d00000, 0x09280000, 0x2ed40000, 0x7e1e0000, 0x399b0000, 0x47ec8000, 0x41c3c000, 0xa921e000, 0x10f19000, 0x9cd82800, 0x208f5c00, 0x39d34600, 0xcc291300, 0xdc55ee80, 0x095e5ec0, 0xddfa02e0, 0x3c7dfc70, 0xe309c468, 0x1da7feb4, 0x5504008e, 0x5934d1c5, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xc8000000, 0x3c000000, 0x26000000, 0xb9000000, 0xb8800000, 0x90400000, 0xcb200000, 0x28f00000, 0x49d80000, 0x3c540000, 0xd1ae0000, 0x5c8b0000, 0x783c8000, 0x4983c000, 0x54c26000, 0x1d625000, 0x4ad02800, 0x11a95c00, 0xd9ccf600, 0x00da3b00, 0x1cd68980, 0xd5eeed40, 0x9da885a0, 0x07cd5ab0, 0x3dd82428, 0x6655ebf4, 0x2eaed78e, 0x4d0a4a45, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x08000000, 0xbc000000, 0x7a000000, 0x2d000000, 0xcd800000, 0x95400000, 0x77600000, 0x3ef00000, 0x75f80000, 0x5ac40000, 0x375e0000, 0xb7eb0000, 0x938f8000, 0x2f81c000, 0xec406000, 0x8ce05000, 0xa4b25800, 0x56197c00, 0xfaf57200, 0xf7868b00, 0x443c3c80, 0xb71b9040, 0x5575b920, 0x5bc48170, 0x68dddda8, 0x43a96d34, 0x0b6c9682, 0x1d31a741, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xd8000000, 0xcc000000, 0xca000000, 0xa7000000, 0xd6800000, 0x53400000, 0xd4e00000, 0xdd500000, 0x5c180000, 0x39bc0000, 0xa0460000, 0x672b0000, 0xd5b78000, 0x20004000, 0x7002a000, 0x7802d000, 0xfc00d800, 0x1202d400, 0x6b02f600, 0x1c813f00, 0xf4408280, 0x02637cc0, 0x8e134820, 0x88fac510, 0xe4ed12a8, 0xfc5c6dd4, 0x5e952c82, 0x75f0d7c7, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x08000000, 0xd4000000, 0x22000000, 0x3f000000, 0x46800000, 0x35c00000, 0x98e00000, 0xc3900000, 0x13d80000, 0xf8bc0000, 0xc2860000, 0xee290000, 0x2d358000, 0x4901c000, 0x9b826000, 0xec41f000, 0xbba29800, 0x66b05400, 0x9caab600, 0x0af54500, 0x16e04880, 0x929377c0, 0x34591620, 0x12fc8e10, 0x3c25c6a8, 0x2d1aaddc, 0x34dde682, 0xf3d7a6c9, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xb8000000, 0x7c000000, 0x32000000, 0x0b000000, 0x61800000, 0x3c400000, 0x7c600000, 0xf6500000, 0x11e80000, 0xd87c0000, 0x3c760000, 0x4a190000, 0x25e68000, 0xd0d3c000, 0x7629a000, 0x275e9000, 0x31c77800, 0x6ce30400, 0xb492da00, 0xa6487f00, 0x3b0f8c80, 0x472ebec0, 0x5f1f57e0, 0xc3a6b3d0, 0xc3b12368, 0xdff8c91c, 0x9bf50e8e, 0x3b5895cd, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x88000000, 0x34000000, 0x8e000000, 0xcb000000, 0xe8800000, 0x77c00000, 0xe8200000, 0x5d500000, 0xfc180000, 0x6f240000, 0x279e0000, 0x2c290000, 0xb48e8000, 0x32524000, 0xa298e000, 0x0fe77000, 0xed3d2800, 0xcbba3400, 0xb736de00, 0x11660500, 0x2dffb380, 0x111b07c0, 0xa8a6f220, 0xaedc9870, 0xb4cae9a8, 0xdb7febbc, 0x95da258e, 0x740606cb, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x58000000, 0xe4000000, 0x12000000, 0x3b000000, 0x70800000, 0xacc00000, 0x35200000, 0x97700000, 0xbc780000, 0x679c0000, 0x50460000, 0x116b0000, 0x59f78000, 0xd3304000, 0x2198a000, 0x47cc7000, 0x284d1800, 0x060ec400, 0x34ef3e00, 0x8e3e7900, 0xb5f6ab80, 0xad30fb40, 0x249be720, 0x924faf10, 0x610fd4a8, 0x226dd054, 0x63fdad82, 0x77577647, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xe8000000, 0xe4000000, 0xce000000, 0x7b000000, 0xc8800000, 0xc9c00000, 0x3ae00000, 0xac700000, 0x9fc80000, 0xf9040000, 0x06ae0000, 0x03190000, 0xc91c8000, 0xd331c000, 0xcfe8e000, 0x5b17b000, 0x2ed6e800, 0xe6347400, 0x0347de00, 0xfd0dfd00, 0xbc4b4080, 0xd0458840, 0xf18d21e0, 0x4b8ad4b0, 0x69a40968, 0x997ee8fc, 0x37801686, 0x1f43714d, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x18000000, 0x04000000, 0x86000000, 0x7b000000, 0x4e800000, 0xa3c00000, 0x40e00000, 0x14300000, 0x39e80000, 0xeb040000, 0x2f8e0000, 0xe1f90000, 0xb6bf8000, 0x0592c000, 0x9cfb2000, 0x433cf000, 0xc8d04800, 0x6fd89400, 0x0fec4600, 0xe10bed00, 0x3b350080, 0xb066f940, 0x61fd6060, 0xcfb24430, 0x43a9a8e8, 0xeca7e97c, 0x299c2e8a, 0x2340704d, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x58000000, 0x2c000000, 0xd2000000, 0x87000000, 0x7b800000, 0xac400000, 0x8ea00000, 0x92b00000, 0xde480000, 0x920c0000, 0xd2660000, 0x771b0000, 0x6ed68000, 0xe450c000, 0xcc592000, 0x63f65000, 0x46a0b800, 0x46b13400, 0x9048c200, 0xcf0d5700, 0x5ae5f780, 0x5eda2e40, 0x19364ae0, 0x04c1d790, 0x57638568, 0x0d510dd4, 0x1adaad86, 0xaf371d41, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x78000000, 0x94000000, 0xae000000, 0x03000000, 0x68800000, 0x8fc00000, 0xbe200000, 0xf1700000, 0x79a80000, 0x034c0000, 0x13460000, 0xb43b0000, 0xce348000, 0xd7914000, 0xb07a2000, 0x67563000, 0x0f002800, 0xa2825400, 0x3ac27e00, 0xf1a3e500, 0xc0312b80, 0xdf4acf40, 0x8a9ea460, 0x175d1f10, 0x187d27e8, 0xa08fc454, 0xb7675d8e, 0x384a4e4f, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xe8000000, 0xdc000000, 0xe6000000, 0x1f000000, 0x09800000, 0x30c00000, 0x7b200000, 0xccb00000, 0x0b580000, 0x99240000, 0x49de0000, 0x02090000, 0x26ef8000, 0xd8924000, 0xc6686000, 0x6ebc5000, 0x95da2800, 0xac674400, 0x1c3daa00, 0xae9abd00, 0x3a857380, 0x5f2fc840, 0x9d3224a0, 0xcf988970, 0xf804ff28, 0x4c6f453c, 0xf7d2918a, 0x5a8a614f, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x68000000, 0x7c000000, 0x72000000, 0xfb000000, 0x64800000, 0x44c00000, 0xdae00000, 0x18500000, 0x2db80000, 0xcd9c0000, 0x3f460000, 0x0dcb0000, 0xf7948000, 0xdab1c000, 0xf1eae000, 0xe625d000, 0x97d87800, 0xb70e8400, 0x5d1c0e00, 0xa5840900, 0x562ab480, 0x9c45a8c0, 0xcd486ca0, 0x25541710, 0x0d502028, 0x1039fbd4, 0x1edc228e, 0x29e6f5cd, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x98000000, 0xcc000000, 0xfe000000, 0xff000000, 0xc6800000, 0x3cc00000, 0x03a00000, 0xbbf00000, 0xf5280000, 0x493c0000, 0x04360000, 0xf5b90000, 0x9e458000, 0xf6d34000, 0xb61aa000, 0x45b7d000, 0x53f90800, 0x97256400, 0x15835600, 0x9440d100, 0x0863e180, 0xdad10b40, 0xd8185060, 0x72b632d0, 0x317939e8, 0x01e41d9c, 0xdb231f82, 0xe8336e43, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x48000000, 0x94000000, 0x4e000000, 0xd9000000, 0xfe800000, 0x22400000, 0x8c600000, 0xd2100000, 0xc5980000, 0x532c0000, 0xcf560000, 0x21ab0000, 0x44c68000, 0x09f24000, 0xc34be000, 0x4c94f000, 0x7c0aa800, 0x68767c00, 0x995b4e00, 0xbd0c8b00, 0x71257c80, 0xc62013c0, 0x9a724f20, 0x01891f50, 0x63b51ba8, 0xf0fa3094, 0xcfbf7a86, 0x808e14cb, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xc8000000, 0x0c000000, 0xba000000, 0xcb000000, 0xac800000, 0x91400000, 0x20a00000, 0xafb00000, 0x96e80000, 0x6d040000, 0x5e0e0000, 0x02190000, 0xf84c8000, 0x8c38c000, 0x79bd6000, 0xb8f29000, 0x9f489800, 0x81356400, 0x1326ee00, 0x67fc3f00, 0x42d35b80, 0x30bba640, 0x00fc6c60, 0x24518f30, 0x12facfe8, 0x18dddd7c, 0x64a0d586, 0xd9b10949, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x78000000, 0xa4000000, 0x66000000, 0xe3000000, 0xdf800000, 0xdf400000, 0x97200000, 0xf1900000, 0xa3680000, 0x42d40000, 0xefde0000, 0x98bb0000, 0x721e8000, 0x1859c000, 0xea6ca000, 0x55c2f000, 0xace24800, 0x32707400, 0x149a2200, 0xb80c7b00, 0xe2723d80, 0xcc9a7cc0, 0xec0e3ae0, 0xec70e470, 0xf39aef68, 0xf18c1cb4, 0xb632bf86, 0x583bf7c5, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xf8000000, 0x4c000000, 0x2e000000, 0xc3000000, 0xb3800000, 0xd5400000, 0x4a600000, 0x15100000, 0x4e380000, 0xffcc0000, 0x38d60000, 0x776b0000, 0xf9158000, 0x81cbc000, 0xf227a000, 0x9e005000, 0x0b01c800, 0x7780d400, 0x1f41b200, 0x1362c300, 0x07904080, 0xc5fb0bc0, 0x106d35a0, 0x01672050, 0xb3631d28, 0x1790af94, 0x1df8528a, 0x0c6e98c1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x28000000, 0x34000000, 0xb2000000, 0x9d000000, 0xaf800000, 0xc2400000, 0x12e00000, 0xded00000, 0x83d80000, 0x73fc0000, 0xda860000, 0x5c490000, 0x0e448000, 0x9968c000, 0x1936e000, 0xb301f000, 0x74805800, 0xa2c39c00, 0xb2215a00, 0x89f3df00, 0xb9a9e680, 0x8e1746c0, 0x69720920, 0xd96a3510, 0x393557a8, 0x03031fdc, 0x0c805c86, 0xbec069c9, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0x04000000, 0x12000000, 0x59000000, 0x57800000, 0xe3400000, 0xbe600000, 0x8f700000, 0xf8680000, 0x694c0000, 0x56060000, 0x5b5b0000, 0x73c58000, 0x7dfbc000, 0xaf94a000, 0xab827000, 0x95401800, 0x85614c00, 0xe9f16a00, 0x70aa7b00, 0x226c0080, 0x2c17d240, 0x22c03560, 0x56206310, 0x1f908de8, 0x93d88d54, 0xf407ca8a, 0x0a58d941, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xd8000000, 0x44000000, 0x16000000, 0xeb000000, 0x09800000, 0x1a400000, 0x39200000, 0x1d100000, 0x77580000, 0xb11c0000, 0xf7260000, 0xff090000, 0xd0e58000, 0xd26b4000, 0xfbd7a000, 0x57a2f000, 0x14d18800, 0x653a1400, 0x0dad5a00, 0xefad7700, 0xaaaf3180, 0x5c2f6ec0, 0x71ee2c20, 0x258cfb90, 0x5a3f35a8, 0xd737715c, 0xcad3cb82, 0x8239e9c3, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x18000000, 0xa4000000, 0xaa000000, 0xdd000000, 0xe1800000, 0x99400000, 0x43e00000, 0x8d900000, 0xd5780000, 0x1af40000, 0x4b2e0000, 0x30a90000, 0x9bef8000, 0x6609c000, 0xb39c2000, 0x25e07000, 0x56907800, 0xdff93c00, 0x61352200, 0x1f0d2b00, 0xff1b8e80, 0x522597c0, 0x23b5b2a0, 0x18cf97b0, 0x853a6428, 0x3a974c7c, 0xcefc8c8a, 0x81b1ccc1, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x18000000, 0x74000000, 0x12000000, 0xc5000000, 0xe3800000, 0xa6400000, 0x2ae00000, 0x71300000, 0xa8980000, 0x06240000, 0xaf1e0000, 0xad6b0000, 0x939e8000, 0x71a84000, 0x62bca000, 0x5f383000, 0xbd755800, 0x7476bc00, 0xc1f78a00, 0x48b5bf00, 0x40d5b680, 0x7e278940, 0xeb1e1ba0, 0x47692770, 0x529c5528, 0x982b2234, 0x75fe1c86, 0x84594643, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xe8000000, 0xdc000000, 0x8e000000, 0x5f000000, 0xed800000, 0x99c00000, 0xfda00000, 0x07b00000, 0x0ce80000, 0xfbfc0000, 0xd0760000, 0x921b0000, 0x3ff48000, 0x72d8c000, 0xccd5e000, 0x5f2b5000, 0x135f0800, 0x6f476400, 0xdfb1fa00, 0xa8e8c900, 0x21fd5d80, 0x0d748640, 0x4698e660, 0xc8b654d0, 0x753953e8, 0xf005e694, 0x4453c78e, 0x7a38df49, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x78000000, 0xf4000000, 0x12000000, 0x33000000, 0x34800000, 0x43c00000, 0x3fe00000, 0xaf100000, 0x15a80000, 0xb8fc0000, 0xe6760000, 0xe0fb0000, 0x70f78000, 0x383ac000, 0x5796a000, 0xa2eab000, 0x24dcd800, 0x4685e400, 0xb2428e00, 0x51a3f500, 0x80b22c80, 0x701979c0, 0x356519e0, 0x1b5300d0, 0x550b4d68, 0xd7ce2d14, 0x6d2f8282, 0x4fbdfccd, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xe8000000, 0x24000000, 0xd2000000, 0x3b000000, 0xbc800000, 0x9ec00000, 0x59a00000, 0xfc100000, 0xd9980000, 0xa4b40000, 0x3b4e0000, 0xd9cb0000, 0xd74e8000, 0x5fcac000, 0xe64de000, 0xc44ab000, 0xda0d9800, 0xce298400, 0x2a3cce00, 0xf2e1e100, 0x2cf12180, 0x566b0cc0, 0xb25dd120, 0xd9d08830, 0x7cba88a8, 0x2667b0f4, 0x6b768f86, 0x696e9dc9, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x38000000, 0x34000000, 0x76000000, 0x11000000, 0xa7800000, 0x58c00000, 0x09a00000, 0xe5100000, 0xdad80000, 0x94c40000, 0x5c7e0000, 0xbc8b0000, 0xf57d8000, 0x6f09c000, 0xfbbea000, 0xa7aab000, 0x812f4800, 0x11b3fc00, 0x6a484a00, 0xb9de4500, 0xab989180, 0x80a514c0, 0x914f8820, 0x228218f0, 0x1940f1a8, 0x58614034, 0xaf33fb8a, 0x290821c9, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xb8000000, 0xac000000, 0x66000000, 0xd1000000, 0x4b800000, 0x5b400000, 0x7fa00000, 0xb2b00000, 0x7b080000, 0x2d4c0000, 0x41a60000, 0x89790000, 0x2aa78000, 0x3dfac000, 0xcf65a000, 0x309ad000, 0xfa346800, 0xd602bc00, 0xb9039a00, 0x7f83bb00, 0x81412780, 0x70a16240, 0x8433bfe0, 0x0dc81190, 0xd8ad5068, 0xc7341fdc, 0x1b809d8a, 0x0342c94d, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xf8000000, 0xa4000000, 0xde000000, 0x6b000000, 0x55800000, 0x6c400000, 0x9a200000, 0x1f900000, 0x5cd80000, 0x6c3c0000, 0x63060000, 0x3ecb0000, 0x70a48000, 0x771b4000, 0x635e2000, 0x0a36f000, 0x9d422800, 0x0aa1b400, 0xd5532a00, 0x6b38bf00, 0xa3cf0580, 0x756ca8c0, 0x9a3d6820, 0x2404d110, 0x894ae5a8, 0x3de47dd4, 0xf5b8af8e, 0x8a0f57c7, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x88000000, 0x64000000, 0xfe000000, 0xc3000000, 0x80800000, 0x89c00000, 0xe9600000, 0x86100000, 0x73780000, 0xe39c0000, 0xdec60000, 0x50e90000, 0x96a48000, 0x777ac000, 0x0d9e6000, 0x75c63000, 0x64682800, 0x69665400, 0x391a5e00, 0xf50dbd00, 0x4c7cbe80, 0xee1797c0, 0xb871a6a0, 0xf3eab810, 0x0627d028, 0x96bb8bdc, 0x50fc6086, 0x85d5eac1, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x68000000, 0xb4000000, 0x4e000000, 0xc3000000, 0x1b800000, 0xf7c00000, 0xf7a00000, 0x41300000, 0xb7980000, 0x09140000, 0xe36e0000, 0xec2b0000, 0x43cf8000, 0x689bc000, 0x0897e000, 0xe9aff000, 0x7b0ba800, 0x32bc1400, 0x25627200, 0x3a116900, 0x24eafd80, 0xc5ee1c40, 0x9b6991a0, 0xf42d96b0, 0x6bc8a428, 0x589faef4, 0x34910f82, 0x47abb549, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xc8000000, 0x7c000000, 0xb6000000, 0x99000000, 0xcf800000, 0x70400000, 0xa2a00000, 0x23300000, 0xf2580000, 0xa6bc0000, 0xd3860000, 0x13e90000, 0x31268000, 0x90d94000, 0x137ee000, 0x4e655000, 0x74f8e800, 0x978d1c00, 0x6addea00, 0x51d4c700, 0xc6637f80, 0xcd525040, 0x330a58a0, 0x8bb69310, 0x0d31af28, 0xaf59cf5c, 0x0b3e158e, 0x40c6d747, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xf8000000, 0xfc000000, 0x02000000, 0x9d000000, 0x72800000, 0xed400000, 0x79600000, 0x08900000, 0xcde80000, 0x830c0000, 0x6e460000, 0x32fb0000, 0x3d248000, 0xe36ac000, 0x1c4fa000, 0x42279000, 0x1ce9b800, 0x1b8d1c00, 0x7a068e00, 0x971bd700, 0xbff4b480, 0x446135c0, 0x0a117ce0, 0xe8aaf010, 0xae6f5068, 0x60d789d4, 0x9c10ba8e, 0x53ab22c1, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xc8000000, 0x1c000000, 0xb2000000, 0x85000000, 0x24800000, 0x7c400000, 0xaa200000, 0x26500000, 0x0e380000, 0x0fb40000, 0xca6e0000, 0x73690000, 0x1a0c8000, 0xe41a4000, 0x09e7e000, 0xd456d000, 0x44dc7800, 0x04617c00, 0x3971b600, 0x24e8cb00, 0x91cddd80, 0x15f93bc0, 0x0656fca0, 0xf1df60b0, 0x08e23928, 0xa932b77c, 0xf4ca6b86, 0x2e9cf0c3, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x68000000, 0x14000000, 0xee000000, 0x5d000000, 0x57800000, 0x7fc00000, 0xf0600000, 0x2fb00000, 0xeca80000, 0x75e40000, 0x806e0000, 0x28190000, 0x5fce8000, 0x3fcbc000, 0xf8d6e000, 0x30867000, 0x2c5ea800, 0x3573ec00, 0x974aba00, 0xaf977900, 0x57a4fa80, 0x04cd6940, 0xe148ef60, 0x5e94f6b0, 0xf224dde8, 0xcc0ec3fc, 0x9da8408e, 0x1067104d, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xd8000000, 0xec000000, 0x62000000, 0xcd000000, 0xf8800000, 0x79400000, 0x0ea00000, 0x9db00000, 0x8c780000, 0xecc40000, 0xe0de0000, 0x03cb0000, 0x35bc8000, 0x78984000, 0x0855a000, 0x2dd75000, 0xc416f800, 0xe7f75c00, 0x0ae62600, 0x6c2daf00, 0xd5137b80, 0x3acbb640, 0x633d8e20, 0x3ed9f670, 0x1b772da8, 0x05a50c34, 0xb18d5d8e, 0x3722194b, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x78000000, 0xbc000000, 0xde000000, 0x1f000000, 0xb5800000, 0x02c00000, 0x3b600000, 0xb7300000, 0xd4e80000, 0x13ac0000, 0xb2660000, 0x19d90000, 0xea448000, 0x4d4bc000, 0x2ffca000, 0xd9be9000, 0x8a9ec800, 0x518c6400, 0x9bf49a00, 0xa8e08500, 0xd6f14a80, 0x64094f40, 0x295fd060, 0x906f3290, 0x038672e8, 0x69aa49dc, 0xef0dd086, 0x16b5ca45, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x08000000, 0x8c000000, 0xbe000000, 0xe1000000, 0x08800000, 0xf7c00000, 0x65200000, 0xa2900000, 0xc9b80000, 0xd7ac0000, 0xf3760000, 0x612b0000, 0x75178000, 0x0759c000, 0xe61c6000, 0x555e9000, 0x99be8800, 0x4f0cdc00, 0x74a55600, 0x1971e500, 0x6a891f80, 0x054414c0, 0x31425fa0, 0x6be3a2d0, 0xeb302828, 0xfeeb3a14, 0x2c344982, 0xe3c9f1c1, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x78000000, 0x04000000, 0x02000000, 0xab000000, 0xd8800000, 0xddc00000, 0xe2a00000, 0xd6700000, 0x4d380000, 0x79ec0000, 0xbaa60000, 0x9a730000, 0x833b8000, 0x5cefc000, 0xe726a000, 0x4a32f000, 0xc9db9800, 0xc47d6400, 0x308f6e00, 0x4f76e500, 0xaeb96580, 0xe4acb740, 0x71c78320, 0x84a37650, 0xcf7188a8, 0xb6b92414, 0x50af6e02, 0xfbc6e501, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x08000000, 0x3c000000, 0x56000000, 0xb3000000, 0x07800000, 0xed400000, 0xeb200000, 0x40300000, 0xda680000, 0x8bec0000, 0xcdb60000, 0xfa310000, 0x676a8000, 0x9b6e4000, 0xb575e000, 0x2d51d000, 0x12fb2800, 0x0ef5d400, 0x56133200, 0x2ad87b00, 0xb9443180, 0x6938f840, 0x76179b60, 0x62c19d10, 0xfa6098e8, 0x9d111e5c, 0xd95b320e, 0x5e047b03, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x08000000, 0x0c000000, 0x62000000, 0xb7000000, 0xba800000, 0x2bc00000, 0xd8a00000, 0x39100000, 0x1d080000, 0x10a40000, 0xb0be0000, 0x13110000, 0x86088000, 0xf824c000, 0xf47d6000, 0x75311000, 0xfad93800, 0xe88f9400, 0xd0495600, 0x49c55500, 0x0a0ff580, 0x3f8a92c0, 0x1f640660, 0x361c83b0, 0x2702a5e8, 0x9283447c, 0x17c15606, 0x62a15501, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x78000000, 0xcc000000, 0xd6000000, 0x73000000, 0xa1800000, 0x59400000, 0x14e00000, 0x81500000, 0xeba80000, 0x96040000, 0x18fe0000, 0xb7510000, 0x88a98000, 0x9f874000, 0x85be2000, 0xc1b3d000, 0x60f9e800, 0x70add400, 0x98796a00, 0x356e3300, 0x1b59de80, 0x861e02c0, 0xfb0381e0, 0xd583e5b0, 0xe3433568, 0xc1e3d47c, 0x2bd16a02, 0xdf6a330b, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0x54000000, 0x3e000000, 0x6b000000, 0x0a800000, 0x4ac00000, 0xf2200000, 0x02b00000, 0x72c80000, 0x7f6c0000, 0xd5160000, 0xb5b30000, 0x62488000, 0x78acc000, 0x6ab7e000, 0xb542f000, 0xa9612800, 0xa8d19400, 0xe4986600, 0xbf34f100, 0xdb014b80, 0x32839640, 0x56c1c7e0, 0xc8207790, 0x7fb0ea68, 0x474b10d4, 0x012e660e, 0x06f7f101, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x48000000, 0xdc000000, 0x46000000, 0x71000000, 0x0e800000, 0x18c00000, 0x14200000, 0x64700000, 0xfe680000, 0x4d5c0000, 0x10460000, 0xf4f10000, 0x73a98000, 0x25fc4000, 0x37f5e000, 0x6f3b5000, 0xe1c7e800, 0x8fb29c00, 0x97c91e00, 0x8c6c8900, 0xff4e9b80, 0x7cbd3d40, 0x10976660, 0x332acdd0, 0xf03ee3e8, 0x7b56799c, 0x9a889e02, 0x910cc907, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xc8000000, 0x1c000000, 0xe2000000, 0xb3000000, 0x6a800000, 0x04c00000, 0xd6a00000, 0x40300000, 0x3f280000, 0xaffc0000, 0x11e60000, 0xa0b10000, 0x44e88000, 0x29dc4000, 0xc216e000, 0x15ba5000, 0xe2e77800, 0xea330400, 0x50288600, 0xc77d6900, 0x56257180, 0xd4913e40, 0x1c1a6a60, 0x22543250, 0x9ed99de8, 0x51f5651c, 0xe9680606, 0x699d2903, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xf8000000, 0x84000000, 0xaa000000, 0x6f000000, 0x21800000, 0x17c00000, 0xfba00000, 0x8a900000, 0x1b380000, 0x53440000, 0x6fee0000, 0x55130000, 0xd1fb8000, 0xd266c000, 0x913da000, 0xb14af000, 0xfc0f3800, 0xfee3d400, 0x39739a00, 0xe0cba900, 0xe3cf4980, 0xc94330c0, 0x75e06ca0, 0x42f1d0f0, 0xd00abf28, 0x55ee4934, 0x82101a02, 0xd4796905, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x38000000, 0xfc000000, 0x86000000, 0x91000000, 0xf7800000, 0x68c00000, 0xf3200000, 0xd6d00000, 0xc3780000, 0x025c0000, 0x6cf60000, 0x65530000, 0x91b98000, 0xc67d4000, 0xaca72000, 0x01681000, 0xf4046800, 0x097b1c00, 0x4d5dba00, 0xa677ed00, 0x34114780, 0x5f59abc0, 0x6e0f7ca0, 0xc6cc4190, 0x55ed8128, 0xd33d0754, 0x58443a0a, 0x9e1aad03, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x88000000, 0x94000000, 0xc2000000, 0xbb000000, 0x6b800000, 0x63c00000, 0xc8600000, 0x89300000, 0xb9180000, 0x0c040000, 0x3fae0000, 0x6d710000, 0x0cb98000, 0x00574000, 0x6d05e000, 0xe32d7000, 0x6b32d800, 0xb219a400, 0x4f862200, 0xb86f9100, 0xef10d680, 0xaa8b3140, 0x10cfcaa0, 0xb9c1f970, 0x7f60be28, 0xecb2193c, 0xcfda4202, 0xcae5a10b, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xc8000000, 0x04000000, 0xee000000, 0xc1000000, 0xc0800000, 0xd7400000, 0xfaa00000, 0xad100000, 0x15180000, 0x0bfc0000, 0xd7760000, 0x40d30000, 0x9ff88000, 0x39cfc000, 0x06bf6000, 0x7ad43000, 0xd0412800, 0x2f227c00, 0xfcd0e600, 0x6df92f00, 0xbacc3f80, 0x7d3ff2c0, 0x8a165e20, 0xf821a090, 0x815207a8, 0xa838bd54, 0xe42f060e, 0x090edf0d, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x98000000, 0x1c000000, 0x0a000000, 0xe3000000, 0x56800000, 0x5fc00000, 0x24200000, 0x1cd00000, 0x12180000, 0x39a40000, 0x3bee0000, 0x04910000, 0xd07b8000, 0x4a174000, 0xd9c7a000, 0xcf5f1000, 0x7639d800, 0xc577e400, 0xf9f5f600, 0x5534f500, 0x6f965780, 0x588577c0, 0xe0bee520, 0x30cb57f0, 0xa6bec4a8, 0x71c9953c, 0xb73fd60a, 0x9e89a503, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x08000000, 0x94000000, 0xba000000, 0xef000000, 0xe8800000, 0xdec00000, 0xb8e00000, 0x39900000, 0x8ab80000, 0xee840000, 0x372e0000, 0x3ed10000, 0xb91b8000, 0xb2b64000, 0x08a4e000, 0x765f7000, 0xadf93800, 0x6d241400, 0x631c7e00, 0x95596900, 0x4b968080, 0x495541c0, 0x3fb7daa0, 0xc32505f0, 0xf61ea428, 0xb2db6d3c, 0xcdd51e0a, 0x27755907, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xd8000000, 0xf4000000, 0xc6000000, 0x45000000, 0x8b800000, 0xa3c00000, 0xe7a00000, 0x63900000, 0xc5780000, 0x8cac0000, 0xa3c60000, 0xa2d30000, 0x78998000, 0x085fc000, 0xfc0e2000, 0x78d7b000, 0x22eb4800, 0xc7d4cc00, 0x66699a00, 0x68965100, 0x22883980, 0xade58cc0, 0x798359a0, 0x40c10250, 0xd9237a28, 0x43d11f94, 0xad183a0a, 0x3a9d2109, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x28000000, 0x1c000000, 0x26000000, 0x07000000, 0xc1800000, 0x4bc00000, 0x28200000, 0x3a300000, 0xb5880000, 0xfa740000, 0x264e0000, 0x5f730000, 0x6be98000, 0x15a64000, 0x1ed46000, 0xdf3fd000, 0x739b6800, 0x9fcfc400, 0xf0b3fa00, 0xc1c93900, 0x8a954780, 0x7fdc7c40, 0x920a1ce0, 0xd6b6faf0, 0x5fed2168, 0xb681ffb4, 0xc2401a0a, 0xefe3a90f, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xa8000000, 0xdc000000, 0x56000000, 0x6b000000, 0x6c800000, 0xabc00000, 0x02600000, 0xc9900000, 0x6ad80000, 0x9c1c0000, 0x41d60000, 0x35d30000, 0xb7f98000, 0xa82f4000, 0x9aff6000, 0x9f86d000, 0xdb69a800, 0xd176b400, 0x9ba3fe00, 0x12f00d00, 0x56caae80, 0x88876bc0, 0x51eb6b20, 0x99b71a10, 0xd943bba8, 0x8ea33cd4, 0x89731e0a, 0xe78a9d0b, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x38000000, 0xdc000000, 0x9e000000, 0x29000000, 0x9e800000, 0x59400000, 0x6b600000, 0x4b500000, 0x05f80000, 0x92cc0000, 0xebe60000, 0xfb130000, 0x501a8000, 0x30dec000, 0xed7fa000, 0xc68c9000, 0xfc058800, 0xee031c00, 0xe101fe00, 0xca824f00, 0x73406080, 0x3861ccc0, 0xbed2eca0, 0x753b9fd0, 0x176ff228, 0x0c15dc14, 0x87985e06, 0xe71ddf01, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x18000000, 0xac000000, 0x0e000000, 0x85000000, 0x39800000, 0xf8c00000, 0x96a00000, 0x41f00000, 0x81c80000, 0xa3c40000, 0x7f7e0000, 0x0c330000, 0x76e88000, 0xd6f74000, 0xd614a000, 0x7305d000, 0x1ddc0800, 0x8fc26c00, 0xcc20d200, 0xd1b29500, 0xc4299180, 0x1f57a140, 0x39657ae0, 0xa08ea130, 0xc0fab968, 0xe8afd574, 0xeb4a720e, 0x6b84450f, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xf8000000, 0xe4000000, 0x6a000000, 0x09000000, 0xe5800000, 0x37c00000, 0xf6200000, 0xdb900000, 0xdbc80000, 0x84e40000, 0xf43e0000, 0xb7530000, 0x856a8000, 0xb7354000, 0xaf172000, 0xe7877000, 0xc8ceb800, 0xca6bcc00, 0x6db41200, 0x1a547900, 0x10e71f80, 0xc63dcac0, 0x0a53cb60, 0x42e819b0, 0x95f446e8, 0x32b7ea74, 0x68d53206, 0x09a4090f, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x88000000, 0x2c000000, 0xe6000000, 0xff000000, 0x8c800000, 0x18400000, 0xd2a00000, 0x7f700000, 0x58e80000, 0xb5d40000, 0xf7ce0000, 0xb9330000, 0xf1488000, 0x9c244000, 0x5665e000, 0x09c59000, 0x2735a800, 0xae1f2400, 0xcca8ae00, 0xd1758300, 0xefbc6380, 0xb95a8340, 0x1edcd860, 0x8c4b73f0, 0x05a695e8, 0xcba733b4, 0x48a54e0e, 0xba241303, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xb8000000, 0xa4000000, 0x8a000000, 0xc7000000, 0x1a800000, 0x1a400000, 0x52200000, 0x5ad00000, 0x8a680000, 0x11340000, 0x8e0e0000, 0x46910000, 0x49488000, 0x5867c000, 0x59a4a000, 0x7a457000, 0x6b763800, 0x0c2ff400, 0x44435600, 0x7720b300, 0x7b50b980, 0xb4a927c0, 0xac566ce0, 0xff7fca70, 0x1ceb0368, 0x5d749ebc, 0xd52ff606, 0x5bc1c30d, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0x84000000, 0xb6000000, 0x83000000, 0x5f800000, 0x12400000, 0x66e00000, 0x07500000, 0x20e80000, 0x01fc0000, 0xe4c60000, 0x47110000, 0xc30b8000, 0xf22dc000, 0x05ee2000, 0x584e7000, 0xf77d4800, 0xf8041400, 0x2932d200, 0x64788700, 0x22b5ba80, 0x650962c0, 0xc92d44e0, 0xae6df750, 0xf40fac68, 0xce9cd29c, 0x92d4f20a, 0x2e9af709, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x38000000, 0x0c000000, 0x2a000000, 0x41000000, 0x5d800000, 0x19c00000, 0xae200000, 0x70500000, 0xd0880000, 0x16040000, 0xef1e0000, 0xa7b10000, 0x7ef88000, 0x6edd4000, 0x95902000, 0x4cabd000, 0x7b571800, 0xc0156c00, 0xdd759200, 0x4447a100, 0xcbfe3780, 0x8942ddc0, 0x00616560, 0x66b24530, 0xe37ae0e8, 0x971ce9fc, 0x8bb2aa06, 0x04f91d07, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xf8000000, 0x64000000, 0x32000000, 0xa1000000, 0x95800000, 0x44c00000, 0x34200000, 0x8db00000, 0xd6680000, 0x139c0000, 0xa4860000, 0xe9510000, 0x75f88000, 0x9547c000, 0xb2f1a000, 0x71897000, 0x5c8ed800, 0x671c0c00, 0x55c63200, 0x69b05500, 0x2469cb80, 0x529c4240, 0x21070960, 0x5591bcd0, 0x25d950e8, 0x2af4db9c, 0xc5994a06, 0xf795290d, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0x2c000000, 0x7a000000, 0x9b000000, 0x39800000, 0xfa400000, 0x5d600000, 0x37900000, 0x65180000, 0x59340000, 0x4dfe0000, 0x1eb10000, 0xfae98000, 0x773dc000, 0xaf11e000, 0x5ddb1000, 0xb797d800, 0x254ec400, 0x155b2a00, 0xa7563f00, 0xe7ecb480, 0x07e927c0, 0x37bc3c20, 0x83d181b0, 0x6d7a42a8, 0xc225897c, 0xde251202, 0x3c27eb01, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x38000000, 0x04000000, 0xc2000000, 0xb1000000, 0xfd800000, 0x44400000, 0xdea00000, 0xd7f00000, 0xa0180000, 0xf3dc0000, 0x9c760000, 0x67110000, 0x74488000, 0x17b64000, 0xb4f32000, 0x649bf000, 0x961c9800, 0xb0960c00, 0x2540d200, 0x4b227700, 0x3fb32380, 0xf0bbc140, 0x6b2ed9a0, 0xb6ed4610, 0x5e0e0828, 0x3e5f005c, 0xc0376a06, 0x2db38b0b, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x08000000, 0x1c000000, 0x76000000, 0x31000000, 0x49800000, 0x55c00000, 0x0c200000, 0xdbd00000, 0xaf580000, 0x88040000, 0xcd4e0000, 0x74330000, 0x09aa8000, 0x550ec000, 0xefd36000, 0x35595000, 0x77062800, 0xf1ce5c00, 0x0a72c200, 0x0b4a8100, 0x8c7e7f80, 0xb618fbc0, 0x0265a420, 0xb07de270, 0x301a79a8, 0x8b66c8b4, 0xbdff8a06, 0x07d98d01, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xa8000000, 0x74000000, 0x1a000000, 0x15000000, 0xfb800000, 0x80c00000, 0x98200000, 0xf4100000, 0xac480000, 0xf7a40000, 0x253e0000, 0xbbf30000, 0x62fb8000, 0xb2bdc000, 0xcd33e000, 0x59da7000, 0xbe2f3800, 0xc9397c00, 0x361c1a00, 0x8360bd00, 0xdcf24b80, 0x1879c4c0, 0xa3fc1f60, 0xb8d3a4b0, 0x1269aee8, 0x08b4ad74, 0x05f6c202, 0xfe14b109, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x48000000, 0x9c000000, 0x82000000, 0x6f000000, 0xc0800000, 0xbd400000, 0x48e00000, 0x8b100000, 0x3fb80000, 0x2c040000, 0x4fee0000, 0xb7b10000, 0x75cb8000, 0x6c6ec000, 0xc0716000, 0x53685000, 0x7d1cf800, 0xee9bf400, 0x54b49e00, 0xaaa50700, 0x0e9e9e80, 0xf15a13c0, 0x7e1660a0, 0x71d553f0, 0xd3750028, 0xb406173c, 0x7bef060a, 0x19b3a305, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xb8000000, 0x44000000, 0x7e000000, 0xa9000000, 0xfb800000, 0xed400000, 0x6a200000, 0x1cd00000, 0xd4780000, 0x0a740000, 0x069e0000, 0x89310000, 0x144a8000, 0xd5be4000, 0xe6632000, 0xb170f000, 0x7fe96800, 0x932c9c00, 0xfab9aa00, 0x09164b00, 0x6e6c6580, 0x1899bfc0, 0x89c4aca0, 0x70159d30, 0x7dec4328, 0x99db99fc, 0x91e7620e, 0x47c56703, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x08000000, 0xa4000000, 0x7e000000, 0x9f000000, 0x7d800000, 0x72400000, 0x41200000, 0x67500000, 0x13780000, 0x335c0000, 0x3a360000, 0x5eb30000, 0xcec98000, 0x12144000, 0x3f62e000, 0x8c73b000, 0xbd2be800, 0x56a74400, 0x70a9aa00, 0x6ce7af00, 0xb58bb580, 0x45b725c0, 0x31f286a0, 0xaf6a1990, 0x07847928, 0x2ffa2354, 0xd39f220a, 0x5cd41b07, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x48000000, 0x04000000, 0x52000000, 0x25000000, 0xdc800000, 0xe6400000, 0xb0e00000, 0xb8b00000, 0xb6880000, 0x16ac0000, 0xb7d60000, 0xbd930000, 0xad1a8000, 0x24b74000, 0xbee3e000, 0x13b03000, 0x810ad800, 0x276d1c00, 0x06f4c600, 0xfc03fb00, 0x5e029280, 0x9303f540, 0x9b82aae0, 0x57c02990, 0x8e211e68, 0xbc1317d4, 0x9bd97e06, 0xc4169707, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xb8000000, 0x74000000, 0xb2000000, 0xb9000000, 0xce800000, 0x59400000, 0x8d600000, 0x94100000, 0x77d80000, 0x61640000, 0xdeee0000, 0x15b30000, 0x086b8000, 0xf40c4000, 0xfe622000, 0x77923000, 0x42199800, 0x0446ec00, 0xc51d3e00, 0x69388f00, 0x98b61880, 0xa814c1c0, 0xd5279520, 0xdf0f8ff0, 0x79e093a8, 0xf852f134, 0x523b0602, 0x1737130f, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xd8000000, 0x8c000000, 0x22000000, 0x49000000, 0x9d800000, 0xe3c00000, 0xdc200000, 0x31d00000, 0xa7280000, 0x324c0000, 0xec760000, 0x91b30000, 0x501b8000, 0x9d154000, 0xd702a000, 0xce805000, 0xeb403800, 0xa8626c00, 0x13303200, 0x795bc900, 0x2c747780, 0x71b093c0, 0x00192de0, 0xb5175a90, 0x8301c868, 0x60835054, 0x80412a02, 0x7ce0b50b, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xa8000000, 0x24000000, 0xee000000, 0xe9000000, 0x7c800000, 0xe1400000, 0x17a00000, 0xe2900000, 0x54180000, 0xfd240000, 0x09ee0000, 0x0cf10000, 0x8e688000, 0xe50d4000, 0x26c26000, 0xc1613000, 0xabf0a800, 0x8beadc00, 0x80ccf600, 0xec20e700, 0x56536380, 0x3e7bf0c0, 0x5955e820, 0x00c581f0, 0x635e1da8, 0xc0baa63c, 0xf436be06, 0xd1364b07, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xe8000000, 0xf4000000, 0xd2000000, 0x91000000, 0x5d800000, 0x13c00000, 0x4c200000, 0x14100000, 0x86080000, 0x3d740000, 0x03ae0000, 0x0e710000, 0xa1fa8000, 0x9d4ec000, 0x23c2e000, 0xb4237000, 0x68111800, 0x700a4c00, 0x96749200, 0x3b2ce900, 0x92333780, 0x6f19a4c0, 0x98fdfe60, 0xa21842f0, 0x437ebbe8, 0x42db7f3c, 0xfbddea0e, 0x048b1501, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x98000000, 0xfc000000, 0x1a000000, 0xb9000000, 0x39800000, 0x36c00000, 0x7fa00000, 0x4b500000, 0x85880000, 0xb4040000, 0xc99e0000, 0x4b710000, 0x6b1b8000, 0x76af4000, 0x358ba000, 0xcc069000, 0xe59d1800, 0x39704c00, 0xb61be200, 0xa92c8d00, 0xa04aed80, 0x3324a7c0, 0xa18ec560, 0xf5985130, 0x36efeae8, 0xae69abfc, 0xdab57a0a, 0x25a78103, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xb8000000, 0x7c000000, 0xba000000, 0x99000000, 0x2b800000, 0xecc00000, 0x81e00000, 0x1d500000, 0x7e780000, 0x8a940000, 0x04fe0000, 0xac330000, 0x01688000, 0x684d4000, 0x57182000, 0xd9861000, 0xd4249800, 0xa2d74c00, 0x995eaa00, 0x72c0ad00, 0xaee1fc80, 0xcdd246c0, 0x6c381aa0, 0xce37fcb0, 0x918fec28, 0xdf7a4774, 0x9d14b20e, 0x323da107, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x48000000, 0x04000000, 0xaa000000, 0x03000000, 0x07800000, 0xf8c00000, 0x38e00000, 0xad100000, 0xd3e80000, 0xfd2c0000, 0x1e960000, 0xb7730000, 0x4cb98000, 0x7064c000, 0xd20b6000, 0x5cbc3000, 0x163c3800, 0x307de400, 0x8cdeb200, 0xba6c2d00, 0xe2b74880, 0xf480abc0, 0xc743bde0, 0xbc200c10, 0x63f0a768, 0x9bf87ad4, 0x84450a0a, 0xb5fa0905, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0x1c000000, 0x6e000000, 0xd7000000, 0x5c800000, 0x5bc00000, 0x5fa00000, 0x1b900000, 0x8c880000, 0x17c40000, 0x519e0000, 0x1db30000, 0x39588000, 0x2cad4000, 0x412b6000, 0xc554d000, 0x5e964800, 0x21352400, 0x6aa50e00, 0xbe2e2d00, 0xddea4980, 0xfe77dcc0, 0x5ac40660, 0xe81ff630, 0xc3f0a1e8, 0x86bb97f4, 0x07ddc60e, 0xce514907, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x08000000, 0x7c000000, 0x1a000000, 0x5f000000, 0xd0800000, 0xb7c00000, 0x79e00000, 0xd4f00000, 0x98380000, 0xfc140000, 0x699e0000, 0xb2930000, 0x43898000, 0xa60dc000, 0x7a9b6000, 0xbcc4d000, 0x23b71800, 0x82cf5400, 0xf1f99e00, 0x84f4ad00, 0x2cecb080, 0x2ce85840, 0x903e4920, 0x3cc06bb0, 0xdf6187a8, 0x0e318ef4, 0x4259060a, 0x5da53901, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0xac000000, 0xde000000, 0x6b000000, 0xd1800000, 0x80c00000, 0x86600000, 0xe0d00000, 0x25180000, 0x40bc0000, 0x2f360000, 0xa5b30000, 0xf8488000, 0x5b654000, 0xb2ea6000, 0x93d71000, 0x54224800, 0xbbf31400, 0x4d6bca00, 0x70173500, 0xffc1c280, 0x1de386c0, 0x0112a920, 0x73faf990, 0xc02c41a8, 0xc40f1a54, 0x67ff820e, 0xae972107, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xf8000000, 0xcc000000, 0xa6000000, 0xa3000000, 0xf4800000, 0xddc00000, 0x6be00000, 0x25700000, 0x00480000, 0xd8940000, 0x3bee0000, 0x47930000, 0xf4b88000, 0xe29ec000, 0x89daa000, 0xdb2dd000, 0x97f22800, 0xee8a5400, 0xdff73e00, 0xdf5ed500, 0x7238a080, 0x665c0640, 0x8bb91ee0, 0x681f3870, 0x8b1aa068, 0xca4dfb34, 0xf843160e, 0x1ba38109, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x98000000, 0x6c000000, 0xb6000000, 0x73000000, 0x33800000, 0xf2400000, 0x4a200000, 0xe5300000, 0x3a580000, 0xf1240000, 0x808e0000, 0x4e110000, 0x2dea8000, 0x5bbd4000, 0x6348a000, 0xfd4cd000, 0x2870e800, 0x65f8d400, 0x5d56e200, 0x07747700, 0xea475980, 0x741e4040, 0xf7392ba0, 0x46b508f0, 0x9224b028, 0xbb0fafbc, 0x18500a0e, 0x15c9a30f, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x38000000, 0x64000000, 0x5e000000, 0x8d000000, 0x1c800000, 0x8a400000, 0xdf200000, 0x6ad00000, 0xe8e80000, 0x22840000, 0xb77e0000, 0xf6f10000, 0x8bba8000, 0x88aec000, 0x7699a000, 0x257e7000, 0xd9f36800, 0x903b0c00, 0x256f2600, 0xee7a8b00, 0x3c4fcd80, 0xddaaf3c0, 0x7e2742e0, 0xa46c54b0, 0x30fa8968, 0x610d9c7c, 0x1d0a4e0e, 0x37348701, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x58000000, 0x34000000, 0x8e000000, 0xdb000000, 0x02800000, 0x70c00000, 0xff600000, 0x64500000, 0xc9380000, 0xbeac0000, 0x2c860000, 0xd9310000, 0xdc6b8000, 0x5817c000, 0xdf682000, 0xae96b000, 0x01a86800, 0x5af51400, 0x3f788600, 0xd70d5900, 0xf0b7e680, 0x44db90c0, 0xe23e67a0, 0x56de6150, 0x69cca728, 0x34d4d89c, 0xd208ee0a, 0xd3c44d01, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x28000000, 0xe4000000, 0x7a000000, 0xdf000000, 0xc8800000, 0x67400000, 0x28200000, 0x55500000, 0x13580000, 0xc2f40000, 0x2a3e0000, 0x39710000, 0x2c0b8000, 0x06afc000, 0x1449e000, 0x260c3000, 0x0658f800, 0xcd76d400, 0xb9fe7e00, 0x10136f00, 0x387bf580, 0xc926d9c0, 0xcf263220, 0x962797b0, 0xc7a7d9a8, 0xd164d17c, 0x3f86860a, 0xac35bb01, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xc8000000, 0xe4000000, 0xb2000000, 0xd3000000, 0x61800000, 0x71c00000, 0x91a00000, 0xf8b00000, 0xc5480000, 0x59dc0000, 0xb9660000, 0xe1110000, 0x39fb8000, 0x5e95c000, 0xabb86000, 0x15f7b000, 0xff2bd800, 0x97cfc400, 0xbf1f6a00, 0x6b479100, 0x5363e980, 0xb893b840, 0xf43959e0, 0x71350950, 0x86083a68, 0x183e501c, 0x81b4b20a, 0x1d485509, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xf8000000, 0x5c000000, 0x8e000000, 0x91000000, 0x2c800000, 0x47400000, 0xc7200000, 0x49300000, 0xb1a80000, 0xf18c0000, 0x6e360000, 0xb7230000, 0x41318000, 0xa5aac000, 0x4b8da000, 0xd5349000, 0xd8a04800, 0x35f1fc00, 0x98483600, 0xae5c0f00, 0xadce9180, 0x16967040, 0x52d01e60, 0x01783690, 0xc7f6f1e8, 0x9043b5d4, 0x0ea0480a, 0x28f1fc0d, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x48000000, 0xa4000000, 0x82000000, 0xfb000000, 0x20800000, 0x22400000, 0xc5200000, 0xbd300000, 0xad980000, 0x2cc40000, 0xfd4e0000, 0x13210000, 0x4c308000, 0x321a4000, 0xdc04e000, 0xa92db000, 0xefb19800, 0xfcd96400, 0x8d652e00, 0x903eeb00, 0xc8992d80, 0x5945f840, 0xc28de6a0, 0xddc08b70, 0x85e07d28, 0x4152fc3c, 0x85099806, 0x562d640b, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xd8000000, 0x14000000, 0xfa000000, 0x15000000, 0x55800000, 0xa1c00000, 0x7ae00000, 0xb6900000, 0xcef80000, 0x58fc0000, 0xbe760000, 0x2ce30000, 0x7d938000, 0xdc79c000, 0xa5bc2000, 0x06d53000, 0xba50b800, 0xc5983c00, 0x1dacc200, 0x036df100, 0xa10f5c80, 0x57dd09c0, 0x68049da0, 0x318afa10, 0xb617bb28, 0x57323ed4, 0xa3c8b802, 0x0e343c09, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x78000000, 0x24000000, 0xea000000, 0xc5000000, 0x3d800000, 0xee400000, 0x94e00000, 0xe4900000, 0xb3e80000, 0xf9540000, 0xf8ce0000, 0x8fe30000, 0xee118000, 0x712bc000, 0xfc76a000, 0xffff7000, 0xbff83800, 0x817d3c00, 0xaf3a2200, 0x455cef00, 0xaf8a1a80, 0x2604b9c0, 0x4d8681e0, 0x18c618f0, 0x16a68168, 0x68f77234, 0x2a3e380a, 0x465a3c09, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xe8000000, 0x34000000, 0x0a000000, 0xaf000000, 0xc5800000, 0x1fc00000, 0x54e00000, 0x0ff00000, 0xbd380000, 0x775c0000, 0x8e760000, 0x46630000, 0x39b08000, 0x40184000, 0xcd4e6000, 0xb43d7000, 0xcd47f800, 0x44381400, 0x63dcea00, 0x91368900, 0x17c09c80, 0x50e2b440, 0x8df0cf20, 0x5638cb90, 0x50dd41a8, 0x0ab7e2d4, 0xdd01780e, 0x86835403, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x78000000, 0xcc000000, 0x9a000000, 0x93000000, 0x9f800000, 0x24c00000, 0xdde00000, 0xf8f00000, 0x63380000, 0x596c0000, 0xb4460000, 0x05610000, 0x25b08000, 0x0b184000, 0x4cfe2000, 0x76ccd000, 0x99145800, 0xe80aa400, 0x96377200, 0x14194d00, 0x697df480, 0xd10dac40, 0x5377bb20, 0x8039d350, 0x7eef65a8, 0xbc86961c, 0xb282d806, 0x3643e403, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x38000000, 0x2c000000, 0xee000000, 0x29000000, 0x15800000, 0x26400000, 0x79e00000, 0x2a700000, 0x60480000, 0xa1dc0000, 0x63060000, 0x41610000, 0x73b28000, 0xbce94000, 0x04cc2000, 0xc9fe5000, 0x21d60800, 0x163b9c00, 0xb796b200, 0x97db6f00, 0xd1e6ee80, 0x29912640, 0x613944e0, 0x73152c50, 0xe8191068, 0x5045f91c, 0x6b02880e, 0x1283dc0f, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x18000000, 0x1c000000, 0x82000000, 0x43000000, 0x1f800000, 0x63c00000, 0xc3200000, 0xae500000, 0x41180000, 0xc0040000, 0x736e0000, 0x21a30000, 0x83138000, 0x0579c000, 0x1d372000, 0xa6c61000, 0x92cd7800, 0x42b28400, 0xf669b200, 0xd04c5100, 0xbff3d380, 0xaa0aadc0, 0x117e4920, 0xe8583e70, 0x5a6750a8, 0xcf5f46b4, 0x7888f802, 0x543c4409, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x98000000, 0xd4000000, 0xce000000, 0x43000000, 0x11800000, 0xd8400000, 0x14200000, 0x05d00000, 0x4f280000, 0x3c2c0000, 0x4df60000, 0xa0a30000, 0x83128000, 0x68cb4000, 0x489ea000, 0xd9af3000, 0xcbb76800, 0xbf82b400, 0xeb430a00, 0x7da20700, 0x3992c180, 0x0d0a4fc0, 0xaefc4fe0, 0xdd5dbe10, 0x07ccec68, 0xcb4442d4, 0x15fbe806, 0x9086f407, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xf8000000, 0x24000000, 0x3a000000, 0xbd000000, 0x63800000, 0xcc400000, 0xc4600000, 0x18b00000, 0x0ac80000, 0x3b040000, 0xaa1e0000, 0x3de30000, 0x99f18000, 0x752a4000, 0x7bf52000, 0xa6b57000, 0x87577800, 0x60a59c00, 0x028e3a00, 0xeff81f00, 0x3a8c1080, 0xabf8ab40, 0x908ee5e0, 0x5efaa530, 0x2f0db768, 0x8cb88d74, 0x6c6ef80a, 0x4a8bdc0f, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xf8000000, 0x0c000000, 0x12000000, 0x43000000, 0x8a800000, 0xb7c00000, 0x16a00000, 0xad900000, 0x5e080000, 0x71040000, 0xbd3e0000, 0x3a210000, 0x27518000, 0x83284000, 0xead52000, 0x3cd5d000, 0x59d57800, 0x2e56c400, 0xf2166600, 0x62f65500, 0xe8841580, 0xa87c34c0, 0x7f401a60, 0xca634230, 0xd5b111e8, 0x125ae7fc, 0x9cacf802, 0xb62a8407, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x88000000, 0x1c000000, 0x22000000, 0x03000000, 0xbb800000, 0xe9400000, 0x1da00000, 0xf4f00000, 0xa9080000, 0x346c0000, 0x71360000, 0x56230000, 0xb5b08000, 0xf8a94000, 0x5a9ee000, 0x4f3c5000, 0xe7cff800, 0x0cc60400, 0x0ba8a200, 0x491f2b00, 0xea7ec380, 0x606ebd40, 0x6f3523e0, 0x27222f90, 0xb532ba68, 0x3e6abdd4, 0x907f780e, 0x876f4407, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x48000000, 0x6c000000, 0x26000000, 0x4d000000, 0x6e800000, 0x00c00000, 0xf5a00000, 0x13500000, 0x5dc80000, 0xf9a40000, 0x7d9e0000, 0x1b210000, 0xd3928000, 0xc868c000, 0xbaf46000, 0x68569000, 0x8e842800, 0x880d2c00, 0x9e494e00, 0x07e75900, 0xa0fd8580, 0xc1d3d3c0, 0xf30a8660, 0x4d07f7b0, 0x764c65e8, 0x432b517c, 0xdd16a80e, 0x8065ec09, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x18000000, 0x84000000, 0x46000000, 0x85000000, 0x12800000, 0xb1400000, 0x4e600000, 0x6a900000, 0x4ee80000, 0x434c0000, 0xbbd60000, 0x2da30000, 0x75b38000, 0xda1ac000, 0x6f342000, 0x2a707000, 0x173a0800, 0x20c58c00, 0x15881e00, 0x635fef00, 0x607d6c80, 0x768ecbc0, 0x39f765e0, 0x2fd3ac90, 0xae8b9f68, 0x80ddc454, 0x2dbda802, 0x80af3c05, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xc8000000, 0x54000000, 0xd2000000, 0x37000000, 0xbb800000, 0xaa400000, 0x6e200000, 0x51300000, 0xb7b80000, 0x072c0000, 0x9c060000, 0xf3e30000, 0x4b528000, 0x21ab4000, 0x1327e000, 0x44507000, 0xa62b1800, 0xef641400, 0x3770f200, 0xe79a6700, 0xcf1dc180, 0x113d7440, 0xc80f6620, 0xcbb5fc50, 0x2e9bcda8, 0x4d9dbb14, 0x51fe7806, 0x62ef2407, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x68000000, 0x1c000000, 0xe2000000, 0x67000000, 0x9c800000, 0x80c00000, 0x82200000, 0xe6300000, 0x90580000, 0x4f940000, 0xf35e0000, 0x84610000, 0x37d08000, 0x76cbc000, 0x2c3de000, 0x3d33d000, 0xded8f800, 0x30559400, 0x89fdae00, 0x7490d100, 0xbca8fb80, 0xc6edd840, 0x347ba5a0, 0x68a7dd30, 0xfe868828, 0x36b4807c, 0xabed9806, 0x13f9840d, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x98000000, 0xac000000, 0xa6000000, 0x25000000, 0x13800000, 0x21400000, 0xdbe00000, 0x49300000, 0x2f880000, 0xd6540000, 0x3e8e0000, 0xba230000, 0x4d108000, 0xab984000, 0xa84fa000, 0xe282d000, 0x08c12800, 0x81a38c00, 0x78511a00, 0x6a7aab00, 0x8a7d5a80, 0xcf8ad340, 0xe6540ee0, 0xc68c2970, 0x6621e668, 0x73139d34, 0x2298080e, 0x1dce1c03, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x38000000, 0x8c000000, 0x1e000000, 0x9b000000, 0x92800000, 0xfa400000, 0x13a00000, 0xf2b00000, 0x0ca80000, 0x1c140000, 0x092e0000, 0xb8630000, 0x95d28000, 0xd1f8c000, 0x36afa000, 0x5fa0d000, 0x4cb34800, 0xa7a99400, 0x66976600, 0x476f4300, 0x39c29780, 0xe2617c40, 0xd4d15460, 0x4279a8f0, 0xbf6d6de8, 0x15c2c3b4, 0xcc606806, 0xa7d28409, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0x4c000000, 0xfa000000, 0x31000000, 0xa6800000, 0x60c00000, 0x2a600000, 0x71700000, 0x8cb80000, 0x72fc0000, 0x6dd60000, 0x2d230000, 0xd5508000, 0xab694000, 0x07556000, 0xf7e29000, 0xae33d800, 0x4c9aac00, 0x832e9e00, 0xe37cb900, 0x48971a80, 0xdc000440, 0x82037320, 0x45018310, 0x4881afa8, 0x8fc2d254, 0x0be0380e, 0x7c327c07, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x98000000, 0x4c000000, 0xd2000000, 0xe1000000, 0x4b800000, 0x06c00000, 0x9c600000, 0x37500000, 0x96780000, 0x7adc0000, 0xf5160000, 0x6fa30000, 0x5eb08000, 0x24eac000, 0x92452000, 0x21d95000, 0x086f7800, 0xd3ff4c00, 0x84e6ea00, 0x78e9d500, 0xf8449a80, 0x3cdb44c0, 0xd9ec10a0, 0xe03d0490, 0xcd079828, 0x7a791954, 0x58dc580e, 0x3c151c09, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x38000000, 0xec000000, 0x22000000, 0x91000000, 0x26800000, 0x1d400000, 0xa9600000, 0x59500000, 0x47e80000, 0xfcc40000, 0x249e0000, 0x21230000, 0x60b18000, 0x7cf9c000, 0xd7cda000, 0x13c95000, 0x3cf63800, 0x72244c00, 0x1e0c9e00, 0x4eeb8f00, 0x2645a080, 0x03dc68c0, 0xa5432ee0, 0x05602eb0, 0x5b53a868, 0x86e94574, 0xe245980a, 0xd5de1c01, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x28000000, 0x7c000000, 0xee000000, 0xa7000000, 0xe5800000, 0xb5c00000, 0xe0e00000, 0x9e900000, 0x15b80000, 0xd5140000, 0xa05e0000, 0x30210000, 0x3af28000, 0x606ac000, 0x4e0fe000, 0x31fb5000, 0x62354800, 0x0f2ea400, 0x7d8b4a00, 0x101f6100, 0x75006480, 0x0c82a1c0, 0x474060a0, 0x48a19cb0, 0x9fb28628, 0xf9c9387c, 0x173ca80e, 0x2270f401, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xd8000000, 0xcc000000, 0xd6000000, 0x55000000, 0x85800000, 0x0e400000, 0x9fe00000, 0x33700000, 0xc3380000, 0x384c0000, 0xd3660000, 0x2aa10000, 0x40128000, 0x15894000, 0xc3d7a000, 0xcc3a5000, 0x9ecf6800, 0x5da58c00, 0xd6828200, 0xf6c3cf00, 0x60203680, 0x88d24a40, 0x34aac520, 0xd48593d0, 0x75d399a8, 0x0529da9c, 0x90c6c80e, 0x8132dc0f, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xe8000000, 0x44000000, 0x86000000, 0xc5000000, 0x6b800000, 0x74400000, 0x0da00000, 0xd8500000, 0xa4a80000, 0xeedc0000, 0x97060000, 0x8fe30000, 0xb8f28000, 0xb3784000, 0x48346000, 0x5978b000, 0xef360800, 0x61f88c00, 0x2df47a00, 0xdf9a5f00, 0x4e463780, 0xedc36fc0, 0x72e137e0, 0x2f72bfd0, 0xfd39f268, 0x5a944314, 0x05aa6806, 0x535c3c0b, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x3c000000, 0xf6000000, 0x35000000, 0x92800000, 0xc7400000, 0x8a200000, 0x6f100000, 0xcb680000, 0x03640000, 0xccbe0000, 0x43630000, 0x9c308000, 0xa8f8c000, 0x0e4c2000, 0x457b9000, 0xd88e2800, 0xcf988c00, 0x387ede00, 0x7e83b700, 0x29418580, 0xe320acc0, 0x5b93f5e0, 0x612bd230, 0x27c40668, 0x92ef85f4, 0x372a080e, 0x62c71c01, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x18000000, 0x14000000, 0xda000000, 0x35000000, 0x65800000, 0xad400000, 0x6ce00000, 0x08700000, 0x0b880000, 0xae340000, 0x0fae0000, 0x5da10000, 0x12928000, 0x48fac000, 0xe73f2000, 0x505a3000, 0x382c3800, 0x69e03c00, 0x65f10200, 0xcacac300, 0xdcd41680, 0xf0dc9a40, 0x12a98be0, 0xae66e8f0, 0xb3f42768, 0xbb8f4dbc, 0xec73180e, 0xb98a0c01, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x88000000, 0xac000000, 0xa2000000, 0xeb000000, 0x3b800000, 0xcc400000, 0xde200000, 0x10500000, 0xfb880000, 0x426c0000, 0x91160000, 0xc2610000, 0x76718000, 0x6fd94000, 0x47e5e000, 0x127a9000, 0x2ff73800, 0xe1d1a400, 0xe0cb8200, 0xddcf7f00, 0x72073980, 0x5a4a91c0, 0x0d0f3360, 0xa9e7c190, 0xcb7b30e8, 0x2777cb5c, 0xc212d802, 0x74ab3403, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x38000000, 0x34000000, 0xae000000, 0x63000000, 0xf0800000, 0xe8c00000, 0xbc600000, 0x28b00000, 0xa4980000, 0x81640000, 0x10ae0000, 0xf4a30000, 0xc4d08000, 0xa4284000, 0x59fd2000, 0x33ca3000, 0x1d0f6800, 0x0df0b400, 0x1bba8e00, 0x59f50100, 0x16264280, 0x1e8f0b40, 0x1db1eca0, 0x2318adf0, 0x2724c828, 0x6f0d53b4, 0x9cf2480e, 0x3a3a8403, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xd8000000, 0xac000000, 0x9a000000, 0xe1000000, 0xaa800000, 0x28c00000, 0x74a00000, 0x1ad00000, 0x9a780000, 0x79940000, 0xd55e0000, 0x90c10000, 0xe8a38000, 0xa8d3c000, 0xdf782000, 0x3d15d000, 0x2a9ed800, 0x35e0ec00, 0x9132ae00, 0xc449c900, 0xe05d5180, 0x1c4269c0, 0x4361daa0, 0xebf2e3b0, 0x05e8dd28, 0xb60c7f7c, 0x0df8200a, 0xa9d5d001, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x08000000, 0xc4000000, 0xaa000000, 0xd3000000, 0xe0800000, 0x77c00000, 0xae600000, 0x31300000, 0xb0a80000, 0xe8ac0000, 0x28960000, 0x63c30000, 0xac628000, 0xd633c000, 0xe2286000, 0x806f3000, 0x0877b800, 0x5c32e400, 0x812a4e00, 0x98ed9d00, 0xa3b50680, 0x94524d40, 0x0d193e60, 0xb1c74410, 0x0f59aee8, 0x85e54054, 0x86486006, 0x325f3005, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xc8000000, 0x34000000, 0x62000000, 0x55000000, 0x3e800000, 0x15400000, 0xa0200000, 0xd2500000, 0x86880000, 0xb83c0000, 0x9d860000, 0x0b430000, 0xe3238000, 0x7bd0c000, 0x68496000, 0xfbdff000, 0xceb75800, 0x9dbbdc00, 0x5ac62e00, 0xe6626f00, 0x53f2b580, 0x2e18b9c0, 0x8f564b60, 0xeb8906d0, 0x0abce8e8, 0x26c7fc14, 0xf0616002, 0xc4f3f00d, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x18000000, 0x7c000000, 0xea000000, 0x27000000, 0x15800000, 0x25c00000, 0x52e00000, 0x29d00000, 0x31180000, 0x515c0000, 0x28b60000, 0x3ec10000, 0x4d638000, 0xdb13c000, 0xbe7b2000, 0x394d9000, 0xdd4c5800, 0x8b4e3400, 0x664d4a00, 0x84ce0100, 0xac8f7c80, 0xa7aebcc0, 0x369c9b20, 0x0955e510, 0x7c91d5a8, 0x20bafcdc, 0x642d200a, 0x3e5c9001, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x88000000, 0x1c000000, 0x9e000000, 0xa3000000, 0x12800000, 0xd2400000, 0xe0e00000, 0x6fb00000, 0x8ca80000, 0x3b240000, 0x809e0000, 0xa9410000, 0xb6608000, 0xa7f04000, 0x3549e000, 0xef165000, 0xedf40800, 0x8f45f400, 0xda6c4600, 0xcd8a4300, 0x69b5aa80, 0xf0a62d40, 0x295d6460, 0x4862fa30, 0x34f160e8, 0x4fc9307c, 0xd157e006, 0x1b175003, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x08000000, 0x5c000000, 0x86000000, 0xbf000000, 0xe0800000, 0xe8c00000, 0xbe200000, 0xa9100000, 0x1bb80000, 0x6df40000, 0x6bbe0000, 0xd7c30000, 0x1ea08000, 0x21d3c000, 0x359a6000, 0xcce55000, 0x2c056800, 0x3c37e400, 0xca1ffe00, 0x1690e100, 0xc3fbbb80, 0x5316ccc0, 0xb08dc2a0, 0xeb6b6d30, 0x8bee8f28, 0x411bf4f4, 0xde24600e, 0x5b26500d, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0x34000000, 0x6e000000, 0xa1000000, 0xd1800000, 0x90400000, 0xd4e00000, 0xa1d00000, 0x52d80000, 0x2ce40000, 0xa24e0000, 0x34c30000, 0x8b218000, 0x5c70c000, 0xfa68e000, 0x3dac7000, 0xf3936800, 0x053a3c00, 0xafb54200, 0x5a574700, 0x6a06b280, 0x889e84c0, 0x6099b420, 0x4b061cf0, 0x191fcca8, 0xd0da9334, 0x8fe7600a, 0x90cfb005, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x28000000, 0x4c000000, 0x4a000000, 0xa9000000, 0x22800000, 0xfac00000, 0xdb600000, 0xc1d00000, 0x2de80000, 0x861c0000, 0xde860000, 0x8f410000, 0x74228000, 0x25f14000, 0x70186000, 0xa2059000, 0x52821800, 0x72c08c00, 0xc763ae00, 0x93d3a100, 0xe0e82680, 0xa29d5ac0, 0xc74498e0, 0xdfa10bd0, 0x6db36868, 0x29bbec1c, 0xecb4e00e, 0x90b9d00f, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x84000000, 0xd2000000, 0x4f000000, 0x8d800000, 0x16c00000, 0x25600000, 0x34300000, 0x63c80000, 0x57640000, 0x363e0000, 0x35430000, 0x7aa18000, 0x79d0c000, 0x17b92000, 0x008f7000, 0xadcb5800, 0x2e677400, 0x16bd8a00, 0xa9012d00, 0x18802e80, 0x28429540, 0xf82337e0, 0xc2929eb0, 0x341aeb68, 0x49de22f4, 0x7e30a00a, 0xc8cbb005, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xc8000000, 0x54000000, 0xa2000000, 0xd5000000, 0xe8800000, 0x76c00000, 0x29600000, 0x1c900000, 0x01e80000, 0x949c0000, 0xb5460000, 0x2a410000, 0xeda28000, 0x48f2c000, 0x71f86000, 0x89b67000, 0x89b9d800, 0xc916dc00, 0x65cb7600, 0xf02e3900, 0xe61dde80, 0xfa87c7c0, 0x65a15de0, 0xbcf191d0, 0x63f84d68, 0x44b5c31c, 0xfd3ae00e, 0x49d4b001, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x08000000, 0x2c000000, 0x9a000000, 0x5f000000, 0xe3800000, 0xed400000, 0xf9e00000, 0x72900000, 0x27d80000, 0x57fc0000, 0x1f160000, 0x32c30000, 0x16a08000, 0x20734000, 0xb8cae000, 0x7c649000, 0xbb88d800, 0x94861400, 0xab997200, 0xe49ffb00, 0xc647f280, 0x0d3b5dc0, 0xccef9d20, 0x528d4c90, 0xeb5d25a8, 0x28646e54, 0x258a600e, 0xad87d00f, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x78000000, 0x64000000, 0x66000000, 0x89000000, 0x89800000, 0x70c00000, 0x93600000, 0xe0b00000, 0xa1c80000, 0x6f040000, 0xd45e0000, 0x21830000, 0x0cc18000, 0xa160c000, 0x67b1a000, 0xbd487000, 0x94440800, 0xd8fdbc00, 0x52d30200, 0xb4fa6500, 0x8c0f4e80, 0xaf3a6f40, 0x09ec75e0, 0x77c9b330, 0xce041168, 0x61dcb574, 0x4341800a, 0x08a0c005, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x18000000, 0xec000000, 0x9e000000, 0x8f000000, 0xc4800000, 0x91c00000, 0x2ba00000, 0xbdf00000, 0xdd380000, 0xde940000, 0xacbe0000, 0xf6810000, 0x20c28000, 0x30214000, 0xc0b0a000, 0x935bd000, 0x3ac5c800, 0xdd764400, 0xbeac2e00, 0x07a9d500, 0xd07ca980, 0x80a17940, 0xe3719320, 0xc9f826b0, 0xfcb6fca8, 0x4d0c5efc, 0x365a800e, 0xa345400f, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xa8000000, 0x2c000000, 0xf6000000, 0x69000000, 0x1a800000, 0x4a400000, 0x64600000, 0xfb900000, 0xa9680000, 0xe2fc0000, 0xb0a60000, 0x6c830000, 0x63428000, 0x9ee1c000, 0x21d0e000, 0x650a1000, 0x356f6800, 0xefcc7c00, 0xe77ece00, 0xc965c300, 0xb8227880, 0x26f01fc0, 0x007a9be0, 0xbdd6a650, 0x683b2568, 0x62b4d694, 0x4a2a8006, 0x3c1dc00d, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xa8000000, 0x3c000000, 0xce000000, 0x6d000000, 0x9b800000, 0x50400000, 0x98200000, 0xad900000, 0xaa880000, 0x1c7c0000, 0x56860000, 0x30810000, 0x0ac08000, 0x65e14000, 0x2cf06000, 0x5eba5000, 0xd427c800, 0x40d08c00, 0x7128da00, 0x95acaf00, 0x262fe180, 0x8a6f76c0, 0x3c4e6c60, 0x4cdda3d0, 0xd5d67fe8, 0xa5e9e61c, 0xa54e8006, 0x555c4007, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x98000000, 0x7c000000, 0x9e000000, 0x59000000, 0x93800000, 0x67400000, 0x66200000, 0x1f300000, 0x73980000, 0xe12c0000, 0x39660000, 0xe0810000, 0x07c18000, 0xa1e04000, 0x1ed0a000, 0xdd4b9000, 0xa4678800, 0xe1011c00, 0x9f802a00, 0xc1415300, 0xf322c580, 0x8ab38440, 0x31d842a0, 0x8a8c32d0, 0x18140528, 0x66b8299c, 0x9e9f8002, 0x8d3d4007, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x58000000, 0x0c000000, 0xa2000000, 0x0d000000, 0x9d800000, 0xd2400000, 0xc0e00000, 0x19b00000, 0xd7180000, 0x632c0000, 0x54a60000, 0x08830000, 0x23c18000, 0xc0a1c000, 0xdc502000, 0x07295000, 0xc876b800, 0x5868bc00, 0xd5174200, 0xb39bbf00, 0x92ec0a80, 0x91048540, 0x1d514aa0, 0x58a8b8d0, 0x67351a28, 0x0d0bae94, 0x4ae7800a, 0x0a62c001, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xb8000000, 0xac000000, 0x2e000000, 0x83000000, 0x08800000, 0x81400000, 0x7c600000, 0xa7f00000, 0xe8980000, 0xebb40000, 0x227e0000, 0x6b010000, 0x6c828000, 0xdb434000, 0xcd602000, 0xba705000, 0x4e5a0800, 0x3016b400, 0xfbac2e00, 0x508b2700, 0x491d7480, 0x86722e40, 0xc85a1da0, 0x7715dcb0, 0x792def28, 0x68c871fc, 0x3cfe000e, 0x05410007, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0xe4000000, 0x92000000, 0x09000000, 0x3d800000, 0xe2400000, 0xdc600000, 0x6fd00000, 0x73a80000, 0x6f6c0000, 0xc9b60000, 0xb1030000, 0xa9818000, 0x1840c000, 0x79612000, 0x7c52f000, 0xeee9d800, 0x158e6c00, 0x70a6d200, 0xc1087f00, 0x971d7880, 0x11ec0ec0, 0xbb7651e0, 0x00a10310, 0xe1728368, 0xbdda2ed4, 0x0c36000a, 0xe7430005, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x48000000, 0xd4000000, 0xc6000000, 0xe5000000, 0x15800000, 0x33c00000, 0x4e200000, 0x62f00000, 0xd2380000, 0xee440000, 0x6bee0000, 0xb1030000, 0x93808000, 0xb6c0c000, 0x0ba06000, 0x19327000, 0x48184800, 0x4ab48c00, 0x5cd5c200, 0x4ac79900, 0xcbaf7780, 0x49e37340, 0xfad22320, 0x7dca41f0, 0xadfe3ea8, 0x386b97b4, 0xa5ce000e, 0x93f30001, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x88000000, 0x9c000000, 0xb6000000, 0x01000000, 0x94800000, 0xb1c00000, 0x1c200000, 0x20100000, 0xe6f80000, 0x048c0000, 0x2c060000, 0xe6030000, 0x59028000, 0x10824000, 0x63c3e000, 0xbf205000, 0x9f90a800, 0x74badc00, 0x3cee5600, 0x35769500, 0x8d09b780, 0x874670c0, 0xfee35ba0, 0x4bb169d0, 0x28ab7228, 0x1c164014, 0xb8f80006, 0xa98c0003, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x38000000, 0xdc000000, 0xde000000, 0x81000000, 0xd3800000, 0x82400000, 0xe1e00000, 0xbc700000, 0x2d480000, 0xc0840000, 0x069e0000, 0xfa030000, 0x23028000, 0xdc814000, 0x58c22000, 0x54239000, 0xddd00800, 0x2fd97c00, 0x033d4a00, 0xba934700, 0x5fb88e80, 0x820ef640, 0x94ba84e0, 0x4a8e5730, 0x1679e868, 0x2daf4a74, 0x7f280006, 0x0eb4000f, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x68000000, 0x24000000, 0xfa000000, 0xbb000000, 0x05800000, 0x79400000, 0x50e00000, 0x11300000, 0x6d380000, 0xbb540000, 0x2e7e0000, 0x94010000, 0x52008000, 0x7f034000, 0xcf816000, 0xaa413000, 0x71637800, 0x92710400, 0x86dafa00, 0xafe5f300, 0x3a06a680, 0x7fb40740, 0x6d4f7020, 0x863919b0, 0x26d7b4a8, 0xfb3e99fc, 0x2ae00006, 0x6a30000f, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x58000000, 0x64000000, 0x62000000, 0x21000000, 0xb4800000, 0x1a400000, 0x21e00000, 0xf0100000, 0x97280000, 0x26140000, 0xebca0000, 0xc0010000, 0x20008000, 0xd000c000, 0xe8016000, 0x3c00b000, 0x0600c800, 0x4300c400, 0x95804200, 0xaec16900, 0x3ba03480, 0xd1f043c0, 0x6739e020, 0xb13d2e50, 0xcdde4c28, 0x2bcad794, 0xe0000002, 0xf0000001, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0xd8000000, 0x3c000000, 0xee000000, 0x23000000, 0x4f800000, 0x44400000, 0xba200000, 0xc5500000, 0xa9c80000, 0x34240000, 0xd1d60000, 0x58010000, 0xfc018000, 0x4e014000, 0x33002000, 0x9781b000, 0x78407800, 0x5421dc00, 0xe6504600, 0xe6489f00, 0x70648880, 0x6bf77440, 0x9d508aa0, 0x55c8d390, 0x7a252848, 0xe2d783ac, 0xcf800002, 0x84400003, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0xb8000000, 0x7c000000, 0xc2000000, 0x91000000, 0x14800000, 0x97400000, 0xb5e00000, 0x03b00000, 0xa8680000, 0x565c0000, 0x70de0000, 0x58010000, 0xcc018000, 0x0a014000, 0x8501a000, 0x12817000, 0xb840f800, 0xf2618400, 0x11712200, 0x9e482900, 0x774d2e80, 0x6ee76bc0, 0xa5850760, 0x42ead0d0, 0x7482ecb8, 0x61dfc1bc, 0x8c800002, 0xfb400003, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x38000000, 0xa4000000, 0x7a000000, 0xc1000000, 0xb0800000, 0xdbc00000, 0xe1a00000, 0x24500000, 0xaa380000, 0xaea40000, 0x39460000, 0x54010000, 0x92008000, 0xbd01c000, 0xfe812000, 0x58c07000, 0x34214800, 0x3510f400, 0x51598200, 0xdbd56100, 0x6cefb780, 0xb13cc340, 0x21b2c8a0, 0x7a7f9470, 0x9625fd48, 0x4e87428c, 0x23a00002, 0x01500001, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xe8000000, 0x4c000000, 0x6e000000, 0xcf000000, 0xb4800000, 0xbdc00000, 0x07e00000, 0x8cf00000, 0x42380000, 0xe53c0000, 0xaa2e0000, 0xc4010000, 0xd2008000, 0xa901c000, 0x87816000, 0x8f41d000, 0x39209800, 0x5190dc00, 0xbc099e00, 0x14656900, 0x7e237b80, 0x2bf70fc0, 0x7fcc99e0, 0x9317c470, 0x0fbc6a78, 0x70ef645c, 0xdb600002, 0x3d300001, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x88000000, 0x1c000000, 0x92000000, 0xb3000000, 0x33800000, 0x05c00000, 0x72a00000, 0x4b500000, 0x99e80000, 0x1a6c0000, 0x2a560000, 0xaa010000, 0x17018000, 0xc5804000, 0x60c1a000, 0xf4211000, 0x40103800, 0xfc092400, 0xa6dd6600, 0xbc0e6700, 0x15b50b80, 0x87236540, 0x8d03d6a0, 0x741213d0, 0xbc9be4d8, 0x72070cac, 0x10680002, 0xa0ac0003, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x78000000, 0x0c000000, 0x12000000, 0x6d000000, 0x71800000, 0xd7400000, 0x6c600000, 0xdc900000, 0x2ff80000, 0x07a40000, 0xb2b20000, 0x86010000, 0x23018000, 0xe6814000, 0x8fc06000, 0xaca0f000, 0x14b01800, 0x91882400, 0x3f0cda00, 0x504ee300, 0x54a6ae80, 0x88ba58c0, 0xb74c7920, 0xd0aefff0, 0xf6f6df48, 0x20636d64, 0x6a180002, 0xf0740003, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x78000000, 0x3c000000, 0xbe000000, 0xc1000000, 0xc0800000, 0xf9400000, 0xbea00000, 0x74900000, 0x2c880000, 0x3fbc0000, 0x73660000, 0x41010000, 0x00818000, 0x9940c000, 0x2ea12000, 0x0c90f000, 0x10887800, 0x81bd7c00, 0xb2678200, 0x81808100, 0xf9c07280, 0x27e1bd40, 0x5a31c920, 0x2018a910, 0x2f340778, 0xf2db9acc, 0xf3660002, 0x81010003, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0x74000000, 0x62000000, 0xab000000, 0x55800000, 0x9bc00000, 0x91e00000, 0xe9f00000, 0x38880000, 0xbba40000, 0x37060000, 0x0b010000, 0x25808000, 0x83c0c000, 0x9de0a000, 0xd7f05000, 0x8588e800, 0x2724c400, 0x52475600, 0x54a1ab00, 0xc651b780, 0xc359e3c0, 0xf73d73e0, 0x63da2110, 0x022a9f48, 0x3ea32a0c, 0xff060002, 0x6f010001, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xb8000000, 0x2c000000, 0xae000000, 0xb7000000, 0x95800000, 0x8ac00000, 0xe8200000, 0x1e900000, 0x6d880000, 0x8f240000, 0xe0b60000, 0x4f010000, 0x99818000, 0x94c1c000, 0xb720a000, 0x1f117000, 0x65485800, 0x7e055c00, 0xdca76e00, 0x3dc82b00, 0x74449580, 0x82c61040, 0x8b399d20, 0x643c2b10, 0x9e1a8648, 0x66933d6c, 0x15360002, 0x55c10003, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x98000000, 0x54000000, 0xaa000000, 0x7f000000, 0xa8800000, 0x6dc00000, 0x93e00000, 0x76300000, 0x3aa80000, 0x44540000, 0x51a60000, 0x0b010000, 0x52818000, 0x2ac14000, 0xff612000, 0x29f13000, 0x8248a800, 0x30e55400, 0x79cefe00, 0x74345100, 0x18d75b80, 0x888967c0, 0x9f844c60, 0x683e0550, 0x327c00a8, 0x1a33474c, 0xda460002, 0xe9310003, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xd8000000, 0x44000000, 0x3a000000, 0x53000000, 0xe7800000, 0x60400000, 0x91e00000, 0xd7d00000, 0x8d580000, 0x4a5c0000, 0x48d20000, 0x29010000, 0x94818000, 0xb7c1c000, 0xf9a1a000, 0xda31b000, 0x24888800, 0xae047400, 0xb60ea600, 0xe612cf00, 0x4c204080, 0x657163c0, 0x14e9cfa0, 0xe4950ab0, 0xfc37acb8, 0xeb5f6da4, 0xa58a0002, 0x735d0003, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xa8000000, 0xec000000, 0x82000000, 0x53000000, 0x58800000, 0xbec00000, 0x27a00000, 0xb6100000, 0xeb380000, 0x5d3c0000, 0x861e0000, 0x01010000, 0xf3808000, 0xb240c000, 0x2f60e000, 0x04b15000, 0x38a9d800, 0x81450400, 0x49c2a600, 0xf0efb100, 0x36c8fd80, 0x66740f40, 0x1b2b4c20, 0x1acb6670, 0x15bbb278, 0x7f32903c, 0xa7260002, 0xd33d0001, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x68000000, 0x6c000000, 0x62000000, 0x23000000, 0x7e800000, 0x19400000, 0xd4600000, 0x16300000, 0x44280000, 0xa9ac0000, 0xbd3a0000, 0xb9010000, 0xe9808000, 0xe1c1c000, 0x1021e000, 0x95d0d000, 0x7ad8d800, 0x3c24c400, 0xec864600, 0xfcc3fd00, 0xb275b280, 0x8c9ee8c0, 0x4a470c60, 0x2c623850, 0xf7e51b58, 0xe3a7c674, 0x0d920002, 0x06ed0001, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x88000000, 0x44000000, 0xa2000000, 0x5b000000, 0xae800000, 0xa3c00000, 0xaba00000, 0x8b100000, 0x1d880000, 0x0e0c0000, 0xf8720000, 0xdd010000, 0xa7808000, 0x6e414000, 0x7ae02000, 0xed711000, 0x80388800, 0xcf154400, 0xbdb6b600, 0x8d9e5d00, 0x0182c780, 0x29f99740, 0x2bb4f620, 0x12264b10, 0x3cd6a418, 0x20aeace4, 0xe65a0002, 0x4c1d0001, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x28000000, 0x04000000, 0xa2000000, 0x35000000, 0x6b800000, 0x92c00000, 0x14e00000, 0xfcd00000, 0xb1380000, 0x57740000, 0x69b20000, 0xdb010000, 0x88818000, 0xa641c000, 0x6ca16000, 0x9b705000, 0xfac80800, 0xc7fd4400, 0xd4ee6a00, 0x2b9fd700, 0x0357a580, 0x39ab69c0, 0x32c5d9a0, 0x019a1270, 0x272d56e8, 0x2bd72f64, 0x0fea0002, 0x26650003, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x08000000, 0x24000000, 0x76000000, 0xeb000000, 0x9d800000, 0x30c00000, 0x71a00000, 0x8bd00000, 0x0fc80000, 0xa2bc0000, 0xdbe20000, 0x1d810000, 0xf0c18000, 0xd1a14000, 0x7bd1e000, 0x07c81000, 0x86bc4800, 0xade2ec00, 0xf680d600, 0x6d40bb00, 0xe1612180, 0x0a710340, 0x8c1907a0, 0x89745790, 0x0f5fa978, 0x2d6361c4, 0x70c18002, 0x11a14003, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x48000000, 0x7c000000, 0x52000000, 0x2b000000, 0x89800000, 0xe6400000, 0x03200000, 0x29f00000, 0xb3480000, 0xafa40000, 0x20c20000, 0x61810000, 0xea408000, 0x39204000, 0x4ef06000, 0x20c89000, 0x1ee4f800, 0xf862a400, 0x85315600, 0xd3a99300, 0x59358c80, 0xde5a6640, 0xc71dc3e0, 0x672f1e90, 0x0f66bb48, 0x0143f784, 0xabc08002, 0xe3604001, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xe8000000, 0x34000000, 0xbe000000, 0xd5000000, 0x9e800000, 0xf8c00000, 0xba200000, 0xec300000, 0x5f180000, 0x85e40000, 0xe12e0000, 0x4a810000, 0x56c18000, 0xe720c000, 0x96b1a000, 0xf1d9d000, 0xdec46800, 0x2d9f7c00, 0x3858aa00, 0xf784bd00, 0x12ff3180, 0x3909d440, 0xcecd8860, 0x87d21630, 0x744ad7c8, 0x7e6f385c, 0x84e18002, 0xff10c003, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x48000000, 0xc4000000, 0xfa000000, 0xf1000000, 0x2b800000, 0x26400000, 0xd1200000, 0xf0900000, 0xe2a80000, 0x1acc0000, 0x5ad60000, 0xb9810000, 0xe3408000, 0xf8a1c000, 0xfbd0a000, 0x6e089000, 0x031d8800, 0x49dff400, 0xaf1ce200, 0x87ded700, 0x5c1c8c80, 0x815f8240, 0x27ddb120, 0xb93e6d50, 0x26ed9198, 0x57c6ffac, 0x02688002, 0x102dc001, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xd8000000, 0x6c000000, 0x26000000, 0xdf000000, 0x1f800000, 0x73c00000, 0x88e00000, 0x57300000, 0xcf980000, 0xb5140000, 0x10c20000, 0x91810000, 0xc8c08000, 0x6560c000, 0x21f12000, 0x79f9b000, 0x3d64d800, 0x1dfa4c00, 0x5784be00, 0xd7cabf00, 0xaa9d2780, 0x0b9eb1c0, 0x7ffede60, 0x9a8fe730, 0xed37d628, 0xf6732784, 0x66d88002, 0x50b4c001, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xa8000000, 0x44000000, 0x5a000000, 0x17000000, 0xb2800000, 0x02c00000, 0xa3600000, 0x6ff00000, 0x4d880000, 0x212c0000, 0xbe2a0000, 0x2c810000, 0x0fc08000, 0x66e0c000, 0x2fb1e000, 0x44295000, 0xa9bc8800, 0xc652b400, 0x57252e00, 0x2247e500, 0xf68bc580, 0xaf9126c0, 0x42f9cfe0, 0xad653310, 0x8ce64658, 0x049b8a54, 0x61288002, 0x683cc001, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xf8000000, 0xd4000000, 0xea000000, 0x33000000, 0xd8800000, 0x30400000, 0x9ae00000, 0xd0100000, 0x4b180000, 0xc7240000, 0xfbb60000, 0x36810000, 0x21418000, 0xfd614000, 0xf6d1e000, 0xc0b9f000, 0xb255a800, 0x627fd400, 0x231d6600, 0x8fa23100, 0x9b1e2080, 0xf7cc55c0, 0xf01a9020, 0x3fca9e30, 0x84f2ca48, 0x7666096c, 0x62b98002, 0xcd554003, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x38000000, 0x6c000000, 0x12000000, 0x73000000, 0xd0800000, 0x90c00000, 0x0a600000, 0x0ad00000, 0x93680000, 0xf4c40000, 0xd68e0000, 0x83810000, 0x90408000, 0x02a14000, 0xfcb12000, 0xb3b87000, 0x78acd800, 0xe0ca2400, 0xb6cfe600, 0xc9202100, 0x08f0e180, 0x671874c0, 0xb11d45a0, 0x8ef38ed0, 0xef221588, 0x10caef1c, 0xfece8002, 0xad204001, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x48000000, 0x24000000, 0x3e000000, 0x23000000, 0x7c800000, 0x8dc00000, 0x29600000, 0x38900000, 0x9f680000, 0xe7840000, 0x6f5e0000, 0xfb810000, 0x0f418000, 0x27a14000, 0x1d70e000, 0x62389000, 0x758c4800, 0x8e4a7c00, 0x28b74600, 0x6fc47900, 0xca7fdb80, 0xe830f2c0, 0x48998120, 0xaf7ca6d0, 0x01331b08, 0xab9b74bc, 0xc97f8002, 0x24b04003, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x08000000, 0xf4000000, 0x3a000000, 0x81000000, 0x3b800000, 0x69400000, 0xc7a00000, 0xbab00000, 0x5f080000, 0x77340000, 0xb7360000, 0xee810000, 0x78c18000, 0xf7e1c000, 0x8a906000, 0x4af81000, 0xa09de800, 0xfa327400, 0xd57e0200, 0x7414f700, 0x2c469280, 0xb1e92f40, 0x2a248560, 0x828e8610, 0xfebc1268, 0x44c3886c, 0x60578002, 0xa7d0c003, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x68000000, 0x04000000, 0xc6000000, 0x69000000, 0x35800000, 0x7f400000, 0x7ba00000, 0x8d300000, 0x1f880000, 0x6aac0000, 0x458e0000, 0x20810000, 0xa0c08000, 0x4fe1c000, 0xfc112000, 0xd978d000, 0x40440800, 0x60f38c00, 0xe517d200, 0x4dd5eb00, 0xa0cbbe80, 0xc7f31740, 0x6d976a60, 0x4914a710, 0x592b3158, 0xaae2e51c, 0xed6e8002, 0xb410c001, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x58000000, 0x74000000, 0xaa000000, 0x1d000000, 0x84800000, 0x1a400000, 0xfe600000, 0xd1500000, 0x6eb80000, 0xd93c0000, 0x4fca0000, 0x83810000, 0xbbc18000, 0x44a14000, 0x3771e000, 0x7088b000, 0x3c54e800, 0x550f5400, 0x72973a00, 0x381b8900, 0xf679f480, 0x3e1cdcc0, 0xf37bb2a0, 0x4fa86570, 0x34e53e78, 0x93265994, 0x10b38002, 0x331c4003, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xc8000000, 0x4c000000, 0x6a000000, 0x8b000000, 0xe9800000, 0x79400000, 0x3d600000, 0xbfb00000, 0xe5c80000, 0xd8940000, 0xc9b60000, 0xb8810000, 0x03c18000, 0x09a04000, 0xcd902000, 0x4e199000, 0xac6c9800, 0x0e2ad400, 0x66821600, 0x19a75300, 0x91d83280, 0xc7cd9ac0, 0x24ba8f60, 0xbb1be390, 0x8f8aed28, 0x0712096c, 0x0dbf8002, 0x6eb54003, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x18000000, 0xac000000, 0x52000000, 0xb9000000, 0x16800000, 0x73c00000, 0x2be00000, 0xb0700000, 0x4eb80000, 0x68c40000, 0x59060000, 0xb5810000, 0xb8408000, 0x38a14000, 0x87506000, 0x9ca83000, 0xb44d5800, 0xdadaa400, 0xc3927200, 0xe4afad00, 0xfb4c2780, 0xe35bf7c0, 0x59d370e0, 0xdd0e1570, 0xf69ddd88, 0x46339c0c, 0xd37e8002, 0xf3244001, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x58000000, 0x3c000000, 0xae000000, 0xdd000000, 0xd5800000, 0xa8400000, 0xcbe00000, 0x25700000, 0x65d80000, 0xa70c0000, 0xf4660000, 0x72810000, 0x7ac18000, 0x4121c000, 0x0c51a000, 0xdd88b000, 0xb0847800, 0x0be35c00, 0xdfe2ba00, 0x05e32b00, 0xf2e21080, 0xb86377c0, 0xeea21ae0, 0xb982e3b0, 0x84d23a18, 0x7adb26cc, 0x831f8002, 0x389cc003, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x48000000, 0x24000000, 0x1e000000, 0x31000000, 0x89800000, 0x53c00000, 0xc9a00000, 0xe0300000, 0xa5e80000, 0xe8040000, 0xced60000, 0x5bc10000, 0x8da18000, 0xee314000, 0x6ce96000, 0x0d849000, 0xa7164800, 0xbd613c00, 0xd511e200, 0x91985300, 0x1e8dc780, 0xeac30340, 0xb90e8860, 0x7d2df7d0, 0x1df37208, 0x6867aeac, 0xc5696002, 0x2e449003, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xe8000000, 0x34000000, 0x9e000000, 0xe1000000, 0xbe800000, 0xc3400000, 0xb0600000, 0xac900000, 0xdfa80000, 0xea1c0000, 0x9a0a0000, 0xcf410000, 0xd2618000, 0x9791c000, 0x66292000, 0xaaddd000, 0xfdaa6800, 0x6ff03c00, 0x4eb84200, 0x7374bd00, 0xbab6a680, 0x097bb0c0, 0x09b9b120, 0xd0f4c350, 0x1d76f638, 0x7d5bb914, 0x96c92002, 0x740dd003, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xe8000000, 0x64000000, 0xea000000, 0xb7000000, 0x32800000, 0xa2c00000, 0x51a00000, 0xc5500000, 0x0de80000, 0xe0d40000, 0xb5fa0000, 0x28c10000, 0x16a08000, 0xffd1c000, 0x7b296000, 0xb375d000, 0xa3aac800, 0xfda8d400, 0xe3b5ee00, 0x290ba500, 0x34792580, 0xf99df340, 0x79fe82a0, 0x3e93afd0, 0x98d4ffa8, 0x29fa86f4, 0x1ec16002, 0x77a1d001, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0x84000000, 0x92000000, 0x9b000000, 0xec800000, 0x60c00000, 0x49e00000, 0x7fd00000, 0xba680000, 0xfeac0000, 0xf6160000, 0x8ec10000, 0xbce08000, 0x26504000, 0xa3286000, 0x9e0c5000, 0xc1670800, 0x87d82400, 0xd955b600, 0x2ef39900, 0xc9cba180, 0x28cf43c0, 0x181437a0, 0x8252f0d0, 0xf8bbbb58, 0x30d68d2c, 0xa6206002, 0x10b05001, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x58000000, 0x84000000, 0x3a000000, 0x15000000, 0xf5800000, 0xea400000, 0x5b200000, 0xfeb00000, 0x1e780000, 0x26740000, 0x945e0000, 0x0f410000, 0x36a18000, 0xb0f04000, 0x0f58e000, 0x95c4b000, 0xfba70800, 0xf9757400, 0xecdfaa00, 0xb480ab00, 0xcdc0b480, 0x58604640, 0x9e101560, 0x7d88f8f0, 0x07ad6ee8, 0x695ab7bc, 0x2106e002, 0x4f85b003, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xe8000000, 0x9c000000, 0xd2000000, 0x6f000000, 0x56800000, 0xebc00000, 0x08a00000, 0x12700000, 0xff780000, 0xcbb40000, 0xcc260000, 0xd4c10000, 0x66218000, 0x9db1c000, 0xa1d9e000, 0x10c5d000, 0x44df3800, 0x1f34a400, 0x70e75e00, 0xeee06d00, 0xc991b780, 0xa3680140, 0x0f9cfce0, 0x23db8af0, 0x814b7168, 0x12a2114c, 0x37ffe002, 0x0704d003, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x38000000, 0x14000000, 0xc2000000, 0x93000000, 0x34800000, 0xddc00000, 0x37600000, 0xa2300000, 0xb8080000, 0xa8040000, 0x0ca60000, 0x46c10000, 0xcfe08000, 0xf9f14000, 0x1669e000, 0x81b47000, 0x8bee2800, 0x55648400, 0xf197a600, 0x4c482900, 0x2324db80, 0x49b75ec0, 0xcdd98c60, 0x4dfc0410, 0xe8cb1e08, 0xbcd3144c, 0xcc4fe002, 0x39b57001, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x58000000, 0xb4000000, 0xae000000, 0xcf000000, 0xb0800000, 0xe3400000, 0xe6e00000, 0x14300000, 0x47580000, 0xc9540000, 0x803e0000, 0x32410000, 0x61618000, 0x63f0c000, 0x44f9e000, 0x1884b000, 0x79d76800, 0x3e0c5c00, 0xb16a1e00, 0x967ea100, 0x5520a680, 0x21903dc0, 0x8d886060, 0xde3c82b0, 0xf833d4a8, 0x002b557c, 0xcd9fe002, 0x1c91b003, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0x84000000, 0x56000000, 0x4f000000, 0x39800000, 0xa3400000, 0x2ce00000, 0xb3900000, 0x90080000, 0xc25c0000, 0x31860000, 0x92410000, 0x06608000, 0x5b514000, 0x36a86000, 0xb3ad3000, 0x0cdf0800, 0x19b5ac00, 0x25ca1e00, 0xe28e3300, 0x539ca680, 0x31a6a9c0, 0x71704f20, 0x98985c10, 0x05d462b8, 0xab9bd40c, 0x78a66002, 0x4ff03001, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x88000000, 0xf4000000, 0x62000000, 0xe3000000, 0x91800000, 0x11400000, 0xdb200000, 0xf3b00000, 0x0f180000, 0x31cc0000, 0xe2e20000, 0xa8c10000, 0x8e618000, 0xb291c000, 0xf3a92000, 0xb1551000, 0xb76fe800, 0x8183c400, 0xb6d14600, 0x68096300, 0x4924c280, 0x87978640, 0x639e1f60, 0x64bbb230, 0xfe2c2198, 0xe93240c4, 0x0448a002, 0xb684d003, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xc8000000, 0x8c000000, 0x7a000000, 0xd3000000, 0xc4800000, 0x31c00000, 0x56600000, 0x6f300000, 0xc4b80000, 0xd0ec0000, 0x7b920000, 0x4d410000, 0x43a18000, 0x5f514000, 0xfa886000, 0x47d59000, 0xa83f1800, 0xf873f400, 0x20312600, 0x42394900, 0xd62d4380, 0x2f735cc0, 0x72b15660, 0x4af9e570, 0x6fcdb3d8, 0xf102b824, 0x27a9e002, 0x0a44d003, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x38000000, 0x5c000000, 0x4a000000, 0x5b000000, 0x7a800000, 0xe4c00000, 0x48600000, 0x36300000, 0xc1880000, 0x109c0000, 0x87a60000, 0xd2410000, 0xfea18000, 0xc951c000, 0xaf38a000, 0x0ad47000, 0xb3dab800, 0x96179400, 0x84883600, 0x8f1cb500, 0x8ce6a980, 0x196140c0, 0x37b12460, 0xefc86f10, 0xd43ca338, 0x9df73c4c, 0x33f92002, 0x3eb5b003, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xb8000000, 0xcc000000, 0x52000000, 0x3f000000, 0xbb800000, 0x00c00000, 0x13e00000, 0x76100000, 0x8a180000, 0x1a5c0000, 0x8c720000, 0x8f410000, 0xad218000, 0x98f1c000, 0xb088e000, 0x5f057000, 0x1b0f9800, 0x0bc3a400, 0x5ae8fe00, 0x1ed53700, 0xad772180, 0x894eb7c0, 0x9a628420, 0xb5596830, 0xef7c4eb8, 0xa88241e4, 0xd5c96002, 0x0124b003, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x68000000, 0x2c000000, 0x6a000000, 0x2b000000, 0x9e800000, 0x51400000, 0xdaa00000, 0x97700000, 0x80d80000, 0x864c0000, 0xa24a0000, 0x45c10000, 0xb0e08000, 0xeb504000, 0x72e8e000, 0xf234d000, 0xde765800, 0xb8d3d400, 0x97add600, 0xec9bfd00, 0xc0e90280, 0xfd350540, 0x56f7e6e0, 0xb0926db0, 0xbc8cde98, 0xf22ab794, 0x8ad06002, 0x83289001, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x48000000, 0x24000000, 0x7a000000, 0x71000000, 0xda800000, 0x35400000, 0xafe00000, 0x28500000, 0x87c80000, 0x0c9c0000, 0xed960000, 0x85c10000, 0x93a08000, 0xd131c000, 0xb4d8e000, 0x67b49000, 0x46da4800, 0x7a5ff400, 0xf15d6200, 0xf236f500, 0x7af04a80, 0x6479afc0, 0x390548a0, 0x67c35390, 0xf64b9f38, 0xeab7442c, 0x12b06002, 0xaf195001, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x88000000, 0x9c000000, 0x22000000, 0x71000000, 0xc3800000, 0x60400000, 0x48a00000, 0x7e700000, 0xe8c80000, 0x9ea40000, 0xac220000, 0x99c10000, 0x5de18000, 0x1350c000, 0x01f96000, 0xba4d1000, 0x20373800, 0x654b4400, 0xbe946200, 0x9f4ac700, 0xab946080, 0x0acb6140, 0xb4d514e0, 0x5aea4d90, 0x84654b48, 0x7b43e544, 0x3d50e002, 0xcaf9d003, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xe8000000, 0x7c000000, 0xca000000, 0xd7000000, 0xbd800000, 0x5e400000, 0x8b200000, 0xb2700000, 0xdf580000, 0xe0a40000, 0xc7560000, 0x95c10000, 0xe8608000, 0x63d0c000, 0x36e8a000, 0x7e9dd000, 0xa8a2f800, 0x22be9400, 0x28dc2e00, 0x4f833b00, 0xd2cfdc80, 0x0c85e640, 0x30a60ce0, 0xe0d9b2b0, 0x65e40b48, 0xe3f6b3ac, 0x6af02002, 0x5f991001, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x68000000, 0x0c000000, 0xf2000000, 0x7d000000, 0x71800000, 0xf2400000, 0x01600000, 0x45b00000, 0xb0c80000, 0x8fe40000, 0x2fca0000, 0xadc10000, 0xd4218000, 0xe4514000, 0xd4b8a000, 0xd90cd000, 0x997e1800, 0x7732e400, 0x3aac7a00, 0xa46e2300, 0xf06b0480, 0xfad0f2c0, 0x1a788360, 0xc3ad7d90, 0x1bee71c8, 0x152b8e94, 0xc3312002, 0x4a099003, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xe8000000, 0x44000000, 0x42000000, 0x7b000000, 0x9e800000, 0x4b400000, 0x5da00000, 0x55500000, 0xaf980000, 0x09740000, 0x0c9a0000, 0xbbc10000, 0xabe18000, 0x4f71c000, 0xa409e000, 0xc68dd000, 0x025e8800, 0x52338400, 0x989c7600, 0xd0677d00, 0x1e17b680, 0x239e0b40, 0xced2b2a0, 0xbf6df330, 0xee2e10e8, 0x24bbaa34, 0xe3506002, 0x5e981003, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x38000000, 0xd4000000, 0xfa000000, 0xf9000000, 0x6d800000, 0xa3c00000, 0x0d200000, 0xb0900000, 0x33880000, 0xc7bc0000, 0x9a820000, 0x87410000, 0x1b618000, 0x1a704000, 0xbc39e000, 0x51a47000, 0x2d37a800, 0x7abef400, 0x9f037200, 0xf8801b00, 0x20416780, 0x8de1ca40, 0xd9315920, 0x75584b10, 0x8ed42178, 0x1a8fe804, 0x67da6002, 0x05953003, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xc8000000, 0xd4000000, 0x26000000, 0x35000000, 0x4e800000, 0x5d400000, 0xe7e00000, 0x1ef00000, 0x9e480000, 0x93e40000, 0x12120000, 0x7ec10000, 0xa8208000, 0xb651c000, 0x64582000, 0xa0dd9000, 0xd87fa800, 0x63974c00, 0x08e3ea00, 0xae88dd00, 0x2ac5da80, 0x14c3bfc0, 0x6ed925e0, 0x539dc890, 0x3e9f69c8, 0x05e7bf24, 0x36eaa002, 0x400d5001, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x18000000, 0xe4000000, 0x72000000, 0xa1000000, 0xd7800000, 0x67c00000, 0xe8600000, 0x40900000, 0xc6680000, 0x18a40000, 0xf6b60000, 0xc5410000, 0x82218000, 0xe2314000, 0xe719a000, 0xd69c3000, 0x209bc800, 0x0883e400, 0x8e9fc200, 0xa5446f00, 0x78e7af80, 0x60c800c0, 0xfbd55920, 0xf18fd0d0, 0xe8ecff48, 0xa622546c, 0x31ee2002, 0xe47c7003, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xb8000000, 0xfc000000, 0x3a000000, 0xdd000000, 0x06800000, 0xf1400000, 0xf9a00000, 0x8d900000, 0x31780000, 0xa3ec0000, 0x4a9e0000, 0x5ec10000, 0x60608000, 0xc671c000, 0x08c8a000, 0xb7c57000, 0xf76bf800, 0x0e437400, 0x1d363a00, 0x18f44d00, 0x0a020280, 0x0616e340, 0x1224b320, 0xcddbdef0, 0xb7eb11d8, 0x5803063c, 0xdf162002, 0x32a5b001, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xf8000000, 0x64000000, 0x2e000000, 0x3d000000, 0x8e800000, 0x01400000, 0xfaa00000, 0x36f00000, 0x18d80000, 0xcfcc0000, 0x99ca0000, 0x7cc10000, 0xd8608000, 0xdb90c000, 0x61c9a000, 0xcd45f000, 0x212ec800, 0x929f5c00, 0xcee7fa00, 0x92da5d00, 0x2948e280, 0x4d05e540, 0xaf0e35e0, 0x9e2ff5b0, 0x031f0198, 0xae278094, 0x40bb2002, 0x81d83001, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xa8000000, 0xb4000000, 0xf2000000, 0x59000000, 0x83800000, 0x87c00000, 0xa6a00000, 0xa9700000, 0x06d80000, 0xa91c0000, 0xcc360000, 0x87410000, 0x0fe08000, 0x1991c000, 0xc7c82000, 0x8b955000, 0xf9436800, 0xb012e400, 0x1dfb3200, 0xd85f4700, 0x78256f80, 0x30bb7d40, 0x82bf8ae0, 0x0c3471b0, 0x6fb37c38, 0x870a416c, 0x0146a002, 0x7b999001, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xd8000000, 0x34000000, 0x26000000, 0x75000000, 0x50800000, 0x72400000, 0xc0a00000, 0x12700000, 0x9ac80000, 0xbd740000, 0x714e0000, 0xa8a10000, 0xbe708000, 0xe8c8c000, 0xde746000, 0x8ccfb000, 0xbe616800, 0x2a90cc00, 0x4f182a00, 0x064cc100, 0xd9335480, 0xb2fae940, 0xe10fe8e0, 0xc3009f90, 0xed81fbe8, 0x9ec1161c, 0x48e16802, 0x6dd0cc01, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x38000000, 0xfc000000, 0x1a000000, 0xf7000000, 0xdb800000, 0xaa400000, 0x7a200000, 0x9e900000, 0xd8580000, 0xa14c0000, 0x396a0000, 0xc6210000, 0xe4918000, 0xbf594000, 0x72cc6000, 0x572a7000, 0x5a00f800, 0x9701b400, 0x4b80ae00, 0xa241d700, 0xbe212480, 0x78910c40, 0x35590920, 0x8dcc5eb0, 0x48aaf598, 0x16402654, 0x0020f802, 0xf991b403, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x18000000, 0xcc000000, 0xa2000000, 0xfb000000, 0xae800000, 0xf5c00000, 0x48a00000, 0x9d300000, 0x47480000, 0x2c840000, 0xf9560000, 0xf4a10000, 0xd7318000, 0x58494000, 0x64052000, 0x81963000, 0x87809800, 0x4840c400, 0xf7e0b600, 0xc6507d00, 0x1fd9db80, 0xcd7d0940, 0x90da7e60, 0xc9927890, 0x54178408, 0x1cc1d92c, 0x55209802, 0xb270c403, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x58000000, 0xfc000000, 0x5e000000, 0x89000000, 0x97800000, 0x9cc00000, 0x0b600000, 0x8dd00000, 0xddc80000, 0x21840000, 0xf2a60000, 0x2f610000, 0xefd18000, 0xaac94000, 0x0f046000, 0xa1e6b000, 0x44c0f800, 0x37613c00, 0x73d05200, 0x64c94f00, 0xee058980, 0x9267eec0, 0x7a00a7a0, 0xeb012990, 0xe0802c08, 0xb240bccc, 0x5820f802, 0xe6713c03, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x68000000, 0x44000000, 0x6a000000, 0x1b000000, 0x42800000, 0x03400000, 0x0ea00000, 0x72d00000, 0x80380000, 0x5b4c0000, 0xe3c20000, 0x82a10000, 0x8cd08000, 0x0938c000, 0xdecde000, 0xe402d000, 0xba418800, 0xc3205400, 0xa110f600, 0x4ad96500, 0x23bcd680, 0x276a9540, 0x64f531a0, 0x1c4fb670, 0xa703f398, 0xf4c1a104, 0x7e618802, 0x46b05401, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xa8000000, 0x84000000, 0x4a000000, 0xfd000000, 0xe8800000, 0x34400000, 0x26a00000, 0x03100000, 0x64480000, 0xf4f40000, 0x71d20000, 0x88a10000, 0x84108000, 0xa9c94000, 0xd435a000, 0x05335000, 0x9e100800, 0xbcc81400, 0x18b4ba00, 0xab727100, 0xedb03880, 0xd359c540, 0x02bdd220, 0x84269290, 0x77f268e8, 0x0bf00324, 0x54f80802, 0x5f2c1401, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x68000000, 0x54000000, 0x42000000, 0xcb000000, 0xf9800000, 0x23400000, 0x90600000, 0xf3500000, 0x33f80000, 0x210c0000, 0xd6860000, 0x16610000, 0xa2508000, 0xdd79c000, 0x1dcde000, 0x84a6d000, 0x13d1a800, 0xfa380400, 0xb7ac5600, 0x70f61300, 0xa7a99680, 0x257508c0, 0x81caa2a0, 0x840711f0, 0x7ca0e118, 0x9970038c, 0x1a49a802, 0xf7640401, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xa8000000, 0x24000000, 0x4e000000, 0x9d000000, 0x80800000, 0x44400000, 0x9d200000, 0x72700000, 0x10180000, 0x7c840000, 0x9d4a0000, 0x6f210000, 0xed718000, 0xc7994000, 0xdb456000, 0xf1ab5000, 0x60b14800, 0x18791c00, 0xd9547a00, 0xd8626100, 0x2b1cd880, 0x9e0ef240, 0xb28a38e0, 0x57c0fa30, 0xa4e06808, 0x3b91da14, 0xa3094802, 0x0fcd1c03, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x98000000, 0x74000000, 0x1e000000, 0xbd000000, 0x33800000, 0x36c00000, 0xae600000, 0x20500000, 0xe8080000, 0x66e40000, 0x7bf20000, 0xd3610000, 0x33d08000, 0x6ec8c000, 0x8085a000, 0xb7a33000, 0x5169e800, 0xf634bc00, 0x9bbbba00, 0x56a4c700, 0x1cd3dd80, 0xb19074c0, 0xbee95ca0, 0xa2f55a10, 0x1adbe2c8, 0x42749664, 0xca9be802, 0xb555bc01, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xa8000000, 0x7c000000, 0x62000000, 0x97000000, 0x13800000, 0x86400000, 0xdee00000, 0xd7900000, 0xd8180000, 0x037c0000, 0x5a860000, 0x81e10000, 0xe8108000, 0x84594000, 0x2e9d6000, 0x28975000, 0x56b9f800, 0xd30c4400, 0x0b8e6e00, 0x3c444700, 0x4ccadc80, 0x590f05c0, 0x70858b20, 0x4aea0e30, 0x36bff9f8, 0x822ccd8c, 0x97bff802, 0x58ad4401, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x38000000, 0xfc000000, 0x8a000000, 0x1f000000, 0x0d800000, 0xe3c00000, 0xede00000, 0xb0500000, 0xf9480000, 0xca540000, 0xfc020000, 0x8ee10000, 0xf7d18000, 0x6588c000, 0x9a356000, 0x97927000, 0x6648f800, 0x07d49400, 0x7fc2fe00, 0xd3007b00, 0x7f803780, 0x60c0e3c0, 0xda6114a0, 0x7491bc90, 0xe52877a8, 0x13c52b84, 0xf7aaf802, 0xf9659403, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xc8000000, 0xb4000000, 0x2e000000, 0xe9000000, 0xff800000, 0x94c00000, 0xace00000, 0x6b900000, 0xd4280000, 0xbc5c0000, 0xa5760000, 0x59e10000, 0xde108000, 0xafe9c000, 0x223d2000, 0x43a79000, 0xe8e86800, 0x74bcdc00, 0xc8e61200, 0x40c9df00, 0x7bcc3980, 0xc35ff1c0, 0x06bcab20, 0x8be76a50, 0xc0492fb8, 0x158d9f6c, 0x56fe6802, 0x260ddc01, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x08000000, 0x6c000000, 0xf6000000, 0x31000000, 0xdb800000, 0xaac00000, 0x3ea00000, 0x28100000, 0x3cd80000, 0x5f7c0000, 0xc69e0000, 0x01a10000, 0xd6908000, 0xef99c000, 0xb81da000, 0xa8ae1000, 0xcf29d800, 0x3dd56c00, 0x208ba200, 0x240b1700, 0xa04ac580, 0x45aae540, 0xe6da5c20, 0x4233ebb0, 0xe2c621f8, 0x149c1cbc, 0x70efd802, 0x04c86c01, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x08000000, 0x5c000000, 0x72000000, 0xf1000000, 0x79800000, 0x94400000, 0xfee00000, 0x65100000, 0x45080000, 0x50cc0000, 0x4b960000, 0x09e10000, 0x33918000, 0x13c8c000, 0xb6eca000, 0x1ba61000, 0x9c59b800, 0x47256400, 0x344b2200, 0xf27f5300, 0x353db880, 0x208e05c0, 0xa8a54e20, 0xe70a5810, 0xc21f3a98, 0x32edc3ac, 0xfda7b802, 0x23586403, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x28000000, 0x4c000000, 0xa6000000, 0x37000000, 0xf0800000, 0x1f400000, 0x16200000, 0x3fd00000, 0x23980000, 0xb22c0000, 0xb4760000, 0x33210000, 0x0a508000, 0x19584000, 0xe6cce000, 0xcb465000, 0xad899800, 0xfbd5cc00, 0x3d2a2e00, 0x295e0100, 0xf765ee80, 0xbe427440, 0x04ba93a0, 0xa7671930, 0x3b598d58, 0x2bcca26c, 0xd2c79802, 0x6148cc01, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0xe8000000, 0x9c000000, 0x42000000, 0xd9000000, 0xe6800000, 0xe2c00000, 0x5ba00000, 0xed300000, 0x96580000, 0xca2c0000, 0xd8860000, 0xe5210000, 0x6bf08000, 0x9bf8c000, 0x701ca000, 0xdb5fd000, 0x6e4c3800, 0xae960400, 0xf3887200, 0xdda5ed00, 0x1322d580, 0xc1022f40, 0x6f730e60, 0x5dcae6b0, 0xac373d58, 0xb839f68c, 0xc93cb802, 0xd2aec401, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x38000000, 0x2c000000, 0x4e000000, 0xa5000000, 0xf7800000, 0x24c00000, 0x7ce00000, 0x72300000, 0x19880000, 0x096c0000, 0x489a0000, 0x27610000, 0xd8f18000, 0x2069c000, 0xbcdc6000, 0x4dd27000, 0x7eed5800, 0xac5b1c00, 0xbb818a00, 0x9ac00f00, 0x01e1f980, 0x99b0c1c0, 0x4b480860, 0xfc8d2110, 0x832b61d8, 0xbf2892b4, 0x5afcd802, 0x3e02dc03, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0xc8000000, 0xd4000000, 0x46000000, 0x0f000000, 0xd7800000, 0xb7400000, 0x97a00000, 0xb5b00000, 0xfcb80000, 0x3d8c0000, 0xd5c60000, 0x34210000, 0x94f18000, 0xbc19c000, 0xb3bde000, 0xc43f9000, 0x030ca800, 0x6a070c00, 0x1b40de00, 0xeda1cf00, 0x38b13e80, 0x5a396740, 0x4e4c7760, 0xb0a64f70, 0xe8705818, 0x92d95b0c, 0xa85d2802, 0x87aecc03, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x68000000, 0x24000000, 0x42000000, 0x1b000000, 0xf2800000, 0x2dc00000, 0x38e00000, 0xd0d00000, 0x4fd80000, 0x4de40000, 0x44b20000, 0xc6610000, 0xbb118000, 0x1e39c000, 0xccb5a000, 0x982ad000, 0xf8a54800, 0x4e930400, 0xaed0f600, 0xaad9c500, 0x9a654b80, 0x5ef399c0, 0x34c0f5a0, 0xf16161b0, 0x3f903ac8, 0xe2f944e4, 0xe9d4c802, 0xbdbac403, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xc8000000, 0xbc000000, 0x96000000, 0x15000000, 0x66800000, 0x03c00000, 0xcce00000, 0xbfb00000, 0x28780000, 0xb6b40000, 0x840e0000, 0xdc610000, 0x39708000, 0x9a184000, 0x8ec5e000, 0x82979000, 0xea647800, 0x7087ac00, 0x808d6a00, 0x9a1bad00, 0xb47ed780, 0x06f881c0, 0x49750360, 0xfeeea2f0, 0x86d1fc68, 0xbf894d9c, 0x936cf802, 0x502bec01, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x18000000, 0x7c000000, 0xba000000, 0x39000000, 0x15800000, 0x2e400000, 0x1f600000, 0x76b00000, 0xf6680000, 0xa9340000, 0x1c320000, 0x80e10000, 0x19f08000, 0x50884000, 0xa3c5e000, 0xa83a3000, 0x8ce5f800, 0x5eebf400, 0x4abd3200, 0xeb774b00, 0xbf1b2c80, 0xf634a6c0, 0x3ab36960, 0xba21c6d0, 0xb1515d68, 0xb5189ee4, 0x797d7802, 0x2e57b401, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xe8000000, 0x24000000, 0x8a000000, 0xdf000000, 0x6e800000, 0x86400000, 0x2da00000, 0xd5300000, 0xb4580000, 0xeebc0000, 0x297a0000, 0x91210000, 0x70708000, 0xc178c000, 0x34cc2000, 0x4703d000, 0x336d4800, 0x7d339400, 0x71b47e00, 0xc9ce7d00, 0x336f1c80, 0xfcdfb340, 0xccc62e60, 0xe4dbfeb0, 0x1410a478, 0x4c291874, 0x1bc5c802, 0x7fb75401, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x08000000, 0x14000000, 0xfa000000, 0xf3000000, 0x6a800000, 0xfac00000, 0xc4600000, 0xd1b00000, 0x7c680000, 0x89340000, 0xcb120000, 0xc8e10000, 0x76708000, 0x3b89c000, 0x6bc4a000, 0xeb5a1000, 0xbac52800, 0x2edb7400, 0x24852600, 0x497af500, 0xa0d52580, 0x60e380c0, 0x91288760, 0xc41516d0, 0x5583e368, 0x75180da4, 0x9e3da802, 0xf716b401, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x38000000, 0x4c000000, 0x6a000000, 0xf3000000, 0x96800000, 0x12c00000, 0x93e00000, 0xaa300000, 0xd0f80000, 0x00340000, 0x818a0000, 0x0b610000, 0x35f08000, 0xf0984000, 0x5f45a000, 0xc1d27000, 0x90c59800, 0xd6925400, 0x7764a600, 0x15820d00, 0xea4d1580, 0x497e9fc0, 0x220ab060, 0xa620fff0, 0x19514968, 0xe909b894, 0xbaad1802, 0xfdce1401, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x88000000, 0xcc000000, 0xb6000000, 0xef000000, 0xda800000, 0x2fc00000, 0x85200000, 0x9bf00000, 0xb3d80000, 0x35340000, 0x40d60000, 0x30a10000, 0xaeb18000, 0x39384000, 0xfbe5a000, 0xe0ff1000, 0x7a4c9800, 0x6d52ec00, 0xa64e9e00, 0xbf749500, 0x58b68f80, 0x3db07240, 0xedb96be0, 0x8f2471b0, 0x9d5e8b68, 0xd37c7c2c, 0x142b1802, 0xa4cbac03, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x58000000, 0xec000000, 0x2a000000, 0xa9000000, 0x95800000, 0x1ec00000, 0xe6a00000, 0x89700000, 0x43680000, 0xe1f40000, 0x50ae0000, 0xaa210000, 0x4a308000, 0xaf094000, 0x1824a000, 0x41b6b000, 0xd83cd800, 0x5a2ad400, 0x04e71200, 0x02640b00, 0x70574d80, 0x2b2cf540, 0x3b93d6e0, 0x248afcd0, 0x819644e8, 0x9b0deadc, 0x30a25802, 0x5a029401, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x98000000, 0xbc000000, 0x66000000, 0xb3000000, 0x14800000, 0x04c00000, 0xa8600000, 0x91500000, 0xfbf80000, 0x5da40000, 0x7a4a0000, 0xf3e10000, 0xc7118000, 0x7459c000, 0x9814e000, 0x30233000, 0x27dc7800, 0xa4af4c00, 0xa18ba600, 0xe1004900, 0x55817980, 0x014108c0, 0xa1203ea0, 0x6470d9f0, 0xdd892648, 0xe92d5714, 0x52e7f802, 0x02478c03, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xc8000000, 0x6c000000, 0x0e000000, 0x85000000, 0x6f800000, 0x85400000, 0x59e00000, 0x16100000, 0xdda80000, 0x81740000, 0x510e0000, 0x97610000, 0xded08000, 0xaa084000, 0xb4052000, 0xb8779000, 0x7b1dd800, 0x4f5a9c00, 0x22de4a00, 0xcee87f00, 0x99945a80, 0xfa9f0bc0, 0x1c898020, 0x48c57950, 0x65d759e8, 0xa96c9e9c, 0x42a35802, 0xa163dc01, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xf8000000, 0x14000000, 0x86000000, 0x27000000, 0xdc800000, 0x7bc00000, 0x7a200000, 0xe7300000, 0x2cd80000, 0xb1e40000, 0x71ce0000, 0x27a10000, 0x57718000, 0xa9b94000, 0xb335e000, 0xbe07f000, 0x6ead2800, 0xe1028c00, 0x12f20e00, 0x148ad900, 0xfb9ec780, 0x75a8fc40, 0x135c1260, 0x2c7b6fb0, 0xb366eec8, 0x407c0e1c, 0x1ccaa802, 0x0afecc03, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x78000000, 0x9c000000, 0x32000000, 0x21000000, 0x2d800000, 0x82c00000, 0x1f200000, 0xfc300000, 0x18080000, 0x50f40000, 0x4bb60000, 0x51a10000, 0x4a708000, 0x5468c000, 0xf325e000, 0xe9aef000, 0x54ec3800, 0xf9fae400, 0x20ab8200, 0x72f23b00, 0x3cdeb580, 0xf605a640, 0x009ecc60, 0x27659a10, 0x2cce36e8, 0xaebdbcec, 0xff22b802, 0xcdc72401, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x18000000, 0xe4000000, 0xa6000000, 0xbb000000, 0xd3800000, 0x29400000, 0x14200000, 0xd7d00000, 0x46080000, 0x0f540000, 0x41da0000, 0x32a10000, 0x4a108000, 0xbae8c000, 0xd0e46000, 0x50a23000, 0x14ecc800, 0x62f7cc00, 0x6db6b600, 0x82964700, 0xe6c72280, 0xb98ec040, 0xbafbf3a0, 0xc8f12210, 0x1a592da8, 0xe41db334, 0xccae4802, 0x07aa0c01, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x08000000, 0x44000000, 0x72000000, 0xbd000000, 0x8d800000, 0x02c00000, 0x66e00000, 0xdb100000, 0xdb880000, 0xb99c0000, 0x78a20000, 0xf0610000, 0x23508000, 0x2329c000, 0x4d2de000, 0xdb1a1000, 0x5b058800, 0x1fb66400, 0x10dfba00, 0x6f537b00, 0x51f85580, 0xe2c4e5c0, 0x93d76220, 0xad8eb510, 0xd77b9438, 0xa655a2c4, 0x479f0802, 0x1772a401, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x08000000, 0xa4000000, 0x0e000000, 0xff000000, 0xc0800000, 0x54c00000, 0x4be00000, 0x57d00000, 0x2e080000, 0xd6040000, 0x4a260000, 0x16610000, 0xb6908000, 0xd0a8c000, 0x19756000, 0x405e1000, 0x0c9c4800, 0xe98a9c00, 0x1cb23e00, 0x9fef6100, 0xb305f980, 0x33a6ffc0, 0xb92003a0, 0xd7311a10, 0x6f59a908, 0x4fcdf7cc, 0xb542c802, 0x0a575c01, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x28000000, 0x24000000, 0xb6000000, 0x63000000, 0x69800000, 0x3a400000, 0x06600000, 0xa6700000, 0x24680000, 0x910c0000, 0x907e0000, 0x4c210000, 0xc8108000, 0x4619c000, 0xf365e000, 0x4a725000, 0x91df4800, 0x0870ec00, 0xeb698600, 0x7a8cf300, 0xa73fc480, 0x4cc114c0, 0xafa0e8e0, 0x8b5022d0, 0xc8f8d718, 0x0bd5d77c, 0x54baa802, 0x6102bc01, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xa8000000, 0x94000000, 0x1a000000, 0x5b000000, 0x13800000, 0x06c00000, 0x7fa00000, 0xafd00000, 0xb9880000, 0x67d40000, 0x1a960000, 0x51610000, 0x04708000, 0x6c58c000, 0xf55ce000, 0xc6c35000, 0xd9362800, 0x30b1b400, 0x9cf8f600, 0x330c0700, 0x528bbd80, 0x7ac38740, 0x1737c3a0, 0x11b0b110, 0xa478fea8, 0x8e4d6fac, 0xbfeac802, 0xb0b2e401, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xe8000000, 0x74000000, 0x0a000000, 0x45000000, 0xc7800000, 0xa6400000, 0xafe00000, 0xf5100000, 0x52e80000, 0xb7a40000, 0x93da0000, 0x51a10000, 0x16f18000, 0x11f84000, 0xce4c2000, 0x44ffd000, 0x92bbe800, 0x83709400, 0xbeb94a00, 0x102def00, 0x3caebc80, 0x0f3367c0, 0x91059620, 0xbbabfbd0, 0x4f990a48, 0x761d9434, 0xf977c802, 0x90cf4403, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x68000000, 0xa4000000, 0x4e000000, 0x01000000, 0xda800000, 0x89400000, 0x14200000, 0x90b00000, 0xaff80000, 0x823c0000, 0xb10a0000, 0x89610000, 0x82918000, 0x8a49c000, 0x2145e000, 0x7776d000, 0x1cca4800, 0x5d001c00, 0x68804200, 0xea419500, 0xd5a02280, 0xe471b040, 0x4d18f560, 0x1b6dc1f0, 0x1222b378, 0xfab4c594, 0x07afa802, 0x8bc6cc03, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0x44000000, 0xe6000000, 0x3d000000, 0x22800000, 0xeec00000, 0x3b600000, 0xeb300000, 0xfb180000, 0x0e7c0000, 0x8bca0000, 0xeba10000, 0xf9508000, 0x8ca8c000, 0x72a42000, 0x42567000, 0x1c9b8800, 0x16084c00, 0x43743a00, 0x973ea500, 0xd0de8d80, 0xec2f0ec0, 0x88d7d260, 0xae5b2030, 0xff6933f8, 0x5b441714, 0x0fa7a802, 0xb0e23c01, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xa8000000, 0xec000000, 0xa2000000, 0x91000000, 0xe7800000, 0x24400000, 0xf2a00000, 0xad900000, 0xe8e80000, 0xde540000, 0x58220000, 0x8ce10000, 0x4a318000, 0xccf84000, 0xf1fda000, 0xaa575000, 0x5692d800, 0x5ad9c400, 0x96ace200, 0xc7de2f00, 0xc5b7b880, 0xc223ed40, 0xb9e10720, 0x13b1d7d0, 0xa3b9e1a8, 0x31dc1fc4, 0x8a077802, 0x5b9a9403, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x78000000, 0x2c000000, 0x36000000, 0xa5000000, 0xe6800000, 0x62c00000, 0xcda00000, 0xe1b00000, 0xe9380000, 0xc16c0000, 0xd1460000, 0x15610000, 0x0f108000, 0x13084000, 0x7015e000, 0xf14af000, 0x61375800, 0xc279ec00, 0xf38d8a00, 0x58166d00, 0xc608d580, 0xae95b340, 0x9f8bb760, 0x6a961470, 0xfec875d8, 0xd034320c, 0xcdbab802, 0x7fef1c01, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xe8000000, 0x4c000000, 0x36000000, 0x7b000000, 0x0a800000, 0x25400000, 0xcd600000, 0xfa100000, 0xe1380000, 0x69c40000, 0x244e0000, 0x8a210000, 0x0e708000, 0x18a9c000, 0x363d2000, 0x0a2bd000, 0x81df9800, 0x4bd9ec00, 0xf715b600, 0xbfd6f500, 0xc5d5ba80, 0x6e7652c0, 0xe165c020, 0xd37ef870, 0x81e92088, 0xf55d2f1c, 0xcf3ab802, 0x80663c01, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x68000000, 0x24000000, 0xce000000, 0x8b000000, 0x5c800000, 0x92c00000, 0x49e00000, 0x45900000, 0x45780000, 0xb64c0000, 0xff3e0000, 0xd0210000, 0x10f08000, 0xb2284000, 0x0ad56000, 0x64e2d000, 0x4e674800, 0xb89c1c00, 0xd6e7d600, 0x345c9900, 0xec061580, 0xd14d4bc0, 0xb9bebf20, 0x4fe190f0, 0x1a916b98, 0x9ff96efc, 0x3b8c2802, 0x4c5fcc01, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xf8000000, 0x34000000, 0x26000000, 0x5d000000, 0x72800000, 0x1f400000, 0xb7e00000, 0x94100000, 0x5f780000, 0xa0940000, 0xdf260000, 0x51a10000, 0x4f718000, 0x9d284000, 0x0c8c2000, 0x51e3f000, 0x209f6800, 0x1314cc00, 0xb8e77a00, 0x86018500, 0x8d006e80, 0xaa80b7c0, 0x3b412c20, 0x69e1b8f0, 0xfd117628, 0x0bf929cc, 0xe2d54802, 0x1a463c03, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x38000000, 0xd4000000, 0xc6000000, 0xaf000000, 0x50800000, 0xd4c00000, 0x4d200000, 0xfbb00000, 0x49a80000, 0xaefc0000, 0x0f160000, 0x12e10000, 0x68118000, 0x95d9c000, 0x80f4a000, 0x0b9a7000, 0xf4fea800, 0xc2fd0c00, 0xdd171e00, 0x9be0c100, 0xc790f980, 0x29988240, 0xcd157360, 0x7b0a3150, 0xe9e60af8, 0x75281aac, 0xa83c0802, 0xcb367c03, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x18000000, 0x7c000000, 0xde000000, 0xb3000000, 0x76800000, 0xd3400000, 0x43600000, 0x42100000, 0x08180000, 0x35640000, 0xd01a0000, 0xa7210000, 0x05f18000, 0xfc494000, 0x6f9d6000, 0xb8ae3000, 0xfe03f800, 0x8d453c00, 0x756ba600, 0xef29cd00, 0xe58d7680, 0xc4b70ec0, 0xc167a020, 0x545e7a30, 0xb5cad9c8, 0x2219f7b4, 0x4c649802, 0x0f9a0c03, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xa8000000, 0xc4000000, 0xfa000000, 0x77000000, 0xe7800000, 0x64c00000, 0x5c200000, 0x71300000, 0x7b280000, 0xcb5c0000, 0xe3320000, 0x75e10000, 0x5d908000, 0x19594000, 0x10946000, 0x697f5000, 0xa2ca8800, 0x15047400, 0xfc272e00, 0x1c5fef00, 0x697a7980, 0xa26ca040, 0xb41b3e60, 0x20bc9c50, 0x03a28fb8, 0x5439ace4, 0x0a44e802, 0xb2c62401, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x28000000, 0x74000000, 0x8a000000, 0xfb000000, 0x9c800000, 0x59400000, 0x52e00000, 0x44900000, 0x67580000, 0xc8b40000, 0xde9e0000, 0xc2a10000, 0x4df18000, 0x68094000, 0x2d4da000, 0x3bda5000, 0x0437e800, 0x5a1d9400, 0x42233600, 0xbf72d900, 0x3d8bc280, 0x1a4fddc0, 0x24991520, 0x2e151cb0, 0xf16f0668, 0x85a93abc, 0xa63c4802, 0xd992c403, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xe8000000, 0x44000000, 0xb2000000, 0x0f000000, 0xcd800000, 0x66400000, 0xfba00000, 0x2f500000, 0x7fa80000, 0xc3a40000, 0x56f60000, 0xfce10000, 0xf8718000, 0xda38c000, 0xad6ca000, 0xfb63d000, 0x538f8800, 0x7aade400, 0xb8835e00, 0x1e7efb00, 0x0ad53c80, 0x484fef40, 0x9f4cd2a0, 0xa0737550, 0xe8869a48, 0xe3d8366c, 0x5b9d2802, 0x2c9b3403, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x38000000, 0xcc000000, 0x06000000, 0xc1000000, 0xf6800000, 0x21400000, 0x2fa00000, 0x7eb00000, 0x07180000, 0x67ac0000, 0x65060000, 0xc8610000, 0x28508000, 0x4a084000, 0xd005e000, 0x30b27000, 0xf64a9800, 0x63778c00, 0xb2184200, 0x1b2ccd00, 0xa3479280, 0x20415740, 0xb9219960, 0x8ff05830, 0xe0b94c58, 0xed1c978c, 0xa81ff802, 0x68cdbc01, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x38000000, 0x5c000000, 0xc6000000, 0xcb000000, 0xa1800000, 0xfbc00000, 0xb7200000, 0xb4700000, 0x45380000, 0x1bec0000, 0xac6a0000, 0xbd610000, 0x70908000, 0x02684000, 0x80a5e000, 0xc7be7000, 0x3c67b800, 0xfdda0c00, 0x48785600, 0x508c6300, 0x4ffa2780, 0x92894640, 0x05f4ace0, 0xddf66870, 0x33338ed8, 0x899d8a54, 0xb252d802, 0xef0c3c01, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xe8000000, 0xec000000, 0x9a000000, 0x97000000, 0xfe800000, 0x4e400000, 0x33e00000, 0xf8900000, 0xa9b80000, 0x7d4c0000, 0x42f60000, 0x4b210000, 0xb9308000, 0xb0c94000, 0xc7652000, 0x1a83d000, 0x41dad800, 0xe786b400, 0x6309ee00, 0xaa451d00, 0xa6b32c80, 0x44924fc0, 0x72234d20, 0x972a5170, 0xa86efd98, 0x535cfa6c, 0xa90f7802, 0xaf8c2401, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x98000000, 0x34000000, 0x72000000, 0xd9000000, 0x2b800000, 0x1dc00000, 0x03200000, 0x47d00000, 0xb1180000, 0x3ad40000, 0x365e0000, 0x71610000, 0x73318000, 0x38e84000, 0x659de000, 0xe1533000, 0x614b6800, 0x1c1e6400, 0x51817200, 0x78c07700, 0x26a0ab80, 0xad10be40, 0x9eb933a0, 0xd4445c30, 0x192774a8, 0xe004b23c, 0x86c70802, 0x9b751403, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x98000000, 0x7c000000, 0xee000000, 0x03000000, 0xe4800000, 0x1d400000, 0x71200000, 0x16900000, 0x2e580000, 0xc1d40000, 0xd2fa0000, 0xece10000, 0x28f18000, 0x44e9c000, 0xce9da000, 0x5cb73000, 0xefaff800, 0x9f5b5c00, 0xbb314600, 0xa9882900, 0xd8ad6a80, 0x32be8a40, 0xfec33920, 0x8985feb0, 0xc643d0a8, 0x8ac53074, 0x1c63d802, 0x4cd5ac03, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x78000000, 0x8c000000, 0x7a000000, 0x4d000000, 0x3b800000, 0x0cc00000, 0xdb200000, 0xacd00000, 0x22180000, 0xa5340000, 0xb8560000, 0xea610000, 0x54318000, 0xbf694000, 0xaebd6000, 0x519af000, 0x4d721800, 0xb30e7400, 0x2bb55a00, 0xc317d700, 0xe781c980, 0xdec0be40, 0x722105a0, 0xa9505230, 0xedd9a368, 0xfe949c2c, 0x14c6f802, 0x6919c403, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x08000000, 0x8c000000, 0x22000000, 0x5d000000, 0x62800000, 0x7fc00000, 0x9ca00000, 0xbd700000, 0x55980000, 0xec5c0000, 0x76560000, 0x3ce10000, 0x8c918000, 0x6388c000, 0x6414e000, 0x58e21000, 0x22721800, 0x6afac400, 0x876efa00, 0x49cc6500, 0x115f4f80, 0xb4351140, 0x255356e0, 0xb4ca9d30, 0x56969bb8, 0x4fc0782c, 0x34a17802, 0x21711403, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x58000000, 0xdc000000, 0x6e000000, 0x6b000000, 0x50800000, 0x12c00000, 0x10200000, 0x89300000, 0x3f380000, 0x4c340000, 0xc98a0000, 0xa9610000, 0x43518000, 0x08e8c000, 0x941c2000, 0x00b6b000, 0x9f66b800, 0x134e5c00, 0x50729600, 0xaf74c100, 0xf2ebf580, 0x5f30c840, 0x58396660, 0x4ab5bc70, 0x7c4bab68, 0xdfc0ad94, 0x6fa11802, 0x19712c03, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xb8000000, 0x4c000000, 0xe2000000, 0xa7000000, 0x53800000, 0x43c00000, 0xa2e00000, 0x07d00000, 0x9e080000, 0x14ac0000, 0x285a0000, 0x85a10000, 0x1d718000, 0x5cf94000, 0x4994e000, 0x142f7000, 0x7ddf9800, 0xf1674400, 0xf9d28e00, 0x38cd8700, 0x64cbd780, 0x53080dc0, 0x742d43a0, 0x461b1e10, 0xe9817c58, 0xb8c00a34, 0x7b60f802, 0x67107403, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xa8000000, 0x7c000000, 0x16000000, 0x77000000, 0x6b800000, 0x78c00000, 0xbfe00000, 0x19700000, 0xcaa80000, 0xf0a40000, 0xecb20000, 0x57a10000, 0xebd08000, 0x8ff94000, 0x791c6000, 0x140f5000, 0x3f7ff800, 0xa0d7ac00, 0xb6f22e00, 0xb0007700, 0xe8000180, 0xdc01f7c0, 0x2601d6e0, 0xdf00ff50, 0x17810c48, 0x6ec13de4, 0xc8e11802, 0x72f0bc01, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xa8000000, 0x14000000, 0x9a000000, 0x5f000000, 0xdd800000, 0x3dc00000, 0x72200000, 0x25d00000, 0x0b680000, 0x74a40000, 0x99f60000, 0x69610000, 0xd5b18000, 0x22594000, 0xebbd2000, 0x932b5000, 0x6bfb2800, 0x0e13b400, 0x1cf77e00, 0x8be15b00, 0x05f0cb80, 0x55b9fc40, 0x004d27a0, 0x3392e4d0, 0xd137f048, 0x61c1f96c, 0x0c218802, 0x78d0a403, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x88000000, 0xec000000, 0x12000000, 0x23000000, 0xc3800000, 0xbfc00000, 0xbaa00000, 0x1db00000, 0x93a80000, 0x75a40000, 0xf6b60000, 0xc1e10000, 0xc5518000, 0xea784000, 0x599ce000, 0x154b1000, 0x2a3ad800, 0x11b2a400, 0x76e68600, 0x2d19a700, 0xe58d4f80, 0x1cd31d40, 0xfdf73760, 0x91010d50, 0x50811648, 0xd441d7ec, 0x9961b802, 0x3d10f403, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xf8000000, 0x54000000, 0x7a000000, 0x1f000000, 0xd2800000, 0x2cc00000, 0x22200000, 0x30300000, 0xb3880000, 0xa53c0000, 0xfffa0000, 0x3f610000, 0xea518000, 0x5458c000, 0x6f24e000, 0xee3ff000, 0x3b4fa800, 0x06a67400, 0x3e4a7e00, 0x14a90500, 0xe88c0980, 0x2a333c40, 0xb0bc2c60, 0x85bb7510, 0xa3814d78, 0x3b41a974, 0xd360c802, 0x64504403, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xd8000000, 0x34000000, 0xfa000000, 0x37000000, 0xd3800000, 0xff400000, 0x3e200000, 0xdc100000, 0xd7b80000, 0xec1c0000, 0x40ba0000, 0x17e10000, 0x85f18000, 0x5f494000, 0xf7d5e000, 0x6bafb000, 0x652f6800, 0x36ef7400, 0x980fae00, 0x637f8700, 0x77f66e80, 0xbac38440, 0x201db420, 0xbebacd70, 0xa2e19d38, 0xa570faf4, 0x51890802, 0x35b48403, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x68000000, 0x7c000000, 0xd2000000, 0x5d000000, 0xd2800000, 0xb1400000, 0x50600000, 0x43700000, 0x2fe80000, 0x8ef40000, 0x545e0000, 0x28a10000, 0xc3d08000, 0x70394000, 0x1ccd2000, 0xed92d000, 0x03b3f800, 0xdf222400, 0x707a7a00, 0xa0464500, 0x01fc5280, 0x6d9a68c0, 0xf5f66ae0, 0xc1b5c9d0, 0x033e4ee8, 0xa850e93c, 0xa5f85802, 0x56ecb401, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x98000000, 0x74000000, 0x6a000000, 0xc7000000, 0x9f800000, 0x3dc00000, 0x51e00000, 0xbdf00000, 0xc8580000, 0xbfac0000, 0x6f4a0000, 0x3df10000, 0x08598000, 0x9fac4000, 0xdf4b6000, 0xa5f03000, 0x7c596800, 0xf5ac9400, 0x184aee00, 0x3a710f00, 0x41991380, 0xa44c37c0, 0xa5bb95e0, 0xf2289fb0, 0xfe346cd8, 0xcb06e954, 0x984aee02, 0xfa710f03, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x48000000, 0xe4000000, 0x0a000000, 0x5b000000, 0xea800000, 0x25400000, 0x20600000, 0x14900000, 0xa9c80000, 0x6c740000, 0x75ea0000, 0xd8910000, 0x17c98000, 0xe5744000, 0xd86b6000, 0xb1519000, 0xa7e84800, 0x6a045400, 0xf1f3d600, 0x9b4c4500, 0xafc60280, 0x5a4714c0, 0xef877f20, 0xd9a6d690, 0x53d6fa68, 0x89cf8f14, 0xd313d602, 0x3e9c4503, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x28000000, 0xcc000000, 0x76000000, 0x19000000, 0xe3800000, 0x5bc00000, 0xcae00000, 0x1b900000, 0x62980000, 0xb6bc0000, 0xa23e0000, 0xbd910000, 0x93998000, 0xb93c4000, 0xdffea000, 0x46715000, 0xa7881800, 0xf664ac00, 0xbaa29200, 0x1c5e9700, 0x2341af80, 0x19a0b9c0, 0xba30e520, 0x1ca9f230, 0x401412f8, 0xa52ba5bc, 0x2e3a9202, 0x73e29703, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x58000000, 0xc4000000, 0xe2000000, 0x5f000000, 0x2d800000, 0x61400000, 0x4ba00000, 0x7b500000, 0x40180000, 0x242c0000, 0xadaa0000, 0xd1510000, 0x33198000, 0x97adc000, 0xc5eae000, 0x5271b000, 0x9f880800, 0x32d40400, 0xef765e00, 0xa2b3eb00, 0x30fdca80, 0x83f31340, 0x5b5c68a0, 0x68a30b30, 0x334572d8, 0xd08ee014, 0xb8ee5e02, 0xbcdfeb03, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x98000000, 0x2c000000, 0xc6000000, 0x87000000, 0xd8800000, 0xc3400000, 0xb8200000, 0x37500000, 0x22880000, 0x37d40000, 0x1d360000, 0x5d510000, 0xa3898000, 0xc8554000, 0x36f66000, 0xbe303000, 0x00f9d800, 0x1b8ccc00, 0xa4ab6e00, 0x4c538100, 0x83df5e80, 0x5d753c40, 0xf827c0a0, 0x9078e410, 0x3ccd6128, 0xfe8aee2c, 0xbe036e02, 0x8cd78103, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x18000000, 0x64000000, 0x12000000, 0xe3000000, 0xd8800000, 0xb4c00000, 0x27a00000, 0x08b00000, 0xcf180000, 0x7e0c0000, 0xde2e0000, 0x56b10000, 0x82198000, 0x138c4000, 0xf36f6000, 0xe6513000, 0xa5494800, 0x55446400, 0x8e6aa600, 0x595a8100, 0x28032180, 0x066eab40, 0x9fd07760, 0xa208bf30, 0xd2a44d98, 0x7bba4f1c, 0x2c52a602, 0xb8268103, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x48000000, 0x24000000, 0x0a000000, 0x3f000000, 0x78800000, 0x35c00000, 0xf8e00000, 0xb8500000, 0x7b380000, 0x0c1c0000, 0xf62e0000, 0x47510000, 0x63b88000, 0x89dc4000, 0xd6cf2000, 0x93019000, 0x3680c800, 0xb0c05400, 0x67615e00, 0x99106100, 0x98182380, 0x79ade5c0, 0x72c70ea0, 0x7d350770, 0x54aaf3b8, 0x78135d9c, 0x314f5e02, 0x0e416101, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x88000000, 0xc4000000, 0x46000000, 0xa7000000, 0x41800000, 0x1ac00000, 0xa1e00000, 0x9a100000, 0x8f080000, 0xae2c0000, 0xe9120000, 0xed110000, 0x16888000, 0xe8ecc000, 0x32f2e000, 0xda001000, 0xfd010800, 0xfc804c00, 0x8641ae00, 0x57a19300, 0x45b1bd80, 0x0eb9cfc0, 0xe6947a20, 0xa8879d10, 0x041669d8, 0x085f11e4, 0x4153ae02, 0xe9b09301, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x28000000, 0x64000000, 0xee000000, 0x81000000, 0xc3800000, 0xb9c00000, 0x85a00000, 0xb8d00000, 0x0ae80000, 0x6bac0000, 0x6a860000, 0x55d10000, 0x13688000, 0x356d4000, 0xd9a62000, 0x51415000, 0xc0e04800, 0x4e309c00, 0x39d92200, 0x23f5d700, 0xd3b3bb80, 0xcb43d740, 0x75bbf3a0, 0x34df52d0, 0xc1e544d8, 0x747a6e4c, 0xbd7f2202, 0x5334d701, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x48000000, 0x7c000000, 0x7e000000, 0xfd000000, 0x6b800000, 0x0cc00000, 0xa8600000, 0x93900000, 0x61a80000, 0xcbe40000, 0xde5a0000, 0x70910000, 0x67298000, 0xb4a44000, 0x3efae000, 0x01619000, 0x6a117800, 0xf668bc00, 0xb1051a00, 0x608a4700, 0x4a99e180, 0x7fbc2cc0, 0x02869d20, 0x2b07f450, 0x44c79e48, 0x2a26d474, 0xe6f71a02, 0x17ff4703, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x18000000, 0x7c000000, 0x2a000000, 0xa3000000, 0x7f800000, 0x0bc00000, 0x20600000, 0x21700000, 0xaaa80000, 0x34540000, 0xef720000, 0xa0710000, 0x52288000, 0xf615c000, 0xddd32000, 0x65e13000, 0xd1b07800, 0x69499400, 0xa4e46600, 0xdebacf00, 0xb6d5ef80, 0x363294c0, 0xe151c4e0, 0x3e780a50, 0x92ed8f28, 0x4a7e4624, 0x34be6602, 0xa25fcf01, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x88000000, 0x84000000, 0xae000000, 0x2f000000, 0x79800000, 0xb1400000, 0x74200000, 0xf6700000, 0x61180000, 0x35740000, 0x6b320000, 0x6ff10000, 0xc0598000, 0xa954c000, 0xc943a000, 0x28e81000, 0x5e2c8800, 0x15e79c00, 0x38f2fe00, 0xe5116300, 0xb0492a80, 0xc99cd440, 0xd31f02e0, 0xb1172930, 0xff2bdc68, 0x5a057c24, 0xf0ab7e02, 0x0845a303, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xc8000000, 0xf4000000, 0x7a000000, 0xad000000, 0xc6800000, 0xb7c00000, 0xfaa00000, 0xd1b00000, 0xfdc80000, 0xb5240000, 0xd8620000, 0x27310000, 0x42098000, 0x1b854000, 0xc3d36000, 0xbff89000, 0xc5ac6800, 0x0e27b400, 0xb3433a00, 0xeac09d00, 0x94204780, 0x82712140, 0x05680960, 0xf5940e90, 0x6d2b19c8, 0xf2d4eb84, 0x0b4aba02, 0x9c45dd03, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x88000000, 0xac000000, 0x7e000000, 0xe7000000, 0x89800000, 0x4dc00000, 0x9fa00000, 0xa6d00000, 0xe4580000, 0x20cc0000, 0x4c360000, 0x47510000, 0x95998000, 0x196d4000, 0xd9e7e000, 0x70881000, 0xcd94d800, 0xda7bbc00, 0x1b272e00, 0x5aa88300, 0x80850380, 0x92836340, 0x4ebb73a0, 0x8a0613b0, 0x6838be18, 0xcebdb52c, 0xaf3eae02, 0x9205c303, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xc8000000, 0xac000000, 0x8e000000, 0xbf000000, 0x04800000, 0x1e400000, 0xea200000, 0xea300000, 0xea180000, 0xdb9c0000, 0xbdca0000, 0xa2b10000, 0x2a598000, 0xd6bd4000, 0x077a6000, 0xbce89000, 0x86e4d800, 0xb4c65c00, 0xea121e00, 0xbdcd1900, 0xf3c3a480, 0xfb04e840, 0xa716da60, 0x61db5530, 0x84992fb8, 0x98dd9dd4, 0xc26b9e02, 0xdd405903, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x88000000, 0x8c000000, 0xe2000000, 0x71000000, 0xc0800000, 0xeb400000, 0x04e00000, 0xa9100000, 0x26480000, 0x50bc0000, 0x0aba0000, 0x27910000, 0x4e098000, 0xcddd4000, 0xd46ba000, 0x84781000, 0x4e449800, 0x6abe8400, 0x1f4e4200, 0x54161100, 0xece30e80, 0xf5e5adc0, 0xe14fc020, 0x2f162590, 0xa1639bf8, 0x6424f2b4, 0x7befc202, 0x2c675103, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x38000000, 0x8c000000, 0x26000000, 0x69000000, 0xf3800000, 0x11c00000, 0x11600000, 0x27300000, 0x82d80000, 0x31bc0000, 0x05920000, 0x55b10000, 0x14998000, 0x3b1d4000, 0x2cc2a000, 0x52d97000, 0xc9bc9800, 0x29930c00, 0x23b17200, 0x45981700, 0x449c7b80, 0x1b02cec0, 0x2ab9ec60, 0x1d0c7ab0, 0xba8b4cf8, 0x036d5be4, 0x673af202, 0x93f45703, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xe8000000, 0x74000000, 0xce000000, 0x05000000, 0x4e800000, 0xd9400000, 0xd1600000, 0x1a700000, 0xd1080000, 0xa7240000, 0x296e0000, 0x95f10000, 0x50c88000, 0x46054000, 0x2effa000, 0xd0c8d000, 0x06046800, 0x8efedc00, 0x00c8aa00, 0xee05cd00, 0xfafe1a80, 0xcec89ec0, 0xeb056ee0, 0xb47e9710, 0x1789c0c8, 0x3a64aa1c, 0xae0e2a02, 0xc6818d01, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0xe8000000, 0x7c000000, 0x7a000000, 0x6f000000, 0xec800000, 0xf0c00000, 0x55a00000, 0x5cb00000, 0x4a780000, 0x7eb40000, 0x425e0000, 0xd5310000, 0x21388000, 0x13554000, 0x458e2000, 0x1758d000, 0xccc47800, 0x6c87b400, 0x8ab5fe00, 0xb45e8900, 0x98315980, 0x26b8ff40, 0xe114f760, 0x89ef95f0, 0xe7c938e8, 0xa94c89fc, 0x11ab7e02, 0x4f8ec901, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0x34000000, 0xbe000000, 0x71000000, 0x6c800000, 0x0ec00000, 0xa9200000, 0x66f00000, 0x71080000, 0x331c0000, 0x12220000, 0xdd710000, 0x16488000, 0xe67d4000, 0x92326000, 0x97283000, 0x086ce800, 0xa16a3c00, 0x798d8200, 0x53bb6900, 0x18f43580, 0x786ece40, 0x216b5fe0, 0x398db310, 0xf3bbf7b8, 0x28f5dc04, 0xe06f0202, 0x156b2901, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xc8000000, 0x8c000000, 0x76000000, 0x83000000, 0x9a800000, 0x6f400000, 0x33e00000, 0x05d00000, 0x2d680000, 0x89540000, 0xebf20000, 0xf2510000, 0xafa98000, 0xdd754000, 0xbb82e000, 0x4e889000, 0xf4849800, 0x229bac00, 0xf104e600, 0x795b2500, 0xbaa58680, 0x97ebebc0, 0x4c5cdda0, 0xe3b717d0, 0x2beaf028, 0x925dce24, 0x3cb76602, 0x7f6b6503, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x28000000, 0xac000000, 0x8e000000, 0xf1000000, 0x3d800000, 0x2f400000, 0x67e00000, 0xd8d00000, 0xfce80000, 0x60ac0000, 0xffa20000, 0x06510000, 0xe9288000, 0xc08d4000, 0x60522000, 0x3dc95000, 0xaaddd800, 0xe77a5c00, 0xbc44c200, 0xcf0eab00, 0x71f34680, 0x537873c0, 0x8fa5c3a0, 0xfddfbad0, 0xee1af3d8, 0x49545a84, 0x17c64202, 0xacaeeb01, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xc8000000, 0x7c000000, 0xf6000000, 0xab000000, 0x9f800000, 0x5ec00000, 0x6f200000, 0x93d00000, 0x98880000, 0xbf040000, 0x81c20000, 0x15510000, 0xc0c98000, 0x4865c000, 0x0572a000, 0x59689000, 0xfbf57800, 0x8e9a2c00, 0x20dcf600, 0x170f2f00, 0x62768580, 0x4cab1240, 0xd4a4a1a0, 0x8b521610, 0xe839df88, 0x593cc3c4, 0x57ff7602, 0x7f2fef03, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xd8000000, 0xac000000, 0xf2000000, 0x3f000000, 0x91800000, 0x93c00000, 0x65600000, 0x7cb00000, 0x95480000, 0x208c0000, 0xf5320000, 0xab710000, 0xb6298000, 0x1d3c4000, 0x8cfb6000, 0x6ebcb000, 0x883ad800, 0xce5ca400, 0x894a9e00, 0x2b75d300, 0xd7f69f80, 0xbb4fdec0, 0x95aa3f60, 0x70049d90, 0x59dee098, 0x9a7277a4, 0x8351fe02, 0x55b96303, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xd8000000, 0xd4000000, 0xaa000000, 0xbb000000, 0xe6800000, 0xcdc00000, 0x57e00000, 0x18f00000, 0xd8680000, 0xb3f40000, 0xe0320000, 0x87310000, 0x10888000, 0x9f854000, 0x2a9b6000, 0xf7a4b000, 0x4a8b2800, 0xdbbd1400, 0xe7d69600, 0xe11a3d00, 0x81e4d380, 0x532b8bc0, 0x1eedcfe0, 0x38ef79d0, 0x3ad7d268, 0x229abea4, 0xaba5f602, 0xfc8a8d01, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x68000000, 0x2c000000, 0x42000000, 0x79000000, 0x2e800000, 0xb3400000, 0x9f600000, 0xf2500000, 0x84b80000, 0x5b540000, 0xd23a0000, 0xef110000, 0x00d88000, 0xce84c000, 0xf342a000, 0xdc65d000, 0xd1d2d800, 0x6c7d4400, 0x7bf6d200, 0x064f4d00, 0x339a1e80, 0x32e02ac0, 0x1291aea0, 0x88196070, 0xee250a28, 0x0432cbb4, 0x736c7202, 0x632e9d01, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x38000000, 0x14000000, 0x5e000000, 0xc7000000, 0xb7800000, 0x8c400000, 0x17200000, 0xb2700000, 0xbb680000, 0x2a2c0000, 0x3b3a0000, 0xd4310000, 0x65498000, 0xf0dc4000, 0x3f932000, 0x037d7000, 0x2823a800, 0xc475fc00, 0x80df2e00, 0x42165f00, 0xc68a9080, 0xda382240, 0xa53422e0, 0xc97fb5d0, 0x84a6bad8, 0xed035334, 0xab040e02, 0x0d372f03, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xb8000000, 0x2c000000, 0x8e000000, 0xc9000000, 0x1e800000, 0xb6400000, 0x7e600000, 0xdc900000, 0x14b80000, 0x16140000, 0xc8960000, 0xf0d10000, 0x41d88000, 0x33054000, 0x2def2000, 0x88647000, 0xb1fed800, 0xfb9d5c00, 0x7b0a3200, 0x6fdb0d00, 0x04039480, 0x740650c0, 0x94699320, 0xdfcc9870, 0xff939aa8, 0xc73f44ec, 0xa2bd1202, 0xdb7b7d01, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xd8000000, 0x54000000, 0x16000000, 0x7f000000, 0x8c800000, 0x79c00000, 0x98200000, 0xc3900000, 0xad280000, 0x30e40000, 0x8aee0000, 0xb0510000, 0xf0098000, 0x72f5c000, 0xb387a000, 0x1ed4b000, 0x96172800, 0x24fcec00, 0x7672de00, 0x4dd26900, 0x63037b80, 0x9bcbec40, 0x369f3120, 0x75c93f50, 0x80d49448, 0xa516689c, 0x0a7d7e02, 0xb6b2d903, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x08000000, 0x74000000, 0xaa000000, 0xc1000000, 0x6a800000, 0xb9c00000, 0xb8200000, 0x26300000, 0x0c380000, 0x92f40000, 0xa5220000, 0x3ef10000, 0xae988000, 0x35054000, 0xfd3b2000, 0x5c351000, 0x18826800, 0x98811400, 0xe4c02200, 0x3ca18500, 0x6cf0bb80, 0x63983440, 0xb9852660, 0xc3fb9970, 0x9994d468, 0xf2f26f04, 0x94d90202, 0xfa659501, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xf8000000, 0xfc000000, 0x4a000000, 0x93000000, 0x13800000, 0x57c00000, 0x09e00000, 0xbfd00000, 0x4c480000, 0x8b140000, 0x44920000, 0x0b110000, 0x0e298000, 0xcf04c000, 0x833a6000, 0xa8d4f000, 0xa3727800, 0xc1c15400, 0x40e0c600, 0x97511700, 0x3c093780, 0x9b3577c0, 0xd7a3a1a0, 0x32092b90, 0x1e351fa8, 0x4d227de4, 0x2d48a602, 0x5794e703, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xc8000000, 0xc4000000, 0x6e000000, 0x2f000000, 0xdc800000, 0x55c00000, 0x9e600000, 0x46300000, 0xb8e80000, 0xe0ec0000, 0x52a60000, 0xa4f10000, 0x26088000, 0x011dc000, 0x492ee000, 0x93ac9000, 0xc0070800, 0x13201c00, 0x43903e00, 0xdfb9e900, 0x7ab5c380, 0x536270c0, 0x22da5a60, 0xd76f94d0, 0xc88d7458, 0x0797808c, 0x4298de02, 0x66247901, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x68000000, 0xdc000000, 0x6e000000, 0x7b000000, 0x33800000, 0xc1400000, 0x0fa00000, 0x86100000, 0x94380000, 0xd08c0000, 0x143a0000, 0xd0510000, 0x1e188000, 0xa8ddc000, 0x76222000, 0xe68dd000, 0x6b3b3800, 0xc9d01c00, 0x6e585600, 0x35fd7700, 0xcbf21a80, 0x9ad51340, 0xbbc6c220, 0x32a35370, 0xb24d7598, 0xf2dbc034, 0x65e07602, 0x7231a701, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x48000000, 0x84000000, 0x32000000, 0xb7000000, 0xea800000, 0x35400000, 0x24600000, 0x04b00000, 0xd2280000, 0x6afc0000, 0xd0f20000, 0xcaf10000, 0x6ac98000, 0x3e0dc000, 0x4b3a6000, 0x337d9000, 0xfd328800, 0x8cd0a400, 0x90988e00, 0x95d48500, 0x538f0280, 0xbfc3bcc0, 0x8218ef60, 0xac945550, 0x21ee7178, 0x0e73cc24, 0x45b0ee02, 0x9da81503, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x78000000, 0xac000000, 0x0e000000, 0x4f000000, 0x55800000, 0x05400000, 0xdce00000, 0x9e900000, 0x85e80000, 0xbb9c0000, 0xbbce0000, 0x32d10000, 0x27898000, 0xcfccc000, 0x7a86e000, 0xa7bdf000, 0x34fed800, 0x4149dc00, 0x556dfe00, 0x73769b00, 0xfe84b280, 0x57ead5c0, 0x78cb3b20, 0xc47bdcd0, 0x59a353b8, 0x78279d5c, 0xb24d1e02, 0x7bc66b03, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x48000000, 0xf4000000, 0xfa000000, 0x17000000, 0x71800000, 0xdbc00000, 0x1ae00000, 0x66300000, 0x58980000, 0x0dcc0000, 0x7c860000, 0x5c710000, 0xf1b98000, 0xb51dc000, 0x202fa000, 0xa2259000, 0xff726800, 0xa32b3400, 0xf1870e00, 0x2af13300, 0xf3f9bf80, 0x503d31c0, 0xeefe3a60, 0x7f8dde30, 0x21a61e18, 0x1ea135cc, 0xba112e02, 0x3ac96303, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xc8000000, 0xb4000000, 0x7e000000, 0x2b000000, 0x5b800000, 0xcf400000, 0x12a00000, 0x3dd00000, 0x1ed80000, 0x3bac0000, 0x5f2a0000, 0x59110000, 0x9b388000, 0xc8dd4000, 0x6623a000, 0xe1649000, 0x3b3fe800, 0x2426bc00, 0x52ea7600, 0xc671e700, 0x79889680, 0x94b5a940, 0xd1e775a0, 0xc18b8eb0, 0xf6c1abd8, 0x0ce14614, 0x99f15602, 0x30c83701, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x98000000, 0x6c000000, 0x46000000, 0x53000000, 0x43800000, 0x72c00000, 0x62200000, 0x08300000, 0x52f80000, 0x34040000, 0x17820000, 0x7d710000, 0xd0188000, 0x3714c000, 0xf3cae000, 0x8dcc3000, 0x8afe5800, 0x50374c00, 0x76cbc600, 0x354cf700, 0x2fbe9d80, 0x1ad65840, 0x91da3e60, 0x130406f0, 0x3e02df88, 0x7ab05644, 0xd2b9a602, 0x96640701, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x58000000, 0xa4000000, 0x12000000, 0xdb000000, 0xed800000, 0xf6400000, 0xa6200000, 0xecb00000, 0x3db80000, 0x491c0000, 0x43660000, 0x25710000, 0x16d88000, 0x5e0dc000, 0x6c2ea000, 0x0bf5b000, 0x4613c800, 0xcca2e400, 0x201a9600, 0x1b872b00, 0x01204480, 0xf7303840, 0xe2f8f760, 0x89bcdc70, 0xec1714b8, 0xeca9cb8c, 0x0754b602, 0x17635b01, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x08000000, 0x44000000, 0xb6000000, 0x9b000000, 0x01800000, 0xbec00000, 0xeae00000, 0x0e900000, 0x06b80000, 0x2e2c0000, 0xcb120000, 0x13d10000, 0x07988000, 0xfcddc000, 0xbe7a6000, 0x4a651000, 0xd8560800, 0x2577ac00, 0x4d86d600, 0xb1ee5300, 0xf4dbd580, 0x075489c0, 0xcf5e9320, 0xd0135a70, 0x525003d8, 0x5959c2e4, 0x263c3602, 0xb8ea8301, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xc8000000, 0x2c000000, 0x2e000000, 0xe3000000, 0xe2800000, 0xc1c00000, 0xf1e00000, 0xef900000, 0x8f380000, 0x04340000, 0x05820000, 0xc6d10000, 0x3e188000, 0xa5c44000, 0xdd6b6000, 0x7b7c9000, 0xe21ed800, 0x3adf1c00, 0x40bf2600, 0x4d6f9500, 0x6df77b80, 0x7ff28fc0, 0xe4797120, 0x5814ef70, 0x15f2f9e8, 0xf5781fc4, 0x9f94c602, 0x49b34501, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x38000000, 0x64000000, 0xd2000000, 0x15000000, 0xe0800000, 0x8ac00000, 0x9f600000, 0xd9300000, 0xabf80000, 0xf4040000, 0x065a0000, 0x1e710000, 0xfad98000, 0x8a94c000, 0x4ef36000, 0x403d7000, 0x4dbf4800, 0x2bda6400, 0x6031ca00, 0x6578f100, 0x0dc47d80, 0x36bb8ac0, 0xe4002060, 0x12007af0, 0x7501b388, 0x5081b974, 0xb2c12a02, 0xfb604103, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xf8000000, 0x94000000, 0x32000000, 0xff000000, 0x74800000, 0xa5c00000, 0x90600000, 0x61b00000, 0x95380000, 0x74640000, 0xe9fa0000, 0x07f10000, 0xa8198000, 0x9e75c000, 0x0413a000, 0xc69cf000, 0x1afea800, 0x773aa400, 0xe910de00, 0xe7695900, 0x0dac0380, 0xb30714c0, 0xcabee560, 0x9f1a0f70, 0xcc817948, 0x11c00434, 0x9260fe02, 0xb6b16903, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xb8000000, 0xcc000000, 0x66000000, 0x89000000, 0x1f800000, 0xca400000, 0x2ba00000, 0xae500000, 0xd9480000, 0xa5b40000, 0x941e0000, 0x14910000, 0xee288000, 0x9584c000, 0x12e62000, 0x559c7000, 0x649b1800, 0x0ff70c00, 0x50f4b200, 0xb13f0f00, 0xd301ec80, 0x18814b40, 0x48c066a0, 0x4460f990, 0x18b071e8, 0x0639ca7c, 0x616c1202, 0x8002bf01, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xa8000000, 0xb4000000, 0x1e000000, 0xa1000000, 0xc4800000, 0x39400000, 0x36a00000, 0xb9700000, 0x7d980000, 0x3cd40000, 0xa6720000, 0x6bb10000, 0x1ff98000, 0x4ac4c000, 0x0b7ba000, 0x182c5000, 0x2f36e800, 0x400bfc00, 0xb6b46200, 0xc4639900, 0x68b97a80, 0xb5652140, 0xa28ac8e0, 0x92f48630, 0x2c43a528, 0x2f8942a4, 0x87dc4202, 0x70ee0903, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x2c000000, 0x1e000000, 0xd3000000, 0x8f800000, 0x20c00000, 0xe6e00000, 0xa0900000, 0xf6480000, 0xf4d40000, 0xf27a0000, 0x0ad10000, 0x70e88000, 0x4be4c000, 0xed82e000, 0xf7bd5000, 0xff5ed800, 0xc6b3fc00, 0xc244c600, 0xab330f00, 0x57853980, 0x0553c1c0, 0x32552f20, 0xfc3af790, 0xee71a228, 0x3ad8a834, 0x7c9ca602, 0xa5af9f01, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xd8000000, 0x4c000000, 0xaa000000, 0xfb000000, 0x6e800000, 0x9fc00000, 0x53200000, 0xe9100000, 0xb4580000, 0x7b040000, 0xdaca0000, 0xe5510000, 0x77398000, 0x7374c000, 0x99e3e000, 0x7dfcb000, 0x6f9f1800, 0xae229400, 0x7adc9600, 0x008e2d00, 0xbb7b8780, 0x4c592240, 0x67044c20, 0x38cb59b0, 0x7a503b88, 0x27b890d4, 0xf1b4f602, 0xf5435d03, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x78000000, 0xbc000000, 0xba000000, 0xd7000000, 0xab800000, 0x15400000, 0xaf200000, 0x55f00000, 0x5c280000, 0xd5740000, 0xc6da0000, 0xc2310000, 0x5cc98000, 0x1c65c000, 0xf9e3e000, 0x777df000, 0x40def800, 0xd103b400, 0xaa6cce00, 0x11e7e700, 0x3d4e7280, 0xb4fbba40, 0xb341cde0, 0x12204350, 0x41718a68, 0xd6e842f4, 0x1114ae02, 0xed0ad703, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x38000000, 0xcc000000, 0x6a000000, 0xd9000000, 0xeb800000, 0x61400000, 0x44e00000, 0x47500000, 0x37380000, 0x22f40000, 0x8b0a0000, 0x4fb10000, 0x5a688000, 0xeccc4000, 0xd27f2000, 0x9dfb7000, 0x9d381800, 0x9bf41400, 0xd08ad200, 0x86f18700, 0xea89aa80, 0x0d9d85c0, 0x5646c8a0, 0x8d8f7b70, 0x9cf34868, 0xf1e44954, 0x8952ca02, 0x1a559301, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x18000000, 0x74000000, 0x82000000, 0x1d000000, 0x6f800000, 0x93c00000, 0xd6e00000, 0x41900000, 0xeed80000, 0x3c340000, 0xe9560000, 0xc3710000, 0x1d488000, 0xa7edc000, 0x46e32000, 0x57e73000, 0xe3d96800, 0x0bb44400, 0xee96da00, 0x0790cf00, 0x59d97f80, 0x52b581c0, 0x6b169d20, 0x755008b0, 0x0eb9e8e8, 0x6be59cec, 0xa3afb202, 0xe9b48b01, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x68000000, 0xa4000000, 0xaa000000, 0x1d000000, 0xe1800000, 0x60c00000, 0xdee00000, 0xe9500000, 0xfb080000, 0x499c0000, 0xf7360000, 0x7db10000, 0xdf588000, 0xab144000, 0xa26b6000, 0x3267d000, 0x58b8c800, 0xd9c59400, 0xdca31a00, 0x389b7300, 0x401ed980, 0x929c61c0, 0xf5b71ca0, 0x03f0ff10, 0x89f9e9b8, 0xdfe41e2c, 0xb713d202, 0xfcc2e701, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x58000000, 0xe4000000, 0x96000000, 0x99000000, 0x03800000, 0x5d400000, 0xfb600000, 0x10f00000, 0x0ea80000, 0x330c0000, 0x94320000, 0x85910000, 0x13598000, 0xd0244000, 0x377f6000, 0x2743b000, 0xa6794800, 0xa334ec00, 0x00e61200, 0x7246d700, 0x7a174280, 0x77efd2c0, 0xd59b9fe0, 0xcc1c3850, 0x49ab0398, 0x1b941024, 0x73b75a02, 0x9b3e3b03, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x98000000, 0xac000000, 0x0e000000, 0xf3000000, 0xc0800000, 0x49400000, 0x73600000, 0x34b00000, 0x98f80000, 0x07540000, 0x41ca0000, 0x25d10000, 0xb1488000, 0x3c2d4000, 0x675e6000, 0x6a3a3000, 0x7148d800, 0xdc2ddc00, 0xf75ec600, 0xc23bd100, 0x45497a80, 0x7e2c62c0, 0x0a5eb360, 0xf1bb06f0, 0xcc88f528, 0x440c73d4, 0x4d8e1e02, 0x5df20d01, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xe8000000, 0xbc000000, 0x22000000, 0x7d000000, 0xeb800000, 0xe7c00000, 0x2ba00000, 0xf1300000, 0x5f980000, 0xb36c0000, 0x738e0000, 0x34910000, 0xd9a98000, 0xe6744000, 0x1ea3e000, 0x1e7ed000, 0x6029f800, 0x54b58400, 0x42835a00, 0xda8ee700, 0x8111e780, 0x4168ab40, 0xab54fc60, 0x0bd3a230, 0x3186d658, 0x2bd4c3dc, 0xf492a202, 0x71676303, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x88000000, 0x44000000, 0xde000000, 0x6d000000, 0x04800000, 0x35400000, 0xa4200000, 0xf3f00000, 0x89d80000, 0x43a40000, 0xdcea0000, 0x5ad10000, 0x2ea98000, 0xe73c4000, 0x476f6000, 0x67ca1000, 0x0aa00800, 0x3db07c00, 0x2079fa00, 0xef947900, 0x2153f280, 0x0e257c40, 0x632b01e0, 0xbeb080b0, 0x01f804c8, 0xba55cb14, 0xde33f202, 0xbcf50503, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x08000000, 0xdc000000, 0x5e000000, 0x45000000, 0x47800000, 0xc5400000, 0x8fa00000, 0xef900000, 0x9de80000, 0x6c940000, 0x52920000, 0x6d310000, 0x49f98000, 0xfa3cc000, 0x0ca7e000, 0x43b31000, 0xfe613800, 0x4bf1fc00, 0x4919aa00, 0x3d0d7f00, 0xd25e2280, 0x7d0f1b40, 0x11076920, 0x8f237ed0, 0xd5087ca8, 0xd7a480e4, 0x426a9202, 0xee8d8303, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x58000000, 0x3c000000, 0x9e000000, 0x53000000, 0x3d800000, 0xea400000, 0x8b600000, 0xad700000, 0x5f080000, 0xb9740000, 0xa55e0000, 0x09110000, 0x31f98000, 0x8f3d4000, 0x82cae000, 0x8f7fb000, 0x4e80f800, 0x67c1fc00, 0x99210600, 0x6a102b00, 0x34791c80, 0x897c52c0, 0xbfaac0e0, 0x150f6310, 0x8e085d68, 0xf9f548fc, 0xd99ffe02, 0x19b0d703, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x48000000, 0xbc000000, 0x5a000000, 0xdd000000, 0x45800000, 0xe6c00000, 0xcfa00000, 0x56300000, 0x4da80000, 0x71040000, 0x2f260000, 0xa8910000, 0x8c198000, 0x5b6dc000, 0x5e03a000, 0xa2479000, 0x5f01f800, 0x4c80f400, 0x7541da00, 0x3661bb00, 0xf5102580, 0x5ed85340, 0x92cda260, 0x5f33aa50, 0x3f6ea488, 0x31448c8c, 0x10c62202, 0x99404f03, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x58000000, 0xdc000000, 0x9a000000, 0x03000000, 0x2b800000, 0xad400000, 0xf8e00000, 0x47900000, 0x56f80000, 0xfd3c0000, 0xbff20000, 0xc8710000, 0x04e88000, 0x1384c000, 0x60ae6000, 0x31d3b000, 0xa2403800, 0x61617400, 0x0dd0a600, 0xf3988700, 0xd6ec5280, 0xe56b7dc0, 0x6e1cbd20, 0xbb427cf0, 0xb23937f8, 0x679d34a4, 0xb9029e02, 0xc358f301, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x18000000, 0x8c000000, 0xb6000000, 0x09000000, 0xc3800000, 0xe7c00000, 0x0ca00000, 0x72f00000, 0x75580000, 0xa1a40000, 0x84160000, 0xf1510000, 0x95288000, 0xdcbd4000, 0xc8d36000, 0x1a173000, 0x2c509800, 0xcca8ac00, 0x347c3200, 0x16f2d700, 0xc0a7e780, 0x0469ed40, 0x1a5c5be0, 0x74435fb0, 0xd49f5bc8, 0x7c9c76ec, 0xdf62aa02, 0xc3af7b01, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x28000000, 0xc4000000, 0x9e000000, 0x5b000000, 0x66800000, 0x6ec00000, 0xab200000, 0x0c500000, 0x4f480000, 0xaf4c0000, 0x8aca0000, 0x26710000, 0x20998000, 0x13454000, 0xb6e66000, 0x4d0b5000, 0x2ad10800, 0x4189fc00, 0x946d9600, 0x9e9afd00, 0x85380580, 0xd5d46240, 0x5c8ed2a0, 0xad178590, 0x65d39e18, 0xfc74d654, 0x501e9e02, 0x9a7e0103, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x48000000, 0x1c000000, 0x32000000, 0x19000000, 0xb2800000, 0x3dc00000, 0x3ba00000, 0x1a500000, 0xeff80000, 0x5d8c0000, 0xeafe0000, 0x33710000, 0x18688000, 0x51d4c000, 0x0923e000, 0x50779000, 0x4195b800, 0x3ac22400, 0xfdc61200, 0xf5dd9500, 0x5c069380, 0xbc7c0b40, 0x3f5792a0, 0x1105e0f0, 0x171a9998, 0xdc5adf3c, 0x0c3b2a02, 0x32cb7101, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xe8000000, 0x14000000, 0xb2000000, 0x75000000, 0xf0800000, 0x7ac00000, 0x2e600000, 0x18500000, 0xdde80000, 0x23340000, 0xb8820000, 0x36b10000, 0xb7788000, 0x54bd4000, 0xe9e66000, 0xdadad000, 0xf47da800, 0xe686a400, 0x200aca00, 0x1655d100, 0xf352cd80, 0xee1930c0, 0x616c8ea0, 0x0a4e08d0, 0x2f4f7ee8, 0xe7ce0644, 0xf10fe202, 0xa16e3501, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xe8000000, 0xec000000, 0x22000000, 0xb5000000, 0xff800000, 0x48c00000, 0xf8e00000, 0xdab00000, 0xff880000, 0x56dc0000, 0xeaba0000, 0x11d10000, 0xdff88000, 0xacb54000, 0xa557a000, 0x8622d000, 0x39145800, 0x9ec78400, 0x1a7a8a00, 0xad300f00, 0x6b495980, 0x143c8dc0, 0x510aeb60, 0x37d86210, 0xbae4df38, 0xd66edb34, 0x6c765202, 0xe9f2cb01, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xb8000000, 0x7c000000, 0xea000000, 0xd9000000, 0x78800000, 0x1cc00000, 0x5da00000, 0x3b100000, 0x3b480000, 0xbf740000, 0x42320000, 0xb4310000, 0x65998000, 0x711cc000, 0xd2976000, 0x54ea7000, 0xc3cc7800, 0x5efe9400, 0x094f1200, 0xc5966100, 0x136bf180, 0x4c8cb740, 0x721f4020, 0x59be1d90, 0x21ae0a68, 0x6367a8a4, 0x7452ea02, 0x25003503, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xc8000000, 0xbc000000, 0x3e000000, 0x01000000, 0x52800000, 0x4dc00000, 0x4f600000, 0xe2d00000, 0x31c80000, 0x81c40000, 0xeaa20000, 0x89310000, 0x63d88000, 0x73edc000, 0x3577e000, 0x87ba9000, 0x783cf800, 0xba3f3c00, 0xadbf2200, 0x58ff5500, 0xc95e3380, 0x316e3ac0, 0x88378ba0, 0xea1b8c90, 0x5e0c0908, 0xf267e604, 0x55135a02, 0x1d29a901, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x18000000, 0x44000000, 0xca000000, 0xed000000, 0xbd800000, 0x7dc00000, 0x06200000, 0x3a100000, 0x34b80000, 0x3c640000, 0xd0c60000, 0x83b10000, 0xa2698000, 0x0d7d4000, 0x04732000, 0x6d6f3000, 0x69ec0800, 0x178b5400, 0xda6aba00, 0xd55aeb00, 0xf9738380, 0x08eff040, 0xf02cea20, 0x4bab9070, 0x157bb448, 0x1862004c, 0x72d73202, 0x3308ff03, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x78000000, 0xa4000000, 0x02000000, 0xef000000, 0x1a800000, 0x35c00000, 0xd8a00000, 0x33b00000, 0x12180000, 0x3fe40000, 0x33660000, 0x9f910000, 0x15698000, 0x2edd4000, 0x7172a000, 0x780ff000, 0x384dc800, 0x339ac400, 0xc6933e00, 0xc6dee500, 0x31441380, 0x05d69d40, 0x0409ad60, 0xf3cd5730, 0x65dadd48, 0x54728e0c, 0x618f7602, 0x390d6103, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x78000000, 0x54000000, 0x46000000, 0x15000000, 0xc9800000, 0x40400000, 0xb8600000, 0x96300000, 0x93080000, 0xb4840000, 0x01960000, 0x52d10000, 0xbcf98000, 0x87ac4000, 0x3f43e000, 0x687ff000, 0x88a42800, 0x01c74c00, 0xbee88a00, 0xc8f50300, 0x0dfe9880, 0x1ae5b4c0, 0xcaa6fa60, 0x04597710, 0xaa3c9688, 0x155b696c, 0x73232202, 0x884f0f03, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x48000000, 0xd4000000, 0xe2000000, 0x09000000, 0xdf800000, 0x7fc00000, 0x43e00000, 0xc4500000, 0xe6e80000, 0xafc40000, 0x035e0000, 0x61310000, 0x0af98000, 0x010d4000, 0x792b6000, 0x01d79000, 0x29652800, 0x3aaf0400, 0x50a93200, 0x08e5cf00, 0xba6e8780, 0x87c88bc0, 0xd5f54ea0, 0xf72688d0, 0x047dbb08, 0x55f37cfc, 0x126b9a02, 0x9b768b03, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x48000000, 0x2c000000, 0x6e000000, 0x5d000000, 0xa2800000, 0x66c00000, 0x26200000, 0xa0d00000, 0xd6b80000, 0xc0cc0000, 0x32460000, 0xe1710000, 0xb6298000, 0x24954000, 0x9f7b2000, 0x3edf9000, 0xc76cd800, 0x13d61c00, 0x11a9da00, 0x44d57500, 0x3d9b4580, 0x1b2ee840, 0x068537a0, 0xede2ca70, 0xcdc3b518, 0x4c136f4c, 0xbe2a8202, 0xf9272903, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xf8000000, 0x6c000000, 0x2a000000, 0x71000000, 0x31800000, 0xd5400000, 0x2da00000, 0x24d00000, 0x74980000, 0xa9ec0000, 0x63be0000, 0xa5f10000, 0x5e898000, 0x3494c000, 0x82a2e000, 0xbb46f000, 0x67ac5800, 0xae9f1400, 0x75e1c200, 0x5af0f300, 0x00084280, 0xf7543740, 0x98c30fa0, 0xb3f7b030, 0xb8844e58, 0xf4da94bc, 0x82da1a02, 0x81da2703, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x78000000, 0x6c000000, 0x3e000000, 0x11000000, 0x89800000, 0x17400000, 0x91200000, 0xa3b00000, 0x29880000, 0x722c0000, 0x04960000, 0xae110000, 0xaef98000, 0xb6c44000, 0x86aae000, 0x857ff000, 0x17ac5800, 0xedd7bc00, 0x0e318200, 0xf4c88300, 0xf00c4680, 0x09a76640, 0x1c58e960, 0x81343a10, 0xb883e5d8, 0xab22c7ec, 0x4d525a02, 0x783a7f03, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x88000000, 0xbc000000, 0x62000000, 0xed000000, 0x0d800000, 0x30400000, 0x9aa00000, 0x24f00000, 0xa0f80000, 0x56440000, 0xf6be0000, 0xecd10000, 0xbcc98000, 0xdddd4000, 0x54eb2000, 0xddc61000, 0x51d5f800, 0xde560400, 0xbf3cba00, 0x36bbab00, 0x0bce4880, 0x52692940, 0x472c87e0, 0x4b1398f0, 0x73032308, 0xaeab8abc, 0x4666c202, 0x32a5ef03, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x68000000, 0x04000000, 0x36000000, 0x57000000, 0x15800000, 0xf4400000, 0x26200000, 0xcdd00000, 0x4d580000, 0xe3ac0000, 0x8f220000, 0x8f710000, 0xae498000, 0xa5154000, 0x713e6000, 0xaffbd000, 0x049c8800, 0xfd4aac00, 0xb2b48e00, 0x8eaf1b00, 0x5b837080, 0x0b60c840, 0x957149a0, 0xab4937b0, 0x4194d8d8, 0x9ffecc84, 0x041b8602, 0x292df703, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x78000000, 0x34000000, 0xca000000, 0x01000000, 0x91800000, 0xc9c00000, 0xd5e00000, 0x8e500000, 0xae280000, 0xacac0000, 0x669a0000, 0x15310000, 0x83388000, 0x56254000, 0x8dc6e000, 0xfdf3f000, 0xfa3de800, 0x64d25400, 0x620ca200, 0x686bb300, 0xe6e94b80, 0xa8cc37c0, 0x810b3aa0, 0x1ef9f550, 0xd9c40dd8, 0xaa97df74, 0xfe5bca02, 0x1951a701, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x48000000, 0x0c000000, 0x82000000, 0x51000000, 0xcf800000, 0xb7400000, 0xbee00000, 0xabb00000, 0xbda80000, 0x027c0000, 0x376e0000, 0x95d10000, 0x35d98000, 0x44f4c000, 0xca822000, 0xa4079000, 0xc90c9800, 0x67664400, 0x7cfd4200, 0x9faeaf00, 0xb4702680, 0x3c89c1c0, 0x98eca160, 0x28567e50, 0xdc946178, 0x8df3479c, 0xb60e5a02, 0x11212b03, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xd8000000, 0x04000000, 0x8e000000, 0x31000000, 0x73800000, 0xd4c00000, 0xfee00000, 0x26500000, 0x3b580000, 0x27a40000, 0x715e0000, 0xc0310000, 0x8d498000, 0x385cc000, 0x8b0be000, 0xe546b000, 0x41b48800, 0xe6a65c00, 0x76644200, 0x0a3f3700, 0x97a1d180, 0x9d7089c0, 0x006842a0, 0xc66d1bb0, 0x4f43adc8, 0x3a9bdcfc, 0xb87f4a02, 0x1000ab03, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x18000000, 0xa4000000, 0x6e000000, 0x17000000, 0x7b800000, 0xfcc00000, 0x48a00000, 0x93b00000, 0x55c80000, 0x14e40000, 0xa3860000, 0x57d10000, 0xf6d88000, 0xe69c4000, 0x24ab6000, 0x4bb33000, 0xb30ec800, 0xc2551c00, 0x10cf8e00, 0x9d74e700, 0x3dbf6180, 0xf51c7540, 0x046b7d60, 0x5913de90, 0xf1bea148, 0x471df4cc, 0x496a2602, 0xf392cb01, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x88000000, 0xf4000000, 0x86000000, 0xff000000, 0x47800000, 0x59400000, 0x76200000, 0xd4f00000, 0xb5c80000, 0x40ec0000, 0xba560000, 0x63910000, 0xfb188000, 0x0bd4c000, 0xfa736000, 0xdbaa1000, 0xb11e6800, 0x82bc4c00, 0x49aede00, 0x23d53f00, 0x9e73aa80, 0x05aad840, 0x821e53e0, 0x3f3d4690, 0x9def8a58, 0x6b75196c, 0xab43d602, 0xd8836301, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xb8000000, 0x04000000, 0x96000000, 0xf7000000, 0x84800000, 0x67400000, 0xed600000, 0xa0500000, 0xcf280000, 0xf49c0000, 0x7dea0000, 0xe6710000, 0xc8198000, 0x6ee54000, 0x2bde6000, 0xc7c67000, 0xcf228800, 0x0bfcec00, 0x7cbb4e00, 0xfad85900, 0xef445680, 0x212ecec0, 0x849eeaa0, 0xf6a7a550, 0x6d7208b8, 0x2dd46a94, 0x47a7a602, 0xf6f2c503, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x58000000, 0xc4000000, 0x16000000, 0xbd000000, 0x6f800000, 0x2c400000, 0xb6200000, 0x78b00000, 0x05180000, 0xf8840000, 0x87220000, 0x2cd10000, 0xf2888000, 0xdcac4000, 0x7bff2000, 0xd2d7b000, 0xc98a0800, 0xa7cdec00, 0x68ee9a00, 0x983e0f00, 0x98b7c080, 0x7f1bb840, 0x8e64cf60, 0xdb72d330, 0x9e995488, 0x4ac45184, 0x3003b202, 0x79e05301, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x88000000, 0x04000000, 0xde000000, 0xbd000000, 0xab800000, 0xf0400000, 0x35600000, 0x9cb00000, 0x4ac80000, 0x87340000, 0x31a20000, 0xaf910000, 0xaa198000, 0x9ccdc000, 0xed1fa000, 0xd5e61000, 0x3fda8800, 0x2e6cfc00, 0x268e9a00, 0xb1ff2700, 0x7617d880, 0xbcf38ec0, 0x55291760, 0x0245f490, 0xb14bbbe8, 0x9df4ba04, 0xfd03b202, 0x2901cb03, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xb8000000, 0xf4000000, 0x76000000, 0x33000000, 0x9c800000, 0xf0c00000, 0x62e00000, 0xe6100000, 0xb0280000, 0x3df40000, 0x485e0000, 0x0e310000, 0xa5d98000, 0x824dc000, 0xf2c3a000, 0x393a7000, 0x15876800, 0x587dac00, 0x111b8600, 0xe0772900, 0x37c45980, 0x1386f1c0, 0x237dce20, 0xf19b8350, 0xfab69d68, 0x5c24a9fc, 0xd8174e02, 0xba14f503, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xa8000000, 0xd4000000, 0xfe000000, 0x8d000000, 0xf9800000, 0xd6c00000, 0x2a200000, 0xb1300000, 0x63d80000, 0x43fc0000, 0xfce20000, 0xafd10000, 0xefc98000, 0x5395c000, 0xda86e000, 0x43ae5000, 0xa82b2800, 0xecc4bc00, 0xac0fba00, 0xc5da8300, 0x463d3580, 0xf2431040, 0x09a00c60, 0x7cf1e2b0, 0x0978fb78, 0x538d4704, 0x46da7202, 0x5abc6f03, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x08000000, 0x14000000, 0x6a000000, 0x3f000000, 0xf8800000, 0x85c00000, 0x04600000, 0x13100000, 0x89580000, 0x98740000, 0x67120000, 0xddb10000, 0x9ea88000, 0x2bfdc000, 0x545ea000, 0x78c71000, 0x14d3a800, 0xd8d09400, 0xc0399e00, 0xb0e48100, 0xbd0b9380, 0x9965e4c0, 0x3d4a2420, 0x7b4489b0, 0x657b9468, 0x43acec64, 0xe5a69602, 0xf6420501, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x68000000, 0x7c000000, 0x76000000, 0xe5000000, 0x69800000, 0xba400000, 0xb5a00000, 0xe5d00000, 0x5de80000, 0x785c0000, 0xbac60000, 0x07310000, 0x28188000, 0x14254000, 0x0bd3a000, 0x2bfbd000, 0x9d477800, 0x0c702c00, 0x5e39aa00, 0x08b4e300, 0x071afc80, 0x19b6af40, 0x038995a0, 0xc66c8ed0, 0x1d5e7d38, 0x8455c94c, 0x53eb7202, 0x7e4e1f01, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x38000000, 0xfc000000, 0x22000000, 0xc5000000, 0xf6800000, 0xd7400000, 0x3e600000, 0xbc700000, 0xc6680000, 0x1c5c0000, 0x3a1a0000, 0xb8510000, 0x16f98000, 0x9f054000, 0x514ea000, 0xd5e77000, 0xad1b7800, 0x23d18400, 0x5339ea00, 0xf8247d00, 0x0c5e8680, 0x607eb0c0, 0x74efcee0, 0x29b66fd0, 0xa5e29138, 0xfbd55b74, 0x61f63202, 0x34038903, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x68000000, 0x94000000, 0x3a000000, 0xbd000000, 0x7e800000, 0xfe400000, 0x28200000, 0xc4900000, 0x0cb80000, 0x75ec0000, 0x85960000, 0xbbf10000, 0xe4888000, 0xde844000, 0x7a63a000, 0x195bd000, 0x6a76a800, 0x0a81b400, 0x74401a00, 0x0d21cd00, 0x9611a480, 0x34f9dc40, 0x4ecdaf20, 0xb887ea70, 0x8a899058, 0x3984daec, 0x49e31202, 0x219aa901, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xb8000000, 0xd4000000, 0x8a000000, 0x4d000000, 0x57800000, 0x04400000, 0xe4e00000, 0x34900000, 0x78580000, 0x143c0000, 0xfad60000, 0xe5310000, 0x89a98000, 0xa7b4c000, 0xbed26000, 0xc78a7000, 0x4a372800, 0x9ba15400, 0xdcf1ba00, 0xd4097f00, 0xf844b080, 0x125a05c0, 0x7d0f4f20, 0x094d51b0, 0x219f55f8, 0xed153bec, 0xb3a2f202, 0x34c35b03, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x68000000, 0x9c000000, 0xd6000000, 0xed000000, 0xc2800000, 0xb6400000, 0x4f600000, 0xe8500000, 0x5f080000, 0x31840000, 0x75160000, 0xaa710000, 0x17b98000, 0x121dc000, 0x32bba000, 0x21d3d000, 0xe387b800, 0x1758ec00, 0x9e8c3a00, 0x1c933500, 0xfb662480, 0x9fc85ac0, 0xa2a4dea0, 0xd9272d10, 0x8aa92088, 0xf9f4f56c, 0xe5ae2202, 0x71ed0903, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xc8000000, 0x1c000000, 0x8a000000, 0x23000000, 0xf7800000, 0x0c400000, 0x52600000, 0xadf00000, 0xbd180000, 0xd8cc0000, 0xbaee0000, 0x52d10000, 0xaa088000, 0xc9e4c000, 0x7a1a2000, 0xece29000, 0xc89fb800, 0xaf885400, 0x02a42600, 0xf1fa9f00, 0x20529080, 0xad6798c0, 0x947571e0, 0x05f3a730, 0x5cb67018, 0x89fc2e9c, 0xa057be02, 0x64cd5b01, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x28000000, 0x64000000, 0x62000000, 0x07000000, 0x60800000, 0x7b400000, 0x0ba00000, 0x29100000, 0x2f580000, 0xda5c0000, 0x6e960000, 0x38f10000, 0x98698000, 0x08d5c000, 0xbff2a000, 0x9fcb5000, 0xa0e64800, 0x76d98400, 0xc89cee00, 0xcff7f100, 0x1c81ce80, 0xc541cb40, 0xc2a19020, 0x1890f5b0, 0x7999dd38, 0xa93c35ec, 0x35e60602, 0x49582503, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x58000000, 0x3c000000, 0xe2000000, 0x2d000000, 0x0a800000, 0x94c00000, 0x5b600000, 0xd4500000, 0x80a80000, 0x97bc0000, 0x81e20000, 0xe0f10000, 0x4e198000, 0x9e044000, 0xd4d62000, 0xaedfb000, 0x60d2f800, 0xf3090400, 0x3a8dba00, 0xd81ac500, 0xed64c180, 0x94863ac0, 0x98770ea0, 0x4c6e2a50, 0xd36a39f8, 0xb73c1184, 0x9c236202, 0x4f117103, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x98000000, 0x4c000000, 0x76000000, 0x07000000, 0x34800000, 0x90c00000, 0x4ae00000, 0xb2b00000, 0x03080000, 0xe5f40000, 0x78020000, 0xec110000, 0xc3998000, 0x3aacc000, 0x1e4f2000, 0xd7ee3000, 0xbbfe1800, 0xb866ac00, 0xe2cb6e00, 0x6c843900, 0x236ae980, 0xd49531c0, 0x1af28f60, 0xff38e510, 0xa73c5968, 0x14963f44, 0x8ae3d602, 0x22a06503, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xd8000000, 0xc4000000, 0xe2000000, 0x05000000, 0xb7800000, 0x8cc00000, 0xaea00000, 0xaf500000, 0x5e680000, 0x309c0000, 0xa17e0000, 0x1eb10000, 0x01588000, 0xc2044000, 0x9b5aa000, 0xa3fab000, 0x03aa0800, 0x83420400, 0x269f6a00, 0x5e81bf00, 0xd5414180, 0xf9604140, 0xc57008a0, 0xf57825d0, 0x3a1451b8, 0x4953a73c, 0x69974202, 0xc76d4b01, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xd8000000, 0xcc000000, 0xc6000000, 0xa7000000, 0x36800000, 0x5b400000, 0xf4e00000, 0x5f300000, 0xd9780000, 0xe1140000, 0x8e1e0000, 0xba110000, 0x97e98000, 0x68bcc000, 0x31c3e000, 0xe422b000, 0x8a931800, 0xae2bcc00, 0xc89eee00, 0xf9507d00, 0xcf083e80, 0x018d6dc0, 0x97bbb460, 0xffb635f0, 0x99ccc3a8, 0x47dbac7c, 0x36c79602, 0x13d5c103, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xa8000000, 0xcc000000, 0xfa000000, 0x43000000, 0x3d800000, 0x0b400000, 0xcf200000, 0x03300000, 0x96c80000, 0xdc040000, 0xf2920000, 0x4ed10000, 0x0f998000, 0xd3dc4000, 0x6feea000, 0x2b4e5000, 0x5a3f1800, 0x5d573400, 0xe4a2e600, 0xec994b00, 0x7e5dbe80, 0xecae4240, 0x786e1c60, 0x0b0e6c90, 0x449fff88, 0xff2704e4, 0x564ade02, 0xc22c6f03, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xa8000000, 0xec000000, 0x2a000000, 0xf9000000, 0x26800000, 0xc6400000, 0xd2e00000, 0xa0100000, 0x46080000, 0x43840000, 0x3a6a0000, 0x74310000, 0x11b88000, 0xa0fd4000, 0xe336e000, 0xdd765000, 0x7b965800, 0x15869400, 0x1c8fd200, 0x028b3d00, 0xcd212480, 0xa13059c0, 0xfd39ce20, 0x4fbd0f10, 0xcf566888, 0xff276e94, 0x297fea02, 0x2512b901, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x78000000, 0x8c000000, 0x8e000000, 0x1d000000, 0x85800000, 0x98c00000, 0xe2a00000, 0x71f00000, 0xdbf80000, 0x338c0000, 0x4d7e0000, 0x14110000, 0xdf688000, 0x45a44000, 0x50bae000, 0x34fbf000, 0xa11a9800, 0x9d8adc00, 0x47a31a00, 0xa466db00, 0xe18df980, 0x967f1140, 0x58918de0, 0xb02812f0, 0xd4c4d398, 0xd76bbb3c, 0x0db3e202, 0x2e0fb701, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xa8000000, 0xec000000, 0xda000000, 0xd5000000, 0xb9800000, 0xc4400000, 0x52600000, 0x69700000, 0x96d80000, 0x5e040000, 0x99460000, 0x08d10000, 0x52898000, 0xe14dc000, 0x162b6000, 0xd1ea5000, 0xe2cb5800, 0x285af400, 0x4fb38a00, 0xa70e0300, 0x303d2080, 0x54f2b8c0, 0x41efe4e0, 0x808d28b0, 0xd20a9188, 0x83fb0bcc, 0x66e23202, 0xb5c76703, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xd8000000, 0x44000000, 0x02000000, 0x37000000, 0xb7800000, 0xeac00000, 0x29a00000, 0x07f00000, 0x9f880000, 0x25940000, 0xdbd60000, 0xe0110000, 0x1e988000, 0xf18cc000, 0x0c1b6000, 0xb6eab000, 0xc5e30800, 0x43374400, 0x9a804e00, 0x0e41ff00, 0xa6e14d80, 0x9b900f40, 0x9a595de0, 0x112cb210, 0x7d6a9ba8, 0x9922306c, 0xe796a602, 0xe9f1cb01, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x28000000, 0x8c000000, 0x76000000, 0x85000000, 0xfe800000, 0x8f400000, 0x4e200000, 0xf1100000, 0xf7f80000, 0x527c0000, 0x1d1e0000, 0x6df10000, 0xd4088000, 0x0775c000, 0x2eeba000, 0xc75b5000, 0x82f29800, 0xff56ac00, 0x1424ea00, 0x45b34d00, 0xad773680, 0x5b351840, 0x6b4a0c20, 0x5f8b8cf0, 0xc06bd178, 0xc01a47fc, 0x70d35202, 0x80467101, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x58000000, 0xbc000000, 0xfe000000, 0x9d000000, 0x09800000, 0x64c00000, 0x12e00000, 0x47700000, 0xe7780000, 0x8c640000, 0xfe120000, 0x83d10000, 0xbea88000, 0x8dcc4000, 0x495ee000, 0x12cfb000, 0x37c6f800, 0xc95a3c00, 0x51ec1a00, 0xfbce8300, 0x3446a180, 0x7a9b71c0, 0xbd8c40e0, 0x56fe43f0, 0x739e1448, 0xad2e9164, 0x01368202, 0x86e24f01, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x28000000, 0x34000000, 0xd2000000, 0x7b000000, 0x1f800000, 0x22c00000, 0xc4200000, 0x7bf00000, 0x11980000, 0x701c0000, 0xd8720000, 0x9f910000, 0xfa098000, 0xb8144000, 0x2b662000, 0x93775000, 0x57bee800, 0xcd8b6400, 0x341c1600, 0xd2738f00, 0xc8911d80, 0x3b89b440, 0x2fd5dde0, 0x6dc70630, 0x7cc698b8, 0xc4465c24, 0x3f075e02, 0x60e6fb03, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x48000000, 0x8c000000, 0xd2000000, 0xe3000000, 0x48800000, 0x05400000, 0xab200000, 0x03900000, 0x0c480000, 0x2da40000, 0x909e0000, 0x1c490000, 0x45a48000, 0xac9ec000, 0x5648a000, 0x62a41000, 0xba1fd800, 0x62090400, 0x6205d600, 0xf44f4900, 0xc0210e80, 0xe7108040, 0x6b094e20, 0xfd841610, 0x1f8e5b08, 0x4b41af1c, 0xf2210e82, 0x94108041, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x88000000, 0xf4000000, 0xc6000000, 0xbb000000, 0x82800000, 0x46400000, 0x36a00000, 0x8ab00000, 0xbb780000, 0x1d040000, 0x8ca20000, 0xc3790000, 0xa1058000, 0x9ea24000, 0xce79e000, 0x10849000, 0xae63a800, 0x78986c00, 0x1795e600, 0x1d2aad00, 0x98a4e080, 0xb0938b40, 0xd840b860, 0x41a11670, 0x92307148, 0x04380124, 0x5c24e082, 0x8dd38b43, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x08000000, 0xec000000, 0x86000000, 0x2d000000, 0xe1800000, 0x6dc00000, 0xfaa00000, 0xe1700000, 0x00180000, 0x6ffc0000, 0x6f260000, 0x78190000, 0x7bfd8000, 0x3d26c000, 0x6719a000, 0xd57d9000, 0xf6671800, 0xbaf8ac00, 0x6fedca00, 0x61eedb00, 0xa30c7780, 0x74fe3f40, 0xf84419e0, 0xa02af7b0, 0x4ae6a0b8, 0xceb927ac, 0x2c8c7782, 0x483e3f43, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xe8000000, 0x4c000000, 0x32000000, 0xfb000000, 0x89800000, 0xb7400000, 0xdaa00000, 0xfb500000, 0x1b380000, 0x326c0000, 0x6b0a0000, 0xb7390000, 0xf06d8000, 0x180ac000, 0x42b96000, 0x9d2c5000, 0x75aa5800, 0x02690400, 0xca55a600, 0x14e74b00, 0x25726a80, 0xbcf51340, 0x2db73da0, 0x4d4a9cf0, 0x7b191798, 0x2bfc3bb4, 0x97d26a82, 0xcba51343, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xd8000000, 0xd4000000, 0x72000000, 0xf3000000, 0xf5800000, 0x82400000, 0xf0200000, 0x40d00000, 0x9ca80000, 0x591c0000, 0x773a0000, 0xb0a90000, 0x8f1d8000, 0x9e3ac000, 0x6a28a000, 0x86dc3000, 0xb95b6800, 0xae584400, 0xde65d600, 0xfb0e8300, 0xb2cf4080, 0x35af3640, 0x41de82a0, 0x116739d0, 0x5f32e478, 0xe5a47cd4, 0x8f6f4082, 0x333f3643, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x68000000, 0xe4000000, 0x02000000, 0x0f000000, 0x3d800000, 0x85400000, 0x62200000, 0x14f00000, 0x2c780000, 0xdef40000, 0x1b360000, 0xb0790000, 0x20f58000, 0xba364000, 0xd4f86000, 0xfd355000, 0x8bd78800, 0x18e86400, 0x2ddd4e00, 0x320bf300, 0x60e36e80, 0x163e8a40, 0x73b55ae0, 0x7d17f670, 0x368997a8, 0xdb8d9c8c, 0xd5436e82, 0xac8e8a43, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x78000000, 0xdc000000, 0x0a000000, 0x8b000000, 0xc0800000, 0x0bc00000, 0xf7a00000, 0x50b00000, 0xe7280000, 0xc9f40000, 0xe60a0000, 0xad290000, 0x62f58000, 0x168bc000, 0x0ee8a000, 0x31557000, 0x903a7800, 0x68c0b400, 0xb3206600, 0xbd71f900, 0x3989a380, 0x76c40940, 0x1c629860, 0x19bccdd0, 0x686eeaa8, 0xc77a2c74, 0xbea1a382, 0xaf300943, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xb8000000, 0x5c000000, 0x76000000, 0x5d000000, 0x3a800000, 0x0e400000, 0x07e00000, 0xbe700000, 0x97880000, 0xb5d40000, 0xc5be0000, 0x79890000, 0x04d48000, 0xc13fc000, 0xdec92000, 0xabb5f000, 0x060f7800, 0x5f21cc00, 0xc9d14a00, 0x67190d00, 0x24acd080, 0x26a3c5c0, 0x4382b1e0, 0x19525f90, 0x45cb9e68, 0x23a6e29c, 0x51a4d082, 0x9137c5c1, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x98000000, 0x94000000, 0x32000000, 0xcb000000, 0xee800000, 0x6fc00000, 0xa8200000, 0xd9d00000, 0x41980000, 0xd08c0000, 0x5aca0000, 0x67990000, 0x698c8000, 0x9f4bc000, 0x36d8a000, 0x366db000, 0x7abae800, 0x9c90c400, 0x6c782600, 0x1e7d3500, 0xce031b80, 0xca4cf640, 0x316bc6a0, 0x2608f8b0, 0x1a744758, 0x27762b34, 0xa7bb1b82, 0x8310f641, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x58000000, 0x5c000000, 0xa2000000, 0x11000000, 0x14800000, 0xb7c00000, 0x8fa00000, 0xcb500000, 0xef880000, 0x818c0000, 0xae2a0000, 0x41890000, 0x1a8c8000, 0x4fabc000, 0x2cc96000, 0xc9ec3000, 0x52db7800, 0x09502400, 0x8e881200, 0x2d0d5100, 0x75ea4b80, 0x34288d40, 0x9cdd87a0, 0x16a23490, 0x0b855e58, 0xfce6d3f4, 0x6fc24b82, 0x73f48d41, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x78000000, 0x24000000, 0x72000000, 0xa7000000, 0xe7800000, 0x7b400000, 0x5d600000, 0x79b00000, 0xca380000, 0x115c0000, 0xf7060000, 0xc4390000, 0x905c8000, 0x1d874000, 0xebf96000, 0x5bfc7000, 0xc1170800, 0x90918400, 0x25693e00, 0x5794c700, 0xb0027280, 0x115204c0, 0x769af460, 0xeb1f46f0, 0x69b57678, 0x60d3826c, 0x38da7282, 0x66fe04c1, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x38000000, 0x3c000000, 0xd6000000, 0xcd000000, 0xa2800000, 0x29c00000, 0xdaa00000, 0x39f00000, 0x70280000, 0x5fbc0000, 0x3b820000, 0xcd290000, 0x853c8000, 0x8e434000, 0x3188e000, 0x49ccf000, 0x60eb3800, 0x91f54c00, 0x65ef6a00, 0x36b37d00, 0x4d219f80, 0x6eb19f40, 0x0549eee0, 0xb9ec8fd0, 0xd4da9838, 0x217d95e4, 0x20a39f82, 0x2e989f41, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xa8000000, 0x64000000, 0xa6000000, 0x93000000, 0xcd800000, 0x63c00000, 0xb1e00000, 0x8e700000, 0x72680000, 0x769c0000, 0x882a0000, 0xc9690000, 0x9f1c8000, 0x6dea4000, 0x3b88a000, 0x74edd000, 0x18428800, 0x5af5ec00, 0xe1b6f600, 0x6ec21300, 0xd0b5ab80, 0xb597d5c0, 0x1252afe0, 0x492c1f50, 0xb6a3f0f8, 0xfb04f3b4, 0x151fab82, 0x5f3ed5c1, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x28000000, 0x44000000, 0x8a000000, 0xcd000000, 0x79800000, 0xa1c00000, 0x3b200000, 0x6b500000, 0x3dc80000, 0xa7940000, 0x16c20000, 0x88c90000, 0xd2148000, 0xc9024000, 0x4ce82000, 0x61c4d000, 0xe28ac800, 0x369d3400, 0x93f74a00, 0xe49b3b00, 0xe434f780, 0xbbd37c40, 0x60e0cda0, 0x4571dc10, 0xf3183b68, 0x4d9cb424, 0xa176f782, 0x8fda7c41, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x28000000, 0x94000000, 0xce000000, 0x0f000000, 0xf2800000, 0xa0400000, 0xdc200000, 0xeab00000, 0xdaa80000, 0xaba40000, 0x5bfa0000, 0xf1a90000, 0xaf248000, 0x28bac000, 0xd509a000, 0x0cd4d000, 0x47b3e800, 0x08dc3c00, 0xfee6ce00, 0xd9af0d00, 0x6c5bfc80, 0x8ad8b640, 0xb96df860, 0x38cf59d0, 0xed4a2908, 0x6101e394, 0x8d81fc82, 0x4ac1b641, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x48000000, 0xcc000000, 0xae000000, 0xc3000000, 0x30800000, 0xc9c00000, 0xe1200000, 0x3c100000, 0xc6280000, 0x434c0000, 0xe3620000, 0xd6a90000, 0x1a8c8000, 0xea434000, 0xf6b8a000, 0x3aa41000, 0xa60ed800, 0x8b5bfc00, 0xe6cc9600, 0x6d223900, 0x94c92f80, 0x377df440, 0x28da5120, 0x178c7bd0, 0x29c38ed8, 0x37f981e4, 0x4645af82, 0x513eb441, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x48000000, 0x8c000000, 0xa6000000, 0x3d000000, 0xc1800000, 0xcc400000, 0x76e00000, 0xf9900000, 0xf4b80000, 0x847c0000, 0xbb0a0000, 0x65390000, 0xc03d8000, 0x61ea4000, 0xeaa8a000, 0x41851000, 0xa8175800, 0x3be3ec00, 0x6f5c6a00, 0x503b5b00, 0x62f03480, 0x776827c0, 0x5325b820, 0x5b6785f0, 0x08cb4338, 0xe698e434, 0x84cdb482, 0xeb8267c3, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x98000000, 0xbc000000, 0x96000000, 0x25000000, 0x2d800000, 0x54400000, 0x77200000, 0x49100000, 0x05180000, 0x234c0000, 0xc1120000, 0x90990000, 0xdb0c8000, 0xe833c000, 0x68886000, 0x4195b000, 0x903eb800, 0x403b4c00, 0xc4dcfa00, 0x40ca6300, 0xe1342480, 0x566e7440, 0xfe824120, 0x4d4016b0, 0x8ca1bed8, 0xd850d904, 0xefb8a482, 0xa61db441, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x68000000, 0x3c000000, 0xa6000000, 0xab000000, 0x4f800000, 0x15c00000, 0x4d600000, 0xb9d00000, 0x52e80000, 0xd6740000, 0x61a60000, 0x05690000, 0xf7b48000, 0x26c64000, 0x69b86000, 0x15dc5000, 0x30f23800, 0x5dbf2c00, 0x00840600, 0x763e2700, 0xa7454780, 0x2a5efcc0, 0xec1404a0, 0xe1f65a50, 0x1140bc28, 0xc721e1ec, 0x1971c782, 0x4258bcc1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x28000000, 0xfc000000, 0xee000000, 0x19000000, 0xab800000, 0x43400000, 0x45200000, 0x88700000, 0x1df80000, 0x3bc40000, 0xad5a0000, 0x8e790000, 0x5c858000, 0x727b4000, 0x3d096000, 0x35fdd000, 0x447eb800, 0xd3b2bc00, 0x2c94e200, 0x63d26f00, 0x4cc57a80, 0xdfdb0840, 0xc6b9afe0, 0x6ae57970, 0x972a03c8, 0x5481b754, 0xfdc0fa82, 0xcbe04843, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x28000000, 0x94000000, 0xb2000000, 0x6d000000, 0xf8800000, 0xfd400000, 0x21200000, 0x29d00000, 0x3a180000, 0x295c0000, 0x1aea0000, 0xf0990000, 0xf91c8000, 0x634b4000, 0xd408e000, 0xca24d000, 0xf7c66800, 0x46fb8400, 0x7ee10a00, 0xecb11900, 0x28683e80, 0x72d52840, 0x6c0edaa0, 0x31bec2b0, 0xd7562ef8, 0xffc38d74, 0x6b6cbe82, 0x78c26841, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xa8000000, 0x54000000, 0x1e000000, 0xf5000000, 0x35800000, 0xa2400000, 0x2de00000, 0x64100000, 0xe3780000, 0xf69c0000, 0x269e0000, 0xb8f90000, 0x59dd8000, 0xa2fec000, 0xa4a82000, 0xd444d000, 0xa4f26800, 0xe88e1c00, 0xe0803a00, 0xa7c18300, 0xd7a09880, 0x25f1c1c0, 0x65695b20, 0xaae41670, 0x0e8260f8, 0xfca6041c, 0x5b051882, 0x109301c3, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x28000000, 0xa4000000, 0xfa000000, 0x71000000, 0x4f800000, 0x28400000, 0x94e00000, 0xda300000, 0x6e580000, 0x00dc0000, 0xa2f20000, 0xe7d90000, 0x8f9d8000, 0xc692c000, 0x0928e000, 0xefe5d000, 0xb15f8800, 0x28131400, 0x16e83200, 0x4f449700, 0x798e8480, 0x9b7b7bc0, 0x18ecb360, 0x01ab7030, 0xbe841e78, 0xda2ebc84, 0x592b0482, 0xee45bbc3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xa8000000, 0xe4000000, 0x2a000000, 0xc3000000, 0x31800000, 0x30400000, 0xef600000, 0xb6b00000, 0xc6680000, 0xebb40000, 0xc2c20000, 0x8ce90000, 0x66758000, 0x73e34000, 0xac382000, 0x4c2cd000, 0xbbfe8800, 0x706e7400, 0x98d65600, 0x103a6b00, 0x7864d480, 0x811ae8c0, 0x08b4f660, 0xa3438050, 0xb4a903a8, 0xfd1431e4, 0x47535482, 0x4d50a8c3, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xf8000000, 0x2c000000, 0x92000000, 0x8d000000, 0xb4800000, 0x9b400000, 0x7fa00000, 0x81300000, 0x9fd80000, 0xc5e40000, 0xd1ba0000, 0x4a590000, 0x18248000, 0x285a4000, 0x48486000, 0x498d7000, 0xb3c61800, 0xc2274400, 0x74376a00, 0x0b9ef100, 0xc702b280, 0xa0ecb540, 0x0c966360, 0x4f2ea530, 0x8d1a0288, 0x68e99e14, 0xd13c3282, 0xb3dff541, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xe8000000, 0x2c000000, 0x56000000, 0x3d000000, 0x68800000, 0xe6c00000, 0xdb200000, 0x79100000, 0x1a580000, 0x03340000, 0x415e0000, 0xd3d90000, 0x73748000, 0x4dbe4000, 0x7f696000, 0x23fd5000, 0xcb721800, 0xf4d3cc00, 0x4d022a00, 0x797b4900, 0x77dec180, 0x7419bc40, 0x6ed50b20, 0x1b6efd30, 0x44918e28, 0xf8197f9c, 0x48d44182, 0xee6efc41, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x78000000, 0x84000000, 0xee000000, 0xd1000000, 0x6b800000, 0xf3400000, 0xdde00000, 0x32f00000, 0xd1280000, 0x7c540000, 0x716a0000, 0x17a90000, 0xce948000, 0x40ca4000, 0x1239a000, 0xcd8c7000, 0x47174800, 0x1e167c00, 0x9996d200, 0x58d61f00, 0x6e375a80, 0x704789c0, 0x6cae2ae0, 0xbbdb00d0, 0x07e1a568, 0x45f1b634, 0xe7a9da82, 0xa694c9c1, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x88000000, 0xe4000000, 0x36000000, 0x93000000, 0xf4800000, 0x0ec00000, 0xb3e00000, 0x8e700000, 0x0de80000, 0xb83c0000, 0x9a360000, 0xf6690000, 0x087c8000, 0xce164000, 0x2e79a000, 0x5ca59000, 0x45638800, 0xfda3cc00, 0x9d43b600, 0xc7b3e100, 0x949b1180, 0x174631c0, 0xe7014de0, 0x2a80d250, 0x09c165b8, 0xa960f38c, 0x7fb19182, 0x988971c1, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x58000000, 0xdc000000, 0x02000000, 0x53000000, 0x98800000, 0x04400000, 0xeea00000, 0x19500000, 0x48a80000, 0x52b40000, 0xdf1e0000, 0x91290000, 0x55758000, 0x797e4000, 0x9499e000, 0x3f2d3000, 0x6fb3f800, 0x9c5be400, 0x02ce9600, 0x1fc04900, 0x9a612c80, 0x57b16b40, 0x1158eba0, 0x0a4d95d0, 0xd2826228, 0x82431f9c, 0xa2a2ac82, 0xd2522b43, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x58000000, 0x6c000000, 0xce000000, 0x9d000000, 0xe3800000, 0xfb400000, 0xfe200000, 0xc4900000, 0x3bf80000, 0xf5ac0000, 0xc4da0000, 0x67790000, 0x7e6d8000, 0xdf3ac000, 0x3509e000, 0xdc653000, 0x47de1800, 0x35167c00, 0x2c930a00, 0x8c3d5f00, 0xcca3ca80, 0x21955640, 0x00974620, 0x86d3b570, 0x4f9c0918, 0x46729194, 0x33cc4a82, 0x68ea9643, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x78000000, 0xcc000000, 0x4a000000, 0x83000000, 0xfb800000, 0xfbc00000, 0xe0600000, 0x97500000, 0x29b80000, 0x73d40000, 0xa9da0000, 0x12790000, 0x73b48000, 0x2e8b4000, 0xf3c06000, 0xb4607000, 0x0150d800, 0x28b9f400, 0xbf55f600, 0x2f9a6f00, 0xc0d86380, 0x7c0446c0, 0x902399a0, 0xb20dc4f0, 0x195f5768, 0x041ba514, 0x13180382, 0x386436c1, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xb8000000, 0xfc000000, 0x8a000000, 0x53000000, 0xd1800000, 0x46c00000, 0x48e00000, 0x07b00000, 0xf1680000, 0x230c0000, 0x41a60000, 0x8fa90000, 0xd7ec8000, 0xac16c000, 0x3dc12000, 0x9d61f000, 0x57713800, 0x70893400, 0x1e3dd600, 0xdb8e5b00, 0x28849980, 0x8a1ab7c0, 0x04e66c60, 0x7e88cf50, 0x1b3de7d8, 0xa30f942c, 0x44c5b982, 0x11bb47c1, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xd8000000, 0xb4000000, 0xda000000, 0x11000000, 0x95800000, 0x10400000, 0x2be00000, 0x3b300000, 0x24680000, 0xa78c0000, 0x100a0000, 0x7c290000, 0x006c8000, 0xb53b4000, 0x1b41a000, 0x4f613000, 0x4ef02800, 0x97c91400, 0xdb5d9200, 0x61524300, 0x34cc9480, 0x336af5c0, 0x5cd91d60, 0x5ca44850, 0xeae7e8d8, 0xffd29e74, 0x400d3482, 0x6d4bc5c1, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xb8000000, 0xf4000000, 0xe6000000, 0xfd000000, 0x00800000, 0xe8c00000, 0xb9200000, 0xc7300000, 0x0dc80000, 0xe63c0000, 0xd48e0000, 0xb1090000, 0xa91c8000, 0x06bec000, 0xc0416000, 0x0de1f000, 0x84112800, 0xadf9ac00, 0xbc748a00, 0x35f3e900, 0x2fe71d80, 0x73450840, 0x343bcf60, 0xbbda6a10, 0x8cca2e38, 0xc0b3ff7c, 0x0e867d82, 0x3d94f841, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xc8000000, 0x2c000000, 0xa6000000, 0x8d000000, 0xb3800000, 0x55c00000, 0x70a00000, 0x65d00000, 0x16d80000, 0xc8a40000, 0x702a0000, 0x67190000, 0xd2048000, 0xaefb4000, 0xb7416000, 0x18e11000, 0x71b11800, 0xee292c00, 0x876c8a00, 0xe7773f00, 0xc486e780, 0x9dce7b40, 0x50d36ca0, 0x882c2630, 0xbb974008, 0x0f37c3f4, 0x90e78782, 0xc53f6b41, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x38000000, 0xb4000000, 0xc2000000, 0x03000000, 0x95800000, 0x36400000, 0x52e00000, 0x5f700000, 0xc7580000, 0x46bc0000, 0xcc460000, 0x4d190000, 0xea5c8000, 0x2e36c000, 0xc2c02000, 0x4220f000, 0x6651a800, 0xe088a400, 0xc2747600, 0x67d24300, 0x543ae880, 0x8d7f23c0, 0xb414d5e0, 0x70628230, 0x8e42b8b8, 0x16129e6c, 0x4b9ac882, 0xc16fd3c1, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x58000000, 0xd4000000, 0x12000000, 0xcb000000, 0xa8800000, 0xb2400000, 0xbda00000, 0x2cf00000, 0x8f580000, 0xb2cc0000, 0xd2320000, 0xdf190000, 0x4c6c8000, 0x3a43c000, 0xb4002000, 0xc2003000, 0x73006800, 0xec810400, 0xf8412600, 0xa2a0f900, 0x96714080, 0xf618ed40, 0xa7ed08e0, 0x4c827a30, 0xede11ed8, 0xd2517d84, 0x67296082, 0xd9d4dd41, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x58000000, 0xa4000000, 0xfa000000, 0xd5000000, 0x76800000, 0x5e400000, 0x2d200000, 0xc9f00000, 0x83f80000, 0x32fc0000, 0x62de0000, 0xbfb90000, 0xcedc8000, 0x57afc000, 0x7f002000, 0x5b803000, 0xfcc08800, 0x4160d400, 0xcdd11a00, 0x6289a500, 0xc0454880, 0xde83f040, 0x3c567ee0, 0x81fc3b70, 0x4f5f7fb8, 0x0078b65c, 0x2a3d6882, 0x39bfc041, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x38000000, 0x84000000, 0xc6000000, 0x13000000, 0x3a800000, 0x44400000, 0x7b200000, 0x06b00000, 0x77b80000, 0x9e5c0000, 0x97be0000, 0x79f90000, 0xac7d8000, 0x6a8fc000, 0xed81e000, 0x98c1f000, 0xbc60c800, 0x0f116c00, 0x89485600, 0xd0c57d00, 0xda530480, 0xb07fd040, 0x3518f860, 0x6e2c27f0, 0x8366eaf8, 0xa834b21c, 0xa7cae482, 0x57122043, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xc8000000, 0xa4000000, 0x1a000000, 0x7d000000, 0xe0800000, 0x2a400000, 0x8fa00000, 0xfb500000, 0xb0f80000, 0x30140000, 0x95b60000, 0x87b90000, 0x4f348000, 0xdca74000, 0x24e0e000, 0xf2711000, 0x3ae80800, 0x14cdd400, 0x9f336a00, 0x24978900, 0x21a9e080, 0x75ec2540, 0x412297a0, 0xd24e4570, 0xf22c2768, 0x2c4261cc, 0x78ff0082, 0x14243541, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xc8000000, 0xe4000000, 0x5e000000, 0x67000000, 0x86800000, 0x0cc00000, 0xe1a00000, 0x9c700000, 0xd0f80000, 0x7e040000, 0x5e1a0000, 0x53390000, 0xad258000, 0xf8ab4000, 0x71602000, 0x5fd01000, 0xf9888800, 0x657d9c00, 0x5b5f5e00, 0xe5c3c500, 0x578c2580, 0x9367cd40, 0xdc6755e0, 0x4ee78870, 0xe426a748, 0xde8610d4, 0xb6760582, 0xb74edd43, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x18000000, 0x8c000000, 0xae000000, 0xe1000000, 0x5e800000, 0x39400000, 0x74600000, 0xcdd00000, 0x2a180000, 0x164c0000, 0x198a0000, 0x3e590000, 0xf2ad8000, 0xdc1b4000, 0x56a1e000, 0x8471b000, 0xb9e85800, 0xfc65bc00, 0xfacff200, 0x2a26a500, 0x0cc3ae80, 0x254ceac0, 0xd00b06a0, 0x9498b6b0, 0x3f0c8c58, 0xa5ea9cb4, 0x17884e82, 0xe2b45ac3, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0x7c000000, 0x7a000000, 0x13000000, 0x7b800000, 0x02400000, 0xd0600000, 0x15700000, 0x11780000, 0x2a3c0000, 0x1d660000, 0xb4390000, 0xd7dc8000, 0x5b564000, 0x79a16000, 0xbf50d000, 0x9068b800, 0x30349400, 0x1b227600, 0xede30f00, 0x6e437080, 0x821246c0, 0x49fb7de0, 0x4b8fd670, 0xa8ccfcb8, 0x2c5eec2c, 0x29641082, 0x924b96c1, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xf8000000, 0x4c000000, 0x72000000, 0xbb000000, 0x36800000, 0x1e400000, 0xa0e00000, 0x8dd00000, 0x14980000, 0xfdac0000, 0x09f20000, 0xb3d90000, 0xe8cd8000, 0x40e34000, 0x9be0e000, 0x7b507000, 0xaad9d800, 0xad4d0400, 0x7c228600, 0xeb41f500, 0x67615880, 0xf21177c0, 0x1eb896a0, 0x8ddde5b0, 0x4ada2298, 0xbb7cec44, 0x13ebb882, 0xbc3407c3, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x28000000, 0xbc000000, 0x76000000, 0xf3000000, 0x7f800000, 0x18400000, 0xf4e00000, 0x6bb00000, 0x2a180000, 0x2f2c0000, 0xd2da0000, 0x0f590000, 0xb34c8000, 0x1caa4000, 0xc0e16000, 0xd1b0d000, 0xa7193800, 0x2fac8c00, 0xeb1bb600, 0xacf88700, 0x259c5c80, 0xb6424fc0, 0x4eb54860, 0x5fb6b4b0, 0xa4638f98, 0xd7247ed4, 0xbc3f3c82, 0x50c79fc1, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xe8000000, 0x8c000000, 0x96000000, 0x43000000, 0xf8800000, 0xb6c00000, 0x18200000, 0xceb00000, 0x6fd80000, 0xbb940000, 0x38520000, 0x88190000, 0x32358000, 0xe5a2c000, 0x8ea0e000, 0x6f705000, 0x1d79d800, 0x6ae4cc00, 0x8a2b5600, 0x7c7de900, 0xa5dfc180, 0xf57f7640, 0xc50f0c60, 0xaef62230, 0x55d3ff68, 0x2558b1c4, 0xf4552182, 0x9df22643, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x68000000, 0x8c000000, 0x9e000000, 0xd5000000, 0x19800000, 0xf5c00000, 0xf0e00000, 0x70100000, 0x9d680000, 0x555c0000, 0x078a0000, 0xd7a90000, 0x533c8000, 0xfcdb4000, 0x8d602000, 0xd7d05000, 0x86885800, 0x79cc1c00, 0x1ea37a00, 0x0bd42b00, 0x4a465780, 0x130a0bc0, 0x0fe87320, 0x8c1dc150, 0x2b2a3378, 0x5a992334, 0xaaa47782, 0x56ff5bc1, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0x28000000, 0xa4000000, 0x0e000000, 0x53000000, 0x07800000, 0x66c00000, 0xdde00000, 0xdbb00000, 0xd3180000, 0x32c40000, 0x80520000, 0x5a590000, 0x8de48000, 0xd803c000, 0x99f06000, 0xe7b8d000, 0xa6548800, 0xc31b7c00, 0xbf35f600, 0x41ebc700, 0x0b0c1180, 0x477efdc0, 0x52f72860, 0x027ac3b0, 0x51c5d248, 0xefd379c4, 0x7898f182, 0xee05edc1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x98000000, 0xf4000000, 0x06000000, 0x13000000, 0xc5800000, 0xccc00000, 0xa6600000, 0x0b300000, 0xa3480000, 0x53540000, 0x1c220000, 0x46090000, 0x0bf58000, 0x04734000, 0x28f12000, 0x6aa8b000, 0xd5a4a800, 0xd98a2c00, 0x9c2c1600, 0xefbfe300, 0x76bfd580, 0x223fcac0, 0x167f6d60, 0xd65ed710, 0x184f3668, 0x3b973024, 0xb65b7582, 0x4b143ac3, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x38000000, 0x14000000, 0xae000000, 0x0f000000, 0xc1800000, 0x98400000, 0xb7200000, 0x11500000, 0x1ed80000, 0x82e40000, 0x070e0000, 0x09190000, 0x72848000, 0x38fec000, 0x1ad02000, 0xcf98f000, 0xb744e800, 0x659e7c00, 0xa1a16e00, 0x8c912b00, 0xc7b8ac80, 0xaf945040, 0x5f07d1a0, 0x16642530, 0x2fcfb788, 0xb0f9f2bc, 0x09340c82, 0x8e166041, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x78000000, 0x2c000000, 0xf6000000, 0x6b000000, 0xb1800000, 0x53400000, 0x23a00000, 0x70900000, 0xda680000, 0x18340000, 0xc97e0000, 0x7ea90000, 0x3bd48000, 0x27ce4000, 0x41116000, 0xc9287000, 0x1b941800, 0x89ef8c00, 0xdcc12600, 0x0fe1bb00, 0x18b10a80, 0x54b8f140, 0x437d7220, 0x6f1b4a50, 0xeb5e9b28, 0x657825dc, 0xce1cea82, 0x896ac141, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xd8000000, 0x34000000, 0x92000000, 0x6f000000, 0xf0800000, 0x38c00000, 0x88600000, 0x16d00000, 0xb2880000, 0x4f7c0000, 0xd4a20000, 0x10c90000, 0xd4dc8000, 0xc093c000, 0xdf50a000, 0x2fc93000, 0xbc5da800, 0x2c528400, 0x15306e00, 0x8e190900, 0xca549580, 0xc9ee6ec0, 0x26f37ca0, 0x7880fc90, 0x94c1ea38, 0xce613ae4, 0x3bd0b582, 0xf5089ec1, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x08000000, 0xdc000000, 0xbe000000, 0xd5000000, 0xbc800000, 0x65400000, 0x11600000, 0x74b00000, 0x43f80000, 0x41e40000, 0xe11a0000, 0xb0390000, 0x22c58000, 0xc34ac000, 0x73b0e000, 0x3c799000, 0x01257800, 0x6fba9c00, 0xb1a8ba00, 0xda6d4100, 0xbba77680, 0xe85768c0, 0x81cf0060, 0x451bb570, 0x1a387d08, 0xf5c43154, 0xe4ca1682, 0x777038c3, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xa8000000, 0xac000000, 0xda000000, 0x9b000000, 0x5a800000, 0xe1400000, 0xf3e00000, 0x1fb00000, 0x89280000, 0xa8fc0000, 0x188a0000, 0xbce90000, 0x2f5d8000, 0xfb5b4000, 0x64b06000, 0x03a8d000, 0xf1bc1800, 0x5f6ad400, 0x7d596600, 0x4b746d00, 0x48273680, 0x5cfab1c0, 0xf7615a60, 0xd3f148d0, 0xc1492238, 0x278d0874, 0x7182d682, 0xb50521c3, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x88000000, 0x2c000000, 0x56000000, 0xd7000000, 0xfa800000, 0x04c00000, 0x20600000, 0xd9700000, 0xc7680000, 0x6c3c0000, 0xf41e0000, 0x2e290000, 0xd21c8000, 0xd9ce4000, 0x6850e000, 0x04399000, 0xfc841800, 0x5f5b4c00, 0x2193be00, 0x273e2d00, 0x18796580, 0x6d24cec0, 0xa9caf7e0, 0x14ca2f50, 0x774afcb8, 0x2a0ac0dc, 0xf62b0582, 0x2efa1ec1, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x98000000, 0xf4000000, 0x96000000, 0x29000000, 0xc3800000, 0x17c00000, 0x6c200000, 0x5a100000, 0xf9c80000, 0xda6c0000, 0xc0ae0000, 0x4c890000, 0x3e0d8000, 0xbb5f4000, 0x3870e000, 0xa338b000, 0x5114a800, 0x405acc00, 0x19e26200, 0x94b6ef00, 0x930cc380, 0xb6dfaa40, 0x52b1a320, 0x6a996410, 0xadc5d898, 0xe232437c, 0x185fa382, 0xe8f15a43, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xa8000000, 0x3c000000, 0xe6000000, 0xd5000000, 0x00800000, 0xa1400000, 0x61200000, 0x5ed00000, 0x4f780000, 0xaf5c0000, 0x1c620000, 0x87b90000, 0x49bd8000, 0x77d24000, 0xc7b16000, 0xfe08d000, 0xd6b43800, 0x4be7ac00, 0xb617fa00, 0xc0bef900, 0x0f1a4e80, 0x1ee5c840, 0x38de4ca0, 0x54ebd470, 0x5d4d98f8, 0xe7fa0b64, 0x7c54ae82, 0x8e565843, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x48000000, 0xe4000000, 0x4e000000, 0xd3000000, 0xcb800000, 0x10400000, 0xe0600000, 0xaf500000, 0x57780000, 0x87cc0000, 0x0f860000, 0xd3b90000, 0xe66d8000, 0x25f74000, 0x07716000, 0x44491000, 0x3de48800, 0x9632fc00, 0x45723600, 0xd692df00, 0x65837c80, 0x489bc6c0, 0xb507f9a0, 0x11787670, 0xd0cdab58, 0x1a0603ac, 0x68f99c82, 0x618c96c3, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x88000000, 0xdc000000, 0x5e000000, 0x71000000, 0x0e800000, 0x22c00000, 0xa2a00000, 0xce700000, 0x23480000, 0xd9ec0000, 0xe8fa0000, 0x30090000, 0x8e0c8000, 0xc46ac000, 0x5b50a000, 0x3d799000, 0x94c57800, 0x74c71c00, 0x6f4af200, 0xe4602500, 0xf6d0b980, 0xf638c740, 0xd72531e0, 0xba56ab10, 0xfb12f298, 0xa0959314, 0x563e9982, 0x07ce9741, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x28000000, 0x8c000000, 0xc2000000, 0x97000000, 0xee800000, 0x66400000, 0xaea00000, 0xd4700000, 0x8a280000, 0xf8e40000, 0x30260000, 0x0fe90000, 0x1d848000, 0x1436c000, 0xb850a000, 0x0a18d000, 0xd36dd800, 0x86322400, 0xb5a67e00, 0x9d294500, 0x56650880, 0x36671340, 0x714885e0, 0xe1f410d0, 0x121ef088, 0x82b5c2ac, 0xad3f2882, 0x32040341, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xa8000000, 0xcc000000, 0xc6000000, 0x85000000, 0x4a800000, 0xbec00000, 0x4de00000, 0x0ad00000, 0x86b80000, 0xad240000, 0x088e0000, 0x0df90000, 0x8f858000, 0xeafe4000, 0x0a302000, 0x7ae8d000, 0x4b5dd800, 0x994aac00, 0xe7275a00, 0x35058d00, 0x8c3f3180, 0x93d1f1c0, 0x423970a0, 0xeae4f8f0, 0xf1eef588, 0x58e8d2bc, 0x045c9182, 0xb0ca61c3, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x68000000, 0x0c000000, 0xc6000000, 0x03000000, 0x61800000, 0xe2c00000, 0xa6e00000, 0x54b00000, 0xf9480000, 0x5a340000, 0xfcfe0000, 0x5b090000, 0x76958000, 0xa8efc000, 0x2050e000, 0xccf95000, 0xebfdd800, 0x108a6c00, 0xe957d600, 0x508c5b00, 0xf1a20980, 0xda926bc0, 0x861bda60, 0xc14fbf10, 0xd6c0cda8, 0xd4e1aa9c, 0xe5b16982, 0xc9c9fbc3, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x88000000, 0xac000000, 0x56000000, 0xd9000000, 0xed800000, 0xe5400000, 0xaba00000, 0x68d00000, 0x98380000, 0x964c0000, 0x82220000, 0x6bf90000, 0xbe2c8000, 0x9a92c000, 0xaf702000, 0x86e99000, 0x27759800, 0xe1ef8c00, 0x289ba200, 0x84750300, 0xc36f2680, 0x995a0540, 0xb714baa0, 0x6d5ef2f0, 0x6e136fd8, 0x87b17be4, 0x38098682, 0xfc045541, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xf8000000, 0x7c000000, 0x6e000000, 0x0b000000, 0x24800000, 0xad400000, 0x03200000, 0x1a100000, 0x25580000, 0x61440000, 0xfc2e0000, 0x76790000, 0x53558000, 0x4d76c000, 0x8d3de000, 0x4e7a7000, 0x068f3800, 0x32a8bc00, 0x82eca600, 0x1b429100, 0xedfb9680, 0xd94f9840, 0x8bc81920, 0xa15c7a30, 0x7a4b4bc8, 0xf24637fc, 0x9d74ae82, 0x2ce72443, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xa8000000, 0xe4000000, 0xfe000000, 0x95000000, 0x27800000, 0x5ec00000, 0xc9200000, 0x9ef00000, 0xca480000, 0xfa840000, 0xd46e0000, 0x37690000, 0x52758000, 0x5f274000, 0x2c6c2000, 0x01dad000, 0x9cef8800, 0xd5285c00, 0xef14ba00, 0xadb7e700, 0x5d343180, 0xe9c7a040, 0xaa3d06e0, 0xeaa35f10, 0x14821248, 0x4af20fbc, 0xd6fbb982, 0x671ffc43, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x68000000, 0x24000000, 0xa2000000, 0x99000000, 0x94800000, 0xc5400000, 0xdaa00000, 0xb0300000, 0x7bc80000, 0xaf7c0000, 0xc2be0000, 0xcd690000, 0xc94c8000, 0x4a774000, 0x5b952000, 0x90325000, 0x25fe0800, 0xcec8e400, 0x4dfc2200, 0xe4fe0100, 0x46493e80, 0xc6bc9f40, 0x315e0560, 0x31f82b10, 0x51b4a0b8, 0xb7434e9c, 0xc5973682, 0x19047b41, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xb8000000, 0xf4000000, 0x5a000000, 0x2b000000, 0x15800000, 0x21400000, 0xb9200000, 0x60700000, 0x5d780000, 0xd6ac0000, 0x505e0000, 0xce590000, 0x45dd8000, 0x7ca74000, 0xebb56000, 0xcba2f000, 0x690fa800, 0xa3505400, 0xe609e600, 0x8654e300, 0x63b3e680, 0xc526bc40, 0x34f537e0, 0x2b82da70, 0x4bfe8218, 0xdce999dc, 0x2dc44e82, 0x6bdae843, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xc8000000, 0xac000000, 0x3e000000, 0xb1000000, 0xa8800000, 0x30400000, 0x87600000, 0x00100000, 0x1ef80000, 0x97f40000, 0x41760000, 0xaf990000, 0xaae48000, 0x390ec000, 0xe12c2000, 0xa0731000, 0x34c69800, 0x5d50dc00, 0x1718b200, 0x12a5e900, 0x726eac80, 0x4f3da4c0, 0xc78af520, 0xa7b28370, 0x1266b228, 0x8ee1634c, 0x10d03482, 0x65d978c1, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x68000000, 0x84000000, 0x82000000, 0x53000000, 0xd2800000, 0x25400000, 0x33200000, 0x98b00000, 0xe7f80000, 0x8a3c0000, 0xe73e0000, 0x2ad90000, 0x5f8d8000, 0x4f474000, 0xb2246000, 0xc5535000, 0xeecf4800, 0xd400e400, 0x3a00b600, 0xaf008d00, 0x0c80fe80, 0x18411840, 0xb4a09860, 0xbe702770, 0x70187138, 0xd66d109c, 0x8e17b682, 0xec8dfc43, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x58000000, 0x04000000, 0x2e000000, 0xe1000000, 0x26800000, 0x92400000, 0xbc200000, 0x9dd00000, 0x17180000, 0xaa8c0000, 0xc90a0000, 0xd2390000, 0xf5dc8000, 0x72534000, 0xcd946000, 0xdb863000, 0x0f324800, 0xe1e4bc00, 0x3a8eb200, 0xb3476500, 0x4b532880, 0xaf14c240, 0xc7c782a0, 0xe21304b0, 0x02b5fa58, 0xbbd6e434, 0x8beb6082, 0xfe897e41, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x38000000, 0xdc000000, 0x06000000, 0xdf000000, 0xcf800000, 0x82400000, 0xe9200000, 0x92d00000, 0xb0f80000, 0x747c0000, 0x81720000, 0xeed90000, 0x0d2d8000, 0x89cbc000, 0x7a84a000, 0x360ff000, 0x462b7800, 0x6eb52c00, 0x9a478e00, 0x3fdf4700, 0x13525880, 0x4988e440, 0xd694eea0, 0xec17c770, 0xc0e673b8, 0xd94ff8c4, 0x9d8b2082, 0x54a4c843, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x08000000, 0xb4000000, 0xf2000000, 0x31000000, 0xe7800000, 0x18c00000, 0x84a00000, 0x9ff00000, 0x9ef80000, 0xd1340000, 0x56360000, 0xff590000, 0xcb448000, 0x090fc000, 0x294ca000, 0xe0429000, 0x690fa800, 0xb94dc400, 0x08433200, 0x0d0fc700, 0x434de580, 0x8d435340, 0x188f1ce0, 0x6a8cba70, 0xee633e28, 0x9fbf810c, 0x70d44d82, 0xa0a79741, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xf8000000, 0xcc000000, 0x46000000, 0xeb000000, 0xc0800000, 0xffc00000, 0xdd600000, 0x7dd00000, 0xa9e80000, 0x4c340000, 0xacce0000, 0x63890000, 0x8f658000, 0x3de7c000, 0xc45c6000, 0xb2ba7000, 0x26675800, 0xc31d6c00, 0xbc1a6600, 0x70d7b900, 0x04256380, 0x554644c0, 0x29edcea0, 0xfd02e650, 0x04fbdda8, 0xcd4728bc, 0x95ec3b82, 0xa30228c3, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xa8000000, 0x0c000000, 0x16000000, 0x77000000, 0x28800000, 0xb8400000, 0x88a00000, 0x94900000, 0x7eb80000, 0x11840000, 0x7b2e0000, 0xd5190000, 0xbf958000, 0x00d6c000, 0x1dbc6000, 0x13ead000, 0xa917d800, 0x76ddcc00, 0x551afe00, 0x0adee900, 0xfe51ec80, 0x5f59f740, 0x9a34ec20, 0xbdc77ff0, 0x34c5c548, 0xb20f4afc, 0x7a483482, 0xd74d3b43, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x48000000, 0x0c000000, 0xa6000000, 0xd9000000, 0xc1800000, 0x3e400000, 0x82e00000, 0x74500000, 0x80380000, 0xf01c0000, 0xbfc20000, 0x55d90000, 0xa0cc8000, 0x5e3b4000, 0x5464a000, 0xca3e1000, 0xb2ca5800, 0xb8ed6c00, 0x894ae200, 0xf1ac7b00, 0xbf2a8080, 0x0c3c7fc0, 0x12b31fa0, 0xc71152f0, 0xc159ecf8, 0xb90cf4a4, 0x9b9ad882, 0xb35413c1, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x28000000, 0x94000000, 0x56000000, 0xb7000000, 0xbf800000, 0x73c00000, 0x75200000, 0x48d00000, 0x2e480000, 0x0efc0000, 0x852e0000, 0xc2690000, 0x52ad8000, 0xd526c000, 0x13752000, 0x5ef3d000, 0x7f96e800, 0x868c0c00, 0x35767e00, 0x817db700, 0x6eefbb80, 0x7b493c40, 0xe07dcaa0, 0xa66fe910, 0xd708eeb8, 0xf69d7f7c, 0xb39f5382, 0x25903043, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x38000000, 0xac000000, 0xfe000000, 0xf3000000, 0x28800000, 0xff400000, 0x14a00000, 0x2f100000, 0x93380000, 0xca940000, 0xac420000, 0xa6990000, 0x80048000, 0x7bbac000, 0xff6da000, 0xd0b6f000, 0xd9aa9800, 0xf7d4dc00, 0xade3d600, 0xce086900, 0x52fc5280, 0x3dce2740, 0x121f0b20, 0x384732f0, 0xcf221368, 0x1268b524, 0x208cca82, 0xc907fb41, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x18000000, 0xf4000000, 0x82000000, 0x35000000, 0xd4800000, 0x16400000, 0x00a00000, 0x5bb00000, 0x2b980000, 0x95ac0000, 0x46020000, 0x08390000, 0x1d9c8000, 0x725b4000, 0xe3f5a000, 0x78ceb000, 0x49eba800, 0x786c2400, 0x05639a00, 0xb3e8a100, 0x1e553880, 0x5bfef340, 0xa2325260, 0x0a60a5b0, 0xe150c118, 0xa6895ae4, 0x02849082, 0x01b7d741, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x58000000, 0x8c000000, 0xf6000000, 0x15000000, 0x29800000, 0xac400000, 0x53600000, 0x4b300000, 0xba380000, 0xf5440000, 0xd20a0000, 0xbe590000, 0xe8f58000, 0xb6f3c000, 0xd4bca000, 0x096f3000, 0x9f83d800, 0xb4e4cc00, 0xd09ada00, 0x12f02b00, 0x2b182480, 0x9414e4c0, 0x2c839160, 0x10645af0, 0x395bad48, 0xcbd115f4, 0x7e49fc82, 0xc09d28c3, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x48000000, 0xc4000000, 0x52000000, 0x65000000, 0x91800000, 0x54c00000, 0x85600000, 0x29100000, 0x8b280000, 0x11c40000, 0xa5160000, 0x05490000, 0x22548000, 0x207f4000, 0x3faca000, 0x55721000, 0x342fc800, 0xd9248400, 0x46c79a00, 0x58014b00, 0x6c01bd80, 0xe60198c0, 0xaf01fd20, 0x788141d0, 0x53414848, 0xe6a0368c, 0x58f07582, 0x67781cc1, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x88000000, 0xf4000000, 0x16000000, 0xd5000000, 0x0d800000, 0xc9400000, 0xd3600000, 0x42100000, 0xbbd80000, 0xba940000, 0x93860000, 0x45390000, 0xa1c58000, 0x233ec000, 0xf1bd6000, 0xe39a9000, 0xeb922800, 0x0d7ecc00, 0x945cfa00, 0xac4ad300, 0x95eb0e80, 0xa4da14c0, 0x01f20b20, 0x78eeab30, 0x69c47ee8, 0x773e58ac, 0xb7bca682, 0x8e9a18c3, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x18000000, 0xcc000000, 0x0a000000, 0x3f000000, 0x3c800000, 0x00c00000, 0x1ea00000, 0xa4700000, 0x74c80000, 0xfbe40000, 0xd1660000, 0xeee90000, 0x23558000, 0x890e4000, 0x327de000, 0xa87bb000, 0x6fc2d800, 0xe86e7400, 0x542c8e00, 0x2802c100, 0x964f8580, 0xb29d8b40, 0xd96b4de0, 0x2b5aba10, 0xeef38988, 0xdb4784ac, 0x7e58dd82, 0xdf3dbf43, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xb8000000, 0xcc000000, 0x9e000000, 0x13000000, 0x50800000, 0x1ac00000, 0x4c200000, 0xda100000, 0x69e80000, 0x3f0c0000, 0x12f60000, 0x29490000, 0x19dd8000, 0xc83e4000, 0x12d52000, 0xd302f000, 0x0edad800, 0x472f9c00, 0x04bd9600, 0xb04ed900, 0x3dcd1980, 0x42d7f640, 0xf5598120, 0xbf35c450, 0x81b26d58, 0xc5e39b4c, 0x78ea4182, 0xc4d62a43, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x88000000, 0x2c000000, 0xca000000, 0x65000000, 0xba800000, 0x0fc00000, 0xcd200000, 0x11d00000, 0x29a80000, 0x02940000, 0x6d920000, 0x7a090000, 0x3a858000, 0x061a4000, 0xa6cd2000, 0x43fe9000, 0x90671800, 0xe72b3400, 0x62951a00, 0x9d92cd00, 0xc209fb80, 0x8e85b840, 0x681bcaa0, 0x25cc6ad0, 0x567f2468, 0x40264004, 0x9f4b6382, 0xb1a4cc43, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x08000000, 0xcc000000, 0xa6000000, 0x89000000, 0x16800000, 0xfec00000, 0x66a00000, 0x36300000, 0xbd380000, 0xa32c0000, 0x4d020000, 0xf9190000, 0x19dc8000, 0x5d9a4000, 0xc985a000, 0x26a69000, 0xcc4ed800, 0x838a6c00, 0x184cc200, 0x4413d500, 0x63514180, 0xd1287740, 0xd9e4c560, 0xfa37e1f0, 0xc146e818, 0x449e2ce4, 0xe8e31982, 0xc2c85b41, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x88000000, 0x5c000000, 0x32000000, 0xb5000000, 0xd6800000, 0x7bc00000, 0x27a00000, 0xc9300000, 0xba580000, 0xd9e40000, 0x4de20000, 0xd9790000, 0x4e158000, 0xae9a4000, 0xbe6da000, 0x240e9000, 0x8e37f800, 0xe3424400, 0x44c8ba00, 0xc28c7500, 0x025f6380, 0xa77f2d40, 0xbb8f7360, 0x8176f530, 0xa2233f88, 0x70d84924, 0x70251b82, 0xaf432943, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x18000000, 0x3c000000, 0xf6000000, 0xbf000000, 0xb8800000, 0x2c400000, 0xd4200000, 0x84100000, 0x79880000, 0x51440000, 0xaa9e0000, 0x5f290000, 0x70158000, 0xe0b7c000, 0x2ebd6000, 0x4363b000, 0x82eab800, 0xffaf0c00, 0x6b300e00, 0x9f192900, 0x858c2480, 0x3c7afe40, 0x3766dd20, 0xdbd4c190, 0x6056a9c8, 0xb2ccaa9c, 0x5adb1c82, 0x36363243, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xa8000000, 0x9c000000, 0x66000000, 0x8b000000, 0x87800000, 0x97400000, 0x7de00000, 0xdb900000, 0x69280000, 0x3b140000, 0x351e0000, 0x99490000, 0xd2c58000, 0x21564000, 0x170c6000, 0xdb52d000, 0x58fa7800, 0x382f2c00, 0x40108600, 0x58689700, 0xedf59280, 0xd90ee5c0, 0xcf211c20, 0x08309ed0, 0xa9d818e8, 0x6c6d8a9c, 0xb5026a82, 0xdbf389c3, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x68000000, 0x4c000000, 0x5e000000, 0xa5000000, 0x7c800000, 0x65400000, 0x1fe00000, 0x50f00000, 0x8d080000, 0xe0ec0000, 0x2ba60000, 0x9b690000, 0x81dc8000, 0x700fc000, 0x3a95a000, 0xba825000, 0xb6025800, 0x4b439c00, 0xc0a3da00, 0xba528100, 0xe85a4680, 0xc337ddc0, 0x0a504ce0, 0x32198e90, 0xe515d918, 0x3243db2c, 0x2a229e82, 0x861281c1, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0x44000000, 0xc6000000, 0x01000000, 0xc4800000, 0x07c00000, 0x4da00000, 0x31d00000, 0xbf080000, 0xfa0c0000, 0xfa560000, 0xaf290000, 0x449c8000, 0x9d3ec000, 0xb655e000, 0x9992d000, 0x36534800, 0x7ff2ec00, 0xe8231200, 0x262aa100, 0x30a67380, 0x8931e140, 0xadb81ea0, 0xd9f40790, 0x3f435058, 0x74da478c, 0x5abfbb82, 0xf214cd41, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x58000000, 0x54000000, 0x82000000, 0x51000000, 0x49800000, 0x6ec00000, 0x60e00000, 0xe5700000, 0xdba80000, 0xb7940000, 0x1a160000, 0x07c90000, 0xbfa58000, 0x329f4000, 0x7a4ca000, 0x7eab3000, 0x750ae800, 0x285a2400, 0xd563d200, 0xccae5b00, 0x91c50980, 0xe3af1bc0, 0x1745a5e0, 0xbbeef4d0, 0x07e4c3e8, 0x923e9e4c, 0x7b9c6182, 0xded37fc3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xb8000000, 0x84000000, 0xc6000000, 0xb1000000, 0x50800000, 0x90400000, 0xd8200000, 0x26900000, 0x6c480000, 0xb82c0000, 0x89520000, 0x9be90000, 0xe37d8000, 0xf7fbc000, 0x16352000, 0xe356f000, 0xad27c800, 0xc79f2c00, 0x314b5200, 0x18ecc900, 0x1133bc80, 0x3d584a40, 0x3da4b820, 0x5d9eae10, 0x124aa718, 0x676dc004, 0xf4f3f482, 0x5bb9a643, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x78000000, 0x3c000000, 0x6a000000, 0xc1000000, 0x30800000, 0x3fc00000, 0x98e00000, 0x22100000, 0xa1080000, 0x0da40000, 0xbf9a0000, 0x6e690000, 0xb3f48000, 0xd4334000, 0xcc7de000, 0x91567000, 0xa0863800, 0x1b6fb400, 0x61dbb200, 0x11c83900, 0xa2c57b80, 0x91cb9bc0, 0xadc19920, 0x25e06390, 0xd8912588, 0x2fc89394, 0xddc5c382, 0x9e4a6fc1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x38000000, 0xe4000000, 0x5e000000, 0x79000000, 0xbf800000, 0xd0c00000, 0xd5a00000, 0x93b00000, 0x93d80000, 0xbe0c0000, 0x36b20000, 0xeeb90000, 0x7c1d8000, 0xd8db4000, 0x926d2000, 0x9723f000, 0x6a118800, 0xf2691c00, 0x66d5c200, 0xdc3e9700, 0x4c4a6d80, 0xeb441140, 0xaa962460, 0x893e1430, 0x01cb7858, 0x70849384, 0x2bb6c582, 0x8ecefd43, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x98000000, 0x84000000, 0x7e000000, 0x63000000, 0xc1800000, 0x17c00000, 0x61e00000, 0x3f100000, 0xc7280000, 0x3ed40000, 0x3c0a0000, 0xc9090000, 0x94258000, 0x4232c000, 0x67f46000, 0xb17ab000, 0x47f0c800, 0xe4b81c00, 0x2cbd3600, 0x057feb00, 0x2432e380, 0x40f58dc0, 0x6efa4120, 0x8331c7d0, 0xdcd8ed68, 0x806cd1b4, 0xddb64b82, 0x46f721c3, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0xc8000000, 0x84000000, 0x92000000, 0x87000000, 0xa7800000, 0xc4400000, 0x74e00000, 0x78700000, 0xb6b80000, 0xa4140000, 0x3c4e0000, 0xca190000, 0xfe848000, 0xc7864000, 0x0834e000, 0xcd1f1000, 0x05704800, 0xa2384400, 0xbdd4de00, 0x7fefa700, 0x3b083c80, 0xf70c6fc0, 0x944adbe0, 0xab5f0bf0, 0x5e90fee8, 0x29c8c8fc, 0x652c9482, 0x641b3bc1, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xd8000000, 0xb4000000, 0x8e000000, 0xd7000000, 0xf4800000, 0x27400000, 0x94a00000, 0xa1100000, 0xd7a80000, 0x9fac0000, 0x17a20000, 0x68490000, 0x401c8000, 0x701b4000, 0x5fcd6000, 0xf9d33000, 0x51112800, 0xefa9fc00, 0xbbad5e00, 0x71a2e100, 0xd349e280, 0x8e9d6f40, 0x0e5af720, 0xe8ed2fd0, 0x8b02cf18, 0x35580be4, 0x45b5aa82, 0xdab7a341, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xa8000000, 0x0c000000, 0xc2000000, 0xe1000000, 0x32800000, 0x27c00000, 0x24a00000, 0xae500000, 0xf8980000, 0xe7b40000, 0x09720000, 0x4ff90000, 0x3b448000, 0x38bbc000, 0x3d55e000, 0x4bc3d000, 0xa2d0d800, 0x1459e400, 0xfc955200, 0x00629d00, 0xfd019b80, 0x68811340, 0x82c17da0, 0xa8209cb0, 0x0290b328, 0x03b919c4, 0x9ea4a382, 0x138b2741, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xb8000000, 0xa4000000, 0xa6000000, 0x3f000000, 0xb4800000, 0x30c00000, 0xd5600000, 0x82100000, 0xa7980000, 0x62dc0000, 0x01660000, 0xa4390000, 0xeaad8000, 0xe06e4000, 0xb9bda000, 0x4076f000, 0xc5200800, 0xc9b06c00, 0xa3e94e00, 0x19d48100, 0x71e25d80, 0x9b639cc0, 0xd0a3a120, 0x674390b0, 0x02926678, 0xd8ea776c, 0x0ae7f582, 0xe07900c3, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0xa8000000, 0xcc000000, 0x76000000, 0x43000000, 0x57800000, 0x5ac00000, 0x67200000, 0xb9b00000, 0x67c80000, 0x8a140000, 0x5c3a0000, 0x40290000, 0x51848000, 0x4ec2c000, 0xd4b52000, 0xa84bd000, 0x75405800, 0x79e04c00, 0x14911600, 0x53791700, 0x9d5d0980, 0x616fd040, 0x14f23060, 0xdbbd7c10, 0xcc7f3568, 0x4a4a9e94, 0x74407182, 0x1f604c41, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x98000000, 0x0c000000, 0x1e000000, 0x15000000, 0xd6800000, 0xa8c00000, 0xc6a00000, 0xa3700000, 0x50780000, 0x18040000, 0x37c60000, 0x24190000, 0x22d58000, 0xf54fc000, 0x09252000, 0x38f6b000, 0xf100d800, 0x8c819c00, 0xd7c0da00, 0x07219500, 0x4e305d80, 0xf199bf40, 0x1d94d7e0, 0xbfafdb70, 0xdf351048, 0x56dff8ec, 0x684da582, 0x835a9343, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xa8000000, 0x74000000, 0x22000000, 0x73000000, 0xac800000, 0x63400000, 0x41600000, 0x6a300000, 0xdc180000, 0xae940000, 0x179e0000, 0x05390000, 0xad458000, 0x78f6c000, 0xc9d5a000, 0x2cfed000, 0xf0092800, 0x73dd6400, 0x38237600, 0x16aa1100, 0xdd375280, 0x7cf4ccc0, 0x412e2960, 0x7261a8b0, 0x66b01ee8, 0x8f5901dc, 0x17f5da82, 0xa1ae78c3, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x98000000, 0xfc000000, 0xc6000000, 0xaf000000, 0x2d800000, 0x6c400000, 0x13200000, 0xea500000, 0x10280000, 0xd58c0000, 0x39fe0000, 0x6c490000, 0x6f7c8000, 0xc4c74000, 0xdd4de000, 0xf41fb000, 0xecf9b800, 0x6665ec00, 0xa6132e00, 0x98464300, 0x8f8de480, 0xc0ff4040, 0xa6c8a3a0, 0x3abcf6d0, 0x19a65e58, 0xb13cebdc, 0x4ae7bc82, 0xc79c1c41, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xc8000000, 0x5c000000, 0x6a000000, 0x95000000, 0x20800000, 0x89c00000, 0x99e00000, 0x16d00000, 0xcf680000, 0xec840000, 0x7f7e0000, 0xa0490000, 0x16358000, 0xef87c000, 0xa3856000, 0xc2fe1000, 0xb5087800, 0x5c153400, 0x3db77a00, 0x06bd9900, 0x02d3d780, 0x2a1261c0, 0xb57258a0, 0xcd637750, 0x8a6b33c8, 0x277fa4dc, 0x2448cf82, 0x383445c3, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x28000000, 0xb4000000, 0x16000000, 0x97000000, 0xa1800000, 0x07c00000, 0xdaa00000, 0x19900000, 0xd3080000, 0xa41c0000, 0x751e0000, 0x1f690000, 0x59ad8000, 0x9dc7c000, 0x5b1ca000, 0x409fd000, 0x3ea9a800, 0xec0c0c00, 0xb9d6be00, 0x2dd48b00, 0xbf23f380, 0x64a73340, 0x862c7c20, 0x99069790, 0x063db678, 0x31ce8a9c, 0x0a80fb82, 0xf441ef43, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x28000000, 0x54000000, 0x3a000000, 0x75000000, 0xa0800000, 0x55400000, 0xe2600000, 0xe2300000, 0x87880000, 0xbf7c0000, 0x436a0000, 0xc7a90000, 0x06ad8000, 0x4513c000, 0x4b7d6000, 0x696bd000, 0x4aa86800, 0xea2d9400, 0x56537a00, 0xb21c8900, 0x64db0e80, 0x4de146c0, 0x42f11160, 0x4028df90, 0xf26d3338, 0xb8b3cc34, 0x736c0682, 0x323202c3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x38000000, 0x0c000000, 0x0a000000, 0xdd000000, 0xcb800000, 0xa7c00000, 0xdc600000, 0xe5500000, 0x49880000, 0x7fbc0000, 0xb7820000, 0xa1290000, 0x4e0d8000, 0x7c1bc000, 0xf83d6000, 0x3a43f000, 0x7048d800, 0x68ddf400, 0xa6520a00, 0x5de0ef00, 0xbf90ab80, 0x8e69dac0, 0x352c29a0, 0x166a1690, 0x3dc5c8b8, 0x67067e24, 0xb40f1382, 0x6df2dec3, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x58000000, 0xdc000000, 0x6a000000, 0xb9000000, 0x7b800000, 0x08c00000, 0xe3e00000, 0x20100000, 0x2b180000, 0xb8cc0000, 0x9cca0000, 0xd7b90000, 0x61fc8000, 0x0122c000, 0x5dfde000, 0x5b223000, 0xdcfc7800, 0x8ca2b400, 0xe63c0200, 0x0a432f00, 0xd7adb580, 0x909b6dc0, 0xf7011320, 0x2480edb0, 0xe840e558, 0xdda14234, 0x5eb0ad82, 0xef2929c1, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xe8000000, 0xcc000000, 0x92000000, 0xbf000000, 0x5c800000, 0xf0400000, 0x6e200000, 0x7e300000, 0xb0980000, 0x0fec0000, 0x79c60000, 0xb6790000, 0x21bd8000, 0x7c4ec000, 0x08bda000, 0x31ce5000, 0x517c5800, 0x382e0400, 0x5bad6e00, 0x89e60100, 0x8548d480, 0x22a51a40, 0x37627160, 0x231bc7b0, 0x05a60e98, 0x0169496c, 0xa794ac82, 0xd57b8e43, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x38000000, 0xdc000000, 0x76000000, 0x05000000, 0xd0800000, 0xcf400000, 0x38a00000, 0x92300000, 0x12580000, 0xcf8c0000, 0x063a0000, 0xf3390000, 0x875d8000, 0x6a73c000, 0x099ca000, 0x2f13f000, 0xcb4d7800, 0x005acc00, 0x0c68ba00, 0x53d43900, 0xf0b6c280, 0x83836340, 0x86249960, 0xd90e4830, 0x489fc358, 0x0977ec94, 0x69629a82, 0x10359f43, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x58000000, 0xa4000000, 0x96000000, 0x55000000, 0x20800000, 0x25400000, 0xc5e00000, 0x21100000, 0x54980000, 0xb35c0000, 0x378a0000, 0xe6b90000, 0x91ed8000, 0x2263c000, 0x4dad6000, 0x5d033000, 0x96fd8800, 0xbbfacc00, 0x9a70da00, 0xe9c8e900, 0xb8a41680, 0x8f8609c0, 0x5fca9f20, 0x87d981b0, 0xd3bdc078, 0x8e1b6db4, 0x03617e82, 0x295035c3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x68000000, 0xe4000000, 0x4a000000, 0xf3000000, 0x2d800000, 0x99400000, 0x53200000, 0x0ab00000, 0x32f80000, 0xd6a40000, 0x12920000, 0x2e190000, 0x8ff58000, 0x22bbc000, 0x14d42000, 0x7c0b5000, 0x742d0800, 0x45ae3400, 0x8d3ff600, 0xaff63300, 0xc56a3680, 0xc03ce840, 0x04a76a60, 0xaa424970, 0x09717c08, 0x2f1928c4, 0xfd749e82, 0x487b4c43, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x28000000, 0xac000000, 0xc2000000, 0x35000000, 0xee800000, 0xc6400000, 0x7ce00000, 0xe3f00000, 0x4fd80000, 0x732c0000, 0x96be0000, 0xd6f90000, 0x10fc8000, 0xd636c000, 0x761de000, 0xc4c6d000, 0xd9449800, 0xf6abe400, 0xc09bfa00, 0x4763e500, 0xe71f1880, 0x48686bc0, 0x45156ee0, 0xa0e25130, 0x15deae98, 0x23c8001c, 0x2a84e082, 0x158a9fc1, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0x08000000, 0x24000000, 0xc6000000, 0xfd000000, 0x9e800000, 0xcc400000, 0xc2e00000, 0x82100000, 0x4f080000, 0xe44c0000, 0x7cfa0000, 0xc6290000, 0x907c8000, 0xb243c000, 0xab1d2000, 0x25929000, 0x83348800, 0xdcef2c00, 0x91f72a00, 0x7ab2d500, 0x02044480, 0xa8d757c0, 0xf6834520, 0xf0bd0490, 0x2fe3e458, 0x5c6cbb54, 0x644b6c82, 0xf7d02bc1, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x28000000, 0xa4000000, 0x72000000, 0x79000000, 0xc1800000, 0x6e400000, 0x58a00000, 0x5e700000, 0xdc280000, 0x83640000, 0x67e20000, 0x16490000, 0x88758000, 0xe25ac000, 0x3a552000, 0xdaebd000, 0x491c8800, 0xad1f4400, 0x0a076200, 0x156a6b00, 0x705c2880, 0xd33e6b40, 0x44b66be0, 0x1d222ed0, 0x87298888, 0xb3e491a4, 0x1c220082, 0x6aa93f43, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xe8000000, 0xe4000000, 0x7e000000, 0xb7000000, 0xa3800000, 0x76400000, 0xf2e00000, 0x0d500000, 0x7c280000, 0xfe840000, 0x15660000, 0x58090000, 0x02f48000, 0x93be4000, 0x2894a000, 0xb12f5000, 0xe91c8800, 0x9c9bdc00, 0x54c3fe00, 0x589eaf00, 0x8b640080, 0xe3b623c0, 0xae6091a0, 0xac9042d0, 0x4e89fbc8, 0x823526ec, 0x519ea882, 0xffe5efc1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xc8000000, 0x3c000000, 0x96000000, 0xb9000000, 0xa7800000, 0xdc400000, 0x82200000, 0xd0b00000, 0x8bb80000, 0x6a9c0000, 0xa5020000, 0xbf590000, 0x29cd8000, 0x6f6bc000, 0x826c2000, 0x0e9a1000, 0xf674b800, 0x1ff78c00, 0xb06e2200, 0xcb429700, 0xc6784480, 0x3dfd6e40, 0xe812b260, 0x5c1015f0, 0x28c9da78, 0x6344b5e4, 0x9b0f5c82, 0x30523243, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xb8000000, 0x0c000000, 0x72000000, 0x75000000, 0xff800000, 0xe7c00000, 0x60600000, 0xc9d00000, 0x1da80000, 0xf1fc0000, 0x5d760000, 0x4a890000, 0x210d8000, 0x3f2ec000, 0x87aca000, 0x071ef000, 0x6b15d800, 0xddaac400, 0xdc0e5a00, 0x295cc700, 0x62471b80, 0x2cb052c0, 0xe3f9d8a0, 0x0f94b6d0, 0xdaeb8038, 0x6d2e98cc, 0x82ade382, 0xf09fa6c3, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xd8000000, 0x4c000000, 0x6e000000, 0xcf000000, 0xa5800000, 0xb0400000, 0xf3200000, 0x31d00000, 0xdea80000, 0xa3f40000, 0x81920000, 0xd1490000, 0x1fc48000, 0x120ac000, 0x43a5e000, 0xfd7b3000, 0x989d5800, 0xf906bc00, 0xbe2bee00, 0x3ff4b300, 0x67924c80, 0x9a49c040, 0x304424a0, 0x974aabd0, 0xf8044ea8, 0x786a7204, 0x6fd47482, 0x8dc38c41, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0xe8000000, 0x1c000000, 0xb6000000, 0x5d000000, 0xe5800000, 0x17400000, 0xbba00000, 0x78700000, 0xc8780000, 0xfdfc0000, 0x4cbe0000, 0xde190000, 0xdbed8000, 0x6ed64000, 0x7f8d2000, 0x67c65000, 0xb7657800, 0x2b92cc00, 0xb52e2a00, 0x28315300, 0x45595280, 0xfe4d9540, 0x77a7a7e0, 0xf475ec70, 0x387b93b8, 0xb9fad11c, 0x2cba8a82, 0x401a4943, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xf8000000, 0x2c000000, 0xc2000000, 0xb3000000, 0xfc800000, 0xc9c00000, 0x6da00000, 0xfa300000, 0x88c80000, 0x8a4c0000, 0x211e0000, 0x45290000, 0x3d9c8000, 0x5e074000, 0x107da000, 0x19d77000, 0xc7641800, 0x9883a400, 0x0d2ed600, 0x70e08100, 0xca502780, 0x51580540, 0xd9b4d960, 0x941a4c10, 0xf73aead8, 0x3fcb47dc, 0x02231f82, 0xfd9e9141, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0x64000000, 0x22000000, 0x83000000, 0x0b800000, 0x17c00000, 0x26e00000, 0x59500000, 0x3f680000, 0xcc8c0000, 0xb9760000, 0xb6390000, 0xebe48000, 0x71fac000, 0x7d4fa000, 0x86dd3000, 0xf59e8800, 0x39752400, 0x5e739600, 0x2193af00, 0xe4438380, 0x8d6affc0, 0x9fc68ba0, 0x4c815250, 0x4e406558, 0xda21c68c, 0x18301582, 0x6ff950c1, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0x68000000, 0x6c000000, 0x42000000, 0x7f000000, 0xf0800000, 0x1d400000, 0x8ce00000, 0x65300000, 0xcae80000, 0x84ec0000, 0x33ae0000, 0x43d90000, 0x4c048000, 0xa842c000, 0x30f66000, 0x7a9d5000, 0x04a69800, 0xbf842400, 0xff83ce00, 0x0a562900, 0x95cc8680, 0x8f3ff3c0, 0xdce1ad60, 0xfd31fa50, 0xaee81c98, 0x1aed69fc, 0x66af4882, 0xa059dac1, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x98000000, 0x6c000000, 0xb2000000, 0x65000000, 0x0d800000, 0x3ac00000, 0xc5600000, 0x6a500000, 0x8a280000, 0xfa940000, 0x7ede0000, 0x32790000, 0x25bd8000, 0xe1ca4000, 0x5266a000, 0x94a5b000, 0x15271800, 0xe3058400, 0x6e17da00, 0x0d7cb300, 0x51abe980, 0x8db654c0, 0x984dfda0, 0x00d2eed0, 0xfe8af868, 0x69c6ccdc, 0x8d943382, 0x065ee7c3, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x08000000, 0x3c000000, 0x06000000, 0x75000000, 0x9e800000, 0x76c00000, 0xd3600000, 0x97700000, 0xac780000, 0x1a9c0000, 0x17320000, 0xe6090000, 0x24658000, 0x556e4000, 0x9b5ae000, 0xc59c9000, 0xe2b3b800, 0x9f48ac00, 0xdd449a00, 0x20bf1500, 0xa2b27980, 0x7f49d0c0, 0x0d4541e0, 0xd8bf2470, 0x96b36478, 0x45497344, 0x7e44e382, 0x333fc5c3, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0x3c000000, 0x26000000, 0x25000000, 0x76800000, 0x74c00000, 0xa5200000, 0x1c500000, 0x43c80000, 0xd0040000, 0xf6160000, 0x82990000, 0xf14c8000, 0x28d2c000, 0xc2af2000, 0x54055000, 0xa4163800, 0xcd99ac00, 0xfccc3a00, 0x5b928500, 0x7fcffd80, 0x9ab41c40, 0x0d2ea7a0, 0x40452f10, 0x48f639c8, 0x46691bcc, 0xa595c782, 0x527f9941, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xe8000000, 0xdc000000, 0x3e000000, 0xc7000000, 0x2a800000, 0x47400000, 0x78e00000, 0x16f00000, 0x7b280000, 0x025c0000, 0xa0d60000, 0x26d90000, 0x55f48000, 0x86cac000, 0x2e6ee000, 0xef9c5000, 0xdf77f800, 0x28c85c00, 0xc82d3e00, 0x17befd00, 0x50e5aa80, 0x579253c0, 0x6b5b8ee0, 0xd17631d0, 0x27c965f8, 0xaeadd08c, 0x76fe9482, 0xdb05aec1, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x38000000, 0x34000000, 0x3e000000, 0x23000000, 0x3a800000, 0x87c00000, 0x93600000, 0xd7100000, 0x5ef80000, 0xaf640000, 0xec2a0000, 0x16e90000, 0xd91d8000, 0xfd8fc000, 0x8622e000, 0x8aa4f000, 0x5e4a2800, 0x0a795c00, 0xe3a45600, 0x59cbad00, 0x8439fb80, 0x0584ecc0, 0x967a3520, 0x94b15b70, 0x3e08c188, 0x924c8db4, 0x7c57ad82, 0x097641c3, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x18000000, 0xac000000, 0x02000000, 0x3f000000, 0xb0800000, 0x62c00000, 0xdde00000, 0xda500000, 0xa1b80000, 0xce240000, 0xc5fe0000, 0xa6e90000, 0x501c8000, 0xa19ac000, 0x8036e000, 0xeb45b000, 0x196f1800, 0xfcb02400, 0x3d692e00, 0xfc5cc900, 0xabba7980, 0x4c06f1c0, 0xf4ec73a0, 0x58d2a3f0, 0x7d5abc08, 0xc8d6b59c, 0x6a955782, 0x349738c1, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x88000000, 0x64000000, 0x72000000, 0xcd000000, 0xcd800000, 0x14c00000, 0xeaa00000, 0x82d00000, 0xaef80000, 0xbd4c0000, 0x445e0000, 0x3b290000, 0x27358000, 0x4a52c000, 0x5016e000, 0x27ed9000, 0x8e8f8800, 0x91d0c400, 0x1878ea00, 0x4b0c8300, 0xc2bfe580, 0x6618bb40, 0xe37c4ca0, 0x8e96cb70, 0x85adfc58, 0x926f535c, 0x95e10f82, 0xebb13843, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x78000000, 0x24000000, 0xe6000000, 0x63000000, 0x2a800000, 0xddc00000, 0x7b600000, 0xfaf00000, 0xdd280000, 0x3a6c0000, 0xa8020000, 0xcad90000, 0x02c48000, 0xff2e4000, 0xd57a6000, 0x9e0d7000, 0x6a728800, 0xa731ec00, 0xe649d600, 0xe09cad00, 0xc52b5f80, 0x88b40cc0, 0x8ec7aee0, 0xd3f6d8d0, 0xb4bf1f98, 0x4ba33624, 0x62c88982, 0x425da1c1, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xc8000000, 0x9c000000, 0xfe000000, 0x25000000, 0xa4800000, 0x44400000, 0xbf600000, 0xc8b00000, 0xde580000, 0xf2340000, 0xcf9e0000, 0x42690000, 0x402d8000, 0x8eca4000, 0xc3466000, 0xad1d1000, 0xfa52f800, 0x1d53dc00, 0x12d23a00, 0x3f132100, 0x4cb3ec80, 0x4922f8c0, 0x59ab9a60, 0xe7f68930, 0x6544ac28, 0x0167879c, 0x404c5682, 0xadfb99c3, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x78000000, 0x0c000000, 0x06000000, 0x65000000, 0xd7800000, 0xa1400000, 0x3da00000, 0x2d300000, 0xfc980000, 0x163c0000, 0x743e0000, 0x2e290000, 0x7fe48000, 0xf5a34000, 0xc426a000, 0x67d57000, 0xe6bbd800, 0xdf5bec00, 0xf84a1a00, 0xf8a38700, 0x87a63680, 0xbc952d40, 0x101bb760, 0x34ea10b0, 0x78131bb8, 0x117f885c, 0x5188ac82, 0x35d5ea41, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xf8000000, 0x8c000000, 0x4a000000, 0x83000000, 0x81800000, 0xd4400000, 0x28a00000, 0xd4b00000, 0x71580000, 0x337c0000, 0xf14a0000, 0x48690000, 0x4c658000, 0xf196c000, 0x3013a000, 0x13157000, 0xa92e5800, 0x2ffff400, 0x4d76d600, 0x6c03ab00, 0x86fcc480, 0x430bd340, 0x99c82460, 0x32551530, 0xa10e2538, 0x398e33b4, 0xd74f9282, 0x462eb843, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x48000000, 0x0c000000, 0x3e000000, 0xc9000000, 0xbd800000, 0xe2c00000, 0x7da00000, 0xd0500000, 0xe9080000, 0x27940000, 0xed2a0000, 0x18d90000, 0x9a5d8000, 0x921fc000, 0xb6232000, 0x084c1000, 0xe3f65800, 0xc5869c00, 0xfb1fa200, 0x3ba2b300, 0x528cc180, 0xca57e540, 0x6fd721a0, 0xe9173890, 0x56b757e8, 0x29e76cb4, 0xf06ee382, 0xbaba9643, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x38000000, 0x1c000000, 0xbe000000, 0x67000000, 0x3c800000, 0x27400000, 0x6fe00000, 0xa7b00000, 0xb6780000, 0xc1cc0000, 0x6fee0000, 0xc1490000, 0xa6f58000, 0x32c24000, 0x3f962000, 0x0b84f000, 0xc39bf800, 0x07cb1c00, 0x50031e00, 0x7cb6f100, 0xc014ea80, 0x16f3fdc0, 0x3e2fd060, 0x94e9cf70, 0x272528d8, 0x49cbdc7c, 0x7f027482, 0xd4374cc3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x68000000, 0x14000000, 0x6e000000, 0xe9000000, 0x01800000, 0xd5c00000, 0x6b600000, 0x45b00000, 0x79580000, 0x7da40000, 0x1a320000, 0xe1690000, 0xbb3d8000, 0x33f7c000, 0x1a6b6000, 0xe54c5000, 0xd8ce6800, 0x9bfe7c00, 0x1fe7e200, 0x3d63bb00, 0xec407f80, 0x32a128c0, 0xdcd00260, 0x9fe91e30, 0xea7c7008, 0x4ed74cc4, 0x2a7a1d82, 0x484553c3, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x18000000, 0xdc000000, 0xc6000000, 0x4f000000, 0x83800000, 0xcfc00000, 0xc5600000, 0x0cd00000, 0xb1480000, 0x1f3c0000, 0x743e0000, 0x38190000, 0xceb48000, 0x1de34000, 0x07362000, 0x4685b000, 0xdaba7800, 0x56a2ec00, 0xaa160e00, 0x6af44f00, 0xa3434b80, 0xfc87c8c0, 0x261ca8a0, 0xba4e3e10, 0x24e1e138, 0xe610fe1c, 0x56a9c582, 0x44acc7c1, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x88000000, 0x64000000, 0xaa000000, 0x13000000, 0x5e800000, 0x23400000, 0x6da00000, 0x29b00000, 0x8b680000, 0xba2c0000, 0xb59e0000, 0xf6590000, 0x91058000, 0x94924000, 0x7d37a000, 0xa3959000, 0xe10b0800, 0x23d2b400, 0xa2971600, 0x5525a500, 0xaae2ba80, 0x8bbf5940, 0x53293060, 0x5d0ca150, 0xed6eb398, 0xbf909c1c, 0x1a182c82, 0x5424bc43, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x08000000, 0x8c000000, 0x1e000000, 0xdb000000, 0xea800000, 0xb5400000, 0xe0200000, 0xe6300000, 0x72680000, 0xf42c0000, 0xebea0000, 0x9cd90000, 0xee048000, 0xea674000, 0x0cc3a000, 0x98d59000, 0x4bded800, 0xd8d6dc00, 0x00ea8600, 0xce581d00, 0x2f452e80, 0xc047ba40, 0xabf30760, 0x493cef50, 0x25321098, 0x57dd64f4, 0xc5e32882, 0xe164e741, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xd8000000, 0x0c000000, 0x52000000, 0x99000000, 0xd7800000, 0x79c00000, 0x5ee00000, 0x54100000, 0xd2780000, 0x9b440000, 0xcd4a0000, 0xa7e90000, 0xdffc8000, 0x706fc000, 0xdff3a000, 0x45cc3000, 0x57675800, 0xdf1ec400, 0x495ba200, 0xed904700, 0xa8b9af80, 0xbf25fbc0, 0x391b3d20, 0x41b0f470, 0x0cc876c8, 0xc70c7674, 0x8f068d82, 0x114e7cc1, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x58000000, 0x34000000, 0x52000000, 0x79000000, 0x84800000, 0x74400000, 0xb4e00000, 0x00500000, 0x6a780000, 0x1dcc0000, 0x4e6a0000, 0xa7a90000, 0x9f748000, 0x87064000, 0xbf726000, 0x73f53000, 0xdf46a800, 0x4d928400, 0xe8a4a200, 0x10bf1100, 0x949e0480, 0x346f6fc0, 0x7aa6e3a0, 0xe5435970, 0xb09dfcd8, 0x229376b4, 0x7f242682, 0x3d7f3ec1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x78000000, 0xfc000000, 0x0a000000, 0x07000000, 0xcb800000, 0x14c00000, 0x2da00000, 0xe6700000, 0xf1480000, 0x6cf40000, 0x848e0000, 0x23b90000, 0x7efd8000, 0x7b1b4000, 0xfbe62000, 0xf9fc7000, 0x709b3800, 0x4f277400, 0x445d5e00, 0xeeea5f00, 0x426ea580, 0x22a91140, 0x6d659de0, 0xaa57d010, 0x48946128, 0x3bdf8fbc, 0xb7c07b82, 0x40210e43, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x28000000, 0xa4000000, 0x96000000, 0x9b000000, 0xd0800000, 0x8d400000, 0x95e00000, 0x45700000, 0x58380000, 0xa73c0000, 0xb0420000, 0xcec90000, 0x8ec48000, 0xaddfc000, 0xfb1be000, 0x9ac5d000, 0xb3de0800, 0x541b0c00, 0x84440600, 0x299ff900, 0x237b5e80, 0x417401c0, 0xafc645e0, 0x9cf64ff0, 0xb1ae5538, 0x16a30ea4, 0xbf39d882, 0x2dbd38c1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x38000000, 0xac000000, 0x4e000000, 0xb9000000, 0x34800000, 0x51c00000, 0xf7200000, 0x47100000, 0x65e80000, 0xa55c0000, 0x5b1a0000, 0xeb790000, 0xbff58000, 0xe3a7c000, 0x93d3a000, 0x9234f000, 0xa2871800, 0x21c2fc00, 0xdd5d2200, 0xd71b0100, 0x15790780, 0x6ef55040, 0x43277d20, 0x20126550, 0x92151978, 0x6817d554, 0x216ba582, 0xdee09143, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x98000000, 0x4c000000, 0xce000000, 0x89000000, 0x54800000, 0x44400000, 0xa9a00000, 0xd5500000, 0xeef80000, 0xa48c0000, 0xfdd20000, 0xe2290000, 0x10b58000, 0xb7bfc000, 0xd48be000, 0x4af5b000, 0x5f1ed800, 0x115bbc00, 0x8a4c4200, 0xc1334100, 0x6659ac80, 0xd15d8d40, 0x456a79a0, 0x40051870, 0x31b6acd8, 0x29aee144, 0xca526e82, 0xa1e80c43, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x68000000, 0x0c000000, 0xa2000000, 0x17000000, 0x50800000, 0x49c00000, 0x5be00000, 0x7ef00000, 0x20180000, 0xf2640000, 0x9d8a0000, 0x3b690000, 0x9c3c8000, 0x4d4ec000, 0x1a32a000, 0xca5d5000, 0x71fe5800, 0xba8b2400, 0x93e8de00, 0xd1fc2900, 0x68aeaf80, 0xb9c3adc0, 0xa1c53ae0, 0x38db6eb0, 0x2220ca88, 0xdd100e34, 0x5ae8f182, 0xac7c44c1, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x78000000, 0x04000000, 0xb6000000, 0x23000000, 0xbb800000, 0x33c00000, 0xb1200000, 0x45b00000, 0x45e80000, 0xb7940000, 0x427a0000, 0xfed90000, 0xc13c8000, 0x788f4000, 0xa5f32000, 0xd19d7000, 0x07ffc800, 0xcbbb0c00, 0x56f91600, 0x660c4f00, 0x4c266380, 0xc2079840, 0x7e36c260, 0x551e3f50, 0xa72ba0e8, 0xe2a04cd4, 0x4a71f582, 0xe6c99741, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xc8000000, 0xcc000000, 0x62000000, 0xdb000000, 0x61800000, 0x68400000, 0xbe600000, 0xf7100000, 0xb3580000, 0x752c0000, 0xd37e0000, 0x34c90000, 0x28b58000, 0x5bf3c000, 0xe1876000, 0x2dd51000, 0x3d63d800, 0x129e6400, 0x1a98c600, 0xb30c8b00, 0x820e2c80, 0x4480fec0, 0x88c11320, 0x88a1e930, 0xdeb05418, 0xe369d11c, 0xf9856a82, 0x89dab5c3, 
    0x80000000, 0x40000000, 0x60000000, 0xb0000000, 0xb8000000, 0x74000000, 0x26000000, 0x51000000, 0xd2800000, 0x9e400000, 0x40200000, 0x22300000, 0xebc80000, 0x00740000, 0x5d0a0000, 0xd8790000, 0xf07c8000, 0xd09ec000, 0xa3a26000, 0xf39cf000, 0xfb4ea800, 0x90baec00, 0xbd713200, 0x31687d00, 0x10043880, 0x14e27e40, 0x353ddb60, 0xb13f6a10, 0x62529228, 0x81b59934, 0x4beb8a82, 0xff29c341, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x68000000, 0xf4000000, 0x42000000, 0xf3000000, 0x6e800000, 0x39c00000, 0x0de00000, 0x36f00000, 0x59680000, 0x1c0c0000, 0xd7160000, 0x02590000, 0x3a848000, 0x46ea4000, 0x66a7e000, 0x37115000, 0xa1992800, 0x38642400, 0xf89bd600, 0xaf0ee500, 0x277c9f80, 0xa13fb9c0, 0xe674f6e0, 0x7882ac50, 0x062a2858, 0x32c7d40c, 0x5ca0a982, 0xbbd00cc1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x98000000, 0x54000000, 0x02000000, 0x8d000000, 0x4f800000, 0x97400000, 0x79200000, 0xbc500000, 0xcdb80000, 0x263c0000, 0x9b9e0000, 0x74a90000, 0x97a58000, 0x5273c000, 0x4bcf6000, 0xff11b000, 0x7698e800, 0xf76da400, 0x29a64a00, 0x5dd40700, 0x211a0280, 0x988b2c40, 0x9cd21da0, 0xc4de5af0, 0x318818b8, 0x05f5a9dc, 0x74cb2882, 0x35729b43, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xf8000000, 0x24000000, 0xb6000000, 0x53000000, 0x0e800000, 0xda400000, 0x74200000, 0x02b00000, 0x46680000, 0xc3ec0000, 0xbb1e0000, 0x70990000, 0x96a58000, 0xeac3c000, 0xe8af6000, 0x35717000, 0xde880800, 0xab3ccc00, 0x0de73600, 0x5caca500, 0x82bf1080, 0x8ee9e240, 0x92ad5e60, 0x35bf1550, 0xd669f318, 0x2bec871c, 0xb71f4682, 0x2a983743, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xf8000000, 0x3c000000, 0xae000000, 0x69000000, 0x9f800000, 0xf3400000, 0xba200000, 0xd5900000, 0x69880000, 0xf6140000, 0x126a0000, 0xe9590000, 0x68bc8000, 0xac6f4000, 0x6efb6000, 0xff507000, 0xfde9b800, 0xcc247c00, 0x96334200, 0x6c65b700, 0x60924280, 0x4634ba40, 0xecfaa620, 0xb051ba90, 0x6f69e6e8, 0x02e517b4, 0xe0526082, 0xc9557d41, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x38000000, 0x5c000000, 0x06000000, 0x51000000, 0xbf800000, 0x68c00000, 0x59200000, 0x3e500000, 0xd6c80000, 0x09440000, 0x023a0000, 0xae590000, 0x03ac8000, 0x88aec000, 0xe96ae000, 0x2d11f000, 0x6d28f800, 0x91352c00, 0x90233200, 0xc494b700, 0x3232e580, 0xab3ddc40, 0x2a46c1a0, 0xf7ffb310, 0x0822a948, 0x4895f694, 0x9c333782, 0x6e3c9b41, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xe8000000, 0x34000000, 0x3a000000, 0x65000000, 0xdc800000, 0xad400000, 0xfee00000, 0xb8700000, 0xb9080000, 0xbd840000, 0x5e2a0000, 0x22390000, 0x656d8000, 0x825ec000, 0xa4db2000, 0x41715000, 0xcb892800, 0x3fc49400, 0xe14b3a00, 0x37890100, 0x81c4c680, 0x264b83c0, 0x420923e0, 0x1605c190, 0x1eeb7448, 0x87196574, 0x03bcdc82, 0x9547d2c3, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x48000000, 0x74000000, 0xc2000000, 0x75000000, 0xd2800000, 0x6c400000, 0x7f200000, 0x07d00000, 0x70b80000, 0x931c0000, 0x35760000, 0xbd290000, 0xd3848000, 0x5a3ac000, 0x0026e000, 0x11d11000, 0x17b8a800, 0xec9ca400, 0x47b79a00, 0x5048dd00, 0x68753480, 0x48d35040, 0x2843a0a0, 0x765a8cf0, 0x8b56a8f8, 0x8a79bf0c, 0x2a7c4e82, 0xdc869d41, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x58000000, 0x34000000, 0x96000000, 0x9b000000, 0xce800000, 0x12c00000, 0x0da00000, 0x63f00000, 0xc0880000, 0xfbcc0000, 0x629a0000, 0x5bb90000, 0x97e58000, 0xad274000, 0xb8ea2000, 0x25703000, 0xde48a800, 0x646d4c00, 0xc46aa600, 0xa2b04500, 0x1268e180, 0xdddd4140, 0xd8834ce0, 0xcdad8990, 0x574a2158, 0x2b817594, 0x7b406782, 0x8be13443, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x58000000, 0x34000000, 0x62000000, 0xe1000000, 0xc8800000, 0x95c00000, 0xe2e00000, 0x66b00000, 0xf5680000, 0xcfe40000, 0xc4d60000, 0x18190000, 0xa76d8000, 0x1a02c000, 0xabe76000, 0x20303000, 0x17a92800, 0x06846400, 0x2e271200, 0x0ad04900, 0x4d180780, 0xcdec03c0, 0x0ec2fe60, 0xb186e050, 0x8b419988, 0x3421050c, 0xcdd07582, 0xfe987ac3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x78000000, 0x2c000000, 0x36000000, 0x5f000000, 0xc1800000, 0xe8c00000, 0x44a00000, 0x88300000, 0x6a280000, 0xf82c0000, 0x81660000, 0x8dd90000, 0x4b258000, 0xe7bbc000, 0x7937a000, 0x15607000, 0xea101800, 0x07590c00, 0x5864ee00, 0x92db2b00, 0x0326e580, 0x8a38db40, 0xce746d60, 0xdb83e6d0, 0x2843f898, 0xef62b3ec, 0x7a93ab82, 0xd49a8043, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x48000000, 0x9c000000, 0xf2000000, 0x05000000, 0xe2800000, 0x06c00000, 0xda600000, 0x29100000, 0x51080000, 0x14240000, 0x62420000, 0x63d90000, 0xd9cc8000, 0x9fb7c000, 0xd1f36000, 0xdaa11000, 0x08707800, 0xf5984400, 0x406cfa00, 0x6e466d00, 0x9f2bd180, 0x0deddac0, 0xcb06dd20, 0x570bca90, 0xeb5ce108, 0xa8ffca64, 0xb4764b82, 0x0513a7c1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xc8000000, 0x64000000, 0xda000000, 0x31000000, 0x5c800000, 0xf6400000, 0x4ee00000, 0x32300000, 0x78c80000, 0x8bec0000, 0x8bda0000, 0xf9b90000, 0xd3458000, 0x2147c000, 0x5acba000, 0xf8611000, 0xad708800, 0x26a8d400, 0xa19d5200, 0x9ef3e100, 0x49e59080, 0x5096cbc0, 0xdab27f60, 0x22058410, 0x9c27b698, 0x993b4614, 0xcd896282, 0x5c8d3ac3, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x18000000, 0xec000000, 0x5e000000, 0x31000000, 0x45800000, 0x44c00000, 0xb7e00000, 0xbb300000, 0xaec80000, 0xdaec0000, 0x926a0000, 0xc4390000, 0x6c448000, 0x5476c000, 0xb5faa000, 0xe1e1b000, 0x5e319800, 0xe949dc00, 0x392df200, 0xa50b6300, 0xcc48ed80, 0x5ead31c0, 0xf6cb5f60, 0x3329ff10, 0xa2dce398, 0x76222574, 0xfe95bf82, 0x508ee2c1, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xe8000000, 0x2c000000, 0xc2000000, 0xe1000000, 0x7a800000, 0x48c00000, 0xea200000, 0x93d00000, 0x17f80000, 0x356c0000, 0x74be0000, 0x8fe90000, 0x43348000, 0x58434000, 0x7a4ee000, 0x86405000, 0xe4e19800, 0xd6f12400, 0x2da9f200, 0x19d57d00, 0xb5b34d80, 0x08669240, 0x43d590a0, 0xd0b38b70, 0x3ce68f18, 0xd815aa9c, 0x49125f82, 0xb176bf41, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x78000000, 0x44000000, 0x26000000, 0xd1000000, 0xb3800000, 0xdec00000, 0xabe00000, 0x7d300000, 0xe2780000, 0x52cc0000, 0xe1520000, 0xb2890000, 0xffd58000, 0x42eec000, 0x5f03a000, 0x2b807000, 0x0ac1c800, 0x95e02c00, 0xb831f200, 0x0ff91f00, 0x190d7980, 0xdf32b9c0, 0xc0793f60, 0x05cc9e70, 0xb3d28fd8, 0xf7c9cf04, 0xb6f52b82, 0xf63ed6c3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x48000000, 0xdc000000, 0xd2000000, 0x23000000, 0x26800000, 0x0bc00000, 0x7fe00000, 0x00d00000, 0x5aa80000, 0x0d3c0000, 0x50320000, 0x04b90000, 0x4bf58000, 0xcd9fc000, 0x9583e000, 0xa7001000, 0xd081f800, 0x8ec08400, 0x04603600, 0x94916500, 0xf7080b80, 0x8d4d1dc0, 0x5d6a0aa0, 0x0a9defd0, 0x47437238, 0xb1609e04, 0x8711dd82, 0x2f4968c3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x38000000, 0x14000000, 0x82000000, 0xe9000000, 0x46800000, 0x45400000, 0xa6a00000, 0x93500000, 0x0dd80000, 0x71640000, 0xabb60000, 0x25490000, 0x4b5d8000, 0x8d23c000, 0x8977e000, 0x6c28f000, 0x4dec6800, 0xae0a2400, 0xf11a4200, 0xace25500, 0xd396e680, 0xb7583b40, 0xca24a9a0, 0xda176430, 0xc7999908, 0x0244328c, 0x2626c482, 0x7ff15e43, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x68000000, 0xfc000000, 0x52000000, 0x57000000, 0x60800000, 0xb8400000, 0x87a00000, 0x90d00000, 0xf5e80000, 0x9e940000, 0x5f060000, 0x25f90000, 0xa09d8000, 0x68e34000, 0xc2c66000, 0x4d985000, 0x7f2d3800, 0xea3a8400, 0x2aca1e00, 0x47336900, 0x6bafec80, 0x994da540, 0x408a3ea0, 0x57925250, 0x3bff2ee8, 0x64e472ec, 0x31be1282, 0x6445dc43, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x38000000, 0xe4000000, 0x96000000, 0xeb000000, 0xe6800000, 0xd6400000, 0x13600000, 0xa7700000, 0xb9280000, 0x28140000, 0x55020000, 0xb2990000, 0xc61d8000, 0x84064000, 0xdc432000, 0x0978f000, 0x882c0800, 0x76cf4c00, 0xb2668600, 0x62b2f500, 0x1e918880, 0x42193cc0, 0x3b5d45e0, 0x51e68bd0, 0xbd724e68, 0x9b307024, 0xe349ae82, 0x0ce579c3, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x68000000, 0xa4000000, 0x7e000000, 0x87000000, 0xd8800000, 0x60c00000, 0xf2e00000, 0x8c900000, 0xaae80000, 0xb67c0000, 0xdfea0000, 0x60390000, 0x49b48000, 0x2f67c000, 0x096ae000, 0xaff95000, 0x27d40800, 0x4d36dc00, 0xbe633e00, 0xe995a900, 0x4c163580, 0xee9337c0, 0x7c2d1620, 0x6ce2fd50, 0x4854dcb8, 0x3d770134, 0x98436b82, 0x71e40ec1, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x28000000, 0x0c000000, 0xce000000, 0xa1000000, 0xb7800000, 0xa2400000, 0x62a00000, 0x49b00000, 0x82180000, 0x590c0000, 0x83260000, 0x78690000, 0x16f58000, 0x38bac000, 0xcba6a000, 0x44a8d000, 0xdd955800, 0x87eafc00, 0xe7afb200, 0xa38da700, 0x48e78080, 0x51887b40, 0x5664ce60, 0xb753a7b0, 0xdf1217d8, 0xaeb35e6c, 0xa7831282, 0x655bcc43, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xf8000000, 0x34000000, 0x5a000000, 0x8d000000, 0x38800000, 0xc0400000, 0x81600000, 0x1c900000, 0xd1a80000, 0xea340000, 0xd55e0000, 0x47f90000, 0x6bbd8000, 0x9c1bc000, 0xf4dfe000, 0xb5397000, 0xcf9c2800, 0x856b9400, 0x6fa70a00, 0xecc56900, 0x03e71c80, 0xb3a48cc0, 0xd077c220, 0x938d0ad0, 0x6082ea28, 0xbef20f5c, 0xd80a7682, 0x553755c3, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x08000000, 0xac000000, 0xee000000, 0x91000000, 0x37800000, 0x94400000, 0x8e600000, 0x1a100000, 0x13e80000, 0x45540000, 0x870a0000, 0x58390000, 0x0b9c8000, 0x24aec000, 0x2f0b2000, 0xc4399000, 0x9d9d1800, 0x01af3c00, 0x528a1200, 0x8378a700, 0x5b7dec80, 0x297f02c0, 0x6cc24920, 0xc61da850, 0x5bee7ae8, 0x3deb38f4, 0xb6e85e82, 0x78d4f5c1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x48000000, 0x84000000, 0x26000000, 0x63000000, 0x64800000, 0xab400000, 0xe0200000, 0xa3d00000, 0xd6480000, 0x89040000, 0x2bee0000, 0xb0590000, 0x252d8000, 0xb89b4000, 0x1eee2000, 0x0fd81000, 0x16edc800, 0x89fa2c00, 0xd41e7600, 0xdfc1d100, 0xc360d280, 0x67f12a40, 0xc398f8a0, 0x744dab10, 0x426ac0c8, 0x16f75a3c, 0x16550482, 0x5ae7ab43, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xb8000000, 0xac000000, 0x36000000, 0xbd000000, 0xa2800000, 0x67c00000, 0x1ae00000, 0x4e500000, 0x70780000, 0x12fc0000, 0x4eda0000, 0x56690000, 0x65258000, 0x33574000, 0xe27ba000, 0xb699f000, 0x42ad9800, 0x37a38c00, 0x2c15aa00, 0x7f3eed00, 0xcc5fbb80, 0x3a4f03c0, 0x359613a0, 0x441b5270, 0x9608a3b8, 0x40b506d4, 0x3fce3182, 0xbbd65ec3, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x58000000, 0x8c000000, 0xe2000000, 0xad000000, 0xfb800000, 0x04c00000, 0xb6600000, 0x1f700000, 0xa7980000, 0x3dfc0000, 0x6cf20000, 0x72a90000, 0x7f448000, 0xaedec000, 0x35d2a000, 0xa7793000, 0x4dcd5800, 0x41caa400, 0xba454a00, 0x115edf00, 0x67131580, 0x0219d2c0, 0xbe3c63e0, 0x3812c9b0, 0x2c98cab8, 0x7d7df9c4, 0xe0b27f82, 0xfc89fdc1, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0xf8000000, 0xc4000000, 0x1a000000, 0xad000000, 0x63800000, 0x9bc00000, 0x99e00000, 0x9bf00000, 0xcda80000, 0x7c540000, 0xc5d20000, 0x5f190000, 0x5e5c8000, 0x7f574000, 0x17f26000, 0xf5087000, 0x24044800, 0x58aa1400, 0x2574ca00, 0x7f423f00, 0x6a00cb80, 0xb501bdc0, 0xb7801ae0, 0xc9c083d0, 0x08e138e8, 0x26715d84, 0xe168e182, 0x2b35b2c1, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xb8000000, 0x0c000000, 0x9e000000, 0x95000000, 0xfc800000, 0xea400000, 0xe5e00000, 0xe7500000, 0x34480000, 0x86340000, 0x3ebe0000, 0xd4d90000, 0x3b5d8000, 0xcf7a4000, 0xb71e2000, 0x1f69f000, 0x12c5d800, 0x9e465c00, 0x30f47a00, 0x611f1100, 0x4e69b080, 0x74457dc0, 0x5b062da0, 0x96947d10, 0x978edf28, 0x82000a1c, 0x73006a82, 0x4580dcc3, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xa8000000, 0x6c000000, 0xd6000000, 0x0b000000, 0xfc800000, 0x65c00000, 0x16200000, 0xe0900000, 0x93c80000, 0xc7940000, 0x5b4a0000, 0x4b190000, 0x0e3d8000, 0xa42ec000, 0xc26ba000, 0x4d09d000, 0x15359800, 0x7a1bcc00, 0x24f0e600, 0x5c39f100, 0xf72d7f80, 0x01a73640, 0x609e7e20, 0xf0324d10, 0xa0d484e8, 0x8faaadf4, 0xf729b982, 0x43a4d743, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xe8000000, 0xc4000000, 0x9e000000, 0x35000000, 0x1e800000, 0xdfc00000, 0xfe600000, 0x23300000, 0xaf680000, 0x5ec40000, 0x307e0000, 0x1a190000, 0x198d8000, 0x65aa4000, 0xae1e6000, 0x69295000, 0xcee44800, 0xa76e1c00, 0x2c61da00, 0x1c31e500, 0x62e94b80, 0x3685cac0, 0xbd5fc160, 0x77885450, 0xde3442c8, 0x4377f05c, 0x50ed7182, 0x1f1a3fc3, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0x08000000, 0xd4000000, 0x06000000, 0xd7000000, 0x31800000, 0xd8400000, 0xdaa00000, 0xdcd00000, 0x86880000, 0x136c0000, 0xde5e0000, 0x68f90000, 0xad348000, 0x25bac000, 0xd6cbe000, 0x24139000, 0x3b36e800, 0xb365ac00, 0x04f31e00, 0xa446fb00, 0xbbbd6480, 0x0ed7ef40, 0xb494f0a0, 0xeeeb0c90, 0x4f039618, 0xa45ea7dc, 0x3df89282, 0x55b4b841, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xf8000000, 0xec000000, 0xe6000000, 0x35000000, 0xc9800000, 0xe3400000, 0x69e00000, 0x06700000, 0x9b380000, 0xa5fc0000, 0xeaf20000, 0x28a90000, 0x96b48000, 0x05364000, 0x8c26a000, 0x70ae7000, 0x244a1800, 0xe015ac00, 0x14a6fa00, 0x386f5b00, 0x49ea0280, 0xa9049dc0, 0x882e81e0, 0x9c8bd5f0, 0xa5b5afb8, 0x49b67b44, 0xaee6e082, 0x3e0e6ac1, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0xd8000000, 0x04000000, 0xee000000, 0x53000000, 0xe4800000, 0x14400000, 0x31600000, 0x32b00000, 0xc2680000, 0xe0040000, 0x043a0000, 0x8db90000, 0x82dc8000, 0x2f57c000, 0xb807a000, 0x749e3000, 0x0b924800, 0xbf1d3c00, 0x95f6f600, 0x27161100, 0xc3676c80, 0x4b2ee0c0, 0xf67a3e60, 0x73d84f50, 0x5eecbd48, 0x147eea54, 0x06e3d282, 0xb6d5cdc1, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x28000000, 0xd4000000, 0xa6000000, 0x75000000, 0x86800000, 0x51c00000, 0x6d600000, 0x06500000, 0x68780000, 0x0b2c0000, 0xcdc60000, 0x0d490000, 0x84048000, 0x2e134000, 0xbf63a000, 0x876bd000, 0x24cf6800, 0xb66d2c00, 0x6e67da00, 0x3ff81500, 0x426c3780, 0xd867c4c0, 0xc2f8afa0, 0x40ec0870, 0x07a76018, 0x0e980f6c, 0x663c8582, 0x4b1efdc1, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0xf8000000, 0x9c000000, 0xf2000000, 0x93000000, 0x98800000, 0x5fc00000, 0x97600000, 0x76900000, 0xeef80000, 0xb69c0000, 0x93b60000, 0x15090000, 0x29f48000, 0xe5524000, 0x22e26000, 0x39aa7000, 0x677ef800, 0xa29d4400, 0x65b77600, 0x7809d900, 0x98747380, 0xd51364c0, 0x1cc24620, 0xe69ae170, 0x63f61378, 0x4b282e0c, 0x66c5fd82, 0xa9dbf9c1, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xb8000000, 0xd4000000, 0x22000000, 0x55000000, 0xc5800000, 0x7dc00000, 0x07a00000, 0x6d100000, 0x93480000, 0x48840000, 0x6bb60000, 0x2ff90000, 0x91dd8000, 0x08fac000, 0x288ae000, 0xe1f3f000, 0x7f6fe800, 0xfd75e400, 0xf70f7a00, 0x2ac57300, 0x30d60780, 0x32c9f940, 0x0f447720, 0x7d170810, 0xed680cc8, 0x4655c68c, 0x745e9582, 0x24ed6e43, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xd8000000, 0x04000000, 0xd2000000, 0x1d000000, 0x8f800000, 0x09400000, 0x77e00000, 0x3cf00000, 0x8a580000, 0x49840000, 0x4f7e0000, 0xaf490000, 0x042c8000, 0xf423c000, 0x4673e000, 0x1f3a3000, 0x04164800, 0x2ab50400, 0x46062a00, 0x299c8700, 0xad9a6e80, 0x710609c0, 0x6f1d90e0, 0xb15b7730, 0xbea76348, 0xa58c715c, 0xc5b20c82, 0x4a1b8ac1, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x38000000, 0xfc000000, 0x72000000, 0xc7000000, 0x0d800000, 0x1ac00000, 0x88e00000, 0xf5300000, 0xd9c80000, 0x0b240000, 0x5ac60000, 0xc2190000, 0x96dd8000, 0xacaac000, 0x61bba000, 0x6ea2f000, 0x6effb800, 0x97140400, 0xcb8e1e00, 0x117cf300, 0xc7ba7980, 0xbfa233c0, 0x1a7f4360, 0x5d54c710, 0x572ebf08, 0xf5ed94ac, 0xcc63df82, 0xda1ec4c3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x28000000, 0xc4000000, 0xaa000000, 0x2d000000, 0xe0800000, 0x0b400000, 0x06200000, 0xd5b00000, 0x22a80000, 0x071c0000, 0x7c5a0000, 0xfc390000, 0xc0858000, 0xdaaf4000, 0x555f2000, 0x1756d000, 0x2dba4800, 0x02e8b400, 0xc2bcea00, 0x752b7900, 0x2671ba80, 0x13c95a40, 0x328dac60, 0xd842bcd0, 0x960cdff8, 0xb9028014, 0x1d2d1882, 0x9c339743, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x68000000, 0x3c000000, 0x4e000000, 0x1b000000, 0xe9800000, 0x15400000, 0xc0200000, 0xbef00000, 0x3dc80000, 0x89f40000, 0xc51e0000, 0xbc190000, 0xc94c8000, 0x15624000, 0x8853a000, 0xf37b5000, 0x081fb800, 0x0a99fc00, 0x0f8c8600, 0xf9039b00, 0x2203be80, 0xab820240, 0xcec3bce0, 0x36e24810, 0xdc12ec28, 0x93db461c, 0x4f2e8082, 0x78b16541, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x08000000, 0xbc000000, 0x2e000000, 0x79000000, 0x49800000, 0x88c00000, 0xe9200000, 0x5d300000, 0x18580000, 0x36ec0000, 0x62f60000, 0x53490000, 0x4f048000, 0x8b024000, 0x53b2e000, 0xa52b9000, 0x9fe6b800, 0x37a07c00, 0x8571c200, 0xe0385b00, 0xf23dc580, 0x7abe1440, 0xb2ccff60, 0x54479c30, 0xbcd18f18, 0xec494f4c, 0x5384bf82, 0xbc433341, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x98000000, 0x14000000, 0x9a000000, 0x65000000, 0x00800000, 0xb4400000, 0x8fa00000, 0xb9700000, 0x99e80000, 0xb9c40000, 0x821e0000, 0xa4390000, 0xb6dd8000, 0x8bf2c000, 0xa0832000, 0x106bb000, 0x472e6800, 0x9e715400, 0x48689a00, 0xe705f900, 0x54ff6480, 0x1e68f940, 0xac0525e0, 0xdb7f6450, 0x47a8ef48, 0x1b64b01c, 0xd7ef9682, 0x17915443, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0x8c000000, 0xbe000000, 0xef000000, 0x3f800000, 0xd5c00000, 0x80e00000, 0x1c700000, 0xee780000, 0x5e5c0000, 0xabbe0000, 0x27e90000, 0x0ed48000, 0x80da4000, 0x27abe000, 0xfc539000, 0x82ced800, 0x3b105c00, 0xb3c9ee00, 0x5ac5d700, 0x4c933f80, 0x88afabc0, 0x40207de0, 0x1e106a70, 0x194917f8, 0x4d854adc, 0x07320982, 0x197f20c1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0xb8000000, 0xac000000, 0x96000000, 0x69000000, 0xa7800000, 0x37c00000, 0xe4200000, 0xc9100000, 0x0ce80000, 0x74c40000, 0xea6a0000, 0x6ad90000, 0xf5bd8000, 0x3507c000, 0x6d162000, 0x4a7ff000, 0xef7a1800, 0xa0314c00, 0xb078c200, 0x44ed8700, 0x1e0e4b80, 0x9ee31e40, 0x22ecfb20, 0x9f0e8750, 0xcd633348, 0xbf2c7e34, 0x3c2e9182, 0x66f2d543, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xe8000000, 0x24000000, 0x56000000, 0x91000000, 0x6f800000, 0x82c00000, 0x3fe00000, 0x14300000, 0xba180000, 0xae140000, 0xb00a0000, 0x3e490000, 0x62fc8000, 0xcbe74000, 0x2c66e000, 0x9aa65000, 0x4b468800, 0xf2778c00, 0xbdefd200, 0x723a6700, 0x55511180, 0x036849c0, 0x092c4160, 0xc5cf58b0, 0xc86bef68, 0x6cb8ab34, 0xe104cb82, 0xf8c2e2c1, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x68000000, 0xf4000000, 0xba000000, 0x85000000, 0xe6800000, 0x3a400000, 0x2fe00000, 0x2b500000, 0xe5980000, 0x31740000, 0xd6ca0000, 0x35a90000, 0xe4fc8000, 0x7946c000, 0xa2072000, 0xf9675000, 0xf976a800, 0x7f8e1400, 0xb2eaba00, 0xbcd99500, 0x13145880, 0x6e5bf9c0, 0xde11fda0, 0x91f9b4b0, 0x3ae4d2a8, 0x78f24374, 0x576cca82, 0x6b7eb8c1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x68000000, 0xb4000000, 0xe2000000, 0xcf000000, 0x1a800000, 0xfbc00000, 0x65e00000, 0x47900000, 0x5bc80000, 0x04840000, 0xad660000, 0x79390000, 0x301d8000, 0x3b4bc000, 0x518b2000, 0x67ea5000, 0x643a2800, 0xd052a400, 0x9de62e00, 0xc9f8ed00, 0x357deb80, 0x841ac9c0, 0x4b227820, 0x463e1710, 0xc0f57248, 0xc43ee6ac, 0xdff46d82, 0x56bf40c3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x98000000, 0x44000000, 0xe2000000, 0x59000000, 0x09800000, 0xffc00000, 0xcb200000, 0xccd00000, 0x15c80000, 0x510c0000, 0x78920000, 0xfdb90000, 0xacd58000, 0x57f74000, 0x26b7a000, 0xd4d7b000, 0xf6674800, 0xc71ea400, 0x4c6ae200, 0x770ccb00, 0x0393e380, 0x0d39b840, 0x0a9464a0, 0xfb164910, 0x654686d8, 0xefcfd444, 0xeba3c982, 0xe7009743, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0xa8000000, 0x3c000000, 0x1e000000, 0xc5000000, 0xcc800000, 0x61c00000, 0xf9200000, 0x9ab00000, 0x63a80000, 0x453c0000, 0xe7220000, 0x89b90000, 0x51648000, 0x3956c000, 0x9836a000, 0x6ee6d000, 0xfb1f3800, 0x4c1adc00, 0x641c3a00, 0x19935100, 0xd011b780, 0x8b584c40, 0x5df4f260, 0x5bcff3d0, 0xb0e3c4b8, 0xc99821e4, 0x79543582, 0x2e3e0141, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xf8000000, 0x1c000000, 0xde000000, 0xe7000000, 0x5d800000, 0x87c00000, 0x05a00000, 0xf1700000, 0x77180000, 0x47740000, 0x22aa0000, 0xa9490000, 0x035c8000, 0x7ca74000, 0x4e47a000, 0x0dd67000, 0x795ef800, 0xeaa3dc00, 0x0bf45e00, 0xbbea1300, 0x14a99b80, 0x194d9140, 0xbdefa3e0, 0x491ab0b0, 0x43713328, 0xa6182e74, 0xb9f5bd82, 0x6aea1e41, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x98000000, 0x1c000000, 0xf6000000, 0x17000000, 0x27800000, 0x80400000, 0x17a00000, 0xe4f00000, 0x28580000, 0xcf240000, 0x45ea0000, 0x83890000, 0xe04d8000, 0xbf76c000, 0x6b17e000, 0x4207b000, 0x800e7800, 0xdf034c00, 0xb455be00, 0x21f2e700, 0x250cc480, 0xa2578540, 0x41268ce0, 0x393e8530, 0x69ba4c88, 0x3ca094f4, 0xe5708282, 0x3719ee43, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x18000000, 0xd4000000, 0xda000000, 0x85000000, 0x4e800000, 0x37c00000, 0x51600000, 0xbf300000, 0xbd380000, 0xe1dc0000, 0xd22e0000, 0x30e90000, 0x66948000, 0x8e6b4000, 0xae4aa000, 0x5bdbb000, 0x76b36800, 0x0266d400, 0x8b2c5a00, 0xff776500, 0x4285a380, 0xbf42a4c0, 0x82be8560, 0xc300bef0, 0x9d80ddf8, 0x5240c87c, 0xa7201182, 0x0a1155c1, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xb8000000, 0xfc000000, 0x76000000, 0xe5000000, 0x08800000, 0x31c00000, 0x50600000, 0x27d00000, 0xee780000, 0xd53c0000, 0x39ce0000, 0xe8490000, 0x03d48000, 0xde2bc000, 0x978b2000, 0xe43af000, 0x4793b800, 0xffd68c00, 0x46a4da00, 0x5263f900, 0xae5ee780, 0xe110aec0, 0x6998b0a0, 0x10ac9070, 0x0f970e38, 0x4184ac7c, 0xfd130582, 0xe1171bc1, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x08000000, 0xcc000000, 0xee000000, 0x43000000, 0xa7800000, 0x87c00000, 0x72200000, 0xded00000, 0x95d80000, 0xd1740000, 0x3a4e0000, 0x89a90000, 0xe03c8000, 0xc2024000, 0x38e36000, 0x9d939000, 0x325a5800, 0x93567c00, 0x297d3600, 0xb1626700, 0x39527b80, 0xf7fbd640, 0xf247e0a0, 0x0a840930, 0x9cc6ec28, 0x3bc543fc, 0x4ba79582, 0x08748d41, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0xf8000000, 0x14000000, 0xb6000000, 0x61000000, 0x0b800000, 0x37c00000, 0x68a00000, 0x54900000, 0x3c480000, 0xbc2c0000, 0x4e6e0000, 0xf7b90000, 0x5c548000, 0x0a9b4000, 0xf1b36000, 0xb5ae7000, 0x4d18e800, 0x87c4cc00, 0x78521200, 0x3fdeaf00, 0xd1a15b80, 0x3b109740, 0xe5883020, 0x918d5210, 0x5f7e0998, 0x8930cf3c, 0x3558c182, 0x46a48441, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x98000000, 0x0c000000, 0x9e000000, 0xab000000, 0x96800000, 0xabc00000, 0xc1200000, 0x16300000, 0x93280000, 0xca940000, 0x833a0000, 0xf7f90000, 0x42ad8000, 0xf2b74000, 0xf67fe000, 0xf27bb000, 0x6319d800, 0xeebd1c00, 0x092fc600, 0x9003e500, 0xe8f5c380, 0x34eb3040, 0xf541cb60, 0x4ee05ad0, 0x7d1005e8, 0xcc183bd4, 0x623c3d82, 0xd3ee7943, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x58000000, 0xc4000000, 0xde000000, 0x7b000000, 0x7d800000, 0x8e400000, 0xc8a00000, 0x19100000, 0xa9f80000, 0xd33c0000, 0x451e0000, 0x4e090000, 0xbf758000, 0xb0cb4000, 0x26d26000, 0x58de3000, 0xebe84800, 0x77441c00, 0xe0626600, 0xb7b7a300, 0x6e6d1880, 0x19479340, 0xe6a4a320, 0xce521270, 0x481ea8b8, 0xb489e1dc, 0x46b55682, 0xbb2a1c43, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x18000000, 0xd4000000, 0x0e000000, 0x37000000, 0xb8800000, 0x9e400000, 0x16a00000, 0xfc500000, 0x5d880000, 0xf71c0000, 0x43aa0000, 0x7d390000, 0x8e658000, 0x026e4000, 0x1c876000, 0xc1aab000, 0x70396800, 0x1fe5bc00, 0x3bae7e00, 0xe0e78900, 0x6f1a3880, 0xfe413740, 0xc6a15ba0, 0xf4508890, 0xa18876f8, 0x351dea34, 0xaeaa4e82, 0xfcb9b243, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xf8000000, 0x74000000, 0x96000000, 0xa7000000, 0x8b800000, 0x95400000, 0x43600000, 0x6ff00000, 0xfa680000, 0x448c0000, 0x4bea0000, 0x9fb90000, 0xc8748000, 0xfffe4000, 0x0036a000, 0x196a7000, 0xca792800, 0x87d44c00, 0x5f2f5e00, 0x764eaf00, 0x34be9e80, 0xd857ccc0, 0x171bcae0, 0xc8511750, 0xb6b84a58, 0x20f43074, 0x7f3e4882, 0x2d175fc1, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x88000000, 0x3c000000, 0xc6000000, 0xb7000000, 0x69800000, 0x0c400000, 0x1c200000, 0xc4700000, 0x8dc80000, 0xcd540000, 0xb69e0000, 0xffd90000, 0xbfcc8000, 0x03f34000, 0xc19be000, 0x55fe9000, 0x7c08b800, 0x1734ac00, 0x37cfde00, 0x24e05b00, 0xd4907c80, 0xe359e240, 0xff0d59e0, 0xe713ae10, 0xf50a1168, 0x66a6c91c, 0x7b04fa82, 0x44278541, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x18000000, 0xec000000, 0x32000000, 0x95000000, 0xe9800000, 0x11400000, 0xf2600000, 0x3ef00000, 0x56680000, 0x49540000, 0xe8ee0000, 0x41b90000, 0xbaac8000, 0x6aa2c000, 0x8e2ba000, 0x6b4fb000, 0x2fe89800, 0x60148400, 0xc68f7a00, 0x05499b00, 0x8dc52e80, 0x1477b2c0, 0xd08540e0, 0xa416c750, 0x53749fe8, 0xbffe2e7c, 0xcd616c82, 0xee711dc1, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x88000000, 0x84000000, 0xee000000, 0xbd000000, 0xdf800000, 0x3ec00000, 0x6de00000, 0x0b100000, 0xa8980000, 0xd2bc0000, 0x4ae60000, 0x26a90000, 0x6dd58000, 0xae524000, 0x4bab6000, 0x54479000, 0xc199c800, 0xbb3c7c00, 0xd5264a00, 0x46c8c700, 0x07043980, 0x63ab35c0, 0x20466f20, 0x879879b0, 0xb23c7438, 0x6ca7d9ac, 0x4108db82, 0x5b641ec3, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x78000000, 0x7c000000, 0xe6000000, 0x03000000, 0x0a800000, 0xcc400000, 0x3b600000, 0x73900000, 0xbcc80000, 0xc3f40000, 0x921a0000, 0xe2790000, 0x72cd8000, 0x8736c000, 0xc19fe000, 0x327a7000, 0x5768b800, 0xfc446c00, 0x70a2d600, 0xb495fd00, 0xdf8bdc80, 0x31b084c0, 0x55b85820, 0xde6cc210, 0x880664a8, 0x1a661154, 0x5e765282, 0x4b7f65c3, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xf8000000, 0x84000000, 0x0e000000, 0x73000000, 0xb4800000, 0x92c00000, 0xefe00000, 0x3ef00000, 0x6e880000, 0x75140000, 0x973a0000, 0xf7590000, 0x0f8c8000, 0x51d74000, 0x83bea000, 0xecda7000, 0xdfa9c800, 0xe6047c00, 0xb643f600, 0x89453100, 0xcae34180, 0x01146dc0, 0xf13acee0, 0x5859c790, 0xe10d5168, 0x461705d4, 0x2fdfdf82, 0xfa6b50c1, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0xb8000000, 0x8c000000, 0x1e000000, 0x6f000000, 0x3d800000, 0x9e400000, 0x64a00000, 0x7bf00000, 0x41e80000, 0xe2340000, 0x26f20000, 0x67f90000, 0x450d8000, 0x7a9fc000, 0x1376a000, 0xe543f000, 0x61b05800, 0x1f49dc00, 0x3cc5ce00, 0x779bb300, 0xef0c6880, 0x479eb340, 0xbff6aee0, 0xf9823a50, 0x1ed07aa8, 0x1259b7c4, 0x7c7d5e82, 0xc0b62c43, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xc8000000, 0x34000000, 0x16000000, 0xcd000000, 0x30800000, 0xdf400000, 0x73e00000, 0x50b00000, 0x7d380000, 0xd4640000, 0xe7fa0000, 0x38290000, 0x0c8d8000, 0xdc56c000, 0x4dee6000, 0x74cb1000, 0x23d02800, 0xfac80c00, 0x8ebdaa00, 0xc52ef900, 0xa7eb6a80, 0xe441b9c0, 0xfe603660, 0x17711ff0, 0x55986088, 0x2935cfd4, 0x33728882, 0xb7f55cc3, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x48000000, 0x34000000, 0xf2000000, 0x59000000, 0x6b800000, 0xcdc00000, 0xada00000, 0x62d00000, 0xfcf80000, 0x498c0000, 0x7d7a0000, 0xb1490000, 0xc2858000, 0x899f4000, 0x44a6e000, 0xa68a1000, 0xb221a800, 0x3d10c400, 0x58588200, 0xf8ddcf00, 0x30428780, 0x93656540, 0x762ec4a0, 0xf6ae4770, 0x69efe4d8, 0x320faf94, 0x88bf4d82, 0xc7377e43, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xb8000000, 0x9c000000, 0xa6000000, 0x17000000, 0x17800000, 0xeb400000, 0xb1600000, 0x95500000, 0xb2180000, 0x757c0000, 0x2d8a0000, 0xa8690000, 0x39d58000, 0x227e4000, 0x90276000, 0x35bbf000, 0xd921f800, 0x71b0ec00, 0xc1097e00, 0xe0840700, 0x9e66d280, 0xe65a38c0, 0x8db0e7a0, 0xb70973b0, 0x5f8451b8, 0x9de6d5f4, 0x8f1b3482, 0x11d023c3, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0xb8000000, 0xac000000, 0x9e000000, 0xed000000, 0x2e800000, 0x32c00000, 0x56e00000, 0x0e100000, 0xb0680000, 0x381c0000, 0x830e0000, 0x24d90000, 0xba458000, 0x4f8a4000, 0x97b22000, 0x6ce7f000, 0x76859800, 0x846bdc00, 0xbf22ca00, 0x6a4fd500, 0x9279b180, 0xd675f3c0, 0x7612b720, 0x19568a50, 0x145d7178, 0x0f2fac7c, 0x48294382, 0xa63c4ac3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x78000000, 0x4c000000, 0xb2000000, 0x81000000, 0xbb800000, 0x1f400000, 0x1c200000, 0x52b00000, 0x46d80000, 0xb55c0000, 0x8c220000, 0x94890000, 0x8e558000, 0x13374000, 0x709f6000, 0xeafa7000, 0xd1d55800, 0xda77c400, 0xfbbfd200, 0x34cbff00, 0x34ccf280, 0xa8ca6640, 0xaecd6460, 0x8dcb4e30, 0xa34d5778, 0x958aa5e4, 0x7bec9882, 0x50fb6d43, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xf8000000, 0x94000000, 0xba000000, 0x85000000, 0xbc800000, 0xefc00000, 0x58600000, 0x26d00000, 0xe0580000, 0xf2140000, 0xec9e0000, 0x19a90000, 0x993d8000, 0x7562c000, 0x952b2000, 0xfd877000, 0x9d1d6800, 0x95921400, 0x44831a00, 0xb8bb0100, 0x4e7e3380, 0x43b986c0, 0x5685daa0, 0xdde65430, 0xefcd7e68, 0xafcbdddc, 0x2396e182, 0x10a523c3, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x28000000, 0x34000000, 0x1e000000, 0x01000000, 0x12800000, 0x83400000, 0xcd200000, 0xb0d00000, 0xbfd80000, 0x3f940000, 0x95e60000, 0x17e90000, 0xb8fd8000, 0x455bc000, 0x7212a000, 0x3afed000, 0xb49d2800, 0x33abdc00, 0x409b3200, 0xd2733d00, 0x5e0e4280, 0x65152c40, 0x32a6caa0, 0x0cc90630, 0xed2ce2e8, 0xde0310ac, 0xfbc77882, 0x6eb8dd43, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x88000000, 0x0c000000, 0x86000000, 0x61000000, 0xbb800000, 0xd3400000, 0x32600000, 0x3cd00000, 0x7a780000, 0x238c0000, 0xf7160000, 0x8a090000, 0xad058000, 0x77d2c000, 0xdd7a2000, 0x528f9000, 0x0f145800, 0x558b6c00, 0xafc73200, 0x2a71df00, 0x8188e280, 0xc64452c0, 0x31b2f0a0, 0x73aaef70, 0x4bf76658, 0x7c19dbcc, 0x2d5c2882, 0x1e6fb1c3, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xc8000000, 0x1c000000, 0xb6000000, 0x43000000, 0x87800000, 0x74400000, 0x3c200000, 0xd9500000, 0xa3680000, 0x03c40000, 0x41b60000, 0x93d90000, 0xaa9c8000, 0x07eac000, 0x8dd36000, 0xc57e1000, 0xcb0d7800, 0x57634c00, 0xf926b600, 0x79d14700, 0x72a86c80, 0xc2a50a40, 0xe646a7a0, 0x91208f50, 0xd9d04c48, 0x62a88b0c, 0x5aa44282, 0x0247d141, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x08000000, 0xa4000000, 0xda000000, 0x73000000, 0x25800000, 0xc4c00000, 0x26a00000, 0xb4700000, 0x05980000, 0x8dc40000, 0x6c8e0000, 0xe8090000, 0xa74c8000, 0xb8824000, 0x45ea6000, 0x3ff79000, 0x895c8800, 0xe3ca1400, 0x97c6d600, 0xca25f300, 0x7a9fa580, 0x5f407740, 0x2b6181e0, 0x545037b0, 0xe8a90848, 0xc63d373c, 0x0d9b1b82, 0x9c6e4041, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x58000000, 0x7c000000, 0xe2000000, 0x5b000000, 0x97800000, 0xe2c00000, 0xf1a00000, 0x87700000, 0xf3b80000, 0xb8b40000, 0xa1660000, 0x43290000, 0xcc9d8000, 0x707ac000, 0xce92e000, 0x0a2e3000, 0xfee4b800, 0x82ef6400, 0x20442600, 0xc41f0700, 0x5c3d8980, 0x878a0940, 0xca6a23e0, 0x0afa23f0, 0xe6d34ca8, 0x2bcf84ec, 0xb4747782, 0x71c79a43, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xd8000000, 0x44000000, 0x2a000000, 0x29000000, 0x31800000, 0x22400000, 0xaea00000, 0x3a100000, 0xb5d80000, 0xbb240000, 0x30720000, 0x0fa90000, 0x4b8d8000, 0x1d7e4000, 0x0a16e000, 0xb9fb3000, 0x95f44800, 0xdbca7400, 0xcafd4200, 0x61573b00, 0x36da6880, 0x85a4b340, 0xacb26120, 0xfdc93630, 0xa3fd8888, 0xb0d62704, 0xc49a0282, 0x03058c43, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0xa8000000, 0x74000000, 0x5e000000, 0xef000000, 0x8f800000, 0x4c400000, 0x70600000, 0xa9700000, 0x35d80000, 0x33cc0000, 0x018e0000, 0xdc090000, 0x96c48000, 0x13cbc000, 0x1a02a000, 0xfbe6d000, 0x48bca800, 0x19565c00, 0x4545ee00, 0x358b8700, 0x3b635c80, 0xe2174ac0, 0x16a43fe0, 0x62ba3a30, 0xc3db8cd8, 0x9a2b6fbc, 0x24323a82, 0x8fde81c1, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xf8000000, 0x54000000, 0xca000000, 0x95000000, 0x35800000, 0xbe400000, 0x95a00000, 0x6a700000, 0x96180000, 0x836c0000, 0x53320000, 0x7b090000, 0x8f648000, 0x80d64000, 0x061f6000, 0x619a7000, 0xd81d6800, 0xa2ab3400, 0x9725fa00, 0x7e77d300, 0x16eef080, 0x2142dd40, 0xe91031e0, 0x2e0919b0, 0xdae57e18, 0x2e963744, 0x5bbf8282, 0xa7eb0a41, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xb8000000, 0xb4000000, 0xda000000, 0xdd000000, 0x2a800000, 0x9ac00000, 0x15200000, 0x3f500000, 0x67480000, 0x93ac0000, 0xcc9a0000, 0x2a790000, 0xbbd48000, 0x0e4f4000, 0x3cb6e000, 0x3ca2f000, 0xdb4da800, 0xf16b9400, 0x92216a00, 0x88d12d00, 0x7709d980, 0xec4cac40, 0x5eeb55a0, 0xc6607c10, 0x95315998, 0x8c780254, 0xf0d57b82, 0x37cea541, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x38000000, 0xe4000000, 0x26000000, 0x99000000, 0x73800000, 0x9cc00000, 0x46a00000, 0x63b00000, 0xc5280000, 0x4eb40000, 0xc7420000, 0xdeb50000, 0x9f438000, 0x4ab44000, 0x51422000, 0x0fb43000, 0xe0c3e800, 0x2c747c00, 0x4ce2da00, 0xa0849b00, 0x53abe380, 0xcb201640, 0x327124e0, 0x9e089c10, 0x24c43988, 0xcd4a5294, 0x347124e2, 0x17089c13, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0x08000000, 0xb4000000, 0x56000000, 0x4f000000, 0x87800000, 0x0ec00000, 0x1b600000, 0x8cf00000, 0x37c80000, 0x7bbc0000, 0xbbfa0000, 0x0fbd0000, 0x4dfa8000, 0xd0bcc000, 0xb27a6000, 0x627cd000, 0x4b1b0800, 0xf78c7c00, 0xb4539600, 0x05717300, 0x1a098b80, 0x9d5c45c0, 0xecca1260, 0x0194ea50, 0x9ef68518, 0xd7ae4da4, 0x97aa1262, 0xbd64ea51, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xf8000000, 0xe4000000, 0x72000000, 0xe7000000, 0x10800000, 0x38c00000, 0x42600000, 0x2a700000, 0x23a80000, 0x01540000, 0x9a820000, 0x85550000, 0x78838000, 0x7a54c000, 0xdc032000, 0xc8953000, 0x9d62e800, 0x8065d400, 0x610b2600, 0xd3d1f500, 0xe9395780, 0x374c71c0, 0xba9e8360, 0xf432f690, 0xe29ca1c8, 0xdea77394, 0x80fe8362, 0xfa42f693, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x58000000, 0xec000000, 0x76000000, 0xa9000000, 0xe5800000, 0xad400000, 0x71600000, 0x4a700000, 0x76380000, 0xc8240000, 0x30ee0000, 0x74250000, 0xceee8000, 0xf925c000, 0x196f6000, 0x3f657000, 0xbe8eb800, 0xe2d59c00, 0x5817ea00, 0x59205700, 0x8890b080, 0xa809b5c0, 0x82fca460, 0xabfb99b0, 0xd993d428, 0xe79ec86c, 0x3d9ca462, 0x148b99b1, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x98000000, 0x54000000, 0xd2000000, 0x41000000, 0x85800000, 0x23400000, 0xc1600000, 0x30d00000, 0xe3f80000, 0xd3f40000, 0x8ade0000, 0xc1f50000, 0x6bde8000, 0x7474c000, 0x009f2000, 0x7915f000, 0xb64f8800, 0x09ec5400, 0xa13b0a00, 0x25f35f00, 0x82ee4c80, 0xbf9c5dc0, 0x25b2ed20, 0x8f0eba30, 0x058cbac8, 0x726b278c, 0xa64aed22, 0xccfaba31, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0xf8000000, 0xfc000000, 0xc2000000, 0x9b000000, 0xee800000, 0xa5400000, 0x29200000, 0x31d00000, 0x4f580000, 0x3f740000, 0x52520000, 0x15750000, 0x6d538000, 0xf5f5c000, 0x39132000, 0xad543000, 0x7d02d800, 0x376db400, 0x2f07ee00, 0x50766900, 0xc63fa480, 0x48f3bb40, 0x0a650720, 0x79ea85f0, 0x52b109c8, 0x8f291954, 0x89bd0722, 0xe8de85f3, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x58000000, 0x44000000, 0xee000000, 0x59000000, 0x23800000, 0x19c00000, 0x82600000, 0x19d00000, 0xbc980000, 0xc8740000, 0x5a4e0000, 0xee750000, 0xaf4f8000, 0x5ff5c000, 0x358f6000, 0x11157000, 0x0b1fe800, 0xfbacac00, 0x181b5a00, 0xa54aeb00, 0x82926980, 0xa6c66fc0, 0xb8f89a20, 0x34a4f6f0, 0x7f573ac8, 0xa0c08a6c, 0x11e09a22, 0x3810f6f3, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x28000000, 0x4c000000, 0x6a000000, 0xb9000000, 0x33800000, 0x9d400000, 0xfbe00000, 0x4e900000, 0xa1580000, 0xa5540000, 0x69120000, 0xe3550000, 0xca138000, 0xf1d54000, 0x90d2a000, 0x99751000, 0xbaa23800, 0x963dc400, 0xa96f4a00, 0x0f5ba300, 0x0b197080, 0x3234d4c0, 0x7a432da0, 0x3e2c7670, 0x5cf6d708, 0x5daf0c54, 0xa8fb2da2, 0xc9e87673, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xb8000000, 0x8c000000, 0x32000000, 0x81000000, 0x59800000, 0xefc00000, 0x54a00000, 0x8c900000, 0xc5580000, 0xbddc0000, 0x1b060000, 0x93dd0000, 0x70068000, 0xb75d4000, 0x1c462000, 0xb93c3000, 0x23f73800, 0xac345400, 0xd7523a00, 0x303ee700, 0x21b0e580, 0xb609ce40, 0xb4243ca0, 0xf64a24f0, 0xc783d718, 0x53075afc, 0xb7dc3ca2, 0x560624f1, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x48000000, 0xbc000000, 0xba000000, 0x2d000000, 0x11800000, 0x0b400000, 0x21200000, 0x81100000, 0xc2880000, 0x00640000, 0xd3fe0000, 0xb6650000, 0x5cfe8000, 0x5ee54000, 0x503ea000, 0xab85d000, 0x708fd800, 0x48dca400, 0xb5038200, 0x2af68700, 0x98409480, 0x23a14540, 0xc8d056a0, 0x8a682050, 0xd994a668, 0x80864fac, 0x597856a2, 0xda1c2051, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xa8000000, 0xd4000000, 0xfe000000, 0xa3000000, 0x9b800000, 0xa6c00000, 0x4aa00000, 0x61900000, 0x8d180000, 0x005c0000, 0x4a9e0000, 0x935d0000, 0xb91f8000, 0xc19d4000, 0xbdbee000, 0xab0c1000, 0x7f274800, 0xf391ec00, 0xdc180e00, 0x9adddb00, 0x4edec380, 0x11bc0e40, 0xd86ee0a0, 0xa4f40470, 0x1e0a2818, 0xdc663d4c, 0xecf0e0a2, 0x54a90473, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x38000000, 0xbc000000, 0xd2000000, 0xd3000000, 0x78800000, 0x17c00000, 0x30a00000, 0x38300000, 0xbb880000, 0x7f040000, 0x9b620000, 0x14050000, 0x1fe28000, 0xb1c5c000, 0xcc42e000, 0xc975b000, 0xdc0b9800, 0x54d01400, 0xac583e00, 0x83dde500, 0xdb7e9180, 0x99da4440, 0x3b0901e0, 0xf4c40350, 0x29c3a7e8, 0xf735c194, 0x58eb01e2, 0xb7010351, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xe8000000, 0xb4000000, 0x12000000, 0x1b000000, 0xf1800000, 0xc7c00000, 0x21a00000, 0x71300000, 0x8c680000, 0x6f140000, 0xad0a0000, 0xc8150000, 0x4a8a8000, 0x8ed5c000, 0xc5ab6000, 0x33a41000, 0x00a20800, 0xefa03400, 0x8c303e00, 0x14e8d700, 0xb2553180, 0x52ea5440, 0xeb4533e0, 0x84721c90, 0x079845c8, 0x7a5c8284, 0xfe6f33e2, 0x0e971c91, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xe8000000, 0x14000000, 0x72000000, 0xcd000000, 0x5d800000, 0x99c00000, 0xd1a00000, 0xf9300000, 0x8f080000, 0x897c0000, 0x7f6e0000, 0xe67d0000, 0x77ee8000, 0xbe3dc000, 0x698ee000, 0xc1ac1000, 0x9b36c800, 0x7198f400, 0xe8455200, 0x9d9b4f00, 0x962fe180, 0x839dac40, 0x4ebf33e0, 0x3da54250, 0x0ccb7918, 0x61b6c08c, 0xa4d933e2, 0xcba44251, 
    0x80000000, 0x40000000, 0xa0000000, 0x30000000, 0x78000000, 0x14000000, 0xb6000000, 0x65000000, 0x9f800000, 0x6f400000, 0x9da00000, 0x7f700000, 0x7f380000, 0x80e40000, 0x5ab60000, 0x7be50000, 0x1c368000, 0xc1244000, 0x61d6e000, 0x0374b000, 0x565ec800, 0x42c9dc00, 0xfb1c0200, 0x0eb3e300, 0xee835c80, 0x941a1840, 0xef8e0260, 0x34013630, 0xc600bba8, 0xbd01b75c, 0xbb800262, 0xa1403631, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x98000000, 0x44000000, 0x02000000, 0xb9000000, 0x4c800000, 0x90c00000, 0x7d200000, 0x7ef00000, 0x47b80000, 0xff3c0000, 0xc1860000, 0x683d0000, 0xca078000, 0x1b7cc000, 0xf866e000, 0xa1edf000, 0x264e6800, 0x3179f400, 0xa91d1a00, 0x82f66d00, 0x9fc4bb80, 0x06dad740, 0x262ae660, 0x5e930830, 0xb62f2018, 0xa2e9c73c, 0xf3b4e662, 0xeea20833, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x68000000, 0xb4000000, 0xba000000, 0xb9000000, 0x9f800000, 0xa6c00000, 0x87a00000, 0x05d00000, 0x12080000, 0xb47c0000, 0x58b60000, 0x6bfd0000, 0x5e778000, 0x7c5dc000, 0xc3a66000, 0xb2551000, 0x79db0800, 0xe9e26400, 0x34a77a00, 0x8ed4db00, 0x699bf780, 0xcf03b440, 0xcc16ec20, 0x10ac9850, 0xc93fe0d8, 0x1740533c, 0x72616c22, 0x5cf15853, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x18000000, 0xf4000000, 0x5a000000, 0xbf000000, 0x19800000, 0xf5400000, 0x8fe00000, 0xa9b00000, 0x4e380000, 0x40cc0000, 0x23d60000, 0xa94d0000, 0xbe968000, 0xfaacc000, 0x71272000, 0xbd94f000, 0x396ac800, 0x97824400, 0x4c06b600, 0xe384f700, 0x2b839c80, 0xba06c8c0, 0x12843fe0, 0x07039cb0, 0xf1c77a78, 0x85a42d1c, 0x8e12bfe2, 0x26af5cb1, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xd8000000, 0x44000000, 0x8e000000, 0x8d000000, 0x1c800000, 0xf5400000, 0x81200000, 0x14d00000, 0x90f80000, 0xf8340000, 0x081e0000, 0xecb50000, 0x115e8000, 0x1f95c000, 0x728ee000, 0x48ec7000, 0xaa7a6800, 0xa6136c00, 0xab7e7200, 0xaec5d500, 0x3db65880, 0x3db83740, 0x7d150120, 0xf2cefeb0, 0xc14ddd48, 0x2deb3c8c, 0xa6cb8122, 0x911b3eb1, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0xa8000000, 0xdc000000, 0x42000000, 0x7b000000, 0xb2800000, 0xdf400000, 0x67a00000, 0xfcd00000, 0x9d180000, 0xb73c0000, 0x685a0000, 0xf9bd0000, 0xa51b8000, 0xdd1dc000, 0x6f4a6000, 0xa9449000, 0x5ad7d800, 0xb64e1400, 0x28b22e00, 0xae08f100, 0xd9c45080, 0x3e975e40, 0x036eb920, 0xfb227c70, 0xfcb0a358, 0x4e2892c4, 0x89d53922, 0x36efbc73, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xf8000000, 0xbc000000, 0x36000000, 0xdf000000, 0x9b800000, 0x33400000, 0x16600000, 0xd5300000, 0x7d980000, 0xabd40000, 0xdba60000, 0xb4550000, 0x02e68000, 0xfb354000, 0xfb57a000, 0x6a6cb000, 0xffa2d800, 0x9b9adc00, 0xa7de6600, 0xe7f16b00, 0x09b94080, 0xb005e7c0, 0x7dcfdae0, 0x603804f0, 0x9644b148, 0x392fc5bc, 0x52c95ae2, 0xad7d44f1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x18000000, 0x9c000000, 0x1e000000, 0x07000000, 0xfa800000, 0xa0400000, 0x5be00000, 0x12700000, 0x3ea80000, 0xc5840000, 0x9a860000, 0x9b050000, 0x68c78000, 0x61e44000, 0x0b37a000, 0x038c7000, 0xae129800, 0x341a4c00, 0xbe8f9600, 0x06903900, 0x32589680, 0x696c2ec0, 0x15e24260, 0x6a730b90, 0x15ab6568, 0x2e07f89c, 0x4445c262, 0xe5a74b93, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0x78000000, 0x04000000, 0x96000000, 0xf3000000, 0xa4800000, 0x42c00000, 0xa5600000, 0x8ed00000, 0xa8680000, 0xb9a40000, 0x7af20000, 0xf1250000, 0x12338000, 0x5545c000, 0x4d63a000, 0x906d3000, 0xb3e7a800, 0x15ee1c00, 0x321b4e00, 0x3c40d500, 0x4ea00b80, 0xe6313fc0, 0xc9f8a620, 0x4bec8710, 0x6fa62968, 0x8b4e6cf4, 0xcc2b2622, 0xe1b94713, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x68000000, 0x44000000, 0xca000000, 0x63000000, 0x68800000, 0xeac00000, 0x8f600000, 0xc9500000, 0xa1380000, 0x35ac0000, 0x016e0000, 0x372d0000, 0x98ae8000, 0xe8cdc000, 0xa73ee000, 0x20951000, 0xb6c26800, 0x41428400, 0x5503ae00, 0xd5a2d500, 0x2612bb80, 0x0d3babc0, 0xb38ff920, 0x893c61b0, 0xd1b70678, 0xc410256c, 0x02197922, 0x605da1b1, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xd8000000, 0xac000000, 0x3a000000, 0xb3000000, 0x59800000, 0xa4c00000, 0x64e00000, 0x13900000, 0x82280000, 0x0f0c0000, 0x586a0000, 0x308d0000, 0xddaa8000, 0xfaed4000, 0x6d7aa000, 0x45e4f000, 0x6987f800, 0xf8768400, 0xfe8f9e00, 0xf88ab700, 0x3d1c9780, 0x82835ec0, 0x996180a0, 0x99514290, 0xf3c8cab8, 0x041da444, 0xe00300a2, 0x30200291, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x48000000, 0xcc000000, 0xfa000000, 0xf5000000, 0xbe800000, 0x8ac00000, 0xace00000, 0xf2f00000, 0x3fe80000, 0xc8740000, 0x5dfa0000, 0x18f50000, 0x7c3a8000, 0x7995c000, 0x2d8b2000, 0xafdd5000, 0xb9aeb800, 0x161ea400, 0x43565200, 0x06f35900, 0xae718780, 0x8428a0c0, 0x8c157260, 0xfacb0710, 0x887d7688, 0xbeffe6e4, 0xc7a7f262, 0x561ac711, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xe8000000, 0x9c000000, 0x6e000000, 0x7f000000, 0x75800000, 0x9a400000, 0xc2200000, 0xc3d00000, 0xf1b80000, 0xe6140000, 0x82ba0000, 0x6c950000, 0x2d7a8000, 0x14f54000, 0xbc8ba000, 0xce9c9000, 0x37269800, 0xc4324c00, 0xa6096600, 0xf05d2700, 0x05c79280, 0x9a024340, 0xb4012520, 0x9201a830, 0xa1003d08, 0x72818744, 0x9bc1a522, 0xaa61e831, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x78000000, 0x24000000, 0x5e000000, 0xd9000000, 0x2c800000, 0xf6c00000, 0x87600000, 0x41500000, 0x94480000, 0xc9cc0000, 0x6b2e0000, 0xb44d0000, 0x9d6e8000, 0xf7edc000, 0xd05e2000, 0xd5753000, 0xf49a6800, 0xadb78c00, 0xee88da00, 0x0cac5500, 0xe97e7780, 0xdb84bbc0, 0x2fe2e520, 0xe5e34b50, 0x0ae2d2b8, 0xc362ab0c, 0x33226522, 0xbd838b51, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xb8000000, 0x0c000000, 0x46000000, 0x4f000000, 0x16800000, 0x6cc00000, 0xc1a00000, 0xa5500000, 0x58780000, 0xa1dc0000, 0x4e720000, 0xcc5d0000, 0xbe338000, 0x083dc000, 0xf3436000, 0x3754b000, 0xab877800, 0xfa0a3c00, 0x9b80e600, 0x67409100, 0xaee07f80, 0xdfb0b240, 0xbdc86520, 0xad158ab0, 0xb6e6c298, 0x46fa1c54, 0x1aa9e522, 0x60e54ab3, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xf8000000, 0xf4000000, 0x32000000, 0xdf000000, 0xff800000, 0x4fc00000, 0x3ce00000, 0x68d00000, 0x17180000, 0x6ee40000, 0x8fe20000, 0x1c650000, 0x50a28000, 0x88c4c000, 0x4f536000, 0x01ed3000, 0x757e8800, 0x3a735400, 0x18dc3600, 0x3a372b00, 0xfbcfe980, 0x86fa72c0, 0x3b81a820, 0x25c084f0, 0x07e099e8, 0xad50f134, 0x8bd92822, 0x6b8544f1, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x98000000, 0x54000000, 0xf6000000, 0xed000000, 0x95800000, 0x5bc00000, 0xa7a00000, 0x5a900000, 0x5c280000, 0x86d40000, 0x56560000, 0x78550000, 0x1d168000, 0x6db4c000, 0xd1e62000, 0x1badf000, 0x8b0a8800, 0x42461c00, 0xa73c5200, 0x4222b700, 0x5513a580, 0xc4ab9840, 0x24d600a0, 0x71157810, 0x43f7e908, 0x41c452bc, 0x3dbe80a2, 0x4b20b811, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0xf8000000, 0xd4000000, 0xfa000000, 0x21000000, 0x80800000, 0xb3c00000, 0xa2200000, 0x37f00000, 0x9f380000, 0x9ff40000, 0x602a0000, 0x90750000, 0x486b8000, 0xc014c000, 0x9efb6000, 0x813d3000, 0xdfe6c800, 0x2c2ac400, 0x0e758a00, 0x8b6b4500, 0xc594ad80, 0xafbb2140, 0x65ddd260, 0x30b64730, 0x1622b188, 0x2c183164, 0xf0845262, 0x08d38733, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xf8000000, 0xec000000, 0x92000000, 0xd3000000, 0x30800000, 0x34400000, 0xa1200000, 0xfc100000, 0xbff80000, 0xdf0c0000, 0x3e7a0000, 0xdb4d0000, 0xd75b8000, 0x435d4000, 0xbea32000, 0xc950b000, 0x1d58f800, 0x57dc9400, 0xbce2de00, 0x4d71b500, 0xd4c99680, 0xb9e44740, 0x6b0e96a0, 0x6bfaacb0, 0x3a8d76b8, 0x57baa544, 0x1fadb6a2, 0x0daa1cb3, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0xf8000000, 0x14000000, 0x96000000, 0x69000000, 0xc2800000, 0xf6400000, 0x01200000, 0xfc100000, 0x25080000, 0x7a340000, 0x95160000, 0x9a750000, 0xbd368000, 0x04e44000, 0x1e7e6000, 0x87f1b000, 0x63784800, 0xae8d9c00, 0xcd7a1a00, 0xfdfe5900, 0xbf309680, 0xc6196b40, 0x24bd66a0, 0x53e2dd50, 0x140238c8, 0x5873e67c, 0x9fcb06a2, 0xee276d51, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x58000000, 0x9c000000, 0x92000000, 0xfd000000, 0x89800000, 0xcb400000, 0x03200000, 0xd7100000, 0x4de80000, 0x5bc40000, 0x1d360000, 0xe2850000, 0x73168000, 0x34154000, 0xc1bf6000, 0x3af1f000, 0xf8985800, 0x731dd400, 0x6f8b2200, 0x1bdf8700, 0x53c0d480, 0xcbe0f140, 0x5e7062a0, 0x7258de90, 0xaf7d0728, 0x1dbabbfc, 0x2a2702a2, 0x3f6d2e91, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xf8000000, 0x4c000000, 0xee000000, 0x05000000, 0x36800000, 0x63400000, 0xa6200000, 0xd1300000, 0xb9a80000, 0xc2840000, 0x13ca0000, 0x43c50000, 0x7eeb8000, 0x5174c000, 0x7a83a000, 0xe2913000, 0xbc593800, 0x22cdec00, 0x8a1eb200, 0xf7374100, 0x65f2d480, 0x5f99bd40, 0x9ead0ee0, 0x2d8e4210, 0x5deea9e8, 0xd47e2c84, 0x9ba6aee2, 0x0cab7213, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x28000000, 0xec000000, 0x7a000000, 0xaf000000, 0xd9800000, 0xf6400000, 0x08200000, 0xec500000, 0xa9880000, 0xeb840000, 0x7fd20000, 0x7bc50000, 0xfaf28000, 0x15154000, 0xd2baa000, 0x11f11000, 0xa9997800, 0xd52ce400, 0x9986a600, 0x9fde1700, 0xf492ea80, 0xa9649740, 0x63638a20, 0xfdfdc050, 0x2ccecb28, 0x31bb80f4, 0xe2712a22, 0xf8d8d051, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xf8000000, 0x34000000, 0x6a000000, 0x57000000, 0x22800000, 0x4c400000, 0xb5e00000, 0x11100000, 0x44a80000, 0x42d40000, 0xbece0000, 0x51950000, 0x25af8000, 0xf2c44000, 0x99e76000, 0x2c81b000, 0x39410800, 0xac606400, 0x51d02600, 0x78096100, 0xa7a45e80, 0xefb7fac0, 0xf94914a0, 0x5fc42790, 0x04677f08, 0x5e417f0c, 0x16e074a2, 0xf9909793, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x68000000, 0x34000000, 0xb6000000, 0xab000000, 0x23800000, 0x91c00000, 0x01e00000, 0xe0f00000, 0xd4880000, 0x9ce40000, 0xcbe20000, 0xe2250000, 0xf7838000, 0x6c15c000, 0x476a6000, 0x42c11000, 0x4e600800, 0xfb317c00, 0x0c68de00, 0x2a95fb00, 0x322a1d80, 0x7b6028c0, 0xe7b03460, 0x98292dd0, 0x89b43ba8, 0xacbaed14, 0x5cd85462, 0xb33d3dd3, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x28000000, 0x34000000, 0xb6000000, 0xe1000000, 0x1f800000, 0x11400000, 0xe0600000, 0x15500000, 0x0e680000, 0x4e5c0000, 0x49fe0000, 0xe81d0000, 0xc71f8000, 0xbb8dc000, 0x5c572000, 0x9ee19000, 0xdb914800, 0x9f49fc00, 0xeb6d0a00, 0x7ac70300, 0x9c288880, 0x76bd13c0, 0xfb6f0a20, 0x6cd44310, 0xf3334498, 0xdc2ae7ec, 0x48ae2a22, 0xa074d313, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0xa8000000, 0xdc000000, 0xda000000, 0x27000000, 0xe5800000, 0xe7400000, 0x1ca00000, 0xb2700000, 0xb5780000, 0x21140000, 0xf7f60000, 0xeb550000, 0x41d78000, 0x67e4c000, 0x854f2000, 0x67219000, 0x4c309800, 0x25592400, 0xe0a55600, 0x09ef2f00, 0x9d513880, 0x7549c640, 0x764d2460, 0xec5238b0, 0xdd3ab848, 0x1cc7845c, 0xeb8c0462, 0xa632a8b3, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x08000000, 0x14000000, 0x22000000, 0xb1000000, 0xc8800000, 0xb5c00000, 0xc2600000, 0xc1900000, 0x26d80000, 0x5cb40000, 0x71e60000, 0xd2750000, 0xce068000, 0x14a5c000, 0x027ee000, 0xbd61d000, 0xa610c800, 0x8c989400, 0x48952a00, 0xa257c500, 0xbc1d2180, 0x915ad1c0, 0x655e4aa0, 0x6751b870, 0xdd3801c8, 0x8065a2bc, 0x109eaaa2, 0x85316871, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x98000000, 0x4c000000, 0x4a000000, 0x57000000, 0x34800000, 0x12400000, 0x18a00000, 0xfe300000, 0xc2e80000, 0xa4e40000, 0x47ee0000, 0xc3a50000, 0x48ce8000, 0xcd54c000, 0x35c6e000, 0x38a1f000, 0x6e307800, 0x8ae86400, 0x40e45600, 0xd9efcd00, 0x92a51280, 0x614e4c40, 0xbc95b6e0, 0x0ba73d90, 0xcc716128, 0x4a49434c, 0x12d556e2, 0x6107cd91, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x08000000, 0xdc000000, 0xee000000, 0x73000000, 0xdc800000, 0x00c00000, 0x7d600000, 0x65f00000, 0x06280000, 0xca040000, 0xc6520000, 0x9bc50000, 0x42b28000, 0xe575c000, 0x27bb6000, 0xa221d000, 0x8cd0d800, 0xa2790c00, 0xcabcbe00, 0x148e7500, 0x913a5f80, 0x3be11fc0, 0xf4306c60, 0xa2c86f90, 0x24b4ae68, 0x5b5ad234, 0x08910c62, 0xdbd8bf91, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0xf8000000, 0x04000000, 0xee000000, 0x31000000, 0xe9800000, 0xa1c00000, 0x55a00000, 0xad300000, 0x73480000, 0xaca40000, 0xd1460000, 0x44e50000, 0xb5278000, 0x1474c000, 0x275ee000, 0xd9993000, 0x81bce800, 0x7abbec00, 0x093e0a00, 0xc6097f00, 0x63456980, 0xb3160440, 0x49bdebe0, 0x46bbe6d0, 0x033e54a8, 0xa909b15c, 0x43c48be2, 0xff5616d3, 
    0x80000000, 0x40000000, 0x20000000, 0xb0000000, 0x98000000, 0x4c000000, 0x2a000000, 0x49000000, 0xe5800000, 0xe9c00000, 0x4ce00000, 0x17300000, 0x22580000, 0xe11c0000, 0x510e0000, 0x9d5d0000, 0x0c2e8000, 0x1a8d4000, 0x3b47e000, 0x44c87000, 0x08d57800, 0x025b2400, 0x79c66a00, 0x0f892f00, 0xdf751980, 0xcaca26c0, 0xf70e3fe0, 0x9e5d3e70, 0x30ae33d8, 0x3ecc996c, 0x4a675fe2, 0x79180e71, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x78000000, 0x0c000000, 0xd6000000, 0xb3000000, 0x81800000, 0xa9400000, 0x89a00000, 0x13b00000, 0xefc80000, 0xe4bc0000, 0x57d20000, 0x3c7d0000, 0x1f338000, 0x726c4000, 0xe94a2000, 0x6418b000, 0x64a43800, 0xf1761c00, 0xd40bde00, 0x87b8df00, 0x1a14ec80, 0x883f5c40, 0xba7643e0, 0x998ba7d0, 0x58f8c898, 0xf0b5c974, 0x620fe3e2, 0xf0ff57d3, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x78000000, 0x54000000, 0xba000000, 0x19000000, 0xae800000, 0x05c00000, 0x87e00000, 0x01b00000, 0xb1d80000, 0xcb140000, 0xe4ea0000, 0x08550000, 0x0aca8000, 0x8004c000, 0x89a3a000, 0x35483000, 0x591d0800, 0xe1d64400, 0xc4d2ba00, 0x75f15900, 0xb279d180, 0x6105c6c0, 0x3323eae0, 0x6a886970, 0x57fcc2c8, 0x36e723a4, 0x24cacae2, 0x83049971, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x38000000, 0xac000000, 0x02000000, 0xc3000000, 0x22800000, 0xbc400000, 0xa4600000, 0xa4500000, 0x65d80000, 0x576c0000, 0x97de0000, 0x25ad0000, 0x2dff8000, 0xd69dc000, 0xa6f72000, 0xcc69b000, 0x6c247800, 0x1b4ab400, 0xe02f7e00, 0x2984b100, 0x1fbae680, 0x668669c0, 0x5381e620, 0xf5c1ae70, 0xcea1a2f8, 0x4271fecc, 0x9ce94622, 0xdb65de73, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xf8000000, 0x24000000, 0x96000000, 0xd9000000, 0x6c800000, 0x31400000, 0xf0a00000, 0x7f100000, 0x70080000, 0xedcc0000, 0x9e360000, 0x060d0000, 0x16d78000, 0xbd3c4000, 0x5c8f2000, 0xbe59b000, 0xad656800, 0xaceb9c00, 0xb8325a00, 0x05168500, 0x11dc5880, 0x71be7440, 0x2d003ea0, 0xc2814050, 0x6c409338, 0x5a204b3c, 0x6f509ea2, 0xc828b053, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x88000000, 0x7c000000, 0x06000000, 0xd1000000, 0x9d800000, 0x0c400000, 0x76a00000, 0x8db00000, 0x90180000, 0x445c0000, 0x805e0000, 0xdf9d0000, 0x45be8000, 0x040c4000, 0xf7d7e000, 0x8fa95000, 0x2f451800, 0x16825c00, 0x5b033a00, 0x8f43a700, 0x1de38280, 0xd2527a40, 0x614a11e0, 0x1396be70, 0xd509cf58, 0x3cf42bcc, 0x139b71e2, 0x70dfae71, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x88000000, 0x8c000000, 0x1a000000, 0x73000000, 0x3b800000, 0x8a400000, 0xbee00000, 0xb2900000, 0x70780000, 0x061c0000, 0xc41a0000, 0x69dd0000, 0xb5ba8000, 0x472cc000, 0xad93a000, 0x3a69d000, 0x7fa4b800, 0x82a6e400, 0x2fb7de00, 0x738ed300, 0x5a72aa80, 0xf0785ec0, 0x461de7a0, 0x241b0230, 0xf9dc6198, 0x3dba4f04, 0xcb2cc7a2, 0xb7921231, 
    0x80000000, 0xc0000000, 0x60000000, 0xf0000000, 0x68000000, 0xec000000, 0x22000000, 0xb1000000, 0x96800000, 0xb3c00000, 0x71a00000, 0x67f00000, 0x9d480000, 0x11a40000, 0x04220000, 0x65e50000, 0x60c38000, 0xc875c000, 0xf7da6000, 0x69691000, 0x2215b800, 0xad8a5400, 0x21d05a00, 0x87f83900, 0xaa8d1d80, 0x3dd66a40, 0x607f1a60, 0x424bacd0, 0xba718f28, 0x2d081394, 0x1b44fa62, 0xaab27cd3, 
    0x80000000, 0x40000000, 0xe0000000, 0x50000000, 0x78000000, 0x34000000, 0xc6000000, 0x9d000000, 0xbd800000, 0xf3c00000, 0x7f600000, 0x8cb00000, 0x76f80000, 0xa5f40000, 0x02be0000, 0x06b50000, 0xbb9e8000, 0xfaa4c000, 0xe4b62000, 0xb2183000, 0xe7844800, 0x06a6bc00, 0xf430f200, 0xfcb88700, 0x27557580, 0x706ea9c0, 0xcb7c34e0, 0xf4538030, 0xc40ef908, 0xbf4c0c4c, 0x48ea94e2, 0x035a7031, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x28000000, 0xe4000000, 0x0a000000, 0x1f000000, 0xb4800000, 0xf5400000, 0x6e600000, 0xe8b00000, 0x46980000, 0x507c0000, 0x5c0e0000, 0x06bd0000, 0xe7af8000, 0xe72dc000, 0x24e62000, 0x6bf99000, 0x6a4de800, 0xaed68400, 0x61215600, 0xc1d0ad00, 0x66a8dc80, 0xf5a401c0, 0xbb1255e0, 0xf783f0f0, 0xf34a0f18, 0x605e97ec, 0x58d5f5e2, 0x7caaa0f3, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x08000000, 0xac000000, 0xfa000000, 0x13000000, 0x26800000, 0x7f400000, 0xe3200000, 0xed300000, 0x3a380000, 0x83440000, 0xd4ea0000, 0xe5850000, 0xd40a8000, 0xa7d54000, 0x16a32000, 0x84d95000, 0x34147800, 0x21c3a400, 0xf849de00, 0x125d2900, 0x369fc080, 0x2156df40, 0xa9ca92e0, 0x2db56730, 0xd1b2b668, 0xb650cde4, 0xdca932e2, 0x460c7731, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x98000000, 0xa4000000, 0x2a000000, 0x97000000, 0x2c800000, 0x2f400000, 0x60200000, 0x79100000, 0x8c880000, 0xd49c0000, 0xc0e60000, 0xbc5d0000, 0xcd068000, 0xe72c4000, 0x0b3e6000, 0xf9e97000, 0x52ad2800, 0xf5fe2400, 0xad098600, 0x385dbd00, 0xd7077880, 0x482d2d40, 0xf3be32a0, 0x64a88850, 0x018d3198, 0x8a6f069c, 0x99c0d2a2, 0xa060b851, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0xa8000000, 0x24000000, 0x02000000, 0xc3000000, 0x0f800000, 0xe2c00000, 0xd6e00000, 0x60d00000, 0x19480000, 0xd4f40000, 0x81aa0000, 0x78b50000, 0x390a8000, 0x03c54000, 0xe4b3a000, 0xd0481000, 0xec75e800, 0xe6eb1400, 0x3b95ee00, 0x2abbcb00, 0x7f9d4b80, 0xf26e16c0, 0xc4069220, 0xd5436850, 0xf1b039c8, 0x4f58b204, 0x015db222, 0xea8f3851, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xa8000000, 0xf4000000, 0xce000000, 0xdb000000, 0x9b800000, 0xd4400000, 0x41600000, 0x01500000, 0x8da80000, 0x637c0000, 0x1ebe0000, 0xa9bd0000, 0x131e8000, 0xda4d4000, 0x00c6e000, 0xc9a81000, 0x457d0800, 0x11be8c00, 0xcc3d3e00, 0xb45f7b00, 0xf4acb680, 0x1bd6c9c0, 0xde600c20, 0xbcd1a690, 0x56e9e0d8, 0x479d9aec, 0xb8ae6c22, 0x0af5f691, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x38000000, 0x84000000, 0x9a000000, 0x13000000, 0xf4800000, 0xe9400000, 0xd8200000, 0x71500000, 0xd2a80000, 0xa7340000, 0x000e0000, 0x6bf50000, 0x82ee8000, 0x9d44c000, 0x1777a000, 0x1728b000, 0x6df4a800, 0xbfee8400, 0xa8c50e00, 0x35b62d00, 0xf4c83c80, 0x20c4cd40, 0xb9b6a620, 0xa2c8d410, 0x85c5ba48, 0x7836fb0c, 0xb2098622, 0xc925a411, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xb8000000, 0xd4000000, 0x56000000, 0x3f000000, 0xe2800000, 0x34400000, 0xa4200000, 0xb1f00000, 0x52880000, 0xd75c0000, 0x750e0000, 0xb37d0000, 0xa4fe8000, 0x91f54000, 0x9ba22000, 0x88fa3000, 0xaade8800, 0x45041c00, 0xe6abb600, 0x0867f900, 0xfe31ee80, 0xb7683940, 0x584c9160, 0xd4172a50, 0xf278c6d8, 0xec552ecc, 0x52921962, 0x81133651, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x78000000, 0xb4000000, 0xa6000000, 0xf1000000, 0xfe800000, 0xa4c00000, 0x1aa00000, 0x0dd00000, 0xa2a80000, 0x5e0c0000, 0x94020000, 0x24ad0000, 0x29d38000, 0x1e04c000, 0xb3df6000, 0x54063000, 0xd2730800, 0x2554fc00, 0x99b62a00, 0x72aa6100, 0x64a15380, 0x18d15c40, 0x1229b420, 0xb7cc3310, 0x1a226938, 0x6ebdc894, 0x385abc22, 0xe698cf13, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xc8000000, 0xac000000, 0x4a000000, 0x09000000, 0x5f800000, 0x7e400000, 0x5fa00000, 0x12700000, 0x1dc80000, 0x10540000, 0x57860000, 0x5ff50000, 0xcdf68000, 0x4e3c4000, 0x07a3a000, 0xd8bbd000, 0xabd7f800, 0x210dc400, 0xb34baa00, 0x6b5edb00, 0x08788680, 0x8f7d9c40, 0x6c836660, 0x7e0b0dd0, 0xda7f1dc8, 0x6fc9645c, 0x0d549e62, 0x1606c9d1, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x28000000, 0xc4000000, 0x5a000000, 0xb1000000, 0xbd800000, 0xadc00000, 0x2c600000, 0x6af00000, 0xf2180000, 0x07c40000, 0x3b5a0000, 0x19a50000, 0x04ab8000, 0x5c3cc000, 0x87aee000, 0x1a869000, 0xc73a6800, 0x2b55a400, 0xfab3ca00, 0x75f83f00, 0x7ff50180, 0xcba38fc0, 0x89d1b060, 0x47c8c1f0, 0x860dd0e8, 0x5a563ec4, 0x6173d862, 0xb69965f3, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0xb8000000, 0xbc000000, 0xca000000, 0x91000000, 0x96800000, 0x33c00000, 0x18600000, 0x8b100000, 0xfce80000, 0xefc40000, 0x6e220000, 0xd5a50000, 0x30328000, 0x69cc4000, 0x67372000, 0xa00f3000, 0x20c35800, 0x8d742400, 0xa4ba3a00, 0x65182900, 0xf1fc6d80, 0xec6fc1c0, 0x25d21fa0, 0x369ca210, 0x56fe1928, 0x877a2bd4, 0x257947a2, 0xb6ec8611, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x48000000, 0x24000000, 0x6e000000, 0xdf000000, 0xab800000, 0xe6400000, 0xe4200000, 0xcd100000, 0x52180000, 0x0d5c0000, 0xd8060000, 0xb67d0000, 0x7e978000, 0xe224c000, 0x47ea2000, 0xbf325000, 0x878f6800, 0xa2f90c00, 0x62ac1600, 0xf8ef7b00, 0x45480a80, 0x79651b40, 0x6d4abca0, 0xf6e3f970, 0x1f76b518, 0xc9554ffc, 0xb2c3d4a2, 0x2267f573, 
    0x80000000, 0x40000000, 0xe0000000, 0x10000000, 0xa8000000, 0x04000000, 0x86000000, 0x95000000, 0xd8800000, 0x1bc00000, 0x48200000, 0xe5b00000, 0x0f780000, 0x8d4c0000, 0xb87a0000, 0x806d0000, 0x8d4a8000, 0x60d4c000, 0x7626a000, 0x041f9000, 0xa3b3a800, 0x0cd81c00, 0x7ebc4200, 0xdc620d00, 0xab716580, 0x3fd9f540, 0x833c12e0, 0x472339b0, 0x44902d78, 0xb848f0c4, 0x7ef5bae2, 0x0e9625b1, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x48000000, 0x9c000000, 0x4a000000, 0x49000000, 0x3a800000, 0x8bc00000, 0x8d600000, 0x9cf00000, 0xed780000, 0x83240000, 0xc1560000, 0x5f450000, 0x73278000, 0xcffd4000, 0xae622000, 0xa9dbd000, 0x311e1800, 0x1578c400, 0x6725ca00, 0xaf579100, 0x58448d80, 0x9ea7d3c0, 0xe1bc5060, 0x91429330, 0x400a1f28, 0x7cb6381c, 0xe1744862, 0xd9bf5733, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x58000000, 0x3c000000, 0xaa000000, 0xe5000000, 0x03800000, 0x05400000, 0xce200000, 0x2e300000, 0x0bb80000, 0xda9c0000, 0xd35a0000, 0x2dbd0000, 0xe4eb8000, 0xfe45c000, 0xbfd76000, 0xf46f7000, 0x8ef21800, 0x4da9a400, 0x48141200, 0xc8ffc300, 0xa0bae880, 0x506c8740, 0x4283f0e0, 0xcab03230, 0x4c79fed8, 0xe47c2804, 0x090be8e2, 0x78949633, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x78000000, 0xa4000000, 0x62000000, 0x75000000, 0x56800000, 0xce400000, 0xa7e00000, 0x17900000, 0x37e80000, 0xc39c0000, 0xef960000, 0x857d0000, 0x04868000, 0x25d44000, 0xd87a2000, 0xd892b000, 0x288e6800, 0x87d8f400, 0x9f04c200, 0x31f37900, 0xe55f6e80, 0xfdd11ec0, 0xb20915a0, 0x010c4310, 0xdefe2398, 0xf0a176bc, 0xe8f17da2, 0xd539b711, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x48000000, 0x2c000000, 0xc2000000, 0x63000000, 0xad800000, 0xb6400000, 0x01200000, 0x6a700000, 0x24c80000, 0x51140000, 0x46ca0000, 0xd7350000, 0x2f3a8000, 0x04bcc000, 0x418f6000, 0x7bc65000, 0x29123800, 0xacb95400, 0x46dc3e00, 0xe25e6f00, 0xb3bf8280, 0x5f2f9540, 0xccf6e260, 0x6d7bf2d0, 0x139db748, 0x0efe99c4, 0x8f8eda62, 0x8ac7a6d1, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x78000000, 0x64000000, 0xc6000000, 0x3f000000, 0x2c800000, 0xa8c00000, 0x46200000, 0x0d700000, 0xfd780000, 0x3dcc0000, 0xc0760000, 0xc8ed0000, 0xcb868000, 0xd8544000, 0xb1ebe000, 0x1012b000, 0x1d1e2800, 0xef49bc00, 0x24d41600, 0x312b0500, 0x5a337780, 0x7a6ee140, 0xf730b160, 0xa8987db0, 0x8c1dc7f8, 0x6fbea6dc, 0x7ef89962, 0x318cc1b1, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x38000000, 0xd4000000, 0xc6000000, 0xc1000000, 0x74800000, 0xb6c00000, 0x5ba00000, 0x75b00000, 0xf3380000, 0xe1340000, 0x6d660000, 0x7d950000, 0xcd568000, 0x7ced4000, 0xe902a000, 0xd39b3000, 0x001e0800, 0x0bc03c00, 0x4520ca00, 0x30717500, 0xcb191780, 0xafc40a40, 0xd3be20e0, 0xc270b630, 0xbc19af88, 0x12444f7c, 0xedfe28e2, 0x05118a31, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xf8000000, 0x5c000000, 0x5a000000, 0x99000000, 0xa8800000, 0x49400000, 0x37600000, 0x8fd00000, 0xa0780000, 0x747c0000, 0x66860000, 0x481d0000, 0x1cd78000, 0xdfa44000, 0x5d8b6000, 0x9413b000, 0xddfed800, 0xe1e08400, 0x9991aa00, 0x5c99b500, 0xf36c0880, 0xe85ec3c0, 0x9191b320, 0x38987930, 0x556c46d8, 0x5b5ec0bc, 0x58116b22, 0x8559fd33, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xb8000000, 0xd4000000, 0x2e000000, 0xa5000000, 0x1a800000, 0xdac00000, 0xc0e00000, 0x40b00000, 0x84b80000, 0x4fb40000, 0xde3a0000, 0x40550000, 0x470b8000, 0xedad4000, 0xc21fe000, 0x5a063000, 0xed234800, 0x78f1ec00, 0xaa994200, 0xf1e53900, 0x37324780, 0xfdd830c0, 0xf6440ae0, 0x3823ebb0, 0x3a71b488, 0xb4584444, 0x970542e2, 0xbe8307b3, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x68000000, 0xa4000000, 0x9a000000, 0x5d000000, 0x66800000, 0xb9c00000, 0x89a00000, 0x58500000, 0x4a180000, 0x703c0000, 0x60620000, 0x1f1d0000, 0xc1f28000, 0xfca54000, 0x199f6000, 0xbedf9000, 0xd2bf2800, 0x854e2400, 0x6c07d200, 0x3ba30900, 0x97bc7180, 0x79225240, 0xf47d7520, 0x8d823c70, 0x3aacb858, 0x165b5f34, 0x6730dd22, 0xb4695871, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0x88000000, 0xfc000000, 0x32000000, 0x65000000, 0x49800000, 0x25400000, 0x96e00000, 0xdc500000, 0x53280000, 0x950c0000, 0x57120000, 0x766d0000, 0xbc028000, 0x46a5c000, 0xc4df6000, 0x13ded000, 0x7f5f9800, 0x739e3400, 0x303f9200, 0xf28f4700, 0x81f6c880, 0x75d392c0, 0xd2cd1420, 0xba32fe90, 0x551c2d38, 0x395ada34, 0x67700c22, 0xe3590a91, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x88000000, 0x14000000, 0x06000000, 0x23000000, 0xc2800000, 0xe3400000, 0x7f200000, 0xaf300000, 0xa3d80000, 0xcb840000, 0x45260000, 0xc2250000, 0x5f578000, 0x95dd4000, 0x7d62a000, 0x1e625000, 0x3ce38800, 0x6fa3dc00, 0x08838e00, 0x3bb37900, 0x8a6b5880, 0x64efaf40, 0xc0480ae0, 0x23adaef0, 0xe09a98e8, 0xa556223c, 0xd4dc02e2, 0xa2e332f3, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x98000000, 0x6c000000, 0x8a000000, 0x5b000000, 0x23800000, 0x88c00000, 0xb1a00000, 0x33f00000, 0xd9c80000, 0x56340000, 0xdc920000, 0xd8150000, 0x35a28000, 0x677cc000, 0x09e76000, 0x29e7f000, 0x79e6b800, 0xf1e66400, 0xf5e7ce00, 0x8be7c300, 0x36e7ef80, 0xc4667840, 0x34269c60, 0x2ec77dd0, 0x24567708, 0x7fcfd574, 0xc3c2a462, 0x90add9d1, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x88000000, 0xb4000000, 0x6e000000, 0x3f000000, 0x83800000, 0xccc00000, 0x97600000, 0xab300000, 0x14780000, 0xcf540000, 0xae120000, 0x25b50000, 0x6ee28000, 0x492dc000, 0xa446e000, 0x0926d000, 0x83168800, 0xc3ee8c00, 0xc7fa3600, 0xd449eb00, 0x46adbf80, 0x7a862dc0, 0x1b4775e0, 0xcaa75b30, 0x2fd6dc48, 0x648f4694, 0xe4cb7de2, 0x74301731, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xb8000000, 0x34000000, 0xa2000000, 0xfb000000, 0x29800000, 0x89c00000, 0x3d600000, 0x40500000, 0x6f480000, 0x05940000, 0xb6c20000, 0xaa750000, 0xb6d38000, 0x019d4000, 0x26772000, 0x14463000, 0x70de4800, 0x48c2f400, 0xbf75fe00, 0xd2530700, 0xa8dc1d80, 0xf85755c0, 0xfd377920, 0x49660d50, 0xa42ec908, 0x0abb7754, 0x2df8b122, 0x3a4cb953, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0xc8000000, 0x6c000000, 0xba000000, 0x8f000000, 0xcb800000, 0x64c00000, 0xae600000, 0x6c500000, 0x63980000, 0x1df40000, 0xf5ba0000, 0xfb150000, 0xbcab8000, 0xe52d4000, 0xdcee2000, 0x659ed000, 0xaef7f800, 0xa3aa2400, 0x06aca600, 0x242f1300, 0x69fe7f80, 0xe9a7d7c0, 0xddb3f320, 0x4a99def0, 0x3b7427c8, 0x51fa9804, 0xfc358b22, 0xe75bbaf3, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x18000000, 0x54000000, 0xaa000000, 0x71000000, 0xf1800000, 0x73400000, 0xa7e00000, 0x23100000, 0x41080000, 0xa9a40000, 0xbd7a0000, 0x92c50000, 0xbaaa8000, 0x686cc000, 0x6d7f2000, 0x5ccef000, 0x66368800, 0xaf0b2400, 0x951daa00, 0xd0266700, 0x3d83fc80, 0x92f940c0, 0x153ccea0, 0x3c1750d0, 0x1a3b36e8, 0xdf2448a4, 0x08bac6a2, 0x08e5b4d1, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0x2c000000, 0x6a000000, 0x87000000, 0x0c800000, 0x28c00000, 0xd8200000, 0x26900000, 0x2fe80000, 0xaa040000, 0x7d520000, 0x23a50000, 0xf0828000, 0xa42d4000, 0xdaf6a000, 0xbd27f000, 0xfdaff800, 0xfb5ba400, 0xda90b600, 0x7de89d00, 0x3105d780, 0x53d3b540, 0xf8642ea0, 0x6222f490, 0x477dcba8, 0xa6bef3b4, 0x15f356a2, 0x5ff51091, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x18000000, 0xc4000000, 0xfa000000, 0x8b000000, 0x26800000, 0xdec00000, 0x65e00000, 0xd6700000, 0x98580000, 0xc3840000, 0x23e60000, 0xa5e50000, 0x24d68000, 0x4f1c4000, 0x4682a000, 0x0af27000, 0xe9aa2800, 0xa4af0400, 0x95887e00, 0x738c6900, 0x342a7380, 0xb4efeac0, 0x42a8cb60, 0xf61d1c70, 0xd7025968, 0x7cb24a3c, 0x2b8a6362, 0x66bf5871, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0xd8000000, 0xfc000000, 0xde000000, 0x6d000000, 0xd2800000, 0x6a400000, 0x2b200000, 0x64d00000, 0xaa380000, 0x15340000, 0xfd3a0000, 0xfb950000, 0x2e2a8000, 0x514d4000, 0xb12ea000, 0x297ef000, 0x2c065800, 0xd493cc00, 0xcd38c200, 0x20b54900, 0xe2fa2680, 0xef752740, 0x4e1bb320, 0x43457930, 0x4a125448, 0xf179a3c4, 0x62956b22, 0x66aaf531, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x88000000, 0x14000000, 0x4a000000, 0xab000000, 0x81800000, 0x46400000, 0x7d600000, 0xb5500000, 0x65480000, 0xf3140000, 0xa74e0000, 0x00350000, 0x1b7f8000, 0x0a2c4000, 0x9e23e000, 0x43f75000, 0x2118c800, 0xc4dd4400, 0xaf9a5e00, 0xf25be700, 0xba7a6280, 0xffca85c0, 0x8f938420, 0x19aed550, 0x8c259b08, 0x68d6fe4c, 0x9128ac22, 0x28c4c153, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x78000000, 0xdc000000, 0x96000000, 0xc7000000, 0xf6800000, 0x35c00000, 0xcb200000, 0x92900000, 0xf6080000, 0x24540000, 0x55f60000, 0xd6b50000, 0xb2468000, 0xc12c4000, 0x149be000, 0x704eb000, 0x27795800, 0x146c1c00, 0x6d7a1600, 0x7f7e5100, 0xc6212d80, 0x75112f40, 0x5249cca0, 0x9c358950, 0x4187a308, 0xa50d2e3c, 0x648b74a2, 0x81872551, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xa8000000, 0x84000000, 0x2e000000, 0x05000000, 0xf7800000, 0xeb400000, 0x94200000, 0x1db00000, 0xb5380000, 0xece40000, 0x536a0000, 0x1f850000, 0x40fb8000, 0xc40cc000, 0xd7a7a000, 0x65439000, 0x4b29a800, 0x6f2d4c00, 0x7e96e200, 0xadbbc300, 0x112d0480, 0xf397d340, 0x2e3b5be0, 0x6c6c5730, 0x4eb7c328, 0x6e0a8664, 0x191553e2, 0xc4f28b33, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xf8000000, 0x94000000, 0x4a000000, 0x1d000000, 0x6c800000, 0x61400000, 0x25200000, 0xc1900000, 0xe4b80000, 0x28a40000, 0x77960000, 0x5ec50000, 0x5a268000, 0xfd6c4000, 0x7a7ba000, 0x13ffb000, 0x67f98800, 0x9c84a400, 0x34877200, 0xe43d9d00, 0x4a22a080, 0x98ab6f40, 0xd3674fa0, 0xf44c5030, 0xc5ea01e8, 0x3047aa9c, 0xc6dd67a2, 0x72d34431, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x38000000, 0xb4000000, 0xde000000, 0xa7000000, 0x94800000, 0x44c00000, 0xd0a00000, 0x9b900000, 0x2f380000, 0xf6240000, 0x0a120000, 0x88450000, 0xf8238000, 0xef6cc000, 0xa17f2000, 0xbf3ab000, 0xdc194800, 0xa5f58c00, 0xb54b4600, 0x83514500, 0x6d995f80, 0x40b59c40, 0x98abeca0, 0x3120e830, 0x46d193e8, 0xb6d91e94, 0x9a5584a2, 0x865bd433, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x18000000, 0xb4000000, 0x26000000, 0x0b000000, 0x5e800000, 0x31c00000, 0x99600000, 0xa5700000, 0x3b480000, 0x8dd40000, 0x864a0000, 0xef750000, 0xc35b8000, 0x52cd4000, 0x79876000, 0x03737000, 0x8f690800, 0x0505bc00, 0x5893de00, 0x71d92100, 0x6e2cad80, 0x6bb6ebc0, 0x049a9360, 0x68ad5f50, 0x0e7627c8, 0xebfbc744, 0xaedcfb62, 0xc7bf9353, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x78000000, 0x9c000000, 0x26000000, 0xb3000000, 0x49800000, 0x55400000, 0x23600000, 0xbd500000, 0xed780000, 0x8ba40000, 0x92920000, 0xb6850000, 0x99228000, 0xb5ed4000, 0xbf9f2000, 0x200bb000, 0xbfb11800, 0x81687c00, 0x0fbdbe00, 0x99678f00, 0xd7ef0480, 0x02c221c0, 0x5d7d3a20, 0xd8470930, 0x4a5e4468, 0x3aabfb94, 0x06410222, 0xdae1c531, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x18000000, 0x2c000000, 0x52000000, 0xff000000, 0xb6800000, 0xd0c00000, 0x73200000, 0x18500000, 0x1cb80000, 0xeddc0000, 0x719a0000, 0x793d0000, 0x386b8000, 0x2315c000, 0x9f2ea000, 0xda83f000, 0x9371f800, 0x78e9d400, 0xdb644600, 0xdf46d900, 0xf4273780, 0x4297f740, 0x8cde8b20, 0x8bab2c30, 0x9cb47798, 0x6cbf9584, 0xf59bd322, 0x2f3c0833, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0x94000000, 0x3a000000, 0xcb000000, 0x9c800000, 0x43c00000, 0x96e00000, 0x1e700000, 0x73f80000, 0x3b8c0000, 0xd10a0000, 0xddad0000, 0x091a8000, 0x15e5c000, 0x828ee000, 0xa4939000, 0x7d90c800, 0x38086400, 0xb0341e00, 0x15277d00, 0x8af76980, 0xd65ec8c0, 0x64ba1960, 0x8cb44530, 0x46e78578, 0x641637a4, 0x442e3162, 0x9142b131, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x98000000, 0xd4000000, 0x62000000, 0x8b000000, 0xaf800000, 0x86400000, 0xd2200000, 0x63b00000, 0xa8b80000, 0xd83c0000, 0xe01a0000, 0xc55d0000, 0xc50b8000, 0xcf94c000, 0x3deea000, 0x6823f000, 0xeea00800, 0x5e71b400, 0x7ed85e00, 0x72ad8b00, 0x1c928280, 0xe7989740, 0x4d0d99e0, 0x02637c30, 0x3a810498, 0x3cc08984, 0x2ee131e2, 0xad503833, 
    0x80000000, 0xc0000000, 0x20000000, 0x10000000, 0x78000000, 0x8c000000, 0x2a000000, 0x25000000, 0x7b800000, 0xdec00000, 0xe7e00000, 0x4db00000, 0x62080000, 0xa2340000, 0xed560000, 0xe0150000, 0x7f878000, 0x45ed4000, 0xc81ba000, 0x7d9fb000, 0x5fc1b800, 0xa2616400, 0x20713200, 0x99687300, 0x9bc41f80, 0x6bfe74c0, 0x39b038e0, 0x040836d0, 0x8d34d588, 0xa3d74cfc, 0x3d5420e2, 0xcaa7e2d3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x48000000, 0xbc000000, 0xb6000000, 0x19000000, 0xef800000, 0x54400000, 0x61a00000, 0xdd900000, 0x20a80000, 0x944c0000, 0xb28a0000, 0xcaad0000, 0x2a3b8000, 0x3754c000, 0x07bf2000, 0xf1625000, 0xfdc15800, 0x14e1bc00, 0x17b02a00, 0xbb788300, 0x8e457280, 0x07d70840, 0x4c4f4da0, 0xb7bbef10, 0xa814a438, 0x329faf84, 0xd43335a2, 0xe0090313, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x98000000, 0x7c000000, 0xa2000000, 0x05000000, 0x3a800000, 0xe6c00000, 0x46a00000, 0x98b00000, 0xe6b80000, 0x1c0c0000, 0x5b4a0000, 0x2eed0000, 0x679a8000, 0x98444000, 0xca9f6000, 0xe23b7000, 0xa1749800, 0xf767b400, 0x91d75200, 0x606e6100, 0x7be2cf80, 0x70e86440, 0xc464a2e0, 0x04ee5730, 0x7a22ddf8, 0xa9c93d24, 0x7095dae2, 0xda36d331, 
    0x80000000, 0xc0000000, 0x60000000, 0x50000000, 0x88000000, 0x3c000000, 0x2a000000, 0xf5000000, 0xf4800000, 0xde400000, 0xffe00000, 0xab100000, 0xe8a80000, 0xe7040000, 0x68b20000, 0x1e250000, 0xe0038000, 0x5b7dc000, 0x423f2000, 0xa322d000, 0xcecc5800, 0x9fe60400, 0x7d5ef200, 0x00728d00, 0x66857e80, 0x8273dac0, 0x5f8524a0, 0xe4f26590, 0x90c431a8, 0x7193a574, 0x0695dca2, 0x4d5b7193, 
    0x80000000, 0x40000000, 0x20000000, 0xf0000000, 0x98000000, 0xb4000000, 0x86000000, 0x75000000, 0x95800000, 0x97c00000, 0x77200000, 0x2e700000, 0xd6780000, 0xbd6c0000, 0x345a0000, 0x940d0000, 0x10ca8000, 0x7c254000, 0xc32f6000, 0xcc2a7000, 0x1f750800, 0x3426fc00, 0x1dbf2200, 0x4b037700, 0xa6105d80, 0x31688140, 0xdf840560, 0x291f3bb0, 0xafb376b8, 0x9ec90b84, 0xf7b4ed62, 0x2186f7b1, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x08000000, 0xac000000, 0x26000000, 0x81000000, 0xac800000, 0xd7400000, 0x1a200000, 0x95300000, 0xe1280000, 0x6f6c0000, 0x40560000, 0x908d0000, 0x0d068000, 0xa035c000, 0xd232a000, 0xdb87d000, 0x8874f800, 0x21921c00, 0xaf77ba00, 0x0b3ca500, 0x406fa480, 0xc6f99940, 0x59957ae0, 0x41c22510, 0x154f3738, 0x8248063c, 0x8d7da2e2, 0xdece2911, 
    0x80000000, 0xc0000000, 0xa0000000, 0x10000000, 0x08000000, 0x34000000, 0x96000000, 0x63000000, 0xa6800000, 0x27400000, 0x02e00000, 0x4c100000, 0x3a080000, 0xf1dc0000, 0x7d3e0000, 0x58fd0000, 0x158f8000, 0xdf844000, 0x608ba000, 0xe24e5000, 0xe924c800, 0x30fbfc00, 0x9f16ce00, 0x8a10d100, 0x31083080, 0xd35d6cc0, 0xd47f0ca0, 0x051c82d0, 0x5d1ebc18, 0x37cd6f2c, 0x5637e4a2, 0x52a16ed3, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x38000000, 0xf4000000, 0xee000000, 0x59000000, 0xf5800000, 0x64400000, 0x1c600000, 0x6cb00000, 0x76f80000, 0xfa0c0000, 0x16760000, 0x7ead0000, 0xbf678000, 0xb0c5c000, 0xe942e000, 0xc9f7b000, 0x55ec0800, 0x9b86ec00, 0x13b5fa00, 0x869aa700, 0x42aa2280, 0xd39207c0, 0x2cbf4fe0, 0xd9994430, 0x4c3d82f8, 0x8c4ebb5c, 0x6f0027e2, 0x2880d833, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x68000000, 0xdc000000, 0x06000000, 0x9f000000, 0xca800000, 0x94400000, 0x79e00000, 0x16900000, 0x50180000, 0x5eb40000, 0xdb6e0000, 0xd2950000, 0xf0df8000, 0x00bcc000, 0x34826000, 0xf52e1000, 0x0274d800, 0x3bce9c00, 0x2265a600, 0xe9972900, 0x0231be80, 0x5ae8b2c0, 0xcefd27a0, 0x1462a0f0, 0x563ff1c8, 0xfcaccbac, 0xe0da1fa2, 0x4a7becf3, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x98000000, 0x14000000, 0x0a000000, 0x09000000, 0x3b800000, 0x0a400000, 0x04200000, 0x45700000, 0x8ad80000, 0x48dc0000, 0xe1520000, 0xe83d0000, 0x37c28000, 0x8ef5c000, 0xc4172000, 0x5c12f000, 0x249c0800, 0x62736400, 0x6dcc5a00, 0x41da7300, 0x61c8de80, 0x73556340, 0x4e276860, 0x976bf0f0, 0xf070dcd8, 0xa758b1d4, 0xad9cc062, 0x19f2a4f1, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xc8000000, 0xec000000, 0xfa000000, 0xff000000, 0x18800000, 0xecc00000, 0xd1200000, 0xb8300000, 0xc7080000, 0x236c0000, 0x44da0000, 0xcd0d0000, 0x378a8000, 0x4ed4c000, 0x3b7e6000, 0x6f1b5000, 0x60acb800, 0x957b2400, 0x2dfc0600, 0x8fa23500, 0xf488af80, 0x492ddf40, 0x703af3e0, 0xc99ddb50, 0x8bf23a38, 0x63d19a64, 0x2318abe2, 0xb7d46f51, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xc8000000, 0x64000000, 0xde000000, 0xc1000000, 0x6c800000, 0x30400000, 0x66a00000, 0xadb00000, 0x02280000, 0x2e340000, 0xd3460000, 0x9b550000, 0x5d968000, 0xf2ac4000, 0x08db6000, 0x75e7d000, 0xd6e4a800, 0x0fbfec00, 0xe498ea00, 0x779d9500, 0x54b3fa80, 0x94738040, 0x509315e0, 0xb0839a10, 0x549b2288, 0x49463d1c, 0x34545de2, 0x9816e611, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xa8000000, 0x4c000000, 0x66000000, 0x9d000000, 0x65800000, 0x79c00000, 0xda200000, 0x75300000, 0x1c780000, 0xdbdc0000, 0x3b0a0000, 0xcebd0000, 0x995b8000, 0xa7944000, 0x652f6000, 0x39ab1000, 0x17ccf800, 0x2ec35c00, 0xef590200, 0xf96c3700, 0xe1b34180, 0x6dc0cb40, 0x98213fe0, 0x6231a5b0, 0xf2f94958, 0xf29d6324, 0xb16b27e2, 0x7e6ca9b3, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x18000000, 0x3c000000, 0x6e000000, 0x49000000, 0x9c800000, 0x3d400000, 0x84a00000, 0x78900000, 0x5ed80000, 0x097c0000, 0x5a560000, 0xa31d0000, 0xbaa68000, 0x4a344000, 0xa773a000, 0x18767000, 0xa5ccd800, 0x475f2c00, 0x2d198a00, 0xd79c7500, 0xd3e7e080, 0xb494b440, 0x4ce275a0, 0xd92e27f0, 0x1671dc58, 0x1f6818dc, 0x9af58da2, 0x6e123bf1, 
    0x80000000, 0x40000000, 0xa0000000, 0x70000000, 0x18000000, 0xe4000000, 0xd2000000, 0x79000000, 0xe6800000, 0x0ac00000, 0x64600000, 0x70900000, 0x7ed80000, 0x21b40000, 0x89160000, 0x86950000, 0x4aa68000, 0xb1fc4000, 0x617a6000, 0x57b67000, 0x6a64a800, 0x70ee5400, 0x54919a00, 0x4cd83900, 0x88b45f80, 0x079789c0, 0x705492a0, 0x18c64270, 0x6a6c9ec8, 0x8023a0dc, 0x9a42daa2, 0x8dd32671, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x98000000, 0x2c000000, 0x02000000, 0x79000000, 0xf9800000, 0xd2400000, 0x4b200000, 0xdbb00000, 0x5cc80000, 0xd6040000, 0x45aa0000, 0x11b50000, 0xa3638000, 0x02b0c000, 0xf5496000, 0x0c44f000, 0xca8ab800, 0x7c043400, 0xa8ab2a00, 0x56353700, 0xe2223680, 0x7d109540, 0x2b392be0, 0xb2ecdbd0, 0x0c9e5168, 0x9517f5c4, 0xaab201e2, 0xf669ecd3, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x68000000, 0x8c000000, 0xe2000000, 0xe7000000, 0xc3800000, 0xac400000, 0x57200000, 0xb3700000, 0xe6d80000, 0x0b2c0000, 0xd2fa0000, 0x1c5d0000, 0xfa238000, 0x4271c000, 0x5459e000, 0xd5ec1000, 0x3b1b7800, 0x76cc1400, 0x1e6b5600, 0x21158300, 0x07c77680, 0x7d2e3940, 0xaa7bc660, 0x099c37f0, 0x624286b8, 0x3ba15b44, 0xc0b09062, 0xc7b9b4f3, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x98000000, 0x14000000, 0x22000000, 0x2b000000, 0x57800000, 0x48c00000, 0x7b600000, 0x77d00000, 0xee980000, 0xf49c0000, 0x53820000, 0x5f4d0000, 0x531a8000, 0x96d14000, 0x8e192000, 0x65dd7000, 0xad238800, 0x957c7400, 0xea12fe00, 0xcaf5ab00, 0x4677e780, 0xdcba29c0, 0x84607620, 0x62509ff0, 0x7d589898, 0x907d0134, 0xe0928822, 0xfcb534f1, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x98000000, 0x94000000, 0xf2000000, 0xf3000000, 0x3e800000, 0x9bc00000, 0x99e00000, 0x01d00000, 0x48a80000, 0x506c0000, 0xa7760000, 0x93bd0000, 0x24de8000, 0x7950c000, 0x82696000, 0x8c0cf000, 0xffe6c800, 0x2735d400, 0x79824e00, 0xa8df5900, 0x5f50b180, 0x63693ec0, 0xb18c3c20, 0xc2a69690, 0xb1145d78, 0x13b3eebc, 0x12a67222, 0x7915cf91, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xc8000000, 0x6c000000, 0x72000000, 0xbb000000, 0x26800000, 0x64400000, 0xba200000, 0xba100000, 0xa9380000, 0x34d40000, 0x13ee0000, 0x2cc50000, 0xf9d78000, 0x3a904000, 0x60786000, 0xad74d000, 0xd23f3800, 0x0e1c7400, 0xe3f22e00, 0x9636e900, 0x6a60de80, 0x46306940, 0x2e29c4a0, 0x266cb230, 0x08fb2388, 0x62ca04ac, 0x5ee3eaa2, 0x938e5b33, 
    0x80000000, 0x40000000, 0x20000000, 0x70000000, 0x08000000, 0x04000000, 0xaa000000, 0x1b000000, 0x39800000, 0x8bc00000, 0x01200000, 0x93d00000, 0x16380000, 0x59940000, 0x16060000, 0xc8450000, 0x2f3e8000, 0x2a514000, 0xddf86000, 0x78b45000, 0xf5d6e800, 0xd67c4400, 0x72aabe00, 0x96566700, 0x0ebc4180, 0x6e0aa140, 0x54479820, 0x0aa40a30, 0x99cf7a88, 0x75b88f7c, 0x81552622, 0x0aa66d31, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0x48000000, 0x74000000, 0x7a000000, 0x71000000, 0x54800000, 0x57400000, 0x49e00000, 0x42500000, 0xbcc80000, 0x76f40000, 0xb9160000, 0x4aa50000, 0x86df8000, 0x4dd14000, 0xb6086000, 0x20d4d000, 0x1be70800, 0xbedd6400, 0x5f338a00, 0x473b1d00, 0x5cef2c80, 0x0a886ac0, 0x3394e220, 0x40062e50, 0x098c1348, 0x857baebc, 0x638f6822, 0x82993353, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x68000000, 0xb4000000, 0x62000000, 0xe3000000, 0xac800000, 0x8cc00000, 0x0ae00000, 0xe0d00000, 0x7bc80000, 0x70940000, 0x41f20000, 0x1e450000, 0x373a8000, 0x3f504000, 0x7388a000, 0xe2b59000, 0xd9c34800, 0x0e5d1400, 0x24e62e00, 0xe0f7dd00, 0xc5df7f80, 0x879b5cc0, 0x26a15020, 0x38f11650, 0x14f83e88, 0xbe0c7174, 0x55ef7e22, 0xd382cb51, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0x18000000, 0x54000000, 0xf2000000, 0xb7000000, 0xe7800000, 0x14c00000, 0xaaa00000, 0x21b00000, 0x2e680000, 0x9d3c0000, 0xc2460000, 0x8b8d0000, 0x4bae8000, 0x22714000, 0x73482000, 0x904c7000, 0x428e0800, 0xdd00d400, 0x44814600, 0x21406b00, 0x5961e780, 0x7490aa40, 0x4f18c2e0, 0xebf4ed90, 0xc9ca1718, 0x8023175c, 0x49df84e2, 0x01398691, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x18000000, 0xf4000000, 0xca000000, 0xed000000, 0x14800000, 0x24c00000, 0xee600000, 0xbe900000, 0xecf80000, 0x816c0000, 0x2fa60000, 0x8afd0000, 0x43df8000, 0x15504000, 0x27192000, 0xd9bd7000, 0x92ff4800, 0x84e0a400, 0xdd51b200, 0x0b18fd00, 0x47bd3380, 0xe5ffc5c0, 0x6561dca0, 0x19101130, 0x0bb8e5f8, 0xfa4d0fbc, 0xa3166ea2, 0x2c35ec33, 
    0x80000000, 0xc0000000, 0x20000000, 0xf0000000, 0xf8000000, 0xe4000000, 0x26000000, 0x9b000000, 0xde800000, 0xc9400000, 0xe0200000, 0x0cf00000, 0x3db80000, 0x34740000, 0x6f920000, 0xcb850000, 0x80ab8000, 0xdcb14000, 0x5e186000, 0x6445b000, 0xadca2800, 0xc660bc00, 0xfc517e00, 0xaf09b100, 0xfd6d4480, 0x3f578d40, 0xfe0f4360, 0xd96b7730, 0x62d18708, 0x86493954, 0xcd4c3d62, 0x3ba7c633, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x48000000, 0x9c000000, 0x36000000, 0x49000000, 0x52800000, 0x56400000, 0x43e00000, 0xfff00000, 0x04280000, 0xa3940000, 0x5a6a0000, 0x49650000, 0x9ac28000, 0xc5b0c000, 0x49c92000, 0xf1655000, 0x3ec29800, 0x17b1fc00, 0x32c92a00, 0x08e50900, 0xd9039e80, 0x2f91b2c0, 0xc318eb60, 0xb41d2390, 0x94ef8ac8, 0x6e578984, 0x885bc162, 0x9a6d2a91, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0x88000000, 0xe4000000, 0xc6000000, 0x51000000, 0xb3800000, 0x5bc00000, 0x84200000, 0x49500000, 0x84080000, 0xec5c0000, 0x146e0000, 0x600d0000, 0x2de68000, 0x8290c000, 0x38296000, 0x290cd000, 0x42662800, 0x93519c00, 0x3f09ea00, 0xccdd2b00, 0x9b2ff580, 0xd56c7f40, 0xecd76d20, 0x56294c50, 0xcc0c8818, 0xafe697cc, 0x05908722, 0xa2a96751, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xf8000000, 0x5c000000, 0xe2000000, 0x6f000000, 0xf7800000, 0xecc00000, 0xcb200000, 0x4ab00000, 0x40280000, 0x17940000, 0x0a860000, 0x76250000, 0x532f8000, 0x68704000, 0x9e09e000, 0x09a4b000, 0x7beed800, 0x8d513400, 0x91b9e600, 0x750d6b00, 0xc93b6780, 0x2d368940, 0xfe8d74e0, 0x37fa1210, 0xd1164448, 0x2fbc6a5c, 0x811292e2, 0x3ea27913, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0x48000000, 0xbc000000, 0x32000000, 0x3f000000, 0xe3800000, 0x1ac00000, 0x60600000, 0xee700000, 0x77980000, 0xfe7c0000, 0x5abe0000, 0x2d0d0000, 0x09a68000, 0x2e304000, 0xbfb82000, 0x742dd000, 0x7d77d800, 0x27b9f400, 0xc02d8600, 0x5376e300, 0x7ab9eb80, 0x54ad17c0, 0x1637d160, 0x3219ebf0, 0xe5bc4e18, 0x6c5fa54c, 0xa13c5762, 0x211e08f1, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x88000000, 0xf4000000, 0x66000000, 0xd7000000, 0x1f800000, 0x1ec00000, 0x9ca00000, 0xf5700000, 0x16880000, 0x96bc0000, 0x19a60000, 0xaacd0000, 0x6bae8000, 0xc730c000, 0x2569a000, 0x22acd000, 0x8f7ec800, 0x9e48dc00, 0x851cc600, 0x6f573300, 0xa085b380, 0x58b29640, 0x1766ff60, 0xfe6d7850, 0x8adf3998, 0x27b8295c, 0xecd43962, 0xd08b4b51, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0x58000000, 0x44000000, 0xa6000000, 0xff000000, 0xec800000, 0x1ac00000, 0x55200000, 0x2fb00000, 0xf5780000, 0x7dac0000, 0xf61e0000, 0xcf1d0000, 0xf6e68000, 0x1bf04000, 0x53996000, 0xecbdf000, 0x6e976800, 0xf628fc00, 0xbcc5f600, 0xb2bbd500, 0x07772b80, 0x33b84340, 0x2a8d22e0, 0xd0aeacb0, 0x81e50a38, 0x610b67cc, 0x400ed4e2, 0xbf1479b1, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x38000000, 0x7c000000, 0x4a000000, 0x05000000, 0x7e800000, 0x26c00000, 0xfc200000, 0x26100000, 0x2c680000, 0xe93c0000, 0xc5320000, 0x81ad0000, 0x179b8000, 0xb8b14000, 0xf6b96000, 0x54743000, 0x409e1800, 0x4037e400, 0xb02a7200, 0x7d88a900, 0xbe8d6780, 0xf80bd540, 0x959969a0, 0x81e43c90, 0x50b7b858, 0x35ea51b4, 0xd8289ba2, 0xf1ddd593, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0xf8000000, 0x64000000, 0x2a000000, 0xf1000000, 0xd7800000, 0x30400000, 0x55200000, 0x8d900000, 0x9f180000, 0xb35c0000, 0xa7860000, 0x514d0000, 0xccdf8000, 0x2d31c000, 0x3fc82000, 0xa8e53000, 0x3e0b6800, 0xac72a400, 0xfb9faa00, 0xb091bb00, 0x3e996280, 0x5c1d9540, 0x2e27e3a0, 0x321df870, 0x85268398, 0x5c9da83c, 0x2ee7c9a2, 0x8ffd8373, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x78000000, 0x24000000, 0x62000000, 0xff000000, 0x4e800000, 0xf8c00000, 0x4ee00000, 0x7cb00000, 0x70a80000, 0x8df40000, 0xbd6a0000, 0x17c50000, 0xa9038000, 0x32d04000, 0xa5d92000, 0x9c3db000, 0x136ee800, 0xc7a73400, 0x6c233600, 0xb0019900, 0x48006f80, 0xac0110c0, 0x6e0110e0, 0xc1000090, 0xf7809088, 0x2b403c84, 0x07a1a6e2, 0x8411d993, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x98000000, 0x7c000000, 0xaa000000, 0x99000000, 0xf6800000, 0xedc00000, 0x38600000, 0x63300000, 0xce880000, 0x39840000, 0x672a0000, 0xf6350000, 0x85638000, 0x1d51c000, 0xb6b96000, 0x1c8df000, 0xe3ee1800, 0xefbf6400, 0x3b874a00, 0x84caf900, 0x10444980, 0x594b0dc0, 0x2e05f5e0, 0xb06a11d0, 0x7194db68, 0x4b334044, 0x74693fe2, 0x497528d3, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x88000000, 0xa4000000, 0xd6000000, 0xe7000000, 0x99800000, 0x5a400000, 0x47e00000, 0xca700000, 0x6b980000, 0xfc7c0000, 0xa1220000, 0x758d0000, 0x55fa8000, 0x4e904000, 0xae68a000, 0x8aa45000, 0x933f6800, 0xcc9fbc00, 0xa80f0600, 0xfb665f00, 0xcd439a80, 0x34bc4cc0, 0xb7029860, 0x235dccf0, 0x5572f618, 0xfcc4dc74, 0xf70f1e62, 0x1ee7d3f1, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0xf8000000, 0xc4000000, 0xba000000, 0x4f000000, 0x5a800000, 0x1d400000, 0x9b200000, 0xe3d00000, 0x99280000, 0xc4dc0000, 0x677e0000, 0xd68d0000, 0x33968000, 0x5330c000, 0xda99a000, 0x64043000, 0x1edaa800, 0xd8c78400, 0xe4589600, 0x41e48100, 0x98ea4480, 0x27de5340, 0x4f9c0520, 0x755fb810, 0xbedc4418, 0x887f87ac, 0xfc0c1322, 0x46d6f911, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x38000000, 0x7c000000, 0xfe000000, 0xc9000000, 0x05800000, 0x31c00000, 0xe7600000, 0x01700000, 0xb1180000, 0x7f7c0000, 0xa3ae0000, 0xbe8d0000, 0xb0f78000, 0xfa51c000, 0xe2c8a000, 0xca74b000, 0xcbbbd800, 0x27c68c00, 0x9ae9ea00, 0x7f24b700, 0x39f21180, 0xd7f395c0, 0xe6f26960, 0xff73e8f0, 0xa0b3f218, 0xb6d2ac6c, 0xce220362, 0xb0fb9ff3, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x18000000, 0x94000000, 0x3a000000, 0xbd000000, 0x20800000, 0x73400000, 0x60200000, 0x14100000, 0xcd880000, 0xfd7c0000, 0x83c20000, 0x2aed0000, 0x428b8000, 0xad71c000, 0xacb96000, 0xe864f000, 0x1e77c800, 0xab734400, 0xf634d200, 0x615f7500, 0x105ebc80, 0x3eded140, 0xda9f96a0, 0x4f3ea750, 0x84ee4cd8, 0xf4061f94, 0xfa4ac4a2, 0x3d911253, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x08000000, 0x34000000, 0xb6000000, 0xa7000000, 0x10800000, 0x1bc00000, 0xb4a00000, 0x41700000, 0x4d780000, 0xc53c0000, 0xb2da0000, 0x61cd0000, 0xbde28000, 0x90104000, 0xcba9e000, 0x7fb55000, 0x3e5f0800, 0x8e0a7c00, 0xb644a600, 0xa4e68d00, 0xd5965980, 0xd0efb840, 0x81d20d60, 0x350957b0, 0xfbc59a98, 0x62a6c844, 0x5f762b62, 0x877e9ab1, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x18000000, 0x04000000, 0x5e000000, 0xb9000000, 0xa4800000, 0xe1c00000, 0xce600000, 0xbbd00000, 0x1c580000, 0x139c0000, 0x40de0000, 0x57cd0000, 0xcac68000, 0x4071c000, 0x0fe8a000, 0x7914f000, 0xbd9a2800, 0x404f8c00, 0xed34fa00, 0x606bb500, 0x4ae75180, 0xdb8145c0, 0xb840cc20, 0xb521f070, 0x3d708e98, 0xd568ba0c, 0x51d4b622, 0xdf7a8571, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x98000000, 0x7c000000, 0x0a000000, 0xe9000000, 0x84800000, 0xc0400000, 0xa2e00000, 0x9c700000, 0x45a80000, 0xdb0c0000, 0x9e420000, 0x773d0000, 0xf10b8000, 0x74404000, 0x8ce02000, 0xa3707000, 0xf2295800, 0xeecd2400, 0x04632a00, 0x83ec1d00, 0x6333d280, 0xf2140cc0, 0x4c469860, 0x33e2be90, 0x762d56f8, 0x591253d4, 0xd6c59262, 0x467ed393, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xd8000000, 0x2c000000, 0x86000000, 0xc3000000, 0x02800000, 0xa5400000, 0x0fa00000, 0xeb100000, 0xe1580000, 0xfaac0000, 0x38c60000, 0x0cfd0000, 0x0a3f8000, 0xa340c000, 0x0ca1e000, 0x09907000, 0x74183800, 0x2d0cbc00, 0xffd7de00, 0x6ba40900, 0x33934c80, 0x9906da40, 0xa51c7ca0, 0x0c0e2df0, 0x3c48db78, 0xc0f4ef3c, 0x0cea42a2, 0x277a54f3, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0xd8000000, 0x34000000, 0xe6000000, 0x19000000, 0xec800000, 0x68400000, 0xdae00000, 0x8af00000, 0x41980000, 0x5c640000, 0x6f820000, 0x5ad50000, 0x9afa8000, 0x69414000, 0x6260e000, 0x14b1f000, 0x6a780800, 0xd6147c00, 0x945a5a00, 0x23511500, 0x8a086280, 0xf6cc2cc0, 0x165fa560, 0x426386f0, 0x99a44528, 0x45a35034, 0xa4851f62, 0xa27363f1, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x68000000, 0xd4000000, 0xc6000000, 0x73000000, 0x70800000, 0xb8400000, 0xcaa00000, 0x21b00000, 0x81180000, 0x075c0000, 0xf8f20000, 0xa2ad0000, 0x614b8000, 0xd140c000, 0xeb206000, 0xd4711000, 0xd4784800, 0x8a8d5c00, 0x8dbb4e00, 0x79786d00, 0xf50c1680, 0xb77ab440, 0x4e99d3e0, 0x759dc770, 0x0b1225d8, 0x7c3d9fd4, 0x1222fde2, 0x8164ba73, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xc8000000, 0x4c000000, 0x4e000000, 0xcf000000, 0x4c800000, 0x8e400000, 0xdb600000, 0x9ad00000, 0x5fc80000, 0x735c0000, 0xe9be0000, 0xe9cd0000, 0x42168000, 0xbcc04000, 0xe2202000, 0x7930d000, 0xd1583800, 0xf2f50c00, 0x81b30600, 0x1c7b0500, 0x0e270280, 0x9419efc0, 0x27154920, 0xb4237950, 0x4b537b18, 0xed6b78ec, 0x3b4e6f22, 0xb234ac51, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x68000000, 0xec000000, 0x42000000, 0x03000000, 0xd9800000, 0x44400000, 0x57a00000, 0xeeb00000, 0xe3d80000, 0xb86c0000, 0xcbfe0000, 0x009d0000, 0xc4878000, 0x1bc04000, 0xdee0e000, 0x31919000, 0x4ba8b800, 0x15d45400, 0x20c3de00, 0xd0aa3700, 0xab9e0e80, 0xd2ccdc40, 0xa5cef5e0, 0x598498f0, 0xa88b45b8, 0x046f9c4c, 0xb235cbe2, 0x9fd33ff3, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xe8000000, 0x4c000000, 0x8e000000, 0x3b000000, 0x2e800000, 0xfec00000, 0x6ee00000, 0x05300000, 0x92180000, 0x75d40000, 0xd18a0000, 0x68250000, 0x1a728000, 0xd841c000, 0x0c21a000, 0x6dd11000, 0x7029b800, 0xaf4ccc00, 0x2d9eee00, 0x77ce4100, 0xb2a60b80, 0x104bc0c0, 0x5a4597e0, 0x4c8349f0, 0x053949c8, 0x86857324, 0x4762d9e2, 0x9d8818f1, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0xa8000000, 0xd4000000, 0x8e000000, 0x49000000, 0x15800000, 0x50400000, 0xc5a00000, 0x57700000, 0x7e580000, 0xcb0c0000, 0x83720000, 0x163d0000, 0x3f8b8000, 0xf6c14000, 0xb761e000, 0x16111000, 0x4d49c800, 0x51c44c00, 0x39f73a00, 0xecea3700, 0x06d0b280, 0x47286040, 0xec542e60, 0xc5fe47f0, 0xb90ec0f8, 0xb617ce54, 0x593af462, 0x637960f3, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x18000000, 0x34000000, 0x4a000000, 0x0b000000, 0x2e800000, 0xda400000, 0x95200000, 0xd9900000, 0x0e180000, 0xf7f40000, 0x8bae0000, 0xe2250000, 0xbd978000, 0x77c0c000, 0x7de06000, 0x10f1f000, 0xc7a98800, 0x57fca400, 0xb9827e00, 0xb59fc900, 0x49ed2280, 0x445b3740, 0x4d8b27a0, 0xfdb26670, 0xed5744c8, 0x5aa1576c, 0xf65139a2, 0x67f85f73, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0xf8000000, 0x4c000000, 0xca000000, 0x39000000, 0x40800000, 0xbc400000, 0x6aa00000, 0x1cf00000, 0xd3280000, 0xad2c0000, 0x43b60000, 0xdc9d0000, 0x7ebf8000, 0x8f014000, 0x8b80e000, 0xa9c1b000, 0xec61f800, 0x0b106400, 0xa9f8ea00, 0x14b51500, 0x6e130a80, 0x6e775440, 0x8efdc160, 0xeaaeb310, 0x257943b8, 0xa2f4313c, 0x1db3cb62, 0x82071613, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xc8000000, 0xa4000000, 0x32000000, 0xc5000000, 0x75800000, 0x98400000, 0x71200000, 0x3e100000, 0x65080000, 0x1e3c0000, 0xc0aa0000, 0x096d0000, 0x6b038000, 0xb8004000, 0xac006000, 0x3600d000, 0x0700a800, 0x7881f400, 0x49c0c200, 0xdb608f00, 0x8a30ba80, 0x2e980940, 0xe3754ca0, 0xafb62850, 0xf7d74058, 0x0767cb44, 0xcd3feea2, 0xd4ab7753, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xa8000000, 0x1c000000, 0x6a000000, 0x6b000000, 0xec800000, 0x13400000, 0x8de00000, 0x41500000, 0x9a280000, 0x57bc0000, 0x7c760000, 0x0aad0000, 0x993f8000, 0x32014000, 0x4f012000, 0x12811000, 0x5e409800, 0xc8618400, 0xc990ee00, 0x82090d00, 0xe34cf080, 0xc66ec2c0, 0x9529a420, 0xa53daf90, 0x52366dd8, 0x3acc6cbc, 0xe4ae6a22, 0xc608b293, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x18000000, 0x24000000, 0xd2000000, 0xb7000000, 0x4b800000, 0x83c00000, 0x35200000, 0x3cf00000, 0x7f480000, 0x0e440000, 0x15d20000, 0x8c750000, 0xa73b8000, 0xf480c000, 0x6440e000, 0x08e1f000, 0xe0d12800, 0x51399400, 0xf84d2600, 0x83f73300, 0xef376980, 0x95967d40, 0xa8a63e60, 0xfdceb4d0, 0xb8fa7568, 0xa7a08d34, 0x75b1f862, 0x072977d3, 
    0x80000000, 0x40000000, 0xe0000000, 0xd0000000, 0x98000000, 0xf4000000, 0xa2000000, 0x09000000, 0xce800000, 0xd4c00000, 0xd7600000, 0x45900000, 0x2d680000, 0x86ec0000, 0x1a320000, 0x193d0000, 0x94fa8000, 0x3d20c000, 0xae312000, 0xe398f000, 0xf0144800, 0x76b67400, 0x1462fa00, 0x26b55900, 0x74c6fb80, 0x8f5b53c0, 0x1bd032a0, 0x84c86c10, 0x911d4af8, 0x3a4ba8b4, 0x557968a2, 0xecc50511, 
    0x80000000, 0xc0000000, 0xe0000000, 0xf0000000, 0x98000000, 0xd4000000, 0xa6000000, 0x1f000000, 0xdc800000, 0x55c00000, 0x47e00000, 0x3a700000, 0x8df80000, 0x145c0000, 0x622e0000, 0xf76d0000, 0xb5f78000, 0xc2a0c000, 0x7a506000, 0x5968f000, 0x08544800, 0x3eca7c00, 0xe13e9600, 0xe4247500, 0xf432d580, 0x1de216c0, 0x85ca8f60, 0xc3be4c30, 0x9ae41858, 0x39523dac, 0xf553f962, 0x47520933, 
    0x80000000, 0x40000000, 0x20000000, 0x50000000, 0xe8000000, 0x4c000000, 0xee000000, 0x4b000000, 0x01800000, 0x93c00000, 0x69a00000, 0x28900000, 0x35a80000, 0xd5fc0000, 0xd2320000, 0x772d0000, 0xa9fa8000, 0x89e14000, 0xdff02000, 0x52199000, 0xe4843800, 0x6b060c00, 0x7c530e00, 0x6c1c5f00, 0x95c37180, 0xd1353040, 0x077e86a0, 0x0be6b010, 0x07239ed8, 0xe7449534, 0x8aa728a2, 0x68c23f11, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x28000000, 0xd4000000, 0xfe000000, 0xbf000000, 0x07800000, 0xc1400000, 0xb3200000, 0xb5300000, 0x00a80000, 0x4dc40000, 0x8b5e0000, 0xa2350000, 0x03968000, 0x60e0c000, 0xc1d1a000, 0x9f799000, 0x1dbc8800, 0x2963ac00, 0xb617d600, 0x2ca07300, 0xb871bc80, 0xc1898940, 0xd5f598e0, 0x31769f10, 0xbc30a5e8, 0xbc2915ec, 0xbd056ee2, 0x023fbc11, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xa8000000, 0x24000000, 0xc6000000, 0x73000000, 0xc6800000, 0x18c00000, 0x5aa00000, 0xefb00000, 0x1e680000, 0x130c0000, 0xa54e0000, 0xbefd0000, 0xf3468000, 0x29e04000, 0x4451a000, 0x9f381000, 0xa1b56800, 0xc6badc00, 0x7027ae00, 0xa7718100, 0x0cc91780, 0xe8bd5840, 0x45279ee0, 0x52f09190, 0x7288bd78, 0x3add5c4c, 0x583710e2, 0x87294091, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0x38000000, 0x9c000000, 0x3a000000, 0x5d000000, 0x97800000, 0xe4400000, 0x7aa00000, 0xddd00000, 0xa3480000, 0xaa6c0000, 0x03120000, 0xde7d0000, 0x33bb8000, 0xece04000, 0x3e71e000, 0xdf193000, 0x82655800, 0xbd5e0400, 0xd57e8200, 0xb76fdb00, 0x18c6b280, 0xdcda7a40, 0xa8d1a320, 0x60c85bd0, 0x702cf378, 0xb2b2a6b4, 0xcb2d4122, 0x2232f0d3, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x48000000, 0x64000000, 0xd2000000, 0x65000000, 0x00800000, 0xd8c00000, 0x30a00000, 0x8c100000, 0x18280000, 0xdcac0000, 0x4e3e0000, 0x7efd0000, 0xa9778000, 0xab61c000, 0x5330e000, 0xd5785000, 0x6265a800, 0x6de33400, 0x47db0200, 0xf05f2500, 0x054d3b80, 0x70ce4040, 0x63a499a0, 0xb3c2e910, 0x580a9d78, 0xf356ea2c, 0x16b0fba2, 0x1d385c13, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x08000000, 0x94000000, 0xea000000, 0xd5000000, 0xc3800000, 0xc2c00000, 0xe7600000, 0x5cd00000, 0x27e80000, 0x579c0000, 0x06660000, 0x0f0d0000, 0x2fae8000, 0x05e04000, 0x4790a000, 0x6f495000, 0xa3ad0800, 0xc99fc400, 0x33198200, 0xde04d300, 0xff236f80, 0xd68f69c0, 0x3a10ac20, 0x72896910, 0xe24ca298, 0x8c0fd91c, 0xad510e22, 0x4c29aa11, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x18000000, 0x14000000, 0x56000000, 0x2f000000, 0xf1800000, 0x5bc00000, 0x5da00000, 0x69d00000, 0x9b080000, 0xee640000, 0x1d7e0000, 0x8af50000, 0xbd978000, 0xa920c000, 0x6691a000, 0xf9e9f000, 0x0d540800, 0x79469c00, 0x5aa97600, 0x1db4cf00, 0x0b772980, 0xfc107840, 0x3da9d420, 0xc0346550, 0xe2b78368, 0xd0b062ec, 0x86f88222, 0xb37c9a53, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xd8000000, 0x2c000000, 0x2a000000, 0x53000000, 0xda800000, 0x5ec00000, 0x82200000, 0x18900000, 0xaf580000, 0x25d40000, 0xf7f60000, 0x4e050000, 0x20cf8000, 0x8aa1c000, 0x8951a000, 0x75f97000, 0xd4847800, 0xde0fe400, 0x7881fe00, 0x59c06100, 0x2ea0db80, 0xf7509140, 0x50f93ca0, 0xbf0402f0, 0xfd4e2e88, 0x78e1175c, 0xe4b0e2a2, 0x92c9d3f3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x98000000, 0x04000000, 0x9e000000, 0x3f000000, 0x1a800000, 0x32400000, 0x90e00000, 0x9c500000, 0xc5b80000, 0xb0d40000, 0x4a820000, 0x85450000, 0xb81b8000, 0x29e04000, 0x7dd16000, 0xd3787000, 0x5d74e800, 0xc4b20c00, 0xeaed7600, 0xc3968900, 0x70e65a80, 0x6d2f74c0, 0x6cb3ac20, 0x16ed82b0, 0x89967508, 0x39e6f874, 0xd4ae3a22, 0xde723bb3, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x48000000, 0x94000000, 0x7a000000, 0xd9000000, 0xd5800000, 0xe4400000, 0xa3e00000, 0xdaf00000, 0xab080000, 0xa55c0000, 0x9a160000, 0x256d0000, 0x2e3f8000, 0x12e04000, 0x8b702000, 0xdd49d000, 0x9bbc8800, 0xa7666400, 0x27259a00, 0x8702df00, 0x6f463a80, 0x7375ccc0, 0x689a2d60, 0x1ba2d9d0, 0x76d7bb58, 0xe54da83c, 0x8e6e1762, 0xf77896d3, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0x58000000, 0x74000000, 0xf2000000, 0xaf000000, 0x46800000, 0x80c00000, 0x73a00000, 0x34500000, 0xbbd80000, 0xa2cc0000, 0xfb3a0000, 0xf5dd0000, 0x9e028000, 0x8ca1c000, 0x0ad1a000, 0xbf187000, 0xeb6dc800, 0x4c6b5400, 0x8e84b600, 0xe10fe900, 0xedbb9f80, 0x0d1cca40, 0x69a39920, 0x82f198f0, 0x3209d938, 0xdd5547c4, 0xcd960f22, 0x2396c1f1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0xd8000000, 0xe4000000, 0xc2000000, 0xaf000000, 0xb6800000, 0x5bc00000, 0xd9200000, 0xf0500000, 0x27480000, 0xbf4c0000, 0x11320000, 0xc75d0000, 0xf11b8000, 0xaa204000, 0x90d0a000, 0xf988f000, 0xd3ece800, 0xf2223400, 0xebf59600, 0xbca76900, 0x2e4ba980, 0xfbe97f40, 0xd45c2720, 0xa19a54d0, 0x3ce08a38, 0xc070caf4, 0x3c989122, 0x92448dd3, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xb8000000, 0x04000000, 0x6a000000, 0x7b000000, 0x3f800000, 0x53400000, 0xa6e00000, 0x2c300000, 0xb3980000, 0x66340000, 0x4ca20000, 0xcbc50000, 0x801b8000, 0xaae1c000, 0xca30a000, 0xee99b000, 0x64b52800, 0x8d63a400, 0x14e5fe00, 0x770b2b00, 0x84699080, 0xf98d92c0, 0xae074ee0, 0xbcae02f0, 0x7383b008, 0x6cd54074, 0x769390e2, 0x0d5c59f3, 
    0x80000000, 0xc0000000, 0x20000000, 0x90000000, 0x88000000, 0x94000000, 0xca000000, 0x29000000, 0x2d800000, 0x0f400000, 0x36200000, 0x3d300000, 0x87c80000, 0xc0fc0000, 0x549a0000, 0x4bed0000, 0x2e638000, 0x2cd94000, 0x2a04a000, 0xbbaf5000, 0xdb8b0800, 0x73140400, 0xf456ba00, 0xcf3faf00, 0x9b32fc80, 0x5180cf40, 0x214038e0, 0xed20d5d0, 0xb5b0ea98, 0x73084f24, 0x8e9d8ae2, 0x910b7ed3, 
    0x80000000, 0xc0000000, 0x60000000, 0xd0000000, 0x18000000, 0x54000000, 0x1e000000, 0x31000000, 0x80800000, 0x18c00000, 0xe0200000, 0xbab00000, 0xa3880000, 0xb5a40000, 0xdb4a0000, 0xcf350000, 0xb2738000, 0x7119c000, 0x409c2000, 0x3766f000, 0x46da0800, 0x5b8c8c00, 0xde1f8a00, 0x54175d00, 0xedf34380, 0xb0581940, 0xc4fd30e0, 0xf7378950, 0xdcc34528, 0x0c91e504, 0xa438b2e2, 0xbcac5853, 
    0x80000000, 0x40000000, 0xe0000000, 0xb0000000, 0xa8000000, 0x34000000, 0xb2000000, 0x0b000000, 0x43800000, 0x26400000, 0x61e00000, 0xb4d00000, 0xd4f80000, 0xbb9c0000, 0x79ea0000, 0xbead0000, 0x41c28000, 0xadc8c000, 0xb5b5e000, 0x7b8e9000, 0x365a0800, 0x4045b400, 0x62873e00, 0x18ce4300, 0x693bea80, 0x60553cc0, 0x3d5e0920, 0x09a2e830, 0x08595798, 0x952c8da4, 0xf3833f22, 0x2e291f31, 
    0x80000000, 0xc0000000, 0xe0000000, 0xd0000000, 0x28000000, 0xf4000000, 0x92000000, 0x05000000, 0x86800000, 0xaec00000, 0x73a00000, 0xb6d00000, 0xb8f80000, 0x5b440000, 0xc2560000, 0x3a350000, 0xb67f8000, 0xc888c000, 0xebec2000, 0xb32b9000, 0x66874800, 0x47cdf400, 0x8bbba200, 0x741f4900, 0x8a782780, 0x47841240, 0x84f69c20, 0xf26448b0, 0x7c46e428, 0x866ca9dc, 0x086a7622, 0xb266f5b3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xc8000000, 0xb4000000, 0x56000000, 0x5d000000, 0x07800000, 0xe7c00000, 0x9ca00000, 0x13f00000, 0x24a80000, 0xe37c0000, 0x9dfa0000, 0xf02d0000, 0x78a38000, 0x04f84000, 0x70a52000, 0xa36ed000, 0x3c4ac800, 0x5ce5bc00, 0xc20f1200, 0x341a4300, 0x4b3cc580, 0x929b0e40, 0x897ccc60, 0x42fbd610, 0x0cadec18, 0x5de25624, 0x04191662, 0xfa342913, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xd8000000, 0xb4000000, 0x12000000, 0x67000000, 0xdf800000, 0x9cc00000, 0x9ae00000, 0xf1d00000, 0x43c80000, 0x00c40000, 0x8bfa0000, 0x51f50000, 0x12e28000, 0x3b79c000, 0x981ce000, 0xaf177000, 0xcf9a0800, 0xb6641400, 0xbf8be600, 0xfbcc3b00, 0xcbdea780, 0x70df92c0, 0x915e7620, 0xac9fa850, 0xacfedb28, 0xa16fa2e4, 0x8f079822, 0x6a338751, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x58000000, 0x24000000, 0x02000000, 0x01000000, 0x00800000, 0x83c00000, 0x67200000, 0xcdf00000, 0x13780000, 0x20bc0000, 0x52520000, 0xbc6d0000, 0x67db8000, 0x1228c000, 0xc0756000, 0x43f77000, 0x9493a800, 0x69cc3400, 0x90ea0a00, 0x32f02500, 0xf4f8d580, 0x40fdf740, 0xc7323060, 0xcdfd5eb0, 0x79b21198, 0x893d40d4, 0x6d139262, 0x9e8d4fb3, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0xa8000000, 0x2c000000, 0x76000000, 0xa5000000, 0x10800000, 0xb9c00000, 0xb6a00000, 0x5ff00000, 0xc7c80000, 0x14540000, 0x8b3e0000, 0x4f050000, 0x4c078000, 0x8f19c000, 0xc72ce000, 0xd0c39000, 0xcebe3800, 0xee453c00, 0xbf665200, 0x08486d00, 0x7e158980, 0x49de8440, 0x3b151860, 0x295f94d0, 0x4ad46448, 0x03ffc76c, 0xcb257262, 0x4d36c5d3, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x98000000, 0xac000000, 0x5e000000, 0xf5000000, 0xea800000, 0x89c00000, 0xb4e00000, 0x7ab00000, 0x05480000, 0x17240000, 0xf96a0000, 0x4c750000, 0x1c128000, 0xafd8c000, 0xdabce000, 0xa676f000, 0xd6923800, 0xb6180c00, 0x265df200, 0xd8c6c900, 0xb9daa980, 0xa63d54c0, 0x9eb742e0, 0x02f29550, 0x72683428, 0x4e7416c4, 0x8f1288e2, 0xcc595051, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x58000000, 0x54000000, 0x66000000, 0x07000000, 0x7d800000, 0x31c00000, 0x90200000, 0x2ff00000, 0xc8880000, 0x35640000, 0xebb60000, 0x3db50000, 0x194e8000, 0x8d99c000, 0x2dbca000, 0x196a7000, 0x894f8800, 0x9599fc00, 0x19bce600, 0x6f6ad700, 0xd64ffd80, 0xbc184340, 0x4e7c1860, 0xf84a9350, 0x843f5028, 0x455146fc, 0xeb397662, 0x3c0cb851, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xf8000000, 0x14000000, 0x52000000, 0x67000000, 0xdf800000, 0x41c00000, 0x1a600000, 0x7ed00000, 0xfaa80000, 0x49840000, 0x52a60000, 0x12350000, 0x2d5f8000, 0xbad8c000, 0xb71da000, 0xe51a3000, 0x121f0800, 0xcbf9d400, 0xcaeca600, 0xf542fb00, 0x7c429d80, 0x5ac2d3c0, 0x1583b220, 0x4ca2cb90, 0x3d538fa8, 0x7b0ad49c, 0xd8561c22, 0xe5ece493, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x88000000, 0x64000000, 0x6e000000, 0x4b000000, 0xc4800000, 0x1ac00000, 0xfc200000, 0x95500000, 0x34a80000, 0xdb140000, 0x47920000, 0x37650000, 0x19ea8000, 0xbe99c000, 0xdf8c2000, 0x251fd000, 0x11fb6800, 0x8c504c00, 0x79281e00, 0x24553500, 0x10f31380, 0x4354a940, 0xfe738b20, 0x4c941b10, 0x55d3a388, 0xeb858af4, 0x8d9afd22, 0x7ce06211, 
    0x80000000, 0x40000000, 0x20000000, 0x90000000, 0x68000000, 0x04000000, 0x96000000, 0xed000000, 0x66800000, 0x73400000, 0x56200000, 0x9e300000, 0x58b80000, 0xd9940000, 0xb66e0000, 0xa2850000, 0x2f668000, 0xe8694000, 0x1cfda000, 0xac129000, 0xcdd62800, 0x4c907c00, 0x56c91200, 0x808c8100, 0x8e0acc80, 0x7e33b940, 0x85e77ee0, 0xd9292b30, 0x79dc7848, 0x2da2462c, 0x7eae44e2, 0x5964d631, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0xb8000000, 0x9c000000, 0x42000000, 0xbd000000, 0x4e800000, 0x8ec00000, 0x1de00000, 0x41d00000, 0x30b80000, 0x1a540000, 0xb4260000, 0xb1650000, 0x22cf8000, 0xcdc8c000, 0xd49da000, 0x013ab000, 0x951e1800, 0xe6717400, 0x03480200, 0x9a5df900, 0xfcdb3780, 0xc4cfeec0, 0x6ec8a220, 0x851de4b0, 0x6c7ab008, 0xf0bed9bc, 0xa880b822, 0x2dc069b3, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0xd8000000, 0xf4000000, 0x8e000000, 0x79000000, 0x18800000, 0x27400000, 0xa7a00000, 0x6ab00000, 0x4b880000, 0xb6a40000, 0xcf160000, 0xc8b50000, 0x19af8000, 0xe759c000, 0x467de000, 0xabab7000, 0xfd7e8800, 0x6b802c00, 0xb0c05a00, 0x45618d00, 0x94d16c80, 0xf4d92640, 0x52bc6fe0, 0x88ca3650, 0x3cae7b28, 0xfdd9f6bc, 0x323cbde2, 0x0b8a9753, 
    0x80000000, 0xc0000000, 0xe0000000, 0x70000000, 0x98000000, 0xfc000000, 0x5e000000, 0x35000000, 0x2f800000, 0xc5c00000, 0xb7600000, 0x4f900000, 0x3fe80000, 0x0bcc0000, 0x42d60000, 0xec3d0000, 0xa22f8000, 0xdd58c000, 0x51156000, 0x9202f000, 0xfb5e1800, 0x95e10c00, 0x09d1d200, 0x1b49c300, 0xd23c3180, 0x272ff9c0, 0x8ad950a0, 0x18d44710, 0xe3637db8, 0x7dcecefc, 0xdb889aa2, 0xf2dd8813, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xd8000000, 0x84000000, 0x2a000000, 0xfd000000, 0x9e800000, 0x26400000, 0xbca00000, 0x6e500000, 0x77080000, 0x09640000, 0x2e260000, 0xa5150000, 0xa13e8000, 0xdfd9c000, 0x9c2d6000, 0xd1e37000, 0xe863e800, 0x35a26400, 0xd5c3b200, 0xfb73c900, 0x7b8aa680, 0x71365c40, 0x2d3cdc20, 0xeecb2150, 0x3416c568, 0xbeacb5dc, 0xe9a20622, 0x3bc34c51, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0x58000000, 0x44000000, 0xc2000000, 0x5b000000, 0x52800000, 0x31c00000, 0xdae00000, 0x85700000, 0x29180000, 0x30140000, 0xea560000, 0xe5050000, 0xf3ff8000, 0x44e84000, 0x07cc6000, 0x6823f000, 0x54e26800, 0x2d83b400, 0x2cb3fe00, 0xca0b0100, 0x554e4580, 0x841108c0, 0x5c29f560, 0xecac4df0, 0x9a1325c8, 0xfcdb4a1c, 0x0507e362, 0xbe0cb8f3, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x18000000, 0x84000000, 0xba000000, 0x31000000, 0x13800000, 0xb9c00000, 0x2aa00000, 0x9f500000, 0xed980000, 0x34a40000, 0xf1520000, 0x9ad50000, 0x465b8000, 0x27494000, 0xdffd2000, 0x1fd67000, 0xa396a800, 0x97f7c400, 0x5687aa00, 0xc90f3300, 0x87d34180, 0x52952a40, 0x403b6120, 0x6b384070, 0x3df47ee8, 0x7bcb0314, 0xfaf1e322, 0x0a49f773, 
    0x80000000, 0x40000000, 0x60000000, 0xd0000000, 0x18000000, 0x14000000, 0xae000000, 0x3f000000, 0x92800000, 0xc4400000, 0xc6e00000, 0x2a300000, 0x7a580000, 0x22840000, 0x8e320000, 0xc8d50000, 0xf41a8000, 0x09e9c000, 0x301d2000, 0xe916f000, 0xfcb68800, 0x1ee6ec00, 0x48cf1600, 0x83f29900, 0x1ef52680, 0x5f8b50c0, 0x7fe0f8e0, 0x1bb16370, 0xee98ce68, 0x7525ef54, 0x7963e6e2, 0xe57cd671, 
    0x80000000, 0xc0000000, 0x60000000, 0xb0000000, 0x18000000, 0x3c000000, 0x8a000000, 0xe7000000, 0x78800000, 0x1fc00000, 0x35a00000, 0x89900000, 0xff680000, 0xc4140000, 0xc9220000, 0x26a50000, 0xc51b8000, 0x43f9c000, 0x38fce000, 0x3076f000, 0x8ae61800, 0x030fa400, 0x59dbf600, 0x18d8c500, 0x13ade180, 0xcd3f7240, 0x842210a0, 0xa9258790, 0x6a5b8808, 0xfd98d814, 0x2acc7ea2, 0x178f2693, 
    0x80000000, 0x40000000, 0xa0000000, 0xb0000000, 0x78000000, 0x9c000000, 0x06000000, 0x1d000000, 0x3e800000, 0xab400000, 0x50600000, 0x56900000, 0x19e80000, 0x72cc0000, 0xe0f20000, 0x0bbd0000, 0xdc4a8000, 0x96b84000, 0xbe05e000, 0x7dcfb000, 0xc8b75800, 0xe8937c00, 0x312dc200, 0x1ba2d100, 0xd574bc80, 0x1e76f5c0, 0x5c327fa0, 0x7c1d7d10, 0x9efb33b8, 0xf820fbb4, 0xe97065a2, 0xb4b99011, 
    0x80000000, 0x40000000, 0xe0000000, 0xf0000000, 0xd8000000, 0x3c000000, 0x76000000, 0xed000000, 0x95800000, 0xc1400000, 0x89200000, 0xf2300000, 0xcb380000, 0x6f640000, 0xde9e0000, 0x80f50000, 0x4d568000, 0x75c8c000, 0x703d6000, 0xacea7000, 0xa2629800, 0x187edc00, 0x0225e200, 0x49bf6700, 0x9bc4c880, 0xa9ee9140, 0x98ed82e0, 0x6302aa30, 0xfcee57a8, 0x816d40cc, 0xec4278e2, 0x54ced131, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x48000000, 0x44000000, 0x3e000000, 0xe3000000, 0x22800000, 0x6ec00000, 0xcc200000, 0x20d00000, 0x33d80000, 0xe5640000, 0x76d20000, 0xa6150000, 0x429b8000, 0x14c84000, 0xbd1c2000, 0xb027d000, 0xc97e2800, 0x16da6c00, 0x7a288e00, 0x8bed5900, 0xae2f6b80, 0x96436540, 0x8d2c7820, 0x360e0df0, 0x60939468, 0xc9f46494, 0x87eb5e22, 0xdf8078f3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x68000000, 0xcc000000, 0x8a000000, 0xad000000, 0x37800000, 0x6c400000, 0x22e00000, 0x86100000, 0x41580000, 0x98340000, 0xc2620000, 0x34450000, 0xc7eb8000, 0x1a084000, 0xee0d2000, 0x71079000, 0x781e3800, 0x44cb4400, 0x87b90200, 0x38251b00, 0x543ab280, 0x0ef0c2c0, 0xfa4808a0, 0x26ec5170, 0xaa16bd48, 0x36c73bf4, 0x14beb2a2, 0x213b4e73, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0x38000000, 0x8c000000, 0x6e000000, 0x33000000, 0xb2800000, 0x18c00000, 0xdfa00000, 0x14d00000, 0x40c80000, 0x9e9c0000, 0x717e0000, 0x566d0000, 0x42278000, 0xa6d94000, 0x08f56000, 0xc8b23000, 0xd89af800, 0x78362c00, 0x16b1be00, 0x36389900, 0x16c48780, 0xa74b5240, 0x967eac20, 0x96ec1cd0, 0x6fe70b98, 0x3cf8f1ec, 0x6c646a22, 0x9e1ae9d3, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x68000000, 0xa4000000, 0xca000000, 0x57000000, 0xd4800000, 0xaf400000, 0x8ee00000, 0xaad00000, 0xca480000, 0x876c0000, 0x88160000, 0x7edd0000, 0xc64f8000, 0x25d9c000, 0x44c56000, 0x092a1000, 0x2fc2a800, 0xb71fc400, 0xf851a600, 0x9c099d00, 0x200d0080, 0x7e07ccc0, 0x29b50720, 0x6e537b50, 0x89b70878, 0x8aecbd3c, 0xded78922, 0xd4fde253, 
    0x80000000, 0x40000000, 0xa0000000, 0x50000000, 0xc8000000, 0x74000000, 0x7e000000, 0x1f000000, 0xc0800000, 0x86400000, 0x46600000, 0x25f00000, 0xd2180000, 0x908c0000, 0x33060000, 0x3e9d0000, 0x1f2e8000, 0xc9a84000, 0xa8f42000, 0xe47ad000, 0x9a834800, 0xd8beec00, 0xc8401600, 0x21601d00, 0xa9714280, 0xc658d5c0, 0x0becc360, 0xc37702f0, 0xcb4529f8, 0x9003f1bc, 0xdfff1d62, 0xa1a0b3f1, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0x48000000, 0xfc000000, 0xde000000, 0x83000000, 0x77800000, 0xb4c00000, 0x58200000, 0xaf500000, 0xcd980000, 0xc64c0000, 0x88e20000, 0x55fd0000, 0x3a0b8000, 0xad784000, 0x373d2000, 0x7d2bd000, 0x5ba85800, 0xd564ac00, 0x20c7be00, 0xeadaf300, 0x48207f80, 0x87516740, 0xc1986b20, 0x004c1d70, 0xbfe35538, 0x007ca774, 0xd3caad22, 0x01d99273, 
    0x80000000, 0xc0000000, 0x20000000, 0x70000000, 0xf8000000, 0xdc000000, 0xca000000, 0xe1000000, 0xee800000, 0x43c00000, 0x4c600000, 0xc6b00000, 0xf5980000, 0x99ac0000, 0x10ea0000, 0x78bd0000, 0xfba38000, 0x1c394000, 0x007d6000, 0xd043b000, 0x03c85800, 0x6445e400, 0xcc3e3a00, 0x398ba900, 0xf68c3580, 0xbefb3dc0, 0x6a753ee0, 0x496621f0, 0x6fc66b38, 0xcf970164, 0xf97e3ce2, 0x7a2bdcf3, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0x28000000, 0x3c000000, 0xa2000000, 0x7f000000, 0xc3800000, 0x53400000, 0x34600000, 0x44300000, 0xbb680000, 0xc06c0000, 0xf6420000, 0x0f7d0000, 0xc77a8000, 0x3b49c000, 0x27bce000, 0xa45a9000, 0xad191800, 0x21e59400, 0xd5de4600, 0xeaf7a300, 0xa17b8880, 0x8248d7c0, 0x4d3d4ae0, 0xe59b1010, 0xfcb9c7b8, 0x8275d0d4, 0x2c26f4e2, 0xcde3b711, 
    0x80000000, 0xc0000000, 0xa0000000, 0xf0000000, 0xb8000000, 0x1c000000, 0x46000000, 0x6d000000, 0x5a800000, 0x49c00000, 0x67200000, 0x1a300000, 0x1e480000, 0xf6240000, 0x492a0000, 0x16f50000, 0x08738000, 0x73a84000, 0x28b46000, 0x1c123000, 0x1778d800, 0x03ec7c00, 0x4a4fa200, 0xec3ed900, 0x8117b980, 0x2a638340, 0x92500be0, 0xfc9878d0, 0x107c8528, 0xb5f61944, 0x1c7311e2, 0xf1a8edd3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x50000000, 0xc8000000, 0x5c000000, 0x8a000000, 0xb1000000, 0xa2800000, 0x59c00000, 0xc5200000, 0x26b00000, 0xc2c80000, 0xb7a40000, 0x3f4e0000, 0x29f50000, 0x30178000, 0x25284000, 0x27b52000, 0xd076d000, 0x58791800, 0xcf6d0400, 0x01ea9a00, 0x703bf100, 0x5e22c180, 0xb71fb740, 0xbdac8ae0, 0x7f4a9dd0, 0x01cbaf28, 0x120b548c, 0xc62a28e2, 0x121ab8d3, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0xf8000000, 0x34000000, 0x9e000000, 0x3d000000, 0x78800000, 0xfcc00000, 0xf5200000, 0x3b500000, 0xc2180000, 0x07c40000, 0x37760000, 0x03750000, 0x1a1f8000, 0xc7784000, 0xcb74e000, 0x161eb000, 0xcd780800, 0xd8754c00, 0xab9f5200, 0x7d39ad00, 0x4f95f380, 0x58ee3340, 0xfcf0d320, 0x76886470, 0x9d7da028, 0xf3a24f5c, 0xadfb6922, 0x47de3573, 
    0x80000000, 0xc0000000, 0xa0000000, 0x30000000, 0xc8000000, 0x4c000000, 0x86000000, 0xeb000000, 0xa8800000, 0xfdc00000, 0xb9a00000, 0x16300000, 0x72280000, 0xc6fc0000, 0x714e0000, 0x1ead0000, 0xa1f78000, 0x6fc84000, 0xc92de000, 0x06b6d000, 0x62a9f800, 0xdf3d1c00, 0x92ee0e00, 0x9d9d3d00, 0x145e3d80, 0x3674fa40, 0x91033be0, 0xf40b9110, 0xf2068898, 0x4040a14c, 0x43e12de2, 0x90d16013, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0xf8000000, 0x5c000000, 0x46000000, 0xe7000000, 0x49800000, 0x03c00000, 0x20e00000, 0x7cb00000, 0x0d780000, 0x5cd40000, 0x93e60000, 0x61450000, 0xffcf8000, 0x04d84000, 0xe0c56000, 0x380eb000, 0xee395800, 0xb574fc00, 0x3ff63600, 0xe2adff00, 0xa4b3b980, 0xac622ac0, 0x26ea12e0, 0xd2e7a530, 0xdfc54bc8, 0x9d8e66bc, 0xf3f81ce2, 0x5e941633, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x08000000, 0x8c000000, 0x4a000000, 0x07000000, 0x2a800000, 0x6ec00000, 0x59600000, 0x2e700000, 0x44680000, 0xc3e40000, 0x88260000, 0x34350000, 0xaa5f8000, 0xe249c000, 0x12b56000, 0x4e9ed000, 0xdc28f800, 0x66450400, 0x6c37d600, 0xcaad2100, 0x8a134380, 0x1b6a3fc0, 0x89967560, 0x8ebc6410, 0x648b3628, 0x4326e11c, 0xf4b43b62, 0xd39e9113, 
    0x80000000, 0x40000000, 0x60000000, 0x10000000, 0x38000000, 0xa4000000, 0x02000000, 0xd1000000, 0x3c800000, 0xe8400000, 0x52a00000, 0xf9f00000, 0x1dd80000, 0x500c0000, 0xf3160000, 0x321d0000, 0x111e8000, 0x9279c000, 0x4b7ca000, 0x118eb000, 0xcf306800, 0x2638f400, 0x9fdc2a00, 0x4b7e5d00, 0x17690280, 0x3ef51440, 0x702ae760, 0x01321cf0, 0x0fdedaf8, 0x3598051c, 0x22ac0562, 0x7ae705f1, 
    0x80000000, 0x40000000, 0x60000000, 0x50000000, 0x58000000, 0xac000000, 0xfe000000, 0x7d000000, 0x35800000, 0x49400000, 0x22200000, 0x81700000, 0x5dd80000, 0xb5bc0000, 0x3cb20000, 0x9aad0000, 0x4bba8000, 0x7cf9c000, 0x3c4c2000, 0x7daa7000, 0x1470f800, 0x8c59cc00, 0x96fd6200, 0x61933700, 0xf55dd880, 0xbba3f740, 0x69a5ac60, 0x97ee25f0, 0x2c0f7298, 0x7f9e2854, 0x06561662, 0x3863aef1, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0x68000000, 0x74000000, 0x4e000000, 0xd9000000, 0x37800000, 0xc2c00000, 0xa0e00000, 0x68b00000, 0x83480000, 0x4c140000, 0x9f660000, 0x2b850000, 0xcdfe8000, 0x67a94000, 0xb2a52000, 0x292e9000, 0xd2104800, 0x1b58cc00, 0x384d1a00, 0x75ab5300, 0x416fe780, 0x11b046c0, 0x24c908e0, 0xc6d41550, 0x9b875648, 0x653485dc, 0xe3b77ae2, 0x523c1a51, 
    0x80000000, 0x40000000, 0x60000000, 0xf0000000, 0xc8000000, 0xd4000000, 0x32000000, 0x87000000, 0xc2800000, 0xe7400000, 0xf6600000, 0x29700000, 0xebc80000, 0x29c40000, 0x3c5a0000, 0xba950000, 0xc4028000, 0x47a9c000, 0x83b56000, 0x7f135000, 0x1f114800, 0xe2b97400, 0x520c6600, 0x2d9e0100, 0x9ace5080, 0x989641c0, 0x36aab860, 0x819d9550, 0xd967b468, 0x712279a4, 0x22b8f662, 0x720cb051, 
    0x80000000, 0x40000000, 0xa0000000, 0xd0000000, 0x18000000, 0xec000000, 0xc2000000, 0x5b000000, 0xb2800000, 0x0b400000, 0x76600000, 0xbd700000, 0xfcf80000, 0x61f40000, 0x6d2e0000, 0x40a50000, 0x6f468000, 0x73184000, 0x9d452000, 0x70f77000, 0xe0417800, 0xece13400, 0x32302e00, 0x6c994100, 0xb1849080, 0x565651c0, 0x0191e860, 0x96c92330, 0x416d9c08, 0xceaa952c, 0x55f39e62, 0x30572631, 
    0x80000000, 0x40000000, 0xa0000000, 0xf0000000, 0xc8000000, 0x7c000000, 0x02000000, 0xab000000, 0xbb800000, 0xeac00000, 0x3f600000, 0xe0700000, 0x22080000, 0xd4940000, 0x15fa0000, 0x50450000, 0xfc628000, 0x01e84000, 0xefa56000, 0x9552d000, 0x12401800, 0xa2211400, 0x5fd0ee00, 0xda189300, 0x676d1380, 0xdea7f1c0, 0x17cb1160, 0x186cecd0, 0x0b26dec8, 0xcc0a1a64, 0x738c8762, 0x0c16bbd1, 
    0x80000000, 0x40000000, 0x60000000, 0x70000000, 0xc8000000, 0x54000000, 0x52000000, 0x83000000, 0x49800000, 0xb8400000, 0x01200000, 0x64300000, 0x3a180000, 0xb4d40000, 0xddda0000, 0x4c850000, 0x4a528000, 0x0cb9c000, 0x05a46000, 0x3a635000, 0x04a14800, 0x4271b400, 0x66396e00, 0xa464d700, 0x5b03e680, 0x8db13940, 0xd2599ce0, 0x6df5b070, 0x55ebd2c8, 0xb89c2f04, 0x7b87dae2, 0x49e28371, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0xa8000000, 0x24000000, 0x76000000, 0x1b000000, 0x54800000, 0xdac00000, 0x58e00000, 0x56d00000, 0x5a980000, 0x7c040000, 0x209a0000, 0xa9f50000, 0x39b38000, 0xf2f9c000, 0x4614a000, 0x59e39000, 0x47a06800, 0x31703c00, 0x5be8be00, 0x7fed6500, 0x4376d380, 0x108350c0, 0x60317420, 0xab4972f0, 0x781d1ca8, 0xf75f3184, 0x640f0222, 0x01d6bbf3, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0x68000000, 0x74000000, 0x8e000000, 0x27000000, 0x19800000, 0x54400000, 0x85600000, 0xa6500000, 0x25980000, 0x5d3c0000, 0x96620000, 0xb3cd0000, 0x848a8000, 0x48584000, 0x5c1da000, 0x7d539000, 0xd404c800, 0x1a2f4c00, 0xd006e600, 0xee338f00, 0x3954f680, 0x843731c0, 0xfc7b4820, 0x51b197f0, 0xbc0921d8, 0x44841574, 0xa0ee4622, 0xd0a684f1, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x88000000, 0x54000000, 0x56000000, 0x4f000000, 0x5a800000, 0xb9400000, 0xeda00000, 0xd7500000, 0xe0180000, 0x20f40000, 0x0c6a0000, 0x31c50000, 0x1bc38000, 0x6dd8c000, 0xd715a000, 0x161ad000, 0x6acd8800, 0xa90e3c00, 0x38d6f600, 0x1dc2b900, 0x8ad9bc80, 0x2995a640, 0x615a8020, 0x146c1d70, 0x26dfce48, 0x788ef064, 0xc517de22, 0xb2228873, 
    0x80000000, 0x40000000, 0x60000000, 0x90000000, 0xb8000000, 0x94000000, 0xd2000000, 0x33000000, 0x71800000, 0xc1c00000, 0x9e200000, 0xbab00000, 0x44a80000, 0xd93c0000, 0xe1b60000, 0xc5ed0000, 0xdc4e8000, 0x72e9c000, 0x47dda000, 0x77a7b000, 0xa3b50800, 0x323a5400, 0x28f28e00, 0x7c9fe700, 0xb111d580, 0x85d99740, 0x7cb5c2e0, 0x25baab10, 0xf832d818, 0x883fa3bc, 0x97e164e2, 0xd8916811, 
    0x80000000, 0x40000000, 0x20000000, 0xd0000000, 0xb8000000, 0xbc000000, 0xde000000, 0x29000000, 0x2e800000, 0x41400000, 0x09600000, 0x86b00000, 0x86680000, 0xb3f40000, 0x7dca0000, 0xbfe50000, 0x13328000, 0xb0a94000, 0xfd552000, 0x975b3000, 0x045dd800, 0xef1e4c00, 0x437e6a00, 0x3d4fc100, 0x27666080, 0xb97357c0, 0xf04923e0, 0xa5242410, 0x1b926388, 0x1f3833c4, 0x0e6d31e2, 0xbf37d911, 
    0x80000000, 0x40000000, 0x60000000, 0x30000000, 0xd8000000, 0x6c000000, 0xf6000000, 0x7d000000, 0xfa800000, 0xc1c00000, 0x33a00000, 0x42900000, 0xedb80000, 0xeb640000, 0xcb3a0000, 0x5d150000, 0xa8728000, 0xb3f9c000, 0xaf84e000, 0xddcb7000, 0x549db800, 0xa2bedc00, 0x25dfe200, 0x6a6ff900, 0x26878980, 0xc4fa6a40, 0x0fb47aa0, 0x5e620e30, 0xbe8182e8, 0xa3c15084, 0x84a040a2, 0xdb119b31, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0xd8000000, 0x2c000000, 0x76000000, 0x57000000, 0x67800000, 0xb9c00000, 0xdca00000, 0xb9900000, 0x1c880000, 0x7e940000, 0x5a7e0000, 0x41e50000, 0x38078000, 0x9bc8c000, 0x1775e000, 0x9f0e7000, 0x129d3800, 0xdaaadc00, 0xaefa3600, 0xf4d2c300, 0xf2d72d80, 0xb4a00e40, 0x8d917ca0, 0xa6896650, 0x6f942508, 0xb2fe546c, 0xb3a412a2, 0x2b67c953, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xb8000000, 0x1c000000, 0xe2000000, 0x11000000, 0x8e800000, 0xf8400000, 0x56e00000, 0x95f00000, 0x9cd80000, 0x4aac0000, 0xe1ea0000, 0x5d7d0000, 0xf7638000, 0xb699c000, 0x054da000, 0x2e9bb000, 0x6fe51800, 0xbc2f3400, 0xa303da00, 0x41287900, 0xa275e280, 0x8d4768c0, 0x43974f60, 0x6f9e7e70, 0x3a3b1fb8, 0x71f48ce4, 0x0187ad62, 0x90374373, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0x58000000, 0xcc000000, 0x62000000, 0x8b000000, 0x6a800000, 0x6cc00000, 0xb8600000, 0x8a100000, 0xd1380000, 0xcad40000, 0x4cf60000, 0x4ce50000, 0xd07f8000, 0xe3f94000, 0x53b52000, 0x9366f000, 0x659c3800, 0x7f0bf400, 0xb0ffce00, 0x20383100, 0x0754bf80, 0x58b6ddc0, 0x1b4419a0, 0x1c8f6cb0, 0x7a104888, 0x1939101c, 0x7ed54fa2, 0xb2f719b3, 
    0x80000000, 0xc0000000, 0xa0000000, 0x70000000, 0x08000000, 0xfc000000, 0x3e000000, 0x97000000, 0x56800000, 0xbfc00000, 0xb5a00000, 0x5d900000, 0xd7f80000, 0x95f40000, 0xc79e0000, 0xb6850000, 0xfe978000, 0x05384000, 0x4bd56000, 0xf64f5000, 0xec9c1800, 0x0913ec00, 0xd62e9600, 0x41acb100, 0xa4fa8180, 0x6e629e40, 0x8527c8a0, 0xd711c2b0, 0xe63899c8, 0x1f55bd4c, 0x408fa6a2, 0xe8bd8fb3, 
    0x80000000, 0x40000000, 0xe0000000, 0x70000000, 0xa8000000, 0xd4000000, 0x4e000000, 0x9f000000, 0xc2800000, 0x39c00000, 0x26a00000, 0x16700000, 0xf0a80000, 0xe78c0000, 0x286e0000, 0x7e1d0000, 0xe4d68000, 0x0268c000, 0x0dac6000, 0x78de9000, 0x1a944800, 0x84eb4c00, 0x280e5600, 0xcc4c7900, 0xdbcf5d80, 0x43ec4040, 0x7c3ff360, 0x0a04aa10, 0x29d332f8, 0xd53bf00c, 0x9b570d62, 0x6429cf11, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x58000000, 0xbc000000, 0xa6000000, 0x1d000000, 0x7b800000, 0x16400000, 0x2e200000, 0xaa700000, 0x60f80000, 0xe1540000, 0x87b20000, 0xe5c50000, 0x26da8000, 0x22794000, 0xf694a000, 0x34d2f000, 0x4f145800, 0x65937c00, 0x81b40200, 0xaf231b00, 0xfaade680, 0x60677340, 0x3fb7c460, 0xb37e7fb0, 0x64f25d48, 0x04654014, 0xf8ebbe62, 0x7ba0a8b1, 
    0x80000000, 0xc0000000, 0x20000000, 0x50000000, 0xc8000000, 0x64000000, 0xde000000, 0xf5000000, 0x77800000, 0xbcc00000, 0x0e200000, 0x6e500000, 0x6ff80000, 0x0e540000, 0x03260000, 0x24650000, 0x31ef8000, 0x78794000, 0x02952000, 0xb507d000, 0xb6356800, 0x2c17ac00, 0x392c6200, 0x5d327300, 0xaf224380, 0x42ba1b40, 0x88df4920, 0x343181b0, 0xe7c96308, 0x7b9df23c, 0x47bae322, 0xa75fceb3, 
    0x80000000, 0xc0000000, 0x60000000, 0x30000000, 0x28000000, 0xec000000, 0xaa000000, 0x97000000, 0xe7800000, 0x93c00000, 0x5ce00000, 0xeb700000, 0x03c80000, 0x2dbc0000, 0x562e0000, 0xbb6d0000, 0x4d378000, 0xacc9c000, 0x9e3de000, 0xfbee9000, 0x2e8cb800, 0xb8c68400, 0x0a413600, 0xa6217b00, 0xf9109980, 0x55f8cec0, 0xffd5f560, 0x69424850, 0x105a1698, 0x8cfe224c, 0x5a741b62, 0xd593e753, 
    0x80000000, 0xc0000000, 0xa0000000, 0x90000000, 0x58000000, 0x9c000000, 0x9a000000, 0xa1000000, 0x89800000, 0x3a400000, 0xf8e00000, 0xa7b00000, 0xcc880000, 0x25dc0000, 0xfae20000, 0x2e4d0000, 0x81fb8000, 0xba884000, 0xb6dca000, 0x2663f000, 0x538d1800, 0xbc5a0400, 0xcb583a00, 0x55248700, 0x2516c680, 0x6023fac0, 0xc16c3fe0, 0xd2ead2d0, 0xda5043d8, 0x14b94a54, 0x80143de2, 0x5b5ee1d3, 
    0x80000000, 0xc0000000, 0xa0000000, 0xb0000000, 0x28000000, 0xe4000000, 0x1a000000, 0xe5000000, 0xa4800000, 0xbd400000, 0xe8e00000, 0xf7700000, 0x84980000, 0x71840000, 0x79de0000, 0xd4d50000, 0xb8178000, 0xb4984000, 0x9984e000, 0x3ddf1000, 0x7ed5a800, 0x7517e400, 0xf4184200, 0x3ec59d00, 0x303fa080, 0x2d2530c0, 0x4ccf7060, 0x6d7c9af0, 0xb06a90e8, 0x60735a0c, 0xe4b7fa62, 0x8188b3f3, 
    0x80000000, 0x40000000, 0x20000000, 0x10000000, 0x08000000, 0x5c000000, 0x26000000, 0x43000000, 0xe2800000, 0x94400000, 0xfb600000, 0x71500000, 0x92b80000, 0x8b1c0000, 0x4b2e0000, 0xe9a50000, 0xb8328000, 0xc68b4000, 0x3397a000, 0x4fb9d000, 0x2e9c5800, 0x6fee3c00, 0xaf850e00, 0xbd83a100, 0x4ca21a80, 0x819359c0, 0xd2fb5920, 0x761f6630, 0xc2cc96d8, 0x78d6694c, 0x105943a2, 0xb88c3ff1, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0x08000000, 0x74000000, 0xce000000, 0xff000000, 0xf6800000, 0xa1c00000, 0xd5a00000, 0xfe100000, 0x83380000, 0x0ed40000, 0xe13a0000, 0xb5ed0000, 0x33ef8000, 0xfed7c000, 0xcf026000, 0xb8b85000, 0xdc954800, 0x32dbac00, 0x461ce600, 0xc4270900, 0x8d4a0980, 0x46644440, 0x6093fca0, 0xc0c1cbb0, 0x0421e548, 0xc5515564, 0x3559f522, 0x68658ff3, 
    0x80000000, 0x40000000, 0xe0000000, 0x90000000, 0x18000000, 0xdc000000, 0x6a000000, 0x21000000, 0x02800000, 0x37c00000, 0x34e00000, 0xd1300000, 0xeef80000, 0x70ac0000, 0xc48a0000, 0xb2550000, 0x16268000, 0x73dec000, 0x80f2a000, 0x01387000, 0x384dd800, 0x0fba0400, 0xf5adea00, 0xa00bd900, 0x36958180, 0x4d475ac0, 0xe5af7ae0, 0x902ac6b0, 0xfcc5e178, 0xd5ce0544, 0x15dafb62, 0xb15d9c71, 
    0x80000000, 0xc0000000, 0xa0000000, 0xd0000000, 0x18000000, 0xac000000, 0x9e000000, 0xff000000, 0xeb800000, 0x8f400000, 0x7de00000, 0x84700000, 0xd2580000, 0x9cfc0000, 0xb5160000, 0xdaa50000, 0x0beb8000, 0xb6b24000, 0xb9cf2000, 0x5f99f000, 0xaedc3800, 0x6a47ec00, 0xd72c3600, 0x1c5e0300, 0x9fb0c480, 0x0b79cec0, 0x4a2d4f60, 0x4edf6ef0, 0x0871d858, 0x5c581bbc, 0xdbfd8be2, 0x2296a033, 
    0x80000000, 0x40000000, 0x20000000, 0x30000000, 0x38000000, 0x9c000000, 0x6e000000, 0x3d000000, 0x1a800000, 0x5e400000, 0x36600000, 0x19100000, 0x67580000, 0xc5340000, 0x6fb60000, 0xd66d0000, 0x30828000, 0x5edb4000, 0x3b6fe000, 0xdd99b000, 0xd8159800, 0xde468c00, 0x34645200, 0xcf8f2100, 0x56c86280, 0xcf2c1fc0, 0xab62f1a0, 0xec0a73f0, 0x4d964408, 0x761ccd3c, 0x274a9322, 0xb5766c31, 
    0x80000000, 0xc0000000, 0x60000000, 0x70000000, 0xa8000000, 0x7c000000, 0x86000000, 0x11000000, 0x79800000, 0x6a400000, 0x5d600000, 0xbb300000, 0x2b680000, 0x27f40000, 0x8fde0000, 0xc29d0000, 0x752b8000, 0x7ac3c000, 0xc0f66000, 0x05091000, 0x06455800, 0x4c767c00, 0xe4c86a00, 0xca65d700, 0x9ca7c280, 0xa25087c0, 0x7259a3e0, 0x2f9cf390, 0x4aaabbc8, 0x6182f7cc, 0x94166162, 0x7c787453, 
    0x80000000, 0xc0000000, 0x20000000, 0x30000000, 0x18000000, 0x9c000000, 0x96000000, 0x0b000000, 0xdf800000, 0x3e400000, 0x8de00000, 0x3f300000, 0x33c80000, 0xa83c0000, 0x985a0000, 0xe9f50000, 0xe1678000, 0x3b2f4000, 0x5652e000, 0xa468f000, 0xe0ec9800, 0x31a33c00, 0x0a807e00, 0xbec01b00, 0x6e203e80, 0xa591fec0, 0x47999be0, 0x440587d0, 0xf28f6558, 0x81832484, 0xf011a562, 0x24d87913, 
    0x80000000, 0xc0000000, 0x20000000, 0xb0000000, 0x88000000, 0xcc000000, 0xea000000, 0x81000000, 0x08800000, 0x23c00000, 0x62200000, 0x06700000, 0x9dc80000, 0xe5bc0000, 0xde7e0000, 0x31750000, 0x1f438000, 0xb6cb4000, 0xf517e000, 0xe379d000, 0xdbd53800, 0xfaf3e400, 0x6923ea00, 0xa6dbcd00, 0x28cfc980, 0xc31da340, 0xd1cee860, 0x6f9d0150, 0x440ef858, 0x5ebd51cc, 0x8fff21e2, 0xce35a213, 
    0x80000000, 0xc0000000, 0xe0000000, 0x50000000, 0x68000000, 0x44000000, 0x96000000, 0xff000000, 0x25800000, 0xa5400000, 0x92e00000, 0x1dd00000, 0x38980000, 0x171c0000, 0x7b4e0000, 0x64850000, 0xc7d38000, 0xd98ac000, 0xfe362000, 0xe3c99000, 0x85446800, 0xfef29c00, 0xc87a0600, 0x07dfbf00, 0x98fc5080, 0xd21f5cc0, 0xefdc7420, 0x40ef2d70, 0x89b5ced8, 0xb39ae3cc, 0x008e24a2, 0xc0a571b3, 
    0x80000000, 0xc0000000, 0xe0000000, 0x90000000, 0x58000000, 0xe4000000, 0xca000000, 0x4d000000, 0xd7800000, 0x3dc00000, 0x7ca00000, 0xe4900000, 0x9fe80000, 0x6a7c0000, 0x1e020000, 0x32950000, 0xceff8000, 0xb6d6c000, 0x750ba000, 0x5c19f000, 0x96a4a800, 0x5b87c400, 0x2443c200, 0x0bf5c300, 0xc2cefd80, 0xcfafb840, 0x719f97a0, 0xd1e62a10, 0x00f3a318, 0x41cdedb4, 0x52bb6a22, 0x16a09253, 
    0x80000000, 0x40000000, 0xa0000000, 0x10000000, 0x88000000, 0x54000000, 0xca000000, 0xb7000000, 0x68800000, 0x11400000, 0x25600000, 0x63100000, 0xc7680000, 0xcadc0000, 0x4e8a0000, 0x50b50000, 0x0bd68000, 0x4ffe4000, 0x2b43a000, 0x4059d000, 0x23c54800, 0xc42fe400, 0x418bf600, 0xb4357d00, 0xac97b080, 0x539e01c0, 0xd5d3eba0, 0x1df04f90, 0x7fb9e7d8, 0x6a951524, 0xf8a65b22, 0xc0074e51, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0x28000000, 0x34000000, 0x2a000000, 0x3f000000, 0x29800000, 0xd6400000, 0x5da00000, 0x4e300000, 0xa7980000, 0x96740000, 0x81660000, 0x8ced0000, 0x75928000, 0x384ac000, 0x7d9fe000, 0x5fc81000, 0x4e3d4800, 0x641ba400, 0x77d72600, 0xa9b5bf00, 0xaa86ae80, 0x4f7c6240, 0x843bade0, 0x15a6f3f0, 0x748d7b48, 0x474350dc, 0xa1c30362, 0xd60391b1, 
    0x80000000, 0xc0000000, 0x60000000, 0x90000000, 0x18000000, 0xec000000, 0x12000000, 0x2d000000, 0x1b800000, 0x7a400000, 0x11200000, 0x97700000, 0x53280000, 0xbd3c0000, 0x222e0000, 0xbd150000, 0x7b938000, 0xb3fbc000, 0x2667a000, 0x2c787000, 0xace5b800, 0x617bf400, 0x61a79200, 0xf4197b00, 0x9e341280, 0xf1e38b40, 0x1353a760, 0x851b2f90, 0xf9773e58, 0x5580f0ac, 0x6d41b5e2, 0x23a1a4d3, 
    0x80000000, 0x40000000, 0xa0000000, 0x90000000, 0xb8000000, 0x24000000, 0x52000000, 0xb1000000, 0xdf800000, 0xa7c00000, 0xcbe00000, 0xc2b00000, 0x83b80000, 0xe18c0000, 0x444e0000, 0xdd350000, 0x5d428000, 0x323a4000, 0xaad6a000, 0x8269b000, 0xc3c4a800, 0xa0dbb400, 0xcbe67a00, 0xe011a300, 0x22a90180, 0xd4a58ec0, 0x9b2a47e0, 0xd3fe5830, 0x330df238, 0x9a0f9b4c, 0x4a154662, 0x8e92d6f1, 
    0x80000000, 0xc0000000, 0xe0000000, 0xb0000000, 0x98000000, 0x5c000000, 0x1e000000, 0xdd000000, 0xce800000, 0xc3c00000, 0x9be00000, 0x92700000, 0x89680000, 0x31240000, 0xfa560000, 0xd6cd0000, 0x98b38000, 0x7f7ac000, 0xa80fe000, 0xb4a07000, 0x79519800, 0xeb79ac00, 0xcb7d5200, 0x9c3a2900, 0x952fb980, 0x7fb1acc0, 0x9788c460, 0xd1d49f90, 0x1effa6e8, 0x39087d5c, 0x6214fde2, 0xfd1ff353, 
    0x80000000, 0xc0000000, 0x60000000, 0x10000000, 0xf8000000, 0xdc000000, 0x3e000000, 0x57000000, 0xa6800000, 0xd4400000, 0xde200000, 0x15700000, 0xa2780000, 0x178c0000, 0x5aca0000, 0x43750000, 0xc1078000, 0x6b9fc000, 0x4102a000, 0x7be1b000, 0x7990d800, 0xdd696c00, 0x6ea4c600, 0x024f7900, 0x704bc280, 0xf134a340, 0xe4272160, 0x0e6ffd30, 0x443b4138, 0xf6cc6fc4, 0x8b6b63e2, 0x13c49e73, 
    0x80000000, 0xc0000000, 0xe0000000, 0x30000000, 0x88000000, 0xe4000000, 0x7e000000, 0x3f000000, 0x37800000, 0xf4400000, 0x4ee00000, 0xbcb00000, 0x5c480000, 0xdf040000, 0xe4320000, 0x88cd0000, 0x2d778000, 0xef1ec000, 0xbb8ae000, 0x94e05000, 0xddb1e800, 0x84c84c00, 0xa4c4c600, 0x32924b00, 0xe09da280, 0x8c8ff0c0, 0x64d240e0, 0x437d42d0, 0x42bee228, 0x8a5bfc54, 0xa6586262, 0x731c7213, 
    0x80000000, 0xc0000000, 0x20000000, 0xd0000000, 0x48000000, 0x9c000000, 0xae000000, 0x0f000000, 0xc6800000, 0x2e400000, 0x57a00000, 0x5cf00000, 0x76f80000, 0xd67c0000, 0x9b560000, 0xe0050000, 0xc06b8000, 0xfc734000, 0x59df2000, 0xa1c05000, 0x3c615800, 0x25902c00, 0x10e81600, 0x8b557900, 0xda622680, 0xe4f76040, 0x10f5f660, 0xa0925330, 0x210f06d8, 0x7e087dfc, 0x528450e2, 0xcc2a7373, 
    0x80000000, 0xc0000000, 0xe0000000, 0x10000000, 0x88000000, 0xe4000000, 0x72000000, 0x9d000000, 0x3b800000, 0x2d400000, 0x70600000, 0x16100000, 0x70980000, 0xeb040000, 0x39fa0000, 0x2a1d0000, 0xdebf8000, 0xa606c000, 0xd4f2a000, 0x24c05000, 0xe021a800, 0xadf01400, 0xd3c9c200, 0x87fc4b00, 0x52ee4c80, 0x8c7e49c0, 0xb927bba0, 0x57836c70, 0x05c82068, 0x48fd2e24, 0x046e7722, 0x02bfe5b3, 
    0x80000000, 0x40000000, 0xe0000000, 0x30000000, 0xe8000000, 0x34000000, 0x3a000000, 0xbf000000, 0x34800000, 0x5d400000, 0x78200000, 0x7c700000, 0xacd80000, 0x6a240000, 0xe6720000, 0x747d0000, 0x10168000, 0x53aec000, 0xcadbe000, 0x2c819000, 0x21414800, 0xa6200400, 0x2170a600, 0xfb59a500, 0x0de5d880, 0x46139340, 0xfbac5560, 0xa97ffa70, 0xb032a668, 0x42dd7df4, 0x6e270de2, 0x83d6a931, 
    0x80000000, 0xc0000000,