---
layout: post
title: Polyglot 1.12 - 리디렉션 개선 및 커뮤니티 기여
lang: ko
description: Jekyll Polyglot 1.12.0은 하위 언어에 대한 향상된 리디렉션 지원, 폴백 페이지 감지 및 새로운 사이트 언어 지원을 제공합니다
---

Jekyll-Polyglot `1.12.0`이 출시되었습니다! 이번 릴리스는 리디렉션 처리 개선에 중점을 두고 있으며 여러 커뮤니티 기여를 포함합니다.

## 리디렉션 개선

이번 릴리스에는 Polyglot에서 리디렉션이 작동하는 방식에 대한 중요한 개선 사항이 포함되어 있습니다:

- **PR #275**: 리디렉션에서 앵커 태그 보존 - [@GruberMarkus](https://github.com/GruberMarkus)의 솔루션 덕분에 리디렉션 URL이 이제 앵커 태그를 올바르게 보존하여 사용자가 정확히 원하는 곳에 도달하도록 합니다.

- **PR #293**: jekyll-redirect-from 플러그인에 대한 하위 언어 리디렉션 지원 - [@rathboma](https://github.com/rathboma)의 제안으로, Polyglot은 이제 하위 언어 전체에서 `redirect_from` 프론트매터를 올바르게 범위 지정하여 중복 리디렉션을 방지하고 기본 언어가 아닌 페이지에 대한 올바른 라우팅을 보장합니다.

## page.rendered_lang로 폴백 페이지 감지

- **PR #283**: 새로운 `page.rendered_lang` 변수 - [@rathboma](https://github.com/rathboma)가 기여한 이 새로운 liquid 변수를 사용하면 페이지가 폴백으로 렌더링될 때 감지할 수 있습니다. `page.rendered_lang != site.active_lang`일 때 페이지 콘텐츠가 아직 번역되지 않았음을 알 수 있습니다.

[/about](/about) 페이지가 이 `page.rendered_lang` 편의 liquid 변수를 가장 잘 사용하는 방법에 대한 지침으로 업데이트되었습니다.

## 새로운 언어 지원

- **PR #280**: 이탈리아어 및 터키어 언어 지원이 Polyglot 문서 사이트에 추가되어 다국어 범위를 확장했습니다.

## 커뮤니티 기여

여러 커뮤니티 멤버들이 프로젝트에 개선 사항을 기여했습니다:

- **PR #277**: 업데이트된 사이드바 리치 텍스트 정의로 사이트의 다국어 프레젠테이션이 개선되었습니다.

- **PR #288**: [@manabu-nakamura](https://github.com/manabu-nakamura)가 기여한 일본어 리치 텍스트 문자열로 일본어 경험이 향상되었습니다.

인기 있는 Minimal Mistakes 테마와 Polyglot을 통합하는 방법을 보여주는 [jekyll-minimal-mistakes-polyglot](https://github.com/PanderMusubi/jekyll-minimal-mistakes-polyglot) 데모를 제공해 주신 [@PanderMusubi](https://github.com/PanderMusubi)에게 특별히 감사드립니다.

이번 릴리스를 가능하게 해주신 모든 기여자분들께 감사드립니다!
