#!/bin/sh
#
# # Copyright (C) 1993,1994 by the author(s).
# 
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with ShapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# $Header: shape_conf.sh[4.0] Mon Jun  6 13:29:43 1994 andy@cs.tu-berlin.de frozen $
#

base=$1

trap "if [ ! -f Makefile ]; then mv $savename Makefile; fi; rm -f Makefile.new; exit 1" 1 2 13 15

# test if echo command interprets -n option
xxx=`echo -n`

if [ -z "$xxx" ]
  then
    echolead=-n
    echotrail=
  else
    echolead=
    echotrail="""\c"""
fi

echo
echo "Configure the shapeTools-1.4pl6 build/installation procedure ..."

# base path (BASE)

if [ -z "$base" ] # if path is not given as argument
  then
    base=`pwd`
    # check if the current directory is the ShapeTools distribution root directory
    if [ ! -f shape_conf.sh ]
      then
        echo "Where did you place the shapeTools-1.4pl6 distribution (root directory) ?"
        echo $echolead "[Default: $base] > " $echotrail
        read input
        if [ -n "$input" ]
          then
            base=$input
        fi
    fi
fi

grep ShapeTools $base/Makefile > /dev/null 2>&1
retval=$?

while [ $retval -ne 0 ]
  do
    echo "This seems not to be the right directory."
    echo "Where did you place the shapeTools-1.4pl6 distribution (root directory) ?"
    echo $echolead "[Default: $base] > " $echotrail
    read input
    base=$input
    grep ShapeTools $base/Makefile > /dev/null 2>&1
    retval=$?
  done

# Operating System type (HOSTSYSTEM)

hostsystem=`grep HOSTSYSTEM $base/Makefile | head -1 | \
	sed -e 's/HOSTSYSTEM//' -e 's/[= ]//g' -e 's/s_//'`
echo
echo "Please enter the operating system type. Supported platforms are:"
echo "    aix -- (IBM/AIX)            hpux  -- (HP/UX)"
echo "    irix -- (SGI/IRIX)          mach  -- (NeXT/Mach)"
echo "    sunos_4 -- (SunOS 4.x.x)    svr_4 -- (SysV R4, Solaris 2)"
echo "    ultrix -- (DEC/Ultrix)      linux -- (Linux 0.99pl14+)"
echo "    for others see the README file."
echo $echolead "[Default: $hostsystem] > " $echotrail
read input
if [ -n "$input" ]
  then
    hostsystem=s_$input
  else
    hostsystem=s_$hostsystem
fi

# machine architecture (HOSTTYPE)

hosttype=`(aa=\`arch\`; echo $aa) 2> /dev/null`

# Compiler and compile flags (CC, MAKECFLAGS, MAKELDFLAGS)

cc=`grep CC $base/Makefile | head -1 | sed -e 's/CC//' -e 's/[= ]//g' -e 's/=//'`
makecflags=`grep MAKECFLAGS $base/Makefile | head -1 | sed -e 's/MAKECFLAGS//' -e 's/[ ]*=[ ]*//'`
makeldflags=`grep MAKELDFLAGS $base/Makefile | head -1 | sed -e 's/MAKELDFLAGS//' -e 's/[ ]*=[ ]*//'`

case $hostsystem in
  s_aix)     makecflags="$makecflags -D_POSIX_SOURCE"
	     ;;
  s_hpux)    makecflags="$makecflags -Aa -D_HPUX_SOURCE"
	     ;;
  s_mach)    makecflags="$makecflags -DATFS_OWN_LOCKING"
	     ;;
esac

echo
echo "Do you want to change any of the following macro definitions ?"
echo "(Check the 'Important Hints' section in the INSTALL file for details)"
echo "   CC      = $cc"
echo "   CFLAGS  = $makecflags"
echo "   LDFLAGS = $makeldflags"
echo $echolead "[Default: no] > " $echotrail
read input

if [ "$input" = "yes" -o "$input" = "y" ]
  then
    echo
    echo $echolead "CC      = [Default: $cc] " $echotrail
    read input
    if [ -n "$input" ]
      then
        cc=$input
    fi
    echo $echolead "CFLAGS  = [Default: $makecflags] " $echotrail
    read input
    if [ -n "$input" ]
      then
        makecflags=$input
    fi
    echo $echolead "LDFLAGS = [Default: $makeldflags] " $echotrail
    read input
    if [ -n "$input" ]
      then
        makeldflags=$input
    fi
fi

case $hostsystem in
  s_aix)     syslibs="-lPW"
	     ;;
  s_hpux)    syslibs="-lPW"
	     ;;
  s_irix)    syslibs="-lsun"
	     ;;
  s_svr_4)   syslibs="-lnsl -lgen"
	     ;;
esac

# Determine subsystems to be included (SUBSYTEMS)

subsystems=`grep SUBSYSTEMS $base/Makefile | head -1 | \
	sed -e 's/SUBSYSTEMS//' -e 's/=//'`
subsystems=`echo $subsystems | sed -e 's.src/interface..' \
	-e 's.src/patches..' -e 's.tutorial..'`

doemacslisp=`grep DOEMACSLISP $base/Makefile | head -1 | \
	sed -e 's/DOEMACSLISP//' -e 's/[\= ]//g'`
echo
echo "Do you use 'GNU-emacs' on your machine ?  Do you want the"
echo "ShapeTools emacs lisp code to be compiled and installed too ?"
echo $echolead "[Default: $doemacslisp] > " $echotrail
read input

if [ "$input" = "no" -o "$input" = "n" ]
  then
    doemacslisp=no
fi
if [ "$input" = "yes" -o "$input" = "y" ]
  then
    doemacslisp=yes
fi
if [ "$doemacslisp" = "yes" ]
  then
    subsystems="$subsystems src/interface"
fi

# Determine whether libs and include files shall be installed.

dolibraries=`grep DOLIBRARIES $base/Makefile | head -1 | \
	sed -e 's/DOLIBRARIES//' -e 's/[\= ]//g'`

echo
echo "Do you want the ShapeTools internal C-libraries and header files"
echo "to be installed ?  You will need these when applying the patches"
echo "for 'gdb' and 'GNU-grep'"
echo $echolead "[Default: $dolibraries] > " $echotrail
read input

if [ "$input" = "no" -o "$input" = "n" ]
  then
    dolibraries=no
fi
if [ "$input" = "yes" -o "$input" = "y" ]
  then
    dolibraries=yes
fi

# Installation base (INSTALLBASE)

installbase=`grep INSTALLBASE $base/Makefile | head -1 | \
	sed -e 's/INSTALLBASE//' -e 's/[\= ]//g'`

echo
echo "Where shall shapeTools-1.4pl6 be installed ?"
echo "Please specify the installation base directory."
echo $echolead "[Default: $installbase] > " $echotrail
read input
if [ -n "$input" ]
  then
    if [ "$input" = "." ]
      then
	input=$base
    fi
    installbase=$input
fi

# Installation paths (INSTALL*PATH)

installbinpath=`grep INSTALLBINPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLBINPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installincpath=`grep INSTALLINCPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLINCPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installlibpath=`grep INSTALLLIBPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLLIBPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installshapelibpath=`grep INSTALLSHAPELIBPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLSHAPELIBPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installemacslisppath=`grep INSTALLEMACSLISPPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLEMACSLISPPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`
installmanpath=`grep INSTALLMANPATH $base/Makefile | head -1 | \
	sed -e 's/INSTALLMANPATH//' -e 's/[\= ]//g' -e s,\$\(INSTALLBASE\),$installbase,`

echo
echo "Install"
if [ -d $installbinpath ]
  then
    echo "...executables     in $installbinpath"
  else
    echo "...executables     in $installbinpath (does not exist)"
    bindirmissing=true
fi
if [ "$dolibraries" = "yes" ]
  then
    if [ -d $installincpath ]
      then
	echo "...header files    in $installincpath"
      else
	echo "...header files    in $installincpath (does not exist)"
	incdirmissing=true
    fi
    if [ -d $installlibpath ]
      then
	echo "...C-libraries     in $installlibpath"
      else
	echo "...C-libraries     in $installlibpath (does not exist)"
	libdirmissing=true
    fi
fi
if [ -d $installshapelibpath ]
  then
    echo "...shape libraries in $installshapelibpath"
  else
    echo "...shape libraries in $installshapelibpath (does not exist)"
    shapelibdirmissing=true
fi
if [ "$doemacslisp" = "yes" ]
  then
    if [ -d $installemacslisppath ]
      then
	echo "...emacs lisp code in $installemacslisppath"
      else
	echo "...emacs lisp code in $installemacslisppath (does not exist)"
	emacslispdirmissing=true
    fi
fi
if [ ! -d "$installmanpath/man1" ]
  then
    man1dirmissing=true
fi
if [ ! -d "$installmanpath/man7" ]
  then
    man7dirmissing=true
fi
if [ "$dolibraries" = "yes" ]
  then
    if [ ! -d "$installmanpath/man3" ]
      then
	man3dirmissing=true
    fi
    if [ ! -d "$installmanpath/man5" ]
      then
	man5dirmissing=true
    fi
    if [ "$man1dirmissing" = "true" ] || [ "$man3dirmissing" = "true" ] \
       || [ "$man5dirmissing" = "true" ] || [ "$man7dirmissing" = "true" ]
      then
	echo "...manuals         in $installmanpath/man{1,3,5,7} (at least one directory does not exist)"
      else
	echo "...manuals         in $installmanpath/man{1,3,5,7}"
    fi
  else
    if [ "$man1dirmissing" = "true" ] || [ "$man7dirmissing" = "true" ]
      then
	echo "...manuals         in $installmanpath/man{1,7} (at least one directory does not exist)"
      else
	echo "...manuals         in $installmanpath/man{1,7}"
    fi
fi
echo $echolead "Is this correct ? [Default: yes] > " $echotrail
read input
if [ "$input" = "no" -o "$input" = "n" ]
  then
    echo
    echo "Install executables in..."
    echo $echolead "[Default: $installbinpath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
	installbinpath=$input
	specialbinpath=true
    fi
    if [ "$dolibraries" = "yes" ]
      then
        echo
        echo "Install header files in..."
        echo $echolead "[Default: $installincpath] > " $echotrail
        read input
        if [ -n "$input" ]
          then
	    installincpath=$input
	    specialincpath=true
        fi
        echo
        echo "Install C-libraries in..."
        echo $echolead "[Default: $installlibpath] > " $echotrail
        read input
        if [ -n "$input" ]
          then
	    installlibpath=$input
	    speciallibpath=true
        fi
    fi
    echo
    echo "Install shape libraries in..."
    echo $echolead "[Default: $installshapelibpath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
	installshapelibpath=$input
	specialshapelibpath=true
    fi
    if [ "$doemacslisp" = "yes" ]
      then
        echo
        echo "Install emacs lisp files in..."
        echo $echolead "[Default: $installemacslisppath] > " $echotrail
        read input
        if [ -n "$input" ]
          then
	    installemacslisppath=$input
	    specialemacslisppath=true
        fi
    fi
    echo
    if [ "$dolibraries" = "yes" ]
      then
        echo "Install manuals in... (You need man{1,3,5,7} subdirectories there)"
      else
        echo "Install manuals in... (You need man{1,7} subdirectories there)"
    fi
    echo $echolead "[Default: $installmanpath] > " $echotrail
    read input
    if [ -n "$input" ]
      then
	installmanpath=$input
	specialmanpath=true
    fi
fi

# Create installation directories if necessary

echo
if [ "$bindirmissing" = "true" ] || [ "$specialbinpath" = "true" ] && [ ! -d $installbinpath ]
  then
    echo $echolead "'$installbinpath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installbinpath
    fi
fi
if [ "$incdirmissing" = "true" ] || [ "$specialincpath" = "true" ] && [ ! -d $installincpath ]
  then
    echo $echolead "'$installincpath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installincpath
    fi
fi
if [ "$libdirmissing" = "true" ] || [ "$speciallibpath" = "true" ] && [ ! -d $installlibpath ]
  then
    echo $echolead "'$installlibpath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installlibpath
    fi
fi
if [ "$shapelibdirmissing" = "true" ] || [ "$specialshapelibpath" = "true" ] && [ ! -d $installshapelibpath ]
  then
    echo $echolead "'$installshapelibpath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installshapelibpath
    fi
fi
if [ "$emacslispdirmissing" = "true" ] || [ "$specialemacslisppath" = "true" ] && [ ! -d $installemacslisppath ]
  then
    echo $echolead "'$installemacslisppath' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installemacslisppath
    fi
fi
if [ "$man1dirmissing" = "true" ] || [ "$specialmanpath" = "true" ] && [ ! -d $installmanpath/man1 ]
  then
    echo $echolead "'$installmanpath/man1' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installmanpath/man1
    fi
fi
if [ "$man3dirmissing" = "true" ] || [ "$specialmanpath" = "true" ] && [ ! -d $installmanpath/man3 ]
  then
    echo $echolead "'$installmanpath/man3' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installmanpath/man3
    fi
fi
if [ "$man5dirmissing" = "true" ] || [ "$specialmanpath" = "true" ] && [ ! -d $installmanpath/man5 ]
  then
    echo $echolead "'$installmanpath/man5' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installmanpath/man5
    fi
fi
if [ "$man7dirmissing" = "true" ] || [ "$specialmanpath" = "true" ] && [ ! -d $installmanpath/man7 ]
  then
    echo $echolead "'$installmanpath/man7' does not exist. Create ? [Default: y] > " $echotrail
    read input
    if [ "$input" != "no" -a "$input" != "n" ]
      then
	sh src/rms/mkpdir $installmanpath/man7
    fi
fi

awk "{  if ((\$1 == \"BASE\" && \$2 == \"=\") || \$1 == \"BASE=\")
	  print \"BASE = $base\"
	else if ((\$1 == \"HOSTSYSTEM\" && \$2 == \"=\") || \$1 == \"HOSTSYSTEM=\")
	  print \"HOSTSYSTEM = $hostsystem\"
	else if ((\$1 == \"HOSTTYPE\" && \$2 == \"=\") || \$1 == \"HOSTTYPE=\")
	  print \"HOSTTYPE = $hosttype\"
	else if ((\$1 == \"SYSLIBS\" && \$2 == \"=\") || \$1 == \"SYSLIBS=\")
	  print \"SYSLIBS = $syslibs\"
	else if ((\$1 == \"SUBSYSTEMS\" && \$2 == \"=\") || \$1 == \"SUBSYSTEMS=\")
	  print \"SUBSYSTEMS = $subsystems\"
	else if ((\$1 == \"CC\" && \$2 == \"=\") || \$1 == \"CC=\")
	  print \"CC = $cc\"
	else if ((\$1 == \"MAKECFLAGS\" && \$2 == \"=\") || \$1 == \"MAKECFLAGS=\")
	  print \"MAKECFLAGS = $makecflags\"
	else if ((\$1 == \"MAKELDFLAGS\" && \$2 == \"=\") || \$1 == \"MAKELDFLAGS=\")
	  print \"MAKELDFLAGS = $makeldflags\"
	else if ((\$1 == \"INSTALLBASE\" && \$2 == \"=\") || \$1 == \"INSTALLBASE=\")
	  print \"INSTALLBASE = $installbase\"
	else if ((\$1 == \"DOLIBRARIES\" && \$2 == \"=\") || \$1 == \"DOLIBRARIES=\")
	  print \"DOLIBRARIES = $dolibraries\"
	else if ((\$1 == \"DOEMACSLISP\" && \$2 == \"=\") || \$1 == \"DOEMACSLISP=\")
	  print \"DOEMACSLISP = $doemacslisp\"
	else print }" Makefile > Makefile.new

if [ "$specialbinpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLBINPATH\" && \$2 == \"=\") || \$1 == \"INSTALLBINPATH=\")
		print \"INSTALLBINPATH = $installbinpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$specialincpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLINCPATH\" && \$2 == \"=\") || \$1 == \"INSTALLINCPATH=\")
		print \"INSTALLINCPATH = $installincpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$speciallibpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLLIBPATH\" && \$2 == \"=\") || \$1 == \"INSTALLLIBPATH=\")
		print \"INSTALLLIBPATH = $installlibpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$specialshapelibpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLSHAPELIBPATH\" && \$2 == \"=\") || \$1 == \"INSTALLSHAPELIBPATH=\")
		print \"INSTALLSHAPELIBPATH = $installshapelibpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$specialemacslisppath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLEMACSLISPPATH\" && \$2 == \"=\") || \$1 == \"INSTALLEMACSLISPPATH=\")
		print \"INSTALLEMACSLISPPATH = $installemacslisppath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi
if [ "$specialmanpath" = "true" ]
  then
    awk "{  if ((\$1 == \"INSTALLMANPATH\" && \$2 == \"=\") || \$1 == \"INSTALLMANPATH=\")
		print \"INSTALLMANPATH = $installmanpath\"
	    else print }" Makefile.new > Makefile.tmp
    mv Makefile.tmp Makefile.new
fi

savename=Makefile.orig
echo
echo "Saving original Makefile to $savename."
mv Makefile $savename
mv Makefile.new Makefile

touch .configured
exit 0
