from sickle.common.lib.generic import modparser

class ShellcodeHandler():
    """This class is responsible for calling the appropriate shellcode module.

    :param payload: The shellcode module to use for shellcode stub generation
    :type payload: str

    :param arg_object: Arguments used by the shellcode module
    :type arg_object: dict
    """

    def __init__(self, payload, arg_object):
        
        self.payload = payload
        self.arg_object = arg_object

    def get_shellcode(self):
        """Calls the respective shellcode module and returns the generated bytecode
        to the caller.

        :return: Raw bytecode from assembly
        :rtype: bytes
        """

        payload_module = modparser.check_module_support("payloads", self.payload) 
        if (payload_module == None):
            return None

        sc_obj = payload_module.Shellcode(self.arg_object)
        bytecode = sc_obj.get_shellcode()
        
        return bytecode

    def print_stubs(print_info):
        """Prints all currently supported shellcode stubs along with a short
        description for each.
        """

        # Obtain the list objects of data we'll be parsing
        payloads = modparser.get_module_list("payloads")

        sc_objects = [modparser.check_module_support("payloads", sc).Shellcode
                     for sc in payloads]

        descriptions = [sc.summary for sc in sc_objects]

        arch_list = sorted(set([sc.arch for sc in sc_objects]))

        if print_info == 'all' or print_info == 'shellcode' or print_info == 'payloads':

            # Get the size of the largest payload string and description string
            max_name_len = len(max(payloads, key=len))
            if max_name_len <  0x0D:
                max_name_len = 0x0D
            
            max_info_len = len(max(descriptions, key=len))

            # Generate an object we can later parse for printing 
            stubs = {}

            for sc in sc_objects:
                
                platform = sc.platform
                summary = sc.summary
                name = sc.module
                arch = sc.arch
                ring = sc.ring

                if platform not in stubs.keys():
                    stubs[platform] = {}
                    stubs[platform]["kernel"] = []
                    stubs[platform]["userland"] = []

                sc_info = [name, arch, ring, summary]

                if ring == 3:
                    stubs[platform]["userland"].append(sc_info)
                elif ring == 0:
                    stubs[platform]["kernel"].append(sc_info)
                else:
                    pass

            # Output the results
            print(f"\n  {'Shellcode':<{max_name_len}} {'Ring'} {'Description'}")
            print(f"  {'---------':<{max_name_len}} {'----'} {'-----------'}")

            for platform in stubs.keys():
                userland_stubs = stubs[platform]["userland"]
                kernel_stubs = stubs[platform]["kernel"]
                space_used = max_name_len + 8
               
                for user in userland_stubs:
                    out_list = modparser.get_truncated_list(f"{user[3]}", space_used)
                    for i in range(len(out_list)):
                        if i != 0:
                            print(f"  {' ' * max_name_len} {' ':^4} {out_list[i]}")
                        else:
                            print(f"  {user[0]:<{max_name_len}} {user[2]:^4} {out_list[i]}")

                for kernel in kernel_stubs:
                    out_list = modparser.get_truncated_list(f"{kernel[3]}", space_used)
                    for i in range(len(out_list)):
                        if i != 0:
                            print(f"  {' ' * max_name_len} {' ':^4} {out_list[i]}")
                        else:
                            print(f"  {kernel[0]:<{max_name_len}} {kernel[2]:^4} {out_list[i]}")

        if (print_info == 'all' or print_info == 'archs' or print_info == 'architectures'):
            print("\n  Architectures")
            print("  -------------")
            for arch in arch_list:
                print(f"  {arch}")
