/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the MessageTemplate type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &MessageTemplate{}

// MessageTemplate struct for MessageTemplate
type MessageTemplate struct {
	// Template ID.
	Id int32 `json:"id"`
	// Template name.
	Name string `json:"name"`
	// Template text. May contain dynamic fields inside braces. See the [Custom fields list](https://docs.textmagic.com/#tag/Templates/Custom-fields-list-(Merge-dynamic-fields)).
	Content string `json:"content"`
	// Time when the template was last modified.
	LastModified NullableTime `json:"lastModified"`
}

type _MessageTemplate MessageTemplate

// NewMessageTemplate instantiates a new MessageTemplate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewMessageTemplate(id int32, name string, content string, lastModified NullableTime) *MessageTemplate {
	this := MessageTemplate{}
	this.Id = id
	this.Name = name
	this.Content = content
	this.LastModified = lastModified
	return &this
}

// NewMessageTemplateWithDefaults instantiates a new MessageTemplate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewMessageTemplateWithDefaults() *MessageTemplate {
	this := MessageTemplate{}
	return &this
}

// GetId returns the Id field value
func (o *MessageTemplate) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *MessageTemplate) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *MessageTemplate) SetId(v int32) {
	o.Id = v
}

// GetName returns the Name field value
func (o *MessageTemplate) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *MessageTemplate) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *MessageTemplate) SetName(v string) {
	o.Name = v
}

// GetContent returns the Content field value
func (o *MessageTemplate) GetContent() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Content
}

// GetContentOk returns a tuple with the Content field value
// and a boolean to check if the value has been set.
func (o *MessageTemplate) GetContentOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Content, true
}

// SetContent sets field value
func (o *MessageTemplate) SetContent(v string) {
	o.Content = v
}

// GetLastModified returns the LastModified field value
// If the value is explicit nil, the zero value for time.Time will be returned
func (o *MessageTemplate) GetLastModified() time.Time {
	if o == nil || o.LastModified.Get() == nil {
		var ret time.Time
		return ret
	}

	return *o.LastModified.Get()
}

// GetLastModifiedOk returns a tuple with the LastModified field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessageTemplate) GetLastModifiedOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastModified.Get(), o.LastModified.IsSet()
}

// SetLastModified sets field value
func (o *MessageTemplate) SetLastModified(v time.Time) {
	o.LastModified.Set(&v)
}

func (o MessageTemplate) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o MessageTemplate) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["name"] = o.Name
	toSerialize["content"] = o.Content
	toSerialize["lastModified"] = o.LastModified.Get()
	return toSerialize, nil
}

func (o *MessageTemplate) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"name",
		"content",
		"lastModified",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varMessageTemplate := _MessageTemplate{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varMessageTemplate)

	if err != nil {
		return err
	}

	*o = MessageTemplate(varMessageTemplate)

	return err
}

type NullableMessageTemplate struct {
	value *MessageTemplate
	isSet bool
}

func (v NullableMessageTemplate) Get() *MessageTemplate {
	return v.value
}

func (v *NullableMessageTemplate) Set(val *MessageTemplate) {
	v.value = val
	v.isSet = true
}

func (v NullableMessageTemplate) IsSet() bool {
	return v.isSet
}

func (v *NullableMessageTemplate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableMessageTemplate(val *MessageTemplate) *NullableMessageTemplate {
	return &NullableMessageTemplate{value: val, isSet: true}
}

func (v NullableMessageTemplate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableMessageTemplate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


