---
title: "Daemon Configuration"
description: "Explore Tetragon options and configuration mechanisms."
weight: 1
---

Tetragon default controlling settings are set during compilation, so configuration
is only needed when it is necessary to deviate from those defaults. This
document lists those controlling settings and how they can be set
as a CLI arguments or as configuration options from YAML files.

## Options

The following table list all Tetragon daemon available options and is
automatically generated using the tetragon binary `--generate-docs` flag. The
same information can also be retrieved using `--help`.

{{< tetragon-options >}}

## Configuration precedence

Tetragon controlling settings can also be loaded from [YAML](https://yaml.org/) configuration files according to this order:

1. From the drop-in configuration snippets inside the following directories
   where each filename maps to one controlling setting and the content of the
   file to its corresponding value:

   - `/usr/lib/tetragon/tetragon.conf.d/*`
   - `/usr/local/lib/tetragon/tetragon.conf.d/*`

2. From the configuration file `/etc/tetragon/tetragon.yaml` if available,
   overriding previous settings.

3. From the drop-in configuration snippets inside
   `/etc/tetragon/tetragon.conf.d/*`, similarly overriding previous settings.

4. If the `config-dir` setting is set, Tetragon loads its settings from the
   files inside the directory pointed by this option, overriding previous
   controlling settings. The `config-dir` is also part of [Kubernetes
   ConfigMap](https://kubernetes.io/docs/concepts/configuration/configmap/).

When reading configuration from directories, each filename maps to one
controlling setting. If the same controlling setting is set multiple times,
then the last value or content of that file overrides the previous ones.

To summarize the configuration precedence:

1. Drop-in directory pointed by `--config-dir`.

2. Drop-in directory `/etc/tetragon/tetragon.conf.d/*`.

3. Configuration file `/etc/tetragon/tetragon.yaml`.

4. Drop-in directories:

   - `/usr/local/lib/tetragon/tetragon.conf.d/*`
   - `/usr/lib/tetragon/tetragon.conf.d/*`

{{< note >}}
To clear a controlling setting that was set before, set it again to an empty
value.

Package managers can customize the configuration by installing drop-ins under
`/usr/`. Configurations in `/etc/tetragon/` are strictly reserved for the local
administrator, who may use this logic to override package managers or the
default installed configuration.
{{< /note >}}

## Configuration examples

The [examples/configuration/tetragon.yaml](https://github.com/cilium/tetragon/blob/main/examples/configuration/tetragon.yaml)
file contains example entries showing the defaults as a guide to the
administrator. Local overrides can be created by editing and copying this file
into `/etc/tetragon/tetragon.yaml`, or by editing and copying "drop-ins" from
the [examples/configuration/tetragon.conf.d](https://github.com/cilium/tetragon/tree/main/examples/configuration/tetragon.conf.d)
directory into the `/etc/tetragon/tetragon.conf.d/` subdirectory. The latter is
generally recommended.

Each filename maps to a one controlling setting and the content of the file to
its corresponding value. This is the recommended way.

Changing configuration example:

* `/etc/tetragon/tetragon.conf.d/bpf-lib` with a corresponding value of:

   ```
   /var/lib/tetragon/
   ```

* `/etc/tetragon/tetragon.conf.d/log-format` with a corresponding value of:

   ```
   text
   ```

* `/etc/tetragon/tetragon.conf.d/export-filename` with a corresponding value of:

   ```
   /var/log/tetragon/tetragon.log
   ```

{{< note >}}
Defaults controlling settings can be restored by simply deleting `/etc/tetragon/tetragon.yaml`
and all drop-ins under `/etc/tetragon/tetragon.conf.d/`
{{< /note >}}

## Restrict gRPC API access

The gRPC API supports unix sockets, it can be set using one of the following methods:

- Use the `--server-address` flag:

   ```
   --server-address unix:///var/run/tetragon/tetragon.sock
   ```

- Or use the drop-in configuration file `/etc/tetragon/tetragon.conf.d/server-address` containing:

   ```
   unix:///var/run/tetragon/tetragon.sock
   ```

Then to access the gRPC API with `tetra` client, set `--server-address` to point to the corresponding address:

   ```
   sudo tetra --server-address unix:///var/run/tetragon/tetragon.sock getevents
   ```

{{< note >}}
When reading events with the `tetra` client, if `--server-address` is not specified,
it will try to detect if Tetragon daemon is running on the same host and use its
`server-address` configuration.
{{< /note >}}

{{< caution >}}
Ensure that you have enough privileges to open the gRPC unix socket since it is restricted to privileged users only.
{{< /caution >}}

## Configure Tracing Policies location

Tetragon daemon automatically loads [Tracing policies](/docs/concepts/tracing-policy) from the default `/etc/tetragon/tetragon.tp.d/` directory. Tracing policies can be organized in directories such: `/etc/tetragon/tetragon.tp.d/file-access`, `/etc/tetragon/tetragon.tp.d/network-access`, etc.

The `--tracing-policy-dir` controlling setting can be used to change the default directory from where [Tracing policies](/docs/concepts/tracing-policy) are loaded.

The `--tracing-policy` controlling setting can be used to specify the path of one tracing policy to load.
